/*
 * Decompiled with CFR 0.152.
 */
package com.graphql_java_generator.client.request;

import com.graphql_java_generator.client.GraphqlClientUtils;
import com.graphql_java_generator.client.directive.Directive;
import com.graphql_java_generator.client.request.QueryField;
import com.graphql_java_generator.client.request.QueryTokenizer;
import com.graphql_java_generator.exception.GraphQLRequestExecutionException;
import com.graphql_java_generator.exception.GraphQLRequestPreparationException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class Fragment {
    final String name;
    final String typeName;
    QueryField content = null;
    List<Directive> directives = new ArrayList<Directive>();

    public Fragment(QueryTokenizer qt, Map<Class<?>, Map<String, Field>> aliasFields, String packageName, boolean inlineFragment, Class<?> clazz, String schema) throws GraphQLRequestPreparationException {
        if (inlineFragment) {
            this.name = null;
            if (qt.checkNextToken("on")) {
                qt.readNextRealToken("on", "looking for the 'on' token of the fragment definition");
                this.typeName = qt.readNextRealToken(null, "reading fragment name");
            } else {
                this.typeName = null;
            }
        } else {
            this.name = qt.readNextRealToken(null, "reading fragment name");
            qt.readNextRealToken("on", "looking for the 'on' token of the fragment definition");
            this.typeName = qt.readNextRealToken(null, "reading fragment name");
        }
        while (qt.hasMoreTokens()) {
            String token = qt.nextToken();
            if (token.equals("@")) {
                this.directives.add(new Directive(qt, schema));
                continue;
            }
            if (token.equals("{")) break;
            throw new GraphQLRequestPreparationException("Unexpected token '" + token + "' while searching for the starting '{' in fragment '" + this.getName() + "'");
        }
        if (this.typeName != null) {
            try {
                clazz = GraphqlClientUtils.graphqlClientUtils.getClass(packageName, this.typeName, schema);
            }
            catch (RuntimeException e) {
                throw new GraphQLRequestPreparationException(e.getMessage(), (Throwable)e);
            }
        }
        this.content = new QueryField(clazz);
        this.content.readTokenizerForResponseDefinition(qt, aliasFields, schema);
    }

    public String getName() {
        return this.name;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void appendToGraphQLRequests(StringBuilder sb, Map<String, Object> params) throws GraphQLRequestExecutionException {
        if (this.name != null) {
            sb.append("fragment ");
            sb.append(this.name);
        }
        if (this.typeName != null) {
            sb.append(" on ");
            sb.append(this.typeName);
        }
        for (Directive d : this.directives) {
            d.appendToGraphQLRequests(sb, params);
        }
        this.content.appendToGraphQLRequests(sb, params, false);
    }

    public void addTypenameFields() throws GraphQLRequestPreparationException {
        this.content.addTypenameFields();
    }
}

