/*
 * Decompiled with CFR 0.152.
 */
package com.graphql_java_generator.client.directive;

import com.graphql_java_generator.client.directive.DirectiveLocation;
import com.graphql_java_generator.client.directive.DirectiveRegistryImpl;
import com.graphql_java_generator.client.request.InputParameter;
import com.graphql_java_generator.client.request.QueryTokenizer;
import com.graphql_java_generator.exception.GraphQLRequestExecutionException;
import com.graphql_java_generator.exception.GraphQLRequestPreparationException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class Directive {
    private String name;
    private String packageName;
    private List<InputParameter> arguments = new ArrayList<InputParameter>();
    private List<DirectiveLocation> directiveLocations = new ArrayList<DirectiveLocation>();

    public Directive(QueryTokenizer qt) throws GraphQLRequestPreparationException {
        this.name = qt.nextToken();
        if (qt.checkNextToken("(")) {
            qt.nextToken();
            this.arguments = InputParameter.readTokenizerForInputParameters(qt, this, null, null);
        }
    }

    public void appendToGraphQLRequests(StringBuilder sb, Map<String, Object> parameters) throws GraphQLRequestExecutionException {
        sb.append(" ").append("@").append(this.name);
        InputParameter.appendInputParametersToGraphQLRequests(sb, this.arguments, parameters);
    }

    public Directive() {
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<InputParameter> getArguments() {
        return this.arguments;
    }

    public void setArguments(List<InputParameter> arguments) {
        this.arguments = arguments;
    }

    public List<DirectiveLocation> getDirectiveLocations() {
        return this.directiveLocations;
    }

    public void setDirectiveLocations(List<DirectiveLocation> directiveLocations) {
        this.directiveLocations = directiveLocations;
    }

    public Directive getDirectiveDefinition() throws GraphQLRequestPreparationException {
        Directive directiveDefinition = DirectiveRegistryImpl.directiveRegistry.getDirective(this.getName());
        if (directiveDefinition == null) {
            throw new GraphQLRequestPreparationException("Could not find the definition for the directive '" + this.getName() + "'");
        }
        return directiveDefinition;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }
}

