/*
 * Decompiled with CFR 0.152.
 */
package com.graphql_java_generator;

import com.graphql_java_generator.annotation.GraphQLNonScalar;
import com.graphql_java_generator.annotation.GraphQLScalar;
import com.graphql_java_generator.exception.GraphQLRequestPreparationException;
import graphql.language.ArrayValue;
import graphql.language.BooleanValue;
import graphql.language.EnumValue;
import graphql.language.FloatValue;
import graphql.language.IntValue;
import graphql.language.NullValue;
import graphql.language.ObjectField;
import graphql.language.ObjectValue;
import graphql.language.StringValue;
import graphql.language.Value;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.springframework.stereotype.Component;

@Component
public class GraphqlUtils {
    public static GraphqlUtils graphqlUtils = new GraphqlUtils();
    Pattern graphqlNamePattern = Pattern.compile("^[_A-Za-z][_0-9A-Za-z]*$");
    List<Class<?>> scalars = new ArrayList();
    private List<String> javaKeywords = new ArrayList<String>();
    public static Character JAVA_KEYWORD_PREFIX = Character.valueOf('_');

    public GraphqlUtils() {
        this.scalars.add(String.class);
        this.scalars.add(Integer.TYPE);
        this.scalars.add(Integer.class);
        this.scalars.add(Float.TYPE);
        this.scalars.add(Float.class);
        this.scalars.add(Boolean.TYPE);
        this.scalars.add(Boolean.class);
        this.javaKeywords.add("abstract");
        this.javaKeywords.add("assert");
        this.javaKeywords.add("boolean");
        this.javaKeywords.add("break");
        this.javaKeywords.add("byte");
        this.javaKeywords.add("case");
        this.javaKeywords.add("catch");
        this.javaKeywords.add("char");
        this.javaKeywords.add("class");
        this.javaKeywords.add("const");
        this.javaKeywords.add("continue");
        this.javaKeywords.add("default");
        this.javaKeywords.add("do");
        this.javaKeywords.add("double");
        this.javaKeywords.add("else");
        this.javaKeywords.add("enum");
        this.javaKeywords.add("extends");
        this.javaKeywords.add("final");
        this.javaKeywords.add("finally");
        this.javaKeywords.add("float");
        this.javaKeywords.add("for");
        this.javaKeywords.add("goto");
        this.javaKeywords.add("if");
        this.javaKeywords.add("implements");
        this.javaKeywords.add("import");
        this.javaKeywords.add("instanceof");
        this.javaKeywords.add("int");
        this.javaKeywords.add("interface");
        this.javaKeywords.add("long");
        this.javaKeywords.add("native");
        this.javaKeywords.add("new");
        this.javaKeywords.add("package");
        this.javaKeywords.add("private");
        this.javaKeywords.add("protected");
        this.javaKeywords.add("public");
        this.javaKeywords.add("return");
        this.javaKeywords.add("short");
        this.javaKeywords.add("static");
        this.javaKeywords.add("strictfp");
        this.javaKeywords.add("super");
        this.javaKeywords.add("switch");
        this.javaKeywords.add("synchronized");
        this.javaKeywords.add("this");
        this.javaKeywords.add("throw");
        this.javaKeywords.add("throws");
        this.javaKeywords.add("transient");
        this.javaKeywords.add("try");
        this.javaKeywords.add("void");
        this.javaKeywords.add("volatile");
        this.javaKeywords.add("while");
    }

    public String getCamelCase(String name) {
        return name.substring(0, 1).toLowerCase() + name.substring(1);
    }

    public String getPascalCase(String name) {
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    public <I> List<I> iterableToList(Iterable<I> iterable) {
        ArrayList<I> ret = new ArrayList<I>();
        for (I i : iterable) {
            ret.add(i);
        }
        return ret;
    }

    public <I> List<I> iterableConcreteClassToListInterface(Iterable<? extends I> iterable) {
        ArrayList<I> ret = new ArrayList<I>();
        for (I i : iterable) {
            ret.add(i);
        }
        return ret;
    }

    public <T> T optionalToObject(Optional<T> optional) {
        return optional.isPresent() ? (T)optional.get() : null;
    }

    public Class<?> getFieldType(Class<?> owningClass, String fieldName, boolean returnIsMandatory) throws GraphQLRequestPreparationException {
        if (owningClass.isInterface()) {
            try {
                Method method = owningClass.getDeclaredMethod("get" + graphqlUtils.getPascalCase(fieldName), new Class[0]);
                GraphQLNonScalar graphQLNonScalar = method.getAnnotation(GraphQLNonScalar.class);
                GraphQLScalar graphQLScalar = method.getAnnotation(GraphQLScalar.class);
                if (graphQLNonScalar != null) {
                    return graphQLNonScalar.javaClass();
                }
                if (graphQLScalar != null) {
                    return graphQLScalar.javaClass();
                }
                throw new GraphQLRequestPreparationException("Error while looking for the getter for the field '" + fieldName + "' in the interface '" + owningClass.getName() + "': this method should have one of these annotations: GraphQLNonScalar or GraphQLScalar ");
            }
            catch (NoSuchMethodException e) {
                if (!returnIsMandatory) {
                    return null;
                }
                throw new GraphQLRequestPreparationException("Error while looking for the getter for the field '" + fieldName + "' in the class '" + owningClass.getName() + "'", e);
            }
            catch (SecurityException e) {
                throw new GraphQLRequestPreparationException("Error while looking for the getter for the field '" + fieldName + "' in the class '" + owningClass.getName() + "'", e);
            }
        }
        try {
            Field field = owningClass.getDeclaredField(graphqlUtils.getJavaName(fieldName));
            GraphQLNonScalar graphQLNonScalar = field.getAnnotation(GraphQLNonScalar.class);
            GraphQLScalar graphQLScalar = field.getAnnotation(GraphQLScalar.class);
            if (graphQLNonScalar != null) {
                return graphQLNonScalar.javaClass();
            }
            if (graphQLScalar != null) {
                return graphQLScalar.javaClass();
            }
            throw new GraphQLRequestPreparationException("Error while looking for the the field <" + fieldName + "> in the class '" + owningClass.getName() + "': this field should have one of these annotations: GraphQLNonScalar or GraphQLScalar ");
        }
        catch (NoSuchFieldException e) {
            if (!returnIsMandatory) {
                return null;
            }
            throw new GraphQLRequestPreparationException("Error while looking for the the field <" + fieldName + "> in the class '" + owningClass.getName() + "'", e);
        }
        catch (SecurityException e) {
            throw new GraphQLRequestPreparationException("Error while looking for the the field <" + fieldName + "> in the class '" + owningClass.getName() + "'", e);
        }
    }

    public <T> T getInputObject(Map<String, Object> map, Class<T> clazz) {
        T t;
        if (map == null) {
            return null;
        }
        try {
            t = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException("Error while creating a new instance of  '" + clazz.getName() + " class", e);
        }
        for (String key : map.keySet()) {
            Field field;
            try {
                field = clazz.getDeclaredField(key);
            }
            catch (NoSuchFieldException | SecurityException e) {
                throw new RuntimeException("Error while reading '" + key + "' field for the " + clazz.getName() + " class", e);
            }
            Method setter = this.getSetter(clazz, field);
            GraphQLScalar graphQLScalar = field.getAnnotation(GraphQLScalar.class);
            GraphQLNonScalar graphQLNonScalar = field.getAnnotation(GraphQLNonScalar.class);
            if (graphQLScalar != null) {
                if (graphQLScalar.javaClass() == UUID.class) {
                    this.invokeMethod(setter, t, UUID.fromString((String)map.get(key)));
                    continue;
                }
                this.invokeMethod(setter, t, map.get(key));
                continue;
            }
            if (graphQLNonScalar != null) {
                if (!(map.get(key) instanceof Map)) {
                    throw new RuntimeException("The value for the field '" + clazz.getName() + "." + key + " should be a map");
                }
                Map subMap = (Map)map.get(key);
                this.invokeMethod(setter, t, this.getInputObject(subMap, graphQLNonScalar.javaClass()));
                continue;
            }
            throw new RuntimeException("Internal error: the field '" + clazz.getName() + "." + key + "' should have one of these annotations: GraphQLScalar or GraphQLScalar");
        }
        return t;
    }

    public <T> List<T> getListInputObjects(List<Map<String, Object>> list, Class<T> clazz) {
        ArrayList<T> ret = new ArrayList<T>(list.size());
        for (Map<String, Object> map : list) {
            ret.add(this.getInputObject(map, clazz));
        }
        return ret;
    }

    public Field getDeclaredField(Class<?> owningClass, String fieldName, boolean mustFindField) throws GraphQLRequestPreparationException {
        try {
            return owningClass.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException | SecurityException e1) {
            block6: {
                if (owningClass.getSimpleName().endsWith("Response")) {
                    try {
                        return owningClass.getSuperclass().getDeclaredField(fieldName);
                    }
                    catch (NoSuchFieldException | SecurityException e2) {
                        if (!mustFindField) break block6;
                        throw new GraphQLRequestPreparationException("Could not find fied '" + fieldName + "' in " + owningClass.getName() + ", nor in " + owningClass.getSuperclass().getName(), e1);
                    }
                }
            }
            if (mustFindField) {
                throw new GraphQLRequestPreparationException("Could not find fied '" + fieldName + "' in " + owningClass.getName(), e1);
            }
            return null;
        }
    }

    public <T> Method getSetter(Class<T> clazz, Field field) {
        String setterMethodName = "set" + this.getPascalCase(field.getName());
        try {
            return clazz.getDeclaredMethod(setterMethodName, field.getType());
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("The setter '" + setterMethodName + "' is missing in " + clazz.getName() + " class", e);
        }
        catch (SecurityException e) {
            throw new RuntimeException("Error while accessing to the setter '" + setterMethodName + "' in " + clazz.getName() + " class", e);
        }
    }

    public Method getGetter(Class<?> clazz, Field field) {
        String getterMethodName = "get" + this.getPascalCase(field.getName());
        try {
            Method method = null;
            try {
                method = clazz.getMethod(getterMethodName, new Class[0]);
            }
            catch (NoSuchMethodException e) {
                if (field.getType().equals(Boolean.TYPE) || field.getType().equals(Boolean.class)) {
                    getterMethodName = "is" + this.getPascalCase(field.getName());
                    method = clazz.getMethod(getterMethodName, new Class[0]);
                }
                throw e;
            }
            if (field.getType() != method.getReturnType()) {
                throw new RuntimeException("The getter '" + getterMethodName + "' and the field '" + field.getName() + "' of the class " + clazz.getName() + " should be of the same type");
            }
            return method;
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("The getter '" + getterMethodName + "' is missing in " + clazz.getName() + " class", e);
        }
        catch (SecurityException e) {
            throw new RuntimeException("Error while accessing to the getter '" + getterMethodName + "' in " + clazz.getName() + " class", e);
        }
    }

    public Object invokeGetter(Object object, String fieldName) {
        try {
            Field field = this.getField(object, fieldName);
            Method getter = this.getGetter(object.getClass(), field);
            return getter.invoke(object, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException("Error while invoking to the getter for the field '" + fieldName + "' in the class " + object.getClass().getName() + " class", e);
        }
    }

    private Field getField(Object object, String fieldName) {
        Class<?> clazz = object.getClass();
        while (!clazz.equals(Object.class)) {
            try {
                return clazz.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                clazz = clazz.getSuperclass();
            }
        }
        throw new RuntimeException("Could not find the field " + fieldName + " in either " + object.getClass().getName() + " or in one of its superclass");
    }

    public void invokeSetter(Object object, Field field, Object value) {
        try {
            Method setter = this.getSetter(object.getClass(), field);
            setter.invoke(object, value);
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException("Error while invoking to the setter for the field '" + field.getName() + "' in the class " + object.getClass().getName() + " class", e);
        }
    }

    public void invokeSetter(Object object, String fieldName, Object value) {
        try {
            Field field = object.getClass().getDeclaredField(fieldName);
            this.invokeSetter(object, field, value);
        }
        catch (IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            throw new RuntimeException("Error while invoking to the setter for the field '" + fieldName + "' in the class " + object.getClass().getName() + " class", e);
        }
    }

    public Method getMethod(String methodName, Class<?> clazz, Class<?> ... parameterTypes) {
        try {
            return clazz.getDeclaredMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Could not get the method '" + methodName + "' in the " + clazz.getName() + " class", e);
        }
    }

    public Object invokeMethod(String methodName, Object object) {
        try {
            Method getType = object.getClass().getDeclaredMethod(methodName, new Class[0]);
            return getType.invoke(object, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException("Error when trying to execute '" + methodName + "' on '" + object.getClass().getName() + "': " + e.getMessage(), e);
        }
    }

    public Object invokeMethod(Method method, Object o, Object ... args) {
        try {
            return method.invoke(o, args);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new RuntimeException("Error when executing the method '" + method.getName() + "' is missing in " + o.getClass().getName() + " class", e);
        }
    }

    public String getJavaName(String name) {
        return this.isJavaReservedWords(name) ? JAVA_KEYWORD_PREFIX + name : name;
    }

    public boolean isJavaReservedWords(String name) {
        return this.javaKeywords.contains(name);
    }

    public String getClassSimpleName(String classFullName) {
        int lstPointPosition = classFullName.lastIndexOf(46);
        return classFullName.substring(lstPointPosition + 1);
    }

    public String getPackageName(String classFullName) {
        int lstPointPosition = classFullName.lastIndexOf(46);
        return classFullName.substring(0, lstPointPosition);
    }

    @SafeVarargs
    public final <T> Stream<T> concatStreams(Class<T> clazz, boolean parallelStreams, T t1, T t2, T t3, List<? extends T> ... lists) {
        Stream.Builder<T> builder = Stream.builder();
        if (t1 != null) {
            builder.accept(t1);
        }
        if (t2 != null) {
            builder.accept(t2);
        }
        if (t3 != null) {
            builder.accept(t3);
        }
        Stream ret = builder.build();
        for (List<T> list : lists) {
            ret = Stream.concat(ret, list.stream());
        }
        return parallelStreams ? (Stream)ret.parallel() : ret;
    }

    Object getValue(Value<?> value, String graphqlTypeName, String action) {
        if (value instanceof StringValue) {
            return ((StringValue)value).getValue();
        }
        if (value instanceof BooleanValue) {
            return ((BooleanValue)value).isValue();
        }
        if (value instanceof IntValue) {
            return ((IntValue)value).getValue();
        }
        if (value instanceof FloatValue) {
            return ((FloatValue)value).getValue();
        }
        if (value instanceof EnumValue) {
            return ((EnumValue)value).getName();
        }
        if (value instanceof NullValue) {
            return null;
        }
        if (value instanceof ArrayValue) {
            List list = ((ArrayValue)value).getValues();
            Object[] ret = new Object[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                ret[i] = this.getValue((Value)list.get(i), graphqlTypeName, action + ": ArrayValue(" + i + ")");
            }
            return ret;
        }
        throw new RuntimeException("Value of type " + value.getClass().getName() + " is not managed (" + action + ")");
    }

    public String getValueAsText(Value<?> value) {
        if (value == null || value instanceof NullValue) {
            return "null";
        }
        if (value instanceof StringValue) {
            return "\"" + ((StringValue)value).getValue() + "\"";
        }
        if (value instanceof BooleanValue) {
            return ((BooleanValue)value).isValue() ? "true" : "false";
        }
        if (value instanceof IntValue) {
            return ((IntValue)value).getValue().toString();
        }
        if (value instanceof FloatValue) {
            return ((FloatValue)value).getValue().toString();
        }
        if (value instanceof EnumValue) {
            return ((EnumValue)value).getName();
        }
        if (value instanceof ObjectValue) {
            StringBuilder sb = new StringBuilder();
            sb.append("{");
            boolean appendSep = false;
            for (ObjectField v : ((ObjectValue)value).getObjectFields()) {
                if (appendSep) {
                    sb.append(",");
                } else {
                    appendSep = true;
                }
                sb.append(v.getName()).append(":").append(this.getValueAsText(v.getValue()));
            }
            sb.append("}");
            return sb.toString();
        }
        if (value instanceof ArrayValue) {
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            boolean appendSep = false;
            for (Value v : ((ArrayValue)value).getValues()) {
                if (appendSep) {
                    sb.append(",");
                } else {
                    appendSep = true;
                }
                sb.append(this.getValueAsText(v));
            }
            sb.append("]");
            return sb.toString();
        }
        throw new RuntimeException("Value of type " + value.getClass().getName() + " is not managed");
    }
}

