/*
 * Decompiled with CFR 0.152.
 */
package graphql.annotations;

import graphql.ExecutionResult;
import graphql.execution.ExecutionContext;
import graphql.execution.ExecutionParameters;
import graphql.execution.SimpleExecutionStrategy;
import graphql.execution.TypeInfo;
import graphql.execution.TypeInfoWorkaround;
import graphql.language.Argument;
import graphql.language.Field;
import graphql.language.ObjectValue;
import graphql.language.StringValue;
import graphql.language.VariableReference;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLType;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;

public class EnhancedExecutionStrategy
extends SimpleExecutionStrategy {
    private static final String CLIENT_MUTATION_ID = "clientMutationId";

    @Override
    protected ExecutionResult resolveField(ExecutionContext executionContext, ExecutionParameters parameters, List<Field> fields) {
        GraphQLObjectType parentType = (GraphQLObjectType)parameters.typeInfo().type();
        GraphQLFieldDefinition fieldDef = this.getFieldDef(executionContext.getGraphQLSchema(), parentType, fields.get(0));
        if (fieldDef == null) {
            return null;
        }
        if (fieldDef.getName().contentEquals(CLIENT_MUTATION_ID)) {
            Object clientMutationId;
            Field field = (Field)executionContext.getOperationDefinition().getSelectionSet().getSelections().get(0);
            Argument argument = (Argument)field.getArguments().get(0);
            if (argument.getValue() instanceof VariableReference) {
                VariableReference ref = (VariableReference)argument.getValue();
                HashMap mutationInputVariables = (HashMap)executionContext.getVariables().get(ref.getName());
                clientMutationId = mutationInputVariables.get(CLIENT_MUTATION_ID);
            } else {
                ObjectValue value = (ObjectValue)((Argument)field.getArguments().get(0)).getValue();
                StringValue clientMutationIdVal = (StringValue)value.getObjectFields().stream().filter(f -> f.getName().contentEquals(CLIENT_MUTATION_ID)).findFirst().get().getValue();
                clientMutationId = clientMutationIdVal.getValue();
            }
            TypeInfo fieldTypeInfo = TypeInfoWorkaround.newTypeInfo((GraphQLType)fieldDef.getType(), parameters.typeInfo());
            ExecutionParameters newParameters = ExecutionParameters.newParameters().arguments(parameters.arguments()).fields(parameters.fields()).typeInfo(fieldTypeInfo).source(clientMutationId).build();
            return this.completeValue(executionContext, newParameters, fields);
        }
        return super.resolveField(executionContext, parameters, fields);
    }

    @Override
    protected ExecutionResult completeValue(ExecutionContext executionContext, ExecutionParameters parameters, List<Field> fields) {
        GraphQLType fieldType = parameters.typeInfo().type();
        Object result = parameters.source();
        if (result instanceof Enum && fieldType instanceof GraphQLEnumType) {
            Object value = ((GraphQLEnumType)fieldType).getCoercing().parseValue((Object)((Enum)result).name());
            return super.completeValue(executionContext, this.withSource(parameters, value), fields);
        }
        if (result instanceof Optional) {
            Object value = ((Optional)result).orElse(null);
            return this.completeValue(executionContext, this.withSource(parameters, value), fields);
        }
        return super.completeValue(executionContext, parameters, fields);
    }

    private ExecutionParameters withSource(ExecutionParameters parameters, Object source) {
        return ExecutionParameters.newParameters().arguments(parameters.arguments()).fields(parameters.fields()).typeInfo(parameters.typeInfo()).source(source).build();
    }
}

