/*
 * Decompiled with CFR 0.152.
 */
package com.hellosign.sdk.http;

import com.hellosign.sdk.HelloSignException;
import com.hellosign.sdk.http.Authentication;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Properties;
import java.util.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHttpRequest {
    public static final String DEFAULT_ENCODING = "UTF-8";
    public static final String USER_AGENT = AbstractHttpRequest.createUserAgent();
    private static final Logger logger = LoggerFactory.getLogger(AbstractHttpRequest.class);
    protected String url;
    protected Authentication auth;
    protected Integer lastHttpStatusCode;
    protected InputStream lastResponseStream;

    private static String createUserAgent() {
        String filename = "config.properties";
        Properties props = new Properties();
        InputStream is = AbstractHttpRequest.class.getClassLoader().getResourceAsStream(filename);
        if (is != null) {
            try {
                props.load(is);
            }
            catch (IOException e) {
                throw new Error(e);
            }
        } else {
            throw new Error(new FileNotFoundException("Could not find " + filename));
        }
        String version = props.getProperty("sdk.version");
        if (version == null) {
            version = "x.x.x";
        }
        return "hellosign-java-sdk/" + version;
    }

    protected static HttpURLConnection getProxiedConnection(String url) throws MalformedURLException, IOException {
        Proxy proxy = null;
        String proxyUrlStr = System.getProperty("hellosign.proxy.url");
        String proxyPortStr = System.getProperty("hellosign.proxy.port");
        int proxyPort = 80;
        if (proxyPortStr != null) {
            proxyPort = Integer.parseInt(proxyPortStr);
        }
        if (proxyUrlStr != null) {
            proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyUrlStr, proxyPort));
        }
        HttpURLConnection conn = proxy == null ? (HttpURLConnection)new URL(url).openConnection() : (HttpURLConnection)new URL(url).openConnection(proxy);
        return conn;
    }

    public void execute() throws HelloSignException {
        HttpURLConnection connection = this.getConnection();
        try {
            this.lastHttpStatusCode = connection.getResponseCode();
            if (this.lastHttpStatusCode >= 200 && this.lastHttpStatusCode < 300) {
                logger.debug("OK!");
                this.lastResponseStream = connection.getInputStream();
            } else {
                logger.error("Error! HTTP Code = " + this.lastHttpStatusCode);
                this.lastResponseStream = connection.getErrorStream();
            }
        }
        catch (Exception ex) {
            throw new HelloSignException(ex);
        }
    }

    public Integer getResponseCode() {
        return this.lastHttpStatusCode;
    }

    public String getResponseBody() {
        String responseStr = "";
        if (this.lastResponseStream == null) {
            logger.error("Unable to parse JSON from empty response!");
        } else {
            Scanner s = new Scanner(this.lastResponseStream);
            s.useDelimiter("\\A");
            responseStr = s.hasNext() ? s.next() : "";
            s.close();
        }
        return responseStr;
    }

    protected abstract HttpURLConnection getConnection() throws HelloSignException;

    public long getResponseAsFile(File f) throws HelloSignException {
        long bytesWritten;
        try {
            bytesWritten = Files.copy(this.lastResponseStream, f.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Exception e) {
            throw new HelloSignException(e);
        }
        return bytesWritten;
    }
}

