/*
 * Decompiled with CFR 0.152.
 */
package com.hellosign.sdk.http;

import com.hellosign.sdk.HelloSignException;
import java.net.HttpURLConnection;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Authentication {
    private static final Logger logger = LoggerFactory.getLogger(Authentication.class);
    private static final String[] allowedOauthOps = new String[]{"account", "signature_request", "reusable_form", "template"};
    private String apiKey = "";
    private String accessToken = "";
    private String accessTokenType = "";

    public Authentication() {
    }

    public Authentication(String apiKey) {
        this.apiKey = apiKey;
    }

    public Authentication(Authentication clone) throws HelloSignException {
        if (clone.hasApiKey()) {
            this.setApiKey(clone.getApiKey());
        }
        if (clone.hasAccessToken()) {
            this.setAccessToken(clone.getAccessToken(), clone.getAccessTokenType());
        }
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        if (apiKey == null) {
            return;
        }
        this.apiKey = apiKey;
    }

    public boolean hasApiKey() {
        return !"".equals(this.apiKey);
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getAccessTokenType() {
        return this.accessTokenType;
    }

    public void setAccessToken(String accessToken, String tokenType) throws HelloSignException {
        if (accessToken == null) {
            throw new HelloSignException("Access Token cannot be null");
        }
        if (tokenType == null) {
            throw new HelloSignException("Token Type cannot be null");
        }
        this.accessToken = accessToken;
        this.accessTokenType = tokenType;
    }

    public boolean hasAccessToken() {
        return !"".equals(this.accessToken) && !"".equals(this.accessTokenType);
    }

    private boolean isOperationOauth(String url) {
        for (String op : allowedOauthOps) {
            if (!url.contains(op)) continue;
            return true;
        }
        return false;
    }

    public void authenticate(HttpURLConnection httpConn, String url) {
        String authorization = null;
        if (this.hasAccessToken() && this.isOperationOauth(url)) {
            logger.debug("Using OAuth token to authenticate");
            authorization = this.getAccessTokenType() + " " + this.getAccessToken();
        } else if (this.hasApiKey()) {
            logger.debug("Using API Key to authenticate");
            String apiKey = this.getApiKey() + ":";
            authorization = "Basic " + Base64.encodeBase64String((byte[])apiKey.getBytes()).trim();
        }
        if (authorization != null) {
            logger.debug("Authorization: " + authorization);
            httpConn.setRequestProperty("authorization", authorization);
        }
    }
}

