/*
 * Decompiled with CFR 0.152.
 */
package com.hellosign.sdk.http;

import com.hellosign.sdk.HelloSignException;
import com.hellosign.sdk.http.AbstractHttpRequest;
import com.hellosign.sdk.http.Authentication;
import com.hellosign.sdk.http.HttpDeleteRequest;
import com.hellosign.sdk.http.HttpGetRequest;
import com.hellosign.sdk.http.HttpOptionsRequest;
import com.hellosign.sdk.http.HttpPostRequest;
import com.hellosign.sdk.http.HttpPutRequest;
import java.io.File;
import java.io.Serializable;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClient {
    private static final Logger logger = LoggerFactory.getLogger(HttpClient.class);
    private Authentication auth;
    private Map<String, String> getParams;
    private Map<String, Serializable> postFields;
    private AbstractHttpRequest request;

    public HttpClient() {
        String disableSslCheck = System.getProperty("hellosign.disable.ssl");
        if ("true".equalsIgnoreCase(disableSslCheck)) {
            this.disableStrictSSL();
        }
    }

    public HttpClient withAuth(Authentication auth) {
        this.auth = auth;
        return this;
    }

    public HttpClient withGetParam(String key, String value) {
        if (this.getParams == null) {
            this.getParams = new HashMap<String, String>();
        }
        this.getParams.put(key, value);
        return this;
    }

    public HttpClient withGetParams(Map<String, String> params) {
        this.getParams = params;
        return this;
    }

    public HttpClient withPostField(String key, Serializable value) {
        if (this.postFields == null) {
            this.postFields = new HashMap<String, Serializable>();
        }
        this.postFields.put(key, value);
        return this;
    }

    public HttpClient withPostFields(Map<String, Serializable> fields) {
        this.postFields = fields;
        return this;
    }

    public String getLastResponse() {
        if (this.request == null) {
            return null;
        }
        return this.request.getResponseBody();
    }

    public Integer getLastResponseCode() {
        if (this.request == null) {
            return null;
        }
        return this.request.getResponseCode();
    }

    public long getLastResponseAsFile(File f) throws HelloSignException {
        return this.request.getResponseAsFile(f);
    }

    private void validate(JSONObject json) throws HelloSignException {
        if (json.has("error")) {
            try {
                JSONObject error = json.getJSONObject("error");
                String message = error.getString("error_msg");
                String type = error.getString("error_name");
                throw new HelloSignException(message, this.getLastResponseCode(), type);
            }
            catch (JSONException ex) {
                throw new HelloSignException((Exception)((Object)ex));
            }
        }
    }

    private void reset() {
        this.auth = null;
        this.getParams = null;
        this.postFields = null;
        this.request = null;
    }

    public JSONObject asJson() throws HelloSignException {
        JSONObject json;
        String response = this.getLastResponse();
        logger.debug("Response body: " + response);
        try {
            json = new JSONObject(response);
            this.validate(json);
        }
        catch (HelloSignException e) {
            throw e;
        }
        catch (JSONException e) {
            throw new HelloSignException((Exception)((Object)e));
        }
        finally {
            this.reset();
        }
        return json;
    }

    public File asFile(String fileName) throws HelloSignException {
        File f;
        Integer lastResponseCode = this.getLastResponseCode();
        try {
            if (lastResponseCode != null && lastResponseCode != 200) {
                this.asJson();
            }
            if (this.getLastResponseAsFile(f = this.createTemporaryFile(fileName)) == 0L) {
                logger.warn("No bytes written to file: " + fileName);
            }
        }
        catch (HelloSignException ex) {
            throw ex;
        }
        finally {
            this.reset();
        }
        return f;
    }

    private File createTemporaryFile(String filename) throws HelloSignException {
        File f;
        String prefix = filename.substring(0, filename.indexOf("."));
        String postfix = filename.substring(filename.indexOf(".") + 1);
        if (StringUtils.isBlank((CharSequence)prefix) || StringUtils.isBlank((CharSequence)postfix)) {
            throw new HelloSignException("Invalid file name: " + prefix + "." + postfix);
        }
        try {
            f = File.createTempFile(prefix, "." + postfix);
        }
        catch (Exception ex) {
            throw new HelloSignException(ex);
        }
        return f;
    }

    public int asHttpCode() throws HelloSignException {
        Integer code = this.getLastResponseCode();
        if (code == null) {
            throw new HelloSignException("No request performed");
        }
        if (code >= 200 && code < 300) {
            this.reset();
            return code;
        }
        throw new HelloSignException("HTTP Code " + code, code);
    }

    public HttpClient get(String url) throws HelloSignException {
        if (this.postFields != null) {
            logger.warn("POST fields set for a GET request, they will be ignored");
        }
        this.request = new HttpGetRequest(url, this.getParams, this.auth);
        this.request.execute();
        return this;
    }

    public HttpClient post(String url) throws HelloSignException {
        if (this.getParams != null) {
            logger.warn("GET parameters set for a POST request, they will be ignored");
        }
        this.request = new HttpPostRequest(url, this.postFields, this.auth);
        this.request.execute();
        return this;
    }

    public HttpClient delete(String url) throws HelloSignException {
        this.request = new HttpDeleteRequest(url, this.auth);
        this.request.execute();
        return this;
    }

    public HttpClient put(String url) throws HelloSignException {
        this.request = new HttpPutRequest(url, this.postFields, this.auth);
        this.request.execute();
        return this;
    }

    public HttpClient options(String url) throws HelloSignException {
        this.request = new HttpOptionsRequest(url);
        this.request.execute();
        return this;
    }

    private void disableStrictSSL() {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        HostnameVerifier hv = (hostname, session) -> true;
        try {
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            HttpsURLConnection.setDefaultHostnameVerifier(hv);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

