/*
 * Decompiled with CFR 0.152.
 */
package com.hellosign.sdk.http;

import com.hellosign.sdk.HelloSignException;
import com.hellosign.sdk.http.AbstractHttpRequest;
import com.hellosign.sdk.http.Authentication;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpGetRequest
extends AbstractHttpRequest {
    private static final Logger logger = LoggerFactory.getLogger(HttpGetRequest.class);
    private Map<String, String> parameters = null;

    public HttpGetRequest(String url) throws HelloSignException {
        this(url, null, null);
    }

    public HttpGetRequest(String url, Authentication auth) throws HelloSignException {
        this(url, null, auth);
    }

    public HttpGetRequest(String url, Map<String, String> parameters) throws HelloSignException {
        this(url, parameters, null);
    }

    public HttpGetRequest(String url, Map<String, String> parameters, Authentication auth) throws HelloSignException {
        if (url == null || "".equals(url)) {
            throw new HelloSignException("URL cannot be null or empty");
        }
        this.url = url;
        if (parameters != null) {
            this.parameters = parameters;
        }
        if (auth != null) {
            this.auth = new Authentication(auth);
        }
    }

    @Override
    protected HttpURLConnection getConnection() throws HelloSignException {
        HttpURLConnection connection;
        if (this.parameters != null) {
            this.url = this.url + "?";
            Iterator<String> keys = this.parameters.keySet().iterator();
            while (keys.hasNext()) {
                String key = keys.next();
                try {
                    this.url = this.url + URLEncoder.encode(key, "UTF-8") + "=" + URLEncoder.encode(this.parameters.get(key), "UTF-8");
                }
                catch (UnsupportedEncodingException ex) {
                    throw new HelloSignException(ex);
                }
                if (!keys.hasNext()) continue;
                this.url = this.url + "&";
            }
        }
        logger.debug("GET: " + this.url);
        try {
            connection = HttpGetRequest.getProxiedConnection(this.url);
        }
        catch (Exception e) {
            throw new HelloSignException(e);
        }
        connection.setRequestProperty("Accept-Charset", "UTF-8");
        connection.setRequestProperty("user-agent", USER_AGENT);
        if (this.auth != null) {
            logger.debug("Authenticating...");
            this.auth.authenticate(connection, this.url);
        }
        return connection;
    }
}

