/*
 * Decompiled with CFR 0.152.
 */
package com.hellosign.sdk.http;

import com.hellosign.sdk.HelloSignException;
import com.hellosign.sdk.http.AbstractHttpRequest;
import com.hellosign.sdk.http.Authentication;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpPostRequest
extends AbstractHttpRequest {
    private static final Logger logger = LoggerFactory.getLogger(HttpPostRequest.class);
    private static final String LINE_FEED = "\r\n";
    private final String boundary;
    protected String method = "POST";
    private HttpURLConnection httpConn;
    private OutputStream outputStream;
    private PrintWriter writer;
    private Map<String, Serializable> fields = null;

    public HttpPostRequest(String url) throws HelloSignException {
        this(url, null, null);
    }

    public HttpPostRequest(String url, Authentication auth) throws HelloSignException {
        this(url, null, auth);
    }

    public HttpPostRequest(String url, Map<String, Serializable> fields) throws HelloSignException {
        this(url, fields, null);
    }

    public HttpPostRequest(String url, Map<String, Serializable> fields, Authentication auth) throws HelloSignException {
        if (url == null || "".equals(url)) {
            throw new HelloSignException("URL cannot be null or empty");
        }
        this.url = url;
        if (fields != null) {
            this.fields = fields;
        }
        if (auth != null) {
            this.auth = new Authentication(auth);
        }
        this.boundary = "===" + Long.toHexString(System.currentTimeMillis()) + "===";
    }

    @Override
    protected HttpURLConnection getConnection() throws HelloSignException {
        if (this.fields != null) {
            for (String key : this.fields.keySet()) {
                if (!(this.fields.get(key) instanceof File)) continue;
                return this.postWithFile();
            }
        }
        return this.postQuery();
    }

    private HttpURLConnection postQuery() throws HelloSignException {
        HttpURLConnection connection;
        logger.debug(this.method + ": " + this.url);
        try {
            connection = HttpPostRequest.getProxiedConnection(this.url);
            if (!this.method.equals("POST")) {
                connection.setRequestMethod(this.method);
            }
        }
        catch (Exception e) {
            throw new HelloSignException(e);
        }
        connection.setDoOutput(true);
        connection.setRequestProperty("user-agent", USER_AGENT);
        connection.setRequestProperty("accept-encoding", "UTF-8");
        this.auth.authenticate(connection, this.url);
        StringBuilder sb = new StringBuilder();
        if (this.fields != null) {
            Iterator<String> keys = this.fields.keySet().iterator();
            while (keys.hasNext()) {
                String encodedKey;
                String value;
                String key = keys.next();
                Serializable val = this.fields.get(key);
                if (val == null) {
                    throw new HelloSignException("POST value for key '" + key + "' is null");
                }
                try {
                    value = URLEncoder.encode(val.toString(), "UTF-8");
                    encodedKey = URLEncoder.encode(key, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new HelloSignException(e);
                }
                logger.debug("\t" + key + " = " + val.toString());
                sb.append(encodedKey).append("=").append(value);
                if (!keys.hasNext()) continue;
                sb.append("&");
            }
        }
        try (OutputStream output = connection.getOutputStream();){
            output.write(sb.toString().getBytes("UTF-8"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new HelloSignException(ex.getMessage());
        }
        return connection;
    }

    private HttpURLConnection postWithFile() throws HelloSignException {
        try {
            this.openMultipartPostConnection();
            if (this.fields != null) {
                for (String key : this.fields.keySet()) {
                    Serializable val = this.fields.get(key);
                    if (val instanceof File) {
                        this.addFilePart(key, (File)val);
                        continue;
                    }
                    this.addFormField(key, val.toString());
                }
            }
            return this.finish();
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw new HelloSignException(ex.getMessage());
        }
    }

    private void openMultipartPostConnection() throws IOException {
        this.httpConn = HttpPostRequest.getProxiedConnection(this.url);
        this.httpConn.setUseCaches(false);
        this.httpConn.setDoOutput(true);
        this.httpConn.setDoInput(true);
        this.httpConn.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + this.boundary);
        this.httpConn.setRequestProperty("User-Agent", USER_AGENT);
        if (this.auth != null) {
            this.auth.authenticate(this.httpConn, this.url);
        }
        this.outputStream = this.httpConn.getOutputStream();
        this.writer = new PrintWriter((Writer)new OutputStreamWriter(this.outputStream, "UTF-8"), true);
    }

    private void addFormField(String name, String value) {
        this.write("--" + this.boundary).write(LINE_FEED);
        this.write("Content-Disposition: form-data; name=\"" + name + "\"").write(LINE_FEED);
        this.write("Content-Type: text/plain; charset=UTF-8").write(LINE_FEED);
        this.write(LINE_FEED);
        this.write(value).append(LINE_FEED);
        this.writer.flush();
    }

    private void addFilePart(String fieldName, File uploadFile) throws IOException {
        int bytesRead;
        String fileName = uploadFile.getName();
        this.write("--" + this.boundary).write(LINE_FEED);
        this.write("Content-Disposition: form-data; name=\"" + fieldName + "\"; filename=\"" + fileName + "\"").write(LINE_FEED);
        this.write("Content-Type: " + URLConnection.guessContentTypeFromName(fileName)).write(LINE_FEED);
        this.write("Content-Transfer-Encoding: binary").write(LINE_FEED);
        this.write(LINE_FEED);
        this.writer.flush();
        FileInputStream inputStream = new FileInputStream(uploadFile);
        byte[] buffer = new byte[4096];
        while ((bytesRead = inputStream.read(buffer)) != -1) {
            this.outputStream.write(buffer, 0, bytesRead);
            logger.debug("  " + bytesRead + " bytes written...");
        }
        this.outputStream.flush();
        inputStream.close();
        this.write(LINE_FEED);
        this.writer.flush();
    }

    private HttpURLConnection finish() {
        this.writer.flush();
        this.write("--" + this.boundary + "--").write(LINE_FEED);
        this.writer.close();
        return this.httpConn;
    }

    private PrintWriter write(String str) {
        logger.debug(str);
        return this.writer.append(str);
    }
}

