/*
 * Decompiled with CFR 0.152.
 */
package com.hellosign.sdk.resource;

import com.hellosign.sdk.HelloSignException;
import com.hellosign.sdk.resource.support.Warning;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class AbstractResource {
    protected JSONObject dataObj;
    protected List<Warning> warnings = new ArrayList<Warning>();

    protected AbstractResource() {
        this.dataObj = new JSONObject();
    }

    protected AbstractResource(JSONObject json, String optionalKey) throws HelloSignException {
        try {
            this.dataObj = json;
            if (json.has(optionalKey) && !json.isNull(optionalKey)) {
                Object obj = json.get(optionalKey);
                if (obj instanceof JSONObject) {
                    this.dataObj = (JSONObject)obj;
                } else if (obj instanceof String) {
                    this.dataObj = new JSONObject((String)obj);
                } else {
                    throw new HelloSignException("Cannot convert response to JSONObject: " + obj);
                }
            }
            if (json.has("warnings")) {
                JSONArray ws = json.getJSONArray("warnings");
                for (int i = 0; i < ws.length(); ++i) {
                    this.warnings.add(new Warning(ws.getJSONObject(i)));
                }
            }
        }
        catch (JSONException ex) {
            throw new HelloSignException((Exception)((Object)ex));
        }
    }

    protected static boolean hasString(String s) {
        return s != null && !s.equals("");
    }

    public JSONObject getJSONObject() {
        return this.dataObj;
    }

    protected boolean has(String key) {
        return this.dataObj.has(key) && !this.dataObj.isNull(key);
    }

    protected void set(String key, Object value) {
        try {
            if (value instanceof Date) {
                this.dataObj.put(key, ((Date)value).getTime());
            } else {
                this.dataObj.put(key, value);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    protected String getString(String key) {
        if (this.dataObj.has(key) && !this.dataObj.isNull(key)) {
            try {
                return this.dataObj.get(key).toString();
            }
            catch (JSONException e) {
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }

    protected Boolean getBoolean(String key) {
        if (this.dataObj.has(key) && !this.dataObj.isNull(key)) {
            try {
                return this.dataObj.getBoolean(key);
            }
            catch (JSONException e) {
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }

    protected Integer getInteger(String key) {
        if (this.dataObj.has(key) && !this.dataObj.isNull(key)) {
            try {
                return this.dataObj.getInt(key);
            }
            catch (JSONException e) {
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }

    protected Object get(String key) {
        if (this.dataObj.has(key) && !this.dataObj.isNull(key)) {
            try {
                return this.dataObj.get(key);
            }
            catch (JSONException e) {
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }

    protected Date getDate(String key) {
        if (this.dataObj.has(key) && !this.dataObj.isNull(key)) {
            try {
                return new Date(this.dataObj.getLong(key) * 1000L);
            }
            catch (JSONException e) {
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }

    protected Long getLong(String key) {
        if (this.dataObj.has(key) && !this.dataObj.isNull(key)) {
            try {
                return this.dataObj.getLong(key);
            }
            catch (JSONException e) {
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }

    protected <T> List<T> getList(Class<T> clazz, String key) {
        return this.getList(clazz, key, null, null);
    }

    protected <T> Object getObject(Class<T> Class2, Object obj, String key) {
        Constructor<?> constructor = this.getConstructor(Class2, obj.getClass());
        Object newItem = null;
        try {
            newItem = constructor.newInstance(this.dataObj.get(key));
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return newItem;
    }

    protected <T> List<T> getList(Class<T> clazz, String key, Serializable filterValue, String filterColumnName) {
        ArrayList returnList = new ArrayList();
        if (this.dataObj.has(key)) {
            try {
                JSONArray array = this.dataObj.getJSONArray(key);
                if (array.length() == 0) {
                    return returnList;
                }
                Constructor<?> constructor = this.getConstructor(clazz, array.get(0).getClass());
                if (constructor == null) {
                    return returnList;
                }
                for (int i = 0; i < array.length(); ++i) {
                    Object obj = array.get(i);
                    Object newItem = constructor.newInstance(obj);
                    if (filterColumnName == null && filterValue == null) {
                        returnList.add(newItem);
                        continue;
                    }
                    if (filterColumnName != null && filterValue != null) {
                        Object columnObj;
                        JSONObject testObj;
                        if (!(obj instanceof JSONObject) || !(testObj = (JSONObject)obj).has(filterColumnName) || !filterValue.equals(columnObj = testObj.get(filterColumnName))) continue;
                        returnList.add(newItem);
                        continue;
                    }
                    if (!(filterValue instanceof String) || !(newItem instanceof String) || !filterValue.equals(newItem)) continue;
                    returnList.add(newItem);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return new ArrayList();
            }
        }
        return returnList;
    }

    protected void clearList(String key) throws HelloSignException {
        try {
            this.dataObj.put(key, (Object)new JSONArray());
        }
        catch (JSONException ex) {
            ex.printStackTrace();
            throw new HelloSignException("Cannot clear list " + key);
        }
    }

    protected void addToList(String key, AbstractResource listItem) throws HelloSignException {
        if (!this.dataObj.has(key)) {
            throw new HelloSignException("Invalid key " + key + " for list of type " + listItem.getClass().getName());
        }
        try {
            JSONArray currentList = this.dataObj.getJSONArray(key);
            currentList.put((Object)listItem.getJSONObject());
        }
        catch (JSONException ex) {
            ex.printStackTrace();
            throw new HelloSignException("Cannot add item to list " + key);
        }
    }

    protected Constructor<?> getConstructor(Class<?> clazz, Class<?> paramClass) {
        for (Constructor<?> c : clazz.getConstructors()) {
            Class<?>[] paramTypes = c.getParameterTypes();
            if (paramTypes.length != 1 || !paramTypes[0].equals(paramClass)) continue;
            return c;
        }
        return null;
    }

    protected <T> void add(String key, T item) {
        try {
            JSONArray array;
            if (this.dataObj.has(key)) {
                array = this.dataObj.getJSONArray(key);
            } else {
                array = new JSONArray();
                this.dataObj.put(key, (Object)array);
            }
            if (item instanceof String) {
                array.put(item);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public String toString() {
        return this.toString(2);
    }

    public String toString(int spacesToIndent) {
        String retStr = null;
        try {
            retStr = spacesToIndent > 0 ? this.dataObj.toString(spacesToIndent) : this.dataObj.toString();
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return retStr;
    }

    public List<Warning> getWarnings() {
        return this.warnings;
    }
}

