/*
 * Decompiled with CFR 0.152.
 */
package com.hellosign.sdk.resource;

import com.hellosign.sdk.HelloSignException;
import com.hellosign.sdk.resource.AbstractRequest;
import com.hellosign.sdk.resource.Template;
import com.hellosign.sdk.resource.support.Document;
import com.hellosign.sdk.resource.support.Signer;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TemplateSignatureRequest
extends AbstractRequest {
    private static final String TEMPLATE_IDS = "template_ids";
    private static final String TEMPLATE_SIGNERS = "signers";
    private static final String TEMPLATE_SIGNERS_EMAIL = "email_address";
    private static final String TEMPLATE_SIGNERS_NAME = "name";
    private static final String TEMPLATE_CCS = "ccs";
    private static final String TEMPLATE_CCS_EMAIL = "email_address";
    private static final String TEMPLATE_APPENDED_FILE = "file";
    private static final String TEMPLATE_APPENDED_FILE_URL = "file_url";
    private Map<String, Signer> signers = new HashMap<String, Signer>();
    private Map<String, String> ccs = new HashMap<String, String>();

    public TemplateSignatureRequest() {
    }

    public TemplateSignatureRequest(Template template) throws HelloSignException {
        this();
        this.setTemplateId(template.getId());
    }

    public TemplateSignatureRequest(List<Template> templates) throws HelloSignException {
        this();
        for (Template template : templates) {
            this.addTemplateId(template.getId());
        }
    }

    public Map<String, String> getCCs() {
        return this.ccs;
    }

    public void setCCs(Map<String, String> newCCs) {
        this.ccs = newCCs;
    }

    public void setCC(String role, String email) {
        this.ccs.put(role, email);
    }

    public void clearCCs() {
        this.ccs = new HashMap<String, String>();
    }

    public void setSigner(String role, String email, String name) throws HelloSignException {
        this.signers.put(role, new Signer(email, name));
    }

    public Map<String, Signer> getSigners() {
        return this.signers;
    }

    public void setSigners(Map<String, Signer> signers) {
        this.signers = signers;
    }

    public void removeSignerByEmail(String email) {
        if (email == null) {
            return;
        }
        Set<Map.Entry<String, Signer>> signerSet = this.signers.entrySet();
        for (Map.Entry<String, Signer> entry : signerSet) {
            if (!email.equalsIgnoreCase(entry.getValue().getEmail())) continue;
            this.signers.remove(entry.getKey());
        }
    }

    public String getTemplateId() {
        List<String> templateIds = this.getTemplateIds();
        if (templateIds.isEmpty()) {
            return null;
        }
        return templateIds.get(0);
    }

    public void setTemplateId(String id) throws HelloSignException {
        this.clearList(TEMPLATE_IDS);
        this.addTemplateId(id, null);
    }

    public void addTemplateId(String id) throws HelloSignException {
        this.addTemplateId(id, null);
    }

    public void addTemplateId(String id, Integer index) throws HelloSignException {
        List<String> currentList = this.getList(String.class, TEMPLATE_IDS);
        if (index == null) {
            index = currentList.size();
        } else {
            if (index < 0) {
                throw new HelloSignException("index cannot be negative");
            }
            if (index > currentList.size()) {
                throw new HelloSignException("index is greater than template ID list size: " + currentList.size());
            }
        }
        if (index.intValue() == currentList.size()) {
            this.add(TEMPLATE_IDS, id);
        } else {
            this.clearList(TEMPLATE_IDS);
            int limit = currentList.size();
            for (int i = 0; i < limit + 1; ++i) {
                if (i == index) {
                    this.add(TEMPLATE_IDS, id);
                }
                if (i >= limit) continue;
                this.add(TEMPLATE_IDS, currentList.get(i));
            }
        }
    }

    public List<String> getTemplateIds() {
        return this.getList(String.class, TEMPLATE_IDS);
    }

    @Override
    public Map<String, Serializable> getPostFields() throws HelloSignException {
        Map<String, Serializable> fields = super.getPostFields();
        try {
            List<String> templateIds = this.getTemplateIds();
            for (int i = 0; i < templateIds.size(); ++i) {
                fields.put("template_ids[" + i + "]", (Serializable)((Object)templateIds.get(i)));
            }
            Map<String, Signer> signerz = this.getSigners();
            for (Map.Entry<String, Signer> entry : signerz.entrySet()) {
                String role = entry.getKey();
                Signer s = signerz.get(role);
                fields.put("signers[" + role + "][" + "email_address" + "]", (Serializable)((Object)s.getEmail()));
                fields.put("signers[" + role + "][" + TEMPLATE_SIGNERS_NAME + "]", (Serializable)((Object)s.getNameOrRole()));
            }
            if (this.hasTitle()) {
                fields.put("title", (Serializable)((Object)this.getTitle()));
            }
            if (this.hasSubject()) {
                fields.put("subject", (Serializable)((Object)this.getSubject()));
            }
            if (this.hasMessage()) {
                fields.put("message", (Serializable)((Object)this.getMessage()));
            }
            List<Document> docs = this.getDocuments();
            for (int i = 0; i < docs.size(); ++i) {
                Document d = docs.get(i);
                fields.put("file[" + i + "]", d.getFile());
            }
            List<String> fileUrls = this.getFileUrls();
            for (int i = 0; i < fileUrls.size(); ++i) {
                fields.put("file_url[" + i + "]", (Serializable)((Object)fileUrls.get(i)));
            }
            if (this.hasRedirectUrl()) {
                fields.put("signing_redirect_url", (Serializable)((Object)this.getRedirectUrl()));
            }
            Map<String, String> ccz = this.getCCs();
            for (Map.Entry<String, String> entry : ccz.entrySet()) {
                String role = entry.getKey();
                fields.put("ccs[" + role + "][" + "email_address" + "]", (Serializable)((Object)ccz.get(role)));
            }
            if (this.isTestMode()) {
                fields.put("test_mode", Boolean.valueOf(true));
            }
        }
        catch (Exception ex) {
            throw new HelloSignException("Could not extract form fields from TemplateSignatureRequest.", ex);
        }
        return fields;
    }

    @Override
    public String getId() {
        return null;
    }

    @Override
    public boolean hasUseTextTags() {
        return false;
    }

    @Override
    public Boolean isUsingTextTags() {
        return null;
    }

    @Override
    public void setUseTextTags(boolean useTextTags) {
    }

    @Override
    public boolean hasHideTextTags() {
        return false;
    }

    @Override
    public Boolean isHidingTextTags() {
        return null;
    }

    @Override
    public void setHideTextTags(boolean hideTextTags) {
    }
}

