/*
 * Decompiled with CFR 0.152.
 */
package com.hellosign.sdk.resource.support;

import com.hellosign.sdk.HelloSignException;
import com.hellosign.sdk.resource.AbstractResource;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONObject;

public class WhiteLabelingOptions
extends AbstractResource {
    public static final String WHITE_LABELING_OPTIONS_KEY = "white_labeling_options";
    public static final String WHITE_LABELING_OPTIONS_PAGE_BACKGROUND_COLOR = "page_background_color";
    public static final String WHITE_LABELING_OPTIONS_HEADER_BACKGROUND_COLOR = "header_background_color";
    public static final String WHITE_LABELING_OPTIONS_TEXT_COLOR_1 = "text_color1";
    public static final String WHITE_LABELING_OPTIONS_TEXT_COLOR_2 = "text_color2";
    public static final String WHITE_LABELING_OPTIONS_LINK_COLOR = "link_color";
    public static final String WHITE_LABELING_OPTIONS_PRIMARY_BUTTON_COLOR = "primary_button_color";
    public static final String WHITE_LABELING_OPTIONS_PRIMARY_BUTTON_TEXT_COLOR = "primary_button_text_color";
    public static final String WHITE_LABELING_OPTIONS_PRIMARY_BUTTON_COLOR_HOVER = "primary_button_color_hover";
    public static final String WHITE_LABELING_OPTIONS_PRIMARY_BUTTON_TEXT_COLOR_HOVER = "primary_button_text_color_hover";
    public static final String WHITE_LABELING_OPTIONS_SECONDARY_BUTTON_COLOR = "secondary_button_color";
    public static final String WHITE_LABELING_OPTIONS_SECONDARY_BUTTON_TEXT_COLOR = "secondary_button_text_color";
    public static final String WHITE_LABELING_OPTIONS_SECONDARY_BUTTON_COLOR_HOVER = "secondary_button_color_hover";
    public static final String WHITE_LABELING_OPTIONS_SECONDARY_BUTTON_TEXT_COLOR_HOVER = "secondary_button_text_color_hover";
    public static final String WHITE_LABELING_OPTIONS_LEGAL_VERSION = "legal_version";
    public static final String LEGAL_VERSION_1 = "terms1";
    public static final String LEGAL_VERSION_2 = "terms2";
    private static final String HEX_PATTERN = "^#([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$";
    private static Pattern pattern = Pattern.compile("^#([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$");

    public WhiteLabelingOptions() {
    }

    public WhiteLabelingOptions(JSONObject json) throws HelloSignException {
        super(json, WHITE_LABELING_OPTIONS_KEY);
    }

    public boolean validateColor(String hex) {
        Matcher matcher = pattern.matcher(hex);
        return matcher.matches();
    }

    private void setColor(String key, String color) throws HelloSignException {
        if (!this.validateColor(color)) {
            throw new HelloSignException("Invalid color: " + color);
        }
        this.set(key, color);
    }

    public String getPageBackgroundColor() {
        return this.getString(WHITE_LABELING_OPTIONS_PAGE_BACKGROUND_COLOR);
    }

    public void setPageBackgroundColor(String color) throws HelloSignException {
        this.setColor(WHITE_LABELING_OPTIONS_PAGE_BACKGROUND_COLOR, color);
    }

    public String getHeaderBackgroundColor() {
        return this.getString(WHITE_LABELING_OPTIONS_HEADER_BACKGROUND_COLOR);
    }

    public void setHeaderBackgroundColor(String color) throws HelloSignException {
        this.setColor(WHITE_LABELING_OPTIONS_HEADER_BACKGROUND_COLOR, color);
    }

    public String getTextColor1() {
        return this.getString(WHITE_LABELING_OPTIONS_TEXT_COLOR_1);
    }

    public void setTextColor1(String color) throws HelloSignException {
        this.setColor(WHITE_LABELING_OPTIONS_TEXT_COLOR_1, color);
    }

    public String getTextColor2() {
        return this.getString(WHITE_LABELING_OPTIONS_TEXT_COLOR_2);
    }

    public void setTextColor2(String color) throws HelloSignException {
        this.setColor(WHITE_LABELING_OPTIONS_TEXT_COLOR_2, color);
    }

    public String getLinkColor() {
        return this.getString(WHITE_LABELING_OPTIONS_LINK_COLOR);
    }

    public void setLinkColor(String color) throws HelloSignException {
        this.setColor(WHITE_LABELING_OPTIONS_LINK_COLOR, color);
    }

    public String getPrimaryButtonColor() {
        return this.getString(WHITE_LABELING_OPTIONS_PRIMARY_BUTTON_COLOR);
    }

    public void setPrimaryButtonColor(String color) throws HelloSignException {
        this.setColor(WHITE_LABELING_OPTIONS_PRIMARY_BUTTON_COLOR, color);
    }

    public String getPrimaryButtonTextColor() {
        return this.getString(WHITE_LABELING_OPTIONS_PRIMARY_BUTTON_TEXT_COLOR);
    }

    public void setPrimaryButtonTextColor(String color) throws HelloSignException {
        this.setColor(WHITE_LABELING_OPTIONS_PRIMARY_BUTTON_TEXT_COLOR, color);
    }

    public String getPrimaryButtonHoverColor() {
        return this.getString(WHITE_LABELING_OPTIONS_PRIMARY_BUTTON_COLOR_HOVER);
    }

    public void setPrimaryButtonHoverColor(String color) throws HelloSignException {
        this.setColor(WHITE_LABELING_OPTIONS_PRIMARY_BUTTON_COLOR_HOVER, color);
    }

    public String getPrimaryButtonTextHoverColor() {
        return this.getString(WHITE_LABELING_OPTIONS_PRIMARY_BUTTON_TEXT_COLOR_HOVER);
    }

    public void setPrimaryButtonTextHoverColor(String color) throws HelloSignException {
        this.setColor(WHITE_LABELING_OPTIONS_PRIMARY_BUTTON_TEXT_COLOR_HOVER, color);
    }

    public String getSecondaryButtonColor() {
        return this.getString(WHITE_LABELING_OPTIONS_SECONDARY_BUTTON_COLOR);
    }

    public void setSecondaryButtonColor(String color) throws HelloSignException {
        this.setColor(WHITE_LABELING_OPTIONS_SECONDARY_BUTTON_COLOR, color);
    }

    public String getSecondaryButtonTextColor() {
        return this.getString(WHITE_LABELING_OPTIONS_SECONDARY_BUTTON_TEXT_COLOR);
    }

    public void setSecondaryButtonTextColor(String color) throws HelloSignException {
        this.setColor(WHITE_LABELING_OPTIONS_SECONDARY_BUTTON_TEXT_COLOR, color);
    }

    public String getSecondaryButtonHoverColor() {
        return this.getString(WHITE_LABELING_OPTIONS_SECONDARY_BUTTON_COLOR_HOVER);
    }

    public void setSecondaryButtonHoverColor(String color) throws HelloSignException {
        this.setColor(WHITE_LABELING_OPTIONS_SECONDARY_BUTTON_COLOR_HOVER, color);
    }

    public String getSecondaryButtonTextHoverColor() {
        return this.getString(WHITE_LABELING_OPTIONS_SECONDARY_BUTTON_TEXT_COLOR_HOVER);
    }

    public void setSecondaryButtonTextHoverColor(String color) throws HelloSignException {
        this.setColor(WHITE_LABELING_OPTIONS_SECONDARY_BUTTON_TEXT_COLOR_HOVER, color);
    }

    public void setLegalVersion(String version) {
        this.set(WHITE_LABELING_OPTIONS_LEGAL_VERSION, version);
    }
}

