// File generated from our OpenAPI spec by Stainless.

package com.increase.api.models.transactions

import com.fasterxml.jackson.annotation.JsonAnyGetter
import com.fasterxml.jackson.annotation.JsonAnySetter
import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonProperty
import com.increase.api.core.Enum
import com.increase.api.core.ExcludeMissing
import com.increase.api.core.JsonField
import com.increase.api.core.JsonMissing
import com.increase.api.core.JsonValue
import com.increase.api.core.checkKnown
import com.increase.api.core.checkRequired
import com.increase.api.core.toImmutable
import com.increase.api.errors.IncreaseInvalidDataException
import java.time.LocalDate
import java.time.OffsetDateTime
import java.util.Collections
import java.util.Objects
import java.util.Optional
import kotlin.jvm.optionals.getOrNull

/**
 * Transactions are the immutable additions and removals of money from your bank account. They're
 * the equivalent of line items on your bank statement. To learn more, see
 * [Transactions and Transfers](/documentation/transactions-transfers).
 */
class Transaction
private constructor(
    private val id: JsonField<String>,
    private val accountId: JsonField<String>,
    private val amount: JsonField<Long>,
    private val createdAt: JsonField<OffsetDateTime>,
    private val currency: JsonField<Currency>,
    private val description: JsonField<String>,
    private val routeId: JsonField<String>,
    private val routeType: JsonField<RouteType>,
    private val source: JsonField<Source>,
    private val type: JsonField<Type>,
    private val additionalProperties: MutableMap<String, JsonValue>,
) {

    @JsonCreator
    private constructor(
        @JsonProperty("id") @ExcludeMissing id: JsonField<String> = JsonMissing.of(),
        @JsonProperty("account_id") @ExcludeMissing accountId: JsonField<String> = JsonMissing.of(),
        @JsonProperty("amount") @ExcludeMissing amount: JsonField<Long> = JsonMissing.of(),
        @JsonProperty("created_at")
        @ExcludeMissing
        createdAt: JsonField<OffsetDateTime> = JsonMissing.of(),
        @JsonProperty("currency") @ExcludeMissing currency: JsonField<Currency> = JsonMissing.of(),
        @JsonProperty("description")
        @ExcludeMissing
        description: JsonField<String> = JsonMissing.of(),
        @JsonProperty("route_id") @ExcludeMissing routeId: JsonField<String> = JsonMissing.of(),
        @JsonProperty("route_type")
        @ExcludeMissing
        routeType: JsonField<RouteType> = JsonMissing.of(),
        @JsonProperty("source") @ExcludeMissing source: JsonField<Source> = JsonMissing.of(),
        @JsonProperty("type") @ExcludeMissing type: JsonField<Type> = JsonMissing.of(),
    ) : this(
        id,
        accountId,
        amount,
        createdAt,
        currency,
        description,
        routeId,
        routeType,
        source,
        type,
        mutableMapOf(),
    )

    /**
     * The Transaction identifier.
     *
     * @throws IncreaseInvalidDataException if the JSON field has an unexpected type or is
     *   unexpectedly missing or null (e.g. if the server responded with an unexpected value).
     */
    fun id(): String = id.getRequired("id")

    /**
     * The identifier for the Account the Transaction belongs to.
     *
     * @throws IncreaseInvalidDataException if the JSON field has an unexpected type or is
     *   unexpectedly missing or null (e.g. if the server responded with an unexpected value).
     */
    fun accountId(): String = accountId.getRequired("account_id")

    /**
     * The Transaction amount in the minor unit of its currency. For dollars, for example, this is
     * cents.
     *
     * @throws IncreaseInvalidDataException if the JSON field has an unexpected type or is
     *   unexpectedly missing or null (e.g. if the server responded with an unexpected value).
     */
    fun amount(): Long = amount.getRequired("amount")

    /**
     * The [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) date on which the Transaction
     * occurred.
     *
     * @throws IncreaseInvalidDataException if the JSON field has an unexpected type or is
     *   unexpectedly missing or null (e.g. if the server responded with an unexpected value).
     */
    fun createdAt(): OffsetDateTime = createdAt.getRequired("created_at")

    /**
     * The [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) code for the Transaction's currency.
     * This will match the currency on the Transaction's Account.
     *
     * @throws IncreaseInvalidDataException if the JSON field has an unexpected type or is
     *   unexpectedly missing or null (e.g. if the server responded with an unexpected value).
     */
    fun currency(): Currency = currency.getRequired("currency")

    /**
     * An informational message describing this transaction. Use the fields in `source` to get more
     * detailed information. This field appears as the line-item on the statement.
     *
     * @throws IncreaseInvalidDataException if the JSON field has an unexpected type or is
     *   unexpectedly missing or null (e.g. if the server responded with an unexpected value).
     */
    fun description(): String = description.getRequired("description")

    /**
     * The identifier for the route this Transaction came through. Routes are things like cards and
     * ACH details.
     *
     * @throws IncreaseInvalidDataException if the JSON field has an unexpected type (e.g. if the
     *   server responded with an unexpected value).
     */
    fun routeId(): Optional<String> = routeId.getOptional("route_id")

    /**
     * The type of the route this Transaction came through.
     *
     * @throws IncreaseInvalidDataException if the JSON field has an unexpected type (e.g. if the
     *   server responded with an unexpected value).
     */
    fun routeType(): Optional<RouteType> = routeType.getOptional("route_type")

    /**
     * This is an object giving more details on the network-level event that caused the Transaction.
     * Note that for backwards compatibility reasons, additional undocumented keys may appear in
     * this object. These should be treated as deprecated and will be removed in the future.
     *
     * @throws IncreaseInvalidDataException if the JSON field has an unexpected type or is
     *   unexpectedly missing or null (e.g. if the server responded with an unexpected value).
     */
    fun source(): Source = source.getRequired("source")

    /**
     * A constant representing the object's type. For this resource it will always be `transaction`.
     *
     * @throws IncreaseInvalidDataException if the JSON field has an unexpected type or is
     *   unexpectedly missing or null (e.g. if the server responded with an unexpected value).
     */
    fun type(): Type = type.getRequired("type")

    /**
     * Returns the raw JSON value of [id].
     *
     * Unlike [id], this method doesn't throw if the JSON field has an unexpected type.
     */
    @JsonProperty("id") @ExcludeMissing fun _id(): JsonField<String> = id

    /**
     * Returns the raw JSON value of [accountId].
     *
     * Unlike [accountId], this method doesn't throw if the JSON field has an unexpected type.
     */
    @JsonProperty("account_id") @ExcludeMissing fun _accountId(): JsonField<String> = accountId

    /**
     * Returns the raw JSON value of [amount].
     *
     * Unlike [amount], this method doesn't throw if the JSON field has an unexpected type.
     */
    @JsonProperty("amount") @ExcludeMissing fun _amount(): JsonField<Long> = amount

    /**
     * Returns the raw JSON value of [createdAt].
     *
     * Unlike [createdAt], this method doesn't throw if the JSON field has an unexpected type.
     */
    @JsonProperty("created_at")
    @ExcludeMissing
    fun _createdAt(): JsonField<OffsetDateTime> = createdAt

    /**
     * Returns the raw JSON value of [currency].
     *
     * Unlike [currency], this method doesn't throw if the JSON field has an unexpected type.
     */
    @JsonProperty("currency") @ExcludeMissing fun _currency(): JsonField<Currency> = currency

    /**
     * Returns the raw JSON value of [description].
     *
     * Unlike [description], this method doesn't throw if the JSON field has an unexpected type.
     */
    @JsonProperty("description") @ExcludeMissing fun _description(): JsonField<String> = description

    /**
     * Returns the raw JSON value of [routeId].
     *
     * Unlike [routeId], this method doesn't throw if the JSON field has an unexpected type.
     */
    @JsonProperty("route_id") @ExcludeMissing fun _routeId(): JsonField<String> = routeId

    /**
     * Returns the raw JSON value of [routeType].
     *
     * Unlike [routeType], this method doesn't throw if the JSON field has an unexpected type.
     */
    @JsonProperty("route_type") @ExcludeMissing fun _routeType(): JsonField<RouteType> = routeType

    /**
     * Returns the raw JSON value of [source].
     *
     * Unlike [source], this method doesn't throw if the JSON field has an unexpected type.
     */
    @JsonProperty("source") @ExcludeMissing fun _source(): JsonField<Source> = source

    /**
     * Returns the raw JSON value of [type].
     *
     * Unlike [type], this method doesn't throw if the JSON field has an unexpected type.
     */
    @JsonProperty("type") @ExcludeMissing fun _type(): JsonField<Type> = type

    @JsonAnySetter
    private fun putAdditionalProperty(key: String, value: JsonValue) {
        additionalProperties.put(key, value)
    }

    @JsonAnyGetter
    @ExcludeMissing
    fun _additionalProperties(): Map<String, JsonValue> =
        Collections.unmodifiableMap(additionalProperties)

    fun toBuilder() = Builder().from(this)

    companion object {

        /**
         * Returns a mutable builder for constructing an instance of [Transaction].
         *
         * The following fields are required:
         * ```java
         * .id()
         * .accountId()
         * .amount()
         * .createdAt()
         * .currency()
         * .description()
         * .routeId()
         * .routeType()
         * .source()
         * .type()
         * ```
         */
        @JvmStatic fun builder() = Builder()
    }

    /** A builder for [Transaction]. */
    class Builder internal constructor() {

        private var id: JsonField<String>? = null
        private var accountId: JsonField<String>? = null
        private var amount: JsonField<Long>? = null
        private var createdAt: JsonField<OffsetDateTime>? = null
        private var currency: JsonField<Currency>? = null
        private var description: JsonField<String>? = null
        private var routeId: JsonField<String>? = null
        private var routeType: JsonField<RouteType>? = null
        private var source: JsonField<Source>? = null
        private var type: JsonField<Type>? = null
        private var additionalProperties: MutableMap<String, JsonValue> = mutableMapOf()

        @JvmSynthetic
        internal fun from(transaction: Transaction) = apply {
            id = transaction.id
            accountId = transaction.accountId
            amount = transaction.amount
            createdAt = transaction.createdAt
            currency = transaction.currency
            description = transaction.description
            routeId = transaction.routeId
            routeType = transaction.routeType
            source = transaction.source
            type = transaction.type
            additionalProperties = transaction.additionalProperties.toMutableMap()
        }

        /** The Transaction identifier. */
        fun id(id: String) = id(JsonField.of(id))

        /**
         * Sets [Builder.id] to an arbitrary JSON value.
         *
         * You should usually call [Builder.id] with a well-typed [String] value instead. This
         * method is primarily for setting the field to an undocumented or not yet supported value.
         */
        fun id(id: JsonField<String>) = apply { this.id = id }

        /** The identifier for the Account the Transaction belongs to. */
        fun accountId(accountId: String) = accountId(JsonField.of(accountId))

        /**
         * Sets [Builder.accountId] to an arbitrary JSON value.
         *
         * You should usually call [Builder.accountId] with a well-typed [String] value instead.
         * This method is primarily for setting the field to an undocumented or not yet supported
         * value.
         */
        fun accountId(accountId: JsonField<String>) = apply { this.accountId = accountId }

        /**
         * The Transaction amount in the minor unit of its currency. For dollars, for example, this
         * is cents.
         */
        fun amount(amount: Long) = amount(JsonField.of(amount))

        /**
         * Sets [Builder.amount] to an arbitrary JSON value.
         *
         * You should usually call [Builder.amount] with a well-typed [Long] value instead. This
         * method is primarily for setting the field to an undocumented or not yet supported value.
         */
        fun amount(amount: JsonField<Long>) = apply { this.amount = amount }

        /**
         * The [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) date on which the Transaction
         * occurred.
         */
        fun createdAt(createdAt: OffsetDateTime) = createdAt(JsonField.of(createdAt))

        /**
         * Sets [Builder.createdAt] to an arbitrary JSON value.
         *
         * You should usually call [Builder.createdAt] with a well-typed [OffsetDateTime] value
         * instead. This method is primarily for setting the field to an undocumented or not yet
         * supported value.
         */
        fun createdAt(createdAt: JsonField<OffsetDateTime>) = apply { this.createdAt = createdAt }

        /**
         * The [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) code for the Transaction's
         * currency. This will match the currency on the Transaction's Account.
         */
        fun currency(currency: Currency) = currency(JsonField.of(currency))

        /**
         * Sets [Builder.currency] to an arbitrary JSON value.
         *
         * You should usually call [Builder.currency] with a well-typed [Currency] value instead.
         * This method is primarily for setting the field to an undocumented or not yet supported
         * value.
         */
        fun currency(currency: JsonField<Currency>) = apply { this.currency = currency }

        /**
         * An informational message describing this transaction. Use the fields in `source` to get
         * more detailed information. This field appears as the line-item on the statement.
         */
        fun description(description: String) = description(JsonField.of(description))

        /**
         * Sets [Builder.description] to an arbitrary JSON value.
         *
         * You should usually call [Builder.description] with a well-typed [String] value instead.
         * This method is primarily for setting the field to an undocumented or not yet supported
         * value.
         */
        fun description(description: JsonField<String>) = apply { this.description = description }

        /**
         * The identifier for the route this Transaction came through. Routes are things like cards
         * and ACH details.
         */
        fun routeId(routeId: String?) = routeId(JsonField.ofNullable(routeId))

        /** Alias for calling [Builder.routeId] with `routeId.orElse(null)`. */
        fun routeId(routeId: Optional<String>) = routeId(routeId.getOrNull())

        /**
         * Sets [Builder.routeId] to an arbitrary JSON value.
         *
         * You should usually call [Builder.routeId] with a well-typed [String] value instead. This
         * method is primarily for setting the field to an undocumented or not yet supported value.
         */
        fun routeId(routeId: JsonField<String>) = apply { this.routeId = routeId }

        /** The type of the route this Transaction came through. */
        fun routeType(routeType: RouteType?) = routeType(JsonField.ofNullable(routeType))

        /** Alias for calling [Builder.routeType] with `routeType.orElse(null)`. */
        fun routeType(routeType: Optional<RouteType>) = routeType(routeType.getOrNull())

        /**
         * Sets [Builder.routeType] to an arbitrary JSON value.
         *
         * You should usually call [Builder.routeType] with a well-typed [RouteType] value instead.
         * This method is primarily for setting the field to an undocumented or not yet supported
         * value.
         */
        fun routeType(routeType: JsonField<RouteType>) = apply { this.routeType = routeType }

        /**
         * This is an object giving more details on the network-level event that caused the
         * Transaction. Note that for backwards compatibility reasons, additional undocumented keys
         * may appear in this object. These should be treated as deprecated and will be removed in
         * the future.
         */
        fun source(source: Source) = source(JsonField.of(source))

        /**
         * Sets [Builder.source] to an arbitrary JSON value.
         *
         * You should usually call [Builder.source] with a well-typed [Source] value instead. This
         * method is primarily for setting the field to an undocumented or not yet supported value.
         */
        fun source(source: JsonField<Source>) = apply { this.source = source }

        /**
         * A constant representing the object's type. For this resource it will always be
         * `transaction`.
         */
        fun type(type: Type) = type(JsonField.of(type))

        /**
         * Sets [Builder.type] to an arbitrary JSON value.
         *
         * You should usually call [Builder.type] with a well-typed [Type] value instead. This
         * method is primarily for setting the field to an undocumented or not yet supported value.
         */
        fun type(type: JsonField<Type>) = apply { this.type = type }

        fun additionalProperties(additionalProperties: Map<String, JsonValue>) = apply {
            this.additionalProperties.clear()
            putAllAdditionalProperties(additionalProperties)
        }

        fun putAdditionalProperty(key: String, value: JsonValue) = apply {
            additionalProperties.put(key, value)
        }

        fun putAllAdditionalProperties(additionalProperties: Map<String, JsonValue>) = apply {
            this.additionalProperties.putAll(additionalProperties)
        }

        fun removeAdditionalProperty(key: String) = apply { additionalProperties.remove(key) }

        fun removeAllAdditionalProperties(keys: Set<String>) = apply {
            keys.forEach(::removeAdditionalProperty)
        }

        /**
         * Returns an immutable instance of [Transaction].
         *
         * Further updates to this [Builder] will not mutate the returned instance.
         *
         * The following fields are required:
         * ```java
         * .id()
         * .accountId()
         * .amount()
         * .createdAt()
         * .currency()
         * .description()
         * .routeId()
         * .routeType()
         * .source()
         * .type()
         * ```
         *
         * @throws IllegalStateException if any required field is unset.
         */
        fun build(): Transaction =
            Transaction(
                checkRequired("id", id),
                checkRequired("accountId", accountId),
                checkRequired("amount", amount),
                checkRequired("createdAt", createdAt),
                checkRequired("currency", currency),
                checkRequired("description", description),
                checkRequired("routeId", routeId),
                checkRequired("routeType", routeType),
                checkRequired("source", source),
                checkRequired("type", type),
                additionalProperties.toMutableMap(),
            )
    }

    private var validated: Boolean = false

    fun validate(): Transaction = apply {
        if (validated) {
            return@apply
        }

        id()
        accountId()
        amount()
        createdAt()
        currency().validate()
        description()
        routeId()
        routeType().ifPresent { it.validate() }
        source().validate()
        type().validate()
        validated = true
    }

    fun isValid(): Boolean =
        try {
            validate()
            true
        } catch (e: IncreaseInvalidDataException) {
            false
        }

    /**
     * Returns a score indicating how many valid values are contained in this object recursively.
     *
     * Used for best match union deserialization.
     */
    @JvmSynthetic
    internal fun validity(): Int =
        (if (id.asKnown().isPresent) 1 else 0) +
            (if (accountId.asKnown().isPresent) 1 else 0) +
            (if (amount.asKnown().isPresent) 1 else 0) +
            (if (createdAt.asKnown().isPresent) 1 else 0) +
            (currency.asKnown().getOrNull()?.validity() ?: 0) +
            (if (description.asKnown().isPresent) 1 else 0) +
            (if (routeId.asKnown().isPresent) 1 else 0) +
            (routeType.asKnown().getOrNull()?.validity() ?: 0) +
            (source.asKnown().getOrNull()?.validity() ?: 0) +
            (type.asKnown().getOrNull()?.validity() ?: 0)

    /**
     * The [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) code for the Transaction's currency.
     * This will match the currency on the Transaction's Account.
     */
    class Currency @JsonCreator private constructor(private val value: JsonField<String>) : Enum {

        /**
         * Returns this class instance's raw value.
         *
         * This is usually only useful if this instance was deserialized from data that doesn't
         * match any known member, and you want to know that value. For example, if the SDK is on an
         * older version than the API, then the API may respond with new members that the SDK is
         * unaware of.
         */
        @com.fasterxml.jackson.annotation.JsonValue fun _value(): JsonField<String> = value

        companion object {

            /** Canadian Dollar (CAD) */
            @JvmField val CAD = of("CAD")

            /** Swiss Franc (CHF) */
            @JvmField val CHF = of("CHF")

            /** Euro (EUR) */
            @JvmField val EUR = of("EUR")

            /** British Pound (GBP) */
            @JvmField val GBP = of("GBP")

            /** Japanese Yen (JPY) */
            @JvmField val JPY = of("JPY")

            /** US Dollar (USD) */
            @JvmField val USD = of("USD")

            @JvmStatic fun of(value: String) = Currency(JsonField.of(value))
        }

        /** An enum containing [Currency]'s known values. */
        enum class Known {
            /** Canadian Dollar (CAD) */
            CAD,
            /** Swiss Franc (CHF) */
            CHF,
            /** Euro (EUR) */
            EUR,
            /** British Pound (GBP) */
            GBP,
            /** Japanese Yen (JPY) */
            JPY,
            /** US Dollar (USD) */
            USD,
        }

        /**
         * An enum containing [Currency]'s known values, as well as an [_UNKNOWN] member.
         *
         * An instance of [Currency] can contain an unknown value in a couple of cases:
         * - It was deserialized from data that doesn't match any known member. For example, if the
         *   SDK is on an older version than the API, then the API may respond with new members that
         *   the SDK is unaware of.
         * - It was constructed with an arbitrary value using the [of] method.
         */
        enum class Value {
            /** Canadian Dollar (CAD) */
            CAD,
            /** Swiss Franc (CHF) */
            CHF,
            /** Euro (EUR) */
            EUR,
            /** British Pound (GBP) */
            GBP,
            /** Japanese Yen (JPY) */
            JPY,
            /** US Dollar (USD) */
            USD,
            /** An enum member indicating that [Currency] was instantiated with an unknown value. */
            _UNKNOWN,
        }

        /**
         * Returns an enum member corresponding to this class instance's value, or [Value._UNKNOWN]
         * if the class was instantiated with an unknown value.
         *
         * Use the [known] method instead if you're certain the value is always known or if you want
         * to throw for the unknown case.
         */
        fun value(): Value =
            when (this) {
                CAD -> Value.CAD
                CHF -> Value.CHF
                EUR -> Value.EUR
                GBP -> Value.GBP
                JPY -> Value.JPY
                USD -> Value.USD
                else -> Value._UNKNOWN
            }

        /**
         * Returns an enum member corresponding to this class instance's value.
         *
         * Use the [value] method instead if you're uncertain the value is always known and don't
         * want to throw for the unknown case.
         *
         * @throws IncreaseInvalidDataException if this class instance's value is a not a known
         *   member.
         */
        fun known(): Known =
            when (this) {
                CAD -> Known.CAD
                CHF -> Known.CHF
                EUR -> Known.EUR
                GBP -> Known.GBP
                JPY -> Known.JPY
                USD -> Known.USD
                else -> throw IncreaseInvalidDataException("Unknown Currency: $value")
            }

        /**
         * Returns this class instance's primitive wire representation.
         *
         * This differs from the [toString] method because that method is primarily for debugging
         * and generally doesn't throw.
         *
         * @throws IncreaseInvalidDataException if this class instance's value does not have the
         *   expected primitive type.
         */
        fun asString(): String =
            _value().asString().orElseThrow {
                IncreaseInvalidDataException("Value is not a String")
            }

        private var validated: Boolean = false

        fun validate(): Currency = apply {
            if (validated) {
                return@apply
            }

            known()
            validated = true
        }

        fun isValid(): Boolean =
            try {
                validate()
                true
            } catch (e: IncreaseInvalidDataException) {
                false
            }

        /**
         * Returns a score indicating how many valid values are contained in this object
         * recursively.
         *
         * Used for best match union deserialization.
         */
        @JvmSynthetic internal fun validity(): Int = if (value() == Value._UNKNOWN) 0 else 1

        override fun equals(other: Any?): Boolean {
            if (this === other) {
                return true
            }

            return /* spotless:off */ other is Currency && value == other.value /* spotless:on */
        }

        override fun hashCode() = value.hashCode()

        override fun toString() = value.toString()
    }

    /** The type of the route this Transaction came through. */
    class RouteType @JsonCreator private constructor(private val value: JsonField<String>) : Enum {

        /**
         * Returns this class instance's raw value.
         *
         * This is usually only useful if this instance was deserialized from data that doesn't
         * match any known member, and you want to know that value. For example, if the SDK is on an
         * older version than the API, then the API may respond with new members that the SDK is
         * unaware of.
         */
        @com.fasterxml.jackson.annotation.JsonValue fun _value(): JsonField<String> = value

        companion object {

            /** An Account Number. */
            @JvmField val ACCOUNT_NUMBER = of("account_number")

            /** A Card. */
            @JvmField val CARD = of("card")

            /** A Lockbox. */
            @JvmField val LOCKBOX = of("lockbox")

            @JvmStatic fun of(value: String) = RouteType(JsonField.of(value))
        }

        /** An enum containing [RouteType]'s known values. */
        enum class Known {
            /** An Account Number. */
            ACCOUNT_NUMBER,
            /** A Card. */
            CARD,
            /** A Lockbox. */
            LOCKBOX,
        }

        /**
         * An enum containing [RouteType]'s known values, as well as an [_UNKNOWN] member.
         *
         * An instance of [RouteType] can contain an unknown value in a couple of cases:
         * - It was deserialized from data that doesn't match any known member. For example, if the
         *   SDK is on an older version than the API, then the API may respond with new members that
         *   the SDK is unaware of.
         * - It was constructed with an arbitrary value using the [of] method.
         */
        enum class Value {
            /** An Account Number. */
            ACCOUNT_NUMBER,
            /** A Card. */
            CARD,
            /** A Lockbox. */
            LOCKBOX,
            /**
             * An enum member indicating that [RouteType] was instantiated with an unknown value.
             */
            _UNKNOWN,
        }

        /**
         * Returns an enum member corresponding to this class instance's value, or [Value._UNKNOWN]
         * if the class was instantiated with an unknown value.
         *
         * Use the [known] method instead if you're certain the value is always known or if you want
         * to throw for the unknown case.
         */
        fun value(): Value =
            when (this) {
                ACCOUNT_NUMBER -> Value.ACCOUNT_NUMBER
                CARD -> Value.CARD
                LOCKBOX -> Value.LOCKBOX
                else -> Value._UNKNOWN
            }

        /**
         * Returns an enum member corresponding to this class instance's value.
         *
         * Use the [value] method instead if you're uncertain the value is always known and don't
         * want to throw for the unknown case.
         *
         * @throws IncreaseInvalidDataException if this class instance's value is a not a known
         *   member.
         */
        fun known(): Known =
            when (this) {
                ACCOUNT_NUMBER -> Known.ACCOUNT_NUMBER
                CARD -> Known.CARD
                LOCKBOX -> Known.LOCKBOX
                else -> throw IncreaseInvalidDataException("Unknown RouteType: $value")
            }

        /**
         * Returns this class instance's primitive wire representation.
         *
         * This differs from the [toString] method because that method is primarily for debugging
         * and generally doesn't throw.
         *
         * @throws IncreaseInvalidDataException if this class instance's value does not have the
         *   expected primitive type.
         */
        fun asString(): String =
            _value().asString().orElseThrow {
                IncreaseInvalidDataException("Value is not a String")
            }

        private var validated: Boolean = false

        fun validate(): RouteType = apply {
            if (validated) {
                return@apply
            }

            known()
            validated = true
        }

        fun isValid(): Boolean =
            try {
                validate()
                true
            } catch (e: IncreaseInvalidDataException) {
                false
            }

        /**
         * Returns a score indicating how many valid values are contained in this object
         * recursively.
         *
         * Used for best match union deserialization.
         */
        @JvmSynthetic internal fun validity(): Int = if (value() == Value._UNKNOWN) 0 else 1

        override fun equals(other: Any?): Boolean {
            if (this === other) {
                return true
            }

            return /* spotless:off */ other is RouteType && value == other.value /* spotless:on */
        }

        override fun hashCode() = value.hashCode()

        override fun toString() = value.toString()
    }

    /**
     * This is an object giving more details on the network-level event that caused the Transaction.
     * Note that for backwards compatibility reasons, additional undocumented keys may appear in
     * this object. These should be treated as deprecated and will be removed in the future.
     */
    class Source
    private constructor(
        private val accountTransferIntention: JsonField<AccountTransferIntention>,
        private val achTransferIntention: JsonField<AchTransferIntention>,
        private val achTransferRejection: JsonField<AchTransferRejection>,
        private val achTransferReturn: JsonField<AchTransferReturn>,
        private val cardDisputeAcceptance: JsonField<CardDisputeAcceptance>,
        private val cardDisputeLoss: JsonField<CardDisputeLoss>,
        private val cardPushTransferAcceptance: JsonField<CardPushTransferAcceptance>,
        private val cardRefund: JsonField<CardRefund>,
        private val cardRevenuePayment: JsonField<CardRevenuePayment>,
        private val cardSettlement: JsonField<CardSettlement>,
        private val cashbackPayment: JsonField<CashbackPayment>,
        private val category: JsonField<Category>,
        private val checkDepositAcceptance: JsonField<CheckDepositAcceptance>,
        private val checkDepositReturn: JsonField<CheckDepositReturn>,
        private val checkTransferDeposit: JsonField<CheckTransferDeposit>,
        private val feePayment: JsonField<FeePayment>,
        private val inboundAchTransfer: JsonField<InboundAchTransfer>,
        private val inboundAchTransferReturnIntention: JsonField<InboundAchTransferReturnIntention>,
        private val inboundCheckAdjustment: JsonField<InboundCheckAdjustment>,
        private val inboundCheckDepositReturnIntention:
            JsonField<InboundCheckDepositReturnIntention>,
        private val inboundRealTimePaymentsTransferConfirmation:
            JsonField<InboundRealTimePaymentsTransferConfirmation>,
        private val inboundRealTimePaymentsTransferDecline:
            JsonField<InboundRealTimePaymentsTransferDecline>,
        private val inboundWireReversal: JsonField<InboundWireReversal>,
        private val inboundWireTransfer: JsonField<InboundWireTransfer>,
        private val inboundWireTransferReversal: JsonField<InboundWireTransferReversal>,
        private val interestPayment: JsonField<InterestPayment>,
        private val internalSource: JsonField<InternalSource>,
        private val other: JsonValue,
        private val realTimePaymentsTransferAcknowledgement:
            JsonField<RealTimePaymentsTransferAcknowledgement>,
        private val sampleFunds: JsonField<SampleFunds>,
        private val swiftTransferIntention: JsonField<SwiftTransferIntention>,
        private val wireTransferIntention: JsonField<WireTransferIntention>,
        private val additionalProperties: MutableMap<String, JsonValue>,
    ) {

        @JsonCreator
        private constructor(
            @JsonProperty("account_transfer_intention")
            @ExcludeMissing
            accountTransferIntention: JsonField<AccountTransferIntention> = JsonMissing.of(),
            @JsonProperty("ach_transfer_intention")
            @ExcludeMissing
            achTransferIntention: JsonField<AchTransferIntention> = JsonMissing.of(),
            @JsonProperty("ach_transfer_rejection")
            @ExcludeMissing
            achTransferRejection: JsonField<AchTransferRejection> = JsonMissing.of(),
            @JsonProperty("ach_transfer_return")
            @ExcludeMissing
            achTransferReturn: JsonField<AchTransferReturn> = JsonMissing.of(),
            @JsonProperty("card_dispute_acceptance")
            @ExcludeMissing
            cardDisputeAcceptance: JsonField<CardDisputeAcceptance> = JsonMissing.of(),
            @JsonProperty("card_dispute_loss")
            @ExcludeMissing
            cardDisputeLoss: JsonField<CardDisputeLoss> = JsonMissing.of(),
            @JsonProperty("card_push_transfer_acceptance")
            @ExcludeMissing
            cardPushTransferAcceptance: JsonField<CardPushTransferAcceptance> = JsonMissing.of(),
            @JsonProperty("card_refund")
            @ExcludeMissing
            cardRefund: JsonField<CardRefund> = JsonMissing.of(),
            @JsonProperty("card_revenue_payment")
            @ExcludeMissing
            cardRevenuePayment: JsonField<CardRevenuePayment> = JsonMissing.of(),
            @JsonProperty("card_settlement")
            @ExcludeMissing
            cardSettlement: JsonField<CardSettlement> = JsonMissing.of(),
            @JsonProperty("cashback_payment")
            @ExcludeMissing
            cashbackPayment: JsonField<CashbackPayment> = JsonMissing.of(),
            @JsonProperty("category")
            @ExcludeMissing
            category: JsonField<Category> = JsonMissing.of(),
            @JsonProperty("check_deposit_acceptance")
            @ExcludeMissing
            checkDepositAcceptance: JsonField<CheckDepositAcceptance> = JsonMissing.of(),
            @JsonProperty("check_deposit_return")
            @ExcludeMissing
            checkDepositReturn: JsonField<CheckDepositReturn> = JsonMissing.of(),
            @JsonProperty("check_transfer_deposit")
            @ExcludeMissing
            checkTransferDeposit: JsonField<CheckTransferDeposit> = JsonMissing.of(),
            @JsonProperty("fee_payment")
            @ExcludeMissing
            feePayment: JsonField<FeePayment> = JsonMissing.of(),
            @JsonProperty("inbound_ach_transfer")
            @ExcludeMissing
            inboundAchTransfer: JsonField<InboundAchTransfer> = JsonMissing.of(),
            @JsonProperty("inbound_ach_transfer_return_intention")
            @ExcludeMissing
            inboundAchTransferReturnIntention: JsonField<InboundAchTransferReturnIntention> =
                JsonMissing.of(),
            @JsonProperty("inbound_check_adjustment")
            @ExcludeMissing
            inboundCheckAdjustment: JsonField<InboundCheckAdjustment> = JsonMissing.of(),
            @JsonProperty("inbound_check_deposit_return_intention")
            @ExcludeMissing
            inboundCheckDepositReturnIntention: JsonField<InboundCheckDepositReturnIntention> =
                JsonMissing.of(),
            @JsonProperty("inbound_real_time_payments_transfer_confirmation")
            @ExcludeMissing
            inboundRealTimePaymentsTransferConfirmation:
                JsonField<InboundRealTimePaymentsTransferConfirmation> =
                JsonMissing.of(),
            @JsonProperty("inbound_real_time_payments_transfer_decline")
            @ExcludeMissing
            inboundRealTimePaymentsTransferDecline:
                JsonField<InboundRealTimePaymentsTransferDecline> =
                JsonMissing.of(),
            @JsonProperty("inbound_wire_reversal")
            @ExcludeMissing
            inboundWireReversal: JsonField<InboundWireReversal> = JsonMissing.of(),
            @JsonProperty("inbound_wire_transfer")
            @ExcludeMissing
            inboundWireTransfer: JsonField<InboundWireTransfer> = JsonMissing.of(),
            @JsonProperty("inbound_wire_transfer_reversal")
            @ExcludeMissing
            inboundWireTransferReversal: JsonField<InboundWireTransferReversal> = JsonMissing.of(),
            @JsonProperty("interest_payment")
            @ExcludeMissing
            interestPayment: JsonField<InterestPayment> = JsonMissing.of(),
            @JsonProperty("internal_source")
            @ExcludeMissing
            internalSource: JsonField<InternalSource> = JsonMissing.of(),
            @JsonProperty("other") @ExcludeMissing other: JsonValue = JsonMissing.of(),
            @JsonProperty("real_time_payments_transfer_acknowledgement")
            @ExcludeMissing
            realTimePaymentsTransferAcknowledgement:
                JsonField<RealTimePaymentsTransferAcknowledgement> =
                JsonMissing.of(),
            @JsonProperty("sample_funds")
            @ExcludeMissing
            sampleFunds: JsonField<SampleFunds> = JsonMissing.of(),
            @JsonProperty("swift_transfer_intention")
            @ExcludeMissing
            swiftTransferIntention: JsonField<SwiftTransferIntention> = JsonMissing.of(),
            @JsonProperty("wire_transfer_intention")
            @ExcludeMissing
            wireTransferIntention: JsonField<WireTransferIntention> = JsonMissing.of(),
        ) : this(
            accountTransferIntention,
            achTransferIntention,
            achTransferRejection,
            achTransferReturn,
            cardDisputeAcceptance,
            cardDisputeLoss,
            cardPushTransferAcceptance,
            cardRefund,
            cardRevenuePayment,
            cardSettlement,
            cashbackPayment,
            category,
            checkDepositAcceptance,
            checkDepositReturn,
            checkTransferDeposit,
            feePayment,
            inboundAchTransfer,
            inboundAchTransferReturnIntention,
            inboundCheckAdjustment,
            inboundCheckDepositReturnIntention,
            inboundRealTimePaymentsTransferConfirmation,
            inboundRealTimePaymentsTransferDecline,
            inboundWireReversal,
            inboundWireTransfer,
            inboundWireTransferReversal,
            interestPayment,
            internalSource,
            other,
            realTimePaymentsTransferAcknowledgement,
            sampleFunds,
            swiftTransferIntention,
            wireTransferIntention,
            mutableMapOf(),
        )

        /**
         * An Account Transfer Intention object. This field will be present in the JSON response if
         * and only if `category` is equal to `account_transfer_intention`. Two Account Transfer
         * Intentions are created from each Account Transfer. One decrements the source account, and
         * the other increments the destination account.
         *
         * @throws IncreaseInvalidDataException if the JSON field has an unexpected type (e.g. if
         *   the server responded with an unexpected value).
         */
        fun accountTransferIntention(): Optional<AccountTransferIntention> =
            accountTransferIntention.getOptional("account_transfer_intention")

        /**
         * An ACH Transfer Intention object. This field will be present in the JSON response if and
         * only if `category` is equal to `ach_transfer_intention`. An ACH Transfer Intention is
         * created from an ACH Transfer. It reflects the intention to move money into or out of an
         * Increase account via the ACH network.
         *
         * @throws IncreaseInvalidDataException if the JSON field has an unexpected type (e.g. if
         *   the server responded with an unexpected value).
         */
        fun achTransferIntention(): Optional<AchTransferIntention> =
            achTransferIntention.getOptional("ach_transfer_intention")

        /**
         * An ACH Transfer Rejection object. This field will be present in the JSON response if and
         * only if `category` is equal to `ach_transfer_rejection`. An ACH Transfer Rejection is
         * created when an ACH Transfer is rejected by Increase. It offsets the ACH Transfer
         * Intention. These rejections are rare.
         *
         * @throws IncreaseInvalidDataException if the JSON field has an unexpected type (e.g. if
         *   the server responded with an unexpected value).
         */
        fun achTransferRejection(): Optional<AchTransferRejection> =
            achTransferRejection.getOptional("ach_transfer_rejection")

        /**
         * An ACH Transfer Return object. This field will be present in the JSON response if and
         * only if `category` is equal to `ach_transfer_return`. An ACH Transfer Return is created
         * when an ACH Transfer is returned by the receiving bank. It offsets the ACH Transfer
         * Intention. ACH Transfer Returns usually occur within the first two business days after
         * the transfer is initiated, but can occur much later.
         *
         * @throws IncreaseInvalidDataException if the JSON field has an unexpected type (e.g. if
         *   the server responded with an unexpected value).
         */
        fun achTransferReturn(): Optional<AchTransferReturn> =
            achTransferReturn.getOptional("ach_transfer_return")

        /**
         * A Card Dispute Acceptance object. This field will be present in the JSON response if and
         * only if `category` is equal to `card_dispute_acceptance`. Contains the details of a
         * successful Card Dispute.
         *
         * @throws IncreaseInvalidDataException if the JSON field has an unexpected type (e.g. if
         *   the server responded with an unexpected value).
         */
        fun cardDisputeAcceptance(): Optional<CardDisputeAcceptance> =
            cardDisputeAcceptance.getOptional("card_dispute_acceptance")

        /**
         * A Card Dispute Loss object. This field will be present in the JSON response if and only
         * if `category` is equal to `card_dispute_loss`. Contains the details of a lost Card
         * Dispute.
         *
         * @throws IncreaseInvalidDataException if the JSON field has an unexpected type (e.g. if
         *   the server responded with an unexpected value).
         */
        fun cardDisputeLoss(): Optional<CardDisputeLoss> =
            cardDisputeLoss.getOptional("card_dispute_loss")

        /**
         * A Card Push Transfer Acceptance object. This field will be present in the JSON response
         * if and only if `category` is equal to `card_push_transfer_acceptance`. A Card Push
         * Transfer Acceptance is created when an Outbound Card Push Transfer sent from Increase is
         * accepted by the receiving bank.
         *
         * @throws IncreaseInvalidDataException if the JSON field has an unexpected type (e.g. if
         *   the server responded with an unexpected value).
         */
        fun cardPushTransferAcceptance(): Optional<CardPushTransferAcceptance> =
            cardPushTransferAcceptance.getOptional("card_push_transfer_acceptance")

        /**
         * A Card Refund object. This field will be present in the JSON response if and only if
         * `category` is equal to `card_refund`. Card Refunds move money back to the cardholder.
         * While they are usually connected to a Card Settlement an acquirer can also refund money
         * directly to a card without relation to a transaction.
         *
         * @throws IncreaseInvalidDataException if the JSON field has an unexpected type (e.g. if
         *   the server responded with an unexpected value).
         */
        fun cardRefund(): Optional<CardRefund> = cardRefund.getOptional("card_refund")

        /**
         * A Card Revenue Payment object. This field will be present in the JSON response if and
         * only if `category` is equal to `card_revenue_payment`. Card Revenue Payments reflect
         * earnings from fees on card transactions.
         *
         * @throws IncreaseInvalidDataException if the JSON field has an unexpected type (e.g. if
         *   the server responded with an unexpected value).
         */
        fun cardRevenuePayment(): Optional<CardRevenuePayment> =
            cardRevenuePayment.getOptional("card_revenue_payment")

        /**
         * A Card Settlement object. This field will be present in the JSON response if and only if
         * `category` is equal to `card_settlement`. Card Settlements are card transactions that
         * have cleared and settled. While a settlement is usually preceded by an authorization, an
         * acquirer can also directly clear a transaction without first authorizing it.
         *
         * @throws IncreaseInvalidDataException if the JSON field has an unexpected type (e.g. if
         *   the server responded with an unexpected value).
         */
        fun cardSettlement(): Optional<CardSettlement> =
            cardSettlement.getOptional("card_settlement")

        /**
         * A Cashback Payment object. This field will be present in the JSON response if and only if
         * `category` is equal to `cashback_payment`. A Cashback Payment represents the cashback
         * paid to a cardholder for a given period. Cashback is usually paid monthly for the prior
         * month's transactions.
         *
         * @throws IncreaseInvalidDataException if the JSON field has an unexpected type (e.g. if
         *   the server responded with an unexpected value).
         */
        fun cashbackPayment(): Optional<CashbackPayment> =
            cashbackPayment.getOptional("cashback_payment")

        /**
         * The type of the resource. We may add additional possible values for this enum over time;
         * your application should be able to handle such additions gracefully.
         *
         * @throws IncreaseInvalidDataException if the JSON field has an unexpected type or is
         *   unexpectedly missing or null (e.g. if the server responded with an unexpected value).
         */
        fun category(): Category = category.getRequired("category")

        /**
         * A Check Deposit Acceptance object. This field will be present in the JSON response if and
         * only if `category` is equal to `check_deposit_acceptance`. A Check Deposit Acceptance is
         * created when a Check Deposit is processed and its details confirmed. Check Deposits may
         * be returned by the receiving bank, which will appear as a Check Deposit Return.
         *
         * @throws IncreaseInvalidDataException if the JSON field has an unexpected type (e.g. if
         *   the server responded with an unexpected value).
         */
        fun checkDepositAcceptance(): Optional<CheckDepositAcceptance> =
            checkDepositAcceptance.getOptional("check_deposit_acceptance")

        /**
         * A Check Deposit Return object. This field will be present in the JSON response if and
         * only if `category` is equal to `check_deposit_return`. A Check Deposit Return is created
         * when a Check Deposit is returned by the bank holding the account it was drawn against.
         * Check Deposits may be returned for a variety of reasons, including insufficient funds or
         * a mismatched account number. Usually, checks are returned within the first 7 days after
         * the deposit is made.
         *
         * @throws IncreaseInvalidDataException if the JSON field has an unexpected type (e.g. if
         *   the server responded with an unexpected value).
         */
        fun checkDepositReturn(): Optional<CheckDepositReturn> =
            checkDepositReturn.getOptional("check_deposit_return")

        /**
         * A Check Transfer Deposit object. This field will be present in the JSON response if and
         * only if `category` is equal to `check_transfer_deposit`. An Inbound Check is a check
         * drawn on an Increase account that has been deposited by an external bank account. These
         * types of checks are not pre-registered.
         *
         * @throws IncreaseInvalidDataException if the JSON field has an unexpected type (e.g. if
         *   the server responded with an unexpected value).
         */
        fun checkTransferDeposit(): Optional<CheckTransferDeposit> =
            checkTransferDeposit.getOptional("check_transfer_deposit")

        /**
         * A Fee Payment object. This field will be present in the JSON response if and only if
         * `category` is equal to `fee_payment`. A Fee Payment represents a payment made to
         * Increase.
         *
         * @throws IncreaseInvalidDataException if the JSON field has an unexpected type (e.g. if
         *   the server responded with an unexpected value).
         */
        fun feePayment(): Optional<FeePayment> = feePayment.getOptional("fee_payment")

        /**
         * An Inbound ACH Transfer Intention object. This field will be present in the JSON response
         * if and only if `category` is equal to `inbound_ach_transfer`. An Inbound ACH Transfer
         * Intention is created when an ACH transfer is initiated at another bank and received by
         * Increase.
         *
         * @throws IncreaseInvalidDataException if the JSON field has an unexpected type (e.g. if
         *   the server responded with an unexpected value).
         */
        fun inboundAchTransfer(): Optional<InboundAchTransfer> =
            inboundAchTransfer.getOptional("inbound_ach_transfer")

        /**
         * An Inbound ACH Transfer Return Intention object. This field will be present in the JSON
         * response if and only if `category` is equal to `inbound_ach_transfer_return_intention`.
         * An Inbound ACH Transfer Return Intention is created when an ACH transfer is initiated at
         * another bank and returned by Increase.
         *
         * @throws IncreaseInvalidDataException if the JSON field has an unexpected type (e.g. if
         *   the server responded with an unexpected value).
         */
        fun inboundAchTransferReturnIntention(): Optional<InboundAchTransferReturnIntention> =
            inboundAchTransferReturnIntention.getOptional("inbound_ach_transfer_return_intention")

        /**
         * An Inbound Check Adjustment object. This field will be present in the JSON response if
         * and only if `category` is equal to `inbound_check_adjustment`. An Inbound Check
         * Adjustment is created when Increase receives an adjustment for a check or return
         * deposited through Check21.
         *
         * @throws IncreaseInvalidDataException if the JSON field has an unexpected type (e.g. if
         *   the server responded with an unexpected value).
         */
        fun inboundCheckAdjustment(): Optional<InboundCheckAdjustment> =
            inboundCheckAdjustment.getOptional("inbound_check_adjustment")

        /**
         * An Inbound Check Deposit Return Intention object. This field will be present in the JSON
         * response if and only if `category` is equal to `inbound_check_deposit_return_intention`.
         * An Inbound Check Deposit Return Intention is created when Increase receives an Inbound
         * Check and the User requests that it be returned.
         *
         * @throws IncreaseInvalidDataException if the JSON field has an unexpected type (e.g. if
         *   the server responded with an unexpected value).
         */
        fun inboundCheckDepositReturnIntention(): Optional<InboundCheckDepositReturnIntention> =
            inboundCheckDepositReturnIntention.getOptional("inbound_check_deposit_return_intention")

        /**
         * An Inbound Real-Time Payments Transfer Confirmation object. This field will be present in
         * the JSON response if and only if `category` is equal to
         * `inbound_real_time_payments_transfer_confirmation`. An Inbound Real-Time Payments
         * Transfer Confirmation is created when a Real-Time Payments transfer is initiated at
         * another bank and received by Increase.
         *
         * @throws IncreaseInvalidDataException if the JSON field has an unexpected type (e.g. if
         *   the server responded with an unexpected value).
         */
        fun inboundRealTimePaymentsTransferConfirmation():
            Optional<InboundRealTimePaymentsTransferConfirmation> =
            inboundRealTimePaymentsTransferConfirmation.getOptional(
                "inbound_real_time_payments_transfer_confirmation"
            )

        /**
         * An Inbound Real-Time Payments Transfer Decline object. This field will be present in the
         * JSON response if and only if `category` is equal to
         * `inbound_real_time_payments_transfer_decline`.
         *
         * @throws IncreaseInvalidDataException if the JSON field has an unexpected type (e.g. if
         *   the server responded with an unexpected value).
         */
        fun inboundRealTimePaymentsTransferDecline():
            Optional<InboundRealTimePaymentsTransferDecline> =
            inboundRealTimePaymentsTransferDecline.getOptional(
                "inbound_real_time_payments_transfer_decline"
            )

        /**
         * An Inbound Wire Reversal object. This field will be present in the JSON response if and
         * only if `category` is equal to `inbound_wire_reversal`. An Inbound Wire Reversal
         * represents a reversal of a wire transfer that was initiated via Increase. The other bank
         * is sending the money back. This most often happens when the original destination account
         * details were incorrect.
         *
         * @throws IncreaseInvalidDataException if the JSON field has an unexpected type (e.g. if
         *   the server responded with an unexpected value).
         */
        fun inboundWireReversal(): Optional<InboundWireReversal> =
            inboundWireReversal.getOptional("inbound_wire_reversal")

        /**
         * An Inbound Wire Transfer Intention object. This field will be present in the JSON
         * response if and only if `category` is equal to `inbound_wire_transfer`. An Inbound Wire
         * Transfer Intention is created when a wire transfer is initiated at another bank and
         * received by Increase.
         *
         * @throws IncreaseInvalidDataException if the JSON field has an unexpected type (e.g. if
         *   the server responded with an unexpected value).
         */
        fun inboundWireTransfer(): Optional<InboundWireTransfer> =
            inboundWireTransfer.getOptional("inbound_wire_transfer")

        /**
         * An Inbound Wire Transfer Reversal Intention object. This field will be present in the
         * JSON response if and only if `category` is equal to `inbound_wire_transfer_reversal`. An
         * Inbound Wire Transfer Reversal Intention is created when Increase has received a wire and
         * the User requests that it be reversed.
         *
         * @throws IncreaseInvalidDataException if the JSON field has an unexpected type (e.g. if
         *   the server responded with an unexpected value).
         */
        fun inboundWireTransferReversal(): Optional<InboundWireTransferReversal> =
            inboundWireTransferReversal.getOptional("inbound_wire_transfer_reversal")

        /**
         * An Interest Payment object. This field will be present in the JSON response if and only
         * if `category` is equal to `interest_payment`. An Interest Payment represents a payment of
         * interest on an account. Interest is usually paid monthly.
         *
         * @throws IncreaseInvalidDataException if the JSON field has an unexpected type (e.g. if
         *   the server responded with an unexpected value).
         */
        fun interestPayment(): Optional<InterestPayment> =
            interestPayment.getOptional("interest_payment")

        /**
         * An Internal Source object. This field will be present in the JSON response if and only if
         * `category` is equal to `internal_source`. A transaction between the user and Increase.
         * See the `reason` attribute for more information.
         *
         * @throws IncreaseInvalidDataException if the JSON field has an unexpected type (e.g. if
         *   the server responded with an unexpected value).
         */
        fun internalSource(): Optional<InternalSource> =
            internalSource.getOptional("internal_source")

        /**
         * If the category of this Transaction source is equal to `other`, this field will contain
         * an empty object, otherwise it will contain null.
         */
        @JsonProperty("other") @ExcludeMissing fun _other(): JsonValue = other

        /**
         * A Real-Time Payments Transfer Acknowledgement object. This field will be present in the
         * JSON response if and only if `category` is equal to
         * `real_time_payments_transfer_acknowledgement`. A Real-Time Payments Transfer
         * Acknowledgement is created when a Real-Time Payments Transfer sent from Increase is
         * acknowledged by the receiving bank.
         *
         * @throws IncreaseInvalidDataException if the JSON field has an unexpected type (e.g. if
         *   the server responded with an unexpected value).
         */
        fun realTimePaymentsTransferAcknowledgement():
            Optional<RealTimePaymentsTransferAcknowledgement> =
            realTimePaymentsTransferAcknowledgement.getOptional(
                "real_time_payments_transfer_acknowledgement"
            )

        /**
         * A Sample Funds object. This field will be present in the JSON response if and only if
         * `category` is equal to `sample_funds`. Sample funds for testing purposes.
         *
         * @throws IncreaseInvalidDataException if the JSON field has an unexpected type (e.g. if
         *   the server responded with an unexpected value).
         */
        fun sampleFunds(): Optional<SampleFunds> = sampleFunds.getOptional("sample_funds")

        /**
         * A Swift Transfer Intention object. This field will be present in the JSON response if and
         * only if `category` is equal to `swift_transfer_intention`. A Swift Transfer initiated via
         * Increase.
         *
         * @throws IncreaseInvalidDataException if the JSON field has an unexpected type (e.g. if
         *   the server responded with an unexpected value).
         */
        fun swiftTransferIntention(): Optional<SwiftTransferIntention> =
            swiftTransferIntention.getOptional("swift_transfer_intention")

        /**
         * A Wire Transfer Intention object. This field will be present in the JSON response if and
         * only if `category` is equal to `wire_transfer_intention`. A Wire Transfer initiated via
         * Increase and sent to a different bank.
         *
         * @throws IncreaseInvalidDataException if the JSON field has an unexpected type (e.g. if
         *   the server responded with an unexpected value).
         */
        fun wireTransferIntention(): Optional<WireTransferIntention> =
            wireTransferIntention.getOptional("wire_transfer_intention")

        /**
         * Returns the raw JSON value of [accountTransferIntention].
         *
         * Unlike [accountTransferIntention], this method doesn't throw if the JSON field has an
         * unexpected type.
         */
        @JsonProperty("account_transfer_intention")
        @ExcludeMissing
        fun _accountTransferIntention(): JsonField<AccountTransferIntention> =
            accountTransferIntention

        /**
         * Returns the raw JSON value of [achTransferIntention].
         *
         * Unlike [achTransferIntention], this method doesn't throw if the JSON field has an
         * unexpected type.
         */
        @JsonProperty("ach_transfer_intention")
        @ExcludeMissing
        fun _achTransferIntention(): JsonField<AchTransferIntention> = achTransferIntention

        /**
         * Returns the raw JSON value of [achTransferRejection].
         *
         * Unlike [achTransferRejection], this method doesn't throw if the JSON field has an
         * unexpected type.
         */
        @JsonProperty("ach_transfer_rejection")
        @ExcludeMissing
        fun _achTransferRejection(): JsonField<AchTransferRejection> = achTransferRejection

        /**
         * Returns the raw JSON value of [achTransferReturn].
         *
         * Unlike [achTransferReturn], this method doesn't throw if the JSON field has an unexpected
         * type.
         */
        @JsonProperty("ach_transfer_return")
        @ExcludeMissing
        fun _achTransferReturn(): JsonField<AchTransferReturn> = achTransferReturn

        /**
         * Returns the raw JSON value of [cardDisputeAcceptance].
         *
         * Unlike [cardDisputeAcceptance], this method doesn't throw if the JSON field has an
         * unexpected type.
         */
        @JsonProperty("card_dispute_acceptance")
        @ExcludeMissing
        fun _cardDisputeAcceptance(): JsonField<CardDisputeAcceptance> = cardDisputeAcceptance

        /**
         * Returns the raw JSON value of [cardDisputeLoss].
         *
         * Unlike [cardDisputeLoss], this method doesn't throw if the JSON field has an unexpected
         * type.
         */
        @JsonProperty("card_dispute_loss")
        @ExcludeMissing
        fun _cardDisputeLoss(): JsonField<CardDisputeLoss> = cardDisputeLoss

        /**
         * Returns the raw JSON value of [cardPushTransferAcceptance].
         *
         * Unlike [cardPushTransferAcceptance], this method doesn't throw if the JSON field has an
         * unexpected type.
         */
        @JsonProperty("card_push_transfer_acceptance")
        @ExcludeMissing
        fun _cardPushTransferAcceptance(): JsonField<CardPushTransferAcceptance> =
            cardPushTransferAcceptance

        /**
         * Returns the raw JSON value of [cardRefund].
         *
         * Unlike [cardRefund], this method doesn't throw if the JSON field has an unexpected type.
         */
        @JsonProperty("card_refund")
        @ExcludeMissing
        fun _cardRefund(): JsonField<CardRefund> = cardRefund

        /**
         * Returns the raw JSON value of [cardRevenuePayment].
         *
         * Unlike [cardRevenuePayment], this method doesn't throw if the JSON field has an
         * unexpected type.
         */
        @JsonProperty("card_revenue_payment")
        @ExcludeMissing
        fun _cardRevenuePayment(): JsonField<CardRevenuePayment> = cardRevenuePayment

        /**
         * Returns the raw JSON value of [cardSettlement].
         *
         * Unlike [cardSettlement], this method doesn't throw if the JSON field has an unexpected
         * type.
         */
        @JsonProperty("card_settlement")
        @ExcludeMissing
        fun _cardSettlement(): JsonField<CardSettlement> = cardSettlement

        /**
         * Returns the raw JSON value of [cashbackPayment].
         *
         * Unlike [cashbackPayment], this method doesn't throw if the JSON field has an unexpected
         * type.
         */
        @JsonProperty("cashback_payment")
        @ExcludeMissing
        fun _cashbackPayment(): JsonField<CashbackPayment> = cashbackPayment

        /**
         * Returns the raw JSON value of [category].
         *
         * Unlike [category], this method doesn't throw if the JSON field has an unexpected type.
         */
        @JsonProperty("category") @ExcludeMissing fun _category(): JsonField<Category> = category

        /**
         * Returns the raw JSON value of [checkDepositAcceptance].
         *
         * Unlike [checkDepositAcceptance], this method doesn't throw if the JSON field has an
         * unexpected type.
         */
        @JsonProperty("check_deposit_acceptance")
        @ExcludeMissing
        fun _checkDepositAcceptance(): JsonField<CheckDepositAcceptance> = checkDepositAcceptance

        /**
         * Returns the raw JSON value of [checkDepositReturn].
         *
         * Unlike [checkDepositReturn], this method doesn't throw if the JSON field has an
         * unexpected type.
         */
        @JsonProperty("check_deposit_return")
        @ExcludeMissing
        fun _checkDepositReturn(): JsonField<CheckDepositReturn> = checkDepositReturn

        /**
         * Returns the raw JSON value of [checkTransferDeposit].
         *
         * Unlike [checkTransferDeposit], this method doesn't throw if the JSON field has an
         * unexpected type.
         */
        @JsonProperty("check_transfer_deposit")
        @ExcludeMissing
        fun _checkTransferDeposit(): JsonField<CheckTransferDeposit> = checkTransferDeposit

        /**
         * Returns the raw JSON value of [feePayment].
         *
         * Unlike [feePayment], this method doesn't throw if the JSON field has an unexpected type.
         */
        @JsonProperty("fee_payment")
        @ExcludeMissing
        fun _feePayment(): JsonField<FeePayment> = feePayment

        /**
         * Returns the raw JSON value of [inboundAchTransfer].
         *
         * Unlike [inboundAchTransfer], this method doesn't throw if the JSON field has an
         * unexpected type.
         */
        @JsonProperty("inbound_ach_transfer")
        @ExcludeMissing
        fun _inboundAchTransfer(): JsonField<InboundAchTransfer> = inboundAchTransfer

        /**
         * Returns the raw JSON value of [inboundAchTransferReturnIntention].
         *
         * Unlike [inboundAchTransferReturnIntention], this method doesn't throw if the JSON field
         * has an unexpected type.
         */
        @JsonProperty("inbound_ach_transfer_return_intention")
        @ExcludeMissing
        fun _inboundAchTransferReturnIntention(): JsonField<InboundAchTransferReturnIntention> =
            inboundAchTransferReturnIntention

        /**
         * Returns the raw JSON value of [inboundCheckAdjustment].
         *
         * Unlike [inboundCheckAdjustment], this method doesn't throw if the JSON field has an
         * unexpected type.
         */
        @JsonProperty("inbound_check_adjustment")
        @ExcludeMissing
        fun _inboundCheckAdjustment(): JsonField<InboundCheckAdjustment> = inboundCheckAdjustment

        /**
         * Returns the raw JSON value of [inboundCheckDepositReturnIntention].
         *
         * Unlike [inboundCheckDepositReturnIntention], this method doesn't throw if the JSON field
         * has an unexpected type.
         */
        @JsonProperty("inbound_check_deposit_return_intention")
        @ExcludeMissing
        fun _inboundCheckDepositReturnIntention(): JsonField<InboundCheckDepositReturnIntention> =
            inboundCheckDepositReturnIntention

        /**
         * Returns the raw JSON value of [inboundRealTimePaymentsTransferConfirmation].
         *
         * Unlike [inboundRealTimePaymentsTransferConfirmation], this method doesn't throw if the
         * JSON field has an unexpected type.
         */
        @JsonProperty("inbound_real_time_payments_transfer_confirmation")
        @ExcludeMissing
        fun _inboundRealTimePaymentsTransferConfirmation():
            JsonField<InboundRealTimePaymentsTransferConfirmation> =
            inboundRealTimePaymentsTransferConfirmation

        /**
         * Returns the raw JSON value of [inboundRealTimePaymentsTransferDecline].
         *
         * Unlike [inboundRealTimePaymentsTransferDecline], this method doesn't throw if the JSON
         * field has an unexpected type.
         */
        @JsonProperty("inbound_real_time_payments_transfer_decline")
        @ExcludeMissing
        fun _inboundRealTimePaymentsTransferDecline():
            JsonField<InboundRealTimePaymentsTransferDecline> =
            inboundRealTimePaymentsTransferDecline

        /**
         * Returns the raw JSON value of [inboundWireReversal].
         *
         * Unlike [inboundWireReversal], this method doesn't throw if the JSON field has an
         * unexpected type.
         */
        @JsonProperty("inbound_wire_reversal")
        @ExcludeMissing
        fun _inboundWireReversal(): JsonField<InboundWireReversal> = inboundWireReversal

        /**
         * Returns the raw JSON value of [inboundWireTransfer].
         *
         * Unlike [inboundWireTransfer], this method doesn't throw if the JSON field has an
         * unexpected type.
         */
        @JsonProperty("inbound_wire_transfer")
        @ExcludeMissing
        fun _inboundWireTransfer(): JsonField<InboundWireTransfer> = inboundWireTransfer

        /**
         * Returns the raw JSON value of [inboundWireTransferReversal].
         *
         * Unlike [inboundWireTransferReversal], this method doesn't throw if the JSON field has an
         * unexpected type.
         */
        @JsonProperty("inbound_wire_transfer_reversal")
        @ExcludeMissing
        fun _inboundWireTransferReversal(): JsonField<InboundWireTransferReversal> =
            inboundWireTransferReversal

        /**
         * Returns the raw JSON value of [interestPayment].
         *
         * Unlike [interestPayment], this method doesn't throw if the JSON field has an unexpected
         * type.
         */
        @JsonProperty("interest_payment")
        @ExcludeMissing
        fun _interestPayment(): JsonField<InterestPayment> = interestPayment

        /**
         * Returns the raw JSON value of [internalSource].
         *
         * Unlike [internalSource], this method doesn't throw if the JSON field has an unexpected
         * type.
         */
        @JsonProperty("internal_source")
        @ExcludeMissing
        fun _internalSource(): JsonField<InternalSource> = internalSource

        /**
         * Returns the raw JSON value of [realTimePaymentsTransferAcknowledgement].
         *
         * Unlike [realTimePaymentsTransferAcknowledgement], this method doesn't throw if the JSON
         * field has an unexpected type.
         */
        @JsonProperty("real_time_payments_transfer_acknowledgement")
        @ExcludeMissing
        fun _realTimePaymentsTransferAcknowledgement():
            JsonField<RealTimePaymentsTransferAcknowledgement> =
            realTimePaymentsTransferAcknowledgement

        /**
         * Returns the raw JSON value of [sampleFunds].
         *
         * Unlike [sampleFunds], this method doesn't throw if the JSON field has an unexpected type.
         */
        @JsonProperty("sample_funds")
        @ExcludeMissing
        fun _sampleFunds(): JsonField<SampleFunds> = sampleFunds

        /**
         * Returns the raw JSON value of [swiftTransferIntention].
         *
         * Unlike [swiftTransferIntention], this method doesn't throw if the JSON field has an
         * unexpected type.
         */
        @JsonProperty("swift_transfer_intention")
        @ExcludeMissing
        fun _swiftTransferIntention(): JsonField<SwiftTransferIntention> = swiftTransferIntention

        /**
         * Returns the raw JSON value of [wireTransferIntention].
         *
         * Unlike [wireTransferIntention], this method doesn't throw if the JSON field has an
         * unexpected type.
         */
        @JsonProperty("wire_transfer_intention")
        @ExcludeMissing
        fun _wireTransferIntention(): JsonField<WireTransferIntention> = wireTransferIntention

        @JsonAnySetter
        private fun putAdditionalProperty(key: String, value: JsonValue) {
            additionalProperties.put(key, value)
        }

        @JsonAnyGetter
        @ExcludeMissing
        fun _additionalProperties(): Map<String, JsonValue> =
            Collections.unmodifiableMap(additionalProperties)

        fun toBuilder() = Builder().from(this)

        companion object {

            /**
             * Returns a mutable builder for constructing an instance of [Source].
             *
             * The following fields are required:
             * ```java
             * .accountTransferIntention()
             * .achTransferIntention()
             * .achTransferRejection()
             * .achTransferReturn()
             * .cardDisputeAcceptance()
             * .cardDisputeLoss()
             * .cardPushTransferAcceptance()
             * .cardRefund()
             * .cardRevenuePayment()
             * .cardSettlement()
             * .cashbackPayment()
             * .category()
             * .checkDepositAcceptance()
             * .checkDepositReturn()
             * .checkTransferDeposit()
             * .feePayment()
             * .inboundAchTransfer()
             * .inboundAchTransferReturnIntention()
             * .inboundCheckAdjustment()
             * .inboundCheckDepositReturnIntention()
             * .inboundRealTimePaymentsTransferConfirmation()
             * .inboundRealTimePaymentsTransferDecline()
             * .inboundWireReversal()
             * .inboundWireTransfer()
             * .inboundWireTransferReversal()
             * .interestPayment()
             * .internalSource()
             * .other()
             * .realTimePaymentsTransferAcknowledgement()
             * .sampleFunds()
             * .swiftTransferIntention()
             * .wireTransferIntention()
             * ```
             */
            @JvmStatic fun builder() = Builder()
        }

        /** A builder for [Source]. */
        class Builder internal constructor() {

            private var accountTransferIntention: JsonField<AccountTransferIntention>? = null
            private var achTransferIntention: JsonField<AchTransferIntention>? = null
            private var achTransferRejection: JsonField<AchTransferRejection>? = null
            private var achTransferReturn: JsonField<AchTransferReturn>? = null
            private var cardDisputeAcceptance: JsonField<CardDisputeAcceptance>? = null
            private var cardDisputeLoss: JsonField<CardDisputeLoss>? = null
            private var cardPushTransferAcceptance: JsonField<CardPushTransferAcceptance>? = null
            private var cardRefund: JsonField<CardRefund>? = null
            private var cardRevenuePayment: JsonField<CardRevenuePayment>? = null
            private var cardSettlement: JsonField<CardSettlement>? = null
            private var cashbackPayment: JsonField<CashbackPayment>? = null
            private var category: JsonField<Category>? = null
            private var checkDepositAcceptance: JsonField<CheckDepositAcceptance>? = null
            private var checkDepositReturn: JsonField<CheckDepositReturn>? = null
            private var checkTransferDeposit: JsonField<CheckTransferDeposit>? = null
            private var feePayment: JsonField<FeePayment>? = null
            private var inboundAchTransfer: JsonField<InboundAchTransfer>? = null
            private var inboundAchTransferReturnIntention:
                JsonField<InboundAchTransferReturnIntention>? =
                null
            private var inboundCheckAdjustment: JsonField<InboundCheckAdjustment>? = null
            private var inboundCheckDepositReturnIntention:
                JsonField<InboundCheckDepositReturnIntention>? =
                null
            private var inboundRealTimePaymentsTransferConfirmation:
                JsonField<InboundRealTimePaymentsTransferConfirmation>? =
                null
            private var inboundRealTimePaymentsTransferDecline:
                JsonField<InboundRealTimePaymentsTransferDecline>? =
                null
            private var inboundWireReversal: JsonField<InboundWireReversal>? = null
            private var inboundWireTransfer: JsonField<InboundWireTransfer>? = null
            private var inboundWireTransferReversal: JsonField<InboundWireTransferReversal>? = null
            private var interestPayment: JsonField<InterestPayment>? = null
            private var internalSource: JsonField<InternalSource>? = null
            private var other: JsonValue? = null
            private var realTimePaymentsTransferAcknowledgement:
                JsonField<RealTimePaymentsTransferAcknowledgement>? =
                null
            private var sampleFunds: JsonField<SampleFunds>? = null
            private var swiftTransferIntention: JsonField<SwiftTransferIntention>? = null
            private var wireTransferIntention: JsonField<WireTransferIntention>? = null
            private var additionalProperties: MutableMap<String, JsonValue> = mutableMapOf()

            @JvmSynthetic
            internal fun from(source: Source) = apply {
                accountTransferIntention = source.accountTransferIntention
                achTransferIntention = source.achTransferIntention
                achTransferRejection = source.achTransferRejection
                achTransferReturn = source.achTransferReturn
                cardDisputeAcceptance = source.cardDisputeAcceptance
                cardDisputeLoss = source.cardDisputeLoss
                cardPushTransferAcceptance = source.cardPushTransferAcceptance
                cardRefund = source.cardRefund
                cardRevenuePayment = source.cardRevenuePayment
                cardSettlement = source.cardSettlement
                cashbackPayment = source.cashbackPayment
                category = source.category
                checkDepositAcceptance = source.checkDepositAcceptance
                checkDepositReturn = source.checkDepositReturn
                checkTransferDeposit = source.checkTransferDeposit
                feePayment = source.feePayment
                inboundAchTransfer = source.inboundAchTransfer
                inboundAchTransferReturnIntention = source.inboundAchTransferReturnIntention
                inboundCheckAdjustment = source.inboundCheckAdjustment
                inboundCheckDepositReturnIntention = source.inboundCheckDepositReturnIntention
                inboundRealTimePaymentsTransferConfirmation =
                    source.inboundRealTimePaymentsTransferConfirmation
                inboundRealTimePaymentsTransferDecline =
                    source.inboundRealTimePaymentsTransferDecline
                inboundWireReversal = source.inboundWireReversal
                inboundWireTransfer = source.inboundWireTransfer
                inboundWireTransferReversal = source.inboundWireTransferReversal
                interestPayment = source.interestPayment
                internalSource = source.internalSource
                other = source.other
                realTimePaymentsTransferAcknowledgement =
                    source.realTimePaymentsTransferAcknowledgement
                sampleFunds = source.sampleFunds
                swiftTransferIntention = source.swiftTransferIntention
                wireTransferIntention = source.wireTransferIntention
                additionalProperties = source.additionalProperties.toMutableMap()
            }

            /**
             * An Account Transfer Intention object. This field will be present in the JSON response
             * if and only if `category` is equal to `account_transfer_intention`. Two Account
             * Transfer Intentions are created from each Account Transfer. One decrements the source
             * account, and the other increments the destination account.
             */
            fun accountTransferIntention(accountTransferIntention: AccountTransferIntention?) =
                accountTransferIntention(JsonField.ofNullable(accountTransferIntention))

            /**
             * Alias for calling [Builder.accountTransferIntention] with
             * `accountTransferIntention.orElse(null)`.
             */
            fun accountTransferIntention(
                accountTransferIntention: Optional<AccountTransferIntention>
            ) = accountTransferIntention(accountTransferIntention.getOrNull())

            /**
             * Sets [Builder.accountTransferIntention] to an arbitrary JSON value.
             *
             * You should usually call [Builder.accountTransferIntention] with a well-typed
             * [AccountTransferIntention] value instead. This method is primarily for setting the
             * field to an undocumented or not yet supported value.
             */
            fun accountTransferIntention(
                accountTransferIntention: JsonField<AccountTransferIntention>
            ) = apply { this.accountTransferIntention = accountTransferIntention }

            /**
             * An ACH Transfer Intention object. This field will be present in the JSON response if
             * and only if `category` is equal to `ach_transfer_intention`. An ACH Transfer
             * Intention is created from an ACH Transfer. It reflects the intention to move money
             * into or out of an Increase account via the ACH network.
             */
            fun achTransferIntention(achTransferIntention: AchTransferIntention?) =
                achTransferIntention(JsonField.ofNullable(achTransferIntention))

            /**
             * Alias for calling [Builder.achTransferIntention] with
             * `achTransferIntention.orElse(null)`.
             */
            fun achTransferIntention(achTransferIntention: Optional<AchTransferIntention>) =
                achTransferIntention(achTransferIntention.getOrNull())

            /**
             * Sets [Builder.achTransferIntention] to an arbitrary JSON value.
             *
             * You should usually call [Builder.achTransferIntention] with a well-typed
             * [AchTransferIntention] value instead. This method is primarily for setting the field
             * to an undocumented or not yet supported value.
             */
            fun achTransferIntention(achTransferIntention: JsonField<AchTransferIntention>) =
                apply {
                    this.achTransferIntention = achTransferIntention
                }

            /**
             * An ACH Transfer Rejection object. This field will be present in the JSON response if
             * and only if `category` is equal to `ach_transfer_rejection`. An ACH Transfer
             * Rejection is created when an ACH Transfer is rejected by Increase. It offsets the ACH
             * Transfer Intention. These rejections are rare.
             */
            fun achTransferRejection(achTransferRejection: AchTransferRejection?) =
                achTransferRejection(JsonField.ofNullable(achTransferRejection))

            /**
             * Alias for calling [Builder.achTransferRejection] with
             * `achTransferRejection.orElse(null)`.
             */
            fun achTransferRejection(achTransferRejection: Optional<AchTransferRejection>) =
                achTransferRejection(achTransferRejection.getOrNull())

            /**
             * Sets [Builder.achTransferRejection] to an arbitrary JSON value.
             *
             * You should usually call [Builder.achTransferRejection] with a well-typed
             * [AchTransferRejection] value instead. This method is primarily for setting the field
             * to an undocumented or not yet supported value.
             */
            fun achTransferRejection(achTransferRejection: JsonField<AchTransferRejection>) =
                apply {
                    this.achTransferRejection = achTransferRejection
                }

            /**
             * An ACH Transfer Return object. This field will be present in the JSON response if and
             * only if `category` is equal to `ach_transfer_return`. An ACH Transfer Return is
             * created when an ACH Transfer is returned by the receiving bank. It offsets the ACH
             * Transfer Intention. ACH Transfer Returns usually occur within the first two business
             * days after the transfer is initiated, but can occur much later.
             */
            fun achTransferReturn(achTransferReturn: AchTransferReturn?) =
                achTransferReturn(JsonField.ofNullable(achTransferReturn))

            /**
             * Alias for calling [Builder.achTransferReturn] with `achTransferReturn.orElse(null)`.
             */
            fun achTransferReturn(achTransferReturn: Optional<AchTransferReturn>) =
                achTransferReturn(achTransferReturn.getOrNull())

            /**
             * Sets [Builder.achTransferReturn] to an arbitrary JSON value.
             *
             * You should usually call [Builder.achTransferReturn] with a well-typed
             * [AchTransferReturn] value instead. This method is primarily for setting the field to
             * an undocumented or not yet supported value.
             */
            fun achTransferReturn(achTransferReturn: JsonField<AchTransferReturn>) = apply {
                this.achTransferReturn = achTransferReturn
            }

            /**
             * A Card Dispute Acceptance object. This field will be present in the JSON response if
             * and only if `category` is equal to `card_dispute_acceptance`. Contains the details of
             * a successful Card Dispute.
             */
            fun cardDisputeAcceptance(cardDisputeAcceptance: CardDisputeAcceptance?) =
                cardDisputeAcceptance(JsonField.ofNullable(cardDisputeAcceptance))

            /**
             * Alias for calling [Builder.cardDisputeAcceptance] with
             * `cardDisputeAcceptance.orElse(null)`.
             */
            fun cardDisputeAcceptance(cardDisputeAcceptance: Optional<CardDisputeAcceptance>) =
                cardDisputeAcceptance(cardDisputeAcceptance.getOrNull())

            /**
             * Sets [Builder.cardDisputeAcceptance] to an arbitrary JSON value.
             *
             * You should usually call [Builder.cardDisputeAcceptance] with a well-typed
             * [CardDisputeAcceptance] value instead. This method is primarily for setting the field
             * to an undocumented or not yet supported value.
             */
            fun cardDisputeAcceptance(cardDisputeAcceptance: JsonField<CardDisputeAcceptance>) =
                apply {
                    this.cardDisputeAcceptance = cardDisputeAcceptance
                }

            /**
             * A Card Dispute Loss object. This field will be present in the JSON response if and
             * only if `category` is equal to `card_dispute_loss`. Contains the details of a lost
             * Card Dispute.
             */
            fun cardDisputeLoss(cardDisputeLoss: CardDisputeLoss?) =
                cardDisputeLoss(JsonField.ofNullable(cardDisputeLoss))

            /** Alias for calling [Builder.cardDisputeLoss] with `cardDisputeLoss.orElse(null)`. */
            fun cardDisputeLoss(cardDisputeLoss: Optional<CardDisputeLoss>) =
                cardDisputeLoss(cardDisputeLoss.getOrNull())

            /**
             * Sets [Builder.cardDisputeLoss] to an arbitrary JSON value.
             *
             * You should usually call [Builder.cardDisputeLoss] with a well-typed [CardDisputeLoss]
             * value instead. This method is primarily for setting the field to an undocumented or
             * not yet supported value.
             */
            fun cardDisputeLoss(cardDisputeLoss: JsonField<CardDisputeLoss>) = apply {
                this.cardDisputeLoss = cardDisputeLoss
            }

            /**
             * A Card Push Transfer Acceptance object. This field will be present in the JSON
             * response if and only if `category` is equal to `card_push_transfer_acceptance`. A
             * Card Push Transfer Acceptance is created when an Outbound Card Push Transfer sent
             * from Increase is accepted by the receiving bank.
             */
            fun cardPushTransferAcceptance(
                cardPushTransferAcceptance: CardPushTransferAcceptance?
            ) = cardPushTransferAcceptance(JsonField.ofNullable(cardPushTransferAcceptance))

            /**
             * Alias for calling [Builder.cardPushTransferAcceptance] with
             * `cardPushTransferAcceptance.orElse(null)`.
             */
            fun cardPushTransferAcceptance(
                cardPushTransferAcceptance: Optional<CardPushTransferAcceptance>
            ) = cardPushTransferAcceptance(cardPushTransferAcceptance.getOrNull())

            /**
             * Sets [Builder.cardPushTransferAcceptance] to an arbitrary JSON value.
             *
             * You should usually call [Builder.cardPushTransferAcceptance] with a well-typed
             * [CardPushTransferAcceptance] value instead. This method is primarily for setting the
             * field to an undocumented or not yet supported value.
             */
            fun cardPushTransferAcceptance(
                cardPushTransferAcceptance: JsonField<CardPushTransferAcceptance>
            ) = apply { this.cardPushTransferAcceptance = cardPushTransferAcceptance }

            /**
             * A Card Refund object. This field will be present in the JSON response if and only if
             * `category` is equal to `card_refund`. Card Refunds move money back to the cardholder.
             * While they are usually connected to a Card Settlement an acquirer can also refund
             * money directly to a card without relation to a transaction.
             */
            fun cardRefund(cardRefund: CardRefund?) = cardRefund(JsonField.ofNullable(cardRefund))

            /** Alias for calling [Builder.cardRefund] with `cardRefund.orElse(null)`. */
            fun cardRefund(cardRefund: Optional<CardRefund>) = cardRefund(cardRefund.getOrNull())

            /**
             * Sets [Builder.cardRefund] to an arbitrary JSON value.
             *
             * You should usually call [Builder.cardRefund] with a well-typed [CardRefund] value
             * instead. This method is primarily for setting the field to an undocumented or not yet
             * supported value.
             */
            fun cardRefund(cardRefund: JsonField<CardRefund>) = apply {
                this.cardRefund = cardRefund
            }

            /**
             * A Card Revenue Payment object. This field will be present in the JSON response if and
             * only if `category` is equal to `card_revenue_payment`. Card Revenue Payments reflect
             * earnings from fees on card transactions.
             */
            fun cardRevenuePayment(cardRevenuePayment: CardRevenuePayment?) =
                cardRevenuePayment(JsonField.ofNullable(cardRevenuePayment))

            /**
             * Alias for calling [Builder.cardRevenuePayment] with
             * `cardRevenuePayment.orElse(null)`.
             */
            fun cardRevenuePayment(cardRevenuePayment: Optional<CardRevenuePayment>) =
                cardRevenuePayment(cardRevenuePayment.getOrNull())

            /**
             * Sets [Builder.cardRevenuePayment] to an arbitrary JSON value.
             *
             * You should usually call [Builder.cardRevenuePayment] with a well-typed
             * [CardRevenuePayment] value instead. This method is primarily for setting the field to
             * an undocumented or not yet supported value.
             */
            fun cardRevenuePayment(cardRevenuePayment: JsonField<CardRevenuePayment>) = apply {
                this.cardRevenuePayment = cardRevenuePayment
            }

            /**
             * A Card Settlement object. This field will be present in the JSON response if and only
             * if `category` is equal to `card_settlement`. Card Settlements are card transactions
             * that have cleared and settled. While a settlement is usually preceded by an
             * authorization, an acquirer can also directly clear a transaction without first
             * authorizing it.
             */
            fun cardSettlement(cardSettlement: CardSettlement?) =
                cardSettlement(JsonField.ofNullable(cardSettlement))

            /** Alias for calling [Builder.cardSettlement] with `cardSettlement.orElse(null)`. */
            fun cardSettlement(cardSettlement: Optional<CardSettlement>) =
                cardSettlement(cardSettlement.getOrNull())

            /**
             * Sets [Builder.cardSettlement] to an arbitrary JSON value.
             *
             * You should usually call [Builder.cardSettlement] with a well-typed [CardSettlement]
             * value instead. This method is primarily for setting the field to an undocumented or
             * not yet supported value.
             */
            fun cardSettlement(cardSettlement: JsonField<CardSettlement>) = apply {
                this.cardSettlement = cardSettlement
            }

            /**
             * A Cashback Payment object. This field will be present in the JSON response if and
             * only if `category` is equal to `cashback_payment`. A Cashback Payment represents the
             * cashback paid to a cardholder for a given period. Cashback is usually paid monthly
             * for the prior month's transactions.
             */
            fun cashbackPayment(cashbackPayment: CashbackPayment?) =
                cashbackPayment(JsonField.ofNullable(cashbackPayment))

            /** Alias for calling [Builder.cashbackPayment] with `cashbackPayment.orElse(null)`. */
            fun cashbackPayment(cashbackPayment: Optional<CashbackPayment>) =
                cashbackPayment(cashbackPayment.getOrNull())

            /**
             * Sets [Builder.cashbackPayment] to an arbitrary JSON value.
             *
             * You should usually call [Builder.cashbackPayment] with a well-typed [CashbackPayment]
             * value instead. This method is primarily for setting the field to an undocumented or
             * not yet supported value.
             */
            fun cashbackPayment(cashbackPayment: JsonField<CashbackPayment>) = apply {
                this.cashbackPayment = cashbackPayment
            }

            /**
             * The type of the resource. We may add additional possible values for this enum over
             * time; your application should be able to handle such additions gracefully.
             */
            fun category(category: Category) = category(JsonField.of(category))

            /**
             * Sets [Builder.category] to an arbitrary JSON value.
             *
             * You should usually call [Builder.category] with a well-typed [Category] value
             * instead. This method is primarily for setting the field to an undocumented or not yet
             * supported value.
             */
            fun category(category: JsonField<Category>) = apply { this.category = category }

            /**
             * A Check Deposit Acceptance object. This field will be present in the JSON response if
             * and only if `category` is equal to `check_deposit_acceptance`. A Check Deposit
             * Acceptance is created when a Check Deposit is processed and its details confirmed.
             * Check Deposits may be returned by the receiving bank, which will appear as a Check
             * Deposit Return.
             */
            fun checkDepositAcceptance(checkDepositAcceptance: CheckDepositAcceptance?) =
                checkDepositAcceptance(JsonField.ofNullable(checkDepositAcceptance))

            /**
             * Alias for calling [Builder.checkDepositAcceptance] with
             * `checkDepositAcceptance.orElse(null)`.
             */
            fun checkDepositAcceptance(checkDepositAcceptance: Optional<CheckDepositAcceptance>) =
                checkDepositAcceptance(checkDepositAcceptance.getOrNull())

            /**
             * Sets [Builder.checkDepositAcceptance] to an arbitrary JSON value.
             *
             * You should usually call [Builder.checkDepositAcceptance] with a well-typed
             * [CheckDepositAcceptance] value instead. This method is primarily for setting the
             * field to an undocumented or not yet supported value.
             */
            fun checkDepositAcceptance(checkDepositAcceptance: JsonField<CheckDepositAcceptance>) =
                apply {
                    this.checkDepositAcceptance = checkDepositAcceptance
                }

            /**
             * A Check Deposit Return object. This field will be present in the JSON response if and
             * only if `category` is equal to `check_deposit_return`. A Check Deposit Return is
             * created when a Check Deposit is returned by the bank holding the account it was drawn
             * against. Check Deposits may be returned for a variety of reasons, including
             * insufficient funds or a mismatched account number. Usually, checks are returned
             * within the first 7 days after the deposit is made.
             */
            fun checkDepositReturn(checkDepositReturn: CheckDepositReturn?) =
                checkDepositReturn(JsonField.ofNullable(checkDepositReturn))

            /**
             * Alias for calling [Builder.checkDepositReturn] with
             * `checkDepositReturn.orElse(null)`.
             */
            fun checkDepositReturn(checkDepositReturn: Optional<CheckDepositReturn>) =
                checkDepositReturn(checkDepositReturn.getOrNull())

            /**
             * Sets [Builder.checkDepositReturn] to an arbitrary JSON value.
             *
             * You should usually call [Builder.checkDepositReturn] with a well-typed
             * [CheckDepositReturn] value instead. This method is primarily for setting the field to
             * an undocumented or not yet supported value.
             */
            fun checkDepositReturn(checkDepositReturn: JsonField<CheckDepositReturn>) = apply {
                this.checkDepositReturn = checkDepositReturn
            }

            /**
             * A Check Transfer Deposit object. This field will be present in the JSON response if
             * and only if `category` is equal to `check_transfer_deposit`. An Inbound Check is a
             * check drawn on an Increase account that has been deposited by an external bank
             * account. These types of checks are not pre-registered.
             */
            fun checkTransferDeposit(checkTransferDeposit: CheckTransferDeposit?) =
                checkTransferDeposit(JsonField.ofNullable(checkTransferDeposit))

            /**
             * Alias for calling [Builder.checkTransferDeposit] with
             * `checkTransferDeposit.orElse(null)`.
             */
            fun checkTransferDeposit(checkTransferDeposit: Optional<CheckTransferDeposit>) =
                checkTransferDeposit(checkTransferDeposit.getOrNull())

            /**
             * Sets [Builder.checkTransferDeposit] to an arbitrary JSON value.
             *
             * You should usually call [Builder.checkTransferDeposit] with a well-typed
             * [CheckTransferDeposit] value instead. This method is primarily for setting the field
             * to an undocumented or not yet supported value.
             */
            fun checkTransferDeposit(checkTransferDeposit: JsonField<CheckTransferDeposit>) =
                apply {
                    this.checkTransferDeposit = checkTransferDeposit
                }

            /**
             * A Fee Payment object. This field will be present in the JSON response if and only if
             * `category` is equal to `fee_payment`. A Fee Payment represents a payment made to
             * Increase.
             */
            fun feePayment(feePayment: FeePayment?) = feePayment(JsonField.ofNullable(feePayment))

            /** Alias for calling [Builder.feePayment] with `feePayment.orElse(null)`. */
            fun feePayment(feePayment: Optional<FeePayment>) = feePayment(feePayment.getOrNull())

            /**
             * Sets [Builder.feePayment] to an arbitrary JSON value.
             *
             * You should usually call [Builder.feePayment] with a well-typed [FeePayment] value
             * instead. This method is primarily for setting the field to an undocumented or not yet
             * supported value.
             */
            fun feePayment(feePayment: JsonField<FeePayment>) = apply {
                this.feePayment = feePayment
            }

            /**
             * An Inbound ACH Transfer Intention object. This field will be present in the JSON
             * response if and only if `category` is equal to `inbound_ach_transfer`. An Inbound ACH
             * Transfer Intention is created when an ACH transfer is initiated at another bank and
             * received by Increase.
             */
            fun inboundAchTransfer(inboundAchTransfer: InboundAchTransfer?) =
                inboundAchTransfer(JsonField.ofNullable(inboundAchTransfer))

            /**
             * Alias for calling [Builder.inboundAchTransfer] with
             * `inboundAchTransfer.orElse(null)`.
             */
            fun inboundAchTransfer(inboundAchTransfer: Optional<InboundAchTransfer>) =
                inboundAchTransfer(inboundAchTransfer.getOrNull())

            /**
             * Sets [Builder.inboundAchTransfer] to an arbitrary JSON value.
             *
             * You should usually call [Builder.inboundAchTransfer] with a well-typed
             * [InboundAchTransfer] value instead. This method is primarily for setting the field to
             * an undocumented or not yet supported value.
             */
            fun inboundAchTransfer(inboundAchTransfer: JsonField<InboundAchTransfer>) = apply {
                this.inboundAchTransfer = inboundAchTransfer
            }

            /**
             * An Inbound ACH Transfer Return Intention object. This field will be present in the
             * JSON response if and only if `category` is equal to
             * `inbound_ach_transfer_return_intention`. An Inbound ACH Transfer Return Intention is
             * created when an ACH transfer is initiated at another bank and returned by Increase.
             */
            fun inboundAchTransferReturnIntention(
                inboundAchTransferReturnIntention: InboundAchTransferReturnIntention?
            ) =
                inboundAchTransferReturnIntention(
                    JsonField.ofNullable(inboundAchTransferReturnIntention)
                )

            /**
             * Alias for calling [Builder.inboundAchTransferReturnIntention] with
             * `inboundAchTransferReturnIntention.orElse(null)`.
             */
            fun inboundAchTransferReturnIntention(
                inboundAchTransferReturnIntention: Optional<InboundAchTransferReturnIntention>
            ) = inboundAchTransferReturnIntention(inboundAchTransferReturnIntention.getOrNull())

            /**
             * Sets [Builder.inboundAchTransferReturnIntention] to an arbitrary JSON value.
             *
             * You should usually call [Builder.inboundAchTransferReturnIntention] with a well-typed
             * [InboundAchTransferReturnIntention] value instead. This method is primarily for
             * setting the field to an undocumented or not yet supported value.
             */
            fun inboundAchTransferReturnIntention(
                inboundAchTransferReturnIntention: JsonField<InboundAchTransferReturnIntention>
            ) = apply { this.inboundAchTransferReturnIntention = inboundAchTransferReturnIntention }

            /**
             * An Inbound Check Adjustment object. This field will be present in the JSON response
             * if and only if `category` is equal to `inbound_check_adjustment`. An Inbound Check
             * Adjustment is created when Increase receives an adjustment for a check or return
             * deposited through Check21.
             */
            fun inboundCheckAdjustment(inboundCheckAdjustment: InboundCheckAdjustment?) =
                inboundCheckAdjustment(JsonField.ofNullable(inboundCheckAdjustment))

            /**
             * Alias for calling [Builder.inboundCheckAdjustment] with
             * `inboundCheckAdjustment.orElse(null)`.
             */
            fun inboundCheckAdjustment(inboundCheckAdjustment: Optional<InboundCheckAdjustment>) =
                inboundCheckAdjustment(inboundCheckAdjustment.getOrNull())

            /**
             * Sets [Builder.inboundCheckAdjustment] to an arbitrary JSON value.
             *
             * You should usually call [Builder.inboundCheckAdjustment] with a well-typed
             * [InboundCheckAdjustment] value instead. This method is primarily for setting the
             * field to an undocumented or not yet supported value.
             */
            fun inboundCheckAdjustment(inboundCheckAdjustment: JsonField<InboundCheckAdjustment>) =
                apply {
                    this.inboundCheckAdjustment = inboundCheckAdjustment
                }

            /**
             * An Inbound Check Deposit Return Intention object. This field will be present in the
             * JSON response if and only if `category` is equal to
             * `inbound_check_deposit_return_intention`. An Inbound Check Deposit Return Intention
             * is created when Increase receives an Inbound Check and the User requests that it be
             * returned.
             */
            fun inboundCheckDepositReturnIntention(
                inboundCheckDepositReturnIntention: InboundCheckDepositReturnIntention?
            ) =
                inboundCheckDepositReturnIntention(
                    JsonField.ofNullable(inboundCheckDepositReturnIntention)
                )

            /**
             * Alias for calling [Builder.inboundCheckDepositReturnIntention] with
             * `inboundCheckDepositReturnIntention.orElse(null)`.
             */
            fun inboundCheckDepositReturnIntention(
                inboundCheckDepositReturnIntention: Optional<InboundCheckDepositReturnIntention>
            ) = inboundCheckDepositReturnIntention(inboundCheckDepositReturnIntention.getOrNull())

            /**
             * Sets [Builder.inboundCheckDepositReturnIntention] to an arbitrary JSON value.
             *
             * You should usually call [Builder.inboundCheckDepositReturnIntention] with a
             * well-typed [InboundCheckDepositReturnIntention] value instead. This method is
             * primarily for setting the field to an undocumented or not yet supported value.
             */
            fun inboundCheckDepositReturnIntention(
                inboundCheckDepositReturnIntention: JsonField<InboundCheckDepositReturnIntention>
            ) = apply {
                this.inboundCheckDepositReturnIntention = inboundCheckDepositReturnIntention
            }

            /**
             * An Inbound Real-Time Payments Transfer Confirmation object. This field will be
             * present in the JSON response if and only if `category` is equal to
             * `inbound_real_time_payments_transfer_confirmation`. An Inbound Real-Time Payments
             * Transfer Confirmation is created when a Real-Time Payments transfer is initiated at
             * another bank and received by Increase.
             */
            fun inboundRealTimePaymentsTransferConfirmation(
                inboundRealTimePaymentsTransferConfirmation:
                    InboundRealTimePaymentsTransferConfirmation?
            ) =
                inboundRealTimePaymentsTransferConfirmation(
                    JsonField.ofNullable(inboundRealTimePaymentsTransferConfirmation)
                )

            /**
             * Alias for calling [Builder.inboundRealTimePaymentsTransferConfirmation] with
             * `inboundRealTimePaymentsTransferConfirmation.orElse(null)`.
             */
            fun inboundRealTimePaymentsTransferConfirmation(
                inboundRealTimePaymentsTransferConfirmation:
                    Optional<InboundRealTimePaymentsTransferConfirmation>
            ) =
                inboundRealTimePaymentsTransferConfirmation(
                    inboundRealTimePaymentsTransferConfirmation.getOrNull()
                )

            /**
             * Sets [Builder.inboundRealTimePaymentsTransferConfirmation] to an arbitrary JSON
             * value.
             *
             * You should usually call [Builder.inboundRealTimePaymentsTransferConfirmation] with a
             * well-typed [InboundRealTimePaymentsTransferConfirmation] value instead. This method
             * is primarily for setting the field to an undocumented or not yet supported value.
             */
            fun inboundRealTimePaymentsTransferConfirmation(
                inboundRealTimePaymentsTransferConfirmation:
                    JsonField<InboundRealTimePaymentsTransferConfirmation>
            ) = apply {
                this.inboundRealTimePaymentsTransferConfirmation =
                    inboundRealTimePaymentsTransferConfirmation
            }

            /**
             * An Inbound Real-Time Payments Transfer Decline object. This field will be present in
             * the JSON response if and only if `category` is equal to
             * `inbound_real_time_payments_transfer_decline`.
             */
            fun inboundRealTimePaymentsTransferDecline(
                inboundRealTimePaymentsTransferDecline: InboundRealTimePaymentsTransferDecline?
            ) =
                inboundRealTimePaymentsTransferDecline(
                    JsonField.ofNullable(inboundRealTimePaymentsTransferDecline)
                )

            /**
             * Alias for calling [Builder.inboundRealTimePaymentsTransferDecline] with
             * `inboundRealTimePaymentsTransferDecline.orElse(null)`.
             */
            fun inboundRealTimePaymentsTransferDecline(
                inboundRealTimePaymentsTransferDecline:
                    Optional<InboundRealTimePaymentsTransferDecline>
            ) =
                inboundRealTimePaymentsTransferDecline(
                    inboundRealTimePaymentsTransferDecline.getOrNull()
                )

            /**
             * Sets [Builder.inboundRealTimePaymentsTransferDecline] to an arbitrary JSON value.
             *
             * You should usually call [Builder.inboundRealTimePaymentsTransferDecline] with a
             * well-typed [InboundRealTimePaymentsTransferDecline] value instead. This method is
             * primarily for setting the field to an undocumented or not yet supported value.
             */
            fun inboundRealTimePaymentsTransferDecline(
                inboundRealTimePaymentsTransferDecline:
                    JsonField<InboundRealTimePaymentsTransferDecline>
            ) = apply {
                this.inboundRealTimePaymentsTransferDecline = inboundRealTimePaymentsTransferDecline
            }

            /**
             * An Inbound Wire Reversal object. This field will be present in the JSON response if
             * and only if `category` is equal to `inbound_wire_reversal`. An Inbound Wire Reversal
             * represents a reversal of a wire transfer that was initiated via Increase. The other
             * bank is sending the money back. This most often happens when the original destination
             * account details were incorrect.
             */
            fun inboundWireReversal(inboundWireReversal: InboundWireReversal?) =
                inboundWireReversal(JsonField.ofNullable(inboundWireReversal))

            /**
             * Alias for calling [Builder.inboundWireReversal] with
             * `inboundWireReversal.orElse(null)`.
             */
            fun inboundWireReversal(inboundWireReversal: Optional<InboundWireReversal>) =
                inboundWireReversal(inboundWireReversal.getOrNull())

            /**
             * Sets [Builder.inboundWireReversal] to an arbitrary JSON value.
             *
             * You should usually call [Builder.inboundWireReversal] with a well-typed
             * [InboundWireReversal] value instead. This method is primarily for setting the field
             * to an undocumented or not yet supported value.
             */
            fun inboundWireReversal(inboundWireReversal: JsonField<InboundWireReversal>) = apply {
                this.inboundWireReversal = inboundWireReversal
            }

            /**
             * An Inbound Wire Transfer Intention object. This field will be present in the JSON
             * response if and only if `category` is equal to `inbound_wire_transfer`. An Inbound
             * Wire Transfer Intention is created when a wire transfer is initiated at another bank
             * and received by Increase.
             */
            fun inboundWireTransfer(inboundWireTransfer: InboundWireTransfer?) =
                inboundWireTransfer(JsonField.ofNullable(inboundWireTransfer))

            /**
             * Alias for calling [Builder.inboundWireTransfer] with
             * `inboundWireTransfer.orElse(null)`.
             */
            fun inboundWireTransfer(inboundWireTransfer: Optional<InboundWireTransfer>) =
                inboundWireTransfer(inboundWireTransfer.getOrNull())

            /**
             * Sets [Builder.inboundWireTransfer] to an arbitrary JSON value.
             *
             * You should usually call [Builder.inboundWireTransfer] with a well-typed
             * [InboundWireTransfer] value instead. This method is primarily for setting the field
             * to an undocumented or not yet supported value.
             */
            fun inboundWireTransfer(inboundWireTransfer: JsonField<InboundWireTransfer>) = apply {
                this.inboundWireTransfer = inboundWireTransfer
            }

            /**
             * An Inbound Wire Transfer Reversal Intention object. This field will be present in the
             * JSON response if and only if `category` is equal to `inbound_wire_transfer_reversal`.
             * An Inbound Wire Transfer Reversal Intention is created when Increase has received a
             * wire and the User requests that it be reversed.
             */
            fun inboundWireTransferReversal(
                inboundWireTransferReversal: InboundWireTransferReversal?
            ) = inboundWireTransferReversal(JsonField.ofNullable(inboundWireTransferReversal))

            /**
             * Alias for calling [Builder.inboundWireTransferReversal] with
             * `inboundWireTransferReversal.orElse(null)`.
             */
            fun inboundWireTransferReversal(
                inboundWireTransferReversal: Optional<InboundWireTransferReversal>
            ) = inboundWireTransferReversal(inboundWireTransferReversal.getOrNull())

            /**
             * Sets [Builder.inboundWireTransferReversal] to an arbitrary JSON value.
             *
             * You should usually call [Builder.inboundWireTransferReversal] with a well-typed
             * [InboundWireTransferReversal] value instead. This method is primarily for setting the
             * field to an undocumented or not yet supported value.
             */
            fun inboundWireTransferReversal(
                inboundWireTransferReversal: JsonField<InboundWireTransferReversal>
            ) = apply { this.inboundWireTransferReversal = inboundWireTransferReversal }

            /**
             * An Interest Payment object. This field will be present in the JSON response if and
             * only if `category` is equal to `interest_payment`. An Interest Payment represents a
             * payment of interest on an account. Interest is usually paid monthly.
             */
            fun interestPayment(interestPayment: InterestPayment?) =
                interestPayment(JsonField.ofNullable(interestPayment))

            /** Alias for calling [Builder.interestPayment] with `interestPayment.orElse(null)`. */
            fun interestPayment(interestPayment: Optional<InterestPayment>) =
                interestPayment(interestPayment.getOrNull())

            /**
             * Sets [Builder.interestPayment] to an arbitrary JSON value.
             *
             * You should usually call [Builder.interestPayment] with a well-typed [InterestPayment]
             * value instead. This method is primarily for setting the field to an undocumented or
             * not yet supported value.
             */
            fun interestPayment(interestPayment: JsonField<InterestPayment>) = apply {
                this.interestPayment = interestPayment
            }

            /**
             * An Internal Source object. This field will be present in the JSON response if and
             * only if `category` is equal to `internal_source`. A transaction between the user and
             * Increase. See the `reason` attribute for more information.
             */
            fun internalSource(internalSource: InternalSource?) =
                internalSource(JsonField.ofNullable(internalSource))

            /** Alias for calling [Builder.internalSource] with `internalSource.orElse(null)`. */
            fun internalSource(internalSource: Optional<InternalSource>) =
                internalSource(internalSource.getOrNull())

            /**
             * Sets [Builder.internalSource] to an arbitrary JSON value.
             *
             * You should usually call [Builder.internalSource] with a well-typed [InternalSource]
             * value instead. This method is primarily for setting the field to an undocumented or
             * not yet supported value.
             */
            fun internalSource(internalSource: JsonField<InternalSource>) = apply {
                this.internalSource = internalSource
            }

            /**
             * If the category of this Transaction source is equal to `other`, this field will
             * contain an empty object, otherwise it will contain null.
             */
            fun other(other: JsonValue) = apply { this.other = other }

            /**
             * A Real-Time Payments Transfer Acknowledgement object. This field will be present in
             * the JSON response if and only if `category` is equal to
             * `real_time_payments_transfer_acknowledgement`. A Real-Time Payments Transfer
             * Acknowledgement is created when a Real-Time Payments Transfer sent from Increase is
             * acknowledged by the receiving bank.
             */
            fun realTimePaymentsTransferAcknowledgement(
                realTimePaymentsTransferAcknowledgement: RealTimePaymentsTransferAcknowledgement?
            ) =
                realTimePaymentsTransferAcknowledgement(
                    JsonField.ofNullable(realTimePaymentsTransferAcknowledgement)
                )

            /**
             * Alias for calling [Builder.realTimePaymentsTransferAcknowledgement] with
             * `realTimePaymentsTransferAcknowledgement.orElse(null)`.
             */
            fun realTimePaymentsTransferAcknowledgement(
                realTimePaymentsTransferAcknowledgement:
                    Optional<RealTimePaymentsTransferAcknowledgement>
            ) =
                realTimePaymentsTransferAcknowledgement(
                    realTimePaymentsTransferAcknowledgement.getOrNull()
                )

            /**
             * Sets [Builder.realTimePaymentsTransferAcknowledgement] to an arbitrary JSON value.
             *
             * You should usually call [Builder.realTimePaymentsTransferAcknowledgement] with a
             * well-typed [RealTimePaymentsTransferAcknowledgement] value instead. This method is
             * primarily for setting the field to an undocumented or not yet supported value.
             */
            fun realTimePaymentsTransferAcknowledgement(
                realTimePaymentsTransferAcknowledgement:
                    JsonField<RealTimePaymentsTransferAcknowledgement>
            ) = apply {
                this.realTimePaymentsTransferAcknowledgement =
                    realTimePaymentsTransferAcknowledgement
            }

            /**
             * A Sample Funds object. This field will be present in the JSON response if and only if
             * `category` is equal to `sample_funds`. Sample funds for testing purposes.
             */
            fun sampleFunds(sampleFunds: SampleFunds?) =
                sampleFunds(JsonField.ofNullable(sampleFunds))

            /** Alias for calling [Builder.sampleFunds] with `sampleFunds.orElse(null)`. */
            fun sampleFunds(sampleFunds: Optional<SampleFunds>) =
                sampleFunds(sampleFunds.getOrNull())

            /**
             * Sets [Builder.sampleFunds] to an arbitrary JSON value.
             *
             * You should usually call [Builder.sampleFunds] with a well-typed [SampleFunds] value
             * instead. This method is primarily for setting the field to an undocumented or not yet
             * supported value.
             */
            fun sampleFunds(sampleFunds: JsonField<SampleFunds>) = apply {
                this.sampleFunds = sampleFunds
            }

            /**
             * A Swift Transfer Intention object. This field will be present in the JSON response if
             * and only if `category` is equal to `swift_transfer_intention`. A Swift Transfer
             * initiated via Increase.
             */
            fun swiftTransferIntention(swiftTransferIntention: SwiftTransferIntention?) =
                swiftTransferIntention(JsonField.ofNullable(swiftTransferIntention))

            /**
             * Alias for calling [Builder.swiftTransferIntention] with
             * `swiftTransferIntention.orElse(null)`.
             */
            fun swiftTransferIntention(swiftTransferIntention: Optional<SwiftTransferIntention>) =
                swiftTransferIntention(swiftTransferIntention.getOrNull())

            /**
             * Sets [Builder.swiftTransferIntention] to an arbitrary JSON value.
             *
             * You should usually call [Builder.swiftTransferIntention] with a well-typed
             * [SwiftTransferIntention] value instead. This method is primarily for setting the
             * field to an undocumented or not yet supported value.
             */
            fun swiftTransferIntention(swiftTransferIntention: JsonField<SwiftTransferIntention>) =
                apply {
                    this.swiftTransferIntention = swiftTransferIntention
                }

            /**
             * A Wire Transfer Intention object. This field will be present in the JSON response if
             * and only if `category` is equal to `wire_transfer_intention`. A Wire Transfer
             * initiated via Increase and sent to a different bank.
             */
            fun wireTransferIntention(wireTransferIntention: WireTransferIntention?) =
                wireTransferIntention(JsonField.ofNullable(wireTransferIntention))

            /**
             * Alias for calling [Builder.wireTransferIntention] with
             * `wireTransferIntention.orElse(null)`.
             */
            fun wireTransferIntention(wireTransferIntention: Optional<WireTransferIntention>) =
                wireTransferIntention(wireTransferIntention.getOrNull())

            /**
             * Sets [Builder.wireTransferIntention] to an arbitrary JSON value.
             *
             * You should usually call [Builder.wireTransferIntention] with a well-typed
             * [WireTransferIntention] value instead. This method is primarily for setting the field
             * to an undocumented or not yet supported value.
             */
            fun wireTransferIntention(wireTransferIntention: JsonField<WireTransferIntention>) =
                apply {
                    this.wireTransferIntention = wireTransferIntention
                }

            fun additionalProperties(additionalProperties: Map<String, JsonValue>) = apply {
                this.additionalProperties.clear()
                putAllAdditionalProperties(additionalProperties)
            }

            fun putAdditionalProperty(key: String, value: JsonValue) = apply {
                additionalProperties.put(key, value)
            }

            fun putAllAdditionalProperties(additionalProperties: Map<String, JsonValue>) = apply {
                this.additionalProperties.putAll(additionalProperties)
            }

            fun removeAdditionalProperty(key: String) = apply { additionalProperties.remove(key) }

            fun removeAllAdditionalProperties(keys: Set<String>) = apply {
                keys.forEach(::removeAdditionalProperty)
            }

            /**
             * Returns an immutable instance of [Source].
             *
             * Further updates to this [Builder] will not mutate the returned instance.
             *
             * The following fields are required:
             * ```java
             * .accountTransferIntention()
             * .achTransferIntention()
             * .achTransferRejection()
             * .achTransferReturn()
             * .cardDisputeAcceptance()
             * .cardDisputeLoss()
             * .cardPushTransferAcceptance()
             * .cardRefund()
             * .cardRevenuePayment()
             * .cardSettlement()
             * .cashbackPayment()
             * .category()
             * .checkDepositAcceptance()
             * .checkDepositReturn()
             * .checkTransferDeposit()
             * .feePayment()
             * .inboundAchTransfer()
             * .inboundAchTransferReturnIntention()
             * .inboundCheckAdjustment()
             * .inboundCheckDepositReturnIntention()
             * .inboundRealTimePaymentsTransferConfirmation()
             * .inboundRealTimePaymentsTransferDecline()
             * .inboundWireReversal()
             * .inboundWireTransfer()
             * .inboundWireTransferReversal()
             * .interestPayment()
             * .internalSource()
             * .other()
             * .realTimePaymentsTransferAcknowledgement()
             * .sampleFunds()
             * .swiftTransferIntention()
             * .wireTransferIntention()
             * ```
             *
             * @throws IllegalStateException if any required field is unset.
             */
            fun build(): Source =
                Source(
                    checkRequired("accountTransferIntention", accountTransferIntention),
                    checkRequired("achTransferIntention", achTransferIntention),
                    checkRequired("achTransferRejection", achTransferRejection),
                    checkRequired("achTransferReturn", achTransferReturn),
                    checkRequired("cardDisputeAcceptance", cardDisputeAcceptance),
                    checkRequired("cardDisputeLoss", cardDisputeLoss),
                    checkRequired("cardPushTransferAcceptance", cardPushTransferAcceptance),
                    checkRequired("cardRefund", cardRefund),
                    checkRequired("cardRevenuePayment", cardRevenuePayment),
                    checkRequired("cardSettlement", cardSettlement),
                    checkRequired("cashbackPayment", cashbackPayment),
                    checkRequired("category", category),
                    checkRequired("checkDepositAcceptance", checkDepositAcceptance),
                    checkRequired("checkDepositReturn", checkDepositReturn),
                    checkRequired("checkTransferDeposit", checkTransferDeposit),
                    checkRequired("feePayment", feePayment),
                    checkRequired("inboundAchTransfer", inboundAchTransfer),
                    checkRequired(
                        "inboundAchTransferReturnIntention",
                        inboundAchTransferReturnIntention,
                    ),
                    checkRequired("inboundCheckAdjustment", inboundCheckAdjustment),
                    checkRequired(
                        "inboundCheckDepositReturnIntention",
                        inboundCheckDepositReturnIntention,
                    ),
                    checkRequired(
                        "inboundRealTimePaymentsTransferConfirmation",
                        inboundRealTimePaymentsTransferConfirmation,
                    ),
                    checkRequired(
                        "inboundRealTimePaymentsTransferDecline",
                        inboundRealTimePaymentsTransferDecline,
                    ),
                    checkRequired("inboundWireReversal", inboundWireReversal),
                    checkRequired("inboundWireTransfer", inboundWireTransfer),
                    checkRequired("inboundWireTransferReversal", inboundWireTransferReversal),
                    checkRequired("interestPayment", interestPayment),
                    checkRequired("internalSource", internalSource),
                    checkRequired("other", other),
                    checkRequired(
                        "realTimePaymentsTransferAcknowledgement",
                        realTimePaymentsTransferAcknowledgement,
                    ),
                    checkRequired("sampleFunds", sampleFunds),
                    checkRequired("swiftTransferIntention", swiftTransferIntention),
                    checkRequired("wireTransferIntention", wireTransferIntention),
                    additionalProperties.toMutableMap(),
                )
        }

        private var validated: Boolean = false

        fun validate(): Source = apply {
            if (validated) {
                return@apply
            }

            accountTransferIntention().ifPresent { it.validate() }
            achTransferIntention().ifPresent { it.validate() }
            achTransferRejection().ifPresent { it.validate() }
            achTransferReturn().ifPresent { it.validate() }
            cardDisputeAcceptance().ifPresent { it.validate() }
            cardDisputeLoss().ifPresent { it.validate() }
            cardPushTransferAcceptance().ifPresent { it.validate() }
            cardRefund().ifPresent { it.validate() }
            cardRevenuePayment().ifPresent { it.validate() }
            cardSettlement().ifPresent { it.validate() }
            cashbackPayment().ifPresent { it.validate() }
            category().validate()
            checkDepositAcceptance().ifPresent { it.validate() }
            checkDepositReturn().ifPresent { it.validate() }
            checkTransferDeposit().ifPresent { it.validate() }
            feePayment().ifPresent { it.validate() }
            inboundAchTransfer().ifPresent { it.validate() }
            inboundAchTransferReturnIntention().ifPresent { it.validate() }
            inboundCheckAdjustment().ifPresent { it.validate() }
            inboundCheckDepositReturnIntention().ifPresent { it.validate() }
            inboundRealTimePaymentsTransferConfirmation().ifPresent { it.validate() }
            inboundRealTimePaymentsTransferDecline().ifPresent { it.validate() }
            inboundWireReversal().ifPresent { it.validate() }
            inboundWireTransfer().ifPresent { it.validate() }
            inboundWireTransferReversal().ifPresent { it.validate() }
            interestPayment().ifPresent { it.validate() }
            internalSource().ifPresent { it.validate() }
            realTimePaymentsTransferAcknowledgement().ifPresent { it.validate() }
            sampleFunds().ifPresent { it.validate() }
            swiftTransferIntention().ifPresent { it.validate() }
            wireTransferIntention().ifPresent { it.validate() }
            validated = true
        }

        fun isValid(): Boolean =
            try {
                validate()
                true
            } catch (e: IncreaseInvalidDataException) {
                false
            }

        /**
         * Returns a score indicating how many valid values are contained in this object
         * recursively.
         *
         * Used for best match union deserialization.
         */
        @JvmSynthetic
        internal fun validity(): Int =
            (accountTransferIntention.asKnown().getOrNull()?.validity() ?: 0) +
                (achTransferIntention.asKnown().getOrNull()?.validity() ?: 0) +
                (achTransferRejection.asKnown().getOrNull()?.validity() ?: 0) +
                (achTransferReturn.asKnown().getOrNull()?.validity() ?: 0) +
                (cardDisputeAcceptance.asKnown().getOrNull()?.validity() ?: 0) +
                (cardDisputeLoss.asKnown().getOrNull()?.validity() ?: 0) +
                (cardPushTransferAcceptance.asKnown().getOrNull()?.validity() ?: 0) +
                (cardRefund.asKnown().getOrNull()?.validity() ?: 0) +
                (cardRevenuePayment.asKnown().getOrNull()?.validity() ?: 0) +
                (cardSettlement.asKnown().getOrNull()?.validity() ?: 0) +
                (cashbackPayment.asKnown().getOrNull()?.validity() ?: 0) +
                (category.asKnown().getOrNull()?.validity() ?: 0) +
                (checkDepositAcceptance.asKnown().getOrNull()?.validity() ?: 0) +
                (checkDepositReturn.asKnown().getOrNull()?.validity() ?: 0) +
                (checkTransferDeposit.asKnown().getOrNull()?.validity() ?: 0) +
                (feePayment.asKnown().getOrNull()?.validity() ?: 0) +
                (inboundAchTransfer.asKnown().getOrNull()?.validity() ?: 0) +
                (inboundAchTransferReturnIntention.asKnown().getOrNull()?.validity() ?: 0) +
                (inboundCheckAdjustment.asKnown().getOrNull()?.validity() ?: 0) +
                (inboundCheckDepositReturnIntention.asKnown().getOrNull()?.validity() ?: 0) +
                (inboundRealTimePaymentsTransferConfirmation.asKnown().getOrNull()?.validity()
                    ?: 0) +
                (inboundRealTimePaymentsTransferDecline.asKnown().getOrNull()?.validity() ?: 0) +
                (inboundWireReversal.asKnown().getOrNull()?.validity() ?: 0) +
                (inboundWireTransfer.asKnown().getOrNull()?.validity() ?: 0) +
                (inboundWireTransferReversal.asKnown().getOrNull()?.validity() ?: 0) +
                (interestPayment.asKnown().getOrNull()?.validity() ?: 0) +
                (internalSource.asKnown().getOrNull()?.validity() ?: 0) +
                (realTimePaymentsTransferAcknowledgement.asKnown().getOrNull()?.validity() ?: 0) +
                (sampleFunds.asKnown().getOrNull()?.validity() ?: 0) +
                (swiftTransferIntention.asKnown().getOrNull()?.validity() ?: 0) +
                (wireTransferIntention.asKnown().getOrNull()?.validity() ?: 0)

        /**
         * An Account Transfer Intention object. This field will be present in the JSON response if
         * and only if `category` is equal to `account_transfer_intention`. Two Account Transfer
         * Intentions are created from each Account Transfer. One decrements the source account, and
         * the other increments the destination account.
         */
        class AccountTransferIntention
        private constructor(
            private val amount: JsonField<Long>,
            private val currency: JsonField<Currency>,
            private val description: JsonField<String>,
            private val destinationAccountId: JsonField<String>,
            private val sourceAccountId: JsonField<String>,
            private val transferId: JsonField<String>,
            private val additionalProperties: MutableMap<String, JsonValue>,
        ) {

            @JsonCreator
            private constructor(
                @JsonProperty("amount") @ExcludeMissing amount: JsonField<Long> = JsonMissing.of(),
                @JsonProperty("currency")
                @ExcludeMissing
                currency: JsonField<Currency> = JsonMissing.of(),
                @JsonProperty("description")
                @ExcludeMissing
                description: JsonField<String> = JsonMissing.of(),
                @JsonProperty("destination_account_id")
                @ExcludeMissing
                destinationAccountId: JsonField<String> = JsonMissing.of(),
                @JsonProperty("source_account_id")
                @ExcludeMissing
                sourceAccountId: JsonField<String> = JsonMissing.of(),
                @JsonProperty("transfer_id")
                @ExcludeMissing
                transferId: JsonField<String> = JsonMissing.of(),
            ) : this(
                amount,
                currency,
                description,
                destinationAccountId,
                sourceAccountId,
                transferId,
                mutableMapOf(),
            )

            /**
             * The pending amount in the minor unit of the transaction's currency. For dollars, for
             * example, this is cents.
             *
             * @throws IncreaseInvalidDataException if the JSON field has an unexpected type or is
             *   unexpectedly missing or null (e.g. if the server responded with an unexpected
             *   value).
             */
            fun amount(): Long = amount.getRequired("amount")

            /**
             * The [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) code for the destination
             * account currency.
             *
             * @throws IncreaseInvalidDataException if the JSON field has an unexpected type or is
             *   unexpectedly missing or null (e.g. if the server responded with an unexpected
             *   value).
             */
            fun currency(): Currency = currency.getRequired("currency")

            /**
             * The description you chose to give the transfer.
             *
             * @throws IncreaseInvalidDataException if the JSON field has an unexpected type or is
             *   unexpectedly missing or null (e.g. if the server responded with an unexpected
             *   value).
             */
            fun description(): String = description.getRequired("description")

            /**
             * The identifier of the Account to where the Account Transfer was sent.
             *
             * @throws IncreaseInvalidDataException if the JSON field has an unexpected type or is
             *   unexpectedly missing or null (e.g. if the server responded with an unexpected
             *   value).
             */
            fun destinationAccountId(): String =
                destinationAccountId.getRequired("destination_account_id")

            /**
             * The identifier of the Account from where the Account Transfer was sent.
             *
             * @throws IncreaseInvalidDataException if the JSON field has an unexpected type or is
             *   unexpectedly missing or null (e.g. if the server responded with an unexpected
             *   value).
             */
            fun sourceAccountId(): String = sourceAccountId.getRequired("source_account_id")

            /**
             * The identifier of the Account Transfer that led to this Pending Transaction.
             *
             * @throws IncreaseInvalidDataException if the JSON field has an unexpected type or is
             *   unexpectedly missing or null (e.g. if the server responded with an unexpected
             *   value).
             */
            fun transferId(): String = transferId.getRequired("transfer_id")

            /**
             * Returns the raw JSON value of [amount].
             *
             * Unlike [amount], this method doesn't throw if the JSON field has an unexpected type.
             */
            @JsonProperty("amount") @ExcludeMissing fun _amount(): JsonField<Long> = amount

            /**
             * Returns the raw JSON value of [currency].
             *
             * Unlike [currency], this method doesn't throw if the JSON field has an unexpected
             * type.
             */
            @JsonProperty("currency")
            @ExcludeMissing
            fun _currency(): JsonField<Currency> = currency

            /**
             * Returns the raw JSON value of [description].
             *
             * Unlike [description], this method doesn't throw if the JSON field has an unexpected
             * type.
             */
            @JsonProperty("description")
            @ExcludeMissing
            fun _description(): JsonField<String> = description

            /**
             * Returns the raw JSON value of [destinationAccountId].
             *
             * Unlike [destinationAccountId], this method doesn't throw if the JSON field has an
             * unexpected type.
             */
            @JsonProperty("destination_account_id")
            @ExcludeMissing
            fun _destinationAccountId(): JsonField<String> = destinationAccountId

            /**
             * Returns the raw JSON value of [sourceAccountId].
             *
             * Unlike [sourceAccountId], this method doesn't throw if the JSON field has an
             * unexpected type.
             */
            @JsonProperty("source_account_id")
            @ExcludeMissing
            fun _sourceAccountId(): JsonField<String> = sourceAccountId

            /**
             * Returns the raw JSON value of [transferId].
             *
             * Unlike [transferId], this method doesn't throw if the JSON field has an unexpected
             * type.
             */
            @JsonProperty("transfer_id")
            @ExcludeMissing
            fun _transferId(): JsonField<String> = transferId

            @JsonAnySetter
            private fun putAdditionalProperty(key: String, value: JsonValue) {
                additionalProperties.put(key, value)
            }

            @JsonAnyGetter
            @ExcludeMissing
            fun _additionalProperties(): Map<String, JsonValue> =
                Collections.unmodifiableMap(additionalProperties)

            fun toBuilder() = Builder().from(this)

            companion object {

                /**
                 * Returns a mutable builder for constructing an instance of
                 * [AccountTransferIntention].
                 *
                 * The following fields are required:
                 * ```java
                 * .amount()
                 * .currency()
                 * .description()
                 * .destinationAccountId()
                 * .sourceAccountId()
                 * .transferId()
                 * ```
                 */
                @JvmStatic fun builder() = Builder()
            }

            /** A builder for [AccountTransferIntention]. */
            class Builder internal constructor() {

                private var amount: JsonField<Long>? = null
                private var currency: JsonField<Currency>? = null
                private var description: JsonField<String>? = null
                private var destinationAccountId: JsonField<String>? = null
                private var sourceAccountId: JsonField<String>? = null
                private var transferId: JsonField<String>? = null
                private var additionalProperties: MutableMap<String, JsonValue> = mutableMapOf()

                @JvmSynthetic
                internal fun from(accountTransferIntention: AccountTransferIntention) = apply {
                    amount = accountTransferIntention.amount
                    currency = accountTransferIntention.currency
                    description = accountTransferIntention.description
                    destinationAccountId = accountTransferIntention.destinationAccountId
                    sourceAccountId = accountTransferIntention.sourceAccountId
                    transferId = accountTransferIntention.transferId
                    additionalProperties =
                        accountTransferIntention.additionalProperties.toMutableMap()
                }

                /**
                 * The pending amount in the minor unit of the transaction's currency. For dollars,
                 * for example, this is cents.
                 */
                fun amount(amount: Long) = amount(JsonField.of(amount))

                /**
                 * Sets [Builder.amount] to an arbitrary JSON value.
                 *
                 * You should usually call [Builder.amount] with a well-typed [Long] value instead.
                 * This method is primarily for setting the field to an undocumented or not yet
                 * supported value.
                 */
                fun amount(amount: JsonField<Long>) = apply { this.amount = amount }

                /**
                 * The [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) code for the destination
                 * account currency.
                 */
                fun currency(currency: Currency) = currency(JsonField.of(currency))

                /**
                 * Sets [Builder.currency] to an arbitrary JSON value.
                 *
                 * You should usually call [Builder.currency] with a well-typed [Currency] value
                 * instead. This method is primarily for setting the field to an undocumented or not
                 * yet supported value.
                 */
                fun currency(currency: JsonField<Currency>) = apply { this.currency = currency }

                /** The description you chose to give the transfer. */
                fun description(description: String) = description(JsonField.of(description))

                /**
                 * Sets [Builder.description] to an arbitrary JSON value.
                 *
                 * You should usually call [Builder.description] with a well-typed [String] value
                 * instead. This method is primarily for setting the field to an undocumented or not
                 * yet supported value.
                 */
                fun description(description: JsonField<String>) = apply {
                    this.description = description
                }

                /** The identifier of the Account to where the Account Transfer was sent. */
                fun destinationAccountId(destinationAccountId: String) =
                    destinationAccountId(JsonField.of(destinationAccountId))

                /**
                 * Sets [Builder.destinationAccountId] to an arbitrary JSON value.
                 *
                 * You should usually call [Builder.destinationAccountId] with a well-typed [String]
                 * value instead. This method is primarily for setting the field to an undocumented
                 * or not yet supported value.
                 */
                fun destinationAccountId(destinationAccountId: JsonField<String>) = apply {
                    this.destinationAccountId = destinationAccountId
                }

                /** The identifier of the Account from where the Account Transfer was sent. */
                fun sourceAccountId(sourceAccountId: String) =
                    sourceAccountId(JsonField.of(sourceAccountId))

                /**
                 * Sets [Builder.sourceAccountId] to an arbitrary JSON value.
                 *
                 * You should usually call [Builder.sourceAccountId] with a well-typed [String]
                 * value instead. This method is primarily for setting the field to an undocumented
                 * or not yet supported value.
                 */
                fun sourceAccountId(sourceAccountId: JsonField<String>) = apply {
                    this.sourceAccountId = sourceAccountId
                }

                /** The identifier of the Account Transfer that led to this Pending Transaction. */
                fun transferId(transferId: String) = transferId(JsonField.of(transferId))

                /**
                 * Sets [Builder.transferId] to an arbitrary JSON value.
                 *
                 * You should usually call [Builder.transferId] with a well-typed [String] value
                 * instead. This method is primarily for setting the field to an undocumented or not
                 * yet supported value.
                 */
                fun transferId(transferId: JsonField<String>) = apply {
                    this.transferId = transferId
                }

                fun additionalProperties(additionalProperties: Map<String, JsonValue>) = apply {
                    this.additionalProperties.clear()
                    putAllAdditionalProperties(additionalProperties)
                }

                fun putAdditionalProperty(key: String, value: JsonValue) = apply {
                    additionalProperties.put(key, value)
                }

                fun putAllAdditionalProperties(additionalProperties: Map<String, JsonValue>) =
                    apply {
                        this.additionalProperties.putAll(additionalProperties)
                    }

                fun removeAdditionalProperty(key: String) = apply {
                    additionalProperties.remove(key)
                }

                fun removeAllAdditionalProperties(keys: Set<String>) = apply {
                    keys.forEach(::removeAdditionalProperty)
                }

                /**
                 * Returns an immutable instance of [AccountTransferIntention].
                 *
                 * Further updates to this [Builder] will not mutate the returned instance.
                 *
                 * The following fields are required:
                 * ```java
                 * .amount()
                 * .currency()
                 * .description()
                 * .destinationAccountId()
                 * .sourceAccountId()
                 * .transferId()
                 * ```
                 *
                 * @throws IllegalStateException if any required field is unset.
                 */
                fun build(): AccountTransferIntention =
                    AccountTransferIntention(
                        checkRequired("amount", amount),
                        checkRequired("currency", currency),
                        checkRequired("description", description),
                        checkRequired("destinationAccountId", destinationAccountId),
                        checkRequired("sourceAccountId", sourceAccountId),
                        checkRequired("transferId", transferId),
                        additionalProperties.toMutableMap(),
                    )
            }

            private var validated: Boolean = false

            fun validate(): AccountTransferIntention = apply {
                if (validated) {
                    return@apply
                }

                amount()
                currency().validate()
                description()
                destinationAccountId()
                sourceAccountId()
                transferId()
                validated = true
            }

            fun isValid(): Boolean =
                try {
                    validate()
                    true
                } catch (e: IncreaseInvalidDataException) {
                    false
                }

            /**
             * Returns a score indicating how many valid values are contained in this object
             * recursively.
             *
             * Used for best match union deserialization.
             */
            @JvmSynthetic
            internal fun validity(): Int =
                (if (amount.asKnown().isPresent) 1 else 0) +
                    (currency.asKnown().getOrNull()?.validity() ?: 0) +
                    (if (description.asKnown().isPresent) 1 else 0) +
                    (if (destinationAccountId.asKnown().isPresent) 1 else 0) +
                    (if (sourceAccountId.asKnown().isPresent) 1 else 0) +
                    (if (transferId.asKnown().isPresent) 1 else 0)

            /**
             * The [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) code for the destination
             * account currency.
             */
            class Currency @JsonCreator private constructor(private val value: JsonField<String>) :
                Enum {

                /**
                 * Returns this class instance's raw value.
                 *
                 * This is usually only useful if this instance was deserialized from data that
                 * doesn't match any known member, and you want to know that value. For example, if
                 * the SDK is on an older version than the API, then the API may respond with new
                 * members that the SDK is unaware of.
                 */
                @com.fasterxml.jackson.annotation.JsonValue fun _value(): JsonField<String> = value

                companion object {

                    /** Canadian Dollar (CAD) */
                    @JvmField val CAD = of("CAD")

                    /** Swiss Franc (CHF) */
                    @JvmField val CHF = of("CHF")

                    /** Euro (EUR) */
                    @JvmField val EUR = of("EUR")

                    /** British Pound (GBP) */
                    @JvmField val GBP = of("GBP")

                    /** Japanese Yen (JPY) */
                    @JvmField val JPY = of("JPY")

                    /** US Dollar (USD) */
                    @JvmField val USD = of("USD")

                    @JvmStatic fun of(value: String) = Currency(JsonField.of(value))
                }

                /** An enum containing [Currency]'s known values. */
                enum class Known {
                    /** Canadian Dollar (CAD) */
                    CAD,
                    /** Swiss Franc (CHF) */
                    CHF,
                    /** Euro (EUR) */
                    EUR,
                    /** British Pound (GBP) */
                    GBP,
                    /** Japanese Yen (JPY) */
                    JPY,
                    /** US Dollar (USD) */
                    USD,
                }

                /**
                 * An enum containing [Currency]'s known values, as well as an [_UNKNOWN] member.
                 *
                 * An instance of [Currency] can contain an unknown value in a couple of cases:
                 * - It was deserialized from data that doesn't match any known member. For example,
                 *   if the SDK is on an older version than the API, then the API may respond with
                 *   new members that the SDK is unaware of.
                 * - It was constructed with an arbitrary value using the [of] method.
                 */
                enum class Value {
                    /** Canadian Dollar (CAD) */
                    CAD,
                    /** Swiss Franc (CHF) */
                    CHF,
                    /** Euro (EUR) */
                    EUR,
                    /** British Pound (GBP) */
                    GBP,
                    /** Japanese Yen (JPY) */
                    JPY,
                    /** US Dollar (USD) */
                    USD,
                    /**
                     * An enum member indicating that [Currency] was instantiated with an unknown
                     * value.
                     */
                    _UNKNOWN,
                }

                /**
                 * Returns an enum member corresponding to this class instance's value, or
                 * [Value._UNKNOWN] if the class was instantiated with an unknown value.
                 *
                 * Use the [known] method instead if you're certain the value is always known or if
                 * you want to throw for the unknown case.
                 */
                fun value(): Value =
                    when (this) {
                        CAD -> Value.CAD
                        CHF -> Value.CHF
                        EUR -> Value.EUR
                        GBP -> Value.GBP
                        JPY -> Value.JPY
                        USD -> Value.USD
                        else -> Value._UNKNOWN
                    }

                /**
                 * Returns an enum member corresponding to this class instance's value.
                 *
                 * Use the [value] method instead if you're uncertain the value is always known and
                 * don't want to throw for the unknown case.
                 *
                 * @throws IncreaseInvalidDataException if this class instance's value is a not a
                 *   known member.
                 */
                fun known(): Known =
                    when (this) {
                        CAD -> Known.CAD
                        CHF -> Known.CHF
                        EUR -> Known.EUR
                        GBP -> Known.GBP
                        JPY -> Known.JPY
                        USD -> Known.USD
                        else -> throw IncreaseInvalidDataException("Unknown Currency: $value")
                    }

                /**
                 * Returns this class instance's primitive wire representation.
                 *
                 * This differs from the [toString] method because that method is primarily for
                 * debugging and generally doesn't throw.
                 *
                 * @throws IncreaseInvalidDataException if this class instance's value does not have
                 *   the expected primitive type.
                 */
                fun asString(): String =
                    _value().asString().orElseThrow {
                        IncreaseInvalidDataException("Value is not a String")
                    }

                private var validated: Boolean = false

                fun validate(): Currency = apply {
                    if (validated) {
                        return@apply
                    }

                    known()
                    validated = true
                }

                fun isValid(): Boolean =
                    try {
                        validate()
                        true
                    } catch (e: IncreaseInvalidDataException) {
                        false
                    }

                /**
                 * Returns a score indicating how many valid values are contained in this object
                 * recursively.
                 *
                 * Used for best match union deserialization.
                 */
                @JvmSynthetic internal fun validity(): Int = if (value() == Value._UNKNOWN) 0 else 1

                override fun equals(other: Any?): Boolean {
                    if (this === other) {
                        return true
                    }

                    return /* spotless:off */ other is Currency && value == other.value /* spotless:on */
                }

                override fun hashCode() = value.hashCode()

                override fun toString() = value.toString()
            }

            override fun equals(other: Any?): Boolean {
                if (this === other) {
                    return true
                }

                return /* spotless:off */ other is AccountTransferIntention && amount == other.amount && currency == other.currency && description == other.description && destinationAccountId == other.destinationAccountId && sourceAccountId == other.sourceAccountId && transferId == other.transferId && additionalProperties == other.additionalProperties /* spotless:on */
            }

            /* spotless:off */
            private val hashCode: Int by lazy { Objects.hash(amount, currency, description, destinationAccountId, sourceAccountId, transferId, additionalProperties) }
            /* spotless:on */

            override fun hashCode(): Int = hashCode

            override fun toString() =
                "AccountTransferIntention{amount=$amount, currency=$currency, description=$description, destinationAccountId=$destinationAccountId, sourceAccountId=$sourceAccountId, transferId=$transferId, additionalProperties=$additionalProperties}"
        }

        /**
         * An ACH Transfer Intention object. This field will be present in the JSON response if and
         * only if `category` is equal to `ach_transfer_intention`. An ACH Transfer Intention is
         * created from an ACH Transfer. It reflects the intention to move money into or out of an
         * Increase account via the ACH network.
         */
        class AchTransferIntention
        private constructor(
            private val accountNumber: JsonField<String>,
            private val amount: JsonField<Long>,
            private val routingNumber: JsonField<String>,
            private val statementDescriptor: JsonField<String>,
            private val transferId: JsonField<String>,
            private val additionalProperties: MutableMap<String, JsonValue>,
        ) {

            @JsonCreator
            private constructor(
                @JsonProperty("account_number")
                @ExcludeMissing
                accountNumber: JsonField<String> = JsonMissing.of(),
                @JsonProperty("amount") @ExcludeMissing amount: JsonField<Long> = JsonMissing.of(),
                @JsonProperty("routing_number")
                @ExcludeMissing
                routingNumber: JsonField<String> = JsonMissing.of(),
                @JsonProperty("statement_descriptor")
                @ExcludeMissing
                statementDescriptor: JsonField<String> = JsonMissing.of(),
                @JsonProperty("transfer_id")
                @ExcludeMissing
                transferId: JsonField<String> = JsonMissing.of(),
            ) : this(
                accountNumber,
                amount,
                routingNumber,
                statementDescriptor,
                transferId,
                mutableMapOf(),
            )

            /**
             * The account number for the destination account.
             *
             * @throws IncreaseInvalidDataException if the JSON field has an unexpected type or is
             *   unexpectedly missing or null (e.g. if the server responded with an unexpected
             *   value).
             */
            fun accountNumber(): String = accountNumber.getRequired("account_number")

            /**
             * The amount in the minor unit of the transaction's currency. For dollars, for example,
             * this is cents.
             *
             * @throws IncreaseInvalidDataException if the JSON field has an unexpected type or is
             *   unexpectedly missing or null (e.g. if the server responded with an unexpected
             *   value).
             */
            fun amount(): Long = amount.getRequired("amount")

            /**
             * The American Bankers' Association (ABA) Routing Transit Number (RTN) for the
             * destination account.
             *
             * @throws IncreaseInvalidDataException if the JSON field has an unexpected type or is
             *   unexpectedly missing or null (e.g. if the server responded with an unexpected
             *   value).
             */
            fun routingNumber(): String = routingNumber.getRequired("routing_number")

            /**
             * A description set when the ACH Transfer was created.
             *
             * @throws IncreaseInvalidDataException if the JSON field has an unexpected type or is
             *   unexpectedly missing or null (e.g. if the server responded with an unexpected
             *   value).
             */
            fun statementDescriptor(): String =
                statementDescriptor.getRequired("statement_descriptor")

            /**
             * The identifier of the ACH Transfer that led to this Transaction.
             *
             * @throws IncreaseInvalidDataException if the JSON field has an unexpected type or is
             *   unexpectedly missing or null (e.g. if the server responded with an unexpected
             *   value).
             */
            fun transferId(): String = transferId.getRequired("transfer_id")

            /**
             * Returns the raw JSON value of [accountNumber].
             *
             * Unlike [accountNumber], this method doesn't throw if the JSON field has an unexpected
             * type.
             */
            @JsonProperty("account_number")
            @ExcludeMissing
            fun _accountNumber(): JsonField<String> = accountNumber

            /**
             * Returns the raw JSON value of [amount].
             *
             * Unlike [amount], this method doesn't throw if the JSON field has an unexpected type.
             */
            @JsonProperty("amount") @ExcludeMissing fun _amount(): JsonField<Long> = amount

            /**
             * Returns the raw JSON value of [routingNumber].
             *
             * Unlike [routingNumber], this method doesn't throw if the JSON field has an unexpected
             * type.
             */
            @JsonProperty("routing_number")
            @ExcludeMissing
            fun _routingNumber(): JsonField<String> = routingNumber

            /**
             * Returns the raw JSON value of [statementDescriptor].
             *
             * Unlike [statementDescriptor], this method doesn't throw if the JSON field has an
             * unexpected type.
             */
            @JsonProperty("statement_descriptor")
            @ExcludeMissing
            fun _statementDescriptor(): JsonField<String> = statementDescriptor

            /**
             * Returns the raw JSON value of [transferId].
             *
             * Unlike [transferId], this method doesn't throw if the JSON field has an unexpected
             * type.
             */
            @JsonProperty("transfer_id")
            @ExcludeMissing
            fun _transferId(): JsonField<String> = transferId

            @JsonAnySetter
            private fun putAdditionalProperty(key: String, value: JsonValue) {
                additionalProperties.put(key, value)
            }

            @JsonAnyGetter
            @ExcludeMissing
            fun _additionalProperties(): Map<String, JsonValue> =
                Collections.unmodifiableMap(additionalProperties)

            fun toBuilder() = Builder().from(this)

            companion object {

                /**
                 * Returns a mutable builder for constructing an instance of [AchTransferIntention].
                 *
                 * The following fields are required:
                 * ```java
                 * .accountNumber()
                 * .amount()
                 * .routingNumber()
                 * .statementDescriptor()
                 * .transferId()
                 * ```
                 */
                @JvmStatic fun builder() = Builder()
            }

            /** A builder for [AchTransferIntention]. */
            class Builder internal constructor() {

                private var accountNumber: JsonField<String>? = null
                private var amount: JsonField<Long>? = null
                private var routingNumber: JsonField<String>? = null
                private var statementDescriptor: JsonField<String>? = null
                private var transferId: JsonField<String>? = null
                private var additionalProperties: MutableMap<String, JsonValue> = mutableMapOf()

                @JvmSynthetic
                internal fun from(achTransferIntention: AchTransferIntention) = apply {
                    accountNumber = achTransferIntention.accountNumber
                    amount = achTransferIntention.amount
                    routingNumber = achTransferIntention.routingNumber
                    statementDescriptor = achTransferIntention.statementDescriptor
                    transferId = achTransferIntention.transferId
                    additionalProperties = achTransferIntention.additionalProperties.toMutableMap()
                }

                /** The account number for the destination account. */
                fun accountNumber(accountNumber: String) =
                    accountNumber(JsonField.of(accountNumber))

                /**
                 * Sets [Builder.accountNumber] to an arbitrary JSON value.
                 *
                 * You should usually call [Builder.accountNumber] with a well-typed [String] value
                 * instead. This method is primarily for setting the field to an undocumented or not
                 * yet supported value.
                 */
                fun accountNumber(accountNumber: JsonField<String>) = apply {
                    this.accountNumber = accountNumber
                }

                /**
                 * The amount in the minor unit of the transaction's currency. For dollars, for
                 * example, this is cents.
                 */
                fun amount(amount: Long) = amount(JsonField.of(amount))

                /**
                 * Sets [Builder.amount] to an arbitrary JSON value.
                 *
                 * You should usually call [Builder.amount] with a well-typed [Long] value instead.
                 * This method is primarily for setting the field to an undocumented or not yet
                 * supported value.
                 */
                fun amount(amount: JsonField<Long>) = apply { this.amount = amount }

                /**
                 * The American Bankers' Association (ABA) Routing Transit Number (RTN) for the
                 * destination account.
                 */
                fun routingNumber(routingNumber: String) =
                    routingNumber(JsonField.of(routingNumber))

                /**
                 * Sets [Builder.routingNumber] to an arbitrary JSON value.
                 *
                 * You should usually call [Builder.routingNumber] with a well-typed [String] value
                 * instead. This method is primarily for setting the field to an undocumented or not
                 * yet supported value.
                 */
                fun routingNumber(routingNumber: JsonField<String>) = apply {
                    this.routingNumber = routingNumber
                }

                /** A description set when the ACH Transfer was created. */
                fun statementDescriptor(statementDescriptor: String) =
                    statementDescriptor(JsonField.of(statementDescriptor))

                /**
                 * Sets [Builder.statementDescriptor] to an arbitrary JSON value.
                 *
                 * You should usually call [Builder.statementDescriptor] with a well-typed [String]
                 * value instead. This method is primarily for setting the field to an undocumented
                 * or not yet supported value.
                 */
                fun statementDescriptor(statementDescriptor: JsonField<String>) = apply {
                    this.statementDescriptor = statementDescriptor
                }

                /** The identifier of the ACH Transfer that led to this Transaction. */
                fun transferId(transferId: String) = transferId(JsonField.of(transferId))

                /**
                 * Sets [Builder.transferId] to an arbitrary JSON value.
                 *
                 * You should usually call [Builder.transferId] with a well-typed [String] value
                 * instead. This method is primarily for setting the field to an undocumented or not
                 * yet supported value.
                 */
                fun transferId(transferId: JsonField<String>) = apply {
                    this.transferId = transferId
                }

                fun additionalProperties(additionalProperties: Map<String, JsonValue>) = apply {
                    this.additionalProperties.clear()
                    putAllAdditionalProperties(additionalProperties)
                }

                fun putAdditionalProperty(key: String, value: JsonValue) = apply {
                    additionalProperties.put(key, value)
                }

                fun putAllAdditionalProperties(additionalProperties: Map<String, JsonValue>) =
                    apply {
                        this.additionalProperties.putAll(additionalProperties)
                    }

                fun removeAdditionalProperty(key: String) = apply {
                    additionalProperties.remove(key)
                }

                fun removeAllAdditionalProperties(keys: Set<String>) = apply {
                    keys.forEach(::removeAdditionalProperty)
                }

                /**
                 * Returns an immutable instance of [AchTransferIntention].
                 *
                 * Further updates to this [Builder] will not mutate the returned instance.
                 *
                 * The following fields are required:
                 * ```java
                 * .accountNumber()
                 * .amount()
                 * .routingNumber()
                 * .statementDescriptor()
                 * .transferId()
                 * ```
                 *
                 * @throws IllegalStateException if any required field is unset.
                 */
                fun build(): AchTransferIntention =
                    AchTransferIntention(
                        checkRequired("accountNumber", accountNumber),
                        checkRequired("amount", amount),
                        checkRequired("routingNumber", routingNumber),
                        checkRequired("statementDescriptor", statementDescriptor),
                        checkRequired("transferId", transferId),
                        additionalProperties.toMutableMap(),
                    )
            }

            private var validated: Boolean = false

            fun validate(): AchTransferIntention = apply {
                if (validated) {
                    return@apply
                }

                accountNumber()
                amount()
                routingNumber()
                statementDescriptor()
                transferId()
                validated = true
            }

            fun isValid(): Boolean =
                try {
                    validate()
                    true
                } catch (e: IncreaseInvalidDataException) {
                    false
                }

            /**
             * Returns a score indicating how many valid values are contained in this object
             * recursively.
             *
             * Used for best match union deserialization.
             */
            @JvmSynthetic
            internal fun validity(): Int =
                (if (accountNumber.asKnown().isPresent) 1 else 0) +
                    (if (amount.asKnown().isPresent) 1 else 0) +
                    (if (routingNumber.asKnown().isPresent) 1 else 0) +
                    (if (statementDescriptor.asKnown().isPresent) 1 else 0) +
                    (if (transferId.asKnown().isPresent) 1 else 0)

            override fun equals(other: Any?): Boolean {
                if (this === other) {
                    return true
                }

                return /* spotless:off */ other is AchTransferIntention && accountNumber == other.accountNumber && amount == other.amount && routingNumber == other.routingNumber && statementDescriptor == other.statementDescriptor && transferId == other.transferId && additionalProperties == other.additionalProperties /* spotless:on */
            }

            /* spotless:off */
            private val hashCode: Int by lazy { Objects.hash(accountNumber, amount, routingNumber, statementDescriptor, transferId, additionalProperties) }
            /* spotless:on */

            override fun hashCode(): Int = hashCode

            override fun toString() =
                "AchTransferIntention{accountNumber=$accountNumber, amount=$amount, routingNumber=$routingNumber, statementDescriptor=$statementDescriptor, transferId=$transferId, additionalProperties=$additionalProperties}"
        }

        /**
         * An ACH Transfer Rejection object. This field will be present in the JSON response if and
         * only if `category` is equal to `ach_transfer_rejection`. An ACH Transfer Rejection is
         * created when an ACH Transfer is rejected by Increase. It offsets the ACH Transfer
         * Intention. These rejections are rare.
         */
        class AchTransferRejection
        private constructor(
            private val transferId: JsonField<String>,
            private val additionalProperties: MutableMap<String, JsonValue>,
        ) {

            @JsonCreator
            private constructor(
                @JsonProperty("transfer_id")
                @ExcludeMissing
                transferId: JsonField<String> = JsonMissing.of()
            ) : this(transferId, mutableMapOf())

            /**
             * The identifier of the ACH Transfer that led to this Transaction.
             *
             * @throws IncreaseInvalidDataException if the JSON field has an unexpected type or is
             *   unexpectedly missing or null (e.g. if the server responded with an unexpected
             *   value).
             */
            fun transferId(): String = transferId.getRequired("transfer_id")

            /**
             * Returns the raw JSON value of [transferId].
             *
             * Unlike [transferId], this method doesn't throw if the JSON field has an unexpected
             * type.
             */
            @JsonProperty("transfer_id")
            @ExcludeMissing
            fun _transferId(): JsonField<String> = transferId

            @JsonAnySetter
            private fun putAdditionalProperty(key: String, value: JsonValue) {
                additionalProperties.put(key, value)
            }

            @JsonAnyGetter
            @ExcludeMissing
            fun _additionalProperties(): Map<String, JsonValue> =
                Collections.unmodifiableMap(additionalProperties)

            fun toBuilder() = Builder().from(this)

            companion object {

                /**
                 * Returns a mutable builder for constructing an instance of [AchTransferRejection].
                 *
                 * The following fields are required:
                 * ```java
                 * .transferId()
                 * ```
                 */
                @JvmStatic fun builder() = Builder()
            }

            /** A builder for [AchTransferRejection]. */
            class Builder internal constructor() {

                private var transferId: JsonField<String>? = null
                private var additionalProperties: MutableMap<String, JsonValue> = mutableMapOf()

                @JvmSynthetic
                internal fun from(achTransferRejection: AchTransferRejection) = apply {
                    transferId = achTransferRejection.transferId
                    additionalProperties = achTransferRejection.additionalProperties.toMutableMap()
                }

                /** The identifier of the ACH Transfer that led to this Transaction. */
                fun transferId(transferId: String) = transferId(JsonField.of(transferId))

                /**
                 * Sets [Builder.transferId] to an arbitrary JSON value.
                 *
                 * You should usually call [Builder.transferId] with a well-typed [String] value
                 * instead. This method is primarily for setting the field to an undocumented or not
                 * yet supported value.
                 */
                fun transferId(transferId: JsonField<String>) = apply {
                    this.transferId = transferId
                }

                fun additionalProperties(additionalProperties: Map<String, JsonValue>) = apply {
                    this.additionalProperties.clear()
                    putAllAdditionalProperties(additionalProperties)
                }

                fun putAdditionalProperty(key: String, value: JsonValue) = apply {
                    additionalProperties.put(key, value)
                }

                fun putAllAdditionalProperties(additionalProperties: Map<String, JsonValue>) =
                    apply {
                        this.additionalProperties.putAll(additionalProperties)
                    }

                fun removeAdditionalProperty(key: String) = apply {
                    additionalProperties.remove(key)
                }

                fun removeAllAdditionalProperties(keys: Set<String>) = apply {
                    keys.forEach(::removeAdditionalProperty)
                }

                /**
                 * Returns an immutable instance of [AchTransferRejection].
                 *
                 * Further updates to this [Builder] will not mutate the returned instance.
                 *
                 * The following fields are required:
                 * ```java
                 * .transferId()
                 * ```
                 *
                 * @throws IllegalStateException if any required field is unset.
                 */
                fun build(): AchTransferRejection =
                    AchTransferRejection(
                        checkRequired("transferId", transferId),
                        additionalProperties.toMutableMap(),
                    )
            }

            private var validated: Boolean = false

            fun validate(): AchTransferRejection = apply {
                if (validated) {
                    return@apply
                }

                transferId()
                validated = true
            }

            fun isValid(): Boolean =
                try {
                    validate()
                    true
                } catch (e: IncreaseInvalidDataException) {
                    false
                }

            /**
             * Returns a score indicating how many valid values are contained in this object
             * recursively.
             *
             * Used for best match union deserialization.
             */
            @JvmSynthetic
            internal fun validity(): Int = (if (transferId.asKnown().isPresent) 1 else 0)

            override fun equals(other: Any?): Boolean {
                if (this === other) {
                    return true
                }

                return /* spotless:off */ other is AchTransferRejection && transferId == other.transferId && additionalProperties == other.additionalProperties /* spotless:on */
            }

            /* spotless:off */
            private val hashCode: Int by lazy { Objects.hash(transferId, additionalProperties) }
            /* spotless:on */

            override fun hashCode(): Int = hashCode

            override fun toString() =
                "AchTransferRejection{transferId=$transferId, additionalProperties=$additionalProperties}"
        }

        /**
         * An ACH Transfer Return object. This field will be present in the JSON response if and
         * only if `category` is equal to `ach_transfer_return`. An ACH Transfer Return is created
         * when an ACH Transfer is returned by the receiving bank. It offsets the ACH Transfer
         * Intention. ACH Transfer Returns usually occur within the first two business days after
         * the transfer is initiated, but can occur much later.
         */
        class AchTransferReturn
        private constructor(
            private val createdAt: JsonField<OffsetDateTime>,
            private val rawReturnReasonCode: JsonField<String>,
            private val returnReasonCode: JsonField<ReturnReasonCode>,
            private val traceNumber: JsonField<String>,
            private val transactionId: JsonField<String>,
            private val transferId: JsonField<String>,
            private val additionalProperties: MutableMap<String, JsonValue>,
        ) {

            @JsonCreator
            private constructor(
                @JsonProperty("created_at")
                @ExcludeMissing
                createdAt: JsonField<OffsetDateTime> = JsonMissing.of(),
                @JsonProperty("raw_return_reason_code")
                @ExcludeMissing
                rawReturnReasonCode: JsonField<String> = JsonMissing.of(),
                @JsonProperty("return_reason_code")
                @ExcludeMissing
                returnReasonCode: JsonField<ReturnReasonCode> = JsonMissing.of(),
                @JsonProperty("trace_number")
                @ExcludeMissing
                traceNumber: JsonField<String> = JsonMissing.of(),
                @JsonProperty("transaction_id")
                @ExcludeMissing
                transactionId: JsonField<String> = JsonMissing.of(),
                @JsonProperty("transfer_id")
                @ExcludeMissing
                transferId: JsonField<String> = JsonMissing.of(),
            ) : this(
                createdAt,
                rawReturnReasonCode,
                returnReasonCode,
                traceNumber,
                transactionId,
                transferId,
                mutableMapOf(),
            )

            /**
             * The [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) date and time at which the
             * transfer was created.
             *
             * @throws IncreaseInvalidDataException if the JSON field has an unexpected type or is
             *   unexpectedly missing or null (e.g. if the server responded with an unexpected
             *   value).
             */
            fun createdAt(): OffsetDateTime = createdAt.getRequired("created_at")

            /**
             * The three character ACH return code, in the range R01 to R85.
             *
             * @throws IncreaseInvalidDataException if the JSON field has an unexpected type or is
             *   unexpectedly missing or null (e.g. if the server responded with an unexpected
             *   value).
             */
            fun rawReturnReasonCode(): String =
                rawReturnReasonCode.getRequired("raw_return_reason_code")

            /**
             * Why the ACH Transfer was returned. This reason code is sent by the receiving bank
             * back to Increase.
             *
             * @throws IncreaseInvalidDataException if the JSON field has an unexpected type or is
             *   unexpectedly missing or null (e.g. if the server responded with an unexpected
             *   value).
             */
            fun returnReasonCode(): ReturnReasonCode =
                returnReasonCode.getRequired("return_reason_code")

            /**
             * A 15 digit number that was generated by the bank that initiated the return. The trace
             * number of the return is different than that of the original transfer. ACH trace
             * numbers are not unique, but along with the amount and date this number can be used to
             * identify the ACH return at the bank that initiated it.
             *
             * @throws IncreaseInvalidDataException if the JSON field has an unexpected type or is
             *   unexpectedly missing or null (e.g. if the server responded with an unexpected
             *   value).
             */
            fun traceNumber(): String = traceNumber.getRequired("trace_number")

            /**
             * The identifier of the Transaction associated with this return.
             *
             * @throws IncreaseInvalidDataException if the JSON field has an unexpected type or is
             *   unexpectedly missing or null (e.g. if the server responded with an unexpected
             *   value).
             */
            fun transactionId(): String = transactionId.getRequired("transaction_id")

            /**
             * The identifier of the ACH Transfer associated with this return.
             *
             * @throws IncreaseInvalidDataException if the JSON field has an unexpected type or is
             *   unexpectedly missing or null (e.g. if the server responded with an unexpected
             *   value).
             */
            fun transferId(): String = transferId.getRequired("transfer_id")

            /**
             * Returns the raw JSON value of [createdAt].
             *
             * Unlike [createdAt], this method doesn't throw if the JSON field has an unexpected
             * type.
             */
            @JsonProperty("created_at")
            @ExcludeMissing
            fun _createdAt(): JsonField<OffsetDateTime> = createdAt

            /**
             * Returns the raw JSON value of [rawReturnReasonCode].
             *
             * Unlike [rawReturnReasonCode], this method doesn't throw if the JSON field has an
             * unexpected type.
             */
            @JsonProperty("raw_return_reason_code")
            @ExcludeMissing
            fun _rawReturnReasonCode(): JsonField<String> = rawReturnReasonCode

            /**
             * Returns the raw JSON value of [returnReasonCode].
             *
             * Unlike [returnReasonCode], this method doesn't throw if the JSON field has an
             * unexpected type.
             */
            @JsonProperty("return_reason_code")
            @ExcludeMissing
            fun _returnReasonCode(): JsonField<ReturnReasonCode> = returnReasonCode

            /**
             * Returns the raw JSON value of [traceNumber].
             *
             * Unlike [traceNumber], this method doesn't throw if the JSON field has an unexpected
             * type.
             */
            @JsonProperty("trace_number")
            @ExcludeMissing
            fun _traceNumber(): JsonField<String> = traceNumber

            /**
             * Returns the raw JSON value of [transactionId].
             *
             * Unlike [transactionId], this method doesn't throw if the JSON field has an unexpected
             * type.
             */
            @JsonProperty("transaction_id")
            @ExcludeMissing
            fun _transactionId(): JsonField<String> = transactionId

            /**
             * Returns the raw JSON value of [transferId].
             *
             * Unlike [transferId], this method doesn't throw if the JSON field has an unexpected
             * type.
             */
            @JsonProperty("transfer_id")
            @ExcludeMissing
            fun _transferId(): JsonField<String> = transferId

            @JsonAnySetter
            private fun putAdditionalProperty(key: String, value: JsonValue) {
                additionalProperties.put(key, value)
            }

            @JsonAnyGetter
            @ExcludeMissing
            fun _additionalProperties(): Map<String, JsonValue> =
                Collections.unmodifiableMap(additionalProperties)

            fun toBuilder() = Builder().from(this)

            companion object {

                /**
                 * Returns a mutable builder for constructing an instance of [AchTransferReturn].
                 *
                 * The following fields are required:
                 * ```java
                 * .createdAt()
                 * .rawReturnReasonCode()
                 * .returnReasonCode()
                 * .traceNumber()
                 * .transactionId()
                 * .transferId()
                 * ```
                 */
                @JvmStatic fun builder() = Builder()
            }

            /** A builder for [AchTransferReturn]. */
            class Builder internal constructor() {

                private var createdAt: JsonField<OffsetDateTime>? = null
                private var rawReturnReasonCode: JsonField<String>? = null
                private var returnReasonCode: JsonField<ReturnReasonCode>? = null
                private var traceNumber: JsonField<String>? = null
                private var transactionId: JsonField<String>? = null
                private var transferId: JsonField<String>? = null
                private var additionalProperties: MutableMap<String, JsonValue> = mutableMapOf()

                @JvmSynthetic
                internal fun from(achTransferReturn: AchTransferReturn) = apply {
                    createdAt = achTransferReturn.createdAt
                    rawReturnReasonCode = achTransferReturn.rawReturnReasonCode
                    returnReasonCode = achTransferReturn.returnReasonCode
                    traceNumber = achTransferReturn.traceNumber
                    transactionId = achTransferReturn.transactionId
                    transferId = achTransferReturn.transferId
                    additionalProperties = achTransferReturn.additionalProperties.toMutableMap()
                }

                /**
                 * The [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) date and time at which the
                 * transfer was created.
                 */
                fun createdAt(createdAt: OffsetDateTime) = createdAt(JsonField.of(createdAt))

                /**
                 * Sets [Builder.createdAt] to an arbitrary JSON value.
                 *
                 * You should usually call [Builder.createdAt] with a well-typed [OffsetDateTime]
                 * value instead. This method is primarily for setting the field to an undocumented
                 * or not yet supported value.
                 */
                fun createdAt(createdAt: JsonField<OffsetDateTime>) = apply {
                    this.createdAt = createdAt
                }

                /** The three character ACH return code, in the range R01 to R85. */
                fun rawReturnReasonCode(rawReturnReasonCode: String) =
                    rawReturnReasonCode(JsonField.of(rawReturnReasonCode))

                /**
                 * Sets [Builder.rawReturnReasonCode] to an arbitrary JSON value.
                 *
                 * You should usually call [Builder.rawReturnReasonCode] with a well-typed [String]
                 * value instead. This method is primarily for setting the field to an undocumented
                 * or not yet supported value.
                 */
                fun rawReturnReasonCode(rawReturnReasonCode: JsonField<String>) = apply {
                    this.rawReturnReasonCode = rawReturnReasonCode
                }

                /**
                 * Why the ACH Transfer was returned. This reason code is sent by the receiving bank
                 * back to Increase.
                 */
                fun returnReasonCode(returnReasonCode: ReturnReasonCode) =
                    returnReasonCode(JsonField.of(returnReasonCode))

                /**
                 * Sets [Builder.returnReasonCode] to an arbitrary JSON value.
                 *
                 * You should usually call [Builder.returnReasonCode] with a well-typed
                 * [ReturnReasonCode] value instead. This method is primarily for setting the field
                 * to an undocumented or not yet supported value.
                 */
                fun returnReasonCode(returnReasonCode: JsonField<ReturnReasonCode>) = apply {
                    this.returnReasonCode = returnReasonCode
                }

                /**
                 * A 15 digit number that was generated by the bank that initiated the return. The
                 * trace number of the return is different than that of the original transfer. ACH
                 * trace numbers are not unique, but along with the amount and date this number can
                 * be used to identify the ACH return at the bank that initiated it.
                 */
                fun traceNumber(traceNumber: String) = traceNumber(JsonField.of(traceNumber))

                /**
                 * Sets [Builder.traceNumber] to an arbitrary JSON value.
                 *
                 * You should usually call [Builder.traceNumber] with a well-typed [String] value
                 * instead. This method is primarily for setting the field to an undocumented or not
                 * yet supported value.
                 */
                fun traceNumber(traceNumber: JsonField<String>) = apply {
                    this.traceNumber = traceNumber
                }

                /** The identifier of the Transaction associated with this return. */
                fun transactionId(transactionId: String) =
                    transactionId(JsonField.of(transactionId))

                /**
                 * Sets [Builder.transactionId] to an arbitrary JSON value.
                 *
                 * You should usually call [Builder.transactionId] with a well-typed [String] value
                 * instead. This method is primarily for setting the field to an undocumented or not
                 * yet supported value.
                 */
                fun transactionId(transactionId: JsonField<String>) = apply {
                    this.transactionId = transactionId
                }

                /** The identifier of the ACH Transfer associated with this return. */
                fun transferId(transferId: String) = transferId(JsonField.of(transferId))

                /**
                 * Sets [Builder.transferId] to an arbitrary JSON value.
                 *
                 * You should usually call [Builder.transferId] with a well-typed [String] value
                 * instead. This method is primarily for setting the field to an undocumented or not
                 * yet supported value.
                 */
                fun transferId(transferId: JsonField<String>) = apply {
                    this.transferId = transferId
                }

                fun additionalProperties(additionalProperties: Map<String, JsonValue>) = apply {
                    this.additionalProperties.clear()
                    putAllAdditionalProperties(additionalProperties)
                }

                fun putAdditionalProperty(key: String, value: JsonValue) = apply {
                    additionalProperties.put(key, value)
                }

                fun putAllAdditionalProperties(additionalProperties: Map<String, JsonValue>) =
                    apply {
                        this.additionalProperties.putAll(additionalProperties)
                    }

                fun removeAdditionalProperty(key: String) = apply {
                    additionalProperties.remove(key)
                }

                fun removeAllAdditionalProperties(keys: Set<String>) = apply {
                    keys.forEach(::removeAdditionalProperty)
                }

                /**
                 * Returns an immutable instance of [AchTransferReturn].
                 *
                 * Further updates to this [Builder] will not mutate the returned instance.
                 *
                 * The following fields are required:
                 * ```java
                 * .createdAt()
                 * .rawReturnReasonCode()
                 * .returnReasonCode()
                 * .traceNumber()
                 * .transactionId()
                 * .transferId()
                 * ```
                 *
                 * @throws IllegalStateException if any required field is unset.
                 */
                fun build(): AchTransferReturn =
                    AchTransferReturn(
                        checkRequired("createdAt", createdAt),
                        checkRequired("rawReturnReasonCode", rawReturnReasonCode),
                        checkRequired("returnReasonCode", returnReasonCode),
                        checkRequired("traceNumber", traceNumber),
                        checkRequired("transactionId", transactionId),
                        checkRequired("transferId", transferId),
                        additionalProperties.toMutableMap(),
                    )
            }

            private var validated: Boolean = false

            fun validate(): AchTransferReturn = apply {
                if (validated) {
                    return@apply
                }

                createdAt()
                rawReturnReasonCode()
                returnReasonCode().validate()
                traceNumber()
                transactionId()
                transferId()
                validated = true
            }

            fun isValid(): Boolean =
                try {
                    validate()
                    true
                } catch (e: IncreaseInvalidDataException) {
                    false
                }

            /**
             * Returns a score indicating how many valid values are contained in this object
             * recursively.
             *
             * Used for best match union deserialization.
             */
            @JvmSynthetic
            internal fun validity(): Int =
                (if (createdAt.asKnown().isPresent) 1 else 0) +
                    (if (rawReturnReasonCode.asKnown().isPresent) 1 else 0) +
                    (returnReasonCode.asKnown().getOrNull()?.validity() ?: 0) +
                    (if (traceNumber.asKnown().isPresent) 1 else 0) +
                    (if (transactionId.asKnown().isPresent) 1 else 0) +
                    (if (transferId.asKnown().isPresent) 1 else 0)

            /**
             * Why the ACH Transfer was returned. This reason code is sent by the receiving bank
             * back to Increase.
             */
            class ReturnReasonCode
            @JsonCreator
            private constructor(private val value: JsonField<String>) : Enum {

                /**
                 * Returns this class instance's raw value.
                 *
                 * This is usually only useful if this instance was deserialized from data that
                 * doesn't match any known member, and you want to know that value. For example, if
                 * the SDK is on an older version than the API, then the API may respond with new
                 * members that the SDK is unaware of.
                 */
                @com.fasterxml.jackson.annotation.JsonValue fun _value(): JsonField<String> = value

                companion object {

                    /**
                     * Code R01. Insufficient funds in the receiving account. Sometimes abbreviated
                     * to NSF.
                     */
                    @JvmField val INSUFFICIENT_FUND = of("insufficient_fund")

                    /**
                     * Code R03. The account does not exist or the receiving bank was unable to
                     * locate it.
                     */
                    @JvmField val NO_ACCOUNT = of("no_account")

                    /** Code R02. The account is closed at the receiving bank. */
                    @JvmField val ACCOUNT_CLOSED = of("account_closed")

                    /** Code R04. The account number is invalid at the receiving bank. */
                    @JvmField
                    val INVALID_ACCOUNT_NUMBER_STRUCTURE = of("invalid_account_number_structure")

                    /**
                     * Code R16. The account at the receiving bank was frozen per the Office of
                     * Foreign Assets Control.
                     */
                    @JvmField
                    val ACCOUNT_FROZEN_ENTRY_RETURNED_PER_OFAC_INSTRUCTION =
                        of("account_frozen_entry_returned_per_ofac_instruction")

                    /** Code R23. The receiving bank account refused a credit transfer. */
                    @JvmField
                    val CREDIT_ENTRY_REFUSED_BY_RECEIVER = of("credit_entry_refused_by_receiver")

                    /**
                     * Code R05. The receiving bank rejected because of an incorrect Standard Entry
                     * Class code.
                     */
                    @JvmField
                    val UNAUTHORIZED_DEBIT_TO_CONSUMER_ACCOUNT_USING_CORPORATE_SEC_CODE =
                        of("unauthorized_debit_to_consumer_account_using_corporate_sec_code")

                    /**
                     * Code R29. The corporate customer at the receiving bank reversed the transfer.
                     */
                    @JvmField
                    val CORPORATE_CUSTOMER_ADVISED_NOT_AUTHORIZED =
                        of("corporate_customer_advised_not_authorized")

                    /** Code R08. The receiving bank stopped payment on this transfer. */
                    @JvmField val PAYMENT_STOPPED = of("payment_stopped")

                    /** Code R20. The receiving bank account does not perform transfers. */
                    @JvmField val NON_TRANSACTION_ACCOUNT = of("non_transaction_account")

                    /**
                     * Code R09. The receiving bank account does not have enough available balance
                     * for the transfer.
                     */
                    @JvmField val UNCOLLECTED_FUNDS = of("uncollected_funds")

                    /** Code R28. The routing number is incorrect. */
                    @JvmField
                    val ROUTING_NUMBER_CHECK_DIGIT_ERROR = of("routing_number_check_digit_error")

                    /** Code R10. The customer at the receiving bank reversed the transfer. */
                    @JvmField
                    val CUSTOMER_ADVISED_UNAUTHORIZED_IMPROPER_INELIGIBLE_OR_INCOMPLETE =
                        of("customer_advised_unauthorized_improper_ineligible_or_incomplete")

                    /** Code R19. The amount field is incorrect or too large. */
                    @JvmField val AMOUNT_FIELD_ERROR = of("amount_field_error")

                    /**
                     * Code R07. The customer at the receiving institution informed their bank that
                     * they have revoked authorization for a previously authorized transfer.
                     */
                    @JvmField
                    val AUTHORIZATION_REVOKED_BY_CUSTOMER = of("authorization_revoked_by_customer")

                    /** Code R13. The routing number is invalid. */
                    @JvmField val INVALID_ACH_ROUTING_NUMBER = of("invalid_ach_routing_number")

                    /**
                     * Code R17. The receiving bank is unable to process a field in the transfer.
                     */
                    @JvmField val FILE_RECORD_EDIT_CRITERIA = of("file_record_edit_criteria")

                    /** Code R45. The individual name field was invalid. */
                    @JvmField val ENR_INVALID_INDIVIDUAL_NAME = of("enr_invalid_individual_name")

                    /**
                     * Code R06. The originating financial institution asked for this transfer to be
                     * returned. The receiving bank is complying with the request.
                     */
                    @JvmField val RETURNED_PER_ODFI_REQUEST = of("returned_per_odfi_request")

                    /**
                     * Code R34. The receiving bank's regulatory supervisor has limited their
                     * participation in the ACH network.
                     */
                    @JvmField val LIMITED_PARTICIPATION_DFI = of("limited_participation_dfi")

                    /** Code R85. The outbound international ACH transfer was incorrect. */
                    @JvmField
                    val INCORRECTLY_CODED_OUTBOUND_INTERNATIONAL_PAYMENT =
                        of("incorrectly_coded_outbound_international_payment")

                    /** Code R12. A rare return reason. The account was sold to another bank. */
                    @JvmField val ACCOUNT_SOLD_TO_ANOTHER_DFI = of("account_sold_to_another_dfi")

                    /** Code R25. The addenda record is incorrect or missing. */
                    @JvmField val ADDENDA_ERROR = of("addenda_error")

                    /** Code R15. A rare return reason. The account holder is deceased. */
                    @JvmField
                    val BENEFICIARY_OR_ACCOUNT_HOLDER_DECEASED =
                        of("beneficiary_or_account_holder_deceased")

                    /**
                     * Code R11. A rare return reason. The customer authorized some payment to the
                     * sender, but this payment was not in error.
                     */
                    @JvmField
                    val CUSTOMER_ADVISED_NOT_WITHIN_AUTHORIZATION_TERMS =
                        of("customer_advised_not_within_authorization_terms")

                    /**
                     * Code R74. A rare return reason. Sent in response to a return that was
                     * returned with code `field_error`. The latest return should include the
                     * corrected field(s).
                     */
                    @JvmField val CORRECTED_RETURN = of("corrected_return")

                    /**
                     * Code R24. A rare return reason. The receiving bank received an exact
                     * duplicate entry with the same trace number and amount.
                     */
                    @JvmField val DUPLICATE_ENTRY = of("duplicate_entry")

                    /**
                     * Code R67. A rare return reason. The return this message refers to was a
                     * duplicate.
                     */
                    @JvmField val DUPLICATE_RETURN = of("duplicate_return")

                    /**
                     * Code R47. A rare return reason. Only used for US Government agency
                     * non-monetary automatic enrollment messages.
                     */
                    @JvmField val ENR_DUPLICATE_ENROLLMENT = of("enr_duplicate_enrollment")

                    /**
                     * Code R43. A rare return reason. Only used for US Government agency
                     * non-monetary automatic enrollment messages.
                     */
                    @JvmField
                    val ENR_INVALID_DFI_ACCOUNT_NUMBER = of("enr_invalid_dfi_account_number")

                    /**
                     * Code R44. A rare return reason. Only used for US Government agency
                     * non-monetary automatic enrollment messages.
                     */
                    @JvmField
                    val ENR_INVALID_INDIVIDUAL_ID_NUMBER = of("enr_invalid_individual_id_number")

                    /**
                     * Code R46. A rare return reason. Only used for US Government agency
                     * non-monetary automatic enrollment messages.
                     */
                    @JvmField
                    val ENR_INVALID_REPRESENTATIVE_PAYEE_INDICATOR =
                        of("enr_invalid_representative_payee_indicator")

                    /**
                     * Code R41. A rare return reason. Only used for US Government agency
                     * non-monetary automatic enrollment messages.
                     */
                    @JvmField val ENR_INVALID_TRANSACTION_CODE = of("enr_invalid_transaction_code")

                    /**
                     * Code R40. A rare return reason. Only used for US Government agency
                     * non-monetary automatic enrollment messages.
                     */
                    @JvmField val ENR_RETURN_OF_ENR_ENTRY = of("enr_return_of_enr_entry")

                    /**
                     * Code R42. A rare return reason. Only used for US Government agency
                     * non-monetary automatic enrollment messages.
                     */
                    @JvmField
                    val ENR_ROUTING_NUMBER_CHECK_DIGIT_ERROR =
                        of("enr_routing_number_check_digit_error")

                    /**
                     * Code R84. A rare return reason. The International ACH Transfer cannot be
                     * processed by the gateway.
                     */
                    @JvmField
                    val ENTRY_NOT_PROCESSED_BY_GATEWAY = of("entry_not_processed_by_gateway")

                    /**
                     * Code R69. A rare return reason. One or more of the fields in the ACH were
                     * malformed.
                     */
                    @JvmField val FIELD_ERROR = of("field_error")

                    /**
                     * Code R83. A rare return reason. The Foreign receiving bank was unable to
                     * settle this ACH transfer.
                     */
                    @JvmField
                    val FOREIGN_RECEIVING_DFI_UNABLE_TO_SETTLE =
                        of("foreign_receiving_dfi_unable_to_settle")

                    /**
                     * Code R80. A rare return reason. The International ACH Transfer is malformed.
                     */
                    @JvmField val IAT_ENTRY_CODING_ERROR = of("iat_entry_coding_error")

                    /**
                     * Code R18. A rare return reason. The ACH has an improper effective entry date
                     * field.
                     */
                    @JvmField
                    val IMPROPER_EFFECTIVE_ENTRY_DATE = of("improper_effective_entry_date")

                    /**
                     * Code R39. A rare return reason. The source document related to this ACH,
                     * usually an ACH check conversion, was presented to the bank.
                     */
                    @JvmField
                    val IMPROPER_SOURCE_DOCUMENT_SOURCE_DOCUMENT_PRESENTED =
                        of("improper_source_document_source_document_presented")

                    /**
                     * Code R21. A rare return reason. The Company ID field of the ACH was invalid.
                     */
                    @JvmField val INVALID_COMPANY_ID = of("invalid_company_id")

                    /**
                     * Code R82. A rare return reason. The foreign receiving bank identifier for an
                     * International ACH Transfer was invalid.
                     */
                    @JvmField
                    val INVALID_FOREIGN_RECEIVING_DFI_IDENTIFICATION =
                        of("invalid_foreign_receiving_dfi_identification")

                    /**
                     * Code R22. A rare return reason. The Individual ID number field of the ACH was
                     * invalid.
                     */
                    @JvmField val INVALID_INDIVIDUAL_ID_NUMBER = of("invalid_individual_id_number")

                    /**
                     * Code R53. A rare return reason. Both the Represented Check ("RCK") entry and
                     * the original check were presented to the bank.
                     */
                    @JvmField
                    val ITEM_AND_RCK_ENTRY_PRESENTED_FOR_PAYMENT =
                        of("item_and_rck_entry_presented_for_payment")

                    /**
                     * Code R51. A rare return reason. The Represented Check ("RCK") entry is
                     * ineligible.
                     */
                    @JvmField
                    val ITEM_RELATED_TO_RCK_ENTRY_IS_INELIGIBLE =
                        of("item_related_to_rck_entry_is_ineligible")

                    /** Code R26. A rare return reason. The ACH is missing a required field. */
                    @JvmField val MANDATORY_FIELD_ERROR = of("mandatory_field_error")

                    /**
                     * Code R71. A rare return reason. The receiving bank does not recognize the
                     * routing number in a dishonored return entry.
                     */
                    @JvmField val MISROUTED_DISHONORED_RETURN = of("misrouted_dishonored_return")

                    /**
                     * Code R61. A rare return reason. The receiving bank does not recognize the
                     * routing number in a return entry.
                     */
                    @JvmField val MISROUTED_RETURN = of("misrouted_return")

                    /**
                     * Code R76. A rare return reason. Sent in response to a return, the bank does
                     * not find the errors alleged by the returning bank.
                     */
                    @JvmField val NO_ERRORS_FOUND = of("no_errors_found")

                    /**
                     * Code R77. A rare return reason. The receiving bank does not accept the return
                     * of the erroneous debit. The funds are not available at the receiving bank.
                     */
                    @JvmField
                    val NON_ACCEPTANCE_OF_R62_DISHONORED_RETURN =
                        of("non_acceptance_of_r62_dishonored_return")

                    /**
                     * Code R81. A rare return reason. The receiving bank does not accept
                     * International ACH Transfers.
                     */
                    @JvmField
                    val NON_PARTICIPANT_IN_IAT_PROGRAM = of("non_participant_in_iat_program")

                    /**
                     * Code R31. A rare return reason. A return that has been agreed to be accepted
                     * by the receiving bank, despite falling outside of the usual return timeframe.
                     */
                    @JvmField val PERMISSIBLE_RETURN_ENTRY = of("permissible_return_entry")

                    /**
                     * Code R70. A rare return reason. The receiving bank had not approved this
                     * return.
                     */
                    @JvmField
                    val PERMISSIBLE_RETURN_ENTRY_NOT_ACCEPTED =
                        of("permissible_return_entry_not_accepted")

                    /**
                     * Code R32. A rare return reason. The receiving bank could not settle this
                     * transaction.
                     */
                    @JvmField val RDFI_NON_SETTLEMENT = of("rdfi_non_settlement")

                    /**
                     * Code R30. A rare return reason. The receiving bank does not accept Check
                     * Truncation ACH transfers.
                     */
                    @JvmField
                    val RDFI_PARTICIPANT_IN_CHECK_TRUNCATION_PROGRAM =
                        of("rdfi_participant_in_check_truncation_program")

                    /** Code R14. A rare return reason. The payee is deceased. */
                    @JvmField
                    val REPRESENTATIVE_PAYEE_DECEASED_OR_UNABLE_TO_CONTINUE_IN_THAT_CAPACITY =
                        of("representative_payee_deceased_or_unable_to_continue_in_that_capacity")

                    /**
                     * Code R75. A rare return reason. The originating bank disputes that an earlier
                     * `duplicate_entry` return was actually a duplicate.
                     */
                    @JvmField val RETURN_NOT_A_DUPLICATE = of("return_not_a_duplicate")

                    /**
                     * Code R62. A rare return reason. The originating financial institution made a
                     * mistake and this return corrects it.
                     */
                    @JvmField
                    val RETURN_OF_ERRONEOUS_OR_REVERSING_DEBIT =
                        of("return_of_erroneous_or_reversing_debit")

                    /** Code R36. A rare return reason. Return of a malformed credit entry. */
                    @JvmField
                    val RETURN_OF_IMPROPER_CREDIT_ENTRY = of("return_of_improper_credit_entry")

                    /** Code R35. A rare return reason. Return of a malformed debit entry. */
                    @JvmField
                    val RETURN_OF_IMPROPER_DEBIT_ENTRY = of("return_of_improper_debit_entry")

                    /**
                     * Code R33. A rare return reason. Return of a Destroyed Check ("XKC") entry.
                     */
                    @JvmField val RETURN_OF_XCK_ENTRY = of("return_of_xck_entry")

                    /**
                     * Code R37. A rare return reason. The source document related to this ACH,
                     * usually an ACH check conversion, was presented to the bank.
                     */
                    @JvmField
                    val SOURCE_DOCUMENT_PRESENTED_FOR_PAYMENT =
                        of("source_document_presented_for_payment")

                    /**
                     * Code R50. A rare return reason. State law prevents the bank from accepting
                     * the Represented Check ("RCK") entry.
                     */
                    @JvmField
                    val STATE_LAW_AFFECTING_RCK_ACCEPTANCE =
                        of("state_law_affecting_rck_acceptance")

                    /**
                     * Code R52. A rare return reason. A stop payment was issued on a Represented
                     * Check ("RCK") entry.
                     */
                    @JvmField
                    val STOP_PAYMENT_ON_ITEM_RELATED_TO_RCK_ENTRY =
                        of("stop_payment_on_item_related_to_rck_entry")

                    /**
                     * Code R38. A rare return reason. The source attached to the ACH, usually an
                     * ACH check conversion, includes a stop payment.
                     */
                    @JvmField
                    val STOP_PAYMENT_ON_SOURCE_DOCUMENT = of("stop_payment_on_source_document")

                    /**
                     * Code R73. A rare return reason. The bank receiving an `untimely_return`
                     * believes it was on time.
                     */
                    @JvmField val TIMELY_ORIGINAL_RETURN = of("timely_original_return")

                    /**
                     * Code R27. A rare return reason. An ACH return's trace number does not match
                     * an originated ACH.
                     */
                    @JvmField val TRACE_NUMBER_ERROR = of("trace_number_error")

                    /** Code R72. A rare return reason. The dishonored return was sent too late. */
                    @JvmField val UNTIMELY_DISHONORED_RETURN = of("untimely_dishonored_return")

                    /** Code R68. A rare return reason. The return was sent too late. */
                    @JvmField val UNTIMELY_RETURN = of("untimely_return")

                    @JvmStatic fun of(value: String) = ReturnReasonCode(JsonField.of(value))
                }

                /** An enum containing [ReturnReasonCode]'s known values. */
                enum class Known {
                    /**
                     * Code R01. Insufficient funds in the receiving account. Sometimes abbreviated
                     * to NSF.
                     */
                    INSUFFICIENT_FUND,
                    /**
                     * Code R03. The account does not exist or the receiving bank was unable to
                     * locate it.
                     */
                    NO_ACCOUNT,
                    /** Code R02. The account is closed at the receiving bank. */
                    ACCOUNT_CLOSED,
                    /** Code R04. The account number is invalid at the receiving bank. */
                    INVALID_ACCOUNT_NUMBER_STRUCTURE,
                    /**
                     * Code R16. The account at the receiving bank was frozen per the Office of
                     * Foreign Assets Control.
                     */
                    ACCOUNT_FROZEN_ENTRY_RETURNED_PER_OFAC_INSTRUCTION,
                    /** Code R23. The receiving bank account refused a credit transfer. */
                    CREDIT_ENTRY_REFUSED_BY_RECEIVER,
                    /**
                     * Code R05. The receiving bank rejected because of an incorrect Standard Entry
                     * Class code.
                     */
                    UNAUTHORIZED_DEBIT_TO_CONSUMER_ACCOUNT_USING_CORPORATE_SEC_CODE,
                    /**
                     * Code R29. The corporate customer at the receiving bank reversed the transfer.
                     */
                    CORPORATE_CUSTOMER_ADVISED_NOT_AUTHORIZED,
                    /** Code R08. The receiving bank stopped payment on this transfer. */
                    PAYMENT_STOPPED,
                    /** Code R20. The receiving bank account does not perform transfers. */
                    NON_TRANSACTION_ACCOUNT,
                    /**
                     * Code R09. The receiving bank account does not have enough available balance
                     * for the transfer.
                     */
                    UNCOLLECTED_FUNDS,
                    /** Code R28. The routing number is incorrect. */
                    ROUTING_NUMBER_CHECK_DIGIT_ERROR,
                    /** Code R10. The customer at the receiving bank reversed the transfer. */
                    CUSTOMER_ADVISED_UNAUTHORIZED_IMPROPER_INELIGIBLE_OR_INCOMPLETE,
                    /** Code R19. The amount field is incorrect or too large. */
                    AMOUNT_FIELD_ERROR,
                    /**
                     * Code R07. The customer at the receiving institution informed their bank that
                     * they have revoked authorization for a previously authorized transfer.
                     */
                    AUTHORIZATION_REVOKED_BY_CUSTOMER,
                    /** Code R13. The routing number is invalid. */
                    INVALID_ACH_ROUTING_NUMBER,
                    /**
                     * Code R17. The receiving bank is unable to process a field in the transfer.
                     */
                    FILE_RECORD_EDIT_CRITERIA,
                    /** Code R45. The individual name field was invalid. */
                    ENR_INVALID_INDIVIDUAL_NAME,
                    /**
                     * Code R06. The originating financial institution asked for this transfer to be
                     * returned. The receiving bank is complying with the request.
                     */
                    RETURNED_PER_ODFI_REQUEST,
                    /**
                     * Code R34. The receiving bank's regulatory supervisor has limited their
                     * participation in the ACH network.
                     */
                    LIMITED_PARTICIPATION_DFI,
                    /** Code R85. The outbound international ACH transfer was incorrect. */
                    INCORRECTLY_CODED_OUTBOUND_INTERNATIONAL_PAYMENT,
                    /** Code R12. A rare return reason. The account was sold to another bank. */
                    ACCOUNT_SOLD_TO_ANOTHER_DFI,
                    /** Code R25. The addenda record is incorrect or missing. */
                    ADDENDA_ERROR,
                    /** Code R15. A rare return reason. The account holder is deceased. */
                    BENEFICIARY_OR_ACCOUNT_HOLDER_DECEASED,
                    /**
                     * Code R11. A rare return reason. The customer authorized some payment to the
                     * sender, but this payment was not in error.
                     */
                    CUSTOMER_ADVISED_NOT_WITHIN_AUTHORIZATION_TERMS,
                    /**
                     * Code R74. A rare return reason. Sent in response to a return that was
                     * returned with code `field_error`. The latest return should include the
                     * corrected field(s).
                     */
                    CORRECTED_RETURN,
                    /**
                     * Code R24. A rare return reason. The receiving bank received an exact
                     * duplicate entry with the same trace number and amount.
                     */
                    DUPLICATE_ENTRY,
                    /**
                     * Code R67. A rare return reason. The return this message refers to was a
                     * duplicate.
                     */
                    DUPLICATE_RETURN,
                    /**
                     * Code R47. A rare return reason. Only used for US Government agency
                     * non-monetary automatic enrollment messages.
                     */
                    ENR_DUPLICATE_ENROLLMENT,
                    /**
                     * Code R43. A rare return reason. Only used for US Government agency
                     * non-monetary automatic enrollment messages.
                     */
                    ENR_INVALID_DFI_ACCOUNT_NUMBER,
                    /**
                     * Code R44. A rare return reason. Only used for US Government agency
                     * non-monetary automatic enrollment messages.
                     */
                    ENR_INVALID_INDIVIDUAL_ID_NUMBER,
                    /**
                     * Code R46. A rare return reason. Only used for US Government agency
                     * non-monetary automatic enrollment messages.
                     */
                    ENR_INVALID_REPRESENTATIVE_PAYEE_INDICATOR,
                    /**
                     * Code R41. A rare return reason. Only used for US Government agency
                     * non-monetary automatic enrollment messages.
                     */
                    ENR_INVALID_TRANSACTION_CODE,
                    /**
                     * Code R40. A rare return reason. Only used for US Government agency
                     * non-monetary automatic enrollment messages.
                     */
                    ENR_RETURN_OF_ENR_ENTRY,
                    /**
                     * Code R42. A rare return reason. Only used for US Government agency
                     * non-monetary automatic enrollment messages.
                     */
                    ENR_ROUTING_NUMBER_CHECK_DIGIT_ERROR,
                    /**
                     * Code R84. A rare return reason. The International ACH Transfer cannot be
                     * processed by the gateway.
                     */
                    ENTRY_NOT_PROCESSED_BY_GATEWAY,
                    /**
                     * Code R69. A rare return reason. One or more of the fields in the ACH were
                     * malformed.
                     */
                    FIELD_ERROR,
                    /**
                     * Code R83. A rare return reason. The Foreign receiving bank was unable to
                     * settle this ACH transfer.
                     */
                    FOREIGN_RECEIVING_DFI_UNABLE_TO_SETTLE,
                    /**
                     * Code R80. A rare return reason. The International ACH Transfer is malformed.
                     */
                    IAT_ENTRY_CODING_ERROR,
                    /**
                     * Code R18. A rare return reason. The ACH has an improper effective entry date
                     * field.
                     */
                    IMPROPER_EFFECTIVE_ENTRY_DATE,
                    /**
                     * Code R39. A rare return reason. The source document related to this ACH,
                     * usually an ACH check conversion, was presented to the bank.
                     */
                    IMPROPER_SOURCE_DOCUMENT_SOURCE_DOCUMENT_PRESENTED,
                    /**
                     * Code R21. A rare return reason. The Company ID field of the ACH was invalid.
                     */
                    INVALID_COMPANY_ID,
                    /**
                     * Code R82. A rare return reason. The foreign receiving bank identifier for an
                     * International ACH Transfer was invalid.
                     */
                    INVALID_FOREIGN_RECEIVING_DFI_IDENTIFICATION,
                    /**
                     * Code R22. A rare return reason. The Individual ID number field of the ACH was
                     * invalid.
                     */
                    INVALID_INDIVIDUAL_ID_NUMBER,
                    /**
                     * Code R53. A rare return reason. Both the Represented Check ("RCK") entry and
                     * the original check were presented to the bank.
                     */
                    ITEM_AND_RCK_ENTRY_PRESENTED_FOR_PAYMENT,
                    /**
                     * Code R51. A rare return reason. The Represented Check ("RCK") entry is
                     * ineligible.
                     */
                    ITEM_RELATED_TO_RCK_ENTRY_IS_INELIGIBLE,
                    /** Code R26. A rare return reason. The ACH is missing a required field. */
                    MANDATORY_FIELD_ERROR,
                    /**
                     * Code R71. A rare return reason. The receiving bank does not recognize the
                     * routing number in a dishonored return entry.
                     */
                    MISROUTED_DISHONORED_RETURN,
                    /**
                     * Code R61. A rare return reason. The receiving bank does not recognize the
                     * routing number in a return entry.
                     */
                    MISROUTED_RETURN,
                    /**
                     * Code R76. A rare return reason. Sent in response to a return, the bank does
                     * not find the errors alleged by the returning bank.
                     */
                    NO_ERRORS_FOUND,
                    /**
                     * Code R77. A rare return reason. The receiving bank does not accept the return
                     * of the erroneous debit. The funds are not available at the receiving bank.
                     */
                    NON_ACCEPTANCE_OF_R62_DISHONORED_RETURN,
                    /**
                     * Code R81. A rare return reason. The receiving bank does not accept
                     * International ACH Transfers.
                     */
                    NON_PARTICIPANT_IN_IAT_PROGRAM,
                    /**
                     * Code R31. A rare return reason. A return that has been agreed to be accepted
                     * by the receiving bank, despite falling outside of the usual return timeframe.
                     */
                    PERMISSIBLE_RETURN_ENTRY,
                    /**
                     * Code R70. A rare return reason. The receiving bank had not approved this
                     * return.
                     */
                    PERMISSIBLE_RETURN_ENTRY_NOT_ACCEPTED,
                    /**
                     * Code R32. A rare return reason. The receiving bank could not settle this
                     * transaction.
                     */
                    RDFI_NON_SETTLEMENT,
                    /**
                     * Code R30. A rare return reason. The receiving bank does not accept Check
                     * Truncation ACH transfers.
                     */
                    RDFI_PARTICIPANT_IN_CHECK_TRUNCATION_PROGRAM,
                    /** Code R14. A rare return reason. The payee is deceased. */
                    REPRESENTATIVE_PAYEE_DECEASED_OR_UNABLE_TO_CONTINUE_IN_THAT_CAPACITY,
                    /**
                     * Code R75. A rare return reason. The originating bank disputes that an earlier
                     * `duplicate_entry` return was actually a duplicate.
                     */
                    RETURN_NOT_A_DUPLICATE,
                    /**
                     * Code R62. A rare return reason. The originating financial institution made a
                     * mistake and this return corrects it.
                     */
                    RETURN_OF_ERRONEOUS_OR_REVERSING_DEBIT,
                    /** Code R36. A rare return reason. Return of a malformed credit entry. */
                    RETURN_OF_IMPROPER_CREDIT_ENTRY,
                    /** Code R35. A rare return reason. Return of a malformed debit entry. */
                    RETURN_OF_IMPROPER_DEBIT_ENTRY,
                    /**
                     * Code R33. A rare return reason. Return of a Destroyed Check ("XKC") entry.
                     */
                    RETURN_OF_XCK_ENTRY,
                    /**
                     * Code R37. A rare return reason. The source document related to this ACH,
                     * usually an ACH check conversion, was presented to the bank.
                     */
                    SOURCE_DOCUMENT_PRESENTED_FOR_PAYMENT,
                    /**
                     * Code R50. A rare return reason. State law prevents the bank from accepting
                     * the Represented Check ("RCK") entry.
                     */
                    STATE_LAW_AFFECTING_RCK_ACCEPTANCE,
                    /**
                     * Code R52. A rare return reason. A stop payment was issued on a Represented
                     * Check ("RCK") entry.
                     */
                    STOP_PAYMENT_ON_ITEM_RELATED_TO_RCK_ENTRY,
                    /**
                     * Code R38. A rare return reason. The source attached to the ACH, usually an
                     * ACH check conversion, includes a stop payment.
                     */
                    STOP_PAYMENT_ON_SOURCE_DOCUMENT,
                    /**
                     * Code R73. A rare return reason. The bank receiving an `untimely_return`
                     * believes it was on time.
                     */
                    TIMELY_ORIGINAL_RETURN,
                    /**
                     * Code R27. A rare return reason. An ACH return's trace number does not match
                     * an originated ACH.
                     */
                    TRACE_NUMBER_ERROR,
                    /** Code R72. A rare return reason. The dishonored return was sent too late. */
                    UNTIMELY_DISHONORED_RETURN,
                    /** Code R68. A rare return reason. The return was sent too late. */
                    UNTIMELY_RETURN,
                }

                /**
                 * An enum containing [ReturnReasonCode]'s known values, as well as an [_UNKNOWN]
                 * member.
                 *
                 * An instance of [ReturnReasonCode] can contain an unknown value in a couple of
                 * cases:
                 * - It was deserialized from data that doesn't match any known member. For example,
                 *   if the SDK is on an older version than the API, then the API may respond with
                 *   new members that the SDK is unaware of.
                 * - It was constructed with an arbitrary value using the [of] method.
                 */
                enum class Value {
                    /**
                     * Code R01. Insufficient funds in the receiving account. Sometimes abbreviated
                     * to NSF.
                     */
                    INSUFFICIENT_FUND,
                    /**
                     * Code R03. The account does not exist or the receiving bank was unable to
                     * locate it.
                     */
                    NO_ACCOUNT,
                    /** Code R02. The account is closed at the receiving bank. */
                    ACCOUNT_CLOSED,
                    /** Code R04. The account number is invalid at the receiving bank. */
                    INVALID_ACCOUNT_NUMBER_STRUCTURE,
                    /**
                     * Code R16. The account at the receiving bank was frozen per the Office of
                     * Foreign Assets Control.
                     */
                    ACCOUNT_FROZEN_ENTRY_RETURNED_PER_OFAC_INSTRUCTION,
                    /** Code R23. The receiving bank account refused a credit transfer. */
                    CREDIT_ENTRY_REFUSED_BY_RECEIVER,
                    /**
                     * Code R05. The receiving bank rejected because of an incorrect Standard Entry
                     * Class code.
                     */
                    UNAUTHORIZED_DEBIT_TO_CONSUMER_ACCOUNT_USING_CORPORATE_SEC_CODE,
                    /**
                     * Code R29. The corporate customer at the receiving bank reversed the transfer.
                     */
                    CORPORATE_CUSTOMER_ADVISED_NOT_AUTHORIZED,
                    /** Code R08. The receiving bank stopped payment on this transfer. */
                    PAYMENT_STOPPED,
                    /** Code R20. The receiving bank account does not perform transfers. */
                    NON_TRANSACTION_ACCOUNT,
                    /**
                     * Code R09. The receiving bank account does not have enough available balance
                     * for the transfer.
                     */
                    UNCOLLECTED_FUNDS,
                    /** Code R28. The routing number is incorrect. */
                    ROUTING_NUMBER_CHECK_DIGIT_ERROR,
                    /** Code R10. The customer at the receiving bank reversed the transfer. */
                    CUSTOMER_ADVISED_UNAUTHORIZED_IMPROPER_INELIGIBLE_OR_INCOMPLETE,
                    /** Code R19. The amount field is incorrect or too large. */
                    AMOUNT_FIELD_ERROR,
                    /**
                     * Code R07. The customer at the receiving institution informed their bank that
                     * they have revoked authorization for a previously authorized transfer.
                     */
                    AUTHORIZATION_REVOKED_BY_CUSTOMER,
                    /** Code R13. The routing number is invalid. */
                    INVALID_ACH_ROUTING_NUMBER,
                    /**
                     * Code R17. The receiving bank is unable to process a field in the transfer.
                     */
                    FILE_RECORD_EDIT_CRITERIA,
                    /** Code R45. The individual name field was invalid. */
                    ENR_INVALID_INDIVIDUAL_NAME,
                    /**
                     * Code R06. The originating financial institution asked for this transfer to be
                     * returned. The receiving bank is complying with the request.
                     */
                    RETURNED_PER_ODFI_REQUEST,
                    /**
                     * Code R34. The receiving bank's regulatory supervisor has limited their
                     * participation in the ACH network.
                     */
                    LIMITED_PARTICIPATION_DFI,
                    /** Code R85. The outbound international ACH transfer was incorrect. */
                    INCORRECTLY_CODED_OUTBOUND_INTERNATIONAL_PAYMENT,
                    /** Code R12. A rare return reason. The account was sold to another bank. */
                    ACCOUNT_SOLD_TO_ANOTHER_DFI,
                    /** Code R25. The addenda record is incorrect or missing. */
                    ADDENDA_ERROR,
                    /** Code R15. A rare return reason. The account holder is deceased. */
                    BENEFICIARY_OR_ACCOUNT_HOLDER_DECEASED,
                    /**
                     * Code R11. A rare return reason. The customer authorized some payment to the
                     * sender, but this payment was not in error.
                     */
                    CUSTOMER_ADVISED_NOT_WITHIN_AUTHORIZATION_TERMS,
                    /**
                     * Code R74. A rare return reason. Sent in response to a return that was
                     * returned with code `field_error`. The latest return should include the
                     * corrected field(s).
                     */
                    CORRECTED_RETURN,
                    /**
                     * Code R24. A rare return reason. The receiving bank received an exact
                     * duplicate entry with the same trace number and amount.
                     */
                    DUPLICATE_ENTRY,
                    /**
                     * Code R67. A rare return reason. The return this message refers to was a
                     * duplicate.
                     */
                    DUPLICATE_RETURN,
                    /**
                     * Code R47. A rare return reason. Only used for US Government agency
                     * non-monetary automatic enrollment messages.
                     */
                    ENR_DUPLICATE_ENROLLMENT,
                    /**
                     * Code R43. A rare return reason. Only used for US Government agency
                     * non-monetary automatic enrollment messages.
                     */
                    ENR_INVALID_DFI_ACCOUNT_NUMBER,
                    /**
                     * Code R44. A rare return reason. Only used for US Government agency
                     * non-monetary automatic enrollment messages.
                     */
                    ENR_INVALID_INDIVIDUAL_ID_NUMBER,
                    /**
                     * Code R46. A rare return reason. Only used for US Government agency
                     * non-monetary automatic enrollment messages.
                     */
                    ENR_INVALID_REPRESENTATIVE_PAYEE_INDICATOR,
                    /**
                     * Code R41. A rare return reason. Only used for US Government agency
                     * non-monetary automatic enrollment messages.
                     */
                    ENR_INVALID_TRANSACTION_CODE,
                    /**
                     * Code R40. A rare return reason. Only used for US Government agency
                     * non-monetary automatic enrollment messages.
                     */
                    ENR_RETURN_OF_ENR_ENTRY,
                    /**
                     * Code R42. A rare return reason. Only used for US Government agency
                     * non-monetary automatic enrollment messages.
                     */
                    ENR_ROUTING_NUMBER_CHECK_DIGIT_ERROR,
                    /**
                     * Code R84. A rare return reason. The International ACH Transfer cannot be
                     * processed by the gateway.
                     */
                    ENTRY_NOT_PROCESSED_BY_GATEWAY,
                    /**
                     * Code R69. A rare return reason. One or more of the fields in the ACH were
                     * malformed.
                     */
                    FIELD_ERROR,
                    /**
                     * Code R83. A rare return reason. The Foreign receiving bank was unable to
                     * settle this ACH transfer.
                     */
                    FOREIGN_RECEIVING_DFI_UNABLE_TO_SETTLE,
                    /**
                     * Code R80. A rare return reason. The International ACH Transfer is malformed.
                     */
                    IAT_ENTRY_CODING_ERROR,
                    /**
                     * Code R18. A rare return reason. The ACH has an improper effective entry date
                     * field.
                     */
                    IMPROPER_EFFECTIVE_ENTRY_DATE,
                    /**
                     * Code R39. A rare return reason. The source document related to this ACH,
                     * usually an ACH check conversion, was presented to the bank.
                     */
                    IMPROPER_SOURCE_DOCUMENT_SOURCE_DOCUMENT_PRESENTED,
                    /**
                     * Code R21. A rare return reason. The Company ID field of the ACH was invalid.
                     */
                    INVALID_COMPANY_ID,
                    /**
                     * Code R82. A rare return reason. The foreign receiving bank identifier for an
                     * International ACH Transfer was invalid.
                     */
                    INVALID_FOREIGN_RECEIVING_DFI_IDENTIFICATION,
                    /**
                     * Code R22. A rare return reason. The Individual ID number field of the ACH was
                     * invalid.
                     */
                    INVALID_INDIVIDUAL_ID_NUMBER,
                    /**
                     * Code R53. A rare return reason. Both the Represented Check ("RCK") entry and
                     * the original check were presented to the bank.
                     */
                    ITEM_AND_RCK_ENTRY_PRESENTED_FOR_PAYMENT,
                    /**
                     * Code R51. A rare return reason. The Represented Check ("RCK") entry is
                     * ineligible.
                     */
                    ITEM_RELATED_TO_RCK_ENTRY_IS_INELIGIBLE,
                    /** Code R26. A rare return reason. The ACH is missing a required field. */
                    MANDATORY_FIELD_ERROR,
                    /**
                     * Code R71. A rare return reason. The receiving bank does not recognize the
                     * routing number in a dishonored return entry.
                     */
                    MISROUTED_DISHONORED_RETURN,
                    /**
                     * Code R61. A rare return reason. The receiving bank does not recognize the
                     * routing number in a return entry.
                     */
                    MISROUTED_RETURN,
                    /**
                     * Code R76. A rare return reason. Sent in response to a return, the bank does
                     * not find the errors alleged by the returning bank.
                     */
                    NO_ERRORS_FOUND,
                    /**
                     * Code R77. A rare return reason. The receiving bank does not accept the return
                     * of the erroneous debit. The funds are not available at the receiving bank.
                     */
                    NON_ACCEPTANCE_OF_R62_DISHONORED_RETURN,
                    /**
                     * Code R81. A rare return reason. The receiving bank does not accept
                     * International ACH Transfers.
                     */
                    NON_PARTICIPANT_IN_IAT_PROGRAM,
                    /**
                     * Code R31. A rare return reason. A return that has been agreed to be accepted
                     * by the receiving bank, despite falling outside of the usual return timeframe.
                     */
                    PERMISSIBLE_RETURN_ENTRY,
                    /**
                     * Code R70. A rare return reason. The receiving bank had not approved this
                     * return.
                     */
                    PERMISSIBLE_RETURN_ENTRY_NOT_ACCEPTED,
                    /**
                     * Code R32. A rare return reason. The receiving bank could not settle this
                     * transaction.
                     */
                    RDFI_NON_SETTLEMENT,
                    /**
                     * Code R30. A rare return reason. The receiving bank does not accept Check
                     * Truncation ACH transfers.
                     */
                    RDFI_PARTICIPANT_IN_CHECK_TRUNCATION_PROGRAM,
                    /** Code R14. A rare return reason. The payee is deceased. */
                    REPRESENTATIVE_PAYEE_DECEASED_OR_UNABLE_TO_CONTINUE_IN_THAT_CAPACITY,
                    /**
                     * Code R75. A rare return reason. The originating bank disputes that an earlier
                     * `duplicate_entry` return was actually a duplicate.
                     */
                    RETURN_NOT_A_DUPLICATE,
                    /**
                     * Code R62. A rare return reason. The originating financial institution made a
                     * mistake and this return corrects it.
                     */
                    RETURN_OF_ERRONEOUS_OR_REVERSING_DEBIT,
                    /** Code R36. A rare return reason. Return of a malformed credit entry. */
                    RETURN_OF_IMPROPER_CREDIT_ENTRY,
                    /** Code R35. A rare return reason. Return of a malformed debit entry. */
                    RETURN_OF_IMPROPER_DEBIT_ENTRY,
                    /**
                     * Code R33. A rare return reason. Return of a Destroyed Check ("XKC") entry.
                     */
                    RETURN_OF_XCK_ENTRY,
                    /**
                     * Code R37. A rare return reason. The source document related to this ACH,
                     * usually an ACH check conversion, was presented to the bank.
                     */
                    SOURCE_DOCUMENT_PRESENTED_FOR_PAYMENT,
                    /**
                     * Code R50. A rare return reason. State law prevents the bank from accepting
                     * the Represented Check ("RCK") entry.
                     */
                    STATE_LAW_AFFECTING_RCK_ACCEPTANCE,
                    /**
                     * Code R52. A rare return reason. A stop payment was issued on a Represented
                     * Check ("RCK") entry.
                     */
                    STOP_PAYMENT_ON_ITEM_RELATED_TO_RCK_ENTRY,
                    /**
                     * Code R38. A rare return reason. The source attached to the ACH, usually an
                     * ACH check conversion, includes a stop payment.
                     */
                    STOP_PAYMENT_ON_SOURCE_DOCUMENT,
                    /**
                     * Code R73. A rare return reason. The bank receiving an `untimely_return`
                     * believes it was on time.
                     */
                    TIMELY_ORIGINAL_RETURN,
                    /**
                     * Code R27. A rare return reason. An ACH return's trace number does not match
                     * an originated ACH.
                     */
                    TRACE_NUMBER_ERROR,
                    /** Code R72. A rare return reason. The dishonored return was sent too late. */
                    UNTIMELY_DISHONORED_RETURN,
                    /** Code R68. A rare return reason. The return was sent too late. */
                    UNTIMELY_RETURN,
                    /**
                     * An enum member indicating that [ReturnReasonCode] was instantiated with an
                     * unknown value.
                     */
                    _UNKNOWN,
                }

                /**
                 * Returns an enum member corresponding to this class instance's value, or
                 * [Value._UNKNOWN] if the class was instantiated with an unknown value.
                 *
                 * Use the [known] method instead if you're certain the value is always known or if
                 * you want to throw for the unknown case.
                 */
                fun value(): Value =
                    when (this) {
                        INSUFFICIENT_FUND -> Value.INSUFFICIENT_FUND
                        NO_ACCOUNT -> Value.NO_ACCOUNT
                        ACCOUNT_CLOSED -> Value.ACCOUNT_CLOSED
                        INVALID_ACCOUNT_NUMBER_STRUCTURE -> Value.INVALID_ACCOUNT_NUMBER_STRUCTURE
                        ACCOUNT_FROZEN_ENTRY_RETURNED_PER_OFAC_INSTRUCTION ->
                            Value.ACCOUNT_FROZEN_ENTRY_RETURNED_PER_OFAC_INSTRUCTION
                        CREDIT_ENTRY_REFUSED_BY_RECEIVER -> Value.CREDIT_ENTRY_REFUSED_BY_RECEIVER
                        UNAUTHORIZED_DEBIT_TO_CONSUMER_ACCOUNT_USING_CORPORATE_SEC_CODE ->
                            Value.UNAUTHORIZED_DEBIT_TO_CONSUMER_ACCOUNT_USING_CORPORATE_SEC_CODE
                        CORPORATE_CUSTOMER_ADVISED_NOT_AUTHORIZED ->
                            Value.CORPORATE_CUSTOMER_ADVISED_NOT_AUTHORIZED
                        PAYMENT_STOPPED -> Value.PAYMENT_STOPPED
                        NON_TRANSACTION_ACCOUNT -> Value.NON_TRANSACTION_ACCOUNT
                        UNCOLLECTED_FUNDS -> Value.UNCOLLECTED_FUNDS
                        ROUTING_NUMBER_CHECK_DIGIT_ERROR -> Value.ROUTING_NUMBER_CHECK_DIGIT_ERROR
                        CUSTOMER_ADVISED_UNAUTHORIZED_IMPROPER_INELIGIBLE_OR_INCOMPLETE ->
                            Value.CUSTOMER_ADVISED_UNAUTHORIZED_IMPROPER_INELIGIBLE_OR_INCOMPLETE
                        AMOUNT_FIELD_ERROR -> Value.AMOUNT_FIELD_ERROR
                        AUTHORIZATION_REVOKED_BY_CUSTOMER -> Value.AUTHORIZATION_REVOKED_BY_CUSTOMER
                        INVALID_ACH_ROUTING_NUMBER -> Value.INVALID_ACH_ROUTING_NUMBER
                        FILE_RECORD_EDIT_CRITERIA -> Value.FILE_RECORD_EDIT_CRITERIA
                        ENR_INVALID_INDIVIDUAL_NAME -> Value.ENR_INVALID_INDIVIDUAL_NAME
                        RETURNED_PER_ODFI_REQUEST -> Value.RETURNED_PER_ODFI_REQUEST
                        LIMITED_PARTICIPATION_DFI -> Value.LIMITED_PARTICIPATION_DFI
                        INCORRECTLY_CODED_OUTBOUND_INTERNATIONAL_PAYMENT ->
                            Value.INCORRECTLY_CODED_OUTBOUND_INTERNATIONAL_PAYMENT
                        ACCOUNT_SOLD_TO_ANOTHER_DFI -> Value.ACCOUNT_SOLD_TO_ANOTHER_DFI
                        ADDENDA_ERROR -> Value.ADDENDA_ERROR
                        BENEFICIARY_OR_ACCOUNT_HOLDER_DECEASED ->
                            Value.BENEFICIARY_OR_ACCOUNT_HOLDER_DECEASED
                        CUSTOMER_ADVISED_NOT_WITHIN_AUTHORIZATION_TERMS ->
                            Value.CUSTOMER_ADVISED_NOT_WITHIN_AUTHORIZATION_TERMS
                        CORRECTED_RETURN -> Value.CORRECTED_RETURN
                        DUPLICATE_ENTRY -> Value.DUPLICATE_ENTRY
                        DUPLICATE_RETURN -> Value.DUPLICATE_RETURN
                        ENR_DUPLICATE_ENROLLMENT -> Value.ENR_DUPLICATE_ENROLLMENT
                        ENR_INVALID_DFI_ACCOUNT_NUMBER -> Value.ENR_INVALID_DFI_ACCOUNT_NUMBER
                        ENR_INVALID_INDIVIDUAL_ID_NUMBER -> Value.ENR_INVALID_INDIVIDUAL_ID_NUMBER
                        ENR_INVALID_REPRESENTATIVE_PAYEE_INDICATOR ->
                            Value.ENR_INVALID_REPRESENTATIVE_PAYEE_INDICATOR
                        ENR_INVALID_TRANSACTION_CODE -> Value.ENR_INVALID_TRANSACTION_CODE
                        ENR_RETURN_OF_ENR_ENTRY -> Value.ENR_RETURN_OF_ENR_ENTRY
                        ENR_ROUTING_NUMBER_CHECK_DIGIT_ERROR ->
                            Value.ENR_ROUTING_NUMBER_CHECK_DIGIT_ERROR
                        ENTRY_NOT_PROCESSED_BY_GATEWAY -> Value.ENTRY_NOT_PROCESSED_BY_GATEWAY
                        FIELD_ERROR -> Value.FIELD_ERROR
                        FOREIGN_RECEIVING_DFI_UNABLE_TO_SETTLE ->
                            Value.FOREIGN_RECEIVING_DFI_UNABLE_TO_SETTLE
                        IAT_ENTRY_CODING_ERROR -> Value.IAT_ENTRY_CODING_ERROR
                        IMPROPER_EFFECTIVE_ENTRY_DATE -> Value.IMPROPER_EFFECTIVE_ENTRY_DATE
                        IMPROPER_SOURCE_DOCUMENT_SOURCE_DOCUMENT_PRESENTED ->
                            Value.IMPROPER_SOURCE_DOCUMENT_SOURCE_DOCUMENT_PRESENTED
                        INVALID_COMPANY_ID -> Value.INVALID_COMPANY_ID
                        INVALID_FOREIGN_RECEIVING_DFI_IDENTIFICATION ->
                            Value.INVALID_FOREIGN_RECEIVING_DFI_IDENTIFICATION
                        INVALID_INDIVIDUAL_ID_NUMBER -> Value.INVALID_INDIVIDUAL_ID_NUMBER
                        ITEM_AND_RCK_ENTRY_PRESENTED_FOR_PAYMENT ->
                            Value.ITEM_AND_RCK_ENTRY_PRESENTED_FOR_PAYMENT
                        ITEM_RELATED_TO_RCK_ENTRY_IS_INELIGIBLE ->
                            Value.ITEM_RELATED_TO_RCK_ENTRY_IS_INELIGIBLE
                        MANDATORY_FIELD_ERROR -> Value.MANDATORY_FIELD_ERROR
                        MISROUTED_DISHONORED_RETURN -> Value.MISROUTED_DISHONORED_RETURN
                        MISROUTED_RETURN -> Value.MISROUTED_RETURN
                        NO_ERRORS_FOUND -> Value.NO_ERRORS_FOUND
                        NON_ACCEPTANCE_OF_R62_DISHONORED_RETURN ->
                            Value.NON_ACCEPTANCE_OF_R62_DISHONORED_RETURN
                        NON_PARTICIPANT_IN_IAT_PROGRAM -> Value.NON_PARTICIPANT_IN_IAT_PROGRAM
                        PERMISSIBLE_RETURN_ENTRY -> Value.PERMISSIBLE_RETURN_ENTRY
                        PERMISSIBLE_RETURN_ENTRY_NOT_ACCEPTED ->
                            Value.PERMISSIBLE_RETURN_ENTRY_NOT_ACCEPTED
                        RDFI_NON_SETTLEMENT -> Value.RDFI_NON_SETTLEMENT
                        RDFI_PARTICIPANT_IN_CHECK_TRUNCATION_PROGRAM ->
                            Value.RDFI_PARTICIPANT_IN_CHECK_TRUNCATION_PROGRAM
                        REPRESENTATIVE_PAYEE_DECEASED_OR_UNABLE_TO_CONTINUE_IN_THAT_CAPACITY ->
                            Value
                                .REPRESENTATIVE_PAYEE_DECEASED_OR_UNABLE_TO_CONTINUE_IN_THAT_CAPACITY
                        RETURN_NOT_A_DUPLICATE -> Value.RETURN_NOT_A_DUPLICATE
                        RETURN_OF_ERRONEOUS_OR_REVERSING_DEBIT ->
                            Value.RETURN_OF_ERRONEOUS_OR_REVERSING_DEBIT
                        RETURN_OF_IMPROPER_CREDIT_ENTRY -> Value.RETURN_OF_IMPROPER_CREDIT_ENTRY
                        RETURN_OF_IMPROPER_DEBIT_ENTRY -> Value.RETURN_OF_IMPROPER_DEBIT_ENTRY
                        RETURN_OF_XCK_ENTRY -> Value.RETURN_OF_XCK_ENTRY
                        SOURCE_DOCUMENT_PRESENTED_FOR_PAYMENT ->
                            Value.SOURCE_DOCUMENT_PRESENTED_FOR_PAYMENT
                        STATE_LAW_AFFECTING_RCK_ACCEPTANCE ->
                            Value.STATE_LAW_AFFECTING_RCK_ACCEPTANCE
                        STOP_PAYMENT_ON_ITEM_RELATED_TO_RCK_ENTRY ->
                            Value.STOP_PAYMENT_ON_ITEM_RELATED_TO_RCK_ENTRY
                        STOP_PAYMENT_ON_SOURCE_DOCUMENT -> Value.STOP_PAYMENT_ON_SOURCE_DOCUMENT
                        TIMELY_ORIGINAL_RETURN -> Value.TIMELY_ORIGINAL_RETURN
                        TRACE_NUMBER_ERROR -> Value.TRACE_NUMBER_ERROR
                        UNTIMELY_DISHONORED_RETURN -> Value.UNTIMELY_DISHONORED_RETURN
                        UNTIMELY_RETURN -> Value.UNTIMELY_RETURN
                        else -> Value._UNKNOWN
                    }

                /**
                 * Returns an enum member corresponding to this class instance's value.
                 *
                 * Use the [value] method instead if you're uncertain the value is always known and
                 * don't want to throw for the unknown case.
                 *
                 * @throws IncreaseInvalidDataException if this class instance's value is a not a
                 *   known member.
                 */
                fun known(): Known =
                    when (this) {
                        INSUFFICIENT_FUND -> Known.INSUFFICIENT_FUND
                        NO_ACCOUNT -> Known.NO_ACCOUNT
                        ACCOUNT_CLOSED -> Known.ACCOUNT_CLOSED
                        INVALID_ACCOUNT_NUMBER_STRUCTURE -> Known.INVALID_ACCOUNT_NUMBER_STRUCTURE
                        ACCOUNT_FROZEN_ENTRY_RETURNED_PER_OFAC_INSTRUCTION ->
                            Known.ACCOUNT_FROZEN_ENTRY_RETURNED_PER_OFAC_INSTRUCTION
                        CREDIT_ENTRY_REFUSED_BY_RECEIVER -> Known.CREDIT_ENTRY_REFUSED_BY_RECEIVER
                        UNAUTHORIZED_DEBIT_TO_CONSUMER_ACCOUNT_USING_CORPORATE_SEC_CODE ->
                            Known.UNAUTHORIZED_DEBIT_TO_CONSUMER_ACCOUNT_USING_CORPORATE_SEC_CODE
                        CORPORATE_CUSTOMER_ADVISED_NOT_AUTHORIZED ->
                            Known.CORPORATE_CUSTOMER_ADVISED_NOT_AUTHORIZED
                        PAYMENT_STOPPED -> Known.PAYMENT_STOPPED
                        NON_TRANSACTION_ACCOUNT -> Known.NON_TRANSACTION_ACCOUNT
                        UNCOLLECTED_FUNDS -> Known.UNCOLLECTED_FUNDS
                        ROUTING_NUMBER_CHECK_DIGIT_ERROR -> Known.ROUTING_NUMBER_CHECK_DIGIT_ERROR
                        CUSTOMER_ADVISED_UNAUTHORIZED_IMPROPER_INELIGIBLE_OR_INCOMPLETE ->
                            Known.CUSTOMER_ADVISED_UNAUTHORIZED_IMPROPER_INELIGIBLE_OR_INCOMPLETE
                        AMOUNT_FIELD_ERROR -> Known.AMOUNT_FIELD_ERROR
                        AUTHORIZATION_REVOKED_BY_CUSTOMER -> Known.AUTHORIZATION_REVOKED_BY_CUSTOMER
                        INVALID_ACH_ROUTING_NUMBER -> Known.INVALID_ACH_ROUTING_NUMBER
                        FILE_RECORD_EDIT_CRITERIA -> Known.FILE_RECORD_EDIT_CRITERIA
                        ENR_INVALID_INDIVIDUAL_NAME -> Known.ENR_INVALID_INDIVIDUAL_NAME
                        RETURNED_PER_ODFI_REQUEST -> Known.RETURNED_PER_ODFI_REQUEST
                        LIMITED_PARTICIPATION_DFI -> Known.LIMITED_PARTICIPATION_DFI
                        INCORRECTLY_CODED_OUTBOUND_INTERNATIONAL_PAYMENT ->
                            Known.INCORRECTLY_CODED_OUTBOUND_INTERNATIONAL_PAYMENT
                        ACCOUNT_SOLD_TO_ANOTHER_DFI -> Known.ACCOUNT_SOLD_TO_ANOTHER_DFI
                        ADDENDA_ERROR -> Known.ADDENDA_ERROR
                        BENEFICIARY_OR_ACCOUNT_HOLDER_DECEASED ->
                            Known.BENEFICIARY_OR_ACCOUNT_HOLDER_DECEASED
                        CUSTOMER_ADVISED_NOT_WITHIN_AUTHORIZATION_TERMS ->
                            Known.CUSTOMER_ADVISED_NOT_WITHIN_AUTHORIZATION_TERMS
                        CORRECTED_RETURN -> Known.CORRECTED_RETURN
                        DUPLICATE_ENTRY -> Known.DUPLICATE_ENTRY
                        DUPLICATE_RETURN -> Known.DUPLICATE_RETURN
                        ENR_DUPLICATE_ENROLLMENT -> Known.ENR_DUPLICATE_ENROLLMENT
                        ENR_INVALID_DFI_ACCOUNT_NUMBER -> Known.ENR_INVALID_DFI_ACCOUNT_NUMBER
                        ENR_INVALID_INDIVIDUAL_ID_NUMBER -> Known.ENR_INVALID_INDIVIDUAL_ID_NUMBER
                        ENR_INVALID_REPRESENTATIVE_PAYEE_INDICATOR ->
                            Known.ENR_INVALID_REPRESENTATIVE_PAYEE_INDICATOR
                        ENR_INVALID_TRANSACTION_CODE -> Known.ENR_INVALID_TRANSACTION_CODE
                        ENR_RETURN_OF_ENR_ENTRY -> Known.ENR_RETURN_OF_ENR_ENTRY
                        ENR_ROUTING_NUMBER_CHECK_DIGIT_ERROR ->
                            Known.ENR_ROUTING_NUMBER_CHECK_DIGIT_ERROR
                        ENTRY_NOT_PROCESSED_BY_GATEWAY -> Known.ENTRY_NOT_PROCESSED_BY_GATEWAY
                        FIELD_ERROR -> Known.FIELD_ERROR
                        FOREIGN_RECEIVING_DFI_UNABLE_TO_SETTLE ->
                            Known.FOREIGN_RECEIVING_DFI_UNABLE_TO_SETTLE
                        IAT_ENTRY_CODING_ERROR -> Known.IAT_ENTRY_CODING_ERROR
                        IMPROPER_EFFECTIVE_ENTRY_DATE -> Known.IMPROPER_EFFECTIVE_ENTRY_DATE
                        IMPROPER_SOURCE_DOCUMENT_SOURCE_DOCUMENT_PRESENTED ->
                            Known.IMPROPER_SOURCE_DOCUMENT_SOURCE_DOCUMENT_PRESENTED
                        INVALID_COMPANY_ID -> Known.INVALID_COMPANY_ID
                        INVALID_FOREIGN_RECEIVING_DFI_IDENTIFICATION ->
                            Known.INVALID_FOREIGN_RECEIVING_DFI_IDENTIFICATION
                        INVALID_INDIVIDUAL_ID_NUMBER -> Known.INVALID_INDIVIDUAL_ID_NUMBER
                        ITEM_AND_RCK_ENTRY_PRESENTED_FOR_PAYMENT ->
                            Known.ITEM_AND_RCK_ENTRY_PRESENTED_FOR_PAYMENT
                        ITEM_RELATED_TO_RCK_ENTRY_IS_INELIGIBLE ->
                            Known.ITEM_RELATED_TO_RCK_ENTRY_IS_INELIGIBLE
                        MANDATORY_FIELD_ERROR -> Known.MANDATORY_FIELD_ERROR
                        MISROUTED_DISHONORED_RETURN -> Known.MISROUTED_DISHONORED_RETURN
                        MISROUTED_RETURN -> Known.MISROUTED_RETURN
                        NO_ERRORS_FOUND -> Known.NO_ERRORS_FOUND
                        NON_ACCEPTANCE_OF_R62_DISHONORED_RETURN ->
                            Known.NON_ACCEPTANCE_OF_R62_DISHONORED_RETURN
                        NON_PARTICIPANT_IN_IAT_PROGRAM -> Known.NON_PARTICIPANT_IN_IAT_PROGRAM
                        PERMISSIBLE_RETURN_ENTRY -> Known.PERMISSIBLE_RETURN_ENTRY
                        PERMISSIBLE_RETURN_ENTRY_NOT_ACCEPTED ->
                            Known.PERMISSIBLE_RETURN_ENTRY_NOT_ACCEPTED
                        RDFI_NON_SETTLEMENT -> Known.RDFI_NON_SETTLEMENT
                        RDFI_PARTICIPANT_IN_CHECK_TRUNCATION_PROGRAM ->
                            Known.RDFI_PARTICIPANT_IN_CHECK_TRUNCATION_PROGRAM
                        REPRESENTATIVE_PAYEE_DECEASED_OR_UNABLE_TO_CONTINUE_IN_THAT_CAPACITY ->
                            Known
                                .REPRESENTATIVE_PAYEE_DECEASED_OR_UNABLE_TO_CONTINUE_IN_THAT_CAPACITY
                        RETURN_NOT_A_DUPLICATE -> Known.RETURN_NOT_A_DUPLICATE
                        RETURN_OF_ERRONEOUS_OR_REVERSING_DEBIT ->
                            Known.RETURN_OF_ERRONEOUS_OR_REVERSING_DEBIT
                        RETURN_OF_IMPROPER_CREDIT_ENTRY -> Known.RETURN_OF_IMPROPER_CREDIT_ENTRY
                        RETURN_OF_IMPROPER_DEBIT_ENTRY -> Known.RETURN_OF_IMPROPER_DEBIT_ENTRY
                        RETURN_OF_XCK_ENTRY -> Known.RETURN_OF_XCK_ENTRY
                        SOURCE_DOCUMENT_PRESENTED_FOR_PAYMENT ->
                            Known.SOURCE_DOCUMENT_PRESENTED_FOR_PAYMENT
                        STATE_LAW_AFFECTING_RCK_ACCEPTANCE ->
                            Known.STATE_LAW_AFFECTING_RCK_ACCEPTANCE
                        STOP_PAYMENT_ON_ITEM_RELATED_TO_RCK_ENTRY ->
                            Known.STOP_PAYMENT_ON_ITEM_RELATED_TO_RCK_ENTRY
                        STOP_PAYMENT_ON_SOURCE_DOCUMENT -> Known.STOP_PAYMENT_ON_SOURCE_DOCUMENT
                        TIMELY_ORIGINAL_RETURN -> Known.TIMELY_ORIGINAL_RETURN
                        TRACE_NUMBER_ERROR -> Known.TRACE_NUMBER_ERROR
                        UNTIMELY_DISHONORED_RETURN -> Known.UNTIMELY_DISHONORED_RETURN
                        UNTIMELY_RETURN -> Known.UNTIMELY_RETURN
                        else ->
                            throw IncreaseInvalidDataException("Unknown ReturnReasonCode: $value")
                    }

                /**
                 * Returns this class instance's primitive wire representation.
                 *
                 * This differs from the [toString] method because that method is primarily for
                 * debugging and generally doesn't throw.
                 *
                 * @throws IncreaseInvalidDataException if this class instance's value does not have
                 *   the expected primitive type.
                 */
                fun asString(): String =
                    _value().asString().orElseThrow {
                        IncreaseInvalidDataException("Value is not a String")
                    }

                private var validated: Boolean = false

                fun validate(): ReturnReasonCode = apply {
                    if (validated) {
                        return@apply
                    }

                    known()
                    validated = true
                }

                fun isValid(): Boolean =
                    try {
                        validate()
                        true
                    } catch (e: IncreaseInvalidDataException) {
                        false
                    }

                /**
                 * Returns a score indicating how many valid values are contained in this object
                 * recursively.
                 *
                 * Used for best match union deserialization.
                 */
                @JvmSynthetic internal fun validity(): Int = if (value() == Value._UNKNOWN) 0 else 1

                override fun equals(other: Any?): Boolean {
                    if (this === other) {
                        return true
                    }

                    return /* spotless:off */ other is ReturnReasonCode && value == other.value /* spotless:on */
                }

                override fun hashCode() = value.hashCode()

                override fun toString() = value.toString()
            }

            override fun equals(other: Any?): Boolean {
                if (this === other) {
                    return true
                }

                return /* spotless:off */ other is AchTransferReturn && createdAt == other.createdAt && rawReturnReasonCode == other.rawReturnReasonCode && returnReasonCode == other.returnReasonCode && traceNumber == other.traceNumber && transactionId == other.transactionId && transferId == other.transferId && additionalProperties == other.additionalProperties /* spotless:on */
            }

            /* spotless:off */
            private val hashCode: Int by lazy { Objects.hash(createdAt, rawReturnReasonCode, returnReasonCode, traceNumber, transactionId, transferId, additionalProperties) }
            /* spotless:on */

            override fun hashCode(): Int = hashCode

            override fun toString() =
                "AchTransferReturn{createdAt=$createdAt, rawReturnReasonCode=$rawReturnReasonCode, returnReasonCode=$returnReasonCode, traceNumber=$traceNumber, transactionId=$transactionId, transferId=$transferId, additionalProperties=$additionalProperties}"
        }

        /**
         * A Card Dispute Acceptance object. This field will be present in the JSON response if and
         * only if `category` is equal to `card_dispute_acceptance`. Contains the details of a
         * successful Card Dispute.
         */
        class CardDisputeAcceptance
        private constructor(
            private val acceptedAt: JsonField<OffsetDateTime>,
            private val cardDisputeId: JsonField<String>,
            private val transactionId: JsonField<String>,
            private val additionalProperties: MutableMap<String, JsonValue>,
        ) {

            @JsonCreator
            private constructor(
                @JsonProperty("accepted_at")
                @ExcludeMissing
                acceptedAt: JsonField<OffsetDateTime> = JsonMissing.of(),
                @JsonProperty("card_dispute_id")
                @ExcludeMissing
                cardDisputeId: JsonField<String> = JsonMissing.of(),
                @JsonProperty("transaction_id")
                @ExcludeMissing
                transactionId: JsonField<String> = JsonMissing.of(),
            ) : this(acceptedAt, cardDisputeId, transactionId, mutableMapOf())

            /**
             * The [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) date and time at which the
             * Card Dispute was accepted.
             *
             * @throws IncreaseInvalidDataException if the JSON field has an unexpected type or is
             *   unexpectedly missing or null (e.g. if the server responded with an unexpected
             *   value).
             */
            fun acceptedAt(): OffsetDateTime = acceptedAt.getRequired("accepted_at")

            /**
             * The identifier of the Card Dispute that was accepted.
             *
             * @throws IncreaseInvalidDataException if the JSON field has an unexpected type or is
             *   unexpectedly missing or null (e.g. if the server responded with an unexpected
             *   value).
             */
            fun cardDisputeId(): String = cardDisputeId.getRequired("card_dispute_id")

            /**
             * The identifier of the Transaction that was created to return the disputed funds to
             * your account.
             *
             * @throws IncreaseInvalidDataException if the JSON field has an unexpected type or is
             *   unexpectedly missing or null (e.g. if the server responded with an unexpected
             *   value).
             */
            fun transactionId(): String = transactionId.getRequired("transaction_id")

            /**
             * Returns the raw JSON value of [acceptedAt].
             *
             * Unlike [acceptedAt], this method doesn't throw if the JSON field has an unexpected
             * type.
             */
            @JsonProperty("accepted_at")
            @ExcludeMissing
            fun _acceptedAt(): JsonField<OffsetDateTime> = acceptedAt

            /**
             * Returns the raw JSON value of [cardDisputeId].
             *
             * Unlike [cardDisputeId], this method doesn't throw if the JSON field has an unexpected
             * type.
             */
            @JsonProperty("card_dispute_id")
            @ExcludeMissing
            fun _cardDisputeId(): JsonField<String> = cardDisputeId

            /**
             * Returns the raw JSON value of [transactionId].
             *
             * Unlike [transactionId], this method doesn't throw if the JSON field has an unexpected
             * type.
             */
            @JsonProperty("transaction_id")
            @ExcludeMissing
            fun _transactionId(): JsonField<String> = transactionId

            @JsonAnySetter
            private fun putAdditionalProperty(key: String, value: JsonValue) {
                additionalProperties.put(key, value)
            }

            @JsonAnyGetter
            @ExcludeMissing
            fun _additionalProperties(): Map<String, JsonValue> =
                Collections.unmodifiableMap(additionalProperties)

            fun toBuilder() = Builder().from(this)

            companion object {

                /**
                 * Returns a mutable builder for constructing an instance of
                 * [CardDisputeAcceptance].
                 *
                 * The following fields are required:
                 * ```java
                 * .acceptedAt()
                 * .cardDisputeId()
                 * .transactionId()
                 * ```
                 */
                @JvmStatic fun builder() = Builder()
            }

            /** A builder for [CardDisputeAcceptance]. */
            class Builder internal constructor() {

                private var acceptedAt: JsonField<OffsetDateTime>? = null
                private var cardDisputeId: JsonField<String>? = null
                private var transactionId: JsonField<String>? = null
                private var additionalProperties: MutableMap<String, JsonValue> = mutableMapOf()

                @JvmSynthetic
                internal fun from(cardDisputeAcceptance: CardDisputeAcceptance) = apply {
                    acceptedAt = cardDisputeAcceptance.acceptedAt
                    cardDisputeId = cardDisputeAcceptance.cardDisputeId
                    transactionId = cardDisputeAcceptance.transactionId
                    additionalProperties = cardDisputeAcceptance.additionalProperties.toMutableMap()
                }

                /**
                 * The [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) date and time at which the
                 * Card Dispute was accepted.
                 */
                fun acceptedAt(acceptedAt: OffsetDateTime) = acceptedAt(JsonField.of(acceptedAt))

                /**
                 * Sets [Builder.acceptedAt] to an arbitrary JSON value.
                 *
                 * You should usually call [Builder.acceptedAt] with a well-typed [OffsetDateTime]
                 * value instead. This method is primarily for setting the field to an undocumented
                 * or not yet supported value.
                 */
                fun acceptedAt(acceptedAt: JsonField<OffsetDateTime>) = apply {
                    this.acceptedAt = acceptedAt
                }

                /** The identifier of the Card Dispute that was accepted. */
                fun cardDisputeId(cardDisputeId: String) =
                    cardDisputeId(JsonField.of(cardDisputeId))

                /**
                 * Sets [Builder.cardDisputeId] to an arbitrary JSON value.
                 *
                 * You should usually call [Builder.cardDisputeId] with a well-typed [String] value
                 * instead. This method is primarily for setting the field to an undocumented or not
                 * yet supported value.
                 */
                fun cardDisputeId(cardDisputeId: JsonField<String>) = apply {
                    this.cardDisputeId = cardDisputeId
                }

                /**
                 * The identifier of the Transaction that was created to return the disputed funds
                 * to your account.
                 */
                fun transactionId(transactionId: String) =
                    transactionId(JsonField.of(transactionId))

                /**
                 * Sets [Builder.transactionId] to an arbitrary JSON value.
                 *
                 * You should usually call [Builder.transactionId] with a well-typed [String] value
                 * instead. This method is primarily for setting the field to an undocumented or not
                 * yet supported value.
                 */
                fun transactionId(transactionId: JsonField<String>) = apply {
                    this.transactionId = transactionId
                }

                fun additionalProperties(additionalProperties: Map<String, JsonValue>) = apply {
                    this.additionalProperties.clear()
                    putAllAdditionalProperties(additionalProperties)
                }

                fun putAdditionalProperty(key: String, value: JsonValue) = apply {
                    additionalProperties.put(key, value)
                }

                fun putAllAdditionalProperties(additionalProperties: Map<String, JsonValue>) =
                    apply {
                        this.additionalProperties.putAll(additionalProperties)
                    }

                fun removeAdditionalProperty(key: String) = apply {
                    additionalProperties.remove(key)
                }

                fun removeAllAdditionalProperties(keys: Set<String>) = apply {
                    keys.forEach(::removeAdditionalProperty)
                }

                /**
                 * Returns an immutable instance of [CardDisputeAcceptance].
                 *
                 * Further updates to this [Builder] will not mutate the returned instance.
                 *
                 * The following fields are required:
                 * ```java
                 * .acceptedAt()
                 * .cardDisputeId()
                 * .transactionId()
                 * ```
                 *
                 * @throws IllegalStateException if any required field is unset.
                 */
                fun build(): CardDisputeAcceptance =
                    CardDisputeAcceptance(
                        checkRequired("acceptedAt", acceptedAt),
                        checkRequired("cardDisputeId", cardDisputeId),
                        checkRequired("transactionId", transactionId),
                        additionalProperties.toMutableMap(),
                    )
            }

            private var validated: Boolean = false

            fun validate(): CardDisputeAcceptance = apply {
                if (validated) {
                    return@apply
                }

                acceptedAt()
                cardDisputeId()
                transactionId()
                validated = true
            }

            fun isValid(): Boolean =
                try {
                    validate()
                    true
                } catch (e: IncreaseInvalidDataException) {
                    false
                }

            /**
             * Returns a score indicating how many valid values are contained in this object
             * recursively.
             *
             * Used for best match union deserialization.
             */
            @JvmSynthetic
            internal fun validity(): Int =
                (if (acceptedAt.asKnown().isPresent) 1 else 0) +
                    (if (cardDisputeId.asKnown().isPresent) 1 else 0) +
                    (if (transactionId.asKnown().isPresent) 1 else 0)

            override fun equals(other: Any?): Boolean {
                if (this === other) {
                    return true
                }

                return /* spotless:off */ other is CardDisputeAcceptance && acceptedAt == other.acceptedAt && cardDisputeId == other.cardDisputeId && transactionId == other.transactionId && additionalProperties == other.additionalProperties /* spotless:on */
            }

            /* spotless:off */
            private val hashCode: Int by lazy { Objects.hash(acceptedAt, cardDisputeId, transactionId, additionalProperties) }
            /* spotless:on */

            override fun hashCode(): Int = hashCode

            override fun toString() =
                "CardDisputeAcceptance{acceptedAt=$acceptedAt, cardDisputeId=$cardDisputeId, transactionId=$transactionId, additionalProperties=$additionalProperties}"
        }

        /**
         * A Card Dispute Loss object. This field will be present in the JSON response if and only
         * if `category` is equal to `card_dispute_loss`. Contains the details of a lost Card
         * Dispute.
         */
        class CardDisputeLoss
        private constructor(
            private val cardDisputeId: JsonField<String>,
            private val explanation: JsonField<String>,
            private val lostAt: JsonField<OffsetDateTime>,
            private val transactionId: JsonField<String>,
            private val additionalProperties: MutableMap<String, JsonValue>,
        ) {

            @JsonCreator
            private constructor(
                @JsonProperty("card_dispute_id")
                @ExcludeMissing
                cardDisputeId: JsonField<String> = JsonMissing.of(),
                @JsonProperty("explanation")
                @ExcludeMissing
                explanation: JsonField<String> = JsonMissing.of(),
                @JsonProperty("lost_at")
                @ExcludeMissing
                lostAt: JsonField<OffsetDateTime> = JsonMissing.of(),
                @JsonProperty("transaction_id")
                @ExcludeMissing
                transactionId: JsonField<String> = JsonMissing.of(),
            ) : this(cardDisputeId, explanation, lostAt, transactionId, mutableMapOf())

            /**
             * The identifier of the Card Dispute that was lost.
             *
             * @throws IncreaseInvalidDataException if the JSON field has an unexpected type or is
             *   unexpectedly missing or null (e.g. if the server responded with an unexpected
             *   value).
             */
            fun cardDisputeId(): String = cardDisputeId.getRequired("card_dispute_id")

            /**
             * Why the Card Dispute was lost.
             *
             * @throws IncreaseInvalidDataException if the JSON field has an unexpected type or is
             *   unexpectedly missing or null (e.g. if the server responded with an unexpected
             *   value).
             */
            fun explanation(): String = explanation.getRequired("explanation")

            /**
             * The [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) date and time at which the
             * Card Dispute was lost.
             *
             * @throws IncreaseInvalidDataException if the JSON field has an unexpected type or is
             *   unexpectedly missing or null (e.g. if the server responded with an unexpected
             *   value).
             */
            fun lostAt(): OffsetDateTime = lostAt.getRequired("lost_at")

            /**
             * The identifier of the Transaction that was created to debit the disputed funds from
             * your account.
             *
             * @throws IncreaseInvalidDataException if the JSON field has an unexpected type or is
             *   unexpectedly missing or null (e.g. if the server responded with an unexpected
             *   value).
             */
            fun transactionId(): String = transactionId.getRequired("transaction_id")

            /**
             * Returns the raw JSON value of [cardDisputeId].
             *
             * Unlike [cardDisputeId], this method doesn't throw if the JSON field has an unexpected
             * type.
             */
            @JsonProperty("card_dispute_id")
            @ExcludeMissing
            fun _cardDisputeId(): JsonField<String> = cardDisputeId

            /**
             * Returns the raw JSON value of [explanation].
             *
             * Unlike [explanation], this method doesn't throw if the JSON field has an unexpected
             * type.
             */
            @JsonProperty("explanation")
            @ExcludeMissing
            fun _explanation(): JsonField<String> = explanation

            /**
             * Returns the raw JSON value of [lostAt].
             *
             * Unlike [lostAt], this method doesn't throw if the JSON field has an unexpected type.
             */
            @JsonProperty("lost_at")
            @ExcludeMissing
            fun _lostAt(): JsonField<OffsetDateTime> = lostAt

            /**
             * Returns the raw JSON value of [transactionId].
             *
             * Unlike [transactionId], this method doesn't throw if the JSON field has an unexpected
             * type.
             */
            @JsonProperty("transaction_id")
            @ExcludeMissing
            fun _transactionId(): JsonField<String> = transactionId

            @JsonAnySetter
            private fun putAdditionalProperty(key: String, value: JsonValue) {
                additionalProperties.put(key, value)
            }

            @JsonAnyGetter
            @ExcludeMissing
            fun _additionalProperties(): Map<String, JsonValue> =
                Collections.unmodifiableMap(additionalProperties)

            fun toBuilder() = Builder().from(this)

            companion object {

                /**
                 * Returns a mutable builder for constructing an instance of [CardDisputeLoss].
                 *
                 * The following fields are required:
                 * ```java
                 * .cardDisputeId()
                 * .explanation()
                 * .lostAt()
                 * .transactionId()
                 * ```
                 */
                @JvmStatic fun builder() = Builder()
            }

            /** A builder for [CardDisputeLoss]. */
            class Builder internal constructor() {

                private var cardDisputeId: JsonField<String>? = null
                private var explanation: JsonField<String>? = null
                private var lostAt: JsonField<OffsetDateTime>? = null
                private var transactionId: JsonField<String>? = null
                private var additionalProperties: MutableMap<String, JsonValue> = mutableMapOf()

                @JvmSynthetic
                internal fun from(cardDisputeLoss: CardDisputeLoss) = apply {
                    cardDisputeId = cardDisputeLoss.cardDisputeId
                    explanation = cardDisputeLoss.explanation
                    lostAt = cardDisputeLoss.lostAt
                    transactionId = cardDisputeLoss.transactionId
                    additionalProperties = cardDisputeLoss.additionalProperties.toMutableMap()
                }

                /** The identifier of the Card Dispute that was lost. */
                fun cardDisputeId(cardDisputeId: String) =
                    cardDisputeId(JsonField.of(cardDisputeId))

                /**
                 * Sets [Builder.cardDisputeId] to an arbitrary JSON value.
                 *
                 * You should usually call [Builder.cardDisputeId] with a well-typed [String] value
                 * instead. This method is primarily for setting the field to an undocumented or not
                 * yet supported value.
                 */
                fun cardDisputeId(cardDisputeId: JsonField<String>) = apply {
                    this.cardDisputeId = cardDisputeId
                }

                /** Why the Card Dispute was lost. */
                fun explanation(explanation: String) = explanation(JsonField.of(explanation))

                /**
                 * Sets [Builder.explanation] to an arbitrary JSON value.
                 *
                 * You should usually call [Builder.explanation] with a well-typed [String] value
                 * instead. This method is primarily for setting the field to an undocumented or not
                 * yet supported value.
                 */
                fun explanation(explanation: JsonField<String>) = apply {
                    this.explanation = explanation
                }

                /**
                 * The [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) date and time at which the
                 * Card Dispute was lost.
                 */
                fun lostAt(lostAt: OffsetDateTime) = lostAt(JsonField.of(lostAt))

                /**
                 * Sets [Builder.lostAt] to an arbitrary JSON value.
                 *
                 * You should usually call [Builder.lostAt] with a well-typed [OffsetDateTime] value
                 * instead. This method is primarily for setting the field to an undocumented or not
                 * yet supported value.
                 */
                fun lostAt(lostAt: JsonField<OffsetDateTime>) = apply { this.lostAt = lostAt }

                /**
                 * The identifier of the Transaction that was created to debit the disputed funds
                 * from your account.
                 */
                fun transactionId(transactionId: String) =
                    transactionId(JsonField.of(transactionId))

                /**
                 * Sets [Builder.transactionId] to an arbitrary JSON value.
                 *
                 * You should usually call [Builder.transactionId] with a well-typed [String] value
                 * instead. This method is primarily for setting the field to an undocumented or not
                 * yet supported value.
                 */
                fun transactionId(transactionId: JsonField<String>) = apply {
                    this.transactionId = transactionId
                }

                fun additionalProperties(additionalProperties: Map<String, JsonValue>) = apply {
                    this.additionalProperties.clear()
                    putAllAdditionalProperties(additionalProperties)
                }

                fun putAdditionalProperty(key: String, value: JsonValue) = apply {
                    additionalProperties.put(key, value)
                }

                fun putAllAdditionalProperties(additionalProperties: Map<String, JsonValue>) =
                    apply {
                        this.additionalProperties.putAll(additionalProperties)
                    }

                fun removeAdditionalProperty(key: String) = apply {
                    additionalProperties.remove(key)
                }

                fun removeAllAdditionalProperties(keys: Set<String>) = apply {
                    keys.forEach(::removeAdditionalProperty)
                }

                /**
                 * Returns an immutable instance of [CardDisputeLoss].
                 *
                 * Further updates to this [Builder] will not mutate the returned instance.
                 *
                 * The following fields are required:
                 * ```java
                 * .cardDisputeId()
                 * .explanation()
                 * .lostAt()
                 * .transactionId()
                 * ```
                 *
                 * @throws IllegalStateException if any required field is unset.
                 */
                fun build(): CardDisputeLoss =
                    CardDisputeLoss(
                        checkRequired("cardDisputeId", cardDisputeId),
                        checkRequired("explanation", explanation),
                        checkRequired("lostAt", lostAt),
                        checkRequired("transactionId", transactionId),
                        additionalProperties.toMutableMap(),
                    )
            }

            private var validated: Boolean = false

            fun validate(): CardDisputeLoss = apply {
                if (validated) {
                    return@apply
                }

                cardDisputeId()
                explanation()
                lostAt()
                transactionId()
                validated = true
            }

            fun isValid(): Boolean =
                try {
                    validate()
                    true
                } catch (e: IncreaseInvalidDataException) {
                    false
                }

            /**
             * Returns a score indicating how many valid values are contained in this object
             * recursively.
             *
             * Used for best match union deserialization.
             */
            @JvmSynthetic
            internal fun validity(): Int =
                (if (cardDisputeId.asKnown().isPresent) 1 else 0) +
                    (if (explanation.asKnown().isPresent) 1 else 0) +
                    (if (lostAt.asKnown().isPresent) 1 else 0) +
                    (if (transactionId.asKnown().isPresent) 1 else 0)

            override fun equals(other: Any?): Boolean {
                if (this === other) {
                    return true
                }

                return /* spotless:off */ other is CardDisputeLoss && cardDisputeId == other.cardDisputeId && explanation == other.explanation && lostAt == other.lostAt && transactionId == other.transactionId && additionalProperties == other.additionalProperties /* spotless:on */
            }

            /* spotless:off */
            private val hashCode: Int by lazy { Objects.hash(cardDisputeId, explanation, lostAt, transactionId, additionalProperties) }
            /* spotless:on */

            override fun hashCode(): Int = hashCode

            override fun toString() =
                "CardDisputeLoss{cardDisputeId=$cardDisputeId, explanation=$explanation, lostAt=$lostAt, transactionId=$transactionId, additionalProperties=$additionalProperties}"
        }

        /**
         * A Card Push Transfer Acceptance object. This field will be present in the JSON response
         * if and only if `category` is equal to `card_push_transfer_acceptance`. A Card Push
         * Transfer Acceptance is created when an Outbound Card Push Transfer sent from Increase is
         * accepted by the receiving bank.
         */
        class CardPushTransferAcceptance
        private constructor(
            private val amount: JsonField<Long>,
            private val transferId: JsonField<String>,
            private val additionalProperties: MutableMap<String, JsonValue>,
        ) {

            @JsonCreator
            private constructor(
                @JsonProperty("amount") @ExcludeMissing amount: JsonField<Long> = JsonMissing.of(),
                @JsonProperty("transfer_id")
                @ExcludeMissing
                transferId: JsonField<String> = JsonMissing.of(),
            ) : this(amount, transferId, mutableMapOf())

            /**
             * The transfer amount in USD cents.
             *
             * @throws IncreaseInvalidDataException if the JSON field has an unexpected type or is
             *   unexpectedly missing or null (e.g. if the server responded with an unexpected
             *   value).
             */
            fun amount(): Long = amount.getRequired("amount")

            /**
             * The identifier of the Card Push Transfer that led to this Transaction.
             *
             * @throws IncreaseInvalidDataException if the JSON field has an unexpected type or is
             *   unexpectedly missing or null (e.g. if the server responded with an unexpected
             *   value).
             */
            fun transferId(): String = transferId.getRequired("transfer_id")

            /**
             * Returns the raw JSON value of [amount].
             *
             * Unlike [amount], this method doesn't throw if the JSON field has an unexpected type.
             */
            @JsonProperty("amount") @ExcludeMissing fun _amount(): JsonField<Long> = amount

            /**
             * Returns the raw JSON value of [transferId].
             *
             * Unlike [transferId], this method doesn't throw if the JSON field has an unexpected
             * type.
             */
            @JsonProperty("transfer_id")
            @ExcludeMissing
            fun _transferId(): JsonField<String> = transferId

            @JsonAnySetter
            private fun putAdditionalProperty(key: String, value: JsonValue) {
                additionalProperties.put(key, value)
            }

            @JsonAnyGetter
            @ExcludeMissing
            fun _additionalProperties(): Map<String, JsonValue> =
                Collections.unmodifiableMap(additionalProperties)

            fun toBuilder() = Builder().from(this)

            companion object {

                /**
                 * Returns a mutable builder for constructing an instance of
                 * [CardPushTransferAcceptance].
                 *
                 * The following fields are required:
                 * ```java
                 * .amount()
                 * .transferId()
                 * ```
                 */
                @JvmStatic fun builder() = Builder()
            }

            /** A builder for [CardPushTransferAcceptance]. */
            class Builder internal constructor() {

                private var amount: JsonField<Long>? = null
                private var transferId: JsonField<String>? = null
                private var additionalProperties: MutableMap<String, JsonValue> = mutableMapOf()

                @JvmSynthetic
                internal fun from(cardPushTransferAcceptance: CardPushTransferAcceptance) = apply {
                    amount = cardPushTransferAcceptance.amount
                    transferId = cardPushTransferAcceptance.transferId
                    additionalProperties =
                        cardPushTransferAcceptance.additionalProperties.toMutableMap()
                }

                /** The transfer amount in USD cents. */
                fun amount(amount: Long) = amount(JsonField.of(amount))

                /**
                 * Sets [Builder.amount] to an arbitrary JSON value.
                 *
                 * You should usually call [Builder.amount] with a well-typed [Long] value instead.
                 * This method is primarily for setting the field to an undocumented or not yet
                 * supported value.
                 */
                fun amount(amount: JsonField<Long>) = apply { this.amount = amount }

                /** The identifier of the Card Push Transfer that led to this Transaction. */
                fun transferId(transferId: String) = transferId(JsonField.of(transferId))

                /**
                 * Sets [Builder.transferId] to an arbitrary JSON value.
                 *
                 * You should usually call [Builder.transferId] with a well-typed [String] value
                 * instead. This method is primarily for setting the field to an undocumented or not
                 * yet supported value.
                 */
                fun transferId(transferId: JsonField<String>) = apply {
                    this.transferId = transferId
                }

                fun additionalProperties(additionalProperties: Map<String, JsonValue>) = apply {
                    this.additionalProperties.clear()
                    putAllAdditionalProperties(additionalProperties)
                }

                fun putAdditionalProperty(key: String, value: JsonValue) = apply {
                    additionalProperties.put(key, value)
                }

                fun putAllAdditionalProperties(additionalProperties: Map<String, JsonValue>) =
                    apply {
                        this.additionalProperties.putAll(additionalProperties)
                    }

                fun removeAdditionalProperty(key: String) = apply {
                    additionalProperties.remove(key)
                }

                fun removeAllAdditionalProperties(keys: Set<String>) = apply {
                    keys.forEach(::removeAdditionalProperty)
                }

                /**
                 * Returns an immutable instance of [CardPushTransferAcceptance].
                 *
                 * Further updates to this [Builder] will not mutate the returned instance.
                 *
                 * The following fields are required:
                 * ```java
                 * .amount()
                 * .transferId()
                 * ```
                 *
                 * @throws IllegalStateException if any required field is unset.
                 */
                fun build(): CardPushTransferAcceptance =
                    CardPushTransferAcceptance(
                        checkRequired("amount", amount),
                        checkRequired("transferId", transferId),
                        additionalProperties.toMutableMap(),
                    )
            }

            private var validated: Boolean = false

            fun validate(): CardPushTransferAcceptance = apply {
                if (validated) {
                    return@apply
                }

                amount()
                transferId()
                validated = true
            }

            fun isValid(): Boolean =
                try {
                    validate()
                    true
                } catch (e: IncreaseInvalidDataException) {
                    false
                }

            /**
             * Returns a score indicating how many valid values are contained in this object
             * recursively.
             *
             * Used for best match union deserialization.
             */
            @JvmSynthetic
            internal fun validity(): Int =
                (if (amount.asKnown().isPresent) 1 else 0) +
                    (if (transferId.asKnown().isPresent) 1 else 0)

            override fun equals(other: Any?): Boolean {
                if (this === other) {
                    return true
                }

                return /* spotless:off */ other is CardPushTransferAcceptance && amount == other.amount && transferId == other.transferId && additionalProperties == other.additionalProperties /* spotless:on */
            }

            /* spotless:off */
            private val hashCode: Int by lazy { Objects.hash(amount, transferId, additionalProperties) }
            /* spotless:on */

            override fun hashCode(): Int = hashCode

            override fun toString() =
                "CardPushTransferAcceptance{amount=$amount, transferId=$transferId, additionalProperties=$additionalProperties}"
        }

        /**
         * A Card Refund object. This field will be present in the JSON response if and only if
         * `category` is equal to `card_refund`. Card Refunds move money back to the cardholder.
         * While they are usually connected to a Card Settlement an acquirer can also refund money
         * directly to a card without relation to a transaction.
         */
        class CardRefund
        private constructor(
            private val id: JsonField<String>,
            private val amount: JsonField<Long>,
            private val cardPaymentId: JsonField<String>,
            private val cashback: JsonField<Cashback>,
            private val currency: JsonField<Currency>,
            private val interchange: JsonField<Interchange>,
            private val merchantAcceptorId: JsonField<String>,
            private val merchantCategoryCode: JsonField<String>,
            private val merchantCity: JsonField<String>,
            private val merchantCountry: JsonField<String>,
            private val merchantName: JsonField<String>,
            private val merchantPostalCode: JsonField<String>,
            private val merchantState: JsonField<String>,
            private val networkIdentifiers: JsonField<NetworkIdentifiers>,
            private val presentmentAmount: JsonField<Long>,
            private val presentmentCurrency: JsonField<String>,
            private val purchaseDetails: JsonField<PurchaseDetails>,
            private val transactionId: JsonField<String>,
            private val type: JsonField<Type>,
            private val additionalProperties: MutableMap<String, JsonValue>,
        ) {

            @JsonCreator
            private constructor(
                @JsonProperty("id") @ExcludeMissing id: JsonField<String> = JsonMissing.of(),
                @JsonProperty("amount") @ExcludeMissing amount: JsonField<Long> = JsonMissing.of(),
                @JsonProperty("card_payment_id")
                @ExcludeMissing
                cardPaymentId: JsonField<String> = JsonMissing.of(),
                @JsonProperty("cashback")
                @ExcludeMissing
                cashback: JsonField<Cashback> = JsonMissing.of(),
                @JsonProperty("currency")
                @ExcludeMissing
                currency: JsonField<Currency> = JsonMissing.of(),
                @JsonProperty("interchange")
                @ExcludeMissing
                interchange: JsonField<Interchange> = JsonMissing.of(),
                @JsonProperty("merchant_acceptor_id")
                @ExcludeMissing
                merchantAcceptorId: JsonField<String> = JsonMissing.of(),
                @JsonProperty("merchant_category_code")
                @ExcludeMissing
                merchantCategoryCode: JsonField<String> = JsonMissing.of(),
                @JsonProperty("merchant_city")
                @ExcludeMissing
                merchantCity: JsonField<String> = JsonMissing.of(),
                @JsonProperty("merchant_country")
                @ExcludeMissing
                merchantCountry: JsonField<String> = JsonMissing.of(),
                @JsonProperty("merchant_name")
                @ExcludeMissing
                merchantName: JsonField<String> = JsonMissing.of(),
                @JsonProperty("merchant_postal_code")
                @ExcludeMissing
                merchantPostalCode: JsonField<String> = JsonMissing.of(),
                @JsonProperty("merchant_state")
                @ExcludeMissing
                merchantState: JsonField<String> = JsonMissing.of(),
                @JsonProperty("network_identifiers")
                @ExcludeMissing
                networkIdentifiers: JsonField<NetworkIdentifiers> = JsonMissing.of(),
                @JsonProperty("presentment_amount")
                @ExcludeMissing
                presentmentAmount: JsonField<Long> = JsonMissing.of(),
                @JsonProperty("presentment_currency")
                @ExcludeMissing
                presentmentCurrency: JsonField<String> = JsonMissing.of(),
                @JsonProperty("purchase_details")
                @ExcludeMissing
                purchaseDetails: JsonField<PurchaseDetails> = JsonMissing.of(),
                @JsonProperty("transaction_id")
                @ExcludeMissing
                transactionId: JsonField<String> = JsonMissing.of(),
                @JsonProperty("type") @ExcludeMissing type: JsonField<Type> = JsonMissing.of(),
            ) : this(
                id,
                amount,
                cardPaymentId,
                cashback,
                currency,
                interchange,
                merchantAcceptorId,
                merchantCategoryCode,
                merchantCity,
                merchantCountry,
                merchantName,
                merchantPostalCode,
                merchantState,
                networkIdentifiers,
                presentmentAmount,
                presentmentCurrency,
                purchaseDetails,
                transactionId,
                type,
                mutableMapOf(),
            )

            /**
             * The Card Refund identifier.
             *
             * @throws IncreaseInvalidDataException if the JSON field has an unexpected type or is
             *   unexpectedly missing or null (e.g. if the server responded with an unexpected
             *   value).
             */
            fun id(): String = id.getRequired("id")

            /**
             * The amount in the minor unit of the transaction's settlement currency. For dollars,
             * for example, this is cents.
             *
             * @throws IncreaseInvalidDataException if the JSON field has an unexpected type or is
             *   unexpectedly missing or null (e.g. if the server responded with an unexpected
             *   value).
             */
            fun amount(): Long = amount.getRequired("amount")

            /**
             * The ID of the Card Payment this transaction belongs to.
             *
             * @throws IncreaseInvalidDataException if the JSON field has an unexpected type or is
             *   unexpectedly missing or null (e.g. if the server responded with an unexpected
             *   value).
             */
            fun cardPaymentId(): String = cardPaymentId.getRequired("card_payment_id")

            /**
             * Cashback debited for this transaction, if eligible. Cashback is paid out in
             * aggregate, monthly.
             *
             * @throws IncreaseInvalidDataException if the JSON field has an unexpected type (e.g.
             *   if the server responded with an unexpected value).
             */
            fun cashback(): Optional<Cashback> = cashback.getOptional("cashback")

            /**
             * The [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) code for the transaction's
             * settlement currency.
             *
             * @throws IncreaseInvalidDataException if the JSON field has an unexpected type or is
             *   unexpectedly missing or null (e.g. if the server responded with an unexpected
             *   value).
             */
            fun currency(): Currency = currency.getRequired("currency")

            /**
             * Interchange assessed as a part of this transaciton.
             *
             * @throws IncreaseInvalidDataException if the JSON field has an unexpected type (e.g.
             *   if the server responded with an unexpected value).
             */
            fun interchange(): Optional<Interchange> = interchange.getOptional("interchange")

            /**
             * The merchant identifier (commonly abbreviated as MID) of the merchant the card is
             * transacting with.
             *
             * @throws IncreaseInvalidDataException if the JSON field has an unexpected type or is
             *   unexpectedly missing or null (e.g. if the server responded with an unexpected
             *   value).
             */
            fun merchantAcceptorId(): String =
                merchantAcceptorId.getRequired("merchant_acceptor_id")

            /**
             * The 4-digit MCC describing the merchant's business.
             *
             * @throws IncreaseInvalidDataException if the JSON field has an unexpected type or is
             *   unexpectedly missing or null (e.g. if the server responded with an unexpected
             *   value).
             */
            fun merchantCategoryCode(): String =
                merchantCategoryCode.getRequired("merchant_category_code")

            /**
             * The city the merchant resides in.
             *
             * @throws IncreaseInvalidDataException if the JSON field has an unexpected type or is
             *   unexpectedly missing or null (e.g. if the server responded with an unexpected
             *   value).
             */
            fun merchantCity(): String = merchantCity.getRequired("merchant_city")

            /**
             * The country the merchant resides in.
             *
             * @throws IncreaseInvalidDataException if the JSON field has an unexpected type or is
             *   unexpectedly missing or null (e.g. if the server responded with an unexpected
             *   value).
             */
            fun merchantCountry(): String = merchantCountry.getRequired("merchant_country")

            /**
             * The name of the merchant.
             *
             * @throws IncreaseInvalidDataException if the JSON field has an unexpected type or is
             *   unexpectedly missing or null (e.g. if the server responded with an unexpected
             *   value).
             */
            fun merchantName(): String = merchantName.getRequired("merchant_name")

            /**
             * The merchant's postal code. For US merchants this is always a 5-digit ZIP code.
             *
             * @throws IncreaseInvalidDataException if the JSON field has an unexpected type (e.g.
             *   if the server responded with an unexpected value).
             */
            fun merchantPostalCode(): Optional<String> =
                merchantPostalCode.getOptional("merchant_postal_code")

            /**
             * The state the merchant resides in.
             *
             * @throws IncreaseInvalidDataException if the JSON field has an unexpected type (e.g.
             *   if the server responded with an unexpected value).
             */
            fun merchantState(): Optional<String> = merchantState.getOptional("merchant_state")

            /**
             * Network-specific identifiers for this refund.
             *
             * @throws IncreaseInvalidDataException if the JSON field has an unexpected type or is
             *   unexpectedly missing or null (e.g. if the server responded with an unexpected
             *   value).
             */
            fun networkIdentifiers(): NetworkIdentifiers =
                networkIdentifiers.getRequired("network_identifiers")

            /**
             * The amount in the minor unit of the transaction's presentment currency.
             *
             * @throws IncreaseInvalidDataException if the JSON field has an unexpected type or is
             *   unexpectedly missing or null (e.g. if the server responded with an unexpected
             *   value).
             */
            fun presentmentAmount(): Long = presentmentAmount.getRequired("presentment_amount")

            /**
             * The [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) code for the transaction's
             * presentment currency.
             *
             * @throws IncreaseInvalidDataException if the JSON field has an unexpected type or is
             *   unexpectedly missing or null (e.g. if the server responded with an unexpected
             *   value).
             */
            fun presentmentCurrency(): String =
                presentmentCurrency.getRequired("presentment_currency")

            /**
             * Additional details about the card purchase, such as tax and industry-specific fields.
             *
             * @throws IncreaseInvalidDataException if the JSON field has an unexpected type (e.g.
             *   if the server responded with an unexpected value).
             */
            fun purchaseDetails(): Optional<PurchaseDetails> =
                purchaseDetails.getOptional("purchase_details")

            /**
             * The identifier of the Transaction associated with this Transaction.
             *
             * @throws IncreaseInvalidDataException if the JSON field has an unexpected type or is
             *   unexpectedly missing or null (e.g. if the server responded with an unexpected
             *   value).
             */
            fun transactionId(): String = transactionId.getRequired("transaction_id")

            /**
             * A constant representing the object's type. For this resource it will always be
             * `card_refund`.
             *
             * @throws IncreaseInvalidDataException if the JSON field has an unexpected type or is
             *   unexpectedly missing or null (e.g. if the server responded with an unexpected
             *   value).
             */
            fun type(): Type = type.getRequired("type")

            /**
             * Returns the raw JSON value of [id].
             *
             * Unlike [id], this method doesn't throw if the JSON field has an unexpected type.
             */
            @JsonProperty("id") @ExcludeMissing fun _id(): JsonField<String> = id

            /**
             * Returns the raw JSON value of [amount].
             *
             * Unlike [amount], this method doesn't throw if the JSON field has an unexpected type.
             */
            @JsonProperty("amount") @ExcludeMissing fun _amount(): JsonField<Long> = amount

            /**
             * Returns the raw JSON value of [cardPaymentId].
             *
             * Unlike [cardPaymentId], this method doesn't throw if the JSON field has an unexpected
             * type.
             */
            @JsonProperty("card_payment_id")
            @ExcludeMissing
            fun _cardPaymentId(): JsonField<String> = cardPaymentId

            /**
             * Returns the raw JSON value of [cashback].
             *
             * Unlike [cashback], this method doesn't throw if the JSON field has an unexpected
             * type.
             */
            @JsonProperty("cashback")
            @ExcludeMissing
            fun _cashback(): JsonField<Cashback> = cashback

            /**
             * Returns the raw JSON value of [currency].
             *
             * Unlike [currency], this method doesn't throw if the JSON field has an unexpected
             * type.
             */
            @JsonProperty("currency")
            @ExcludeMissing
            fun _currency(): JsonField<Currency> = currency

            /**
             * Returns the raw JSON value of [interchange].
             *
             * Unlike [interchange], this method doesn't throw if the JSON field has an unexpected
             * type.
             */
            @JsonProperty("interchange")
            @ExcludeMissing
            fun _interchange(): JsonField<Interchange> = interchange

            /**
             * Returns the raw JSON value of [merchantAcceptorId].
             *
             * Unlike [merchantAcceptorId], this method doesn't throw if the JSON field has an
             * unexpected type.
             */
            @JsonProperty("merchant_acceptor_id")
            @ExcludeMissing
            fun _merchantAcceptorId(): JsonField<String> = merchantAcceptorId

            /**
             * Returns the raw JSON value of [merchantCategoryCode].
             *
             * Unlike [merchantCategoryCode], this method doesn't throw if the JSON field has an
             * unexpected type.
             */
            @JsonProperty("merchant_category_code")
            @ExcludeMissing
            fun _merchantCategoryCode(): JsonField<String> = merchantCategoryCode

            /**
             * Returns the raw JSON value of [merchantCity].
             *
             * Unlike [merchantCity], this method doesn't throw if the JSON field has an unexpected
             * type.
             */
            @JsonProperty("merchant_city")
            @ExcludeMissing
            fun _merchantCity(): JsonField<String> = merchantCity

            /**
             * Returns the raw JSON value of [merchantCountry].
             *
             * Unlike [merchantCountry], this method doesn't throw if the JSON field has an
             * unexpected type.
             */
            @JsonProperty("merchant_country")
            @ExcludeMissing
            fun _merchantCountry(): JsonField<String> = merchantCountry

            /**
             * Returns the raw JSON value of [merchantName].
             *
             * Unlike [merchantName], this method doesn't throw if the JSON field has an unexpected
             * type.
             */
            @JsonProperty("merchant_name")
            @ExcludeMissing
            fun _merchantName(): JsonField<String> = merchantName

            /**
             * Returns the raw JSON value of [merchantPostalCode].
             *
             * Unlike [merchantPostalCode], this method doesn't throw if the JSON field has an
             * unexpected type.
             */
            @JsonProperty("merchant_postal_code")
            @ExcludeMissing
            fun _merchantPostalCode(): JsonField<String> = merchantPostalCode

            /**
             * Returns the raw JSON value of [merchantState].
             *
             * Unlike [merchantState], this method doesn't throw if the JSON field has an unexpected
             * type.
             */
            @JsonProperty("merchant_state")
            @ExcludeMissing
            fun _merchantState(): JsonField<String> = merchantState

            /**
             * Returns the raw JSON value of [networkIdentifiers].
             *
             * Unlike [networkIdentifiers], this method doesn't throw if the JSON field has an
             * unexpected type.
             */
            @JsonProperty("network_identifiers")
            @ExcludeMissing
            fun _networkIdentifiers(): JsonField<NetworkIdentifiers> = networkIdentifiers

            /**
             * Returns the raw JSON value of [presentmentAmount].
             *
             * Unlike [presentmentAmount], this method doesn't throw if the JSON field has an
             * unexpected type.
             */
            @JsonProperty("presentment_amount")
            @ExcludeMissing
            fun _presentmentAmount(): JsonField<Long> = presentmentAmount

            /**
             * Returns the raw JSON value of [presentmentCurrency].
             *
             * Unlike [presentmentCurrency], this method doesn't throw if the JSON field has an
             * unexpected type.
             */
            @JsonProperty("presentment_currency")
            @ExcludeMissing
            fun _presentmentCurrency(): JsonField<String> = presentmentCurrency

            /**
             * Returns the raw JSON value of [purchaseDetails].
             *
             * Unlike [purchaseDetails], this method doesn't throw if the JSON field has an
             * unexpected type.
             */
            @JsonProperty("purchase_details")
            @ExcludeMissing
            fun _purchaseDetails(): JsonField<PurchaseDetails> = purchaseDetails

            /**
             * Returns the raw JSON value of [transactionId].
             *
             * Unlike [transactionId], this method doesn't throw if the JSON field has an unexpected
             * type.
             */
            @JsonProperty("transaction_id")
            @ExcludeMissing
            fun _transactionId(): JsonField<String> = transactionId

            /**
             * Returns the raw JSON value of [type].
             *
             * Unlike [type], this method doesn't throw if the JSON field has an unexpected type.
             */
            @JsonProperty("type") @ExcludeMissing fun _type(): JsonField<Type> = type

            @JsonAnySetter
            private fun putAdditionalProperty(key: String, value: JsonValue) {
                additionalProperties.put(key, value)
            }

            @JsonAnyGetter
            @ExcludeMissing
            fun _additionalProperties(): Map<String, JsonValue> =
                Collections.unmodifiableMap(additionalProperties)

            fun toBuilder() = Builder().from(this)

            companion object {

                /**
                 * Returns a mutable builder for constructing an instance of [CardRefund].
                 *
                 * The following fields are required:
                 * ```java
                 * .id()
                 * .amount()
                 * .cardPaymentId()
                 * .cashback()
                 * .currency()
                 * .interchange()
                 * .merchantAcceptorId()
                 * .merchantCategoryCode()
                 * .merchantCity()
                 * .merchantCountry()
                 * .merchantName()
                 * .merchantPostalCode()
                 * .merchantState()
                 * .networkIdentifiers()
                 * .presentmentAmount()
                 * .presentmentCurrency()
                 * .purchaseDetails()
                 * .transactionId()
                 * .type()
                 * ```
                 */
                @JvmStatic fun builder() = Builder()
            }

            /** A builder for [CardRefund]. */
            class Builder internal constructor() {

                private var id: JsonField<String>? = null
                private var amount: JsonField<Long>? = null
                private var cardPaymentId: JsonField<String>? = null
                private var cashback: JsonField<Cashback>? = null
                private var currency: JsonField<Currency>? = null
                private var interchange: JsonField<Interchange>? = null
                private var merchantAcceptorId: JsonField<String>? = null
                private var merchantCategoryCode: JsonField<String>? = null
                private var merchantCity: JsonField<String>? = null
                private var merchantCountry: JsonField<String>? = null
                private var merchantName: JsonField<String>? = null
                private var merchantPostalCode: JsonField<String>? = null
                private var merchantState: JsonField<String>? = null
                private var networkIdentifiers: JsonField<NetworkIdentifiers>? = null
                private var presentmentAmount: JsonField<Long>? = null
                private var presentmentCurrency: JsonField<String>? = null
                private var purchaseDetails: JsonField<PurchaseDetails>? = null
                private var transactionId: JsonField<String>? = null
                private var type: JsonField<Type>? = null
                private var additionalProperties: MutableMap<String, JsonValue> = mutableMapOf()

                @JvmSynthetic
                internal fun from(cardRefund: CardRefund) = apply {
                    id = cardRefund.id
                    amount = cardRefund.amount
                    cardPaymentId = cardRefund.cardPaymentId
                    cashback = cardRefund.cashback
                    currency = cardRefund.currency
                    interchange = cardRefund.interchange
                    merchantAcceptorId = cardRefund.merchantAcceptorId
                    merchantCategoryCode = cardRefund.merchantCategoryCode
                    merchantCity = cardRefund.merchantCity
                    merchantCountry = cardRefund.merchantCountry
                    merchantName = cardRefund.merchantName
                    merchantPostalCode = cardRefund.merchantPostalCode
                    merchantState = cardRefund.merchantState
                    networkIdentifiers = cardRefund.networkIdentifiers
                    presentmentAmount = cardRefund.presentmentAmount
                    presentmentCurrency = cardRefund.presentmentCurrency
                    purchaseDetails = cardRefund.purchaseDetails
                    transactionId = cardRefund.transactionId
                    type = cardRefund.type
                    additionalProperties = cardRefund.additionalProperties.toMutableMap()
                }

                /** The Card Refund identifier. */
                fun id(id: String) = id(JsonField.of(id))

                /**
                 * Sets [Builder.id] to an arbitrary JSON value.
                 *
                 * You should usually call [Builder.id] with a well-typed [String] value instead.
                 * This method is primarily for setting the field to an undocumented or not yet
                 * supported value.
                 */
                fun id(id: JsonField<String>) = apply { this.id = id }

                /**
                 * The amount in the minor unit of the transaction's settlement currency. For
                 * dollars, for example, this is cents.
                 */
                fun amount(amount: Long) = amount(JsonField.of(amount))

                /**
                 * Sets [Builder.amount] to an arbitrary JSON value.
                 *
                 * You should usually call [Builder.amount] with a well-typed [Long] value instead.
                 * This method is primarily for setting the field to an undocumented or not yet
                 * supported value.
                 */
                fun amount(amount: JsonField<Long>) = apply { this.amount = amount }

                /** The ID of the Card Payment this transaction belongs to. */
                fun cardPaymentId(cardPaymentId: String) =
                    cardPaymentId(JsonField.of(cardPaymentId))

                /**
                 * Sets [Builder.cardPaymentId] to an arbitrary JSON value.
                 *
                 * You should usually call [Builder.cardPaymentId] with a well-typed [String] value
                 * instead. This method is primarily for setting the field to an undocumented or not
                 * yet supported value.
                 */
                fun cardPaymentId(cardPaymentId: JsonField<String>) = apply {
                    this.cardPaymentId = cardPaymentId
                }

                /**
                 * Cashback debited for this transaction, if eligible. Cashback is paid out in
                 * aggregate, monthly.
                 */
                fun cashback(cashback: Cashback?) = cashback(JsonField.ofNullable(cashback))

                /** Alias for calling [Builder.cashback] with `cashback.orElse(null)`. */
                fun cashback(cashback: Optional<Cashback>) = cashback(cashback.getOrNull())

                /**
                 * Sets [Builder.cashback] to an arbitrary JSON value.
                 *
                 * You should usually call [Builder.cashback] with a well-typed [Cashback] value
                 * instead. This method is primarily for setting the field to an undocumented or not
                 * yet supported value.
                 */
                fun cashback(cashback: JsonField<Cashback>) = apply { this.cashback = cashback }

                /**
                 * The [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) code for the transaction's
                 * settlement currency.
                 */
                fun currency(currency: Currency) = currency(JsonField.of(currency))

                /**
                 * Sets [Builder.currency] to an arbitrary JSON value.
                 *
                 * You should usually call [Builder.currency] with a well-typed [Currency] value
                 * instead. This method is primarily for setting the field to an undocumented or not
                 * yet supported value.
                 */
                fun currency(currency: JsonField<Currency>) = apply { this.currency = currency }

                /** Interchange assessed as a part of this transaciton. */
                fun interchange(interchange: Interchange?) =
                    interchange(JsonField.ofNullable(interchange))

                /** Alias for calling [Builder.interchange] with `interchange.orElse(null)`. */
                fun interchange(interchange: Optional<Interchange>) =
                    interchange(interchange.getOrNull())

                /**
                 * Sets [Builder.interchange] to an arbitrary JSON value.
                 *
                 * You should usually call [Builder.interchange] with a well-typed [Interchange]
                 * value instead. This method is primarily for setting the field to an undocumented
                 * or not yet supported value.
                 */
                fun interchange(interchange: JsonField<Interchange>) = apply {
                    this.interchange = interchange
                }

                /**
                 * The merchant identifier (commonly abbreviated as MID) of the merchant the card is
                 * transacting with.
                 */
                fun merchantAcceptorId(merchantAcceptorId: String) =
                    merchantAcceptorId(JsonField.of(merchantAcceptorId))

                /**
                 * Sets [Builder.merchantAcceptorId] to an arbitrary JSON value.
                 *
                 * You should usually call [Builder.merchantAcceptorId] with a well-typed [String]
                 * value instead. This method is primarily for setting the field to an undocumented
                 * or not yet supported value.
                 */
                fun merchantAcceptorId(merchantAcceptorId: JsonField<String>) = apply {
                    this.merchantAcceptorId = merchantAcceptorId
                }

                /** The 4-digit MCC describing the merchant's business. */
                fun merchantCategoryCode(merchantCategoryCode: String) =
                    merchantCategoryCode(JsonField.of(merchantCategoryCode))

                /**
                 * Sets [Builder.merchantCategoryCode] to an arbitrary JSON value.
                 *
                 * You should usually call [Builder.merchantCategoryCode] with a well-typed [String]
                 * value instead. This method is primarily for setting the field to an undocumented
                 * or not yet supported value.
                 */
                fun merchantCategoryCode(merchantCategoryCode: JsonField<String>) = apply {
                    this.merchantCategoryCode = merchantCategoryCode
                }

                /** The city the merchant resides in. */
                fun merchantCity(merchantCity: String) = merchantCity(JsonField.of(merchantCity))

                /**
                 * Sets [Builder.merchantCity] to an arbitrary JSON value.
                 *
                 * You should usually call [Builder.merchantCity] with a well-typed [String] value
                 * instead. This method is primarily for setting the field to an undocumented or not
                 * yet supported value.
                 */
                fun merchantCity(merchantCity: JsonField<String>) = apply {
                    this.merchantCity = merchantCity
                }

                /** The country the merchant resides in. */
                fun merchantCountry(merchantCountry: String) =
                    merchantCountry(JsonField.of(merchantCountry))

                /**
                 * Sets [Builder.merchantCountry] to an arbitrary JSON value.
                 *
                 * You should usually call [Builder.merchantCountry] with a well-typed [String]
                 * value instead. This method is primarily for setting the field to an undocumented
                 * or not yet supported value.
                 */
                fun merchantCountry(merchantCountry: JsonField<String>) = apply {
                    this.merchantCountry = merchantCountry
                }

                /** The name of the merchant. */
                fun merchantName(merchantName: String) = merchantName(JsonField.of(merchantName))

                /**
                 * Sets [Builder.merchantName] to an arbitrary JSON value.
                 *
                 * You should usually call [Builder.merchantName] with a well-typed [String] value
                 * instead. This method is primarily for setting the field to an undocumented or not
                 * yet supported value.
                 */
                fun merchantName(merchantName: JsonField<String>) = apply {
                    this.merchantName = merchantName
                }

                /**
                 * The merchant's postal code. For US merchants this is always a 5-digit ZIP code.
                 */
                fun merchantPostalCode(merchantPostalCode: String?) =
                    merchantPostalCode(JsonField.ofNullable(merchantPostalCode))

                /**
                 * Alias for calling [Builder.merchantPostalCode] with
                 * `merchantPostalCode.orElse(null)`.
                 */
                fun merchantPostalCode(merchantPostalCode: Optional<String>) =
                    merchantPostalCode(merchantPostalCode.getOrNull())

                /**
                 * Sets [Builder.merchantPostalCode] to an arbitrary JSON value.
                 *
                 * You should usually call [Builder.merchantPostalCode] with a well-typed [String]
                 * value instead. This method is primarily for setting the field to an undocumented
                 * or not yet supported value.
                 */
                fun merchantPostalCode(merchantPostalCode: JsonField<String>) = apply {
                    this.merchantPostalCode = merchantPostalCode
                }

                /** The state the merchant resides in. */
                fun merchantState(merchantState: String?) =
                    merchantState(JsonField.ofNullable(merchantState))

                /** Alias for calling [Builder.merchantState] with `merchantState.orElse(null)`. */
                fun merchantState(merchantState: Optional<String>) =
                    merchantState(merchantState.getOrNull())

                /**
                 * Sets [Builder.merchantState] to an arbitrary JSON value.
                 *
                 * You should usually call [Builder.merchantState] with a well-typed [String] value
                 * instead. This method is primarily for setting the field to an undocumented or not
                 * yet supported value.
                 */
                fun merchantState(merchantState: JsonField<String>) = apply {
                    this.merchantState = merchantState
                }

                /** Network-specific identifiers for this refund. */
                fun networkIdentifiers(networkIdentifiers: NetworkIdentifiers) =
                    networkIdentifiers(JsonField.of(networkIdentifiers))

                /**
                 * Sets [Builder.networkIdentifiers] to an arbitrary JSON value.
                 *
                 * You should usually call [Builder.networkIdentifiers] with a well-typed
                 * [NetworkIdentifiers] value instead. This method is primarily for setting the
                 * field to an undocumented or not yet supported value.
                 */
                fun networkIdentifiers(networkIdentifiers: JsonField<NetworkIdentifiers>) = apply {
                    this.networkIdentifiers = networkIdentifiers
                }

                /** The amount in the minor unit of the transaction's presentment currency. */
                fun presentmentAmount(presentmentAmount: Long) =
                    presentmentAmount(JsonField.of(presentmentAmount))

                /**
                 * Sets [Builder.presentmentAmount] to an arbitrary JSON value.
                 *
                 * You should usually call [Builder.presentmentAmount] with a well-typed [Long]
                 * value instead. This method is primarily for setting the field to an undocumented
                 * or not yet supported value.
                 */
                fun presentmentAmount(presentmentAmount: JsonField<Long>) = apply {
                    this.presentmentAmount = presentmentAmount
                }

                /**
                 * The [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) code for the transaction's
                 * presentment currency.
                 */
                fun presentmentCurrency(presentmentCurrency: String) =
                    presentmentCurrency(JsonField.of(presentmentCurrency))

                /**
                 * Sets [Builder.presentmentCurrency] to an arbitrary JSON value.
                 *
                 * You should usually call [Builder.presentmentCurrency] with a well-typed [String]
                 * value instead. This method is primarily for setting the field to an undocumented
                 * or not yet supported value.
                 */
                fun presentmentCurrency(presentmentCurrency: JsonField<String>) = apply {
                    this.presentmentCurrency = presentmentCurrency
                }

                /**
                 * Additional details about the card purchase, such as tax and industry-specific
                 * fields.
                 */
                fun purchaseDetails(purchaseDetails: PurchaseDetails?) =
                    purchaseDetails(JsonField.ofNullable(purchaseDetails))

                /**
                 * Alias for calling [Builder.purchaseDetails] with `purchaseDetails.orElse(null)`.
                 */
                fun purchaseDetails(purchaseDetails: Optional<PurchaseDetails>) =
                    purchaseDetails(purchaseDetails.getOrNull())

                /**
                 * Sets [Builder.purchaseDetails] to an arbitrary JSON value.
                 *
                 * You should usually call [Builder.purchaseDetails] with a well-typed
                 * [PurchaseDetails] value instead. This method is primarily for setting the field
                 * to an undocumented or not yet supported value.
                 */
                fun purchaseDetails(purchaseDetails: JsonField<PurchaseDetails>) = apply {
                    this.purchaseDetails = purchaseDetails
                }

                /** The identifier of the Transaction associated with this Transaction. */
                fun transactionId(transactionId: String) =
                    transactionId(JsonField.of(transactionId))

                /**
                 * Sets [Builder.transactionId] to an arbitrary JSON value.
                 *
                 * You should usually call [Builder.transactionId] with a well-typed [String] value
                 * instead. This method is primarily for setting the field to an undocumented or not
                 * yet supported value.
                 */
                fun transactionId(transactionId: JsonField<String>) = apply {
                    this.transactionId = transactionId
                }

                /**
                 * A constant representing the object's type. For this resource it will always be
                 * `card_refund`.
                 */
                fun type(type: Type) = type(JsonField.of(type))

                /**
                 * Sets [Builder.type] to an arbitrary JSON value.
                 *
                 * You should usually call [Builder.type] with a well-typed [Type] value instead.
                 * This method is primarily for setting the field to an undocumented or not yet
                 * supported value.
                 */
                fun type(type: JsonField<Type>) = apply { this.type = type }

                fun additionalProperties(additionalProperties: Map<String, JsonValue>) = apply {
                    this.additionalProperties.clear()
                    putAllAdditionalProperties(additionalProperties)
                }

                fun putAdditionalProperty(key: String, value: JsonValue) = apply {
                    additionalProperties.put(key, value)
                }

                fun putAllAdditionalProperties(additionalProperties: Map<String, JsonValue>) =
                    apply {
                        this.additionalProperties.putAll(additionalProperties)
                    }

                fun removeAdditionalProperty(key: String) = apply {
                    additionalProperties.remove(key)
                }

                fun removeAllAdditionalProperties(keys: Set<String>) = apply {
                    keys.forEach(::removeAdditionalProperty)
                }

                /**
                 * Returns an immutable instance of [CardRefund].
                 *
                 * Further updates to this [Builder] will not mutate the returned instance.
                 *
                 * The following fields are required:
                 * ```java
                 * .id()
                 * .amount()
                 * .cardPaymentId()
                 * .cashback()
                 * .currency()
                 * .interchange()
                 * .merchantAcceptorId()
                 * .merchantCategoryCode()
                 * .merchantCity()
                 * .merchantCountry()
                 * .merchantName()
                 * .merchantPostalCode()
                 * .merchantState()
                 * .networkIdentifiers()
                 * .presentmentAmount()
                 * .presentmentCurrency()
                 * .purchaseDetails()
                 * .transactionId()
                 * .type()
                 * ```
                 *
                 * @throws IllegalStateException if any required field is unset.
                 */
                fun build(): CardRefund =
                    CardRefund(
                        checkRequired("id", id),
                        checkRequired("amount", amount),
                        checkRequired("cardPaymentId", cardPaymentId),
                        checkRequired("cashback", cashback),
                        checkRequired("currency", currency),
                        checkRequired("interchange", interchange),
                        checkRequired("merchantAcceptorId", merchantAcceptorId),
                        checkRequired("merchantCategoryCode", merchantCategoryCode),
                        checkRequired("merchantCity", merchantCity),
                        checkRequired("merchantCountry", merchantCountry),
                        checkRequired("merchantName", merchantName),
                        checkRequired("merchantPostalCode", merchantPostalCode),
                        checkRequired("merchantState", merchantState),
                        checkRequired("networkIdentifiers", networkIdentifiers),
                        checkRequired("presentmentAmount", presentmentAmount),
                        checkRequired("presentmentCurrency", presentmentCurrency),
                        checkRequired("purchaseDetails", purchaseDetails),
                        checkRequired("transactionId", transactionId),
                        checkRequired("type", type),
                        additionalProperties.toMutableMap(),
                    )
            }

            private var validated: Boolean = false

            fun validate(): CardRefund = apply {
                if (validated) {
                    return@apply
                }

                id()
                amount()
                cardPaymentId()
                cashback().ifPresent { it.validate() }
                currency().validate()
                interchange().ifPresent { it.validate() }
                merchantAcceptorId()
                merchantCategoryCode()
                merchantCity()
                merchantCountry()
                merchantName()
                merchantPostalCode()
                merchantState()
                networkIdentifiers().validate()
                presentmentAmount()
                presentmentCurrency()
                purchaseDetails().ifPresent { it.validate() }
                transactionId()
                type().validate()
                validated = true
            }

            fun isValid(): Boolean =
                try {
                    validate()
                    true
                } catch (e: IncreaseInvalidDataException) {
                    false
                }

            /**
             * Returns a score indicating how many valid values are contained in this object
             * recursively.
             *
             * Used for best match union deserialization.
             */
            @JvmSynthetic
            internal fun validity(): Int =
                (if (id.asKnown().isPresent) 1 else 0) +
                    (if (amount.asKnown().isPresent) 1 else 0) +
                    (if (cardPaymentId.asKnown().isPresent) 1 else 0) +
                    (cashback.asKnown().getOrNull()?.validity() ?: 0) +
                    (currency.asKnown().getOrNull()?.validity() ?: 0) +
                    (interchange.asKnown().getOrNull()?.validity() ?: 0) +
                    (if (merchantAcceptorId.asKnown().isPresent) 1 else 0) +
                    (if (merchantCategoryCode.asKnown().isPresent) 1 else 0) +
                    (if (merchantCity.asKnown().isPresent) 1 else 0) +
                    (if (merchantCountry.asKnown().isPresent) 1 else 0) +
                    (if (merchantName.asKnown().isPresent) 1 else 0) +
                    (if (merchantPostalCode.asKnown().isPresent) 1 else 0) +
                    (if (merchantState.asKnown().isPresent) 1 else 0) +
                    (networkIdentifiers.asKnown().getOrNull()?.validity() ?: 0) +
                    (if (presentmentAmount.asKnown().isPresent) 1 else 0) +
                    (if (presentmentCurrency.asKnown().isPresent) 1 else 0) +
                    (purchaseDetails.asKnown().getOrNull()?.validity() ?: 0) +
                    (if (transactionId.asKnown().isPresent) 1 else 0) +
                    (type.asKnown().getOrNull()?.validity() ?: 0)

            /**
             * Cashback debited for this transaction, if eligible. Cashback is paid out in
             * aggregate, monthly.
             */
            class Cashback
            private constructor(
                private val amount: JsonField<String>,
                private val currency: JsonField<Currency>,
                private val additionalProperties: MutableMap<String, JsonValue>,
            ) {

                @JsonCreator
                private constructor(
                    @JsonProperty("amount")
                    @ExcludeMissing
                    amount: JsonField<String> = JsonMissing.of(),
                    @JsonProperty("currency")
                    @ExcludeMissing
                    currency: JsonField<Currency> = JsonMissing.of(),
                ) : this(amount, currency, mutableMapOf())

                /**
                 * The cashback amount given as a string containing a decimal number. The amount is
                 * a positive number if it will be credited to you (e.g., settlements) and a
                 * negative number if it will be debited (e.g., refunds).
                 *
                 * @throws IncreaseInvalidDataException if the JSON field has an unexpected type or
                 *   is unexpectedly missing or null (e.g. if the server responded with an
                 *   unexpected value).
                 */
                fun amount(): String = amount.getRequired("amount")

                /**
                 * The [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) code for the cashback.
                 *
                 * @throws IncreaseInvalidDataException if the JSON field has an unexpected type or
                 *   is unexpectedly missing or null (e.g. if the server responded with an
                 *   unexpected value).
                 */
                fun currency(): Currency = currency.getRequired("currency")

                /**
                 * Returns the raw JSON value of [amount].
                 *
                 * Unlike [amount], this method doesn't throw if the JSON field has an unexpected
                 * type.
                 */
                @JsonProperty("amount") @ExcludeMissing fun _amount(): JsonField<String> = amount

                /**
                 * Returns the raw JSON value of [currency].
                 *
                 * Unlike [currency], this method doesn't throw if the JSON field has an unexpected
                 * type.
                 */
                @JsonProperty("currency")
                @ExcludeMissing
                fun _currency(): JsonField<Currency> = currency

                @JsonAnySetter
                private fun putAdditionalProperty(key: String, value: JsonValue) {
                    additionalProperties.put(key, value)
                }

                @JsonAnyGetter
                @ExcludeMissing
                fun _additionalProperties(): Map<String, JsonValue> =
                    Collections.unmodifiableMap(additionalProperties)

                fun toBuilder() = Builder().from(this)

                companion object {

                    /**
                     * Returns a mutable builder for constructing an instance of [Cashback].
                     *
                     * The following fields are required:
                     * ```java
                     * .amount()
                     * .currency()
                     * ```
                     */
                    @JvmStatic fun builder() = Builder()
                }

                /** A builder for [Cashback]. */
                class Builder internal constructor() {

                    private var amount: JsonField<String>? = null
                    private var currency: JsonField<Currency>? = null
                    private var additionalProperties: MutableMap<String, JsonValue> = mutableMapOf()

                    @JvmSynthetic
                    internal fun from(cashback: Cashback) = apply {
                        amount = cashback.amount
                        currency = cashback.currency
                        additionalProperties = cashback.additionalProperties.toMutableMap()
                    }

                    /**
                     * The cashback amount given as a string containing a decimal number. The amount
                     * is a positive number if it will be credited to you (e.g., settlements) and a
                     * negative number if it will be debited (e.g., refunds).
                     */
                    fun amount(amount: String) = amount(JsonField.of(amount))

                    /**
                     * Sets [Builder.amount] to an arbitrary JSON value.
                     *
                     * You should usually call [Builder.amount] with a well-typed [String] value
                     * instead. This method is primarily for setting the field to an undocumented or
                     * not yet supported value.
                     */
                    fun amount(amount: JsonField<String>) = apply { this.amount = amount }

                    /**
                     * The [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) code for the cashback.
                     */
                    fun currency(currency: Currency) = currency(JsonField.of(currency))

                    /**
                     * Sets [Builder.currency] to an arbitrary JSON value.
                     *
                     * You should usually call [Builder.currency] with a well-typed [Currency] value
                     * instead. This method is primarily for setting the field to an undocumented or
                     * not yet supported value.
                     */
                    fun currency(currency: JsonField<Currency>) = apply { this.currency = currency }

                    fun additionalProperties(additionalProperties: Map<String, JsonValue>) = apply {
                        this.additionalProperties.clear()
                        putAllAdditionalProperties(additionalProperties)
                    }

                    fun putAdditionalProperty(key: String, value: JsonValue) = apply {
                        additionalProperties.put(key, value)
                    }

                    fun putAllAdditionalProperties(additionalProperties: Map<String, JsonValue>) =
                        apply {
                            this.additionalProperties.putAll(additionalProperties)
                        }

                    fun removeAdditionalProperty(key: String) = apply {
                        additionalProperties.remove(key)
                    }

                    fun removeAllAdditionalProperties(keys: Set<String>) = apply {
                        keys.forEach(::removeAdditionalProperty)
                    }

                    /**
                     * Returns an immutable instance of [Cashback].
                     *
                     * Further updates to this [Builder] will not mutate the returned instance.
                     *
                     * The following fields are required:
                     * ```java
                     * .amount()
                     * .currency()
                     * ```
                     *
                     * @throws IllegalStateException if any required field is unset.
                     */
                    fun build(): Cashback =
                        Cashback(
                            checkRequired("amount", amount),
                            checkRequired("currency", currency),
                            additionalProperties.toMutableMap(),
                        )
                }

                private var validated: Boolean = false

                fun validate(): Cashback = apply {
                    if (validated) {
                        return@apply
                    }

                    amount()
                    currency().validate()
                    validated = true
                }

                fun isValid(): Boolean =
                    try {
                        validate()
                        true
                    } catch (e: IncreaseInvalidDataException) {
                        false
                    }

                /**
                 * Returns a score indicating how many valid values are contained in this object
                 * recursively.
                 *
                 * Used for best match union deserialization.
                 */
                @JvmSynthetic
                internal fun validity(): Int =
                    (if (amount.asKnown().isPresent) 1 else 0) +
                        (currency.asKnown().getOrNull()?.validity() ?: 0)

                /** The [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) code for the cashback. */
                class Currency
                @JsonCreator
                private constructor(private val value: JsonField<String>) : Enum {

                    /**
                     * Returns this class instance's raw value.
                     *
                     * This is usually only useful if this instance was deserialized from data that
                     * doesn't match any known member, and you want to know that value. For example,
                     * if the SDK is on an older version than the API, then the API may respond with
                     * new members that the SDK is unaware of.
                     */
                    @com.fasterxml.jackson.annotation.JsonValue
                    fun _value(): JsonField<String> = value

                    companion object {

                        /** Canadian Dollar (CAD) */
                        @JvmField val CAD = of("CAD")

                        /** Swiss Franc (CHF) */
                        @JvmField val CHF = of("CHF")

                        /** Euro (EUR) */
                        @JvmField val EUR = of("EUR")

                        /** British Pound (GBP) */
                        @JvmField val GBP = of("GBP")

                        /** Japanese Yen (JPY) */
                        @JvmField val JPY = of("JPY")

                        /** US Dollar (USD) */
                        @JvmField val USD = of("USD")

                        @JvmStatic fun of(value: String) = Currency(JsonField.of(value))
                    }

                    /** An enum containing [Currency]'s known values. */
                    enum class Known {
                        /** Canadian Dollar (CAD) */
                        CAD,
                        /** Swiss Franc (CHF) */
                        CHF,
                        /** Euro (EUR) */
                        EUR,
                        /** British Pound (GBP) */
                        GBP,
                        /** Japanese Yen (JPY) */
                        JPY,
                        /** US Dollar (USD) */
                        USD,
                    }

                    /**
                     * An enum containing [Currency]'s known values, as well as an [_UNKNOWN]
                     * member.
                     *
                     * An instance of [Currency] can contain an unknown value in a couple of cases:
                     * - It was deserialized from data that doesn't match any known member. For
                     *   example, if the SDK is on an older version than the API, then the API may
                     *   respond with new members that the SDK is unaware of.
                     * - It was constructed with an arbitrary value using the [of] method.
                     */
                    enum class Value {
                        /** Canadian Dollar (CAD) */
                        CAD,
                        /** Swiss Franc (CHF) */
                        CHF,
                        /** Euro (EUR) */
                        EUR,
                        /** British Pound (GBP) */
                        GBP,
                        /** Japanese Yen (JPY) */
                        JPY,
                        /** US Dollar (USD) */
                        USD,
                        /**
                         * An enum member indicating that [Currency] was instantiated with an
                         * unknown value.
                         */
                        _UNKNOWN,
                    }

                    /**
                     * Returns an enum member corresponding to this class instance's value, or
                     * [Value._UNKNOWN] if the class was instantiated with an unknown value.
                     *
                     * Use the [known] method instead if you're certain the value is always known or
                     * if you want to throw for the unknown case.
                     */
                    fun value(): Value =
                        when (this) {
                            CAD -> Value.CAD
                            CHF -> Value.CHF
                            EUR -> Value.EUR
                            GBP -> Value.GBP
                            JPY -> Value.JPY
                            USD -> Value.USD
                            else -> Value._UNKNOWN
                        }

                    /**
                     * Returns an enum member corresponding to this class instance's value.
                     *
                     * Use the [value] method instead if you're uncertain the value is always known
                     * and don't want to throw for the unknown case.
                     *
                     * @throws IncreaseInvalidDataException if this class instance's value is a not
                     *   a known member.
                     */
                    fun known(): Known =
                        when (this) {
                            CAD -> Known.CAD
                            CHF -> Known.CHF
                            EUR -> Known.EUR
                            GBP -> Known.GBP
                            JPY -> Known.JPY
                            USD -> Known.USD
                            else -> throw IncreaseInvalidDataException("Unknown Currency: $value")
                        }

                    /**
                     * Returns this class instance's primitive wire representation.
                     *
                     * This differs from the [toString] method because that method is primarily for
                     * debugging and generally doesn't throw.
                     *
                     * @throws IncreaseInvalidDataException if this class instance's value does not
                     *   have the expected primitive type.
                     */
                    fun asString(): String =
                        _value().asString().orElseThrow {
                            IncreaseInvalidDataException("Value is not a String")
                        }

                    private var validated: Boolean = false

                    fun validate(): Currency = apply {
                        if (validated) {
                            return@apply
                        }

                        known()
                        validated = true
                    }

                    fun isValid(): Boolean =
                        try {
                            validate()
                            true
                        } catch (e: IncreaseInvalidDataException) {
                            false
                        }

                    /**
                     * Returns a score indicating how many valid values are contained in this object
                     * recursively.
                     *
                     * Used for best match union deserialization.
                     */
                    @JvmSynthetic
                    internal fun validity(): Int = if (value() == Value._UNKNOWN) 0 else 1

                    override fun equals(other: Any?): Boolean {
                        if (this === other) {
                            return true
                        }

                        return /* spotless:off */ other is Currency && value == other.value /* spotless:on */
                    }

                    override fun hashCode() = value.hashCode()

                    override fun toString() = value.toString()
                }

                override fun equals(other: Any?): Boolean {
                    if (this === other) {
                        return true
                    }

                    return /* spotless:off */ other is Cashback && amount == other.amount && currency == other.currency && additionalProperties == other.additionalProperties /* spotless:on */
                }

                /* spotless:off */
                private val hashCode: Int by lazy { Objects.hash(amount, currency, additionalProperties) }
                /* spotless:on */

                override fun hashCode(): Int = hashCode

                override fun toString() =
                    "Cashback{amount=$amount, currency=$currency, additionalProperties=$additionalProperties}"
            }

            /**
             * The [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) code for the transaction's
             * settlement currency.
             */
            class Currency @JsonCreator private constructor(private val value: JsonField<String>) :
                Enum {

                /**
                 * Returns this class instance's raw value.
                 *
                 * This is usually only useful if this instance was deserialized from data that
                 * doesn't match any known member, and you want to know that value. For example, if
                 * the SDK is on an older version than the API, then the API may respond with new
                 * members that the SDK is unaware of.
                 */
                @com.fasterxml.jackson.annotation.JsonValue fun _value(): JsonField<String> = value

                companion object {

                    /** Canadian Dollar (CAD) */
                    @JvmField val CAD = of("CAD")

                    /** Swiss Franc (CHF) */
                    @JvmField val CHF = of("CHF")

                    /** Euro (EUR) */
                    @JvmField val EUR = of("EUR")

                    /** British Pound (GBP) */
                    @JvmField val GBP = of("GBP")

                    /** Japanese Yen (JPY) */
                    @JvmField val JPY = of("JPY")

                    /** US Dollar (USD) */
                    @JvmField val USD = of("USD")

                    @JvmStatic fun of(value: String) = Currency(JsonField.of(value))
                }

                /** An enum containing [Currency]'s known values. */
                enum class Known {
                    /** Canadian Dollar (CAD) */
                    CAD,
                    /** Swiss Franc (CHF) */
                    CHF,
                    /** Euro (EUR) */
                    EUR,
                    /** British Pound (GBP) */
                    GBP,
                    /** Japanese Yen (JPY) */
                    JPY,
                    /** US Dollar (USD) */
                    USD,
                }

                /**
                 * An enum containing [Currency]'s known values, as well as an [_UNKNOWN] member.
                 *
                 * An instance of [Currency] can contain an unknown value in a couple of cases:
                 * - It was deserialized from data that doesn't match any known member. For example,
                 *   if the SDK is on an older version than the API, then the API may respond with
                 *   new members that the SDK is unaware of.
                 * - It was constructed with an arbitrary value using the [of] method.
                 */
                enum class Value {
                    /** Canadian Dollar (CAD) */
                    CAD,
                    /** Swiss Franc (CHF) */
                    CHF,
                    /** Euro (EUR) */
                    EUR,
                    /** British Pound (GBP) */
                    GBP,
                    /** Japanese Yen (JPY) */
                    JPY,
                    /** US Dollar (USD) */
                    USD,
                    /**
                     * An enum member indicating that [Currency] was instantiated with an unknown
                     * value.
                     */
                    _UNKNOWN,
                }

                /**
                 * Returns an enum member corresponding to this class instance's value, or
                 * [Value._UNKNOWN] if the class was instantiated with an unknown value.
                 *
                 * Use the [known] method instead if you're certain the value is always known or if
                 * you want to throw for the unknown case.
                 */
                fun value(): Value =
                    when (this) {
                        CAD -> Value.CAD
                        CHF -> Value.CHF
                        EUR -> Value.EUR
                        GBP -> Value.GBP
                        JPY -> Value.JPY
                        USD -> Value.USD
                        else -> Value._UNKNOWN
                    }

                /**
                 * Returns an enum member corresponding to this class instance's value.
                 *
                 * Use the [value] method instead if you're uncertain the value is always known and
                 * don't want to throw for the unknown case.
                 *
                 * @throws IncreaseInvalidDataException if this class instance's value is a not a
                 *   known member.
                 */
                fun known(): Known =
                    when (this) {
                        CAD -> Known.CAD
                        CHF -> Known.CHF
                        EUR -> Known.EUR
                        GBP -> Known.GBP
                        JPY -> Known.JPY
                        USD -> Known.USD
                        else -> throw IncreaseInvalidDataException("Unknown Currency: $value")
                    }

                /**
                 * Returns this class instance's primitive wire representation.
                 *
                 * This differs from the [toString] method because that method is primarily for
                 * debugging and generally doesn't throw.
                 *
                 * @throws IncreaseInvalidDataException if this class instance's value does not have
                 *   the expected primitive type.
                 */
                fun asString(): String =
                    _value().asString().orElseThrow {
                        IncreaseInvalidDataException("Value is not a String")
                    }

                private var validated: Boolean = false

                fun validate(): Currency = apply {
                    if (validated) {
                        return@apply
                    }

                    known()
                    validated = true
                }

                fun isValid(): Boolean =
                    try {
                        validate()
                        true
                    } catch (e: IncreaseInvalidDataException) {
                        false
                    }

                /**
                 * Returns a score indicating how many valid values are contained in this object
                 * recursively.
                 *
                 * Used for best match union deserialization.
                 */
                @JvmSynthetic internal fun validity(): Int = if (value() == Value._UNKNOWN) 0 else 1

                override fun equals(other: Any?): Boolean {
                    if (this === other) {
                        return true
                    }

                    return /* spotless:off */ other is Currency && value == other.value /* spotless:on */
                }

                override fun hashCode() = value.hashCode()

                override fun toString() = value.toString()
            }

            /** Interchange assessed as a part of this transaciton. */
            class Interchange
            private constructor(
                private val amount: JsonField<String>,
                private val code: JsonField<String>,
                private val currency: JsonField<Currency>,
                private val additionalProperties: MutableMap<String, JsonValue>,
            ) {

                @JsonCreator
                private constructor(
                    @JsonProperty("amount")
                    @ExcludeMissing
                    amount: JsonField<String> = JsonMissing.of(),
                    @JsonProperty("code")
                    @ExcludeMissing
                    code: JsonField<String> = JsonMissing.of(),
                    @JsonProperty("currency")
                    @ExcludeMissing
                    currency: JsonField<Currency> = JsonMissing.of(),
                ) : this(amount, code, currency, mutableMapOf())

                /**
                 * The interchange amount given as a string containing a decimal number in major
                 * units (so e.g., "3.14" for $3.14). The amount is a positive number if it is
                 * credited to Increase (e.g., settlements) and a negative number if it is debited
                 * (e.g., refunds).
                 *
                 * @throws IncreaseInvalidDataException if the JSON field has an unexpected type or
                 *   is unexpectedly missing or null (e.g. if the server responded with an
                 *   unexpected value).
                 */
                fun amount(): String = amount.getRequired("amount")

                /**
                 * The card network specific interchange code.
                 *
                 * @throws IncreaseInvalidDataException if the JSON field has an unexpected type
                 *   (e.g. if the server responded with an unexpected value).
                 */
                fun code(): Optional<String> = code.getOptional("code")

                /**
                 * The [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) code for the interchange
                 * reimbursement.
                 *
                 * @throws IncreaseInvalidDataException if the JSON field has an unexpected type or
                 *   is unexpectedly missing or null (e.g. if the server responded with an
                 *   unexpected value).
                 */
                fun currency(): Currency = currency.getRequired("currency")

                /**
                 * Returns the raw JSON value of [amount].
                 *
                 * Unlike [amount], this method doesn't throw if the JSON field has an unexpected
                 * type.
                 */
                @JsonProperty("amount") @ExcludeMissing fun _amount(): JsonField<String> = amount

                /**
                 * Returns the raw JSON value of [code].
                 *
                 * Unlike [code], this method doesn't throw if the JSON field has an unexpected
                 * type.
                 */
                @JsonProperty("code") @ExcludeMissing fun _code(): JsonField<String> = code

                /**
                 * Returns the raw JSON value of [currency].
                 *
                 * Unlike [currency], this method doesn't throw if the JSON field has an unexpected
                 * type.
                 */
                @JsonProperty("currency")
                @ExcludeMissing
                fun _currency(): JsonField<Currency> = currency

                @JsonAnySetter
                private fun putAdditionalProperty(key: String, value: JsonValue) {
                    additionalProperties.put(key, value)
                }

                @JsonAnyGetter
                @ExcludeMissing
                fun _additionalProperties(): Map<String, JsonValue> =
                    Collections.unmodifiableMap(additionalProperties)

                fun toBuilder() = Builder().from(this)

                companion object {

                    /**
                     * Returns a mutable builder for constructing an instance of [Interchange].
                     *
                     * The following fields are required:
                     * ```java
                     * .amount()
                     * .code()
                     * .currency()
                     * ```
                     */
                    @JvmStatic fun builder() = Builder()
                }

                /** A builder for [Interchange]. */
                class Builder internal constructor() {

                    private var amount: JsonField<String>? = null
                    private var code: JsonField<String>? = null
                    private var currency: JsonField<Currency>? = null
                    private var additionalProperties: MutableMap<String, JsonValue> = mutableMapOf()

                    @JvmSynthetic
                    internal fun from(interchange: Interchange) = apply {
                        amount = interchange.amount
                        code = interchange.code
                        currency = interchange.currency
                        additionalProperties = interchange.additionalProperties.toMutableMap()
                    }

                    /**
                     * The interchange amount given as a string containing a decimal number in major
                     * units (so e.g., "3.14" for $3.14). The amount is a positive number if it is
                     * credited to Increase (e.g., settlements) and a negative number if it is
                     * debited (e.g., refunds).
                     */
                    fun amount(amount: String) = amount(JsonField.of(amount))

                    /**
                     * Sets [Builder.amount] to an arbitrary JSON value.
                     *
                     * You should usually call [Builder.amount] with a well-typed [String] value
                     * instead. This method is primarily for setting the field to an undocumented or
                     * not yet supported value.
                     */
                    fun amount(amount: JsonField<String>) = apply { this.amount = amount }

                    /** The card network specific interchange code. */
                    fun code(code: String?) = code(JsonField.ofNullable(code))

                    /** Alias for calling [Builder.code] with `code.orElse(null)`. */
                    fun code(code: Optional<String>) = code(code.getOrNull())

                    /**
                     * Sets [Builder.code] to an arbitrary JSON value.
                     *
                     * You should usually call [Builder.code] with a well-typed [String] value
                     * instead. This method is primarily for setting the field to an undocumented or
                     * not yet supported value.
                     */
                    fun code(code: JsonField<String>) = apply { this.code = code }

                    /**
                     * The [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) code for the
                     * interchange reimbursement.
                     */
                    fun currency(currency: Currency) = currency(JsonField.of(currency))

                    /**
                     * Sets [Builder.currency] to an arbitrary JSON value.
                     *
                     * You should usually call [Builder.currency] with a well-typed [Currency] value
                     * instead. This method is primarily for setting the field to an undocumented or
                     * not yet supported value.
                     */
                    fun currency(currency: JsonField<Currency>) = apply { this.currency = currency }

                    fun additionalProperties(additionalProperties: Map<String, JsonValue>) = apply {
                        this.additionalProperties.clear()
                        putAllAdditionalProperties(additionalProperties)
                    }

                    fun putAdditionalProperty(key: String, value: JsonValue) = apply {
                        additionalProperties.put(key, value)
                    }

                    fun putAllAdditionalProperties(additionalProperties: Map<String, JsonValue>) =
                        apply {
                            this.additionalProperties.putAll(additionalProperties)
                        }

                    fun removeAdditionalProperty(key: String) = apply {
                        additionalProperties.remove(key)
                    }

                    fun removeAllAdditionalProperties(keys: Set<String>) = apply {
                        keys.forEach(::removeAdditionalProperty)
                    }

                    /**
                     * Returns an immutable instance of [Interchange].
                     *
                     * Further updates to this [Builder] will not mutate the returned instance.
                     *
                     * The following fields are required:
                     * ```java
                     * .amount()
                     * .code()
                     * .currency()
                     * ```
                     *
                     * @throws IllegalStateException if any required field is unset.
                     */
                    fun build(): Interchange =
                        Interchange(
                            checkRequired("amount", amount),
                            checkRequired("code", code),
                            checkRequired("currency", currency),
                            additionalProperties.toMutableMap(),
                        )
                }

                private var validated: Boolean = false

                fun validate(): Interchange = apply {
                    if (validated) {
                        return@apply
                    }

                    amount()
                    code()
                    currency().validate()
                    validated = true
                }

                fun isValid(): Boolean =
                    try {
                        validate()
                        true
                    } catch (e: IncreaseInvalidDataException) {
                        false
                    }

                /**
                 * Returns a score indicating how many valid values are contained in this object
                 * recursively.
                 *
                 * Used for best match union deserialization.
                 */
                @JvmSynthetic
                internal fun validity(): Int =
                    (if (amount.asKnown().isPresent) 1 else 0) +
                        (if (code.asKnown().isPresent) 1 else 0) +
                        (currency.asKnown().getOrNull()?.validity() ?: 0)

                /**
                 * The [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) code for the interchange
                 * reimbursement.
                 */
                class Currency
                @JsonCreator
                private constructor(private val value: JsonField<String>) : Enum {

                    /**
                     * Returns this class instance's raw value.
                     *
                     * This is usually only useful if this instance was deserialized from data that
                     * doesn't match any known member, and you want to know that value. For example,
                     * if the SDK is on an older version than the API, then the API may respond with
                     * new members that the SDK is unaware of.
                     */
                    @com.fasterxml.jackson.annotation.JsonValue
                    fun _value(): JsonField<String> = value

                    companion object {

                        /** Canadian Dollar (CAD) */
                        @JvmField val CAD = of("CAD")

                        /** Swiss Franc (CHF) */
                        @JvmField val CHF = of("CHF")

                        /** Euro (EUR) */
                        @JvmField val EUR = of("EUR")

                        /** British Pound (GBP) */
                        @JvmField val GBP = of("GBP")

                        /** Japanese Yen (JPY) */
                        @JvmField val JPY = of("JPY")

                        /** US Dollar (USD) */
                        @JvmField val USD = of("USD")

                        @JvmStatic fun of(value: String) = Currency(JsonField.of(value))
                    }

                    /** An enum containing [Currency]'s known values. */
                    enum class Known {
                        /** Canadian Dollar (CAD) */
                        CAD,
                        /** Swiss Franc (CHF) */
                        CHF,
                        /** Euro (EUR) */
                        EUR,
                        /** British Pound (GBP) */
                        GBP,
                        /** Japanese Yen (JPY) */
                        JPY,
                        /** US Dollar (USD) */
                        USD,
                    }

                    /**
                     * An enum containing [Currency]'s known values, as well as an [_UNKNOWN]
                     * member.
                     *
                     * An instance of [Currency] can contain an unknown value in a couple of cases:
                     * - It was deserialized from data that doesn't match any known member. For
                     *   example, if the SDK is on an older version than the API, then the API may
                     *   respond with new members that the SDK is unaware of.
                     * - It was constructed with an arbitrary value using the [of] method.
                     */
                    enum class Value {
                        /** Canadian Dollar (CAD) */
                        CAD,
                        /** Swiss Franc (CHF) */
                        CHF,
                        /** Euro (EUR) */
                        EUR,
                        /** British Pound (GBP) */
                        GBP,
                        /** Japanese Yen (JPY) */
                        JPY,
                        /** US Dollar (USD) */
                        USD,
                        /**
                         * An enum member indicating that [Currency] was instantiated with an
                         * unknown value.
                         */
                        _UNKNOWN,
                    }

                    /**
                     * Returns an enum member corresponding to this class instance's value, or
                     * [Value._UNKNOWN] if the class was instantiated with an unknown value.
                     *
                     * Use the [known] method instead if you're certain the value is always known or
                     * if you want to throw for the unknown case.
                     */
                    fun value(): Value =
                        when (this) {
                            CAD -> Value.CAD
                            CHF -> Value.CHF
                            EUR -> Value.EUR
                            GBP -> Value.GBP
                            JPY -> Value.JPY
                            USD -> Value.USD
                            else -> Value._UNKNOWN
                        }

                    /**
                     * Returns an enum member corresponding to this class instance's value.
                     *
                     * Use the [value] method instead if you're uncertain the value is always known
                     * and don't want to throw for the unknown case.
                     *
                     * @throws IncreaseInvalidDataException if this class instance's value is a not
                     *   a known member.
                     */
                    fun known(): Known =
                        when (this) {
                            CAD -> Known.CAD
                            CHF -> Known.CHF
                            EUR -> Known.EUR
                            GBP -> Known.GBP
                            JPY -> Known.JPY
                            USD -> Known.USD
                            else -> throw IncreaseInvalidDataException("Unknown Currency: $value")
                        }

                    /**
                     * Returns this class instance's primitive wire representation.
                     *
                     * This differs from the [toString] method because that method is primarily for
                     * debugging and generally doesn't throw.
                     *
                     * @throws IncreaseInvalidDataException if this class instance's value does not
                     *   have the expected primitive type.
                     */
                    fun asString(): String =
                        _value().asString().orElseThrow {
                            IncreaseInvalidDataException("Value is not a String")
                        }

                    private var validated: Boolean = false

                    fun validate(): Currency = apply {
                        if (validated) {
                            return@apply
                        }

                        known()
                        validated = true
                    }

                    fun isValid(): Boolean =
                        try {
                            validate()
                            true
                        } catch (e: IncreaseInvalidDataException) {
                            false
                        }

                    /**
                     * Returns a score indicating how many valid values are contained in this object
                     * recursively.
                     *
                     * Used for best match union deserialization.
                     */
                    @JvmSynthetic
                    internal fun validity(): Int = if (value() == Value._UNKNOWN) 0 else 1

                    override fun equals(other: Any?): Boolean {
                        if (this === other) {
                            return true
                        }

                        return /* spotless:off */ other is Currency && value == other.value /* spotless:on */
                    }

                    override fun hashCode() = value.hashCode()

                    override fun toString() = value.toString()
                }

                override fun equals(other: Any?): Boolean {
                    if (this === other) {
                        return true
                    }

                    return /* spotless:off */ other is Interchange && amount == other.amount && code == other.code && currency == other.currency && additionalProperties == other.additionalProperties /* spotless:on */
                }

                /* spotless:off */
                private val hashCode: Int by lazy { Objects.hash(amount, code, currency, additionalProperties) }
                /* spotless:on */

                override fun hashCode(): Int = hashCode

                override fun toString() =
                    "Interchange{amount=$amount, code=$code, currency=$currency, additionalProperties=$additionalProperties}"
            }

            /** Network-specific identifiers for this refund. */
            class NetworkIdentifiers
            private constructor(
                private val acquirerBusinessId: JsonField<String>,
                private val acquirerReferenceNumber: JsonField<String>,
                private val transactionId: JsonField<String>,
                private val additionalProperties: MutableMap<String, JsonValue>,
            ) {

                @JsonCreator
                private constructor(
                    @JsonProperty("acquirer_business_id")
                    @ExcludeMissing
                    acquirerBusinessId: JsonField<String> = JsonMissing.of(),
                    @JsonProperty("acquirer_reference_number")
                    @ExcludeMissing
                    acquirerReferenceNumber: JsonField<String> = JsonMissing.of(),
                    @JsonProperty("transaction_id")
                    @ExcludeMissing
                    transactionId: JsonField<String> = JsonMissing.of(),
                ) : this(acquirerBusinessId, acquirerReferenceNumber, transactionId, mutableMapOf())

                /**
                 * A network assigned business ID that identifies the acquirer that processed this
                 * transaction.
                 *
                 * @throws IncreaseInvalidDataException if the JSON field has an unexpected type or
                 *   is unexpectedly missing or null (e.g. if the server responded with an
                 *   unexpected value).
                 */
                fun acquirerBusinessId(): String =
                    acquirerBusinessId.getRequired("acquirer_business_id")

                /**
                 * A globally unique identifier for this settlement.
                 *
                 * @throws IncreaseInvalidDataException if the JSON field has an unexpected type or
                 *   is unexpectedly missing or null (e.g. if the server responded with an
                 *   unexpected value).
                 */
                fun acquirerReferenceNumber(): String =
                    acquirerReferenceNumber.getRequired("acquirer_reference_number")

                /**
                 * A globally unique transaction identifier provided by the card network, used
                 * across multiple life-cycle requests.
                 *
                 * @throws IncreaseInvalidDataException if the JSON field has an unexpected type
                 *   (e.g. if the server responded with an unexpected value).
                 */
                fun transactionId(): Optional<String> = transactionId.getOptional("transaction_id")

                /**
                 * Returns the raw JSON value of [acquirerBusinessId].
                 *
                 * Unlike [acquirerBusinessId], this method doesn't throw if the JSON field has an
                 * unexpected type.
                 */
                @JsonProperty("acquirer_business_id")
                @ExcludeMissing
                fun _acquirerBusinessId(): JsonField<String> = acquirerBusinessId

                /**
                 * Returns the raw JSON value of [acquirerReferenceNumber].
                 *
                 * Unlike [acquirerReferenceNumber], this method doesn't throw if the JSON field has
                 * an unexpected type.
                 */
                @JsonProperty("acquirer_reference_number")
                @ExcludeMissing
                fun _acquirerReferenceNumber(): JsonField<String> = acquirerReferenceNumber

                /**
                 * Returns the raw JSON value of [transactionId].
                 *
                 * Unlike [transactionId], this method doesn't throw if the JSON field has an
                 * unexpected type.
                 */
                @JsonProperty("transaction_id")
                @ExcludeMissing
                fun _transactionId(): JsonField<String> = transactionId

                @JsonAnySetter
                private fun putAdditionalProperty(key: String, value: JsonValue) {
                    additionalProperties.put(key, value)
                }

                @JsonAnyGetter
                @ExcludeMissing
                fun _additionalProperties(): Map<String, JsonValue> =
                    Collections.unmodifiableMap(additionalProperties)

                fun toBuilder() = Builder().from(this)

                companion object {

                    /**
                     * Returns a mutable builder for constructing an instance of
                     * [NetworkIdentifiers].
                     *
                     * The following fields are required:
                     * ```java
                     * .acquirerBusinessId()
                     * .acquirerReferenceNumber()
                     * .transactionId()
                     * ```
                     */
                    @JvmStatic fun builder() = Builder()
                }

                /** A builder for [NetworkIdentifiers]. */
                class Builder internal constructor() {

                    private var acquirerBusinessId: JsonField<String>? = null
                    private var acquirerReferenceNumber: JsonField<String>? = null
                    private var transactionId: JsonField<String>? = null
                    private var additionalProperties: MutableMap<String, JsonValue> = mutableMapOf()

                    @JvmSynthetic
                    internal fun from(networkIdentifiers: NetworkIdentifiers) = apply {
                        acquirerBusinessId = networkIdentifiers.acquirerBusinessId
                        acquirerReferenceNumber = networkIdentifiers.acquirerReferenceNumber
                        transactionId = networkIdentifiers.transactionId
                        additionalProperties =
                            networkIdentifiers.additionalProperties.toMutableMap()
                    }

                    /**
                     * A network assigned business ID that identifies the acquirer that processed
                     * this transaction.
                     */
                    fun acquirerBusinessId(acquirerBusinessId: String) =
                        acquirerBusinessId(JsonField.of(acquirerBusinessId))

                    /**
                     * Sets [Builder.acquirerBusinessId] to an arbitrary JSON value.
                     *
                     * You should usually call [Builder.acquirerBusinessId] with a well-typed
                     * [String] value instead. This method is primarily for setting the field to an
                     * undocumented or not yet supported value.
                     */
                    fun acquirerBusinessId(acquirerBusinessId: JsonField<String>) = apply {
                        this.acquirerBusinessId = acquirerBusinessId
                    }

                    /** A globally unique identifier for this settlement. */
                    fun acquirerReferenceNumber(acquirerReferenceNumber: String) =
                        acquirerReferenceNumber(JsonField.of(acquirerReferenceNumber))

                    /**
                     * Sets [Builder.acquirerReferenceNumber] to an arbitrary JSON value.
                     *
                     * You should usually call [Builder.acquirerReferenceNumber] with a well-typed
                     * [String] value instead. This method is primarily for setting the field to an
                     * undocumented or not yet supported value.
                     */
                    fun acquirerReferenceNumber(acquirerReferenceNumber: JsonField<String>) =
                        apply {
                            this.acquirerReferenceNumber = acquirerReferenceNumber
                        }

                    /**
                     * A globally unique transaction identifier provided by the card network, used
                     * across multiple life-cycle requests.
                     */
                    fun transactionId(transactionId: String?) =
                        transactionId(JsonField.ofNullable(transactionId))

                    /**
                     * Alias for calling [Builder.transactionId] with `transactionId.orElse(null)`.
                     */
                    fun transactionId(transactionId: Optional<String>) =
                        transactionId(transactionId.getOrNull())

                    /**
                     * Sets [Builder.transactionId] to an arbitrary JSON value.
                     *
                     * You should usually call [Builder.transactionId] with a well-typed [String]
                     * value instead. This method is primarily for setting the field to an
                     * undocumented or not yet supported value.
                     */
                    fun transactionId(transactionId: JsonField<String>) = apply {
                        this.transactionId = transactionId
                    }

                    fun additionalProperties(additionalProperties: Map<String, JsonValue>) = apply {
                        this.additionalProperties.clear()
                        putAllAdditionalProperties(additionalProperties)
                    }

                    fun putAdditionalProperty(key: String, value: JsonValue) = apply {
                        additionalProperties.put(key, value)
                    }

                    fun putAllAdditionalProperties(additionalProperties: Map<String, JsonValue>) =
                        apply {
                            this.additionalProperties.putAll(additionalProperties)
                        }

                    fun removeAdditionalProperty(key: String) = apply {
                        additionalProperties.remove(key)
                    }

                    fun removeAllAdditionalProperties(keys: Set<String>) = apply {
                        keys.forEach(::removeAdditionalProperty)
                    }

                    /**
                     * Returns an immutable instance of [NetworkIdentifiers].
                     *
                     * Further updates to this [Builder] will not mutate the returned instance.
                     *
                     * The following fields are required:
                     * ```java
                     * .acquirerBusinessId()
                     * .acquirerReferenceNumber()
                     * .transactionId()
                     * ```
                     *
                     * @throws IllegalStateException if any required field is unset.
                     */
                    fun build(): NetworkIdentifiers =
                        NetworkIdentifiers(
                            checkRequired("acquirerBusinessId", acquirerBusinessId),
                            checkRequired("acquirerReferenceNumber", acquirerReferenceNumber),
                            checkRequired("transactionId", transactionId),
                            additionalProperties.toMutableMap(),
                        )
                }

                private var validated: Boolean = false

                fun validate(): NetworkIdentifiers = apply {
                    if (validated) {
                        return@apply
                    }

                    acquirerBusinessId()
                    acquirerReferenceNumber()
                    transactionId()
                    validated = true
                }

                fun isValid(): Boolean =
                    try {
                        validate()
                        true
                    } catch (e: IncreaseInvalidDataException) {
                        false
                    }

                /**
                 * Returns a score indicating how many valid values are contained in this object
                 * recursively.
                 *
                 * Used for best match union deserialization.
                 */
                @JvmSynthetic
                internal fun validity(): Int =
                    (if (acquirerBusinessId.asKnown().isPresent) 1 else 0) +
                        (if (acquirerReferenceNumber.asKnown().isPresent) 1 else 0) +
                        (if (transactionId.asKnown().isPresent) 1 else 0)

                override fun equals(other: Any?): Boolean {
                    if (this === other) {
                        return true
                    }

                    return /* spotless:off */ other is NetworkIdentifiers && acquirerBusinessId == other.acquirerBusinessId && acquirerReferenceNumber == other.acquirerReferenceNumber && transactionId == other.transactionId && additionalProperties == other.additionalProperties /* spotless:on */
                }

                /* spotless:off */
                private val hashCode: Int by lazy { Objects.hash(acquirerBusinessId, acquirerReferenceNumber, transactionId, additionalProperties) }
                /* spotless:on */

                override fun hashCode(): Int = hashCode

                override fun toString() =
                    "NetworkIdentifiers{acquirerBusinessId=$acquirerBusinessId, acquirerReferenceNumber=$acquirerReferenceNumber, transactionId=$transactionId, additionalProperties=$additionalProperties}"
            }

            /**
             * Additional details about the card purchase, such as tax and industry-specific fields.
             */
            class PurchaseDetails
            private constructor(
                private val carRental: JsonField<CarRental>,
                private val customerReferenceIdentifier: JsonField<String>,
                private val localTaxAmount: JsonField<Long>,
                private val localTaxCurrency: JsonField<String>,
                private val lodging: JsonField<Lodging>,
                private val nationalTaxAmount: JsonField<Long>,
                private val nationalTaxCurrency: JsonField<String>,
                private val purchaseIdentifier: JsonField<String>,
                private val purchaseIdentifierFormat: JsonField<PurchaseIdentifierFormat>,
                private val travel: JsonField<Travel>,
                private val additionalProperties: MutableMap<String, JsonValue>,
            ) {

                @JsonCreator
                private constructor(
                    @JsonProperty("car_rental")
                    @ExcludeMissing
                    carRental: JsonField<CarRental> = JsonMissing.of(),
                    @JsonProperty("customer_reference_identifier")
                    @ExcludeMissing
                    customerReferenceIdentifier: JsonField<String> = JsonMissing.of(),
                    @JsonProperty("local_tax_amount")
                    @ExcludeMissing
                    localTaxAmount: JsonField<Long> = JsonMissing.of(),
                    @JsonProperty("local_tax_currency")
                    @ExcludeMissing
                    localTaxCurrency: JsonField<String> = JsonMissing.of(),
                    @JsonProperty("lodging")
                    @ExcludeMissing
                    lodging: JsonField<Lodging> = JsonMissing.of(),
                    @JsonProperty("national_tax_amount")
                    @ExcludeMissing
                    nationalTaxAmount: JsonField<Long> = JsonMissing.of(),
                    @JsonProperty("national_tax_currency")
                    @ExcludeMissing
                    nationalTaxCurrency: JsonField<String> = JsonMissing.of(),
                    @JsonProperty("purchase_identifier")
                    @ExcludeMissing
                    purchaseIdentifier: JsonField<String> = JsonMissing.of(),
                    @JsonProperty("purchase_identifier_format")
                    @ExcludeMissing
                    purchaseIdentifierFormat: JsonField<PurchaseIdentifierFormat> =
                        JsonMissing.of(),
                    @JsonProperty("travel")
                    @ExcludeMissing
                    travel: JsonField<Travel> = JsonMissing.of(),
                ) : this(
                    carRental,
                    customerReferenceIdentifier,
                    localTaxAmount,
                    localTaxCurrency,
                    lodging,
                    nationalTaxAmount,
                    nationalTaxCurrency,
                    purchaseIdentifier,
                    purchaseIdentifierFormat,
                    travel,
                    mutableMapOf(),
                )

                /**
                 * Fields specific to car rentals.
                 *
                 * @throws IncreaseInvalidDataException if the JSON field has an unexpected type
                 *   (e.g. if the server responded with an unexpected value).
                 */
                fun carRental(): Optional<CarRental> = carRental.getOptional("car_rental")

                /**
                 * An identifier from the merchant for the customer or consumer.
                 *
                 * @throws IncreaseInvalidDataException if the JSON field has an unexpected type
                 *   (e.g. if the server responded with an unexpected value).
                 */
                fun customerReferenceIdentifier(): Optional<String> =
                    customerReferenceIdentifier.getOptional("customer_reference_identifier")

                /**
                 * The state or provincial tax amount in minor units.
                 *
                 * @throws IncreaseInvalidDataException if the JSON field has an unexpected type
                 *   (e.g. if the server responded with an unexpected value).
                 */
                fun localTaxAmount(): Optional<Long> =
                    localTaxAmount.getOptional("local_tax_amount")

                /**
                 * The [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) code for the local tax
                 * assessed.
                 *
                 * @throws IncreaseInvalidDataException if the JSON field has an unexpected type
                 *   (e.g. if the server responded with an unexpected value).
                 */
                fun localTaxCurrency(): Optional<String> =
                    localTaxCurrency.getOptional("local_tax_currency")

                /**
                 * Fields specific to lodging.
                 *
                 * @throws IncreaseInvalidDataException if the JSON field has an unexpected type
                 *   (e.g. if the server responded with an unexpected value).
                 */
                fun lodging(): Optional<Lodging> = lodging.getOptional("lodging")

                /**
                 * The national tax amount in minor units.
                 *
                 * @throws IncreaseInvalidDataException if the JSON field has an unexpected type
                 *   (e.g. if the server responded with an unexpected value).
                 */
                fun nationalTaxAmount(): Optional<Long> =
                    nationalTaxAmount.getOptional("national_tax_amount")

                /**
                 * The [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) code for the local tax
                 * assessed.
                 *
                 * @throws IncreaseInvalidDataException if the JSON field has an unexpected type
                 *   (e.g. if the server responded with an unexpected value).
                 */
                fun nationalTaxCurrency(): Optional<String> =
                    nationalTaxCurrency.getOptional("national_tax_currency")

                /**
                 * An identifier from the merchant for the purchase to the issuer and cardholder.
                 *
                 * @throws IncreaseInvalidDataException if the JSON field has an unexpected type
                 *   (e.g. if the server responded with an unexpected value).
                 */
                fun purchaseIdentifier(): Optional<String> =
                    purchaseIdentifier.getOptional("purchase_identifier")

                /**
                 * The format of the purchase identifier.
                 *
                 * @throws IncreaseInvalidDataException if the JSON field has an unexpected type
                 *   (e.g. if the server responded with an unexpected value).
                 */
                fun purchaseIdentifierFormat(): Optional<PurchaseIdentifierFormat> =
                    purchaseIdentifierFormat.getOptional("purchase_identifier_format")

                /**
                 * Fields specific to travel.
                 *
                 * @throws IncreaseInvalidDataException if the JSON field has an unexpected type
                 *   (e.g. if the server responded with an unexpected value).
                 */
                fun travel(): Optional<Travel> = travel.getOptional("travel")

                /**
                 * Returns the raw JSON value of [carRental].
                 *
                 * Unlike [carRental], this method doesn't throw if the JSON field has an unexpected
                 * type.
                 */
                @JsonProperty("car_rental")
                @ExcludeMissing
                fun _carRental(): JsonField<CarRental> = carRental

                /**
                 * Returns the raw JSON value of [customerReferenceIdentifier].
                 *
                 * Unlike [customerReferenceIdentifier], this method doesn't throw if the JSON field
                 * has an unexpected type.
                 */
                @JsonProperty("customer_reference_identifier")
                @ExcludeMissing
                fun _customerReferenceIdentifier(): JsonField<String> = customerReferenceIdentifier

                /**
                 * Returns the raw JSON value of [localTaxAmount].
                 *
                 * Unlike [localTaxAmount], this method doesn't throw if the JSON field has an
                 * unexpected type.
                 */
                @JsonProperty("local_tax_amount")
                @ExcludeMissing
                fun _localTaxAmount(): JsonField<Long> = localTaxAmount

                /**
                 * Returns the raw JSON value of [localTaxCurrency].
                 *
                 * Unlike [localTaxCurrency], this method doesn't throw if the JSON field has an
                 * unexpected type.
                 */
                @JsonProperty("local_tax_currency")
                @ExcludeMissing
                fun _localTaxCurrency(): JsonField<String> = localTaxCurrency

                /**
                 * Returns the raw JSON value of [lodging].
                 *
                 * Unlike [lodging], this method doesn't throw if the JSON field has an unexpected
                 * type.
                 */
                @JsonProperty("lodging")
                @ExcludeMissing
                fun _lodging(): JsonField<Lodging> = lodging

                /**
                 * Returns the raw JSON value of [nationalTaxAmount].
                 *
                 * Unlike [nationalTaxAmount], this method doesn't throw if the JSON field has an
                 * unexpected type.
                 */
                @JsonProperty("national_tax_amount")
                @ExcludeMissing
                fun _nationalTaxAmount(): JsonField<Long> = nationalTaxAmount

                /**
                 * Returns the raw JSON value of [nationalTaxCurrency].
                 *
                 * Unlike [nationalTaxCurrency], this method doesn't throw if the JSON field has an
                 * unexpected type.
                 */
                @JsonProperty("national_tax_currency")
                @ExcludeMissing
                fun _nationalTaxCurrency(): JsonField<String> = nationalTaxCurrency

                /**
                 * Returns the raw JSON value of [purchaseIdentifier].
                 *
                 * Unlike [purchaseIdentifier], this method doesn't throw if the JSON field has an
                 * unexpected type.
                 */
                @JsonProperty("purchase_identifier")
                @ExcludeMissing
                fun _purchaseIdentifier(): JsonField<String> = purchaseIdentifier

                /**
                 * Returns the raw JSON value of [purchaseIdentifierFormat].
                 *
                 * Unlike [purchaseIdentifierFormat], this method doesn't throw if the JSON field
                 * has an unexpected type.
                 */
                @JsonProperty("purchase_identifier_format")
                @ExcludeMissing
                fun _purchaseIdentifierFormat(): JsonField<PurchaseIdentifierFormat> =
                    purchaseIdentifierFormat

                /**
                 * Returns the raw JSON value of [travel].
                 *
                 * Unlike [travel], this method doesn't throw if the JSON field has an unexpected
                 * type.
                 */
                @JsonProperty("travel") @ExcludeMissing fun _travel(): JsonField<Travel> = travel

                @JsonAnySetter
                private fun putAdditionalProperty(key: String, value: JsonValue) {
                    additionalProperties.put(key, value)
                }

                @JsonAnyGetter
                @ExcludeMissing
                fun _additionalProperties(): Map<String, JsonValue> =
                    Collections.unmodifiableMap(additionalProperties)

                fun toBuilder() = Builder().from(this)

                companion object {

                    /**
                     * Returns a mutable builder for constructing an instance of [PurchaseDetails].
                     *
                     * The following fields are required:
                     * ```java
                     * .carRental()
                     * .customerReferenceIdentifier()
                     * .localTaxAmount()
                     * .localTaxCurrency()
                     * .lodging()
                     * .nationalTaxAmount()
                     * .nationalTaxCurrency()
                     * .purchaseIdentifier()
                     * .purchaseIdentifierFormat()
                     * .travel()
                     * ```
                     */
                    @JvmStatic fun builder() = Builder()
                }

                /** A builder for [PurchaseDetails]. */
                class Builder internal constructor() {

                    private var carRental: JsonField<CarRental>? = null
                    private var customerReferenceIdentifier: JsonField<String>? = null
                    private var localTaxAmount: JsonField<Long>? = null
                    private var localTaxCurrency: JsonField<String>? = null
                    private var lodging: JsonField<Lodging>? = null
                    private var nationalTaxAmount: JsonField<Long>? = null
                    private var nationalTaxCurrency: JsonField<String>? = null
                    private var purchaseIdentifier: JsonField<String>? = null
                    private var purchaseIdentifierFormat: JsonField<PurchaseIdentifierFormat>? =
                        null
                    private var travel: JsonField<Travel>? = null
                    private var additionalProperties: MutableMap<String, JsonValue> = mutableMapOf()

                    @JvmSynthetic
                    internal fun from(purchaseDetails: PurchaseDetails) = apply {
                        carRental = purchaseDetails.carRental
                        customerReferenceIdentifier = purchaseDetails.customerReferenceIdentifier
                        localTaxAmount = purchaseDetails.localTaxAmount
                        localTaxCurrency = purchaseDetails.localTaxCurrency
                        lodging = purchaseDetails.lodging
                        nationalTaxAmount = purchaseDetails.nationalTaxAmount
                        nationalTaxCurrency = purchaseDetails.nationalTaxCurrency
                        purchaseIdentifier = purchaseDetails.purchaseIdentifier
                        purchaseIdentifierFormat = purchaseDetails.purchaseIdentifierFormat
                        travel = purchaseDetails.travel
                        additionalProperties = purchaseDetails.additionalProperties.toMutableMap()
                    }

                    /** Fields specific to car rentals. */
                    fun carRental(carRental: CarRental?) =
                        carRental(JsonField.ofNullable(carRental))

                    /** Alias for calling [Builder.carRental] with `carRental.orElse(null)`. */
                    fun carRental(carRental: Optional<CarRental>) = carRental(carRental.getOrNull())

                    /**
                     * Sets [Builder.carRental] to an arbitrary JSON value.
                     *
                     * You should usually call [Builder.carRental] with a well-typed [CarRental]
                     * value instead. This method is primarily for setting the field to an
                     * undocumented or not yet supported value.
                     */
                    fun carRental(carRental: JsonField<CarRental>) = apply {
                        this.carRental = carRental
                    }

                    /** An identifier from the merchant for the customer or consumer. */
                    fun customerReferenceIdentifier(customerReferenceIdentifier: String?) =
                        customerReferenceIdentifier(
                            JsonField.ofNullable(customerReferenceIdentifier)
                        )

                    /**
                     * Alias for calling [Builder.customerReferenceIdentifier] with
                     * `customerReferenceIdentifier.orElse(null)`.
                     */
                    fun customerReferenceIdentifier(customerReferenceIdentifier: Optional<String>) =
                        customerReferenceIdentifier(customerReferenceIdentifier.getOrNull())

                    /**
                     * Sets [Builder.customerReferenceIdentifier] to an arbitrary JSON value.
                     *
                     * You should usually call [Builder.customerReferenceIdentifier] with a
                     * well-typed [String] value instead. This method is primarily for setting the
                     * field to an undocumented or not yet supported value.
                     */
                    fun customerReferenceIdentifier(
                        customerReferenceIdentifier: JsonField<String>
                    ) = apply { this.customerReferenceIdentifier = customerReferenceIdentifier }

                    /** The state or provincial tax amount in minor units. */
                    fun localTaxAmount(localTaxAmount: Long?) =
                        localTaxAmount(JsonField.ofNullable(localTaxAmount))

                    /**
                     * Alias for [Builder.localTaxAmount].
                     *
                     * This unboxed primitive overload exists for backwards compatibility.
                     */
                    fun localTaxAmount(localTaxAmount: Long) =
                        localTaxAmount(localTaxAmount as Long?)

                    /**
                     * Alias for calling [Builder.localTaxAmount] with
                     * `localTaxAmount.orElse(null)`.
                     */
                    fun localTaxAmount(localTaxAmount: Optional<Long>) =
                        localTaxAmount(localTaxAmount.getOrNull())

                    /**
                     * Sets [Builder.localTaxAmount] to an arbitrary JSON value.
                     *
                     * You should usually call [Builder.localTaxAmount] with a well-typed [Long]
                     * value instead. This method is primarily for setting the field to an
                     * undocumented or not yet supported value.
                     */
                    fun localTaxAmount(localTaxAmount: JsonField<Long>) = apply {
                        this.localTaxAmount = localTaxAmount
                    }

                    /**
                     * The [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) code for the local tax
                     * assessed.
                     */
                    fun localTaxCurrency(localTaxCurrency: String?) =
                        localTaxCurrency(JsonField.ofNullable(localTaxCurrency))

                    /**
                     * Alias for calling [Builder.localTaxCurrency] with
                     * `localTaxCurrency.orElse(null)`.
                     */
                    fun localTaxCurrency(localTaxCurrency: Optional<String>) =
                        localTaxCurrency(localTaxCurrency.getOrNull())

                    /**
                     * Sets [Builder.localTaxCurrency] to an arbitrary JSON value.
                     *
                     * You should usually call [Builder.localTaxCurrency] with a well-typed [String]
                     * value instead. This method is primarily for setting the field to an
                     * undocumented or not yet supported value.
                     */
                    fun localTaxCurrency(localTaxCurrency: JsonField<String>) = apply {
                        this.localTaxCurrency = localTaxCurrency
                    }

                    /** Fields specific to lodging. */
                    fun lodging(lodging: Lodging?) = lodging(JsonField.ofNullable(lodging))

                    /** Alias for calling [Builder.lodging] with `lodging.orElse(null)`. */
                    fun lodging(lodging: Optional<Lodging>) = lodging(lodging.getOrNull())

                    /**
                     * Sets [Builder.lodging] to an arbitrary JSON value.
                     *
                     * You should usually call [Builder.lodging] with a well-typed [Lodging] value
                     * instead. This method is primarily for setting the field to an undocumented or
                     * not yet supported value.
                     */
                    fun lodging(lodging: JsonField<Lodging>) = apply { this.lodging = lodging }

                    /** The national tax amount in minor units. */
                    fun nationalTaxAmount(nationalTaxAmount: Long?) =
                        nationalTaxAmount(JsonField.ofNullable(nationalTaxAmount))

                    /**
                     * Alias for [Builder.nationalTaxAmount].
                     *
                     * This unboxed primitive overload exists for backwards compatibility.
                     */
                    fun nationalTaxAmount(nationalTaxAmount: Long) =
                        nationalTaxAmount(nationalTaxAmount as Long?)

                    /**
                     * Alias for calling [Builder.nationalTaxAmount] with
                     * `nationalTaxAmount.orElse(null)`.
                     */
                    fun nationalTaxAmount(nationalTaxAmount: Optional<Long>) =
                        nationalTaxAmount(nationalTaxAmount.getOrNull())

                    /**
                     * Sets [Builder.nationalTaxAmount] to an arbitrary JSON value.
                     *
                     * You should usually call [Builder.nationalTaxAmount] with a well-typed [Long]
                     * value instead. This method is primarily for setting the field to an
                     * undocumented or not yet supported value.
                     */
                    fun nationalTaxAmount(nationalTaxAmount: JsonField<Long>) = apply {
                        this.nationalTaxAmount = nationalTaxAmount
                    }

                    /**
                     * The [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) code for the local tax
                     * assessed.
                     */
                    fun nationalTaxCurrency(nationalTaxCurrency: String?) =
                        nationalTaxCurrency(JsonField.ofNullable(nationalTaxCurrency))

                    /**
                     * Alias for calling [Builder.nationalTaxCurrency] with
                     * `nationalTaxCurrency.orElse(null)`.
                     */
                    fun nationalTaxCurrency(nationalTaxCurrency: Optional<String>) =
                        nationalTaxCurrency(nationalTaxCurrency.getOrNull())

                    /**
                     * Sets [Builder.nationalTaxCurrency] to an arbitrary JSON value.
                     *
                     * You should usually call [Builder.nationalTaxCurrency] with a well-typed
                     * [String] value instead. This method is primarily for setting the field to an
                     * undocumented or not yet supported value.
                     */
                    fun nationalTaxCurrency(nationalTaxCurrency: JsonField<String>) = apply {
                        this.nationalTaxCurrency = nationalTaxCurrency
                    }

                    /**
                     * An identifier from the merchant for the purchase to the issuer and
                     * cardholder.
                     */
                    fun purchaseIdentifier(purchaseIdentifier: String?) =
                        purchaseIdentifier(JsonField.ofNullable(purchaseIdentifier))

                    /**
                     * Alias for calling [Builder.purchaseIdentifier] with
                     * `purchaseIdentifier.orElse(null)`.
                     */
                    fun purchaseIdentifier(purchaseIdentifier: Optional<String>) =
                        purchaseIdentifier(purchaseIdentifier.getOrNull())

                    /**
                     * Sets [Builder.purchaseIdentifier] to an arbitrary JSON value.
                     *
                     * You should usually call [Builder.purchaseIdentifier] with a well-typed
                     * [String] value instead. This method is primarily for setting the field to an
                     * undocumented or not yet supported value.
                     */
                    fun purchaseIdentifier(purchaseIdentifier: JsonField<String>) = apply {
                        this.purchaseIdentifier = purchaseIdentifier
                    }

                    /** The format of the purchase identifier. */
                    fun purchaseIdentifierFormat(
                        purchaseIdentifierFormat: PurchaseIdentifierFormat?
                    ) = purchaseIdentifierFormat(JsonField.ofNullable(purchaseIdentifierFormat))

                    /**
                     * Alias for calling [Builder.purchaseIdentifierFormat] with
                     * `purchaseIdentifierFormat.orElse(null)`.
                     */
                    fun purchaseIdentifierFormat(
                        purchaseIdentifierFormat: Optional<PurchaseIdentifierFormat>
                    ) = purchaseIdentifierFormat(purchaseIdentifierFormat.getOrNull())

                    /**
                     * Sets [Builder.purchaseIdentifierFormat] to an arbitrary JSON value.
                     *
                     * You should usually call [Builder.purchaseIdentifierFormat] with a well-typed
                     * [PurchaseIdentifierFormat] value instead. This method is primarily for
                     * setting the field to an undocumented or not yet supported value.
                     */
                    fun purchaseIdentifierFormat(
                        purchaseIdentifierFormat: JsonField<PurchaseIdentifierFormat>
                    ) = apply { this.purchaseIdentifierFormat = purchaseIdentifierFormat }

                    /** Fields specific to travel. */
                    fun travel(travel: Travel?) = travel(JsonField.ofNullable(travel))

                    /** Alias for calling [Builder.travel] with `travel.orElse(null)`. */
                    fun travel(travel: Optional<Travel>) = travel(travel.getOrNull())

                    /**
                     * Sets [Builder.travel] to an arbitrary JSON value.
                     *
                     * You should usually call [Builder.travel] with a well-typed [Travel] value
                     * instead. This method is primarily for setting the field to an undocumented or
                     * not yet supported value.
                     */
                    fun travel(travel: JsonField<Travel>) = apply { this.travel = travel }

                    fun additionalProperties(additionalProperties: Map<String, JsonValue>) = apply {
                        this.additionalProperties.clear()
                        putAllAdditionalProperties(additionalProperties)
                    }

                    fun putAdditionalProperty(key: String, value: JsonValue) = apply {
                        additionalProperties.put(key, value)
                    }

                    fun putAllAdditionalProperties(additionalProperties: Map<String, JsonValue>) =
                        apply {
                            this.additionalProperties.putAll(additionalProperties)
                        }

                    fun removeAdditionalProperty(key: String) = apply {
                        additionalProperties.remove(key)
                    }

                    fun removeAllAdditionalProperties(keys: Set<String>) = apply {
                        keys.forEach(::removeAdditionalProperty)
                    }

                    /**
                     * Returns an immutable instance of [PurchaseDetails].
                     *
                     * Further updates to this [Builder] will not mutate the returned instance.
                     *
                     * The following fields are required:
                     * ```java
                     * .carRental()
                     * .customerReferenceIdentifier()
                     * .localTaxAmount()
                     * .localTaxCurrency()
                     * .lodging()
                     * .nationalTaxAmount()
                     * .nationalTaxCurrency()
                     * .purchaseIdentifier()
                     * .purchaseIdentifierFormat()
                     * .travel()
                     * ```
                     *
                     * @throws IllegalStateException if any required field is unset.
                     */
                    fun build(): PurchaseDetails =
                        PurchaseDetails(
                            checkRequired("carRental", carRental),
                            checkRequired(
                                "customerReferenceIdentifier",
                                customerReferenceIdentifier,
                            ),
                            checkRequired("localTaxAmount", localTaxAmount),
                            checkRequired("localTaxCurrency", localTaxCurrency),
                            checkRequired("lodging", lodging),
                            checkRequired("nationalTaxAmount", nationalTaxAmount),
                            checkRequired("nationalTaxCurrency", nationalTaxCurrency),
                            checkRequired("purchaseIdentifier", purchaseIdentifier),
                            checkRequired("purchaseIdentifierFormat", purchaseIdentifierFormat),
                            checkRequired("travel", travel),
                            additionalProperties.toMutableMap(),
                        )
                }

                private var validated: Boolean = false

                fun validate(): PurchaseDetails = apply {
                    if (validated) {
                        return@apply
                    }

                    carRental().ifPresent { it.validate() }
                    customerReferenceIdentifier()
                    localTaxAmount()
                    localTaxCurrency()
                    lodging().ifPresent { it.validate() }
                    nationalTaxAmount()
                    nationalTaxCurrency()
                    purchaseIdentifier()
                    purchaseIdentifierFormat().ifPresent { it.validate() }
                    travel().ifPresent { it.validate() }
                    validated = true
                }

                fun isValid(): Boolean =
                    try {
                        validate()
                        true
                    } catch (e: IncreaseInvalidDataException) {
                        false
                    }

                /**
                 * Returns a score indicating how many valid values are contained in this object
                 * recursively.
                 *
                 * Used for best match union deserialization.
                 */
                @JvmSynthetic
                internal fun validity(): Int =
                    (carRental.asKnown().getOrNull()?.validity() ?: 0) +
                        (if (customerReferenceIdentifier.asKnown().isPresent) 1 else 0) +
                        (if (localTaxAmount.asKnown().isPresent) 1 else 0) +
                        (if (localTaxCurrency.asKnown().isPresent) 1 else 0) +
                        (lodging.asKnown().getOrNull()?.validity() ?: 0) +
                        (if (nationalTaxAmount.asKnown().isPresent) 1 else 0) +
                        (if (nationalTaxCurrency.asKnown().isPresent) 1 else 0) +
                        (if (purchaseIdentifier.asKnown().isPresent) 1 else 0) +
                        (purchaseIdentifierFormat.asKnown().getOrNull()?.validity() ?: 0) +
                        (travel.asKnown().getOrNull()?.validity() ?: 0)

                /** Fields specific to car rentals. */
                class CarRental
                private constructor(
                    private val carClassCode: JsonField<String>,
                    private val checkoutDate: JsonField<LocalDate>,
                    private val dailyRentalRateAmount: JsonField<Long>,
                    private val dailyRentalRateCurrency: JsonField<String>,
                    private val daysRented: JsonField<Long>,
                    private val extraCharges: JsonField<ExtraCharges>,
                    private val fuelChargesAmount: JsonField<Long>,
                    private val fuelChargesCurrency: JsonField<String>,
                    private val insuranceChargesAmount: JsonField<Long>,
                    private val insuranceChargesCurrency: JsonField<String>,
                    private val noShowIndicator: JsonField<NoShowIndicator>,
                    private val oneWayDropOffChargesAmount: JsonField<Long>,
                    private val oneWayDropOffChargesCurrency: JsonField<String>,
                    private val renterName: JsonField<String>,
                    private val weeklyRentalRateAmount: JsonField<Long>,
                    private val weeklyRentalRateCurrency: JsonField<String>,
                    private val additionalProperties: MutableMap<String, JsonValue>,
                ) {

                    @JsonCreator
                    private constructor(
                        @JsonProperty("car_class_code")
                        @ExcludeMissing
                        carClassCode: JsonField<String> = JsonMissing.of(),
                        @JsonProperty("checkout_date")
                        @ExcludeMissing
                        checkoutDate: JsonField<LocalDate> = JsonMissing.of(),
                        @JsonProperty("daily_rental_rate_amount")
                        @ExcludeMissing
                        dailyRentalRateAmount: JsonField<Long> = JsonMissing.of(),
                        @JsonProperty("daily_rental_rate_currency")
                        @ExcludeMissing
                        dailyRentalRateCurrency: JsonField<String> = JsonMissing.of(),
                        @JsonProperty("days_rented")
                        @ExcludeMissing
                        daysRented: JsonField<Long> = JsonMissing.of(),
                        @JsonProperty("extra_charges")
                        @ExcludeMissing
                        extraCharges: JsonField<ExtraCharges> = JsonMissing.of(),
                        @JsonProperty("fuel_charges_amount")
                        @ExcludeMissing
                        fuelChargesAmount: JsonField<Long> = JsonMissing.of(),
                        @JsonProperty("fuel_charges_currency")
                        @ExcludeMissing
                        fuelChargesCurrency: JsonField<String> = JsonMissing.of(),
                        @JsonProperty("insurance_charges_amount")
                        @ExcludeMissing
                        insuranceChargesAmount: JsonField<Long> = JsonMissing.of(),
                        @JsonProperty("insurance_charges_currency")
                        @ExcludeMissing
                        insuranceChargesCurrency: JsonField<String> = JsonMissing.of(),
                        @JsonProperty("no_show_indicator")
                        @ExcludeMissing
                        noShowIndicator: JsonField<NoShowIndicator> = JsonMissing.of(),
                        @JsonProperty("one_way_drop_off_charges_amount")
                        @ExcludeMissing
                        oneWayDropOffChargesAmount: JsonField<Long> = JsonMissing.of(),
                        @JsonProperty("one_way_drop_off_charges_currency")
                        @ExcludeMissing
                        oneWayDropOffChargesCurrency: JsonField<String> = JsonMissing.of(),
                        @JsonProperty("renter_name")
                        @ExcludeMissing
                        renterName: JsonField<String> = JsonMissing.of(),
                        @JsonProperty("weekly_rental_rate_amount")
                        @ExcludeMissing
                        weeklyRentalRateAmount: JsonField<Long> = JsonMissing.of(),
                        @JsonProperty("weekly_rental_rate_currency")
                        @ExcludeMissing
                        weeklyRentalRateCurrency: JsonField<String> = JsonMissing.of(),
                    ) : this(
                        carClassCode,
                        checkoutDate,
                        dailyRentalRateAmount,
                        dailyRentalRateCurrency,
                        daysRented,
                        extraCharges,
                        fuelChargesAmount,
                        fuelChargesCurrency,
                        insuranceChargesAmount,
                        insuranceChargesCurrency,
                        noShowIndicator,
                        oneWayDropOffChargesAmount,
                        oneWayDropOffChargesCurrency,
                        renterName,
                        weeklyRentalRateAmount,
                        weeklyRentalRateCurrency,
                        mutableMapOf(),
                    )

                    /**
                     * Code indicating the vehicle's class.
                     *
                     * @throws IncreaseInvalidDataException if the JSON field has an unexpected type
                     *   (e.g. if the server responded with an unexpected value).
                     */
                    fun carClassCode(): Optional<String> =
                        carClassCode.getOptional("car_class_code")

                    /**
                     * Date the customer picked up the car or, in the case of a no-show or pre-pay
                     * transaction, the scheduled pick up date.
                     *
                     * @throws IncreaseInvalidDataException if the JSON field has an unexpected type
                     *   (e.g. if the server responded with an unexpected value).
                     */
                    fun checkoutDate(): Optional<LocalDate> =
                        checkoutDate.getOptional("checkout_date")

                    /**
                     * Daily rate being charged for the vehicle.
                     *
                     * @throws IncreaseInvalidDataException if the JSON field has an unexpected type
                     *   (e.g. if the server responded with an unexpected value).
                     */
                    fun dailyRentalRateAmount(): Optional<Long> =
                        dailyRentalRateAmount.getOptional("daily_rental_rate_amount")

                    /**
                     * The [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) code for the daily
                     * rental rate.
                     *
                     * @throws IncreaseInvalidDataException if the JSON field has an unexpected type
                     *   (e.g. if the server responded with an unexpected value).
                     */
                    fun dailyRentalRateCurrency(): Optional<String> =
                        dailyRentalRateCurrency.getOptional("daily_rental_rate_currency")

                    /**
                     * Number of days the vehicle was rented.
                     *
                     * @throws IncreaseInvalidDataException if the JSON field has an unexpected type
                     *   (e.g. if the server responded with an unexpected value).
                     */
                    fun daysRented(): Optional<Long> = daysRented.getOptional("days_rented")

                    /**
                     * Additional charges (gas, late fee, etc.) being billed.
                     *
                     * @throws IncreaseInvalidDataException if the JSON field has an unexpected type
                     *   (e.g. if the server responded with an unexpected value).
                     */
                    fun extraCharges(): Optional<ExtraCharges> =
                        extraCharges.getOptional("extra_charges")

                    /**
                     * Fuel charges for the vehicle.
                     *
                     * @throws IncreaseInvalidDataException if the JSON field has an unexpected type
                     *   (e.g. if the server responded with an unexpected value).
                     */
                    fun fuelChargesAmount(): Optional<Long> =
                        fuelChargesAmount.getOptional("fuel_charges_amount")

                    /**
                     * The [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) code for the fuel
                     * charges assessed.
                     *
                     * @throws IncreaseInvalidDataException if the JSON field has an unexpected type
                     *   (e.g. if the server responded with an unexpected value).
                     */
                    fun fuelChargesCurrency(): Optional<String> =
                        fuelChargesCurrency.getOptional("fuel_charges_currency")

                    /**
                     * Any insurance being charged for the vehicle.
                     *
                     * @throws IncreaseInvalidDataException if the JSON field has an unexpected type
                     *   (e.g. if the server responded with an unexpected value).
                     */
                    fun insuranceChargesAmount(): Optional<Long> =
                        insuranceChargesAmount.getOptional("insurance_charges_amount")

                    /**
                     * The [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) code for the insurance
                     * charges assessed.
                     *
                     * @throws IncreaseInvalidDataException if the JSON field has an unexpected type
                     *   (e.g. if the server responded with an unexpected value).
                     */
                    fun insuranceChargesCurrency(): Optional<String> =
                        insuranceChargesCurrency.getOptional("insurance_charges_currency")

                    /**
                     * An indicator that the cardholder is being billed for a reserved vehicle that
                     * was not actually rented (that is, a "no-show" charge).
                     *
                     * @throws IncreaseInvalidDataException if the JSON field has an unexpected type
                     *   (e.g. if the server responded with an unexpected value).
                     */
                    fun noShowIndicator(): Optional<NoShowIndicator> =
                        noShowIndicator.getOptional("no_show_indicator")

                    /**
                     * Charges for returning the vehicle at a different location than where it was
                     * picked up.
                     *
                     * @throws IncreaseInvalidDataException if the JSON field has an unexpected type
                     *   (e.g. if the server responded with an unexpected value).
                     */
                    fun oneWayDropOffChargesAmount(): Optional<Long> =
                        oneWayDropOffChargesAmount.getOptional("one_way_drop_off_charges_amount")

                    /**
                     * The [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) code for the one-way
                     * drop-off charges assessed.
                     *
                     * @throws IncreaseInvalidDataException if the JSON field has an unexpected type
                     *   (e.g. if the server responded with an unexpected value).
                     */
                    fun oneWayDropOffChargesCurrency(): Optional<String> =
                        oneWayDropOffChargesCurrency.getOptional(
                            "one_way_drop_off_charges_currency"
                        )

                    /**
                     * Name of the person renting the vehicle.
                     *
                     * @throws IncreaseInvalidDataException if the JSON field has an unexpected type
                     *   (e.g. if the server responded with an unexpected value).
                     */
                    fun renterName(): Optional<String> = renterName.getOptional("renter_name")

                    /**
                     * Weekly rate being charged for the vehicle.
                     *
                     * @throws IncreaseInvalidDataException if the JSON field has an unexpected type
                     *   (e.g. if the server responded with an unexpected value).
                     */
                    fun weeklyRentalRateAmount(): Optional<Long> =
                        weeklyRentalRateAmount.getOptional("weekly_rental_rate_amount")

                    /**
                     * The [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) code for the weekly
                     * rental rate.
                     *
                     * @throws IncreaseInvalidDataException if the JSON field has an unexpected type
                     *   (e.g. if the server responded with an unexpected value).
                     */
                    fun weeklyRentalRateCurrency(): Optional<String> =
                        weeklyRentalRateCurrency.getOptional("weekly_rental_rate_currency")

                    /**
                     * Returns the raw JSON value of [carClassCode].
                     *
                     * Unlike [carClassCode], this method doesn't throw if the JSON field has an
                     * unexpected type.
                     */
                    @JsonProperty("car_class_code")
                    @ExcludeMissing
                    fun _carClassCode(): JsonField<String> = carClassCode

                    /**
                     * Returns the raw JSON value of [checkoutDate].
                     *
                     * Unlike [checkoutDate], this method doesn't throw if the JSON field has an
                     * unexpected type.
                     */
                    @JsonProperty("checkout_date")
                    @ExcludeMissing
                    fun _checkoutDate(): JsonField<LocalDate> = checkoutDate

                    /**
                     * Returns the raw JSON value of [dailyRentalRateAmount].
                     *
                     * Unlike [dailyRentalRateAmount], this method doesn't throw if the JSON field
                     * has an unexpected type.
                     */
                    @JsonProperty("daily_rental_rate_amount")
                    @ExcludeMissing
                    fun _dailyRentalRateAmount(): JsonField<Long> = dailyRentalRateAmount

                    /**
                     * Returns the raw JSON value of [dailyRentalRateCurrency].
                     *
                     * Unlike [dailyRentalRateCurrency], this method doesn't throw if the JSON field
                     * has an unexpected type.
                     */
                    @JsonProperty("daily_rental_rate_currency")
                    @ExcludeMissing
                    fun _dailyRentalRateCurrency(): JsonField<String> = dailyRentalRateCurrency

                    /**
                     * Returns the raw JSON value of [daysRented].
                     *
                     * Unlike [daysRented], this method doesn't throw if the JSON field has an
                     * unexpected type.
                     */
                    @JsonProperty("days_rented")
                    @ExcludeMissing
                    fun _daysRented(): JsonField<Long> = daysRented

                    /**
                     * Returns the raw JSON value of [extraCharges].
                     *
                     * Unlike [extraCharges], this method doesn't throw if the JSON field has an
                     * unexpected type.
                     */
                    @JsonProperty("extra_charges")
                    @ExcludeMissing
                    fun _extraCharges(): JsonField<ExtraCharges> = extraCharges

                    /**
                     * Returns the raw JSON value of [fuelChargesAmount].
                     *
                     * Unlike [fuelChargesAmount], this method doesn't throw if the JSON field has
                     * an unexpected type.
                     */
                    @JsonProperty("fuel_charges_amount")
                    @ExcludeMissing
                    fun _fuelChargesAmount(): JsonField<Long> = fuelChargesAmount

                    /**
                     * Returns the raw JSON value of [fuelChargesCurrency].
                     *
                     * Unlike [fuelChargesCurrency], this method doesn't throw if the JSON field has
                     * an unexpected type.
                     */
                    @JsonProperty("fuel_charges_currency")
                    @ExcludeMissing
                    fun _fuelChargesCurrency(): JsonField<String> = fuelChargesCurrency

                    /**
                     * Returns the raw JSON value of [insuranceChargesAmount].
                     *
                     * Unlike [insuranceChargesAmount], this method doesn't throw if the JSON field
                     * has an unexpected type.
                     */
                    @JsonProperty("insurance_charges_amount")
                    @ExcludeMissing
                    fun _insuranceChargesAmount(): JsonField<Long> = insuranceChargesAmount

                    /**
                     * Returns the raw JSON value of [insuranceChargesCurrency].
                     *
                     * Unlike [insuranceChargesCurrency], this method doesn't throw if the JSON
                     * field has an unexpected type.
                     */
                    @JsonProperty("insurance_charges_currency")
                    @ExcludeMissing
                    fun _insuranceChargesCurrency(): JsonField<String> = insuranceChargesCurrency

                    /**
                     * Returns the raw JSON value of [noShowIndicator].
                     *
                     * Unlike [noShowIndicator], this method doesn't throw if the JSON field has an
                     * unexpected type.
                     */
                    @JsonProperty("no_show_indicator")
                    @ExcludeMissing
                    fun _noShowIndicator(): JsonField<NoShowIndicator> = noShowIndicator

                    /**
                     * Returns the raw JSON value of [oneWayDropOffChargesAmount].
                     *
                     * Unlike [oneWayDropOffChargesAmount], this method doesn't throw if the JSON
                     * field has an unexpected type.
                     */
                    @JsonProperty("one_way_drop_off_charges_amount")
                    @ExcludeMissing
                    fun _oneWayDropOffChargesAmount(): JsonField<Long> = oneWayDropOffChargesAmount

                    /**
                     * Returns the raw JSON value of [oneWayDropOffChargesCurrency].
                     *
                     * Unlike [oneWayDropOffChargesCurrency], this method doesn't throw if the JSON
                     * field has an unexpected type.
                     */
                    @JsonProperty("one_way_drop_off_charges_currency")
                    @ExcludeMissing
                    fun _oneWayDropOffChargesCurrency(): JsonField<String> =
                        oneWayDropOffChargesCurrency

                    /**
                     * Returns the raw JSON value of [renterName].
                     *
                     * Unlike [renterName], this method doesn't throw if the JSON field has an
                     * unexpected type.
                     */
                    @JsonProperty("renter_name")
                    @ExcludeMissing
                    fun _renterName(): JsonField<String> = renterName

                    /**
                     * Returns the raw JSON value of [weeklyRentalRateAmount].
                     *
                     * Unlike [weeklyRentalRateAmount], this method doesn't throw if the JSON field
                     * has an unexpected type.
                     */
                    @JsonProperty("weekly_rental_rate_amount")
                    @ExcludeMissing
                    fun _weeklyRentalRateAmount(): JsonField<Long> = weeklyRentalRateAmount

                    /**
                     * Returns the raw JSON value of [weeklyRentalRateCurrency].
                     *
                     * Unlike [weeklyRentalRateCurrency], this method doesn't throw if the JSON
                     * field has an unexpected type.
                     */
                    @JsonProperty("weekly_rental_rate_currency")
                    @ExcludeMissing
                    fun _weeklyRentalRateCurrency(): JsonField<String> = weeklyRentalRateCurrency

                    @JsonAnySetter
                    private fun putAdditionalProperty(key: String, value: JsonValue) {
                        additionalProperties.put(key, value)
                    }

                    @JsonAnyGetter
                    @ExcludeMissing
                    fun _additionalProperties(): Map<String, JsonValue> =
                        Collections.unmodifiableMap(additionalProperties)

                    fun toBuilder() = Builder().from(this)

                    companion object {

                        /**
                         * Returns a mutable builder for constructing an instance of [CarRental].
                         *
                         * The following fields are required:
                         * ```java
                         * .carClassCode()
                         * .checkoutDate()
                         * .dailyRentalRateAmount()
                         * .dailyRentalRateCurrency()
                         * .daysRented()
                         * .extraCharges()
                         * .fuelChargesAmount()
                         * .fuelChargesCurrency()
                         * .insuranceChargesAmount()
                         * .insuranceChargesCurrency()
                         * .noShowIndicator()
                         * .oneWayDropOffChargesAmount()
                         * .oneWayDropOffChargesCurrency()
                         * .renterName()
                         * .weeklyRentalRateAmount()
                         * .weeklyRentalRateCurrency()
                         * ```
                         */
                        @JvmStatic fun builder() = Builder()
                    }

                    /** A builder for [CarRental]. */
                    class Builder internal constructor() {

                        private var carClassCode: JsonField<String>? = null
                        private var checkoutDate: JsonField<LocalDate>? = null
                        private var dailyRentalRateAmount: JsonField<Long>? = null
                        private var dailyRentalRateCurrency: JsonField<String>? = null
                        private var daysRented: JsonField<Long>? = null
                        private var extraCharges: JsonField<ExtraCharges>? = null
                        private var fuelChargesAmount: JsonField<Long>? = null
                        private var fuelChargesCurrency: JsonField<String>? = null
                        private var insuranceChargesAmount: JsonField<Long>? = null
                        private var insuranceChargesCurrency: JsonField<String>? = null
                        private var noShowIndicator: JsonField<NoShowIndicator>? = null
                        private var oneWayDropOffChargesAmount: JsonField<Long>? = null
                        private var oneWayDropOffChargesCurrency: JsonField<String>? = null
                        private var renterName: JsonField<String>? = null
                        private var weeklyRentalRateAmount: JsonField<Long>? = null
                        private var weeklyRentalRateCurrency: JsonField<String>? = null
                        private var additionalProperties: MutableMap<String, JsonValue> =
                            mutableMapOf()

                        @JvmSynthetic
                        internal fun from(carRental: CarRental) = apply {
                            carClassCode = carRental.carClassCode
                            checkoutDate = carRental.checkoutDate
                            dailyRentalRateAmount = carRental.dailyRentalRateAmount
                            dailyRentalRateCurrency = carRental.dailyRentalRateCurrency
                            daysRented = carRental.daysRented
                            extraCharges = carRental.extraCharges
                            fuelChargesAmount = carRental.fuelChargesAmount
                            fuelChargesCurrency = carRental.fuelChargesCurrency
                            insuranceChargesAmount = carRental.insuranceChargesAmount
                            insuranceChargesCurrency = carRental.insuranceChargesCurrency
                            noShowIndicator = carRental.noShowIndicator
                            oneWayDropOffChargesAmount = carRental.oneWayDropOffChargesAmount
                            oneWayDropOffChargesCurrency = carRental.oneWayDropOffChargesCurrency
                            renterName = carRental.renterName
                            weeklyRentalRateAmount = carRental.weeklyRentalRateAmount
                            weeklyRentalRateCurrency = carRental.weeklyRentalRateCurrency
                            additionalProperties = carRental.additionalProperties.toMutableMap()
                        }

                        /** Code indicating the vehicle's class. */
                        fun carClassCode(carClassCode: String?) =
                            carClassCode(JsonField.ofNullable(carClassCode))

                        /**
                         * Alias for calling [Builder.carClassCode] with
                         * `carClassCode.orElse(null)`.
                         */
                        fun carClassCode(carClassCode: Optional<String>) =
                            carClassCode(carClassCode.getOrNull())

                        /**
                         * Sets [Builder.carClassCode] to an arbitrary JSON value.
                         *
                         * You should usually call [Builder.carClassCode] with a well-typed [String]
                         * value instead. This method is primarily for setting the field to an
                         * undocumented or not yet supported value.
                         */
                        fun carClassCode(carClassCode: JsonField<String>) = apply {
                            this.carClassCode = carClassCode
                        }

                        /**
                         * Date the customer picked up the car or, in the case of a no-show or
                         * pre-pay transaction, the scheduled pick up date.
                         */
                        fun checkoutDate(checkoutDate: LocalDate?) =
                            checkoutDate(JsonField.ofNullable(checkoutDate))

                        /**
                         * Alias for calling [Builder.checkoutDate] with
                         * `checkoutDate.orElse(null)`.
                         */
                        fun checkoutDate(checkoutDate: Optional<LocalDate>) =
                            checkoutDate(checkoutDate.getOrNull())

                        /**
                         * Sets [Builder.checkoutDate] to an arbitrary JSON value.
                         *
                         * You should usually call [Builder.checkoutDate] with a well-typed
                         * [LocalDate] value instead. This method is primarily for setting the field
                         * to an undocumented or not yet supported value.
                         */
                        fun checkoutDate(checkoutDate: JsonField<LocalDate>) = apply {
                            this.checkoutDate = checkoutDate
                        }

                        /** Daily rate being charged for the vehicle. */
                        fun dailyRentalRateAmount(dailyRentalRateAmount: Long?) =
                            dailyRentalRateAmount(JsonField.ofNullable(dailyRentalRateAmount))

                        /**
                         * Alias for [Builder.dailyRentalRateAmount].
                         *
                         * This unboxed primitive overload exists for backwards compatibility.
                         */
                        fun dailyRentalRateAmount(dailyRentalRateAmount: Long) =
                            dailyRentalRateAmount(dailyRentalRateAmount as Long?)

                        /**
                         * Alias for calling [Builder.dailyRentalRateAmount] with
                         * `dailyRentalRateAmount.orElse(null)`.
                         */
                        fun dailyRentalRateAmount(dailyRentalRateAmount: Optional<Long>) =
                            dailyRentalRateAmount(dailyRentalRateAmount.getOrNull())

                        /**
                         * Sets [Builder.dailyRentalRateAmount] to an arbitrary JSON value.
                         *
                         * You should usually call [Builder.dailyRentalRateAmount] with a well-typed
                         * [Long] value instead. This method is primarily for setting the field to
                         * an undocumented or not yet supported value.
                         */
                        fun dailyRentalRateAmount(dailyRentalRateAmount: JsonField<Long>) = apply {
                            this.dailyRentalRateAmount = dailyRentalRateAmount
                        }

                        /**
                         * The [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) code for the daily
                         * rental rate.
                         */
                        fun dailyRentalRateCurrency(dailyRentalRateCurrency: String?) =
                            dailyRentalRateCurrency(JsonField.ofNullable(dailyRentalRateCurrency))

                        /**
                         * Alias for calling [Builder.dailyRentalRateCurrency] with
                         * `dailyRentalRateCurrency.orElse(null)`.
                         */
                        fun dailyRentalRateCurrency(dailyRentalRateCurrency: Optional<String>) =
                            dailyRentalRateCurrency(dailyRentalRateCurrency.getOrNull())

                        /**
                         * Sets [Builder.dailyRentalRateCurrency] to an arbitrary JSON value.
                         *
                         * You should usually call [Builder.dailyRentalRateCurrency] with a
                         * well-typed [String] value instead. This method is primarily for setting
                         * the field to an undocumented or not yet supported value.
                         */
                        fun dailyRentalRateCurrency(dailyRentalRateCurrency: JsonField<String>) =
                            apply {
                                this.dailyRentalRateCurrency = dailyRentalRateCurrency
                            }

                        /** Number of days the vehicle was rented. */
                        fun daysRented(daysRented: Long?) =
                            daysRented(JsonField.ofNullable(daysRented))

                        /**
                         * Alias for [Builder.daysRented].
                         *
                         * This unboxed primitive overload exists for backwards compatibility.
                         */
                        fun daysRented(daysRented: Long) = daysRented(daysRented as Long?)

                        /**
                         * Alias for calling [Builder.daysRented] with `daysRented.orElse(null)`.
                         */
                        fun daysRented(daysRented: Optional<Long>) =
                            daysRented(daysRented.getOrNull())

                        /**
                         * Sets [Builder.daysRented] to an arbitrary JSON value.
                         *
                         * You should usually call [Builder.daysRented] with a well-typed [Long]
                         * value instead. This method is primarily for setting the field to an
                         * undocumented or not yet supported value.
                         */
                        fun daysRented(daysRented: JsonField<Long>) = apply {
                            this.daysRented = daysRented
                        }

                        /** Additional charges (gas, late fee, etc.) being billed. */
                        fun extraCharges(extraCharges: ExtraCharges?) =
                            extraCharges(JsonField.ofNullable(extraCharges))

                        /**
                         * Alias for calling [Builder.extraCharges] with
                         * `extraCharges.orElse(null)`.
                         */
                        fun extraCharges(extraCharges: Optional<ExtraCharges>) =
                            extraCharges(extraCharges.getOrNull())

                        /**
                         * Sets [Builder.extraCharges] to an arbitrary JSON value.
                         *
                         * You should usually call [Builder.extraCharges] with a well-typed
                         * [ExtraCharges] value instead. This method is primarily for setting the
                         * field to an undocumented or not yet supported value.
                         */
                        fun extraCharges(extraCharges: JsonField<ExtraCharges>) = apply {
                            this.extraCharges = extraCharges
                        }

                        /** Fuel charges for the vehicle. */
                        fun fuelChargesAmount(fuelChargesAmount: Long?) =
                            fuelChargesAmount(JsonField.ofNullable(fuelChargesAmount))

                        /**
                         * Alias for [Builder.fuelChargesAmount].
                         *
                         * This unboxed primitive overload exists for backwards compatibility.
                         */
                        fun fuelChargesAmount(fuelChargesAmount: Long) =
                            fuelChargesAmount(fuelChargesAmount as Long?)

                        /**
                         * Alias for calling [Builder.fuelChargesAmount] with
                         * `fuelChargesAmount.orElse(null)`.
                         */
                        fun fuelChargesAmount(fuelChargesAmount: Optional<Long>) =
                            fuelChargesAmount(fuelChargesAmount.getOrNull())

                        /**
                         * Sets [Builder.fuelChargesAmount] to an arbitrary JSON value.
                         *
                         * You should usually call [Builder.fuelChargesAmount] with a well-typed
                         * [Long] value instead. This method is primarily for setting the field to
                         * an undocumented or not yet supported value.
                         */
                        fun fuelChargesAmount(fuelChargesAmount: JsonField<Long>) = apply {
                            this.fuelChargesAmount = fuelChargesAmount
                        }

                        /**
                         * The [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) code for the fuel
                         * charges assessed.
                         */
                        fun fuelChargesCurrency(fuelChargesCurrency: String?) =
                            fuelChargesCurrency(JsonField.ofNullable(fuelChargesCurrency))

                        /**
                         * Alias for calling [Builder.fuelChargesCurrency] with
                         * `fuelChargesCurrency.orElse(null)`.
                         */
                        fun fuelChargesCurrency(fuelChargesCurrency: Optional<String>) =
                            fuelChargesCurrency(fuelChargesCurrency.getOrNull())

                        /**
                         * Sets [Builder.fuelChargesCurrency] to an arbitrary JSON value.
                         *
                         * You should usually call [Builder.fuelChargesCurrency] with a well-typed
                         * [String] value instead. This method is primarily for setting the field to
                         * an undocumented or not yet supported value.
                         */
                        fun fuelChargesCurrency(fuelChargesCurrency: JsonField<String>) = apply {
                            this.fuelChargesCurrency = fuelChargesCurrency
                        }

                        /** Any insurance being charged for the vehicle. */
                        fun insuranceChargesAmount(insuranceChargesAmount: Long?) =
                            insuranceChargesAmount(JsonField.ofNullable(insuranceChargesAmount))

                        /**
                         * Alias for [Builder.insuranceChargesAmount].
                         *
                         * This unboxed primitive overload exists for backwards compatibility.
                         */
                        fun insuranceChargesAmount(insuranceChargesAmount: Long) =
                            insuranceChargesAmount(insuranceChargesAmount as Long?)

                        /**
                         * Alias for calling [Builder.insuranceChargesAmount] with
                         * `insuranceChargesAmount.orElse(null)`.
                         */
                        fun insuranceChargesAmount(insuranceChargesAmount: Optional<Long>) =
                            insuranceChargesAmount(insuranceChargesAmount.getOrNull())

                        /**
                         * Sets [Builder.insuranceChargesAmount] to an arbitrary JSON value.
                         *
                         * You should usually call [Builder.insuranceChargesAmount] with a
                         * well-typed [Long] value instead. This method is primarily for setting the
                         * field to an undocumented or not yet supported value.
                         */
                        fun insuranceChargesAmount(insuranceChargesAmount: JsonField<Long>) =
                            apply {
                                this.insuranceChargesAmount = insuranceChargesAmount
                            }

                        /**
                         * The [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) code for the
                         * insurance charges assessed.
                         */
                        fun insuranceChargesCurrency(insuranceChargesCurrency: String?) =
                            insuranceChargesCurrency(JsonField.ofNullable(insuranceChargesCurrency))

                        /**
                         * Alias for calling [Builder.insuranceChargesCurrency] with
                         * `insuranceChargesCurrency.orElse(null)`.
                         */
                        fun insuranceChargesCurrency(insuranceChargesCurrency: Optional<String>) =
                            insuranceChargesCurrency(insuranceChargesCurrency.getOrNull())

                        /**
                         * Sets [Builder.insuranceChargesCurrency] to an arbitrary JSON value.
                         *
                         * You should usually call [Builder.insuranceChargesCurrency] with a
                         * well-typed [String] value instead. This method is primarily for setting
                         * the field to an undocumented or not yet supported value.
                         */
                        fun insuranceChargesCurrency(insuranceChargesCurrency: JsonField<String>) =
                            apply {
                                this.insuranceChargesCurrency = insuranceChargesCurrency
                            }

                        /**
                         * An indicator that the cardholder is being billed for a reserved vehicle
                         * that was not actually rented (that is, a "no-show" charge).
                         */
                        fun noShowIndicator(noShowIndicator: NoShowIndicator?) =
                            noShowIndicator(JsonField.ofNullable(noShowIndicator))

                        /**
                         * Alias for calling [Builder.noShowIndicator] with
                         * `noShowIndicator.orElse(null)`.
                         */
                        fun noShowIndicator(noShowIndicator: Optional<NoShowIndicator>) =
                            noShowIndicator(noShowIndicator.getOrNull())

                        /**
                         * Sets [Builder.noShowIndicator] to an arbitrary JSON value.
                         *
                         * You should usually call [Builder.noShowIndicator] with a well-typed
                         * [NoShowIndicator] value instead. This method is primarily for setting the
                         * field to an undocumented or not yet supported value.
                         */
                        fun noShowIndicator(noShowIndicator: JsonField<NoShowIndicator>) = apply {
                            this.noShowIndicator = noShowIndicator
                        }

                        /**
                         * Charges for returning the vehicle at a different location than where it
                         * was picked up.
                         */
                        fun oneWayDropOffChargesAmount(oneWayDropOffChargesAmount: Long?) =
                            oneWayDropOffChargesAmount(
                                JsonField.ofNullable(oneWayDropOffChargesAmount)
                            )

                        /**
                         * Alias for [Builder.oneWayDropOffChargesAmount].
                         *
                         * This unboxed primitive overload exists for backwards compatibility.
                         */
                        fun oneWayDropOffChargesAmount(oneWayDropOffChargesAmount: Long) =
                            oneWayDropOffChargesAmount(oneWayDropOffChargesAmount as Long?)

                        /**
                         * Alias for calling [Builder.oneWayDropOffChargesAmount] with
                         * `oneWayDropOffChargesAmount.orElse(null)`.
                         */
                        fun oneWayDropOffChargesAmount(oneWayDropOffChargesAmount: Optional<Long>) =
                            oneWayDropOffChargesAmount(oneWayDropOffChargesAmount.getOrNull())

                        /**
                         * Sets [Builder.oneWayDropOffChargesAmount] to an arbitrary JSON value.
                         *
                         * You should usually call [Builder.oneWayDropOffChargesAmount] with a
                         * well-typed [Long] value instead. This method is primarily for setting the
                         * field to an undocumented or not yet supported value.
                         */
                        fun oneWayDropOffChargesAmount(
                            oneWayDropOffChargesAmount: JsonField<Long>
                        ) = apply { this.oneWayDropOffChargesAmount = oneWayDropOffChargesAmount }

                        /**
                         * The [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) code for the
                         * one-way drop-off charges assessed.
                         */
                        fun oneWayDropOffChargesCurrency(oneWayDropOffChargesCurrency: String?) =
                            oneWayDropOffChargesCurrency(
                                JsonField.ofNullable(oneWayDropOffChargesCurrency)
                            )

                        /**
                         * Alias for calling [Builder.oneWayDropOffChargesCurrency] with
                         * `oneWayDropOffChargesCurrency.orElse(null)`.
                         */
                        fun oneWayDropOffChargesCurrency(
                            oneWayDropOffChargesCurrency: Optional<String>
                        ) = oneWayDropOffChargesCurrency(oneWayDropOffChargesCurrency.getOrNull())

                        /**
                         * Sets [Builder.oneWayDropOffChargesCurrency] to an arbitrary JSON value.
                         *
                         * You should usually call [Builder.oneWayDropOffChargesCurrency] with a
                         * well-typed [String] value instead. This method is primarily for setting
                         * the field to an undocumented or not yet supported value.
                         */
                        fun oneWayDropOffChargesCurrency(
                            oneWayDropOffChargesCurrency: JsonField<String>
                        ) = apply {
                            this.oneWayDropOffChargesCurrency = oneWayDropOffChargesCurrency
                        }

                        /** Name of the person renting the vehicle. */
                        fun renterName(renterName: String?) =
                            renterName(JsonField.ofNullable(renterName))

                        /**
                         * Alias for calling [Builder.renterName] with `renterName.orElse(null)`.
                         */
                        fun renterName(renterName: Optional<String>) =
                            renterName(renterName.getOrNull())

                        /**
                         * Sets [Builder.renterName] to an arbitrary JSON value.
                         *
                         * You should usually call [Builder.renterName] with a well-typed [String]
                         * value instead. This method is primarily for setting the field to an
                         * undocumented or not yet supported value.
                         */
                        fun renterName(renterName: JsonField<String>) = apply {
                            this.renterName = renterName
                        }

                        /** Weekly rate being charged for the vehicle. */
                        fun weeklyRentalRateAmount(weeklyRentalRateAmount: Long?) =
                            weeklyRentalRateAmount(JsonField.ofNullable(weeklyRentalRateAmount))

                        /**
                         * Alias for [Builder.weeklyRentalRateAmount].
                         *
                         * This unboxed primitive overload exists for backwards compatibility.
                         */
                        fun weeklyRentalRateAmount(weeklyRentalRateAmount: Long) =
                            weeklyRentalRateAmount(weeklyRentalRateAmount as Long?)

                        /**
                         * Alias for calling [Builder.weeklyRentalRateAmount] with
                         * `weeklyRentalRateAmount.orElse(null)`.
                         */
                        fun weeklyRentalRateAmount(weeklyRentalRateAmount: Optional<Long>) =
                            weeklyRentalRateAmount(weeklyRentalRateAmount.getOrNull())

                        /**
                         * Sets [Builder.weeklyRentalRateAmount] to an arbitrary JSON value.
                         *
                         * You should usually call [Builder.weeklyRentalRateAmount] with a
                         * well-typed [Long] value instead. This method is primarily for setting the
                         * field to an undocumented or not yet supported value.
                         */
                        fun weeklyRentalRateAmount(weeklyRentalRateAmount: JsonField<Long>) =
                            apply {
                                this.weeklyRentalRateAmount = weeklyRentalRateAmount
                            }

                        /**
                         * The [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) code for the
                         * weekly rental rate.
                         */
                        fun weeklyRentalRateCurrency(weeklyRentalRateCurrency: String?) =
                            weeklyRentalRateCurrency(JsonField.ofNullable(weeklyRentalRateCurrency))

                        /**
                         * Alias for calling [Builder.weeklyRentalRateCurrency] with
                         * `weeklyRentalRateCurrency.orElse(null)`.
                         */
                        fun weeklyRentalRateCurrency(weeklyRentalRateCurrency: Optional<String>) =
                            weeklyRentalRateCurrency(weeklyRentalRateCurrency.getOrNull())

                        /**
                         * Sets [Builder.weeklyRentalRateCurrency] to an arbitrary JSON value.
                         *
                         * You should usually call [Builder.weeklyRentalRateCurrency] with a
                         * well-typed [String] value instead. This method is primarily for setting
                         * the field to an undocumented or not yet supported value.
                         */
                        fun weeklyRentalRateCurrency(weeklyRentalRateCurrency: JsonField<String>) =
                            apply {
                                this.weeklyRentalRateCurrency = weeklyRentalRateCurrency
                            }

                        fun additionalProperties(additionalProperties: Map<String, JsonValue>) =
                            apply {
                                this.additionalProperties.clear()
                                putAllAdditionalProperties(additionalProperties)
                            }

                        fun putAdditionalProperty(key: String, value: JsonValue) = apply {
                            additionalProperties.put(key, value)
                        }

                        fun putAllAdditionalProperties(
                            additionalProperties: Map<String, JsonValue>
                        ) = apply { this.additionalProperties.putAll(additionalProperties) }

                        fun removeAdditionalProperty(key: String) = apply {
                            additionalProperties.remove(key)
                        }

                        fun removeAllAdditionalProperties(keys: Set<String>) = apply {
                            keys.forEach(::removeAdditionalProperty)
                        }

                        /**
                         * Returns an immutable instance of [CarRental].
                         *
                         * Further updates to this [Builder] will not mutate the returned instance.
                         *
                         * The following fields are required:
                         * ```java
                         * .carClassCode()
                         * .checkoutDate()
                         * .dailyRentalRateAmount()
                         * .dailyRentalRateCurrency()
                         * .daysRented()
                         * .extraCharges()
                         * .fuelChargesAmount()
                         * .fuelChargesCurrency()
                         * .insuranceChargesAmount()
                         * .insuranceChargesCurrency()
                         * .noShowIndicator()
                         * .oneWayDropOffChargesAmount()
                         * .oneWayDropOffChargesCurrency()
                         * .renterName()
                         * .weeklyRentalRateAmount()
                         * .weeklyRentalRateCurrency()
                         * ```
                         *
                         * @throws IllegalStateException if any required field is unset.
                         */
                        fun build(): CarRental =
                            CarRental(
                                checkRequired("carClassCode", carClassCode),
                                checkRequired("checkoutDate", checkoutDate),
                                checkRequired("dailyRentalRateAmount", dailyRentalRateAmount),
                                checkRequired("dailyRentalRateCurrency", dailyRentalRateCurrency),
                                checkRequired("daysRented", daysRented),
                                checkRequired("extraCharges", extraCharges),
                                checkRequired("fuelChargesAmount", fuelChargesAmount),
                                checkRequired("fuelChargesCurrency", fuelChargesCurrency),
                                checkRequired("insuranceChargesAmount", insuranceChargesAmount),
                                checkRequired("insuranceChargesCurrency", insuranceChargesCurrency),
                                checkRequired("noShowIndicator", noShowIndicator),
                                checkRequired(
                                    "oneWayDropOffChargesAmount",
                                    oneWayDropOffChargesAmount,
                                ),
                                checkRequired(
                                    "oneWayDropOffChargesCurrency",
                                    oneWayDropOffChargesCurrency,
                                ),
                                checkRequired("renterName", renterName),
                                checkRequired("weeklyRentalRateAmount", weeklyRentalRateAmount),
                                checkRequired("weeklyRentalRateCurrency", weeklyRentalRateCurrency),
                                additionalProperties.toMutableMap(),
                            )
                    }

                    private var validated: Boolean = false

                    fun validate(): CarRental = apply {
                        if (validated) {
                            return@apply
                        }

                        carClassCode()
                        checkoutDate()
                        dailyRentalRateAmount()
                        dailyRentalRateCurrency()
                        daysRented()
                        extraCharges().ifPresent { it.validate() }
                        fuelChargesAmount()
                        fuelChargesCurrency()
                        insuranceChargesAmount()
                        insuranceChargesCurrency()
                        noShowIndicator().ifPresent { it.validate() }
                        oneWayDropOffChargesAmount()
                        oneWayDropOffChargesCurrency()
                        renterName()
                        weeklyRentalRateAmount()
                        weeklyRentalRateCurrency()
                        validated = true
                    }

                    fun isValid(): Boolean =
                        try {
                            validate()
                            true
                        } catch (e: IncreaseInvalidDataException) {
                            false
                        }

                    /**
                     * Returns a score indicating how many valid values are contained in this object
                     * recursively.
                     *
                     * Used for best match union deserialization.
                     */
                    @JvmSynthetic
                    internal fun validity(): Int =
                        (if (carClassCode.asKnown().isPresent) 1 else 0) +
                            (if (checkoutDate.asKnown().isPresent) 1 else 0) +
                            (if (dailyRentalRateAmount.asKnown().isPresent) 1 else 0) +
                            (if (dailyRentalRateCurrency.asKnown().isPresent) 1 else 0) +
                            (if (daysRented.asKnown().isPresent) 1 else 0) +
                            (extraCharges.asKnown().getOrNull()?.validity() ?: 0) +
                            (if (fuelChargesAmount.asKnown().isPresent) 1 else 0) +
                            (if (fuelChargesCurrency.asKnown().isPresent) 1 else 0) +
                            (if (insuranceChargesAmount.asKnown().isPresent) 1 else 0) +
                            (if (insuranceChargesCurrency.asKnown().isPresent) 1 else 0) +
                            (noShowIndicator.asKnown().getOrNull()?.validity() ?: 0) +
                            (if (oneWayDropOffChargesAmount.asKnown().isPresent) 1 else 0) +
                            (if (oneWayDropOffChargesCurrency.asKnown().isPresent) 1 else 0) +
                            (if (renterName.asKnown().isPresent) 1 else 0) +
                            (if (weeklyRentalRateAmount.asKnown().isPresent) 1 else 0) +
                            (if (weeklyRentalRateCurrency.asKnown().isPresent) 1 else 0)

                    /** Additional charges (gas, late fee, etc.) being billed. */
                    class ExtraCharges
                    @JsonCreator
                    private constructor(private val value: JsonField<String>) : Enum {

                        /**
                         * Returns this class instance's raw value.
                         *
                         * This is usually only useful if this instance was deserialized from data
                         * that doesn't match any known member, and you want to know that value. For
                         * example, if the SDK is on an older version than the API, then the API may
                         * respond with new members that the SDK is unaware of.
                         */
                        @com.fasterxml.jackson.annotation.JsonValue
                        fun _value(): JsonField<String> = value

                        companion object {

                            /** No extra charge */
                            @JvmField val NO_EXTRA_CHARGE = of("no_extra_charge")

                            /** Gas */
                            @JvmField val GAS = of("gas")

                            /** Extra mileage */
                            @JvmField val EXTRA_MILEAGE = of("extra_mileage")

                            /** Late return */
                            @JvmField val LATE_RETURN = of("late_return")

                            /** One way service fee */
                            @JvmField val ONE_WAY_SERVICE_FEE = of("one_way_service_fee")

                            /** Parking violation */
                            @JvmField val PARKING_VIOLATION = of("parking_violation")

                            @JvmStatic fun of(value: String) = ExtraCharges(JsonField.of(value))
                        }

                        /** An enum containing [ExtraCharges]'s known values. */
                        enum class Known {
                            /** No extra charge */
                            NO_EXTRA_CHARGE,
                            /** Gas */
                            GAS,
                            /** Extra mileage */
                            EXTRA_MILEAGE,
                            /** Late return */
                            LATE_RETURN,
                            /** One way service fee */
                            ONE_WAY_SERVICE_FEE,
                            /** Parking violation */
                            PARKING_VIOLATION,
                        }

                        /**
                         * An enum containing [ExtraCharges]'s known values, as well as an
                         * [_UNKNOWN] member.
                         *
                         * An instance of [ExtraCharges] can contain an unknown value in a couple of
                         * cases:
                         * - It was deserialized from data that doesn't match any known member. For
                         *   example, if the SDK is on an older version than the API, then the API
                         *   may respond with new members that the SDK is unaware of.
                         * - It was constructed with an arbitrary value using the [of] method.
                         */
                        enum class Value {
                            /** No extra charge */
                            NO_EXTRA_CHARGE,
                            /** Gas */
                            GAS,
                            /** Extra mileage */
                            EXTRA_MILEAGE,
                            /** Late return */
                            LATE_RETURN,
                            /** One way service fee */
                            ONE_WAY_SERVICE_FEE,
                            /** Parking violation */
                            PARKING_VIOLATION,
                            /**
                             * An enum member indicating that [ExtraCharges] was instantiated with
                             * an unknown value.
                             */
                            _UNKNOWN,
                        }

                        /**
                         * Returns an enum member corresponding to this class instance's value, or
                         * [Value._UNKNOWN] if the class was instantiated with an unknown value.
                         *
                         * Use the [known] method instead if you're certain the value is always
                         * known or if you want to throw for the unknown case.
                         */
                        fun value(): Value =
                            when (this) {
                                NO_EXTRA_CHARGE -> Value.NO_EXTRA_CHARGE
                                GAS -> Value.GAS
                                EXTRA_MILEAGE -> Value.EXTRA_MILEAGE
                                LATE_RETURN -> Value.LATE_RETURN
                                ONE_WAY_SERVICE_FEE -> Value.ONE_WAY_SERVICE_FEE
                                PARKING_VIOLATION -> Value.PARKING_VIOLATION
                                else -> Value._UNKNOWN
                            }

                        /**
                         * Returns an enum member corresponding to this class instance's value.
                         *
                         * Use the [value] method instead if you're uncertain the value is always
                         * known and don't want to throw for the unknown case.
                         *
                         * @throws IncreaseInvalidDataException if this class instance's value is a
                         *   not a known member.
                         */
                        fun known(): Known =
                            when (this) {
                                NO_EXTRA_CHARGE -> Known.NO_EXTRA_CHARGE
                                GAS -> Known.GAS
                                EXTRA_MILEAGE -> Known.EXTRA_MILEAGE
                                LATE_RETURN -> Known.LATE_RETURN
                                ONE_WAY_SERVICE_FEE -> Known.ONE_WAY_SERVICE_FEE
                                PARKING_VIOLATION -> Known.PARKING_VIOLATION
                                else ->
                                    throw IncreaseInvalidDataException(
                                        "Unknown ExtraCharges: $value"
                                    )
                            }

                        /**
                         * Returns this class instance's primitive wire representation.
                         *
                         * This differs from the [toString] method because that method is primarily
                         * for debugging and generally doesn't throw.
                         *
                         * @throws IncreaseInvalidDataException if this class instance's value does
                         *   not have the expected primitive type.
                         */
                        fun asString(): String =
                            _value().asString().orElseThrow {
                                IncreaseInvalidDataException("Value is not a String")
                            }

                        private var validated: Boolean = false

                        fun validate(): ExtraCharges = apply {
                            if (validated) {
                                return@apply
                            }

                            known()
                            validated = true
                        }

                        fun isValid(): Boolean =
                            try {
                                validate()
                                true
                            } catch (e: IncreaseInvalidDataException) {
                                false
                            }

                        /**
                         * Returns a score indicating how many valid values are contained in this
                         * object recursively.
                         *
                         * Used for best match union deserialization.
                         */
                        @JvmSynthetic
                        internal fun validity(): Int = if (value() == Value._UNKNOWN) 0 else 1

                        override fun equals(other: Any?): Boolean {
                            if (this === other) {
                                return true
                            }

                            return /* spotless:off */ other is ExtraCharges && value == other.value /* spotless:on */
                        }

                        override fun hashCode() = value.hashCode()

                        override fun toString() = value.toString()
                    }

                    /**
                     * An indicator that the cardholder is being billed for a reserved vehicle that
                     * was not actually rented (that is, a "no-show" charge).
                     */
                    class NoShowIndicator
                    @JsonCreator
                    private constructor(private val value: JsonField<String>) : Enum {

                        /**
                         * Returns this class instance's raw value.
                         *
                         * This is usually only useful if this instance was deserialized from data
                         * that doesn't match any known member, and you want to know that value. For
                         * example, if the SDK is on an older version than the API, then the API may
                         * respond with new members that the SDK is unaware of.
                         */
                        @com.fasterxml.jackson.annotation.JsonValue
                        fun _value(): JsonField<String> = value

                        companion object {

                            /** Not applicable */
                            @JvmField val NOT_APPLICABLE = of("not_applicable")

                            /** No show for specialized vehicle */
                            @JvmField
                            val NO_SHOW_FOR_SPECIALIZED_VEHICLE =
                                of("no_show_for_specialized_vehicle")

                            @JvmStatic fun of(value: String) = NoShowIndicator(JsonField.of(value))
                        }

                        /** An enum containing [NoShowIndicator]'s known values. */
                        enum class Known {
                            /** Not applicable */
                            NOT_APPLICABLE,
                            /** No show for specialized vehicle */
                            NO_SHOW_FOR_SPECIALIZED_VEHICLE,
                        }

                        /**
                         * An enum containing [NoShowIndicator]'s known values, as well as an
                         * [_UNKNOWN] member.
                         *
                         * An instance of [NoShowIndicator] can contain an unknown value in a couple
                         * of cases:
                         * - It was deserialized from data that doesn't match any known member. For
                         *   example, if the SDK is on an older version than the API, then the API
                         *   may respond with new members that the SDK is unaware of.
                         * - It was constructed with an arbitrary value using the [of] method.
                         */
                        enum class Value {
                            /** Not applicable */
                            NOT_APPLICABLE,
                            /** No show for specialized vehicle */
                            NO_SHOW_FOR_SPECIALIZED_VEHICLE,
                            /**
                             * An enum member indicating that [NoShowIndicator] was instantiated
                             * with an unknown value.
                             */
                            _UNKNOWN,
                        }

                        /**
                         * Returns an enum member corresponding to this class instance's value, or
                         * [Value._UNKNOWN] if the class was instantiated with an unknown value.
                         *
                         * Use the [known] method instead if you're certain the value is always
                         * known or if you want to throw for the unknown case.
                         */
                        fun value(): Value =
                            when (this) {
                                NOT_APPLICABLE -> Value.NOT_APPLICABLE
                                NO_SHOW_FOR_SPECIALIZED_VEHICLE ->
                                    Value.NO_SHOW_FOR_SPECIALIZED_VEHICLE
                                else -> Value._UNKNOWN
                            }

                        /**
                         * Returns an enum member corresponding to this class instance's value.
                         *
                         * Use the [value] method instead if you're uncertain the value is always
                         * known and don't want to throw for the unknown case.
                         *
                         * @throws IncreaseInvalidDataException if this class instance's value is a
                         *   not a known member.
                         */
                        fun known(): Known =
                            when (this) {
                                NOT_APPLICABLE -> Known.NOT_APPLICABLE
                                NO_SHOW_FOR_SPECIALIZED_VEHICLE ->
                                    Known.NO_SHOW_FOR_SPECIALIZED_VEHICLE
                                else ->
                                    throw IncreaseInvalidDataException(
                                        "Unknown NoShowIndicator: $value"
                                    )
                            }

                        /**
                         * Returns this class instance's primitive wire representation.
                         *
                         * This differs from the [toString] method because that method is primarily
                         * for debugging and generally doesn't throw.
                         *
                         * @throws IncreaseInvalidDataException if this class instance's value does
                         *   not have the expected primitive type.
                         */
                        fun asString(): String =
                            _value().asString().orElseThrow {
                                IncreaseInvalidDataException("Value is not a String")
                            }

                        private var validated: Boolean = false

                        fun validate(): NoShowIndicator = apply {
                            if (validated) {
                                return@apply
                            }

                            known()
                            validated = true
                        }

                        fun isValid(): Boolean =
                            try {
                                validate()
                                true
                            } catch (e: IncreaseInvalidDataException) {
                                false
                            }

                        /**
                         * Returns a score indicating how many valid values are contained in this
                         * object recursively.
                         *
                         * Used for best match union deserialization.
                         */
                        @JvmSynthetic
                        internal fun validity(): Int = if (value() == Value._UNKNOWN) 0 else 1

                        override fun equals(other: Any?): Boolean {
                            if (this === other) {
                                return true
                            }

                            return /* spotless:off */ other is NoShowIndicator && value == other.value /* spotless:on */
                        }

                        override fun hashCode() = value.hashCode()

                        override fun toString() = value.toString()
                    }

                    override fun equals(other: Any?): Boolean {
                        if (this === other) {
                            return true
                        }

                        return /* spotless:off */ other is CarRental && carClassCode == other.carClassCode && checkoutDate == other.checkoutDate && dailyRentalRateAmount == other.dailyRentalRateAmount && dailyRentalRateCurrency == other.dailyRentalRateCurrency && daysRented == other.daysRented && extraCharges == other.extraCharges && fuelChargesAmount == other.fuelChargesAmount && fuelChargesCurrency == other.fuelChargesCurrency && insuranceChargesAmount == other.insuranceChargesAmount && insuranceChargesCurrency == other.insuranceChargesCurrency && noShowIndicator == other.noShowIndicator && oneWayDropOffChargesAmount == other.oneWayDropOffChargesAmount && oneWayDropOffChargesCurrency == other.oneWayDropOffChargesCurrency && renterName == other.renterName && weeklyRentalRateAmount == other.weeklyRentalRateAmount && weeklyRentalRateCurrency == other.weeklyRentalRateCurrency && additionalProperties == other.additionalProperties /* spotless:on */
                    }

                    /* spotless:off */
                    private val hashCode: Int by lazy { Objects.hash(carClassCode, checkoutDate, dailyRentalRateAmount, dailyRentalRateCurrency, daysRented, extraCharges, fuelChargesAmount, fuelChargesCurrency, insuranceChargesAmount, insuranceChargesCurrency, noShowIndicator, oneWayDropOffChargesAmount, oneWayDropOffChargesCurrency, renterName, weeklyRentalRateAmount, weeklyRentalRateCurrency, additionalProperties) }
                    /* spotless:on */

                    override fun hashCode(): Int = hashCode

                    override fun toString() =
                        "CarRental{carClassCode=$carClassCode, checkoutDate=$checkoutDate, dailyRentalRateAmount=$dailyRentalRateAmount, dailyRentalRateCurrency=$dailyRentalRateCurrency, daysRented=$daysRented, extraCharges=$extraCharges, fuelChargesAmount=$fuelChargesAmount, fuelChargesCurrency=$fuelChargesCurrency, insuranceChargesAmount=$insuranceChargesAmount, insuranceChargesCurrency=$insuranceChargesCurrency, noShowIndicator=$noShowIndicator, oneWayDropOffChargesAmount=$oneWayDropOffChargesAmount, oneWayDropOffChargesCurrency=$oneWayDropOffChargesCurrency, renterName=$renterName, weeklyRentalRateAmount=$weeklyRentalRateAmount, weeklyRentalRateCurrency=$weeklyRentalRateCurrency, additionalProperties=$additionalProperties}"
                }

                /** Fields specific to lodging. */
                class Lodging
                private constructor(
                    private val checkInDate: JsonField<LocalDate>,
                    private val dailyRoomRateAmount: JsonField<Long>,
                    private val dailyRoomRateCurrency: JsonField<String>,
                    private val extraCharges: JsonField<ExtraCharges>,
                    private val folioCashAdvancesAmount: JsonField<Long>,
                    private val folioCashAdvancesCurrency: JsonField<String>,
                    private val foodBeverageChargesAmount: JsonField<Long>,
                    private val foodBeverageChargesCurrency: JsonField<String>,
                    private val noShowIndicator: JsonField<NoShowIndicator>,
                    private val prepaidExpensesAmount: JsonField<Long>,
                    private val prepaidExpensesCurrency: JsonField<String>,
                    private val roomNights: JsonField<Long>,
                    private val totalRoomTaxAmount: JsonField<Long>,
                    private val totalRoomTaxCurrency: JsonField<String>,
                    private val totalTaxAmount: JsonField<Long>,
                    private val totalTaxCurrency: JsonField<String>,
                    private val additionalProperties: MutableMap<String, JsonValue>,
                ) {

                    @JsonCreator
                    private constructor(
                        @JsonProperty("check_in_date")
                        @ExcludeMissing
                        checkInDate: JsonField<LocalDate> = JsonMissing.of(),
                        @JsonProperty("daily_room_rate_amount")
                        @ExcludeMissing
                        dailyRoomRateAmount: JsonField<Long> = JsonMissing.of(),
                        @JsonProperty("daily_room_rate_currency")
                        @ExcludeMissing
                        dailyRoomRateCurrency: JsonField<String> = JsonMissing.of(),
                        @JsonProperty("extra_charges")
                        @ExcludeMissing
                        extraCharges: JsonField<ExtraCharges> = JsonMissing.of(),
                        @JsonProperty("folio_cash_advances_amount")
                        @ExcludeMissing
                        folioCashAdvancesAmount: JsonField<Long> = JsonMissing.of(),
                        @JsonProperty("folio_cash_advances_currency")
                        @ExcludeMissing
                        folioCashAdvancesCurrency: JsonField<String> = JsonMissing.of(),
                        @JsonProperty("food_beverage_charges_amount")
                        @ExcludeMissing
                        foodBeverageChargesAmount: JsonField<Long> = JsonMissing.of(),
                        @JsonProperty("food_beverage_charges_currency")
                        @ExcludeMissing
                        foodBeverageChargesCurrency: JsonField<String> = JsonMissing.of(),
                        @JsonProperty("no_show_indicator")
                        @ExcludeMissing
                        noShowIndicator: JsonField<NoShowIndicator> = JsonMissing.of(),
                        @JsonProperty("prepaid_expenses_amount")
                        @ExcludeMissing
                        prepaidExpensesAmount: JsonField<Long> = JsonMissing.of(),
                        @JsonProperty("prepaid_expenses_currency")
                        @ExcludeMissing
                        prepaidExpensesCurrency: JsonField<String> = JsonMissing.of(),
                        @JsonProperty("room_nights")
                        @ExcludeMissing
                        roomNights: JsonField<Long> = JsonMissing.of(),
                        @JsonProperty("total_room_tax_amount")
                        @ExcludeMissing
                        totalRoomTaxAmount: JsonField<Long> = JsonMissing.of(),
                        @JsonProperty("total_room_tax_currency")
                        @ExcludeMissing
                        totalRoomTaxCurrency: JsonField<String> = JsonMissing.of(),
                        @JsonProperty("total_tax_amount")
                        @ExcludeMissing
                        totalTaxAmount: JsonField<Long> = JsonMissing.of(),
                        @JsonProperty("total_tax_currency")
                        @ExcludeMissing
                        totalTaxCurrency: JsonField<String> = JsonMissing.of(),
                    ) : this(
                        checkInDate,
                        dailyRoomRateAmount,
                        dailyRoomRateCurrency,
                        extraCharges,
                        folioCashAdvancesAmount,
                        folioCashAdvancesCurrency,
                        foodBeverageChargesAmount,
                        foodBeverageChargesCurrency,
                        noShowIndicator,
                        prepaidExpensesAmount,
                        prepaidExpensesCurrency,
                        roomNights,
                        totalRoomTaxAmount,
                        totalRoomTaxCurrency,
                        totalTaxAmount,
                        totalTaxCurrency,
                        mutableMapOf(),
                    )

                    /**
                     * Date the customer checked in.
                     *
                     * @throws IncreaseInvalidDataException if the JSON field has an unexpected type
                     *   (e.g. if the server responded with an unexpected value).
                     */
                    fun checkInDate(): Optional<LocalDate> =
                        checkInDate.getOptional("check_in_date")

                    /**
                     * Daily rate being charged for the room.
                     *
                     * @throws IncreaseInvalidDataException if the JSON field has an unexpected type
                     *   (e.g. if the server responded with an unexpected value).
                     */
                    fun dailyRoomRateAmount(): Optional<Long> =
                        dailyRoomRateAmount.getOptional("daily_room_rate_amount")

                    /**
                     * The [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) code for the daily
                     * room rate.
                     *
                     * @throws IncreaseInvalidDataException if the JSON field has an unexpected type
                     *   (e.g. if the server responded with an unexpected value).
                     */
                    fun dailyRoomRateCurrency(): Optional<String> =
                        dailyRoomRateCurrency.getOptional("daily_room_rate_currency")

                    /**
                     * Additional charges (phone, late check-out, etc.) being billed.
                     *
                     * @throws IncreaseInvalidDataException if the JSON field has an unexpected type
                     *   (e.g. if the server responded with an unexpected value).
                     */
                    fun extraCharges(): Optional<ExtraCharges> =
                        extraCharges.getOptional("extra_charges")

                    /**
                     * Folio cash advances for the room.
                     *
                     * @throws IncreaseInvalidDataException if the JSON field has an unexpected type
                     *   (e.g. if the server responded with an unexpected value).
                     */
                    fun folioCashAdvancesAmount(): Optional<Long> =
                        folioCashAdvancesAmount.getOptional("folio_cash_advances_amount")

                    /**
                     * The [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) code for the folio
                     * cash advances.
                     *
                     * @throws IncreaseInvalidDataException if the JSON field has an unexpected type
                     *   (e.g. if the server responded with an unexpected value).
                     */
                    fun folioCashAdvancesCurrency(): Optional<String> =
                        folioCashAdvancesCurrency.getOptional("folio_cash_advances_currency")

                    /**
                     * Food and beverage charges for the room.
                     *
                     * @throws IncreaseInvalidDataException if the JSON field has an unexpected type
                     *   (e.g. if the server responded with an unexpected value).
                     */
                    fun foodBeverageChargesAmount(): Optional<Long> =
                        foodBeverageChargesAmount.getOptional("food_beverage_charges_amount")

                    /**
                     * The [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) code for the food and
                     * beverage charges.
                     *
                     * @throws IncreaseInvalidDataException if the JSON field has an unexpected type
                     *   (e.g. if the server responded with an unexpected value).
                     */
                    fun foodBeverageChargesCurrency(): Optional<String> =
                        foodBeverageChargesCurrency.getOptional("food_beverage_charges_currency")

                    /**
                     * Indicator that the cardholder is being billed for a reserved room that was
                     * not actually used.
                     *
                     * @throws IncreaseInvalidDataException if the JSON field has an unexpected type
                     *   (e.g. if the server responded with an unexpected value).
                     */
                    fun noShowIndicator(): Optional<NoShowIndicator> =
                        noShowIndicator.getOptional("no_show_indicator")

                    /**
                     * Prepaid expenses being charged for the room.
                     *
                     * @throws IncreaseInvalidDataException if the JSON field has an unexpected type
                     *   (e.g. if the server responded with an unexpected value).
                     */
                    fun prepaidExpensesAmount(): Optional<Long> =
                        prepaidExpensesAmount.getOptional("prepaid_expenses_amount")

                    /**
                     * The [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) code for the prepaid
                     * expenses.
                     *
                     * @throws IncreaseInvalidDataException if the JSON field has an unexpected type
                     *   (e.g. if the server responded with an unexpected value).
                     */
                    fun prepaidExpensesCurrency(): Optional<String> =
                        prepaidExpensesCurrency.getOptional("prepaid_expenses_currency")

                    /**
                     * Number of nights the room was rented.
                     *
                     * @throws IncreaseInvalidDataException if the JSON field has an unexpected type
                     *   (e.g. if the server responded with an unexpected value).
                     */
                    fun roomNights(): Optional<Long> = roomNights.getOptional("room_nights")

                    /**
                     * Total room tax being charged.
                     *
                     * @throws IncreaseInvalidDataException if the JSON field has an unexpected type
                     *   (e.g. if the server responded with an unexpected value).
                     */
                    fun totalRoomTaxAmount(): Optional<Long> =
                        totalRoomTaxAmount.getOptional("total_room_tax_amount")

                    /**
                     * The [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) code for the total
                     * room tax.
                     *
                     * @throws IncreaseInvalidDataException if the JSON field has an unexpected type
                     *   (e.g. if the server responded with an unexpected value).
                     */
                    fun totalRoomTaxCurrency(): Optional<String> =
                        totalRoomTaxCurrency.getOptional("total_room_tax_currency")

                    /**
                     * Total tax being charged for the room.
                     *
                     * @throws IncreaseInvalidDataException if the JSON field has an unexpected type
                     *   (e.g. if the server responded with an unexpected value).
                     */
                    fun totalTaxAmount(): Optional<Long> =
                        totalTaxAmount.getOptional("total_tax_amount")

                    /**
                     * The [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) code for the total tax
                     * assessed.
                     *
                     * @throws IncreaseInvalidDataException if the JSON field has an unexpected type
                     *   (e.g. if the server responded with an unexpected value).
                     */
                    fun totalTaxCurrency(): Optional<String> =
                        totalTaxCurrency.getOptional("total_tax_currency")

                    /**
                     * Returns the raw JSON value of [checkInDate].
                     *
                     * Unlike [checkInDate], this method doesn't throw if the JSON field has an
                     * unexpected type.
                     */
                    @JsonProperty("check_in_date")
                    @ExcludeMissing
                    fun _checkInDate(): JsonField<LocalDate> = checkInDate

                    /**
                     * Returns the raw JSON value of [dailyRoomRateAmount].
                     *
                     * Unlike [dailyRoomRateAmount], this method doesn't throw if the JSON field has
                     * an unexpected type.
                     */
                    @JsonProperty("daily_room_rate_amount")
                    @ExcludeMissing
                    fun _dailyRoomRateAmount(): JsonField<Long> = dailyRoomRateAmount

                    /**
                     * Returns the raw JSON value of [dailyRoomRateCurrency].
                     *
                     * Unlike [dailyRoomRateCurrency], this method doesn't throw if the JSON field
                     * has an unexpected type.
                     */
                    @JsonProperty("daily_room_rate_currency")
                    @ExcludeMissing
                    fun _dailyRoomRateCurrency(): JsonField<String> = dailyRoomRateCurrency

                    /**
                     * Returns the raw JSON value of [extraCharges].
                     *
                     * Unlike [extraCharges], this method doesn't throw if the JSON field has an
                     * unexpected type.
                     */
                    @JsonProperty("extra_charges")
                    @ExcludeMissing
                    fun _extraCharges(): JsonField<ExtraCharges> = extraCharges

                    /**
                     * Returns the raw JSON value of [folioCashAdvancesAmount].
                     *
                     * Unlike [folioCashAdvancesAmount], this method doesn't throw if the JSON field
                     * has an unexpected type.
                     */
                    @JsonProperty("folio_cash_advances_amount")
                    @ExcludeMissing
                    fun _folioCashAdvancesAmount(): JsonField<Long> = folioCashAdvancesAmount

                    /**
                     * Returns the raw JSON value of [folioCashAdvancesCurrency].
                     *
                     * Unlike [folioCashAdvancesCurrency], this method doesn't throw if the JSON
                     * field has an unexpected type.
                     */
                    @JsonProperty("folio_cash_advances_currency")
                    @ExcludeMissing
                    fun _folioCashAdvancesCurrency(): JsonField<String> = folioCashAdvancesCurrency

                    /**
                     * Returns the raw JSON value of [foodBeverageChargesAmount].
                     *
                     * Unlike [foodBeverageChargesAmount], this method doesn't throw if the JSON
                     * field has an unexpected type.
                     */
                    @JsonProperty("food_beverage_charges_amount")
                    @ExcludeMissing
                    fun _foodBeverageChargesAmount(): JsonField<Long> = foodBeverageChargesAmount

                    /**
                     * Returns the raw JSON value of [foodBeverageChargesCurrency].
                     *
                     * Unlike [foodBeverageChargesCurrency], this method doesn't throw if the JSON
                     * field has an unexpected type.
                     */
                    @JsonProperty("food_beverage_charges_currency")
                    @ExcludeMissing
                    fun _foodBeverageChargesCurrency(): JsonField<String> =
                        foodBeverageChargesCurrency

                    /**
                     * Returns the raw JSON value of [noShowIndicator].
                     *
                     * Unlike [noShowIndicator], this method doesn't throw if the JSON field has an
                     * unexpected type.
                     */
                    @JsonProperty("no_show_indicator")
                    @ExcludeMissing
                    fun _noShowIndicator(): JsonField<NoShowIndicator> = noShowIndicator

                    /**
                     * Returns the raw JSON value of [prepaidExpensesAmount].
                     *
                     * Unlike [prepaidExpensesAmount], this method doesn't throw if the JSON field
                     * has an unexpected type.
                     */
                    @JsonProperty("prepaid_expenses_amount")
                    @ExcludeMissing
                    fun _prepaidExpensesAmount(): JsonField<Long> = prepaidExpensesAmount

                    /**
                     * Returns the raw JSON value of [prepaidExpensesCurrency].
                     *
                     * Unlike [prepaidExpensesCurrency], this method doesn't throw if the JSON field
                     * has an unexpected type.
                     */
                    @JsonProperty("prepaid_expenses_currency")
                    @ExcludeMissing
                    fun _prepaidExpensesCurrency(): JsonField<String> = prepaidExpensesCurrency

                    /**
                     * Returns the raw JSON value of [roomNights].
                     *
                     * Unlike [roomNights], this method doesn't throw if the JSON field has an
                     * unexpected type.
                     */
                    @JsonProperty("room_nights")
                    @ExcludeMissing
                    fun _roomNights(): JsonField<Long> = roomNights

                    /**
                     * Returns the raw JSON value of [totalRoomTaxAmount].
                     *
                     * Unlike [totalRoomTaxAmount], this method doesn't throw if the JSON field has
                     * an unexpected type.
                     */
                    @JsonProperty("total_room_tax_amount")
                    @ExcludeMissing
                    fun _totalRoomTaxAmount(): JsonField<Long> = totalRoomTaxAmount

                    /**
                     * Returns the raw JSON value of [totalRoomTaxCurrency].
                     *
                     * Unlike [totalRoomTaxCurrency], this method doesn't throw if the JSON field
                     * has an unexpected type.
                     */
                    @JsonProperty("total_room_tax_currency")
                    @ExcludeMissing
                    fun _totalRoomTaxCurrency(): JsonField<String> = totalRoomTaxCurrency

                    /**
                     * Returns the raw JSON value of [totalTaxAmount].
                     *
                     * Unlike [totalTaxAmount], this method doesn't throw if the JSON field has an
                     * unexpected type.
                     */
                    @JsonProperty("total_tax_amount")
                    @ExcludeMissing
                    fun _totalTaxAmount(): JsonField<Long> = totalTaxAmount

                    /**
                     * Returns the raw JSON value of [totalTaxCurrency].
                     *
                     * Unlike [totalTaxCurrency], this method doesn't throw if the JSON field has an
                     * unexpected type.
                     */
                    @JsonProperty("total_tax_currency")
                    @ExcludeMissing
                    fun _totalTaxCurrency(): JsonField<String> = totalTaxCurrency

                    @JsonAnySetter
                    private fun putAdditionalProperty(key: String, value: JsonValue) {
                        additionalProperties.put(key, value)
                    }

                    @JsonAnyGetter
                    @ExcludeMissing
                    fun _additionalProperties(): Map<String, JsonValue> =
                        Collections.unmodifiableMap(additionalProperties)

                    fun toBuilder() = Builder().from(this)

                    companion object {

                        /**
                         * Returns a mutable builder for constructing an instance of [Lodging].
                         *
                         * The following fields are required:
                         * ```java
                         * .checkInDate()
                         * .dailyRoomRateAmount()
                         * .dailyRoomRateCurrency()
                         * .extraCharges()
                         * .folioCashAdvancesAmount()
                         * .folioCashAdvancesCurrency()
                         * .foodBeverageChargesAmount()
                         * .foodBeverageChargesCurrency()
                         * .noShowIndicator()
                         * .prepaidExpensesAmount()
                         * .prepaidExpensesCurrency()
                         * .roomNights()
                         * .totalRoomTaxAmount()
                         * .totalRoomTaxCurrency()
                         * .totalTaxAmount()
                         * .totalTaxCurrency()
                         * ```
                         */
                        @JvmStatic fun builder() = Builder()
                    }

                    /** A builder for [Lodging]. */
                    class Builder internal constructor() {

                        private var checkInDate: JsonField<LocalDate>? = null
                        private var dailyRoomRateAmount: JsonField<Long>? = null
                        private var dailyRoomRateCurrency: JsonField<String>? = null
                        private var extraCharges: JsonField<ExtraCharges>? = null
                        private var folioCashAdvancesAmount: JsonField<Long>? = null
                        private var folioCashAdvancesCurrency: JsonField<String>? = null
                        private var foodBeverageChargesAmount: JsonField<Long>? = null
                        private var foodBeverageChargesCurrency: JsonField<String>? = null
                        private var noShowIndicator: JsonField<NoShowIndicator>? = null
                        private var prepaidExpensesAmount: JsonField<Long>? = null
                        private var prepaidExpensesCurrency: JsonField<String>? = null
                        private var roomNights: JsonField<Long>? = null
                        private var totalRoomTaxAmount: JsonField<Long>? = null
                        private var totalRoomTaxCurrency: JsonField<String>? = null
                        private var totalTaxAmount: JsonField<Long>? = null
                        private var totalTaxCurrency: JsonField<String>? = null
                        private var additionalProperties: MutableMap<String, JsonValue> =
                            mutableMapOf()

                        @JvmSynthetic
                        internal fun from(lodging: Lodging) = apply {
                            checkInDate = lodging.checkInDate
                            dailyRoomRateAmount = lodging.dailyRoomRateAmount
                            dailyRoomRateCurrency = lodging.dailyRoomRateCurrency
                            extraCharges = lodging.extraCharges
                            folioCashAdvancesAmount = lodging.folioCashAdvancesAmount
                            folioCashAdvancesCurrency = lodging.folioCashAdvancesCurrency
                            foodBeverageChargesAmount = lodging.foodBeverageChargesAmount
                            foodBeverageChargesCurrency = lodging.foodBeverageChargesCurrency
                            noShowIndicator = lodging.noShowIndicator
                            prepaidExpensesAmount = lodging.prepaidExpensesAmount
                            prepaidExpensesCurrency = lodging.prepaidExpensesCurrency
                            roomNights = lodging.roomNights
                            totalRoomTaxAmount = lodging.totalRoomTaxAmount
                            totalRoomTaxCurrency = lodging.totalRoomTaxCurrency
                            totalTaxAmount = lodging.totalTaxAmount
                            totalTaxCurrency = lodging.totalTaxCurrency
                            additionalProperties = lodging.additionalProperties.toMutableMap()
                        }

                        /** Date the customer checked in. */
                        fun checkInDate(checkInDate: LocalDate?) =
                            checkInDate(JsonField.ofNullable(checkInDate))

                        /**
                         * Alias for calling [Builder.checkInDate] with `checkInDate.orElse(null)`.
                         */
                        fun checkInDate(checkInDate: Optional<LocalDate>) =
                            checkInDate(checkInDate.getOrNull())

                        /**
                         * Sets [Builder.checkInDate] to an arbitrary JSON value.
                         *
                         * You should usually call [Builder.checkInDate] with a well-typed
                         * [LocalDate] value instead. This method is primarily for setting the field
                         * to an undocumented or not yet supported value.
                         */
                        fun checkInDate(checkInDate: JsonField<LocalDate>) = apply {
                            this.checkInDate = checkInDate
                        }

                        /** Daily rate being charged for the room. */
                        fun dailyRoomRateAmount(dailyRoomRateAmount: Long?) =
                            dailyRoomRateAmount(JsonField.ofNullable(dailyRoomRateAmount))

                        /**
                         * Alias for [Builder.dailyRoomRateAmount].
                         *
                         * This unboxed primitive overload exists for backwards compatibility.
                         */
                        fun dailyRoomRateAmount(dailyRoomRateAmount: Long) =
                            dailyRoomRateAmount(dailyRoomRateAmount as Long?)

                        /**
                         * Alias for calling [Builder.dailyRoomRateAmount] with
                         * `dailyRoomRateAmount.orElse(null)`.
                         */
                        fun dailyRoomRateAmount(dailyRoomRateAmount: Optional<Long>) =
                            dailyRoomRateAmount(dailyRoomRateAmount.getOrNull())

                        /**
                         * Sets [Builder.dailyRoomRateAmount] to an arbitrary JSON value.
                         *
                         * You should usually call [Builder.dailyRoomRateAmount] with a well-typed
                         * [Long] value instead. This method is primarily for setting the field to
                         * an undocumented or not yet supported value.
                         */
                        fun dailyRoomRateAmount(dailyRoomRateAmount: JsonField<Long>) = apply {
                            this.dailyRoomRateAmount = dailyRoomRateAmount
                        }

                        /**
                         * The [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) code for the daily
                         * room rate.
                         */
                        fun dailyRoomRateCurrency(dailyRoomRateCurrency: String?) =
                            dailyRoomRateCurrency(JsonField.ofNullable(dailyRoomRateCurrency))

                        /**
                         * Alias for calling [Builder.dailyRoomRateCurrency] with
                         * `dailyRoomRateCurrency.orElse(null)`.
                         */
                        fun dailyRoomRateCurrency(dailyRoomRateCurrency: Optional<String>) =
                            dailyRoomRateCurrency(dailyRoomRateCurrency.getOrNull())

                        /**
                         * Sets [Builder.dailyRoomRateCurrency] to an arbitrary JSON value.
                         *
                         * You should usually call [Builder.dailyRoomRateCurrency] with a well-typed
                         * [String] value instead. This method is primarily for setting the field to
                         * an undocumented or not yet supported value.
                         */
                        fun dailyRoomRateCurrency(dailyRoomRateCurrency: JsonField<String>) =
                            apply {
                                this.dailyRoomRateCurrency = dailyRoomRateCurrency
                            }

                        /** Additional charges (phone, late check-out, etc.) being billed. */
                        fun extraCharges(extraCharges: ExtraCharges?) =
                            extraCharges(JsonField.ofNullable(extraCharges))

                        /**
                         * Alias for calling [Builder.extraCharges] with
                         * `extraCharges.orElse(null)`.
                         */
                        fun extraCharges(extraCharges: Optional<ExtraCharges>) =
                            extraCharges(extraCharges.getOrNull())

                        /**
                         * Sets [Builder.extraCharges] to an arbitrary JSON value.
                         *
                         * You should usually call [Builder.extraCharges] with a well-typed
                         * [ExtraCharges] value instead. This method is primarily for setting the
                         * field to an undocumented or not yet supported value.
                         */
                        fun extraCharges(extraCharges: JsonField<ExtraCharges>) = apply {
                            this.extraCharges = extraCharges
                        }

                        /** Folio cash advances for the room. */
                        fun folioCashAdvancesAmount(folioCashAdvancesAmount: Long?) =
                            folioCashAdvancesAmount(JsonField.ofNullable(folioCashAdvancesAmount))

                        /**
                         * Alias for [Builder.folioCashAdvancesAmount].
                         *
                         * This unboxed primitive overload exists for backwards compatibility.
                         */
                        fun folioCashAdvancesAmount(folioCashAdvancesAmount: Long) =
                            folioCashAdvancesAmount(folioCashAdvancesAmount as Long?)

                        /**
                         * Alias for calling [Builder.folioCashAdvancesAmount] with
                         * `folioCashAdvancesAmount.orElse(null)`.
                         */
                        fun folioCashAdvancesAmount(folioCashAdvancesAmount: Optional<Long>) =
                            folioCashAdvancesAmount(folioCashAdvancesAmount.getOrNull())

                        /**
                         * Sets [Builder.folioCashAdvancesAmount] to an arbitrary JSON value.
                         *
                         * You should usually call [Builder.folioCashAdvancesAmount] with a
                         * well-typed [Long] value instead. This method is primarily for setting the
                         * field to an undocumented or not yet supported value.
                         */
                        fun folioCashAdvancesAmount(folioCashAdvancesAmount: JsonField<Long>) =
                            apply {
                                this.folioCashAdvancesAmount = folioCashAdvancesAmount
                            }

                        /**
                         * The [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) code for the folio
                         * cash advances.
                         */
                        fun folioCashAdvancesCurrency(folioCashAdvancesCurrency: String?) =
                            folioCashAdvancesCurrency(
                                JsonField.ofNullable(folioCashAdvancesCurrency)
                            )

                        /**
                         * Alias for calling [Builder.folioCashAdvancesCurrency] with
                         * `folioCashAdvancesCurrency.orElse(null)`.
                         */
                        fun folioCashAdvancesCurrency(folioCashAdvancesCurrency: Optional<String>) =
                            folioCashAdvancesCurrency(folioCashAdvancesCurrency.getOrNull())

                        /**
                         * Sets [Builder.folioCashAdvancesCurrency] to an arbitrary JSON value.
                         *
                         * You should usually call [Builder.folioCashAdvancesCurrency] with a
                         * well-typed [String] value instead. This method is primarily for setting
                         * the field to an undocumented or not yet supported value.
                         */
                        fun folioCashAdvancesCurrency(
                            folioCashAdvancesCurrency: JsonField<String>
                        ) = apply { this.folioCashAdvancesCurrency = folioCashAdvancesCurrency }

                        /** Food and beverage charges for the room. */
                        fun foodBeverageChargesAmount(foodBeverageChargesAmount: Long?) =
                            foodBeverageChargesAmount(
                                JsonField.ofNullable(foodBeverageChargesAmount)
                            )

                        /**
                         * Alias for [Builder.foodBeverageChargesAmount].
                         *
                         * This unboxed primitive overload exists for backwards compatibility.
                         */
                        fun foodBeverageChargesAmount(foodBeverageChargesAmount: Long) =
                            foodBeverageChargesAmount(foodBeverageChargesAmount as Long?)

                        /**
                         * Alias for calling [Builder.foodBeverageChargesAmount] with
                         * `foodBeverageChargesAmount.orElse(null)`.
                         */
                        fun foodBeverageChargesAmount(foodBeverageChargesAmount: Optional<Long>) =
                            foodBeverageChargesAmount(foodBeverageChargesAmount.getOrNull())

                        /**
                         * Sets [Builder.foodBeverageChargesAmount] to an arbitrary JSON value.
                         *
                         * You should usually call [Builder.foodBeverageChargesAmount] with a
                         * well-typed [Long] value instead. This method is primarily for setting the
                         * field to an undocumented or not yet supported value.
                         */
                        fun foodBeverageChargesAmount(foodBeverageChargesAmount: JsonField<Long>) =
                            apply {
                                this.foodBeverageChargesAmount = foodBeverageChargesAmount
                            }

                        /**
                         * The [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) code for the food
                         * and beverage charges.
                         */
                        fun foodBeverageChargesCurrency(foodBeverageChargesCurrency: String?) =
                            foodBeverageChargesCurrency(
                                JsonField.ofNullable(foodBeverageChargesCurrency)
                            )

                        /**
                         * Alias for calling [Builder.foodBeverageChargesCurrency] with
                         * `foodBeverageChargesCurrency.orElse(null)`.
                         */
                        fun foodBeverageChargesCurrency(
                            foodBeverageChargesCurrency: Optional<String>
                        ) = foodBeverageChargesCurrency(foodBeverageChargesCurrency.getOrNull())

                        /**
                         * Sets [Builder.foodBeverageChargesCurrency] to an arbitrary JSON value.
                         *
                         * You should usually call [Builder.foodBeverageChargesCurrency] with a
                         * well-typed [String] value instead. This method is primarily for setting
                         * the field to an undocumented or not yet supported value.
                         */
                        fun foodBeverageChargesCurrency(
                            foodBeverageChargesCurrency: JsonField<String>
                        ) = apply { this.foodBeverageChargesCurrency = foodBeverageChargesCurrency }

                        /**
                         * Indicator that the cardholder is being billed for a reserved room that
                         * was not actually used.
                         */
                        fun noShowIndicator(noShowIndicator: NoShowIndicator?) =
                            noShowIndicator(JsonField.ofNullable(noShowIndicator))

                        /**
                         * Alias for calling [Builder.noShowIndicator] with
                         * `noShowIndicator.orElse(null)`.
                         */
                        fun noShowIndicator(noShowIndicator: Optional<NoShowIndicator>) =
                            noShowIndicator(noShowIndicator.getOrNull())

                        /**
                         * Sets [Builder.noShowIndicator] to an arbitrary JSON value.
                         *
                         * You should usually call [Builder.noShowIndicator] with a well-typed
                         * [NoShowIndicator] value instead. This method is primarily for setting the
                         * field to an undocumented or not yet supported value.
                         */
                        fun noShowIndicator(noShowIndicator: JsonField<NoShowIndicator>) = apply {
                            this.noShowIndicator = noShowIndicator
                        }

                        /** Prepaid expenses being charged for the room. */
                        fun prepaidExpensesAmount(prepaidExpensesAmount: Long?) =
                            prepaidExpensesAmount(JsonField.ofNullable(prepaidExpensesAmount))

                        /**
                         * Alias for [Builder.prepaidExpensesAmount].
                         *
                         * This unboxed primitive overload exists for backwards compatibility.
                         */
                        fun prepaidExpensesAmount(prepaidExpensesAmount: Long) =
                            prepaidExpensesAmount(prepaidExpensesAmount as Long?)

                        /**
                         * Alias for calling [Builder.prepaidExpensesAmount] with
                         * `prepaidExpensesAmount.orElse(null)`.
                         */
                        fun prepaidExpensesAmount(prepaidExpensesAmount: Optional<Long>) =
                            prepaidExpensesAmount(prepaidExpensesAmount.getOrNull())

                        /**
                         * Sets [Builder.prepaidExpensesAmount] to an arbitrary JSON value.
                         *
                         * You should usually call [Builder.prepaidExpensesAmount] with a well-typed
                         * [Long] value instead. This method is primarily for setting the field to
                         * an undocumented or not yet supported value.
                         */
                        fun prepaidExpensesAmount(prepaidExpensesAmount: JsonField<Long>) = apply {
                            this.prepaidExpensesAmount = prepaidExpensesAmount
                        }

                        /**
                         * The [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) code for the
                         * prepaid expenses.
                         */
                        fun prepaidExpensesCurrency(prepaidExpensesCurrency: String?) =
                            prepaidExpensesCurrency(JsonField.ofNullable(prepaidExpensesCurrency))

                        /**
                         * Alias for calling [Builder.prepaidExpensesCurrency] with
                         * `prepaidExpensesCurrency.orElse(null)`.
                         */
                        fun prepaidExpensesCurrency(prepaidExpensesCurrency: Optional<String>) =
                            prepaidExpensesCurrency(prepaidExpensesCurrency.getOrNull())

                        /**
                         * Sets [Builder.prepaidExpensesCurrency] to an arbitrary JSON value.
                         *
                         * You should usually call [Builder.prepaidExpensesCurrency] with a
                         * well-typed [String] value instead. This method is primarily for setting
                         * the field to an undocumented or not yet supported value.
                         */
                        fun prepaidExpensesCurrency(prepaidExpensesCurrency: JsonField<String>) =
                            apply {
                                this.prepaidExpensesCurrency = prepaidExpensesCurrency
                            }

                        /** Number of nights the room was rented. */
                        fun roomNights(roomNights: Long?) =
                            roomNights(JsonField.ofNullable(roomNights))

                        /**
                         * Alias for [Builder.roomNights].
                         *
                         * This unboxed primitive overload exists for backwards compatibility.
                         */
                        fun roomNights(roomNights: Long) = roomNights(roomNights as Long?)

                        /**
                         * Alias for calling [Builder.roomNights] with `roomNights.orElse(null)`.
                         */
                        fun roomNights(roomNights: Optional<Long>) =
                            roomNights(roomNights.getOrNull())

                        /**
                         * Sets [Builder.roomNights] to an arbitrary JSON value.
                         *
                         * You should usually call [Builder.roomNights] with a well-typed [Long]
                         * value instead. This method is primarily for setting the field to an
                         * undocumented or not yet supported value.
                         */
                        fun roomNights(roomNights: JsonField<Long>) = apply {
                            this.roomNights = roomNights
                        }

                        /** Total room tax being charged. */
                        fun totalRoomTaxAmount(totalRoomTaxAmount: Long?) =
                            totalRoomTaxAmount(JsonField.ofNullable(totalRoomTaxAmount))

                        /**
                         * Alias for [Builder.totalRoomTaxAmount].
                         *
                         * This unboxed primitive overload exists for backwards compatibility.
                         */
                        fun totalRoomTaxAmount(totalRoomTaxAmount: Long) =
                            totalRoomTaxAmount(totalRoomTaxAmount as Long?)

                        /**
                         * Alias for calling [Builder.totalRoomTaxAmount] with
                         * `totalRoomTaxAmount.orElse(null)`.
                         */
                        fun totalRoomTaxAmount(totalRoomTaxAmount: Optional<Long>) =
                            totalRoomTaxAmount(totalRoomTaxAmount.getOrNull())

                        /**
                         * Sets [Builder.totalRoomTaxAmount] to an arbitrary JSON value.
                         *
                         * You should usually call [Builder.totalRoomTaxAmount] with a well-typed
                         * [Long] value instead. This method is primarily for setting the field to
                         * an undocumented or not yet supported value.
                         */
                        fun totalRoomTaxAmount(totalRoomTaxAmount: JsonField<Long>) = apply {
                            this.totalRoomTaxAmount = totalRoomTaxAmount
                        }

                        /**
                         * The [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) code for the total
                         * room tax.
                         */
                        fun totalRoomTaxCurrency(totalRoomTaxCurrency: String?) =
                            totalRoomTaxCurrency(JsonField.ofNullable(totalRoomTaxCurrency))

                        /**
                         * Alias for calling [Builder.totalRoomTaxCurrency] with
                         * `totalRoomTaxCurrency.orElse(null)`.
                         */
                        fun totalRoomTaxCurrency(totalRoomTaxCurrency: Optional<String>) =
                            totalRoomTaxCurrency(totalRoomTaxCurrency.getOrNull())

                        /**
                         * Sets [Builder.totalRoomTaxCurrency] to an arbitrary JSON value.
                         *
                         * You should usually call [Builder.totalRoomTaxCurrency] with a well-typed
                         * [String] value instead. This method is primarily for setting the field to
                         * an undocumented or not yet supported value.
                         */
                        fun totalRoomTaxCurrency(totalRoomTaxCurrency: JsonField<String>) = apply {
                            this.totalRoomTaxCurrency = totalRoomTaxCurrency
                        }

                        /** Total tax being charged for the room. */
                        fun totalTaxAmount(totalTaxAmount: Long?) =
                            totalTaxAmount(JsonField.ofNullable(totalTaxAmount))

                        /**
                         * Alias for [Builder.totalTaxAmount].
                         *
                         * This unboxed primitive overload exists for backwards compatibility.
                         */
                        fun totalTaxAmount(totalTaxAmount: Long) =
                            totalTaxAmount(totalTaxAmount as Long?)

                        /**
                         * Alias for calling [Builder.totalTaxAmount] with
                         * `totalTaxAmount.orElse(null)`.
                         */
                        fun totalTaxAmount(totalTaxAmount: Optional<Long>) =
                            totalTaxAmount(totalTaxAmount.getOrNull())

                        /**
                         * Sets [Builder.totalTaxAmount] to an arbitrary JSON value.
                         *
                         * You should usually call [Builder.totalTaxAmount] with a well-typed [Long]
                         * value instead. This method is primarily for setting the field to an
                         * undocumented or not yet supported value.
                         */
                        fun totalTaxAmount(totalTaxAmount: JsonField<Long>) = apply {
                            this.totalTaxAmount = totalTaxAmount
                        }

                        /**
                         * The [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) code for the total
                         * tax assessed.
                         */
                        fun totalTaxCurrency(totalTaxCurrency: String?) =
                            totalTaxCurrency(JsonField.ofNullable(totalTaxCurrency))

                        /**
                         * Alias for calling [Builder.totalTaxCurrency] with
                         * `totalTaxCurrency.orElse(null)`.
                         */
                        fun totalTaxCurrency(totalTaxCurrency: Optional<String>) =
                            totalTaxCurrency(totalTaxCurrency.getOrNull())

                        /**
                         * Sets [Builder.totalTaxCurrency] to an arbitrary JSON value.
                         *
                         * You should usually call [Builder.totalTaxCurrency] with a well-typed
                         * [String] value instead. This method is primarily for setting the field to
                         * an undocumented or not yet supported value.
                         */
                        fun totalTaxCurrency(totalTaxCurrency: JsonField<String>) = apply {
                            this.totalTaxCurrency = totalTaxCurrency
                        }

                        fun additionalProperties(additionalProperties: Map<String, JsonValue>) =
                            apply {
                                this.additionalProperties.clear()
                                putAllAdditionalProperties(additionalProperties)
                            }

                        fun putAdditionalProperty(key: String, value: JsonValue) = apply {
                            additionalProperties.put(key, value)
                        }

                        fun putAllAdditionalProperties(
                            additionalProperties: Map<String, JsonValue>
                        ) = apply { this.additionalProperties.putAll(additionalProperties) }

                        fun removeAdditionalProperty(key: String) = apply {
                            additionalProperties.remove(key)
                        }

                        fun removeAllAdditionalProperties(keys: Set<String>) = apply {
                            keys.forEach(::removeAdditionalProperty)
                        }

                        /**
                         * Returns an immutable instance of [Lodging].
                         *
                         * Further updates to this [Builder] will not mutate the returned instance.
                         *
                         * The following fields are required:
                         * ```java
                         * .checkInDate()
                         * .dailyRoomRateAmount()
                         * .dailyRoomRateCurrency()
                         * .extraCharges()
                         * .folioCashAdvancesAmount()
                         * .folioCashAdvancesCurrency()
                         * .foodBeverageChargesAmount()
                         * .foodBeverageChargesCurrency()
                         * .noShowIndicator()
                         * .prepaidExpensesAmount()
                         * .prepaidExpensesCurrency()
                         * .roomNights()
                         * .totalRoomTaxAmount()
                         * .totalRoomTaxCurrency()
                         * .totalTaxAmount()
                         * .totalTaxCurrency()
                         * ```
                         *
                         * @throws IllegalStateException if any required field is unset.
                         */
                        fun build(): Lodging =
                            Lodging(
                                checkRequired("checkInDate", checkInDate),
                                checkRequired("dailyRoomRateAmount", dailyRoomRateAmount),
                                checkRequired("dailyRoomRateCurrency", dailyRoomRateCurrency),
                                checkRequired("extraCharges", extraCharges),
                                checkRequired("folioCashAdvancesAmount", folioCashAdvancesAmount),
                                checkRequired(
                                    "folioCashAdvancesCurrency",
                                    folioCashAdvancesCurrency,
                                ),
                                checkRequired(
                                    "foodBeverageChargesAmount",
                                    foodBeverageChargesAmount,
                                ),
                                checkRequired(
                                    "foodBeverageChargesCurrency",
                                    foodBeverageChargesCurrency,
                                ),
                                checkRequired("noShowIndicator", noShowIndicator),
                                checkRequired("prepaidExpensesAmount", prepaidExpensesAmount),
                                checkRequired("prepaidExpensesCurrency", prepaidExpensesCurrency),
                                checkRequired("roomNights", roomNights),
                                checkRequired("totalRoomTaxAmount", totalRoomTaxAmount),
                                checkRequired("totalRoomTaxCurrency", totalRoomTaxCurrency),
                                checkRequired("totalTaxAmount", totalTaxAmount),
                                checkRequired("totalTaxCurrency", totalTaxCurrency),
                                additionalProperties.toMutableMap(),
                            )
                    }

                    private var validated: Boolean = false

                    fun validate(): Lodging = apply {
                        if (validated) {
                            return@apply
                        }

                        checkInDate()
                        dailyRoomRateAmount()
                        dailyRoomRateCurrency()
                        extraCharges().ifPresent { it.validate() }
                        folioCashAdvancesAmount()
                        folioCashAdvancesCurrency()
                        foodBeverageChargesAmount()
                        foodBeverageChargesCurrency()
                        noShowIndicator().ifPresent { it.validate() }
                        prepaidExpensesAmount()
                        prepaidExpensesCurrency()
                        roomNights()
                        totalRoomTaxAmount()
                        totalRoomTaxCurrency()
                        totalTaxAmount()
                        totalTaxCurrency()
                        validated = true
                    }

                    fun isValid(): Boolean =
                        try {
                            validate()
                            true
                        } catch (e: IncreaseInvalidDataException) {
                            false
                        }

                    /**
                     * Returns a score indicating how many valid values are contained in this object
                     * recursively.
                     *
                     * Used for best match union deserialization.
                     */
                    @JvmSynthetic
                    internal fun validity(): Int =
                        (if (checkInDate.asKnown().isPresent) 1 else 0) +
                            (if (dailyRoomRateAmount.asKnown().isPresent) 1 else 0) +
                            (if (dailyRoomRateCurrency.asKnown().isPresent) 1 else 0) +
                            (extraCharges.asKnown().getOrNull()?.validity() ?: 0) +
                            (if (folioCashAdvancesAmount.asKnown().isPresent) 1 else 0) +
                            (if (folioCashAdvancesCurrency.asKnown().isPresent) 1 else 0) +
                            (if (foodBeverageChargesAmount.asKnown().isPresent) 1 else 0) +
                            (if (foodBeverageChargesCurrency.asKnown().isPresent) 1 else 0) +
                            (noShowIndicator.asKnown().getOrNull()?.validity() ?: 0) +
                            (if (prepaidExpensesAmount.asKnown().isPresent) 1 else 0) +
                            (if (prepaidExpensesCurrency.asKnown().isPresent) 1 else 0) +
                            (if (roomNights.asKnown().isPresent) 1 else 0) +
                            (if (totalRoomTaxAmount.asKnown().isPresent) 1 else 0) +
                            (if (totalRoomTaxCurrency.asKnown().isPresent) 1 else 0) +
                            (if (totalTaxAmount.asKnown().isPresent) 1 else 0) +
                            (if (totalTaxCurrency.asKnown().isPresent) 1 else 0)

                    /** Additional charges (phone, late check-out, etc.) being billed. */
                    class ExtraCharges
                    @JsonCreator
                    private constructor(private val value: JsonField<String>) : Enum {

                        /**
                         * Returns this class instance's raw value.
                         *
                         * This is usually only useful if this instance was deserialized from data
                         * that doesn't match any known member, and you want to know that value. For
                         * example, if the SDK is on an older version than the API, then the API may
                         * respond with new members that the SDK is unaware of.
                         */
                        @com.fasterxml.jackson.annotation.JsonValue
                        fun _value(): JsonField<String> = value

                        companion object {

                            /** No extra charge */
                            @JvmField val NO_EXTRA_CHARGE = of("no_extra_charge")

                            /** Restaurant */
                            @JvmField val RESTAURANT = of("restaurant")

                            /** Gift shop */
                            @JvmField val GIFT_SHOP = of("gift_shop")

                            /** Mini bar */
                            @JvmField val MINI_BAR = of("mini_bar")

                            /** Telephone */
                            @JvmField val TELEPHONE = of("telephone")

                            /** Other */
                            @JvmField val OTHER = of("other")

                            /** Laundry */
                            @JvmField val LAUNDRY = of("laundry")

                            @JvmStatic fun of(value: String) = ExtraCharges(JsonField.of(value))
                        }

                        /** An enum containing [ExtraCharges]'s known values. */
                        enum class Known {
                            /** No extra charge */
                            NO_EXTRA_CHARGE,
                            /** Restaurant */
                            RESTAURANT,
                            /** Gift shop */
                            GIFT_SHOP,
                            /** Mini bar */
                            MINI_BAR,
                            /** Telephone */
                            TELEPHONE,
                            /** Other */
                            OTHER,
                            /** Laundry */
                            LAUNDRY,
                        }

                        /**
                         * An enum containing [ExtraCharges]'s known values, as well as an
                         * [_UNKNOWN] member.
                         *
                         * An instance of [ExtraCharges] can contain an unknown value in a couple of
                         * cases:
                         * - It was deserialized from data that doesn't match any known member. For
                         *   example, if the SDK is on an older version than the API, then the API
                         *   may respond with new members that the SDK is unaware of.
                         * - It was constructed with an arbitrary value using the [of] method.
                         */
                        enum class Value {
                            /** No extra charge */
                            NO_EXTRA_CHARGE,
                            /** Restaurant */
                            RESTAURANT,
                            /** Gift shop */
                            GIFT_SHOP,
                            /** Mini bar */
                            MINI_BAR,
                            /** Telephone */
                            TELEPHONE,
                            /** Other */
                            OTHER,
                            /** Laundry */
                            LAUNDRY,
                            /**
                             * An enum member indicating that [ExtraCharges] was instantiated with
                             * an unknown value.
                             */
                            _UNKNOWN,
                        }

                        /**
                         * Returns an enum member corresponding to this class instance's value, or
                         * [Value._UNKNOWN] if the class was instantiated with an unknown value.
                         *
                         * Use the [known] method instead if you're certain the value is always
                         * known or if you want to throw for the unknown case.
                         */
                        fun value(): Value =
                            when (this) {
                                NO_EXTRA_CHARGE -> Value.NO_EXTRA_CHARGE
                                RESTAURANT -> Value.RESTAURANT
                                GIFT_SHOP -> Value.GIFT_SHOP
                                MINI_BAR -> Value.MINI_BAR
                                TELEPHONE -> Value.TELEPHONE
                                OTHER -> Value.OTHER
                                LAUNDRY -> Value.LAUNDRY
                                else -> Value._UNKNOWN
                            }

                        /**
                         * Returns an enum member corresponding to this class instance's value.
                         *
                         * Use the [value] method instead if you're uncertain the value is always
                         * known and don't want to throw for the unknown case.
                         *
                         * @throws IncreaseInvalidDataException if this class instance's value is a
                         *   not a known member.
                         */
                        fun known(): Known =
                            when (this) {
                                NO_EXTRA_CHARGE -> Known.NO_EXTRA_CHARGE
                                RESTAURANT -> Known.RESTAURANT
                                GIFT_SHOP -> Known.GIFT_SHOP
                                MINI_BAR -> Known.MINI_BAR
                                TELEPHONE -> Known.TELEPHONE
                                OTHER -> Known.OTHER
                                LAUNDRY -> Known.LAUNDRY
                                else ->
                                    throw IncreaseInvalidDataException(
                                        "Unknown ExtraCharges: $value"
                                    )
                            }

                        /**
                         * Returns this class instance's primitive wire representation.
                         *
                         * This differs from the [toString] method because that method is primarily
                         * for debugging and generally doesn't throw.
                         *
                         * @throws IncreaseInvalidDataException if this class instance's value does
                         *   not have the expected primitive type.
                         */
                        fun asString(): String =
                            _value().asString().orElseThrow {
                                IncreaseInvalidDataException("Value is not a String")
                            }

                        private var validated: Boolean = false

                        fun validate(): ExtraCharges = apply {
                            if (validated) {
                                return@apply
                            }

                            known()
                            validated = true
                        }

                        fun isValid(): Boolean =
                            try {
                                validate()
                                true
                            } catch (e: IncreaseInvalidDataException) {
                                false
                            }

                        /**
                         * Returns a score indicating how many valid values are contained in this
                         * object recursively.
                         *
                         * Used for best match union deserialization.
                         */
                        @JvmSynthetic
                        internal fun validity(): Int = if (value() == Value._UNKNOWN) 0 else 1

                        override fun equals(other: Any?): Boolean {
                            if (this === other) {
                                return true
                            }

                            return /* spotless:off */ other is ExtraCharges && value == other.value /* spotless:on */
                        }

                        override fun hashCode() = value.hashCode()

                        override fun toString() = value.toString()
                    }

                    /**
                     * Indicator that the cardholder is being billed for a reserved room that was
                     * not actually used.
                     */
                    class NoShowIndicator
                    @JsonCreator
                    private constructor(private val value: JsonField<String>) : Enum {

                        /**
                         * Returns this class instance's raw value.
                         *
                         * This is usually only useful if this instance was deserialized from data
                         * that doesn't match any known member, and you want to know that value. For
                         * example, if the SDK is on an older version than the API, then the API may
                         * respond with new members that the SDK is unaware of.
                         */
                        @com.fasterxml.jackson.annotation.JsonValue
                        fun _value(): JsonField<String> = value

                        companion object {

                            /** Not applicable */
                            @JvmField val NOT_APPLICABLE = of("not_applicable")

                            /** No show */
                            @JvmField val NO_SHOW = of("no_show")

                            @JvmStatic fun of(value: String) = NoShowIndicator(JsonField.of(value))
                        }

                        /** An enum containing [NoShowIndicator]'s known values. */
                        enum class Known {
                            /** Not applicable */
                            NOT_APPLICABLE,
                            /** No show */
                            NO_SHOW,
                        }

                        /**
                         * An enum containing [NoShowIndicator]'s known values, as well as an
                         * [_UNKNOWN] member.
                         *
                         * An instance of [NoShowIndicator] can contain an unknown value in a couple
                         * of cases:
                         * - It was deserialized from data that doesn't match any known member. For
                         *   example, if the SDK is on an older version than the API, then the API
                         *   may respond with new members that the SDK is unaware of.
                         * - It was constructed with an arbitrary value using the [of] method.
                         */
                        enum class Value {
                            /** Not applicable */
                            NOT_APPLICABLE,
                            /** No show */
                            NO_SHOW,
                            /**
                             * An enum member indicating that [NoShowIndicator] was instantiated
                             * with an unknown value.
                             */
                            _UNKNOWN,
                        }

                        /**
                         * Returns an enum member corresponding to this class instance's value, or
                         * [Value._UNKNOWN] if the class was instantiated with an unknown value.
                         *
                         * Use the [known] method instead if you're certain the value is always
                         * known or if you want to throw for the unknown case.
                         */
                        fun value(): Value =
                            when (this) {
                                NOT_APPLICABLE -> Value.NOT_APPLICABLE
                                NO_SHOW -> Value.NO_SHOW
                                else -> Value._UNKNOWN
                            }

                        /**
                         * Returns an enum member corresponding to this class instance's value.
                         *
                         * Use the [value] method instead if you're uncertain the value is always
                         * known and don't want to throw for the unknown case.
                         *
                         * @throws IncreaseInvalidDataException if this class instance's value is a
                         *   not a known member.
                         */
                        fun known(): Known =
                            when (this) {
                                NOT_APPLICABLE -> Known.NOT_APPLICABLE
                                NO_SHOW -> Known.NO_SHOW
                                else ->
                                    throw IncreaseInvalidDataException(
                                        "Unknown NoShowIndicator: $value"
                                    )
                            }

                        /**
                         * Returns this class instance's primitive wire representation.
                         *
                         * This differs from the [toString] method because that method is primarily
                         * for debugging and generally doesn't throw.
                         *
                         * @throws IncreaseInvalidDataException if this class instance's value does
                         *   not have the expected primitive type.
                         */
                        fun asString(): String =
                            _value().asString().orElseThrow {
                                IncreaseInvalidDataException("Value is not a String")
                            }

                        private var validated: Boolean = false

                        fun validate(): NoShowIndicator = apply {
                            if (validated) {
                                return@apply
                            }

                            known()
                            validated = true
                        }

                        fun isValid(): Boolean =
                            try {
                                validate()
                                true
                            } catch (e: IncreaseInvalidDataException) {
                                false
                            }

                        /**
                         * Returns a score indicating how many valid values are contained in this
                         * object recursively.
                         *
                         * Used for best match union deserialization.
                         */
                        @JvmSynthetic
                        internal fun validity(): Int = if (value() == Value._UNKNOWN) 0 else 1

                        override fun equals(other: Any?): Boolean {
                            if (this === other) {
                                return true
                            }

                            return /* spotless:off */ other is NoShowIndicator && value == other.value /* spotless:on */
                        }

                        override fun hashCode() = value.hashCode()

                        override fun toString() = value.toString()
                    }

                    override fun equals(other: Any?): Boolean {
                        if (this === other) {
                            return true
                        }

                        return /* spotless:off */ other is Lodging && checkInDate == other.checkInDate && dailyRoomRateAmount == other.dailyRoomRateAmount && dailyRoomRateCurrency == other.dailyRoomRateCurrency && extraCharges == other.extraCharges && folioCashAdvancesAmount == other.folioCashAdvancesAmount && folioCashAdvancesCurrency == other.folioCashAdvancesCurrency && foodBeverageChargesAmount == other.foodBeverageChargesAmount && foodBeverageChargesCurrency == other.foodBeverageChargesCurrency && noShowIndicator == other.noShowIndicator && prepaidExpensesAmount == other.prepaidExpensesAmount && prepaidExpensesCurrency == other.prepaidExpensesCurrency && roomNights == other.roomNights && totalRoomTaxAmount == other.totalRoomTaxAmount && totalRoomTaxCurrency == other.totalRoomTaxCurrency && totalTaxAmount == other.totalTaxAmount && totalTaxCurrency == other.totalTaxCurrency && additionalProperties == other.additionalProperties /* spotless:on */
                    }

                    /* spotless:off */
                    private val hashCode: Int by lazy { Objects.hash(checkInDate, dailyRoomRateAmount, dailyRoomRateCurrency, extraCharges, folioCashAdvancesAmount, folioCashAdvancesCurrency, foodBeverageChargesAmount, foodBeverageChargesCurrency, noShowIndicator, prepaidExpensesAmount, prepaidExpensesCurrency, roomNights, totalRoomTaxAmount, totalRoomTaxCurrency, totalTaxAmount, totalTaxCurrency, additionalProperties) }
                    /* spotless:on */

                    override fun hashCode(): Int = hashCode

                    override fun toString() =
                        "Lodging{checkInDate=$checkInDate, dailyRoomRateAmount=$dailyRoomRateAmount, dailyRoomRateCurrency=$dailyRoomRateCurrency, extraCharges=$extraCharges, folioCashAdvancesAmount=$folioCashAdvancesAmount, folioCashAdvancesCurrency=$folioCashAdvancesCurrency, foodBeverageChargesAmount=$foodBeverageChargesAmount, foodBeverageChargesCurrency=$foodBeverageChargesCurrency, noShowIndicator=$noShowIndicator, prepaidExpensesAmount=$prepaidExpensesAmount, prepaidExpensesCurrency=$prepaidExpensesCurrency, roomNights=$roomNights, totalRoomTaxAmount=$totalRoomTaxAmount, totalRoomTaxCurrency=$totalRoomTaxCurrency, totalTaxAmount=$totalTaxAmount, totalTaxCurrency=$totalTaxCurrency, additionalProperties=$additionalProperties}"
                }

                /** The format of the purchase identifier. */
                class PurchaseIdentifierFormat
                @JsonCreator
                private constructor(private val value: JsonField<String>) : Enum {

                    /**
                     * Returns this class instance's raw value.
                     *
                     * This is usually only useful if this instance was deserialized from data that
                     * doesn't match any known member, and you want to know that value. For example,
                     * if the SDK is on an older version than the API, then the API may respond with
                     * new members that the SDK is unaware of.
                     */
                    @com.fasterxml.jackson.annotation.JsonValue
                    fun _value(): JsonField<String> = value

                    companion object {

                        /** Free text */
                        @JvmField val FREE_TEXT = of("free_text")

                        /** Order number */
                        @JvmField val ORDER_NUMBER = of("order_number")

                        /** Rental agreement number */
                        @JvmField val RENTAL_AGREEMENT_NUMBER = of("rental_agreement_number")

                        /** Hotel folio number */
                        @JvmField val HOTEL_FOLIO_NUMBER = of("hotel_folio_number")

                        /** Invoice number */
                        @JvmField val INVOICE_NUMBER = of("invoice_number")

                        @JvmStatic
                        fun of(value: String) = PurchaseIdentifierFormat(JsonField.of(value))
                    }

                    /** An enum containing [PurchaseIdentifierFormat]'s known values. */
                    enum class Known {
                        /** Free text */
                        FREE_TEXT,
                        /** Order number */
                        ORDER_NUMBER,
                        /** Rental agreement number */
                        RENTAL_AGREEMENT_NUMBER,
                        /** Hotel folio number */
                        HOTEL_FOLIO_NUMBER,
                        /** Invoice number */
                        INVOICE_NUMBER,
                    }

                    /**
                     * An enum containing [PurchaseIdentifierFormat]'s known values, as well as an
                     * [_UNKNOWN] member.
                     *
                     * An instance of [PurchaseIdentifierFormat] can contain an unknown value in a
                     * couple of cases:
                     * - It was deserialized from data that doesn't match any known member. For
                     *   example, if the SDK is on an older version than the API, then the API may
                     *   respond with new members that the SDK is unaware of.
                     * - It was constructed with an arbitrary value using the [of] method.
                     */
                    enum class Value {
                        /** Free text */
                        FREE_TEXT,
                        /** Order number */
                        ORDER_NUMBER,
                        /** Rental agreement number */
                        RENTAL_AGREEMENT_NUMBER,
                        /** Hotel folio number */
                        HOTEL_FOLIO_NUMBER,
                        /** Invoice number */
                        INVOICE_NUMBER,
                        /**
                         * An enum member indicating that [PurchaseIdentifierFormat] was
                         * instantiated with an unknown value.
                         */
                        _UNKNOWN,
                    }

                    /**
                     * Returns an enum member corresponding to this class instance's value, or
                     * [Value._UNKNOWN] if the class was instantiated with an unknown value.
                     *
                     * Use the [known] method instead if you're certain the value is always known or
                     * if you want to throw for the unknown case.
                     */
                    fun value(): Value =
                        when (this) {
                            FREE_TEXT -> Value.FREE_TEXT
                            ORDER_NUMBER -> Value.ORDER_NUMBER
                            RENTAL_AGREEMENT_NUMBER -> Value.RENTAL_AGREEMENT_NUMBER
                            HOTEL_FOLIO_NUMBER -> Value.HOTEL_FOLIO_NUMBER
                            INVOICE_NUMBER -> Value.INVOICE_NUMBER
                            else -> Value._UNKNOWN
                        }

                    /**
                     * Returns an enum member corresponding to this class instance's value.
                     *
                     * Use the [value] method instead if you're uncertain the value is always known
                     * and don't want to throw for the unknown case.
                     *
                     * @throws IncreaseInvalidDataException if this class instance's value is a not
                     *   a known member.
                     */
                    fun known(): Known =
                        when (this) {
                            FREE_TEXT -> Known.FREE_TEXT
                            ORDER_NUMBER -> Known.ORDER_NUMBER
                            RENTAL_AGREEMENT_NUMBER -> Known.RENTAL_AGREEMENT_NUMBER
                            HOTEL_FOLIO_NUMBER -> Known.HOTEL_FOLIO_NUMBER
                            INVOICE_NUMBER -> Known.INVOICE_NUMBER
                            else ->
                                throw IncreaseInvalidDataException(
                                    "Unknown PurchaseIdentifierFormat: $value"
                                )
                        }

                    /**
                     * Returns this class instance's primitive wire representation.
                     *
                     * This differs from the [toString] method because that method is primarily for
                     * debugging and generally doesn't throw.
                     *
                     * @throws IncreaseInvalidDataException if this class instance's value does not
                     *   have the expected primitive type.
                     */
                    fun asString(): String =
                        _value().asString().orElseThrow {
                            IncreaseInvalidDataException("Value is not a String")
                        }

                    private var validated: Boolean = false

                    fun validate(): PurchaseIdentifierFormat = apply {
                        if (validated) {
                            return@apply
                        }

                        known()
                        validated = true
                    }

                    fun isValid(): Boolean =
                        try {
                            validate()
                            true
                        } catch (e: IncreaseInvalidDataException) {
                            false
                        }

                    /**
                     * Returns a score indicating how many valid values are contained in this object
                     * recursively.
                     *
                     * Used for best match union deserialization.
                     */
                    @JvmSynthetic
                    internal fun validity(): Int = if (value() == Value._UNKNOWN) 0 else 1

                    override fun equals(other: Any?): Boolean {
                        if (this === other) {
                            return true
                        }

                        return /* spotless:off */ other is PurchaseIdentifierFormat && value == other.value /* spotless:on */
                    }

                    override fun hashCode() = value.hashCode()

                    override fun toString() = value.toString()
                }

                /** Fields specific to travel. */
                class Travel
                private constructor(
                    private val ancillary: JsonField<Ancillary>,
                    private val computerizedReservationSystem: JsonField<String>,
                    private val creditReasonIndicator: JsonField<CreditReasonIndicator>,
                    private val departureDate: JsonField<LocalDate>,
                    private val originationCityAirportCode: JsonField<String>,
                    private val passengerName: JsonField<String>,
                    private val restrictedTicketIndicator: JsonField<RestrictedTicketIndicator>,
                    private val ticketChangeIndicator: JsonField<TicketChangeIndicator>,
                    private val ticketNumber: JsonField<String>,
                    private val travelAgencyCode: JsonField<String>,
                    private val travelAgencyName: JsonField<String>,
                    private val tripLegs: JsonField<List<TripLeg>>,
                    private val additionalProperties: MutableMap<String, JsonValue>,
                ) {

                    @JsonCreator
                    private constructor(
                        @JsonProperty("ancillary")
                        @ExcludeMissing
                        ancillary: JsonField<Ancillary> = JsonMissing.of(),
                        @JsonProperty("computerized_reservation_system")
                        @ExcludeMissing
                        computerizedReservationSystem: JsonField<String> = JsonMissing.of(),
                        @JsonProperty("credit_reason_indicator")
                        @ExcludeMissing
                        creditReasonIndicator: JsonField<CreditReasonIndicator> = JsonMissing.of(),
                        @JsonProperty("departure_date")
                        @ExcludeMissing
                        departureDate: JsonField<LocalDate> = JsonMissing.of(),
                        @JsonProperty("origination_city_airport_code")
                        @ExcludeMissing
                        originationCityAirportCode: JsonField<String> = JsonMissing.of(),
                        @JsonProperty("passenger_name")
                        @ExcludeMissing
                        passengerName: JsonField<String> = JsonMissing.of(),
                        @JsonProperty("restricted_ticket_indicator")
                        @ExcludeMissing
                        restrictedTicketIndicator: JsonField<RestrictedTicketIndicator> =
                            JsonMissing.of(),
                        @JsonProperty("ticket_change_indicator")
                        @ExcludeMissing
                        ticketChangeIndicator: JsonField<TicketChangeIndicator> = JsonMissing.of(),
                        @JsonProperty("ticket_number")
                        @ExcludeMissing
                        ticketNumber: JsonField<String> = JsonMissing.of(),
                        @JsonProperty("travel_agency_code")
                        @ExcludeMissing
                        travelAgencyCode: JsonField<String> = JsonMissing.of(),
                        @JsonProperty("travel_agency_name")
                        @ExcludeMissing
                        travelAgencyName: JsonField<String> = JsonMissing.of(),
                        @JsonProperty("trip_legs")
                        @ExcludeMissing
                        tripLegs: JsonField<List<TripLeg>> = JsonMissing.of(),
                    ) : this(
                        ancillary,
                        computerizedReservationSystem,
                        creditReasonIndicator,
                        departureDate,
                        originationCityAirportCode,
                        passengerName,
                        restrictedTicketIndicator,
                        ticketChangeIndicator,
                        ticketNumber,
                        travelAgencyCode,
                        travelAgencyName,
                        tripLegs,
                        mutableMapOf(),
                    )

                    /**
                     * Ancillary purchases in addition to the airfare.
                     *
                     * @throws IncreaseInvalidDataException if the JSON field has an unexpected type
                     *   (e.g. if the server responded with an unexpected value).
                     */
                    fun ancillary(): Optional<Ancillary> = ancillary.getOptional("ancillary")

                    /**
                     * Indicates the computerized reservation system used to book the ticket.
                     *
                     * @throws IncreaseInvalidDataException if the JSON field has an unexpected type
                     *   (e.g. if the server responded with an unexpected value).
                     */
                    fun computerizedReservationSystem(): Optional<String> =
                        computerizedReservationSystem.getOptional("computerized_reservation_system")

                    /**
                     * Indicates the reason for a credit to the cardholder.
                     *
                     * @throws IncreaseInvalidDataException if the JSON field has an unexpected type
                     *   (e.g. if the server responded with an unexpected value).
                     */
                    fun creditReasonIndicator(): Optional<CreditReasonIndicator> =
                        creditReasonIndicator.getOptional("credit_reason_indicator")

                    /**
                     * Date of departure.
                     *
                     * @throws IncreaseInvalidDataException if the JSON field has an unexpected type
                     *   (e.g. if the server responded with an unexpected value).
                     */
                    fun departureDate(): Optional<LocalDate> =
                        departureDate.getOptional("departure_date")

                    /**
                     * Code for the originating city or airport.
                     *
                     * @throws IncreaseInvalidDataException if the JSON field has an unexpected type
                     *   (e.g. if the server responded with an unexpected value).
                     */
                    fun originationCityAirportCode(): Optional<String> =
                        originationCityAirportCode.getOptional("origination_city_airport_code")

                    /**
                     * Name of the passenger.
                     *
                     * @throws IncreaseInvalidDataException if the JSON field has an unexpected type
                     *   (e.g. if the server responded with an unexpected value).
                     */
                    fun passengerName(): Optional<String> =
                        passengerName.getOptional("passenger_name")

                    /**
                     * Indicates whether this ticket is non-refundable.
                     *
                     * @throws IncreaseInvalidDataException if the JSON field has an unexpected type
                     *   (e.g. if the server responded with an unexpected value).
                     */
                    fun restrictedTicketIndicator(): Optional<RestrictedTicketIndicator> =
                        restrictedTicketIndicator.getOptional("restricted_ticket_indicator")

                    /**
                     * Indicates why a ticket was changed.
                     *
                     * @throws IncreaseInvalidDataException if the JSON field has an unexpected type
                     *   (e.g. if the server responded with an unexpected value).
                     */
                    fun ticketChangeIndicator(): Optional<TicketChangeIndicator> =
                        ticketChangeIndicator.getOptional("ticket_change_indicator")

                    /**
                     * Ticket number.
                     *
                     * @throws IncreaseInvalidDataException if the JSON field has an unexpected type
                     *   (e.g. if the server responded with an unexpected value).
                     */
                    fun ticketNumber(): Optional<String> = ticketNumber.getOptional("ticket_number")

                    /**
                     * Code for the travel agency if the ticket was issued by a travel agency.
                     *
                     * @throws IncreaseInvalidDataException if the JSON field has an unexpected type
                     *   (e.g. if the server responded with an unexpected value).
                     */
                    fun travelAgencyCode(): Optional<String> =
                        travelAgencyCode.getOptional("travel_agency_code")

                    /**
                     * Name of the travel agency if the ticket was issued by a travel agency.
                     *
                     * @throws IncreaseInvalidDataException if the JSON field has an unexpected type
                     *   (e.g. if the server responded with an unexpected value).
                     */
                    fun travelAgencyName(): Optional<String> =
                        travelAgencyName.getOptional("travel_agency_name")

                    /**
                     * Fields specific to each leg of the journey.
                     *
                     * @throws IncreaseInvalidDataException if the JSON field has an unexpected type
                     *   (e.g. if the server responded with an unexpected value).
                     */
                    fun tripLegs(): Optional<List<TripLeg>> = tripLegs.getOptional("trip_legs")

                    /**
                     * Returns the raw JSON value of [ancillary].
                     *
                     * Unlike [ancillary], this method doesn't throw if the JSON field has an
                     * unexpected type.
                     */
                    @JsonProperty("ancillary")
                    @ExcludeMissing
                    fun _ancillary(): JsonField<Ancillary> = ancillary

                    /**
                     * Returns the raw JSON value of [computerizedReservationSystem].
                     *
                     * Unlike [computerizedReservationSystem], this method doesn't throw if the JSON
                     * field has an unexpected type.
                     */
                    @JsonProperty("computerized_reservation_system")
                    @ExcludeMissing
                    fun _computerizedReservationSystem(): JsonField<String> =
                        computerizedReservationSystem

                    /**
                     * Returns the raw JSON value of [creditReasonIndicator].
                     *
                     * Unlike [creditReasonIndicator], this method doesn't throw if the JSON field
                     * has an unexpected type.
                     */
                    @JsonProperty("credit_reason_indicator")
                    @ExcludeMissing
                    fun _creditReasonIndicator(): JsonField<CreditReasonIndicator> =
                        creditReasonIndicator

                    /**
                     * Returns the raw JSON value of [departureDate].
                     *
                     * Unlike [departureDate], this method doesn't throw if the JSON field has an
                     * unexpected type.
                     */
                    @JsonProperty("departure_date")
                    @ExcludeMissing
                    fun _departureDate(): JsonField<LocalDate> = departureDate

                    /**
                     * Returns the raw JSON value of [originationCityAirportCode].
                     *
                     * Unlike [originationCityAirportCode], this method doesn't throw if the JSON
                     * field has an unexpected type.
                     */
                    @JsonProperty("origination_city_airport_code")
                    @ExcludeMissing
                    fun _originationCityAirportCode(): JsonField<String> =
                        originationCityAirportCode

                    /**
                     * Returns the raw JSON value of [passengerName].
                     *
                     * Unlike [passengerName], this method doesn't throw if the JSON field has an
                     * unexpected type.
                     */
                    @JsonProperty("passenger_name")
                    @ExcludeMissing
                    fun _passengerName(): JsonField<String> = passengerName

                    /**
                     * Returns the raw JSON value of [restrictedTicketIndicator].
                     *
                     * Unlike [restrictedTicketIndicator], this method doesn't throw if the JSON
                     * field has an unexpected type.
                     */
                    @JsonProperty("restricted_ticket_indicator")
                    @ExcludeMissing
                    fun _restrictedTicketIndicator(): JsonField<RestrictedTicketIndicator> =
                        restrictedTicketIndicator

                    /**
                     * Returns the raw JSON value of [ticketChangeIndicator].
                     *
                     * Unlike [ticketChangeIndicator], this method doesn't throw if the JSON field
                     * has an unexpected type.
                     */
                    @JsonProperty("ticket_change_indicator")
                    @ExcludeMissing
                    fun _ticketChangeIndicator(): JsonField<TicketChangeIndicator> =
                        ticketChangeIndicator

                    /**
                     * Returns the raw JSON value of [ticketNumber].
                     *
                     * Unlike [ticketNumber], this method doesn't throw if the JSON field has an
                     * unexpected type.
                     */
                    @JsonProperty("ticket_number")
                    @ExcludeMissing
                    fun _ticketNumber(): JsonField<String> = ticketNumber

                    /**
                     * Returns the raw JSON value of [travelAgencyCode].
                     *
                     * Unlike [travelAgencyCode], this method doesn't throw if the JSON field has an
                     * unexpected type.
                     */
                    @JsonProperty("travel_agency_code")
                    @ExcludeMissing
                    fun _travelAgencyCode(): JsonField<String> = travelAgencyCode

                    /**
                     * Returns the raw JSON value of [travelAgencyName].
                     *
                     * Unlike [travelAgencyName], this method doesn't throw if the JSON field has an
                     * unexpected type.
                     */
                    @JsonProperty("travel_agency_name")
                    @ExcludeMissing
                    fun _travelAgencyName(): JsonField<String> = travelAgencyName

                    /**
                     * Returns the raw JSON value of [tripLegs].
                     *
                     * Unlike [tripLegs], this method doesn't throw if the JSON field has an
                     * unexpected type.
                     */
                    @JsonProperty("trip_legs")
                    @ExcludeMissing
                    fun _tripLegs(): JsonField<List<TripLeg>> = tripLegs

                    @JsonAnySetter
                    private fun putAdditionalProperty(key: String, value: JsonValue) {
                        additionalProperties.put(key, value)
                    }

                    @JsonAnyGetter
                    @ExcludeMissing
                    fun _additionalProperties(): Map<String, JsonValue> =
                        Collections.unmodifiableMap(additionalProperties)

                    fun toBuilder() = Builder().from(this)

                    companion object {

                        /**
                         * Returns a mutable builder for constructing an instance of [Travel].
                         *
                         * The following fields are required:
                         * ```java
                         * .ancillary()
                         * .computerizedReservationSystem()
                         * .creditReasonIndicator()
                         * .departureDate()
                         * .originationCityAirportCode()
                         * .passengerName()
                         * .restrictedTicketIndicator()
                         * .ticketChangeIndicator()
                         * .ticketNumber()
                         * .travelAgencyCode()
                         * .travelAgencyName()
                         * .tripLegs()
                         * ```
                         */
                        @JvmStatic fun builder() = Builder()
                    }

                    /** A builder for [Travel]. */
                    class Builder internal constructor() {

                        private var ancillary: JsonField<Ancillary>? = null
                        private var computerizedReservationSystem: JsonField<String>? = null
                        private var creditReasonIndicator: JsonField<CreditReasonIndicator>? = null
                        private var departureDate: JsonField<LocalDate>? = null
                        private var originationCityAirportCode: JsonField<String>? = null
                        private var passengerName: JsonField<String>? = null
                        private var restrictedTicketIndicator:
                            JsonField<RestrictedTicketIndicator>? =
                            null
                        private var ticketChangeIndicator: JsonField<TicketChangeIndicator>? = null
                        private var ticketNumber: JsonField<String>? = null
                        private var travelAgencyCode: JsonField<String>? = null
                        private var travelAgencyName: JsonField<String>? = null
                        private var tripLegs: JsonField<MutableList<TripLeg>>? = null
                        private var additionalProperties: MutableMap<String, JsonValue> =
                            mutableMapOf()

                        @JvmSynthetic
                        internal fun from(travel: Travel) = apply {
                            ancillary = travel.ancillary
                            computerizedReservationSystem = travel.computerizedReservationSystem
                            creditReasonIndicator = travel.creditReasonIndicator
                            departureDate = travel.departureDate
                            originationCityAirportCode = travel.originationCityAirportCode
                            passengerName = travel.passengerName
                            restrictedTicketIndicator = travel.restrictedTicketIndicator
                            ticketChangeIndicator = travel.ticketChangeIndicator
                            ticketNumber = travel.ticketNumber
                            travelAgencyCode = travel.travelAgencyCode
                            travelAgencyName = travel.travelAgencyName
                            tripLegs = travel.tripLegs.map { it.toMutableList() }
                            additionalProperties = travel.additionalProperties.toMutableMap()
                        }

                        /** Ancillary purchases in addition to the airfare. */
                        fun ancillary(ancillary: Ancillary?) =
                            ancillary(JsonField.ofNullable(ancillary))

                        /** Alias for calling [Builder.ancillary] with `ancillary.orElse(null)`. */
                        fun ancillary(ancillary: Optional<Ancillary>) =
                            ancillary(ancillary.getOrNull())

                        /**
                         * Sets [Builder.ancillary] to an arbitrary JSON value.
                         *
                         * You should usually call [Builder.ancillary] with a well-typed [Ancillary]
                         * value instead. This method is primarily for setting the field to an
                         * undocumented or not yet supported value.
                         */
                        fun ancillary(ancillary: JsonField<Ancillary>) = apply {
                            this.ancillary = ancillary
                        }

                        /**
                         * Indicates the computerized reservation system used to book the ticket.
                         */
                        fun computerizedReservationSystem(computerizedReservationSystem: String?) =
                            computerizedReservationSystem(
                                JsonField.ofNullable(computerizedReservationSystem)
                            )

                        /**
                         * Alias for calling [Builder.computerizedReservationSystem] with
                         * `computerizedReservationSystem.orElse(null)`.
                         */
                        fun computerizedReservationSystem(
                            computerizedReservationSystem: Optional<String>
                        ) = computerizedReservationSystem(computerizedReservationSystem.getOrNull())

                        /**
                         * Sets [Builder.computerizedReservationSystem] to an arbitrary JSON value.
                         *
                         * You should usually call [Builder.computerizedReservationSystem] with a
                         * well-typed [String] value instead. This method is primarily for setting
                         * the field to an undocumented or not yet supported value.
                         */
                        fun computerizedReservationSystem(
                            computerizedReservationSystem: JsonField<String>
                        ) = apply {
                            this.computerizedReservationSystem = computerizedReservationSystem
                        }

                        /** Indicates the reason for a credit to the cardholder. */
                        fun creditReasonIndicator(creditReasonIndicator: CreditReasonIndicator?) =
                            creditReasonIndicator(JsonField.ofNullable(creditReasonIndicator))

                        /**
                         * Alias for calling [Builder.creditReasonIndicator] with
                         * `creditReasonIndicator.orElse(null)`.
                         */
                        fun creditReasonIndicator(
                            creditReasonIndicator: Optional<CreditReasonIndicator>
                        ) = creditReasonIndicator(creditReasonIndicator.getOrNull())

                        /**
                         * Sets [Builder.creditReasonIndicator] to an arbitrary JSON value.
                         *
                         * You should usually call [Builder.creditReasonIndicator] with a well-typed
                         * [CreditReasonIndicator] value instead. This method is primarily for
                         * setting the field to an undocumented or not yet supported value.
                         */
                        fun creditReasonIndicator(
                            creditReasonIndicator: JsonField<CreditReasonIndicator>
                        ) = apply { this.creditReasonIndicator = creditReasonIndicator }

                        /** Date of departure. */
                        fun departureDate(departureDate: LocalDate?) =
                            departureDate(JsonField.ofNullable(departureDate))

                        /**
                         * Alias for calling [Builder.departureDate] with
                         * `departureDate.orElse(null)`.
                         */
                        fun departureDate(departureDate: Optional<LocalDate>) =
                            departureDate(departureDate.getOrNull())

                        /**
                         * Sets [Builder.departureDate] to an arbitrary JSON value.
                         *
                         * You should usually call [Builder.departureDate] with a well-typed
                         * [LocalDate] value instead. This method is primarily for setting the field
                         * to an undocumented or not yet supported value.
                         */
                        fun departureDate(departureDate: JsonField<LocalDate>) = apply {
                            this.departureDate = departureDate
                        }

                        /** Code for the originating city or airport. */
                        fun originationCityAirportCode(originationCityAirportCode: String?) =
                            originationCityAirportCode(
                                JsonField.ofNullable(originationCityAirportCode)
                            )

                        /**
                         * Alias for calling [Builder.originationCityAirportCode] with
                         * `originationCityAirportCode.orElse(null)`.
                         */
                        fun originationCityAirportCode(
                            originationCityAirportCode: Optional<String>
                        ) = originationCityAirportCode(originationCityAirportCode.getOrNull())

                        /**
                         * Sets [Builder.originationCityAirportCode] to an arbitrary JSON value.
                         *
                         * You should usually call [Builder.originationCityAirportCode] with a
                         * well-typed [String] value instead. This method is primarily for setting
                         * the field to an undocumented or not yet supported value.
                         */
                        fun originationCityAirportCode(
                            originationCityAirportCode: JsonField<String>
                        ) = apply { this.originationCityAirportCode = originationCityAirportCode }

                        /** Name of the passenger. */
                        fun passengerName(passengerName: String?) =
                            passengerName(JsonField.ofNullable(passengerName))

                        /**
                         * Alias for calling [Builder.passengerName] with
                         * `passengerName.orElse(null)`.
                         */
                        fun passengerName(passengerName: Optional<String>) =
                            passengerName(passengerName.getOrNull())

                        /**
                         * Sets [Builder.passengerName] to an arbitrary JSON value.
                         *
                         * You should usually call [Builder.passengerName] with a well-typed
                         * [String] value instead. This method is primarily for setting the field to
                         * an undocumented or not yet supported value.
                         */
                        fun passengerName(passengerName: JsonField<String>) = apply {
                            this.passengerName = passengerName
                        }

                        /** Indicates whether this ticket is non-refundable. */
                        fun restrictedTicketIndicator(
                            restrictedTicketIndicator: RestrictedTicketIndicator?
                        ) =
                            restrictedTicketIndicator(
                                JsonField.ofNullable(restrictedTicketIndicator)
                            )

                        /**
                         * Alias for calling [Builder.restrictedTicketIndicator] with
                         * `restrictedTicketIndicator.orElse(null)`.
                         */
                        fun restrictedTicketIndicator(
                            restrictedTicketIndicator: Optional<RestrictedTicketIndicator>
                        ) = restrictedTicketIndicator(restrictedTicketIndicator.getOrNull())

                        /**
                         * Sets [Builder.restrictedTicketIndicator] to an arbitrary JSON value.
                         *
                         * You should usually call [Builder.restrictedTicketIndicator] with a
                         * well-typed [RestrictedTicketIndicator] value instead. This method is
                         * primarily for setting the field to an undocumented or not yet supported
                         * value.
                         */
                        fun restrictedTicketIndicator(
                            restrictedTicketIndicator: JsonField<RestrictedTicketIndicator>
                        ) = apply { this.restrictedTicketIndicator = restrictedTicketIndicator }

                        /** Indicates why a ticket was changed. */
                        fun ticketChangeIndicator(ticketChangeIndicator: TicketChangeIndicator?) =
                            ticketChangeIndicator(JsonField.ofNullable(ticketChangeIndicator))

                        /**
                         * Alias for calling [Builder.ticketChangeIndicator] with
                         * `ticketChangeIndicator.orElse(null)`.
                         */
                        fun ticketChangeIndicator(
                            ticketChangeIndicator: Optional<TicketChangeIndicator>
                        ) = ticketChangeIndicator(ticketChangeIndicator.getOrNull())

                        /**
                         * Sets [Builder.ticketChangeIndicator] to an arbitrary JSON value.
                         *
                         * You should usually call [Builder.ticketChangeIndicator] with a well-typed
                         * [TicketChangeIndicator] value instead. This method is primarily for
                         * setting the field to an undocumented or not yet supported value.
                         */
                        fun ticketChangeIndicator(
                            ticketChangeIndicator: JsonField<TicketChangeIndicator>
                        ) = apply { this.ticketChangeIndicator = ticketChangeIndicator }

                        /** Ticket number. */
                        fun ticketNumber(ticketNumber: String?) =
                            ticketNumber(JsonField.ofNullable(ticketNumber))

                        /**
                         * Alias for calling [Builder.ticketNumber] with
                         * `ticketNumber.orElse(null)`.
                         */
                        fun ticketNumber(ticketNumber: Optional<String>) =
                            ticketNumber(ticketNumber.getOrNull())

                        /**
                         * Sets [Builder.ticketNumber] to an arbitrary JSON value.
                         *
                         * You should usually call [Builder.ticketNumber] with a well-typed [String]
                         * value instead. This method is primarily for setting the field to an
                         * undocumented or not yet supported value.
                         */
                        fun ticketNumber(ticketNumber: JsonField<String>) = apply {
                            this.ticketNumber = ticketNumber
                        }

                        /**
                         * Code for the travel agency if the ticket was issued by a travel agency.
                         */
                        fun travelAgencyCode(travelAgencyCode: String?) =
                            travelAgencyCode(JsonField.ofNullable(travelAgencyCode))

                        /**
                         * Alias for calling [Builder.travelAgencyCode] with
                         * `travelAgencyCode.orElse(null)`.
                         */
                        fun travelAgencyCode(travelAgencyCode: Optional<String>) =
                            travelAgencyCode(travelAgencyCode.getOrNull())

                        /**
                         * Sets [Builder.travelAgencyCode] to an arbitrary JSON value.
                         *
                         * You should usually call [Builder.travelAgencyCode] with a well-typed
                         * [String] value instead. This method is primarily for setting the field to
                         * an undocumented or not yet supported value.
                         */
                        fun travelAgencyCode(travelAgencyCode: JsonField<String>) = apply {
                            this.travelAgencyCode = travelAgencyCode
                        }

                        /**
                         * Name of the travel agency if the ticket was issued by a travel agency.
                         */
                        fun travelAgencyName(travelAgencyName: String?) =
                            travelAgencyName(JsonField.ofNullable(travelAgencyName))

                        /**
                         * Alias for calling [Builder.travelAgencyName] with
                         * `travelAgencyName.orElse(null)`.
                         */
                        fun travelAgencyName(travelAgencyName: Optional<String>) =
                            travelAgencyName(travelAgencyName.getOrNull())

                        /**
                         * Sets [Builder.travelAgencyName] to an arbitrary JSON value.
                         *
                         * You should usually call [Builder.travelAgencyName] with a well-typed
                         * [String] value instead. This method is primarily for setting the field to
                         * an undocumented or not yet supported value.
                         */
                        fun travelAgencyName(travelAgencyName: JsonField<String>) = apply {
                            this.travelAgencyName = travelAgencyName
                        }

                        /** Fields specific to each leg of the journey. */
                        fun tripLegs(tripLegs: List<TripLeg>?) =
                            tripLegs(JsonField.ofNullable(tripLegs))

                        /** Alias for calling [Builder.tripLegs] with `tripLegs.orElse(null)`. */
                        fun tripLegs(tripLegs: Optional<List<TripLeg>>) =
                            tripLegs(tripLegs.getOrNull())

                        /**
                         * Sets [Builder.tripLegs] to an arbitrary JSON value.
                         *
                         * You should usually call [Builder.tripLegs] with a well-typed
                         * `List<TripLeg>` value instead. This method is primarily for setting the
                         * field to an undocumented or not yet supported value.
                         */
                        fun tripLegs(tripLegs: JsonField<List<TripLeg>>) = apply {
                            this.tripLegs = tripLegs.map { it.toMutableList() }
                        }

                        /**
                         * Adds a single [TripLeg] to [tripLegs].
                         *
                         * @throws IllegalStateException if the field was previously set to a
                         *   non-list.
                         */
                        fun addTripLeg(tripLeg: TripLeg) = apply {
                            tripLegs =
                                (tripLegs ?: JsonField.of(mutableListOf())).also {
                                    checkKnown("tripLegs", it).add(tripLeg)
                                }
                        }

                        fun additionalProperties(additionalProperties: Map<String, JsonValue>) =
                            apply {
                                this.additionalProperties.clear()
                                putAllAdditionalProperties(additionalProperties)
                            }

                        fun putAdditionalProperty(key: String, value: JsonValue) = apply {
                            additionalProperties.put(key, value)
                        }

                        fun putAllAdditionalProperties(
                            additionalProperties: Map<String, JsonValue>
                        ) = apply { this.additionalProperties.putAll(additionalProperties) }

                        fun removeAdditionalProperty(key: String) = apply {
                            additionalProperties.remove(key)
                        }

                        fun removeAllAdditionalProperties(keys: Set<String>) = apply {
                            keys.forEach(::removeAdditionalProperty)
                        }

                        /**
                         * Returns an immutable instance of [Travel].
                         *
                         * Further updates to this [Builder] will not mutate the returned instance.
                         *
                         * The following fields are required:
                         * ```java
                         * .ancillary()
                         * .computerizedReservationSystem()
                         * .creditReasonIndicator()
                         * .departureDate()
                         * .originationCityAirportCode()
                         * .passengerName()
                         * .restrictedTicketIndicator()
                         * .ticketChangeIndicator()
                         * .ticketNumber()
                         * .travelAgencyCode()
                         * .travelAgencyName()
                         * .tripLegs()
                         * ```
                         *
                         * @throws IllegalStateException if any required field is unset.
                         */
                        fun build(): Travel =
                            Travel(
                                checkRequired("ancillary", ancillary),
                                checkRequired(
                                    "computerizedReservationSystem",
                                    computerizedReservationSystem,
                                ),
                                checkRequired("creditReasonIndicator", creditReasonIndicator),
                                checkRequired("departureDate", departureDate),
                                checkRequired(
                                    "originationCityAirportCode",
                                    originationCityAirportCode,
                                ),
                                checkRequired("passengerName", passengerName),
                                checkRequired(
                                    "restrictedTicketIndicator",
                                    restrictedTicketIndicator,
                                ),
                                checkRequired("ticketChangeIndicator", ticketChangeIndicator),
                                checkRequired("ticketNumber", ticketNumber),
                                checkRequired("travelAgencyCode", travelAgencyCode),
                                checkRequired("travelAgencyName", travelAgencyName),
                                checkRequired("tripLegs", tripLegs).map { it.toImmutable() },
                                additionalProperties.toMutableMap(),
                            )
                    }

                    private var validated: Boolean = false

                    fun validate(): Travel = apply {
                        if (validated) {
                            return@apply
                        }

                        ancillary().ifPresent { it.validate() }
                        computerizedReservationSystem()
                        creditReasonIndicator().ifPresent { it.validate() }
                        departureDate()
                        originationCityAirportCode()
                        passengerName()
                        restrictedTicketIndicator().ifPresent { it.validate() }
                        ticketChangeIndicator().ifPresent { it.validate() }
                        ticketNumber()
                        travelAgencyCode()
                        travelAgencyName()
                        tripLegs().ifPresent { it.forEach { it.validate() } }
                        validated = true
                    }

                    fun isValid(): Boolean =
                        try {
                            validate()
                            true
                        } catch (e: IncreaseInvalidDataException) {
                            false
                        }

                    /**
                     * Returns a score indicating how many valid values are contained in this object
                     * recursively.
                     *
                     * Used for best match union deserialization.
                     */
                    @JvmSynthetic
                    internal fun validity(): Int =
                        (ancillary.asKnown().getOrNull()?.validity() ?: 0) +
                            (if (computerizedReservationSystem.asKnown().isPresent) 1 else 0) +
                            (creditReasonIndicator.asKnown().getOrNull()?.validity() ?: 0) +
                            (if (departureDate.asKnown().isPresent) 1 else 0) +
                            (if (originationCityAirportCode.asKnown().isPresent) 1 else 0) +
                            (if (passengerName.asKnown().isPresent) 1 else 0) +
                            (restrictedTicketIndicator.asKnown().getOrNull()?.validity() ?: 0) +
                            (ticketChangeIndicator.asKnown().getOrNull()?.validity() ?: 0) +
                            (if (ticketNumber.asKnown().isPresent) 1 else 0) +
                            (if (travelAgencyCode.asKnown().isPresent) 1 else 0) +
                            (if (travelAgencyName.asKnown().isPresent) 1 else 0) +
                            (tripLegs.asKnown().getOrNull()?.sumOf { it.validity().toInt() } ?: 0)

                    /** Ancillary purchases in addition to the airfare. */
                    class Ancillary
                    private constructor(
                        private val connectedTicketDocumentNumber: JsonField<String>,
                        private val creditReasonIndicator: JsonField<CreditReasonIndicator>,
                        private val passengerNameOrDescription: JsonField<String>,
                        private val services: JsonField<List<Service>>,
                        private val ticketDocumentNumber: JsonField<String>,
                        private val additionalProperties: MutableMap<String, JsonValue>,
                    ) {

                        @JsonCreator
                        private constructor(
                            @JsonProperty("connected_ticket_document_number")
                            @ExcludeMissing
                            connectedTicketDocumentNumber: JsonField<String> = JsonMissing.of(),
                            @JsonProperty("credit_reason_indicator")
                            @ExcludeMissing
                            creditReasonIndicator: JsonField<CreditReasonIndicator> =
                                JsonMissing.of(),
                            @JsonProperty("passenger_name_or_description")
                            @ExcludeMissing
                            passengerNameOrDescription: JsonField<String> = JsonMissing.of(),
                            @JsonProperty("services")
                            @ExcludeMissing
                            services: JsonField<List<Service>> = JsonMissing.of(),
                            @JsonProperty("ticket_document_number")
                            @ExcludeMissing
                            ticketDocumentNumber: JsonField<String> = JsonMissing.of(),
                        ) : this(
                            connectedTicketDocumentNumber,
                            creditReasonIndicator,
                            passengerNameOrDescription,
                            services,
                            ticketDocumentNumber,
                            mutableMapOf(),
                        )

                        /**
                         * If this purchase has a connection or relationship to another purchase,
                         * such as a baggage fee for a passenger transport ticket, this field should
                         * contain the ticket document number for the other purchase.
                         *
                         * @throws IncreaseInvalidDataException if the JSON field has an unexpected
                         *   type (e.g. if the server responded with an unexpected value).
                         */
                        fun connectedTicketDocumentNumber(): Optional<String> =
                            connectedTicketDocumentNumber.getOptional(
                                "connected_ticket_document_number"
                            )

                        /**
                         * Indicates the reason for a credit to the cardholder.
                         *
                         * @throws IncreaseInvalidDataException if the JSON field has an unexpected
                         *   type (e.g. if the server responded with an unexpected value).
                         */
                        fun creditReasonIndicator(): Optional<CreditReasonIndicator> =
                            creditReasonIndicator.getOptional("credit_reason_indicator")

                        /**
                         * Name of the passenger or description of the ancillary purchase.
                         *
                         * @throws IncreaseInvalidDataException if the JSON field has an unexpected
                         *   type (e.g. if the server responded with an unexpected value).
                         */
                        fun passengerNameOrDescription(): Optional<String> =
                            passengerNameOrDescription.getOptional("passenger_name_or_description")

                        /**
                         * Additional travel charges, such as baggage fees.
                         *
                         * @throws IncreaseInvalidDataException if the JSON field has an unexpected
                         *   type or is unexpectedly missing or null (e.g. if the server responded
                         *   with an unexpected value).
                         */
                        fun services(): List<Service> = services.getRequired("services")

                        /**
                         * Ticket document number.
                         *
                         * @throws IncreaseInvalidDataException if the JSON field has an unexpected
                         *   type (e.g. if the server responded with an unexpected value).
                         */
                        fun ticketDocumentNumber(): Optional<String> =
                            ticketDocumentNumber.getOptional("ticket_document_number")

                        /**
                         * Returns the raw JSON value of [connectedTicketDocumentNumber].
                         *
                         * Unlike [connectedTicketDocumentNumber], this method doesn't throw if the
                         * JSON field has an unexpected type.
                         */
                        @JsonProperty("connected_ticket_document_number")
                        @ExcludeMissing
                        fun _connectedTicketDocumentNumber(): JsonField<String> =
                            connectedTicketDocumentNumber

                        /**
                         * Returns the raw JSON value of [creditReasonIndicator].
                         *
                         * Unlike [creditReasonIndicator], this method doesn't throw if the JSON
                         * field has an unexpected type.
                         */
                        @JsonProperty("credit_reason_indicator")
                        @ExcludeMissing
                        fun _creditReasonIndicator(): JsonField<CreditReasonIndicator> =
                            creditReasonIndicator

                        /**
                         * Returns the raw JSON value of [passengerNameOrDescription].
                         *
                         * Unlike [passengerNameOrDescription], this method doesn't throw if the
                         * JSON field has an unexpected type.
                         */
                        @JsonProperty("passenger_name_or_description")
                        @ExcludeMissing
                        fun _passengerNameOrDescription(): JsonField<String> =
                            passengerNameOrDescription

                        /**
                         * Returns the raw JSON value of [services].
                         *
                         * Unlike [services], this method doesn't throw if the JSON field has an
                         * unexpected type.
                         */
                        @JsonProperty("services")
                        @ExcludeMissing
                        fun _services(): JsonField<List<Service>> = services

                        /**
                         * Returns the raw JSON value of [ticketDocumentNumber].
                         *
                         * Unlike [ticketDocumentNumber], this method doesn't throw if the JSON
                         * field has an unexpected type.
                         */
                        @JsonProperty("ticket_document_number")
                        @ExcludeMissing
                        fun _ticketDocumentNumber(): JsonField<String> = ticketDocumentNumber

                        @JsonAnySetter
                        private fun putAdditionalProperty(key: String, value: JsonValue) {
                            additionalProperties.put(key, value)
                        }

                        @JsonAnyGetter
                        @ExcludeMissing
                        fun _additionalProperties(): Map<String, JsonValue> =
                            Collections.unmodifiableMap(additionalProperties)

                        fun toBuilder() = Builder().from(this)

                        companion object {

                            /**
                             * Returns a mutable builder for constructing an instance of
                             * [Ancillary].
                             *
                             * The following fields are required:
                             * ```java
                             * .connectedTicketDocumentNumber()
                             * .creditReasonIndicator()
                             * .passengerNameOrDescription()
                             * .services()
                             * .ticketDocumentNumber()
                             * ```
                             */
                            @JvmStatic fun builder() = Builder()
                        }

                        /** A builder for [Ancillary]. */
                        class Builder internal constructor() {

                            private var connectedTicketDocumentNumber: JsonField<String>? = null
                            private var creditReasonIndicator: JsonField<CreditReasonIndicator>? =
                                null
                            private var passengerNameOrDescription: JsonField<String>? = null
                            private var services: JsonField<MutableList<Service>>? = null
                            private var ticketDocumentNumber: JsonField<String>? = null
                            private var additionalProperties: MutableMap<String, JsonValue> =
                                mutableMapOf()

                            @JvmSynthetic
                            internal fun from(ancillary: Ancillary) = apply {
                                connectedTicketDocumentNumber =
                                    ancillary.connectedTicketDocumentNumber
                                creditReasonIndicator = ancillary.creditReasonIndicator
                                passengerNameOrDescription = ancillary.passengerNameOrDescription
                                services = ancillary.services.map { it.toMutableList() }
                                ticketDocumentNumber = ancillary.ticketDocumentNumber
                                additionalProperties = ancillary.additionalProperties.toMutableMap()
                            }

                            /**
                             * If this purchase has a connection or relationship to another
                             * purchase, such as a baggage fee for a passenger transport ticket,
                             * this field should contain the ticket document number for the other
                             * purchase.
                             */
                            fun connectedTicketDocumentNumber(
                                connectedTicketDocumentNumber: String?
                            ) =
                                connectedTicketDocumentNumber(
                                    JsonField.ofNullable(connectedTicketDocumentNumber)
                                )

                            /**
                             * Alias for calling [Builder.connectedTicketDocumentNumber] with
                             * `connectedTicketDocumentNumber.orElse(null)`.
                             */
                            fun connectedTicketDocumentNumber(
                                connectedTicketDocumentNumber: Optional<String>
                            ) =
                                connectedTicketDocumentNumber(
                                    connectedTicketDocumentNumber.getOrNull()
                                )

                            /**
                             * Sets [Builder.connectedTicketDocumentNumber] to an arbitrary JSON
                             * value.
                             *
                             * You should usually call [Builder.connectedTicketDocumentNumber] with
                             * a well-typed [String] value instead. This method is primarily for
                             * setting the field to an undocumented or not yet supported value.
                             */
                            fun connectedTicketDocumentNumber(
                                connectedTicketDocumentNumber: JsonField<String>
                            ) = apply {
                                this.connectedTicketDocumentNumber = connectedTicketDocumentNumber
                            }

                            /** Indicates the reason for a credit to the cardholder. */
                            fun creditReasonIndicator(
                                creditReasonIndicator: CreditReasonIndicator?
                            ) = creditReasonIndicator(JsonField.ofNullable(creditReasonIndicator))

                            /**
                             * Alias for calling [Builder.creditReasonIndicator] with
                             * `creditReasonIndicator.orElse(null)`.
                             */
                            fun creditReasonIndicator(
                                creditReasonIndicator: Optional<CreditReasonIndicator>
                            ) = creditReasonIndicator(creditReasonIndicator.getOrNull())

                            /**
                             * Sets [Builder.creditReasonIndicator] to an arbitrary JSON value.
                             *
                             * You should usually call [Builder.creditReasonIndicator] with a
                             * well-typed [CreditReasonIndicator] value instead. This method is
                             * primarily for setting the field to an undocumented or not yet
                             * supported value.
                             */
                            fun creditReasonIndicator(
                                creditReasonIndicator: JsonField<CreditReasonIndicator>
                            ) = apply { this.creditReasonIndicator = creditReasonIndicator }

                            /** Name of the passenger or description of the ancillary purchase. */
                            fun passengerNameOrDescription(passengerNameOrDescription: String?) =
                                passengerNameOrDescription(
                                    JsonField.ofNullable(passengerNameOrDescription)
                                )

                            /**
                             * Alias for calling [Builder.passengerNameOrDescription] with
                             * `passengerNameOrDescription.orElse(null)`.
                             */
                            fun passengerNameOrDescription(
                                passengerNameOrDescription: Optional<String>
                            ) = passengerNameOrDescription(passengerNameOrDescription.getOrNull())

                            /**
                             * Sets [Builder.passengerNameOrDescription] to an arbitrary JSON value.
                             *
                             * You should usually call [Builder.passengerNameOrDescription] with a
                             * well-typed [String] value instead. This method is primarily for
                             * setting the field to an undocumented or not yet supported value.
                             */
                            fun passengerNameOrDescription(
                                passengerNameOrDescription: JsonField<String>
                            ) = apply {
                                this.passengerNameOrDescription = passengerNameOrDescription
                            }

                            /** Additional travel charges, such as baggage fees. */
                            fun services(services: List<Service>) = services(JsonField.of(services))

                            /**
                             * Sets [Builder.services] to an arbitrary JSON value.
                             *
                             * You should usually call [Builder.services] with a well-typed
                             * `List<Service>` value instead. This method is primarily for setting
                             * the field to an undocumented or not yet supported value.
                             */
                            fun services(services: JsonField<List<Service>>) = apply {
                                this.services = services.map { it.toMutableList() }
                            }

                            /**
                             * Adds a single [Service] to [services].
                             *
                             * @throws IllegalStateException if the field was previously set to a
                             *   non-list.
                             */
                            fun addService(service: Service) = apply {
                                services =
                                    (services ?: JsonField.of(mutableListOf())).also {
                                        checkKnown("services", it).add(service)
                                    }
                            }

                            /** Ticket document number. */
                            fun ticketDocumentNumber(ticketDocumentNumber: String?) =
                                ticketDocumentNumber(JsonField.ofNullable(ticketDocumentNumber))

                            /**
                             * Alias for calling [Builder.ticketDocumentNumber] with
                             * `ticketDocumentNumber.orElse(null)`.
                             */
                            fun ticketDocumentNumber(ticketDocumentNumber: Optional<String>) =
                                ticketDocumentNumber(ticketDocumentNumber.getOrNull())

                            /**
                             * Sets [Builder.ticketDocumentNumber] to an arbitrary JSON value.
                             *
                             * You should usually call [Builder.ticketDocumentNumber] with a
                             * well-typed [String] value instead. This method is primarily for
                             * setting the field to an undocumented or not yet supported value.
                             */
                            fun ticketDocumentNumber(ticketDocumentNumber: JsonField<String>) =
                                apply {
                                    this.ticketDocumentNumber = ticketDocumentNumber
                                }

                            fun additionalProperties(additionalProperties: Map<String, JsonValue>) =
                                apply {
                                    this.additionalProperties.clear()
                                    putAllAdditionalProperties(additionalProperties)
                                }

                            fun putAdditionalProperty(key: String, value: JsonValue) = apply {
                                additionalProperties.put(key, value)
                            }

                            fun putAllAdditionalProperties(
                                additionalProperties: Map<String, JsonValue>
                            ) = apply { this.additionalProperties.putAll(additionalProperties) }

                            fun removeAdditionalProperty(key: String) = apply {
                                additionalProperties.remove(key)
                            }

                            fun removeAllAdditionalProperties(keys: Set<String>) = apply {
                                keys.forEach(::removeAdditionalProperty)
                            }

                            /**
                             * Returns an immutable instance of [Ancillary].
                             *
                             * Further updates to this [Builder] will not mutate the returned
                             * instance.
                             *
                             * The following fields are required:
                             * ```java
                             * .connectedTicketDocumentNumber()
                             * .creditReasonIndicator()
                             * .passengerNameOrDescription()
                             * .services()
                             * .ticketDocumentNumber()
                             * ```
                             *
                             * @throws IllegalStateException if any required field is unset.
                             */
                            fun build(): Ancillary =
                                Ancillary(
                                    checkRequired(
                                        "connectedTicketDocumentNumber",
                                        connectedTicketDocumentNumber,
                                    ),
                                    checkRequired("creditReasonIndicator", creditReasonIndicator),
                                    checkRequired(
                                        "passengerNameOrDescription",
                                        passengerNameOrDescription,
                                    ),
                                    checkRequired("services", services).map { it.toImmutable() },
                                    checkRequired("ticketDocumentNumber", ticketDocumentNumber),
                                    additionalProperties.toMutableMap(),
                                )
                        }

                        private var validated: Boolean = false

                        fun validate(): Ancillary = apply {
                            if (validated) {
                                return@apply
                            }

                            connectedTicketDocumentNumber()
                            creditReasonIndicator().ifPresent { it.validate() }
                            passengerNameOrDescription()
                            services().forEach { it.validate() }
                            ticketDocumentNumber()
                            validated = true
                        }

                        fun isValid(): Boolean =
                            try {
                                validate()
                                true
                            } catch (e: IncreaseInvalidDataException) {
                                false
                            }

                        /**
                         * Returns a score indicating how many valid values are contained in this
                         * object recursively.
                         *
                         * Used for best match union deserialization.
                         */
                        @JvmSynthetic
                        internal fun validity(): Int =
                            (if (connectedTicketDocumentNumber.asKnown().isPresent) 1 else 0) +
                                (creditReasonIndicator.asKnown().getOrNull()?.validity() ?: 0) +
                                (if (passengerNameOrDescription.asKnown().isPresent) 1 else 0) +
                                (services.asKnown().getOrNull()?.sumOf { it.validity().toInt() }
                                    ?: 0) +
                                (if (ticketDocumentNumber.asKnown().isPresent) 1 else 0)

                        /** Indicates the reason for a credit to the cardholder. */
                        class CreditReasonIndicator
                        @JsonCreator
                        private constructor(private val value: JsonField<String>) : Enum {

                            /**
                             * Returns this class instance's raw value.
                             *
                             * This is usually only useful if this instance was deserialized from
                             * data that doesn't match any known member, and you want to know that
                             * value. For example, if the SDK is on an older version than the API,
                             * then the API may respond with new members that the SDK is unaware of.
                             */
                            @com.fasterxml.jackson.annotation.JsonValue
                            fun _value(): JsonField<String> = value

                            companion object {

                                /** No credit */
                                @JvmField val NO_CREDIT = of("no_credit")

                                /** Passenger transport ancillary purchase cancellation */
                                @JvmField
                                val PASSENGER_TRANSPORT_ANCILLARY_PURCHASE_CANCELLATION =
                                    of("passenger_transport_ancillary_purchase_cancellation")

                                /**
                                 * Airline ticket and passenger transport ancillary purchase
                                 * cancellation
                                 */
                                @JvmField
                                val AIRLINE_TICKET_AND_PASSENGER_TRANSPORT_ANCILLARY_PURCHASE_CANCELLATION =
                                    of(
                                        "airline_ticket_and_passenger_transport_ancillary_purchase_cancellation"
                                    )

                                /** Other */
                                @JvmField val OTHER = of("other")

                                @JvmStatic
                                fun of(value: String) = CreditReasonIndicator(JsonField.of(value))
                            }

                            /** An enum containing [CreditReasonIndicator]'s known values. */
                            enum class Known {
                                /** No credit */
                                NO_CREDIT,
                                /** Passenger transport ancillary purchase cancellation */
                                PASSENGER_TRANSPORT_ANCILLARY_PURCHASE_CANCELLATION,
                                /**
                                 * Airline ticket and passenger transport ancillary purchase
                                 * cancellation
                                 */
                                AIRLINE_TICKET_AND_PASSENGER_TRANSPORT_ANCILLARY_PURCHASE_CANCELLATION,
                                /** Other */
                                OTHER,
                            }

                            /**
                             * An enum containing [CreditReasonIndicator]'s known values, as well as
                             * an [_UNKNOWN] member.
                             *
                             * An instance of [CreditReasonIndicator] can contain an unknown value
                             * in a couple of cases:
                             * - It was deserialized from data that doesn't match any known member.
                             *   For example, if the SDK is on an older version than the API, then
                             *   the API may respond with new members that the SDK is unaware of.
                             * - It was constructed with an arbitrary value using the [of] method.
                             */
                            enum class Value {
                                /** No credit */
                                NO_CREDIT,
                                /** Passenger transport ancillary purchase cancellation */
                                PASSENGER_TRANSPORT_ANCILLARY_PURCHASE_CANCELLATION,
                                /**
                                 * Airline ticket and passenger transport ancillary purchase
                                 * cancellation
                                 */
                                AIRLINE_TICKET_AND_PASSENGER_TRANSPORT_ANCILLARY_PURCHASE_CANCELLATION,
                                /** Other */
                                OTHER,
                                /**
                                 * An enum member indicating that [CreditReasonIndicator] was
                                 * instantiated with an unknown value.
                                 */
                                _UNKNOWN,
                            }

                            /**
                             * Returns an enum member corresponding to this class instance's value,
                             * or [Value._UNKNOWN] if the class was instantiated with an unknown
                             * value.
                             *
                             * Use the [known] method instead if you're certain the value is always
                             * known or if you want to throw for the unknown case.
                             */
                            fun value(): Value =
                                when (this) {
                                    NO_CREDIT -> Value.NO_CREDIT
                                    PASSENGER_TRANSPORT_ANCILLARY_PURCHASE_CANCELLATION ->
                                        Value.PASSENGER_TRANSPORT_ANCILLARY_PURCHASE_CANCELLATION
                                    AIRLINE_TICKET_AND_PASSENGER_TRANSPORT_ANCILLARY_PURCHASE_CANCELLATION ->
                                        Value
                                            .AIRLINE_TICKET_AND_PASSENGER_TRANSPORT_ANCILLARY_PURCHASE_CANCELLATION
                                    OTHER -> Value.OTHER
                                    else -> Value._UNKNOWN
                                }

                            /**
                             * Returns an enum member corresponding to this class instance's value.
                             *
                             * Use the [value] method instead if you're uncertain the value is
                             * always known and don't want to throw for the unknown case.
                             *
                             * @throws IncreaseInvalidDataException if this class instance's value
                             *   is a not a known member.
                             */
                            fun known(): Known =
                                when (this) {
                                    NO_CREDIT -> Known.NO_CREDIT
                                    PASSENGER_TRANSPORT_ANCILLARY_PURCHASE_CANCELLATION ->
                                        Known.PASSENGER_TRANSPORT_ANCILLARY_PURCHASE_CANCELLATION
                                    AIRLINE_TICKET_AND_PASSENGER_TRANSPORT_ANCILLARY_PURCHASE_CANCELLATION ->
                                        Known
                                            .AIRLINE_TICKET_AND_PASSENGER_TRANSPORT_ANCILLARY_PURCHASE_CANCELLATION
                                    OTHER -> Known.OTHER
                                    else ->
                                        throw IncreaseInvalidDataException(
                                            "Unknown CreditReasonIndicator: $value"
                                        )
                                }

                            /**
                             * Returns this class instance's primitive wire representation.
                             *
                             * This differs from the [toString] method because that method is
                             * primarily for debugging and generally doesn't throw.
                             *
                             * @throws IncreaseInvalidDataException if this class instance's value
                             *   does not have the expected primitive type.
                             */
                            fun asString(): String =
                                _value().asString().orElseThrow {
                                    IncreaseInvalidDataException("Value is not a String")
                                }

                            private var validated: Boolean = false

                            fun validate(): CreditReasonIndicator = apply {
                                if (validated) {
                                    return@apply
                                }

                                known()
                                validated = true
                            }

                            fun isValid(): Boolean =
                                try {
                                    validate()
                                    true
                                } catch (e: IncreaseInvalidDataException) {
                                    false
                                }

                            /**
                             * Returns a score indicating how many valid values are contained in
                             * this object recursively.
                             *
                             * Used for best match union deserialization.
                             */
                            @JvmSynthetic
                            internal fun validity(): Int = if (value() == Value._UNKNOWN) 0 else 1

                            override fun equals(other: Any?): Boolean {
                                if (this === other) {
                                    return true
                                }

                                return /* spotless:off */ other is CreditReasonIndicator && value == other.value /* spotless:on */
                            }

                            override fun hashCode() = value.hashCode()

                            override fun toString() = value.toString()
                        }

                        class Service
                        private constructor(
                            private val category: JsonField<Category>,
                            private val subCategory: JsonField<String>,
                            private val additionalProperties: MutableMap<String, JsonValue>,
                        ) {

                            @JsonCreator
                            private constructor(
                                @JsonProperty("category")
                                @ExcludeMissing
                                category: JsonField<Category> = JsonMissing.of(),
                                @JsonProperty("sub_category")
                                @ExcludeMissing
                                subCategory: JsonField<String> = JsonMissing.of(),
                            ) : this(category, subCategory, mutableMapOf())

                            /**
                             * Category of the ancillary service.
                             *
                             * @throws IncreaseInvalidDataException if the JSON field has an
                             *   unexpected type (e.g. if the server responded with an unexpected
                             *   value).
                             */
                            fun category(): Optional<Category> = category.getOptional("category")

                            /**
                             * Sub-category of the ancillary service, free-form.
                             *
                             * @throws IncreaseInvalidDataException if the JSON field has an
                             *   unexpected type (e.g. if the server responded with an unexpected
                             *   value).
                             */
                            fun subCategory(): Optional<String> =
                                subCategory.getOptional("sub_category")

                            /**
                             * Returns the raw JSON value of [category].
                             *
                             * Unlike [category], this method doesn't throw if the JSON field has an
                             * unexpected type.
                             */
                            @JsonProperty("category")
                            @ExcludeMissing
                            fun _category(): JsonField<Category> = category

                            /**
                             * Returns the raw JSON value of [subCategory].
                             *
                             * Unlike [subCategory], this method doesn't throw if the JSON field has
                             * an unexpected type.
                             */
                            @JsonProperty("sub_category")
                            @ExcludeMissing
                            fun _subCategory(): JsonField<String> = subCategory

                            @JsonAnySetter
                            private fun putAdditionalProperty(key: String, value: JsonValue) {
                                additionalProperties.put(key, value)
                            }

                            @JsonAnyGetter
                            @ExcludeMissing
                            fun _additionalProperties(): Map<String, JsonValue> =
                                Collections.unmodifiableMap(additionalProperties)

                            fun toBuilder() = Builder().from(this)

                            companion object {

                                /**
                                 * Returns a mutable builder for constructing an instance of
                                 * [Service].
                                 *
                                 * The following fields are required:
                                 * ```java
                                 * .category()
                                 * .subCategory()
                                 * ```
                                 */
                                @JvmStatic fun builder() = Builder()
                            }

                            /** A builder for [Service]. */
                            class Builder internal constructor() {

                                private var category: JsonField<Category>? = null
                                private var subCategory: JsonField<String>? = null
                                private var additionalProperties: MutableMap<String, JsonValue> =
                                    mutableMapOf()

                                @JvmSynthetic
                                internal fun from(service: Service) = apply {
                                    category = service.category
                                    subCategory = service.subCategory
                                    additionalProperties =
                                        service.additionalProperties.toMutableMap()
                                }

                                /** Category of the ancillary service. */
                                fun category(category: Category?) =
                                    category(JsonField.ofNullable(category))

                                /**
                                 * Alias for calling [Builder.category] with
                                 * `category.orElse(null)`.
                                 */
                                fun category(category: Optional<Category>) =
                                    category(category.getOrNull())

                                /**
                                 * Sets [Builder.category] to an arbitrary JSON value.
                                 *
                                 * You should usually call [Builder.category] with a well-typed
                                 * [Category] value instead. This method is primarily for setting
                                 * the field to an undocumented or not yet supported value.
                                 */
                                fun category(category: JsonField<Category>) = apply {
                                    this.category = category
                                }

                                /** Sub-category of the ancillary service, free-form. */
                                fun subCategory(subCategory: String?) =
                                    subCategory(JsonField.ofNullable(subCategory))

                                /**
                                 * Alias for calling [Builder.subCategory] with
                                 * `subCategory.orElse(null)`.
                                 */
                                fun subCategory(subCategory: Optional<String>) =
                                    subCategory(subCategory.getOrNull())

                                /**
                                 * Sets [Builder.subCategory] to an arbitrary JSON value.
                                 *
                                 * You should usually call [Builder.subCategory] with a well-typed
                                 * [String] value instead. This method is primarily for setting the
                                 * field to an undocumented or not yet supported value.
                                 */
                                fun subCategory(subCategory: JsonField<String>) = apply {
                                    this.subCategory = subCategory
                                }

                                fun additionalProperties(
                                    additionalProperties: Map<String, JsonValue>
                                ) = apply {
                                    this.additionalProperties.clear()
                                    putAllAdditionalProperties(additionalProperties)
                                }

                                fun putAdditionalProperty(key: String, value: JsonValue) = apply {
                                    additionalProperties.put(key, value)
                                }

                                fun putAllAdditionalProperties(
                                    additionalProperties: Map<String, JsonValue>
                                ) = apply { this.additionalProperties.putAll(additionalProperties) }

                                fun removeAdditionalProperty(key: String) = apply {
                                    additionalProperties.remove(key)
                                }

                                fun removeAllAdditionalProperties(keys: Set<String>) = apply {
                                    keys.forEach(::removeAdditionalProperty)
                                }

                                /**
                                 * Returns an immutable instance of [Service].
                                 *
                                 * Further updates to this [Builder] will not mutate the returned
                                 * instance.
                                 *
                                 * The following fields are required:
                                 * ```java
                                 * .category()
                                 * .subCategory()
                                 * ```
                                 *
                                 * @throws IllegalStateException if any required field is unset.
                                 */
                                fun build(): Service =
                                    Service(
                                        checkRequired("category", category),
                                        checkRequired("subCategory", subCategory),
                                        additionalProperties.toMutableMap(),
                                    )
                            }

                            private var validated: Boolean = false

                            fun validate(): Service = apply {
                                if (validated) {
                                    return@apply
                                }

                                category().ifPresent { it.validate() }
                                subCategory()
                                validated = true
                            }

                            fun isValid(): Boolean =
                                try {
                                    validate()
                                    true
                                } catch (e: IncreaseInvalidDataException) {
                                    false
                                }

                            /**
                             * Returns a score indicating how many valid values are contained in
                             * this object recursively.
                             *
                             * Used for best match union deserialization.
                             */
                            @JvmSynthetic
                            internal fun validity(): Int =
                                (category.asKnown().getOrNull()?.validity() ?: 0) +
                                    (if (subCategory.asKnown().isPresent) 1 else 0)

                            /** Category of the ancillary service. */
                            class Category
                            @JsonCreator
                            private constructor(private val value: JsonField<String>) : Enum {

                                /**
                                 * Returns this class instance's raw value.
                                 *
                                 * This is usually only useful if this instance was deserialized
                                 * from data that doesn't match any known member, and you want to
                                 * know that value. For example, if the SDK is on an older version
                                 * than the API, then the API may respond with new members that the
                                 * SDK is unaware of.
                                 */
                                @com.fasterxml.jackson.annotation.JsonValue
                                fun _value(): JsonField<String> = value

                                companion object {

                                    /** None */
                                    @JvmField val NONE = of("none")

                                    /** Bundled service */
                                    @JvmField val BUNDLED_SERVICE = of("bundled_service")

                                    /** Baggage fee */
                                    @JvmField val BAGGAGE_FEE = of("baggage_fee")

                                    /** Change fee */
                                    @JvmField val CHANGE_FEE = of("change_fee")

                                    /** Cargo */
                                    @JvmField val CARGO = of("cargo")

                                    /** Carbon offset */
                                    @JvmField val CARBON_OFFSET = of("carbon_offset")

                                    /** Frequent flyer */
                                    @JvmField val FREQUENT_FLYER = of("frequent_flyer")

                                    /** Gift card */
                                    @JvmField val GIFT_CARD = of("gift_card")

                                    /** Ground transport */
                                    @JvmField val GROUND_TRANSPORT = of("ground_transport")

                                    /** In-flight entertainment */
                                    @JvmField
                                    val IN_FLIGHT_ENTERTAINMENT = of("in_flight_entertainment")

                                    /** Lounge */
                                    @JvmField val LOUNGE = of("lounge")

                                    /** Medical */
                                    @JvmField val MEDICAL = of("medical")

                                    /** Meal beverage */
                                    @JvmField val MEAL_BEVERAGE = of("meal_beverage")

                                    /** Other */
                                    @JvmField val OTHER = of("other")

                                    /** Passenger assist fee */
                                    @JvmField val PASSENGER_ASSIST_FEE = of("passenger_assist_fee")

                                    /** Pets */
                                    @JvmField val PETS = of("pets")

                                    /** Seat fees */
                                    @JvmField val SEAT_FEES = of("seat_fees")

                                    /** Standby */
                                    @JvmField val STANDBY = of("standby")

                                    /** Service fee */
                                    @JvmField val SERVICE_FEE = of("service_fee")

                                    /** Store */
                                    @JvmField val STORE = of("store")

                                    /** Travel service */
                                    @JvmField val TRAVEL_SERVICE = of("travel_service")

                                    /** Unaccompanied travel */
                                    @JvmField val UNACCOMPANIED_TRAVEL = of("unaccompanied_travel")

                                    /** Upgrades */
                                    @JvmField val UPGRADES = of("upgrades")

                                    /** Wi-fi */
                                    @JvmField val WIFI = of("wifi")

                                    @JvmStatic fun of(value: String) = Category(JsonField.of(value))
                                }

                                /** An enum containing [Category]'s known values. */
                                enum class Known {
                                    /** None */
                                    NONE,
                                    /** Bundled service */
                                    BUNDLED_SERVICE,
                                    /** Baggage fee */
                                    BAGGAGE_FEE,
                                    /** Change fee */
                                    CHANGE_FEE,
                                    /** Cargo */
                                    CARGO,
                                    /** Carbon offset */
                                    CARBON_OFFSET,
                                    /** Frequent flyer */
                                    FREQUENT_FLYER,
                                    /** Gift card */
                                    GIFT_CARD,
                                    /** Ground transport */
                                    GROUND_TRANSPORT,
                                    /** In-flight entertainment */
                                    IN_FLIGHT_ENTERTAINMENT,
                                    /** Lounge */
                                    LOUNGE,
                                    /** Medical */
                                    MEDICAL,
                                    /** Meal beverage */
                                    MEAL_BEVERAGE,
                                    /** Other */
                                    OTHER,
                                    /** Passenger assist fee */
                                    PASSENGER_ASSIST_FEE,
                                    /** Pets */
                                    PETS,
                                    /** Seat fees */
                                    SEAT_FEES,
                                    /** Standby */
                                    STANDBY,
                                    /** Service fee */
                                    SERVICE_FEE,
                                    /** Store */
                                    STORE,
                                    /** Travel service */
                                    TRAVEL_SERVICE,
                                    /** Unaccompanied travel */
                                    UNACCOMPANIED_TRAVEL,
                                    /** Upgrades */
                                    UPGRADES,
                                    /** Wi-fi */
                                    WIFI,
                                }

                                /**
                                 * An enum containing [Category]'s known values, as well as an
                                 * [_UNKNOWN] member.
                                 *
                                 * An instance of [Category] can contain an unknown value in a
                                 * couple of cases:
                                 * - It was deserialized from data that doesn't match any known
                                 *   member. For example, if the SDK is on an older version than the
                                 *   API, then the API may respond with new members that the SDK is
                                 *   unaware of.
                                 * - It was constructed with an arbitrary value using the [of]
                                 *   method.
                                 */
                                enum class Value {
                                    /** None */
                                    NONE,
                                    /** Bundled service */
                                    BUNDLED_SERVICE,
                                    /** Baggage fee */
                                    BAGGAGE_FEE,
                                    /** Change fee */
                                    CHANGE_FEE,
                                    /** Cargo */
                                    CARGO,
                                    /** Carbon offset */
                                    CARBON_OFFSET,
                                    /** Frequent flyer */
                                    FREQUENT_FLYER,
                                    /** Gift card */
                                    GIFT_CARD,
                                    /** Ground transport */
                                    GROUND_TRANSPORT,
                                    /** In-flight entertainment */
                                    IN_FLIGHT_ENTERTAINMENT,
                                    /** Lounge */
                                    LOUNGE,
                                    /** Medical */
                                    MEDICAL,
                                    /** Meal beverage */
                                    MEAL_BEVERAGE,
                                    /** Other */
                                    OTHER,
                                    /** Passenger assist fee */
                                    PASSENGER_ASSIST_FEE,
                                    /** Pets */
                                    PETS,
                                    /** Seat fees */
                                    SEAT_FEES,
                                    /** Standby */
                                    STANDBY,
                                    /** Service fee */
                                    SERVICE_FEE,
                                    /** Store */
                                    STORE,
                                    /** Travel service */
                                    TRAVEL_SERVICE,
                                    /** Unaccompanied travel */
                                    UNACCOMPANIED_TRAVEL,
                                    /** Upgrades */
                                    UPGRADES,
                                    /** Wi-fi */
                                    WIFI,
                                    /**
                                     * An enum member indicating that [Category] was instantiated
                                     * with an unknown value.
                                     */
                                    _UNKNOWN,
                                }

                                /**
                                 * Returns an enum member corresponding to this class instance's
                                 * value, or [Value._UNKNOWN] if the class was instantiated with an
                                 * unknown value.
                                 *
                                 * Use the [known] method instead if you're certain the value is
                                 * always known or if you want to throw for the unknown case.
                                 */
                                fun value(): Value =
                                    when (this) {
                                        NONE -> Value.NONE
                                        BUNDLED_SERVICE -> Value.BUNDLED_SERVICE
                                        BAGGAGE_FEE -> Value.BAGGAGE_FEE
                                        CHANGE_FEE -> Value.CHANGE_FEE
                                        CARGO -> Value.CARGO
                                        CARBON_OFFSET -> Value.CARBON_OFFSET
                                        FREQUENT_FLYER -> Value.FREQUENT_FLYER
                                        GIFT_CARD -> Value.GIFT_CARD
                                        GROUND_TRANSPORT -> Value.GROUND_TRANSPORT
                                        IN_FLIGHT_ENTERTAINMENT -> Value.IN_FLIGHT_ENTERTAINMENT
                                        LOUNGE -> Value.LOUNGE
                                        MEDICAL -> Value.MEDICAL
                                        MEAL_BEVERAGE -> Value.MEAL_BEVERAGE
                                        OTHER -> Value.OTHER
                                        PASSENGER_ASSIST_FEE -> Value.PASSENGER_ASSIST_FEE
                                        PETS -> Value.PETS
                                        SEAT_FEES -> Value.SEAT_FEES
                                        STANDBY -> Value.STANDBY
                                        SERVICE_FEE -> Value.SERVICE_FEE
                                        STORE -> Value.STORE
                                        TRAVEL_SERVICE -> Value.TRAVEL_SERVICE
                                        UNACCOMPANIED_TRAVEL -> Value.UNACCOMPANIED_TRAVEL
                                        UPGRADES -> Value.UPGRADES
                                        WIFI -> Value.WIFI
                                        else -> Value._UNKNOWN
                                    }

                                /**
                                 * Returns an enum member corresponding to this class instance's
                                 * value.
                                 *
                                 * Use the [value] method instead if you're uncertain the value is
                                 * always known and don't want to throw for the unknown case.
                                 *
                                 * @throws IncreaseInvalidDataException if this class instance's
                                 *   value is a not a known member.
                                 */
                                fun known(): Known =
                                    when (this) {
                                        NONE -> Known.NONE
                                        BUNDLED_SERVICE -> Known.BUNDLED_SERVICE
                                        BAGGAGE_FEE -> Known.BAGGAGE_FEE
                                        CHANGE_FEE -> Known.CHANGE_FEE
                                        CARGO -> Known.CARGO
                                        CARBON_OFFSET -> Known.CARBON_OFFSET
                                        FREQUENT_FLYER -> Known.FREQUENT_FLYER
                                        GIFT_CARD -> Known.GIFT_CARD
                                        GROUND_TRANSPORT -> Known.GROUND_TRANSPORT
                                        IN_FLIGHT_ENTERTAINMENT -> Known.IN_FLIGHT_ENTERTAINMENT
                                        LOUNGE -> Known.LOUNGE
                                        MEDICAL -> Known.MEDICAL
                                        MEAL_BEVERAGE -> Known.MEAL_BEVERAGE
                                        OTHER -> Known.OTHER
                                        PASSENGER_ASSIST_FEE -> Known.PASSENGER_ASSIST_FEE
                                        PETS -> Known.PETS
                                        SEAT_FEES -> Known.SEAT_FEES
                                        STANDBY -> Known.STANDBY
                                        SERVICE_FEE -> Known.SERVICE_FEE
                                        STORE -> Known.STORE
                                        TRAVEL_SERVICE -> Known.TRAVEL_SERVICE
                                        UNACCOMPANIED_TRAVEL -> Known.UNACCOMPANIED_TRAVEL
                                        UPGRADES -> Known.UPGRADES
                                        WIFI -> Known.WIFI
                                        else ->
                                            throw IncreaseInvalidDataException(
                                                "Unknown Category: $value"
                                            )
                                    }

                                /**
                                 * Returns this class instance's primitive wire representation.
                                 *
                                 * This differs from the [toString] method because that method is
                                 * primarily for debugging and generally doesn't throw.
                                 *
                                 * @throws IncreaseInvalidDataException if this class instance's
                                 *   value does not have the expected primitive type.
                                 */
                                fun asString(): String =
                                    _value().asString().orElseThrow {
                                        IncreaseInvalidDataException("Value is not a String")
                                    }

                                private var validated: Boolean = false

                                fun validate(): Category = apply {
                                    if (validated) {
                                        return@apply
                                    }

                                    known()
                                    validated = true
                                }

                                fun isValid(): Boolean =
                                    try {
                                        validate()
                                        true
                                    } catch (e: IncreaseInvalidDataException) {
                                        false
                                    }

                                /**
                                 * Returns a score indicating how many valid values are contained in
                                 * this object recursively.
                                 *
                                 * Used for best match union deserialization.
                                 */
                                @JvmSynthetic
                                internal fun validity(): Int =
                                    if (value() == Value._UNKNOWN) 0 else 1

                                override fun equals(other: Any?): Boolean {
                                    if (this === other) {
                                        return true
                                    }

                                    return /* spotless:off */ other is Category && value == other.value /* spotless:on */
                                }

                                override fun hashCode() = value.hashCode()

                                override fun toString() = value.toString()
                            }

                            override fun equals(other: Any?): Boolean {
                                if (this === other) {
                                    return true
                                }

                                return /* spotless:off */ other is Service && category == other.category && subCategory == other.subCategory && additionalProperties == other.additionalProperties /* spotless:on */
                            }

                            /* spotless:off */
                            private val hashCode: Int by lazy { Objects.hash(category, subCategory, additionalProperties) }
                            /* spotless:on */

                            override fun hashCode(): Int = hashCode

                            override fun toString() =
                                "Service{category=$category, subCategory=$subCategory, additionalProperties=$additionalProperties}"
                        }

                        override fun equals(other: Any?): Boolean {
                            if (this === other) {
                                return true
                            }

                            return /* spotless:off */ other is Ancillary && connectedTicketDocumentNumber == other.connectedTicketDocumentNumber && creditReasonIndicator == other.creditReasonIndicator && passengerNameOrDescription == other.passengerNameOrDescription && services == other.services && ticketDocumentNumber == other.ticketDocumentNumber && additionalProperties == other.additionalProperties /* spotless:on */
                        }

                        /* spotless:off */
                        private val hashCode: Int by lazy { Objects.hash(connectedTicketDocumentNumber, creditReasonIndicator, passengerNameOrDescription, services, ticketDocumentNumber, additionalProperties) }
                        /* spotless:on */

                        override fun hashCode(): Int = hashCode

                        override fun toString() =
                            "Ancillary{connectedTicketDocumentNumber=$connectedTicketDocumentNumber, creditReasonIndicator=$creditReasonIndicator, passengerNameOrDescription=$passengerNameOrDescription, services=$services, ticketDocumentNumber=$ticketDocumentNumber, additionalProperties=$additionalProperties}"
                    }

                    /** Indicates the reason for a credit to the cardholder. */
                    class CreditReasonIndicator
                    @JsonCreator
                    private constructor(private val value: JsonField<String>) : Enum {

                        /**
                         * Returns this class instance's raw value.
                         *
                         * This is usually only useful if this instance was deserialized from data
                         * that doesn't match any known member, and you want to know that value. For
                         * example, if the SDK is on an older version than the API, then the API may
                         * respond with new members that the SDK is unaware of.
                         */
                        @com.fasterxml.jackson.annotation.JsonValue
                        fun _value(): JsonField<String> = value

                        companion object {

                            /** No credit */
                            @JvmField val NO_CREDIT = of("no_credit")

                            /** Passenger transport ancillary purchase cancellation */
                            @JvmField
                            val PASSENGER_TRANSPORT_ANCILLARY_PURCHASE_CANCELLATION =
                                of("passenger_transport_ancillary_purchase_cancellation")

                            /**
                             * Airline ticket and passenger transport ancillary purchase
                             * cancellation
                             */
                            @JvmField
                            val AIRLINE_TICKET_AND_PASSENGER_TRANSPORT_ANCILLARY_PURCHASE_CANCELLATION =
                                of(
                                    "airline_ticket_and_passenger_transport_ancillary_purchase_cancellation"
                                )

                            /** Airline ticket cancellation */
                            @JvmField
                            val AIRLINE_TICKET_CANCELLATION = of("airline_ticket_cancellation")

                            /** Other */
                            @JvmField val OTHER = of("other")

                            /** Partial refund of airline ticket */
                            @JvmField
                            val PARTIAL_REFUND_OF_AIRLINE_TICKET =
                                of("partial_refund_of_airline_ticket")

                            @JvmStatic
                            fun of(value: String) = CreditReasonIndicator(JsonField.of(value))
                        }

                        /** An enum containing [CreditReasonIndicator]'s known values. */
                        enum class Known {
                            /** No credit */
                            NO_CREDIT,
                            /** Passenger transport ancillary purchase cancellation */
                            PASSENGER_TRANSPORT_ANCILLARY_PURCHASE_CANCELLATION,
                            /**
                             * Airline ticket and passenger transport ancillary purchase
                             * cancellation
                             */
                            AIRLINE_TICKET_AND_PASSENGER_TRANSPORT_ANCILLARY_PURCHASE_CANCELLATION,
                            /** Airline ticket cancellation */
                            AIRLINE_TICKET_CANCELLATION,
                            /** Other */
                            OTHER,
                            /** Partial refund of airline ticket */
                            PARTIAL_REFUND_OF_AIRLINE_TICKET,
                        }

                        /**
                         * An enum containing [CreditReasonIndicator]'s known values, as well as an
                         * [_UNKNOWN] member.
                         *
                         * An instance of [CreditReasonIndicator] can contain an unknown value in a
                         * couple of cases:
                         * - It was deserialized from data that doesn't match any known member. For
                         *   example, if the SDK is on an older version than the API, then the API
                         *   may respond with new members that the SDK is unaware of.
                         * - It was constructed with an arbitrary value using the [of] method.
                         */
                        enum class Value {
                            /** No credit */
                            NO_CREDIT,
                            /** Passenger transport ancillary purchase cancellation */
                            PASSENGER_TRANSPORT_ANCILLARY_PURCHASE_CANCELLATION,
                            /**
                             * Airline ticket and passenger transport ancillary purchase
                             * cancellation
                             */
                            AIRLINE_TICKET_AND_PASSENGER_TRANSPORT_ANCILLARY_PURCHASE_CANCELLATION,
                            /** Airline ticket cancellation */
                            AIRLINE_TICKET_CANCELLATION,
                            /** Other */
                            OTHER,
                            /** Partial refund of airline ticket */
                            PARTIAL_REFUND_OF_AIRLINE_TICKET,
                            /**
                             * An enum member indicating that [CreditReasonIndicator] was
                             * instantiated with an unknown value.
                             */
                            _UNKNOWN,
                        }

                        /**
                         * Returns an enum member corresponding to this class instance's value, or
                         * [Value._UNKNOWN] if the class was instantiated with an unknown value.
                         *
                         * Use the [known] method instead if you're certain the value is always
                         * known or if you want to throw for the unknown case.
                         */
                        fun value(): Value =
                            when (this) {
                                NO_CREDIT -> Value.NO_CREDIT
                                PASSENGER_TRANSPORT_ANCILLARY_PURCHASE_CANCELLATION ->
                                    Value.PASSENGER_TRANSPORT_ANCILLARY_PURCHASE_CANCELLATION
                                AIRLINE_TICKET_AND_PASSENGER_TRANSPORT_ANCILLARY_PURCHASE_CANCELLATION ->
                                    Value
                                        .AIRLINE_TICKET_AND_PASSENGER_TRANSPORT_ANCILLARY_PURCHASE_CANCELLATION
                                AIRLINE_TICKET_CANCELLATION -> Value.AIRLINE_TICKET_CANCELLATION
                                OTHER -> Value.OTHER
                                PARTIAL_REFUND_OF_AIRLINE_TICKET ->
                                    Value.PARTIAL_REFUND_OF_AIRLINE_TICKET
                                else -> Value._UNKNOWN
                            }

                        /**
                         * Returns an enum member corresponding to this class instance's value.
                         *
                         * Use the [value] method instead if you're uncertain the value is always
                         * known and don't want to throw for the unknown case.
                         *
                         * @throws IncreaseInvalidDataException if this class instance's value is a
                         *   not a known member.
                         */
                        fun known(): Known =
                            when (this) {
                                NO_CREDIT -> Known.NO_CREDIT
                                PASSENGER_TRANSPORT_ANCILLARY_PURCHASE_CANCELLATION ->
                                    Known.PASSENGER_TRANSPORT_ANCILLARY_PURCHASE_CANCELLATION
                                AIRLINE_TICKET_AND_PASSENGER_TRANSPORT_ANCILLARY_PURCHASE_CANCELLATION ->
                                    Known
                                        .AIRLINE_TICKET_AND_PASSENGER_TRANSPORT_ANCILLARY_PURCHASE_CANCELLATION
                                AIRLINE_TICKET_CANCELLATION -> Known.AIRLINE_TICKET_CANCELLATION
                                OTHER -> Known.OTHER
                                PARTIAL_REFUND_OF_AIRLINE_TICKET ->
                                    Known.PARTIAL_REFUND_OF_AIRLINE_TICKET
                                else ->
                                    throw IncreaseInvalidDataException(
                                        "Unknown CreditReasonIndicator: $value"
                                    )
                            }

                        /**
                         * Returns this class instance's primitive wire representation.
                         *
                         * This differs from the [toString] method because that method is primarily
                         * for debugging and generally doesn't throw.
                         *
                         * @throws IncreaseInvalidDataException if this class instance's value does
                         *   not have the expected primitive type.
                         */
                        fun asString(): String =
                            _value().asString().orElseThrow {
                                IncreaseInvalidDataException("Value is not a String")
                            }

                        private var validated: Boolean = false

                        fun validate(): CreditReasonIndicator = apply {
                            if (validated) {
                                return@apply
                            }

                            known()
                            validated = true
                        }

                        fun isValid(): Boolean =
                            try {
                                validate()
                                true
                            } catch (e: IncreaseInvalidDataException) {
                                false
                            }

                        /**
                         * Returns a score indicating how many valid values are contained in this
                         * object recursively.
                         *
                         * Used for best match union deserialization.
                         */
                        @JvmSynthetic
                        internal fun validity(): Int = if (value() == Value._UNKNOWN) 0 else 1

                        override fun equals(other: Any?): Boolean {
                            if (this === other) {
                                return true
                            }

                            return /* spotless:off */ other is CreditReasonIndicator && value == other.value /* spotless:on */
                        }

                        override fun hashCode() = value.hashCode()

                        override fun toString() = value.toString()
                    }

                    /** Indicates whether this ticket is non-refundable. */
                    class RestrictedTicketIndicator
                    @JsonCreator
                    private constructor(private val value: JsonField<String>) : Enum {

                        /**
                         * Returns this class instance's raw value.
                         *
                         * This is usually only useful if this instance was deserialized from data
                         * that doesn't match any known member, and you want to know that value. For
                         * example, if the SDK is on an older version than the API, then the API may
                         * respond with new members that the SDK is unaware of.
                         */
                        @com.fasterxml.jackson.annotation.JsonValue
                        fun _value(): JsonField<String> = value

                        companion object {

                            /** No restrictions */
                            @JvmField val NO_RESTRICTIONS = of("no_restrictions")

                            /** Restricted non-refundable ticket */
                            @JvmField
                            val RESTRICTED_NON_REFUNDABLE_TICKET =
                                of("restricted_non_refundable_ticket")

                            @JvmStatic
                            fun of(value: String) = RestrictedTicketIndicator(JsonField.of(value))
                        }

                        /** An enum containing [RestrictedTicketIndicator]'s known values. */
                        enum class Known {
                            /** No restrictions */
                            NO_RESTRICTIONS,
                            /** Restricted non-refundable ticket */
                            RESTRICTED_NON_REFUNDABLE_TICKET,
                        }

                        /**
                         * An enum containing [RestrictedTicketIndicator]'s known values, as well as
                         * an [_UNKNOWN] member.
                         *
                         * An instance of [RestrictedTicketIndicator] can contain an unknown value
                         * in a couple of cases:
                         * - It was deserialized from data that doesn't match any known member. For
                         *   example, if the SDK is on an older version than the API, then the API
                         *   may respond with new members that the SDK is unaware of.
                         * - It was constructed with an arbitrary value using the [of] method.
                         */
                        enum class Value {
                            /** No restrictions */
                            NO_RESTRICTIONS,
                            /** Restricted non-refundable ticket */
                            RESTRICTED_NON_REFUNDABLE_TICKET,
                            /**
                             * An enum member indicating that [RestrictedTicketIndicator] was
                             * instantiated with an unknown value.
                             */
                            _UNKNOWN,
                        }

                        /**
                         * Returns an enum member corresponding to this class instance's value, or
                         * [Value._UNKNOWN] if the class was instantiated with an unknown value.
                         *
                         * Use the [known] method instead if you're certain the value is always
                         * known or if you want to throw for the unknown case.
                         */
                        fun value(): Value =
                            when (this) {
                                NO_RESTRICTIONS -> Value.NO_RESTRICTIONS
                                RESTRICTED_NON_REFUNDABLE_TICKET ->
                                    Value.RESTRICTED_NON_REFUNDABLE_TICKET
                                else -> Value._UNKNOWN
                            }

                        /**
                         * Returns an enum member corresponding to this class instance's value.
                         *
                         * Use the [value] method instead if you're uncertain the value is always
                         * known and don't want to throw for the unknown case.
                         *
                         * @throws IncreaseInvalidDataException if this class instance's value is a
                         *   not a known member.
                         */
                        fun known(): Known =
                            when (this) {
                                NO_RESTRICTIONS -> Known.NO_RESTRICTIONS
                                RESTRICTED_NON_REFUNDABLE_TICKET ->
                                    Known.RESTRICTED_NON_REFUNDABLE_TICKET
                                else ->
                                    throw IncreaseInvalidDataException(
                                        "Unknown RestrictedTicketIndicator: $value"
                                    )
                            }

                        /**
                         * Returns this class instance's primitive wire representation.
                         *
                         * This differs from the [toString] method because that method is primarily
                         * for debugging and generally doesn't throw.
                         *
                         * @throws IncreaseInvalidDataException if this class instance's value does
                         *   not have the expected primitive type.
                         */
                        fun asString(): String =
                            _value().asString().orElseThrow {
                                IncreaseInvalidDataException("Value is not a String")
                            }

                        private var validated: Boolean = false

                        fun validate(): RestrictedTicketIndicator = apply {
                            if (validated) {
                                return@apply
                            }

                            known()
                            validated = true
                        }

                        fun isValid(): Boolean =
                            try {
                                validate()
                                true
                            } catch (e: IncreaseInvalidDataException) {
                                false
                            }

                        /**
                         * Returns a score indicating how many valid values are contained in this
                         * object recursively.
                         *
                         * Used for best match union deserialization.
                         */
                        @JvmSynthetic
                        internal fun validity(): Int = if (value() == Value._UNKNOWN) 0 else 1

                        override fun equals(other: Any?): Boolean {
                            if (this === other) {
                                return true
                            }

                            return /* spotless:off */ other is RestrictedTicketIndicator && value == other.value /* spotless:on */
                        }

                        override fun hashCode() = value.hashCode()

                        override fun toString() = value.toString()
                    }

                    /** Indicates why a ticket was changed. */
                    class TicketChangeIndicator
                    @JsonCreator
                    private constructor(private val value: JsonField<String>) : Enum {

                        /**
                         * Returns this class instance's raw value.
                         *
                         * This is usually only useful if this instance was deserialized from data
                         * that doesn't match any known member, and you want to know that value. For
                         * example, if the SDK is on an older version than the API, then the API may
                         * respond with new members that the SDK is unaware of.
                         */
                        @com.fasterxml.jackson.annotation.JsonValue
                        fun _value(): JsonField<String> = value

                        companion object {

                            /** None */
                            @JvmField val NONE = of("none")

                            /** Change to existing ticket */
                            @JvmField
                            val CHANGE_TO_EXISTING_TICKET = of("change_to_existing_ticket")

                            /** New ticket */
                            @JvmField val NEW_TICKET = of("new_ticket")

                            @JvmStatic
                            fun of(value: String) = TicketChangeIndicator(JsonField.of(value))
                        }

                        /** An enum containing [TicketChangeIndicator]'s known values. */
                        enum class Known {
                            /** None */
                            NONE,
                            /** Change to existing ticket */
                            CHANGE_TO_EXISTING_TICKET,
                            /** New ticket */
                            NEW_TICKET,
                        }

                        /**
                         * An enum containing [TicketChangeIndicator]'s known values, as well as an
                         * [_UNKNOWN] member.
                         *
                         * An instance of [TicketChangeIndicator] can contain an unknown value in a
                         * couple of cases:
                         * - It was deserialized from data that doesn't match any known member. For
                         *   example, if the SDK is on an older version than the API, then the API
                         *   may respond with new members that the SDK is unaware of.
                         * - It was constructed with an arbitrary value using the [of] method.
                         */
                        enum class Value {
                            /** None */
                            NONE,
                            /** Change to existing ticket */
                            CHANGE_TO_EXISTING_TICKET,
                            /** New ticket */
                            NEW_TICKET,
                            /**
                             * An enum member indicating that [TicketChangeIndicator] was
                             * instantiated with an unknown value.
                             */
                            _UNKNOWN,
                        }

                        /**
                         * Returns an enum member corresponding to this class instance's value, or
                         * [Value._UNKNOWN] if the class was instantiated with an unknown value.
                         *
                         * Use the [known] method instead if you're certain the value is always
                         * known or if you want to throw for the unknown case.
                         */
                        fun value(): Value =
                            when (this) {
                                NONE -> Value.NONE
                                CHANGE_TO_EXISTING_TICKET -> Value.CHANGE_TO_EXISTING_TICKET
                                NEW_TICKET -> Value.NEW_TICKET
                                else -> Value._UNKNOWN
                            }

                        /**
                         * Returns an enum member corresponding to this class instance's value.
                         *
                         * Use the [value] method instead if you're uncertain the value is always
                         * known and don't want to throw for the unknown case.
                         *
                         * @throws IncreaseInvalidDataException if this class instance's value is a
                         *   not a known member.
                         */
                        fun known(): Known =
                            when (this) {
                                NONE -> Known.NONE
                                CHANGE_TO_EXISTING_TICKET -> Known.CHANGE_TO_EXISTING_TICKET
                                NEW_TICKET -> Known.NEW_TICKET
                                else ->
                                    throw IncreaseInvalidDataException(
                                        "Unknown TicketChangeIndicator: $value"
                                    )
                            }

                        /**
                         * Returns this class instance's primitive wire representation.
                         *
                         * This differs from the [toString] method because that method is primarily
                         * for debugging and generally doesn't throw.
                         *
                         * @throws IncreaseInvalidDataException if this class instance's value does
                         *   not have the expected primitive type.
                         */
                        fun asString(): String =
                            _value().asString().orElseThrow {
                                IncreaseInvalidDataException("Value is not a String")
                            }

                        private var validated: Boolean = false

                        fun validate(): TicketChangeIndicator = apply {
                            if (validated) {
                                return@apply
                            }

                            known()
                            validated = true
                        }

                        fun isValid(): Boolean =
                            try {
                                validate()
                                true
                            } catch (e: IncreaseInvalidDataException) {
                                false
                            }

                        /**
                         * Returns a score indicating how many valid values are contained in this
                         * object recursively.
                         *
                         * Used for best match union deserialization.
                         */
                        @JvmSynthetic
                        internal fun validity(): Int = if (value() == Value._UNKNOWN) 0 else 1

                        override fun equals(other: Any?): Boolean {
                            if (this === other) {
                                return true
                            }

                            return /* spotless:off */ other is TicketChangeIndicator && value == other.value /* spotless:on */
                        }

                        override fun hashCode() = value.hashCode()

                        override fun toString() = value.toString()
                    }

                    class TripLeg
                    private constructor(
                        private val carrierCode: JsonField<String>,
                        private val destinationCityAirportCode: JsonField<String>,
                        private val fareBasisCode: JsonField<String>,
                        private val flightNumber: JsonField<String>,
                        private val serviceClass: JsonField<String>,
                        private val stopOverCode: JsonField<StopOverCode>,
                        private val additionalProperties: MutableMap<String, JsonValue>,
                    ) {

                        @JsonCreator
                        private constructor(
                            @JsonProperty("carrier_code")
                            @ExcludeMissing
                            carrierCode: JsonField<String> = JsonMissing.of(),
                            @JsonProperty("destination_city_airport_code")
                            @ExcludeMissing
                            destinationCityAirportCode: JsonField<String> = JsonMissing.of(),
                            @JsonProperty("fare_basis_code")
                            @ExcludeMissing
                            fareBasisCode: JsonField<String> = JsonMissing.of(),
                            @JsonProperty("flight_number")
                            @ExcludeMissing
                            flightNumber: JsonField<String> = JsonMissing.of(),
                            @JsonProperty("service_class")
                            @ExcludeMissing
                            serviceClass: JsonField<String> = JsonMissing.of(),
                            @JsonProperty("stop_over_code")
                            @ExcludeMissing
                            stopOverCode: JsonField<StopOverCode> = JsonMissing.of(),
                        ) : this(
                            carrierCode,
                            destinationCityAirportCode,
                            fareBasisCode,
                            flightNumber,
                            serviceClass,
                            stopOverCode,
                            mutableMapOf(),
                        )

                        /**
                         * Carrier code (e.g., United Airlines, Jet Blue, etc.).
                         *
                         * @throws IncreaseInvalidDataException if the JSON field has an unexpected
                         *   type (e.g. if the server responded with an unexpected value).
                         */
                        fun carrierCode(): Optional<String> =
                            carrierCode.getOptional("carrier_code")

                        /**
                         * Code for the destination city or airport.
                         *
                         * @throws IncreaseInvalidDataException if the JSON field has an unexpected
                         *   type (e.g. if the server responded with an unexpected value).
                         */
                        fun destinationCityAirportCode(): Optional<String> =
                            destinationCityAirportCode.getOptional("destination_city_airport_code")

                        /**
                         * Fare basis code.
                         *
                         * @throws IncreaseInvalidDataException if the JSON field has an unexpected
                         *   type (e.g. if the server responded with an unexpected value).
                         */
                        fun fareBasisCode(): Optional<String> =
                            fareBasisCode.getOptional("fare_basis_code")

                        /**
                         * Flight number.
                         *
                         * @throws IncreaseInvalidDataException if the JSON field has an unexpected
                         *   type (e.g. if the server responded with an unexpected value).
                         */
                        fun flightNumber(): Optional<String> =
                            flightNumber.getOptional("flight_number")

                        /**
                         * Service class (e.g., first class, business class, etc.).
                         *
                         * @throws IncreaseInvalidDataException if the JSON field has an unexpected
                         *   type (e.g. if the server responded with an unexpected value).
                         */
                        fun serviceClass(): Optional<String> =
                            serviceClass.getOptional("service_class")

                        /**
                         * Indicates whether a stopover is allowed on this ticket.
                         *
                         * @throws IncreaseInvalidDataException if the JSON field has an unexpected
                         *   type (e.g. if the server responded with an unexpected value).
                         */
                        fun stopOverCode(): Optional<StopOverCode> =
                            stopOverCode.getOptional("stop_over_code")

                        /**
                         * Returns the raw JSON value of [carrierCode].
                         *
                         * Unlike [carrierCode], this method doesn't throw if the JSON field has an
                         * unexpected type.
                         */
                        @JsonProperty("carrier_code")
                        @ExcludeMissing
                        fun _carrierCode(): JsonField<String> = carrierCode

                        /**
                         * Returns the raw JSON value of [destinationCityAirportCode].
                         *
                         * Unlike [destinationCityAirportCode], this method doesn't throw if the
                         * JSON field has an unexpected type.
                         */
                        @JsonProperty("destination_city_airport_code")
                        @ExcludeMissing
                        fun _destinationCityAirportCode(): JsonField<String> =
                            destinationCityAirportCode

                        /**
                         * Returns the raw JSON value of [fareBasisCode].
                         *
                         * Unlike [fareBasisCode], this method doesn't throw if the JSON field has
                         * an unexpected type.
                         */
                        @JsonProperty("fare_basis_code")
                        @ExcludeMissing
                        fun _fareBasisCode(): JsonField<String> = fareBasisCode

                        /**
                         * Returns the raw JSON value of [flightNumber].
                         *
                         * Unlike [flightNumber], this method doesn't throw if the JSON field has an
                         * unexpected type.
                         */
                        @JsonProperty("flight_number")
                        @ExcludeMissing
                        fun _flightNumber(): JsonField<String> = flightNumber

                        /**
                         * Returns the raw JSON value of [serviceClass].
                         *
                         * Unlike [serviceClass], this method doesn't throw if the JSON field has an
                         * unexpected type.
                         */
                        @JsonProperty("service_class")
                        @ExcludeMissing
                        fun _serviceClass(): JsonField<String> = serviceClass

                        /**
                         * Returns the raw JSON value of [stopOverCode].
                         *
                         * Unlike [stopOverCode], this method doesn't throw if the JSON field has an
                         * unexpected type.
                         */
                        @JsonProperty("stop_over_code")
                        @ExcludeMissing
                        fun _stopOverCode(): JsonField<StopOverCode> = stopOverCode

                        @JsonAnySetter
                        private fun putAdditionalProperty(key: String, value: JsonValue) {
                            additionalProperties.put(key, value)
                        }

                        @JsonAnyGetter
                        @ExcludeMissing
                        fun _additionalProperties(): Map<String, JsonValue> =
                            Collections.unmodifiableMap(additionalProperties)

                        fun toBuilder() = Builder().from(this)

                        companion object {

                            /**
                             * Returns a mutable builder for constructing an instance of [TripLeg].
                             *
                             * The following fields are required:
                             * ```java
                             * .carrierCode()
                             * .destinationCityAirportCode()
                             * .fareBasisCode()
                             * .flightNumber()
                             * .serviceClass()
                             * .stopOverCode()
                             * ```
                             */
                            @JvmStatic fun builder() = Builder()
                        }

                        /** A builder for [TripLeg]. */
                        class Builder internal constructor() {

                            private var carrierCode: JsonField<String>? = null
                            private var destinationCityAirportCode: JsonField<String>? = null
                            private var fareBasisCode: JsonField<String>? = null
                            private var flightNumber: JsonField<String>? = null
                            private var serviceClass: JsonField<String>? = null
                            private var stopOverCode: JsonField<StopOverCode>? = null
                            private var additionalProperties: MutableMap<String, JsonValue> =
                                mutableMapOf()

                            @JvmSynthetic
                            internal fun from(tripLeg: TripLeg) = apply {
                                carrierCode = tripLeg.carrierCode
                                destinationCityAirportCode = tripLeg.destinationCityAirportCode
                                fareBasisCode = tripLeg.fareBasisCode
                                flightNumber = tripLeg.flightNumber
                                serviceClass = tripLeg.serviceClass
                                stopOverCode = tripLeg.stopOverCode
                                additionalProperties = tripLeg.additionalProperties.toMutableMap()
                            }

                            /** Carrier code (e.g., United Airlines, Jet Blue, etc.). */
                            fun carrierCode(carrierCode: String?) =
                                carrierCode(JsonField.ofNullable(carrierCode))

                            /**
                             * Alias for calling [Builder.carrierCode] with
                             * `carrierCode.orElse(null)`.
                             */
                            fun carrierCode(carrierCode: Optional<String>) =
                                carrierCode(carrierCode.getOrNull())

                            /**
                             * Sets [Builder.carrierCode] to an arbitrary JSON value.
                             *
                             * You should usually call [Builder.carrierCode] with a well-typed
                             * [String] value instead. This method is primarily for setting the
                             * field to an undocumented or not yet supported value.
                             */
                            fun carrierCode(carrierCode: JsonField<String>) = apply {
                                this.carrierCode = carrierCode
                            }

                            /** Code for the destination city or airport. */
                            fun destinationCityAirportCode(destinationCityAirportCode: String?) =
                                destinationCityAirportCode(
                                    JsonField.ofNullable(destinationCityAirportCode)
                                )

                            /**
                             * Alias for calling [Builder.destinationCityAirportCode] with
                             * `destinationCityAirportCode.orElse(null)`.
                             */
                            fun destinationCityAirportCode(
                                destinationCityAirportCode: Optional<String>
                            ) = destinationCityAirportCode(destinationCityAirportCode.getOrNull())

                            /**
                             * Sets [Builder.destinationCityAirportCode] to an arbitrary JSON value.
                             *
                             * You should usually call [Builder.destinationCityAirportCode] with a
                             * well-typed [String] value instead. This method is primarily for
                             * setting the field to an undocumented or not yet supported value.
                             */
                            fun destinationCityAirportCode(
                                destinationCityAirportCode: JsonField<String>
                            ) = apply {
                                this.destinationCityAirportCode = destinationCityAirportCode
                            }

                            /** Fare basis code. */
                            fun fareBasisCode(fareBasisCode: String?) =
                                fareBasisCode(JsonField.ofNullable(fareBasisCode))

                            /**
                             * Alias for calling [Builder.fareBasisCode] with
                             * `fareBasisCode.orElse(null)`.
                             */
                            fun fareBasisCode(fareBasisCode: Optional<String>) =
                                fareBasisCode(fareBasisCode.getOrNull())

                            /**
                             * Sets [Builder.fareBasisCode] to an arbitrary JSON value.
                             *
                             * You should usually call [Builder.fareBasisCode] with a well-typed
                             * [String] value instead. This method is primarily for setting the
                             * field to an undocumented or not yet supported value.
                             */
                            fun fareBasisCode(fareBasisCode: JsonField<String>) = apply {
                                this.fareBasisCode = fareBasisCode
                            }

                            /** Flight number. */
                            fun flightNumber(flightNumber: String?) =
                                flightNumber(JsonField.ofNullable(flightNumber))

                            /**
                             * Alias for calling [Builder.flightNumber] with
                             * `flightNumber.orElse(null)`.
                             */
                            fun flightNumber(flightNumber: Optional<String>) =
                                flightNumber(flightNumber.getOrNull())

                            /**
                             * Sets [Builder.flightNumber] to an arbitrary JSON value.
                             *
                             * You should usually call [Builder.flightNumber] with a well-typed
                             * [String] value instead. This method is primarily for setting the
                             * field to an undocumented or not yet supported value.
                             */
                            fun flightNumber(flightNumber: JsonField<String>) = apply {
                                this.flightNumber = flightNumber
                            }

                            /** Service class (e.g., first class, business class, etc.). */
                            fun serviceClass(serviceClass: String?) =
                                serviceClass(JsonField.ofNullable(serviceClass))

                            /**
                             * Alias for calling [Builder.serviceClass] with
                             * `serviceClass.orElse(null)`.
                             */
                            fun serviceClass(serviceClass: Optional<String>) =
                                serviceClass(serviceClass.getOrNull())

                            /**
                             * Sets [Builder.serviceClass] to an arbitrary JSON value.
                             *
                             * You should usually call [Builder.serviceClass] with a well-typed
                             * [String] value instead. This method is primarily for setting the
                             * field to an undocumented or not yet supported value.
                             */
                            fun serviceClass(serviceClass: JsonField<String>) = apply {
                                this.serviceClass = serviceClass
                            }

                            /** Indicates whether a stopover is allowed on this ticket. */
                            fun stopOverCode(stopOverCode: StopOverCode?) =
                                stopOverCode(JsonField.ofNullable(stopOverCode))

                            /**
                             * Alias for calling [Builder.stopOverCode] with
                             * `stopOverCode.orElse(null)`.
                             */
                            fun stopOverCode(stopOverCode: Optional<StopOverCode>) =
                                stopOverCode(stopOverCode.getOrNull())

                            /**
                             * Sets [Builder.stopOverCode] to an arbitrary JSON value.
                             *
                             * You should usually call [Builder.stopOverCode] with a well-typed
                             * [StopOverCode] value instead. This method is primarily for setting
                             * the field to an undocumented or not yet supported value.
                             */
                            fun stopOverCode(stopOverCode: JsonField<StopOverCode>) = apply {
                                this.stopOverCode = stopOverCode
                            }

                            fun additionalProperties(additionalProperties: Map<String, JsonValue>) =
                                apply {
                                    this.additionalProperties.clear()
                                    putAllAdditionalProperties(additionalProperties)
                                }

                            fun putAdditionalProperty(key: String, value: JsonValue) = apply {
                                additionalProperties.put(key, value)
                            }

                            fun putAllAdditionalProperties(
                                additionalProperties: Map<String, JsonValue>
                            ) = apply { this.additionalProperties.putAll(additionalProperties) }

                            fun removeAdditionalProperty(key: String) = apply {
                                additionalProperties.remove(key)
                            }

                            fun removeAllAdditionalProperties(keys: Set<String>) = apply {
                                keys.forEach(::removeAdditionalProperty)
                            }

                            /**
                             * Returns an immutable instance of [TripLeg].
                             *
                             * Further updates to this [Builder] will not mutate the returned
                             * instance.
                             *
                             * The following fields are required:
                             * ```java
                             * .carrierCode()
                             * .destinationCityAirportCode()
                             * .fareBasisCode()
                             * .flightNumber()
                             * .serviceClass()
                             * .stopOverCode()
                             * ```
                             *
                             * @throws IllegalStateException if any required field is unset.
                             */
                            fun build(): TripLeg =
                                TripLeg(
                                    checkRequired("carrierCode", carrierCode),
                                    checkRequired(
                                        "destinationCityAirportCode",
                                        destinationCityAirportCode,
                                    ),
                                    checkRequired("fareBasisCode", fareBasisCode),
                                    checkRequired("flightNumber", flightNumber),
                                    checkRequired("serviceClass", serviceClass),
                                    checkRequired("stopOverCode", stopOverCode),
                                    additionalProperties.toMutableMap(),
                                )
                        }

                        private var validated: Boolean = false

                        fun validate(): TripLeg = apply {
                            if (validated) {
                                return@apply
                            }

                            carrierCode()
                            destinationCityAirportCode()
                            fareBasisCode()
                            flightNumber()
                            serviceClass()
                            stopOverCode().ifPresent { it.validate() }
                            validated = true
                        }

                        fun isValid(): Boolean =
                            try {
                                validate()
                                true
                            } catch (e: IncreaseInvalidDataException) {
                                false
                            }

                        /**
                         * Returns a score indicating how many valid values are contained in this
                         * object recursively.
                         *
                         * Used for best match union deserialization.
                         */
                        @JvmSynthetic
                        internal fun validity(): Int =
                            (if (carrierCode.asKnown().isPresent) 1 else 0) +
                                (if (destinationCityAirportCode.asKnown().isPresent) 1 else 0) +
                                (if (fareBasisCode.asKnown().isPresent) 1 else 0) +
                                (if (flightNumber.asKnown().isPresent) 1 else 0) +
                                (if (serviceClass.asKnown().isPresent) 1 else 0) +
                                (stopOverCode.asKnown().getOrNull()?.validity() ?: 0)

                        /** Indicates whether a stopover is allowed on this ticket. */
                        class StopOverCode
                        @JsonCreator
                        private constructor(private val value: JsonField<String>) : Enum {

                            /**
                             * Returns this class instance's raw value.
                             *
                             * This is usually only useful if this instance was deserialized from
                             * data that doesn't match any known member, and you want to know that
                             * value. For example, if the SDK is on an older version than the API,
                             * then the API may respond with new members that the SDK is unaware of.
                             */
                            @com.fasterxml.jackson.annotation.JsonValue
                            fun _value(): JsonField<String> = value

                            companion object {

                                /** None */
                                @JvmField val NONE = of("none")

                                /** Stop over allowed */
                                @JvmField val STOP_OVER_ALLOWED = of("stop_over_allowed")

                                /** Stop over not allowed */
                                @JvmField val STOP_OVER_NOT_ALLOWED = of("stop_over_not_allowed")

                                @JvmStatic fun of(value: String) = StopOverCode(JsonField.of(value))
                            }

                            /** An enum containing [StopOverCode]'s known values. */
                            enum class Known {
                                /** None */
                                NONE,
                                /** Stop over allowed */
                                STOP_OVER_ALLOWED,
                                /** Stop over not allowed */
                                STOP_OVER_NOT_ALLOWED,
                            }

                            /**
                             * An enum containing [StopOverCode]'s known values, as well as an
                             * [_UNKNOWN] member.
                             *
                             * An instance of [StopOverCode] can contain an unknown value in a
                             * couple of cases:
                             * - It was deserialized from data that doesn't match any known member.
                             *   For example, if the SDK is on an older version than the API, then
                             *   the API may respond with new members that the SDK is unaware of.
                             * - It was constructed with an arbitrary value using the [of] method.
                             */
                            enum class Value {
                                /** None */
                                NONE,
                                /** Stop over allowed */
                                STOP_OVER_ALLOWED,
                                /** Stop over not allowed */
                                STOP_OVER_NOT_ALLOWED,
                                /**
                                 * An enum member indicating that [StopOverCode] was instantiated
                                 * with an unknown value.
                                 */
                                _UNKNOWN,
                            }

                            /**
                             * Returns an enum member corresponding to this class instance's value,
                             * or [Value._UNKNOWN] if the class was instantiated with an unknown
                             * value.
                             *
                             * Use the [known] method instead if you're certain the value is always
                             * known or if you want to throw for the unknown case.
                             */
                            fun value(): Value =
                                when (this) {
                                    NONE -> Value.NONE
                                    STOP_OVER_ALLOWED -> Value.STOP_OVER_ALLOWED
                                    STOP_OVER_NOT_ALLOWED -> Value.STOP_OVER_NOT_ALLOWED
                                    else -> Value._UNKNOWN
                                }

                            /**
                             * Returns an enum member corresponding to this class instance's value.
                             *
                             * Use the [value] method instead if you're uncertain the value is
                             * always known and don't want to throw for the unknown case.
                             *
                             * @throws IncreaseInvalidDataException if this class instance's value
                             *   is a not a known member.
                             */
                            fun known(): Known =
                                when (this) {
                                    NONE -> Known.NONE
                                    STOP_OVER_ALLOWED -> Known.STOP_OVER_ALLOWED
                                    STOP_OVER_NOT_ALLOWED -> Known.STOP_OVER_NOT_ALLOWED
                                    else ->
                                        throw IncreaseInvalidDataException(
                                            "Unknown StopOverCode: $value"
                                        )
                                }

                            /**
                             * Returns this class instance's primitive wire representation.
                             *
                             * This differs from the [toString] method because that method is
                             * primarily for debugging and generally doesn't throw.
                             *
                             * @throws IncreaseInvalidDataException if this class instance's value
                             *   does not have the expected primitive type.
                             */
                            fun asString(): String =
                                _value().asString().orElseThrow {
                                    IncreaseInvalidDataException("Value is not a String")
                                }

                            private var validated: Boolean = false

                            fun validate(): StopOverCode = apply {
                                if (validated) {
                                    return@apply
                                }

                                known()
                                validated = true
                            }

                            fun isValid(): Boolean =
                                try {
                                    validate()
                                    true
                                } catch (e: IncreaseInvalidDataException) {
                                    false
                                }

                            /**
                             * Returns a score indicating how many valid values are contained in
                             * this object recursively.
                             *
                             * Used for best match union deserialization.
                             */
                            @JvmSynthetic
                            internal fun validity(): Int = if (value() == Value._UNKNOWN) 0 else 1

                            override fun equals(other: Any?): Boolean {
                                if (this === other) {
                                    return true
                                }

                                return /* spotless:off */ other is StopOverCode && value == other.value /* spotless:on */
                            }

                            override fun hashCode() = value.hashCode()

                            override fun toString() = value.toString()
                        }

                        override fun equals(other: Any?): Boolean {
                            if (this === other) {
                                return true
                            }

                            return /* spotless:off */ other is TripLeg && carrierCode == other.carrierCode && destinationCityAirportCode == other.destinationCityAirportCode && fareBasisCode == other.fareBasisCode && flightNumber == other.flightNumber && serviceClass == other.serviceClass && stopOverCode == other.stopOverCode && additionalProperties == other.additionalProperties /* spotless:on */
                        }

                        /* spotless:off */
                        private val hashCode: Int by lazy { Objects.hash(carrierCode, destinationCityAirportCode, fareBasisCode, flightNumber, serviceClass, stopOverCode, additionalProperties) }
                        /* spotless:on */

                        override fun hashCode(): Int = hashCode

                        override fun toString() =
                            "TripLeg{carrierCode=$carrierCode, destinationCityAirportCode=$destinationCityAirportCode, fareBasisCode=$fareBasisCode, flightNumber=$flightNumber, serviceClass=$serviceClass, stopOverCode=$stopOverCode, additionalProperties=$additionalProperties}"
                    }

                    override fun equals(other: Any?): Boolean {
                        if (this === other) {
                            return true
                        }

                        return /* spotless:off */ other is Travel && ancillary == other.ancillary && computerizedReservationSystem == other.computerizedReservationSystem && creditReasonIndicator == other.creditReasonIndicator && departureDate == other.departureDate && originationCityAirportCode == other.originationCityAirportCode && passengerName == other.passengerName && restrictedTicketIndicator == other.restrictedTicketIndicator && ticketChangeIndicator == other.ticketChangeIndicator && ticketNumber == other.ticketNumber && travelAgencyCode == other.travelAgencyCode && travelAgencyName == other.travelAgencyName && tripLegs == other.tripLegs && additionalProperties == other.additionalProperties /* spotless:on */
                    }

                    /* spotless:off */
                    private val hashCode: Int by lazy { Objects.hash(ancillary, computerizedReservationSystem, creditReasonIndicator, departureDate, originationCityAirportCode, passengerName, restrictedTicketIndicator, ticketChangeIndicator, ticketNumber, travelAgencyCode, travelAgencyName, tripLegs, additionalProperties) }
                    /* spotless:on */

                    override fun hashCode(): Int = hashCode

                    override fun toString() =
                        "Travel{ancillary=$ancillary, computerizedReservationSystem=$computerizedReservationSystem, creditReasonIndicator=$creditReasonIndicator, departureDate=$departureDate, originationCityAirportCode=$originationCityAirportCode, passengerName=$passengerName, restrictedTicketIndicator=$restrictedTicketIndicator, ticketChangeIndicator=$ticketChangeIndicator, ticketNumber=$ticketNumber, travelAgencyCode=$travelAgencyCode, travelAgencyName=$travelAgencyName, tripLegs=$tripLegs, additionalProperties=$additionalProperties}"
                }

                override fun equals(other: Any?): Boolean {
                    if (this === other) {
                        return true
                    }

                    return /* spotless:off */ other is PurchaseDetails && carRental == other.carRental && customerReferenceIdentifier == other.customerReferenceIdentifier && localTaxAmount == other.localTaxAmount && localTaxCurrency == other.localTaxCurrency && lodging == other.lodging && nationalTaxAmount == other.nationalTaxAmount && nationalTaxCurrency == other.nationalTaxCurrency && purchaseIdentifier == other.purchaseIdentifier && purchaseIdentifierFormat == other.purchaseIdentifierFormat && travel == other.travel && additionalProperties == other.additionalProperties /* spotless:on */
                }

                /* spotless:off */
                private val hashCode: Int by lazy { Objects.hash(carRental, customerReferenceIdentifier, localTaxAmount, localTaxCurrency, lodging, nationalTaxAmount, nationalTaxCurrency, purchaseIdentifier, purchaseIdentifierFormat, travel, additionalProperties) }
                /* spotless:on */

                override fun hashCode(): Int = hashCode

                override fun toString() =
                    "PurchaseDetails{carRental=$carRental, customerReferenceIdentifier=$customerReferenceIdentifier, localTaxAmount=$localTaxAmount, localTaxCurrency=$localTaxCurrency, lodging=$lodging, nationalTaxAmount=$nationalTaxAmount, nationalTaxCurrency=$nationalTaxCurrency, purchaseIdentifier=$purchaseIdentifier, purchaseIdentifierFormat=$purchaseIdentifierFormat, travel=$travel, additionalProperties=$additionalProperties}"
            }

            /**
             * A constant representing the object's type. For this resource it will always be
             * `card_refund`.
             */
            class Type @JsonCreator private constructor(private val value: JsonField<String>) :
                Enum {

                /**
                 * Returns this class instance's raw value.
                 *
                 * This is usually only useful if this instance was deserialized from data that
                 * doesn't match any known member, and you want to know that value. For example, if
                 * the SDK is on an older version than the API, then the API may respond with new
                 * members that the SDK is unaware of.
                 */
                @com.fasterxml.jackson.annotation.JsonValue fun _value(): JsonField<String> = value

                companion object {

                    @JvmField val CARD_REFUND = of("card_refund")

                    @JvmStatic fun of(value: String) = Type(JsonField.of(value))
                }

                /** An enum containing [Type]'s known values. */
                enum class Known {
                    CARD_REFUND
                }

                /**
                 * An enum containing [Type]'s known values, as well as an [_UNKNOWN] member.
                 *
                 * An instance of [Type] can contain an unknown value in a couple of cases:
                 * - It was deserialized from data that doesn't match any known member. For example,
                 *   if the SDK is on an older version than the API, then the API may respond with
                 *   new members that the SDK is unaware of.
                 * - It was constructed with an arbitrary value using the [of] method.
                 */
                enum class Value {
                    CARD_REFUND,
                    /**
                     * An enum member indicating that [Type] was instantiated with an unknown value.
                     */
                    _UNKNOWN,
                }

                /**
                 * Returns an enum member corresponding to this class instance's value, or
                 * [Value._UNKNOWN] if the class was instantiated with an unknown value.
                 *
                 * Use the [known] method instead if you're certain the value is always known or if
                 * you want to throw for the unknown case.
                 */
                fun value(): Value =
                    when (this) {
                        CARD_REFUND -> Value.CARD_REFUND
                        else -> Value._UNKNOWN
                    }

                /**
                 * Returns an enum member corresponding to this class instance's value.
                 *
                 * Use the [value] method instead if you're uncertain the value is always known and
                 * don't want to throw for the unknown case.
                 *
                 * @throws IncreaseInvalidDataException if this class instance's value is a not a
                 *   known member.
                 */
                fun known(): Known =
                    when (this) {
                        CARD_REFUND -> Known.CARD_REFUND
                        else -> throw IncreaseInvalidDataException("Unknown Type: $value")
                    }

                /**
                 * Returns this class instance's primitive wire representation.
                 *
                 * This differs from the [toString] method because that method is primarily for
                 * debugging and generally doesn't throw.
                 *
                 * @throws IncreaseInvalidDataException if this class instance's value does not have
                 *   the expected primitive type.
                 */
                fun asString(): String =
                    _value().asString().orElseThrow {
                        IncreaseInvalidDataException("Value is not a String")
                    }

                private var validated: Boolean = false

                fun validate(): Type = apply {
                    if (validated) {
                        return@apply
                    }

                    known()
                    validated = true
                }

                fun isValid(): Boolean =
                    try {
                        validate()
                        true
                    } catch (e: IncreaseInvalidDataException) {
                        false
                    }

                /**
                 * Returns a score indicating how many valid values are contained in this object
                 * recursively.
                 *
                 * Used for best match union deserialization.
                 */
                @JvmSynthetic internal fun validity(): Int = if (value() == Value._UNKNOWN) 0 else 1

                override fun equals(other: Any?): Boolean {
                    if (this === other) {
                        return true
                    }

                    return /* spotless:off */ other is Type && value == other.value /* spotless:on */
                }

                override fun hashCode() = value.hashCode()

                override fun toString() = value.toString()
            }

            override fun equals(other: Any?): Boolean {
                if (this === other) {
                    return true
                }

                return /* spotless:off */ other is CardRefund && id == other.id && amount == other.amount && cardPaymentId == other.cardPaymentId && cashback == other.cashback && currency == other.currency && interchange == other.interchange && merchantAcceptorId == other.merchantAcceptorId && merchantCategoryCode == other.merchantCategoryCode && merchantCity == other.merchantCity && merchantCountry == other.merchantCountry && merchantName == other.merchantName && merchantPostalCode == other.merchantPostalCode && merchantState == other.merchantState && networkIdentifiers == other.networkIdentifiers && presentmentAmount == other.presentmentAmount && presentmentCurrency == other.presentmentCurrency && purchaseDetails == other.purchaseDetails && transactionId == other.transactionId && type == other.type && additionalProperties == other.additionalProperties /* spotless:on */
            }

            /* spotless:off */
            private val hashCode: Int by lazy { Objects.hash(id, amount, cardPaymentId, cashback, currency, interchange, merchantAcceptorId, merchantCategoryCode, merchantCity, merchantCountry, merchantName, merchantPostalCode, merchantState, networkIdentifiers, presentmentAmount, presentmentCurrency, purchaseDetails, transactionId, type, additionalProperties) }
            /* spotless:on */

            override fun hashCode(): Int = hashCode

            override fun toString() =
                "CardRefund{id=$id, amount=$amount, cardPaymentId=$cardPaymentId, cashback=$cashback, currency=$currency, interchange=$interchange, merchantAcceptorId=$merchantAcceptorId, merchantCategoryCode=$merchantCategoryCode, merchantCity=$merchantCity, merchantCountry=$merchantCountry, merchantName=$merchantName, merchantPostalCode=$merchantPostalCode, merchantState=$merchantState, networkIdentifiers=$networkIdentifiers, presentmentAmount=$presentmentAmount, presentmentCurrency=$presentmentCurrency, purchaseDetails=$purchaseDetails, transactionId=$transactionId, type=$type, additionalProperties=$additionalProperties}"
        }

        /**
         * A Card Revenue Payment object. This field will be present in the JSON response if and
         * only if `category` is equal to `card_revenue_payment`. Card Revenue Payments reflect
         * earnings from fees on card transactions.
         */
        class CardRevenuePayment
        private constructor(
            private val amount: JsonField<Long>,
            private val currency: JsonField<Currency>,
            private val periodEnd: JsonField<OffsetDateTime>,
            private val periodStart: JsonField<OffsetDateTime>,
            private val transactedOnAccountId: JsonField<String>,
            private val additionalProperties: MutableMap<String, JsonValue>,
        ) {

            @JsonCreator
            private constructor(
                @JsonProperty("amount") @ExcludeMissing amount: JsonField<Long> = JsonMissing.of(),
                @JsonProperty("currency")
                @ExcludeMissing
                currency: JsonField<Currency> = JsonMissing.of(),
                @JsonProperty("period_end")
                @ExcludeMissing
                periodEnd: JsonField<OffsetDateTime> = JsonMissing.of(),
                @JsonProperty("period_start")
                @ExcludeMissing
                periodStart: JsonField<OffsetDateTime> = JsonMissing.of(),
                @JsonProperty("transacted_on_account_id")
                @ExcludeMissing
                transactedOnAccountId: JsonField<String> = JsonMissing.of(),
            ) : this(
                amount,
                currency,
                periodEnd,
                periodStart,
                transactedOnAccountId,
                mutableMapOf(),
            )

            /**
             * The amount in the minor unit of the transaction's currency. For dollars, for example,
             * this is cents.
             *
             * @throws IncreaseInvalidDataException if the JSON field has an unexpected type or is
             *   unexpectedly missing or null (e.g. if the server responded with an unexpected
             *   value).
             */
            fun amount(): Long = amount.getRequired("amount")

            /**
             * The [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) code for the transaction
             * currency.
             *
             * @throws IncreaseInvalidDataException if the JSON field has an unexpected type or is
             *   unexpectedly missing or null (e.g. if the server responded with an unexpected
             *   value).
             */
            fun currency(): Currency = currency.getRequired("currency")

            /**
             * The end of the period for which this transaction paid interest.
             *
             * @throws IncreaseInvalidDataException if the JSON field has an unexpected type or is
             *   unexpectedly missing or null (e.g. if the server responded with an unexpected
             *   value).
             */
            fun periodEnd(): OffsetDateTime = periodEnd.getRequired("period_end")

            /**
             * The start of the period for which this transaction paid interest.
             *
             * @throws IncreaseInvalidDataException if the JSON field has an unexpected type or is
             *   unexpectedly missing or null (e.g. if the server responded with an unexpected
             *   value).
             */
            fun periodStart(): OffsetDateTime = periodStart.getRequired("period_start")

            /**
             * The account the card belonged to.
             *
             * @throws IncreaseInvalidDataException if the JSON field has an unexpected type (e.g.
             *   if the server responded with an unexpected value).
             */
            fun transactedOnAccountId(): Optional<String> =
                transactedOnAccountId.getOptional("transacted_on_account_id")

            /**
             * Returns the raw JSON value of [amount].
             *
             * Unlike [amount], this method doesn't throw if the JSON field has an unexpected type.
             */
            @JsonProperty("amount") @ExcludeMissing fun _amount(): JsonField<Long> = amount

            /**
             * Returns the raw JSON value of [currency].
             *
             * Unlike [currency], this method doesn't throw if the JSON field has an unexpected
             * type.
             */
            @JsonProperty("currency")
            @ExcludeMissing
            fun _currency(): JsonField<Currency> = currency

            /**
             * Returns the raw JSON value of [periodEnd].
             *
             * Unlike [periodEnd], this method doesn't throw if the JSON field has an unexpected
             * type.
             */
            @JsonProperty("period_end")
            @ExcludeMissing
            fun _periodEnd(): JsonField<OffsetDateTime> = periodEnd

            /**
             * Returns the raw JSON value of [periodStart].
             *
             * Unlike [periodStart], this method doesn't throw if the JSON field has an unexpected
             * type.
             */
            @JsonProperty("period_start")
            @ExcludeMissing
            fun _periodStart(): JsonField<OffsetDateTime> = periodStart

            /**
             * Returns the raw JSON value of [transactedOnAccountId].
             *
             * Unlike [transactedOnAccountId], this method doesn't throw if the JSON field has an
             * unexpected type.
             */
            @JsonProperty("transacted_on_account_id")
            @ExcludeMissing
            fun _transactedOnAccountId(): JsonField<String> = transactedOnAccountId

            @JsonAnySetter
            private fun putAdditionalProperty(key: String, value: JsonValue) {
                additionalProperties.put(key, value)
            }

            @JsonAnyGetter
            @ExcludeMissing
            fun _additionalProperties(): Map<String, JsonValue> =
                Collections.unmodifiableMap(additionalProperties)

            fun toBuilder() = Builder().from(this)

            companion object {

                /**
                 * Returns a mutable builder for constructing an instance of [CardRevenuePayment].
                 *
                 * The following fields are required:
                 * ```java
                 * .amount()
                 * .currency()
                 * .periodEnd()
                 * .periodStart()
                 * .transactedOnAccountId()
                 * ```
                 */
                @JvmStatic fun builder() = Builder()
            }

            /** A builder for [CardRevenuePayment]. */
            class Builder internal constructor() {

                private var amount: JsonField<Long>? = null
                private var currency: JsonField<Currency>? = null
                private var periodEnd: JsonField<OffsetDateTime>? = null
                private var periodStart: JsonField<OffsetDateTime>? = null
                private var transactedOnAccountId: JsonField<String>? = null
                private var additionalProperties: MutableMap<String, JsonValue> = mutableMapOf()

                @JvmSynthetic
                internal fun from(cardRevenuePayment: CardRevenuePayment) = apply {
                    amount = cardRevenuePayment.amount
                    currency = cardRevenuePayment.currency
                    periodEnd = cardRevenuePayment.periodEnd
                    periodStart = cardRevenuePayment.periodStart
                    transactedOnAccountId = cardRevenuePayment.transactedOnAccountId
                    additionalProperties = cardRevenuePayment.additionalProperties.toMutableMap()
                }

                /**
                 * The amount in the minor unit of the transaction's currency. For dollars, for
                 * example, this is cents.
                 */
                fun amount(amount: Long) = amount(JsonField.of(amount))

                /**
                 * Sets [Builder.amount] to an arbitrary JSON value.
                 *
                 * You should usually call [Builder.amount] with a well-typed [Long] value instead.
                 * This method is primarily for setting the field to an undocumented or not yet
                 * supported value.
                 */
                fun amount(amount: JsonField<Long>) = apply { this.amount = amount }

                /**
                 * The [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) code for the transaction
                 * currency.
                 */
                fun currency(currency: Currency) = currency(JsonField.of(currency))

                /**
                 * Sets [Builder.currency] to an arbitrary JSON value.
                 *
                 * You should usually call [Builder.currency] with a well-typed [Currency] value
                 * instead. This method is primarily for setting the field to an undocumented or not
                 * yet supported value.
                 */
                fun currency(currency: JsonField<Currency>) = apply { this.currency = currency }

                /** The end of the period for which this transaction paid interest. */
                fun periodEnd(periodEnd: OffsetDateTime) = periodEnd(JsonField.of(periodEnd))

                /**
                 * Sets [Builder.periodEnd] to an arbitrary JSON value.
                 *
                 * You should usually call [Builder.periodEnd] with a well-typed [OffsetDateTime]
                 * value instead. This method is primarily for setting the field to an undocumented
                 * or not yet supported value.
                 */
                fun periodEnd(periodEnd: JsonField<OffsetDateTime>) = apply {
                    this.periodEnd = periodEnd
                }

                /** The start of the period for which this transaction paid interest. */
                fun periodStart(periodStart: OffsetDateTime) =
                    periodStart(JsonField.of(periodStart))

                /**
                 * Sets [Builder.periodStart] to an arbitrary JSON value.
                 *
                 * You should usually call [Builder.periodStart] with a well-typed [OffsetDateTime]
                 * value instead. This method is primarily for setting the field to an undocumented
                 * or not yet supported value.
                 */
                fun periodStart(periodStart: JsonField<OffsetDateTime>) = apply {
                    this.periodStart = periodStart
                }

                /** The account the card belonged to. */
                fun transactedOnAccountId(transactedOnAccountId: String?) =
                    transactedOnAccountId(JsonField.ofNullable(transactedOnAccountId))

                /**
                 * Alias for calling [Builder.transactedOnAccountId] with
                 * `transactedOnAccountId.orElse(null)`.
                 */
                fun transactedOnAccountId(transactedOnAccountId: Optional<String>) =
                    transactedOnAccountId(transactedOnAccountId.getOrNull())

                /**
                 * Sets [Builder.transactedOnAccountId] to an arbitrary JSON value.
                 *
                 * You should usually call [Builder.transactedOnAccountId] with a well-typed
                 * [String] value instead. This method is primarily for setting the field to an
                 * undocumented or not yet supported value.
                 */
                fun transactedOnAccountId(transactedOnAccountId: JsonField<String>) = apply {
                    this.transactedOnAccountId = transactedOnAccountId
                }

                fun additionalProperties(additionalProperties: Map<String, JsonValue>) = apply {
                    this.additionalProperties.clear()
                    putAllAdditionalProperties(additionalProperties)
                }

                fun putAdditionalProperty(key: String, value: JsonValue) = apply {
                    additionalProperties.put(key, value)
                }

                fun putAllAdditionalProperties(additionalProperties: Map<String, JsonValue>) =
                    apply {
                        this.additionalProperties.putAll(additionalProperties)
                    }

                fun removeAdditionalProperty(key: String) = apply {
                    additionalProperties.remove(key)
                }

                fun removeAllAdditionalProperties(keys: Set<String>) = apply {
                    keys.forEach(::removeAdditionalProperty)
                }

                /**
                 * Returns an immutable instance of [CardRevenuePayment].
                 *
                 * Further updates to this [Builder] will not mutate the returned instance.
                 *
                 * The following fields are required:
                 * ```java
                 * .amount()
                 * .currency()
                 * .periodEnd()
                 * .periodStart()
                 * .transactedOnAccountId()
                 * ```
                 *
                 * @throws IllegalStateException if any required field is unset.
                 */
                fun build(): CardRevenuePayment =
                    CardRevenuePayment(
                        checkRequired("amount", amount),
                        checkRequired("currency", currency),
                        checkRequired("periodEnd", periodEnd),
                        checkRequired("periodStart", periodStart),
                        checkRequired("transactedOnAccountId", transactedOnAccountId),
                        additionalProperties.toMutableMap(),
                    )
            }

            private var validated: Boolean = false

            fun validate(): CardRevenuePayment = apply {
                if (validated) {
                    return@apply
                }

                amount()
                currency().validate()
                periodEnd()
                periodStart()
                transactedOnAccountId()
                validated = true
            }

            fun isValid(): Boolean =
                try {
                    validate()
                    true
                } catch (e: IncreaseInvalidDataException) {
                    false
                }

            /**
             * Returns a score indicating how many valid values are contained in this object
             * recursively.
             *
             * Used for best match union deserialization.
             */
            @JvmSynthetic
            internal fun validity(): Int =
                (if (amount.asKnown().isPresent) 1 else 0) +
                    (currency.asKnown().getOrNull()?.validity() ?: 0) +
                    (if (periodEnd.asKnown().isPresent) 1 else 0) +
                    (if (periodStart.asKnown().isPresent) 1 else 0) +
                    (if (transactedOnAccountId.asKnown().isPresent) 1 else 0)

            /**
             * The [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) code for the transaction
             * currency.
             */
            class Currency @JsonCreator private constructor(private val value: JsonField<String>) :
                Enum {

                /**
                 * Returns this class instance's raw value.
                 *
                 * This is usually only useful if this instance was deserialized from data that
                 * doesn't match any known member, and you want to know that value. For example, if
                 * the SDK is on an older version than the API, then the API may respond with new
                 * members that the SDK is unaware of.
                 */
                @com.fasterxml.jackson.annotation.JsonValue fun _value(): JsonField<String> = value

                companion object {

                    /** Canadian Dollar (CAD) */
                    @JvmField val CAD = of("CAD")

                    /** Swiss Franc (CHF) */
                    @JvmField val CHF = of("CHF")

                    /** Euro (EUR) */
                    @JvmField val EUR = of("EUR")

                    /** British Pound (GBP) */
                    @JvmField val GBP = of("GBP")

                    /** Japanese Yen (JPY) */
                    @JvmField val JPY = of("JPY")

                    /** US Dollar (USD) */
                    @JvmField val USD = of("USD")

                    @JvmStatic fun of(value: String) = Currency(JsonField.of(value))
                }

                /** An enum containing [Currency]'s known values. */
                enum class Known {
                    /** Canadian Dollar (CAD) */
                    CAD,
                    /** Swiss Franc (CHF) */
                    CHF,
                    /** Euro (EUR) */
                    EUR,
                    /** British Pound (GBP) */
                    GBP,
                    /** Japanese Yen (JPY) */
                    JPY,
                    /** US Dollar (USD) */
                    USD,
                }

                /**
                 * An enum containing [Currency]'s known values, as well as an [_UNKNOWN] member.
                 *
                 * An instance of [Currency] can contain an unknown value in a couple of cases:
                 * - It was deserialized from data that doesn't match any known member. For example,
                 *   if the SDK is on an older version than the API, then the API may respond with
                 *   new members that the SDK is unaware of.
                 * - It was constructed with an arbitrary value using the [of] method.
                 */
                enum class Value {
                    /** Canadian Dollar (CAD) */
                    CAD,
                    /** Swiss Franc (CHF) */
                    CHF,
                    /** Euro (EUR) */
                    EUR,
                    /** British Pound (GBP) */
                    GBP,
                    /** Japanese Yen (JPY) */
                    JPY,
                    /** US Dollar (USD) */
                    USD,
                    /**
                     * An enum member indicating that [Currency] was instantiated with an unknown
                     * value.
                     */
                    _UNKNOWN,
                }

                /**
                 * Returns an enum member corresponding to this class instance's value, or
                 * [Value._UNKNOWN] if the class was instantiated with an unknown value.
                 *
                 * Use the [known] method instead if you're certain the value is always known or if
                 * you want to throw for the unknown case.
                 */
                fun value(): Value =
                    when (this) {
                        CAD -> Value.CAD
                        CHF -> Value.CHF
                        EUR -> Value.EUR
                        GBP -> Value.GBP
                        JPY -> Value.JPY
                        USD -> Value.USD
                        else -> Value._UNKNOWN
                    }

                /**
                 * Returns an enum member corresponding to this class instance's value.
                 *
                 * Use the [value] method instead if you're uncertain the value is always known and
                 * don't want to throw for the unknown case.
                 *
                 * @throws IncreaseInvalidDataException if this class instance's value is a not a
                 *   known member.
                 */
                fun known(): Known =
                    when (this) {
                        CAD -> Known.CAD
                        CHF -> Known.CHF
                        EUR -> Known.EUR
                        GBP -> Known.GBP
                        JPY -> Known.JPY
                        USD -> Known.USD
                        else -> throw IncreaseInvalidDataException("Unknown Currency: $value")
                    }

                /**
                 * Returns this class instance's primitive wire representation.
                 *
                 * This differs from the [toString] method because that method is primarily for
                 * debugging and generally doesn't throw.
                 *
                 * @throws IncreaseInvalidDataException if this class instance's value does not have
                 *   the expected primitive type.
                 */
                fun asString(): String =
                    _value().asString().orElseThrow {
                        IncreaseInvalidDataException("Value is not a String")
                    }

                private var validated: Boolean = false

                fun validate(): Currency = apply {
                    if (validated) {
                        return@apply
                    }

                    known()
                    validated = true
                }

                fun isValid(): Boolean =
                    try {
                        validate()
                        true
                    } catch (e: IncreaseInvalidDataException) {
                        false
                    }

                /**
                 * Returns a score indicating how many valid values are contained in this object
                 * recursively.
                 *
                 * Used for best match union deserialization.
                 */
                @JvmSynthetic internal fun validity(): Int = if (value() == Value._UNKNOWN) 0 else 1

                override fun equals(other: Any?): Boolean {
                    if (this === other) {
                        return true
                    }

                    return /* spotless:off */ other is Currency && value == other.value /* spotless:on */
                }

                override fun hashCode() = value.hashCode()

                override fun toString() = value.toString()
            }

            override fun equals(other: Any?): Boolean {
                if (this === other) {
                    return true
                }

                return /* spotless:off */ other is CardRevenuePayment && amount == other.amount && currency == other.currency && periodEnd == other.periodEnd && periodStart == other.periodStart && transactedOnAccountId == other.transactedOnAccountId && additionalProperties == other.additionalProperties /* spotless:on */
            }

            /* spotless:off */
            private val hashCode: Int by lazy { Objects.hash(amount, currency, periodEnd, periodStart, transactedOnAccountId, additionalProperties) }
            /* spotless:on */

            override fun hashCode(): Int = hashCode

            override fun toString() =
                "CardRevenuePayment{amount=$amount, currency=$currency, periodEnd=$periodEnd, periodStart=$periodStart, transactedOnAccountId=$transactedOnAccountId, additionalProperties=$additionalProperties}"
        }

        /**
         * A Card Settlement object. This field will be present in the JSON response if and only if
         * `category` is equal to `card_settlement`. Card Settlements are card transactions that
         * have cleared and settled. While a settlement is usually preceded by an authorization, an
         * acquirer can also directly clear a transaction without first authorizing it.
         */
        class CardSettlement
        private constructor(
            private val id: JsonField<String>,
            private val amount: JsonField<Long>,
            private val cardAuthorization: JsonField<String>,
            private val cardPaymentId: JsonField<String>,
            private val cashback: JsonField<Cashback>,
            private val currency: JsonField<Currency>,
            private val interchange: JsonField<Interchange>,
            private val merchantAcceptorId: JsonField<String>,
            private val merchantCategoryCode: JsonField<String>,
            private val merchantCity: JsonField<String>,
            private val merchantCountry: JsonField<String>,
            private val merchantName: JsonField<String>,
            private val merchantPostalCode: JsonField<String>,
            private val merchantState: JsonField<String>,
            private val networkIdentifiers: JsonField<NetworkIdentifiers>,
            private val pendingTransactionId: JsonField<String>,
            private val presentmentAmount: JsonField<Long>,
            private val presentmentCurrency: JsonField<String>,
            private val purchaseDetails: JsonField<PurchaseDetails>,
            private val transactionId: JsonField<String>,
            private val type: JsonField<Type>,
            private val additionalProperties: MutableMap<String, JsonValue>,
        ) {

            @JsonCreator
            private constructor(
                @JsonProperty("id") @ExcludeMissing id: JsonField<String> = JsonMissing.of(),
                @JsonProperty("amount") @ExcludeMissing amount: JsonField<Long> = JsonMissing.of(),
                @JsonProperty("card_authorization")
                @ExcludeMissing
                cardAuthorization: JsonField<String> = JsonMissing.of(),
                @JsonProperty("card_payment_id")
                @ExcludeMissing
                cardPaymentId: JsonField<String> = JsonMissing.of(),
                @JsonProperty("cashback")
                @ExcludeMissing
                cashback: JsonField<Cashback> = JsonMissing.of(),
                @JsonProperty("currency")
                @ExcludeMissing
                currency: JsonField<Currency> = JsonMissing.of(),
                @JsonProperty("interchange")
                @ExcludeMissing
                interchange: JsonField<Interchange> = JsonMissing.of(),
                @JsonProperty("merchant_acceptor_id")
                @ExcludeMissing
                merchantAcceptorId: JsonField<String> = JsonMissing.of(),
                @JsonProperty("merchant_category_code")
                @ExcludeMissing
                merchantCategoryCode: JsonField<String> = JsonMissing.of(),
                @JsonProperty("merchant_city")
                @ExcludeMissing
                merchantCity: JsonField<String> = JsonMissing.of(),
                @JsonProperty("merchant_country")
                @ExcludeMissing
                merchantCountry: JsonField<String> = JsonMissing.of(),
                @JsonProperty("merchant_name")
                @ExcludeMissing
                merchantName: JsonField<String> = JsonMissing.of(),
                @JsonProperty("merchant_postal_code")
                @ExcludeMissing
                merchantPostalCode: JsonField<String> = JsonMissing.of(),
                @JsonProperty("merchant_state")
                @ExcludeMissing
                merchantState: JsonField<String> = JsonMissing.of(),
                @JsonProperty("network_identifiers")
                @ExcludeMissing
                networkIdentifiers: JsonField<NetworkIdentifiers> = JsonMissing.of(),
                @JsonProperty("pending_transaction_id")
                @ExcludeMissing
                pendingTransactionId: JsonField<String> = JsonMissing.of(),
                @JsonProperty("presentment_amount")
                @ExcludeMissing
                presentmentAmount: JsonField<Long> = JsonMissing.of(),
                @JsonProperty("presentment_currency")
                @ExcludeMissing
                presentmentCurrency: JsonField<String> = JsonMissing.of(),
                @JsonProperty("purchase_details")
                @ExcludeMissing
                purchaseDetails: JsonField<PurchaseDetails> = JsonMissing.of(),
                @JsonProperty("transaction_id")
                @ExcludeMissing
                transactionId: JsonField<String> = JsonMissing.of(),
                @JsonProperty("type") @ExcludeMissing type: JsonField<Type> = JsonMissing.of(),
            ) : this(
                id,
                amount,
                cardAuthorization,
                cardPaymentId,
                cashback,
                currency,
                interchange,
                merchantAcceptorId,
                merchantCategoryCode,
                merchantCity,
                merchantCountry,
                merchantName,
                merchantPostalCode,
                merchantState,
                networkIdentifiers,
                pendingTransactionId,
                presentmentAmount,
                presentmentCurrency,
                purchaseDetails,
                transactionId,
                type,
                mutableMapOf(),
            )

            /**
             * The Card Settlement identifier.
             *
             * @throws IncreaseInvalidDataException if the JSON field has an unexpected type or is
             *   unexpectedly missing or null (e.g. if the server responded with an unexpected
             *   value).
             */
            fun id(): String = id.getRequired("id")

            /**
             * The amount in the minor unit of the transaction's settlement currency. For dollars,
             * for example, this is cents.
             *
             * @throws IncreaseInvalidDataException if the JSON field has an unexpected type or is
             *   unexpectedly missing or null (e.g. if the server responded with an unexpected
             *   value).
             */
            fun amount(): Long = amount.getRequired("amount")

            /**
             * The Card Authorization that was created prior to this Card Settlement, if one exists.
             *
             * @throws IncreaseInvalidDataException if the JSON field has an unexpected type (e.g.
             *   if the server responded with an unexpected value).
             */
            fun cardAuthorization(): Optional<String> =
                cardAuthorization.getOptional("card_authorization")

            /**
             * The ID of the Card Payment this transaction belongs to.
             *
             * @throws IncreaseInvalidDataException if the JSON field has an unexpected type or is
             *   unexpectedly missing or null (e.g. if the server responded with an unexpected
             *   value).
             */
            fun cardPaymentId(): String = cardPaymentId.getRequired("card_payment_id")

            /**
             * Cashback earned on this transaction, if eligible. Cashback is paid out in aggregate,
             * monthly.
             *
             * @throws IncreaseInvalidDataException if the JSON field has an unexpected type (e.g.
             *   if the server responded with an unexpected value).
             */
            fun cashback(): Optional<Cashback> = cashback.getOptional("cashback")

            /**
             * The [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) code for the transaction's
             * settlement currency.
             *
             * @throws IncreaseInvalidDataException if the JSON field has an unexpected type or is
             *   unexpectedly missing or null (e.g. if the server responded with an unexpected
             *   value).
             */
            fun currency(): Currency = currency.getRequired("currency")

            /**
             * Interchange assessed as a part of this transaction.
             *
             * @throws IncreaseInvalidDataException if the JSON field has an unexpected type (e.g.
             *   if the server responded with an unexpected value).
             */
            fun interchange(): Optional<Interchange> = interchange.getOptional("interchange")

            /**
             * The merchant identifier (commonly abbreviated as MID) of the merchant the card is
             * transacting with.
             *
             * @throws IncreaseInvalidDataException if the JSON field has an unexpected type or is
             *   unexpectedly missing or null (e.g. if the server responded with an unexpected
             *   value).
             */
            fun merchantAcceptorId(): String =
                merchantAcceptorId.getRequired("merchant_acceptor_id")

            /**
             * The 4-digit MCC describing the merchant's business.
             *
             * @throws IncreaseInvalidDataException if the JSON field has an unexpected type or is
             *   unexpectedly missing or null (e.g. if the server responded with an unexpected
             *   value).
             */
            fun merchantCategoryCode(): String =
                merchantCategoryCode.getRequired("merchant_category_code")

            /**
             * The city the merchant resides in.
             *
             * @throws IncreaseInvalidDataException if the JSON field has an unexpected type or is
             *   unexpectedly missing or null (e.g. if the server responded with an unexpected
             *   value).
             */
            fun merchantCity(): String = merchantCity.getRequired("merchant_city")

            /**
             * The country the merchant resides in.
             *
             * @throws IncreaseInvalidDataException if the JSON field has an unexpected type or is
             *   unexpectedly missing or null (e.g. if the server responded with an unexpected
             *   value).
             */
            fun merchantCountry(): String = merchantCountry.getRequired("merchant_country")

            /**
             * The name of the merchant.
             *
             * @throws IncreaseInvalidDataException if the JSON field has an unexpected type or is
             *   unexpectedly missing or null (e.g. if the server responded with an unexpected
             *   value).
             */
            fun merchantName(): String = merchantName.getRequired("merchant_name")

            /**
             * The merchant's postal code. For US merchants this is always a 5-digit ZIP code.
             *
             * @throws IncreaseInvalidDataException if the JSON field has an unexpected type (e.g.
             *   if the server responded with an unexpected value).
             */
            fun merchantPostalCode(): Optional<String> =
                merchantPostalCode.getOptional("merchant_postal_code")

            /**
             * The state the merchant resides in.
             *
             * @throws IncreaseInvalidDataException if the JSON field has an unexpected type (e.g.
             *   if the server responded with an unexpected value).
             */
            fun merchantState(): Optional<String> = merchantState.getOptional("merchant_state")

            /**
             * Network-specific identifiers for this refund.
             *
             * @throws IncreaseInvalidDataException if the JSON field has an unexpected type or is
             *   unexpectedly missing or null (e.g. if the server responded with an unexpected
             *   value).
             */
            fun networkIdentifiers(): NetworkIdentifiers =
                networkIdentifiers.getRequired("network_identifiers")

            /**
             * The identifier of the Pending Transaction associated with this Transaction.
             *
             * @throws IncreaseInvalidDataException if the JSON field has an unexpected type (e.g.
             *   if the server responded with an unexpected value).
             */
            fun pendingTransactionId(): Optional<String> =
                pendingTransactionId.getOptional("pending_transaction_id")

            /**
             * The amount in the minor unit of the transaction's presentment currency.
             *
             * @throws IncreaseInvalidDataException if the JSON field has an unexpected type or is
             *   unexpectedly missing or null (e.g. if the server responded with an unexpected
             *   value).
             */
            fun presentmentAmount(): Long = presentmentAmount.getRequired("presentment_amount")

            /**
             * The [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) code for the transaction's
             * presentment currency.
             *
             * @throws IncreaseInvalidDataException if the JSON field has an unexpected type or is
             *   unexpectedly missing or null (e.g. if the server responded with an unexpected
             *   value).
             */
            fun presentmentCurrency(): String =
                presentmentCurrency.getRequired("presentment_currency")

            /**
             * Additional details about the card purchase, such as tax and industry-specific fields.
             *
             * @throws IncreaseInvalidDataException if the JSON field has an unexpected type (e.g.
             *   if the server responded with an unexpected value).
             */
            fun purchaseDetails(): Optional<PurchaseDetails> =
                purchaseDetails.getOptional("purchase_details")

            /**
             * The identifier of the Transaction associated with this Transaction.
             *
             * @throws IncreaseInvalidDataException if the JSON field has an unexpected type or is
             *   unexpectedly missing or null (e.g. if the server responded with an unexpected
             *   value).
             */
            fun transactionId(): String = transactionId.getRequired("transaction_id")

            /**
             * A constant representing the object's type. For this resource it will always be
             * `card_settlement`.
             *
             * @throws IncreaseInvalidDataException if the JSON field has an unexpected type or is
             *   unexpectedly missing or null (e.g. if the server responded with an unexpected
             *   value).
             */
            fun type(): Type = type.getRequired("type")

            /**
             * Returns the raw JSON value of [id].
             *
             * Unlike [id], this method doesn't throw if the JSON field has an unexpected type.
             */
            @JsonProperty("id") @ExcludeMissing fun _id(): JsonField<String> = id

            /**
             * Returns the raw JSON value of [amount].
             *
             * Unlike [amount], this method doesn't throw if the JSON field has an unexpected type.
             */
            @JsonProperty("amount") @ExcludeMissing fun _amount(): JsonField<Long> = amount

            /**
             * Returns the raw JSON value of [cardAuthorization].
             *
             * Unlike [cardAuthorization], this method doesn't throw if the JSON field has an
             * unexpected type.
             */
            @JsonProperty("card_authorization")
            @ExcludeMissing
            fun _cardAuthorization(): JsonField<String> = cardAuthorization

            /**
             * Returns the raw JSON value of [cardPaymentId].
             *
             * Unlike [cardPaymentId], this method doesn't throw if the JSON field has an unexpected
             * type.
             */
            @JsonProperty("card_payment_id")
            @ExcludeMissing
            fun _cardPaymentId(): JsonField<String> = cardPaymentId

            /**
             * Returns the raw JSON value of [cashback].
             *
             * Unlike [cashback], this method doesn't throw if the JSON field has an unexpected
             * type.
             */
            @JsonProperty("cashback")
            @ExcludeMissing
            fun _cashback(): JsonField<Cashback> = cashback

            /**
             * Returns the raw JSON value of [currency].
             *
             * Unlike [currency], this method doesn't throw if the JSON field has an unexpected
             * type.
             */
            @JsonProperty("currency")
            @ExcludeMissing
            fun _currency(): JsonField<Currency> = currency

            /**
             * Returns the raw JSON value of [interchange].
             *
             * Unlike [interchange], this method doesn't throw if the JSON field has an unexpected
             * type.
             */
            @JsonProperty("interchange")
            @ExcludeMissing
            fun _interchange(): JsonField<Interchange> = interchange

            /**
             * Returns the raw JSON value of [merchantAcceptorId].
             *
             * Unlike [merchantAcceptorId], this method doesn't throw if the JSON field has an
             * unexpected type.
             */
            @JsonProperty("merchant_acceptor_id")
            @ExcludeMissing
            fun _merchantAcceptorId(): JsonField<String> = merchantAcceptorId

            /**
             * Returns the raw JSON value of [merchantCategoryCode].
             *
             * Unlike [merchantCategoryCode], this method doesn't throw if the JSON field has an
             * unexpected type.
             */
            @JsonProperty("merchant_category_code")
            @ExcludeMissing
            fun _merchantCategoryCode(): JsonField<String> = merchantCategoryCode

            /**
             * Returns the raw JSON value of [merchantCity].
             *
             * Unlike [merchantCity], this method doesn't throw if the JSON field has an unexpected
             * type.
             */
            @JsonProperty("merchant_city")
            @ExcludeMissing
            fun _merchantCity(): JsonField<String> = merchantCity

            /**
             * Returns the raw JSON value of [merchantCountry].
             *
             * Unlike [merchantCountry], this method doesn't throw if the JSON field has an
             * unexpected type.
             */
            @JsonProperty("merchant_country")
            @ExcludeMissing
            fun _merchantCountry(): JsonField<String> = merchantCountry

            /**
             * Returns the raw JSON value of [merchantName].
             *
             * Unlike [merchantName], this method doesn't throw if the JSON field has an unexpected
             * type.
             */
            @JsonProperty("merchant_name")
            @ExcludeMissing
            fun _merchantName(): JsonField<String> = merchantName

            /**
             * Returns the raw JSON value of [merchantPostalCode].
             *
             * Unlike [merchantPostalCode], this method doesn't throw if the JSON field has an
             * unexpected type.
             */
            @JsonProperty("merchant_postal_code")
            @ExcludeMissing
            fun _merchantPostalCode(): JsonField<String> = merchantPostalCode

            /**
             * Returns the raw JSON value of [merchantState].
             *
             * Unlike [merchantState], this method doesn't throw if the JSON field has an unexpected
             * type.
             */
            @JsonProperty("merchant_state")
            @ExcludeMissing
            fun _merchantState(): JsonField<String> = merchantState

            /**
             * Returns the raw JSON value of [networkIdentifiers].
             *
             * Unlike [networkIdentifiers], this method doesn't throw if the JSON field has an
             * unexpected type.
             */
            @JsonProperty("network_identifiers")
            @ExcludeMissing
            fun _networkIdentifiers(): JsonField<NetworkIdentifiers> = networkIdentifiers

            /**
             * Returns the raw JSON value of [pendingTransactionId].
             *
             * Unlike [pendingTransactionId], this method doesn't throw if the JSON field has an
             * unexpected type.
             */
            @JsonProperty("pending_transaction_id")
            @ExcludeMissing
            fun _pendingTransactionId(): JsonField<String> = pendingTransactionId

            /**
             * Returns the raw JSON value of [presentmentAmount].
             *
             * Unlike [presentmentAmount], this method doesn't throw if the JSON field has an
             * unexpected type.
             */
            @JsonProperty("presentment_amount")
            @ExcludeMissing
            fun _presentmentAmount(): JsonField<Long> = presentmentAmount

            /**
             * Returns the raw JSON value of [presentmentCurrency].
             *
             * Unlike [presentmentCurrency], this method doesn't throw if the JSON field has an
             * unexpected type.
             */
            @JsonProperty("presentment_currency")
            @ExcludeMissing
            fun _presentmentCurrency(): JsonField<String> = presentmentCurrency

            /**
             * Returns the raw JSON value of [purchaseDetails].
             *
             * Unlike [purchaseDetails], this method doesn't throw if the JSON field has an
             * unexpected type.
             */
            @JsonProperty("purchase_details")
            @ExcludeMissing
            fun _purchaseDetails(): JsonField<PurchaseDetails> = purchaseDetails

            /**
             * Returns the raw JSON value of [transactionId].
             *
             * Unlike [transactionId], this method doesn't throw if the JSON field has an unexpected
             * type.
             */
            @JsonProperty("transaction_id")
            @ExcludeMissing
            fun _transactionId(): JsonField<String> = transactionId

            /**
             * Returns the raw JSON value of [type].
             *
             * Unlike [type], this method doesn't throw if the JSON field has an unexpected type.
             */
            @JsonProperty("type") @ExcludeMissing fun _type(): JsonField<Type> = type

            @JsonAnySetter
            private fun putAdditionalProperty(key: String, value: JsonValue) {
                additionalProperties.put(key, value)
            }

            @JsonAnyGetter
            @ExcludeMissing
            fun _additionalProperties(): Map<String, JsonValue> =
                Collections.unmodifiableMap(additionalProperties)

            fun toBuilder() = Builder().from(this)

            companion object {

                /**
                 * Returns a mutable builder for constructing an instance of [CardSettlement].
                 *
                 * The following fields are required:
                 * ```java
                 * .id()
                 * .amount()
                 * .cardAuthorization()
                 * .cardPaymentId()
                 * .cashback()
                 * .currency()
                 * .interchange()
                 * .merchantAcceptorId()
                 * .merchantCategoryCode()
                 * .merchantCity()
                 * .merchantCountry()
                 * .merchantName()
                 * .merchantPostalCode()
                 * .merchantState()
                 * .networkIdentifiers()
                 * .pendingTransactionId()
                 * .presentmentAmount()
                 * .presentmentCurrency()
                 * .purchaseDetails()
                 * .transactionId()
                 * .type()
                 * ```
                 */
                @JvmStatic fun builder() = Builder()
            }

            /** A builder for [CardSettlement]. */
            class Builder internal constructor() {

                private var id: JsonField<String>? = null
                private var amount: JsonField<Long>? = null
                private var cardAuthorization: JsonField<String>? = null
                private var cardPaymentId: JsonField<String>? = null
                private var cashback: JsonField<Cashback>? = null
                private var currency: JsonField<Currency>? = null
                private var interchange: JsonField<Interchange>? = null
                private var merchantAcceptorId: JsonField<String>? = null
                private var merchantCategoryCode: JsonField<String>? = null
                private var merchantCity: JsonField<String>? = null
                private var merchantCountry: JsonField<String>? = null
                private var merchantName: JsonField<String>? = null
                private var merchantPostalCode: JsonField<String>? = null
                private var merchantState: JsonField<String>? = null
                private var networkIdentifiers: JsonField<NetworkIdentifiers>? = null
                private var pendingTransactionId: JsonField<String>? = null
                private var presentmentAmount: JsonField<Long>? = null
                private var presentmentCurrency: JsonField<String>? = null
                private var purchaseDetails: JsonField<PurchaseDetails>? = null
                private var transactionId: JsonField<String>? = null
                private var type: JsonField<Type>? = null
                private var additionalProperties: MutableMap<String, JsonValue> = mutableMapOf()

                @JvmSynthetic
                internal fun from(cardSettlement: CardSettlement) = apply {
                    id = cardSettlement.id
                    amount = cardSettlement.amount
                    cardAuthorization = cardSettlement.cardAuthorization
                    cardPaymentId = cardSettlement.cardPaymentId
                    cashback = cardSettlement.cashback
                    currency = cardSettlement.currency
                    interchange = cardSettlement.interchange
                    merchantAcceptorId = cardSettlement.merchantAcceptorId
                    merchantCategoryCode = cardSettlement.merchantCategoryCode
                    merchantCity = cardSettlement.merchantCity
                    merchantCountry = cardSettlement.merchantCountry
                    merchantName = cardSettlement.merchantName
                    merchantPostalCode = cardSettlement.merchantPostalCode
                    merchantState = cardSettlement.merchantState
                    networkIdentifiers = cardSettlement.networkIdentifiers
                    pendingTransactionId = cardSettlement.pendingTransactionId
                    presentmentAmount = cardSettlement.presentmentAmount
                    presentmentCurrency = cardSettlement.presentmentCurrency
                    purchaseDetails = cardSettlement.purchaseDetails
                    transactionId = cardSettlement.transactionId
                    type = cardSettlement.type
                    additionalProperties = cardSettlement.additionalProperties.toMutableMap()
                }

                /** The Card Settlement identifier. */
                fun id(id: String) = id(JsonField.of(id))

                /**
                 * Sets [Builder.id] to an arbitrary JSON value.
                 *
                 * You should usually call [Builder.id] with a well-typed [String] value instead.
                 * This method is primarily for setting the field to an undocumented or not yet
                 * supported value.
                 */
                fun id(id: JsonField<String>) = apply { this.id = id }

                /**
                 * The amount in the minor unit of the transaction's settlement currency. For
                 * dollars, for example, this is cents.
                 */
                fun amount(amount: Long) = amount(JsonField.of(amount))

                /**
                 * Sets [Builder.amount] to an arbitrary JSON value.
                 *
                 * You should usually call [Builder.amount] with a well-typed [Long] value instead.
                 * This method is primarily for setting the field to an undocumented or not yet
                 * supported value.
                 */
                fun amount(amount: JsonField<Long>) = apply { this.amount = amount }

                /**
                 * The Card Authorization that was created prior to this Card Settlement, if one
                 * exists.
                 */
                fun cardAuthorization(cardAuthorization: String?) =
                    cardAuthorization(JsonField.ofNullable(cardAuthorization))

                /**
                 * Alias for calling [Builder.cardAuthorization] with
                 * `cardAuthorization.orElse(null)`.
                 */
                fun cardAuthorization(cardAuthorization: Optional<String>) =
                    cardAuthorization(cardAuthorization.getOrNull())

                /**
                 * Sets [Builder.cardAuthorization] to an arbitrary JSON value.
                 *
                 * You should usually call [Builder.cardAuthorization] with a well-typed [String]
                 * value instead. This method is primarily for setting the field to an undocumented
                 * or not yet supported value.
                 */
                fun cardAuthorization(cardAuthorization: JsonField<String>) = apply {
                    this.cardAuthorization = cardAuthorization
                }

                /** The ID of the Card Payment this transaction belongs to. */
                fun cardPaymentId(cardPaymentId: String) =
                    cardPaymentId(JsonField.of(cardPaymentId))

                /**
                 * Sets [Builder.cardPaymentId] to an arbitrary JSON value.
                 *
                 * You should usually call [Builder.cardPaymentId] with a well-typed [String] value
                 * instead. This method is primarily for setting the field to an undocumented or not
                 * yet supported value.
                 */
                fun cardPaymentId(cardPaymentId: JsonField<String>) = apply {
                    this.cardPaymentId = cardPaymentId
                }

                /**
                 * Cashback earned on this transaction, if eligible. Cashback is paid out in
                 * aggregate, monthly.
                 */
                fun cashback(cashback: Cashback?) = cashback(JsonField.ofNullable(cashback))

                /** Alias for calling [Builder.cashback] with `cashback.orElse(null)`. */
                fun cashback(cashback: Optional<Cashback>) = cashback(cashback.getOrNull())

                /**
                 * Sets [Builder.cashback] to an arbitrary JSON value.
                 *
                 * You should usually call [Builder.cashback] with a well-typed [Cashback] value
                 * instead. This method is primarily for setting the field to an undocumented or not
                 * yet supported value.
                 */
                fun cashback(cashback: JsonField<Cashback>) = apply { this.cashback = cashback }

                /**
                 * The [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) code for the transaction's
                 * settlement currency.
                 */
                fun currency(currency: Currency) = currency(JsonField.of(currency))

                /**
                 * Sets [Builder.currency] to an arbitrary JSON value.
                 *
                 * You should usually call [Builder.currency] with a well-typed [Currency] value
                 * instead. This method is primarily for setting the field to an undocumented or not
                 * yet supported value.
                 */
                fun currency(currency: JsonField<Currency>) = apply { this.currency = currency }

                /** Interchange assessed as a part of this transaction. */
                fun interchange(interchange: Interchange?) =
                    interchange(JsonField.ofNullable(interchange))

                /** Alias for calling [Builder.interchange] with `interchange.orElse(null)`. */
                fun interchange(interchange: Optional<Interchange>) =
                    interchange(interchange.getOrNull())

                /**
                 * Sets [Builder.interchange] to an arbitrary JSON value.
                 *
                 * You should usually call [Builder.interchange] with a well-typed [Interchange]
                 * value instead. This method is primarily for setting the field to an undocumented
                 * or not yet supported value.
                 */
                fun interchange(interchange: JsonField<Interchange>) = apply {
                    this.interchange = interchange
                }

                /**
                 * The merchant identifier (commonly abbreviated as MID) of the merchant the card is
                 * transacting with.
                 */
                fun merchantAcceptorId(merchantAcceptorId: String) =
                    merchantAcceptorId(JsonField.of(merchantAcceptorId))

                /**
                 * Sets [Builder.merchantAcceptorId] to an arbitrary JSON value.
                 *
                 * You should usually call [Builder.merchantAcceptorId] with a well-typed [String]
                 * value instead. This method is primarily for setting the field to an undocumented
                 * or not yet supported value.
                 */
                fun merchantAcceptorId(merchantAcceptorId: JsonField<String>) = apply {
                    this.merchantAcceptorId = merchantAcceptorId
                }

                /** The 4-digit MCC describing the merchant's business. */
                fun merchantCategoryCode(merchantCategoryCode: String) =
                    merchantCategoryCode(JsonField.of(merchantCategoryCode))

                /**
                 * Sets [Builder.merchantCategoryCode] to an arbitrary JSON value.
                 *
                 * You should usually call [Builder.merchantCategoryCode] with a well-typed [String]
                 * value instead. This method is primarily for setting the field to an undocumented
                 * or not yet supported value.
                 */
                fun merchantCategoryCode(merchantCategoryCode: JsonField<String>) = apply {
                    this.merchantCategoryCode = merchantCategoryCode
                }

                /** The city the merchant resides in. */
                fun merchantCity(merchantCity: String) = merchantCity(JsonField.of(merchantCity))

                /**
                 * Sets [Builder.merchantCity] to an arbitrary JSON value.
                 *
                 * You should usually call [Builder.merchantCity] with a well-typed [String] value
                 * instead. This method is primarily for setting the field to an undocumented or not
                 * yet supported value.
                 */
                fun merchantCity(merchantCity: JsonField<String>) = apply {
                    this.merchantCity = merchantCity
                }

                /** The country the merchant resides in. */
                fun merchantCountry(merchantCountry: String) =
                    merchantCountry(JsonField.of(merchantCountry))

                /**
                 * Sets [Builder.merchantCountry] to an arbitrary JSON value.
                 *
                 * You should usually call [Builder.merchantCountry] with a well-typed [String]
                 * value instead. This method is primarily for setting the field to an undocumented
                 * or not yet supported value.
                 */
                fun merchantCountry(merchantCountry: JsonField<String>) = apply {
                    this.merchantCountry = merchantCountry
                }

                /** The name of the merchant. */
                fun merchantName(merchantName: String) = merchantName(JsonField.of(merchantName))

                /**
                 * Sets [Builder.merchantName] to an arbitrary JSON value.
                 *
                 * You should usually call [Builder.merchantName] with a well-typed [String] value
                 * instead. This method is primarily for setting the field to an undocumented or not
                 * yet supported value.
                 */
                fun merchantName(merchantName: JsonField<String>) = apply {
                    this.merchantName = merchantName
                }

                /**
                 * The merchant's postal code. For US merchants this is always a 5-digit ZIP code.
                 */
                fun merchantPostalCode(merchantPostalCode: String?) =
                    merchantPostalCode(JsonField.ofNullable(merchantPostalCode))

                /**
                 * Alias for calling [Builder.merchantPostalCode] with
                 * `merchantPostalCode.orElse(null)`.
                 */
                fun merchantPostalCode(merchantPostalCode: Optional<String>) =
                    merchantPostalCode(merchantPostalCode.getOrNull())

                /**
                 * Sets [Builder.merchantPostalCode] to an arbitrary JSON value.
                 *
                 * You should usually call [Builder.merchantPostalCode] with a well-typed [String]
                 * value instead. This method is primarily for setting the field to an undocumented
                 * or not yet supported value.
                 */
                fun merchantPostalCode(merchantPostalCode: JsonField<String>) = apply {
                    this.merchantPostalCode = merchantPostalCode
                }

                /** The state the merchant resides in. */
                fun merchantState(merchantState: String?) =
                    merchantState(JsonField.ofNullable(merchantState))

                /** Alias for calling [Builder.merchantState] with `merchantState.orElse(null)`. */
                fun merchantState(merchantState: Optional<String>) =
                    merchantState(merchantState.getOrNull())

                /**
                 * Sets [Builder.merchantState] to an arbitrary JSON value.
                 *
                 * You should usually call [Builder.merchantState] with a well-typed [String] value
                 * instead. This method is primarily for setting the field to an undocumented or not
                 * yet supported value.
                 */
                fun merchantState(merchantState: JsonField<String>) = apply {
                    this.merchantState = merchantState
                }

                /** Network-specific identifiers for this refund. */
                fun networkIdentifiers(networkIdentifiers: NetworkIdentifiers) =
                    networkIdentifiers(JsonField.of(networkIdentifiers))

                /**
                 * Sets [Builder.networkIdentifiers] to an arbitrary JSON value.
                 *
                 * You should usually call [Builder.networkIdentifiers] with a well-typed
                 * [NetworkIdentifiers] value instead. This method is primarily for setting the
                 * field to an undocumented or not yet supported value.
                 */
                fun networkIdentifiers(networkIdentifiers: JsonField<NetworkIdentifiers>) = apply {
                    this.networkIdentifiers = networkIdentifiers
                }

                /** The identifier of the Pending Transaction associated with this Transaction. */
                fun pendingTransactionId(pendingTransactionId: String?) =
                    pendingTransactionId(JsonField.ofNullable(pendingTransactionId))

                /**
                 * Alias for calling [Builder.pendingTransactionId] with
                 * `pendingTransactionId.orElse(null)`.
                 */
                fun pendingTransactionId(pendingTransactionId: Optional<String>) =
                    pendingTransactionId(pendingTransactionId.getOrNull())

                /**
                 * Sets [Builder.pendingTransactionId] to an arbitrary JSON value.
                 *
                 * You should usually call [Builder.pendingTransactionId] with a well-typed [String]
                 * value instead. This method is primarily for setting the field to an undocumented
                 * or not yet supported value.
                 */
                fun pendingTransactionId(pendingTransactionId: JsonField<String>) = apply {
                    this.pendingTransactionId = pendingTransactionId
                }

                /** The amount in the minor unit of the transaction's presentment currency. */
                fun presentmentAmount(presentmentAmount: Long) =
                    presentmentAmount(JsonField.of(presentmentAmount))

                /**
                 * Sets [Builder.presentmentAmount] to an arbitrary JSON value.
                 *
                 * You should usually call [Builder.presentmentAmount] with a well-typed [Long]
                 * value instead. This method is primarily for setting the field to an undocumented
                 * or not yet supported value.
                 */
                fun presentmentAmount(presentmentAmount: JsonField<Long>) = apply {
                    this.presentmentAmount = presentmentAmount
                }

                /**
                 * The [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) code for the transaction's
                 * presentment currency.
                 */
                fun presentmentCurrency(presentmentCurrency: String) =
                    presentmentCurrency(JsonField.of(presentmentCurrency))

                /**
                 * Sets [Builder.presentmentCurrency] to an arbitrary JSON value.
                 *
                 * You should usually call [Builder.presentmentCurrency] with a well-typed [String]
                 * value instead. This method is primarily for setting the field to an undocumented
                 * or not yet supported value.
                 */
                fun presentmentCurrency(presentmentCurrency: JsonField<String>) = apply {
                    this.presentmentCurrency = presentmentCurrency
                }

                /**
                 * Additional details about the card purchase, such as tax and industry-specific
                 * fields.
                 */
                fun purchaseDetails(purchaseDetails: PurchaseDetails?) =
                    purchaseDetails(JsonField.ofNullable(purchaseDetails))

                /**
                 * Alias for calling [Builder.purchaseDetails] with `purchaseDetails.orElse(null)`.
                 */
                fun purchaseDetails(purchaseDetails: Optional<PurchaseDetails>) =
                    purchaseDetails(purchaseDetails.getOrNull())

                /**
                 * Sets [Builder.purchaseDetails] to an arbitrary JSON value.
                 *
                 * You should usually call [Builder.purchaseDetails] with a well-typed
                 * [PurchaseDetails] value instead. This method is primarily for setting the field
                 * to an undocumented or not yet supported value.
                 */
                fun purchaseDetails(purchaseDetails: JsonField<PurchaseDetails>) = apply {
                    this.purchaseDetails = purchaseDetails
                }

                /** The identifier of the Transaction associated with this Transaction. */
                fun transactionId(transactionId: String) =
                    transactionId(JsonField.of(transactionId))

                /**
                 * Sets [Builder.transactionId] to an arbitrary JSON value.
                 *
                 * You should usually call [Builder.transactionId] with a well-typed [String] value
                 * instead. This method is primarily for setting the field to an undocumented or not
                 * yet supported value.
                 */
                fun transactionId(transactionId: JsonField<String>) = apply {
                    this.transactionId = transactionId
                }

                /**
                 * A constant representing the object's type. For this resource it will always be
                 * `card_settlement`.
                 */
                fun type(type: Type) = type(JsonField.of(type))

                /**
                 * Sets [Builder.type] to an arbitrary JSON value.
                 *
                 * You should usually call [Builder.type] with a well-typed [Type] value instead.
                 * This method is primarily for setting the field to an undocumented or not yet
                 * supported value.
                 */
                fun type(type: JsonField<Type>) = apply { this.type = type }

                fun additionalProperties(additionalProperties: Map<String, JsonValue>) = apply {
                    this.additionalProperties.clear()
                    putAllAdditionalProperties(additionalProperties)
                }

                fun putAdditionalProperty(key: String, value: JsonValue) = apply {
                    additionalProperties.put(key, value)
                }

                fun putAllAdditionalProperties(additionalProperties: Map<String, JsonValue>) =
                    apply {
                        this.additionalProperties.putAll(additionalProperties)
                    }

                fun removeAdditionalProperty(key: String) = apply {
                    additionalProperties.remove(key)
                }

                fun removeAllAdditionalProperties(keys: Set<String>) = apply {
                    keys.forEach(::removeAdditionalProperty)
                }

                /**
                 * Returns an immutable instance of [CardSettlement].
                 *
                 * Further updates to this [Builder] will not mutate the returned instance.
                 *
                 * The following fields are required:
                 * ```java
                 * .id()
                 * .amount()
                 * .cardAuthorization()
                 * .cardPaymentId()
                 * .cashback()
                 * .currency()
                 * .interchange()
                 * .merchantAcceptorId()
                 * .merchantCategoryCode()
                 * .merchantCity()
                 * .merchantCountry()
                 * .merchantName()
                 * .merchantPostalCode()
                 * .merchantState()
                 * .networkIdentifiers()
                 * .pendingTransactionId()
                 * .presentmentAmount()
                 * .presentmentCurrency()
                 * .purchaseDetails()
                 * .transactionId()
                 * .type()
                 * ```
                 *
                 * @throws IllegalStateException if any required field is unset.
                 */
                fun build(): CardSettlement =
                    CardSettlement(
                        checkRequired("id", id),
                        checkRequired("amount", amount),
                        checkRequired("cardAuthorization", cardAuthorization),
                        checkRequired("cardPaymentId", cardPaymentId),
                        checkRequired("cashback", cashback),
                        checkRequired("currency", currency),
                        checkRequired("interchange", interchange),
                        checkRequired("merchantAcceptorId", merchantAcceptorId),
                        checkRequired("merchantCategoryCode", merchantCategoryCode),
                        checkRequired("merchantCity", merchantCity),
                        checkRequired("merchantCountry", merchantCountry),
                        checkRequired("merchantName", merchantName),
                        checkRequired("merchantPostalCode", merchantPostalCode),
                        checkRequired("merchantState", merchantState),
                        checkRequired("networkIdentifiers", networkIdentifiers),
                        checkRequired("pendingTransactionId", pendingTransactionId),
                        checkRequired("presentmentAmount", presentmentAmount),
                        checkRequired("presentmentCurrency", presentmentCurrency),
                        checkRequired("purchaseDetails", purchaseDetails),
                        checkRequired("transactionId", transactionId),
                        checkRequired("type", type),
                        additionalProperties.toMutableMap(),
                    )
            }

            private var validated: Boolean = false

            fun validate(): CardSettlement = apply {
                if (validated) {
                    return@apply
                }

                id()
                amount()
                cardAuthorization()
                cardPaymentId()
                cashback().ifPresent { it.validate() }
                currency().validate()
                interchange().ifPresent { it.validate() }
                merchantAcceptorId()
                merchantCategoryCode()
                merchantCity()
                merchantCountry()
                merchantName()
                merchantPostalCode()
                merchantState()
                networkIdentifiers().validate()
                pendingTransactionId()
                presentmentAmount()
                presentmentCurrency()
                purchaseDetails().ifPresent { it.validate() }
                transactionId()
                type().validate()
                validated = true
            }

            fun isValid(): Boolean =
                try {
                    validate()
                    true
                } catch (e: IncreaseInvalidDataException) {
                    false
                }

            /**
             * Returns a score indicating how many valid values are contained in this object
             * recursively.
             *
             * Used for best match union deserialization.
             */
            @JvmSynthetic
            internal fun validity(): Int =
                (if (id.asKnown().isPresent) 1 else 0) +
                    (if (amount.asKnown().isPresent) 1 else 0) +
                    (if (cardAuthorization.asKnown().isPresent) 1 else 0) +
                    (if (cardPaymentId.asKnown().isPresent) 1 else 0) +
                    (cashback.asKnown().getOrNull()?.validity() ?: 0) +
                    (currency.asKnown().getOrNull()?.validity() ?: 0) +
                    (interchange.asKnown().getOrNull()?.validity() ?: 0) +
                    (if (merchantAcceptorId.asKnown().isPresent) 1 else 0) +
                    (if (merchantCategoryCode.asKnown().isPresent) 1 else 0) +
                    (if (merchantCity.asKnown().isPresent) 1 else 0) +
                    (if (merchantCountry.asKnown().isPresent) 1 else 0) +
                    (if (merchantName.asKnown().isPresent) 1 else 0) +
                    (if (merchantPostalCode.asKnown().isPresent) 1 else 0) +
                    (if (merchantState.asKnown().isPresent) 1 else 0) +
                    (networkIdentifiers.asKnown().getOrNull()?.validity() ?: 0) +
                    (if (pendingTransactionId.asKnown().isPresent) 1 else 0) +
                    (if (presentmentAmount.asKnown().isPresent) 1 else 0) +
                    (if (presentmentCurrency.asKnown().isPresent) 1 else 0) +
                    (purchaseDetails.asKnown().getOrNull()?.validity() ?: 0) +
                    (if (transactionId.asKnown().isPresent) 1 else 0) +
                    (type.asKnown().getOrNull()?.validity() ?: 0)

            /**
             * Cashback earned on this transaction, if eligible. Cashback is paid out in aggregate,
             * monthly.
             */
            class Cashback
            private constructor(
                private val amount: JsonField<String>,
                private val currency: JsonField<Currency>,
                private val additionalProperties: MutableMap<String, JsonValue>,
            ) {

                @JsonCreator
                private constructor(
                    @JsonProperty("amount")
                    @ExcludeMissing
                    amount: JsonField<String> = JsonMissing.of(),
                    @JsonProperty("currency")
                    @ExcludeMissing
                    currency: JsonField<Currency> = JsonMissing.of(),
                ) : this(amount, currency, mutableMapOf())

                /**
                 * The cashback amount given as a string containing a decimal number. The amount is
                 * a positive number if it will be credited to you (e.g., settlements) and a
                 * negative number if it will be debited (e.g., refunds).
                 *
                 * @throws IncreaseInvalidDataException if the JSON field has an unexpected type or
                 *   is unexpectedly missing or null (e.g. if the server responded with an
                 *   unexpected value).
                 */
                fun amount(): String = amount.getRequired("amount")

                /**
                 * The [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) code for the cashback.
                 *
                 * @throws IncreaseInvalidDataException if the JSON field has an unexpected type or
                 *   is unexpectedly missing or null (e.g. if the server responded with an
                 *   unexpected value).
                 */
                fun currency(): Currency = currency.getRequired("currency")

                /**
                 * Returns the raw JSON value of [amount].
                 *
                 * Unlike [amount], this method doesn't throw if the JSON field has an unexpected
                 * type.
                 */
                @JsonProperty("amount") @ExcludeMissing fun _amount(): JsonField<String> = amount

                /**
                 * Returns the raw JSON value of [currency].
                 *
                 * Unlike [currency], this method doesn't throw if the JSON field has an unexpected
                 * type.
                 */
                @JsonProperty("currency")
                @ExcludeMissing
                fun _currency(): JsonField<Currency> = currency

                @JsonAnySetter
                private fun putAdditionalProperty(key: String, value: JsonValue) {
                    additionalProperties.put(key, value)
                }

                @JsonAnyGetter
                @ExcludeMissing
                fun _additionalProperties(): Map<String, JsonValue> =
                    Collections.unmodifiableMap(additionalProperties)

                fun toBuilder() = Builder().from(this)

                companion object {

                    /**
                     * Returns a mutable builder for constructing an instance of [Cashback].
                     *
                     * The following fields are required:
                     * ```java
                     * .amount()
                     * .currency()
                     * ```
                     */
                    @JvmStatic fun builder() = Builder()
                }

                /** A builder for [Cashback]. */
                class Builder internal constructor() {

                    private var amount: JsonField<String>? = null
                    private var currency: JsonField<Currency>? = null
                    private var additionalProperties: MutableMap<String, JsonValue> = mutableMapOf()

                    @JvmSynthetic
                    internal fun from(cashback: Cashback) = apply {
                        amount = cashback.amount
                        currency = cashback.currency
                        additionalProperties = cashback.additionalProperties.toMutableMap()
                    }

                    /**
                     * The cashback amount given as a string containing a decimal number. The amount
                     * is a positive number if it will be credited to you (e.g., settlements) and a
                     * negative number if it will be debited (e.g., refunds).
                     */
                    fun amount(amount: String) = amount(JsonField.of(amount))

                    /**
                     * Sets [Builder.amount] to an arbitrary JSON value.
                     *
                     * You should usually call [Builder.amount] with a well-typed [String] value
                     * instead. This method is primarily for setting the field to an undocumented or
                     * not yet supported value.
                     */
                    fun amount(amount: JsonField<String>) = apply { this.amount = amount }

                    /**
                     * The [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) code for the cashback.
                     */
                    fun currency(currency: Currency) = currency(JsonField.of(currency))

                    /**
                     * Sets [Builder.currency] to an arbitrary JSON value.
                     *
                     * You should usually call [Builder.currency] with a well-typed [Currency] value
                     * instead. This method is primarily for setting the field to an undocumented or
                     * not yet supported value.
                     */
                    fun currency(currency: JsonField<Currency>) = apply { this.currency = currency }

                    fun additionalProperties(additionalProperties: Map<String, JsonValue>) = apply {
                        this.additionalProperties.clear()
                        putAllAdditionalProperties(additionalProperties)
                    }

                    fun putAdditionalProperty(key: String, value: JsonValue) = apply {
                        additionalProperties.put(key, value)
                    }

                    fun putAllAdditionalProperties(additionalProperties: Map<String, JsonValue>) =
                        apply {
                            this.additionalProperties.putAll(additionalProperties)
                        }

                    fun removeAdditionalProperty(key: String) = apply {
                        additionalProperties.remove(key)
                    }

                    fun removeAllAdditionalProperties(keys: Set<String>) = apply {
                        keys.forEach(::removeAdditionalProperty)
                    }

                    /**
                     * Returns an immutable instance of [Cashback].
                     *
                     * Further updates to this [Builder] will not mutate the returned instance.
                     *
                     * The following fields are required:
                     * ```java
                     * .amount()
                     * .currency()
                     * ```
                     *
                     * @throws IllegalStateException if any required field is unset.
                     */
                    fun build(): Cashback =
                        Cashback(
                            checkRequired("amount", amount),
                            checkRequired("currency", currency),
                            additionalProperties.toMutableMap(),
                        )
                }

                private var validated: Boolean = false

                fun validate(): Cashback = apply {
                    if (validated) {
                        return@apply
                    }

                    amount()
                    currency().validate()
                    validated = true
                }

                fun isValid(): Boolean =
                    try {
                        validate()
                        true
                    } catch (e: IncreaseInvalidDataException) {
                        false
                    }

                /**
                 * Returns a score indicating how many valid values are contained in this object
                 * recursively.
                 *
                 * Used for best match union deserialization.
                 */
                @JvmSynthetic
                internal fun validity(): Int =
                    (if (amount.asKnown().isPresent) 1 else 0) +
                        (currency.asKnown().getOrNull()?.validity() ?: 0)

                /** The [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) code for the cashback. */
                class Currency
                @JsonCreator
                private constructor(private val value: JsonField<String>) : Enum {

                    /**
                     * Returns this class instance's raw value.
                     *
                     * This is usually only useful if this instance was deserialized from data that
                     * doesn't match any known member, and you want to know that value. For example,
                     * if the SDK is on an older version than the API, then the API may respond with
                     * new members that the SDK is unaware of.
                     */
                    @com.fasterxml.jackson.annotation.JsonValue
                    fun _value(): JsonField<String> = value

                    companion object {

                        /** Canadian Dollar (CAD) */
                        @JvmField val CAD = of("CAD")

                        /** Swiss Franc (CHF) */
                        @JvmField val CHF = of("CHF")

                        /** Euro (EUR) */
                        @JvmField val EUR = of("EUR")

                        /** British Pound (GBP) */
                        @JvmField val GBP = of("GBP")

                        /** Japanese Yen (JPY) */
                        @JvmField val JPY = of("JPY")

                        /** US Dollar (USD) */
                        @JvmField val USD = of("USD")

                        @JvmStatic fun of(value: String) = Currency(JsonField.of(value))
                    }

                    /** An enum containing [Currency]'s known values. */
                    enum class Known {
                        /** Canadian Dollar (CAD) */
                        CAD,
                        /** Swiss Franc (CHF) */
                        CHF,
                        /** Euro (EUR) */
                        EUR,
                        /** British Pound (GBP) */
                        GBP,
                        /** Japanese Yen (JPY) */
                        JPY,
                        /** US Dollar (USD) */
                        USD,
                    }

                    /**
                     * An enum containing [Currency]'s known values, as well as an [_UNKNOWN]
                     * member.
                     *
                     * An instance of [Currency] can contain an unknown value in a couple of cases:
                     * - It was deserialized from data that doesn't match any known member. For
                     *   example, if the SDK is on an older version than the API, then the API may
                     *   respond with new members that the SDK is unaware of.
                     * - It was constructed with an arbitrary value using the [of] method.
                     */
                    enum class Value {
                        /** Canadian Dollar (CAD) */
                        CAD,
                        /** Swiss Franc (CHF) */
                        CHF,
                        /** Euro (EUR) */
                        EUR,
                        /** British Pound (GBP) */
                        GBP,
                        /** Japanese Yen (JPY) */
                        JPY,
                        /** US Dollar (USD) */
                        USD,
                        /**
                         * An enum member indicating that [Currency] was instantiated with an
                         * unknown value.
                         */
                        _UNKNOWN,
                    }

                    /**
                     * Returns an enum member corresponding to this class instance's value, or
                     * [Value._UNKNOWN] if the class was instantiated with an unknown value.
                     *
                     * Use the [known] method instead if you're certain the value is always known or
                     * if you want to throw for the unknown case.
                     */
                    fun value(): Value =
                        when (this) {
                            CAD -> Value.CAD
                            CHF -> Value.CHF
                            EUR -> Value.EUR
                            GBP -> Value.GBP
                            JPY -> Value.JPY
                            USD -> Value.USD
                            else -> Value._UNKNOWN
                        }

                    /**
                     * Returns an enum member corresponding to this class instance's value.
                     *
                     * Use the [value] method instead if you're uncertain the value is always known
                     * and don't want to throw for the unknown case.
                     *
                     * @throws IncreaseInvalidDataException if this class instance's value is a not
                     *   a known member.
                     */
                    fun known(): Known =
                        when (this) {
                            CAD -> Known.CAD
                            CHF -> Known.CHF
                            EUR -> Known.EUR
                            GBP -> Known.GBP
                            JPY -> Known.JPY
                            USD -> Known.USD
                            else -> throw IncreaseInvalidDataException("Unknown Currency: $value")
                        }

                    /**
                     * Returns this class instance's primitive wire representation.
                     *
                     * This differs from the [toString] method because that method is primarily for
                     * debugging and generally doesn't throw.
                     *
                     * @throws IncreaseInvalidDataException if this class instance's value does not
                     *   have the expected primitive type.
                     */
                    fun asString(): String =
                        _value().asString().orElseThrow {
                            IncreaseInvalidDataException("Value is not a String")
                        }

                    private var validated: Boolean = false

                    fun validate(): Currency = apply {
                        if (validated) {
                            return@apply
                        }

                        known()
                        validated = true
                    }

                    fun isValid(): Boolean =
                        try {
                            validate()
                            true
                        } catch (e: IncreaseInvalidDataException) {
                            false
                        }

                    /**
                     * Returns a score indicating how many valid values are contained in this object
                     * recursively.
                     *
                     * Used for best match union deserialization.
                     */
                    @JvmSynthetic
                    internal fun validity(): Int = if (value() == Value._UNKNOWN) 0 else 1

                    override fun equals(other: Any?): Boolean {
                        if (this === other) {
                            return true
                        }

                        return /* spotless:off */ other is Currency && value == other.value /* spotless:on */
                    }

                    override fun hashCode() = value.hashCode()

                    override fun toString() = value.toString()
                }

                override fun equals(other: Any?): Boolean {
                    if (this === other) {
                        return true
                    }

                    return /* spotless:off */ other is Cashback && amount == other.amount && currency == other.currency && additionalProperties == other.additionalProperties /* spotless:on */
                }

                /* spotless:off */
                private val hashCode: Int by lazy { Objects.hash(amount, currency, additionalProperties) }
                /* spotless:on */

                override fun hashCode(): Int = hashCode

                override fun toString() =
                    "Cashback{amount=$amount, currency=$currency, additionalProperties=$additionalProperties}"
            }

            /**
             * The [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) code for the transaction's
             * settlement currency.
             */
            class Currency @JsonCreator private constructor(private val value: JsonField<String>) :
                Enum {

                /**
                 * Returns this class instance's raw value.
                 *
                 * This is usually only useful if this instance was deserialized from data that
                 * doesn't match any known member, and you want to know that value. For example, if
                 * the SDK is on an older version than the API, then the API may respond with new
                 * members that the SDK is unaware of.
                 */
                @com.fasterxml.jackson.annotation.JsonValue fun _value(): JsonField<String> = value

                companion object {

                    /** Canadian Dollar (CAD) */
                    @JvmField val CAD = of("CAD")

                    /** Swiss Franc (CHF) */
                    @JvmField val CHF = of("CHF")

                    /** Euro (EUR) */
                    @JvmField val EUR = of("EUR")

                    /** British Pound (GBP) */
                    @JvmField val GBP = of("GBP")

                    /** Japanese Yen (JPY) */
                    @JvmField val JPY = of("JPY")

                    /** US Dollar (USD) */
                    @JvmField val USD = of("USD")

                    @JvmStatic fun of(value: String) = Currency(JsonField.of(value))
                }

                /** An enum containing [Currency]'s known values. */
                enum class Known {
                    /** Canadian Dollar (CAD) */
                    CAD,
                    /** Swiss Franc (CHF) */
                    CHF,
                    /** Euro (EUR) */
                    EUR,
                    /** British Pound (GBP) */
                    GBP,
                    /** Japanese Yen (JPY) */
                    JPY,
                    /** US Dollar (USD) */
                    USD,
                }

                /**
                 * An enum containing [Currency]'s known values, as well as an [_UNKNOWN] member.
                 *
                 * An instance of [Currency] can contain an unknown value in a couple of cases:
                 * - It was deserialized from data that doesn't match any known member. For example,
                 *   if the SDK is on an older version than the API, then the API may respond with
                 *   new members that the SDK is unaware of.
                 * - It was constructed with an arbitrary value using the [of] method.
                 */
                enum class Value {
                    /** Canadian Dollar (CAD) */
                    CAD,
                    /** Swiss Franc (CHF) */
                    CHF,
                    /** Euro (EUR) */
                    EUR,
                    /** British Pound (GBP) */
                    GBP,
                    /** Japanese Yen (JPY) */
                    JPY,
                    /** US Dollar (USD) */
                    USD,
                    /**
                     * An enum member indicating that [Currency] was instantiated with an unknown
                     * value.
                     */
                    _UNKNOWN,
                }

                /**
                 * Returns an enum member corresponding to this class instance's value, or
                 * [Value._UNKNOWN] if the class was instantiated with an unknown value.
                 *
                 * Use the [known] method instead if you're certain the value is always known or if
                 * you want to throw for the unknown case.
                 */
                fun value(): Value =
                    when (this) {
                        CAD -> Value.CAD
                        CHF -> Value.CHF
                        EUR -> Value.EUR
                        GBP -> Value.GBP
                        JPY -> Value.JPY
                        USD -> Value.USD
                        else -> Value._UNKNOWN
                    }

                /**
                 * Returns an enum member corresponding to this class instance's value.
                 *
                 * Use the [value] method instead if you're uncertain the value is always known and
                 * don't want to throw for the unknown case.
                 *
                 * @throws IncreaseInvalidDataException if this class instance's value is a not a
                 *   known member.
                 */
                fun known(): Known =
                    when (this) {
                        CAD -> Known.CAD
                        CHF -> Known.CHF
                        EUR -> Known.EUR
                        GBP -> Known.GBP
                        JPY -> Known.JPY
                        USD -> Known.USD
                        else -> throw IncreaseInvalidDataException("Unknown Currency: $value")
                    }

                /**
                 * Returns this class instance's primitive wire representation.
                 *
                 * This differs from the [toString] method because that method is primarily for
                 * debugging and generally doesn't throw.
                 *
                 * @throws IncreaseInvalidDataException if this class instance's value does not have
                 *   the expected primitive type.
                 */
                fun asString(): String =
                    _value().asString().orElseThrow {
                        IncreaseInvalidDataException("Value is not a String")
                    }

                private var validated: Boolean = false

                fun validate(): Currency = apply {
                    if (validated) {
                        return@apply
                    }

                    known()
                    validated = true
                }

                fun isValid(): Boolean =
                    try {
                        validate()
                        true
                    } catch (e: IncreaseInvalidDataException) {
                        false
                    }

                /**
                 * Returns a score indicating how many valid values are contained in this object
                 * recursively.
                 *
                 * Used for best match union deserialization.
                 */
                @JvmSynthetic internal fun validity(): Int = if (value() == Value._UNKNOWN) 0 else 1

                override fun equals(other: Any?): Boolean {
                    if (this === other) {
                        return true
                    }

                    return /* spotless:off */ other is Currency && value == other.value /* spotless:on */
                }

                override fun hashCode() = value.hashCode()

                override fun toString() = value.toString()
            }

            /** Interchange assessed as a part of this transaction. */
            class Interchange
            private constructor(
                private val amount: JsonField<String>,
                private val code: JsonField<String>,
                private val currency: JsonField<Currency>,
                private val additionalProperties: MutableMap<String, JsonValue>,
            ) {

                @JsonCreator
                private constructor(
                    @JsonProperty("amount")
                    @ExcludeMissing
                    amount: JsonField<String> = JsonMissing.of(),
                    @JsonProperty("code")
                    @ExcludeMissing
                    code: JsonField<String> = JsonMissing.of(),
                    @JsonProperty("currency")
                    @ExcludeMissing
                    currency: JsonField<Currency> = JsonMissing.of(),
                ) : this(amount, code, currency, mutableMapOf())

                /**
                 * The interchange amount given as a string containing a decimal number in major
                 * units (so e.g., "3.14" for $3.14). The amount is a positive number if it is
                 * credited to Increase (e.g., settlements) and a negative number if it is debited
                 * (e.g., refunds).
                 *
                 * @throws IncreaseInvalidDataException if the JSON field has an unexpected type or
                 *   is unexpectedly missing or null (e.g. if the server responded with an
                 *   unexpected value).
                 */
                fun amount(): String = amount.getRequired("amount")

                /**
                 * The card network specific interchange code.
                 *
                 * @throws IncreaseInvalidDataException if the JSON field has an unexpected type
                 *   (e.g. if the server responded with an unexpected value).
                 */
                fun code(): Optional<String> = code.getOptional("code")

                /**
                 * The [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) code for the interchange
                 * reimbursement.
                 *
                 * @throws IncreaseInvalidDataException if the JSON field has an unexpected type or
                 *   is unexpectedly missing or null (e.g. if the server responded with an
                 *   unexpected value).
                 */
                fun currency(): Currency = currency.getRequired("currency")

                /**
                 * Returns the raw JSON value of [amount].
                 *
                 * Unlike [amount], this method doesn't throw if the JSON field has an unexpected
                 * type.
                 */
                @JsonProperty("amount") @ExcludeMissing fun _amount(): JsonField<String> = amount

                /**
                 * Returns the raw JSON value of [code].
                 *
                 * Unlike [code], this method doesn't throw if the JSON field has an unexpected
                 * type.
                 */
                @JsonProperty("code") @ExcludeMissing fun _code(): JsonField<String> = code

                /**
                 * Returns the raw JSON value of [currency].
                 *
                 * Unlike [currency], this method doesn't throw if the JSON field has an unexpected
                 * type.
                 */
                @JsonProperty("currency")
                @ExcludeMissing
                fun _currency(): JsonField<Currency> = currency

                @JsonAnySetter
                private fun putAdditionalProperty(key: String, value: JsonValue) {
                    additionalProperties.put(key, value)
                }

                @JsonAnyGetter
                @ExcludeMissing
                fun _additionalProperties(): Map<String, JsonValue> =
                    Collections.unmodifiableMap(additionalProperties)

                fun toBuilder() = Builder().from(this)

                companion object {

                    /**
                     * Returns a mutable builder for constructing an instance of [Interchange].
                     *
                     * The following fields are required:
                     * ```java
                     * .amount()
                     * .code()
                     * .currency()
                     * ```
                     */
                    @JvmStatic fun builder() = Builder()
                }

                /** A builder for [Interchange]. */
                class Builder internal constructor() {

                    private var amount: JsonField<String>? = null
                    private var code: JsonField<String>? = null
                    private var currency: JsonField<Currency>? = null
                    private var additionalProperties: MutableMap<String, JsonValue> = mutableMapOf()

                    @JvmSynthetic
                    internal fun from(interchange: Interchange) = apply {
                        amount = interchange.amount
                        code = interchange.code
                        currency = interchange.currency
                        additionalProperties = interchange.additionalProperties.toMutableMap()
                    }

                    /**
                     * The interchange amount given as a string containing a decimal number in major
                     * units (so e.g., "3.14" for $3.14). The amount is a positive number if it is
                     * credited to Increase (e.g., settlements) and a negative number if it is
                     * debited (e.g., refunds).
                     */
                    fun amount(amount: String) = amount(JsonField.of(amount))

                    /**
                     * Sets [Builder.amount] to an arbitrary JSON value.
                     *
                     * You should usually call [Builder.amount] with a well-typed [String] value
                     * instead. This method is primarily for setting the field to an undocumented or
                     * not yet supported value.
                     */
                    fun amount(amount: JsonField<String>) = apply { this.amount = amount }

                    /** The card network specific interchange code. */
                    fun code(code: String?) = code(JsonField.ofNullable(code))

                    /** Alias for calling [Builder.code] with `code.orElse(null)`. */
                    fun code(code: Optional<String>) = code(code.getOrNull())

                    /**
                     * Sets [Builder.code] to an arbitrary JSON value.
                     *
                     * You should usually call [Builder.code] with a well-typed [String] value
                     * instead. This method is primarily for setting the field to an undocumented or
                     * not yet supported value.
                     */
                    fun code(code: JsonField<String>) = apply { this.code = code }

                    /**
                     * The [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) code for the
                     * interchange reimbursement.
                     */
                    fun currency(currency: Currency) = currency(JsonField.of(currency))

                    /**
                     * Sets [Builder.currency] to an arbitrary JSON value.
                     *
                     * You should usually call [Builder.currency] with a well-typed [Currency] value
                     * instead. This method is primarily for setting the field to an undocumented or
                     * not yet supported value.
                     */
                    fun currency(currency: JsonField<Currency>) = apply { this.currency = currency }

                    fun additionalProperties(additionalProperties: Map<String, JsonValue>) = apply {
                        this.additionalProperties.clear()
                        putAllAdditionalProperties(additionalProperties)
                    }

                    fun putAdditionalProperty(key: String, value: JsonValue) = apply {
                        additionalProperties.put(key, value)
                    }

                    fun putAllAdditionalProperties(additionalProperties: Map<String, JsonValue>) =
                        apply {
                            this.additionalProperties.putAll(additionalProperties)
                        }

                    fun removeAdditionalProperty(key: String) = apply {
                        additionalProperties.remove(key)
                    }

                    fun removeAllAdditionalProperties(keys: Set<String>) = apply {
                        keys.forEach(::removeAdditionalProperty)
                    }

                    /**
                     * Returns an immutable instance of [Interchange].
                     *
                     * Further updates to this [Builder] will not mutate the returned instance.
                     *
                     * The following fields are required:
                     * ```java
                     * .amount()
                     * .code()
                     * .currency()
                     * ```
                     *
                     * @throws IllegalStateException if any required field is unset.
                     */
                    fun build(): Interchange =
                        Interchange(
                            checkRequired("amount", amount),
                            checkRequired("code", code),
                            checkRequired("currency", currency),
                            additionalProperties.toMutableMap(),
                        )
                }

                private var validated: Boolean = false

                fun validate(): Interchange = apply {
                    if (validated) {
                        return@apply
                    }

                    amount()
                    code()
                    currency().validate()
                    validated = true
                }

                fun isValid(): Boolean =
                    try {
                        validate()
                        true
                    } catch (e: IncreaseInvalidDataException) {
                        false
                    }

                /**
                 * Returns a score indicating how many valid values are contained in this object
                 * recursively.
                 *
                 * Used for best match union deserialization.
                 */
                @JvmSynthetic
                internal fun validity(): Int =
                    (if (amount.asKnown().isPresent) 1 else 0) +
                        (if (code.asKnown().isPresent) 1 else 0) +
                        (currency.asKnown().getOrNull()?.validity() ?: 0)

                /**
                 * The [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) code for the interchange
                 * reimbursement.
                 */
                class Currency
                @JsonCreator
                private constructor(private val value: JsonField<String>) : Enum {

                    /**
                     * Returns this class instance's raw value.
                     *
                     * This is usually only useful if this instance was deserialized from data that
                     * doesn't match any known member, and you want to know that value. For example,
                     * if the SDK is on an older version than the API, then the API may respond with
                     * new members that the SDK is unaware of.
                     */
                    @com.fasterxml.jackson.annotation.JsonValue
                    fun _value(): JsonField<String> = value

                    companion object {

                        /** Canadian Dollar (CAD) */
                        @JvmField val CAD = of("CAD")

                        /** Swiss Franc (CHF) */
                        @JvmField val CHF = of("CHF")

                        /** Euro (EUR) */
                        @JvmField val EUR = of("EUR")

                        /** British Pound (GBP) */
                        @JvmField val GBP = of("GBP")

                        /** Japanese Yen (JPY) */
                        @JvmField val JPY = of("JPY")

                        /** US Dollar (USD) */
                        @JvmField val USD = of("USD")

                        @JvmStatic fun of(value: String) = Currency(JsonField.of(value))
                    }

                    /** An enum containing [Currency]'s known values. */
                    enum class Known {
                        /** Canadian Dollar (CAD) */
                        CAD,
                        /** Swiss Franc (CHF) */
                        CHF,
                        /** Euro (EUR) */
                        EUR,
                        /** British Pound (GBP) */
                        GBP,
                        /** Japanese Yen (JPY) */
                        JPY,
                        /** US Dollar (USD) */
                        USD,
                    }

                    /**
                     * An enum containing [Currency]'s known values, as well as an [_UNKNOWN]
                     * member.
                     *
                     * An instance of [Currency] can contain an unknown value in a couple of cases:
                     * - It was deserialized from data that doesn't match any known member. For
                     *   example, if the SDK is on an older version than the API, then the API may
                     *   respond with new members that the SDK is unaware of.
                     * - It was constructed with an arbitrary value using the [of] method.
                     */
                    enum class Value {
                        /** Canadian Dollar (CAD) */
                        CAD,
                        /** Swiss Franc (CHF) */
                        CHF,
                        /** Euro (EUR) */
                        EUR,
                        /** British Pound (GBP) */
                        GBP,
                        /** Japanese Yen (JPY) */
                        JPY,
                        /** US Dollar (USD) */
                        USD,
                        /**
                         * An enum member indicating that [Currency] was instantiated with an
                         * unknown value.
                         */
                        _UNKNOWN,
                    }

                    /**
                     * Returns an enum member corresponding to this class instance's value, or
                     * [Value._UNKNOWN] if the class was instantiated with an unknown value.
                     *
                     * Use the [known] method instead if you're certain the value is always known or
                     * if you want to throw for the unknown case.
                     */
                    fun value(): Value =
                        when (this) {
                            CAD -> Value.CAD
                            CHF -> Value.CHF
                            EUR -> Value.EUR
                            GBP -> Value.GBP
                            JPY -> Value.JPY
                            USD -> Value.USD
                            else -> Value._UNKNOWN
                        }

                    /**
                     * Returns an enum member corresponding to this class instance's value.
                     *
                     * Use the [value] method instead if you're uncertain the value is always known
                     * and don't want to throw for the unknown case.
                     *
                     * @throws IncreaseInvalidDataException if this class instance's value is a not
                     *   a known member.
                     */
                    fun known(): Known =
                        when (this) {
                            CAD -> Known.CAD
                            CHF -> Known.CHF
                            EUR -> Known.EUR
                            GBP -> Known.GBP
                            JPY -> Known.JPY
                            USD -> Known.USD
                            else -> throw IncreaseInvalidDataException("Unknown Currency: $value")
                        }

                    /**
                     * Returns this class instance's primitive wire representation.
                     *
                     * This differs from the [toString] method because that method is primarily for
                     * debugging and generally doesn't throw.
                     *
                     * @throws IncreaseInvalidDataException if this class instance's value does not
                     *   have the expected primitive type.
                     */
                    fun asString(): String =
                        _value().asString().orElseThrow {
                            IncreaseInvalidDataException("Value is not a String")
                        }

                    private var validated: Boolean = false

                    fun validate(): Currency = apply {
                        if (validated) {
                            return@apply
                        }

                        known()
                        validated = true
                    }

                    fun isValid(): Boolean =
                        try {
                            validate()
                            true
                        } catch (e: IncreaseInvalidDataException) {
                            false
                        }

                    /**
                     * Returns a score indicating how many valid values are contained in this object
                     * recursively.
                     *
                     * Used for best match union deserialization.
                     */
                    @JvmSynthetic
                    internal fun validity(): Int = if (value() == Value._UNKNOWN) 0 else 1

                    override fun equals(other: Any?): Boolean {
                        if (this === other) {
                            return true
                        }

                        return /* spotless:off */ other is Currency && value == other.value /* spotless:on */
                    }

                    override fun hashCode() = value.hashCode()

                    override fun toString() = value.toString()
                }

                override fun equals(other: Any?): Boolean {
                    if (this === other) {
                        return true
                    }

                    return /* spotless:off */ other is Interchange && amount == other.amount && code == other.code && currency == other.currency && additionalProperties == other.additionalProperties /* spotless:on */
                }

                /* spotless:off */
                private val hashCode: Int by lazy { Objects.hash(amount, code, currency, additionalProperties) }
                /* spotless:on */

                override fun hashCode(): Int = hashCode

                override fun toString() =
                    "Interchange{amount=$amount, code=$code, currency=$currency, additionalProperties=$additionalProperties}"
            }

            /** Network-specific identifiers for this refund. */
            class NetworkIdentifiers
            private constructor(
                private val acquirerBusinessId: JsonField<String>,
                private val acquirerReferenceNumber: JsonField<String>,
                private val transactionId: JsonField<String>,
                private val additionalProperties: MutableMap<String, JsonValue>,
            ) {

                @JsonCreator
                private constructor(
                    @JsonProperty("acquirer_business_id")
                    @ExcludeMissing
                    acquirerBusinessId: JsonField<String> = JsonMissing.of(),
                    @JsonProperty("acquirer_reference_number")
                    @ExcludeMissing
                    acquirerReferenceNumber: JsonField<String> = JsonMissing.of(),
                    @JsonProperty("transaction_id")
                    @ExcludeMissing
                    transactionId: JsonField<String> = JsonMissing.of(),
                ) : this(acquirerBusinessId, acquirerReferenceNumber, transactionId, mutableMapOf())

                /**
                 * A network assigned business ID that identifies the acquirer that processed this
                 * transaction.
                 *
                 * @throws IncreaseInvalidDataException if the JSON field has an unexpected type or
                 *   is unexpectedly missing or null (e.g. if the server responded with an
                 *   unexpected value).
                 */
                fun acquirerBusinessId(): String =
                    acquirerBusinessId.getRequired("acquirer_business_id")

                /**
                 * A globally unique identifier for this settlement.
                 *
                 * @throws IncreaseInvalidDataException if the JSON field has an unexpected type or
                 *   is unexpectedly missing or null (e.g. if the server responded with an
                 *   unexpected value).
                 */
                fun acquirerReferenceNumber(): String =
                    acquirerReferenceNumber.getRequired("acquirer_reference_number")

                /**
                 * A globally unique transaction identifier provided by the card network, used
                 * across multiple life-cycle requests.
                 *
                 * @throws IncreaseInvalidDataException if the JSON field has an unexpected type
                 *   (e.g. if the server responded with an unexpected value).
                 */
                fun transactionId(): Optional<String> = transactionId.getOptional("transaction_id")

                /**
                 * Returns the raw JSON value of [acquirerBusinessId].
                 *
                 * Unlike [acquirerBusinessId], this method doesn't throw if the JSON field has an
                 * unexpected type.
                 */
                @JsonProperty("acquirer_business_id")
                @ExcludeMissing
                fun _acquirerBusinessId(): JsonField<String> = acquirerBusinessId

                /**
                 * Returns the raw JSON value of [acquirerReferenceNumber].
                 *
                 * Unlike [acquirerReferenceNumber], this method doesn't throw if the JSON field has
                 * an unexpected type.
                 */
                @JsonProperty("acquirer_reference_number")
                @ExcludeMissing
                fun _acquirerReferenceNumber(): JsonField<String> = acquirerReferenceNumber

                /**
                 * Returns the raw JSON value of [transactionId].
                 *
                 * Unlike [transactionId], this method doesn't throw if the JSON field has an
                 * unexpected type.
                 */
                @JsonProperty("transaction_id")
                @ExcludeMissing
                fun _transactionId(): JsonField<String> = transactionId

                @JsonAnySetter
                private fun putAdditionalProperty(key: String, value: JsonValue) {
                    additionalProperties.put(key, value)
                }

                @JsonAnyGetter
                @ExcludeMissing
                fun _additionalProperties(): Map<String, JsonValue> =
                    Collections.unmodifiableMap(additionalProperties)

                fun toBuilder() = Builder().from(this)

                companion object {

                    /**
                     * Returns a mutable builder for constructing an instance of
                     * [NetworkIdentifiers].
                     *
                     * The following fields are required:
                     * ```java
                     * .acquirerBusinessId()
                     * .acquirerReferenceNumber()
                     * .transactionId()
                     * ```
                     */
                    @JvmStatic fun builder() = Builder()
                }

                /** A builder for [NetworkIdentifiers]. */
                class Builder internal constructor() {

                    private var acquirerBusinessId: JsonField<String>? = null
                    private var acquirerReferenceNumber: JsonField<String>? = null
                    private var transactionId: JsonField<String>? = null
                    private var additionalProperties: MutableMap<String, JsonValue> = mutableMapOf()

                    @JvmSynthetic
                    internal fun from(networkIdentifiers: NetworkIdentifiers) = apply {
                        acquirerBusinessId = networkIdentifiers.acquirerBusinessId
                        acquirerReferenceNumber = networkIdentifiers.acquirerReferenceNumber
                        transactionId = networkIdentifiers.transactionId
                        additionalProperties =
                            networkIdentifiers.additionalProperties.toMutableMap()
                    }

                    /**
                     * A network assigned business ID that identifies the acquirer that processed
                     * this transaction.
                     */
                    fun acquirerBusinessId(acquirerBusinessId: String) =
                        acquirerBusinessId(JsonField.of(acquirerBusinessId))

                    /**
                     * Sets [Builder.acquirerBusinessId] to an arbitrary JSON value.
                     *
                     * You should usually call [Builder.acquirerBusinessId] with a well-typed
                     * [String] value instead. This method is primarily for setting the field to an
                     * undocumented or not yet supported value.
                     */
                    fun acquirerBusinessId(acquirerBusinessId: JsonField<String>) = apply {
                        this.acquirerBusinessId = acquirerBusinessId
                    }

                    /** A globally unique identifier for this settlement. */
                    fun acquirerReferenceNumber(acquirerReferenceNumber: String) =
                        acquirerReferenceNumber(JsonField.of(acquirerReferenceNumber))

                    /**
                     * Sets [Builder.acquirerReferenceNumber] to an arbitrary JSON value.
                     *
                     * You should usually call [Builder.acquirerReferenceNumber] with a well-typed
                     * [String] value instead. This method is primarily for setting the field to an
                     * undocumented or not yet supported value.
                     */
                    fun acquirerReferenceNumber(acquirerReferenceNumber: JsonField<String>) =
                        apply {
                            this.acquirerReferenceNumber = acquirerReferenceNumber
                        }

                    /**
                     * A globally unique transaction identifier provided by the card network, used
                     * across multiple life-cycle requests.
                     */
                    fun transactionId(transactionId: String?) =
                        transactionId(JsonField.ofNullable(transactionId))

                    /**
                     * Alias for calling [Builder.transactionId] with `transactionId.orElse(null)`.
                     */
                    fun transactionId(transactionId: Optional<String>) =
                        transactionId(transactionId.getOrNull())

                    /**
                     * Sets [Builder.transactionId] to an arbitrary JSON value.
                     *
                     * You should usually call [Builder.transactionId] with a well-typed [String]
                     * value instead. This method is primarily for setting the field to an
                     * undocumented or not yet supported value.
                     */
                    fun transactionId(transactionId: JsonField<String>) = apply {
                        this.transactionId = transactionId
                    }

                    fun additionalProperties(additionalProperties: Map<String, JsonValue>) = apply {
                        this.additionalProperties.clear()
                        putAllAdditionalProperties(additionalProperties)
                    }

                    fun putAdditionalProperty(key: String, value: JsonValue) = apply {
                        additionalProperties.put(key, value)
                    }

                    fun putAllAdditionalProperties(additionalProperties: Map<String, JsonValue>) =
                        apply {
                            this.additionalProperties.putAll(additionalProperties)
                        }

                    fun removeAdditionalProperty(key: String) = apply {
                        additionalProperties.remove(key)
                    }

                    fun removeAllAdditionalProperties(keys: Set<String>) = apply {
                        keys.forEach(::removeAdditionalProperty)
                    }

                    /**
                     * Returns an immutable instance of [NetworkIdentifiers].
                     *
                     * Further updates to this [Builder] will not mutate the returned instance.
                     *
                     * The following fields are required:
                     * ```java
                     * .acquirerBusinessId()
                     * .acquirerReferenceNumber()
                     * .transactionId()
                     * ```
                     *
                     * @throws IllegalStateException if any required field is unset.
                     */
                    fun build(): NetworkIdentifiers =
                        NetworkIdentifiers(
                            checkRequired("acquirerBusinessId", acquirerBusinessId),
                            checkRequired("acquirerReferenceNumber", acquirerReferenceNumber),
                            checkRequired("transactionId", transactionId),
                            additionalProperties.toMutableMap(),
                        )
                }

                private var validated: Boolean = false

                fun validate(): NetworkIdentifiers = apply {
                    if (validated) {
                        return@apply
                    }

                    acquirerBusinessId()
                    acquirerReferenceNumber()
                    transactionId()
                    validated = true
                }

                fun isValid(): Boolean =
                    try {
                        validate()
                        true
                    } catch (e: IncreaseInvalidDataException) {
                        false
                    }

                /**
                 * Returns a score indicating how many valid values are contained in this object
                 * recursively.
                 *
                 * Used for best match union deserialization.
                 */
                @JvmSynthetic
                internal fun validity(): Int =
                    (if (acquirerBusinessId.asKnown().isPresent) 1 else 0) +
                        (if (acquirerReferenceNumber.asKnown().isPresent) 1 else 0) +
                        (if (transactionId.asKnown().isPresent) 1 else 0)

                override fun equals(other: Any?): Boolean {
                    if (this === other) {
                        return true
                    }

                    return /* spotless:off */ other is NetworkIdentifiers && acquirerBusinessId == other.acquirerBusinessId && acquirerReferenceNumber == other.acquirerReferenceNumber && transactionId == other.transactionId && additionalProperties == other.additionalProperties /* spotless:on */
                }

                /* spotless:off */
                private val hashCode: Int by lazy { Objects.hash(acquirerBusinessId, acquirerReferenceNumber, transactionId, additionalProperties) }
                /* spotless:on */

                override fun hashCode(): Int = hashCode

                override fun toString() =
                    "NetworkIdentifiers{acquirerBusinessId=$acquirerBusinessId, acquirerReferenceNumber=$acquirerReferenceNumber, transactionId=$transactionId, additionalProperties=$additionalProperties}"
            }

            /**
             * Additional details about the card purchase, such as tax and industry-specific fields.
             */
            class PurchaseDetails
            private constructor(
                private val carRental: JsonField<CarRental>,
                private val customerReferenceIdentifier: JsonField<String>,
                private val localTaxAmount: JsonField<Long>,
                private val localTaxCurrency: JsonField<String>,
                private val lodging: JsonField<Lodging>,
                private val nationalTaxAmount: JsonField<Long>,
                private val nationalTaxCurrency: JsonField<String>,
                private val purchaseIdentifier: JsonField<String>,
                private val purchaseIdentifierFormat: JsonField<PurchaseIdentifierFormat>,
                private val travel: JsonField<Travel>,
                private val additionalProperties: MutableMap<String, JsonValue>,
            ) {

                @JsonCreator
                private constructor(
                    @JsonProperty("car_rental")
                    @ExcludeMissing
                    carRental: JsonField<CarRental> = JsonMissing.of(),
                    @JsonProperty("customer_reference_identifier")
                    @ExcludeMissing
                    customerReferenceIdentifier: JsonField<String> = JsonMissing.of(),
                    @JsonProperty("local_tax_amount")
                    @ExcludeMissing
                    localTaxAmount: JsonField<Long> = JsonMissing.of(),
                    @JsonProperty("local_tax_currency")
                    @ExcludeMissing
                    localTaxCurrency: JsonField<String> = JsonMissing.of(),
                    @JsonProperty("lodging")
                    @ExcludeMissing
                    lodging: JsonField<Lodging> = JsonMissing.of(),
                    @JsonProperty("national_tax_amount")
                    @ExcludeMissing
                    nationalTaxAmount: JsonField<Long> = JsonMissing.of(),
                    @JsonProperty("national_tax_currency")
                    @ExcludeMissing
                    nationalTaxCurrency: JsonField<String> = JsonMissing.of(),
                    @JsonProperty("purchase_identifier")
                    @ExcludeMissing
                    purchaseIdentifier: JsonField<String> = JsonMissing.of(),
                    @JsonProperty("purchase_identifier_format")
                    @ExcludeMissing
                    purchaseIdentifierFormat: JsonField<PurchaseIdentifierFormat> =
                        JsonMissing.of(),
                    @JsonProperty("travel")
                    @ExcludeMissing
                    travel: JsonField<Travel> = JsonMissing.of(),
                ) : this(
                    carRental,
                    customerReferenceIdentifier,
                    localTaxAmount,
                    localTaxCurrency,
                    lodging,
                    nationalTaxAmount,
                    nationalTaxCurrency,
                    purchaseIdentifier,
                    purchaseIdentifierFormat,
                    travel,
                    mutableMapOf(),
                )

                /**
                 * Fields specific to car rentals.
                 *
                 * @throws IncreaseInvalidDataException if the JSON field has an unexpected type
                 *   (e.g. if the server responded with an unexpected value).
                 */
                fun carRental(): Optional<CarRental> = carRental.getOptional("car_rental")

                /**
                 * An identifier from the merchant for the customer or consumer.
                 *
                 * @throws IncreaseInvalidDataException if the JSON field has an unexpected type
                 *   (e.g. if the server responded with an unexpected value).
                 */
                fun customerReferenceIdentifier(): Optional<String> =
                    customerReferenceIdentifier.getOptional("customer_reference_identifier")

                /**
                 * The state or provincial tax amount in minor units.
                 *
                 * @throws IncreaseInvalidDataException if the JSON field has an unexpected type
                 *   (e.g. if the server responded with an unexpected value).
                 */
                fun localTaxAmount(): Optional<Long> =
                    localTaxAmount.getOptional("local_tax_amount")

                /**
                 * The [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) code for the local tax
                 * assessed.
                 *
                 * @throws IncreaseInvalidDataException if the JSON field has an unexpected type
                 *   (e.g. if the server responded with an unexpected value).
                 */
                fun localTaxCurrency(): Optional<String> =
                    localTaxCurrency.getOptional("local_tax_currency")

                /**
                 * Fields specific to lodging.
                 *
                 * @throws IncreaseInvalidDataException if the JSON field has an unexpected type
                 *   (e.g. if the server responded with an unexpected value).
                 */
                fun lodging(): Optional<Lodging> = lodging.getOptional("lodging")

                /**
                 * The national tax amount in minor units.
                 *
                 * @throws IncreaseInvalidDataException if the JSON field has an unexpected type
                 *   (e.g. if the server responded with an unexpected value).
                 */
                fun nationalTaxAmount(): Optional<Long> =
                    nationalTaxAmount.getOptional("national_tax_amount")

                /**
                 * The [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) code for the local tax
                 * assessed.
                 *
                 * @throws IncreaseInvalidDataException if the JSON field has an unexpected type
                 *   (e.g. if the server responded with an unexpected value).
                 */
                fun nationalTaxCurrency(): Optional<String> =
                    nationalTaxCurrency.getOptional("national_tax_currency")

                /**
                 * An identifier from the merchant for the purchase to the issuer and cardholder.
                 *
                 * @throws IncreaseInvalidDataException if the JSON field has an unexpected type
                 *   (e.g. if the server responded with an unexpected value).
                 */
                fun purchaseIdentifier(): Optional<String> =
                    purchaseIdentifier.getOptional("purchase_identifier")

                /**
                 * The format of the purchase identifier.
                 *
                 * @throws IncreaseInvalidDataException if the JSON field has an unexpected type
                 *   (e.g. if the server responded with an unexpected value).
                 */
                fun purchaseIdentifierFormat(): Optional<PurchaseIdentifierFormat> =
                    purchaseIdentifierFormat.getOptional("purchase_identifier_format")

                /**
                 * Fields specific to travel.
                 *
                 * @throws IncreaseInvalidDataException if the JSON field has an unexpected type
                 *   (e.g. if the server responded with an unexpected value).
                 */
                fun travel(): Optional<Travel> = travel.getOptional("travel")

                /**
                 * Returns the raw JSON value of [carRental].
                 *
                 * Unlike [carRental], this method doesn't throw if the JSON field has an unexpected
                 * type.
                 */
                @JsonProperty("car_rental")
                @ExcludeMissing
                fun _carRental(): JsonField<CarRental> = carRental

                /**
                 * Returns the raw JSON value of [customerReferenceIdentifier].
                 *
                 * Unlike [customerReferenceIdentifier], this method doesn't throw if the JSON field
                 * has an unexpected type.
                 */
                @JsonProperty("customer_reference_identifier")
                @ExcludeMissing
                fun _customerReferenceIdentifier(): JsonField<String> = customerReferenceIdentifier

                /**
                 * Returns the raw JSON value of [localTaxAmount].
                 *
                 * Unlike [localTaxAmount], this method doesn't throw if the JSON field has an
                 * unexpected type.
                 */
                @JsonProperty("local_tax_amount")
                @ExcludeMissing
                fun _localTaxAmount(): JsonField<Long> = localTaxAmount

                /**
                 * Returns the raw JSON value of [localTaxCurrency].
                 *
                 * Unlike [localTaxCurrency], this method doesn't throw if the JSON field has an
                 * unexpected type.
                 */
                @JsonProperty("local_tax_currency")
                @ExcludeMissing
                fun _localTaxCurrency(): JsonField<String> = localTaxCurrency

                /**
                 * Returns the raw JSON value of [lodging].
                 *
                 * Unlike [lodging], this method doesn't throw if the JSON field has an unexpected
                 * type.
                 */
                @JsonProperty("lodging")
                @ExcludeMissing
                fun _lodging(): JsonField<Lodging> = lodging

                /**
                 * Returns the raw JSON value of [nationalTaxAmount].
                 *
                 * Unlike [nationalTaxAmount], this method doesn't throw if the JSON field has an
                 * unexpected type.
                 */
                @JsonProperty("national_tax_amount")
                @ExcludeMissing
                fun _nationalTaxAmount(): JsonField<Long> = nationalTaxAmount

                /**
                 * Returns the raw JSON value of [nationalTaxCurrency].
                 *
                 * Unlike [nationalTaxCurrency], this method doesn't throw if the JSON field has an
                 * unexpected type.
                 */
                @JsonProperty("national_tax_currency")
                @ExcludeMissing
                fun _nationalTaxCurrency(): JsonField<String> = nationalTaxCurrency

                /**
                 * Returns the raw JSON value of [purchaseIdentifier].
                 *
                 * Unlike [purchaseIdentifier], this method doesn't throw if the JSON field has an
                 * unexpected type.
                 */
                @JsonProperty("purchase_identifier")
                @ExcludeMissing
                fun _purchaseIdentifier(): JsonField<String> = purchaseIdentifier

                /**
                 * Returns the raw JSON value of [purchaseIdentifierFormat].
                 *
                 * Unlike [purchaseIdentifierFormat], this method doesn't throw if the JSON field
                 * has an unexpected type.
                 */
                @JsonProperty("purchase_identifier_format")
                @ExcludeMissing
                fun _purchaseIdentifierFormat(): JsonField<PurchaseIdentifierFormat> =
                    purchaseIdentifierFormat

                /**
                 * Returns the raw JSON value of [travel].
                 *
                 * Unlike [travel], this method doesn't throw if the JSON field has an unexpected
                 * type.
                 */
                @JsonProperty("travel") @ExcludeMissing fun _travel(): JsonField<Travel> = travel

                @JsonAnySetter
                private fun putAdditionalProperty(key: String, value: JsonValue) {
                    additionalProperties.put(key, value)
                }

                @JsonAnyGetter
                @ExcludeMissing
                fun _additionalProperties(): Map<String, JsonValue> =
                    Collections.unmodifiableMap(additionalProperties)

                fun toBuilder() = Builder().from(this)

                companion object {

                    /**
                     * Returns a mutable builder for constructing an instance of [PurchaseDetails].
                     *
                     * The following fields are required:
                     * ```java
                     * .carRental()
                     * .customerReferenceIdentifier()
                     * .localTaxAmount()
                     * .localTaxCurrency()
                     * .lodging()
                     * .nationalTaxAmount()
                     * .nationalTaxCurrency()
                     * .purchaseIdentifier()
                     * .purchaseIdentifierFormat()
                     * .travel()
                     * ```
                     */
                    @JvmStatic fun builder() = Builder()
                }

                /** A builder for [PurchaseDetails]. */
                class Builder internal constructor() {

                    private var carRental: JsonField<CarRental>? = null
                    private var customerReferenceIdentifier: JsonField<String>? = null
                    private var localTaxAmount: JsonField<Long>? = null
                    private var localTaxCurrency: JsonField<String>? = null
                    private var lodging: JsonField<Lodging>? = null
                    private var nationalTaxAmount: JsonField<Long>? = null
                    private var nationalTaxCurrency: JsonField<String>? = null
                    private var purchaseIdentifier: JsonField<String>? = null
                    private var purchaseIdentifierFormat: JsonField<PurchaseIdentifierFormat>? =
                        null
                    private var travel: JsonField<Travel>? = null
                    private var additionalProperties: MutableMap<String, JsonValue> = mutableMapOf()

                    @JvmSynthetic
                    internal fun from(purchaseDetails: PurchaseDetails) = apply {
                        carRental = purchaseDetails.carRental
                        customerReferenceIdentifier = purchaseDetails.customerReferenceIdentifier
                        localTaxAmount = purchaseDetails.localTaxAmount
                        localTaxCurrency = purchaseDetails.localTaxCurrency
                        lodging = purchaseDetails.lodging
                        nationalTaxAmount = purchaseDetails.nationalTaxAmount
                        nationalTaxCurrency = purchaseDetails.nationalTaxCurrency
                        purchaseIdentifier = purchaseDetails.purchaseIdentifier
                        purchaseIdentifierFormat = purchaseDetails.purchaseIdentifierFormat
                        travel = purchaseDetails.travel
                        additionalProperties = purchaseDetails.additionalProperties.toMutableMap()
                    }

                    /** Fields specific to car rentals. */
                    fun carRental(carRental: CarRental?) =
                        carRental(JsonField.ofNullable(carRental))

                    /** Alias for calling [Builder.carRental] with `carRental.orElse(null)`. */
                    fun carRental(carRental: Optional<CarRental>) = carRental(carRental.getOrNull())

                    /**
                     * Sets [Builder.carRental] to an arbitrary JSON value.
                     *
                     * You should usually call [Builder.carRental] with a well-typed [CarRental]
                     * value instead. This method is primarily for setting the field to an
                     * undocumented or not yet supported value.
                     */
                    fun carRental(carRental: JsonField<CarRental>) = apply {
                        this.carRental = carRental
                    }

                    /** An identifier from the merchant for the customer or consumer. */
                    fun customerReferenceIdentifier(customerReferenceIdentifier: String?) =
                        customerReferenceIdentifier(
                            JsonField.ofNullable(customerReferenceIdentifier)
                        )

                    /**
                     * Alias for calling [Builder.customerReferenceIdentifier] with
                     * `customerReferenceIdentifier.orElse(null)`.
                     */
                    fun customerReferenceIdentifier(customerReferenceIdentifier: Optional<String>) =
                        customerReferenceIdentifier(customerReferenceIdentifier.getOrNull())

                    /**
                     * Sets [Builder.customerReferenceIdentifier] to an arbitrary JSON value.
                     *
                     * You should usually call [Builder.customerReferenceIdentifier] with a
                     * well-typed [String] value instead. This method is primarily for setting the
                     * field to an undocumented or not yet supported value.
                     */
                    fun customerReferenceIdentifier(
                        customerReferenceIdentifier: JsonField<String>
                    ) = apply { this.customerReferenceIdentifier = customerReferenceIdentifier }

                    /** The state or provincial tax amount in minor units. */
                    fun localTaxAmount(localTaxAmount: Long?) =
                        localTaxAmount(JsonField.ofNullable(localTaxAmount))

                    /**
                     * Alias for [Builder.localTaxAmount].
                     *
                     * This unboxed primitive overload exists for backwards compatibility.
                     */
                    fun localTaxAmount(localTaxAmount: Long) =
                        localTaxAmount(localTaxAmount as Long?)

                    /**
                     * Alias for calling [Builder.localTaxAmount] with
                     * `localTaxAmount.orElse(null)`.
                     */
                    fun localTaxAmount(localTaxAmount: Optional<Long>) =
                        localTaxAmount(localTaxAmount.getOrNull())

                    /**
                     * Sets [Builder.localTaxAmount] to an arbitrary JSON value.
                     *
                     * You should usually call [Builder.localTaxAmount] with a well-typed [Long]
                     * value instead. This method is primarily for setting the field to an
                     * undocumented or not yet supported value.
                     */
                    fun localTaxAmount(localTaxAmount: JsonField<Long>) = apply {
                        this.localTaxAmount = localTaxAmount
                    }

                    /**
                     * The [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) code for the local tax
                     * assessed.
                     */
                    fun localTaxCurrency(localTaxCurrency: String?) =
                        localTaxCurrency(JsonField.ofNullable(localTaxCurrency))

                    /**
                     * Alias for calling [Builder.localTaxCurrency] with
                     * `localTaxCurrency.orElse(null)`.
                     */
                    fun localTaxCurrency(localTaxCurrency: Optional<String>) =
                        localTaxCurrency(localTaxCurrency.getOrNull())

                    /**
                     * Sets [Builder.localTaxCurrency] to an arbitrary JSON value.
                     *
                     * You should usually call [Builder.localTaxCurrency] with a well-typed [String]
                     * value instead. This method is primarily for setting the field to an
                     * undocumented or not yet supported value.
                     */
                    fun localTaxCurrency(localTaxCurrency: JsonField<String>) = apply {
                        this.localTaxCurrency = localTaxCurrency
                    }

                    /** Fields specific to lodging. */
                    fun lodging(lodging: Lodging?) = lodging(JsonField.ofNullable(lodging))

                    /** Alias for calling [Builder.lodging] with `lodging.orElse(null)`. */
                    fun lodging(lodging: Optional<Lodging>) = lodging(lodging.getOrNull())

                    /**
                     * Sets [Builder.lodging] to an arbitrary JSON value.
                     *
                     * You should usually call [Builder.lodging] with a well-typed [Lodging] value
                     * instead. This method is primarily for setting the field to an undocumented or
                     * not yet supported value.
                     */
                    fun lodging(lodging: JsonField<Lodging>) = apply { this.lodging = lodging }

                    /** The national tax amount in minor units. */
                    fun nationalTaxAmount(nationalTaxAmount: Long?) =
                        nationalTaxAmount(JsonField.ofNullable(nationalTaxAmount))

                    /**
                     * Alias for [Builder.nationalTaxAmount].
                     *
                     * This unboxed primitive overload exists for backwards compatibility.
                     */
                    fun nationalTaxAmount(nationalTaxAmount: Long) =
                        nationalTaxAmount(nationalTaxAmount as Long?)

                    /**
                     * Alias for calling [Builder.nationalTaxAmount] with
                     * `nationalTaxAmount.orElse(null)`.
                     */
                    fun nationalTaxAmount(nationalTaxAmount: Optional<Long>) =
                        nationalTaxAmount(nationalTaxAmount.getOrNull())

                    /**
                     * Sets [Builder.nationalTaxAmount] to an arbitrary JSON value.
                     *
                     * You should usually call [Builder.nationalTaxAmount] with a well-typed [Long]
                     * value instead. This method is primarily for setting the field to an
                     * undocumented or not yet supported value.
                     */
                    fun nationalTaxAmount(nationalTaxAmount: JsonField<Long>) = apply {
                        this.nationalTaxAmount = nationalTaxAmount
                    }

                    /**
                     * The [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) code for the local tax
                     * assessed.
                     */
                    fun nationalTaxCurrency(nationalTaxCurrency: String?) =
                        nationalTaxCurrency(JsonField.ofNullable(nationalTaxCurrency))

                    /**
                     * Alias for calling [Builder.nationalTaxCurrency] with
                     * `nationalTaxCurrency.orElse(null)`.
                     */
                    fun nationalTaxCurrency(nationalTaxCurrency: Optional<String>) =
                        nationalTaxCurrency(nationalTaxCurrency.getOrNull())

                    /**
                     * Sets [Builder.nationalTaxCurrency] to an arbitrary JSON value.
                     *
                     * You should usually call [Builder.nationalTaxCurrency] with a well-typed
                     * [String] value instead. This method is primarily for setting the field to an
                     * undocumented or not yet supported value.
                     */
                    fun nationalTaxCurrency(nationalTaxCurrency: JsonField<String>) = apply {
                        this.nationalTaxCurrency = nationalTaxCurrency
                    }

                    /**
                     * An identifier from the merchant for the purchase to the issuer and
                     * cardholder.
                     */
                    fun purchaseIdentifier(purchaseIdentifier: String?) =
                        purchaseIdentifier(JsonField.ofNullable(purchaseIdentifier))

                    /**
                     * Alias for calling [Builder.purchaseIdentifier] with
                     * `purchaseIdentifier.orElse(null)`.
                     */
                    fun purchaseIdentifier(purchaseIdentifier: Optional<String>) =
                        purchaseIdentifier(purchaseIdentifier.getOrNull())

                    /**
                     * Sets [Builder.purchaseIdentifier] to an arbitrary JSON value.
                     *
                     * You should usually call [Builder.purchaseIdentifier] with a well-typed
                     * [String] value instead. This method is primarily for setting the field to an
                     * undocumented or not yet supported value.
                     */
                    fun purchaseIdentifier(purchaseIdentifier: JsonField<String>) = apply {
                        this.purchaseIdentifier = purchaseIdentifier
                    }

                    /** The format of the purchase identifier. */
                    fun purchaseIdentifierFormat(
                        purchaseIdentifierFormat: PurchaseIdentifierFormat?
                    ) = purchaseIdentifierFormat(JsonField.ofNullable(purchaseIdentifierFormat))

                    /**
                     * Alias for calling [Builder.purchaseIdentifierFormat] with
                     * `purchaseIdentifierFormat.orElse(null)`.
                     */
                    fun purchaseIdentifierFormat(
                        purchaseIdentifierFormat: Optional<PurchaseIdentifierFormat>
                    ) = purchaseIdentifierFormat(purchaseIdentifierFormat.getOrNull())

                    /**
                     * Sets [Builder.purchaseIdentifierFormat] to an arbitrary JSON value.
                     *
                     * You should usually call [Builder.purchaseIdentifierFormat] with a well-typed
                     * [PurchaseIdentifierFormat] value instead. This method is primarily for
                     * setting the field to an undocumented or not yet supported value.
                     */
                    fun purchaseIdentifierFormat(
                        purchaseIdentifierFormat: JsonField<PurchaseIdentifierFormat>
                    ) = apply { this.purchaseIdentifierFormat = purchaseIdentifierFormat }

                    /** Fields specific to travel. */
                    fun travel(travel: Travel?) = travel(JsonField.ofNullable(travel))

                    /** Alias for calling [Builder.travel] with `travel.orElse(null)`. */
                    fun travel(travel: Optional<Travel>) = travel(travel.getOrNull())

                    /**
                     * Sets [Builder.travel] to an arbitrary JSON value.
                     *
                     * You should usually call [Builder.travel] with a well-typed [Travel] value
                     * instead. This method is primarily for setting the field to an undocumented or
                     * not yet supported value.
                     */
                    fun travel(travel: JsonField<Travel>) = apply { this.travel = travel }

                    fun additionalProperties(additionalProperties: Map<String, JsonValue>) = apply {
                        this.additionalProperties.clear()
                        putAllAdditionalProperties(additionalProperties)
                    }

                    fun putAdditionalProperty(key: String, value: JsonValue) = apply {
                        additionalProperties.put(key, value)
                    }

                    fun putAllAdditionalProperties(additionalProperties: Map<String, JsonValue>) =
                        apply {
                            this.additionalProperties.putAll(additionalProperties)
                        }

                    fun removeAdditionalProperty(key: String) = apply {
                        additionalProperties.remove(key)
                    }

                    fun removeAllAdditionalProperties(keys: Set<String>) = apply {
                        keys.forEach(::removeAdditionalProperty)
                    }

                    /**
                     * Returns an immutable instance of [PurchaseDetails].
                     *
                     * Further updates to this [Builder] will not mutate the returned instance.
                     *
                     * The following fields are required:
                     * ```java
                     * .carRental()
                     * .customerReferenceIdentifier()
                     * .localTaxAmount()
                     * .localTaxCurrency()
                     * .lodging()
                     * .nationalTaxAmount()
                     * .nationalTaxCurrency()
                     * .purchaseIdentifier()
                     * .purchaseIdentifierFormat()
                     * .travel()
                     * ```
                     *
                     * @throws IllegalStateException if any required field is unset.
                     */
                    fun build(): PurchaseDetails =
                        PurchaseDetails(
                            checkRequired("carRental", carRental),
                            checkRequired(
                                "customerReferenceIdentifier",
                                customerReferenceIdentifier,
                            ),
                            checkRequired("localTaxAmount", localTaxAmount),
                            checkRequired("localTaxCurrency", localTaxCurrency),
                            checkRequired("lodging", lodging),
                            checkRequired("nationalTaxAmount", nationalTaxAmount),
                            checkRequired("nationalTaxCurrency", nationalTaxCurrency),
                            checkRequired("purchaseIdentifier", purchaseIdentifier),
                            checkRequired("purchaseIdentifierFormat", purchaseIdentifierFormat),
                            checkRequired("travel", travel),
                            additionalProperties.toMutableMap(),
                        )
                }

                private var validated: Boolean = false

                fun validate(): PurchaseDetails = apply {
                    if (validated) {
                        return@apply
                    }

                    carRental().ifPresent { it.validate() }
                    customerReferenceIdentifier()
                    localTaxAmount()
                    localTaxCurrency()
                    lodging().ifPresent { it.validate() }
                    nationalTaxAmount()
                    nationalTaxCurrency()
                    purchaseIdentifier()
                    purchaseIdentifierFormat().ifPresent { it.validate() }
                    travel().ifPresent { it.validate() }
                    validated = true
                }

                fun isValid(): Boolean =
                    try {
                        validate()
                        true
                    } catch (e: IncreaseInvalidDataException) {
                        false
                    }

                /**
                 * Returns a score indicating how many valid values are contained in this object
                 * recursively.
                 *
                 * Used for best match union deserialization.
                 */
                @JvmSynthetic
                internal fun validity(): Int =
                    (carRental.asKnown().getOrNull()?.validity() ?: 0) +
                        (if (customerReferenceIdentifier.asKnown().isPresent) 1 else 0) +
                        (if (localTaxAmount.asKnown().isPresent) 1 else 0) +
                        (if (localTaxCurrency.asKnown().isPresent) 1 else 0) +
                        (lodging.asKnown().getOrNull()?.validity() ?: 0) +
                        (if (nationalTaxAmount.asKnown().isPresent) 1 else 0) +
                        (if (nationalTaxCurrency.asKnown().isPresent) 1 else 0) +
                        (if (purchaseIdentifier.asKnown().isPresent) 1 else 0) +
                        (purchaseIdentifierFormat.asKnown().getOrNull()?.validity() ?: 0) +
                        (travel.asKnown().getOrNull()?.validity() ?: 0)

                /** Fields specific to car rentals. */
                class CarRental
                private constructor(
                    private val carClassCode: JsonField<String>,
                    private val checkoutDate: JsonField<LocalDate>,
                    private val dailyRentalRateAmount: JsonField<Long>,
                    private val dailyRentalRateCurrency: JsonField<String>,
                    private val daysRented: JsonField<Long>,
                    private val extraCharges: JsonField<ExtraCharges>,
                    private val fuelChargesAmount: JsonField<Long>,
                    private val fuelChargesCurrency: JsonField<String>,
                    private val insuranceChargesAmount: JsonField<Long>,
                    private val insuranceChargesCurrency: JsonField<String>,
                    private val noShowIndicator: JsonField<NoShowIndicator>,
                    private val oneWayDropOffChargesAmount: JsonField<Long>,
                    private val oneWayDropOffChargesCurrency: JsonField<String>,
                    private val renterName: JsonField<String>,
                    private val weeklyRentalRateAmount: JsonField<Long>,
                    private val weeklyRentalRateCurrency: JsonField<String>,
                    private val additionalProperties: MutableMap<String, JsonValue>,
                ) {

                    @JsonCreator
                    private constructor(
                        @JsonProperty("car_class_code")
                        @ExcludeMissing
                        carClassCode: JsonField<String> = JsonMissing.of(),
                        @JsonProperty("checkout_date")
                        @ExcludeMissing
                        checkoutDate: JsonField<LocalDate> = JsonMissing.of(),
                        @JsonProperty("daily_rental_rate_amount")
                        @ExcludeMissing
                        dailyRentalRateAmount: JsonField<Long> = JsonMissing.of(),
                        @JsonProperty("daily_rental_rate_currency")
                        @ExcludeMissing
                        dailyRentalRateCurrency: JsonField<String> = JsonMissing.of(),
                        @JsonProperty("days_rented")
                        @ExcludeMissing
                        daysRented: JsonField<Long> = JsonMissing.of(),
                        @JsonProperty("extra_charges")
                        @ExcludeMissing
                        extraCharges: JsonField<ExtraCharges> = JsonMissing.of(),
                        @JsonProperty("fuel_charges_amount")
                        @ExcludeMissing
                        fuelChargesAmount: JsonField<Long> = JsonMissing.of(),
                        @JsonProperty("fuel_charges_currency")
                        @ExcludeMissing
                        fuelChargesCurrency: JsonField<String> = JsonMissing.of(),
                        @JsonProperty("insurance_charges_amount")
                        @ExcludeMissing
                        insuranceChargesAmount: JsonField<Long> = JsonMissing.of(),
                        @JsonProperty("insurance_charges_currency")
                        @ExcludeMissing
                        insuranceChargesCurrency: JsonField<String> = JsonMissing.of(),
                        @JsonProperty("no_show_indicator")
                        @ExcludeMissing
                        noShowIndicator: JsonField<NoShowIndicator> = JsonMissing.of(),
                        @JsonProperty("one_way_drop_off_charges_amount")
                        @ExcludeMissing
                        oneWayDropOffChargesAmount: JsonField<Long> = JsonMissing.of(),
                        @JsonProperty("one_way_drop_off_charges_currency")
                        @ExcludeMissing
                        oneWayDropOffChargesCurrency: JsonField<String> = JsonMissing.of(),
                        @JsonProperty("renter_name")
                        @ExcludeMissing
                        renterName: JsonField<String> = JsonMissing.of(),
                        @JsonProperty("weekly_rental_rate_amount")
                        @ExcludeMissing
                        weeklyRentalRateAmount: JsonField<Long> = JsonMissing.of(),
                        @JsonProperty("weekly_rental_rate_currency")
                        @ExcludeMissing
                        weeklyRentalRateCurrency: JsonField<String> = JsonMissing.of(),
                    ) : this(
                        carClassCode,
                        checkoutDate,
                        dailyRentalRateAmount,
                        dailyRentalRateCurrency,
                        daysRented,
                        extraCharges,
                        fuelChargesAmount,
                        fuelChargesCurrency,
                        insuranceChargesAmount,
                        insuranceChargesCurrency,
                        noShowIndicator,
                        oneWayDropOffChargesAmount,
                        oneWayDropOffChargesCurrency,
                        renterName,
                        weeklyRentalRateAmount,
                        weeklyRentalRateCurrency,
                        mutableMapOf(),
                    )

                    /**
                     * Code indicating the vehicle's class.
                     *
                     * @throws IncreaseInvalidDataException if the JSON field has an unexpected type
                     *   (e.g. if the server responded with an unexpected value).
                     */
                    fun carClassCode(): Optional<String> =
                        carClassCode.getOptional("car_class_code")

                    /**
                     * Date the customer picked up the car or, in the case of a no-show or pre-pay
                     * transaction, the scheduled pick up date.
                     *
                     * @throws IncreaseInvalidDataException if the JSON field has an unexpected type
                     *   (e.g. if the server responded with an unexpected value).
                     */
                    fun checkoutDate(): Optional<LocalDate> =
                        checkoutDate.getOptional("checkout_date")

                    /**
                     * Daily rate being charged for the vehicle.
                     *
                     * @throws IncreaseInvalidDataException if the JSON field has an unexpected type
                     *   (e.g. if the server responded with an unexpected value).
                     */
                    fun dailyRentalRateAmount(): Optional<Long> =
                        dailyRentalRateAmount.getOptional("daily_rental_rate_amount")

                    /**
                     * The [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) code for the daily
                     * rental rate.
                     *
                     * @throws IncreaseInvalidDataException if the JSON field has an unexpected type
                     *   (e.g. if the server responded with an unexpected value).
                     */
                    fun dailyRentalRateCurrency(): Optional<String> =
                        dailyRentalRateCurrency.getOptional("daily_rental_rate_currency")

                    /**
                     * Number of days the vehicle was rented.
                     *
                     * @throws IncreaseInvalidDataException if the JSON field has an unexpected type
                     *   (e.g. if the server responded with an unexpected value).
                     */
                    fun daysRented(): Optional<Long> = daysRented.getOptional("days_rented")

                    /**
                     * Additional charges (gas, late fee, etc.) being billed.
                     *
                     * @throws IncreaseInvalidDataException if the JSON field has an unexpected type
                     *   (e.g. if the server responded with an unexpected value).
                     */
                    fun extraCharges(): Optional<ExtraCharges> =
                        extraCharges.getOptional("extra_charges")

                    /**
                     * Fuel charges for the vehicle.
                     *
                     * @throws IncreaseInvalidDataException if the JSON field has an unexpected type
                     *   (e.g. if the server responded with an unexpected value).
                     */
                    fun fuelChargesAmount(): Optional<Long> =
                        fuelChargesAmount.getOptional("fuel_charges_amount")

                    /**
                     * The [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) code for the fuel
                     * charges assessed.
                     *
                     * @throws IncreaseInvalidDataException if the JSON field has an unexpected type
                     *   (e.g. if the server responded with an unexpected value).
                     */
                    fun fuelChargesCurrency(): Optional<String> =
                        fuelChargesCurrency.getOptional("fuel_charges_currency")

                    /**
                     * Any insurance being charged for the vehicle.
                     *
                     * @throws IncreaseInvalidDataException if the JSON field has an unexpected type
                     *   (e.g. if the server responded with an unexpected value).
                     */
                    fun insuranceChargesAmount(): Optional<Long> =
                        insuranceChargesAmount.getOptional("insurance_charges_amount")

                    /**
                     * The [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) code for the insurance
                     * charges assessed.
                     *
                     * @throws IncreaseInvalidDataException if the JSON field has an unexpected type
                     *   (e.g. if the server responded with an unexpected value).
                     */
                    fun insuranceChargesCurrency(): Optional<String> =
                        insuranceChargesCurrency.getOptional("insurance_charges_currency")

                    /**
                     * An indicator that the cardholder is being billed for a reserved vehicle that
                     * was not actually rented (that is, a "no-show" charge).
                     *
                     * @throws IncreaseInvalidDataException if the JSON field has an unexpected type
                     *   (e.g. if the server responded with an unexpected value).
                     */
                    fun noShowIndicator(): Optional<NoShowIndicator> =
                        noShowIndicator.getOptional("no_show_indicator")

                    /**
                     * Charges for returning the vehicle at a different location than where it was
                     * picked up.
                     *
                     * @throws IncreaseInvalidDataException if the JSON field has an unexpected type
                     *   (e.g. if the server responded with an unexpected value).
                     */
                    fun oneWayDropOffChargesAmount(): Optional<Long> =
                        oneWayDropOffChargesAmount.getOptional("one_way_drop_off_charges_amount")

                    /**
                     * The [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) code for the one-way
                     * drop-off charges assessed.
                     *
                     * @throws IncreaseInvalidDataException if the JSON field has an unexpected type
                     *   (e.g. if the server responded with an unexpected value).
                     */
                    fun oneWayDropOffChargesCurrency(): Optional<String> =
                        oneWayDropOffChargesCurrency.getOptional(
                            "one_way_drop_off_charges_currency"
                        )

                    /**
                     * Name of the person renting the vehicle.
                     *
                     * @throws IncreaseInvalidDataException if the JSON field has an unexpected type
                     *   (e.g. if the server responded with an unexpected value).
                     */
                    fun renterName(): Optional<String> = renterName.getOptional("renter_name")

                    /**
                     * Weekly rate being charged for the vehicle.
                     *
                     * @throws IncreaseInvalidDataException if the JSON field has an unexpected type
                     *   (e.g. if the server responded with an unexpected value).
                     */
                    fun weeklyRentalRateAmount(): Optional<Long> =
                        weeklyRentalRateAmount.getOptional("weekly_rental_rate_amount")

                    /**
                     * The [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) code for the weekly
                     * rental rate.
                     *
                     * @throws IncreaseInvalidDataException if the JSON field has an unexpected type
                     *   (e.g. if the server responded with an unexpected value).
                     */
                    fun weeklyRentalRateCurrency(): Optional<String> =
                        weeklyRentalRateCurrency.getOptional("weekly_rental_rate_currency")

                    /**
                     * Returns the raw JSON value of [carClassCode].
                     *
                     * Unlike [carClassCode], this method doesn't throw if the JSON field has an
                     * unexpected type.
                     */
                    @JsonProperty("car_class_code")
                    @ExcludeMissing
                    fun _carClassCode(): JsonField<String> = carClassCode

                    /**
                     * Returns the raw JSON value of [checkoutDate].
                     *
                     * Unlike [checkoutDate], this method doesn't throw if the JSON field has an
                     * unexpected type.
                     */
                    @JsonProperty("checkout_date")
                    @ExcludeMissing
                    fun _checkoutDate(): JsonField<LocalDate> = checkoutDate

                    /**
                     * Returns the raw JSON value of [dailyRentalRateAmount].
                     *
                     * Unlike [dailyRentalRateAmount], this method doesn't throw if the JSON field
                     * has an unexpected type.
                     */
                    @JsonProperty("daily_rental_rate_amount")
                    @ExcludeMissing
                    fun _dailyRentalRateAmount(): JsonField<Long> = dailyRentalRateAmount

                    /**
                     * Returns the raw JSON value of [dailyRentalRateCurrency].
                     *
                     * Unlike [dailyRentalRateCurrency], this method doesn't throw if the JSON field
                     * has an unexpected type.
                     */
                    @JsonProperty("daily_rental_rate_currency")
                    @ExcludeMissing
                    fun _dailyRentalRateCurrency(): JsonField<String> = dailyRentalRateCurrency

                    /**
                     * Returns the raw JSON value of [daysRented].
                     *
                     * Unlike [daysRented], this method doesn't throw if the JSON field has an
                     * unexpected type.
                     */
                    @JsonProperty("days_rented")
                    @ExcludeMissing
                    fun _daysRented(): JsonField<Long> = daysRented

                    /**
                     * Returns the raw JSON value of [extraCharges].
                     *
                     * Unlike [extraCharges], this method doesn't throw if the JSON field has an
                     * unexpected type.
                     */
                    @JsonProperty("extra_charges")
                    @ExcludeMissing
                    fun _extraCharges(): JsonField<ExtraCharges> = extraCharges

                    /**
                     * Returns the raw JSON value of [fuelChargesAmount].
                     *
                     * Unlike [fuelChargesAmount], this method doesn't throw if the JSON field has
                     * an unexpected type.
                     */
                    @JsonProperty("fuel_charges_amount")
                    @ExcludeMissing
                    fun _fuelChargesAmount(): JsonField<Long> = fuelChargesAmount

                    /**
                     * Returns the raw JSON value of [fuelChargesCurrency].
                     *
                     * Unlike [fuelChargesCurrency], this method doesn't throw if the JSON field has
                     * an unexpected type.
                     */
                    @JsonProperty("fuel_charges_currency")
                    @ExcludeMissing
                    fun _fuelChargesCurrency(): JsonField<String> = fuelChargesCurrency

                    /**
                     * Returns the raw JSON value of [insuranceChargesAmount].
                     *
                     * Unlike [insuranceChargesAmount], this method doesn't throw if the JSON field
                     * has an unexpected type.
                     */
                    @JsonProperty("insurance_charges_amount")
                    @ExcludeMissing
                    fun _insuranceChargesAmount(): JsonField<Long> = insuranceChargesAmount

                    /**
                     * Returns the raw JSON value of [insuranceChargesCurrency].
                     *
                     * Unlike [insuranceChargesCurrency], this method doesn't throw if the JSON
                     * field has an unexpected type.
                     */
                    @JsonProperty("insurance_charges_currency")
                    @ExcludeMissing
                    fun _insuranceChargesCurrency(): JsonField<String> = insuranceChargesCurrency

                    /**
                     * Returns the raw JSON value of [noShowIndicator].
                     *
                     * Unlike [noShowIndicator], this method doesn't throw if the JSON field has an
                     * unexpected type.
                     */
                    @JsonProperty("no_show_indicator")
                    @ExcludeMissing
                    fun _noShowIndicator(): JsonField<NoShowIndicator> = noShowIndicator

                    /**
                     * Returns the raw JSON value of [oneWayDropOffChargesAmount].
                     *
                     * Unlike [oneWayDropOffChargesAmount], this method doesn't throw if the JSON
                     * field has an unexpected type.
                     */
                    @JsonProperty("one_way_drop_off_charges_amount")
                    @ExcludeMissing
                    fun _oneWayDropOffChargesAmount(): JsonField<Long> = oneWayDropOffChargesAmount

                    /**
                     * Returns the raw JSON value of [oneWayDropOffChargesCurrency].
                     *
                     * Unlike [oneWayDropOffChargesCurrency], this method doesn't throw if the JSON
                     * field has an unexpected type.
                     */
                    @JsonProperty("one_way_drop_off_charges_currency")
                    @ExcludeMissing
                    fun _oneWayDropOffChargesCurrency(): JsonField<String> =
                        oneWayDropOffChargesCurrency

                    /**
                     * Returns the raw JSON value of [renterName].
                     *
                     * Unlike [renterName], this method doesn't throw if the JSON field has an
                     * unexpected type.
                     */
                    @JsonProperty("renter_name")
                    @ExcludeMissing
                    fun _renterName(): JsonField<String> = renterName

                    /**
                     * Returns the raw JSON value of [weeklyRentalRateAmount].
                     *
                     * Unlike [weeklyRentalRateAmount], this method doesn't throw if the JSON field
                     * has an unexpected type.
                     */
                    @JsonProperty("weekly_rental_rate_amount")
                    @ExcludeMissing
                    fun _weeklyRentalRateAmount(): JsonField<Long> = weeklyRentalRateAmount

                    /**
                     * Returns the raw JSON value of [weeklyRentalRateCurrency].
                     *
                     * Unlike [weeklyRentalRateCurrency], this method doesn't throw if the JSON
                     * field has an unexpected type.
                     */
                    @JsonProperty("weekly_rental_rate_currency")
                    @ExcludeMissing
                    fun _weeklyRentalRateCurrency(): JsonField<String> = weeklyRentalRateCurrency

                    @JsonAnySetter
                    private fun putAdditionalProperty(key: String, value: JsonValue) {
                        additionalProperties.put(key, value)
                    }

                    @JsonAnyGetter
                    @ExcludeMissing
                    fun _additionalProperties(): Map<String, JsonValue> =
                        Collections.unmodifiableMap(additionalProperties)

                    fun toBuilder() = Builder().from(this)

                    companion object {

                        /**
                         * Returns a mutable builder for constructing an instance of [CarRental].
                         *
                         * The following fields are required:
                         * ```java
                         * .carClassCode()
                         * .checkoutDate()
                         * .dailyRentalRateAmount()
                         * .dailyRentalRateCurrency()
                         * .daysRented()
                         * .extraCharges()
                         * .fuelChargesAmount()
                         * .fuelChargesCurrency()
                         * .insuranceChargesAmount()
                         * .insuranceChargesCurrency()
                         * .noShowIndicator()
                         * .oneWayDropOffChargesAmount()
                         * .oneWayDropOffChargesCurrency()
                         * .renterName()
                         * .weeklyRentalRateAmount()
                         * .weeklyRentalRateCurrency()
                         * ```
                         */
                        @JvmStatic fun builder() = Builder()
                    }

                    /** A builder for [CarRental]. */
                    class Builder internal constructor() {

                        private var carClassCode: JsonField<String>? = null
                        private var checkoutDate: JsonField<LocalDate>? = null
                        private var dailyRentalRateAmount: JsonField<Long>? = null
                        private var dailyRentalRateCurrency: JsonField<String>? = null
                        private var daysRented: JsonField<Long>? = null
                        private var extraCharges: JsonField<ExtraCharges>? = null
                        private var fuelChargesAmount: JsonField<Long>? = null
                        private var fuelChargesCurrency: JsonField<String>? = null
                        private var insuranceChargesAmount: JsonField<Long>? = null
                        private var insuranceChargesCurrency: JsonField<String>? = null
                        private var noShowIndicator: JsonField<NoShowIndicator>? = null
                        private var oneWayDropOffChargesAmount: JsonField<Long>? = null
                        private var oneWayDropOffChargesCurrency: JsonField<String>? = null
                        private var renterName: JsonField<String>? = null
                        private var weeklyRentalRateAmount: JsonField<Long>? = null
                        private var weeklyRentalRateCurrency: JsonField<String>? = null
                        private var additionalProperties: MutableMap<String, JsonValue> =
                            mutableMapOf()

                        @JvmSynthetic
                        internal fun from(carRental: CarRental) = apply {
                            carClassCode = carRental.carClassCode
                            checkoutDate = carRental.checkoutDate
                            dailyRentalRateAmount = carRental.dailyRentalRateAmount
                            dailyRentalRateCurrency = carRental.dailyRentalRateCurrency
                            daysRented = carRental.daysRented
                            extraCharges = carRental.extraCharges
                            fuelChargesAmount = carRental.fuelChargesAmount
                            fuelChargesCurrency = carRental.fuelChargesCurrency
                            insuranceChargesAmount = carRental.insuranceChargesAmount
                            insuranceChargesCurrency = carRental.insuranceChargesCurrency
                            noShowIndicator = carRental.noShowIndicator
                            oneWayDropOffChargesAmount = carRental.oneWayDropOffChargesAmount
                            oneWayDropOffChargesCurrency = carRental.oneWayDropOffChargesCurrency
                            renterName = carRental.renterName
                            weeklyRentalRateAmount = carRental.weeklyRentalRateAmount
                            weeklyRentalRateCurrency = carRental.weeklyRentalRateCurrency
                            additionalProperties = carRental.additionalProperties.toMutableMap()
                        }

                        /** Code indicating the vehicle's class. */
                        fun carClassCode(carClassCode: String?) =
                            carClassCode(JsonField.ofNullable(carClassCode))

                        /**
                         * Alias for calling [Builder.carClassCode] with
                         * `carClassCode.orElse(null)`.
                         */
                        fun carClassCode(carClassCode: Optional<String>) =
                            carClassCode(carClassCode.getOrNull())

                        /**
                         * Sets [Builder.carClassCode] to an arbitrary JSON value.
                         *
                         * You should usually call [Builder.carClassCode] with a well-typed [String]
                         * value instead. This method is primarily for setting the field to an
                         * undocumented or not yet supported value.
                         */
                        fun carClassCode(carClassCode: JsonField<String>) = apply {
                            this.carClassCode = carClassCode
                        }

                        /**
                         * Date the customer picked up the car or, in the case of a no-show or
                         * pre-pay transaction, the scheduled pick up date.
                         */
                        fun checkoutDate(checkoutDate: LocalDate?) =
                            checkoutDate(JsonField.ofNullable(checkoutDate))

                        /**
                         * Alias for calling [Builder.checkoutDate] with
                         * `checkoutDate.orElse(null)`.
                         */
                        fun checkoutDate(checkoutDate: Optional<LocalDate>) =
                            checkoutDate(checkoutDate.getOrNull())

                        /**
                         * Sets [Builder.checkoutDate] to an arbitrary JSON value.
                         *
                         * You should usually call [Builder.checkoutDate] with a well-typed
                         * [LocalDate] value instead. This method is primarily for setting the field
                         * to an undocumented or not yet supported value.
                         */
                        fun checkoutDate(checkoutDate: JsonField<LocalDate>) = apply {
                            this.checkoutDate = checkoutDate
                        }

                        /** Daily rate being charged for the vehicle. */
                        fun dailyRentalRateAmount(dailyRentalRateAmount: Long?) =
                            dailyRentalRateAmount(JsonField.ofNullable(dailyRentalRateAmount))

                        /**
                         * Alias for [Builder.dailyRentalRateAmount].
                         *
                         * This unboxed primitive overload exists for backwards compatibility.
                         */
                        fun dailyRentalRateAmount(dailyRentalRateAmount: Long) =
                            dailyRentalRateAmount(dailyRentalRateAmount as Long?)

                        /**
                         * Alias for calling [Builder.dailyRentalRateAmount] with
                         * `dailyRentalRateAmount.orElse(null)`.
                         */
                        fun dailyRentalRateAmount(dailyRentalRateAmount: Optional<Long>) =
                            dailyRentalRateAmount(dailyRentalRateAmount.getOrNull())

                        /**
                         * Sets [Builder.dailyRentalRateAmount] to an arbitrary JSON value.
                         *
                         * You should usually call [Builder.dailyRentalRateAmount] with a well-typed
                         * [Long] value instead. This method is primarily for setting the field to
                         * an undocumented or not yet supported value.
                         */
                        fun dailyRentalRateAmount(dailyRentalRateAmount: JsonField<Long>) = apply {
                            this.dailyRentalRateAmount = dailyRentalRateAmount
                        }

                        /**
                         * The [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) code for the daily
                         * rental rate.
                         */
                        fun dailyRentalRateCurrency(dailyRentalRateCurrency: String?) =
                            dailyRentalRateCurrency(JsonField.ofNullable(dailyRentalRateCurrency))

                        /**
                         * Alias for calling [Builder.dailyRentalRateCurrency] with
                         * `dailyRentalRateCurrency.orElse(null)`.
                         */
                        fun dailyRentalRateCurrency(dailyRentalRateCurrency: Optional<String>) =
                            dailyRentalRateCurrency(dailyRentalRateCurrency.getOrNull())

                        /**
                         * Sets [Builder.dailyRentalRateCurrency] to an arbitrary JSON value.
                         *
                         * You should usually call [Builder.dailyRentalRateCurrency] with a
                         * well-typed [String] value instead. This method is primarily for setting
                         * the field to an undocumented or not yet supported value.
                         */
                        fun dailyRentalRateCurrency(dailyRentalRateCurrency: JsonField<String>) =
                            apply {
                                this.dailyRentalRateCurrency = dailyRentalRateCurrency
                            }

                        /** Number of days the vehicle was rented. */
                        fun daysRented(daysRented: Long?) =
                            daysRented(JsonField.ofNullable(daysRented))

                        /**
                         * Alias for [Builder.daysRented].
                         *
                         * This unboxed primitive overload exists for backwards compatibility.
                         */
                        fun daysRented(daysRented: Long) = daysRented(daysRented as Long?)

                        /**
                         * Alias for calling [Builder.daysRented] with `daysRented.orElse(null)`.
                         */
                        fun daysRented(daysRented: Optional<Long>) =
                            daysRented(daysRented.getOrNull())

                        /**
                         * Sets [Builder.daysRented] to an arbitrary JSON value.
                         *
                         * You should usually call [Builder.daysRented] with a well-typed [Long]
                         * value instead. This method is primarily for setting the field to an
                         * undocumented or not yet supported value.
                         */
                        fun daysRented(daysRented: JsonField<Long>) = apply {
                            this.daysRented = daysRented
                        }

                        /** Additional charges (gas, late fee, etc.) being billed. */
                        fun extraCharges(extraCharges: ExtraCharges?) =
                            extraCharges(JsonField.ofNullable(extraCharges))

                        /**
                         * Alias for calling [Builder.extraCharges] with
                         * `extraCharges.orElse(null)`.
                         */
                        fun extraCharges(extraCharges: Optional<ExtraCharges>) =
                            extraCharges(extraCharges.getOrNull())

                        /**
                         * Sets [Builder.extraCharges] to an arbitrary JSON value.
                         *
                         * You should usually call [Builder.extraCharges] with a well-typed
                         * [ExtraCharges] value instead. This method is primarily for setting the
                         * field to an undocumented or not yet supported value.
                         */
                        fun extraCharges(extraCharges: JsonField<ExtraCharges>) = apply {
                            this.extraCharges = extraCharges
                        }

                        /** Fuel charges for the vehicle. */
                        fun fuelChargesAmount(fuelChargesAmount: Long?) =
                            fuelChargesAmount(JsonField.ofNullable(fuelChargesAmount))

                        /**
                         * Alias for [Builder.fuelChargesAmount].
                         *
                         * This unboxed primitive overload exists for backwards compatibility.
                         */
                        fun fuelChargesAmount(fuelChargesAmount: Long) =
                            fuelChargesAmount(fuelChargesAmount as Long?)

                        /**
                         * Alias for calling [Builder.fuelChargesAmount] with
                         * `fuelChargesAmount.orElse(null)`.
                         */
                        fun fuelChargesAmount(fuelChargesAmount: Optional<Long>) =
                            fuelChargesAmount(fuelChargesAmount.getOrNull())

                        /**
                         * Sets [Builder.fuelChargesAmount] to an arbitrary JSON value.
                         *
                         * You should usually call [Builder.fuelChargesAmount] with a well-typed
                         * [Long] value instead. This method is primarily for setting the field to
                         * an undocumented or not yet supported value.
                         */
                        fun fuelChargesAmount(fuelChargesAmount: JsonField<Long>) = apply {
                            this.fuelChargesAmount = fuelChargesAmount
                        }

                        /**
                         * The [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) code for the fuel
                         * charges assessed.
                         */
                        fun fuelChargesCurrency(fuelChargesCurrency: String?) =
                            fuelChargesCurrency(JsonField.ofNullable(fuelChargesCurrency))

                        /**
                         * Alias for calling [Builder.fuelChargesCurrency] with
                         * `fuelChargesCurrency.orElse(null)`.
                         */
                        fun fuelChargesCurrency(fuelChargesCurrency: Optional<String>) =
                            fuelChargesCurrency(fuelChargesCurrency.getOrNull())

                        /**
                         * Sets [Builder.fuelChargesCurrency] to an arbitrary JSON value.
                         *
                         * You should usually call [Builder.fuelChargesCurrency] with a well-typed
                         * [String] value instead. This method is primarily for setting the field to
                         * an undocumented or not yet supported value.
                         */
                        fun fuelChargesCurrency(fuelChargesCurrency: JsonField<String>) = apply {
                            this.fuelChargesCurrency = fuelChargesCurrency
                        }

                        /** Any insurance being charged for the vehicle. */
                        fun insuranceChargesAmount(insuranceChargesAmount: Long?) =
                            insuranceChargesAmount(JsonField.ofNullable(insuranceChargesAmount))

                        /**
                         * Alias for [Builder.insuranceChargesAmount].
                         *
                         * This unboxed primitive overload exists for backwards compatibility.
                         */
                        fun insuranceChargesAmount(insuranceChargesAmount: Long) =
                            insuranceChargesAmount(insuranceChargesAmount as Long?)

                        /**
                         * Alias for calling [Builder.insuranceChargesAmount] with
                         * `insuranceChargesAmount.orElse(null)`.
                         */
                        fun insuranceChargesAmount(insuranceChargesAmount: Optional<Long>) =
                            insuranceChargesAmount(insuranceChargesAmount.getOrNull())

                        /**
                         * Sets [Builder.insuranceChargesAmount] to an arbitrary JSON value.
                         *
                         * You should usually call [Builder.insuranceChargesAmount] with a
                         * well-typed [Long] value instead. This method is primarily for setting the
                         * field to an undocumented or not yet supported value.
                         */
                        fun insuranceChargesAmount(insuranceChargesAmount: JsonField<Long>) =
                            apply {
                                this.insuranceChargesAmount = insuranceChargesAmount
                            }

                        /**
                         * The [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) code for the
                         * insurance charges assessed.
                         */
                        fun insuranceChargesCurrency(insuranceChargesCurrency: String?) =
                            insuranceChargesCurrency(JsonField.ofNullable(insuranceChargesCurrency))

                        /**
                         * Alias for calling [Builder.insuranceChargesCurrency] with
                         * `insuranceChargesCurrency.orElse(null)`.
                         */
                        fun insuranceChargesCurrency(insuranceChargesCurrency: Optional<String>) =
                            insuranceChargesCurrency(insuranceChargesCurrency.getOrNull())

                        /**
                         * Sets [Builder.insuranceChargesCurrency] to an arbitrary JSON value.
                         *
                         * You should usually call [Builder.insuranceChargesCurrency] with a
                         * well-typed [String] value instead. This method is primarily for setting
                         * the field to an undocumented or not yet supported value.
                         */
                        fun insuranceChargesCurrency(insuranceChargesCurrency: JsonField<String>) =
                            apply {
                                this.insuranceChargesCurrency = insuranceChargesCurrency
                            }

                        /**
                         * An indicator that the cardholder is being billed for a reserved vehicle
                         * that was not actually rented (that is, a "no-show" charge).
                         */
                        fun noShowIndicator(noShowIndicator: NoShowIndicator?) =
                            noShowIndicator(JsonField.ofNullable(noShowIndicator))

                        /**
                         * Alias for calling [Builder.noShowIndicator] with
                         * `noShowIndicator.orElse(null)`.
                         */
                        fun noShowIndicator(noShowIndicator: Optional<NoShowIndicator>) =
                            noShowIndicator(noShowIndicator.getOrNull())

                        /**
                         * Sets [Builder.noShowIndicator] to an arbitrary JSON value.
                         *
                         * You should usually call [Builder.noShowIndicator] with a well-typed
                         * [NoShowIndicator] value instead. This method is primarily for setting the
                         * field to an undocumented or not yet supported value.
                         */
                        fun noShowIndicator(noShowIndicator: JsonField<NoShowIndicator>) = apply {
                            this.noShowIndicator = noShowIndicator
                        }

                        /**
                         * Charges for returning the vehicle at a different location than where it
                         * was picked up.
                         */
                        fun oneWayDropOffChargesAmount(oneWayDropOffChargesAmount: Long?) =
                            oneWayDropOffChargesAmount(
                                JsonField.ofNullable(oneWayDropOffChargesAmount)
                            )

                        /**
                         * Alias for [Builder.oneWayDropOffChargesAmount].
                         *
                         * This unboxed primitive overload exists for backwards compatibility.
                         */
                        fun oneWayDropOffChargesAmount(oneWayDropOffChargesAmount: Long) =
                            oneWayDropOffChargesAmount(oneWayDropOffChargesAmount as Long?)

                        /**
                         * Alias for calling [Builder.oneWayDropOffChargesAmount] with
                         * `oneWayDropOffChargesAmount.orElse(null)`.
                         */
                        fun oneWayDropOffChargesAmount(oneWayDropOffChargesAmount: Optional<Long>) =
                            oneWayDropOffChargesAmount(oneWayDropOffChargesAmount.getOrNull())

                        /**
                         * Sets [Builder.oneWayDropOffChargesAmount] to an arbitrary JSON value.
                         *
                         * You should usually call [Builder.oneWayDropOffChargesAmount] with a
                         * well-typed [Long] value instead. This method is primarily for setting the
                         * field to an undocumented or not yet supported value.
                         */
                        fun oneWayDropOffChargesAmount(
                            oneWayDropOffChargesAmount: JsonField<Long>
                        ) = apply { this.oneWayDropOffChargesAmount = oneWayDropOffChargesAmount }

                        /**
                         * The [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) code for the
                         * one-way drop-off charges assessed.
                         */
                        fun oneWayDropOffChargesCurrency(oneWayDropOffChargesCurrency: String?) =
                            oneWayDropOffChargesCurrency(
                                JsonField.ofNullable(oneWayDropOffChargesCurrency)
                            )

                        /**
                         * Alias for calling [Builder.oneWayDropOffChargesCurrency] with
                         * `oneWayDropOffChargesCurrency.orElse(null)`.
                         */
                        fun oneWayDropOffChargesCurrency(
                            oneWayDropOffChargesCurrency: Optional<String>
                        ) = oneWayDropOffChargesCurrency(oneWayDropOffChargesCurrency.getOrNull())

                        /**
                         * Sets [Builder.oneWayDropOffChargesCurrency] to an arbitrary JSON value.
                         *
                         * You should usually call [Builder.oneWayDropOffChargesCurrency] with a
                         * well-typed [String] value instead. This method is primarily for setting
                         * the field to an undocumented or not yet supported value.
                         */
                        fun oneWayDropOffChargesCurrency(
                            oneWayDropOffChargesCurrency: JsonField<String>
                        ) = apply {
                            this.oneWayDropOffChargesCurrency = oneWayDropOffChargesCurrency
                        }

                        /** Name of the person renting the vehicle. */
                        fun renterName(renterName: String?) =
                            renterName(JsonField.ofNullable(renterName))

                        /**
                         * Alias for calling [Builder.renterName] with `renterName.orElse(null)`.
                         */
                        fun renterName(renterName: Optional<String>) =
                            renterName(renterName.getOrNull())

                        /**
                         * Sets [Builder.renterName] to an arbitrary JSON value.
                         *
                         * You should usually call [Builder.renterName] with a well-typed [String]
                         * value instead. This method is primarily for setting the field to an
                         * undocumented or not yet supported value.
                         */
                        fun renterName(renterName: JsonField<String>) = apply {
                            this.renterName = renterName
                        }

                        /** Weekly rate being charged for the vehicle. */
                        fun weeklyRentalRateAmount(weeklyRentalRateAmount: Long?) =
                            weeklyRentalRateAmount(JsonField.ofNullable(weeklyRentalRateAmount))

                        /**
                         * Alias for [Builder.weeklyRentalRateAmount].
                         *
                         * This unboxed primitive overload exists for backwards compatibility.
                         */
                        fun weeklyRentalRateAmount(weeklyRentalRateAmount: Long) =
                            weeklyRentalRateAmount(weeklyRentalRateAmount as Long?)

                        /**
                         * Alias for calling [Builder.weeklyRentalRateAmount] with
                         * `weeklyRentalRateAmount.orElse(null)`.
                         */
                        fun weeklyRentalRateAmount(weeklyRentalRateAmount: Optional<Long>) =
                            weeklyRentalRateAmount(weeklyRentalRateAmount.getOrNull())

                        /**
                         * Sets [Builder.weeklyRentalRateAmount] to an arbitrary JSON value.
                         *
                         * You should usually call [Builder.weeklyRentalRateAmount] with a
                         * well-typed [Long] value instead. This method is primarily for setting the
                         * field to an undocumented or not yet supported value.
                         */
                        fun weeklyRentalRateAmount(weeklyRentalRateAmount: JsonField<Long>) =
                            apply {
                                this.weeklyRentalRateAmount = weeklyRentalRateAmount
                            }

                        /**
                         * The [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217) code for the
                         * weekly rental rate.
                         */
                        fun weeklyRentalRateCurrency(weeklyRentalRateCurrency: String?) =
                            weeklyRentalRateCurrency(JsonField.ofNullable(weeklyRentalRateCurrency))

                        /**
                         * Alias for calling [Builder.weeklyRentalRateCurrency] with
                         * `weeklyRentalRateCurrency.orElse(null)`.
                         */
                        fun weeklyRentalRateCurrency(weeklyRentalRateCurrency: Optional<String>) =
                            weeklyRentalRateCurrency(weeklyRentalRateCurrency.getOrNull())

                        /**
                         * Sets [Builder.weeklyRentalRateCurrency] to an arbitrary JSON value.
                         *
                         * You should usually call [Builder.weeklyRentalRateCurrency] with a
                         * well-typed [String] value instead. This method is primarily for setting
                         * the field to an undocumented or not yet supported value.
                         */
                        fun weeklyRentalRateCurrency(weeklyRentalRateCurrency: JsonField<String>) =
                            apply {
                                this.weeklyRentalRateCurrency = weeklyRentalRateCurrency
                            }

                        fun additionalProperties(additionalProperties: Map<String, JsonValue>) =
                            apply {
                                this.additionalProperties.clear()
                                putAllAdditionalProperties(additionalProperties)
                            }

                        fun putAdditionalProperty(key: String, value: JsonValue) = apply {
                            additionalProperties.put(key, value)
                        }

                        fun putAllAdditionalProperties(
                            additionalProperties: Map<String, JsonValue>
                        ) = apply { this.additionalProperties.putAll(additionalProperties) }

                        fun removeAdditionalProperty(key: String) = apply {
                            additionalProperties.remove(key)
                        }

                        fun removeAllAdditionalProperties(keys: Set<String>) = apply {
                            keys.forEach(::removeAdditionalProperty)
                        }

                        /**
                         * Returns an immutable instance of [CarRental].
                         *
                         * Further updates to this [Builder] will not mutate the returned instance.
                         *
                         * The following fields are required:
                         * ```java
                         * .carClassCode()
                         * .checkoutDate()
                         * .dailyRentalRateAmount()
                         * .dailyRentalRateCurrency()
                         * .daysRented()
                         * .extraCharges()
                         * .fuelChargesAmount()
                         * .fuelChargesC