/*
 * Decompiled with CFR 0.152.
 */
package com.javaaidev.agenticpatterns.taskexecution;

import com.javaaidev.agenticpatterns.core.Agent;
import com.javaaidev.agenticpatterns.core.AgentExecutionException;
import com.javaaidev.agenticpatterns.core.TypeResolver;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.jspecify.annotations.Nullable;
import org.springframework.ai.chat.client.ChatClient;
import org.springframework.core.ParameterizedTypeReference;

public abstract class TaskExecutionAgent<Request, Response>
extends Agent
implements Function<Request, Response> {
    protected final @Nullable Type responseType;

    protected abstract String getPromptTemplate();

    protected TaskExecutionAgent(ChatClient chatClient) {
        super(chatClient);
        this.responseType = TypeResolver.resolveType(this.getClass(), TaskExecutionAgent.class, (int)1);
    }

    protected TaskExecutionAgent(ChatClient chatClient, @Nullable Type responseType) {
        super(chatClient);
        this.responseType = responseType;
    }

    protected @Nullable Map<String, Object> getPromptContext(@Nullable Request request) {
        return new HashMap<String, Object>();
    }

    protected void updateRequest(ChatClient.ChatClientRequestSpec spec) {
    }

    @Override
    public Response apply(Request request) {
        return this.call(request);
    }

    public Response call(@Nullable Request request) {
        Object output;
        String template = this.getPromptTemplate();
        if (template.isBlank()) {
            throw new AgentExecutionException("Blank prompt template");
        }
        Object type = this.responseType != null ? this.responseType : Object.class;
        HashMap context = Optional.ofNullable(this.getPromptContext(request)).map(HashMap::new).orElseGet(HashMap::new);
        ChatClient.ChatClientRequestSpec requestSpec = this.chatClient.prompt().user(userSpec -> userSpec.text(template).params((Map)context));
        this.updateRequest(requestSpec);
        ChatClient.CallResponseSpec responseSpec = requestSpec.call();
        if (type instanceof Class) {
            Class clazz = (Class)type;
            output = responseSpec.entity(clazz);
        } else if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            output = responseSpec.entity(ParameterizedTypeReference.forType((Type)parameterizedType));
        } else {
            throw new AgentExecutionException("Invalid type " + String.valueOf(type));
        }
        if (output == null) {
            throw new RuntimeException("Empty or bad response from LLM");
        }
        return (Response)output;
    }
}

