/*
 * Decompiled with CFR 0.152.
 */
package com.javaaidev.llmcodeexecutor.core;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.exception.NotModifiedException;
import com.github.dockerjava.api.model.Bind;
import com.github.dockerjava.api.model.Frame;
import com.github.dockerjava.api.model.HostConfig;
import com.github.dockerjava.api.model.PullResponseItem;
import com.github.dockerjava.api.model.StreamType;
import com.github.dockerjava.api.model.Volume;
import com.github.dockerjava.core.DefaultDockerClientConfig;
import com.github.dockerjava.core.DockerClientConfig;
import com.github.dockerjava.core.DockerClientImpl;
import com.github.dockerjava.httpclient5.ApacheDockerHttpClient;
import com.github.dockerjava.transport.DockerHttpClient;
import com.github.dockerjava.transport.SSLConfig;
import com.javaaidev.llmcodeexecutor.core.CodeExecutionRequest;
import com.javaaidev.llmcodeexecutor.core.CodeExecutionResponse;
import com.javaaidev.llmcodeexecutor.core.CodeExecutorConfig;
import com.javaaidev.llmcodeexecutor.core.CopiedFile;
import com.javaaidev.llmcodeexecutor.core.LLMCodeExecutor;
import com.javaaidev.llmcodeexecutor.core.OutputFileCollectionConfig;
import com.javaaidev.llmcodeexecutor.core.OutputFileContent;
import com.javaaidev.llmcodeexecutor.core.VolumeBind;
import java.io.Closeable;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\b\u0010\u0018\u001a\u00020\u0019H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0018\u0010\f\u001a\n \n*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u0018\u0010\u000e\u001a\n \n*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u0018\u0010\u0011\u001a\n \n*\u0004\u0018\u00010\u00120\u0012X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0013\u00a8\u0006\u001a"}, d2={"Lcom/javaaidev/llmcodeexecutor/core/LLMCodeExecutor;", "", "config", "Lcom/javaaidev/llmcodeexecutor/core/CodeExecutorConfig;", "customDockerClientConfig", "Lcom/github/dockerjava/core/DockerClientConfig;", "<init>", "(Lcom/javaaidev/llmcodeexecutor/core/CodeExecutorConfig;Lcom/github/dockerjava/core/DockerClientConfig;)V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "dockerClientConfig", "Lcom/github/dockerjava/core/DockerClientConfig;", "httpClient", "Lcom/github/dockerjava/httpclient5/ApacheDockerHttpClient;", "Lcom/github/dockerjava/httpclient5/ApacheDockerHttpClient;", "dockerClient", "Lcom/github/dockerjava/api/DockerClient;", "Lcom/github/dockerjava/api/DockerClient;", "execute", "Lcom/javaaidev/llmcodeexecutor/core/CodeExecutionResponse;", "request", "Lcom/javaaidev/llmcodeexecutor/core/CodeExecutionRequest;", "pullImage", "", "core"})
@SourceDebugExtension(value={"SMAP\nLLMCodeExecutor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LLMCodeExecutor.kt\ncom/javaaidev/llmcodeexecutor/core/LLMCodeExecutor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,241:1\n1557#2:242\n1628#2,3:243\n1557#2:246\n1628#2,3:247\n774#2:251\n865#2,2:252\n1863#2,2:254\n1#3:250\n*S KotlinDebug\n*F\n+ 1 LLMCodeExecutor.kt\ncom/javaaidev/llmcodeexecutor/core/LLMCodeExecutor\n*L\n89#1:242\n89#1:243,3\n94#1:246\n94#1:247,3\n165#1:251\n165#1:252,2\n166#1:254,2\n*E\n"})
public final class LLMCodeExecutor {
    @NotNull
    private final CodeExecutorConfig config;
    private final Logger logger;
    private final DockerClientConfig dockerClientConfig;
    private final ApacheDockerHttpClient httpClient;
    private final DockerClient dockerClient;

    public LLMCodeExecutor(@NotNull CodeExecutorConfig config, @Nullable DockerClientConfig customDockerClientConfig) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
        this.logger = LoggerFactory.getLogger(LLMCodeExecutor.class);
        DockerClientConfig dockerClientConfig = customDockerClientConfig;
        if (dockerClientConfig == null) {
            dockerClientConfig = (DockerClientConfig)DefaultDockerClientConfig.createDefaultConfigBuilder().build();
        }
        this.dockerClientConfig = dockerClientConfig;
        this.httpClient = new ApacheDockerHttpClient.Builder().dockerHost(this.dockerClientConfig.getDockerHost()).sslConfig((SSLConfig)this.dockerClientConfig.getSSLConfig()).maxConnections(100).connectionTimeout(Duration.ofSeconds(30L)).responseTimeout(Duration.ofSeconds(45L)).build();
        this.dockerClient = DockerClientImpl.getInstance((DockerClientConfig)this.dockerClientConfig, (DockerHttpClient)((DockerHttpClient)this.httpClient));
    }

    public /* synthetic */ LLMCodeExecutor(CodeExecutorConfig codeExecutorConfig, DockerClientConfig dockerClientConfig, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            dockerClientConfig = null;
        }
        this(codeExecutorConfig, dockerClientConfig);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final CodeExecutionResponse execute(@NotNull CodeExecutionRequest request) {
        Object it;
        Object it2;
        Object object;
        Iterable<Volume> destination$iv$iv;
        Iterable $this$map$iv;
        CreateContainerCmd createContainerCmd;
        List<Object> volumes;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        this.pullImage();
        CreateContainerCmd cmd = this.dockerClient.createContainerCmd(this.config.getContainerImage());
        List<String> list = this.config.getVolumes();
        if (list != null) {
            void $this$mapTo$iv$iv;
            volumes = list;
            boolean bl = false;
            Iterable iterable = volumes;
            createContainerCmd = cmd;
            boolean $i$f$map = false;
            void var10_11 = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it3;
                String string = (String)item$iv$iv;
                object = destination$iv$iv;
                boolean bl2 = false;
                object.add(new Volume((String)it3));
            }
            createContainerCmd.withVolumes((List)destination$iv$iv);
        }
        List<VolumeBind> list2 = this.config.getVolumeBinds();
        if (list2 != null) {
            void $this$mapTo$iv$iv;
            volumes = list2;
            boolean bl = false;
            $this$map$iv = volumes;
            createContainerCmd = HostConfig.newHostConfig();
            CreateContainerCmd createContainerCmd2 = cmd;
            boolean $i$f$map = false;
            destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                object = (VolumeBind)item$iv$iv;
                Collection bl2 = destination$iv$iv2;
                boolean bl3 = false;
                bl2.add(new Bind(((VolumeBind)it2).getVolumeName(), new Volume(((VolumeBind)it2).getDestinationVolume())));
            }
            List bl2 = (List)destination$iv$iv2;
            createContainerCmd2.withHostConfig(createContainerCmd.withBinds(bl2));
        }
        List<String> list3 = this.config.getCommands();
        if (list3 != null) {
            it = list3;
            boolean bl = false;
            cmd.withCmd(it);
        }
        String string = this.config.getWorkingDirectory();
        if (string != null) {
            it = string;
            boolean bl = false;
            cmd.withWorkingDir((String)it);
        }
        String containerId = cmd.exec().getId();
        this.logger.info("Created container {}", (Object)containerId);
        this.dockerClient.startContainerCmd(containerId).exec();
        this.logger.info("Started container {}", (Object)containerId);
        StringBuffer outputBuilder = new StringBuffer();
        StringBuffer errorBuilder = new StringBuffer();
        CountDownLatch countDownLatch = new CountDownLatch(1);
        this.dockerClient.logContainerCmd(containerId).withStdErr(Boolean.valueOf(true)).withStdOut(Boolean.valueOf(true)).withTailAll().withFollowStream(Boolean.valueOf(true)).exec((ResultCallback)new ResultCallback<Frame>(errorBuilder, countDownLatch, outputBuilder){
            private Closeable closeable;
            final /* synthetic */ StringBuffer $errorBuilder;
            final /* synthetic */ CountDownLatch $countDownLatch;
            final /* synthetic */ StringBuffer $outputBuilder;
            {
                this.$errorBuilder = $errorBuilder;
                this.$countDownLatch = $countDownLatch;
                this.$outputBuilder = $outputBuilder;
            }

            public void close() {
            }

            public void onStart(Closeable closeable) {
                this.closeable = closeable;
            }

            public void onError(Throwable throwable) {
                block0: {
                    Throwable throwable2 = throwable;
                    if (throwable2 == null) break block0;
                    Throwable throwable3 = throwable2;
                    StringBuffer stringBuffer = this.$errorBuilder;
                    Throwable it = throwable3;
                    boolean bl = false;
                    stringBuffer.append(it.getMessage());
                }
            }

            public void onComplete() {
                Closeable closeable = this.closeable;
                if (closeable != null) {
                    closeable.close();
                }
                this.$countDownLatch.countDown();
            }

            public void onNext(Frame frame) {
                StringBuffer stringBuffer;
                Frame frame2 = frame;
                if (frame2 != null) {
                    Frame frame3 = frame2;
                    StringBuffer stringBuffer2 = this.$errorBuilder;
                    StringBuffer stringBuffer3 = this.$outputBuilder;
                    Frame it = frame3;
                    boolean bl = false;
                    byte[] byArray = it.getPayload();
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getPayload(...)");
                    byte[] byArray2 = byArray;
                    String content = new String(byArray2, Charsets.UTF_8);
                    StreamType streamType = it.getStreamType();
                    stringBuffer = (streamType == null ? -1 : execute.WhenMappings.$EnumSwitchMapping$0[streamType.ordinal()]) == 1 ? stringBuffer2.append(content) : stringBuffer3.append(content);
                } else {
                    stringBuffer = null;
                }
            }
        });
        Duration duration = this.config.getExecutionTimeout();
        if (duration == null) {
            duration = Duration.ofMinutes(1L);
        }
        countDownLatch.await(duration.toSeconds(), TimeUnit.SECONDS);
        this.logger.info("Container finished execution {}", (Object)containerId);
        try {
            this.dockerClient.stopContainerCmd(containerId).exec();
        }
        catch (NotModifiedException notModifiedException) {
            // empty catch block
        }
        List copiedFiles = new ArrayList();
        List loadedFiles = new ArrayList();
        OutputFileCollectionConfig outputFileCollectionConfig = request.getOutputFileCollectionConfig();
        if (outputFileCollectionConfig != null) {
            OutputFileCollectionConfig collectionConfig = outputFileCollectionConfig;
            boolean bl = false;
            if (this.config.getContainerOutputDirectory() != null && (Intrinsics.areEqual((Object)collectionConfig.getLoadFiles(), (Object)true) || Intrinsics.areEqual((Object)collectionConfig.getCopyFiles(), (Object)true))) {
                InspectContainerResponse response = this.dockerClient.inspectContainerCmd(containerId).exec();
                Object object2 = response.getMounts();
                if (object2 != null) {
                    Object v8;
                    block20: {
                        Object item$iv$iv;
                        Iterable iterable = (Iterable)object2;
                        item$iv$iv = iterable.iterator();
                        while (item$iv$iv.hasNext()) {
                            it2 = item$iv$iv.next();
                            InspectContainerResponse.Mount mount = (InspectContainerResponse.Mount)it2;
                            boolean bl4 = false;
                            Volume volume = mount.getDestination();
                            if (!Intrinsics.areEqual((Object)(volume != null ? volume.getPath() : null), (Object)this.config.getContainerOutputDirectory())) continue;
                            v8 = it2;
                            break block20;
                        }
                        v8 = null;
                    }
                    if ((object2 = (InspectContainerResponse.Mount)v8) != null && (object2 = object2.getSource()) != null) {
                        void $this$forEach$iv;
                        void $this$filterTo$iv$iv;
                        Iterable $this$filter$iv;
                        Object source = object2;
                        boolean bl5 = false;
                        Path path = Path.of((String)source, new String[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(...)");
                        String string2 = collectionConfig.getIncludedFilePattern();
                        if (string2 == null) {
                            string2 = "*";
                        }
                        Iterable mount = PathsKt.listDirectoryEntries((Path)path, (String)string2);
                        boolean $i$f$filter = false;
                        Iterator iterator = $this$filter$iv;
                        Collection destination$iv$iv3 = new ArrayList();
                        boolean $i$f$filterTo = false;
                        for (Object element$iv$iv : $this$filterTo$iv$iv) {
                            Path it4 = (Path)element$iv$iv;
                            boolean bl6 = false;
                            LinkOption[] linkOptionArray = new LinkOption[]{};
                            if (!Files.isRegularFile(it4, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) continue;
                            destination$iv$iv3.add(element$iv$iv);
                        }
                        $this$filter$iv = (List)destination$iv$iv3;
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            boolean bl7;
                            Path path2 = (Path)element$iv;
                            boolean bl8 = false;
                            if (Intrinsics.areEqual((Object)collectionConfig.getCopyFiles(), (Object)true)) {
                                String string3 = collectionConfig.getCopiedFilesPath();
                                if (string3 == null) {
                                    string3 = ".";
                                }
                                Path copiedFilesPath = Path.of(string3, new String[0]);
                                Files.createDirectories(copiedFilesPath, new FileAttribute[0]);
                                Path targetPath = copiedFilesPath.resolve(path2.getFileName());
                                CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                                Files.copy(path2, targetPath, copyOptionArray);
                                bl7 = copiedFiles.add(new CopiedFile(((Object)targetPath.toAbsolutePath().normalize()).toString()));
                                continue;
                            }
                            String mimeType = Files.probeContentType(path2);
                            Intrinsics.checkNotNull((Object)mimeType);
                            if (StringsKt.startsWith$default((String)mimeType, (String)"text/", (boolean)false, (int)2, null)) {
                                String string4 = Files.readString(path2);
                                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"readString(...)");
                                bl7 = loadedFiles.add(new OutputFileContent(mimeType, string4));
                                continue;
                            }
                            String string5 = Base64.getMimeEncoder().encodeToString(Files.readAllBytes(path2));
                            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"encodeToString(...)");
                            bl7 = loadedFiles.add(new OutputFileContent(mimeType, string5));
                        }
                    }
                }
            }
        }
        this.dockerClient.removeContainerCmd(containerId).exec();
        this.logger.info("Container removed {}", (Object)containerId);
        String string6 = outputBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"toString(...)");
        return new CodeExecutionResponse(string6, errorBuilder.toString(), loadedFiles, copiedFiles);
    }

    private final void pullImage() {
        this.logger.info("Start pulling image {}", (Object)this.config.getContainerImage());
        CountDownLatch pullImageCountDownLatch = new CountDownLatch(1);
        this.dockerClient.pullImageCmd(this.config.getContainerImage()).exec((ResultCallback)new ResultCallback<PullResponseItem>(this, pullImageCountDownLatch){
            final /* synthetic */ LLMCodeExecutor this$0;
            final /* synthetic */ CountDownLatch $pullImageCountDownLatch;
            {
                this.this$0 = $receiver;
                this.$pullImageCountDownLatch = $pullImageCountDownLatch;
            }

            public void close() {
            }

            public void onStart(Closeable closeable) {
            }

            public void onError(Throwable throwable) {
                LLMCodeExecutor.access$getLogger$p(this.this$0).error("Failed to pull image", throwable);
            }

            public void onComplete() {
                this.$pullImageCountDownLatch.countDown();
            }

            public void onNext(PullResponseItem object) {
            }
        });
        pullImageCountDownLatch.await(1L, TimeUnit.MINUTES);
        this.logger.info("Image pulled successfully");
    }

    public static final /* synthetic */ Logger access$getLogger$p(LLMCodeExecutor $this) {
        return $this.logger;
    }
}

