/*-
 * #%L
 * JSQLParser library
 * %%
 * Copyright (C) 2004 - 2019 JSQLParser
 * %%
 * Dual licensed under GNU LGPL 2.1 or Apache License 2.0
 * #L%
 */
package com.javaoffers.thrid.jsqlparser.expression.operators.relational;

import com.javaoffers.thrid.jsqlparser.expression.Expression;
import com.javaoffers.thrid.jsqlparser.expression.ExpressionVisitor;

public class NotEqualsTo extends ComparisonOperator {

    public NotEqualsTo() {
        super("<>");
    }

    public NotEqualsTo(String operator) {
        super(operator);
    }

    public NotEqualsTo(Expression left, Expression right) {
        this();
        setLeftExpression(left);
        setRightExpression(right);
    }

    @Override
    public NotEqualsTo withLeftExpression(Expression expression) {
        return (NotEqualsTo) super.withLeftExpression(expression);
    }

    @Override
    public NotEqualsTo withRightExpression(Expression expression) {
        return (NotEqualsTo) super.withRightExpression(expression);
    }

    @Override
    public void accept(ExpressionVisitor expressionVisitor) {
        expressionVisitor.visit(this);
    }

    @Override
    public NotEqualsTo withOldOracleJoinSyntax(int arg0) {
        return (NotEqualsTo) super.withOldOracleJoinSyntax(arg0);
    }

    @Override
    public NotEqualsTo withOraclePriorPosition(int arg0) {
        return (NotEqualsTo) super.withOraclePriorPosition(arg0);
    }
}
