/*-
 * #%L
 * JSQLParser library
 * %%
 * Copyright (C) 2004 - 2022 JSQLParser
 * %%
 * Dual licensed under GNU LGPL 2.1 or Apache License 2.0
 * #L%
 */
/* CCJSqlParser.java */
/* Generated By:JJTree&JavaCC: Do not edit this line. CCJSqlParser.java */
package com.javaoffers.thrid.jsqlparser.parser;

import com.javaoffers.thrid.jsqlparser.expression.*;
import com.javaoffers.thrid.jsqlparser.expression.operators.arithmetic.*;
import com.javaoffers.thrid.jsqlparser.expression.operators.conditional.*;
import com.javaoffers.thrid.jsqlparser.expression.operators.relational.*;
import com.javaoffers.thrid.jsqlparser.parser.feature.*;
import com.javaoffers.thrid.jsqlparser.schema.*;
import com.javaoffers.thrid.jsqlparser.statement.*;
import com.javaoffers.thrid.jsqlparser.statement.alter.*;
import com.javaoffers.thrid.jsqlparser.statement.alter.sequence.*;
import com.javaoffers.thrid.jsqlparser.statement.comment.Comment;
import com.javaoffers.thrid.jsqlparser.statement.create.function.CreateFunction;
import com.javaoffers.thrid.jsqlparser.statement.create.index.CreateIndex;
import com.javaoffers.thrid.jsqlparser.statement.create.procedure.CreateProcedure;
import com.javaoffers.thrid.jsqlparser.statement.create.schema.*;
import com.javaoffers.thrid.jsqlparser.statement.create.sequence.*;
import com.javaoffers.thrid.jsqlparser.statement.create.synonym.*;
import com.javaoffers.thrid.jsqlparser.statement.create.table.*;
import com.javaoffers.thrid.jsqlparser.statement.create.view.*;
import com.javaoffers.thrid.jsqlparser.statement.delete.*;
import com.javaoffers.thrid.jsqlparser.statement.drop.*;
import com.javaoffers.thrid.jsqlparser.statement.execute.*;
import com.javaoffers.thrid.jsqlparser.statement.grant.*;
import com.javaoffers.thrid.jsqlparser.statement.insert.*;
import com.javaoffers.thrid.jsqlparser.statement.merge.*;
import com.javaoffers.thrid.jsqlparser.statement.replace.*;
import com.javaoffers.thrid.jsqlparser.statement.select.*;
import com.javaoffers.thrid.jsqlparser.statement.show.*;
import com.javaoffers.thrid.jsqlparser.statement.truncate.*;
import com.javaoffers.thrid.jsqlparser.statement.update.*;
import com.javaoffers.thrid.jsqlparser.statement.upsert.*;
import com.javaoffers.thrid.jsqlparser.statement.values.*;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;

/**
 * The com.javaoffers.thrid.sqlparse.parser generated by JavaCC
 */
public class CCJSqlParser extends AbstractJSqlParser<CCJSqlParser>/*@bgen(jjtree)*/implements CCJSqlParserTreeConstants, CCJSqlParserConstants {/*@bgen(jjtree)*/
  protected JJTCCJSqlParserState jjtree = new JJTCCJSqlParserState();public int bracketsCounter = 0;
    public int caseCounter = 0;

    public CCJSqlParser withConfiguration(FeatureConfiguration configuration) {
        token_source.configuration = configuration;
        return this;
    }

    public FeatureConfiguration getConfiguration() {
        return token_source.configuration;
    }

    public CCJSqlParser me () {
        return this;
    }

    private void linkAST(ASTNodeAccess access, SimpleNode node) {
        access.setASTNode(node);
        node.jjtSetValue(access);
    }

    public Node getASTRoot() {
        return jjtree.rootNode();
    }

  final public Statement Statement() throws ParseException {/*@bgen(jjtree) Statement */
    SimpleNode jjtn000 = new SimpleNode(JJTSTATEMENT);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));
    IfElseStatement ifElseStatement = null;
    Statement stm = null;
    Statement stm2 = null;
    Expression condition;
    try {
      try {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_IF:{
          jj_consume_token(K_IF);
          condition = Condition();
          stm = SingleStatement();
ifElseStatement = new IfElseStatement(condition, stm);
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case ST_SEMICOLON:{
            jj_consume_token(ST_SEMICOLON);
ifElseStatement.setUsingSemicolonForIfStatement(true);
            break;
            }
          default:
            jj_la1[0] = jj_gen;
            ;
          }
          if (jj_2_1(2)) {
            jj_consume_token(K_ELSE);
            stm2 = SingleStatement();
ifElseStatement.setElseStatement(stm2);
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case ST_SEMICOLON:{
              jj_consume_token(ST_SEMICOLON);
ifElseStatement.setUsingSemicolonForElseStatement(true);
              break;
              }
            default:
              jj_la1[1] = jj_gen;
              ;
            }
          } else {
            ;
          }
          jj_consume_token(0);
          break;
          }
        case K_ALTER:
        case K_CALL:
        case K_COMMIT:
        case K_COMMENT:
        case K_CREATE:
        case K_DECLARE:
        case K_DELETE:
        case K_DESCRIBE:
        case K_DROP:
        case K_EXEC:
        case K_EXECUTE:
        case K_EXPLAIN:
        case K_GRANT:
        case K_INSERT:
        case K_MERGE:
        case K_PURGE:
        case K_RENAME:
        case K_REPLACE:
        case K_ROLLBACK:
        case K_SAVEPOINT:
        case K_SELECT:
        case K_SET:
        case K_RESET:
        case K_SHOW:
        case K_TRUNCATE:
        case K_UPDATE:
        case K_UPSERT:
        case K_USE:
        case K_VALUES:
        case K_WITH:
        case 325:{
          stm = SingleStatement();
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case ST_SEMICOLON:{
            jj_consume_token(ST_SEMICOLON);
            break;
            }
          default:
            jj_la1[2] = jj_gen;
            ;
          }
          jj_consume_token(0);
          break;
          }
        default:
          jj_la1[3] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      } catch (ParseException e) {
if (errorRecovery) {
            parseErrors.add(e);
            error_skipto(ST_SEMICOLON);
        }
        else
            {if (true) throw e;}
      }
jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
          jjtn000.jjtSetLastToken(getToken(0));
return ifElseStatement!=null ? ifElseStatement : stm;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return com.javaoffers.thrid.sqlparse.statement in function");
}

  final public Statement SingleStatement() throws ParseException {Statement stm = null;
    List<WithItem> with = null;
    try {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_DELETE:
      case K_INSERT:
      case K_MERGE:
      case K_SELECT:
      case K_UPDATE:
      case K_VALUES:
      case K_WITH:
      case 325:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_WITH:{
          with = WithList();

          break;
          }
        default:
          jj_la1[4] = jj_gen;
          ;
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_SELECT:
        case K_VALUES:
        case 325:{
          stm = Select(with);
          break;
          }
        case K_INSERT:{
          stm = Insert(with);
          break;
          }
        case K_UPDATE:{
          stm = Update(with);
          break;
          }
        case K_DELETE:{
          stm = Delete(with);
          break;
          }
        case K_MERGE:{
          stm = Merge(with);
          break;
          }
        default:
          jj_la1[5] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      case K_UPSERT:{
        stm = Upsert();
        break;
        }
      default:
        jj_la1[6] = jj_gen;
        if (jj_2_2(3)) {
          stm = Replace();
        } else if (jj_2_3(2)) {
          stm = AlterTable();
        } else if (jj_2_4(2)) {
          stm = AlterSession();
        } else if (jj_2_5(2147483647)) {
          stm = CreateFunctionStatement();
        } else if (jj_2_6(2147483647)) {
          stm = CreateIndex();
        } else if (jj_2_7(2147483647)) {
          stm = CreateSchema();
        } else if (jj_2_8(2147483647)) {
          stm = CreateSequence();
        } else if (jj_2_9(2147483647)) {
          stm = CreateSynonym();
        } else if (jj_2_10(2147483647)) {
          stm = CreateTable();
        } else if (jj_2_11(2147483647)) {
          stm = CreateView();
        } else if (jj_2_12(2147483647)) {
          stm = AlterView();
        } else if (jj_2_13(2147483647)) {
          stm = AlterSequence();
        } else {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_DROP:{
            stm = Drop();
            break;
            }
          case K_TRUNCATE:{
            stm = Truncate();
            break;
            }
          case K_CALL:
          case K_EXEC:
          case K_EXECUTE:{
            stm = Execute();
            break;
            }
          case K_SET:{
            stm = Set();
            break;
            }
          case K_RENAME:{
            stm = RenameTableStatement();
            break;
            }
          case K_RESET:{
            stm = Reset();
            break;
            }
          default:
            jj_la1[7] = jj_gen;
            if (jj_2_14(2147483647)) {
              stm = ShowColumns();
            } else if (jj_2_15(2147483647)) {
              stm = ShowTables();
            } else {
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case K_SHOW:{
                stm = Show();
                break;
                }
              case K_USE:{
                stm = Use();
                break;
                }
              case K_SAVEPOINT:{
                stm = SavepointStatement();
                break;
                }
              case K_ROLLBACK:{
                stm = RollbackStatement();
                break;
                }
              case K_COMMIT:{
                stm = Commit();
                break;
                }
              case K_COMMENT:{
                stm = Comment();
                break;
                }
              case K_DESCRIBE:{
                stm = Describe();
                break;
                }
              case K_EXPLAIN:{
                stm = Explain();
                break;
                }
              case K_DECLARE:{
                stm = Declare();
                break;
                }
              case K_GRANT:{
                stm = Grant();
                break;
                }
              case K_PURGE:{
                stm = PurgeStatement();
                break;
                }
              case K_ALTER:{
                stm = AlterSystemStatement();
                break;
                }
              default:
                jj_la1[8] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
              }
            }
          }
        }
      }
return stm;
    } catch (ParseException e) {
if (errorRecovery) {
            parseErrors.add(e);
            error_skipto(ST_SEMICOLON);
            return null;
        } else
            {if (true) throw e;}
    }
    throw new RuntimeException("Missing return com.javaoffers.thrid.sqlparse.statement in function");
}

  final public Block Block() throws ParseException {/*@bgen(jjtree) Block */
    SimpleNode jjtn000 = new SimpleNode(JJTBLOCK);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));Statements stmts = new Statements();
    List<Statement> list = new ArrayList<Statement>();
    Statement stm;
    Block block = new Block();
    try {
      jj_consume_token(K_BEGIN);
      label_1:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case ST_SEMICOLON:{
          ;
          break;
          }
        default:
          jj_la1[9] = jj_gen;
          break label_1;
        }
        jj_consume_token(ST_SEMICOLON);
      }
      try {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_ALTER:
        case K_CALL:
        case K_COMMIT:
        case K_COMMENT:
        case K_CREATE:
        case K_DECLARE:
        case K_DELETE:
        case K_DESCRIBE:
        case K_DROP:
        case K_EXEC:
        case K_EXECUTE:
        case K_EXPLAIN:
        case K_GRANT:
        case K_INSERT:
        case K_MERGE:
        case K_PURGE:
        case K_RENAME:
        case K_REPLACE:
        case K_ROLLBACK:
        case K_SAVEPOINT:
        case K_SELECT:
        case K_SET:
        case K_RESET:
        case K_SHOW:
        case K_TRUNCATE:
        case K_UPDATE:
        case K_UPSERT:
        case K_USE:
        case K_VALUES:
        case K_WITH:
        case 325:{
          stm = SingleStatement();
          break;
          }
        case K_BEGIN:{
          stm = Block();
          break;
          }
        default:
          jj_la1[10] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
list.add(stm);
        jj_consume_token(ST_SEMICOLON);
        label_2:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_ALTER:
          case K_BEGIN:
          case K_CALL:
          case K_COMMIT:
          case K_COMMENT:
          case K_CREATE:
          case K_DECLARE:
          case K_DELETE:
          case K_DESCRIBE:
          case K_DROP:
          case K_EXEC:
          case K_EXECUTE:
          case K_EXPLAIN:
          case K_GRANT:
          case K_INSERT:
          case K_MERGE:
          case K_PURGE:
          case K_RENAME:
          case K_REPLACE:
          case K_ROLLBACK:
          case K_SAVEPOINT:
          case K_SELECT:
          case K_SET:
          case K_RESET:
          case K_SHOW:
          case K_TRUNCATE:
          case K_UPDATE:
          case K_UPSERT:
          case K_USE:
          case K_VALUES:
          case K_WITH:
          case 325:{
            ;
            break;
            }
          default:
            jj_la1[11] = jj_gen;
            break label_2;
          }
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_ALTER:
          case K_CALL:
          case K_COMMIT:
          case K_COMMENT:
          case K_CREATE:
          case K_DECLARE:
          case K_DELETE:
          case K_DESCRIBE:
          case K_DROP:
          case K_EXEC:
          case K_EXECUTE:
          case K_EXPLAIN:
          case K_GRANT:
          case K_INSERT:
          case K_MERGE:
          case K_PURGE:
          case K_RENAME:
          case K_REPLACE:
          case K_ROLLBACK:
          case K_SAVEPOINT:
          case K_SELECT:
          case K_SET:
          case K_RESET:
          case K_SHOW:
          case K_TRUNCATE:
          case K_UPDATE:
          case K_UPSERT:
          case K_USE:
          case K_VALUES:
          case K_WITH:
          case 325:{
            stm = SingleStatement();
            break;
            }
          case K_BEGIN:{
            stm = Block();
            break;
            }
          default:
            jj_la1[12] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          jj_consume_token(ST_SEMICOLON);
list.add(stm);
        }
      } catch (ParseException e) {
if (errorRecovery) {
            parseErrors.add(e);
            error_skipto(ST_SEMICOLON);
        } else {
            {if (true) throw e;}
        }
      }
stmts.setStatements(list);
        block.setStatements(stmts);
      jj_consume_token(K_END);
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
return block;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return com.javaoffers.thrid.sqlparse.statement in function");
}

  final public Statements Statements() throws ParseException {/*@bgen(jjtree) Statements */
    SimpleNode jjtn000 = new SimpleNode(JJTSTATEMENTS);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));Statements stmts = new Statements();
    List<Statement> list = new ArrayList<Statement>();

    IfElseStatement ifElseStatement = null;
    Statement stm = null;
    Statement stm2 = null;
    Expression condition;
    try {
      label_3:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case ST_SEMICOLON:{
          ;
          break;
          }
        default:
          jj_la1[13] = jj_gen;
          break label_3;
        }
        jj_consume_token(ST_SEMICOLON);
      }
      try {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_IF:{
          jj_consume_token(K_IF);
          condition = Condition();
          stm = SingleStatement();
ifElseStatement = new IfElseStatement(condition, stm);
          if (jj_2_16(2)) {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case ST_SEMICOLON:{
              jj_consume_token(ST_SEMICOLON);
ifElseStatement.setUsingSemicolonForIfStatement(true);
              break;
              }
            default:
              jj_la1[14] = jj_gen;
              ;
            }
            jj_consume_token(K_ELSE);
            stm2 = SingleStatement();
ifElseStatement.setElseStatement(stm2);
          } else {
            ;
          }
list.add( ifElseStatement );
          break;
          }
        case K_ALTER:
        case K_BEGIN:
        case K_CALL:
        case K_COMMIT:
        case K_COMMENT:
        case K_CREATE:
        case K_DECLARE:
        case K_DELETE:
        case K_DESCRIBE:
        case K_DROP:
        case K_EXEC:
        case K_EXECUTE:
        case K_EXPLAIN:
        case K_GRANT:
        case K_INSERT:
        case K_MERGE:
        case K_PURGE:
        case K_RENAME:
        case K_REPLACE:
        case K_ROLLBACK:
        case K_SAVEPOINT:
        case K_SELECT:
        case K_SET:
        case K_RESET:
        case K_SHOW:
        case K_TRUNCATE:
        case K_UPDATE:
        case K_UPSERT:
        case K_USE:
        case K_VALUES:
        case K_WITH:
        case 325:{
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_ALTER:
          case K_CALL:
          case K_COMMIT:
          case K_COMMENT:
          case K_CREATE:
          case K_DECLARE:
          case K_DELETE:
          case K_DESCRIBE:
          case K_DROP:
          case K_EXEC:
          case K_EXECUTE:
          case K_EXPLAIN:
          case K_GRANT:
          case K_INSERT:
          case K_MERGE:
          case K_PURGE:
          case K_RENAME:
          case K_REPLACE:
          case K_ROLLBACK:
          case K_SAVEPOINT:
          case K_SELECT:
          case K_SET:
          case K_RESET:
          case K_SHOW:
          case K_TRUNCATE:
          case K_UPDATE:
          case K_UPSERT:
          case K_USE:
          case K_VALUES:
          case K_WITH:
          case 325:{
            stm = SingleStatement();
            break;
            }
          case K_BEGIN:{
            stm = Block();
            if (jj_2_17(2)) {
              jj_consume_token(ST_SEMICOLON);
            } else {
              ;
            }
            break;
            }
          default:
            jj_la1[15] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
list.add(stm);
          break;
          }
        default:
          jj_la1[16] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        label_4:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case ST_SEMICOLON:{
            ;
            break;
            }
          default:
            jj_la1[17] = jj_gen;
            break label_4;
          }
          jj_consume_token(ST_SEMICOLON);
if (stm2!=null)
                                ifElseStatement.setUsingSemicolonForElseStatement(true);
                             else if (ifElseStatement!=null)
                                ifElseStatement.setUsingSemicolonForIfStatement(true);
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_ALTER:
          case K_BEGIN:
          case K_CALL:
          case K_COMMIT:
          case K_COMMENT:
          case K_CREATE:
          case K_DECLARE:
          case K_DELETE:
          case K_DESCRIBE:
          case K_DROP:
          case K_EXEC:
          case K_EXECUTE:
          case K_EXPLAIN:
          case K_GRANT:
          case K_IF:
          case K_INSERT:
          case K_MERGE:
          case K_PURGE:
          case K_RENAME:
          case K_REPLACE:
          case K_ROLLBACK:
          case K_SAVEPOINT:
          case K_SELECT:
          case K_SET:
          case K_RESET:
          case K_SHOW:
          case K_TRUNCATE:
          case K_UPDATE:
          case K_UPSERT:
          case K_USE:
          case K_VALUES:
          case K_WITH:
          case 325:{
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_IF:{
              jj_consume_token(K_IF);
              condition = Condition();
              stm = SingleStatement();
ifElseStatement = new IfElseStatement(condition, stm);
              if (jj_2_18(2)) {
                switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
                case ST_SEMICOLON:{
                  jj_consume_token(ST_SEMICOLON);
ifElseStatement.setUsingSemicolonForIfStatement(true);
                  break;
                  }
                default:
                  jj_la1[18] = jj_gen;
                  ;
                }
                jj_consume_token(K_ELSE);
                stm2 = SingleStatement();
ifElseStatement.setElseStatement(stm2);
              } else {
                ;
              }
list.add( ifElseStatement );
              break;
              }
            case K_ALTER:
            case K_BEGIN:
            case K_CALL:
            case K_COMMIT:
            case K_COMMENT:
            case K_CREATE:
            case K_DECLARE:
            case K_DELETE:
            case K_DESCRIBE:
            case K_DROP:
            case K_EXEC:
            case K_EXECUTE:
            case K_EXPLAIN:
            case K_GRANT:
            case K_INSERT:
            case K_MERGE:
            case K_PURGE:
            case K_RENAME:
            case K_REPLACE:
            case K_ROLLBACK:
            case K_SAVEPOINT:
            case K_SELECT:
            case K_SET:
            case K_RESET:
            case K_SHOW:
            case K_TRUNCATE:
            case K_UPDATE:
            case K_UPSERT:
            case K_USE:
            case K_VALUES:
            case K_WITH:
            case 325:{
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case K_ALTER:
              case K_CALL:
              case K_COMMIT:
              case K_COMMENT:
              case K_CREATE:
              case K_DECLARE:
              case K_DELETE:
              case K_DESCRIBE:
              case K_DROP:
              case K_EXEC:
              case K_EXECUTE:
              case K_EXPLAIN:
              case K_GRANT:
              case K_INSERT:
              case K_MERGE:
              case K_PURGE:
              case K_RENAME:
              case K_REPLACE:
              case K_ROLLBACK:
              case K_SAVEPOINT:
              case K_SELECT:
              case K_SET:
              case K_RESET:
              case K_SHOW:
              case K_TRUNCATE:
              case K_UPDATE:
              case K_UPSERT:
              case K_USE:
              case K_VALUES:
              case K_WITH:
              case 325:{
                stm = SingleStatement();
                break;
                }
              case K_BEGIN:{
                stm = Block();
                if (jj_2_19(2)) {
                  jj_consume_token(ST_SEMICOLON);
                } else {
                  ;
                }
                break;
                }
              default:
                jj_la1[19] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
              }
list.add(stm);
              break;
              }
            default:
              jj_la1[20] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
            break;
            }
          default:
            jj_la1[21] = jj_gen;
            ;
          }
        }
        jj_consume_token(0);
      } catch (ParseException e) {
if (errorRecovery) {
            parseErrors.add(e);
            error_skipto(ST_SEMICOLON);
        } else {
            {if (true) throw e;}
        }
      }
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
return stmts.withStatements(list);
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return com.javaoffers.thrid.sqlparse.statement in function");
}

  void error_skipto(int kind) throws ParseException {ParseException e = generateParseException();
  Token t;
  do {
    t = getNextToken();
  } while (t.kind != kind && t.kind != EOF);
  }

  final public DeclareStatement Declare() throws ParseException {UserVariable userVariable;
    ColDataType colDataType;
    Expression defaultExpr = null;
    DeclareStatement stmt = new DeclareStatement();
    String typeName;
    String columnName;
    ColumnDefinition colDef;
    jj_consume_token(K_DECLARE);
    userVariable = UserVariable();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_TABLE:{
      jj_consume_token(K_TABLE);
      jj_consume_token(325);
      colDef = ColumnDefinition();
stmt.withUserVariable(userVariable)
        .withDeclareType(DeclareType.TABLE)
        .addColumnDefinition(colDef);
      label_5:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_COMMA:{
          ;
          break;
          }
        default:
          jj_la1[22] = jj_gen;
          break label_5;
        }
        jj_consume_token(K_COMMA);
        colDef = ColumnDefinition();
stmt.addColumnDefinition(colDef);
      }
      jj_consume_token(326);
      break;
      }
    case K_AS:{
      jj_consume_token(K_AS);
      typeName = RelObjectName();
stmt.withUserVariable(userVariable)
                      .withDeclareType(DeclareType.AS)
                      .withTypeName(typeName);
      break;
      }
    case K_BINARY:
    case K_BIT:
    case K_CHARACTER:
    case K_CHAR:
    case K_DATETIMELITERAL:
    case K_DATE_LITERAL:
    case K_DOUBLE:
    case K_INTERVAL:
    case K_JSON:
    case K_SET:
    case K_SIGNED:
    case K_UNSIGNED:
    case K_XML:
    case DT_ZONE:
    case S_IDENTIFIER:
    case S_QUOTED_IDENTIFIER:{
      colDataType = ColDataType();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 327:{
        jj_consume_token(327);
        defaultExpr = Expression();
        break;
        }
      default:
        jj_la1[23] = jj_gen;
        ;
      }
stmt.withDeclareType(DeclareType.TYPE)
                  .addType(userVariable, colDataType, defaultExpr);
      label_6:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_COMMA:{
          ;
          break;
          }
        default:
          jj_la1[24] = jj_gen;
          break label_6;
        }
        jj_consume_token(K_COMMA);
        userVariable = UserVariable();
        colDataType = ColDataType();
defaultExpr = null;
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 327:{
          jj_consume_token(327);
          defaultExpr = Expression();
          break;
          }
        default:
          jj_la1[25] = jj_gen;
          ;
        }
stmt.addType(userVariable, colDataType, defaultExpr);
      }
      break;
      }
    default:
      jj_la1[26] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return stmt;
}

  final public SetStatement Set() throws ParseException {String name;
    ArrayList<Expression> expList;
    boolean useEqual = false;
    SetStatement set;
    Expression exp = null;
    Token tk = null;
    String effectParameter = null;
    jj_consume_token(K_SET);
    if (jj_2_20(3)) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_LOCAL:{
        tk = jj_consume_token(K_LOCAL);
        break;
        }
      case K_SESSION:{
        tk = jj_consume_token(K_SESSION);
        break;
        }
      default:
        jj_la1[27] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
effectParameter = tk.image;
    } else {
      ;
    }
    if (jj_2_21(2)) {
      jj_consume_token(K_DATETIMELITERAL);
      jj_consume_token(K_ZONE);
name = "Time Zone"; useEqual=false;
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ACTION:
      case K_ACTIVE:
      case K_ALGORITHM:
      case K_ALL:
      case K_ANY:
      case K_ARCHIVE:
      case K_ARRAY_LITERAL:
      case K_AT:
      case K_BYTE:
      case K_CASCADE:
      case K_CASE:
      case K_CASEWHEN:
      case K_CAST:
      case K_TRY_CAST:
      case K_CHARACTER:
      case K_CHANGE:
      case K_CHECKPOINT:
      case K_CHAR:
      case K_COLUMN:
      case K_COLUMNS:
      case K_COMMIT:
      case K_COMMENT:
      case K_COSTS:
      case K_CREATE:
      case K_CYCLE:
      case K_DATETIMELITERAL:
      case K_DATE_LITERAL:
      case K_DBA_RECYCLEBIN:
      case K_DEFAULT:
      case K_DESC:
      case K_DESCRIBE:
      case K_DISABLE:
      case K_DISCONNECT:
      case K_DIV:
      case K_DO:
      case K_DOUBLE:
      case K_DUMP:
      case K_DUPLICATE:
      case K_ENABLE:
      case K_END:
      case K_EXCLUDE:
      case K_EXTRACT:
      case K_FILTER:
      case K_FIRST:
      case K_FALSE:
      case K_FLUSH:
      case K_FOLLOWING:
      case K_FORMAT:
      case K_FULLTEXT:
      case K_GROUP:
      case K_GROUPING:
      case K_HISTORY:
      case K_IF:
      case K_IIF:
      case K_IN:
      case K_INDEX:
      case K_INSERT:
      case K_INTERVAL:
      case K_ISNULL:
      case K_JSON:
      case K_KEY:
      case K_FN:
      case K_LAST:
      case K_LEADING:
      case K_LEFT:
      case K_LIMIT:
      case K_LOCAL:
      case K_LINK:
      case K_LOG:
      case K_MATERIALIZED:
      case K_NEXTVAL:
      case K_NO:
      case K_NOLOCK:
      case K_NULLS:
      case K_OF:
      case K_OFFSET:
      case K_ON:
      case K_OPEN:
      case K_ORDER:
      case K_OVER:
      case K_OPTIMIZE:
      case K_PARALLEL:
      case K_PARTITION:
      case K_PATH:
      case K_PERCENT:
      case K_PRECISION:
      case K_PRIMARY:
      case K_PRIOR:
      case K_PROCEDURE:
      case K_PUBLIC:
      case K_QUERY:
      case K_QUIESCE:
      case K_RANGE:
      case K_READ:
      case K_RECYCLEBIN:
      case K_REGISTER:
      case K_REPLACE:
      case K_RESUME:
      case K_RESTRICTED:
      case K_RIGHT:
      case K_ROW:
      case K_ROWS:
      case K_SCHEMA:
      case K_SEQUENCE:
      case K_SEPARATOR:
      case K_SESSION:
      case K_SET:
      case K_SHUTDOWN:
      case K_SIBLINGS:
      case K_SIZE:
      case K_SKIP:
      case K_SOME:
      case K_START:
      case K_SUSPEND:
      case K_SWITCH:
      case K_SYNONYM:
      case K_SYSTEM:
      case K_TABLE:
      case K_TABLES:
      case K_TABLESPACE:
      case K_TEMP:
      case K_TEMPORARY:
      case K_TIMEOUT:
      case K_TO:
      case K_TOP:
      case K_TRUNCATE:
      case K_TRUE:
      case K_TYPE:
      case K_UNQIESCE:
      case K_USER:
      case K_SIGNED:
      case K_STRING_FUNCTION_NAME:
      case K_UNSIGNED:
      case K_VALIDATE:
      case K_VALUE:
      case K_VALUES:
      case K_VIEW:
      case K_XML:
      case K_ZONE:
      case S_IDENTIFIER:
      case S_QUOTED_IDENTIFIER:{
        name = RelObjectNameExt();
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 327:{
          jj_consume_token(327);
useEqual=true;
          break;
          }
        default:
          jj_la1[28] = jj_gen;
          ;
        }
        break;
        }
      default:
        jj_la1[29] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    exp = SimpleExpression();
expList = new ArrayList<Expression>(); expList.add(exp);
set = new SetStatement(name,expList).withUseEqual(useEqual).withEffectParameter(effectParameter);
    label_7:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COMMA:{
        ;
        break;
        }
      default:
        jj_la1[30] = jj_gen;
        break label_7;
      }
useEqual=false;
      jj_consume_token(K_COMMA);
      if (jj_2_23(3)) {
        if (jj_2_22(2)) {
          jj_consume_token(K_DATETIMELITERAL);
          jj_consume_token(K_ZONE);
name = "Time Zone"; useEqual=false;
        } else {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_ACTION:
          case K_ACTIVE:
          case K_ALGORITHM:
          case K_ALL:
          case K_ANY:
          case K_ARCHIVE:
          case K_ARRAY_LITERAL:
          case K_AT:
          case K_BYTE:
          case K_CASCADE:
          case K_CASE:
          case K_CASEWHEN:
          case K_CAST:
          case K_TRY_CAST:
          case K_CHARACTER:
          case K_CHANGE:
          case K_CHECKPOINT:
          case K_CHAR:
          case K_COLUMN:
          case K_COLUMNS:
          case K_COMMIT:
          case K_COMMENT:
          case K_COSTS:
          case K_CREATE:
          case K_CYCLE:
          case K_DATETIMELITERAL:
          case K_DATE_LITERAL:
          case K_DBA_RECYCLEBIN:
          case K_DEFAULT:
          case K_DESC:
          case K_DESCRIBE:
          case K_DISABLE:
          case K_DISCONNECT:
          case K_DIV:
          case K_DO:
          case K_DOUBLE:
          case K_DUMP:
          case K_DUPLICATE:
          case K_ENABLE:
          case K_END:
          case K_EXCLUDE:
          case K_EXTRACT:
          case K_FILTER:
          case K_FIRST:
          case K_FALSE:
          case K_FLUSH:
          case K_FOLLOWING:
          case K_FORMAT:
          case K_FULLTEXT:
          case K_GROUP:
          case K_GROUPING:
          case K_HISTORY:
          case K_IF:
          case K_IIF:
          case K_IN:
          case K_INDEX:
          case K_INSERT:
          case K_INTERVAL:
          case K_ISNULL:
          case K_JSON:
          case K_KEY:
          case K_FN:
          case K_LAST:
          case K_LEADING:
          case K_LEFT:
          case K_LIMIT:
          case K_LOCAL:
          case K_LINK:
          case K_LOG:
          case K_MATERIALIZED:
          case K_NEXTVAL:
          case K_NO:
          case K_NOLOCK:
          case K_NULLS:
          case K_OF:
          case K_OFFSET:
          case K_ON:
          case K_OPEN:
          case K_ORDER:
          case K_OVER:
          case K_OPTIMIZE:
          case K_PARALLEL:
          case K_PARTITION:
          case K_PATH:
          case K_PERCENT:
          case K_PRECISION:
          case K_PRIMARY:
          case K_PRIOR:
          case K_PROCEDURE:
          case K_PUBLIC:
          case K_QUERY:
          case K_QUIESCE:
          case K_RANGE:
          case K_READ:
          case K_RECYCLEBIN:
          case K_REGISTER:
          case K_REPLACE:
          case K_RESUME:
          case K_RESTRICTED:
          case K_RIGHT:
          case K_ROW:
          case K_ROWS:
          case K_SCHEMA:
          case K_SEQUENCE:
          case K_SEPARATOR:
          case K_SESSION:
          case K_SET:
          case K_SHUTDOWN:
          case K_SIBLINGS:
          case K_SIZE:
          case K_SKIP:
          case K_SOME:
          case K_START:
          case K_SUSPEND:
          case K_SWITCH:
          case K_SYNONYM:
          case K_SYSTEM:
          case K_TABLE:
          case K_TABLES:
          case K_TABLESPACE:
          case K_TEMP:
          case K_TEMPORARY:
          case K_TIMEOUT:
          case K_TO:
          case K_TOP:
          case K_TRUNCATE:
          case K_TRUE:
          case K_TYPE:
          case K_UNQIESCE:
          case K_USER:
          case K_SIGNED:
          case K_STRING_FUNCTION_NAME:
          case K_UNSIGNED:
          case K_VALIDATE:
          case K_VALUE:
          case K_VALUES:
          case K_VIEW:
          case K_XML:
          case K_ZONE:
          case S_IDENTIFIER:
          case S_QUOTED_IDENTIFIER:{
            name = RelObjectNameExt();
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case 327:{
              jj_consume_token(327);
useEqual=true;
              break;
              }
            default:
              jj_la1[31] = jj_gen;
              ;
            }
            break;
            }
          default:
            jj_la1[32] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
        exp = SimpleExpression();
expList = new ArrayList<Expression>();
                expList.add(exp);
                set.add(name, expList, useEqual);
      } else if (jj_2_24(1)) {
        exp = SimpleExpression();
expList.add(exp);
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
return set;
}

  final public ResetStatement Reset() throws ParseException {String name;
    ResetStatement reset;
    Token all;
    jj_consume_token(K_RESET);
    if (jj_2_25(2)) {
      jj_consume_token(K_DATETIMELITERAL);
      jj_consume_token(K_ZONE);
name = "Time Zone";
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ACTION:
      case K_ACTIVE:
      case K_ALGORITHM:
      case K_ARCHIVE:
      case K_ARRAY_LITERAL:
      case K_AT:
      case K_BYTE:
      case K_CASCADE:
      case K_CASE:
      case K_CAST:
      case K_TRY_CAST:
      case K_CHARACTER:
      case K_CHANGE:
      case K_CHECKPOINT:
      case K_CHAR:
      case K_COLUMN:
      case K_COLUMNS:
      case K_COMMIT:
      case K_COMMENT:
      case K_COSTS:
      case K_CREATE:
      case K_CYCLE:
      case K_DATETIMELITERAL:
      case K_DATE_LITERAL:
      case K_DBA_RECYCLEBIN:
      case K_DEFAULT:
      case K_DESC:
      case K_DESCRIBE:
      case K_DISABLE:
      case K_DISCONNECT:
      case K_DIV:
      case K_DO:
      case K_DUMP:
      case K_DUPLICATE:
      case K_ENABLE:
      case K_END:
      case K_EXCLUDE:
      case K_EXTRACT:
      case K_FILTER:
      case K_FIRST:
      case K_FALSE:
      case K_FLUSH:
      case K_FOLLOWING:
      case K_FORMAT:
      case K_FULLTEXT:
      case K_GROUP:
      case K_HISTORY:
      case K_INDEX:
      case K_INSERT:
      case K_INTERVAL:
      case K_ISNULL:
      case K_JSON:
      case K_KEY:
      case K_FN:
      case K_LAST:
      case K_LEADING:
      case K_LOCAL:
      case K_LINK:
      case K_LOG:
      case K_MATERIALIZED:
      case K_NEXTVAL:
      case K_NO:
      case K_NOLOCK:
      case K_NULLS:
      case K_OF:
      case K_ON:
      case K_OPEN:
      case K_ORDER:
      case K_OVER:
      case K_PARALLEL:
      case K_PARTITION:
      case K_PATH:
      case K_PERCENT:
      case K_PRECISION:
      case K_PRIMARY:
      case K_PRIOR:
      case K_QUERY:
      case K_QUIESCE:
      case K_RANGE:
      case K_READ:
      case K_RECYCLEBIN:
      case K_REGISTER:
      case K_REPLACE:
      case K_RESUME:
      case K_RESTRICTED:
      case K_ROW:
      case K_ROWS:
      case K_SCHEMA:
      case K_SEQUENCE:
      case K_SEPARATOR:
      case K_SESSION:
      case K_SHUTDOWN:
      case K_SIBLINGS:
      case K_SIZE:
      case K_SKIP:
      case K_START:
      case K_SUSPEND:
      case K_SWITCH:
      case K_SYNONYM:
      case K_SYSTEM:
      case K_TABLE:
      case K_TABLES:
      case K_TABLESPACE:
      case K_TEMP:
      case K_TEMPORARY:
      case K_TIMEOUT:
      case K_TO:
      case K_TOP:
      case K_TRUNCATE:
      case K_TRUE:
      case K_TYPE:
      case K_UNQIESCE:
      case K_USER:
      case K_SIGNED:
      case K_STRING_FUNCTION_NAME:
      case K_UNSIGNED:
      case K_VALIDATE:
      case K_VALUE:
      case K_VALUES:
      case K_VIEW:
      case K_XML:
      case K_ZONE:
      case S_IDENTIFIER:
      case S_QUOTED_IDENTIFIER:{
        name = RelObjectName();
        break;
        }
      case K_ALL:{
        all = jj_consume_token(K_ALL);
name = all.image;
        break;
        }
      default:
        jj_la1[33] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
reset = new ResetStatement(name);
return reset;
}

  final public RenameTableStatement RenameTableStatement() throws ParseException {RenameTableStatement renameTableStatement;
    Table oldName;
    Table newName;
    boolean usingTableKeyword=false;
    boolean usesIfExistsKeyword=false;
    String waitDirective = "";
    Token token;
    jj_consume_token(K_RENAME);
    if (jj_2_26(2)) {
      jj_consume_token(K_TABLE);
usingTableKeyword = true;
    } else {
      ;
    }
    if (jj_2_27(2)) {
      jj_consume_token(K_IF);
      jj_consume_token(K_EXISTS);
usesIfExistsKeyword = true;
    } else {
      ;
    }
    oldName = Table();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_NOWAIT:
    case K_WAIT:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_WAIT:{
        jj_consume_token(K_WAIT);
        token = jj_consume_token(S_LONG);
waitDirective = "WAIT " + token.image;
        break;
        }
      case K_NOWAIT:{
        jj_consume_token(K_NOWAIT);
waitDirective = "NOWAIT";
        break;
        }
      default:
        jj_la1[34] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[35] = jj_gen;
      ;
    }
    jj_consume_token(K_TO);
    newName = Table();
renameTableStatement = new RenameTableStatement(oldName, newName, usingTableKeyword, usesIfExistsKeyword, waitDirective);
    label_8:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COMMA:{
        ;
        break;
        }
      default:
        jj_la1[36] = jj_gen;
        break label_8;
      }
      jj_consume_token(K_COMMA);
      oldName = Table();
      jj_consume_token(K_TO);
      newName = Table();
renameTableStatement.addTableNames(oldName, newName);
    }
return renameTableStatement;
}

  final public PurgeStatement PurgeStatement() throws ParseException {PurgeStatement purgeStatement = null;
    Table table;
    Index index;
    Token tableSpaceToken;
    Token userToken = null;
    jj_consume_token(K_PURGE);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_TABLE:{
      jj_consume_token(K_TABLE);
      table = Table();
purgeStatement = new PurgeStatement(table);
      break;
      }
    case K_INDEX:{
      jj_consume_token(K_INDEX);
      index = Index();
purgeStatement = new PurgeStatement(index);
      break;
      }
    case K_RECYCLEBIN:{
      jj_consume_token(K_RECYCLEBIN);
purgeStatement = new PurgeStatement(PurgeObjectType.RECYCLEBIN);
      break;
      }
    case K_DBA_RECYCLEBIN:{
      jj_consume_token(K_DBA_RECYCLEBIN);
purgeStatement = new PurgeStatement(PurgeObjectType.DBA_RECYCLEBIN);
      break;
      }
    case K_TABLESPACE:{
      jj_consume_token(K_TABLESPACE);
      tableSpaceToken = jj_consume_token(S_IDENTIFIER);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_USER:{
        jj_consume_token(K_USER);
        userToken = jj_consume_token(S_IDENTIFIER);
        break;
        }
      default:
        jj_la1[37] = jj_gen;
        ;
      }
purgeStatement = new PurgeStatement(
                PurgeObjectType.TABLESPACE
                , tableSpaceToken.image
                , userToken!=null ? userToken.image : null);
      break;
      }
    default:
      jj_la1[38] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return purgeStatement;
}

  final public DescribeStatement Describe() throws ParseException {Table table;
    jj_consume_token(K_DESCRIBE);
    table = Table();
return new DescribeStatement(table);
}

  final public ExplainStatement Explain() throws ParseException {Select select;
    List<ExplainStatement.Option> options = null;
    jj_consume_token(K_EXPLAIN);
    options = ExplainStatementOptions();
    select = SelectWithWithItems();
ExplainStatement es = new ExplainStatement(select);
       if(options != null && !options.isEmpty()) {
         for(ExplainStatement.Option o : options) {
           es.addOption(o);
         }
       }
       return es;
}

/**
 * Postgres supports TRUE,ON,1,FALSE,OFF,0 as values
 */
  final public String ExplainOptionBoolean() throws ParseException {Token tk = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_FALSE:
    case K_OFF:
    case K_ON:
    case K_TRUE:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_TRUE:{
        tk = jj_consume_token(K_TRUE);
        break;
        }
      case K_FALSE:{
        tk = jj_consume_token(K_FALSE);
        break;
        }
      case K_ON:{
        tk = jj_consume_token(K_ON);
        break;
        }
      case K_OFF:{
        tk = jj_consume_token(K_OFF);
        break;
        }
      default:
        jj_la1[39] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[40] = jj_gen;
      ;
    }
return tk != null ? tk.image : null;
}

/**
 * The output format, which can be TEXT, XML, JSON, or YAML
 */
  final public String ExplainFormatOption() throws ParseException {Token tk = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_JSON:
    case K_XML:
    case K_YAML:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_XML:{
        tk = jj_consume_token(K_XML);
        break;
        }
      case K_JSON:{
        tk = jj_consume_token(K_JSON);
        break;
        }
      case K_YAML:{
        tk = jj_consume_token(K_YAML);
        break;
        }
      default:
        jj_la1[41] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[42] = jj_gen;
      ;
    }
return tk != null ? tk.image : null;
}

/**
 * Options for explain, see https://www.postgresql.org/docs/9.1/sql-explain.html
 */
  final public List<ExplainStatement.Option> ExplainStatementOptions() throws ParseException {List<ExplainStatement.Option> options = new ArrayList<ExplainStatement.Option>();
  ExplainStatement.Option option = null;
  Token token = null;
  String value = null;
    label_9:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ANALYZE:
      case K_BUFFERS:
      case K_COSTS:
      case K_FORMAT:
      case K_VERBOSE:{
        ;
        break;
        }
      default:
        jj_la1[43] = jj_gen;
        break label_9;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ANALYZE:{
        jj_consume_token(K_ANALYZE);
        value = ExplainOptionBoolean();
option = new ExplainStatement.Option(ExplainStatement.OptionType.ANALYZE);
       option.setValue(value);
       options.add(option);
        break;
        }
      case K_BUFFERS:{
        jj_consume_token(K_BUFFERS);
        value = ExplainOptionBoolean();
option = new ExplainStatement.Option(ExplainStatement.OptionType.BUFFERS);
        option.setValue(value);
        options.add(option);
        break;
        }
      case K_COSTS:{
        jj_consume_token(K_COSTS);
        value = ExplainOptionBoolean();
option = new ExplainStatement.Option(ExplainStatement.OptionType.COSTS);
        option.setValue(value);
        options.add(option);
        break;
        }
      case K_VERBOSE:{
        jj_consume_token(K_VERBOSE);
        value = ExplainOptionBoolean();
option = new ExplainStatement.Option(ExplainStatement.OptionType.VERBOSE);
        option.setValue(value);
        options.add(option);
        break;
        }
      case K_FORMAT:{
        jj_consume_token(K_FORMAT);
        value = ExplainFormatOption();
option = new ExplainStatement.Option(ExplainStatement.OptionType.FORMAT);
        option.setValue(value);
        options.add(option);
        break;
        }
      default:
        jj_la1[44] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
return options;
}

  final public UseStatement Use() throws ParseException {String name;
    boolean hasSchemaKeyword = false;
    jj_consume_token(K_USE);
    if (jj_2_28(2)) {
      jj_consume_token(K_SCHEMA);
hasSchemaKeyword = true;
    } else {
      ;
    }
    name = RelObjectNameExt();
return new UseStatement(name, hasSchemaKeyword);
}

  final public ShowColumnsStatement ShowColumns() throws ParseException {String tableName;
    jj_consume_token(K_SHOW);
    jj_consume_token(K_COLUMNS);
    jj_consume_token(K_FROM);
    tableName = RelObjectNameExt();
return new ShowColumnsStatement(tableName);
}

// https://dev.mysql.com/doc/refman/8.0/en/show-tables.html
  final public ShowTablesStatement ShowTables() throws ParseException {ShowTablesStatement showTablesStatement;
    EnumSet<ShowTablesStatement.Modifiers> modifiers =  EnumSet.noneOf(ShowTablesStatement.Modifiers.class);
    ShowTablesStatement.SelectionMode selectionMode = null;
    String dbName = null;
    Expression likeExpression = null;
    Expression whereCondition = null;
    jj_consume_token(K_SHOW);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_EXTENDED:{
      jj_consume_token(K_EXTENDED);
modifiers.add(ShowTablesStatement.Modifiers.EXTENDED);
      break;
      }
    default:
      jj_la1[45] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_FULL:{
      jj_consume_token(K_FULL);
modifiers.add(ShowTablesStatement.Modifiers.FULL);
      break;
      }
    default:
      jj_la1[46] = jj_gen;
      ;
    }
    jj_consume_token(K_TABLES);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_FROM:
    case K_IN:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_FROM:{
        jj_consume_token(K_FROM);
selectionMode = ShowTablesStatement.SelectionMode.FROM;
        break;
        }
      case K_IN:{
        jj_consume_token(K_IN);
selectionMode = ShowTablesStatement.SelectionMode.IN;
        break;
        }
      default:
        jj_la1[47] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      dbName = RelObjectNameExt();
      break;
      }
    default:
      jj_la1[48] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_LIKE:
    case K_WHERE:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_LIKE:{
        jj_consume_token(K_LIKE);
        likeExpression = SimpleExpression();
        break;
        }
      case K_WHERE:{
        jj_consume_token(K_WHERE);
        whereCondition = Expression();
        break;
        }
      default:
        jj_la1[49] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[50] = jj_gen;
      ;
    }
showTablesStatement = new ShowTablesStatement();
    showTablesStatement.setModifiers(modifiers);
    showTablesStatement.setSelectionMode(selectionMode);
    showTablesStatement.setDbName(dbName);
    showTablesStatement.setLikeExpression(likeExpression);
    showTablesStatement.setWhereCondition(whereCondition);
    return showTablesStatement;
}

  final public ShowStatement Show() throws ParseException {String name;
    jj_consume_token(K_SHOW);
    name = RelObjectNameExt();
return new ShowStatement(name);
}

  final public ValuesStatement Values() throws ParseException {ItemsList itemsList;
    jj_consume_token(K_VALUES);
    itemsList = SimpleExpressionList(false);
return new ValuesStatement(itemsList);
}

  final public Update Update(List<WithItem> with) throws ParseException {Update update = new Update();
    Table table = null;
    List<Join> startJoins = null;

    UpdateSet updateSet = null;
    Column tableColumn = null;
    SubSelect subSelect;
    Expression valueExpression = null;
    ExpressionList expressionList;
    Expression where = null;
    FromItem fromItem = null;
    List<Join> joins = null;
    Limit limit = null;
    List<OrderByElement> orderByElements;
    boolean useColumnsBrackets = false;
    List<SelectExpressionItem> returning = null;
    Token tk = null;
    UpdateModifierPriority modifierPriority = null;
    boolean modifierIgnore = false;
    jj_consume_token(K_UPDATE);
update.setOracleHint(getOracleHint());
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_LOW_PRIORITY:{
      jj_consume_token(K_LOW_PRIORITY);
modifierPriority = UpdateModifierPriority.LOW_PRIORITY;
      break;
      }
    default:
      jj_la1[51] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_IGNORE:{
      jj_consume_token(K_IGNORE);
modifierIgnore = true;
      break;
      }
    default:
      jj_la1[52] = jj_gen;
      ;
    }
    table = TableWithAlias();
    startJoins = JoinsList();
    jj_consume_token(K_SET);
    if (jj_2_41(3)) {
      tableColumn = Column();
      jj_consume_token(327);
      valueExpression = SimpleExpression();
update.addUpdateSet(tableColumn, valueExpression);
      label_10:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_COMMA:{
          ;
          break;
          }
        default:
          jj_la1[53] = jj_gen;
          break label_10;
        }
        jj_consume_token(K_COMMA);
        tableColumn = Column();
        jj_consume_token(327);
        valueExpression = SimpleExpression();
update.addUpdateSet(tableColumn, valueExpression);
      }
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ACTION:
      case K_ACTIVE:
      case K_ALGORITHM:
      case K_ALL:
      case K_ANY:
      case K_ARCHIVE:
      case K_ARRAY_LITERAL:
      case K_AT:
      case K_BYTE:
      case K_CASCADE:
      case K_CASE:
      case K_CASEWHEN:
      case K_CAST:
      case K_TRY_CAST:
      case K_CHARACTER:
      case K_CHANGE:
      case K_CHECKPOINT:
      case K_CHAR:
      case K_COLUMN:
      case K_COLUMNS:
      case K_COMMIT:
      case K_COMMENT:
      case K_COSTS:
      case K_CREATE:
      case K_CYCLE:
      case K_DATETIMELITERAL:
      case K_DATE_LITERAL:
      case K_DBA_RECYCLEBIN:
      case K_DEFAULT:
      case K_DESC:
      case K_DESCRIBE:
      case K_DISABLE:
      case K_DISCONNECT:
      case K_DIV:
      case K_DO:
      case K_DOUBLE:
      case K_DUMP:
      case K_DUPLICATE:
      case K_ENABLE:
      case K_END:
      case K_EXCLUDE:
      case K_EXTRACT:
      case K_FILTER:
      case K_FIRST:
      case K_FALSE:
      case K_FLUSH:
      case K_FOLLOWING:
      case K_FORMAT:
      case K_FULLTEXT:
      case K_GROUP:
      case K_GROUPING:
      case K_HISTORY:
      case K_IF:
      case K_IIF:
      case K_IN:
      case K_INDEX:
      case K_INSERT:
      case K_INTERVAL:
      case K_ISNULL:
      case K_JSON:
      case K_KEY:
      case K_FN:
      case K_LAST:
      case K_LEADING:
      case K_LEFT:
      case K_LIMIT:
      case K_LOCAL:
      case K_LINK:
      case K_LOG:
      case K_MATERIALIZED:
      case K_NEXTVAL:
      case K_NO:
      case K_NOLOCK:
      case K_NULLS:
      case K_OF:
      case K_OFFSET:
      case K_ON:
      case K_OPEN:
      case K_ORDER:
      case K_OVER:
      case K_OPTIMIZE:
      case K_PARALLEL:
      case K_PARTITION:
      case K_PATH:
      case K_PERCENT:
      case K_PRECISION:
      case K_PRIMARY:
      case K_PRIOR:
      case K_PROCEDURE:
      case K_PUBLIC:
      case K_QUERY:
      case K_QUIESCE:
      case K_RANGE:
      case K_READ:
      case K_RECYCLEBIN:
      case K_REGISTER:
      case K_REPLACE:
      case K_RESUME:
      case K_RESTRICTED:
      case K_RIGHT:
      case K_ROW:
      case K_ROWS:
      case K_SCHEMA:
      case K_SEQUENCE:
      case K_SEPARATOR:
      case K_SESSION:
      case K_SET:
      case K_SHUTDOWN:
      case K_SIBLINGS:
      case K_SIZE:
      case K_SKIP:
      case K_SOME:
      case K_START:
      case K_SUSPEND:
      case K_SWITCH:
      case K_SYNONYM:
      case K_SYSTEM:
      case K_TABLE:
      case K_TABLES:
      case K_TABLESPACE:
      case K_TEMP:
      case K_TEMPORARY:
      case K_TIMEOUT:
      case K_TO:
      case K_TOP:
      case K_TRUNCATE:
      case K_TRUE:
      case K_TYPE:
      case K_UNQIESCE:
      case K_USER:
      case K_SIGNED:
      case K_STRING_FUNCTION_NAME:
      case K_UNSIGNED:
      case K_VALIDATE:
      case K_VALUE:
      case K_VALUES:
      case K_VIEW:
      case K_XML:
      case K_ZONE:
      case S_IDENTIFIER:
      case S_QUOTED_IDENTIFIER:
      case 325:{
updateSet = new UpdateSet(); update.addUpdateSet(updateSet);
        if (jj_2_29(2)) {
          jj_consume_token(325);
updateSet.setUsingBracketsForColumns(true);
        } else {
          ;
        }
        tableColumn = Column();
updateSet.add(tableColumn);
        label_11:
        while (true) {
          if (jj_2_30(2)) {
            ;
          } else {
            break label_11;
          }
          jj_consume_token(K_COMMA);
          tableColumn = Column();
updateSet.add(tableColumn);
        }
        if (jj_2_31(2)) {
          jj_consume_token(326);
        } else {
          ;
        }
        jj_consume_token(327);
        if (jj_2_32(3)) {
          subSelect = SubSelect();
updateSet.add(subSelect.withUseBrackets(false));
        } else if (jj_2_33(3)) {
          jj_consume_token(325);
          expressionList = ComplexExpressionList();
updateSet.setUsingBracketsForValues(true); updateSet.add(expressionList);
          jj_consume_token(326);
        } else if (jj_2_34(1)) {
          valueExpression = Expression();
updateSet.add(valueExpression);
        } else {
          jj_consume_token(-1);
          throw new ParseException();
        }
        label_12:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_COMMA:{
            ;
            break;
            }
          default:
            jj_la1[54] = jj_gen;
            break label_12;
          }
          jj_consume_token(K_COMMA);
updateSet = new UpdateSet(); update.addUpdateSet(updateSet);
          if (jj_2_35(2)) {
            jj_consume_token(325);
updateSet.setUsingBracketsForColumns(true);
          } else {
            ;
          }
          tableColumn = Column();
updateSet.add(tableColumn);
          label_13:
          while (true) {
            if (jj_2_36(2)) {
              ;
            } else {
              break label_13;
            }
            jj_consume_token(K_COMMA);
            tableColumn = Column();
updateSet.add(tableColumn);
          }
          if (jj_2_37(2)) {
            jj_consume_token(326);
          } else {
            ;
          }
          jj_consume_token(327);
          if (jj_2_38(3)) {
            subSelect = SubSelect();
updateSet.add(subSelect.withUseBrackets(false));
          } else if (jj_2_39(3)) {
            jj_consume_token(325);
            expressionList = ComplexExpressionList();
updateSet.setUsingBracketsForValues(true); updateSet.add(expressionList);
            jj_consume_token(326);
          } else if (jj_2_40(1)) {
            valueExpression = Expression();
updateSet.add(valueExpression);
          } else {
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
        break;
        }
      default:
        jj_la1[55] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_FROM:{
      jj_consume_token(K_FROM);
      fromItem = FromItem();
      joins = JoinsList();
      break;
      }
    default:
      jj_la1[56] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_WHERE:{
      where = WhereClause();
update.setWhere(where);
      break;
      }
    default:
      jj_la1[57] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ORDER:{
      orderByElements = OrderByElements();
update.setOrderByElements(orderByElements);
      break;
      }
    default:
      jj_la1[58] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_LIMIT:{
      limit = PlainLimit();
update.setLimit(limit);
      break;
      }
    default:
      jj_la1[59] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_RETURNING:{
      jj_consume_token(K_RETURNING);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 328:{
        jj_consume_token(328);
update.setReturningAllColumns(true);
        break;
        }
      default:
        jj_la1[60] = jj_gen;
        if (jj_2_42(1)) {
          returning = ListExpressionItem();
        } else {
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      break;
      }
    default:
      jj_la1[61] = jj_gen;
      ;
    }
return update.withWithItemsList(with)
              .withTable(table)
              .withStartJoins(startJoins)
              .withFromItem(fromItem)
              .withJoins(joins)
              .withModifierPriority(modifierPriority)
              .withModifierIgnore(modifierIgnore)
              .withReturningExpressionList(returning);
}

  final public Replace Replace() throws ParseException {
      Replace replace = new Replace();
    Table table = null;
    Column tableColumn = null;
    Expression value = null;

    List<Column> columns = new ArrayList<Column>();
    List<Expression> expList = new ArrayList<Expression>();
    MultiExpressionList multiExpr = null;
    ItemsList itemsList = null;
    Expression exp = null;
    jj_consume_token(K_REPLACE);
    if (jj_2_43(2)) {
      jj_consume_token(K_INTO);
replace.setUseIntoTables(true);
    } else {
      ;
    }
    table = Table();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_SET:{
      jj_consume_token(K_SET);
      tableColumn = Column();
      jj_consume_token(327);
      value = SimpleExpression();
columns.add(tableColumn); expList.add(value);
      label_14:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_COMMA:{
          ;
          break;
          }
        default:
          jj_la1[62] = jj_gen;
          break label_14;
        }
        jj_consume_token(K_COMMA);
        tableColumn = Column();
        jj_consume_token(327);
        value = SimpleExpression();
columns.add(tableColumn); expList.add(value);
      }
replace.setExpressions(expList);
      break;
      }
    case K_SELECT:
    case K_VALUE:
    case K_VALUES:
    case K_WITH:
    case 325:{
      if (jj_2_44(2)) {
        jj_consume_token(325);
        tableColumn = Column();
columns.add(tableColumn);
        label_15:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_COMMA:{
            ;
            break;
            }
          default:
            jj_la1[63] = jj_gen;
            break label_15;
          }
          jj_consume_token(K_COMMA);
          tableColumn = Column();
columns.add(tableColumn);
        }
        jj_consume_token(326);
      } else {
        ;
      }
      if (jj_2_45(2)) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_VALUE:
        case K_VALUES:{
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_VALUES:{
            jj_consume_token(K_VALUES);
            break;
            }
          case K_VALUE:{
            jj_consume_token(K_VALUE);
            break;
            }
          default:
            jj_la1[64] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          break;
          }
        default:
          jj_la1[65] = jj_gen;
          ;
        }
        jj_consume_token(325);
        exp = PrimaryExpression();
expList.add(exp);
        label_16:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_COMMA:{
            ;
            break;
            }
          default:
            jj_la1[66] = jj_gen;
            break label_16;
          }
          jj_consume_token(K_COMMA);
          exp = PrimaryExpression();
expList.add(exp);
        }
        jj_consume_token(326);
itemsList = new ExpressionList(expList);
        label_17:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_COMMA:{
            ;
            break;
            }
          default:
            jj_la1[67] = jj_gen;
            break label_17;
          }
          jj_consume_token(K_COMMA);
          jj_consume_token(325);
          exp = SimpleExpression();
if (multiExpr==null) {
                                multiExpr=new MultiExpressionList();
                                multiExpr.addExpressionList((ExpressionList)itemsList);
                                itemsList = multiExpr;
                            }
                            expList = new ArrayList<Expression>();
                            expList.add(exp);
          label_18:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_COMMA:{
              ;
              break;
              }
            default:
              jj_la1[68] = jj_gen;
              break label_18;
            }
            jj_consume_token(K_COMMA);
            exp = SimpleExpression();
expList.add(exp);
          }
          jj_consume_token(326);
multiExpr.addExpressionList(expList);
        }
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_SELECT:
        case K_VALUES:
        case K_WITH:
        case 325:{
replace.setUseValues(false);
          itemsList = SubSelect();
((SubSelect)itemsList).setUseBrackets(false);
          break;
          }
        default:
          jj_la1[69] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
replace.setItemsList(itemsList);
      break;
      }
    default:
      jj_la1[70] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
if (!columns.isEmpty()) {
           replace.withColumns(columns);
        }
        return replace.withTable(table);
}

  final public List<SelectExpressionItem> ListExpressionItem() throws ParseException {List<SelectExpressionItem> retval = new ArrayList<SelectExpressionItem>();
   SelectExpressionItem item;
    item = SelectExpressionItem();
retval.add(item);
    label_19:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COMMA:{
        ;
        break;
        }
      default:
        jj_la1[71] = jj_gen;
        break label_19;
      }
      jj_consume_token(K_COMMA);
      item = SelectExpressionItem();
retval.add(item);
    }
return retval;
}

  final public Insert Insert(List<WithItem> with) throws ParseException {Insert insert = new Insert();
    Table table = null;
    Column tableColumn = null;
    List<Column> columns = new ArrayList<Column>();
    List<Expression> primaryExpList = new ArrayList<Expression>();
    ItemsList itemsList = null;
    Expression exp = null;
    MultiExpressionList multiExpr = null;
    List<SelectExpressionItem> returning = null;
    Select select = null;
    boolean useValues = true;
    boolean useSelectBrackets = false;
    boolean useDuplicate = false;
    List<Column> duplicateUpdateColumns = null;
    List<Expression> duplicateUpdateExpressionList = null;
    Token tk = null;
    InsertModifierPriority modifierPriority = null;
    boolean modifierIgnore = false;
    boolean useSet = false;
    List<Column> setColumns = new ArrayList<Column>();
    List<Expression> setExpressionList = new ArrayList<Expression>();
    String name = null;
    boolean useAs = false;
    jj_consume_token(K_INSERT);
insert.setOracleHint(getOracleHint());
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_DELAYED:
    case K_HIGH_PRIORITY:
    case K_LOW_PRIORITY:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_LOW_PRIORITY:{
        tk = jj_consume_token(K_LOW_PRIORITY);
        break;
        }
      case K_DELAYED:{
        tk = jj_consume_token(K_DELAYED);
        break;
        }
      case K_HIGH_PRIORITY:{
        tk = jj_consume_token(K_HIGH_PRIORITY);
        break;
        }
      default:
        jj_la1[72] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
if (tk!=null)
        modifierPriority = InsertModifierPriority.valueOf(tk.image.toUpperCase());
      break;
      }
    default:
      jj_la1[73] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_IGNORE:{
      jj_consume_token(K_IGNORE);
modifierIgnore = true;
      break;
      }
    default:
      jj_la1[74] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_INTO:{
      jj_consume_token(K_INTO);
      break;
      }
    default:
      jj_la1[75] = jj_gen;
      ;
    }
    table = Table();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ACTION:
    case K_ACTIVE:
    case K_ALGORITHM:
    case K_ARCHIVE:
    case K_ARRAY_LITERAL:
    case K_AS:
    case K_AT:
    case K_BYTE:
    case K_CASCADE:
    case K_CASE:
    case K_CAST:
    case K_TRY_CAST:
    case K_CHARACTER:
    case K_CHANGE:
    case K_CHECKPOINT:
    case K_CHAR:
    case K_COLUMN:
    case K_COLUMNS:
    case K_COMMIT:
    case K_COMMENT:
    case K_COSTS:
    case K_CYCLE:
    case K_DATETIMELITERAL:
    case K_DATE_LITERAL:
    case K_DBA_RECYCLEBIN:
    case K_DEFAULT:
    case K_DESC:
    case K_DESCRIBE:
    case K_DISABLE:
    case K_DISCONNECT:
    case K_DIV:
    case K_DO:
    case K_DUMP:
    case K_DUPLICATE:
    case K_ENABLE:
    case K_END:
    case K_EXCLUDE:
    case K_EXTRACT:
    case K_FILTER:
    case K_FIRST:
    case K_FALSE:
    case K_FLUSH:
    case K_FOLLOWING:
    case K_FORMAT:
    case K_FULLTEXT:
    case K_HISTORY:
    case K_INDEX:
    case K_INSERT:
    case K_ISNULL:
    case K_JSON:
    case K_KEY:
    case K_FN:
    case K_LAST:
    case K_LEADING:
    case K_LOCAL:
    case K_LINK:
    case K_LOG:
    case K_MATERIALIZED:
    case K_NEXTVAL:
    case K_NO:
    case K_NOLOCK:
    case K_NULLS:
    case K_OF:
    case K_OPEN:
    case K_OVER:
    case K_PARALLEL:
    case K_PARTITION:
    case K_PATH:
    case K_PERCENT:
    case K_PRECISION:
    case K_PRIMARY:
    case K_PRIOR:
    case K_QUERY:
    case K_QUIESCE:
    case K_RANGE:
    case K_READ:
    case K_RECYCLEBIN:
    case K_REGISTER:
    case K_REPLACE:
    case K_RESUME:
    case K_RESTRICTED:
    case K_ROW:
    case K_ROWS:
    case K_SCHEMA:
    case K_SEQUENCE:
    case K_SEPARATOR:
    case K_SESSION:
    case K_SHUTDOWN:
    case K_SIBLINGS:
    case K_SIZE:
    case K_SKIP:
    case K_SUSPEND:
    case K_SWITCH:
    case K_SYNONYM:
    case K_SYSTEM:
    case K_TABLE:
    case K_TABLESPACE:
    case K_TEMP:
    case K_TEMPORARY:
    case K_TIMEOUT:
    case K_TO:
    case K_TRUNCATE:
    case K_TRUE:
    case K_TYPE:
    case K_UNQIESCE:
    case K_USER:
    case K_SIGNED:
    case K_STRING_FUNCTION_NAME:
    case K_UNSIGNED:
    case K_VALIDATE:
    case K_VIEW:
    case K_XML:
    case K_ZONE:
    case S_IDENTIFIER:
    case S_QUOTED_IDENTIFIER:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_AS:{
        jj_consume_token(K_AS);
useAs = true;
        break;
        }
      default:
        jj_la1[76] = jj_gen;
        ;
      }
      name = RelObjectNameWithoutValue();
table.setAlias(new Alias(name,useAs));
      break;
      }
    default:
      jj_la1[77] = jj_gen;
      ;
    }
    if (jj_2_46(2)) {
      jj_consume_token(325);
      tableColumn = Column();
columns.add(tableColumn);
      label_20:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_COMMA:{
          ;
          break;
          }
        default:
          jj_la1[78] = jj_gen;
          break label_20;
        }
        jj_consume_token(K_COMMA);
        tableColumn = Column();
columns.add(tableColumn);
      }
      jj_consume_token(326);
    } else {
      ;
    }
    if (jj_2_48(2)) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_VALUE:
      case K_VALUES:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_VALUES:{
          jj_consume_token(K_VALUES);
          break;
          }
        case K_VALUE:{
          jj_consume_token(K_VALUE);
          break;
          }
        default:
          jj_la1[79] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[80] = jj_gen;
        ;
      }
      jj_consume_token(325);
      exp = SimpleExpression();
primaryExpList.add(exp);
      label_21:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_COMMA:{
          ;
          break;
          }
        default:
          jj_la1[81] = jj_gen;
          break label_21;
        }
        jj_consume_token(K_COMMA);
        exp = SimpleExpression();
primaryExpList.add(exp);
      }
      jj_consume_token(326);
itemsList = new ExpressionList(primaryExpList);
      label_22:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_COMMA:{
          ;
          break;
          }
        default:
          jj_la1[82] = jj_gen;
          break label_22;
        }
        jj_consume_token(K_COMMA);
        jj_consume_token(325);
        exp = SimpleExpression();
if (multiExpr==null) {
                        multiExpr=new MultiExpressionList();
                        multiExpr.addExpressionList((ExpressionList)itemsList);
                        itemsList = multiExpr;
                    }
                    primaryExpList = new ArrayList<Expression>();
                    primaryExpList.add(exp);
        label_23:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_COMMA:{
            ;
            break;
            }
          default:
            jj_la1[83] = jj_gen;
            break label_23;
          }
          jj_consume_token(K_COMMA);
          exp = SimpleExpression();
primaryExpList.add(exp);
        }
        jj_consume_token(326);
multiExpr.addExpressionList(primaryExpList);
      }
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_SELECT:
      case K_VALUES:
      case K_WITH:
      case 325:{
        if (jj_2_47(2)) {
          jj_consume_token(325);
useSelectBrackets = true;
insert.setUseValues(false);
          select = SelectWithWithItems();
          jj_consume_token(326);
        } else {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_SELECT:
          case K_VALUES:
          case K_WITH:
          case 325:{
insert.setUseValues(false);
            select = SelectWithWithItems();
            break;
            }
          default:
            jj_la1[84] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
        break;
        }
      case K_SET:{
        jj_consume_token(K_SET);
useSet = true;
                insert.setUseValues(false);
        tableColumn = Column();
        jj_consume_token(327);
        exp = SimpleExpression();
setColumns = new ArrayList<Column>();
                setExpressionList = new ArrayList<Expression>();
                setColumns.add(tableColumn);
                setExpressionList.add(exp);
        label_24:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_COMMA:{
            ;
            break;
            }
          default:
            jj_la1[85] = jj_gen;
            break label_24;
          }
          jj_consume_token(K_COMMA);
          tableColumn = Column();
          jj_consume_token(327);
          exp = SimpleExpression();
setColumns.add(tableColumn);
                setExpressionList.add(exp);
        }
        break;
        }
      default:
        jj_la1[86] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ON:{
      jj_consume_token(K_ON);
      jj_consume_token(K_DUPLICATE);
      jj_consume_token(K_KEY);
      jj_consume_token(K_UPDATE);
useDuplicate = true;
      tableColumn = Column();
      jj_consume_token(327);
      exp = SimpleExpression();
duplicateUpdateColumns = new ArrayList<Column>();
            duplicateUpdateExpressionList = new ArrayList<Expression>();
            duplicateUpdateColumns.add(tableColumn);
            duplicateUpdateExpressionList.add(exp);
      label_25:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_COMMA:{
          ;
          break;
          }
        default:
          jj_la1[87] = jj_gen;
          break label_25;
        }
        jj_consume_token(K_COMMA);
        tableColumn = Column();
        jj_consume_token(327);
        exp = SimpleExpression();
duplicateUpdateColumns.add(tableColumn);
        duplicateUpdateExpressionList.add(exp);
      }
      break;
      }
    default:
      jj_la1[88] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_RETURNING:{
      jj_consume_token(K_RETURNING);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 328:{
        jj_consume_token(328);
insert.setReturningAllColumns(true);
        break;
        }
      default:
        jj_la1[89] = jj_gen;
        if (jj_2_49(1)) {
          returning = ListExpressionItem();
        } else {
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      break;
      }
    default:
      jj_la1[90] = jj_gen;
      ;
    }
if (!columns.isEmpty()) {
            insert.setColumns(columns);
        }
        return insert.withWithItemsList(with)
              .withItemsList(itemsList)
              .withUseSelectBrackets(useSelectBrackets)
              .withSelect(select)
              .withTable(table)
              .withUseDuplicate(useDuplicate)
              .withDuplicateUpdateColumns(duplicateUpdateColumns)
              .withDuplicateUpdateExpressionList(duplicateUpdateExpressionList)
              .withReturningExpressionList(returning)
              .withModifierPriority(modifierPriority)
              .withModifierIgnore(modifierIgnore)
              .withUseSet(useSet)
              .withUseSetColumns(setColumns)
              .withSetExpressionList(setExpressionList);
}

  final public Upsert Upsert() throws ParseException {
    Upsert upsert = new Upsert();
    Table table = null;
    Column tableColumn = null;
    List<Column> columns = new ArrayList<Column>();
    List<Expression> primaryExpList = new ArrayList<Expression>();
    ItemsList itemsList = null;
    Expression exp = null;
    MultiExpressionList multiExpr = null;
    List<SelectExpressionItem> returning = null;
    Select select = null;
    boolean useSelectBrackets = false;
    boolean useDuplicate = false;
    List<Column> duplicateUpdateColumns = null;
    List<Expression> duplicateUpdateExpressionList = null;
    Token tk = null;
    jj_consume_token(K_UPSERT);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_INTO:{
      jj_consume_token(K_INTO);
      break;
      }
    default:
      jj_la1[91] = jj_gen;
      ;
    }
    table = Table();
    if (jj_2_50(2)) {
      jj_consume_token(325);
      tableColumn = Column();
columns.add(tableColumn);
      label_26:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_COMMA:{
          ;
          break;
          }
        default:
          jj_la1[92] = jj_gen;
          break label_26;
        }
        jj_consume_token(K_COMMA);
        tableColumn = Column();
columns.add(tableColumn);
      }
      jj_consume_token(326);
    } else {
      ;
    }
    if (jj_2_52(2)) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_VALUE:
      case K_VALUES:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_VALUES:{
          jj_consume_token(K_VALUES);
          break;
          }
        case K_VALUE:{
          jj_consume_token(K_VALUE);
          break;
          }
        default:
          jj_la1[93] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[94] = jj_gen;
        ;
      }
      jj_consume_token(325);
      exp = SimpleExpression();
primaryExpList.add(exp);
      label_27:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_COMMA:{
          ;
          break;
          }
        default:
          jj_la1[95] = jj_gen;
          break label_27;
        }
        jj_consume_token(K_COMMA);
        exp = SimpleExpression();
primaryExpList.add(exp);
      }
      jj_consume_token(326);
itemsList = new ExpressionList(primaryExpList);
      label_28:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_COMMA:{
          ;
          break;
          }
        default:
          jj_la1[96] = jj_gen;
          break label_28;
        }
        jj_consume_token(K_COMMA);
        jj_consume_token(325);
        exp = SimpleExpression();
if (multiExpr==null) {
                        multiExpr=new MultiExpressionList();
                        multiExpr.addExpressionList((ExpressionList)itemsList);
                        itemsList = multiExpr;
                    }
                    primaryExpList = new ArrayList<Expression>();
                    primaryExpList.add(exp);
        label_29:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_COMMA:{
            ;
            break;
            }
          default:
            jj_la1[97] = jj_gen;
            break label_29;
          }
          jj_consume_token(K_COMMA);
          exp = SimpleExpression();
primaryExpList.add(exp);
        }
        jj_consume_token(326);
multiExpr.addExpressionList(primaryExpList);
      }
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_SELECT:
      case K_VALUES:
      case K_WITH:
      case 325:{
        if (jj_2_51(2)) {
          jj_consume_token(325);
useSelectBrackets = true;
upsert.setUseValues(false);
          select = SelectWithWithItems();
          jj_consume_token(326);
        } else {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_SELECT:
          case K_VALUES:
          case K_WITH:
          case 325:{
upsert.setUseValues(false);
            select = SelectWithWithItems();
            break;
            }
          default:
            jj_la1[98] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
        break;
        }
      default:
        jj_la1[99] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ON:{
      jj_consume_token(K_ON);
      jj_consume_token(K_DUPLICATE);
      jj_consume_token(K_KEY);
      jj_consume_token(K_UPDATE);
useDuplicate = true;
      tableColumn = Column();
      jj_consume_token(327);
      exp = SimpleExpression();
duplicateUpdateColumns = new ArrayList<Column>();
            duplicateUpdateExpressionList = new ArrayList<Expression>();
            duplicateUpdateColumns.add(tableColumn);
            duplicateUpdateExpressionList.add(exp);
      label_30:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_COMMA:{
          ;
          break;
          }
        default:
          jj_la1[100] = jj_gen;
          break label_30;
        }
        jj_consume_token(K_COMMA);
        tableColumn = Column();
        jj_consume_token(327);
        exp = SimpleExpression();
duplicateUpdateColumns.add(tableColumn);
        duplicateUpdateExpressionList.add(exp);
      }
      break;
      }
    default:
      jj_la1[101] = jj_gen;
      ;
    }
if (columns.size() > 0) {
            upsert.setColumns(columns);
        }
        return upsert.withItemsList(itemsList)
              .withUseSelectBrackets(useSelectBrackets)
              .withSelect(select)
              .withTable(table)
              .withUseDuplicate(useDuplicate)
              .withDuplicateUpdateColumns(duplicateUpdateColumns)
              .withDuplicateUpdateExpressionList(duplicateUpdateExpressionList);
}

  final public Delete Delete(List<WithItem> with) throws ParseException {Delete delete = new Delete();
    Table table = null;
    List<Table> tables = new ArrayList<Table>();
    Table usingTable = null;
    List<Table> usingList = new ArrayList<Table>();
    List<Join> joins = null;
    Expression where = null;
    Limit limit = null;
    List<OrderByElement> orderByElements;
    boolean hasFrom = false;
    Token tk = null;
    DeleteModifierPriority modifierPriority = null;
    boolean modifierIgnore = false;
    boolean modifierQuick = false;
    jj_consume_token(K_DELETE);
delete.setOracleHint(getOracleHint());
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_LOW_PRIORITY:{
      jj_consume_token(K_LOW_PRIORITY);
modifierPriority = DeleteModifierPriority.LOW_PRIORITY;
      break;
      }
    default:
      jj_la1[102] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_QUICK:{
      jj_consume_token(K_QUICK);
modifierQuick = true;
      break;
      }
    default:
      jj_la1[103] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_IGNORE:{
      jj_consume_token(K_IGNORE);
modifierIgnore = true;
      break;
      }
    default:
      jj_la1[104] = jj_gen;
      ;
    }
    if (jj_2_53(4)) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ACTION:
      case K_ACTIVE:
      case K_ALGORITHM:
      case K_ALL:
      case K_ANY:
      case K_ARCHIVE:
      case K_ARRAY_LITERAL:
      case K_AT:
      case K_BYTE:
      case K_CASCADE:
      case K_CASE:
      case K_CASEWHEN:
      case K_CAST:
      case K_TRY_CAST:
      case K_CHARACTER:
      case K_CHANGE:
      case K_CHECKPOINT:
      case K_CHAR:
      case K_COLUMN:
      case K_COLUMNS:
      case K_COMMIT:
      case K_COMMENT:
      case K_COSTS:
      case K_CREATE:
      case K_CYCLE:
      case K_DATETIMELITERAL:
      case K_DATE_LITERAL:
      case K_DBA_RECYCLEBIN:
      case K_DEFAULT:
      case K_DESC:
      case K_DESCRIBE:
      case K_DISABLE:
      case K_DISCONNECT:
      case K_DIV:
      case K_DO:
      case K_DOUBLE:
      case K_DUMP:
      case K_DUPLICATE:
      case K_ENABLE:
      case K_END:
      case K_EXCLUDE:
      case K_EXTRACT:
      case K_FILTER:
      case K_FIRST:
      case K_FALSE:
      case K_FLUSH:
      case K_FOLLOWING:
      case K_FORMAT:
      case K_FULLTEXT:
      case K_GROUP:
      case K_GROUPING:
      case K_HISTORY:
      case K_IF:
      case K_IIF:
      case K_IN:
      case K_INDEX:
      case K_INSERT:
      case K_INTERVAL:
      case K_ISNULL:
      case K_JSON:
      case K_KEY:
      case K_FN:
      case K_LAST:
      case K_LEADING:
      case K_LEFT:
      case K_LIMIT:
      case K_LOCAL:
      case K_LINK:
      case K_LOG:
      case K_MATERIALIZED:
      case K_NEXTVAL:
      case K_NO:
      case K_NOLOCK:
      case K_NULLS:
      case K_OF:
      case K_OFFSET:
      case K_ON:
      case K_OPEN:
      case K_ORDER:
      case K_OVER:
      case K_OPTIMIZE:
      case K_PARALLEL:
      case K_PARTITION:
      case K_PATH:
      case K_PERCENT:
      case K_PRECISION:
      case K_PRIMARY:
      case K_PRIOR:
      case K_PROCEDURE:
      case K_PUBLIC:
      case K_QUERY:
      case K_QUIESCE:
      case K_RANGE:
      case K_READ:
      case K_RECYCLEBIN:
      case K_REGISTER:
      case K_REPLACE:
      case K_RESUME:
      case K_RESTRICTED:
      case K_RIGHT:
      case K_ROW:
      case K_ROWS:
      case K_SCHEMA:
      case K_SEQUENCE:
      case K_SEPARATOR:
      case K_SESSION:
      case K_SET:
      case K_SHUTDOWN:
      case K_SIBLINGS:
      case K_SIZE:
      case K_SKIP:
      case K_SOME:
      case K_START:
      case K_SUSPEND:
      case K_SWITCH:
      case K_SYNONYM:
      case K_SYSTEM:
      case K_TABLE:
      case K_TABLES:
      case K_TABLESPACE:
      case K_TEMP:
      case K_TEMPORARY:
      case K_TIMEOUT:
      case K_TO:
      case K_TOP:
      case K_TRUNCATE:
      case K_TRUE:
      case K_TYPE:
      case K_UNQIESCE:
      case K_USER:
      case K_SIGNED:
      case K_STRING_FUNCTION_NAME:
      case K_UNSIGNED:
      case K_VALIDATE:
      case K_VALUE:
      case K_VALUES:
      case K_VIEW:
      case K_XML:
      case K_ZONE:
      case S_IDENTIFIER:
      case S_QUOTED_IDENTIFIER:{
        table = TableWithAlias();
tables.add(table);
        label_31:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_COMMA:{
            ;
            break;
            }
          default:
            jj_la1[105] = jj_gen;
            break label_31;
          }
          jj_consume_token(K_COMMA);
          table = TableWithAlias();
tables.add(table);
        }
        jj_consume_token(K_FROM);
        break;
        }
      case K_FROM:{
        jj_consume_token(K_FROM);
        break;
        }
      default:
        jj_la1[106] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
hasFrom = true;
    } else {
      ;
    }
    if (jj_2_54(3)) {
      table = TableWithAlias();
      joins = JoinsList();
    } else {
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_USING:{
      jj_consume_token(K_USING);
      usingTable = TableWithAlias();
usingList.add(usingTable);
      label_32:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_COMMA:{
          ;
          break;
          }
        default:
          jj_la1[107] = jj_gen;
          break label_32;
        }
        jj_consume_token(K_COMMA);
        usingTable = TableWithAlias();
usingList.add(usingTable);
      }
      break;
      }
    default:
      jj_la1[108] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_WHERE:{
      where = WhereClause();
delete.setWhere(where);
      break;
      }
    default:
      jj_la1[109] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ORDER:{
      orderByElements = OrderByElements();
delete.setOrderByElements(orderByElements);
      break;
      }
    default:
      jj_la1[110] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_LIMIT:{
      limit = PlainLimit();
delete.setLimit(limit);
      break;
      }
    default:
      jj_la1[111] = jj_gen;
      ;
    }
if (joins != null && joins.size() > 0) {
            delete.setJoins(joins);
        }
        return delete.withWithItemsList(with)
              .withTables(tables)
              .withTable(table)
              .withHasFrom(hasFrom)
              .withUsingList(usingList)
              .withModifierPriority(modifierPriority)
              .withModifierIgnore(modifierIgnore)
              .withModifierQuick(modifierQuick);
}

  final public Statement Merge(List<WithItem> with) throws ParseException {
    Merge merge = new Merge();
    Table table;
    SubSelect select;
    Alias alias;
    Expression condition;
    MergeUpdate update;
    MergeInsert insert;
    jj_consume_token(K_MERGE);
merge.setOracleHint(getOracleHint());
    jj_consume_token(K_INTO);
    table = TableWithAlias();
merge.setTable(table);
    jj_consume_token(K_USING);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ACTION:
    case K_ACTIVE:
    case K_ALGORITHM:
    case K_ALL:
    case K_ANY:
    case K_ARCHIVE:
    case K_ARRAY_LITERAL:
    case K_AT:
    case K_BYTE:
    case K_CASCADE:
    case K_CASE:
    case K_CASEWHEN:
    case K_CAST:
    case K_TRY_CAST:
    case K_CHARACTER:
    case K_CHANGE:
    case K_CHECKPOINT:
    case K_CHAR:
    case K_COLUMN:
    case K_COLUMNS:
    case K_COMMIT:
    case K_COMMENT:
    case K_COSTS:
    case K_CREATE:
    case K_CYCLE:
    case K_DATETIMELITERAL:
    case K_DATE_LITERAL:
    case K_DBA_RECYCLEBIN:
    case K_DEFAULT:
    case K_DESC:
    case K_DESCRIBE:
    case K_DISABLE:
    case K_DISCONNECT:
    case K_DIV:
    case K_DO:
    case K_DOUBLE:
    case K_DUMP:
    case K_DUPLICATE:
    case K_ENABLE:
    case K_END:
    case K_EXCLUDE:
    case K_EXTRACT:
    case K_FILTER:
    case K_FIRST:
    case K_FALSE:
    case K_FLUSH:
    case K_FOLLOWING:
    case K_FORMAT:
    case K_FULLTEXT:
    case K_GROUP:
    case K_GROUPING:
    case K_HISTORY:
    case K_IF:
    case K_IIF:
    case K_IN:
    case K_INDEX:
    case K_INSERT:
    case K_INTERVAL:
    case K_ISNULL:
    case K_JSON:
    case K_KEY:
    case K_FN:
    case K_LAST:
    case K_LEADING:
    case K_LEFT:
    case K_LIMIT:
    case K_LOCAL:
    case K_LINK:
    case K_LOG:
    case K_MATERIALIZED:
    case K_NEXTVAL:
    case K_NO:
    case K_NOLOCK:
    case K_NULLS:
    case K_OF:
    case K_OFFSET:
    case K_ON:
    case K_OPEN:
    case K_ORDER:
    case K_OVER:
    case K_OPTIMIZE:
    case K_PARALLEL:
    case K_PARTITION:
    case K_PATH:
    case K_PERCENT:
    case K_PRECISION:
    case K_PRIMARY:
    case K_PRIOR:
    case K_PROCEDURE:
    case K_PUBLIC:
    case K_QUERY:
    case K_QUIESCE:
    case K_RANGE:
    case K_READ:
    case K_RECYCLEBIN:
    case K_REGISTER:
    case K_REPLACE:
    case K_RESUME:
    case K_RESTRICTED:
    case K_RIGHT:
    case K_ROW:
    case K_ROWS:
    case K_SCHEMA:
    case K_SEQUENCE:
    case K_SEPARATOR:
    case K_SESSION:
    case K_SET:
    case K_SHUTDOWN:
    case K_SIBLINGS:
    case K_SIZE:
    case K_SKIP:
    case K_SOME:
    case K_START:
    case K_SUSPEND:
    case K_SWITCH:
    case K_SYNONYM:
    case K_SYSTEM:
    case K_TABLE:
    case K_TABLES:
    case K_TABLESPACE:
    case K_TEMP:
    case K_TEMPORARY:
    case K_TIMEOUT:
    case K_TO:
    case K_TOP:
    case K_TRUNCATE:
    case K_TRUE:
    case K_TYPE:
    case K_UNQIESCE:
    case K_USER:
    case K_SIGNED:
    case K_STRING_FUNCTION_NAME:
    case K_UNSIGNED:
    case K_VALIDATE:
    case K_VALUE:
    case K_VALUES:
    case K_VIEW:
    case K_XML:
    case K_ZONE:
    case S_IDENTIFIER:
    case S_QUOTED_IDENTIFIER:{
      table = Table();
merge.setUsingTable(table);
      break;
      }
    case 325:{
      jj_consume_token(325);
      select = SubSelect();
merge.setUsingSelect(select);
      jj_consume_token(326);
      break;
      }
    default:
      jj_la1[112] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ACTION:
    case K_ACTIVE:
    case K_ALGORITHM:
    case K_ARCHIVE:
    case K_ARRAY_LITERAL:
    case K_AS:
    case K_AT:
    case K_BYTE:
    case K_CASCADE:
    case K_CASE:
    case K_CAST:
    case K_TRY_CAST:
    case K_CHARACTER:
    case K_CHANGE:
    case K_CHECKPOINT:
    case K_CHAR:
    case K_COLUMN:
    case K_COLUMNS:
    case K_COMMIT:
    case K_COMMENT:
    case K_COSTS:
    case K_CYCLE:
    case K_DATETIMELITERAL:
    case K_DATE_LITERAL:
    case K_DBA_RECYCLEBIN:
    case K_DEFAULT:
    case K_DESC:
    case K_DESCRIBE:
    case K_DISABLE:
    case K_DISCONNECT:
    case K_DIV:
    case K_DO:
    case K_DUMP:
    case K_DUPLICATE:
    case K_ENABLE:
    case K_END:
    case K_EXCLUDE:
    case K_EXTRACT:
    case K_FILTER:
    case K_FIRST:
    case K_FALSE:
    case K_FLUSH:
    case K_FOLLOWING:
    case K_FORMAT:
    case K_FULLTEXT:
    case K_HISTORY:
    case K_INDEX:
    case K_INSERT:
    case K_INTERVAL:
    case K_ISNULL:
    case K_JSON:
    case K_KEY:
    case K_FN:
    case K_LAST:
    case K_LEADING:
    case K_LOCAL:
    case K_LINK:
    case K_LOG:
    case K_MATERIALIZED:
    case K_NEXTVAL:
    case K_NO:
    case K_NOLOCK:
    case K_NULLS:
    case K_OF:
    case K_OPEN:
    case K_OVER:
    case K_PARALLEL:
    case K_PARTITION:
    case K_PATH:
    case K_PERCENT:
    case K_PRECISION:
    case K_PRIMARY:
    case K_PRIOR:
    case K_QUERY:
    case K_QUIESCE:
    case K_RANGE:
    case K_READ:
    case K_RECYCLEBIN:
    case K_REGISTER:
    case K_REPLACE:
    case K_RESUME:
    case K_RESTRICTED:
    case K_ROW:
    case K_ROWS:
    case K_SCHEMA:
    case K_SEQUENCE:
    case K_SEPARATOR:
    case K_SESSION:
    case K_SHUTDOWN:
    case K_SIBLINGS:
    case K_SIZE:
    case K_SKIP:
    case K_SUSPEND:
    case K_SWITCH:
    case K_SYNONYM:
    case K_SYSTEM:
    case K_TABLE:
    case K_TABLESPACE:
    case K_TEMP:
    case K_TEMPORARY:
    case K_TIMEOUT:
    case K_TO:
    case K_TOP:
    case K_TRUNCATE:
    case K_TRUE:
    case K_TYPE:
    case K_UNQIESCE:
    case K_USER:
    case K_SIGNED:
    case K_STRING_FUNCTION_NAME:
    case K_UNSIGNED:
    case K_VALIDATE:
    case K_VALUE:
    case K_VALUES:
    case K_VIEW:
    case K_XML:
    case K_ZONE:
    case S_IDENTIFIER:
    case S_CHAR_LITERAL:
    case S_QUOTED_IDENTIFIER:{
      alias = Alias();
merge.setUsingAlias(alias);
      break;
      }
    default:
      jj_la1[113] = jj_gen;
      ;
    }
    jj_consume_token(K_ON);
    jj_consume_token(325);
    condition = Expression();
merge.setOnCondition(condition);
    jj_consume_token(326);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_WHEN:{
      if (jj_2_55(2)) {
        update = MergeUpdateClause();
merge.setMergeUpdate(update);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_WHEN:{
          insert = MergeInsertClause();
merge.setMergeInsert(insert);
          break;
          }
        default:
          jj_la1[114] = jj_gen;
          ;
        }
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_WHEN:{
          insert = MergeInsertClause();
merge.withMergeInsert(insert).withInsertFirst(true);
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_WHEN:{
            update = MergeUpdateClause();
merge.setMergeUpdate(update);
            break;
            }
          default:
            jj_la1[115] = jj_gen;
            ;
          }
          break;
          }
        default:
          jj_la1[116] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      break;
      }
    default:
      jj_la1[117] = jj_gen;
      ;
    }
return merge.withWithItemsList(with);
}

  final public MergeUpdate MergeUpdateClause() throws ParseException {MergeUpdate mu = new MergeUpdate();
    List<Column> columns = new ArrayList<Column>();
    List<Expression> expList = new ArrayList<Expression>();
    Column col;
    Expression exp;
    Expression condition;
    jj_consume_token(K_WHEN);
    jj_consume_token(K_MATCHED);
    jj_consume_token(K_THEN);
    jj_consume_token(K_UPDATE);
    jj_consume_token(K_SET);
    col = Column();
    jj_consume_token(327);
    exp = SimpleExpression();
columns.add(col); expList.add(exp);
    label_33:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COMMA:{
        ;
        break;
        }
      default:
        jj_la1[118] = jj_gen;
        break label_33;
      }
      jj_consume_token(K_COMMA);
      col = Column();
      jj_consume_token(327);
      exp = SimpleExpression();
columns.add(col); expList.add(exp);
    }
mu.withColumns(columns).withValues(expList);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_WHERE:{
      jj_consume_token(K_WHERE);
      condition = Expression();
mu.setWhereCondition(condition);
      break;
      }
    default:
      jj_la1[119] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_DELETE:{
      jj_consume_token(K_DELETE);
      jj_consume_token(K_WHERE);
      condition = Expression();
mu.setDeleteWhereCondition(condition);
      break;
      }
    default:
      jj_la1[120] = jj_gen;
      ;
    }
return mu;
}

  final public MergeInsert MergeInsertClause() throws ParseException {MergeInsert mi = new MergeInsert();
    List<Column> columns = new ArrayList<Column>();
    List<Expression> expList = new ArrayList<Expression>();
    Column col;
    Expression exp;
    Expression condition;
    jj_consume_token(K_WHEN);
    jj_consume_token(K_NOT);
    jj_consume_token(K_MATCHED);
    jj_consume_token(K_THEN);
    jj_consume_token(K_INSERT);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case 325:{
      jj_consume_token(325);
      col = Column();
columns.add(col);
      label_34:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_COMMA:{
          ;
          break;
          }
        default:
          jj_la1[121] = jj_gen;
          break label_34;
        }
        jj_consume_token(K_COMMA);
        col = Column();
columns.add(col);
      }
      jj_consume_token(326);
      break;
      }
    default:
      jj_la1[122] = jj_gen;
      ;
    }
    jj_consume_token(K_VALUES);
    jj_consume_token(325);
    exp = SimpleExpression();
expList.add(exp);
    label_35:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COMMA:{
        ;
        break;
        }
      default:
        jj_la1[123] = jj_gen;
        break label_35;
      }
      jj_consume_token(K_COMMA);
      exp = SimpleExpression();
expList.add(exp);
    }
    jj_consume_token(326);
mi.withColumns(columns).withValues(expList);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_WHERE:{
      jj_consume_token(K_WHERE);
      condition = Expression();
mi.setWhereCondition(condition);
      break;
      }
    default:
      jj_la1[124] = jj_gen;
      ;
    }
return mi;
}

  final public List<String> RelObjectNameList() throws ParseException {String token = null;
    List<String> data = new ArrayList<String>();
    token = RelObjectNameExt();
data.add(token);
    label_36:
    while (true) {
      if (jj_2_56(2)) {
        ;
      } else {
        break label_36;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 329:{
        jj_consume_token(329);
        break;
        }
      case 330:{
        jj_consume_token(330);
        break;
        }
      default:
        jj_la1[125] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      label_37:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 329:{
          ;
          break;
          }
        default:
          jj_la1[126] = jj_gen;
          break label_37;
        }
        jj_consume_token(329);
data.add(null);
      }
      token = RelObjectNameExt2();
data.add(token);
    }
return data;
}

// See: http://technet.microsoft.com/en-us/library/ms187879%28v=sql.105%29.aspx
  final public 
Column Column() throws ParseException {/*@bgen(jjtree) Column */
    SimpleNode jjtn000 = new SimpleNode(JJTCOLUMN);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));List<String> data = new ArrayList<String>();
    try {
      data = RelObjectNameList();
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
Column col = new Column(data);
        linkAST(col,jjtn000);
        return col;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return com.javaoffers.thrid.sqlparse.statement in function");
}

/*
Not all names should be allowed for aliases.
*/
  final public String RelObjectNameWithoutValue() throws ParseException {Token tk = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case S_IDENTIFIER:{
      tk = jj_consume_token(S_IDENTIFIER);
      break;
      }
    case S_QUOTED_IDENTIFIER:{
      tk = jj_consume_token(S_QUOTED_IDENTIFIER);
      break;
      }
    case K_ALGORITHM:{
      tk = jj_consume_token(K_ALGORITHM);
      break;
      }
    case K_AT:{
      tk = jj_consume_token(K_AT);
      break;
      }
    case K_BYTE:{
      tk = jj_consume_token(K_BYTE);
      break;
      }
    case K_CHAR:{
      tk = jj_consume_token(K_CHAR);
      break;
      }
    case K_CHANGE:{
      tk = jj_consume_token(K_CHANGE);
      break;
      }
    case K_CHARACTER:{
      tk = jj_consume_token(K_CHARACTER);
      break;
      }
    case K_CAST:{
      tk = jj_consume_token(K_CAST);
      break;
      }
    case K_TRY_CAST:{
      tk = jj_consume_token(K_TRY_CAST);
      break;
      }
    case K_COMMENT:{
      tk = jj_consume_token(K_COMMENT);
      break;
      }
    case K_COSTS:{
      tk = jj_consume_token(K_COSTS);
      break;
      }
    case K_DISABLE:{
      tk = jj_consume_token(K_DISABLE);
      break;
      }
    case K_DESC:{
      tk = jj_consume_token(K_DESC);
      break;
      }
    case K_DO:{
      tk = jj_consume_token(K_DO);
      break;
      }
    case K_DEFAULT:{
      tk = jj_consume_token(K_DEFAULT);
      break;
      }
    case K_EXTRACT:{
      tk = jj_consume_token(K_EXTRACT);
      break;
      }
    case K_FILTER:{
      tk = jj_consume_token(K_FILTER);
      break;
      }
    case K_FIRST:{
      tk = jj_consume_token(K_FIRST);
      break;
      }
    case K_FOLLOWING:{
      tk = jj_consume_token(K_FOLLOWING);
      break;
      }
    case K_JSON:{
      tk = jj_consume_token(K_JSON);
      break;
      }
    case K_LAST:{
      tk = jj_consume_token(K_LAST);
      break;
      }
    case K_LEADING:{
      tk = jj_consume_token(K_LEADING);
      break;
      }
    case K_MATERIALIZED:{
      tk = jj_consume_token(K_MATERIALIZED);
      break;
      }
    case K_NULLS:{
      tk = jj_consume_token(K_NULLS);
      break;
      }
    case K_PARTITION:{
      tk = jj_consume_token(K_PARTITION);
      break;
      }
    case K_RANGE:{
      tk = jj_consume_token(K_RANGE);
      break;
      }
    case K_ROW:{
      tk = jj_consume_token(K_ROW);
      break;
      }
    case K_ROWS:{
      tk = jj_consume_token(K_ROWS);
      break;
      }
    case K_SIBLINGS:{
      tk = jj_consume_token(K_SIBLINGS);
      break;
      }
    case K_XML:{
      tk = jj_consume_token(K_XML);
      break;
      }
    case K_COLUMN:{
      tk = jj_consume_token(K_COLUMN);
      break;
      }
    case K_REPLACE:{
      tk = jj_consume_token(K_REPLACE);
      break;
      }
    case K_TRUNCATE:{
      tk = jj_consume_token(K_TRUNCATE);
      break;
      }
    case K_KEY:{
      tk = jj_consume_token(K_KEY);
      break;
      }
    case K_OPEN:{
      tk = jj_consume_token(K_OPEN);
      break;
      }
    case K_OVER:{
      tk = jj_consume_token(K_OVER);
      break;
      }
    case K_PERCENT:{
      tk = jj_consume_token(K_PERCENT);
      break;
      }
    case K_PRIOR:{
      tk = jj_consume_token(K_PRIOR);
      break;
      }
    case K_SEPARATOR:{
      tk = jj_consume_token(K_SEPARATOR);
      break;
      }
    case K_NO:{
      tk = jj_consume_token(K_NO);
      break;
      }
    case K_ACTION:{
      tk = jj_consume_token(K_ACTION);
      break;
      }
    case K_CASCADE:{
      tk = jj_consume_token(K_CASCADE);
      break;
      }
    case K_END:{
      tk = jj_consume_token(K_END);
      break;
      }
    case K_TABLE:{
      tk = jj_consume_token(K_TABLE);
      break;
      }
    case K_DATETIMELITERAL:{
      tk = jj_consume_token(K_DATETIMELITERAL);
      break;
      }
    case K_COMMIT:{
      tk = jj_consume_token(K_COMMIT);
      break;
      }
    case K_PRECISION:{
      tk = jj_consume_token(K_PRECISION);
      break;
      }
    case K_INSERT:{
      tk = jj_consume_token(K_INSERT);
      break;
      }
    case K_INDEX:{
      tk = jj_consume_token(K_INDEX);
      break;
      }
    case K_PRIMARY:{
      tk = jj_consume_token(K_PRIMARY);
      break;
      }
    case K_ENABLE:{
      tk = jj_consume_token(K_ENABLE);
      break;
      }
    case K_TEMP:{
      tk = jj_consume_token(K_TEMP);
      break;
      }
    case K_TEMPORARY:{
      tk = jj_consume_token(K_TEMPORARY);
      break;
      }
    case K_TO:{
      tk = jj_consume_token(K_TO);
      break;
      }
    case K_TYPE:{
      tk = jj_consume_token(K_TYPE);
      break;
      }
    case K_ISNULL:{
      tk = jj_consume_token(K_ISNULL);
      break;
      }
    case K_ZONE:{
      tk = jj_consume_token(K_ZONE);
      break;
      }
    case K_COLUMNS:{
      tk = jj_consume_token(K_COLUMNS);
      break;
      }
    case K_DESCRIBE:{
      tk = jj_consume_token(K_DESCRIBE);
      break;
      }
    case K_FN:{
      tk = jj_consume_token(K_FN);
      break;
      }
    case K_PATH:{
      tk = jj_consume_token(K_PATH);
      break;
      }
    case K_DATE_LITERAL:{
      tk = jj_consume_token(K_DATE_LITERAL);
      break;
      }
    case K_NEXTVAL:{
      tk = jj_consume_token(K_NEXTVAL);
      break;
      }
    case K_TRUE:{
      tk = jj_consume_token(K_TRUE);
      break;
      }
    case K_FALSE:{
      tk = jj_consume_token(K_FALSE);
      break;
      }
    case K_DUPLICATE:{
      tk = jj_consume_token(K_DUPLICATE);
      break;
      }
    case K_READ:{
      tk = jj_consume_token(K_READ);
      break;
      }
    case K_SCHEMA:{
      tk = jj_consume_token(K_SCHEMA);
      break;
      }
    case K_SIGNED:{
      tk = jj_consume_token(K_SIGNED);
      break;
      }
    case K_SIZE:{
      tk = jj_consume_token(K_SIZE);
      break;
      }
    case K_SEQUENCE:{
      tk = jj_consume_token(K_SEQUENCE);
      break;
      }
    case K_SESSION:{
      tk = jj_consume_token(K_SESSION);
      break;
      }
    case K_SKIP:{
      tk = jj_consume_token(K_SKIP);
      break;
      }
    case K_SYNONYM:{
      tk = jj_consume_token(K_SYNONYM);
      break;
      }
    case K_VIEW:{
      tk = jj_consume_token(K_VIEW);
      break;
      }
    case K_NOLOCK:{
      tk = jj_consume_token(K_NOLOCK);
      break;
      }
    case K_VALIDATE:{
      tk = jj_consume_token(K_VALIDATE);
      break;
      }
    case K_CYCLE:{
      tk = jj_consume_token(K_CYCLE);
      break;
      }
    case K_OF:{
      tk = jj_consume_token(K_OF);
      break;
      }
    case K_EXCLUDE:{
      tk = jj_consume_token(K_EXCLUDE);
      break;
      }
    case K_FORMAT:{
      tk = jj_consume_token(K_FORMAT);
      break;
      }
    case K_DIV:{
      tk = jj_consume_token(K_DIV);
      break;
      }
    case K_UNSIGNED:{
      tk = jj_consume_token(K_UNSIGNED);
      break;
      }
    case K_CASE:{
      tk = jj_consume_token(K_CASE);
      break;
      }
    case K_LOCAL:{
      tk = jj_consume_token(K_LOCAL);
      break;
      }
    case K_ARRAY_LITERAL:{
      tk = jj_consume_token(K_ARRAY_LITERAL);
      break;
      }
    case K_STRING_FUNCTION_NAME:{
      tk = jj_consume_token(K_STRING_FUNCTION_NAME);
      break;
      }
    case K_USER:{
      tk = jj_consume_token(K_USER);
      break;
      }
    case K_RECYCLEBIN:{
      tk = jj_consume_token(K_RECYCLEBIN);
      break;
      }
    case K_DBA_RECYCLEBIN:{
      tk = jj_consume_token(K_DBA_RECYCLEBIN);
      break;
      }
    case K_TIMEOUT:{
      tk = jj_consume_token(K_TIMEOUT);
      break;
      }
    case K_PARALLEL:{
      tk = jj_consume_token(K_PARALLEL);
      break;
      }
    case K_LINK:{
      tk = jj_consume_token(K_LINK);
      break;
      }
    case K_LOG:{
      tk = jj_consume_token(K_LOG);
      break;
      }
    case K_DUMP:{
      tk = jj_consume_token(K_DUMP);
      break;
      }
    case K_FLUSH:{
      tk = jj_consume_token(K_FLUSH);
      break;
      }
    case K_ACTIVE:{
      tk = jj_consume_token(K_ACTIVE);
      break;
      }
    case K_RESUME:{
      tk = jj_consume_token(K_RESUME);
      break;
      }
    case K_SWITCH:{
      tk = jj_consume_token(K_SWITCH);
      break;
      }
    case K_SUSPEND:{
      tk = jj_consume_token(K_SUSPEND);
      break;
      }
    case K_ARCHIVE:{
      tk = jj_consume_token(K_ARCHIVE);
      break;
      }
    case K_QUIESCE:{
      tk = jj_consume_token(K_QUIESCE);
      break;
      }
    case K_HISTORY:{
      tk = jj_consume_token(K_HISTORY);
      break;
      }
    case K_SHUTDOWN:{
      tk = jj_consume_token(K_SHUTDOWN);
      break;
      }
    case K_REGISTER:{
      tk = jj_consume_token(K_REGISTER);
      break;
      }
    case K_UNQIESCE:{
      tk = jj_consume_token(K_UNQIESCE);
      break;
      }
    case K_RESTRICTED:{
      tk = jj_consume_token(K_RESTRICTED);
      break;
      }
    case K_CHECKPOINT:{
      tk = jj_consume_token(K_CHECKPOINT);
      break;
      }
    case K_DISCONNECT:{
      tk = jj_consume_token(K_DISCONNECT);
      break;
      }
    case K_SYSTEM:{
      tk = jj_consume_token(K_SYSTEM);
      break;
      }
    case K_QUERY:{
      tk = jj_consume_token(K_QUERY);
      break;
      }
    case K_FULLTEXT:{
      tk = jj_consume_token(K_FULLTEXT);
      break;
      }
    case K_TABLESPACE:{
      tk = jj_consume_token(K_TABLESPACE);
      break;
      }
    default:
      jj_la1[127] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return tk.image;
}

/*
Normal names.
*/
  final public String RelObjectName() throws ParseException {Token tk = null; String result = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ACTION:
    case K_ACTIVE:
    case K_ALGORITHM:
    case K_ARCHIVE:
    case K_ARRAY_LITERAL:
    case K_AT:
    case K_BYTE:
    case K_CASCADE:
    case K_CASE:
    case K_CAST:
    case K_TRY_CAST:
    case K_CHARACTER:
    case K_CHANGE:
    case K_CHECKPOINT:
    case K_CHAR:
    case K_COLUMN:
    case K_COLUMNS:
    case K_COMMIT:
    case K_COMMENT:
    case K_COSTS:
    case K_CYCLE:
    case K_DATETIMELITERAL:
    case K_DATE_LITERAL:
    case K_DBA_RECYCLEBIN:
    case K_DEFAULT:
    case K_DESC:
    case K_DESCRIBE:
    case K_DISABLE:
    case K_DISCONNECT:
    case K_DIV:
    case K_DO:
    case K_DUMP:
    case K_DUPLICATE:
    case K_ENABLE:
    case K_END:
    case K_EXCLUDE:
    case K_EXTRACT:
    case K_FILTER:
    case K_FIRST:
    case K_FALSE:
    case K_FLUSH:
    case K_FOLLOWING:
    case K_FORMAT:
    case K_FULLTEXT:
    case K_HISTORY:
    case K_INDEX:
    case K_INSERT:
    case K_ISNULL:
    case K_JSON:
    case K_KEY:
    case K_FN:
    case K_LAST:
    case K_LEADING:
    case K_LOCAL:
    case K_LINK:
    case K_LOG:
    case K_MATERIALIZED:
    case K_NEXTVAL:
    case K_NO:
    case K_NOLOCK:
    case K_NULLS:
    case K_OF:
    case K_OPEN:
    case K_OVER:
    case K_PARALLEL:
    case K_PARTITION:
    case K_PATH:
    case K_PERCENT:
    case K_PRECISION:
    case K_PRIMARY:
    case K_PRIOR:
    case K_QUERY:
    case K_QUIESCE:
    case K_RANGE:
    case K_READ:
    case K_RECYCLEBIN:
    case K_REGISTER:
    case K_REPLACE:
    case K_RESUME:
    case K_RESTRICTED:
    case K_ROW:
    case K_ROWS:
    case K_SCHEMA:
    case K_SEQUENCE:
    case K_SEPARATOR:
    case K_SESSION:
    case K_SHUTDOWN:
    case K_SIBLINGS:
    case K_SIZE:
    case K_SKIP:
    case K_SUSPEND:
    case K_SWITCH:
    case K_SYNONYM:
    case K_SYSTEM:
    case K_TABLE:
    case K_TABLESPACE:
    case K_TEMP:
    case K_TEMPORARY:
    case K_TIMEOUT:
    case K_TO:
    case K_TRUNCATE:
    case K_TRUE:
    case K_TYPE:
    case K_UNQIESCE:
    case K_USER:
    case K_SIGNED:
    case K_STRING_FUNCTION_NAME:
    case K_UNSIGNED:
    case K_VALIDATE:
    case K_VIEW:
    case K_XML:
    case K_ZONE:
    case S_IDENTIFIER:
    case S_QUOTED_IDENTIFIER:{
      result = RelObjectNameWithoutValue();
      break;
      }
    case K_GROUP:{
      tk = jj_consume_token(K_GROUP);
      break;
      }
    case K_INTERVAL:{
      tk = jj_consume_token(K_INTERVAL);
      break;
      }
    case K_ON:{
      tk = jj_consume_token(K_ON);
      break;
      }
    case K_ORDER:{
      tk = jj_consume_token(K_ORDER);
      break;
      }
    case K_START:{
      tk = jj_consume_token(K_START);
      break;
      }
    case K_TOP:{
      tk = jj_consume_token(K_TOP);
      break;
      }
    case K_VALUE:{
      tk = jj_consume_token(K_VALUE);
      break;
      }
    case K_VALUES:{
      tk = jj_consume_token(K_VALUES);
      break;
      }
    case K_CREATE:{
      tk = jj_consume_token(K_CREATE);
      break;
      }
    case K_TABLES:{
      tk = jj_consume_token(K_TABLES);
      break;
      }
    default:
      jj_la1[128] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
if (tk!=null) result=tk.image;
                return result;
}

  final public String RelObjectNameWithoutStart() throws ParseException {Token tk = null; String result = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ACTION:
    case K_ACTIVE:
    case K_ALGORITHM:
    case K_ARCHIVE:
    case K_ARRAY_LITERAL:
    case K_AT:
    case K_BYTE:
    case K_CASCADE:
    case K_CASE:
    case K_CAST:
    case K_TRY_CAST:
    case K_CHARACTER:
    case K_CHANGE:
    case K_CHECKPOINT:
    case K_CHAR:
    case K_COLUMN:
    case K_COLUMNS:
    case K_COMMIT:
    case K_COMMENT:
    case K_COSTS:
    case K_CYCLE:
    case K_DATETIMELITERAL:
    case K_DATE_LITERAL:
    case K_DBA_RECYCLEBIN:
    case K_DEFAULT:
    case K_DESC:
    case K_DESCRIBE:
    case K_DISABLE:
    case K_DISCONNECT:
    case K_DIV:
    case K_DO:
    case K_DUMP:
    case K_DUPLICATE:
    case K_ENABLE:
    case K_END:
    case K_EXCLUDE:
    case K_EXTRACT:
    case K_FILTER:
    case K_FIRST:
    case K_FALSE:
    case K_FLUSH:
    case K_FOLLOWING:
    case K_FORMAT:
    case K_FULLTEXT:
    case K_HISTORY:
    case K_INDEX:
    case K_INSERT:
    case K_ISNULL:
    case K_JSON:
    case K_KEY:
    case K_FN:
    case K_LAST:
    case K_LEADING:
    case K_LOCAL:
    case K_LINK:
    case K_LOG:
    case K_MATERIALIZED:
    case K_NEXTVAL:
    case K_NO:
    case K_NOLOCK:
    case K_NULLS:
    case K_OF:
    case K_OPEN:
    case K_OVER:
    case K_PARALLEL:
    case K_PARTITION:
    case K_PATH:
    case K_PERCENT:
    case K_PRECISION:
    case K_PRIMARY:
    case K_PRIOR:
    case K_QUERY:
    case K_QUIESCE:
    case K_RANGE:
    case K_READ:
    case K_RECYCLEBIN:
    case K_REGISTER:
    case K_REPLACE:
    case K_RESUME:
    case K_RESTRICTED:
    case K_ROW:
    case K_ROWS:
    case K_SCHEMA:
    case K_SEQUENCE:
    case K_SEPARATOR:
    case K_SESSION:
    case K_SHUTDOWN:
    case K_SIBLINGS:
    case K_SIZE:
    case K_SKIP:
    case K_SUSPEND:
    case K_SWITCH:
    case K_SYNONYM:
    case K_SYSTEM:
    case K_TABLE:
    case K_TABLESPACE:
    case K_TEMP:
    case K_TEMPORARY:
    case K_TIMEOUT:
    case K_TO:
    case K_TRUNCATE:
    case K_TRUE:
    case K_TYPE:
    case K_UNQIESCE:
    case K_USER:
    case K_SIGNED:
    case K_STRING_FUNCTION_NAME:
    case K_UNSIGNED:
    case K_VALIDATE:
    case K_VIEW:
    case K_XML:
    case K_ZONE:
    case S_IDENTIFIER:
    case S_QUOTED_IDENTIFIER:{
      result = RelObjectNameWithoutValue();
      break;
      }
    case K_TOP:{
      tk = jj_consume_token(K_TOP);
      break;
      }
    case K_VALUE:{
      tk = jj_consume_token(K_VALUE);
      break;
      }
    case K_VALUES:{
      tk = jj_consume_token(K_VALUES);
      break;
      }
    case K_INTERVAL:{
      tk = jj_consume_token(K_INTERVAL);
      break;
      }
    default:
      jj_la1[129] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
if (tk!=null) result=tk.image;
                return result;
}

/*
Extended version of object names.
*/
  final public String RelObjectNameExt() throws ParseException {Token tk = null;
  String result=null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ACTION:
    case K_ACTIVE:
    case K_ALGORITHM:
    case K_ARCHIVE:
    case K_ARRAY_LITERAL:
    case K_AT:
    case K_BYTE:
    case K_CASCADE:
    case K_CASE:
    case K_CAST:
    case K_TRY_CAST:
    case K_CHARACTER:
    case K_CHANGE:
    case K_CHECKPOINT:
    case K_CHAR:
    case K_COLUMN:
    case K_COLUMNS:
    case K_COMMIT:
    case K_COMMENT:
    case K_COSTS:
    case K_CREATE:
    case K_CYCLE:
    case K_DATETIMELITERAL:
    case K_DATE_LITERAL:
    case K_DBA_RECYCLEBIN:
    case K_DEFAULT:
    case K_DESC:
    case K_DESCRIBE:
    case K_DISABLE:
    case K_DISCONNECT:
    case K_DIV:
    case K_DO:
    case K_DUMP:
    case K_DUPLICATE:
    case K_ENABLE:
    case K_END:
    case K_EXCLUDE:
    case K_EXTRACT:
    case K_FILTER:
    case K_FIRST:
    case K_FALSE:
    case K_FLUSH:
    case K_FOLLOWING:
    case K_FORMAT:
    case K_FULLTEXT:
    case K_GROUP:
    case K_HISTORY:
    case K_INDEX:
    case K_INSERT:
    case K_INTERVAL:
    case K_ISNULL:
    case K_JSON:
    case K_KEY:
    case K_FN:
    case K_LAST:
    case K_LEADING:
    case K_LOCAL:
    case K_LINK:
    case K_LOG:
    case K_MATERIALIZED:
    case K_NEXTVAL:
    case K_NO:
    case K_NOLOCK:
    case K_NULLS:
    case K_OF:
    case K_ON:
    case K_OPEN:
    case K_ORDER:
    case K_OVER:
    case K_PARALLEL:
    case K_PARTITION:
    case K_PATH:
    case K_PERCENT:
    case K_PRECISION:
    case K_PRIMARY:
    case K_PRIOR:
    case K_QUERY:
    case K_QUIESCE:
    case K_RANGE:
    case K_READ:
    case K_RECYCLEBIN:
    case K_REGISTER:
    case K_REPLACE:
    case K_RESUME:
    case K_RESTRICTED:
    case K_ROW:
    case K_ROWS:
    case K_SCHEMA:
    case K_SEQUENCE:
    case K_SEPARATOR:
    case K_SESSION:
    case K_SHUTDOWN:
    case K_SIBLINGS:
    case K_SIZE:
    case K_SKIP:
    case K_START:
    case K_SUSPEND:
    case K_SWITCH:
    case K_SYNONYM:
    case K_SYSTEM:
    case K_TABLE:
    case K_TABLES:
    case K_TABLESPACE:
    case K_TEMP:
    case K_TEMPORARY:
    case K_TIMEOUT:
    case K_TO:
    case K_TOP:
    case K_TRUNCATE:
    case K_TRUE:
    case K_TYPE:
    case K_UNQIESCE:
    case K_USER:
    case K_SIGNED:
    case K_STRING_FUNCTION_NAME:
    case K_UNSIGNED:
    case K_VALIDATE:
    case K_VALUE:
    case K_VALUES:
    case K_VIEW:
    case K_XML:
    case K_ZONE:
    case S_IDENTIFIER:
    case S_QUOTED_IDENTIFIER:{
      result = RelObjectName();
      break;
      }
    case K_ALL:{
      tk = jj_consume_token(K_ALL);
      break;
      }
    case K_ANY:{
      tk = jj_consume_token(K_ANY);
      break;
      }
    case K_SOME:{
      tk = jj_consume_token(K_SOME);
      break;
      }
    case K_LEFT:{
      tk = jj_consume_token(K_LEFT);
      break;
      }
    case K_RIGHT:{
      tk = jj_consume_token(K_RIGHT);
      break;
      }
    case K_SET:{
      tk = jj_consume_token(K_SET);
      break;
      }
    case K_DOUBLE:{
      tk = jj_consume_token(K_DOUBLE);
      break;
      }
    case K_IF:{
      tk = jj_consume_token(K_IF);
      break;
      }
    case K_IIF:{
      tk = jj_consume_token(K_IIF);
      break;
      }
    case K_OPTIMIZE:{
      tk = jj_consume_token(K_OPTIMIZE);
      break;
      }
    case K_LIMIT:{
      tk = jj_consume_token(K_LIMIT);
      break;
      }
    case K_OFFSET:{
      tk = jj_consume_token(K_OFFSET);
      break;
      }
    case K_PROCEDURE:{
      tk = jj_consume_token(K_PROCEDURE);
      break;
      }
    case K_PUBLIC:{
      tk = jj_consume_token(K_PUBLIC);
      break;
      }
    case K_CASEWHEN:{
      tk = jj_consume_token(K_CASEWHEN);
      break;
      }
    case K_IN:{
      tk = jj_consume_token(K_IN);
      break;
      }
    case K_GROUPING:{
      tk = jj_consume_token(K_GROUPING);
      break;
      }
    default:
      jj_la1[130] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
if (tk!=null) result=tk.image;
        return result;
}

/*
Extended usage of object names - part 2. Using within multipart names as following parts.
*/
  final public String RelObjectNameExt2() throws ParseException {Token tk = null;
  String result=null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ACTION:
    case K_ACTIVE:
    case K_ALGORITHM:
    case K_ALL:
    case K_ANY:
    case K_ARCHIVE:
    case K_ARRAY_LITERAL:
    case K_AT:
    case K_BYTE:
    case K_CASCADE:
    case K_CASE:
    case K_CASEWHEN:
    case K_CAST:
    case K_TRY_CAST:
    case K_CHARACTER:
    case K_CHANGE:
    case K_CHECKPOINT:
    case K_CHAR:
    case K_COLUMN:
    case K_COLUMNS:
    case K_COMMIT:
    case K_COMMENT:
    case K_COSTS:
    case K_CREATE:
    case K_CYCLE:
    case K_DATETIMELITERAL:
    case K_DATE_LITERAL:
    case K_DBA_RECYCLEBIN:
    case K_DEFAULT:
    case K_DESC:
    case K_DESCRIBE:
    case K_DISABLE:
    case K_DISCONNECT:
    case K_DIV:
    case K_DO:
    case K_DOUBLE:
    case K_DUMP:
    case K_DUPLICATE:
    case K_ENABLE:
    case K_END:
    case K_EXCLUDE:
    case K_EXTRACT:
    case K_FILTER:
    case K_FIRST:
    case K_FALSE:
    case K_FLUSH:
    case K_FOLLOWING:
    case K_FORMAT:
    case K_FULLTEXT:
    case K_GROUP:
    case K_GROUPING:
    case K_HISTORY:
    case K_IF:
    case K_IIF:
    case K_IN:
    case K_INDEX:
    case K_INSERT:
    case K_INTERVAL:
    case K_ISNULL:
    case K_JSON:
    case K_KEY:
    case K_FN:
    case K_LAST:
    case K_LEADING:
    case K_LEFT:
    case K_LIMIT:
    case K_LOCAL:
    case K_LINK:
    case K_LOG:
    case K_MATERIALIZED:
    case K_NEXTVAL:
    case K_NO:
    case K_NOLOCK:
    case K_NULLS:
    case K_OF:
    case K_OFFSET:
    case K_ON:
    case K_OPEN:
    case K_ORDER:
    case K_OVER:
    case K_OPTIMIZE:
    case K_PARALLEL:
    case K_PARTITION:
    case K_PATH:
    case K_PERCENT:
    case K_PRECISION:
    case K_PRIMARY:
    case K_PRIOR:
    case K_PROCEDURE:
    case K_PUBLIC:
    case K_QUERY:
    case K_QUIESCE:
    case K_RANGE:
    case K_READ:
    case K_RECYCLEBIN:
    case K_REGISTER:
    case K_REPLACE:
    case K_RESUME:
    case K_RESTRICTED:
    case K_RIGHT:
    case K_ROW:
    case K_ROWS:
    case K_SCHEMA:
    case K_SEQUENCE:
    case K_SEPARATOR:
    case K_SESSION:
    case K_SET:
    case K_SHUTDOWN:
    case K_SIBLINGS:
    case K_SIZE:
    case K_SKIP:
    case K_SOME:
    case K_START:
    case K_SUSPEND:
    case K_SWITCH:
    case K_SYNONYM:
    case K_SYSTEM:
    case K_TABLE:
    case K_TABLES:
    case K_TABLESPACE:
    case K_TEMP:
    case K_TEMPORARY:
    case K_TIMEOUT:
    case K_TO:
    case K_TOP:
    case K_TRUNCATE:
    case K_TRUE:
    case K_TYPE:
    case K_UNQIESCE:
    case K_USER:
    case K_SIGNED:
    case K_STRING_FUNCTION_NAME:
    case K_UNSIGNED:
    case K_VALIDATE:
    case K_VALUE:
    case K_VALUES:
    case K_VIEW:
    case K_XML:
    case K_ZONE:
    case S_IDENTIFIER:
    case S_QUOTED_IDENTIFIER:{
      result = RelObjectNameExt();
      break;
      }
    case K_FROM:{
      tk = jj_consume_token(K_FROM);
      break;
      }
    case K_SELECT:{
      tk = jj_consume_token(K_SELECT);
      break;
      }
    case K_CURRENT:{
      tk = jj_consume_token(K_CURRENT);
      break;
      }
    default:
      jj_la1[131] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
if (tk!=null) result=tk.image;
        return result;
}

  final public Table Table() throws ParseException {/*@bgen(jjtree) Table */
    SimpleNode jjtn000 = new SimpleNode(JJTTABLE);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));//String serverName = null, databaseName = null, schemaName = null, tableName = null;
    List<String> data = new ArrayList<String>();
    try {
      data = RelObjectNameList();
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
Table table = new Table(data);
                linkAST(table,jjtn000);
        return table;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return com.javaoffers.thrid.sqlparse.statement in function");
}

  final public Table TableWithAlias() throws ParseException {Table table = null;
    Alias alias = null;
    table = Table();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ACTION:
    case K_ACTIVE:
    case K_ALGORITHM:
    case K_ARCHIVE:
    case K_ARRAY_LITERAL:
    case K_AS:
    case K_AT:
    case K_BYTE:
    case K_CASCADE:
    case K_CASE:
    case K_CAST:
    case K_TRY_CAST:
    case K_CHARACTER:
    case K_CHANGE:
    case K_CHECKPOINT:
    case K_CHAR:
    case K_COLUMN:
    case K_COLUMNS:
    case K_COMMIT:
    case K_COMMENT:
    case K_COSTS:
    case K_CYCLE:
    case K_DATETIMELITERAL:
    case K_DATE_LITERAL:
    case K_DBA_RECYCLEBIN:
    case K_DEFAULT:
    case K_DESC:
    case K_DESCRIBE:
    case K_DISABLE:
    case K_DISCONNECT:
    case K_DIV:
    case K_DO:
    case K_DUMP:
    case K_DUPLICATE:
    case K_ENABLE:
    case K_END:
    case K_EXCLUDE:
    case K_EXTRACT:
    case K_FILTER:
    case K_FIRST:
    case K_FALSE:
    case K_FLUSH:
    case K_FOLLOWING:
    case K_FORMAT:
    case K_FULLTEXT:
    case K_HISTORY:
    case K_INDEX:
    case K_INSERT:
    case K_INTERVAL:
    case K_ISNULL:
    case K_JSON:
    case K_KEY:
    case K_FN:
    case K_LAST:
    case K_LEADING:
    case K_LOCAL:
    case K_LINK:
    case K_LOG:
    case K_MATERIALIZED:
    case K_NEXTVAL:
    case K_NO:
    case K_NOLOCK:
    case K_NULLS:
    case K_OF:
    case K_OPEN:
    case K_OVER:
    case K_PARALLEL:
    case K_PARTITION:
    case K_PATH:
    case K_PERCENT:
    case K_PRECISION:
    case K_PRIMARY:
    case K_PRIOR:
    case K_QUERY:
    case K_QUIESCE:
    case K_RANGE:
    case K_READ:
    case K_RECYCLEBIN:
    case K_REGISTER:
    case K_REPLACE:
    case K_RESUME:
    case K_RESTRICTED:
    case K_ROW:
    case K_ROWS:
    case K_SCHEMA:
    case K_SEQUENCE:
    case K_SEPARATOR:
    case K_SESSION:
    case K_SHUTDOWN:
    case K_SIBLINGS:
    case K_SIZE:
    case K_SKIP:
    case K_SUSPEND:
    case K_SWITCH:
    case K_SYNONYM:
    case K_SYSTEM:
    case K_TABLE:
    case K_TABLESPACE:
    case K_TEMP:
    case K_TEMPORARY:
    case K_TIMEOUT:
    case K_TO:
    case K_TOP:
    case K_TRUNCATE:
    case K_TRUE:
    case K_TYPE:
    case K_UNQIESCE:
    case K_USER:
    case K_SIGNED:
    case K_STRING_FUNCTION_NAME:
    case K_UNSIGNED:
    case K_VALIDATE:
    case K_VALUE:
    case K_VALUES:
    case K_VIEW:
    case K_XML:
    case K_ZONE:
    case S_IDENTIFIER:
    case S_CHAR_LITERAL:
    case S_QUOTED_IDENTIFIER:{
      alias = Alias();
table.setAlias(alias);
      break;
      }
    default:
      jj_la1[132] = jj_gen;
      ;
    }
return table;
}

  final public Select SelectWithWithItems() throws ParseException {Select select;
    List<WithItem> with = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_WITH:{
      with = WithList();

      break;
      }
    default:
      jj_la1[133] = jj_gen;
      ;
    }
    select = Select(with);
return select;
}

  final public Select Select(List<WithItem> with) throws ParseException {Select select = new Select();
    SelectBody selectBody = null;
    selectBody = SelectBody();
return select.withWithItemsList(with).withSelectBody(selectBody);
}

  final public SelectBody SelectBody() throws ParseException {SelectBody selectBody = null;
    selectBody = SetOperationList();
return selectBody;
}

  final public PlainSelect PlainSelect() throws ParseException {/*@bgen(jjtree) PlainSelect */
    SimpleNode jjtn000 = new SimpleNode(JJTPLAINSELECT);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));PlainSelect plainSelect = new PlainSelect();
    List<SelectItem> selectItems = null;
    FromItem fromItem = null;
    List<Join> joins = null;
    List<SelectItem> distinctOn = null;
    Expression where = null;
    List<OrderByElement> orderByElements;
    GroupByElement groupBy = null;
    Expression having = null;
    Limit limit = null;
    Offset offset = null;
    Fetch fetch = null;
    WithIsolation withIsolation = null;
    OptimizeFor optimize = null;
    Top top = null;
        Skip skip = null;
        First first = null;
    OracleHierarchicalExpression oracleHierarchicalQueryClause = null;
    List<Table> intoTables = null;
    Table updateTable = null;
    Wait wait = null;
    boolean mySqlSqlCalcFoundRows = false;
    Token token;
    KSQLWindow ksqlWindow = null;
    boolean noWait = false;
    try {
      jj_consume_token(K_SELECT);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_STRAIGHT:{
        jj_consume_token(K_STRAIGHT);
plainSelect.setMySqlHintStraightJoin(true);
        break;
        }
      default:
        jj_la1[134] = jj_gen;
        ;
      }
plainSelect.setOracleHint(getOracleHint());
      if (jj_2_57(2)) {
        skip = Skip();
plainSelect.setSkip(skip);
      } else {
        ;
      }
      if (jj_2_58(2)) {
        first = First();
plainSelect.setFirst(first);
      } else {
        ;
      }
      if (jj_2_60(2)) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_ALL:{
          jj_consume_token(K_ALL);
          break;
          }
        case K_DISTINCT:{
          jj_consume_token(K_DISTINCT);
Distinct distinct = new Distinct(); plainSelect.setDistinct(distinct);
          if (jj_2_59(2)) {
            jj_consume_token(K_ON);
            jj_consume_token(325);
            distinctOn = SelectItemsList();
plainSelect.getDistinct().setOnSelectItems(distinctOn);
            jj_consume_token(326);
          } else {
            ;
          }
          break;
          }
        case K_UNIQUE:{
          jj_consume_token(K_UNIQUE);
Distinct distinct = new Distinct(true); plainSelect.setDistinct(distinct);
          break;
          }
        case K_SQL_CALC_FOUND_ROWS:{
          jj_consume_token(K_SQL_CALC_FOUND_ROWS);
plainSelect.setMySqlSqlCalcFoundRows(true);
          break;
          }
        case K_SQL_NO_CACHE:
        case K_SQL_CACHE:{
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_SQL_NO_CACHE:{
            jj_consume_token(K_SQL_NO_CACHE);
plainSelect.setMySqlSqlCacheFlag(MySqlSqlCacheFlags.SQL_NO_CACHE);
            break;
            }
          case K_SQL_CACHE:{
            jj_consume_token(K_SQL_CACHE);
plainSelect.setMySqlSqlCacheFlag(MySqlSqlCacheFlags.SQL_CACHE);
            break;
            }
          default:
            jj_la1[135] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          break;
          }
        default:
          jj_la1[136] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      } else {
        ;
      }
      if (jj_2_61(2)) {
        top = Top();
plainSelect.setTop(top);
      } else {
        ;
      }
      selectItems = SelectItemsList();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_INTO:{
        intoTables = IntoClause();
plainSelect.setIntoTables(intoTables);
        break;
        }
      default:
        jj_la1[137] = jj_gen;
        ;
      }
      if (jj_2_62(2)) {
        jj_consume_token(K_FROM);
        fromItem = FromItem();
        joins = JoinsList();
      } else {
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_WINDOW:{
        ksqlWindow = KSQLWindowClause();
plainSelect.setKsqlWindow(ksqlWindow);
        break;
        }
      default:
        jj_la1[138] = jj_gen;
        ;
      }
      if (jj_2_63(2)) {
        where = WhereClause();
plainSelect.setWhere(where);
      } else {
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_CONNECT:
      case K_START:{
        oracleHierarchicalQueryClause = OracleHierarchicalQueryClause();
plainSelect.setOracleHierarchical(oracleHierarchicalQueryClause);
        break;
        }
      default:
        jj_la1[139] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_GROUP:{
        groupBy = GroupByColumnReferences();
plainSelect.setGroupByElement(groupBy);
        break;
        }
      default:
        jj_la1[140] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_HAVING:{
        having = Having();
plainSelect.setHaving(having);
        break;
        }
      default:
        jj_la1[141] = jj_gen;
        ;
      }
      if (jj_2_64(2147483647)) {
        orderByElements = OrderByElements();
plainSelect.setOracleSiblings(true); plainSelect.setOrderByElements(orderByElements);
      } else {
        ;
      }
      if (jj_2_65(2147483647)) {
        orderByElements = OrderByElements();
plainSelect.setOrderByElements(orderByElements);
      } else {
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_EMIT:{
        jj_consume_token(K_EMIT);
        jj_consume_token(K_CHANGES);
plainSelect.setEmitChanges(true);
        break;
        }
      default:
        jj_la1[142] = jj_gen;
        ;
      }
      if (jj_2_66(2147483647)) {
        limit = LimitWithOffset();
plainSelect.setLimit(limit);
      } else {
        ;
      }
      if (jj_2_67(2147483647)) {
        offset = Offset();
plainSelect.setOffset(offset);
      } else {
        ;
      }
      if (jj_2_68(2147483647) && (limit==null)) {
        limit = LimitWithOffset();
plainSelect.setLimit(limit);
      } else {
        ;
      }
      if (jj_2_69(2147483647)) {
        fetch = Fetch();
plainSelect.setFetch(fetch);
      } else {
        ;
      }
      if (jj_2_70(2147483647)) {
        withIsolation = WithIsolation();
plainSelect.setWithIsolation(withIsolation);
      } else {
        ;
      }
      if (jj_2_72(2)) {
        jj_consume_token(K_FOR);
        jj_consume_token(K_UPDATE);
plainSelect.setForUpdate(true);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_OF:{
          jj_consume_token(K_OF);
          updateTable = Table();
plainSelect.setForUpdateTable(updateTable);
          break;
          }
        default:
          jj_la1[143] = jj_gen;
          ;
        }
        if (jj_2_71(2147483647)) {
          wait = Wait();
plainSelect.setWait(wait);
        } else {
          ;
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_NOWAIT:{
          jj_consume_token(K_NOWAIT);
plainSelect.setNoWait(true);
          break;
          }
        default:
          jj_la1[144] = jj_gen;
          ;
        }
      } else {
        ;
      }
      if (jj_2_73(2147483647)) {
        optimize = OptimizeFor();
plainSelect.setOptimizeFor(optimize);
      } else {
        ;
      }
      if (jj_2_74(3)) {
        jj_consume_token(K_FOR);
        jj_consume_token(K_XML);
        jj_consume_token(K_PATH);
        jj_consume_token(325);
        token = jj_consume_token(S_CHAR_LITERAL);
        jj_consume_token(326);
plainSelect.setForXmlPath(token.image);
      } else {
        ;
      }
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
plainSelect.setSelectItems(selectItems);
        plainSelect.setFromItem(fromItem);
        if (joins != null && joins.size() > 0)
            plainSelect.setJoins(joins);
        linkAST(plainSelect,jjtn000);
        return plainSelect;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return com.javaoffers.thrid.sqlparse.statement in function");
}

  final public SelectBody SetOperationList() throws ParseException {/*@bgen(jjtree) SetOperationList */
    SimpleNode jjtn000 = new SimpleNode(JJTSETOPERATIONLIST);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));SetOperationList list = new SetOperationList();
    List<OrderByElement> orderByElements = null;
    Limit limit = null;
    Offset offset = null;
    Fetch fetch = null;
    WithIsolation withIsolation = null;
    SelectBody select = null;
    List<SelectBody> selects = new ArrayList<SelectBody>();
    List<SetOperation> operations = new ArrayList<SetOperation>();
    List<Boolean> brackets = new ArrayList<Boolean>();
    boolean bracket = false;
    try {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 325:{
        jj_consume_token(325);
        select = SelectBody();
        jj_consume_token(326);
bracket=true;
        break;
        }
      case K_SELECT:
      case K_VALUES:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_SELECT:{
          select = PlainSelect();
          break;
          }
        case K_VALUES:{
          select = Values();
          break;
          }
        default:
          jj_la1[145] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
bracket=false;
        break;
        }
      default:
        jj_la1[146] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
selects.add(select);brackets.add(bracket);
      label_38:
      while (true) {
        if (jj_2_75(2)) {
          ;
        } else {
          break label_38;
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_UNION:{
          jj_consume_token(K_UNION);
UnionOp union = new UnionOp();linkAST(union,jjtn000);operations.add(union);
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_ALL:
          case K_DISTINCT:{
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_ALL:{
              jj_consume_token(K_ALL);
union.setAll(true);
              break;
              }
            case K_DISTINCT:{
              jj_consume_token(K_DISTINCT);
union.setDistinct(true);
              break;
              }
            default:
              jj_la1[147] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
            break;
            }
          default:
            jj_la1[148] = jj_gen;
            ;
          }
          break;
          }
        case K_INTERSECT:{
          jj_consume_token(K_INTERSECT);
operations.add(new IntersectOp());
          break;
          }
        case K_MINUS:{
          jj_consume_token(K_MINUS);
operations.add(new MinusOp());
          break;
          }
        case K_EXCEPT:{
          jj_consume_token(K_EXCEPT);
operations.add(new ExceptOp());
          break;
          }
        default:
          jj_la1[149] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 325:{
          jj_consume_token(325);
          select = SelectBody();
          jj_consume_token(326);
bracket=true;
          break;
          }
        case K_SELECT:
        case K_VALUES:{
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_SELECT:{
            select = PlainSelect();
            break;
            }
          case K_VALUES:{
            select = Values();
            break;
            }
          default:
            jj_la1[150] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
bracket=false;
          break;
          }
        default:
          jj_la1[151] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
selects.add(select);brackets.add(bracket);
      }
      if (jj_2_76(2)) {
        orderByElements = OrderByElements();
list.setOrderByElements(orderByElements);
      } else {
        ;
      }
      if (jj_2_77(2147483647)) {
        limit = LimitWithOffset();
list.setLimit(limit);
      } else {
        ;
      }
      if (jj_2_78(2147483647)) {
        offset = Offset();
list.setOffset(offset);
      } else {
        ;
      }
      if (jj_2_79(2147483647)) {
        fetch = Fetch();
list.setFetch(fetch);
      } else {
        ;
      }
      if (jj_2_80(2147483647)) {
        withIsolation = WithIsolation();
list.setWithIsolation(withIsolation);
      } else {
        ;
      }
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
if (selects.size()==1 && selects.get(0) instanceof PlainSelect && orderByElements==null) {
            if (brackets.get(0)) {
                if (limit==null && offset==null && fetch==null && withIsolation==null)
                    ((PlainSelect)selects.get(0)).setUseBrackets(true);
                else {
                    list.setBracketsOpsAndSelects(brackets,selects,operations);
                    return list;    //brackets with outside limit, offset
                }
            }
            return selects.get(0);
        } else {
            if (selects.size()>1 && selects.get(selects.size()-1) instanceof PlainSelect && !brackets.get(brackets.size() - 1)) {
                PlainSelect ps = (PlainSelect)selects.get(selects.size()-1);
                if (ps.getOrderByElements() != null) {
                    list.setOrderByElements(ps.getOrderByElements());
                    list.setLimit(ps.getLimit());
                    list.setOffset(ps.getOffset());
                    ps.setOrderByElements(null);
                    ps.setLimit(null);
                    ps.setOffset(null);
                }
                if (ps.getFetch() != null) {
                    list.setFetch(ps.getFetch());
                    ps.setFetch(null);
                }
                if (ps.getWithIsolation() != null) {
                    list.setWithIsolation(ps.getWithIsolation());
                    ps.setWithIsolation(null);
                }
            }
            list.setBracketsOpsAndSelects(brackets,selects,operations);
            return list;
        }
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return com.javaoffers.thrid.sqlparse.statement in function");
}

  final public SelectBody SetOperationListWithoutIntialSelect(FromItem fromItem) throws ParseException {/*@bgen(jjtree) SetOperationList */
    SimpleNode jjtn000 = new SimpleNode(JJTSETOPERATIONLIST);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));SetOperationList list = new SetOperationList();
    List<OrderByElement> orderByElements = null;
    Limit limit = null;
    Offset offset = null;
    Fetch fetch = null;
    WithIsolation withIsolation = null;
    SelectBody select;
    List<SelectBody> selects = new ArrayList<SelectBody>();
    List<SetOperation> operations = new ArrayList<SetOperation>();
    List<Boolean> brackets = new ArrayList<Boolean>();
    boolean bracket = false;
    try {
while (fromItem instanceof ParenthesisFromItem) {
            fromItem = ((ParenthesisFromItem)fromItem).getFromItem();
        }

        if (fromItem instanceof SubSelect) {
            select = ((SubSelect)fromItem).getSelectBody();
        } else {
            {if (true) throw new IllegalArgumentException("this type of set operation is not allowed");}
        }

        selects.add(select);
        brackets.add(true);
      label_39:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_UNION:{
          jj_consume_token(K_UNION);
UnionOp union = new UnionOp();linkAST(union,jjtn000);operations.add(union);
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_ALL:
          case K_DISTINCT:{
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_ALL:{
              jj_consume_token(K_ALL);
union.setAll(true);
              break;
              }
            case K_DISTINCT:{
              jj_consume_token(K_DISTINCT);
union.setDistinct(true);
              break;
              }
            default:
              jj_la1[152] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
            break;
            }
          default:
            jj_la1[153] = jj_gen;
            ;
          }
          break;
          }
        case K_INTERSECT:{
          jj_consume_token(K_INTERSECT);
operations.add(new IntersectOp());
          break;
          }
        case K_MINUS:{
          jj_consume_token(K_MINUS);
operations.add(new MinusOp());
          break;
          }
        case K_EXCEPT:{
          jj_consume_token(K_EXCEPT);
operations.add(new ExceptOp());
          break;
          }
        default:
          jj_la1[154] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        jj_consume_token(325);
        select = SelectBody();
        jj_consume_token(326);
bracket=true;
selects.add(select);brackets.add(bracket);
        if (jj_2_81(2)) {
          ;
        } else {
          break label_39;
        }
      }
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
list.setBracketsOpsAndSelects(brackets,selects,operations);
        return list;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return com.javaoffers.thrid.sqlparse.statement in function");
}

  final public List<WithItem> WithList() throws ParseException {List<WithItem> withItemsList = new ArrayList<WithItem>();
    WithItem with = null;
    jj_consume_token(K_WITH);
    with = WithItem();
withItemsList.add(with);
    label_40:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COMMA:{
        ;
        break;
        }
      default:
        jj_la1[155] = jj_gen;
        break label_40;
      }
      jj_consume_token(K_COMMA);
      with = WithItem();
withItemsList.add(with);
    }
return withItemsList;
}

  final public WithItem WithItem() throws ParseException {/*@bgen(jjtree) WithItem */
    SimpleNode jjtn000 = new SimpleNode(JJTWITHITEM);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));WithItem with = new WithItem();
    String name = null;
    List<SelectItem> selectItems = null;
    SubSelect select = null;

    ExpressionList simpleExpressionList;
    try {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_RECURSIVE:{
        jj_consume_token(K_RECURSIVE);
with.setRecursive(true);
        break;
        }
      default:
        jj_la1[156] = jj_gen;
        ;
      }
      name = RelObjectName();
with.setName(name);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 325:{
        jj_consume_token(325);
        selectItems = SelectItemsList();
        jj_consume_token(326);
with.setWithItemList(selectItems);
        break;
        }
      default:
        jj_la1[157] = jj_gen;
        ;
      }
      jj_consume_token(K_AS);
      if (jj_2_82(2147483647)) {
        jj_consume_token(325);
        jj_consume_token(K_VALUES);
        simpleExpressionList = SimpleExpressionList(true);
with.withUseBracketsForValues(false).setItemsList(simpleExpressionList);
        jj_consume_token(326);
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 325:{
          jj_consume_token(325);
          select = SubSelect();
with.setSubSelect(select.withUseBrackets(false)); with.setUseValues(false);
          jj_consume_token(326);
          break;
          }
        default:
          jj_la1[158] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
jjtree.closeNodeScope(jjtn000, true);
       jjtc000 = false;
       jjtn000.jjtSetLastToken(getToken(0));
return with;
    } catch (Throwable jjte000) {
if (jjtc000) {
         jjtree.clearNodeScope(jjtn000);
         jjtc000 = false;
       } else {
         jjtree.popNode();
       }
       if (jjte000 instanceof RuntimeException) {
         {if (true) throw (RuntimeException)jjte000;}
       }
       if (jjte000 instanceof ParseException) {
         {if (true) throw (ParseException)jjte000;}
       }
       {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
         jjtree.closeNodeScope(jjtn000, true);
         jjtn000.jjtSetLastToken(getToken(0));
       }
    }
    throw new RuntimeException("Missing return com.javaoffers.thrid.sqlparse.statement in function");
}

  final public List<SelectItem> SelectItemsList() throws ParseException {List<SelectItem> selectItemsList = new ArrayList<SelectItem>();
    SelectItem selectItem = null;
    selectItem = SelectItem();
selectItemsList.add(selectItem);
    label_41:
    while (true) {
      if (jj_2_83(2)) {
        ;
      } else {
        break label_41;
      }
      jj_consume_token(K_COMMA);
      selectItem = SelectItem();
selectItemsList.add(selectItem);
    }
return selectItemsList;
}

  final public SelectExpressionItem SelectExpressionItem() throws ParseException {SelectExpressionItem selectExpressionItem = null;
    Expression expression = null;
    Alias alias = null;
    expression = Expression();
selectExpressionItem = new SelectExpressionItem(); selectExpressionItem.setExpression(expression);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ACTION:
    case K_ACTIVE:
    case K_ALGORITHM:
    case K_ARCHIVE:
    case K_ARRAY_LITERAL:
    case K_AS:
    case K_AT:
    case K_BYTE:
    case K_CASCADE:
    case K_CASE:
    case K_CAST:
    case K_TRY_CAST:
    case K_CHARACTER:
    case K_CHANGE:
    case K_CHECKPOINT:
    case K_CHAR:
    case K_COLUMN:
    case K_COLUMNS:
    case K_COMMIT:
    case K_COMMENT:
    case K_COSTS:
    case K_CYCLE:
    case K_DATETIMELITERAL:
    case K_DATE_LITERAL:
    case K_DBA_RECYCLEBIN:
    case K_DEFAULT:
    case K_DESC:
    case K_DESCRIBE:
    case K_DISABLE:
    case K_DISCONNECT:
    case K_DIV:
    case K_DO:
    case K_DUMP:
    case K_DUPLICATE:
    case K_ENABLE:
    case K_END:
    case K_EXCLUDE:
    case K_EXTRACT:
    case K_FILTER:
    case K_FIRST:
    case K_FALSE:
    case K_FLUSH:
    case K_FOLLOWING:
    case K_FORMAT:
    case K_FULLTEXT:
    case K_HISTORY:
    case K_INDEX:
    case K_INSERT:
    case K_INTERVAL:
    case K_ISNULL:
    case K_JSON:
    case K_KEY:
    case K_FN:
    case K_LAST:
    case K_LEADING:
    case K_LOCAL:
    case K_LINK:
    case K_LOG:
    case K_MATERIALIZED:
    case K_NEXTVAL:
    case K_NO:
    case K_NOLOCK:
    case K_NULLS:
    case K_OF:
    case K_OPEN:
    case K_OVER:
    case K_PARALLEL:
    case K_PARTITION:
    case K_PATH:
    case K_PERCENT:
    case K_PRECISION:
    case K_PRIMARY:
    case K_PRIOR:
    case K_QUERY:
    case K_QUIESCE:
    case K_RANGE:
    case K_READ:
    case K_RECYCLEBIN:
    case K_REGISTER:
    case K_REPLACE:
    case K_RESUME:
    case K_RESTRICTED:
    case K_ROW:
    case K_ROWS:
    case K_SCHEMA:
    case K_SEQUENCE:
    case K_SEPARATOR:
    case K_SESSION:
    case K_SHUTDOWN:
    case K_SIBLINGS:
    case K_SIZE:
    case K_SKIP:
    case K_SUSPEND:
    case K_SWITCH:
    case K_SYNONYM:
    case K_SYSTEM:
    case K_TABLE:
    case K_TABLESPACE:
    case K_TEMP:
    case K_TEMPORARY:
    case K_TIMEOUT:
    case K_TO:
    case K_TOP:
    case K_TRUNCATE:
    case K_TRUE:
    case K_TYPE:
    case K_UNQIESCE:
    case K_USER:
    case K_SIGNED:
    case K_STRING_FUNCTION_NAME:
    case K_UNSIGNED:
    case K_VALIDATE:
    case K_VALUE:
    case K_VALUES:
    case K_VIEW:
    case K_XML:
    case K_ZONE:
    case S_IDENTIFIER:
    case S_CHAR_LITERAL:
    case S_QUOTED_IDENTIFIER:{
      alias = Alias();
selectExpressionItem.setAlias(alias);
      break;
      }
    default:
      jj_la1[159] = jj_gen;
      ;
    }
return selectExpressionItem;
}

  final public SelectItem SelectItem() throws ParseException {/*@bgen(jjtree) SelectItem */
    SimpleNode jjtn000 = new SimpleNode(JJTSELECTITEM);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));SelectItem selectItem = null;
    try {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 328:{
        jj_consume_token(328);
selectItem = new AllColumns();
        break;
        }
      default:
        jj_la1[160] = jj_gen;
        if (jj_2_84(2147483647)) {
          selectItem = AllTableColumns();
        } else if (jj_2_85(1)) {
          selectItem = SelectExpressionItem();
        } else {
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
linkAST(selectItem,jjtn000);
        return selectItem;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return com.javaoffers.thrid.sqlparse.statement in function");
}

  final public AllTableColumns AllTableColumns() throws ParseException {Table table = null;
    table = Table();
    jj_consume_token(329);
    jj_consume_token(328);
return new AllTableColumns(table);
}

  final public Alias Alias() throws ParseException {String name = null;
  Token token = null;
  boolean useAs = false;
  Alias alias;
  String colname;
  ColDataType colDataType = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_AS:{
      jj_consume_token(K_AS);
useAs = true;
      break;
      }
    default:
      jj_la1[161] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ACTION:
    case K_ACTIVE:
    case K_ALGORITHM:
    case K_ARCHIVE:
    case K_ARRAY_LITERAL:
    case K_AT:
    case K_BYTE:
    case K_CASCADE:
    case K_CASE:
    case K_CAST:
    case K_TRY_CAST:
    case K_CHARACTER:
    case K_CHANGE:
    case K_CHECKPOINT:
    case K_CHAR:
    case K_COLUMN:
    case K_COLUMNS:
    case K_COMMIT:
    case K_COMMENT:
    case K_COSTS:
    case K_CYCLE:
    case K_DATETIMELITERAL:
    case K_DATE_LITERAL:
    case K_DBA_RECYCLEBIN:
    case K_DEFAULT:
    case K_DESC:
    case K_DESCRIBE:
    case K_DISABLE:
    case K_DISCONNECT:
    case K_DIV:
    case K_DO:
    case K_DUMP:
    case K_DUPLICATE:
    case K_ENABLE:
    case K_END:
    case K_EXCLUDE:
    case K_EXTRACT:
    case K_FILTER:
    case K_FIRST:
    case K_FALSE:
    case K_FLUSH:
    case K_FOLLOWING:
    case K_FORMAT:
    case K_FULLTEXT:
    case K_HISTORY:
    case K_INDEX:
    case K_INSERT:
    case K_INTERVAL:
    case K_ISNULL:
    case K_JSON:
    case K_KEY:
    case K_FN:
    case K_LAST:
    case K_LEADING:
    case K_LOCAL:
    case K_LINK:
    case K_LOG:
    case K_MATERIALIZED:
    case K_NEXTVAL:
    case K_NO:
    case K_NOLOCK:
    case K_NULLS:
    case K_OF:
    case K_OPEN:
    case K_OVER:
    case K_PARALLEL:
    case K_PARTITION:
    case K_PATH:
    case K_PERCENT:
    case K_PRECISION:
    case K_PRIMARY:
    case K_PRIOR:
    case K_QUERY:
    case K_QUIESCE:
    case K_RANGE:
    case K_READ:
    case K_RECYCLEBIN:
    case K_REGISTER:
    case K_REPLACE:
    case K_RESUME:
    case K_RESTRICTED:
    case K_ROW:
    case K_ROWS:
    case K_SCHEMA:
    case K_SEQUENCE:
    case K_SEPARATOR:
    case K_SESSION:
    case K_SHUTDOWN:
    case K_SIBLINGS:
    case K_SIZE:
    case K_SKIP:
    case K_SUSPEND:
    case K_SWITCH:
    case K_SYNONYM:
    case K_SYSTEM:
    case K_TABLE:
    case K_TABLESPACE:
    case K_TEMP:
    case K_TEMPORARY:
    case K_TIMEOUT:
    case K_TO:
    case K_TOP:
    case K_TRUNCATE:
    case K_TRUE:
    case K_TYPE:
    case K_UNQIESCE:
    case K_USER:
    case K_SIGNED:
    case K_STRING_FUNCTION_NAME:
    case K_UNSIGNED:
    case K_VALIDATE:
    case K_VALUE:
    case K_VALUES:
    case K_VIEW:
    case K_XML:
    case K_ZONE:
    case S_IDENTIFIER:
    case S_QUOTED_IDENTIFIER:{
      name = RelObjectNameWithoutStart();
      break;
      }
    case S_CHAR_LITERAL:{
      token = jj_consume_token(S_CHAR_LITERAL);
name=token.image;
      break;
      }
    default:
      jj_la1[162] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
alias = new Alias(name,useAs);
    if (jj_2_86(2)) {
      jj_consume_token(325);
List<Alias.AliasColumn> list = new ArrayList<Alias.AliasColumn>();
      colname = RelObjectName();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_BINARY:
      case K_BIT:
      case K_CHARACTER:
      case K_CHAR:
      case K_DATETIMELITERAL:
      case K_DATE_LITERAL:
      case K_DOUBLE:
      case K_INTERVAL:
      case K_JSON:
      case K_SET:
      case K_SIGNED:
      case K_UNSIGNED:
      case K_XML:
      case DT_ZONE:
      case S_IDENTIFIER:
      case S_QUOTED_IDENTIFIER:{
        colDataType = ColDataType();
        break;
        }
      default:
        jj_la1[163] = jj_gen;
        ;
      }
list.add(new Alias.AliasColumn(colname, colDataType));
      label_42:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_COMMA:{
          ;
          break;
          }
        default:
          jj_la1[164] = jj_gen;
          break label_42;
        }
        jj_consume_token(K_COMMA);
colDataType=null;
        colname = RelObjectName();
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_BINARY:
        case K_BIT:
        case K_CHARACTER:
        case K_CHAR:
        case K_DATETIMELITERAL:
        case K_DATE_LITERAL:
        case K_DOUBLE:
        case K_INTERVAL:
        case K_JSON:
        case K_SET:
        case K_SIGNED:
        case K_UNSIGNED:
        case K_XML:
        case DT_ZONE:
        case S_IDENTIFIER:
        case S_QUOTED_IDENTIFIER:{
          colDataType = ColDataType();
          break;
          }
        default:
          jj_la1[165] = jj_gen;
          ;
        }
list.add(new Alias.AliasColumn(colname, colDataType));
      }
      jj_consume_token(326);
alias.setAliasColumns(list);
    } else {
      ;
    }
return alias;
}

  final public void SQLServerHint(SQLServerHints hints) throws ParseException {String str;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_INDEX:{
      jj_consume_token(K_INDEX);
      jj_consume_token(325);
      str = RelObjectName();
      jj_consume_token(326);
hints.setIndexName(str);
      break;
      }
    case K_NOLOCK:{
      jj_consume_token(K_NOLOCK);
hints.withNoLock();
      break;
      }
    default:
      jj_la1[166] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
}

  final public SQLServerHints SQLServerHints() throws ParseException {SQLServerHints hints = new SQLServerHints();
    jj_consume_token(K_WITH);
    jj_consume_token(325);
    SQLServerHint(hints);
    label_43:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COMMA:{
        ;
        break;
        }
      default:
        jj_la1[167] = jj_gen;
        break label_43;
      }
      jj_consume_token(K_COMMA);
      SQLServerHint(hints);
    }
    jj_consume_token(326);
return hints;
}

  final public MySQLIndexHint MySQLIndexHint() throws ParseException {Token actionToken = null;
        Token indexToken = null;
        String indexName = null;
        List<String> indexNameList = new ArrayList<String>();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_USE:{
      actionToken = jj_consume_token(K_USE);
      break;
      }
    case K_SHOW:{
      actionToken = jj_consume_token(K_SHOW);
      break;
      }
    case K_IGNORE:{
      actionToken = jj_consume_token(K_IGNORE);
      break;
      }
    case K_FORCE:{
      actionToken = jj_consume_token(K_FORCE);
      break;
      }
    default:
      jj_la1[168] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_INDEX:{
      indexToken = jj_consume_token(K_INDEX);
      break;
      }
    case K_KEY:{
      indexToken = jj_consume_token(K_KEY);
      break;
      }
    default:
      jj_la1[169] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(325);
    indexName = RelObjectNameWithoutValue();
indexNameList.add(indexName);
    label_44:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COMMA:{
        ;
        break;
        }
      default:
        jj_la1[170] = jj_gen;
        break label_44;
      }
      jj_consume_token(K_COMMA);
      indexName = RelObjectNameWithoutValue();
indexNameList.add(indexName);
    }
    jj_consume_token(326);
return new MySQLIndexHint(actionToken.image, indexToken.image, indexNameList);
}

  final public FunctionItem FunctionItem() throws ParseException {Alias alias = null;
    Function function;
     FunctionItem functionItem;
    function = Function();
functionItem = new FunctionItem(); functionItem.setFunction(function);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ACTION:
    case K_ACTIVE:
    case K_ALGORITHM:
    case K_ARCHIVE:
    case K_ARRAY_LITERAL:
    case K_AS:
    case K_AT:
    case K_BYTE:
    case K_CASCADE:
    case K_CASE:
    case K_CAST:
    case K_TRY_CAST:
    case K_CHARACTER:
    case K_CHANGE:
    case K_CHECKPOINT:
    case K_CHAR:
    case K_COLUMN:
    case K_COLUMNS:
    case K_COMMIT:
    case K_COMMENT:
    case K_COSTS:
    case K_CYCLE:
    case K_DATETIMELITERAL:
    case K_DATE_LITERAL:
    case K_DBA_RECYCLEBIN:
    case K_DEFAULT:
    case K_DESC:
    case K_DESCRIBE:
    case K_DISABLE:
    case K_DISCONNECT:
    case K_DIV:
    case K_DO:
    case K_DUMP:
    case K_DUPLICATE:
    case K_ENABLE:
    case K_END:
    case K_EXCLUDE:
    case K_EXTRACT:
    case K_FILTER:
    case K_FIRST:
    case K_FALSE:
    case K_FLUSH:
    case K_FOLLOWING:
    case K_FORMAT:
    case K_FULLTEXT:
    case K_HISTORY:
    case K_INDEX:
    case K_INSERT:
    case K_INTERVAL:
    case K_ISNULL:
    case K_JSON:
    case K_KEY:
    case K_FN:
    case K_LAST:
    case K_LEADING:
    case K_LOCAL:
    case K_LINK:
    case K_LOG:
    case K_MATERIALIZED:
    case K_NEXTVAL:
    case K_NO:
    case K_NOLOCK:
    case K_NULLS:
    case K_OF:
    case K_OPEN:
    case K_OVER:
    case K_PARALLEL:
    case K_PARTITION:
    case K_PATH:
    case K_PERCENT:
    case K_PRECISION:
    case K_PRIMARY:
    case K_PRIOR:
    case K_QUERY:
    case K_QUIESCE:
    case K_RANGE:
    case K_READ:
    case K_RECYCLEBIN:
    case K_REGISTER:
    case K_REPLACE:
    case K_RESUME:
    case K_RESTRICTED:
    case K_ROW:
    case K_ROWS:
    case K_SCHEMA:
    case K_SEQUENCE:
    case K_SEPARATOR:
    case K_SESSION:
    case K_SHUTDOWN:
    case K_SIBLINGS:
    case K_SIZE:
    case K_SKIP:
    case K_SUSPEND:
    case K_SWITCH:
    case K_SYNONYM:
    case K_SYSTEM:
    case K_TABLE:
    case K_TABLESPACE:
    case K_TEMP:
    case K_TEMPORARY:
    case K_TIMEOUT:
    case K_TO:
    case K_TOP:
    case K_TRUNCATE:
    case K_TRUE:
    case K_TYPE:
    case K_UNQIESCE:
    case K_USER:
    case K_SIGNED:
    case K_STRING_FUNCTION_NAME:
    case K_UNSIGNED:
    case K_VALIDATE:
    case K_VALUE:
    case K_VALUES:
    case K_VIEW:
    case K_XML:
    case K_ZONE:
    case S_IDENTIFIER:
    case S_CHAR_LITERAL:
    case S_QUOTED_IDENTIFIER:{
      alias = Alias();
functionItem.setAlias(alias);
      break;
      }
    default:
      jj_la1[171] = jj_gen;
      ;
    }
return functionItem;
}

  final public List<Column> PivotForColumns() throws ParseException {List<Column> columns = new ArrayList<Column>();
    Column column;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case 325:{
      jj_consume_token(325);
      column = Column();
columns.add(column);
      label_45:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_COMMA:{
          ;
          break;
          }
        default:
          jj_la1[172] = jj_gen;
          break label_45;
        }
        jj_consume_token(K_COMMA);
        column = Column();
columns.add(column);
      }
      jj_consume_token(326);
      break;
      }
    case K_ACTION:
    case K_ACTIVE:
    case K_ALGORITHM:
    case K_ALL:
    case K_ANY:
    case K_ARCHIVE:
    case K_ARRAY_LITERAL:
    case K_AT:
    case K_BYTE:
    case K_CASCADE:
    case K_CASE:
    case K_CASEWHEN:
    case K_CAST:
    case K_TRY_CAST:
    case K_CHARACTER:
    case K_CHANGE:
    case K_CHECKPOINT:
    case K_CHAR:
    case K_COLUMN:
    case K_COLUMNS:
    case K_COMMIT:
    case K_COMMENT:
    case K_COSTS:
    case K_CREATE:
    case K_CYCLE:
    case K_DATETIMELITERAL:
    case K_DATE_LITERAL:
    case K_DBA_RECYCLEBIN:
    case K_DEFAULT:
    case K_DESC:
    case K_DESCRIBE:
    case K_DISABLE:
    case K_DISCONNECT:
    case K_DIV:
    case K_DO:
    case K_DOUBLE:
    case K_DUMP:
    case K_DUPLICATE:
    case K_ENABLE:
    case K_END:
    case K_EXCLUDE:
    case K_EXTRACT:
    case K_FILTER:
    case K_FIRST:
    case K_FALSE:
    case K_FLUSH:
    case K_FOLLOWING:
    case K_FORMAT:
    case K_FULLTEXT:
    case K_GROUP:
    case K_GROUPING:
    case K_HISTORY:
    case K_IF:
    case K_IIF:
    case K_IN:
    case K_INDEX:
    case K_INSERT:
    case K_INTERVAL:
    case K_ISNULL:
    case K_JSON:
    case K_KEY:
    case K_FN:
    case K_LAST:
    case K_LEADING:
    case K_LEFT:
    case K_LIMIT:
    case K_LOCAL:
    case K_LINK:
    case K_LOG:
    case K_MATERIALIZED:
    case K_NEXTVAL:
    case K_NO:
    case K_NOLOCK:
    case K_NULLS:
    case K_OF:
    case K_OFFSET:
    case K_ON:
    case K_OPEN:
    case K_ORDER:
    case K_OVER:
    case K_OPTIMIZE:
    case K_PARALLEL:
    case K_PARTITION:
    case K_PATH:
    case K_PERCENT:
    case K_PRECISION:
    case K_PRIMARY:
    case K_PRIOR:
    case K_PROCEDURE:
    case K_PUBLIC:
    case K_QUERY:
    case K_QUIESCE:
    case K_RANGE:
    case K_READ:
    case K_RECYCLEBIN:
    case K_REGISTER:
    case K_REPLACE:
    case K_RESUME:
    case K_RESTRICTED:
    case K_RIGHT:
    case K_ROW:
    case K_ROWS:
    case K_SCHEMA:
    case K_SEQUENCE:
    case K_SEPARATOR:
    case K_SESSION:
    case K_SET:
    case K_SHUTDOWN:
    case K_SIBLINGS:
    case K_SIZE:
    case K_SKIP:
    case K_SOME:
    case K_START:
    case K_SUSPEND:
    case K_SWITCH:
    case K_SYNONYM:
    case K_SYSTEM:
    case K_TABLE:
    case K_TABLES:
    case K_TABLESPACE:
    case K_TEMP:
    case K_TEMPORARY:
    case K_TIMEOUT:
    case K_TO:
    case K_TOP:
    case K_TRUNCATE:
    case K_TRUE:
    case K_TYPE:
    case K_UNQIESCE:
    case K_USER:
    case K_SIGNED:
    case K_STRING_FUNCTION_NAME:
    case K_UNSIGNED:
    case K_VALIDATE:
    case K_VALUE:
    case K_VALUES:
    case K_VIEW:
    case K_XML:
    case K_ZONE:
    case S_IDENTIFIER:
    case S_QUOTED_IDENTIFIER:{
      column = Column();
columns.add(column);
      break;
      }
    default:
      jj_la1[173] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return columns;
}

  final public List<FunctionItem> PivotFunctionItems() throws ParseException {List< FunctionItem> functionItems = new ArrayList< FunctionItem>();
    FunctionItem item;
    item = FunctionItem();
functionItems.add(item);
    label_46:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COMMA:{
        ;
        break;
        }
      default:
        jj_la1[174] = jj_gen;
        break label_46;
      }
      jj_consume_token(K_COMMA);
      item = FunctionItem();
functionItems.add(item);
    }
return functionItems;
}

  final public List<SelectExpressionItem> PivotSingleInItems() throws ParseException {List<SelectExpressionItem> retval = new ArrayList<SelectExpressionItem>();
   SelectExpressionItem item;
    item = PivotSelectExprItem();
retval.add(item);
    label_47:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COMMA:{
        ;
        break;
        }
      default:
        jj_la1[175] = jj_gen;
        break label_47;
      }
      jj_consume_token(K_COMMA);
      item = PivotSelectExprItem();
retval.add(item);
    }
return retval;
}

  final public SelectExpressionItem PivotSelectExprItem() throws ParseException {SelectExpressionItem selectExpressionItem = null;
    Expression expression = null;
    Alias alias = null;
    expression = SimpleExpression();
selectExpressionItem = new SelectExpressionItem(); selectExpressionItem.setExpression(expression);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ACTION:
    case K_ACTIVE:
    case K_ALGORITHM:
    case K_ARCHIVE:
    case K_ARRAY_LITERAL:
    case K_AS:
    case K_AT:
    case K_BYTE:
    case K_CASCADE:
    case K_CASE:
    case K_CAST:
    case K_TRY_CAST:
    case K_CHARACTER:
    case K_CHANGE:
    case K_CHECKPOINT:
    case K_CHAR:
    case K_COLUMN:
    case K_COLUMNS:
    case K_COMMIT:
    case K_COMMENT:
    case K_COSTS:
    case K_CYCLE:
    case K_DATETIMELITERAL:
    case K_DATE_LITERAL:
    case K_DBA_RECYCLEBIN:
    case K_DEFAULT:
    case K_DESC:
    case K_DESCRIBE:
    case K_DISABLE:
    case K_DISCONNECT:
    case K_DIV:
    case K_DO:
    case K_DUMP:
    case K_DUPLICATE:
    case K_ENABLE:
    case K_END:
    case K_EXCLUDE:
    case K_EXTRACT:
    case K_FILTER:
    case K_FIRST:
    case K_FALSE:
    case K_FLUSH:
    case K_FOLLOWING:
    case K_FORMAT:
    case K_FULLTEXT:
    case K_HISTORY:
    case K_INDEX:
    case K_INSERT:
    case K_INTERVAL:
    case K_ISNULL:
    case K_JSON:
    case K_KEY:
    case K_FN:
    case K_LAST:
    case K_LEADING:
    case K_LOCAL:
    case K_LINK:
    case K_LOG:
    case K_MATERIALIZED:
    case K_NEXTVAL:
    case K_NO:
    case K_NOLOCK:
    case K_NULLS:
    case K_OF:
    case K_OPEN:
    case K_OVER:
    case K_PARALLEL:
    case K_PARTITION:
    case K_PATH:
    case K_PERCENT:
    case K_PRECISION:
    case K_PRIMARY:
    case K_PRIOR:
    case K_QUERY:
    case K_QUIESCE:
    case K_RANGE:
    case K_READ:
    case K_RECYCLEBIN:
    case K_REGISTER:
    case K_REPLACE:
    case K_RESUME:
    case K_RESTRICTED:
    case K_ROW:
    case K_ROWS:
    case K_SCHEMA:
    case K_SEQUENCE:
    case K_SEPARATOR:
    case K_SESSION:
    case K_SHUTDOWN:
    case K_SIBLINGS:
    case K_SIZE:
    case K_SKIP:
    case K_SUSPEND:
    case K_SWITCH:
    case K_SYNONYM:
    case K_SYSTEM:
    case K_TABLE:
    case K_TABLESPACE:
    case K_TEMP:
    case K_TEMPORARY:
    case K_TIMEOUT:
    case K_TO:
    case K_TOP:
    case K_TRUNCATE:
    case K_TRUE:
    case K_TYPE:
    case K_UNQIESCE:
    case K_USER:
    case K_SIGNED:
    case K_STRING_FUNCTION_NAME:
    case K_UNSIGNED:
    case K_VALIDATE:
    case K_VALUE:
    case K_VALUES:
    case K_VIEW:
    case K_XML:
    case K_ZONE:
    case S_IDENTIFIER:
    case S_CHAR_LITERAL:
    case S_QUOTED_IDENTIFIER:{
      alias = Alias();
selectExpressionItem.setAlias(alias);
      break;
      }
    default:
      jj_la1[176] = jj_gen;
      ;
    }
return selectExpressionItem;
}

  final public ExpressionListItem ExpressionListItem() throws ParseException {ExpressionListItem expressionListItem = null;
    ExpressionList expressionList = null;
    Alias alias = null;
    jj_consume_token(325);
    expressionList = SimpleExpressionList(true);
expressionListItem = new ExpressionListItem(); expressionListItem.setExpressionList(expressionList);
    jj_consume_token(326);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ACTION:
    case K_ACTIVE:
    case K_ALGORITHM:
    case K_ARCHIVE:
    case K_ARRAY_LITERAL:
    case K_AS:
    case K_AT:
    case K_BYTE:
    case K_CASCADE:
    case K_CASE:
    case K_CAST:
    case K_TRY_CAST:
    case K_CHARACTER:
    case K_CHANGE:
    case K_CHECKPOINT:
    case K_CHAR:
    case K_COLUMN:
    case K_COLUMNS:
    case K_COMMIT:
    case K_COMMENT:
    case K_COSTS:
    case K_CYCLE:
    case K_DATETIMELITERAL:
    case K_DATE_LITERAL:
    case K_DBA_RECYCLEBIN:
    case K_DEFAULT:
    case K_DESC:
    case K_DESCRIBE:
    case K_DISABLE:
    case K_DISCONNECT:
    case K_DIV:
    case K_DO:
    case K_DUMP:
    case K_DUPLICATE:
    case K_ENABLE:
    case K_END:
    case K_EXCLUDE:
    case K_EXTRACT:
    case K_FILTER:
    case K_FIRST:
    case K_FALSE:
    case K_FLUSH:
    case K_FOLLOWING:
    case K_FORMAT:
    case K_FULLTEXT:
    case K_HISTORY:
    case K_INDEX:
    case K_INSERT:
    case K_INTERVAL:
    case K_ISNULL:
    case K_JSON:
    case K_KEY:
    case K_FN:
    case K_LAST:
    case K_LEADING:
    case K_LOCAL:
    case K_LINK:
    case K_LOG:
    case K_MATERIALIZED:
    case K_NEXTVAL:
    case K_NO:
    case K_NOLOCK:
    case K_NULLS:
    case K_OF:
    case K_OPEN:
    case K_OVER:
    case K_PARALLEL:
    case K_PARTITION:
    case K_PATH:
    case K_PERCENT:
    case K_PRECISION:
    case K_PRIMARY:
    case K_PRIOR:
    case K_QUERY:
    case K_QUIESCE:
    case K_RANGE:
    case K_READ:
    case K_RECYCLEBIN:
    case K_REGISTER:
    case K_REPLACE:
    case K_RESUME:
    case K_RESTRICTED:
    case K_ROW:
    case K_ROWS:
    case K_SCHEMA:
    case K_SEQUENCE:
    case K_SEPARATOR:
    case K_SESSION:
    case K_SHUTDOWN:
    case K_SIBLINGS:
    case K_SIZE:
    case K_SKIP:
    case K_SUSPEND:
    case K_SWITCH:
    case K_SYNONYM:
    case K_SYSTEM:
    case K_TABLE:
    case K_TABLESPACE:
    case K_TEMP:
    case K_TEMPORARY:
    case K_TIMEOUT:
    case K_TO:
    case K_TOP:
    case K_TRUNCATE:
    case K_TRUE:
    case K_TYPE:
    case K_UNQIESCE:
    case K_USER:
    case K_SIGNED:
    case K_STRING_FUNCTION_NAME:
    case K_UNSIGNED:
    case K_VALIDATE:
    case K_VALUE:
    case K_VALUES:
    case K_VIEW:
    case K_XML:
    case K_ZONE:
    case S_IDENTIFIER:
    case S_CHAR_LITERAL:
    case S_QUOTED_IDENTIFIER:{
      alias = Alias();
expressionListItem.setAlias(alias);
      break;
      }
    default:
      jj_la1[177] = jj_gen;
      ;
    }
return expressionListItem;
}

  final public List<ExpressionListItem> PivotMultiInItems() throws ParseException {List<ExpressionListItem> retval = new ArrayList<ExpressionListItem>();
   ExpressionListItem item;
    item = ExpressionListItem();
retval.add(item);
    label_48:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COMMA:{
        ;
        break;
        }
      default:
        jj_la1[178] = jj_gen;
        break label_48;
      }
      jj_consume_token(K_COMMA);
      item = ExpressionListItem();
retval.add(item);
    }
return retval;
}

  final public Pivot Pivot() throws ParseException {Pivot retval = new Pivot();
    List<FunctionItem> functionItems;
    List<Column> forColumns;
    List<SelectExpressionItem> singleInItems = null;
    List<ExpressionListItem> multiInItems = null;
    Alias alias = null;
    jj_consume_token(K_PIVOT);
    jj_consume_token(325);
    functionItems = PivotFunctionItems();
    jj_consume_token(K_FOR);
    forColumns = PivotForColumns();
    jj_consume_token(K_IN);
    jj_consume_token(325);
    if (jj_2_87(3)) {
      singleInItems = PivotSingleInItems();
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 325:{
        multiInItems = PivotMultiInItems();
        break;
        }
      default:
        jj_la1[179] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    jj_consume_token(326);
    jj_consume_token(326);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ACTION:
    case K_ACTIVE:
    case K_ALGORITHM:
    case K_ARCHIVE:
    case K_ARRAY_LITERAL:
    case K_AS:
    case K_AT:
    case K_BYTE:
    case K_CASCADE:
    case K_CASE:
    case K_CAST:
    case K_TRY_CAST:
    case K_CHARACTER:
    case K_CHANGE:
    case K_CHECKPOINT:
    case K_CHAR:
    case K_COLUMN:
    case K_COLUMNS:
    case K_COMMIT:
    case K_COMMENT:
    case K_COSTS:
    case K_CYCLE:
    case K_DATETIMELITERAL:
    case K_DATE_LITERAL:
    case K_DBA_RECYCLEBIN:
    case K_DEFAULT:
    case K_DESC:
    case K_DESCRIBE:
    case K_DISABLE:
    case K_DISCONNECT:
    case K_DIV:
    case K_DO:
    case K_DUMP:
    case K_DUPLICATE:
    case K_ENABLE:
    case K_END:
    case K_EXCLUDE:
    case K_EXTRACT:
    case K_FILTER:
    case K_FIRST:
    case K_FALSE:
    case K_FLUSH:
    case K_FOLLOWING:
    case K_FORMAT:
    case K_FULLTEXT:
    case K_HISTORY:
    case K_INDEX:
    case K_INSERT:
    case K_INTERVAL:
    case K_ISNULL:
    case K_JSON:
    case K_KEY:
    case K_FN:
    case K_LAST:
    case K_LEADING:
    case K_LOCAL:
    case K_LINK:
    case K_LOG:
    case K_MATERIALIZED:
    case K_NEXTVAL:
    case K_NO:
    case K_NOLOCK:
    case K_NULLS:
    case K_OF:
    case K_OPEN:
    case K_OVER:
    case K_PARALLEL:
    case K_PARTITION:
    case K_PATH:
    case K_PERCENT:
    case K_PRECISION:
    case K_PRIMARY:
    case K_PRIOR:
    case K_QUERY:
    case K_QUIESCE:
    case K_RANGE:
    case K_READ:
    case K_RECYCLEBIN:
    case K_REGISTER:
    case K_REPLACE:
    case K_RESUME:
    case K_RESTRICTED:
    case K_ROW:
    case K_ROWS:
    case K_SCHEMA:
    case K_SEQUENCE:
    case K_SEPARATOR:
    case K_SESSION:
    case K_SHUTDOWN:
    case K_SIBLINGS:
    case K_SIZE:
    case K_SKIP:
    case K_SUSPEND:
    case K_SWITCH:
    case K_SYNONYM:
    case K_SYSTEM:
    case K_TABLE:
    case K_TABLESPACE:
    case K_TEMP:
    case K_TEMPORARY:
    case K_TIMEOUT:
    case K_TO:
    case K_TOP:
    case K_TRUNCATE:
    case K_TRUE:
    case K_TYPE:
    case K_UNQIESCE:
    case K_USER:
    case K_SIGNED:
    case K_STRING_FUNCTION_NAME:
    case K_UNSIGNED:
    case K_VALIDATE:
    case K_VALUE:
    case K_VALUES:
    case K_VIEW:
    case K_XML:
    case K_ZONE:
    case S_IDENTIFIER:
    case S_CHAR_LITERAL:
    case S_QUOTED_IDENTIFIER:{
      alias = Alias();
      break;
      }
    default:
      jj_la1[180] = jj_gen;
      ;
    }
retval.setFunctionItems(functionItems);
        retval.setForColumns(forColumns);
        retval.setSingleInItems(singleInItems);
        retval.setMultiInItems(multiInItems);
        retval.setAlias(alias);
        return retval;
}

  final public PivotXml PivotXml() throws ParseException {PivotXml retval = new PivotXml();
    List<FunctionItem> functionItems;
    List<Column> forColumns;
    List<SelectExpressionItem> singleInItems = null;
    List<ExpressionListItem> multiInItems = null;
    SelectBody inSelect = null;
    jj_consume_token(K_PIVOT);
    jj_consume_token(K_XML);
    jj_consume_token(325);
    functionItems = PivotFunctionItems();
    jj_consume_token(K_FOR);
    forColumns = PivotForColumns();
    jj_consume_token(K_IN);
    jj_consume_token(325);
    if (jj_2_88(2)) {
      jj_consume_token(K_ANY);
retval.setInAny(true);
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_SELECT:
      case K_VALUES:
      case 325:{
        inSelect = SelectBody();
        break;
        }
      default:
        jj_la1[181] = jj_gen;
        if (jj_2_89(2)) {
          singleInItems = PivotSingleInItems();
        } else {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case 325:{
            multiInItems = PivotMultiInItems();
            break;
            }
          default:
            jj_la1[182] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
      }
    }
    jj_consume_token(326);
    jj_consume_token(326);
retval.setFunctionItems(functionItems);
        retval.setForColumns(forColumns);
        retval.setSingleInItems(singleInItems);
        retval.setMultiInItems(multiInItems);
        retval.setInSelect(inSelect);
        return retval;
}

  final public UnPivot UnPivot() throws ParseException {UnPivot retval = new UnPivot();
    List<Column> unpivotClause;
    List<Column> unpivotForClause;
    List<SelectExpressionItem> unpivotInClause;
    Alias alias = null;
    jj_consume_token(K_UNPIVOT);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_EXCLUDE:
    case K_INCLUDE:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_INCLUDE:{
        jj_consume_token(K_INCLUDE);
        jj_consume_token(K_NULLS);
retval.setIncludeNulls(true);
        break;
        }
      case K_EXCLUDE:{
        jj_consume_token(K_EXCLUDE);
        jj_consume_token(K_NULLS);
retval.setIncludeNulls(false);
        break;
        }
      default:
        jj_la1[183] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[184] = jj_gen;
      ;
    }
    jj_consume_token(325);
    unpivotClause = PivotForColumns();
    jj_consume_token(K_FOR);
    unpivotForClause = PivotForColumns();
    jj_consume_token(K_IN);
    jj_consume_token(325);
    unpivotInClause = PivotSingleInItems();
    jj_consume_token(326);
    jj_consume_token(326);
    if (jj_2_90(2)) {
      alias = Alias();
    } else {
      ;
    }
retval.setUnPivotClause(unpivotClause);
        retval.setUnPivotForClause(unpivotForClause);
        retval.setUnPivotInClause(unpivotInClause);
        retval.setAlias(alias);
        return retval;
}

  final public List<Table> IntoClause() throws ParseException {List<Table> tables = new ArrayList<Table>();
    Table table;
    jj_consume_token(K_INTO);
    table = Table();
tables.add(table);
    label_49:
    while (true) {
      if (jj_2_91(2)) {
        ;
      } else {
        break label_49;
      }
      jj_consume_token(K_COMMA);
      table = Table();
tables.add(table);
    }
return tables;
}

  final public FromItem FromItem() throws ParseException {FromItem fromItem = null;
    FromItem fromItem2 = null;
    Pivot pivot = null;
    UnPivot unpivot = null;
    Alias alias = null;
    MySQLIndexHint indexHint = null;
    SQLServerHints sqlServerHints = null;
    SelectBody selectBody;
    if (jj_2_98(2147483647)) {
      fromItem = ValuesList();
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ACTION:
      case K_ACTIVE:
      case K_ALGORITHM:
      case K_ALL:
      case K_ANY:
      case K_ARCHIVE:
      case K_ARRAY_LITERAL:
      case K_AT:
      case K_BYTE:
      case K_CASCADE:
      case K_CASE:
      case K_CASEWHEN:
      case K_CAST:
      case K_TRY_CAST:
      case K_CHARACTER:
      case K_CHANGE:
      case K_CHECKPOINT:
      case K_CHAR:
      case K_COLUMN:
      case K_COLUMNS:
      case K_COMMIT:
      case K_COMMENT:
      case K_COSTS:
      case K_CREATE:
      case K_CYCLE:
      case K_DATETIMELITERAL:
      case K_DATE_LITERAL:
      case K_DBA_RECYCLEBIN:
      case K_DEFAULT:
      case K_DESC:
      case K_DESCRIBE:
      case K_DISABLE:
      case K_DISCONNECT:
      case K_DIV:
      case K_DO:
      case K_DOUBLE:
      case K_DUMP:
      case K_DUPLICATE:
      case K_ENABLE:
      case K_END:
      case K_EXCLUDE:
      case K_EXTRACT:
      case K_FILTER:
      case K_FIRST:
      case K_FALSE:
      case K_FLUSH:
      case K_FOLLOWING:
      case K_FORMAT:
      case K_FULLTEXT:
      case K_GROUP:
      case K_GROUPING:
      case K_HISTORY:
      case K_IF:
      case K_IIF:
      case K_IN:
      case K_INDEX:
      case K_INSERT:
      case K_INTERVAL:
      case K_ISNULL:
      case K_JSON:
      case K_KEY:
      case K_FN:
      case K_LAST:
      case K_LATERAL:
      case K_LEADING:
      case K_LEFT:
      case K_LIMIT:
      case K_LOCAL:
      case K_LINK:
      case K_LOG:
      case K_MATERIALIZED:
      case K_NEXTVAL:
      case K_NO:
      case K_NOLOCK:
      case K_NULLS:
      case K_OF:
      case K_OFFSET:
      case K_ON:
      case K_OPEN:
      case K_ORDER:
      case K_OVER:
      case K_OPTIMIZE:
      case K_PARALLEL:
      case K_PARTITION:
      case K_PATH:
      case K_PERCENT:
      case K_PRECISION:
      case K_PRIMARY:
      case K_PRIOR:
      case K_PROCEDURE:
      case K_PUBLIC:
      case K_QUERY:
      case K_QUIESCE:
      case K_RANGE:
      case K_READ:
      case K_RECYCLEBIN:
      case K_REGISTER:
      case K_REPLACE:
      case K_RESUME:
      case K_RESTRICTED:
      case K_RIGHT:
      case K_ROW:
      case K_ROWS:
      case K_SCHEMA:
      case K_SEQUENCE:
      case K_SEPARATOR:
      case K_SESSION:
      case K_SET:
      case K_SHUTDOWN:
      case K_SIBLINGS:
      case K_SIZE:
      case K_SKIP:
      case K_SOME:
      case K_START:
      case K_SUSPEND:
      case K_SWITCH:
      case K_SYNONYM:
      case K_SYSTEM:
      case K_TABLE:
      case K_TABLES:
      case K_TABLESPACE:
      case K_TEMP:
      case K_TEMPORARY:
      case K_TIMEOUT:
      case K_TO:
      case K_TOP:
      case K_TRUNCATE:
      case K_TRUE:
      case K_TYPE:
      case K_UNQIESCE:
      case K_USER:
      case K_SIGNED:
      case K_STRING_FUNCTION_NAME:
      case K_UNSIGNED:
      case K_VALIDATE:
      case K_VALUE:
      case K_VALUES:
      case K_VIEW:
      case K_XML:
      case K_ZONE:
      case S_IDENTIFIER:
      case S_QUOTED_IDENTIFIER:
      case 325:
      case 373:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 325:{
          jj_consume_token(325);
          if (jj_2_92(3)) {
            fromItem2 = FromItem();
fromItem = new ParenthesisFromItem(fromItem2);
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_APPLY:
            case K_COMMA:
            case K_CROSS:
            case K_FULL:
            case K_INNER:
            case K_STRAIGHT:
            case K_JOIN:
            case K_LEFT:
            case K_NATURAL:
            case K_OUTER:
            case K_RIGHT:{
              fromItem = SubJoin(fromItem2);
              break;
              }
            default:
              jj_la1[185] = jj_gen;
              ;
            }
          } else {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_SELECT:
            case K_VALUES:
            case K_WITH:
            case 325:{
              fromItem = SubSelect();
              break;
              }
            default:
              jj_la1[186] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
          }
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_EXCEPT:
          case K_INTERSECT:
          case K_MINUS:
          case K_UNION:{
            selectBody = SetOperationListWithoutIntialSelect(fromItem);
if (!(selectBody instanceof PlainSelect)) {
                                    fromItem = new SubSelect().withSelectBody(selectBody);
                                }
            break;
            }
          default:
            jj_la1[187] = jj_gen;
            ;
          }
          jj_consume_token(326);
          if (jj_2_93(2)) {
            unpivot = UnPivot();
fromItem.setUnPivot(unpivot);
          } else {
            ;
          }
          break;
          }
        default:
          jj_la1[188] = jj_gen;
          if (jj_2_94(2147483647)) {
            fromItem = TableFunction();
          } else {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_ACTION:
            case K_ACTIVE:
            case K_ALGORITHM:
            case K_ALL:
            case K_ANY:
            case K_ARCHIVE:
            case K_ARRAY_LITERAL:
            case K_AT:
            case K_BYTE:
            case K_CASCADE:
            case K_CASE:
            case K_CASEWHEN:
            case K_CAST:
            case K_TRY_CAST:
            case K_CHARACTER:
            case K_CHANGE:
            case K_CHECKPOINT:
            case K_CHAR:
            case K_COLUMN:
            case K_COLUMNS:
            case K_COMMIT:
            case K_COMMENT:
            case K_COSTS:
            case K_CREATE:
            case K_CYCLE:
            case K_DATETIMELITERAL:
            case K_DATE_LITERAL:
            case K_DBA_RECYCLEBIN:
            case K_DEFAULT:
            case K_DESC:
            case K_DESCRIBE:
            case K_DISABLE:
            case K_DISCONNECT:
            case K_DIV:
            case K_DO:
            case K_DOUBLE:
            case K_DUMP:
            case K_DUPLICATE:
            case K_ENABLE:
            case K_END:
            case K_EXCLUDE:
            case K_EXTRACT:
            case K_FILTER:
            case K_FIRST:
            case K_FALSE:
            case K_FLUSH:
            case K_FOLLOWING:
            case K_FORMAT:
            case K_FULLTEXT:
            case K_GROUP:
            case K_GROUPING:
            case K_HISTORY:
            case K_IF:
            case K_IIF:
            case K_IN:
            case K_INDEX:
            case K_INSERT:
            case K_INTERVAL:
            case K_ISNULL:
            case K_JSON:
            case K_KEY:
            case K_FN:
            case K_LAST:
            case K_LEADING:
            case K_LEFT:
            case K_LIMIT:
            case K_LOCAL:
            case K_LINK:
            case K_LOG:
            case K_MATERIALIZED:
            case K_NEXTVAL:
            case K_NO:
            case K_NOLOCK:
            case K_NULLS:
            case K_OF:
            case K_OFFSET:
            case K_ON:
            case K_OPEN:
            case K_ORDER:
            case K_OVER:
            case K_OPTIMIZE:
            case K_PARALLEL:
            case K_PARTITION:
            case K_PATH:
            case K_PERCENT:
            case K_PRECISION:
            case K_PRIMARY:
            case K_PRIOR:
            case K_PROCEDURE:
            case K_PUBLIC:
            case K_QUERY:
            case K_QUIESCE:
            case K_RANGE:
            case K_READ:
            case K_RECYCLEBIN:
            case K_REGISTER:
            case K_REPLACE:
            case K_RESUME:
            case K_RESTRICTED:
            case K_RIGHT:
            case K_ROW:
            case K_ROWS:
            case K_SCHEMA:
            case K_SEQUENCE:
            case K_SEPARATOR:
            case K_SESSION:
            case K_SET:
            case K_SHUTDOWN:
            case K_SIBLINGS:
            case K_SIZE:
            case K_SKIP:
            case K_SOME:
            case K_START:
            case K_SUSPEND:
            case K_SWITCH:
            case K_SYNONYM:
            case K_SYSTEM:
            case K_TABLE:
            case K_TABLES:
            case K_TABLESPACE:
            case K_TEMP:
            case K_TEMPORARY:
            case K_TIMEOUT:
            case K_TO:
            case K_TOP:
            case K_TRUNCATE:
            case K_TRUE:
            case K_TYPE:
            case K_UNQIESCE:
            case K_USER:
            case K_SIGNED:
            case K_STRING_FUNCTION_NAME:
            case K_UNSIGNED:
            case K_VALIDATE:
            case K_VALUE:
            case K_VALUES:
            case K_VIEW:
            case K_XML:
            case K_ZONE:
            case S_IDENTIFIER:
            case S_QUOTED_IDENTIFIER:{
              fromItem = Table();
              break;
              }
            case K_LATERAL:{
              fromItem = LateralSubSelect();
              break;
              }
            default:
              jj_la1[189] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
          }
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_ACTION:
        case K_ACTIVE:
        case K_ALGORITHM:
        case K_ARCHIVE:
        case K_ARRAY_LITERAL:
        case K_AS:
        case K_AT:
        case K_BYTE:
        case K_CASCADE:
        case K_CASE:
        case K_CAST:
        case K_TRY_CAST:
        case K_CHARACTER:
        case K_CHANGE:
        case K_CHECKPOINT:
        case K_CHAR:
        case K_COLUMN:
        case K_COLUMNS:
        case K_COMMIT:
        case K_COMMENT:
        case K_COSTS:
        case K_CYCLE:
        case K_DATETIMELITERAL:
        case K_DATE_LITERAL:
        case K_DBA_RECYCLEBIN:
        case K_DEFAULT:
        case K_DESC:
        case K_DESCRIBE:
        case K_DISABLE:
        case K_DISCONNECT:
        case K_DIV:
        case K_DO:
        case K_DUMP:
        case K_DUPLICATE:
        case K_ENABLE:
        case K_END:
        case K_EXCLUDE:
        case K_EXTRACT:
        case K_FILTER:
        case K_FIRST:
        case K_FALSE:
        case K_FLUSH:
        case K_FOLLOWING:
        case K_FORMAT:
        case K_FULLTEXT:
        case K_HISTORY:
        case K_INDEX:
        case K_INSERT:
        case K_INTERVAL:
        case K_ISNULL:
        case K_JSON:
        case K_KEY:
        case K_FN:
        case K_LAST:
        case K_LEADING:
        case K_LOCAL:
        case K_LINK:
        case K_LOG:
        case K_MATERIALIZED:
        case K_NEXTVAL:
        case K_NO:
        case K_NOLOCK:
        case K_NULLS:
        case K_OF:
        case K_OPEN:
        case K_OVER:
        case K_PARALLEL:
        case K_PARTITION:
        case K_PATH:
        case K_PERCENT:
        case K_PRECISION:
        case K_PRIMARY:
        case K_PRIOR:
        case K_QUERY:
        case K_QUIESCE:
        case K_RANGE:
        case K_READ:
        case K_RECYCLEBIN:
        case K_REGISTER:
        case K_REPLACE:
        case K_RESUME:
        case K_RESTRICTED:
        case K_ROW:
        case K_ROWS:
        case K_SCHEMA:
        case K_SEQUENCE:
        case K_SEPARATOR:
        case K_SESSION:
        case K_SHUTDOWN:
        case K_SIBLINGS:
        case K_SIZE:
        case K_SKIP:
        case K_SUSPEND:
        case K_SWITCH:
        case K_SYNONYM:
        case K_SYSTEM:
        case K_TABLE:
        case K_TABLESPACE:
        case K_TEMP:
        case K_TEMPORARY:
        case K_TIMEOUT:
        case K_TO:
        case K_TOP:
        case K_TRUNCATE:
        case K_TRUE:
        case K_TYPE:
        case K_UNQIESCE:
        case K_USER:
        case K_SIGNED:
        case K_STRING_FUNCTION_NAME:
        case K_UNSIGNED:
        case K_VALIDATE:
        case K_VALUE:
        case K_VALUES:
        case K_VIEW:
        case K_XML:
        case K_ZONE:
        case S_IDENTIFIER:
        case S_CHAR_LITERAL:
        case S_QUOTED_IDENTIFIER:{
          alias = Alias();
fromItem.setAlias(alias);
          break;
          }
        default:
          jj_la1[190] = jj_gen;
          ;
        }
        if (jj_2_95(2)) {
          unpivot = UnPivot();
fromItem.setUnPivot(unpivot);
        } else {
          ;
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_PIVOT:{
          if (jj_2_96(2)) {
            pivot = PivotXml();
          } else {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_PIVOT:{
              pivot = Pivot();
              break;
              }
            default:
              jj_la1[191] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
          }
fromItem.setPivot(pivot);
          break;
          }
        default:
          jj_la1[192] = jj_gen;
          ;
        }
        if (jj_2_97(2)) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_FORCE:
          case K_IGNORE:
          case K_SHOW:
          case K_USE:{
            indexHint = MySQLIndexHint();
if (fromItem instanceof Table)
                            ((Table) fromItem).setHint(indexHint);
            break;
            }
          case K_WITH:{
            sqlServerHints = SQLServerHints();
if (fromItem instanceof Table)
                            ((Table) fromItem).setSqlServerHints(sqlServerHints);
            break;
            }
          default:
            jj_la1[193] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        } else {
          ;
        }
        break;
        }
      default:
        jj_la1[194] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
return fromItem;
}

  final public FromItem ValuesList() throws ParseException {MultiExpressionList exprList = new MultiExpressionList();
    List<Expression> primaryExpList = new ArrayList<Expression>();
    ValuesList valuesList = new ValuesList();
    Expression exp = null;
    List<String> colNames = null;
    String colName;
    Alias alias;
    jj_consume_token(325);
    jj_consume_token(K_VALUES);
    if (jj_2_99(3)) {
      jj_consume_token(325);
      exp = SimpleExpression();
primaryExpList.add(exp);
      label_50:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_COMMA:{
          ;
          break;
          }
        default:
          jj_la1[195] = jj_gen;
          break label_50;
        }
        jj_consume_token(K_COMMA);
        exp = SimpleExpression();
primaryExpList.add(exp);
      }
      jj_consume_token(326);
exprList.addExpressionList(primaryExpList);
      label_51:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_COMMA:{
          ;
          break;
          }
        default:
          jj_la1[196] = jj_gen;
          break label_51;
        }
        jj_consume_token(K_COMMA);
        jj_consume_token(325);
        exp = SimpleExpression();
primaryExpList = new ArrayList<Expression>();
                    primaryExpList.add(exp);
        label_52:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_COMMA:{
            ;
            break;
            }
          default:
            jj_la1[197] = jj_gen;
            break label_52;
          }
          jj_consume_token(K_COMMA);
          exp = SimpleExpression();
primaryExpList.add(exp);
        }
        jj_consume_token(326);
exprList.addExpressionList(primaryExpList);
      }
    } else if (jj_2_100(1)) {
      exp = SimpleExpression();
exprList.addExpressionList(exp); valuesList.setNoBrackets(true);
      label_53:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_COMMA:{
          ;
          break;
          }
        default:
          jj_la1[198] = jj_gen;
          break label_53;
        }
        jj_consume_token(K_COMMA);
        exp = SimpleExpression();
exprList.addExpressionList(exp);
      }
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(326);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ACTION:
    case K_ACTIVE:
    case K_ALGORITHM:
    case K_ARCHIVE:
    case K_ARRAY_LITERAL:
    case K_AS:
    case K_AT:
    case K_BYTE:
    case K_CASCADE:
    case K_CASE:
    case K_CAST:
    case K_TRY_CAST:
    case K_CHARACTER:
    case K_CHANGE:
    case K_CHECKPOINT:
    case K_CHAR:
    case K_COLUMN:
    case K_COLUMNS:
    case K_COMMIT:
    case K_COMMENT:
    case K_COSTS:
    case K_CYCLE:
    case K_DATETIMELITERAL:
    case K_DATE_LITERAL:
    case K_DBA_RECYCLEBIN:
    case K_DEFAULT:
    case K_DESC:
    case K_DESCRIBE:
    case K_DISABLE:
    case K_DISCONNECT:
    case K_DIV:
    case K_DO:
    case K_DUMP:
    case K_DUPLICATE:
    case K_ENABLE:
    case K_END:
    case K_EXCLUDE:
    case K_EXTRACT:
    case K_FILTER:
    case K_FIRST:
    case K_FALSE:
    case K_FLUSH:
    case K_FOLLOWING:
    case K_FORMAT:
    case K_FULLTEXT:
    case K_HISTORY:
    case K_INDEX:
    case K_INSERT:
    case K_INTERVAL:
    case K_ISNULL:
    case K_JSON:
    case K_KEY:
    case K_FN:
    case K_LAST:
    case K_LEADING:
    case K_LOCAL:
    case K_LINK:
    case K_LOG:
    case K_MATERIALIZED:
    case K_NEXTVAL:
    case K_NO:
    case K_NOLOCK:
    case K_NULLS:
    case K_OF:
    case K_OPEN:
    case K_OVER:
    case K_PARALLEL:
    case K_PARTITION:
    case K_PATH:
    case K_PERCENT:
    case K_PRECISION:
    case K_PRIMARY:
    case K_PRIOR:
    case K_QUERY:
    case K_QUIESCE:
    case K_RANGE:
    case K_READ:
    case K_RECYCLEBIN:
    case K_REGISTER:
    case K_REPLACE:
    case K_RESUME:
    case K_RESTRICTED:
    case K_ROW:
    case K_ROWS:
    case K_SCHEMA:
    case K_SEQUENCE:
    case K_SEPARATOR:
    case K_SESSION:
    case K_SHUTDOWN:
    case K_SIBLINGS:
    case K_SIZE:
    case K_SKIP:
    case K_SUSPEND:
    case K_SWITCH:
    case K_SYNONYM:
    case K_SYSTEM:
    case K_TABLE:
    case K_TABLESPACE:
    case K_TEMP:
    case K_TEMPORARY:
    case K_TIMEOUT:
    case K_TO:
    case K_TOP:
    case K_TRUNCATE:
    case K_TRUE:
    case K_TYPE:
    case K_UNQIESCE:
    case K_USER:
    case K_SIGNED:
    case K_STRING_FUNCTION_NAME:
    case K_UNSIGNED:
    case K_VALIDATE:
    case K_VALUE:
    case K_VALUES:
    case K_VIEW:
    case K_XML:
    case K_ZONE:
    case S_IDENTIFIER:
    case S_CHAR_LITERAL:
    case S_QUOTED_IDENTIFIER:{
      alias = Alias();
valuesList.setAlias(alias);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 325:{
        jj_consume_token(325);
        colName = RelObjectName();
colNames = new ArrayList<String>(); colNames.add(colName);
        label_54:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_COMMA:{
            ;
            break;
            }
          default:
            jj_la1[199] = jj_gen;
            break label_54;
          }
          jj_consume_token(K_COMMA);
          colName = RelObjectName();
colNames.add(colName);
        }
        jj_consume_token(326);
valuesList.setColumnNames(colNames);
        break;
        }
      default:
        jj_la1[200] = jj_gen;
        ;
      }
      break;
      }
    default:
      jj_la1[201] = jj_gen;
      ;
    }
valuesList.setMultiExpressionList(exprList);
        return valuesList;
}

  final public LateralSubSelect LateralSubSelect() throws ParseException {LateralSubSelect specialSubSelect;
    SubSelect subSelect = null;
    jj_consume_token(K_LATERAL);
specialSubSelect = new LateralSubSelect();
    jj_consume_token(325);
    subSelect = SubSelect();
    jj_consume_token(326);
specialSubSelect.setSubSelect(subSelect);
        return specialSubSelect;
}

  final public FromItem SubJoin(FromItem fromItem) throws ParseException {Join join = null;
    List<Join> joinList = null;
    joinList = SubJoinsList();
SubJoin subJoin = new SubJoin();
        subJoin.setLeft(fromItem);
        subJoin.setJoinList(joinList);
        return subJoin;
}

  final public List<Join> JoinsList() throws ParseException {List<Join> joinsList = new ArrayList<Join>();
    Join join = null;
    label_55:
    while (true) {
      if (jj_2_101(2)) {
        ;
      } else {
        break label_55;
      }
      join = JoinerExpression();
joinsList.add(join);
    }
return joinsList;
}

  final public List<Join> SubJoinsList() throws ParseException {List<Join> joinsList = new ArrayList<Join>();
    Join join = null;
    label_56:
    while (true) {
      join = JoinerExpression();
joinsList.add(join);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_APPLY:
      case K_COMMA:
      case K_CROSS:
      case K_FULL:
      case K_INNER:
      case K_STRAIGHT:
      case K_JOIN:
      case K_LEFT:
      case K_NATURAL:
      case K_OUTER:
      case K_RIGHT:{
        ;
        break;
        }
      default:
        jj_la1[202] = jj_gen;
        break label_56;
      }
    }
return joinsList;
}

  final public Join JoinerExpression() throws ParseException {/*@bgen(jjtree) JoinerExpression */
    SimpleNode jjtn000 = new SimpleNode(JJTJOINEREXPRESSION);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));Join join = new Join();
    FromItem right = null;
    Expression onExpression = null;
    Column tableColumn;
    List<Column> columns = null;
    KSQLJoinWindow joinWindow = null;
    try {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_CROSS:
      case K_FULL:
      case K_INNER:
      case K_LEFT:
      case K_NATURAL:
      case K_OUTER:
      case K_RIGHT:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_LEFT:{
          jj_consume_token(K_LEFT);
join.setLeft(true);
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_OUTER:
          case K_SEMI:{
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_SEMI:{
              jj_consume_token(K_SEMI);
join.setSemi(true);
              break;
              }
            case K_OUTER:{
              jj_consume_token(K_OUTER);
join.setOuter(true);
              break;
              }
            default:
              jj_la1[203] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
            break;
            }
          default:
            jj_la1[204] = jj_gen;
            ;
          }
          break;
          }
        case K_FULL:
        case K_RIGHT:{
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_RIGHT:{
            jj_consume_token(K_RIGHT);
join.setRight(true);
            break;
            }
          case K_FULL:{
            jj_consume_token(K_FULL);
join.setFull(true);
            break;
            }
          default:
            jj_la1[205] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_OUTER:{
            jj_consume_token(K_OUTER);
join.setOuter(true);
            break;
            }
          default:
            jj_la1[206] = jj_gen;
            ;
          }
          break;
          }
        case K_INNER:{
          jj_consume_token(K_INNER);
join.setInner(true);
          break;
          }
        case K_NATURAL:{
          jj_consume_token(K_NATURAL);
join.setNatural(true);
          break;
          }
        case K_CROSS:{
          jj_consume_token(K_CROSS);
join.setCross(true);
          break;
          }
        case K_OUTER:{
          jj_consume_token(K_OUTER);
join.setOuter(true);
          break;
          }
        default:
          jj_la1[207] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[208] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_JOIN:{
        jj_consume_token(K_JOIN);
        break;
        }
      case K_COMMA:{
        jj_consume_token(K_COMMA);
join.setSimple(true);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_OUTER:{
          jj_consume_token(K_OUTER);
join.setOuter(true);
          break;
          }
        default:
          jj_la1[209] = jj_gen;
          ;
        }
        break;
        }
      case K_STRAIGHT:{
        jj_consume_token(K_STRAIGHT);
join.setStraight(true);
        break;
        }
      case K_APPLY:{
        jj_consume_token(K_APPLY);
join.setApply(true);
        break;
        }
      default:
        jj_la1[210] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      right = FromItem();
      if (jj_2_103(2)) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_ON:
        case K_WITHIN:{
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_WITHIN:{
            jj_consume_token(K_WITHIN);
            jj_consume_token(325);
            joinWindow = JoinWindow();
            jj_consume_token(326);
join.setJoinWindow(joinWindow);
            break;
            }
          default:
            jj_la1[211] = jj_gen;
            ;
          }
          jj_consume_token(K_ON);
          onExpression = Expression();
join.addOnExpression(onExpression);
          label_57:
          while (true) {
            if (jj_2_102(2)) {
              ;
            } else {
              break label_57;
            }
            jj_consume_token(K_ON);
            onExpression = Expression();
join.addOnExpression(onExpression);
          }
          break;
          }
        case K_USING:{
          jj_consume_token(K_USING);
          jj_consume_token(325);
          tableColumn = Column();
columns = new ArrayList<Column>(); columns.add(tableColumn);
          label_58:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_COMMA:{
              ;
              break;
              }
            default:
              jj_la1[212] = jj_gen;
              break label_58;
            }
            jj_consume_token(K_COMMA);
            tableColumn = Column();
columns.add(tableColumn);
          }
          jj_consume_token(326);
join.setUsingColumns(columns);
          break;
          }
        default:
          jj_la1[213] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      } else {
        ;
      }
jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    jjtn000.jjtSetLastToken(getToken(0));
linkAST(join,jjtn000);
      join.setRightItem(right);
    return join;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return com.javaoffers.thrid.sqlparse.statement in function");
}

  final public KSQLJoinWindow JoinWindow() throws ParseException {KSQLJoinWindow retval = new KSQLJoinWindow();
    boolean beforeAfter;
    Token beforeDurationToken = null;
    Token beforeTimeUnitToken = null;
    Token afterDurationToken = null;
    Token afterTimeUnitToken = null;
    beforeDurationToken = jj_consume_token(S_LONG);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case S_IDENTIFIER:{
      beforeTimeUnitToken = jj_consume_token(S_IDENTIFIER);
      break;
      }
    case K_DATE_LITERAL:{
      beforeTimeUnitToken = jj_consume_token(K_DATE_LITERAL);
      break;
      }
    default:
      jj_la1[214] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_COMMA:{
      jj_consume_token(K_COMMA);
      afterDurationToken = jj_consume_token(S_LONG);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S_IDENTIFIER:{
        afterTimeUnitToken = jj_consume_token(S_IDENTIFIER);
        break;
        }
      case K_DATE_LITERAL:{
        afterTimeUnitToken = jj_consume_token(K_DATE_LITERAL);
        break;
        }
      default:
        jj_la1[215] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[216] = jj_gen;
      ;
    }
if (afterDurationToken == null) {
            retval.setDuration(Long.parseLong(beforeDurationToken.image));
            retval.setTimeUnit(KSQLJoinWindow.TimeUnit.valueOf(beforeTimeUnitToken.image));
            retval.setBeforeAfterWindow(false);
            return retval;
        }
        retval.setBeforeDuration(Long.parseLong(beforeDurationToken.image));
        retval.setBeforeTimeUnit(KSQLJoinWindow.TimeUnit.valueOf(beforeTimeUnitToken.image));
        retval.setAfterDuration(Long.parseLong(afterDurationToken.image));
        retval.setAfterTimeUnit(KSQLJoinWindow.TimeUnit.valueOf(afterTimeUnitToken.image));
        retval.setBeforeAfterWindow(true);
        return retval;
}

  final public KSQLWindow KSQLWindowClause() throws ParseException {KSQLWindow retval = null;
    Token sizeDurationToken = null;
    Token sizeTimeUnitToken = null;
    Token advanceDurationToken = null;
    Token advanceTimeUnitToken = null;
    jj_consume_token(K_WINDOW);
retval=new KSQLWindow();
        retval.setHoppingWindow(false);
        retval.setSessionWindow(false);
        retval.setTumblingWindow(false);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_HOPPING:{
      jj_consume_token(K_HOPPING);
      jj_consume_token(325);
      jj_consume_token(K_SIZE);
      sizeDurationToken = jj_consume_token(S_LONG);
      sizeTimeUnitToken = jj_consume_token(S_IDENTIFIER);
      jj_consume_token(K_COMMA);
      jj_consume_token(K_ADVANCE);
      jj_consume_token(K_BY);
      advanceDurationToken = jj_consume_token(S_LONG);
      advanceTimeUnitToken = jj_consume_token(S_IDENTIFIER);
      jj_consume_token(326);
retval.setHoppingWindow(true);
      break;
      }
    case K_SESSION:{
      jj_consume_token(K_SESSION);
      jj_consume_token(325);
      sizeDurationToken = jj_consume_token(S_LONG);
      sizeTimeUnitToken = jj_consume_token(S_IDENTIFIER);
      jj_consume_token(326);
retval.setSessionWindow(true);
      break;
      }
    case K_TUMBLING:{
      jj_consume_token(K_TUMBLING);
      jj_consume_token(325);
      jj_consume_token(K_SIZE);
      sizeDurationToken = jj_consume_token(S_LONG);
      sizeTimeUnitToken = jj_consume_token(S_IDENTIFIER);
      jj_consume_token(326);
retval.setTumblingWindow(true);
      break;
      }
    default:
      jj_la1[217] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
retval.setSizeDuration(Long.parseLong(sizeDurationToken.image));
            retval.setSizeTimeUnit(KSQLWindow.TimeUnit.valueOf(sizeTimeUnitToken.image));
            if (advanceDurationToken != null) {
                retval.setAdvanceDuration(Long.parseLong(advanceDurationToken.image));
                retval.setAdvanceTimeUnit(KSQLWindow.TimeUnit.valueOf(advanceTimeUnitToken.image));
            }
            return retval;
}

  final public Expression WhereClause() throws ParseException {Expression retval = null;
    jj_consume_token(K_WHERE);
    retval = Expression();
return retval;
}

  final public OracleHierarchicalExpression OracleHierarchicalQueryClause() throws ParseException {OracleHierarchicalExpression result = new OracleHierarchicalExpression();
    Expression expr;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_START:{
      jj_consume_token(K_START);
      jj_consume_token(K_WITH);
      expr = AndExpression();
result.setStartExpression(expr);
      jj_consume_token(K_CONNECT);
      jj_consume_token(K_BY);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_NOCYCLE:{
        jj_consume_token(K_NOCYCLE);
result.setNoCycle(true);
        break;
        }
      default:
        jj_la1[218] = jj_gen;
        ;
      }
      expr = AndExpression();
result.setConnectExpression(expr);
      break;
      }
    case K_CONNECT:{
      jj_consume_token(K_CONNECT);
      jj_consume_token(K_BY);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_NOCYCLE:{
        jj_consume_token(K_NOCYCLE);
result.setNoCycle(true);
        break;
        }
      default:
        jj_la1[219] = jj_gen;
        ;
      }
      expr = AndExpression();
result.setConnectExpression(expr);
                    result.setConnectFirst(true);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_START:{
        jj_consume_token(K_START);
        jj_consume_token(K_WITH);
        expr = AndExpression();
result.setStartExpression(expr);
        break;
        }
      default:
        jj_la1[220] = jj_gen;
        ;
      }
      break;
      }
    default:
      jj_la1[221] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return result;
}

  final public GroupByElement GroupByColumnReferences() throws ParseException {Expression columnReference;
    GroupByElement groupBy = new GroupByElement();
    Expression expr;
    ExpressionList list;
    jj_consume_token(K_GROUP);
    jj_consume_token(K_BY);
    if (jj_2_110(2)) {
      jj_consume_token(325);
      jj_consume_token(326);
groupBy.withUsingBrackets(true);
    } else if (jj_2_111(2)) {
      jj_consume_token(K_GROUPING);
      jj_consume_token(K_SETS);
      jj_consume_token(325);
      if (jj_2_104(2)) {
        jj_consume_token(325);
        jj_consume_token(326);
groupBy.addGroupingSet(new ExpressionList());
      } else if (jj_2_105(3)) {
        jj_consume_token(325);
        list = SimpleExpressionList(true);
        jj_consume_token(326);
groupBy.addGroupingSet(list);
      } else if (jj_2_106(1)) {
        expr = SimpleExpression();
groupBy.addGroupingSet(expr);
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
      label_59:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_COMMA:{
          ;
          break;
          }
        default:
          jj_la1[222] = jj_gen;
          break label_59;
        }
        jj_consume_token(K_COMMA);
        if (jj_2_107(2)) {
          jj_consume_token(325);
          jj_consume_token(326);
groupBy.addGroupingSet(new ExpressionList());
        } else if (jj_2_108(3)) {
          jj_consume_token(325);
          list = SimpleExpressionList(true);
          jj_consume_token(326);
groupBy.addGroupingSet(list);
        } else if (jj_2_109(1)) {
          expr = SimpleExpression();
groupBy.addGroupingSet(expr);
        } else {
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      jj_consume_token(326);
    } else if (jj_2_112(2)) {
      list = ComplexExpressionList();
groupBy.setGroupByExpressionList(list.withUsingBrackets(false));
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
return groupBy;
}

  final public Expression Having() throws ParseException {Expression having = null;
    jj_consume_token(K_HAVING);
    having = Expression();
return having;
}

  final public List<OrderByElement> OrderByElements() throws ParseException {List<OrderByElement> orderByList = new ArrayList<OrderByElement>();
    OrderByElement orderByElement = null;
    jj_consume_token(K_ORDER);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_SIBLINGS:{
      jj_consume_token(K_SIBLINGS);
      break;
      }
    default:
      jj_la1[223] = jj_gen;
      ;
    }
    jj_consume_token(K_BY);
    orderByElement = OrderByElement();
orderByList.add(orderByElement);
    label_60:
    while (true) {
      if (jj_2_113(2)) {
        ;
      } else {
        break label_60;
      }
      jj_consume_token(K_COMMA);
      orderByElement = OrderByElement();
orderByList.add(orderByElement);
    }
return orderByList;
}

  final public OrderByElement OrderByElement() throws ParseException {OrderByElement orderByElement = new OrderByElement();
    Expression columnReference = null;
    columnReference = Expression();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ASC:
    case K_DESC:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ASC:{
        jj_consume_token(K_ASC);
        break;
        }
      case K_DESC:{
        jj_consume_token(K_DESC);
orderByElement.setAsc(false);
        break;
        }
      default:
        jj_la1[224] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
orderByElement.setAscDescPresent(true);
      break;
      }
    default:
      jj_la1[225] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_NULLS:{
      jj_consume_token(K_NULLS);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_FIRST:
      case K_LAST:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_FIRST:{
          jj_consume_token(K_FIRST);
orderByElement.setNullOrdering(OrderByElement.NullOrdering.NULLS_FIRST);
          break;
          }
        case K_LAST:{
          jj_consume_token(K_LAST);
orderByElement.setNullOrdering(OrderByElement.NullOrdering.NULLS_LAST);
          break;
          }
        default:
          jj_la1[226] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[227] = jj_gen;
        ;
      }
      break;
      }
    default:
      jj_la1[228] = jj_gen;
      ;
    }
orderByElement.setExpression(columnReference);
        return orderByElement;
}

  final public JdbcParameter SimpleJdbcParameter() throws ParseException {JdbcParameter retval;
    jj_consume_token(331);
retval = new JdbcParameter(++jdbcParameterIndex, false);
    if (jj_2_114(2)) {
      token = jj_consume_token(S_LONG);
retval.setUseFixedIndex(true); retval.setIndex(Integer.valueOf(token.image));
    } else {
      ;
    }
return retval;
}

  final public JdbcNamedParameter SimpleJdbcNamedParameter() throws ParseException {String name;
    jj_consume_token(330);
    name = RelObjectNameExt();
return new JdbcNamedParameter(token.image);
}

  final public Limit LimitWithOffset() throws ParseException {/*@bgen(jjtree) LimitWithOffset */
    SimpleNode jjtn000 = new SimpleNode(JJTLIMITWITHOFFSET);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));Limit limit = new Limit();
    Expression rowCountExpression;
    Expression offsetExpression;
    try {
      if (jj_2_115(2147483647)) {
        jj_consume_token(K_LIMIT);
        offsetExpression = Expression();
limit.setOffset( offsetExpression );
        jj_consume_token(K_COMMA);
        rowCountExpression = Expression();
limit.setRowCount( rowCountExpression );
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_LIMIT:{
          limit = PlainLimit();
          break;
          }
        default:
          jj_la1[229] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
linkAST(limit,jjtn000);
        return limit;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return com.javaoffers.thrid.sqlparse.statement in function");
}

  final public Limit PlainLimit() throws ParseException {/*@bgen(jjtree) PlainLimit */
    SimpleNode jjtn000 = new SimpleNode(JJTPLAINLIMIT);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));Limit limit = new Limit();
    Expression rowCountExpression;
    try {
      jj_consume_token(K_LIMIT);
      if (jj_2_116(3)) {
        jj_consume_token(325);
        rowCountExpression = SubSelect();
        jj_consume_token(326);
      } else if (jj_2_117(1)) {
        rowCountExpression = Expression();
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
limit.setRowCount(rowCountExpression);
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
linkAST(limit,jjtn000);
        return limit;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return com.javaoffers.thrid.sqlparse.statement in function");
}

  final public Offset Offset() throws ParseException {Offset offset = new Offset();
    Expression offsetExpression;
    jj_consume_token(K_OFFSET);
    offsetExpression = Expression();
offset.setOffset( offsetExpression );
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ROW:
    case K_ROWS:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ROWS:{
        jj_consume_token(K_ROWS);
offset.setOffsetParam("ROWS");
        break;
        }
      case K_ROW:{
        jj_consume_token(K_ROW);
offset.setOffsetParam("ROW");
        break;
        }
      default:
        jj_la1[230] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[231] = jj_gen;
      ;
    }
return offset;
}

  final public Fetch Fetch() throws ParseException {Fetch fetch = new Fetch();
    Token token = null;
    JdbcParameter jdbc;
    jj_consume_token(K_FETCH);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_FIRST:{
      jj_consume_token(K_FIRST);
fetch.setFetchParamFirst(true);
      break;
      }
    case K_NEXT:{
      jj_consume_token(K_NEXT);
      break;
      }
    default:
      jj_la1[232] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case S_LONG:{
      token = jj_consume_token(S_LONG);
fetch.setRowCount(Long.parseLong(token.image));
      break;
      }
    case 331:{
      jdbc = SimpleJdbcParameter();
fetch.setFetchJdbcParameter(jdbc);
      break;
      }
    default:
      jj_la1[233] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ROWS:{
      jj_consume_token(K_ROWS);
fetch.setFetchParam("ROWS");
      break;
      }
    case K_ROW:{
      jj_consume_token(K_ROW);
      break;
      }
    default:
      jj_la1[234] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(K_ONLY);
return fetch;
}

  final public WithIsolation WithIsolation() throws ParseException {WithIsolation withIsolation = new WithIsolation();
    Token token = null;
    JdbcParameter jdbc;
    jj_consume_token(K_WITH);
    token = jj_consume_token(K_ISOLATION);
withIsolation.setIsolation(token.image);
return withIsolation;
}

  final public OptimizeFor OptimizeFor() throws ParseException {Token token;
    LongValue value;
    jj_consume_token(K_OPTIMIZE);
    jj_consume_token(K_FOR);
    token = jj_consume_token(S_LONG);
    jj_consume_token(K_ROWS);
value = new LongValue(token.image);
return new OptimizeFor(value.getValue());
}

// according to http://technet.microsoft.com/en-us/library/ms189463.aspx
  final public Top Top() throws ParseException {Top top = new Top();
    Token token = null;
    Expression expr = null;
    JdbcParameter jdbc = null;
    jj_consume_token(K_TOP);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case S_LONG:{
      token = jj_consume_token(S_LONG);
top.setExpression(new LongValue(token.image));
      break;
      }
    case 331:{
      jdbc = SimpleJdbcParameter();
top.setExpression(jdbc);
      break;
      }
    case 330:{
      jj_consume_token(330);
top.setExpression(new JdbcNamedParameter());
      if (jj_2_118(2)) {
        token = jj_consume_token(S_IDENTIFIER);
((JdbcNamedParameter)top.getExpression()).setName(token.image);
      } else {
        ;
      }
      break;
      }
    case 325:{
      jj_consume_token(325);
      expr = AdditiveExpression();
top.setExpression(expr);
top.setParenthesis(true);
      jj_consume_token(326);
      break;
      }
    default:
      jj_la1[235] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    if (jj_2_119(2)) {
      jj_consume_token(K_PERCENT);
top.setPercentage(true);
    } else {
      ;
    }
    if (jj_2_120(2)) {
      jj_consume_token(K_WITH_TIES);
top.setWithTies(true);
    } else {
      ;
    }
return top;
}

// according to http://www-01.ibm.com/support/knowledgecenter/SSGU8G_12.1.0/com.ibm.sqls.doc/ids_sqs_0156.htm
  final public Skip Skip() throws ParseException {Skip skip = new Skip();
    Token token = null;
    JdbcParameter jdbc;
    jj_consume_token(K_SKIP);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case S_LONG:{
      token = jj_consume_token(S_LONG);
skip.setRowCount(Long.parseLong(token.image));
      break;
      }
    case S_IDENTIFIER:{
      token = jj_consume_token(S_IDENTIFIER);
skip.setVariable(token.image);
      break;
      }
    case 331:{
      jdbc = SimpleJdbcParameter();
skip.setJdbcParameter(jdbc);
      break;
      }
    default:
      jj_la1[236] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return skip;
}

  OracleHint getOracleHint() throws ParseException {OracleHint hint = null;
  Token tok = getToken(1);
  // Retrieve first comment (if any) prior next token
  if (tok.specialToken != null) {
    tok = tok.specialToken;
    while (tok.specialToken != null) tok = tok.specialToken;
    // Check if it matches Hint pattern?
    if (OracleHint.isHintMatch(tok.image)) {
      hint = new OracleHint();
      hint.setComment(tok.image);
    }
  }
  return hint;
  }

  final public First First() throws ParseException {First first = new First();
    Token token = null;
    JdbcParameter jdbc;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_FIRST:{
      jj_consume_token(K_FIRST);
first.setKeyword(First.Keyword.FIRST);
      break;
      }
    case K_LIMIT:{
      jj_consume_token(K_LIMIT);
first.setKeyword(First.Keyword.LIMIT);
      break;
      }
    default:
      jj_la1[237] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case S_LONG:{
      token = jj_consume_token(S_LONG);
first.setRowCount(Long.parseLong(token.image));
      break;
      }
    case S_IDENTIFIER:{
      token = jj_consume_token(S_IDENTIFIER);
first.setVariable(token.image);
      break;
      }
    case 331:{
      jdbc = SimpleJdbcParameter();
first.setJdbcParameter(jdbc);
      break;
      }
    default:
      jj_la1[238] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return first;
}

  final public Expression Expression() throws ParseException {/*@bgen(jjtree) Expression */
    SimpleNode jjtn000 = new SimpleNode(JJTEXPRESSION);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));Expression retval = null;
    try {
      retval = XorExpression();
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
return retval;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return com.javaoffers.thrid.sqlparse.statement in function");
}

  final public Expression XorExpression() throws ParseException {Expression left, right, result;
    left = OrExpression();
result = left;
    label_61:
    while (true) {
      if (jj_2_121(2)) {
        ;
      } else {
        break label_61;
      }
      jj_consume_token(K_XOR);
      right = OrExpression();
result = new XorExpression(left, right);
            left = result;
    }
return result;
}

  final public Expression OrExpression() throws ParseException {Expression left, right, result;
    left = AndExpression();
result = left;
    label_62:
    while (true) {
      if (jj_2_122(2)) {
        ;
      } else {
        break label_62;
      }
      jj_consume_token(K_OR);
      right = AndExpression();
result = new OrExpression(left, right);
            left = result;
    }
return result;
}

  final public Expression AndExpression() throws ParseException {Expression left, right, result;
    boolean not = false;
        boolean exclamationMarkNot=false;
    if (jj_2_123(2147483647)) {
      left = Condition();
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_NOT:
      case 325:
      case 332:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_NOT:
        case 332:{
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_NOT:{
            jj_consume_token(K_NOT);
not=true;
            break;
            }
          case 332:{
            jj_consume_token(332);
not=true; exclamationMarkNot=true;
            break;
            }
          default:
            jj_la1[239] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          break;
          }
        default:
          jj_la1[240] = jj_gen;
          ;
        }
        jj_consume_token(325);
        left = XorExpression();
        jj_consume_token(326);
left = new Parenthesis(left); if (not) { left = new NotExpression(left, exclamationMarkNot); not = false; }
        break;
        }
      default:
        jj_la1[241] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
result = left;
    label_63:
    while (true) {
      if (jj_2_124(2)) {
        ;
      } else {
        break label_63;
      }
boolean useOperator = false;
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_AND:{
        jj_consume_token(K_AND);
        break;
        }
      case K_AND_OPERATOR:{
        jj_consume_token(K_AND_OPERATOR);
useOperator=true;
        break;
        }
      default:
        jj_la1[242] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      if (jj_2_125(2147483647)) {
        right = Condition();
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_NOT:
        case 325:
        case 332:{
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_NOT:
          case 332:{
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_NOT:{
              jj_consume_token(K_NOT);
not=true;
              break;
              }
            case 332:{
              jj_consume_token(332);
not=true; exclamationMarkNot=true;
              break;
              }
            default:
              jj_la1[243] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
            break;
            }
          default:
            jj_la1[244] = jj_gen;
            ;
          }
          jj_consume_token(325);
          right = XorExpression();
          jj_consume_token(326);
right = new Parenthesis(right); if (not) { right = new NotExpression(right, exclamationMarkNot); not = false; }
          break;
          }
        default:
          jj_la1[245] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
result = new AndExpression(left, right);
            ((AndExpression)result).setUseOperator(useOperator);
            left = result;
    }
return result;
}

  final public Expression Condition() throws ParseException {Expression result;
    Token token;
    boolean not = false;
        boolean exclamationMarkNot = false;
    if (jj_2_126(2)) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_NOT:{
        jj_consume_token(K_NOT);
not=true;
        break;
        }
      case 332:{
        jj_consume_token(332);
not=true; exclamationMarkNot=true;
        break;
        }
      default:
        jj_la1[246] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } else {
      ;
    }
    if (jj_2_127(2147483647)) {
      result = RegularCondition();
    } else if (jj_2_128(1)) {
      result = SQLCondition();
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
return not?new NotExpression(result, exclamationMarkNot):result;
}

  final public Expression RegularCondition() throws ParseException {/*@bgen(jjtree) RegularCondition */
    SimpleNode jjtn000 = new SimpleNode(JJTREGULARCONDITION);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));Expression result = null;
    Expression leftExpression;
    Expression rightExpression;
    int oracleJoin=EqualsTo.NO_ORACLE_JOIN;
    int oraclePrior=EqualsTo.NO_ORACLE_PRIOR;
    boolean binary = false;
    boolean not = false;
    try {
      if (jj_2_129(2)) {
        jj_consume_token(K_PRIOR);
oraclePrior = EqualsTo.ORACLE_PRIOR_START;
      } else {
        ;
      }
      leftExpression = ComparisonItem();
result = leftExpression;
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 325:{
        jj_consume_token(325);
        jj_consume_token(333);
        jj_consume_token(326);
oracleJoin=EqualsTo.ORACLE_JOIN_RIGHT;
        break;
        }
      default:
        jj_la1[247] = jj_gen;
        ;
      }
      if (jj_2_130(2)) {
        jj_consume_token(334);
result = new GreaterThan();
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 335:{
          jj_consume_token(335);
result = new MinorThan();
          break;
          }
        case 327:{
          jj_consume_token(327);
result = new EqualsTo();
          break;
          }
        case OP_GREATERTHANEQUALS:{
          token = jj_consume_token(OP_GREATERTHANEQUALS);
result = new GreaterThanEquals(token.image);
          break;
          }
        case OP_MINORTHANEQUALS:{
          token = jj_consume_token(OP_MINORTHANEQUALS);
result = new MinorThanEquals(token.image);
          break;
          }
        case OP_NOTEQUALSSTANDARD:{
          token = jj_consume_token(OP_NOTEQUALSSTANDARD);
result = new NotEqualsTo(token.image);
          break;
          }
        case OP_NOTEQUALSBANG:{
          token = jj_consume_token(OP_NOTEQUALSBANG);
result = new NotEqualsTo(token.image);
          break;
          }
        case 336:{
          jj_consume_token(336);
result = new Matches();
          break;
          }
        case 337:{
          jj_consume_token(337);
result = new RegExpMatchOperator(RegExpMatchOperatorType.MATCH_CASESENSITIVE);
          break;
          }
        case K_NOT:
        case K_REGEXP:{
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_NOT:{
            jj_consume_token(K_NOT);
not=true;
            break;
            }
          default:
            jj_la1[248] = jj_gen;
            ;
          }
          jj_consume_token(K_REGEXP);
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_BINARY:{
            jj_consume_token(K_BINARY);
binary=true;
            break;
            }
          default:
            jj_la1[249] = jj_gen;
            ;
          }
result = new RegExpMySQLOperator(not, binary?RegExpMatchOperatorType.MATCH_CASESENSITIVE:RegExpMatchOperatorType.MATCH_CASEINSENSITIVE);
          break;
          }
        case K_RLIKE:{
          jj_consume_token(K_RLIKE);
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_BINARY:{
            jj_consume_token(K_BINARY);
binary=true;
            break;
            }
          default:
            jj_la1[250] = jj_gen;
            ;
          }
result = new RegExpMySQLOperator(binary?RegExpMatchOperatorType.MATCH_CASESENSITIVE:RegExpMatchOperatorType.MATCH_CASEINSENSITIVE).useRLike();
          break;
          }
        case 338:{
          jj_consume_token(338);
result = new RegExpMatchOperator(RegExpMatchOperatorType.MATCH_CASEINSENSITIVE);
          break;
          }
        case 339:{
          jj_consume_token(339);
result = new RegExpMatchOperator(RegExpMatchOperatorType.NOT_MATCH_CASESENSITIVE);
          break;
          }
        case 340:{
          jj_consume_token(340);
result = new RegExpMatchOperator(RegExpMatchOperatorType.NOT_MATCH_CASEINSENSITIVE);
          break;
          }
        case 341:{
          jj_consume_token(341);
result = new JsonOperator("@>");
          break;
          }
        case 342:{
          jj_consume_token(342);
result = new JsonOperator("<@");
          break;
          }
        case 331:{
          jj_consume_token(331);
result = new JsonOperator("?");
          break;
          }
        case 343:{
          jj_consume_token(343);
result = new JsonOperator("?|");
          break;
          }
        case 344:{
          jj_consume_token(344);
result = new JsonOperator("?&");
          break;
          }
        case OP_CONCAT:{
          jj_consume_token(OP_CONCAT);
result = new JsonOperator("||");
          break;
          }
        case 345:{
          jj_consume_token(345);
result = new JsonOperator("-");
          break;
          }
        case 346:{
          jj_consume_token(346);
result = new JsonOperator("-#");
          break;
          }
        case 347:{
          jj_consume_token(347);
result = new GeometryDistance("<->");
          break;
          }
        case 348:{
          jj_consume_token(348);
result = new GeometryDistance("<#>");
          break;
          }
        default:
          jj_la1[251] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      if (jj_2_131(2)) {
        jj_consume_token(K_PRIOR);
        rightExpression = ComparisonItem();
oraclePrior = EqualsTo.ORACLE_PRIOR_END;
      } else if (jj_2_132(1)) {
        rightExpression = ComparisonItem();
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
      if (jj_2_133(2)) {
        jj_consume_token(325);
        jj_consume_token(333);
        jj_consume_token(326);
oracleJoin=EqualsTo.ORACLE_JOIN_LEFT;
      } else {
        ;
      }
BinaryExpression regCond = (BinaryExpression) result;
        regCond.setLeftExpression(leftExpression);
        regCond.setRightExpression(rightExpression);

        if (oracleJoin>0)
            ((SupportsOldOracleJoinSyntax)result).setOldOracleJoinSyntax(oracleJoin);

        if (oraclePrior!=EqualsTo.NO_ORACLE_PRIOR)
            ((SupportsOldOracleJoinSyntax)result).setOraclePriorPosition(oraclePrior);
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
linkAST(result,jjtn000);
        return result;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return com.javaoffers.thrid.sqlparse.statement in function");
}

  final public Expression SQLCondition() throws ParseException {Expression result;
    Expression left;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_EXISTS:{
      result = ExistsExpression();
      break;
      }
    default:
      jj_la1[253] = jj_gen;
      if (jj_2_140(2147483647)) {
        result = InExpression();
      } else if (jj_2_141(1)) {
        left = SimpleExpression();
result = left;
        if (jj_2_139(2)) {
          if (jj_2_134(2)) {
            result = Between(left);
          } else if (jj_2_135(2147483647)) {
            result = IsNullExpression(left);
          } else if (jj_2_136(2147483647)) {
            result = IsBooleanExpression(left);
          } else if (jj_2_137(2)) {
            result = LikeExpression(left);
          } else if (jj_2_138(2147483647)) {
            result = IsDistinctExpression(left);
          } else {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_NOT:
            case K_SIMILAR:{
              result = SimilarToExpression(left);
              break;
              }
            default:
              jj_la1[252] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
          }
        } else {
          ;
        }
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
return result;
}

  final public Expression InExpression() throws ParseException {/*@bgen(jjtree) InExpression */
    SimpleNode jjtn000 = new SimpleNode(JJTINEXPRESSION);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));InExpression result = new InExpression();
    ItemsList leftItemsList = null;
    ExpressionList rightItemsList = null;
    Expression leftExpression = null;
    Expression rightExpression = null;
    Token token;
    MultiExpressionList multiExpressionList = null;
    ExpressionList expressionList = null;
    try {
      leftExpression = SimpleExpression();
result.setLeftExpression(leftExpression);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 325:{
        jj_consume_token(325);
        jj_consume_token(333);
        jj_consume_token(326);
result.setOldOracleJoinSyntax(EqualsTo.ORACLE_JOIN_RIGHT);
        break;
        }
      default:
        jj_la1[254] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_NOT:{
        jj_consume_token(K_NOT);
result.setNot(true);
        break;
        }
      default:
        jj_la1[255] = jj_gen;
        ;
      }
      jj_consume_token(K_IN);
      if (jj_2_142(2)) {
        token = jj_consume_token(S_CHAR_LITERAL);
result.setRightExpression(new StringValue(token.image));
      } else if (jj_2_143(3)) {
        rightExpression = Function();
result.setRightExpression(rightExpression);
      } else if (jj_2_144(2147483647)) {
        jj_consume_token(325);
        rightItemsList = ComplexExpressionList();
result.setRightItemsList(rightItemsList.withBrackets(true) );
        jj_consume_token(326);
      } else if (jj_2_145(3)) {
        jj_consume_token(325);
        rightExpression = SubSelect();
result.setRightExpression( ((SubSelect) rightExpression).withUseBrackets(true) );
        jj_consume_token(326);
      } else if (jj_2_146(2)) {
        rightExpression = SimpleExpression();
result.setRightExpression(rightExpression);
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
linkAST(result,jjtn000);
        return result;
    } catch (Throwable jjte000) {
if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
            jjtn000.jjtSetLastToken(getToken(0));
          }
    }
    throw new RuntimeException("Missing return com.javaoffers.thrid.sqlparse.statement in function");
}

  final public MultiExpressionList MultiInExpressions() throws ParseException {MultiExpressionList multiExpressionList = null;
   ExpressionList expressionList = null;
    jj_consume_token(325);
    jj_consume_token(325);
    expressionList = SimpleExpressionList(true);
if(multiExpressionList == null) {
         multiExpressionList = new MultiExpressionList();
       }
       multiExpressionList.addExpressionList(expressionList);
    label_64:
    while (true) {
      if (jj_2_147(3)) {
        ;
      } else {
        break label_64;
      }
      jj_consume_token(326);
      jj_consume_token(K_COMMA);
      jj_consume_token(325);
      expressionList = SimpleExpressionList(true);
if(multiExpressionList == null) {
          multiExpressionList = new MultiExpressionList();
       }
       multiExpressionList.addExpressionList(expressionList);
    }
    jj_consume_token(326);
    jj_consume_token(326);
return multiExpressionList;
}

  final public Expression Between(Expression leftExpression) throws ParseException {Between result = new Between();
    Expression betweenExpressionStart = null;
    Expression betweenExpressionEnd = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_NOT:{
      jj_consume_token(K_NOT);
result.setNot(true);
      break;
      }
    default:
      jj_la1[256] = jj_gen;
      ;
    }
    jj_consume_token(K_BETWEEN);
    betweenExpressionStart = SimpleExpression();
    jj_consume_token(K_AND);
    betweenExpressionEnd = SimpleExpression();
result.setLeftExpression(leftExpression);
        result.setBetweenExpressionStart(betweenExpressionStart);
        result.setBetweenExpressionEnd(betweenExpressionEnd);
        return result;
}

  final public Expression LikeExpression(Expression leftExpression) throws ParseException {/*@bgen(jjtree) LikeExpression */
    SimpleNode jjtn000 = new SimpleNode(JJTLIKEEXPRESSION);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));LikeExpression result = new LikeExpression();
    Expression rightExpression = null;
    Expression escape;
    try {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_NOT:{
        jj_consume_token(K_NOT);
result.setNot(true);
        break;
        }
      default:
        jj_la1[257] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_LIKE:{
        jj_consume_token(K_LIKE);
        break;
        }
      case K_ILIKE:{
        jj_consume_token(K_ILIKE);
result.setCaseInsensitive(true);
        break;
        }
      default:
        jj_la1[258] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      rightExpression = SimpleExpression();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ESCAPE:{
        jj_consume_token(K_ESCAPE);
        escape = Expression();
result.setEscape(escape);
        break;
        }
      default:
        jj_la1[259] = jj_gen;
        ;
      }
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
result.setLeftExpression(leftExpression);
        result.setRightExpression(rightExpression);
        linkAST(result,jjtn000);
        return result;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return com.javaoffers.thrid.sqlparse.statement in function");
}

  final public Expression SimilarToExpression(Expression leftExpression) throws ParseException {/*@bgen(jjtree) SimilarToExpression */
    SimpleNode jjtn000 = new SimpleNode(JJTSIMILARTOEXPRESSION);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));SimilarToExpression result = new SimilarToExpression();
    Expression rightExpression = null;
    try {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_NOT:{
        jj_consume_token(K_NOT);
result.setNot(true);
        break;
        }
      default:
        jj_la1[260] = jj_gen;
        ;
      }
      jj_consume_token(K_SIMILAR);
      jj_consume_token(K_TO);
      rightExpression = SimpleExpression();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ESCAPE:{
        jj_consume_token(K_ESCAPE);
        token = jj_consume_token(S_CHAR_LITERAL);
result.setEscape((new StringValue(token.image)).getValue());
        break;
        }
      default:
        jj_la1[261] = jj_gen;
        ;
      }
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
result.setLeftExpression(leftExpression);
        result.setRightExpression(rightExpression);
        linkAST(result,jjtn000);
        return result;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return com.javaoffers.thrid.sqlparse.statement in function");
}

  final public Expression IsDistinctExpression(Expression leftExpression) throws ParseException {/*@bgen(jjtree) IsDistinctExpression */
    SimpleNode jjtn000 = new SimpleNode(JJTISDISTINCTEXPRESSION);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));IsDistinctExpression result = new IsDistinctExpression();
    Expression rightExpression = null;
    try {
      jj_consume_token(K_IS);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_NOT:{
        jj_consume_token(K_NOT);
result.setNot(true);
        break;
        }
      default:
        jj_la1[262] = jj_gen;
        ;
      }
      jj_consume_token(K_DISTINCT);
      jj_consume_token(K_FROM);
      rightExpression = SimpleExpression();
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
result.setLeftExpression(leftExpression);
        result.setRightExpression(rightExpression);
        linkAST(result,jjtn000);
        return result;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return com.javaoffers.thrid.sqlparse.statement in function");
}

  final public Expression IsNullExpression(Expression leftExpression) throws ParseException {IsNullExpression result = new IsNullExpression();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ISNULL:{
      jj_consume_token(K_ISNULL);
result.setUseIsNull(true);
      break;
      }
    case K_IS:{
      jj_consume_token(K_IS);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_NOT:{
        jj_consume_token(K_NOT);
result.setNot(true);
        break;
        }
      default:
        jj_la1[263] = jj_gen;
        ;
      }
      jj_consume_token(K_NULL);
      break;
      }
    default:
      jj_la1[264] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
result.setLeftExpression(leftExpression);
        return result;
}

  final public Expression IsBooleanExpression(Expression leftExpression) throws ParseException {IsBooleanExpression result = new IsBooleanExpression();
    jj_consume_token(K_IS);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_NOT:{
      jj_consume_token(K_NOT);
result.setNot(true);
      break;
      }
    default:
      jj_la1[265] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_TRUE:{
      jj_consume_token(K_TRUE);
result.setIsTrue(true);
      break;
      }
    case K_FALSE:{
      jj_consume_token(K_FALSE);
result.setIsTrue(false);
      break;
      }
    default:
      jj_la1[266] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
result.setLeftExpression(leftExpression);
        return result;
}

  final public Expression ExistsExpression() throws ParseException {ExistsExpression result = new ExistsExpression();
    Expression rightExpression = null;
    jj_consume_token(K_EXISTS);
    rightExpression = SimpleExpression();
result.setRightExpression(rightExpression);
        return result;
}

  final public ExpressionList SQLExpressionList() throws ParseException {ExpressionList retval = new ExpressionList();
    List<Expression> expressions = new ArrayList<Expression>();
    Expression expr = null;
    expr = Expression();
expressions.add(expr);
    label_65:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COMMA:{
        ;
        break;
        }
      default:
        jj_la1[267] = jj_gen;
        break label_65;
      }
      jj_consume_token(K_COMMA);
      expr = Expression();
expressions.add(expr);
    }
retval.setExpressions(expressions);
        return retval;
}

  final public ExpressionList SimpleExpressionList(boolean outerBrackets) throws ParseException {/*@bgen(jjtree) ExpressionList */
    SimpleNode jjtn000 = new SimpleNode(JJTEXPRESSIONLIST);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));ExpressionList retval = new ExpressionList().withBrackets(outerBrackets);
    List<Expression> expressions = new ArrayList<Expression>();
    Expression expr = null;
    try {
      expr = SimpleExpression();
expressions.add(expr);
      label_66:
      while (true) {
        if (jj_2_148(2)) {
          ;
        } else {
          break label_66;
        }
        jj_consume_token(K_COMMA);
        expr = SimpleExpression();
expressions.add(expr);
      }
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
retval.setExpressions(expressions);
        return retval;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return com.javaoffers.thrid.sqlparse.statement in function");
}

  final public ExpressionList ComplexExpressionList() throws ParseException {/*@bgen(jjtree) ExpressionList */
    SimpleNode jjtn000 = new SimpleNode(JJTEXPRESSIONLIST);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));ExpressionList retval = new ExpressionList();
    List<Expression> expressions = new ArrayList<Expression>();
    Expression expr = null;
    try {
      if (jj_2_149(2)) {
        expr = OracleNamedFunctionParameter();
      } else if (jj_2_150(1)) {
        expr = Expression();
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
expressions.add(expr);
      label_67:
      while (true) {
        if (jj_2_151(2)) {
          ;
        } else {
          break label_67;
        }
        jj_consume_token(K_COMMA);
        if (jj_2_152(2)) {
          expr = OracleNamedFunctionParameter();
        } else if (jj_2_153(1)) {
          expr = Expression();
        } else {
          jj_consume_token(-1);
          throw new ParseException();
        }
expressions.add(expr);
      }
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
retval.setExpressions(expressions);
        return retval;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return com.javaoffers.thrid.sqlparse.statement in function");
}

// trim( [leading|trailing|both] expr from expr)
// The [leading|trailing|both] token has already been consumed
  final public NamedExpressionList NamedExpressionList1() throws ParseException {NamedExpressionList retval = new NamedExpressionList();
    List<Expression> expressions = new ArrayList<Expression>();
    List<String> names = new ArrayList<String>();
    Expression expr1 = null;
    Expression expr2 = null;
        String name = "";
    Token tk1 = null;
    Token tk2 = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_BOTH:{
      tk1 = jj_consume_token(K_BOTH);
      break;
      }
    case K_LEADING:{
      tk1 = jj_consume_token(K_LEADING);
      break;
      }
    case K_TRAILING:{
      tk1 = jj_consume_token(K_TRAILING);
      break;
      }
    default:
      jj_la1[268] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
names.add(tk1.image);
    expr1 = SimpleExpression();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_FROM:{
      tk2 = jj_consume_token(K_FROM);
      break;
      }
    case K_IN:{
      tk2 = jj_consume_token(K_IN);
      break;
      }
    case K_PLACING:{
      tk2 = jj_consume_token(K_PLACING);
      break;
      }
    default:
      jj_la1[269] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    expr2 = SimpleExpression();
expressions.add(expr1); names.add(tk2.image); expressions.add(expr2);
retval.setNames(names);
        retval.setExpressions(expressions);
        return retval;
}

// substring(expr1 from expr2)
// substring(expr1 from expr2 for expr3)
// trim(expr1 from expr2)
// position(expr1 in expr2)
// overlay(expr1 placing expr2 from expr3)
// overlay(expr1 placing expr2 from expr3 for expr4)
// expr1 has already been consumed
  final public NamedExpressionList NamedExpressionListExprFirst() throws ParseException {NamedExpressionList retval = new NamedExpressionList();
    List<Expression> expressions = new ArrayList<Expression>();
    List<String> names = new ArrayList<String>();
    Expression expr1 = null;
    Expression expr2 = null;
    Expression expr3 = null;
    Expression expr4 = null;
    Token tk2 = null;
    Token tk3 = null;
    Token tk4 = null;
    expr1 = SimpleExpression();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_FROM:{
      tk2 = jj_consume_token(K_FROM);
      break;
      }
    case K_IN:{
      tk2 = jj_consume_token(K_IN);
      break;
      }
    case K_PLACING:{
      tk2 = jj_consume_token(K_PLACING);
      break;
      }
    default:
      jj_la1[270] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
names.add("");
                expressions.add(expr1);
                names.add(tk2.image);
    expr2 = SimpleExpression();
expressions.add(expr2);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_FOR:
    case K_FROM:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_FOR:{
        tk3 = jj_consume_token(K_FOR);
        break;
        }
      case K_FROM:{
        tk3 = jj_consume_token(K_FROM);
        break;
        }
      default:
        jj_la1[271] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      expr3 = SimpleExpression();
names.add(tk3.image); expressions.add(expr3);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_FOR:{
        tk4 = jj_consume_token(K_FOR);
        expr4 = SimpleExpression();
names.add(tk4.image); expressions.add(expr4);
        break;
        }
      default:
        jj_la1[272] = jj_gen;
        ;
      }
      break;
      }
    default:
      jj_la1[273] = jj_gen;
      ;
    }
retval.setNames(names);
        retval.setExpressions(expressions);
        return retval;
}

  final public ExpressionList SimpleExpressionListAtLeastTwoItems() throws ParseException {ExpressionList retval = new ExpressionList();
    List<Expression> expressions = new ArrayList<Expression>();
    Expression expr = null;
    expr = SimpleExpression();
expressions.add(expr);
    label_68:
    while (true) {
      jj_consume_token(K_COMMA);
      expr = SimpleExpression();
expressions.add(expr);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COMMA:{
        ;
        break;
        }
      default:
        jj_la1[274] = jj_gen;
        break label_68;
      }
    }
retval.setExpressions(expressions);
        return retval;
}

  final public Expression ComparisonItem() throws ParseException {Expression retval = null;
    if (jj_2_154(3)) {
      retval = AnyComparisonExpression();
    } else if (jj_2_155(2147483647)) {
      retval = ValueListExpression();
    } else if (jj_2_156(3)) {
      retval = SimpleExpression();
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ROW:
      case 325:{
        retval = RowConstructor();
        break;
        }
      default:
        jj_la1[275] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
return retval;
}

  final public Expression AnyComparisonExpression() throws ParseException {AnyComparisonExpression anyComparisonExpr = null;
    AnyType anyType;
    SubSelect subSelect;
    ItemsList simpleExpressionList;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ANY:{
      jj_consume_token(K_ANY);
anyType = AnyType.ANY;
      break;
      }
    case K_SOME:{
      jj_consume_token(K_SOME);
anyType = AnyType.SOME;
      break;
      }
    case K_ALL:{
      jj_consume_token(K_ALL);
anyType = AnyType.ALL;
      break;
      }
    default:
      jj_la1[276] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(325);
    if (jj_2_157(2147483647)) {
      jj_consume_token(K_VALUES);
      simpleExpressionList = SimpleExpressionList(false);
anyComparisonExpr=new AnyComparisonExpression(anyType, simpleExpressionList).withUseBracketsForValues(false);
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_SELECT:
      case K_VALUES:
      case K_WITH:
      case 325:{
        subSelect = SubSelect();
anyComparisonExpr=new AnyComparisonExpression(anyType, subSelect.withUseBrackets(false)).withUseBracketsForValues(false);
        break;
        }
      default:
        jj_la1[277] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    jj_consume_token(326);
return anyComparisonExpr;
}

  final public Expression SimpleExpression() throws ParseException {Expression retval = null;
    UserVariable user = null;
    Token operation = null;
    if (jj_2_158(2147483647)) {
      user = UserVariable();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 327:{
        operation = jj_consume_token(327);
        break;
        }
      case 349:{
        operation = jj_consume_token(349);
        break;
        }
      default:
        jj_la1[278] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } else {
      ;
    }
    retval = ConcatExpression();
if (user != null) {
            VariableAssignment assignment = new VariableAssignment();
            assignment.setVariable(user);
            assignment.setOperation(operation.image);
            assignment.setExpression(retval);
            return assignment;
        } else
            return retval;
}

  final public Expression ConcatExpression() throws ParseException {Expression result = null;
    Expression leftExpression = null;
    Expression rightExpression = null;
    leftExpression = BitwiseAndOr();
result = leftExpression;
    label_69:
    while (true) {
      if (jj_2_159(3)) {
        ;
      } else {
        break label_69;
      }
      jj_consume_token(OP_CONCAT);
      /* Oracle allows space between the bars. */
              rightExpression = BitwiseAndOr();
Concat binExp = new Concat();
            binExp.setLeftExpression(leftExpression);
            binExp.setRightExpression(rightExpression);
            result = binExp;
            leftExpression = result;
    }
return result;
}

  final public Expression BitwiseAndOr() throws ParseException {Expression result = null;
    Expression leftExpression = null;
    Expression rightExpression = null;
    leftExpression = AdditiveExpression();
result = leftExpression;
    label_70:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 350:
      case 351:
      case 352:
      case 353:{
        ;
        break;
        }
      default:
        jj_la1[279] = jj_gen;
        break label_70;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 350:{
        jj_consume_token(350);
result = new BitwiseOr();
        break;
        }
      case 351:{
        jj_consume_token(351);
result = new BitwiseAnd();
        break;
        }
      case 352:{
        jj_consume_token(352);
result = new BitwiseLeftShift();
        break;
        }
      case 353:{
        jj_consume_token(353);
result = new BitwiseRightShift();
        break;
        }
      default:
        jj_la1[280] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      rightExpression = AdditiveExpression();
BinaryExpression binExp = (BinaryExpression) result;
            binExp.setLeftExpression(leftExpression);
            binExp.setRightExpression(rightExpression);
            leftExpression = result;
    }
return result;
}

  final public Expression AdditiveExpression() throws ParseException {Expression result = null;
    Expression leftExpression = null;
    Expression rightExpression = null;
    leftExpression = MultiplicativeExpression();
result = leftExpression;
    label_71:
    while (true) {
      if (jj_2_160(2)) {
        ;
      } else {
        break label_71;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 333:{
        jj_consume_token(333);
result = new Addition();
        break;
        }
      case 345:{
        jj_consume_token(345);
result = new Subtraction();
        break;
        }
      default:
        jj_la1[281] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      rightExpression = MultiplicativeExpression();
BinaryExpression binExp = (BinaryExpression) result;
            binExp.setLeftExpression(leftExpression);
            binExp.setRightExpression(rightExpression);
            leftExpression = result;
    }
return result;
}

  final public Expression MultiplicativeExpression() throws ParseException {Expression result = null;
    Expression leftExpression = null;
    Expression rightExpression = null;
    leftExpression = BitwiseXor();
result = leftExpression;
    label_72:
    while (true) {
      if (jj_2_161(2)) {
        ;
      } else {
        break label_72;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 328:{
        jj_consume_token(328);
result = new Multiplication();
        break;
        }
      case 354:{
        jj_consume_token(354);
result = new Division();
        break;
        }
      case K_DIV:{
        jj_consume_token(K_DIV);
result = new IntegerDivision();
        break;
        }
      case 355:{
        jj_consume_token(355);
result = new Modulo();
        break;
        }
      default:
        jj_la1[282] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      rightExpression = BitwiseXor();
BinaryExpression binExp = (BinaryExpression) result;
            binExp.setLeftExpression(leftExpression);
            binExp.setRightExpression(rightExpression);
            leftExpression = result;
    }
return result;
}

  final public Expression BitwiseXor() throws ParseException {Expression result = null;
    Expression leftExpression = null;
    Expression rightExpression = null;
    leftExpression = PrimaryExpression();
result = leftExpression;
    label_73:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 356:{
        ;
        break;
        }
      default:
        jj_la1[283] = jj_gen;
        break label_73;
      }
      jj_consume_token(356);
      rightExpression = PrimaryExpression();
BitwiseXor binExp = new BitwiseXor();
            binExp.setLeftExpression(leftExpression);
            binExp.setRightExpression(rightExpression);
            result = binExp;
            leftExpression = result;
    }
return result;
}

  final public Expression ArrayExpression(Expression obj) throws ParseException {Expression idxExpr = null;
    Expression startExpr = null;
    Expression stopExpr = null;
    jj_consume_token(357);
    if (jj_2_162(3)) {
      idxExpr = SimpleExpression();
    } else {
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case 330:{
      jj_consume_token(330);
startExpr=idxExpr; idxExpr=null;
      if (jj_2_163(1)) {
        stopExpr = SimpleExpression();
      } else {
        ;
      }
      break;
      }
    default:
      jj_la1[284] = jj_gen;
      ;
    }
    jj_consume_token(358);
return new ArrayExpression(obj, idxExpr, startExpr, stopExpr);
}

  final public Expression PrimaryExpression() throws ParseException {/*@bgen(jjtree) PrimaryExpression */
    SimpleNode jjtn000 = new SimpleNode(JJTPRIMARYEXPRESSION);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));Expression retval = null;
    CastExpression castExpr = null;
    TimezoneExpression timezoneExpr = null;
    Expression timezoneRightExpr = null;
    Token token = null;
    Token sign = null;
    String tmp = "";
    ColDataType type = null;
    boolean not = false;
    boolean exclamationMarkNot = false;
    boolean dateExpressionAllowed = true;
    ExpressionList list;
    try {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_NOT:
      case 332:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_NOT:{
          jj_consume_token(K_NOT);
not=true;
          break;
          }
        case 332:{
          jj_consume_token(332);
not=true; exclamationMarkNot=true;
          break;
          }
        default:
          jj_la1[285] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[286] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 333:
      case 337:
      case 345:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 333:{
          sign = jj_consume_token(333);
          break;
          }
        case 345:{
          sign = jj_consume_token(345);
          break;
          }
        case 337:{
          sign = jj_consume_token(337);
          break;
          }
        default:
          jj_la1[287] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[288] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_NULL:{
        jj_consume_token(K_NULL);
retval = new NullValue();
        break;
        }
      default:
        jj_la1[292] = jj_gen;
        if (jj_2_166(3)) {
          retval = CaseWhenExpression();
        } else {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case 331:{
            retval = SimpleJdbcParameter();
            break;
            }
          default:
            jj_la1[293] = jj_gen;
            if (jj_2_167(2)) {
              retval = JdbcNamedParameter();
            } else {
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case 336:
              case 364:{
                retval = UserVariable();
                break;
                }
              default:
                jj_la1[294] = jj_gen;
                if (jj_2_168(2)) {
                  retval = NumericBind();
                } else if (jj_2_169(3)) {
                  retval = ExtractExpression();
                } else {
                  switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
                  case K_GROUP_CONCAT:{
                    retval = MySQLGroupConcat();
                    break;
                    }
                  case K_XMLSERIALIZE:{
                    retval = XMLSerializeExpr();
                    break;
                    }
                  default:
                    jj_la1[295] = jj_gen;
                    if (jj_2_170(2147483647)) {
                      retval = JsonExpression();
                    } else if (jj_2_171(2147483647)) {
                      retval = Function();
                      if (jj_2_164(2)) {
                        retval = AnalyticExpression((Function) retval);
                      } else {
                        ;
                      }
                    } else if (jj_2_172(2147483647)) {
                      retval = JsonFunction();
                    } else if (jj_2_173(2147483647)) {
                      retval = JsonAggregateFunction();
                    } else if (jj_2_174(2147483647)) {
                      retval = FullTextSearch();
                    } else if (jj_2_175(2)) {
                      retval = IntervalExpression();
dateExpressionAllowed = false;
                    } else {
                      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
                      case S_DOUBLE:{
                        token = jj_consume_token(S_DOUBLE);
retval = new DoubleValue(token.image);
                        break;
                        }
                      case S_LONG:{
                        token = jj_consume_token(S_LONG);
retval = new LongValue(token.image);
                        break;
                        }
                      case S_HEX:{
                        token = jj_consume_token(S_HEX);
retval = new HexValue(token.image);
                        break;
                        }
                      default:
                        jj_la1[296] = jj_gen;
                        if (jj_2_176(2)) {
                          retval = CastExpression();
                        } else if (jj_2_177(2)) {
                          retval = TryCastExpression();
                        } else {
                          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
                          case K_CURRENT:
                          case K_TIME_KEY_EXPR:{
                            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
                            case K_TIME_KEY_EXPR:{
                              token = jj_consume_token(K_TIME_KEY_EXPR);
                              break;
                              }
                            case K_CURRENT:{
                              token = jj_consume_token(K_CURRENT);
                              break;
                              }
                            default:
                              jj_la1[289] = jj_gen;
                              jj_consume_token(-1);
                              throw new ParseException();
                            }
retval = new TimeKeyExpression(token.image);
                            break;
                            }
                          default:
                            jj_la1[297] = jj_gen;
                            if (jj_2_178(2)) {
                              retval = DateTimeLiteralExpression();
                            } else if (jj_2_179(2)) {
                              jj_consume_token(K_ARRAY_LITERAL);
                              retval = ArrayConstructor(true);
                            } else if (jj_2_180(2)) {
                              retval = NextValExpression();
                            } else {
                              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
                              case K_CONNECT_BY_ROOT:{
                                retval = ConnectByRootOperator();
                                break;
                                }
                              default:
                                jj_la1[298] = jj_gen;
                                if (jj_2_181(2)) {
                                  jj_consume_token(K_ALL);
retval = new AllValue();
                                } else if (jj_2_182(2)) {
                                  retval = Column();
                                } else {
                                  switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
                                  case S_CHAR_LITERAL:{
                                    token = jj_consume_token(S_CHAR_LITERAL);
retval = new StringValue(token.image); linkAST(retval,jjtn000);
                                    break;
                                    }
                                  case 359:{
                                    jj_consume_token(359);
                                    token = jj_consume_token(S_CHAR_LITERAL);
                                    jj_consume_token(360);
retval = new DateValue(token.image);
                                    break;
                                    }
                                  case 361:{
                                    jj_consume_token(361);
                                    token = jj_consume_token(S_CHAR_LITERAL);
                                    jj_consume_token(360);
retval = new TimeValue(token.image);
                                    break;
                                    }
                                  case 362:{
                                    jj_consume_token(362);
                                    token = jj_consume_token(S_CHAR_LITERAL);
                                    jj_consume_token(360);
retval = new TimestampValue(token.image);
                                    break;
                                    }
                                  default:
                                    jj_la1[299] = jj_gen;
                                    if (jj_2_183(2147483647)) {
                                      jj_consume_token(325);
                                      retval = SubSelect();
                                      jj_consume_token(326);
                                    } else if (jj_2_184(1)) {
                                      if (jj_2_165(1)) {
                                        if (getAsBoolean(Feature.allowComplexParsing)) {

                                        } else {
                                          jj_consume_token(-1);
                                          throw new ParseException();
                                        }
                                        jj_consume_token(325);
                                        list = ComplexExpressionList();
                                        jj_consume_token(326);
if (list.getExpressions().size() == 1) {
                          retval = new Parenthesis(list.getExpressions().get(0));
                      } else {
                          retval = new RowConstructor().withExprList(list);
                      }
                                      } else {
                                        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
                                        case 325:{
                                          jj_consume_token(325);
                                          list = SimpleExpressionList(true);
                                          jj_consume_token(326);
if (list.getExpressions().size() == 1) {
                              retval = new Parenthesis(list.getExpressions().get(0));
                          } else {
                              retval = new RowConstructor().withExprList(list);
                          }
                                          break;
                                          }
                                        default:
                                          jj_la1[290] = jj_gen;
                                          jj_consume_token(-1);
                                          throw new ParseException();
                                        }
                                      }
                                      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
                                      case 329:{
                                        jj_consume_token(329);
                                        tmp = RelObjectNameExt();
retval = new RowGetExpression(retval, tmp);
                                        break;
                                        }
                                      default:
                                        jj_la1[291] = jj_gen;
                                        ;
                                      }
                                    } else {
                                      jj_consume_token(-1);
                                      throw new ParseException();
                                    }
                                  }
                                }
                              }
                            }
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COLLATE:{
        jj_consume_token(K_COLLATE);
        token = jj_consume_token(S_IDENTIFIER);
retval = new CollateExpression(retval, token.image);
        break;
        }
      default:
        jj_la1[300] = jj_gen;
        ;
      }
      if (jj_2_185(2) && (dateExpressionAllowed)) {
        retval = IntervalExpressionWithoutInterval(retval);
      } else {
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 357:{
        retval = ArrayExpression(retval);
        break;
        }
      default:
        jj_la1[301] = jj_gen;
        ;
      }
      label_74:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 363:{
          ;
          break;
          }
        default:
          jj_la1[302] = jj_gen;
          break label_74;
        }
        jj_consume_token(363);
        type = ColDataType();
castExpr = new CastExpression();
        castExpr.setUseCastKeyword(false);
        castExpr.setLeftExpression(retval);
        castExpr.setType(type);
        retval=castExpr;
      }
      label_75:
      while (true) {
        if (jj_2_186(2)) {
          ;
        } else {
          break label_75;
        }
        jj_consume_token(K_AT);
        jj_consume_token(K_DATETIMELITERAL);
        jj_consume_token(K_ZONE);
        timezoneRightExpr = PrimaryExpression();
if (timezoneExpr == null)
            timezoneExpr = new TimezoneExpression();

        timezoneExpr.addTimezoneExpression(timezoneRightExpr);
      }
if (timezoneExpr != null && !timezoneExpr.getTimezoneExpressions().isEmpty()) {
            timezoneExpr.setLeftExpression(retval);
            retval=timezoneExpr;
        }
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
if (sign != null) {
            retval = new SignedExpression(sign.image.charAt(0), retval);
        }
        if (not) {
            retval = new NotExpression(retval, exclamationMarkNot);
        }
        return retval;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return com.javaoffers.thrid.sqlparse.statement in function");
}

  final public ConnectByRootOperator ConnectByRootOperator() throws ParseException {/*@bgen(jjtree) ConnectByRootOperator */
    SimpleNode jjtn000 = new SimpleNode(JJTCONNECTBYROOTOPERATOR);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));Column column;
    try {
      jj_consume_token(K_CONNECT_BY_ROOT);
      column = Column();
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
return new ConnectByRootOperator(column);
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return com.javaoffers.thrid.sqlparse.statement in function");
}

  final public NextValExpression NextValExpression() throws ParseException {List<String> data = new ArrayList<String>();
    Token token;
    token = jj_consume_token(K_NEXTVAL);
    data = RelObjectNameList();
return new NextValExpression(data, token.image);
}

  final public JdbcNamedParameter JdbcNamedParameter() throws ParseException {JdbcNamedParameter parameter = new JdbcNamedParameter();
    String name;
    jj_consume_token(330);
    name = RelObjectNameExt2();
parameter.setName(name);
return parameter;
}

  final public OracleNamedFunctionParameter OracleNamedFunctionParameter() throws ParseException {String name;
    Expression expression;
    name = RelObjectNameExt2();
    jj_consume_token(K_ORACLE_NAMED_PARAMETER_ASSIGNMENT);
    expression = Expression();
return new OracleNamedFunctionParameter(name, expression);
}

  final public UserVariable UserVariable() throws ParseException {UserVariable var = new UserVariable();
    String varName;
    String var2;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case 364:{
      jj_consume_token(364);
      break;
      }
    case 336:{
      jj_consume_token(336);
var.setDoubleAdd(true);
      break;
      }
    default:
      jj_la1[303] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    varName = RelObjectNameExt2();
    label_76:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 329:{
        ;
        break;
        }
      default:
        jj_la1[304] = jj_gen;
        break label_76;
      }
      jj_consume_token(329);
      var2 = RelObjectNameExt2();
varName+="." + var2;
    }
var.setName(varName);
        return var;
}

  final public NumericBind NumericBind() throws ParseException {NumericBind var = new NumericBind();
    Token token;
    jj_consume_token(330);
    token = jj_consume_token(S_LONG);
var.setBindId(Integer.valueOf(token.image));
        return var;
}

  final public DateTimeLiteralExpression DateTimeLiteralExpression() throws ParseException {DateTimeLiteralExpression expr = new DateTimeLiteralExpression();
    Token t;
    t = jj_consume_token(K_DATETIMELITERAL);
expr.setType(DateTimeLiteralExpression.DateTime.valueOf(t.image.toUpperCase()));
    t = jj_consume_token(S_CHAR_LITERAL);
expr.setValue(t.image); return expr;
}

  final public ArrayConstructor ArrayConstructor(final boolean arrayKeyword) throws ParseException {ArrayList<Expression> expList = new ArrayList();
    ArrayConstructor array = new ArrayConstructor(expList, arrayKeyword);
    Expression exp = null;
    jj_consume_token(357);
    if (jj_2_189(1)) {
      if (jj_2_187(3)) {
        exp = SimpleExpression();
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 357:{
          exp = ArrayConstructor(false);
          break;
          }
        default:
          jj_la1[305] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
expList.add(exp);
      label_77:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_COMMA:{
          ;
          break;
          }
        default:
          jj_la1[306] = jj_gen;
          break label_77;
        }
        jj_consume_token(K_COMMA);
        if (jj_2_188(1)) {
          exp = SimpleExpression();
        } else {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case 357:{
            exp = ArrayConstructor(false);
            break;
            }
          default:
            jj_la1[307] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
expList.add(exp);
      }
    } else {
      ;
    }
    jj_consume_token(358);
return array;
}

  final public JsonExpression JsonExpression() throws ParseException {JsonExpression result = new JsonExpression();
  Expression expr;
  Token token;
  ColDataType type = null;
  CastExpression castExpr = null;
    expr = Column();
    label_78:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 363:{
        ;
        break;
        }
      default:
        jj_la1[308] = jj_gen;
        break label_78;
      }
      jj_consume_token(363);
      type = ColDataType();
castExpr = new CastExpression();
            castExpr.setUseCastKeyword(false);
            castExpr.setLeftExpression(expr);
            castExpr.setType(type);
            expr=castExpr;
    }
    label_79:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 365:{
        jj_consume_token(365);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S_CHAR_LITERAL:{
          token = jj_consume_token(S_CHAR_LITERAL);
          break;
          }
        case S_LONG:{
          token = jj_consume_token(S_LONG);
          break;
          }
        default:
          jj_la1[309] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
result.addIdent(token.image,"->");
        break;
        }
      case 366:{
        jj_consume_token(366);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S_CHAR_LITERAL:{
          token = jj_consume_token(S_CHAR_LITERAL);
          break;
          }
        case S_LONG:{
          token = jj_consume_token(S_LONG);
          break;
          }
        default:
          jj_la1[310] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
result.addIdent(token.image,"->>");
        break;
        }
      case 367:{
        jj_consume_token(367);
        token = jj_consume_token(S_CHAR_LITERAL);
result.addIdent(token.image,"#>");
        break;
        }
      case 368:{
        jj_consume_token(368);
        token = jj_consume_token(S_CHAR_LITERAL);
result.addIdent(token.image,"#>>");
        break;
        }
      default:
        jj_la1[311] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 365:
      case 366:
      case 367:
      case 368:{
        ;
        break;
        }
      default:
        jj_la1[312] = jj_gen;
        break label_79;
      }
    }
result.setExpression(expr);
        return result;
}

  final public JsonFunction JsonFunction() throws ParseException {JsonFunction result = new JsonFunction();
    boolean usingKeyKeyword = false;
    boolean usingValueKeyword = false;
    boolean usingFormatJason = false;
    Token keyToken;
    Token valueToken = null;
    Column column = null;
    JsonKeyValuePair keyValuePair;

    Expression expression = null;
    JsonFunctionExpression functionExpression;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_JSON_OBJECT:{
      jj_consume_token(K_JSON_OBJECT);
      jj_consume_token(325);
result.setType( JsonFunctionType.OBJECT );
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_KEY:
      case S_CHAR_LITERAL:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_KEY:{
          jj_consume_token(K_KEY);
usingKeyKeyword = true;
          break;
          }
        default:
          jj_la1[313] = jj_gen;
          ;
        }
        keyToken = jj_consume_token(S_CHAR_LITERAL);
        if (jj_2_190(2)) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case 330:{
            jj_consume_token(330);
            break;
            }
          case K_COMMA:{
            jj_consume_token(K_COMMA);
result.setType( JsonFunctionType.POSTGRES_OBJECT );
            break;
            }
          case K_VALUE:{
            jj_consume_token(K_VALUE);
usingValueKeyword = true;
            break;
            }
          default:
            jj_la1[314] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          expression = Expression();
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_FORMAT:{
            jj_consume_token(K_FORMAT);
            jj_consume_token(K_JSON);
usingFormatJason = true;
            break;
            }
          default:
            jj_la1[315] = jj_gen;
            ;
          }
        } else {
          ;
        }
if (expression !=null) {
                                                                           keyValuePair = new JsonKeyValuePair( keyToken.image, expression, usingKeyKeyword, usingValueKeyword );
                                                                           keyValuePair.setUsingFormatJson( usingFormatJason );
                                                                           result.add(keyValuePair);
                                                                      } else {
                                       result.setType( JsonFunctionType.POSTGRES_OBJECT );
                                       keyValuePair = new JsonKeyValuePair( keyToken.image, null, false, false );
                                       result.add(keyValuePair);
                                  }
        label_80:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_COMMA:{
            ;
            break;
            }
          default:
            jj_la1[316] = jj_gen;
            break label_80;
          }
          jj_consume_token(K_COMMA);
usingKeyKeyword = false; usingValueKeyword = false;
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_KEY:{
            jj_consume_token(K_KEY);
usingKeyKeyword = true;
            break;
            }
          default:
            jj_la1[317] = jj_gen;
            ;
          }
          keyToken = jj_consume_token(S_CHAR_LITERAL);
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case 330:{
            jj_consume_token(330);
            break;
            }
          case K_COMMA:{
            jj_consume_token(K_COMMA);
result.setType( JsonFunctionType.MYSQL_OBJECT );
            break;
            }
          case K_VALUE:{
            jj_consume_token(K_VALUE);
usingValueKeyword = true;
            break;
            }
          default:
            jj_la1[318] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          expression = Expression();
keyValuePair = new JsonKeyValuePair( keyToken.image, expression, usingKeyKeyword, usingValueKeyword ); result.add(keyValuePair);
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_FORMAT:{
            jj_consume_token(K_FORMAT);
            jj_consume_token(K_JSON);
keyValuePair.setUsingFormatJson( true );
            break;
            }
          default:
            jj_la1[319] = jj_gen;
            ;
          }
        }
        break;
        }
      default:
        jj_la1[320] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ABSENT:
      case K_NULL:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_NULL:{
          jj_consume_token(K_NULL);
          jj_consume_token(K_ON);
          jj_consume_token(K_NULL);
result.setOnNullType(  JsonAggregateOnNullType.NULL );
          break;
          }
        case K_ABSENT:{
          jj_consume_token(K_ABSENT);
          jj_consume_token(K_ON);
          jj_consume_token(K_NULL);
result.setOnNullType(  JsonAggregateOnNullType.ABSENT );
          break;
          }
        default:
          jj_la1[321] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[322] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_WITH:
      case K_WITHOUT:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_WITH:{
          jj_consume_token(K_WITH);
          jj_consume_token(K_UNIQUE);
          jj_consume_token(K_KEYS);
result.setUniqueKeysType( JsonAggregateUniqueKeysType.WITH );
          break;
          }
        case K_WITHOUT:{
          jj_consume_token(K_WITHOUT);
          jj_consume_token(K_UNIQUE);
          jj_consume_token(K_KEYS);
result.setUniqueKeysType( JsonAggregateUniqueKeysType.WITHOUT );
          break;
          }
        default:
          jj_la1[323] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[324] = jj_gen;
        ;
      }
      jj_consume_token(326);
      break;
      }
    case K_JSON_ARRAY:{
      jj_consume_token(K_JSON_ARRAY);
result.setType( JsonFunctionType.ARRAY );
      jj_consume_token(325);
      label_81:
      while (true) {
        if (jj_2_191(1)) {
          ;
        } else {
          break label_81;
        }
        if (jj_2_194(2)) {
          jj_consume_token(K_NULL);
          jj_consume_token(K_ON);
          jj_consume_token(K_NULL);
result.setOnNullType(  JsonAggregateOnNullType.NULL );
        } else if (jj_2_195(1)) {
          expression = Expression();
functionExpression = new JsonFunctionExpression( expression ); result.add( functionExpression );
          if (jj_2_192(2)) {
            jj_consume_token(K_FORMAT);
            jj_consume_token(K_JSON);
functionExpression.setUsingFormatJson( true );
          } else {
            ;
          }
          label_82:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_COMMA:{
              ;
              break;
              }
            default:
              jj_la1[325] = jj_gen;
              break label_82;
            }
            jj_consume_token(K_COMMA);
            expression = Expression();
functionExpression = new JsonFunctionExpression( expression ); result.add( functionExpression );
            if (jj_2_193(2)) {
              jj_consume_token(K_FORMAT);
              jj_consume_token(K_JSON);
functionExpression.setUsingFormatJson( true );
            } else {
              ;
            }
          }
        } else {
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ABSENT:{
        jj_consume_token(K_ABSENT);
        jj_consume_token(K_ON);
        jj_consume_token(K_NULL);
result.setOnNullType(  JsonAggregateOnNullType.ABSENT );
        break;
        }
      default:
        jj_la1[326] = jj_gen;
        ;
      }
      jj_consume_token(326);
      break;
      }
    default:
      jj_la1[327] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return result;
}

  final public JsonAggregateFunction JsonAggregateFunction() throws ParseException {JsonAggregateFunction result = new JsonAggregateFunction();
    Token token;
    Expression expression;
    List<OrderByElement> expressionOrderByList = null;

    Expression filter;
    ExpressionList expressionList = null;
    List<OrderByElement> olist = null;
    WindowElement windowElement = null;
    boolean partitionByBrackets = false;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_JSON_OBJECTAGG:{
      jj_consume_token(K_JSON_OBJECTAGG);
      jj_consume_token(325);
result.setType( JsonFunctionType.OBJECT );
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_KEY:{
        jj_consume_token(K_KEY);
result.setUsingKeyKeyword( true );
        break;
        }
      default:
        jj_la1[328] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case DT_ZONE:{
        token = jj_consume_token(DT_ZONE);
        break;
        }
      case S_DOUBLE:{
        token = jj_consume_token(S_DOUBLE);
        break;
        }
      case S_LONG:{
        token = jj_consume_token(S_LONG);
        break;
        }
      case S_HEX:{
        token = jj_consume_token(S_HEX);
        break;
        }
      case S_CHAR_LITERAL:{
        token = jj_consume_token(S_CHAR_LITERAL);
        break;
        }
      case S_IDENTIFIER:{
        token = jj_consume_token(S_IDENTIFIER);
        break;
        }
      case S_QUOTED_IDENTIFIER:{
        token = jj_consume_token(S_QUOTED_IDENTIFIER);
        break;
        }
      default:
        jj_la1[329] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
result.setKey( token.image );
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 330:{
        jj_consume_token(330);
        break;
        }
      case K_VALUE:{
        jj_consume_token(K_VALUE);
result.setUsingValueKeyword( true );
        break;
        }
      default:
        jj_la1[330] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S_IDENTIFIER:{
        token = jj_consume_token(S_IDENTIFIER);
        break;
        }
      case S_QUOTED_IDENTIFIER:{
        token = jj_consume_token(S_QUOTED_IDENTIFIER);
        break;
        }
      default:
        jj_la1[331] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
result.setValue( token.image );
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_FORMAT:{
        jj_consume_token(K_FORMAT);
        jj_consume_token(K_JSON);
result.setUsingFormatJson( true );
        break;
        }
      default:
        jj_la1[332] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ABSENT:
      case K_NULL:{
        if (jj_2_196(2)) {
          jj_consume_token(K_NULL);
          jj_consume_token(K_ON);
          jj_consume_token(K_NULL);
result.setOnNullType(  JsonAggregateOnNullType.NULL );
        } else {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_ABSENT:{
            jj_consume_token(K_ABSENT);
            jj_consume_token(K_ON);
            jj_consume_token(K_NULL);
result.setOnNullType(  JsonAggregateOnNullType.ABSENT );
            break;
            }
          default:
            jj_la1[333] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
        break;
        }
      default:
        jj_la1[334] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_WITH:
      case K_WITHOUT:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_WITH:{
          jj_consume_token(K_WITH);
          jj_consume_token(K_UNIQUE);
          jj_consume_token(K_KEYS);
result.setUniqueKeysType( JsonAggregateUniqueKeysType.WITH );
          break;
          }
        case K_WITHOUT:{
          jj_consume_token(K_WITHOUT);
          jj_consume_token(K_UNIQUE);
          jj_consume_token(K_KEYS);
result.setUniqueKeysType( JsonAggregateUniqueKeysType.WITHOUT );
          break;
          }
        default:
          jj_la1[335] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[336] = jj_gen;
        ;
      }
      jj_consume_token(326);
      break;
      }
    case K_JSON_ARRAYAGG:{
      jj_consume_token(K_JSON_ARRAYAGG);
      jj_consume_token(325);
result.setType( JsonFunctionType.ARRAY );
      expression = Expression();
result.setExpression( expression );
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_FORMAT:{
        jj_consume_token(K_FORMAT);
        jj_consume_token(K_JSON);
result.setUsingFormatJson( true );
        break;
        }
      default:
        jj_la1[337] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ORDER:{
        expressionOrderByList = OrderByElements();
result.setExpressionOrderByElements( expressionOrderByList );
        break;
        }
      default:
        jj_la1[338] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ABSENT:
      case K_NULL:{
        if (jj_2_197(2)) {
          jj_consume_token(K_NULL);
          jj_consume_token(K_ON);
          jj_consume_token(K_NULL);
result.setOnNullType(  JsonAggregateOnNullType.NULL );
        } else {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_ABSENT:{
            jj_consume_token(K_ABSENT);
            jj_consume_token(K_ON);
            jj_consume_token(K_NULL);
result.setOnNullType(  JsonAggregateOnNullType.ABSENT );
            break;
            }
          default:
            jj_la1[339] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
        break;
        }
      default:
        jj_la1[340] = jj_gen;
        ;
      }
      jj_consume_token(326);
      break;
      }
    default:
      jj_la1[341] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    if (jj_2_198(2)) {
      jj_consume_token(K_FILTER);
      jj_consume_token(325);
      jj_consume_token(K_WHERE);
result.setAnalyticType(AnalyticType.FILTER_ONLY);
      filter = Expression();
result.setFilterExpression( filter );
      jj_consume_token(326);
    } else {
      ;
    }
    if (jj_2_200(2)) {
      jj_consume_token(K_OVER);
result.setAnalyticType(AnalyticType.OVER);
      jj_consume_token(325);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_PARTITION:{
        jj_consume_token(K_PARTITION);
        jj_consume_token(K_BY);
        if (jj_2_199(2147483647)) {
          expressionList = ComplexExpressionList();
        } else {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case 325:{
            jj_consume_token(325);
partitionByBrackets = true;
            expressionList = ComplexExpressionList();
            jj_consume_token(326);
            break;
            }
          default:
            jj_la1[342] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
        break;
        }
      default:
        jj_la1[343] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ORDER:{
        olist = OrderByElements();
        break;
        }
      default:
        jj_la1[344] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_RANGE:
      case K_ROWS:{
        windowElement = WindowElement();
        break;
        }
      default:
        jj_la1[345] = jj_gen;
        ;
      }
result.setPartitionExpressionList(expressionList, partitionByBrackets);
                result.setOrderByElements(olist);
                result.setWindowElement(windowElement);
      jj_consume_token(326);
    } else {
      ;
    }
return result;
}

  final public IntervalExpression IntervalExpression() throws ParseException {IntervalExpression interval;
    Token token = null;
    Expression expr = null;
    boolean signed = false;
interval = new IntervalExpression();
    jj_consume_token(K_INTERVAL);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case 345:{
      jj_consume_token(345);
signed=true;
      break;
      }
    default:
      jj_la1[346] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case S_LONG:{
      token = jj_consume_token(S_LONG);
      break;
      }
    case S_DOUBLE:{
      token = jj_consume_token(S_DOUBLE);
      break;
      }
    case S_CHAR_LITERAL:{
      token = jj_consume_token(S_CHAR_LITERAL);
      break;
      }
    default:
      jj_la1[347] = jj_gen;
      if (jj_2_201(2147483647)) {
        expr = SimpleJdbcParameter();
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 330:{
          expr = JdbcNamedParameter();
          break;
          }
        default:
          jj_la1[348] = jj_gen;
          if (jj_2_202(2147483647)) {
            expr = Function();
          } else {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_ACTION:
            case K_ACTIVE:
            case K_ALGORITHM:
            case K_ALL:
            case K_ANY:
            case K_ARCHIVE:
            case K_ARRAY_LITERAL:
            case K_AT:
            case K_BYTE:
            case K_CASCADE:
            case K_CASE:
            case K_CASEWHEN:
            case K_CAST:
            case K_TRY_CAST:
            case K_CHARACTER:
            case K_CHANGE:
            case K_CHECKPOINT:
            case K_CHAR:
            case K_COLUMN:
            case K_COLUMNS:
            case K_COMMIT:
            case K_COMMENT:
            case K_COSTS:
            case K_CREATE:
            case K_CYCLE:
            case K_DATETIMELITERAL:
            case K_DATE_LITERAL:
            case K_DBA_RECYCLEBIN:
            case K_DEFAULT:
            case K_DESC:
            case K_DESCRIBE:
            case K_DISABLE:
            case K_DISCONNECT:
            case K_DIV:
            case K_DO:
            case K_DOUBLE:
            case K_DUMP:
            case K_DUPLICATE:
            case K_ENABLE:
            case K_END:
            case K_EXCLUDE:
            case K_EXTRACT:
            case K_FILTER:
            case K_FIRST:
            case K_FALSE:
            case K_FLUSH:
            case K_FOLLOWING:
            case K_FORMAT:
            case K_FULLTEXT:
            case K_GROUP:
            case K_GROUPING:
            case K_HISTORY:
            case K_IF:
            case K_IIF:
            case K_IN:
            case K_INDEX:
            case K_INSERT:
            case K_INTERVAL:
            case K_ISNULL:
            case K_JSON:
            case K_KEY:
            case K_FN:
            case K_LAST:
            case K_LEADING:
            case K_LEFT:
            case K_LIMIT:
            case K_LOCAL:
            case K_LINK:
            case K_LOG:
            case K_MATERIALIZED:
            case K_NEXTVAL:
            case K_NO:
            case K_NOLOCK:
            case K_NULLS:
            case K_OF:
            case K_OFFSET:
            case K_ON:
            case K_OPEN:
            case K_ORDER:
            case K_OVER:
            case K_OPTIMIZE:
            case K_PARALLEL:
            case K_PARTITION:
            case K_PATH:
            case K_PERCENT:
            case K_PRECISION:
            case K_PRIMARY:
            case K_PRIOR:
            case K_PROCEDURE:
            case K_PUBLIC:
            case K_QUERY:
            case K_QUIESCE:
            case K_RANGE:
            case K_READ:
            case K_RECYCLEBIN:
            case K_REGISTER:
            case K_REPLACE:
            case K_RESUME:
            case K_RESTRICTED:
            case K_RIGHT:
            case K_ROW:
            case K_ROWS:
            case K_SCHEMA:
            case K_SEQUENCE:
            case K_SEPARATOR:
            case K_SESSION:
            case K_SET:
            case K_SHUTDOWN:
            case K_SIBLINGS:
            case K_SIZE:
            case K_SKIP:
            case K_SOME:
            case K_START:
            case K_SUSPEND:
            case K_SWITCH:
            case K_SYNONYM:
            case K_SYSTEM:
            case K_TABLE:
            case K_TABLES:
            case K_TABLESPACE:
            case K_TEMP:
            case K_TEMPORARY:
            case K_TIMEOUT:
            case K_TO:
            case K_TOP:
            case K_TRUNCATE:
            case K_TRUE:
            case K_TYPE:
            case K_UNQIESCE:
            case K_USER:
            case K_SIGNED:
            case K_STRING_FUNCTION_NAME:
            case K_UNSIGNED:
            case K_VALIDATE:
            case K_VALUE:
            case K_VALUES:
            case K_VIEW:
            case K_XML:
            case K_ZONE:
            case S_IDENTIFIER:
            case S_QUOTED_IDENTIFIER:{
              expr = Column();
              break;
              }
            default:
              jj_la1[349] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
          }
        }
      }
    }
if (expr != null) {
            if (signed) expr = new SignedExpression('-', expr);
            interval.setExpression(expr);
        } else {
            interval.setParameter((signed?"-":"") + token.image);
        }
    if (jj_2_203(2)) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S_IDENTIFIER:{
        token = jj_consume_token(S_IDENTIFIER);
        break;
        }
      case K_DATE_LITERAL:{
        token = jj_consume_token(K_DATE_LITERAL);
        break;
        }
      default:
        jj_la1[350] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
interval.setIntervalType(token.image);
    } else {
      ;
    }
return interval;
}

  final public IntervalExpression IntervalExpressionWithoutInterval(Expression expr) throws ParseException {IntervalExpression interval;
    Token token;
    boolean signed = false;
interval = new IntervalExpression(false);
        interval.setExpression(expr);
    token = jj_consume_token(K_DATE_LITERAL);
interval.setIntervalType(token.image);
return interval;
}

  final public KeepExpression KeepExpression() throws ParseException {KeepExpression keep = new KeepExpression();
    Token token;
    List<OrderByElement> list;
    jj_consume_token(K_KEEP);
    jj_consume_token(325);
    token = jj_consume_token(S_IDENTIFIER);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_FIRST:{
      jj_consume_token(K_FIRST);
keep.setFirst(true);
      break;
      }
    case K_LAST:{
      jj_consume_token(K_LAST);
keep.setFirst(false);
      break;
      }
    default:
      jj_la1[351] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    list = OrderByElements();
    jj_consume_token(326);
keep.setName(token.image);
        keep.setOrderByElements(list);
        return keep;
}

  final public void windowFun(AnalyticExpression retval) throws ParseException {ExpressionList expressionList = null;
         List<OrderByElement> olist = null;
         WindowElement windowElement = null;
         boolean partitionByBrackets = false;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_IGNORE:
    case K_OVER:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_IGNORE:{
        jj_consume_token(K_IGNORE);
        jj_consume_token(K_NULLS);
retval.setIgnoreNullsOutside(true);
        break;
        }
      default:
        jj_la1[352] = jj_gen;
        ;
      }
      jj_consume_token(K_OVER);
retval.setType(AnalyticType.OVER);
      break;
      }
    case K_WITHIN:{
      jj_consume_token(K_WITHIN);
      jj_consume_token(K_GROUP);
retval.setType(AnalyticType.WITHIN_GROUP);
      break;
      }
    default:
      jj_la1[353] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(325);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_PARTITION:{
      jj_consume_token(K_PARTITION);
      jj_consume_token(K_BY);
      if (jj_2_204(2147483647)) {
        expressionList = ComplexExpressionList();
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 325:{
          jj_consume_token(325);
partitionByBrackets = true;
          expressionList = ComplexExpressionList();
          jj_consume_token(326);
          break;
          }
        default:
          jj_la1[354] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      break;
      }
    default:
      jj_la1[355] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ORDER:{
      olist = OrderByElements();
      break;
      }
    default:
      jj_la1[356] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_RANGE:
    case K_ROWS:{
      windowElement = WindowElement();
      break;
      }
    default:
      jj_la1[357] = jj_gen;
      ;
    }
retval.setPartitionExpressionList(expressionList, partitionByBrackets);
            retval.setOrderByElements(olist);
            retval.setWindowElement(windowElement);
    jj_consume_token(326);
}

  final public AnalyticExpression AnalyticExpression(Function function) throws ParseException {AnalyticExpression retval = new AnalyticExpression(function);
    Expression filter = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_FILTER:{
      jj_consume_token(K_FILTER);
      jj_consume_token(325);
      jj_consume_token(K_WHERE);
retval.setType(AnalyticType.FILTER_ONLY);
      filter = Expression();
      jj_consume_token(326);
      if (jj_2_205(2)) {
        windowFun(retval);
      } else {
        ;
      }
      break;
      }
    case K_IGNORE:
    case K_OVER:
    case K_WITHIN:{
      windowFun(retval);
      break;
      }
    default:
      jj_la1[358] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
retval.setFilterExpression(filter);
        return retval;
}

  final public WindowElement WindowElement() throws ParseException {WindowElement windowElement = new WindowElement();
    WindowRange range = new WindowRange();
    WindowOffset offset = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ROWS:{
      jj_consume_token(K_ROWS);
windowElement.setType(WindowElement.Type.ROWS);
      break;
      }
    case K_RANGE:{
      jj_consume_token(K_RANGE);
windowElement.setType(WindowElement.Type.RANGE);
      break;
      }
    default:
      jj_la1[359] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_BETWEEN:{
      jj_consume_token(K_BETWEEN);
windowElement.setRange(range);
      offset = WindowOffset();
range.setStart(offset);
      jj_consume_token(K_AND);
      offset = WindowOffset();
range.setEnd(offset);
      break;
      }
    default:
      jj_la1[360] = jj_gen;
      if (jj_2_206(1)) {
        offset = WindowOffset();
windowElement.setOffset(offset);
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
return windowElement;
}

  final public WindowOffset WindowOffset() throws ParseException {WindowOffset offset = new WindowOffset();
    Expression expr = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_UNBOUNDED:{
      jj_consume_token(K_UNBOUNDED);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_PRECEDING:{
        jj_consume_token(K_PRECEDING);
offset.setType(WindowOffset.Type.PRECEDING);
        break;
        }
      case K_FOLLOWING:{
        jj_consume_token(K_FOLLOWING);
offset.setType(WindowOffset.Type.FOLLOWING);
        break;
        }
      default:
        jj_la1[361] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[363] = jj_gen;
      if (jj_2_207(2)) {
        jj_consume_token(K_CURRENT);
        jj_consume_token(K_ROW);
offset.setType(WindowOffset.Type.CURRENT);
      } else if (jj_2_208(1)) {
        expr = SimpleExpression();
offset.setType(WindowOffset.Type.EXPR);
                        offset.setExpression(expr);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_PRECEDING:{
          jj_consume_token(K_PRECEDING);
offset.setType(WindowOffset.Type.PRECEDING);
          break;
          }
        case K_FOLLOWING:{
          jj_consume_token(K_FOLLOWING);
offset.setType(WindowOffset.Type.FOLLOWING);
          break;
          }
        default:
          jj_la1[362] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
return offset;
}

  final public ExtractExpression ExtractExpression() throws ParseException {ExtractExpression retval = new ExtractExpression();
    String token = null;
    Expression expr = null;
    jj_consume_token(K_EXTRACT);
    jj_consume_token(325);
    token = RelObjectName();
retval.setName(token);
    jj_consume_token(K_FROM);
    expr = SimpleExpression();
retval.setExpression(expr);
    jj_consume_token(326);
return retval;
}

  final public CastExpression CastExpression() throws ParseException {CastExpression retval = new CastExpression();
    ColDataType type = null;
    RowConstructor rowConstructor = null;
    Expression expression = null;
    boolean    useCastKeyword;
    jj_consume_token(K_CAST);
    jj_consume_token(325);
    expression = SimpleExpression();
    jj_consume_token(K_AS);
retval.setUseCastKeyword(true);
    if (jj_2_209(3)) {
      rowConstructor = RowConstructor();
retval.setRowConstructor(rowConstructor);
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_BINARY:
      case K_BIT:
      case K_CHARACTER:
      case K_CHAR:
      case K_DATETIMELITERAL:
      case K_DATE_LITERAL:
      case K_DOUBLE:
      case K_INTERVAL:
      case K_JSON:
      case K_SET:
      case K_SIGNED:
      case K_UNSIGNED:
      case K_XML:
      case DT_ZONE:
      case S_IDENTIFIER:
      case S_QUOTED_IDENTIFIER:{
        type = ColDataType();
retval.setType(type);
        break;
        }
      default:
        jj_la1[364] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    jj_consume_token(326);
retval.setLeftExpression(expression);
        return retval;
}

  final public TryCastExpression TryCastExpression() throws ParseException {TryCastExpression retval = new TryCastExpression();
    ColDataType type = null;
    RowConstructor rowConstructor = null;
    Expression expression = null;
    boolean    useCastKeyword;
    jj_consume_token(K_TRY_CAST);
    jj_consume_token(325);
    expression = SimpleExpression();
    jj_consume_token(K_AS);
retval.setUseCastKeyword(true);
    if (jj_2_210(3)) {
      rowConstructor = RowConstructor();
retval.setRowConstructor(rowConstructor);
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_BINARY:
      case K_BIT:
      case K_CHARACTER:
      case K_CHAR:
      case K_DATETIMELITERAL:
      case K_DATE_LITERAL:
      case K_DOUBLE:
      case K_INTERVAL:
      case K_JSON:
      case K_SET:
      case K_SIGNED:
      case K_UNSIGNED:
      case K_XML:
      case DT_ZONE:
      case S_IDENTIFIER:
      case S_QUOTED_IDENTIFIER:{
        type = ColDataType();
retval.setType(type);
        break;
        }
      default:
        jj_la1[365] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    jj_consume_token(326);
retval.setLeftExpression(expression);
        return retval;
}

  final public Expression CaseWhenExpression() throws ParseException {/*@bgen(jjtree) CaseWhenExpression */
    SimpleNode jjtn000 = new SimpleNode(JJTCASEWHENEXPRESSION);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));CaseExpression caseExp = new CaseExpression();
    Expression switchExp = null;
    WhenClause clause;
    List<WhenClause> whenClauses = new ArrayList<WhenClause>();
    Expression elseExp = null;
    try {
      jj_consume_token(K_CASE);
caseCounter++;
      if (jj_2_211(1)) {
        switchExp = Expression();
      } else {
        ;
      }
      label_83:
      while (true) {
        clause = WhenThenSearchCondition();
whenClauses.add(clause);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_WHEN:{
          ;
          break;
          }
        default:
          jj_la1[366] = jj_gen;
          break label_83;
        }
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ELSE:{
        jj_consume_token(K_ELSE);
        if (jj_2_212(2147483647)) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case 325:{
            jj_consume_token(325);
            break;
            }
          default:
            jj_la1[367] = jj_gen;
            ;
          }
          elseExp = CaseWhenExpression();
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case 326:{
            jj_consume_token(326);
((CaseExpression) elseExp).setUsingBrackets(true);
            break;
            }
          default:
            jj_la1[368] = jj_gen;
            ;
          }
        } else if (jj_2_213(1)) {
          elseExp = Expression();
        } else {
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[369] = jj_gen;
        ;
      }
      jj_consume_token(K_END);
caseCounter--;
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
caseExp.setSwitchExpression(switchExp);
        caseExp.setWhenClauses(whenClauses);
        caseExp.setElseExpression(elseExp);
        return caseExp;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return com.javaoffers.thrid.sqlparse.statement in function");
}

  final public WhenClause WhenThenSearchCondition() throws ParseException {WhenClause whenThen = new WhenClause();
    Expression whenExp = null;
    Expression thenExp = null;
    jj_consume_token(K_WHEN);
    whenExp = Expression();
    jj_consume_token(K_THEN);
    if (jj_2_214(2147483647)) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 325:{
        jj_consume_token(325);
        break;
        }
      default:
        jj_la1[370] = jj_gen;
        ;
      }
      thenExp = CaseWhenExpression();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 326:{
        jj_consume_token(326);
((CaseExpression) thenExp).setUsingBrackets(true);
        break;
        }
      default:
        jj_la1[371] = jj_gen;
        ;
      }
    } else if (jj_2_215(1)) {
      thenExp = Expression();
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
whenThen.setWhenExpression(whenExp);
       whenThen.setThenExpression(thenExp);
       return whenThen;
}

  final public RowConstructor RowConstructor() throws ParseException {RowConstructor rowConstructor = new RowConstructor();
    ColumnDefinition columnDefinition = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ROW:{
      jj_consume_token(K_ROW);
rowConstructor.setName("ROW");
      break;
      }
    default:
      jj_la1[372] = jj_gen;
      ;
    }
    jj_consume_token(325);
    columnDefinition = ColumnDefinition();
rowConstructor.addColumnDefinition(columnDefinition);
    label_84:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COMMA:{
        ;
        break;
        }
      default:
        jj_la1[373] = jj_gen;
        break label_84;
      }
      jj_consume_token(K_COMMA);
      columnDefinition = ColumnDefinition();
rowConstructor.addColumnDefinition(columnDefinition);
    }
    jj_consume_token(326);
return rowConstructor;
}

/**
TODO: VariableExpression should be a standalone class with more operations available. 
*/
  final public EqualsTo VariableExpression() throws ParseException {Expression left;
    Expression right;
    left = UserVariable();
    jj_consume_token(327);
    right = SimpleExpression();
EqualsTo equals = new EqualsTo();
        equals.setLeftExpression(left);
        equals.setRightExpression(right);
        return equals;
}

  final public Execute Execute() throws ParseException {List<String> funcName;
    ExpressionList expressionList = null;
    Execute execute = new Execute();
    List<Expression> namedExprList;
    Expression expr;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_EXEC:{
      jj_consume_token(K_EXEC);
execute.setExecType(Execute.ExecType.EXEC);
      break;
      }
    case K_EXECUTE:{
      jj_consume_token(K_EXECUTE);
execute.setExecType(Execute.ExecType.EXECUTE);
      break;
      }
    case K_CALL:{
      jj_consume_token(K_CALL);
execute.setExecType(Execute.ExecType.CALL);
      break;
      }
    default:
      jj_la1[374] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    funcName = RelObjectNameList();
execute.setName(funcName);
    if (jj_2_218(1)) {
      if (jj_2_216(3)) {
        expr = VariableExpression();
namedExprList = new ArrayList<Expression>(); namedExprList.add( expr );
        label_85:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_COMMA:{
            ;
            break;
            }
          default:
            jj_la1[375] = jj_gen;
            break label_85;
          }
          jj_consume_token(K_COMMA);
          expr = VariableExpression();
namedExprList.add(expr);
        }
expressionList = new ExpressionList(namedExprList);
      } else if (jj_2_217(3)) {
        expressionList = SimpleExpressionList(true);
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 325:{
          jj_consume_token(325);
          expressionList = SimpleExpressionList(true);
          jj_consume_token(326);
execute.setParenthesis(true);
          break;
          }
        default:
          jj_la1[376] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    } else {
      ;
    }
execute.setExprList(expressionList);
        return execute;
}

  final public FullTextSearch FullTextSearch() throws ParseException {Column col;
    Token searchModifier;
    Token againstValue;
    JdbcParameter jdbcParameter;
    JdbcNamedParameter jdbcNamedParameter;
    FullTextSearch fs = new FullTextSearch();
    List<Column> matchedColumns = new ArrayList<Column>();
    List<Expression> expList = new ArrayList<Expression>();
    jj_consume_token(K_MATCH);
    jj_consume_token(325);
    col = Column();
matchedColumns.add(col);
    label_86:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COMMA:{
        ;
        break;
        }
      default:
        jj_la1[377] = jj_gen;
        break label_86;
      }
      jj_consume_token(K_COMMA);
      col = Column();
matchedColumns.add(col);
    }
    jj_consume_token(326);
    jj_consume_token(K_AGAINST);
    jj_consume_token(325);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case S_CHAR_LITERAL:{
      againstValue = jj_consume_token(S_CHAR_LITERAL);
fs.setAgainstValue(new StringValue(againstValue.image));
      break;
      }
    case 331:{
      jdbcParameter = SimpleJdbcParameter();
fs.setAgainstValue(  jdbcParameter );
      break;
      }
    case 330:{
      jdbcNamedParameter = SimpleJdbcNamedParameter();
fs.setAgainstValue(  jdbcNamedParameter );
      break;
      }
    default:
      jj_la1[378] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case 369:
    case 370:
    case 371:
    case 372:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 369:{
        searchModifier = jj_consume_token(369);
        break;
        }
      case 370:{
        searchModifier = jj_consume_token(370);
        break;
        }
      case 371:{
        searchModifier = jj_consume_token(371);
        break;
        }
      case 372:{
        searchModifier = jj_consume_token(372);
        break;
        }
      default:
        jj_la1[379] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
fs.setSearchModifier(searchModifier.image);
      break;
      }
    default:
      jj_la1[380] = jj_gen;
      ;
    }
    jj_consume_token(326);
fs.setMatchColumns(matchedColumns);
        return fs;
}

/* Function FunctionWithCondParams() #Function: {
    Function retval = new Function();
    String funcName = null;
    ExpressionList expressionList = null;
    Token token = null;
}
{
    (token = <K_IF> | token = <K_IIF> | token = <K_CASEWHEN> ) { funcName=token.image; }

    "("
        expressionList=ComplexExpressionList()
	")"

    {
        retval.setParameters(expressionList);
        retval.setName(funcName);
        linkAST(retval,jjtThis);
        return retval;
    }
} */
  final public 

Function Function() throws ParseException {/*@bgen(jjtree) Function */
    SimpleNode jjtn000 = new SimpleNode(JJTFUNCTION);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));Function retval = new Function();
    try {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 373:{
        jj_consume_token(373);
        jj_consume_token(K_FN);
retval.setEscaped(true);
        InternalFunction(retval);
        jj_consume_token(360);
        break;
        }
      default:
        jj_la1[381] = jj_gen;
        if (jj_2_219(3)) {
          retval = SpecialStringFunctionWithNamedParameters();
        } else {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_ACTION:
          case K_ACTIVE:
          case K_ALGORITHM:
          case K_ALL:
          case K_ANY:
          case K_ARCHIVE:
          case K_ARRAY_LITERAL:
          case K_AT:
          case K_BYTE:
          case K_CASCADE:
          case K_CASE:
          case K_CASEWHEN:
          case K_CAST:
          case K_TRY_CAST:
          case K_CHARACTER:
          case K_CHANGE:
          case K_CHECKPOINT:
          case K_CHAR:
          case K_COLUMN:
          case K_COLUMNS:
          case K_COMMIT:
          case K_COMMENT:
          case K_COSTS:
          case K_CREATE:
          case K_CYCLE:
          case K_DATETIMELITERAL:
          case K_DATE_LITERAL:
          case K_DBA_RECYCLEBIN:
          case K_DEFAULT:
          case K_DESC:
          case K_DESCRIBE:
          case K_DISABLE:
          case K_DISCONNECT:
          case K_DIV:
          case K_DO:
          case K_DOUBLE:
          case K_DUMP:
          case K_DUPLICATE:
          case K_ENABLE:
          case K_END:
          case K_EXCLUDE:
          case K_EXTRACT:
          case K_FILTER:
          case K_FIRST:
          case K_FALSE:
          case K_FLUSH:
          case K_FOLLOWING:
          case K_FORMAT:
          case K_FULLTEXT:
          case K_GROUP:
          case K_GROUPING:
          case K_HISTORY:
          case K_IF:
          case K_IIF:
          case K_IN:
          case K_INDEX:
          case K_INSERT:
          case K_INTERVAL:
          case K_ISNULL:
          case K_JSON:
          case K_KEY:
          case K_FN:
          case K_LAST:
          case K_LEADING:
          case K_LEFT:
          case K_LIMIT:
          case K_LOCAL:
          case K_LINK:
          case K_LOG:
          case K_MATERIALIZED:
          case K_NEXTVAL:
          case K_NO:
          case K_NOLOCK:
          case K_NULLS:
          case K_OF:
          case K_OFFSET:
          case K_ON:
          case K_OPEN:
          case K_ORDER:
          case K_OVER:
          case K_OPTIMIZE:
          case K_PARALLEL:
          case K_PARTITION:
          case K_PATH:
          case K_PERCENT:
          case K_PRECISION:
          case K_PRIMARY:
          case K_PRIOR:
          case K_PROCEDURE:
          case K_PUBLIC:
          case K_QUERY:
          case K_QUIESCE:
          case K_RANGE:
          case K_READ:
          case K_RECYCLEBIN:
          case K_REGISTER:
          case K_REPLACE:
          case K_RESUME:
          case K_RESTRICTED:
          case K_RIGHT:
          case K_ROW:
          case K_ROWS:
          case K_SCHEMA:
          case K_SEQUENCE:
          case K_SEPARATOR:
          case K_SESSION:
          case K_SET:
          case K_SHUTDOWN:
          case K_SIBLINGS:
          case K_SIZE:
          case K_SKIP:
          case K_SOME:
          case K_START:
          case K_SUSPEND:
          case K_SWITCH:
          case K_SYNONYM:
          case K_SYSTEM:
          case K_TABLE:
          case K_TABLES:
          case K_TABLESPACE:
          case K_TEMP:
          case K_TEMPORARY:
          case K_TIMEOUT:
          case K_TO:
          case K_TOP:
          case K_TRUNCATE:
          case K_TRUE:
          case K_TYPE:
          case K_UNQIESCE:
          case K_USER:
          case K_SIGNED:
          case K_STRING_FUNCTION_NAME:
          case K_UNSIGNED:
          case K_VALIDATE:
          case K_VALUE:
          case K_VALUES:
          case K_VIEW:
          case K_XML:
          case K_ZONE:
          case S_IDENTIFIER:
          case S_QUOTED_IDENTIFIER:{
            InternalFunction(retval);
            break;
            }
          default:
            jj_la1[382] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
      }
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
linkAST(retval,jjtn000);
        return retval;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return com.javaoffers.thrid.sqlparse.statement in function");
}

  final public Function SpecialStringFunctionWithNamedParameters() throws ParseException {Token funcName;
    NamedExpressionList namedExpressionList = null;
    ExpressionList expressionList = null;
    List<OrderByElement> orderByList;
    funcName = jj_consume_token(K_STRING_FUNCTION_NAME);
    jj_consume_token(325);
    if (jj_2_220(2147483647)) {
      namedExpressionList = NamedExpressionList1();
    } else if (jj_2_221(2147483647) && (getAsBoolean(Feature.allowComplexParsing))) {
      namedExpressionList = NamedExpressionListExprFirst();
    } else if (jj_2_222(3) && (getAsBoolean(Feature.allowComplexParsing))) {
      expressionList = ComplexExpressionList();
expressionList.setUsingBrackets(false);
    } else if (jj_2_223(3)) {
      expressionList = SimpleExpressionList(false);
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(326);
return new Function().withName(funcName.image).withNamedParameters(namedExpressionList).withParameters(expressionList);
}

  final public Function InternalFunction(Function retval) throws ParseException {List<String> funcName;
    String tmp = null;
    List<Expression> expressions = new ArrayList<Expression>();
    ExpressionList expressionList = null;
    NamedExpressionList namedExpressionList = null;
    KeepExpression keep = null;
    SubSelect expr = null;
    Token tk1 = null;
    Token tk2 = null;
    Expression expr1 = null;
    List<OrderByElement> orderByList;
    boolean ignoreNulls = false;
    funcName = RelObjectNameList();
    jj_consume_token(325);
    if (jj_2_229(1)) {
      if (jj_2_224(2)) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_DISTINCT:{
          jj_consume_token(K_DISTINCT);
retval.setDistinct(true);
          break;
          }
        case K_ALL:{
          jj_consume_token(K_ALL);
retval.setAllColumns(true);
          break;
          }
        case K_UNIQUE:{
          jj_consume_token(K_UNIQUE);
retval.setUnique(true);
          break;
          }
        default:
          jj_la1[383] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      } else {
        ;
      }
      if (jj_2_225(4)) {
        jj_consume_token(328);
expr1 = new AllColumns(); expressionList = new ExpressionList(expr1).withUsingBrackets(false);
      } else if (jj_2_226(2147483647)) {
        expr1 = AllTableColumns();
expressionList = new ExpressionList(expr1).withUsingBrackets(false);
      } else if (jj_2_227(3) && (getAsBoolean(Feature.allowComplexParsing))) {
        expressionList = ComplexExpressionList();
expressionList.setUsingBrackets(false);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_ORDER:{
          orderByList = OrderByElements();
retval.setOrderByElements(orderByList);
          break;
          }
        default:
          jj_la1[384] = jj_gen;
          ;
        }
      } else if (jj_2_228(3)) {
        expressionList = SimpleExpressionList(false);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_ORDER:{
          orderByList = OrderByElements();
retval.setOrderByElements(orderByList);
          break;
          }
        default:
          jj_la1[385] = jj_gen;
          ;
        }
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_SELECT:
        case K_VALUES:
        case K_WITH:
        case 325:{
          expr = SubSelect();
expr.setUseBrackets(false); expressionList = new ExpressionList(expr).withUsingBrackets(false);
          break;
          }
        default:
          jj_la1[386] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    } else {
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_IGNORE:{
      jj_consume_token(K_IGNORE);
      jj_consume_token(K_NULLS);
retval.setIgnoreNulls(true);
      break;
      }
    default:
      jj_la1[387] = jj_gen;
      ;
    }
    jj_consume_token(326);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case 329:{
      jj_consume_token(329);
      if (jj_2_230(2)) {
        expr1 = Function();
retval.setAttribute(expr1);
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_ACTION:
        case K_ACTIVE:
        case K_ALGORITHM:
        case K_ARCHIVE:
        case K_ARRAY_LITERAL:
        case K_AT:
        case K_BYTE:
        case K_CASCADE:
        case K_CASE:
        case K_CAST:
        case K_TRY_CAST:
        case K_CHARACTER:
        case K_CHANGE:
        case K_CHECKPOINT:
        case K_CHAR:
        case K_COLUMN:
        case K_COLUMNS:
        case K_COMMIT:
        case K_COMMENT:
        case K_COSTS:
        case K_CREATE:
        case K_CYCLE:
        case K_DATETIMELITERAL:
        case K_DATE_LITERAL:
        case K_DBA_RECYCLEBIN:
        case K_DEFAULT:
        case K_DESC:
        case K_DESCRIBE:
        case K_DISABLE:
        case K_DISCONNECT:
        case K_DIV:
        case K_DO:
        case K_DUMP:
        case K_DUPLICATE:
        case K_ENABLE:
        case K_END:
        case K_EXCLUDE:
        case K_EXTRACT:
        case K_FILTER:
        case K_FIRST:
        case K_FALSE:
        case K_FLUSH:
        case K_FOLLOWING:
        case K_FORMAT:
        case K_FULLTEXT:
        case K_GROUP:
        case K_HISTORY:
        case K_INDEX:
        case K_INSERT:
        case K_INTERVAL:
        case K_ISNULL:
        case K_JSON:
        case K_KEY:
        case K_FN:
        case K_LAST:
        case K_LEADING:
        case K_LOCAL:
        case K_LINK:
        case K_LOG:
        case K_MATERIALIZED:
        case K_NEXTVAL:
        case K_NO:
        case K_NOLOCK:
        case K_NULLS:
        case K_OF:
        case K_ON:
        case K_OPEN:
        case K_ORDER:
        case K_OVER:
        case K_PARALLEL:
        case K_PARTITION:
        case K_PATH:
        case K_PERCENT:
        case K_PRECISION:
        case K_PRIMARY:
        case K_PRIOR:
        case K_QUERY:
        case K_QUIESCE:
        case K_RANGE:
        case K_READ:
        case K_RECYCLEBIN:
        case K_REGISTER:
        case K_REPLACE:
        case K_RESUME:
        case K_RESTRICTED:
        case K_ROW:
        case K_ROWS:
        case K_SCHEMA:
        case K_SEQUENCE:
        case K_SEPARATOR:
        case K_SESSION:
        case K_SHUTDOWN:
        case K_SIBLINGS:
        case K_SIZE:
        case K_SKIP:
        case K_START:
        case K_SUSPEND:
        case K_SWITCH:
        case K_SYNONYM:
        case K_SYSTEM:
        case K_TABLE:
        case K_TABLES:
        case K_TABLESPACE:
        case K_TEMP:
        case K_TEMPORARY:
        case K_TIMEOUT:
        case K_TO:
        case K_TOP:
        case K_TRUNCATE:
        case K_TRUE:
        case K_TYPE:
        case K_UNQIESCE:
        case K_USER:
        case K_SIGNED:
        case K_STRING_FUNCTION_NAME:
        case K_UNSIGNED:
        case K_VALIDATE:
        case K_VALUE:
        case K_VALUES:
        case K_VIEW:
        case K_XML:
        case K_ZONE:
        case S_IDENTIFIER:
        case S_QUOTED_IDENTIFIER:{
          tmp = RelObjectName();
retval.setAttributeName(tmp);
          break;
          }
        default:
          jj_la1[388] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      break;
      }
    default:
      jj_la1[389] = jj_gen;
      ;
    }
    if (jj_2_231(2)) {
      keep = KeepExpression();
    } else {
      ;
    }
retval.setParameters(expressionList);
        retval.setName(funcName);
        retval.setKeep(keep);
        return retval;
}

  final public XMLSerializeExpr XMLSerializeExpr() throws ParseException {XMLSerializeExpr result;
   Expression expression;
   List<OrderByElement> orderByElements = null;
   ColDataType dataType;
    jj_consume_token(K_XMLSERIALIZE);
    jj_consume_token(325);
    jj_consume_token(K_XMLAGG);
    jj_consume_token(325);
    jj_consume_token(K_XMLTEXT);
    jj_consume_token(325);
    expression = SimpleExpression();
    jj_consume_token(326);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ORDER:{
      orderByElements = OrderByElements();
      break;
      }
    default:
      jj_la1[390] = jj_gen;
      ;
    }
    jj_consume_token(326);
    jj_consume_token(K_AS);
    dataType = ColDataType();
    jj_consume_token(326);
result = new XMLSerializeExpr();
        result.setExpression(expression);
        result.setOrderByElements(orderByElements);
        result.setDataType(dataType);
        return result;
}

  final public MySQLGroupConcat MySQLGroupConcat() throws ParseException {MySQLGroupConcat retval = new MySQLGroupConcat();
    ExpressionList expressionList = null;
    List<OrderByElement> orderByList = null;
    Token t;
    jj_consume_token(K_GROUP_CONCAT);
    jj_consume_token(325);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_DISTINCT:{
      jj_consume_token(K_DISTINCT);
retval.setDistinct(true);
      break;
      }
    default:
      jj_la1[391] = jj_gen;
      ;
    }
    expressionList = SimpleExpressionList(true);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ORDER:{
      orderByList = OrderByElements();
retval.setOrderByElements(orderByList);
      break;
      }
    default:
      jj_la1[392] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_SEPARATOR:{
      jj_consume_token(K_SEPARATOR);
      t = jj_consume_token(S_CHAR_LITERAL);
retval.setSeparator(t.image);
      break;
      }
    default:
      jj_la1[393] = jj_gen;
      ;
    }
    jj_consume_token(326);
retval.setExpressionList(expressionList);
        return retval;
}

  final public ValueListExpression ValueListExpression() throws ParseException {ValueListExpression retval = new ValueListExpression();
    ExpressionList expressionList = null;
    jj_consume_token(325);
    expressionList = SimpleExpressionListAtLeastTwoItems();
    jj_consume_token(326);
retval.setExpressionList(expressionList);
        return retval;
}

  final public TableFunction TableFunction() throws ParseException {Alias alias = null;
    Function function;
    TableFunction functionItem;
    function = Function();
functionItem = new TableFunction().withFunction(function);
    if (jj_2_232(2)) {
      alias = Alias();
functionItem.setAlias(alias);
    } else {
      ;
    }
return functionItem;
}

  final public SubSelect SubSelect() throws ParseException {/*@bgen(jjtree) SubSelect */
    SimpleNode jjtn000 = new SimpleNode(JJTSUBSELECT);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));SelectBody selectBody = null;
    SubSelect subSelect = new SubSelect();
    List<WithItem> with = null;
    try {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_WITH:{
        with = WithList();
subSelect.setWithItemsList(with);
        break;
        }
      default:
        jj_la1[394] = jj_gen;
        ;
      }
      selectBody = SelectBody();
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
subSelect.setSelectBody(selectBody);
        linkAST(subSelect,jjtn000);
        return subSelect;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return com.javaoffers.thrid.sqlparse.statement in function");
}

  final public List<Index.ColumnParams> ColumnNamesWithParamsList() throws ParseException {List<Index.ColumnParams> colNames = new ArrayList<Index.ColumnParams>();
    String columnName;
    List<String> parameter = null;
    jj_consume_token(325);
    columnName = RelObjectName();
parameter = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ARRAY_LITERAL:
    case K_AS:
    case K_ASC:
    case K_BY:
    case K_CASCADE:
    case K_CHECK:
    case K_COLLATE:
    case K_COMMIT:
    case K_COMMENT:
    case K_CONSTRAINT:
    case K_DEFAULT:
    case K_DELETE:
    case K_DESC:
    case K_DROP:
    case K_EXCLUDE:
    case K_FALSE:
    case K_FOREIGN:
    case K_IN:
    case K_KEY:
    case K_NOT:
    case K_NULL:
    case K_ON:
    case K_PARALLEL:
    case K_PARTITION:
    case K_PRIMARY:
    case K_REFERENCES:
    case K_ROWS:
    case K_TABLESPACE:
    case K_TEMP:
    case K_TEMPORARY:
    case K_TIME_KEY_EXPR:
    case K_TRUE:
    case K_TYPE:
    case K_UNIQUE:
    case K_UPDATE:
    case K_USING:
    case K_UNSIGNED:
    case K_WHERE:
    case K_WITH:
    case S_DOUBLE:
    case S_LONG:
    case S_IDENTIFIER:
    case S_CHAR_LITERAL:
    case S_QUOTED_IDENTIFIER:
    case 325:
    case 327:
    case 333:
    case 345:
    case 363:{
      parameter = CreateParameter();
      break;
      }
    default:
      jj_la1[395] = jj_gen;
      ;
    }
colNames.add(new Index.ColumnParams(columnName,parameter));
    label_87:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COMMA:{
        ;
        break;
        }
      default:
        jj_la1[396] = jj_gen;
        break label_87;
      }
      jj_consume_token(K_COMMA);
      columnName = RelObjectName();
parameter = null;
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ARRAY_LITERAL:
      case K_AS:
      case K_ASC:
      case K_BY:
      case K_CASCADE:
      case K_CHECK:
      case K_COLLATE:
      case K_COMMIT:
      case K_COMMENT:
      case K_CONSTRAINT:
      case K_DEFAULT:
      case K_DELETE:
      case K_DESC:
      case K_DROP:
      case K_EXCLUDE:
      case K_FALSE:
      case K_FOREIGN:
      case K_IN:
      case K_KEY:
      case K_NOT:
      case K_NULL:
      case K_ON:
      case K_PARALLEL:
      case K_PARTITION:
      case K_PRIMARY:
      case K_REFERENCES:
      case K_ROWS:
      case K_TABLESPACE:
      case K_TEMP:
      case K_TEMPORARY:
      case K_TIME_KEY_EXPR:
      case K_TRUE:
      case K_TYPE:
      case K_UNIQUE:
      case K_UPDATE:
      case K_USING:
      case K_UNSIGNED:
      case K_WHERE:
      case K_WITH:
      case S_DOUBLE:
      case S_LONG:
      case S_IDENTIFIER:
      case S_CHAR_LITERAL:
      case S_QUOTED_IDENTIFIER:
      case 325:
      case 327:
      case 333:
      case 345:
      case 363:{
        parameter = CreateParameter();
        break;
        }
      default:
        jj_la1[397] = jj_gen;
        ;
      }
colNames.add(new Index.ColumnParams(columnName,parameter));
    }
    jj_consume_token(326);
return colNames;
}

  final public Index Index() throws ParseException {List<String> name;
    name = RelObjectNameList();
return new Index().withName(name).withType("");
}

  final public CreateIndex CreateIndex() throws ParseException {CreateIndex createIndex = new CreateIndex();
    Table table = null;
    List<Index.ColumnParams> colNames;
    //Token columnName;
    Token using;
    Index index = null;
    //String name = null;
    List<String> parameter = new ArrayList<String>();
    List<String> tailParameters = new ArrayList<String>();
    List<String> name;
    jj_consume_token(K_CREATE);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ARRAY_LITERAL:
    case K_AS:
    case K_ASC:
    case K_BY:
    case K_CASCADE:
    case K_CHECK:
    case K_COLLATE:
    case K_COMMIT:
    case K_COMMENT:
    case K_CONSTRAINT:
    case K_DEFAULT:
    case K_DELETE:
    case K_DESC:
    case K_DROP:
    case K_EXCLUDE:
    case K_FALSE:
    case K_FOREIGN:
    case K_IN:
    case K_KEY:
    case K_NOT:
    case K_NULL:
    case K_ON:
    case K_PARALLEL:
    case K_PARTITION:
    case K_PRIMARY:
    case K_REFERENCES:
    case K_ROWS:
    case K_TABLESPACE:
    case K_TEMP:
    case K_TEMPORARY:
    case K_TIME_KEY_EXPR:
    case K_TRUE:
    case K_TYPE:
    case K_UNIQUE:
    case K_UPDATE:
    case K_USING:
    case K_UNSIGNED:
    case K_WHERE:
    case K_WITH:
    case S_DOUBLE:
    case S_LONG:
    case S_IDENTIFIER:
    case S_CHAR_LITERAL:
    case S_QUOTED_IDENTIFIER:
    case 325:
    case 327:
    case 333:
    case 345:
    case 363:{
      parameter = CreateParameter();
      break;
      }
    default:
      jj_la1[398] = jj_gen;
      ;
    }
    jj_consume_token(K_INDEX);
    index = Index();
index.setType(parameter.isEmpty()?null:parameter.get(0));
    jj_consume_token(K_ON);
    table = Table();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_USING:{
      jj_consume_token(K_USING);
      using = jj_consume_token(S_IDENTIFIER);
index.setUsing(using.image);
      break;
      }
    default:
      jj_la1[399] = jj_gen;
      ;
    }
    colNames = ColumnNamesWithParamsList();
    label_88:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ARRAY_LITERAL:
      case K_AS:
      case K_ASC:
      case K_BY:
      case K_CASCADE:
      case K_CHECK:
      case K_COLLATE:
      case K_COMMIT:
      case K_COMMENT:
      case K_CONSTRAINT:
      case K_DEFAULT:
      case K_DELETE:
      case K_DESC:
      case K_DROP:
      case K_EXCLUDE:
      case K_FALSE:
      case K_FOREIGN:
      case K_IN:
      case K_KEY:
      case K_NOT:
      case K_NULL:
      case K_ON:
      case K_PARALLEL:
      case K_PARTITION:
      case K_PRIMARY:
      case K_REFERENCES:
      case K_ROWS:
      case K_TABLESPACE:
      case K_TEMP:
      case K_TEMPORARY:
      case K_TIME_KEY_EXPR:
      case K_TRUE:
      case K_TYPE:
      case K_UNIQUE:
      case K_UPDATE:
      case K_USING:
      case K_UNSIGNED:
      case K_WHERE:
      case K_WITH:
      case S_DOUBLE:
      case S_LONG:
      case S_IDENTIFIER:
      case S_CHAR_LITERAL:
      case S_QUOTED_IDENTIFIER:
      case 325:
      case 327:
      case 333:
      case 345:
      case 363:{
        ;
        break;
        }
      default:
        jj_la1[400] = jj_gen;
        break label_88;
      }
      parameter = CreateParameter();
tailParameters.addAll(parameter);
    }
index.setColumns(colNames);
        createIndex.setIndex(index);
        createIndex.setTable(table);
        createIndex.setTailParameters(tailParameters);
        return createIndex;
}

  final public ColumnDefinition ColumnDefinition() throws ParseException {ColumnDefinition coldef;
    String columnName;
    ColDataType colDataType;
    List<String> columnSpecs = new ArrayList<String>();
    List<String> parameter;
    columnName = RelObjectName();
    colDataType = ColDataType();
    label_89:
    while (true) {
      if (jj_2_233(2)) {
        ;
      } else {
        break label_89;
      }
      parameter = CreateParameter();
columnSpecs.addAll(parameter);
    }
coldef = new ColumnDefinition();
        coldef.setColumnName(columnName);
        coldef.setColDataType(colDataType);
        if (columnSpecs.size() > 0)
            coldef.setColumnSpecs(columnSpecs);
        return coldef;
}

  final public CreateSchema CreateSchema() throws ParseException {Token tk = null;
    CreateTable table = null;
    CreateView view = null;
    CreateSchema schema = new CreateSchema();
    //com.javaoffers.thrid.sqlparse.schema.setSchemaName(System.getProperty("user.name"));
    //com.javaoffers.thrid.sqlparse.schema.setAuthorization(System.getProperty("user.name"));
    List<String> schemaPath = null;
    List<Statement> statements = new ArrayList<Statement>();
    jj_consume_token(K_CREATE);
    jj_consume_token(K_SCHEMA);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case S_IDENTIFIER:
    case S_QUOTED_IDENTIFIER:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S_IDENTIFIER:{
        tk = jj_consume_token(S_IDENTIFIER);
        break;
        }
      case S_QUOTED_IDENTIFIER:{
        tk = jj_consume_token(S_QUOTED_IDENTIFIER);
        break;
        }
      default:
        jj_la1[401] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
schema.setSchemaName(tk.image);
      break;
      }
    default:
      jj_la1[402] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_AUTHORIZATION:{
      jj_consume_token(K_AUTHORIZATION);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S_IDENTIFIER:{
        tk = jj_consume_token(S_IDENTIFIER);
        break;
        }
      case S_QUOTED_IDENTIFIER:{
        tk = jj_consume_token(S_QUOTED_IDENTIFIER);
        break;
        }
      default:
        jj_la1[403] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
schema.setAuthorization(tk.image);
      break;
      }
    default:
      jj_la1[404] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_PATH:{
      schemaPath = PathSpecification();
schema.setSchemaPath(schemaPath);
      break;
      }
    default:
      jj_la1[405] = jj_gen;
      ;
    }
    label_90:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_CREATE:{
        ;
        break;
        }
      default:
        jj_la1[406] = jj_gen;
        break label_90;
      }
      if (jj_2_234(3)) {
        table = CreateTable();
table.getTable().setSchemaName(schema.getSchemaName());
            schema.addStatement(table);
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_CREATE:{
          view = CreateView();
view.getView().setSchemaName(schema.getSchemaName());
            schema.addStatement(view);
          break;
          }
        default:
          jj_la1[407] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
return schema;
}

  final public List<String> PathSpecification() throws ParseException {Token tk;
    List<String> pathList = new ArrayList<String>();
    jj_consume_token(K_PATH);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case S_IDENTIFIER:{
      tk = jj_consume_token(S_IDENTIFIER);
      break;
      }
    case S_QUOTED_IDENTIFIER:{
      tk = jj_consume_token(S_QUOTED_IDENTIFIER);
      break;
      }
    default:
      jj_la1[408] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
pathList.add(tk.image);
    label_91:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COMMA:{
        ;
        break;
        }
      default:
        jj_la1[409] = jj_gen;
        break label_91;
      }
      jj_consume_token(K_COMMA);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S_IDENTIFIER:{
        tk = jj_consume_token(S_IDENTIFIER);
        break;
        }
      case S_QUOTED_IDENTIFIER:{
        tk = jj_consume_token(S_QUOTED_IDENTIFIER);
        break;
        }
      default:
        jj_la1[410] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
pathList.add(tk.image);
    }
return pathList;
}

  final public CreateTable CreateTable() throws ParseException {CreateTable createTable = new CreateTable();
    Table table = null;
    List<ColumnDefinition> columnDefinitions = new ArrayList<ColumnDefinition>();
    List<String> columnSpecs = null;
    List<String> tableOptions = new ArrayList<String>();
    List<String> createOptions = new ArrayList<String>();
    String columnName;
    Token tk = null;
    Token tk2 = null;
    Token tk3 = null;
    String sk3 = null;
    ColDataType colDataType = null;
    String stringList = null;
    ColumnDefinition coldef = null;
    List<Index> indexes = new ArrayList<Index>();
    List<Index.ColumnParams> colNames = null;
    List<String> colNames2 = null;
    Index index = null;
    ForeignKeyIndex fkIndex = null;
    List<String> parameter = new ArrayList<String>();
    List<String> idxSpec = new ArrayList<String>();
    Table fkTable = null;
    Select select = null;
    Table likeTable = null;
    CheckConstraint checkCs = null;
    ExcludeConstraint excludeC = null;
    RowMovement rowMovement = null;
    ReferentialAction.Action action = null;
    String tableColumn = null;
    List<String> columns = new ArrayList<String>();
    jj_consume_token(K_CREATE);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_OR:{
      jj_consume_token(K_OR);
      jj_consume_token(K_REPLACE);
createTable.setOrReplace(true);
      break;
      }
    default:
      jj_la1[411] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_UNLOGGED:{
      jj_consume_token(K_UNLOGGED);
createTable.setUnlogged(true);
      break;
      }
    default:
      jj_la1[412] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_GLOBAL:{
      tk = jj_consume_token(K_GLOBAL);
createOptions.add(tk.image);
      break;
      }
    default:
      jj_la1[413] = jj_gen;
      ;
    }
    label_92:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ARRAY_LITERAL:
      case K_AS:
      case K_ASC:
      case K_BY:
      case K_CASCADE:
      case K_CHECK:
      case K_COLLATE:
      case K_COMMIT:
      case K_COMMENT:
      case K_CONSTRAINT:
      case K_DEFAULT:
      case K_DELETE:
      case K_DESC:
      case K_DROP:
      case K_EXCLUDE:
      case K_FALSE:
      case K_FOREIGN:
      case K_IN:
      case K_KEY:
      case K_NOT:
      case K_NULL:
      case K_ON:
      case K_PARALLEL:
      case K_PARTITION:
      case K_PRIMARY:
      case K_REFERENCES:
      case K_ROWS:
      case K_TABLESPACE:
      case K_TEMP:
      case K_TEMPORARY:
      case K_TIME_KEY_EXPR:
      case K_TRUE:
      case K_TYPE:
      case K_UNIQUE:
      case K_UPDATE:
      case K_USING:
      case K_UNSIGNED:
      case K_WHERE:
      case K_WITH:
      case S_DOUBLE:
      case S_LONG:
      case S_IDENTIFIER:
      case S_CHAR_LITERAL:
      case S_QUOTED_IDENTIFIER:
      case 325:
      case 327:
      case 333:
      case 345:
      case 363:{
        ;
        break;
        }
      default:
        jj_la1[414] = jj_gen;
        break label_92;
      }
      parameter = CreateParameter();
createOptions.addAll(parameter);
    }
    jj_consume_token(K_TABLE);
    if (jj_2_235(2)) {
      jj_consume_token(K_IF);
      jj_consume_token(K_NOT);
      jj_consume_token(K_EXISTS);
createTable.setIfNotExists(true);
    } else {
      ;
    }
    table = Table();
    if (jj_2_245(2)) {
      if (jj_2_244(3)) {
        jj_consume_token(325);
        tableColumn = RelObjectName();
columns.add(tableColumn);
        label_93:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_COMMA:{
            ;
            break;
            }
          default:
            jj_la1[415] = jj_gen;
            break label_93;
          }
          jj_consume_token(K_COMMA);
          tableColumn = RelObjectName();
columns.add(tableColumn);
        }
        jj_consume_token(326);
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 325:{
          jj_consume_token(325);
          coldef = ColumnDefinition();
columnDefinitions.add(coldef);
          label_94:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_COMMA:{
              ;
              break;
              }
            default:
              jj_la1[416] = jj_gen;
              break label_94;
            }
            jj_consume_token(K_COMMA);
            if (jj_2_238(3)) {
              tk = jj_consume_token(K_INDEX);
              sk3 = RelObjectName();
              /* colNames=ColumnsNamesList() */
                                          colNames = ColumnNamesWithParamsList();
index = new Index().withType(tk.image).withName(sk3).withColumns(colNames);
                                indexes.add(index);
            } else if (jj_2_239(3)) {
index = new NamedConstraint();
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case K_CONSTRAINT:{
                jj_consume_token(K_CONSTRAINT);
                sk3 = RelObjectName();
index.setName(sk3);
                break;
                }
              default:
                jj_la1[417] = jj_gen;
                ;
              }
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case K_PRIMARY:{
                tk = jj_consume_token(K_PRIMARY);
                tk2 = jj_consume_token(K_KEY);
index.setType(tk.image + " " + tk2.image);
                break;
                }
              case K_UNIQUE:{
                tk = jj_consume_token(K_UNIQUE);
                switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
                case K_KEY:{
                  tk2 = jj_consume_token(K_KEY);
                  break;
                  }
                default:
                  jj_la1[418] = jj_gen;
                  ;
                }
index.setType(tk.image + (tk2!=null?" " + tk2.image:""));
                break;
                }
              default:
                jj_la1[419] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
              }
              /* colNames=ColumnsNamesList() */
                                          colNames = ColumnNamesWithParamsList();
              label_95:
              while (true) {
                switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
                case K_ARRAY_LITERAL:
                case K_AS:
                case K_ASC:
                case K_BY:
                case K_CASCADE:
                case K_CHECK:
                case K_COLLATE:
                case K_COMMIT:
                case K_COMMENT:
                case K_CONSTRAINT:
                case K_DEFAULT:
                case K_DELETE:
                case K_DESC:
                case K_DROP:
                case K_EXCLUDE:
                case K_FALSE:
                case K_FOREIGN:
                case K_IN:
                case K_KEY:
                case K_NOT:
                case K_NULL:
                case K_ON:
                case K_PARALLEL:
                case K_PARTITION:
                case K_PRIMARY:
                case K_REFERENCES:
                case K_ROWS:
                case K_TABLESPACE:
                case K_TEMP:
                case K_TEMPORARY:
                case K_TIME_KEY_EXPR:
                case K_TRUE:
                case K_TYPE:
                case K_UNIQUE:
                case K_UPDATE:
                case K_USING:
                case K_UNSIGNED:
                case K_WHERE:
                case K_WITH:
                case S_DOUBLE:
                case S_LONG:
                case S_IDENTIFIER:
                case S_CHAR_LITERAL:
                case S_QUOTED_IDENTIFIER:
                case 325:
                case 327:
                case 333:
                case 345:
                case 363:{
                  ;
                  break;
                  }
                default:
                  jj_la1[420] = jj_gen;
                  break label_95;
                }
                parameter = CreateParameter();
idxSpec.addAll(parameter);
              }
index.withColumns(colNames).withIndexSpec(idxSpec);
                                indexes.add(index);
tk2=null;
            } else if (jj_2_240(3)) {
tk=null;
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case K_UNIQUE:{
                tk = jj_consume_token(K_UNIQUE);
                break;
                }
              default:
                jj_la1[421] = jj_gen;
                ;
              }
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case K_FULLTEXT:{
                tk3 = jj_consume_token(K_FULLTEXT);
                break;
                }
              default:
                jj_la1[422] = jj_gen;
                ;
              }
              tk2 = jj_consume_token(K_KEY);
              sk3 = RelObjectName();
              /* colNames=ColumnsNamesList() */
                                          colNames = ColumnNamesWithParamsList();
              label_96:
              while (true) {
                switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
                case K_ARRAY_LITERAL:
                case K_AS:
                case K_ASC:
                case K_BY:
                case K_CASCADE:
                case K_CHECK:
                case K_COLLATE:
                case K_COMMIT:
                case K_COMMENT:
                case K_CONSTRAINT:
                case K_DEFAULT:
                case K_DELETE:
                case K_DESC:
                case K_DROP:
                case K_EXCLUDE:
                case K_FALSE:
                case K_FOREIGN:
                case K_IN:
                case K_KEY:
                case K_NOT:
                case K_NULL:
                case K_ON:
                case K_PARALLEL:
                case K_PARTITION:
                case K_PRIMARY:
                case K_REFERENCES:
                case K_ROWS:
                case K_TABLESPACE:
                case K_TEMP:
                case K_TEMPORARY:
                case K_TIME_KEY_EXPR:
                case K_TRUE:
                case K_TYPE:
                case K_UNIQUE:
                case K_UPDATE:
                case K_USING:
                case K_UNSIGNED:
                case K_WHERE:
                case K_WITH:
                case S_DOUBLE:
                case S_LONG:
                case S_IDENTIFIER:
                case S_CHAR_LITERAL:
                case S_QUOTED_IDENTIFIER:
                case 325:
                case 327:
                case 333:
                case 345:
                case 363:{
                  ;
                  break;
                  }
                default:
                  jj_la1[423] = jj_gen;
                  break label_96;
                }
                parameter = CreateParameter();
idxSpec.addAll(parameter);
              }
index = new Index()
                                .withType((tk!=null?tk.image + " ":"") + (tk3!=null?tk3.image + " ":"") + tk2.image)
                                .withName(sk3)
                                .withColumns(colNames)
                                .withIndexSpec(idxSpec);
                                indexes.add(index);
            } else if (jj_2_241(3)) {
fkIndex = new ForeignKeyIndex();
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case K_CONSTRAINT:{
                jj_consume_token(K_CONSTRAINT);
                sk3 = RelObjectName();
fkIndex.setName(sk3);
                break;
                }
              default:
                jj_la1[424] = jj_gen;
                ;
              }
              tk = jj_consume_token(K_FOREIGN);
              tk2 = jj_consume_token(K_KEY);
              /* colNames=ColumnsNamesList() */
                                          colNames = ColumnNamesWithParamsList();
fkIndex.withType(tk.image + " " + tk2.image).withColumns(colNames);
              jj_consume_token(K_REFERENCES);
              fkTable = Table();
              colNames2 = ColumnsNamesList();
fkIndex.setTable(fkTable);
                                fkIndex.setReferencedColumnNames(colNames2);
                                indexes.add(fkIndex);
              if (jj_2_236(2)) {
                jj_consume_token(K_ON);
                switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
                case K_DELETE:{
                  tk = jj_consume_token(K_DELETE);
                  break;
                  }
                case K_UPDATE:{
                  tk = jj_consume_token(K_UPDATE);
                  break;
                  }
                default:
                  jj_la1[425] = jj_gen;
                  jj_consume_token(-1);
                  throw new ParseException();
                }
                action = Action();
fkIndex.setReferentialAction(ReferentialAction.Type.valueOf(tk.image), action);
              } else {
                ;
              }
              if (jj_2_237(2)) {
                jj_consume_token(K_ON);
                switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
                case K_DELETE:{
                  tk = jj_consume_token(K_DELETE);
                  break;
                  }
                case K_UPDATE:{
                  tk = jj_consume_token(K_UPDATE);
                  break;
                  }
                default:
                  jj_la1[426] = jj_gen;
                  jj_consume_token(-1);
                  throw new ParseException();
                }
                action = Action();
fkIndex.setReferentialAction(ReferentialAction.Type.valueOf(tk.image), action);
              } else {
                ;
              }
            } else if (jj_2_242(3)) {
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case K_CONSTRAINT:{
                jj_consume_token(K_CONSTRAINT);
                sk3 = RelObjectName();
                break;
                }
              default:
                jj_la1[427] = jj_gen;
                ;
              }
Expression exp = null;
              jj_consume_token(K_CHECK);
              label_97:
              while (true) {
                switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
                case 325:{
                  ;
                  break;
                  }
                default:
                  jj_la1[428] = jj_gen;
                  break label_97;
                }
                jj_consume_token(325);
                exp = Expression();
                jj_consume_token(326);
              }
checkCs = new CheckConstraint().withName(sk3).withExpression(exp);
                           indexes.add(checkCs);
            } else if (jj_2_243(2)) {
              tk = jj_consume_token(K_EXCLUDE);
excludeC = new ExcludeConstraint(); Expression exp = null;
              tk2 = jj_consume_token(K_WHERE);
              label_98:
              while (true) {
                switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
                case 325:{
                  ;
                  break;
                  }
                default:
                  jj_la1[429] = jj_gen;
                  break label_98;
                }
                jj_consume_token(325);
                exp = Expression();
                jj_consume_token(326);
              }
excludeC.setExpression(exp);
indexes.add(excludeC);
            } else {
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case K_ACTION:
              case K_ACTIVE:
              case K_ALGORITHM:
              case K_ARCHIVE:
              case K_ARRAY_LITERAL:
              case K_AT:
              case K_BYTE:
              case K_CASCADE:
              case K_CASE:
              case K_CAST:
              case K_TRY_CAST:
              case K_CHARACTER:
              case K_CHANGE:
              case K_CHECKPOINT:
              case K_CHAR:
              case K_COLUMN:
              case K_COLUMNS:
              case K_COMMIT:
              case K_COMMENT:
              case K_COSTS:
              case K_CREATE:
              case K_CYCLE:
              case K_DATETIMELITERAL:
              case K_DATE_LITERAL:
              case K_DBA_RECYCLEBIN:
              case K_DEFAULT:
              case K_DESC:
              case K_DESCRIBE:
              case K_DISABLE:
              case K_DISCONNECT:
              case K_DIV:
              case K_DO:
              case K_DUMP:
              case K_DUPLICATE:
              case K_ENABLE:
              case K_END:
              case K_EXCLUDE:
              case K_EXTRACT:
              case K_FILTER:
              case K_FIRST:
              case K_FALSE:
              case K_FLUSH:
              case K_FOLLOWING:
              case K_FORMAT:
              case K_FULLTEXT:
              case K_GROUP:
              case K_HISTORY:
              case K_INDEX:
              case K_INSERT:
              case K_INTERVAL:
              case K_ISNULL:
              case K_JSON:
              case K_KEY:
              case K_FN:
              case K_LAST:
              case K_LEADING:
              case K_LOCAL:
              case K_LINK:
              case K_LOG:
              case K_MATERIALIZED:
              case K_NEXTVAL:
              case K_NO:
              case K_NOLOCK:
              case K_NULLS:
              case K_OF:
              case K_ON:
              case K_OPEN:
              case K_ORDER:
              case K_OVER:
              case K_PARALLEL:
              case K_PARTITION:
              case K_PATH:
              case K_PERCENT:
              case K_PRECISION:
              case K_PRIMARY:
              case K_PRIOR:
              case K_QUERY:
              case K_QUIESCE:
              case K_RANGE:
              case K_READ:
              case K_RECYCLEBIN:
              case K_REGISTER:
              case K_REPLACE:
              case K_RESUME:
              case K_RESTRICTED:
              case K_ROW:
              case K_ROWS:
              case K_SCHEMA:
              case K_SEQUENCE:
              case K_SEPARATOR:
              case K_SESSION:
              case K_SHUTDOWN:
              case K_SIBLINGS:
              case K_SIZE:
              case K_SKIP:
              case K_START:
              case K_SUSPEND:
              case K_SWITCH:
              case K_SYNONYM:
              case K_SYSTEM:
              case K_TABLE:
              case K_TABLES:
              case K_TABLESPACE:
              case K_TEMP:
              case K_TEMPORARY:
              case K_TIMEOUT:
              case K_TO:
              case K_TOP:
              case K_TRUNCATE:
              case K_TRUE:
              case K_TYPE:
              case K_UNQIESCE:
              case K_USER:
              case K_SIGNED:
              case K_STRING_FUNCTION_NAME:
              case K_UNSIGNED:
              case K_VALIDATE:
              case K_VALUE:
              case K_VALUES:
              case K_VIEW:
              case K_XML:
              case K_ZONE:
              case S_IDENTIFIER:
              case S_QUOTED_IDENTIFIER:{
                coldef = ColumnDefinition();
columnDefinitions.add(coldef);
                break;
                }
              default:
                jj_la1[430] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
              }
            }
          }
          jj_consume_token(326);
          break;
          }
        default:
          jj_la1[431] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    } else {
      ;
    }
    label_99:
    while (true) {
      if (jj_2_246(2) && (getToken(1).kind != K_AS)) {
        ;
      } else {
        break label_99;
      }
      parameter = CreateParameter();
tableOptions.addAll(parameter);
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_DISABLE:
    case K_ENABLE:{
      rowMovement = RowMovement();
createTable.setRowMovement(rowMovement);
      break;
      }
    default:
      jj_la1[432] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_AS:{
      jj_consume_token(K_AS);
      select = SelectWithWithItems();
createTable.setSelect(select, false);
      break;
      }
    default:
      jj_la1[433] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_LIKE:{
      jj_consume_token(K_LIKE);
      if (jj_2_247(2147483647)) {
        jj_consume_token(325);
        likeTable = Table();
createTable.setLikeTable(likeTable, true);
        jj_consume_token(326);
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_ACTION:
        case K_ACTIVE:
        case K_ALGORITHM:
        case K_ALL:
        case K_ANY:
        case K_ARCHIVE:
        case K_ARRAY_LITERAL:
        case K_AT:
        case K_BYTE:
        case K_CASCADE:
        case K_CASE:
        case K_CASEWHEN:
        case K_CAST:
        case K_TRY_CAST:
        case K_CHARACTER:
        case K_CHANGE:
        case K_CHECKPOINT:
        case K_CHAR:
        case K_COLUMN:
        case K_COLUMNS:
        case K_COMMIT:
        case K_COMMENT:
        case K_COSTS:
        case K_CREATE:
        case K_CYCLE:
        case K_DATETIMELITERAL:
        case K_DATE_LITERAL:
        case K_DBA_RECYCLEBIN:
        case K_DEFAULT:
        case K_DESC:
        case K_DESCRIBE:
        case K_DISABLE:
        case K_DISCONNECT:
        case K_DIV:
        case K_DO:
        case K_DOUBLE:
        case K_DUMP:
        case K_DUPLICATE:
        case K_ENABLE:
        case K_END:
        case K_EXCLUDE:
        case K_EXTRACT:
        case K_FILTER:
        case K_FIRST:
        case K_FALSE:
        case K_FLUSH:
        case K_FOLLOWING:
        case K_FORMAT:
        case K_FULLTEXT:
        case K_GROUP:
        case K_GROUPING:
        case K_HISTORY:
        case K_IF:
        case K_IIF:
        case K_IN:
        case K_INDEX:
        case K_INSERT:
        case K_INTERVAL:
        case K_ISNULL:
        case K_JSON:
        case K_KEY:
        case K_FN:
        case K_LAST:
        case K_LEADING:
        case K_LEFT:
        case K_LIMIT:
        case K_LOCAL:
        case K_LINK:
        case K_LOG:
        case K_MATERIALIZED:
        case K_NEXTVAL:
        case K_NO:
        case K_NOLOCK:
        case K_NULLS:
        case K_OF:
        case K_OFFSET:
        case K_ON:
        case K_OPEN:
        case K_ORDER:
        case K_OVER:
        case K_OPTIMIZE:
        case K_PARALLEL:
        case K_PARTITION:
        case K_PATH:
        case K_PERCENT:
        case K_PRECISION:
        case K_PRIMARY:
        case K_PRIOR:
        case K_PROCEDURE:
        case K_PUBLIC:
        case K_QUERY:
        case K_QUIESCE:
        case K_RANGE:
        case K_READ:
        case K_RECYCLEBIN:
        case K_REGISTER:
        case K_REPLACE:
        case K_RESUME:
        case K_RESTRICTED:
        case K_RIGHT:
        case K_ROW:
        case K_ROWS:
        case K_SCHEMA:
        case K_SEQUENCE:
        case K_SEPARATOR:
        case K_SESSION:
        case K_SET:
        case K_SHUTDOWN:
        case K_SIBLINGS:
        case K_SIZE:
        case K_SKIP:
        case K_SOME:
        case K_START:
        case K_SUSPEND:
        case K_SWITCH:
        case K_SYNONYM:
        case K_SYSTEM:
        case K_TABLE:
        case K_TABLES:
        case K_TABLESPACE:
        case K_TEMP:
        case K_TEMPORARY:
        case K_TIMEOUT:
        case K_TO:
        case K_TOP:
        case K_TRUNCATE:
        case K_TRUE:
        case K_TYPE:
        case K_UNQIESCE:
        case K_USER:
        case K_SIGNED:
        case K_STRING_FUNCTION_NAME:
        case K_UNSIGNED:
        case K_VALIDATE:
        case K_VALUE:
        case K_VALUES:
        case K_VIEW:
        case K_XML:
        case K_ZONE:
        case S_IDENTIFIER:
        case S_QUOTED_IDENTIFIER:{
          likeTable = Table();
createTable.setLikeTable(likeTable, false);
          break;
          }
        default:
          jj_la1[434] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      break;
      }
    default:
      jj_la1[435] = jj_gen;
      ;
    }
createTable.setTable(table);
        if (indexes.size() > 0)
            createTable.setIndexes(indexes);
        if (createOptions.size() > 0)
            createTable.setCreateOptionsStrings(createOptions);
        if (tableOptions.size() > 0)
            createTable.setTableOptionsStrings(tableOptions);
        if (columnDefinitions.size() > 0)
            createTable.setColumnDefinitions(columnDefinitions);
        if (columns.size() > 0)
            createTable.setColumns(columns);
        return createTable;
}

  final public ColDataType ColDataType() throws ParseException {ColDataType colDataType = new ColDataType();
    Token tk = null;
    Token tk2 = null;
    List<String> argumentsStringList = new ArrayList<String>();
    List<Integer> array = new ArrayList<Integer>();
    List<String> name;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_BIT:
    case K_CHARACTER:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_CHARACTER:{
        tk = jj_consume_token(K_CHARACTER);
        break;
        }
      case K_BIT:{
        tk = jj_consume_token(K_BIT);
        break;
        }
      default:
        jj_la1[436] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_VARYING:{
        tk2 = jj_consume_token(K_VARYING);
        break;
        }
      default:
        jj_la1[437] = jj_gen;
        ;
      }
colDataType.setDataType(tk.image + (tk2!=null?" " + tk2.image:""));
      break;
      }
    case K_DOUBLE:{
      tk = jj_consume_token(K_DOUBLE);
      if (jj_2_248(2)) {
        tk2 = jj_consume_token(K_PRECISION);
      } else {
        ;
      }
colDataType.setDataType(tk.image + (tk2!=null?" " + tk2.image:""));
      break;
      }
    case K_BINARY:
    case K_CHAR:
    case K_DATETIMELITERAL:
    case K_DATE_LITERAL:
    case K_INTERVAL:
    case K_JSON:
    case K_SET:
    case K_XML:
    case DT_ZONE:
    case S_IDENTIFIER:
    case S_QUOTED_IDENTIFIER:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S_IDENTIFIER:{
        tk = jj_consume_token(S_IDENTIFIER);
        break;
        }
      case S_QUOTED_IDENTIFIER:{
        tk = jj_consume_token(S_QUOTED_IDENTIFIER);
        break;
        }
      case K_DATETIMELITERAL:{
        tk = jj_consume_token(K_DATETIMELITERAL);
        break;
        }
      case K_DATE_LITERAL:{
        tk = jj_consume_token(K_DATE_LITERAL);
        break;
        }
      case K_XML:{
        tk = jj_consume_token(K_XML);
        break;
        }
      case K_INTERVAL:{
        tk = jj_consume_token(K_INTERVAL);
        break;
        }
      case DT_ZONE:{
        tk = jj_consume_token(DT_ZONE);
        break;
        }
      case K_CHAR:{
        tk = jj_consume_token(K_CHAR);
        break;
        }
      case K_SET:{
        tk = jj_consume_token(K_SET);
        break;
        }
      case K_BINARY:{
        tk = jj_consume_token(K_BINARY);
        break;
        }
      case K_JSON:{
        tk = jj_consume_token(K_JSON);
        break;
        }
      default:
        jj_la1[438] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 329:{
        jj_consume_token(329);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S_IDENTIFIER:{
          tk2 = jj_consume_token(S_IDENTIFIER);
          break;
          }
        case S_QUOTED_IDENTIFIER:{
          tk2 = jj_consume_token(S_QUOTED_IDENTIFIER);
          break;
          }
        default:
          jj_la1[439] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[440] = jj_gen;
        ;
      }
if (tk2!=null) colDataType.setDataType(tk.image + "." + tk2.image); else colDataType.setDataType(tk.image);
      break;
      }
    case K_UNSIGNED:{
      tk = jj_consume_token(K_UNSIGNED);
      if (jj_2_249(2)) {
        tk2 = jj_consume_token(S_IDENTIFIER);
      } else {
        ;
      }
if (tk2!=null) colDataType.setDataType(tk.image + " " + tk2.image); else colDataType.setDataType(tk.image);
      break;
      }
    default:
      jj_la1[441] = jj_gen;
      if (jj_2_250(2)) {
        tk = jj_consume_token(K_SIGNED);
        tk2 = jj_consume_token(S_IDENTIFIER);
colDataType.setDataType(tk.image + " " + tk2.image);
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_SIGNED:{
          tk = jj_consume_token(K_SIGNED);
colDataType.setDataType(tk.image);
          break;
          }
        default:
          jj_la1[442] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
    if (jj_2_252(2)) {
      jj_consume_token(325);
tk2 =null;
      label_100:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_CHAR:
        case S_LONG:
        case S_IDENTIFIER:
        case S_CHAR_LITERAL:{
          ;
          break;
          }
        default:
          jj_la1[443] = jj_gen;
          break label_100;
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S_LONG:{
          tk = jj_consume_token(S_LONG);
          if (jj_2_251(2)) {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_BYTE:{
              tk2 = jj_consume_token(K_BYTE);
              break;
              }
            case K_CHAR:{
              tk2 = jj_consume_token(K_CHAR);
              break;
              }
            default:
              jj_la1[444] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
          } else {
            ;
          }
          break;
          }
        case S_CHAR_LITERAL:{
          tk = jj_consume_token(S_CHAR_LITERAL);
          break;
          }
        case S_IDENTIFIER:{
          tk = jj_consume_token(S_IDENTIFIER);
          break;
          }
        case K_CHAR:{
          tk = jj_consume_token(K_CHAR);
          break;
          }
        default:
          jj_la1[445] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
argumentsStringList.add(tk.image + (tk2!=null?" " + tk2.image:""));
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_COMMA:{
          jj_consume_token(K_COMMA);

          break;
          }
        default:
          jj_la1[446] = jj_gen;
          ;
        }
      }
      jj_consume_token(326);
    } else {
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case 357:{
      label_101:
      while (true) {
        jj_consume_token(357);
tk=null;
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S_LONG:{
          tk = jj_consume_token(S_LONG);
          break;
          }
        default:
          jj_la1[447] = jj_gen;
          ;
        }
array.add(tk!=null?Integer.valueOf(tk.image):null);
        jj_consume_token(358);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 357:{
          ;
          break;
          }
        default:
          jj_la1[448] = jj_gen;
          break label_101;
        }
      }
colDataType.setArrayData(array);
      break;
      }
    default:
      jj_la1[449] = jj_gen;
      ;
    }
    if (jj_2_253(2)) {
      jj_consume_token(K_CHARACTER);
      jj_consume_token(K_SET);
      tk = jj_consume_token(S_IDENTIFIER);
colDataType.setCharacterSet(tk.image);
    } else {
      ;
    }
if (argumentsStringList.size() > 0)
            colDataType.setArgumentsStringList(argumentsStringList);
        return colDataType;
}

  final public CreateView CreateView() throws ParseException {CreateView createView = new CreateView();
    Table view = null;
    Select select = null;
    List<String> columnNames = null;
    jj_consume_token(K_CREATE);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_OR:{
      jj_consume_token(K_OR);
      jj_consume_token(K_REPLACE);
createView.setOrReplace(true);
      break;
      }
    default:
      jj_la1[450] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_FORCE:
    case K_NO:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_NO:{
        jj_consume_token(K_NO);
        jj_consume_token(K_FORCE);
createView.setForce(ForceOption.NO_FORCE);
        break;
        }
      case K_FORCE:{
        jj_consume_token(K_FORCE);
createView.setForce(ForceOption.FORCE);
        break;
        }
      default:
        jj_la1[451] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[452] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_TEMP:
    case K_TEMPORARY:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_TEMP:{
        jj_consume_token(K_TEMP);
createView.setTemporary(TemporaryOption.TEMP);
        break;
        }
      case K_TEMPORARY:{
        jj_consume_token(K_TEMPORARY);
createView.setTemporary(TemporaryOption.TEMPORARY);
        break;
        }
      default:
        jj_la1[453] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[454] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_MATERIALIZED:{
      jj_consume_token(K_MATERIALIZED);
createView.setMaterialized(true);
      break;
      }
    default:
      jj_la1[455] = jj_gen;
      ;
    }
    jj_consume_token(K_VIEW);
    view = Table();
createView.setView(view);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case 325:{
      columnNames = ColumnsNamesList();
createView.setColumnNames(columnNames);
      break;
      }
    default:
      jj_la1[456] = jj_gen;
      ;
    }
    jj_consume_token(K_AS);
    select = SelectWithWithItems();
createView.setSelect(select);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_WITH:{
      jj_consume_token(K_WITH);
      jj_consume_token(K_READ);
      jj_consume_token(K_ONLY);
createView.setWithReadOnly(true);
      break;
      }
    default:
      jj_la1[457] = jj_gen;
      ;
    }
return createView;
}

  final public ReferentialAction.Action Action() throws ParseException {ReferentialAction.Action action = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_CASCADE:{
      jj_consume_token(K_CASCADE);
action=ReferentialAction.Action.CASCADE;
      break;
      }
    case K_RESTRICT:{
      jj_consume_token(K_RESTRICT);
action=ReferentialAction.Action.RESTRICT;
      break;
      }
    case K_NO:{
      jj_consume_token(K_NO);
      jj_consume_token(K_ACTION);
action=ReferentialAction.Action.NO_ACTION;
      break;
      }
    case K_SET:{
      jj_consume_token(K_SET);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_NULL:{
        jj_consume_token(K_NULL);
action=ReferentialAction.Action.SET_NULL;
        break;
        }
      case K_DEFAULT:{
        jj_consume_token(K_DEFAULT);
action=ReferentialAction.Action.SET_DEFAULT;
        break;
        }
      default:
        jj_la1[458] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[459] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return action;
}

  final public AlterView AlterView() throws ParseException {AlterView alterView = new AlterView();
    Table view = null;
    SelectBody select = null;
    List<String> columnNames = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ALTER:{
      jj_consume_token(K_ALTER);
      break;
      }
    case K_REPLACE:{
      jj_consume_token(K_REPLACE);
alterView.setUseReplace(true);
      break;
      }
    default:
      jj_la1[460] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(K_VIEW);
    view = Table();
alterView.setView(view);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case 325:{
      columnNames = ColumnsNamesList();
alterView.setColumnNames(columnNames);
      break;
      }
    default:
      jj_la1[461] = jj_gen;
      ;
    }
    jj_consume_token(K_AS);
    select = SelectBody();
alterView.setSelectBody(select);
return alterView;
}

  final public List<String> CreateParameter() throws ParseException {String retval = "";
    Token tk = null;
    Token tk2 = null;
    StringBuilder identifier = new StringBuilder("");
    Expression exp = null;
    List<String> param = new ArrayList<String>();
    ColDataType colDataType;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case S_IDENTIFIER:
    case S_QUOTED_IDENTIFIER:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S_IDENTIFIER:{
        tk = jj_consume_token(S_IDENTIFIER);
        break;
        }
      case S_QUOTED_IDENTIFIER:{
        tk = jj_consume_token(S_QUOTED_IDENTIFIER);
        break;
        }
      default:
        jj_la1[462] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
identifier.append(tk.image);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 329:{
        jj_consume_token(329);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S_IDENTIFIER:{
          tk2 = jj_consume_token(S_IDENTIFIER);
          break;
          }
        case S_QUOTED_IDENTIFIER:{
          tk2 = jj_consume_token(S_QUOTED_IDENTIFIER);
          break;
          }
        default:
          jj_la1[463] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
identifier.append("."); identifier.append(tk2.image);
        break;
        }
      default:
        jj_la1[464] = jj_gen;
        ;
      }
param.add(identifier.toString());
      break;
      }
    case K_NULL:{
      tk = jj_consume_token(K_NULL);
param.add(tk.image);
      break;
      }
    case K_NOT:{
      tk = jj_consume_token(K_NOT);
param.add(tk.image);
      break;
      }
    case K_PRIMARY:{
      tk = jj_consume_token(K_PRIMARY);
param.add(tk.image);
      break;
      }
    case K_DEFAULT:{
      tk = jj_consume_token(K_DEFAULT);
param.add(tk.image);
      break;
      }
    case K_FOREIGN:{
      tk = jj_consume_token(K_FOREIGN);
param.add(tk.image);
      break;
      }
    case K_REFERENCES:{
      tk = jj_consume_token(K_REFERENCES);
param.add(tk.image);
      break;
      }
    case K_KEY:{
      tk = jj_consume_token(K_KEY);
param.add(tk.image);
      break;
      }
    case S_CHAR_LITERAL:{
      tk = jj_consume_token(S_CHAR_LITERAL);
param.add(tk.image);
      break;
      }
    case S_DOUBLE:
    case S_LONG:
    case 333:
    case 345:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 333:
      case 345:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 333:{
          jj_consume_token(333);
retval = "+";
          break;
          }
        case 345:{
          jj_consume_token(345);
retval = "-";
          break;
          }
        default:
          jj_la1[465] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[466] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S_LONG:{
        tk = jj_consume_token(S_LONG);
retval += tk.image;
        break;
        }
      case S_DOUBLE:{
        tk = jj_consume_token(S_DOUBLE);
retval += tk.image;
        break;
        }
      default:
        jj_la1[467] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
param.add(retval);
      break;
      }
    case K_AS:{
      tk = jj_consume_token(K_AS);
param.add(tk.image);
      break;
      }
    case K_ON:{
      tk = jj_consume_token(K_ON);
param.add(tk.image);
      break;
      }
    case K_COMMIT:{
      tk = jj_consume_token(K_COMMIT);
param.add(tk.image);
      break;
      }
    case K_DROP:{
      tk = jj_consume_token(K_DROP);
param.add(tk.image);
      break;
      }
    case K_ROWS:{
      tk = jj_consume_token(K_ROWS);
param.add(tk.image);
      break;
      }
    case K_UNIQUE:{
      tk = jj_consume_token(K_UNIQUE);
param.add(tk.image);
      break;
      }
    case K_CASCADE:{
      tk = jj_consume_token(K_CASCADE);
param.add(tk.image);
      break;
      }
    case K_DELETE:{
      tk = jj_consume_token(K_DELETE);
param.add(tk.image);
      break;
      }
    case K_UPDATE:{
      tk = jj_consume_token(K_UPDATE);
param.add(tk.image);
      break;
      }
    case K_TIME_KEY_EXPR:{
      tk = jj_consume_token(K_TIME_KEY_EXPR);
param.add(new TimeKeyExpression(tk.image).toString());
      break;
      }
    case 327:{
      jj_consume_token(327);
param.add("=");
      break;
      }
    default:
      jj_la1[468] = jj_gen;
      if (jj_2_254(3)) {
        jj_consume_token(K_USING);
        jj_consume_token(K_INDEX);
        jj_consume_token(K_TABLESPACE);
        retval = RelObjectName();
param.add("USING"); param.add("INDEX"); param.add("TABLESPACE"); param.add(retval);
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_TABLESPACE:{
          jj_consume_token(K_TABLESPACE);
          retval = RelObjectName();
param.add("TABLESPACE"); param.add(retval);
          break;
          }
        case 325:{
          retval = AList();
param.add(retval);
          break;
          }
        case K_CHECK:{
          jj_consume_token(K_CHECK);
          jj_consume_token(325);
          exp = Expression();
          jj_consume_token(326);
param.add("CHECK"); param.add("(" + exp.toString() + ")");
          break;
          }
        case K_CONSTRAINT:{
          tk = jj_consume_token(K_CONSTRAINT);
param.add(tk.image);
          break;
          }
        case K_WITH:{
          tk = jj_consume_token(K_WITH);
param.add(tk.image);
          break;
          }
        case K_EXCLUDE:{
          tk = jj_consume_token(K_EXCLUDE);
param.add(tk.image);
          break;
          }
        case K_WHERE:{
          tk = jj_consume_token(K_WHERE);
param.add(tk.image);
          break;
          }
        case K_UNSIGNED:{
          tk = jj_consume_token(K_UNSIGNED);
param.add(tk.image);
          break;
          }
        case K_TEMP:{
          tk = jj_consume_token(K_TEMP);
param.add(tk.image);
          break;
          }
        case K_TEMPORARY:{
          tk = jj_consume_token(K_TEMPORARY);
param.add(tk.image);
          break;
          }
        case K_PARTITION:{
          tk = jj_consume_token(K_PARTITION);
param.add(tk.image);
          break;
          }
        case K_BY:{
          tk = jj_consume_token(K_BY);
param.add(tk.image);
          break;
          }
        case K_IN:{
          tk = jj_consume_token(K_IN);
param.add(tk.image);
          break;
          }
        case K_TYPE:{
          tk = jj_consume_token(K_TYPE);
param.add(tk.image);
          break;
          }
        case K_COMMENT:{
          tk = jj_consume_token(K_COMMENT);
param.add(tk.image);
          break;
          }
        case K_USING:{
          tk = jj_consume_token(K_USING);
param.add(tk.image);
          break;
          }
        case K_COLLATE:{
          tk = jj_consume_token(K_COLLATE);
param.add(tk.image);
          break;
          }
        case K_ASC:{
          tk = jj_consume_token(K_ASC);
param.add(tk.image);
          break;
          }
        case K_DESC:{
          tk = jj_consume_token(K_DESC);
param.add(tk.image);
          break;
          }
        case K_TRUE:{
          tk = jj_consume_token(K_TRUE);
param.add(tk.image);
          break;
          }
        case K_FALSE:{
          tk = jj_consume_token(K_FALSE);
param.add(tk.image);
          break;
          }
        case K_PARALLEL:{
          tk = jj_consume_token(K_PARALLEL);
param.add(tk.image);
          break;
          }
        case K_ARRAY_LITERAL:{
          jj_consume_token(K_ARRAY_LITERAL);
          exp = ArrayConstructor(true);
param.add(exp.toString());
          break;
          }
        case 363:{
          tk = jj_consume_token(363);
          colDataType = ColDataType();
param.add(tk.image); param.add(colDataType.toString());
          break;
          }
        default:
          jj_la1[469] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
return param;
}

// row_movement_clause https://docs.oracle.com/cd/B19306_01/server.102/b14200/statements_7002.htm#i2204697
  final public RowMovement RowMovement() throws ParseException {RowMovement rowMovement = new RowMovement();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ENABLE:{
      jj_consume_token(K_ENABLE);
      jj_consume_token(K_ROW);
      jj_consume_token(K_MOVEMENT);
rowMovement.setMode(RowMovementMode.ENABLE);
      break;
      }
    case K_DISABLE:{
      jj_consume_token(K_DISABLE);
      jj_consume_token(K_ROW);
      jj_consume_token(K_MOVEMENT);
rowMovement.setMode(RowMovementMode.DISABLE);
      break;
      }
    default:
      jj_la1[470] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return rowMovement;
}

  final public String AList() throws ParseException {StringBuilder retval = new StringBuilder("(");
    Token tk = null;
    String name = null;
    jj_consume_token(325);
    label_102:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ACTION:
      case K_ACTIVE:
      case K_ALGORITHM:
      case K_ARCHIVE:
      case K_ARRAY_LITERAL:
      case K_AT:
      case K_BYTE:
      case K_CASCADE:
      case K_CASE:
      case K_CAST:
      case K_TRY_CAST:
      case K_CHARACTER:
      case K_CHANGE:
      case K_CHECKPOINT:
      case K_CHAR:
      case K_COLUMN:
      case K_COLUMNS:
      case K_COMMIT:
      case K_COMMENT:
      case K_COSTS:
      case K_CYCLE:
      case K_DATETIMELITERAL:
      case K_DATE_LITERAL:
      case K_DBA_RECYCLEBIN:
      case K_DEFAULT:
      case K_DESC:
      case K_DESCRIBE:
      case K_DISABLE:
      case K_DISCONNECT:
      case K_DIV:
      case K_DO:
      case K_DUMP:
      case K_DUPLICATE:
      case K_ENABLE:
      case K_END:
      case K_EXCLUDE:
      case K_EXTRACT:
      case K_FILTER:
      case K_FIRST:
      case K_FALSE:
      case K_FLUSH:
      case K_FOLLOWING:
      case K_FORMAT:
      case K_FULLTEXT:
      case K_HISTORY:
      case K_INDEX:
      case K_INSERT:
      case K_ISNULL:
      case K_JSON:
      case K_KEY:
      case K_FN:
      case K_LAST:
      case K_LEADING:
      case K_LOCAL:
      case K_LINK:
      case K_LOG:
      case K_MATERIALIZED:
      case K_NEXTVAL:
      case K_NO:
      case K_NOLOCK:
      case K_NULLS:
      case K_OF:
      case K_OPEN:
      case K_OVER:
      case K_PARALLEL:
      case K_PARTITION:
      case K_PATH:
      case K_PERCENT:
      case K_PRECISION:
      case K_PRIMARY:
      case K_PRIOR:
      case K_QUERY:
      case K_QUIESCE:
      case K_RANGE:
      case K_READ:
      case K_RECYCLEBIN:
      case K_REGISTER:
      case K_REPLACE:
      case K_RESUME:
      case K_RESTRICTED:
      case K_ROW:
      case K_ROWS:
      case K_SCHEMA:
      case K_SEQUENCE:
      case K_SEPARATOR:
      case K_SESSION:
      case K_SHUTDOWN:
      case K_SIBLINGS:
      case K_SIZE:
      case K_SKIP:
      case K_SUSPEND:
      case K_SWITCH:
      case K_SYNONYM:
      case K_SYSTEM:
      case K_TABLE:
      case K_TABLESPACE:
      case K_TEMP:
      case K_TEMPORARY:
      case K_TIMEOUT:
      case K_TO:
      case K_TRUNCATE:
      case K_TRUE:
      case K_TYPE:
      case K_UNQIESCE:
      case K_USER:
      case K_SIGNED:
      case K_STRING_FUNCTION_NAME:
      case K_UNSIGNED:
      case K_VALIDATE:
      case K_VIEW:
      case K_XML:
      case K_ZONE:
      case S_DOUBLE:
      case S_LONG:
      case S_IDENTIFIER:
      case S_CHAR_LITERAL:
      case S_QUOTED_IDENTIFIER:{
        ;
        break;
        }
      default:
        jj_la1[471] = jj_gen;
        break label_102;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S_DOUBLE:
      case S_LONG:
      case S_CHAR_LITERAL:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S_LONG:{
          tk = jj_consume_token(S_LONG);
          break;
          }
        case S_DOUBLE:{
          tk = jj_consume_token(S_DOUBLE);
          break;
          }
        case S_CHAR_LITERAL:{
          tk = jj_consume_token(S_CHAR_LITERAL);
          break;
          }
        default:
          jj_la1[472] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
retval.append(tk.image);
        break;
        }
      case K_ACTION:
      case K_ACTIVE:
      case K_ALGORITHM:
      case K_ARCHIVE:
      case K_ARRAY_LITERAL:
      case K_AT:
      case K_BYTE:
      case K_CASCADE:
      case K_CASE:
      case K_CAST:
      case K_TRY_CAST:
      case K_CHARACTER:
      case K_CHANGE:
      case K_CHECKPOINT:
      case K_CHAR:
      case K_COLUMN:
      case K_COLUMNS:
      case K_COMMIT:
      case K_COMMENT:
      case K_COSTS:
      case K_CYCLE:
      case K_DATETIMELITERAL:
      case K_DATE_LITERAL:
      case K_DBA_RECYCLEBIN:
      case K_DEFAULT:
      case K_DESC:
      case K_DESCRIBE:
      case K_DISABLE:
      case K_DISCONNECT:
      case K_DIV:
      case K_DO:
      case K_DUMP:
      case K_DUPLICATE:
      case K_ENABLE:
      case K_END:
      case K_EXCLUDE:
      case K_EXTRACT:
      case K_FILTER:
      case K_FIRST:
      case K_FALSE:
      case K_FLUSH:
      case K_FOLLOWING:
      case K_FORMAT:
      case K_FULLTEXT:
      case K_HISTORY:
      case K_INDEX:
      case K_INSERT:
      case K_ISNULL:
      case K_JSON:
      case K_KEY:
      case K_FN:
      case K_LAST:
      case K_LEADING:
      case K_LOCAL:
      case K_LINK:
      case K_LOG:
      case K_MATERIALIZED:
      case K_NEXTVAL:
      case K_NO:
      case K_NOLOCK:
      case K_NULLS:
      case K_OF:
      case K_OPEN:
      case K_OVER:
      case K_PARALLEL:
      case K_PARTITION:
      case K_PATH:
      case K_PERCENT:
      case K_PRECISION:
      case K_PRIMARY:
      case K_PRIOR:
      case K_QUERY:
      case K_QUIESCE:
      case K_RANGE:
      case K_READ:
      case K_RECYCLEBIN:
      case K_REGISTER:
      case K_REPLACE:
      case K_RESUME:
      case K_RESTRICTED:
      case K_ROW:
      case K_ROWS:
      case K_SCHEMA:
      case K_SEQUENCE:
      case K_SEPARATOR:
      case K_SESSION:
      case K_SHUTDOWN:
      case K_SIBLINGS:
      case K_SIZE:
      case K_SKIP:
      case K_SUSPEND:
      case K_SWITCH:
      case K_SYNONYM:
      case K_SYSTEM:
      case K_TABLE:
      case K_TABLESPACE:
      case K_TEMP:
      case K_TEMPORARY:
      case K_TIMEOUT:
      case K_TO:
      case K_TRUNCATE:
      case K_TRUE:
      case K_TYPE:
      case K_UNQIESCE:
      case K_USER:
      case K_SIGNED:
      case K_STRING_FUNCTION_NAME:
      case K_UNSIGNED:
      case K_VALIDATE:
      case K_VIEW:
      case K_XML:
      case K_ZONE:
      case S_IDENTIFIER:
      case S_QUOTED_IDENTIFIER:{
        name = RelObjectNameWithoutValue();
retval.append(name);
        break;
        }
      default:
        jj_la1[473] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COMMA:
      case 327:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_COMMA:{
          jj_consume_token(K_COMMA);
retval.append(",");
          break;
          }
        case 327:{
          jj_consume_token(327);
retval.append("=");
          break;
          }
        default:
          jj_la1[474] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[475] = jj_gen;
        ;
      }
    }
    jj_consume_token(326);
retval.append(")");
        return retval.toString();
}

  final public String ColumnsNamesListItem() throws ParseException {Token tk = null;
    String item = null;
    item = RelObjectName();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case 325:{
      jj_consume_token(325);
      tk = jj_consume_token(S_LONG);
      jj_consume_token(326);
item = item + "(" + tk.image + ")";
      break;
      }
    default:
      jj_la1[476] = jj_gen;
      ;
    }
return item;
}

  final public List<String> ColumnsNamesList() throws ParseException {List<String> retval = new ArrayList<String>();
    String img = null;
    jj_consume_token(325);
    img = ColumnsNamesListItem();
retval.add(img);
    label_103:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COMMA:{
        ;
        break;
        }
      default:
        jj_la1[477] = jj_gen;
        break label_103;
      }
      jj_consume_token(K_COMMA);
      img = ColumnsNamesListItem();
retval.add(img);
    }
    jj_consume_token(326);
return retval;
}

  final public Drop Drop() throws ParseException {
      Drop drop = new Drop();
    Token tk = null;
    Table name;
    List<String> dropArgs = new ArrayList<String>();
    jj_consume_token(K_DROP);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case S_IDENTIFIER:{
      tk = jj_consume_token(S_IDENTIFIER);
      break;
      }
    case K_TABLE:{
      tk = jj_consume_token(K_TABLE);
      break;
      }
    case K_INDEX:{
      tk = jj_consume_token(K_INDEX);
      break;
      }
    case K_VIEW:{
      tk = jj_consume_token(K_VIEW);
      break;
      }
    case K_SCHEMA:{
      tk = jj_consume_token(K_SCHEMA);
      break;
      }
    case K_SEQUENCE:{
      tk = jj_consume_token(K_SEQUENCE);
      break;
      }
    default:
      jj_la1[478] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
drop.setType(tk.image);
    if (jj_2_255(2)) {
      jj_consume_token(K_IF);
      jj_consume_token(K_EXISTS);
drop.setIfExists(true);
    } else {
      ;
    }
    name = Table();
drop.setName(name);
    label_104:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_CASCADE:
      case K_RESTRICT:
      case S_IDENTIFIER:{
        ;
        break;
        }
      default:
        jj_la1[479] = jj_gen;
        break label_104;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S_IDENTIFIER:{
        tk = jj_consume_token(S_IDENTIFIER);
        break;
        }
      case K_CASCADE:{
        tk = jj_consume_token(K_CASCADE);
        break;
        }
      case K_RESTRICT:{
        tk = jj_consume_token(K_RESTRICT);
        break;
        }
      default:
        jj_la1[480] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
dropArgs.add(tk.image);
    }
if (dropArgs.size() > 0)
            drop.setParameters(dropArgs);
        return drop;
}

  final public Truncate Truncate() throws ParseException {Truncate truncate = new Truncate();
    Table table;
    jj_consume_token(K_TRUNCATE);
    jj_consume_token(K_TABLE);
    table = Table();
truncate.setTable(table); truncate.setCascade(false);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_CASCADE:{
      jj_consume_token(K_CASCADE);
truncate.setCascade(true);
      break;
      }
    default:
      jj_la1[481] = jj_gen;
      ;
    }
return truncate;
}

  final public AlterExpression.ColumnDataType AlterExpressionColumnDataType() throws ParseException {String columnName = null;
    boolean withType = false;
    ColDataType dataType = null;
    List<String> columnSpecs = null;
    List<String> parameter = null;
    columnName = RelObjectName();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_TYPE:{
      jj_consume_token(K_TYPE);
withType = true;
      break;
      }
    default:
      jj_la1[482] = jj_gen;
      ;
    }
    dataType = ColDataType();
columnSpecs = new ArrayList<String>();
    label_105:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ARRAY_LITERAL:
      case K_AS:
      case K_ASC:
      case K_BY:
      case K_CASCADE:
      case K_CHECK:
      case K_COLLATE:
      case K_COMMIT:
      case K_COMMENT:
      case K_CONSTRAINT:
      case K_DEFAULT:
      case K_DELETE:
      case K_DESC:
      case K_DROP:
      case K_EXCLUDE:
      case K_FALSE:
      case K_FOREIGN:
      case K_IN:
      case K_KEY:
      case K_NOT:
      case K_NULL:
      case K_ON:
      case K_PARALLEL:
      case K_PARTITION:
      case K_PRIMARY:
      case K_REFERENCES:
      case K_ROWS:
      case K_TABLESPACE:
      case K_TEMP:
      case K_TEMPORARY:
      case K_TIME_KEY_EXPR:
      case K_TRUE:
      case K_TYPE:
      case K_UNIQUE:
      case K_UPDATE:
      case K_USING:
      case K_UNSIGNED:
      case K_WHERE:
      case K_WITH:
      case S_DOUBLE:
      case S_LONG:
      case S_IDENTIFIER:
      case S_CHAR_LITERAL:
      case S_QUOTED_IDENTIFIER:
      case 325:
      case 327:
      case 333:
      case 345:
      case 363:{
        ;
        break;
        }
      default:
        jj_la1[483] = jj_gen;
        break label_105;
      }
      parameter = CreateParameter();
columnSpecs.addAll(parameter);
    }
return new AlterExpression.ColumnDataType(columnName, withType, dataType, columnSpecs);
}

  final public AlterExpression.ColumnDropNotNull AlterExpressionColumnDropNotNull() throws ParseException {String columnName = null;
    boolean withNot = false;
    ColDataType dataType = null;
    List<String> columnSpecs = null;
    List<String> parameter = null;
    columnName = RelObjectName();
    jj_consume_token(K_DROP);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_NOT:{
      jj_consume_token(K_NOT);
withNot = true;
      break;
      }
    default:
      jj_la1[484] = jj_gen;
      ;
    }
    jj_consume_token(K_NULL);
return new AlterExpression.ColumnDropNotNull(columnName, withNot);
}

  final public List<ConstraintState> AlterExpressionConstraintState() throws ParseException {List<ConstraintState> retval = new ArrayList<ConstraintState>();
    label_106:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_DEFERRABLE:
      case K_DISABLE:
      case K_ENABLE:
      case K_NOT:
      case K_NOVALIDATE:
      case K_VALIDATE:{
        ;
        break;
        }
      default:
        jj_la1[485] = jj_gen;
        break label_106;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_DEFERRABLE:{
        jj_consume_token(K_DEFERRABLE);
retval.add(new DeferrableConstraint(false));
        break;
        }
      case K_NOT:{
        jj_consume_token(K_NOT);
        jj_consume_token(K_DEFERRABLE);
retval.add(new DeferrableConstraint(true));
        break;
        }
      case K_VALIDATE:{
        jj_consume_token(K_VALIDATE);
retval.add(new ValidateConstraint(false));
        break;
        }
      case K_NOVALIDATE:{
        jj_consume_token(K_NOVALIDATE);
retval.add(new ValidateConstraint(true));
        break;
        }
      case K_ENABLE:{
        jj_consume_token(K_ENABLE);
retval.add(new EnableConstraint(false));
        break;
        }
      case K_DISABLE:{
        jj_consume_token(K_DISABLE);
retval.add(new EnableConstraint(true));
        break;
        }
      default:
        jj_la1[486] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
return retval;
}

/**
* This production needs refactoring to multiple smaller productions. The target class should
* be splitted as well.
*/
  final public AlterExpression AlterExpression() throws ParseException {AlterExpression alterExp = new AlterExpression();
    Token tk;
    Token tk2 = null;
    String sk3 = null;
    String sk4 = null;
    ColDataType dataType;
    List<String> columnNames = null;
    List<ConstraintState> constraints = null;
    ForeignKeyIndex fkIndex = null;
    Index index = null;
    Table fkTable = null;
    AlterExpression.ColumnDataType alterExpressionColumnDataType = null;
    AlterExpression.ColumnDropNotNull alterExpressionColumnDropNotNull = null;
    ReferentialAction.Action action = null;

    // for captureRest()
    List<String> tokens = new LinkedList<String>();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ADD:
    case K_ALTER:
    case K_MODIFY:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ADD:{
        jj_consume_token(K_ADD);
alterExp.setOperation(AlterOperation.ADD);
        break;
        }
      case K_ALTER:{
        jj_consume_token(K_ALTER);
alterExp.setOperation(AlterOperation.ALTER);
        break;
        }
      case K_MODIFY:{
        jj_consume_token(K_MODIFY);
alterExp.setOperation(AlterOperation.MODIFY);
        break;
        }
      default:
        jj_la1[487] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      if (jj_2_262(2)) {
        jj_consume_token(K_PRIMARY);
        jj_consume_token(K_KEY);
        columnNames = ColumnsNamesList();
alterExp.setPkColumns(columnNames);
        constraints = AlterExpressionConstraintState();
alterExp.setConstraints(constraints);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_USING:{
          jj_consume_token(K_USING);
          sk4 = RelObjectName();
alterExp.addParameters("USING", sk4);
          break;
          }
        default:
          jj_la1[488] = jj_gen;
          ;
        }
      } else if (jj_2_263(2)) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_KEY:{
          tk = jj_consume_token(K_KEY);
alterExp.setUk(true);
          break;
          }
        case K_INDEX:{
          tk = jj_consume_token(K_INDEX);
          break;
          }
        default:
          jj_la1[489] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        sk3 = RelObjectName();
        columnNames = ColumnsNamesList();
index = new Index().withType(tk.image).withName(sk3).withColumnsNames(columnNames);
                alterExp.setIndex(index);
        constraints = AlterExpressionConstraintState();
alterExp.setConstraints(constraints);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_USING:{
          jj_consume_token(K_USING);
          sk4 = RelObjectName();
alterExp.addParameters("USING", sk4);
          break;
          }
        default:
          jj_la1[490] = jj_gen;
          ;
        }
      } else if (jj_2_264(3)) {
        if (jj_2_256(2)) {
          jj_consume_token(K_COLUMN);
alterExp.hasColumn(true);
        } else {
          ;
        }
        if (jj_2_257(2)) {
          alterExpressionColumnDataType = AlterExpressionColumnDataType();
alterExp.addColDataType(alterExpressionColumnDataType);
        } else {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_ACTION:
          case K_ACTIVE:
          case K_ALGORITHM:
          case K_ARCHIVE:
          case K_ARRAY_LITERAL:
          case K_AT:
          case K_BYTE:
          case K_CASCADE:
          case K_CASE:
          case K_CAST:
          case K_TRY_CAST:
          case K_CHARACTER:
          case K_CHANGE:
          case K_CHECKPOINT:
          case K_CHAR:
          case K_COLUMN:
          case K_COLUMNS:
          case K_COMMIT:
          case K_COMMENT:
          case K_COSTS:
          case K_CREATE:
          case K_CYCLE:
          case K_DATETIMELITERAL:
          case K_DATE_LITERAL:
          case K_DBA_RECYCLEBIN:
          case K_DEFAULT:
          case K_DESC:
          case K_DESCRIBE:
          case K_DISABLE:
          case K_DISCONNECT:
          case K_DIV:
          case K_DO:
          case K_DUMP:
          case K_DUPLICATE:
          case K_ENABLE:
          case K_END:
          case K_EXCLUDE:
          case K_EXTRACT:
          case K_FILTER:
          case K_FIRST:
          case K_FALSE:
          case K_FLUSH:
          case K_FOLLOWING:
          case K_FORMAT:
          case K_FULLTEXT:
          case K_GROUP:
          case K_HISTORY:
          case K_INDEX:
          case K_INSERT:
          case K_INTERVAL:
          case K_ISNULL:
          case K_JSON:
          case K_KEY:
          case K_FN:
          case K_LAST:
          case K_LEADING:
          case K_LOCAL:
          case K_LINK:
          case K_LOG:
          case K_MATERIALIZED:
          case K_NEXTVAL:
          case K_NO:
          case K_NOLOCK:
          case K_NULLS:
          case K_OF:
          case K_ON:
          case K_OPEN:
          case K_ORDER:
          case K_OVER:
          case K_PARALLEL:
          case K_PARTITION:
          case K_PATH:
          case K_PERCENT:
          case K_PRECISION:
          case K_PRIMARY:
          case K_PRIOR:
          case K_QUERY:
          case K_QUIESCE:
          case K_RANGE:
          case K_READ:
          case K_RECYCLEBIN:
          case K_REGISTER:
          case K_REPLACE:
          case K_RESUME:
          case K_RESTRICTED:
          case K_ROW:
          case K_ROWS:
          case K_SCHEMA:
          case K_SEQUENCE:
          case K_SEPARATOR:
          case K_SESSION:
          case K_SHUTDOWN:
          case K_SIBLINGS:
          case K_SIZE:
          case K_SKIP:
          case K_START:
          case K_SUSPEND:
          case K_SWITCH:
          case K_SYNONYM:
          case K_SYSTEM:
          case K_TABLE:
          case K_TABLES:
          case K_TABLESPACE:
          case K_TEMP:
          case K_TEMPORARY:
          case K_TIMEOUT:
          case K_TO:
          case K_TOP:
          case K_TRUNCATE:
          case K_TRUE:
          case K_TYPE:
          case K_UNQIESCE:
          case K_USER:
          case K_SIGNED:
          case K_STRING_FUNCTION_NAME:
          case K_UNSIGNED:
          case K_VALIDATE:
          case K_VALUE:
          case K_VALUES:
          case K_VIEW:
          case K_XML:
          case K_ZONE:
          case S_IDENTIFIER:
          case S_QUOTED_IDENTIFIER:{
            alterExpressionColumnDropNotNull = AlterExpressionColumnDropNotNull();
alterExp.addColDropNotNull( alterExpressionColumnDropNotNull);
            break;
            }
          default:
            jj_la1[491] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 325:{
          jj_consume_token(325);
          alterExpressionColumnDataType = AlterExpressionColumnDataType();
alterExp.addColDataType(alterExpressionColumnDataType);
          label_107:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_COMMA:{
              ;
              break;
              }
            default:
              jj_la1[492] = jj_gen;
              break label_107;
            }
            jj_consume_token(K_COMMA);
            alterExpressionColumnDataType = AlterExpressionColumnDataType();
alterExp.addColDataType(alterExpressionColumnDataType);
          }
          jj_consume_token(326);
          break;
          }
        case K_UNIQUE:{
          jj_consume_token(K_UNIQUE);
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_INDEX:
          case K_KEY:{
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_KEY:{
              jj_consume_token(K_KEY);
alterExp.setUk(true);
              break;
              }
            case K_INDEX:{
              jj_consume_token(K_INDEX);
              break;
              }
            default:
              jj_la1[493] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case S_IDENTIFIER:{
              tk = jj_consume_token(S_IDENTIFIER);
              break;
              }
            case S_QUOTED_IDENTIFIER:{
              tk = jj_consume_token(S_QUOTED_IDENTIFIER);
              break;
              }
            default:
              jj_la1[494] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
alterExp.setUkName(tk.image);
            break;
            }
          default:
            jj_la1[495] = jj_gen;
            ;
          }
          columnNames = ColumnsNamesList();
alterExp.setUkColumns(columnNames);
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_USING:{
            jj_consume_token(K_USING);
            sk4 = RelObjectName();
alterExp.addParameters("USING", sk4);
            break;
            }
          default:
            jj_la1[496] = jj_gen;
            ;
          }
          break;
          }
        case K_FOREIGN:{
          jj_consume_token(K_FOREIGN);
          jj_consume_token(K_KEY);
          columnNames = ColumnsNamesList();
alterExp.setFkColumns(columnNames); columnNames = null;
          jj_consume_token(K_REFERENCES);
          fkTable = Table();
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case 325:{
            columnNames = ColumnsNamesList();
            break;
            }
          default:
            jj_la1[497] = jj_gen;
            ;
          }
alterExp.setFkSourceSchema(fkTable.getSchemaName());
                        alterExp.setFkSourceTable(fkTable.getName());
                        alterExp.setFkSourceColumns(columnNames);
          if (jj_2_258(2)) {
            jj_consume_token(K_ON);
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_DELETE:{
              tk = jj_consume_token(K_DELETE);
              break;
              }
            case K_UPDATE:{
              tk = jj_consume_token(K_UPDATE);
              break;
              }
            default:
              jj_la1[498] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
            action = Action();
alterExp.setReferentialAction(ReferentialAction.Type.valueOf(tk.image), action);
          } else {
            ;
          }
          if (jj_2_259(2)) {
            jj_consume_token(K_ON);
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_DELETE:{
              tk = jj_consume_token(K_DELETE);
              break;
              }
            case K_UPDATE:{
              tk = jj_consume_token(K_UPDATE);
              break;
              }
            default:
              jj_la1[499] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
            action = Action();
alterExp.setReferentialAction(ReferentialAction.Type.valueOf(tk.image), action);
          } else {
            ;
          }
          break;
          }
        case K_CONSTRAINT:{
          jj_consume_token(K_CONSTRAINT);
          sk3 = RelObjectName();
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_FOREIGN:{
            tk = jj_consume_token(K_FOREIGN);
            tk2 = jj_consume_token(K_KEY);
            columnNames = ColumnsNamesList();
fkIndex = new ForeignKeyIndex()
                        .withName(sk3)
                        .withType(tk.image + " " + tk2.image)
                        .withColumnsNames(columnNames);
                                            columnNames = null;
            jj_consume_token(K_REFERENCES);
            fkTable = Table();
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case 325:{
              columnNames = ColumnsNamesList();
              break;
              }
            default:
              jj_la1[500] = jj_gen;
              ;
            }
fkIndex.withTable(fkTable).withReferencedColumnNames(columnNames);
                        alterExp.setIndex(fkIndex);
            if (jj_2_260(2)) {
              jj_consume_token(K_ON);
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case K_DELETE:{
                tk = jj_consume_token(K_DELETE);
                break;
                }
              case K_UPDATE:{
                tk = jj_consume_token(K_UPDATE);
                break;
                }
              default:
                jj_la1[501] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
              }
              action = Action();
fkIndex.setReferentialAction(ReferentialAction.Type.valueOf(tk.image), action);
            } else {
              ;
            }
            if (jj_2_261(2)) {
              jj_consume_token(K_ON);
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case K_DELETE:{
                tk = jj_consume_token(K_DELETE);
                break;
                }
              case K_UPDATE:{
                tk = jj_consume_token(K_UPDATE);
                break;
                }
              default:
                jj_la1[502] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
              }
              action = Action();
fkIndex.setReferentialAction(ReferentialAction.Type.valueOf(tk.image), action);
            } else {
              ;
            }
            constraints = AlterExpressionConstraintState();
alterExp.setConstraints(constraints);
            break;
            }
          case K_PRIMARY:{
            tk = jj_consume_token(K_PRIMARY);
            tk2 = jj_consume_token(K_KEY);
            columnNames = ColumnsNamesList();
index = new NamedConstraint()
                        .withName(sk3)
                        .withType(tk.image + " " + tk2.image)
                        .withColumnsNames(columnNames);
                        alterExp.setIndex(index);
            constraints = AlterExpressionConstraintState();
alterExp.setConstraints(constraints);
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_USING:{
              jj_consume_token(K_USING);
              sk4 = RelObjectName();
alterExp.addParameters("USING", sk4);
              break;
              }
            default:
              jj_la1[503] = jj_gen;
              ;
            }
            break;
            }
          case K_CHECK:{
            jj_consume_token(K_CHECK);
Expression exp = null;
            label_108:
            while (true) {
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case 325:{
                ;
                break;
                }
              default:
                jj_la1[504] = jj_gen;
                break label_108;
              }
              jj_consume_token(325);
              exp = Expression();
              jj_consume_token(326);
            }
CheckConstraint checkCs = new CheckConstraint().withName(sk3).withExpression(exp);
                    alterExp.setIndex(checkCs);
            break;
            }
          case K_UNIQUE:{
            tk = jj_consume_token(K_UNIQUE);
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_INDEX:
            case K_KEY:{
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case K_KEY:{
                tk2 = jj_consume_token(K_KEY);
alterExp.setUk(true);
                break;
                }
              case K_INDEX:{
                tk2 = jj_consume_token(K_INDEX);
                break;
                }
              default:
                jj_la1[505] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
              }
              break;
              }
            default:
              jj_la1[506] = jj_gen;
              ;
            }
            columnNames = ColumnsNamesList();
index = new NamedConstraint()
                            .withName(sk3)
                                .withType(tk.image + (tk2!=null?" " + tk2.image:""))
                                .withColumnsNames(columnNames);
                          alterExp.setIndex(index);
            constraints = AlterExpressionConstraintState();
alterExp.setConstraints(constraints);
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case K_USING:{
              jj_consume_token(K_USING);
              sk4 = RelObjectName();
alterExp.addParameters("USING", sk4);
              break;
              }
            default:
              jj_la1[507] = jj_gen;
              ;
            }
            break;
            }
          case K_KEY:{
            tk = jj_consume_token(K_KEY);
            columnNames = ColumnsNamesList();
index = new NamedConstraint()
                                .withName(sk3)
                                .withType(tk.image)
                                                        .withColumnsNames(columnNames);
                          alterExp.setIndex(index);
            constraints = AlterExpressionConstraintState();
alterExp.setConstraints(constraints);
            break;
            }
          default:
            jj_la1[508] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          break;
          }
        case K_ACTION:
        case K_ACTIVE:
        case K_ALGORITHM:
        case K_ARCHIVE:
        case K_ARRAY_LITERAL:
        case K_AT:
        case K_BYTE:
        case K_CASCADE:
        case K_CASE:
        case K_CAST:
        case K_TRY_CAST:
        case K_CHARACTER:
        case K_CHANGE:
        case K_CHECKPOINT:
        case K_CHAR:
        case K_COLUMN:
        case K_COLUMNS:
        case K_COMMIT:
        case K_COMMENT:
        case K_COSTS:
        case K_CREATE:
        case K_CYCLE:
        case K_DATETIMELITERAL:
        case K_DATE_LITERAL:
        case K_DBA_RECYCLEBIN:
        case K_DEFAULT:
        case K_DESC:
        case K_DESCRIBE:
        case K_DISABLE:
        case K_DISCONNECT:
        case K_DIV:
        case K_DO:
        case K_DUMP:
        case K_DUPLICATE:
        case K_ENABLE:
        case K_END:
        case K_EXCLUDE:
        case K_EXTRACT:
        case K_FILTER:
        case K_FIRST:
        case K_FALSE:
        case K_FLUSH:
        case K_FOLLOWING:
        case K_FORMAT:
        case K_FULLTEXT:
        case K_GROUP:
        case K_HISTORY:
        case K_INDEX:
        case K_INSERT:
        case K_INTERVAL:
        case K_ISNULL:
        case K_JSON:
        case K_KEY:
        case K_FN:
        case K_LAST:
        case K_LEADING:
        case K_LOCAL:
        case K_LINK:
        case K_LOG:
        case K_MATERIALIZED:
        case K_NEXTVAL:
        case K_NO:
        case K_NOLOCK:
        case K_NULLS:
        case K_OF:
        case K_ON:
        case K_OPEN:
        case K_ORDER:
        case K_OVER:
        case K_PARALLEL:
        case K_PARTITION:
        case K_PATH:
        case K_PERCENT:
        case K_PRECISION:
        case K_PRIMARY:
        case K_PRIOR:
        case K_QUERY:
        case K_QUIESCE:
        case K_RANGE:
        case K_READ:
        case K_RECYCLEBIN:
        case K_REGISTER:
        case K_REPLACE:
        case K_RESUME:
        case K_RESTRICTED:
        case K_ROW:
        case K_ROWS:
        case K_SCHEMA:
        case K_SEQUENCE:
        case K_SEPARATOR:
        case K_SESSION:
        case K_SHUTDOWN:
        case K_SIBLINGS:
        case K_SIZE:
        case K_SKIP:
        case K_START:
        case K_SUSPEND:
        case K_SWITCH:
        case K_SYNONYM:
        case K_SYSTEM:
        case K_TABLE:
        case K_TABLES:
        case K_TABLESPACE:
        case K_TEMP:
        case K_TEMPORARY:
        case K_TIMEOUT:
        case K_TO:
        case K_TOP:
        case K_TRUNCATE:
        case K_TRUE:
        case K_TYPE:
        case K_UNQIESCE:
        case K_USER:
        case K_SIGNED:
        case K_STRING_FUNCTION_NAME:
        case K_UNSIGNED:
        case K_VALIDATE:
        case K_VALUE:
        case K_VALUES:
        case K_VIEW:
        case K_XML:
        case K_ZONE:
        case S_IDENTIFIER:
        case S_QUOTED_IDENTIFIER:{
          sk3 = RelObjectName();
          jj_consume_token(K_COMMENT);
          tk = jj_consume_token(S_CHAR_LITERAL);
alterExp.withColumnName(sk3).withCommentText(tk.image);
          break;
          }
        default:
          jj_la1[509] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      break;
      }
    case K_CHANGE:{
      jj_consume_token(K_CHANGE);
alterExp.setOperation(AlterOperation.CHANGE);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COLUMN:{
        jj_consume_token(K_COLUMN);
alterExp.hasColumn(true); alterExp.setOptionalSpecifier("COLUMN");
        break;
        }
      default:
        jj_la1[510] = jj_gen;

      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S_IDENTIFIER:{
        tk = jj_consume_token(S_IDENTIFIER);
        break;
        }
      case S_QUOTED_IDENTIFIER:{
        tk = jj_consume_token(S_QUOTED_IDENTIFIER);
        break;
        }
      default:
        jj_la1[511] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      alterExpressionColumnDataType = AlterExpressionColumnDataType();
alterExp.withColumnOldName(tk.image).addColDataType(alterExpressionColumnDataType);
      break;
      }
    case K_DROP:{
      jj_consume_token(K_DROP);
alterExp.setOperation(AlterOperation.DROP);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COLUMN:
      case S_IDENTIFIER:
      case S_QUOTED_IDENTIFIER:
      case 325:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 325:{
          // we use the PK Columns Field instead of the Column Field
                              // for holding multiple DROP Columns
                              columnNames = ColumnsNamesList();
alterExp.setPkColumns(columnNames); columnNames = null;
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case 374:{
            jj_consume_token(374);
alterExp.addParameters("INVALIDATE");
            break;
            }
          default:
            jj_la1[512] = jj_gen;
            ;
          }
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_CASCADE:{
            jj_consume_token(K_CASCADE);
alterExp.addParameters("CASCADE");
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case 375:{
              jj_consume_token(375);
alterExp.addParameters("CONSTRAINTS");
              break;
              }
            default:
              jj_la1[513] = jj_gen;
              ;
            }
            break;
            }
          default:
            jj_la1[514] = jj_gen;
            ;
          }
          break;
          }
        case K_COLUMN:
        case S_IDENTIFIER:
        case S_QUOTED_IDENTIFIER:{
          if (jj_2_265(2)) {
            jj_consume_token(K_COLUMN);
alterExp.hasColumn(true);
          } else {
            ;
          }
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case S_IDENTIFIER:{
            tk = jj_consume_token(S_IDENTIFIER);
            break;
            }
          case S_QUOTED_IDENTIFIER:{
            tk = jj_consume_token(S_QUOTED_IDENTIFIER);
            break;
            }
          default:
            jj_la1[515] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
alterExp.setColumnName(tk.image);
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case 374:{
            jj_consume_token(374);
alterExp.addParameters("INVALIDATE");
            break;
            }
          default:
            jj_la1[516] = jj_gen;
            ;
          }
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_CASCADE:{
            jj_consume_token(K_CASCADE);
alterExp.addParameters("CASCADE");
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case 375:{
              jj_consume_token(375);
alterExp.addParameters("CONSTRAINTS");
              break;
              }
            default:
              jj_la1[517] = jj_gen;
              ;
            }
            break;
            }
          default:
            jj_la1[518] = jj_gen;
            ;
          }
          break;
          }
        default:
          jj_la1[519] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      case K_INDEX:{
        tk = jj_consume_token(K_INDEX);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S_IDENTIFIER:{
          tk2 = jj_consume_token(S_IDENTIFIER);
          break;
          }
        case S_QUOTED_IDENTIFIER:{
          tk2 = jj_consume_token(S_QUOTED_IDENTIFIER);
          break;
          }
        default:
          jj_la1[520] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
index = new Index().withType(tk.image).withName(tk2.image);
                       alterExp.setIndex(index);
        break;
        }
      case K_UNIQUE:{
        tk = jj_consume_token(K_UNIQUE);
alterExp.setOperation(AlterOperation.DROP_UNIQUE);
        columnNames = ColumnsNamesList();
alterExp.setPkColumns(columnNames); columnNames = null;
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_CASCADE:
        case K_RESTRICT:{
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_CASCADE:{
            tk = jj_consume_token(K_CASCADE);
            break;
            }
          case K_RESTRICT:{
            tk = jj_consume_token(K_RESTRICT);
            break;
            }
          default:
            jj_la1[521] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
alterExp.addParameters(tk.image);
          break;
          }
        default:
          jj_la1[522] = jj_gen;
          ;
        }
        break;
        }
      case K_PRIMARY:{
        tk = jj_consume_token(K_PRIMARY);
        tk2 = jj_consume_token(K_KEY);
alterExp.setOperation(AlterOperation.DROP_PRIMARY_KEY);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_CASCADE:
        case K_RESTRICT:{
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_CASCADE:{
            tk = jj_consume_token(K_CASCADE);
            break;
            }
          case K_RESTRICT:{
            tk = jj_consume_token(K_RESTRICT);
            break;
            }
          default:
            jj_la1[523] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
alterExp.addParameters(tk.image);
          break;
          }
        default:
          jj_la1[524] = jj_gen;
          ;
        }
        break;
        }
      case K_FOREIGN:{
        tk = jj_consume_token(K_FOREIGN);
        tk2 = jj_consume_token(K_KEY);
alterExp.setOperation(AlterOperation.DROP_FOREIGN_KEY);
        columnNames = ColumnsNamesList();
alterExp.setPkColumns(columnNames); columnNames = null;
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_CASCADE:
        case K_RESTRICT:{
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_CASCADE:{
            tk = jj_consume_token(K_CASCADE);
            break;
            }
          case K_RESTRICT:{
            tk = jj_consume_token(K_RESTRICT);
            break;
            }
          default:
            jj_la1[525] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
alterExp.addParameters(tk.image);
          break;
          }
        default:
          jj_la1[526] = jj_gen;
          ;
        }
        break;
        }
      case K_CONSTRAINT:{
        jj_consume_token(K_CONSTRAINT);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_IF:{
          jj_consume_token(K_IF);
          jj_consume_token(K_EXISTS);
alterExp.setUsingIfExists(true);
          break;
          }
        default:
          jj_la1[527] = jj_gen;
          ;
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S_IDENTIFIER:{
          tk = jj_consume_token(S_IDENTIFIER);
          break;
          }
        case S_QUOTED_IDENTIFIER:{
          tk = jj_consume_token(S_QUOTED_IDENTIFIER);
          break;
          }
        default:
          jj_la1[528] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
alterExp.setConstraintName(tk.image);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_CASCADE:
        case K_RESTRICT:{
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_CASCADE:{
            tk = jj_consume_token(K_CASCADE);
            break;
            }
          case K_RESTRICT:{
            tk = jj_consume_token(K_RESTRICT);
            break;
            }
          default:
            jj_la1[529] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
alterExp.addParameters(tk.image);
          break;
          }
        default:
          jj_la1[530] = jj_gen;
          ;
        }
        break;
        }
      default:
        jj_la1[531] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    case K_ALGORITHM:{
      jj_consume_token(K_ALGORITHM);
alterExp.setOperation(AlterOperation.ALGORITHM);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 327:{
        jj_consume_token(327);
alterExp.setUseEqual(true);
        break;
        }
      default:
        jj_la1[532] = jj_gen;
        ;
      }
      sk3 = RelObjectName();
alterExp.addParameters(sk3);
      break;
      }
    default:
      jj_la1[536] = jj_gen;
      if (jj_2_266(2)) {
        jj_consume_token(K_RENAME);
        jj_consume_token(K_COLUMN);
alterExp.setOperation(AlterOperation.RENAME); alterExp.hasColumn(true);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S_IDENTIFIER:{
          tk = jj_consume_token(S_IDENTIFIER);
          break;
          }
        case S_QUOTED_IDENTIFIER:{
          tk = jj_consume_token(S_QUOTED_IDENTIFIER);
          break;
          }
        default:
          jj_la1[533] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
alterExp.setColOldName(tk.image);
        jj_consume_token(K_TO);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S_IDENTIFIER:{
          tk2 = jj_consume_token(S_IDENTIFIER);
          break;
          }
        case S_QUOTED_IDENTIFIER:{
          tk2 = jj_consume_token(S_QUOTED_IDENTIFIER);
          break;
          }
        default:
          jj_la1[534] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
alterExp.setColumnName(tk2.image);
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_RENAME:{
          jj_consume_token(K_RENAME);
          jj_consume_token(K_TO);
alterExp.setOperation(AlterOperation.RENAME_TABLE);
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case S_IDENTIFIER:{
            tk2 = jj_consume_token(S_IDENTIFIER);
            break;
            }
          case S_QUOTED_IDENTIFIER:{
            tk2 = jj_consume_token(S_QUOTED_IDENTIFIER);
            break;
            }
          default:
            jj_la1[535] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
alterExp.setNewTableName(tk2.image);
          break;
          }
        case K_COMMENT:{
          jj_consume_token(K_COMMENT);
alterExp.setOperation(AlterOperation.COMMENT);
          tk = jj_consume_token(S_CHAR_LITERAL);
alterExp.setCommentText(tk.image);
          break;
          }
        default:
          jj_la1[537] = jj_gen;
          tokens = captureRest();
alterExp.setOperation(AlterOperation.UNSPECIFIC);
                    StringBuilder optionalSpecifier = new StringBuilder();
                    int i=0;

                    for (String s: tokens)
                        if (!s.equals(";")) {
                            if (i>0)
                                optionalSpecifier.append( " " );
                            optionalSpecifier.append( s );
                            i++;
                        }

                    alterExp.setOptionalSpecifier( optionalSpecifier.toString() );
        }
      }
    }
return alterExp;
}

  final public Alter AlterTable() throws ParseException {Alter alter = new Alter();
    Table table;
    AlterExpression alterExp;
    boolean usingIfExists = false;
    jj_consume_token(K_ALTER);
    jj_consume_token(K_TABLE);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ONLY:{
      jj_consume_token(K_ONLY);
alter.setUseOnly(true);
      break;
      }
    default:
      jj_la1[538] = jj_gen;
      ;
    }
    if (jj_2_267(2)) {
      jj_consume_token(K_IF);
      jj_consume_token(K_EXISTS);
usingIfExists = true;
    } else {
      ;
    }
    table = Table();
alter.setTable(table);
    alterExp = AlterExpression();
if (usingIfExists)
                                    alter.addAlterExpression( alterExp.withUsingIfExists(true) );
                                  else
                                    alter.addAlterExpression(alterExp);
    label_109:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COMMA:{
        ;
        break;
        }
      default:
        jj_la1[539] = jj_gen;
        break label_109;
      }
      jj_consume_token(K_COMMA);
      alterExp = AlterExpression();
alter.addAlterExpression(alterExp);
    }
return alter;
}

  final public AlterSession AlterSession() throws ParseException {AlterSessionOperation operation = null;
    List<String> parameters = new ArrayList<String>();
    Token token;
    jj_consume_token(K_ALTER);
    jj_consume_token(K_SESSION);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ADVISE:{
      jj_consume_token(K_ADVISE);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COMMIT:{
        jj_consume_token(K_COMMIT);
operation = AlterSessionOperation.ADVISE_COMMIT;
        break;
        }
      case K_ROLLBACK:{
        jj_consume_token(K_ROLLBACK);
operation = AlterSessionOperation.ADVISE_ROLLBACK;
        break;
        }
      case K_NOTHING:{
        jj_consume_token(K_NOTHING);
operation = AlterSessionOperation.ADVISE_NOTHING;
        break;
        }
      default:
        jj_la1[540] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    case K_CLOSE:{
      jj_consume_token(K_CLOSE);
      jj_consume_token(K_DATABASE);
      jj_consume_token(K_LINK);
operation = AlterSessionOperation.CLOSE_DATABASE_LINK;
      break;
      }
    case K_ENABLE:{
      jj_consume_token(K_ENABLE);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COMMIT:{
        jj_consume_token(K_COMMIT);
        jj_consume_token(K_IN);
        jj_consume_token(K_PROCEDURE);
operation = AlterSessionOperation.ENABLE_COMMIT_IN_PROCEDURE;
        break;
        }
      case K_GUARD:{
        jj_consume_token(K_GUARD);
operation = AlterSessionOperation.ENABLE_GUARD;
        break;
        }
      case K_PARALLEL:{
        jj_consume_token(K_PARALLEL);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_DML:{
          jj_consume_token(K_DML);
operation = AlterSessionOperation.ENABLE_PARALLEL_DML;
          break;
          }
        case K_DDL:{
          jj_consume_token(K_DDL);
operation = AlterSessionOperation.ENABLE_PARALLEL_DDL;
          break;
          }
        case K_QUERY:{
          jj_consume_token(K_QUERY);
operation = AlterSessionOperation.ENABLE_PARALLEL_QUERY;
          break;
          }
        default:
          jj_la1[541] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      case K_RESUMABLE:{
        jj_consume_token(K_RESUMABLE);
operation = AlterSessionOperation.ENABLE_RESUMABLE;
        break;
        }
      default:
        jj_la1[542] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    case K_DISABLE:{
      jj_consume_token(K_DISABLE);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COMMIT:{
        jj_consume_token(K_COMMIT);
        jj_consume_token(K_IN);
        jj_consume_token(K_PROCEDURE);
operation = AlterSessionOperation.DISABLE_COMMIT_IN_PROCEDURE;
        break;
        }
      case K_GUARD:{
        jj_consume_token(K_GUARD);
operation = AlterSessionOperation.DISABLE_GUARD;
        break;
        }
      case K_PARALLEL:{
        jj_consume_token(K_PARALLEL);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_DML:{
          jj_consume_token(K_DML);
operation = AlterSessionOperation.DISABLE_PARALLEL_DML;
          break;
          }
        case K_DDL:{
          jj_consume_token(K_DDL);
operation = AlterSessionOperation.DISABLE_PARALLEL_DDL;
          break;
          }
        case K_QUERY:{
          jj_consume_token(K_QUERY);
operation = AlterSessionOperation.DISABLE_PARALLEL_QUERY;
          break;
          }
        default:
          jj_la1[543] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      case K_RESUMABLE:{
        jj_consume_token(K_RESUMABLE);
operation = AlterSessionOperation.DISABLE_RESUMABLE;
        break;
        }
      default:
        jj_la1[544] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    case K_FORCE:{
      jj_consume_token(K_FORCE);
      jj_consume_token(K_PARALLEL);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_DML:{
        jj_consume_token(K_DML);
operation = AlterSessionOperation.FORCE_PARALLEL_DML;
        break;
        }
      case K_DDL:{
        jj_consume_token(K_DDL);
operation = AlterSessionOperation.FORCE_PARALLEL_DDL;
        break;
        }
      case K_QUERY:{
        jj_consume_token(K_QUERY);
operation = AlterSessionOperation.FORCE_PARALLEL_QUERY;
        break;
        }
      default:
        jj_la1[545] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    case K_SET:{
      jj_consume_token(K_SET);
operation = AlterSessionOperation.SET;
      break;
      }
    default:
      jj_la1[546] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    label_110:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_PARALLEL:
      case S_LONG:
      case S_IDENTIFIER:
      case S_CHAR_LITERAL:
      case 327:{
        ;
        break;
        }
      default:
        jj_la1[547] = jj_gen;
        break label_110;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S_CHAR_LITERAL:{
        token = jj_consume_token(S_CHAR_LITERAL);
        break;
        }
      case S_IDENTIFIER:{
        token = jj_consume_token(S_IDENTIFIER);
        break;
        }
      case 327:{
        token = jj_consume_token(327);
        break;
        }
      case S_LONG:{
        token = jj_consume_token(S_LONG);
        break;
        }
      case K_PARALLEL:{
        token = jj_consume_token(K_PARALLEL);
        break;
        }
      default:
        jj_la1[548] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
parameters.add( token.image );
    }
return new AlterSession(operation, parameters);
}

  final public AlterSystemStatement AlterSystemStatement() throws ParseException {AlterSystemOperation operation = null;
    List<String> parameters = new LinkedList<String>();
    jj_consume_token(K_ALTER);
    jj_consume_token(K_SYSTEM);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ARCHIVE:{
      jj_consume_token(K_ARCHIVE);
      jj_consume_token(K_LOG);
operation = AlterSystemOperation.ARCHIVE_LOG;
      break;
      }
    case K_CHECKPOINT:{
      jj_consume_token(K_CHECKPOINT);
operation = AlterSystemOperation.CHECKPOINT;
      break;
      }
    case K_DUMP:{
      jj_consume_token(K_DUMP);
      jj_consume_token(K_ACTIVE);
      jj_consume_token(K_SESSION);
      jj_consume_token(K_HISTORY);
operation = AlterSystemOperation.DUMP_ACTIVE_SESSION_HISTORY;
      break;
      }
    case K_ENABLE:{
      jj_consume_token(K_ENABLE);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 376:{
        jj_consume_token(376);
operation = AlterSystemOperation.ENABLE_DISTRIBUTED_RECOVERY;
        break;
        }
      case 377:{
        jj_consume_token(377);
operation = AlterSystemOperation.ENABLE_DISTRIBUTED_RECOVERY;
        break;
        }
      default:
        jj_la1[549] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    case K_DISABLE:{
      jj_consume_token(K_DISABLE);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 376:{
        jj_consume_token(376);
operation = AlterSystemOperation.DISABLE_DISTRIBUTED_RECOVERY;
        break;
        }
      case 377:{
        jj_consume_token(377);
operation = AlterSystemOperation.DISABLE_RESTRICTED_SESSION;
        break;
        }
      default:
        jj_la1[550] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    case K_FLUSH:{
      jj_consume_token(K_FLUSH);
operation = AlterSystemOperation.FLUSH;
      break;
      }
    case K_DISCONNECT:{
      jj_consume_token(K_DISCONNECT);
      jj_consume_token(K_SESSION);
operation = AlterSystemOperation.DISCONNECT_SESSION;
      break;
      }
    case 378:{
      jj_consume_token(378);
operation = AlterSystemOperation.DISCONNECT_SESSION;
      break;
      }
    case 379:{
      jj_consume_token(379);
operation = AlterSystemOperation.KILL_SESSION;
      break;
      }
    case K_SWITCH:{
      jj_consume_token(K_SWITCH);
operation = AlterSystemOperation.SWITCH;
      break;
      }
    case K_SUSPEND:{
      jj_consume_token(K_SUSPEND);
operation = AlterSystemOperation.SUSPEND;
      break;
      }
    case K_RESUME:{
      jj_consume_token(K_RESUME);
operation = AlterSystemOperation.RESUME;
      break;
      }
    case K_QUIESCE:{
      jj_consume_token(K_QUIESCE);
      jj_consume_token(K_RESTRICTED);
operation = AlterSystemOperation.QUIESCE;
      break;
      }
    case 380:{
      jj_consume_token(380);
operation = AlterSystemOperation.UNQUIESCE;
      break;
      }
    case K_SHUTDOWN:{
      jj_consume_token(K_SHUTDOWN);
operation = AlterSystemOperation.SHUTDOWN;
      break;
      }
    case K_REGISTER:{
      jj_consume_token(K_REGISTER);
operation = AlterSystemOperation.REGISTER;
      break;
      }
    case K_SET:{
      jj_consume_token(K_SET);
operation = AlterSystemOperation.SET;
      break;
      }
    case K_RESET:{
      jj_consume_token(K_RESET);
operation = AlterSystemOperation.RESET;
      break;
      }
    default:
      jj_la1[551] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    parameters = captureRest();
return new AlterSystemStatement(operation, parameters);
}

  final public Wait Wait() throws ParseException {Wait wait = new Wait();
    Token token = null;
    jj_consume_token(K_WAIT);
    token = jj_consume_token(S_LONG);
wait.setTimeout(Long.parseLong(token.image));
return wait;
}

  final public SavepointStatement SavepointStatement() throws ParseException {SavepointStatement savepointStatement;
    jj_consume_token(K_SAVEPOINT);
    token = jj_consume_token(S_IDENTIFIER);
savepointStatement = new SavepointStatement(token.image);
return savepointStatement;
}

  final public RollbackStatement RollbackStatement() throws ParseException {RollbackStatement rollbackStatement;
    boolean usingWorkKeyword=false;
    boolean usingSavepointKeyword=false;
    String savepointName=null;
    String forceDistributedTransactionIdentifier=null;
    jj_consume_token(K_ROLLBACK);
rollbackStatement = new RollbackStatement();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_WORK:{
      jj_consume_token(K_WORK);
rollbackStatement.setUsingWorkKeyword(true);
      break;
      }
    default:
      jj_la1[552] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_FORCE:
    case K_TO:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_TO:{
        jj_consume_token(K_TO);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_SAVEPOINT:{
          jj_consume_token(K_SAVEPOINT);
rollbackStatement.setUsingSavepointKeyword(true);
          break;
          }
        default:
          jj_la1[553] = jj_gen;
          ;
        }
        token = jj_consume_token(S_IDENTIFIER);
rollbackStatement.setSavepointName(token.image);
        break;
        }
      case K_FORCE:{
        jj_consume_token(K_FORCE);
        token = jj_consume_token(S_CHAR_LITERAL);
rollbackStatement.setForceDistributedTransactionIdentifier(token.image);
        break;
        }
      default:
        jj_la1[554] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[555] = jj_gen;
      ;
    }
return rollbackStatement;
}

  final public Commit Commit() throws ParseException {Commit commit=new Commit();
    jj_consume_token(K_COMMIT);
return commit;
}

  final public Comment Comment() throws ParseException {
      Comment result = new Comment();
    Table table;
    Table view;
    Column column;
    Token comment;
    jj_consume_token(K_COMMENT);
    jj_consume_token(K_ON);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_TABLE:{
      jj_consume_token(K_TABLE);
      table = Table();
result.setTable(table);
      break;
      }
    case K_COLUMN:{
      jj_consume_token(K_COLUMN);
      column = Column();
result.setColumn(column);
      break;
      }
    case K_VIEW:{
      jj_consume_token(K_VIEW);
      view = Table();
result.setView(view);
      break;
      }
    default:
      jj_la1[556] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(K_IS);
    comment = jj_consume_token(S_CHAR_LITERAL);
result.setComment(new StringValue(comment.image));
return result;
}

  final public Grant Grant() throws ParseException {Grant grant = new Grant();
        ArrayList<String> privileges = new ArrayList<String>();
        List<String> users;
        Token tk = null;
        List<String> objName;
    jj_consume_token(K_GRANT);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_ALTER:
    case K_DELETE:
    case K_DROP:
    case K_EXECUTE:
    case K_INSERT:
    case K_ON:
    case K_SELECT:
    case K_UPDATE:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_ALTER:
      case K_DELETE:
      case K_DROP:
      case K_EXECUTE:
      case K_INSERT:
      case K_SELECT:
      case K_UPDATE:{
        readGrantTypes(privileges);
        label_111:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case K_COMMA:{
            ;
            break;
            }
          default:
            jj_la1[557] = jj_gen;
            break label_111;
          }
          jj_consume_token(K_COMMA);
          readGrantTypes(privileges);
        }
        break;
        }
      default:
        jj_la1[558] = jj_gen;
        ;
      }
      jj_consume_token(K_ON);
      objName = RelObjectNameList();
grant.setObjectName(objName);
      break;
      }
    case S_IDENTIFIER:{
      tk = jj_consume_token(S_IDENTIFIER);
grant.setRole(tk.image);
      break;
      }
    default:
      jj_la1[559] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(K_TO);
    users = UsersList();
grant.setUsers(users);
if(privileges.size() > 0) {
                grant.setPrivileges(privileges);
            }
                return grant;
}

  final public List<String> UsersList() throws ParseException {List<String> users = new ArrayList<String>();
    String user = null;
    user = RelObjectName();
users.add(user);
    label_112:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_COMMA:{
        ;
        break;
        }
      default:
        jj_la1[560] = jj_gen;
        break label_112;
      }
      jj_consume_token(K_COMMA);
      user = ColumnsNamesListItem();
users.add(user);
    }
return users;
}

  final public void readGrantTypes(ArrayList<String> privileges) throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_SELECT:{
      jj_consume_token(K_SELECT);
privileges.add("SELECT");
      break;
      }
    case K_INSERT:{
      jj_consume_token(K_INSERT);
privileges.add("INSERT");
      break;
      }
    case K_UPDATE:{
      jj_consume_token(K_UPDATE);
privileges.add("UPDATE");
      break;
      }
    case K_DELETE:{
      jj_consume_token(K_DELETE);
privileges.add("DELETE");
      break;
      }
    case K_EXECUTE:{
      jj_consume_token(K_EXECUTE);
privileges.add("EXECUTE");
      break;
      }
    case K_ALTER:{
      jj_consume_token(K_ALTER);
privileges.add("ALTER");
      break;
      }
    case K_DROP:{
      jj_consume_token(K_DROP);
privileges.add("DROP");
      break;
      }
    default:
      jj_la1[561] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
}

  final public Sequence Sequence() throws ParseException {/*@bgen(jjtree) Sequence */
    SimpleNode jjtn000 = new SimpleNode(JJTSEQUENCE);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));List<String> data = new ArrayList<String>();
    String serverName = null, databaseName = null, schemaName = null, sequenceName = null;
    try {
      data = RelObjectNameList();
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
Sequence sequence = new Sequence(data);
                linkAST(sequence,jjtn000);
        return sequence;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return com.javaoffers.thrid.sqlparse.statement in function");
}

  final public List<Sequence.Parameter> SequenceParameters() throws ParseException {List<Sequence.Parameter> sequenceParameters = new ArrayList<Sequence.Parameter>();
  Sequence.Parameter parameter = null;
  Token token = null;
    label_113:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_CACHE:
      case K_CYCLE:
      case K_GLOBAL:
      case K_INCREMENT:
      case K_KEEP:
      case K_MAXVALUE:
      case K_MINVALUE:
      case K_NOCACHE:
      case K_NOCYCLE:
      case K_NOKEEP:
      case K_NOMAXVALUE:
      case K_NOMINVALUE:
      case K_NOORDER:
      case K_ORDER:
      case K_SESSION:
      case K_RESTART:
      case K_START:{
        ;
        break;
        }
      default:
        jj_la1[562] = jj_gen;
        break label_113;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case K_INCREMENT:{
        jj_consume_token(K_INCREMENT);
        jj_consume_token(K_BY);
        token = jj_consume_token(S_LONG);
parameter = new Sequence.Parameter(Sequence.ParameterType.INCREMENT_BY);
        parameter.setValue(Long.parseLong(token.image));
        sequenceParameters.add(parameter);
        break;
        }
      case K_START:{
        jj_consume_token(K_START);
        jj_consume_token(K_WITH);
        token = jj_consume_token(S_LONG);
parameter = new Sequence.Parameter(Sequence.ParameterType.START_WITH);
      parameter.setValue(Long.parseLong(token.image));
      sequenceParameters.add(parameter);
        break;
        }
      case K_RESTART:{
        jj_consume_token(K_RESTART);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_WITH:{
          jj_consume_token(K_WITH);
          token = jj_consume_token(S_LONG);
          break;
          }
        default:
          jj_la1[563] = jj_gen;
          ;
        }
parameter = new Sequence.Parameter(Sequence.ParameterType.RESTART_WITH);
      if(token != null){
        parameter.setValue(Long.parseLong(token.image));
      }
      sequenceParameters.add(parameter);
        break;
        }
      case K_MAXVALUE:
      case K_NOMAXVALUE:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_NOMAXVALUE:{
          jj_consume_token(K_NOMAXVALUE);
parameter = new Sequence.Parameter(Sequence.ParameterType.NOMAXVALUE);
      sequenceParameters.add(parameter);
          break;
          }
        case K_MAXVALUE:{
          jj_consume_token(K_MAXVALUE);
          token = jj_consume_token(S_LONG);
parameter = new Sequence.Parameter(Sequence.ParameterType.MAXVALUE);
      parameter.setValue(Long.parseLong(token.image));
      sequenceParameters.add(parameter);
          break;
          }
        default:
          jj_la1[564] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      case K_MINVALUE:
      case K_NOMINVALUE:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_NOMINVALUE:{
          jj_consume_token(K_NOMINVALUE);
parameter = new Sequence.Parameter(Sequence.ParameterType.NOMINVALUE);
      sequenceParameters.add(parameter);
          break;
          }
        case K_MINVALUE:{
          jj_consume_token(K_MINVALUE);
          token = jj_consume_token(S_LONG);
parameter = new Sequence.Parameter(Sequence.ParameterType.MINVALUE);
      parameter.setValue(Long.parseLong(token.image));
      sequenceParameters.add(parameter);
          break;
          }
        default:
          jj_la1[565] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      case K_CYCLE:
      case K_NOCYCLE:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_NOCYCLE:{
          jj_consume_token(K_NOCYCLE);
sequenceParameters.add(new Sequence.Parameter(Sequence.ParameterType.NOCYCLE));
          break;
          }
        case K_CYCLE:{
          jj_consume_token(K_CYCLE);
sequenceParameters.add(new Sequence.Parameter(Sequence.ParameterType.CYCLE));
          break;
          }
        default:
          jj_la1[566] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      case K_CACHE:
      case K_NOCACHE:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_NOCACHE:{
          jj_consume_token(K_NOCACHE);
parameter = new Sequence.Parameter(Sequence.ParameterType.NOCACHE);
      sequenceParameters.add(parameter);
          break;
          }
        case K_CACHE:{
          jj_consume_token(K_CACHE);
          token = jj_consume_token(S_LONG);
parameter = new Sequence.Parameter(Sequence.ParameterType.CACHE);
      parameter.setValue(Long.parseLong(token.image));
      sequenceParameters.add(parameter);
          break;
          }
        default:
          jj_la1[567] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      case K_NOORDER:
      case K_ORDER:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_ORDER:{
          jj_consume_token(K_ORDER);
sequenceParameters.add(new Sequence.Parameter(Sequence.ParameterType.ORDER));
          break;
          }
        case K_NOORDER:{
          jj_consume_token(K_NOORDER);
sequenceParameters.add(new Sequence.Parameter(Sequence.ParameterType.NOORDER));
          break;
          }
        default:
          jj_la1[568] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      case K_KEEP:
      case K_NOKEEP:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_KEEP:{
          jj_consume_token(K_KEEP);
sequenceParameters.add(new Sequence.Parameter(Sequence.ParameterType.KEEP));
          break;
          }
        case K_NOKEEP:{
          jj_consume_token(K_NOKEEP);
sequenceParameters.add(new Sequence.Parameter(Sequence.ParameterType.NOKEEP));
          break;
          }
        default:
          jj_la1[569] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      case K_GLOBAL:
      case K_SESSION:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case K_SESSION:{
          jj_consume_token(K_SESSION);
sequenceParameters.add(new Sequence.Parameter(Sequence.ParameterType.SESSION));
          break;
          }
        case K_GLOBAL:{
          jj_consume_token(K_GLOBAL);
sequenceParameters.add(new Sequence.Parameter(Sequence.ParameterType.GLOBAL));
          break;
          }
        default:
          jj_la1[570] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[571] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
return sequenceParameters;
}

  final public CreateSequence CreateSequence() throws ParseException {CreateSequence createSequence = new CreateSequence();
  Sequence sequence;
  List<Sequence.Parameter> sequenceParameters;
    jj_consume_token(K_CREATE);
    jj_consume_token(K_SEQUENCE);
    sequence = Sequence();
createSequence.setSequence(sequence);
    sequenceParameters = SequenceParameters();
sequence.setParameters(sequenceParameters);
return createSequence;
}

  final public AlterSequence AlterSequence() throws ParseException {AlterSequence alterSequence = new AlterSequence();
  Sequence sequence;
  List<Sequence.Parameter> sequenceParameters;
    jj_consume_token(K_ALTER);
    jj_consume_token(K_SEQUENCE);
    sequence = Sequence();
alterSequence.setSequence(sequence);
    sequenceParameters = SequenceParameters();
sequence.setParameters(sequenceParameters);
return alterSequence;
}

  final public CreateFunctionalStatement CreateFunctionStatement() throws ParseException {CreateFunctionalStatement type = null;
  List<String> tokens = new LinkedList<String>();
  String statementType = null;
  boolean orReplace = false;
    jj_consume_token(K_CREATE);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_OR:{
      jj_consume_token(K_OR);
      jj_consume_token(K_REPLACE);
orReplace = true;
      break;
      }
    default:
      jj_la1[572] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_FUNCTION:{
      jj_consume_token(K_FUNCTION);
statementType = "FUNCTION";
      break;
      }
    case K_PROCEDURE:{
      jj_consume_token(K_PROCEDURE);
statementType = "PROCEDURE";
      break;
      }
    default:
      jj_la1[573] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    tokens = captureRest();
if(statementType.equals("FUNCTION")) {
      type = new CreateFunction(orReplace, tokens);
    }
    if(statementType.equals("PROCEDURE")) {
      type = new CreateProcedure(orReplace, tokens);
    }

    return type;
}

  final public CreateSynonym CreateSynonym() throws ParseException {CreateSynonym createSynonym = new CreateSynonym();
  Synonym synonym;
  boolean orReplace = false;
  boolean publicSynonym = false;
  List<String> data = new ArrayList<String>();
    jj_consume_token(K_CREATE);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_OR:{
      jj_consume_token(K_OR);
      jj_consume_token(K_REPLACE);
orReplace = true;
      break;
      }
    default:
      jj_la1[574] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case K_PUBLIC:{
      jj_consume_token(K_PUBLIC);
publicSynonym = true;
      break;
      }
    default:
      jj_la1[575] = jj_gen;
      ;
    }
    jj_consume_token(K_SYNONYM);
    synonym = Synonym();
createSynonym.setSynonym(synonym);
    jj_consume_token(K_FOR);
    data = RelObjectNameList();
createSynonym.setOrReplace(orReplace);
    createSynonym.setPublicSynonym(publicSynonym);
    createSynonym.setForList(data);
    return createSynonym;
}

  final public Synonym Synonym() throws ParseException {/*@bgen(jjtree) Synonym */
    SimpleNode jjtn000 = new SimpleNode(JJTSYNONYM);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));List<String> data = new ArrayList<String>();
    String serverName = null, databaseName = null, schemaName = null, sequenceName = null;
    try {
      data = RelObjectNameList();
jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
Synonym synonym = new Synonym(data);
                linkAST(synonym,jjtn000);
        return synonym;
    } catch (Throwable jjte000) {
if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
    throw new RuntimeException("Missing return com.javaoffers.thrid.sqlparse.statement in function");
}

  List<String> captureRest() throws ParseException {List<String> tokens = new LinkedList<String>();
  Token tok;
  while(true) {
    tok = getToken(1);
    if(tok.kind == EOF) {
      break;
    }
    tokens.add(tok.image);
    tok = getNextToken();
  }
  return tokens;
  }

  private boolean jj_2_1(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_1()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  private boolean jj_2_2(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_2()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  private boolean jj_2_3(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_3()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(2, xla); }
  }

  private boolean jj_2_4(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_4()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(3, xla); }
  }

  private boolean jj_2_5(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_5()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(4, xla); }
  }

  private boolean jj_2_6(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_6()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(5, xla); }
  }

  private boolean jj_2_7(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_7()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(6, xla); }
  }

  private boolean jj_2_8(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_8()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(7, xla); }
  }

  private boolean jj_2_9(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_9()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(8, xla); }
  }

  private boolean jj_2_10(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_10()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(9, xla); }
  }

  private boolean jj_2_11(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_11()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(10, xla); }
  }

  private boolean jj_2_12(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_12()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(11, xla); }
  }

  private boolean jj_2_13(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_13()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(12, xla); }
  }

  private boolean jj_2_14(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_14()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(13, xla); }
  }

  private boolean jj_2_15(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_15()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(14, xla); }
  }

  private boolean jj_2_16(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_16()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(15, xla); }
  }

  private boolean jj_2_17(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_17()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(16, xla); }
  }

  private boolean jj_2_18(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_18()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(17, xla); }
  }

  private boolean jj_2_19(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_19()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(18, xla); }
  }

  private boolean jj_2_20(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_20()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(19, xla); }
  }

  private boolean jj_2_21(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_21()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(20, xla); }
  }

  private boolean jj_2_22(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_22()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(21, xla); }
  }

  private boolean jj_2_23(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_23()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(22, xla); }
  }

  private boolean jj_2_24(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_24()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(23, xla); }
  }

  private boolean jj_2_25(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_25()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(24, xla); }
  }

  private boolean jj_2_26(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_26()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(25, xla); }
  }

  private boolean jj_2_27(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_27()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(26, xla); }
  }

  private boolean jj_2_28(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_28()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(27, xla); }
  }

  private boolean jj_2_29(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_29()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(28, xla); }
  }

  private boolean jj_2_30(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_30()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(29, xla); }
  }

  private boolean jj_2_31(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_31()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(30, xla); }
  }

  private boolean jj_2_32(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_32()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(31, xla); }
  }

  private boolean jj_2_33(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_33()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(32, xla); }
  }

  private boolean jj_2_34(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_34()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(33, xla); }
  }

  private boolean jj_2_35(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_35()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(34, xla); }
  }

  private boolean jj_2_36(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_36()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(35, xla); }
  }

  private boolean jj_2_37(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_37()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(36, xla); }
  }

  private boolean jj_2_38(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_38()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(37, xla); }
  }

  private boolean jj_2_39(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_39()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(38, xla); }
  }

  private boolean jj_2_40(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_40()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(39, xla); }
  }

  private boolean jj_2_41(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_41()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(40, xla); }
  }

  private boolean jj_2_42(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_42()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(41, xla); }
  }

  private boolean jj_2_43(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_43()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(42, xla); }
  }

  private boolean jj_2_44(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_44()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(43, xla); }
  }

  private boolean jj_2_45(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_45()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(44, xla); }
  }

  private boolean jj_2_46(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_46()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(45, xla); }
  }

  private boolean jj_2_47(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_47()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(46, xla); }
  }

  private boolean jj_2_48(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_48()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(47, xla); }
  }

  private boolean jj_2_49(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_49()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(48, xla); }
  }

  private boolean jj_2_50(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_50()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(49, xla); }
  }

  private boolean jj_2_51(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_51()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(50, xla); }
  }

  private boolean jj_2_52(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_52()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(51, xla); }
  }

  private boolean jj_2_53(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_53()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(52, xla); }
  }

  private boolean jj_2_54(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_54()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(53, xla); }
  }

  private boolean jj_2_55(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_55()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(54, xla); }
  }

  private boolean jj_2_56(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_56()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(55, xla); }
  }

  private boolean jj_2_57(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_57()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(56, xla); }
  }

  private boolean jj_2_58(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_58()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(57, xla); }
  }

  private boolean jj_2_59(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_59()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(58, xla); }
  }

  private boolean jj_2_60(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_60()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(59, xla); }
  }

  private boolean jj_2_61(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_61()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(60, xla); }
  }

  private boolean jj_2_62(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_62()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(61, xla); }
  }

  private boolean jj_2_63(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_63()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(62, xla); }
  }

  private boolean jj_2_64(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_64()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(63, xla); }
  }

  private boolean jj_2_65(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_65()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(64, xla); }
  }

  private boolean jj_2_66(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_66()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(65, xla); }
  }

  private boolean jj_2_67(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_67()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(66, xla); }
  }

  private boolean jj_2_68(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_68()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(67, xla); }
  }

  private boolean jj_2_69(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_69()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(68, xla); }
  }

  private boolean jj_2_70(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_70()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(69, xla); }
  }

  private boolean jj_2_71(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_71()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(70, xla); }
  }

  private boolean jj_2_72(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_72()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(71, xla); }
  }

  private boolean jj_2_73(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_73()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(72, xla); }
  }

  private boolean jj_2_74(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_74()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(73, xla); }
  }

  private boolean jj_2_75(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_75()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(74, xla); }
  }

  private boolean jj_2_76(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_76()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(75, xla); }
  }

  private boolean jj_2_77(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_77()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(76, xla); }
  }

  private boolean jj_2_78(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_78()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(77, xla); }
  }

  private boolean jj_2_79(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_79()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(78, xla); }
  }

  private boolean jj_2_80(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_80()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(79, xla); }
  }

  private boolean jj_2_81(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_81()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(80, xla); }
  }

  private boolean jj_2_82(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_82()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(81, xla); }
  }

  private boolean jj_2_83(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_83()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(82, xla); }
  }

  private boolean jj_2_84(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_84()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(83, xla); }
  }

  private boolean jj_2_85(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_85()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(84, xla); }
  }

  private boolean jj_2_86(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_86()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(85, xla); }
  }

  private boolean jj_2_87(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_87()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(86, xla); }
  }

  private boolean jj_2_88(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_88()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(87, xla); }
  }

  private boolean jj_2_89(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_89()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(88, xla); }
  }

  private boolean jj_2_90(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_90()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(89, xla); }
  }

  private boolean jj_2_91(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_91()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(90, xla); }
  }

  private boolean jj_2_92(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_92()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(91, xla); }
  }

  private boolean jj_2_93(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_93()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(92, xla); }
  }

  private boolean jj_2_94(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_94()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(93, xla); }
  }

  private boolean jj_2_95(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_95()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(94, xla); }
  }

  private boolean jj_2_96(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_96()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(95, xla); }
  }

  private boolean jj_2_97(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_97()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(96, xla); }
  }

  private boolean jj_2_98(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_98()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(97, xla); }
  }

  private boolean jj_2_99(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_99()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(98, xla); }
  }

  private boolean jj_2_100(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_100()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(99, xla); }
  }

  private boolean jj_2_101(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_101()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(100, xla); }
  }

  private boolean jj_2_102(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_102()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(101, xla); }
  }

  private boolean jj_2_103(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_103()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(102, xla); }
  }

  private boolean jj_2_104(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_104()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(103, xla); }
  }

  private boolean jj_2_105(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_105()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(104, xla); }
  }

  private boolean jj_2_106(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_106()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(105, xla); }
  }

  private boolean jj_2_107(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_107()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(106, xla); }
  }

  private boolean jj_2_108(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_108()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(107, xla); }
  }

  private boolean jj_2_109(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_109()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(108, xla); }
  }

  private boolean jj_2_110(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_110()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(109, xla); }
  }

  private boolean jj_2_111(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_111()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(110, xla); }
  }

  private boolean jj_2_112(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_112()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(111, xla); }
  }

  private boolean jj_2_113(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_113()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(112, xla); }
  }

  private boolean jj_2_114(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_114()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(113, xla); }
  }

  private boolean jj_2_115(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_115()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(114, xla); }
  }

  private boolean jj_2_116(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_116()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(115, xla); }
  }

  private boolean jj_2_117(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_117()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(116, xla); }
  }

  private boolean jj_2_118(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_118()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(117, xla); }
  }

  private boolean jj_2_119(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_119()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(118, xla); }
  }

  private boolean jj_2_120(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_120()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(119, xla); }
  }

  private boolean jj_2_121(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_121()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(120, xla); }
  }

  private boolean jj_2_122(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_122()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(121, xla); }
  }

  private boolean jj_2_123(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_123()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(122, xla); }
  }

  private boolean jj_2_124(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_124()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(123, xla); }
  }

  private boolean jj_2_125(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_125()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(124, xla); }
  }

  private boolean jj_2_126(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_126()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(125, xla); }
  }

  private boolean jj_2_127(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_127()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(126, xla); }
  }

  private boolean jj_2_128(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_128()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(127, xla); }
  }

  private boolean jj_2_129(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_129()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(128, xla); }
  }

  private boolean jj_2_130(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_130()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(129, xla); }
  }

  private boolean jj_2_131(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_131()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(130, xla); }
  }

  private boolean jj_2_132(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_132()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(131, xla); }
  }

  private boolean jj_2_133(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_133()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(132, xla); }
  }

  private boolean jj_2_134(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_134()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(133, xla); }
  }

  private boolean jj_2_135(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_135()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(134, xla); }
  }

  private boolean jj_2_136(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_136()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(135, xla); }
  }

  private boolean jj_2_137(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_137()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(136, xla); }
  }

  private boolean jj_2_138(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_138()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(137, xla); }
  }

  private boolean jj_2_139(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_139()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(138, xla); }
  }

  private boolean jj_2_140(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_140()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(139, xla); }
  }

  private boolean jj_2_141(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_141()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(140, xla); }
  }

  private boolean jj_2_142(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_142()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(141, xla); }
  }

  private boolean jj_2_143(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_143()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(142, xla); }
  }

  private boolean jj_2_144(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_144()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(143, xla); }
  }

  private boolean jj_2_145(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_145()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(144, xla); }
  }

  private boolean jj_2_146(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_146()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(145, xla); }
  }

  private boolean jj_2_147(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_147()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(146, xla); }
  }

  private boolean jj_2_148(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_148()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(147, xla); }
  }

  private boolean jj_2_149(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_149()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(148, xla); }
  }

  private boolean jj_2_150(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_150()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(149, xla); }
  }

  private boolean jj_2_151(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_151()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(150, xla); }
  }

  private boolean jj_2_152(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_152()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(151, xla); }
  }

  private boolean jj_2_153(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_153()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(152, xla); }
  }

  private boolean jj_2_154(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_154()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(153, xla); }
  }

  private boolean jj_2_155(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_155()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(154, xla); }
  }

  private boolean jj_2_156(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_156()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(155, xla); }
  }

  private boolean jj_2_157(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_157()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(156, xla); }
  }

  private boolean jj_2_158(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_158()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(157, xla); }
  }

  private boolean jj_2_159(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_159()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(158, xla); }
  }

  private boolean jj_2_160(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_160()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(159, xla); }
  }

  private boolean jj_2_161(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_161()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(160, xla); }
  }

  private boolean jj_2_162(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_162()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(161, xla); }
  }

  private boolean jj_2_163(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_163()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(162, xla); }
  }

  private boolean jj_2_164(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_164()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(163, xla); }
  }

  private boolean jj_2_165(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_165()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(164, xla); }
  }

  private boolean jj_2_166(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_166()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(165, xla); }
  }

  private boolean jj_2_167(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_167()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(166, xla); }
  }

  private boolean jj_2_168(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_168()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(167, xla); }
  }

  private boolean jj_2_169(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_169()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(168, xla); }
  }

  private boolean jj_2_170(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_170()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(169, xla); }
  }

  private boolean jj_2_171(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_171()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(170, xla); }
  }

  private boolean jj_2_172(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_172()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(171, xla); }
  }

  private boolean jj_2_173(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_173()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(172, xla); }
  }

  private boolean jj_2_174(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_174()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(173, xla); }
  }

  private boolean jj_2_175(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_175()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(174, xla); }
  }

  private boolean jj_2_176(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_176()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(175, xla); }
  }

  private boolean jj_2_177(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_177()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(176, xla); }
  }

  private boolean jj_2_178(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_178()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(177, xla); }
  }

  private boolean jj_2_179(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_179()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(178, xla); }
  }

  private boolean jj_2_180(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_180()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(179, xla); }
  }

  private boolean jj_2_181(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_181()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(180, xla); }
  }

  private boolean jj_2_182(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_182()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(181, xla); }
  }

  private boolean jj_2_183(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_183()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(182, xla); }
  }

  private boolean jj_2_184(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_184()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(183, xla); }
  }

  private boolean jj_2_185(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_185()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(184, xla); }
  }

  private boolean jj_2_186(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_186()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(185, xla); }
  }

  private boolean jj_2_187(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_187()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(186, xla); }
  }

  private boolean jj_2_188(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_188()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(187, xla); }
  }

  private boolean jj_2_189(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_189()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(188, xla); }
  }

  private boolean jj_2_190(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_190()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(189, xla); }
  }

  private boolean jj_2_191(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_191()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(190, xla); }
  }

  private boolean jj_2_192(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_192()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(191, xla); }
  }

  private boolean jj_2_193(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_193()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(192, xla); }
  }

  private boolean jj_2_194(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_194()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(193, xla); }
  }

  private boolean jj_2_195(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_195()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(194, xla); }
  }

  private boolean jj_2_196(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_196()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(195, xla); }
  }

  private boolean jj_2_197(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_197()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(196, xla); }
  }

  private boolean jj_2_198(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_198()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(197, xla); }
  }

  private boolean jj_2_199(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_199()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(198, xla); }
  }

  private boolean jj_2_200(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_200()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(199, xla); }
  }

  private boolean jj_2_201(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_201()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(200, xla); }
  }

  private boolean jj_2_202(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_202()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(201, xla); }
  }

  private boolean jj_2_203(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_203()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(202, xla); }
  }

  private boolean jj_2_204(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_204()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(203, xla); }
  }

  private boolean jj_2_205(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_205()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(204, xla); }
  }

  private boolean jj_2_206(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_206()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(205, xla); }
  }

  private boolean jj_2_207(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_207()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(206, xla); }
  }

  private boolean jj_2_208(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_208()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(207, xla); }
  }

  private boolean jj_2_209(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_209()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(208, xla); }
  }

  private boolean jj_2_210(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_210()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(209, xla); }
  }

  private boolean jj_2_211(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_211()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(210, xla); }
  }

  private boolean jj_2_212(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_212()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(211, xla); }
  }

  private boolean jj_2_213(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_213()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(212, xla); }
  }

  private boolean jj_2_214(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_214()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(213, xla); }
  }

  private boolean jj_2_215(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_215()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(214, xla); }
  }

  private boolean jj_2_216(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_216()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(215, xla); }
  }

  private boolean jj_2_217(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_217()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(216, xla); }
  }

  private boolean jj_2_218(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_218()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(217, xla); }
  }

  private boolean jj_2_219(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_219()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(218, xla); }
  }

  private boolean jj_2_220(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_220()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(219, xla); }
  }

  private boolean jj_2_221(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_221()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(220, xla); }
  }

  private boolean jj_2_222(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_222()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(221, xla); }
  }

  private boolean jj_2_223(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_223()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(222, xla); }
  }

  private boolean jj_2_224(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_224()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(223, xla); }
  }

  private boolean jj_2_225(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_225()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(224, xla); }
  }

  private boolean jj_2_226(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_226()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(225, xla); }
  }

  private boolean jj_2_227(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_227()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(226, xla); }
  }

  private boolean jj_2_228(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_228()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(227, xla); }
  }

  private boolean jj_2_229(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_229()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(228, xla); }
  }

  private boolean jj_2_230(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_230()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(229, xla); }
  }

  private boolean jj_2_231(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_231()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(230, xla); }
  }

  private boolean jj_2_232(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_232()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(231, xla); }
  }

  private boolean jj_2_233(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_233()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(232, xla); }
  }

  private boolean jj_2_234(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_234()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(233, xla); }
  }

  private boolean jj_2_235(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_235()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(234, xla); }
  }

  private boolean jj_2_236(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_236()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(235, xla); }
  }

  private boolean jj_2_237(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_237()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(236, xla); }
  }

  private boolean jj_2_238(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_238()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(237, xla); }
  }

  private boolean jj_2_239(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_239()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(238, xla); }
  }

  private boolean jj_2_240(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_240()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(239, xla); }
  }

  private boolean jj_2_241(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_241()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(240, xla); }
  }

  private boolean jj_2_242(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_242()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(241, xla); }
  }

  private boolean jj_2_243(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_243()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(242, xla); }
  }

  private boolean jj_2_244(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_244()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(243, xla); }
  }

  private boolean jj_2_245(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_245()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(244, xla); }
  }

  private boolean jj_2_246(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_246()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(245, xla); }
  }

  private boolean jj_2_247(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_247()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(246, xla); }
  }

  private boolean jj_2_248(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_248()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(247, xla); }
  }

  private boolean jj_2_249(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_249()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(248, xla); }
  }

  private boolean jj_2_250(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_250()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(249, xla); }
  }

  private boolean jj_2_251(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_251()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(250, xla); }
  }

  private boolean jj_2_252(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_252()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(251, xla); }
  }

  private boolean jj_2_253(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_253()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(252, xla); }
  }

  private boolean jj_2_254(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_254()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(253, xla); }
  }

  private boolean jj_2_255(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_255()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(254, xla); }
  }

  private boolean jj_2_256(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_256()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(255, xla); }
  }

  private boolean jj_2_257(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_257()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(256, xla); }
  }

  private boolean jj_2_258(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_258()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(257, xla); }
  }

  private boolean jj_2_259(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_259()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(258, xla); }
  }

  private boolean jj_2_260(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_260()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(259, xla); }
  }

  private boolean jj_2_261(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_261()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(260, xla); }
  }

  private boolean jj_2_262(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_262()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(261, xla); }
  }

  private boolean jj_2_263(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_263()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(262, xla); }
  }

  private boolean jj_2_264(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_264()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(263, xla); }
  }

  private boolean jj_2_265(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_265()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(264, xla); }
  }

  private boolean jj_2_266(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_266()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(265, xla); }
  }

  private boolean jj_2_267(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_267()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(266, xla); }
  }

  private boolean jj_3R_AndExpression_3045_21_192()
 {
    if (jj_scan_token(K_AND_OPERATOR)) return true;
    return false;
  }

  private boolean jj_3_125()
 {
    if (jj_3R_Condition_3072_5_191()) return true;
    return false;
  }

  private boolean jj_3R_AndExpression_3050_15_420()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_AndExpression_3050_15_631()) {
    jj_scanpos = xsp;
    if (jj_3R_AndExpression_3050_39_632()) return true;
    }
    return false;
  }

  private boolean jj_3R_AndExpression_3050_15_631()
 {
    if (jj_scan_token(K_NOT)) return true;
    return false;
  }

  private boolean jj_3R_Sequence_6130_5_320()
 {
    if (jj_3R_RelObjectNameList_1613_5_325()) return true;
    return false;
  }

  private boolean jj_3R_AndExpression_3050_13_194()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_AndExpression_3050_15_420()) jj_scanpos = xsp;
    if (jj_scan_token(325)) return true;
    if (jj_3R_XorExpression_2993_5_351()) return true;
    if (jj_scan_token(326)) return true;
    return false;
  }

  private boolean jj_3R_AndExpression_3047_9_193()
 {
    if (jj_3R_Condition_3072_5_191()) return true;
    return false;
  }

  private boolean jj_3_123()
 {
    if (jj_3R_Condition_3072_5_191()) return true;
    return false;
  }

  private boolean jj_3_124()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(13)) {
    jj_scanpos = xsp;
    if (jj_3R_AndExpression_3045_21_192()) return true;
    }
    xsp = jj_scanpos;
    if (jj_3R_AndExpression_3047_9_193()) {
    jj_scanpos = xsp;
    if (jj_3R_AndExpression_3050_13_194()) return true;
    }
    return false;
  }

  private boolean jj_3R_AndExpression_3038_11_630()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_AndExpression_3038_11_724()) {
    jj_scanpos = xsp;
    if (jj_3R_AndExpression_3038_35_725()) return true;
    }
    return false;
  }

  private boolean jj_3R_AndExpression_3038_11_724()
 {
    if (jj_scan_token(K_NOT)) return true;
    return false;
  }

  private boolean jj_3R_AndExpression_3038_9_418()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_AndExpression_3038_11_630()) jj_scanpos = xsp;
    if (jj_scan_token(325)) return true;
    if (jj_3R_XorExpression_2993_5_351()) return true;
    if (jj_scan_token(326)) return true;
    return false;
  }

  private boolean jj_3R_AndExpression_3035_9_417()
 {
    if (jj_3R_Condition_3072_5_191()) return true;
    return false;
  }

  private boolean jj_3R_AndExpression_3034_5_190()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_AndExpression_3035_9_417()) {
    jj_scanpos = xsp;
    if (jj_3R_AndExpression_3038_9_418()) return true;
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_124()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_122()
 {
    if (jj_scan_token(K_OR)) return true;
    if (jj_3R_AndExpression_3034_5_190()) return true;
    return false;
  }

  private boolean jj_3R_OrExpression_3012_5_189()
 {
    if (jj_3R_AndExpression_3034_5_190()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_122()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_Grant_6075_9_573()
 {
    if (jj_scan_token(K_GRANT)) return true;
    return false;
  }

  private boolean jj_3_118()
 {
    if (jj_scan_token(S_IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3_121()
 {
    if (jj_scan_token(K_XOR)) return true;
    if (jj_3R_OrExpression_3012_5_189()) return true;
    return false;
  }

  private boolean jj_3R_XorExpression_2993_5_351()
 {
    if (jj_3R_OrExpression_3012_5_189()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_121()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_First_2969_19_386()
 {
    if (jj_3R_SimpleJdbcParameter_2756_5_245()) return true;
    return false;
  }

  private boolean jj_3R_Expression_2983_5_136()
 {
    if (jj_3R_XorExpression_2993_5_351()) return true;
    return false;
  }

  private boolean jj_3R_First_2968_19_385()
 {
    if (jj_scan_token(S_IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_First_2964_16_383()
 {
    if (jj_scan_token(K_LIMIT)) return true;
    return false;
  }

  private boolean jj_3R_Comment_6046_5_569()
 {
    if (jj_scan_token(K_COMMENT)) return true;
    return false;
  }

  private boolean jj_3R_First_2967_10_384()
 {
    if (jj_scan_token(S_LONG)) return true;
    return false;
  }

  private boolean jj_3R_First_2963_7_382()
 {
    if (jj_scan_token(K_FIRST)) return true;
    return false;
  }

  private boolean jj_3R_First_2963_5_150()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_First_2963_7_382()) {
    jj_scanpos = xsp;
    if (jj_3R_First_2964_16_383()) return true;
    }
    xsp = jj_scanpos;
    if (jj_3R_First_2967_10_384()) {
    jj_scanpos = xsp;
    if (jj_3R_First_2968_19_385()) {
    jj_scanpos = xsp;
    if (jj_3R_First_2969_19_386()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_Commit_6031_3_568()
 {
    if (jj_scan_token(K_COMMIT)) return true;
    return false;
  }

  private boolean jj_3R_Skip_2931_19_381()
 {
    if (jj_3R_SimpleJdbcParameter_2756_5_245()) return true;
    return false;
  }

  private boolean jj_3R_Skip_2930_19_380()
 {
    if (jj_scan_token(S_IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_RollbackStatement_6010_5_567()
 {
    if (jj_scan_token(K_ROLLBACK)) return true;
    return false;
  }

  private boolean jj_3R_Skip_2929_10_379()
 {
    if (jj_scan_token(S_LONG)) return true;
    return false;
  }

  private boolean jj_3R_Skip_2927_5_149()
 {
    if (jj_scan_token(K_SKIP)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_Skip_2929_10_379()) {
    jj_scanpos = xsp;
    if (jj_3R_Skip_2930_19_380()) {
    jj_scanpos = xsp;
    if (jj_3R_Skip_2931_19_381()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_SavepointStatement_5995_3_566()
 {
    if (jj_scan_token(K_SAVEPOINT)) return true;
    return false;
  }

  private boolean jj_3_120()
 {
    if (jj_scan_token(K_WITH_TIES)) return true;
    return false;
  }

  private boolean jj_3_119()
 {
    if (jj_scan_token(K_PERCENT)) return true;
    return false;
  }

  private boolean jj_3R_Wait_5983_5_873()
 {
    if (jj_scan_token(K_WAIT)) return true;
    if (jj_scan_token(S_LONG)) return true;
    return false;
  }

  private boolean jj_3R_Top_2908_8_392()
 {
    if (jj_scan_token(325)) return true;
    if (jj_3R_AdditiveExpression_3614_5_472()) return true;
    if (jj_scan_token(326)) return true;
    return false;
  }

  private boolean jj_3R_Top_2906_8_391()
 {
    if (jj_scan_token(330)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_118()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_Top_2903_10_390()
 {
    if (jj_3R_SimpleJdbcParameter_2756_5_245()) return true;
    return false;
  }

  private boolean jj_3R_Top_2901_10_389()
 {
    if (jj_scan_token(S_LONG)) return true;
    return false;
  }

  private boolean jj_3R_Top_2899_5_155()
 {
    if (jj_scan_token(K_TOP)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_Top_2901_10_389()) {
    jj_scanpos = xsp;
    if (jj_3R_Top_2903_10_390()) {
    jj_scanpos = xsp;
    if (jj_3R_Top_2906_8_391()) {
    jj_scanpos = xsp;
    if (jj_3R_Top_2908_8_392()) return true;
    }
    }
    }
    xsp = jj_scanpos;
    if (jj_3_119()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_120()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_Offset_2830_62_838()
 {
    if (jj_scan_token(K_ROW)) return true;
    return false;
  }

  private boolean jj_3R_OptimizeFor_2884_5_857()
 {
    if (jj_scan_token(K_OPTIMIZE)) return true;
    if (jj_scan_token(K_FOR)) return true;
    if (jj_scan_token(S_LONG)) return true;
    if (jj_scan_token(K_ROWS)) return true;
    return false;
  }

  private boolean jj_3R_WithIsolation_2867_5_770()
 {
    if (jj_scan_token(K_WITH)) return true;
    if (jj_scan_token(K_ISOLATION)) return true;
    return false;
  }

  private boolean jj_3R_Fetch_2850_20_806()
 {
    if (jj_3R_SimpleJdbcParameter_2756_5_245()) return true;
    return false;
  }

  private boolean jj_3R_Fetch_2851_19_807()
 {
    if (jj_scan_token(K_ROWS)) return true;
    return false;
  }

  private boolean jj_3R_Fetch_2848_20_804()
 {
    if (jj_scan_token(K_FIRST)) return true;
    return false;
  }

  private boolean jj_3R_Fetch_2849_19_805()
 {
    if (jj_scan_token(S_LONG)) return true;
    return false;
  }

  private boolean jj_3R_Fetch_2845_5_769()
 {
    if (jj_scan_token(K_FETCH)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_Fetch_2848_20_804()) {
    jj_scanpos = xsp;
    if (jj_scan_token(165)) return true;
    }
    xsp = jj_scanpos;
    if (jj_3R_Fetch_2849_19_805()) {
    jj_scanpos = xsp;
    if (jj_3R_Fetch_2850_20_806()) return true;
    }
    xsp = jj_scanpos;
    if (jj_3R_Fetch_2851_19_807()) {
    jj_scanpos = xsp;
    if (jj_scan_token(226)) return true;
    }
    if (jj_scan_token(K_ONLY)) return true;
    return false;
  }

  private boolean jj_3R_Offset_2830_16_837()
 {
    if (jj_scan_token(K_ROWS)) return true;
    return false;
  }

  private boolean jj_3R_Offset_2830_15_803()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_Offset_2830_16_837()) {
    jj_scanpos = xsp;
    if (jj_3R_Offset_2830_62_838()) return true;
    }
    return false;
  }

  private boolean jj_3R_Offset_2824_5_768()
 {
    if (jj_scan_token(K_OFFSET)) return true;
    if (jj_3R_Expression_2983_5_136()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_Offset_2830_15_803()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_AlterSystemStatement_5889_5_575()
 {
    if (jj_scan_token(K_ALTER)) return true;
    return false;
  }

  private boolean jj_3_117()
 {
    if (jj_3R_Expression_2983_5_136()) return true;
    return false;
  }

  private boolean jj_3_116()
 {
    if (jj_scan_token(325)) return true;
    if (jj_3R_SubSelect_4738_5_134()) return true;
    if (jj_scan_token(326)) return true;
    return false;
  }

  private boolean jj_3R_PlainLimit_2803_5_836()
 {
    if (jj_scan_token(K_LIMIT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_116()) {
    jj_scanpos = xsp;
    if (jj_3_117()) return true;
    }
    return false;
  }

  private boolean jj_3_115()
 {
    if (jj_scan_token(K_LIMIT)) return true;
    if (jj_3R_Expression_2983_5_136()) return true;
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_3R_Expression_2983_5_136()) return true;
    return false;
  }

  private boolean jj_3R_LimitWithOffset_2789_9_802()
 {
    if (jj_3R_PlainLimit_2803_5_836()) return true;
    return false;
  }

  private boolean jj_3R_LimitWithOffset_2781_9_801()
 {
    if (jj_scan_token(K_LIMIT)) return true;
    if (jj_3R_Expression_2983_5_136()) return true;
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_3R_Expression_2983_5_136()) return true;
    return false;
  }

  private boolean jj_3R_LimitWithOffset_2780_5_767()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_LimitWithOffset_2781_9_801()) {
    jj_scanpos = xsp;
    if (jj_3R_LimitWithOffset_2789_9_802()) return true;
    }
    return false;
  }

  private boolean jj_3_114()
 {
    if (jj_scan_token(S_LONG)) return true;
    return false;
  }

  private boolean jj_3R_SimpleJdbcNamedParameter_2767_5_665()
 {
    if (jj_scan_token(330)) return true;
    if (jj_3R_RelObjectNameExt_1719_5_342()) return true;
    return false;
  }

  private boolean jj_3R_SimpleJdbcParameter_2756_5_245()
 {
    if (jj_scan_token(331)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_114()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_OrderByElement_2740_19_840()
 {
    if (jj_scan_token(K_DESC)) return true;
    return false;
  }

  private boolean jj_3R_AlterSession_5823_5_117()
 {
    if (jj_scan_token(K_ALTER)) return true;
    if (jj_scan_token(K_SESSION)) return true;
    return false;
  }

  private boolean jj_3R_OrderByElement_2743_9_861()
 {
    if (jj_scan_token(K_LAST)) return true;
    return false;
  }

  private boolean jj_3R_OrderByElement_2742_9_860()
 {
    if (jj_scan_token(K_FIRST)) return true;
    return false;
  }

  private boolean jj_3R_OrderByElement_2742_9_841()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_OrderByElement_2742_9_860()) {
    jj_scanpos = xsp;
    if (jj_3R_OrderByElement_2743_9_861()) return true;
    }
    return false;
  }

  private boolean jj_3R_OrderByElement_2740_7_815()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(21)) {
    jj_scanpos = xsp;
    if (jj_3R_OrderByElement_2740_19_840()) return true;
    }
    return false;
  }

  private boolean jj_3R_OrderByElement_2741_6_816()
 {
    if (jj_scan_token(K_NULLS)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_OrderByElement_2742_9_841()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_OrderByElement_2739_5_188()
 {
    if (jj_3R_Expression_2983_5_136()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_OrderByElement_2740_7_815()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_OrderByElement_2741_6_816()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_113()
 {
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_3R_OrderByElement_2739_5_188()) return true;
    return false;
  }

  private boolean jj_3_267()
 {
    if (jj_scan_token(K_IF)) return true;
    if (jj_scan_token(K_EXISTS)) return true;
    return false;
  }

  private boolean jj_3R_AlterTable_5798_5_116()
 {
    if (jj_scan_token(K_ALTER)) return true;
    if (jj_scan_token(K_TABLE)) return true;
    return false;
  }

  private boolean jj_3R_OrderByElements_2726_5_164()
 {
    if (jj_scan_token(K_ORDER)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(241)) jj_scanpos = xsp;
    if (jj_scan_token(K_BY)) return true;
    if (jj_3R_OrderByElement_2739_5_188()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_113()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_Having_2714_5_853()
 {
    if (jj_scan_token(K_HAVING)) return true;
    if (jj_3R_Expression_2983_5_136()) return true;
    return false;
  }

  private boolean jj_3_109()
 {
    if (jj_3R_SimpleExpression_3535_5_132()) return true;
    return false;
  }

  private boolean jj_3_107()
 {
    if (jj_scan_token(325)) return true;
    if (jj_scan_token(326)) return true;
    return false;
  }

  private boolean jj_3_108()
 {
    if (jj_scan_token(325)) return true;
    if (jj_3R_SimpleExpressionList_3358_5_169()) return true;
    if (jj_scan_token(326)) return true;
    return false;
  }

  private boolean jj_3_106()
 {
    if (jj_3R_SimpleExpression_3535_5_132()) return true;
    return false;
  }

  private boolean jj_3_105()
 {
    if (jj_scan_token(325)) return true;
    if (jj_3R_SimpleExpressionList_3358_5_169()) return true;
    if (jj_scan_token(326)) return true;
    return false;
  }

  private boolean jj_3R_GroupByColumnReferences_2694_19_877()
 {
    if (jj_scan_token(K_COMMA)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_107()) {
    jj_scanpos = xsp;
    if (jj_3_108()) {
    jj_scanpos = xsp;
    if (jj_3_109()) return true;
    }
    }
    return false;
  }

  private boolean jj_3_112()
 {
    if (jj_3R_ComplexExpressionList_3373_5_135()) return true;
    return false;
  }

  private boolean jj_3_104()
 {
    if (jj_scan_token(325)) return true;
    if (jj_scan_token(326)) return true;
    return false;
  }

  private boolean jj_3R_OracleHierarchicalQueryClause_2663_38_875()
 {
    if (jj_scan_token(K_NOCYCLE)) return true;
    return false;
  }

  private boolean jj_3_111()
 {
    if (jj_scan_token(K_GROUPING)) return true;
    if (jj_scan_token(K_SETS)) return true;
    if (jj_scan_token(325)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_104()) {
    jj_scanpos = xsp;
    if (jj_3_105()) {
    jj_scanpos = xsp;
    if (jj_3_106()) return true;
    }
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_GroupByColumnReferences_2694_19_877()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(326)) return true;
    return false;
  }

  private boolean jj_3R_OracleHierarchicalQueryClause_2660_38_874()
 {
    if (jj_scan_token(K_NOCYCLE)) return true;
    return false;
  }

  private boolean jj_3_110()
 {
    if (jj_scan_token(325)) return true;
    if (jj_scan_token(326)) return true;
    return false;
  }

  private boolean jj_3_266()
 {
    if (jj_scan_token(K_RENAME)) return true;
    if (jj_scan_token(K_COLUMN)) return true;
    return false;
  }

  private boolean jj_3R_GroupByColumnReferences_2683_5_852()
 {
    if (jj_scan_token(K_GROUP)) return true;
    if (jj_scan_token(K_BY)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_110()) {
    jj_scanpos = xsp;
    if (jj_3_111()) {
    jj_scanpos = xsp;
    if (jj_3_112()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_OracleHierarchicalQueryClause_2668_19_876()
 {
    if (jj_scan_token(K_START)) return true;
    if (jj_scan_token(K_WITH)) return true;
    if (jj_3R_AndExpression_3034_5_190()) return true;
    return false;
  }

  private boolean jj_3R_OracleHierarchicalQueryClause_2663_17_872()
 {
    if (jj_scan_token(K_CONNECT)) return true;
    if (jj_scan_token(K_BY)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_OracleHierarchicalQueryClause_2663_38_875()) jj_scanpos = xsp;
    if (jj_3R_AndExpression_3034_5_190()) return true;
    xsp = jj_scanpos;
    if (jj_3R_OracleHierarchicalQueryClause_2668_19_876()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_OracleHierarchicalQueryClause_2659_17_871()
 {
    if (jj_scan_token(K_START)) return true;
    if (jj_scan_token(K_WITH)) return true;
    if (jj_3R_AndExpression_3034_5_190()) return true;
    if (jj_scan_token(K_CONNECT)) return true;
    if (jj_scan_token(K_BY)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_OracleHierarchicalQueryClause_2660_38_874()) jj_scanpos = xsp;
    if (jj_3R_AndExpression_3034_5_190()) return true;
    return false;
  }

  private boolean jj_3R_OracleHierarchicalQueryClause_2658_5_851()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_OracleHierarchicalQueryClause_2659_17_871()) {
    jj_scanpos = xsp;
    if (jj_3R_OracleHierarchicalQueryClause_2663_17_872()) return true;
    }
    return false;
  }

  private boolean jj_3R_WhereClause_2648_5_157()
 {
    if (jj_scan_token(K_WHERE)) return true;
    if (jj_3R_Expression_2983_5_136()) return true;
    return false;
  }

  private boolean jj_3_265()
 {
    if (jj_scan_token(K_COLUMN)) return true;
    return false;
  }

  private boolean jj_3R_KSQLWindowClause_2627_9_870()
 {
    if (jj_scan_token(K_TUMBLING)) return true;
    if (jj_scan_token(325)) return true;
    if (jj_scan_token(K_SIZE)) return true;
    if (jj_scan_token(S_LONG)) return true;
    if (jj_scan_token(S_IDENTIFIER)) return true;
    if (jj_scan_token(326)) return true;
    return false;
  }

  private boolean jj_3R_KSQLWindowClause_2623_9_869()
 {
    if (jj_scan_token(K_SESSION)) return true;
    if (jj_scan_token(325)) return true;
    if (jj_scan_token(S_LONG)) return true;
    if (jj_scan_token(S_IDENTIFIER)) return true;
    if (jj_scan_token(326)) return true;
    return false;
  }

  private boolean jj_3R_KSQLWindowClause_2617_9_868()
 {
    if (jj_scan_token(K_HOPPING)) return true;
    if (jj_scan_token(325)) return true;
    if (jj_scan_token(K_SIZE)) return true;
    if (jj_scan_token(S_LONG)) return true;
    if (jj_scan_token(S_IDENTIFIER)) return true;
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_scan_token(K_ADVANCE)) return true;
    if (jj_scan_token(K_BY)) return true;
    if (jj_scan_token(S_LONG)) return true;
    if (jj_scan_token(S_IDENTIFIER)) return true;
    if (jj_scan_token(326)) return true;
    return false;
  }

  private boolean jj_3R_JoinerExpression_2534_81_778()
 {
    if (jj_scan_token(K_OUTER)) return true;
    return false;
  }

  private boolean jj_3R_KSQLWindowClause_2609_5_850()
 {
    if (jj_scan_token(K_WINDOW)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_KSQLWindowClause_2617_9_868()) {
    jj_scanpos = xsp;
    if (jj_3R_KSQLWindowClause_2623_9_869()) {
    jj_scanpos = xsp;
    if (jj_3R_KSQLWindowClause_2627_9_870()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_JoinerExpression_2545_57_415()
 {
    if (jj_scan_token(K_APPLY)) return true;
    return false;
  }

  private boolean jj_3R_JoinerExpression_2544_55_629()
 {
    if (jj_scan_token(K_OUTER)) return true;
    return false;
  }

  private boolean jj_3R_JoinWindow_2583_11_912()
 {
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_scan_token(S_LONG)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(319)) {
    jj_scanpos = xsp;
    if (jj_scan_token(62)) return true;
    }
    return false;
  }

  private boolean jj_3R_JoinerExpression_2559_31_898()
 {
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_3R_Column_1626_5_133()) return true;
    return false;
  }

  private boolean jj_3R_JoinWindow_2582_5_905()
 {
    if (jj_scan_token(S_LONG)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(319)) {
    jj_scanpos = xsp;
    if (jj_scan_token(62)) return true;
    }
    xsp = jj_scanpos;
    if (jj_3R_JoinWindow_2583_11_912()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_102()
 {
    if (jj_scan_token(K_ON)) return true;
    if (jj_3R_Expression_2983_5_136()) return true;
    return false;
  }

  private boolean jj_3R_JoinerExpression_2557_25_187()
 {
    if (jj_scan_token(K_USING)) return true;
    if (jj_scan_token(325)) return true;
    if (jj_3R_Column_1626_5_133()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_JoinerExpression_2559_31_898()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(326)) return true;
    return false;
  }

  private boolean jj_3R_JoinerExpression_2534_46_720()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_JoinerExpression_2534_46_777()) {
    jj_scanpos = xsp;
    if (jj_3R_JoinerExpression_2534_81_778()) return true;
    }
    return false;
  }

  private boolean jj_3R_JoinerExpression_2534_46_777()
 {
    if (jj_scan_token(K_SEMI)) return true;
    return false;
  }

  private boolean jj_3R_JoinerExpression_2552_27_416()
 {
    if (jj_scan_token(K_WITHIN)) return true;
    if (jj_scan_token(325)) return true;
    if (jj_3R_JoinWindow_2582_5_905()) return true;
    if (jj_scan_token(326)) return true;
    return false;
  }

  private boolean jj_3R_JoinerExpression_2552_25_186()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_JoinerExpression_2552_27_416()) jj_scanpos = xsp;
    if (jj_scan_token(K_ON)) return true;
    if (jj_3R_Expression_2983_5_136()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_102()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_JoinerExpression_2544_24_413()
 {
    if (jj_scan_token(K_COMMA)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_JoinerExpression_2544_55_629()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_103()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_JoinerExpression_2552_25_186()) {
    jj_scanpos = xsp;
    if (jj_3R_JoinerExpression_2557_25_187()) return true;
    }
    return false;
  }

  private boolean jj_3R_JoinerExpression_2545_14_414()
 {
    if (jj_scan_token(K_STRAIGHT)) return true;
    return false;
  }

  private boolean jj_3_261()
 {
    if (jj_scan_token(K_ON)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(67)) {
    jj_scanpos = xsp;
    if (jj_scan_token(271)) return true;
    }
    return false;
  }

  private boolean jj_3R_JoinerExpression_2537_16_723()
 {
    if (jj_scan_token(K_OUTER)) return true;
    return false;
  }

  private boolean jj_3R_JoinerExpression_2541_11_628()
 {
    if (jj_scan_token(K_OUTER)) return true;
    return false;
  }

  private boolean jj_3R_JoinerExpression_2536_16_722()
 {
    if (jj_scan_token(K_FULL)) return true;
    return false;
  }

  private boolean jj_3_260()
 {
    if (jj_scan_token(K_ON)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(67)) {
    jj_scanpos = xsp;
    if (jj_scan_token(271)) return true;
    }
    return false;
  }

  private boolean jj_3R_JoinerExpression_2540_11_627()
 {
    if (jj_scan_token(K_CROSS)) return true;
    return false;
  }

  private boolean jj_3R_JoinerExpression_2535_16_721()
 {
    if (jj_scan_token(K_RIGHT)) return true;
    return false;
  }

  private boolean jj_3R_JoinerExpression_2539_11_626()
 {
    if (jj_scan_token(K_NATURAL)) return true;
    return false;
  }

  private boolean jj_3R_JoinerExpression_2535_14_624()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_JoinerExpression_2535_16_721()) {
    jj_scanpos = xsp;
    if (jj_3R_JoinerExpression_2536_16_722()) return true;
    }
    xsp = jj_scanpos;
    if (jj_3R_JoinerExpression_2537_16_723()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_JoinerExpression_2538_11_625()
 {
    if (jj_scan_token(K_INNER)) return true;
    return false;
  }

  private boolean jj_3R_JoinerExpression_2534_11_412()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_JoinerExpression_2534_11_623()) {
    jj_scanpos = xsp;
    if (jj_3R_JoinerExpression_2535_14_624()) {
    jj_scanpos = xsp;
    if (jj_3R_JoinerExpression_2538_11_625()) {
    jj_scanpos = xsp;
    if (jj_3R_JoinerExpression_2539_11_626()) {
    jj_scanpos = xsp;
    if (jj_3R_JoinerExpression_2540_11_627()) {
    jj_scanpos = xsp;
    if (jj_3R_JoinerExpression_2541_11_628()) return true;
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_JoinerExpression_2534_11_623()
 {
    if (jj_scan_token(K_LEFT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_JoinerExpression_2534_46_720()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_JoinerExpression_2531_5_185()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_JoinerExpression_2534_11_412()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(135)) {
    jj_scanpos = xsp;
    if (jj_3R_JoinerExpression_2544_24_413()) {
    jj_scanpos = xsp;
    if (jj_3R_JoinerExpression_2545_14_414()) {
    jj_scanpos = xsp;
    if (jj_3R_JoinerExpression_2545_57_415()) return true;
    }
    }
    }
    if (jj_3R_FromItem_2370_5_156()) return true;
    xsp = jj_scanpos;
    if (jj_3_103()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_259()
 {
    if (jj_scan_token(K_ON)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(67)) {
    jj_scanpos = xsp;
    if (jj_scan_token(271)) return true;
    }
    return false;
  }

  private boolean jj_3_258()
 {
    if (jj_scan_token(K_ON)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(67)) {
    jj_scanpos = xsp;
    if (jj_scan_token(271)) return true;
    }
    return false;
  }

  private boolean jj_3R_SubJoinsList_2515_6_717()
 {
    if (jj_3R_JoinerExpression_2531_5_185()) return true;
    return false;
  }

  private boolean jj_3R_SubJoinsList_2515_5_617()
 {
    Token xsp;
    if (jj_3R_SubJoinsList_2515_6_717()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_SubJoinsList_2515_6_717()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_101()
 {
    if (jj_3R_JoinerExpression_2531_5_185()) return true;
    return false;
  }

  private boolean jj_3R_JoinsList_2504_5_145()
 {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_101()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_256()
 {
    if (jj_scan_token(K_COLUMN)) return true;
    return false;
  }

  private boolean jj_3R_AlterExpression_5554_17_275()
 {
    if (jj_3R_AlterExpressionColumnDropNotNull_5460_5_550()) return true;
    return false;
  }

  private boolean jj_3_257()
 {
    if (jj_3R_AlterExpressionColumnDataType_5442_5_273()) return true;
    return false;
  }

  private boolean jj_3R_SubJoin_2489_5_407()
 {
    if (jj_3R_SubJoinsList_2515_5_617()) return true;
    return false;
  }

  private boolean jj_3_264()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_256()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_257()) {
    jj_scanpos = xsp;
    if (jj_3R_AlterExpression_5554_17_275()) return true;
    }
    return false;
  }

  private boolean jj_3R_AlterExpression_5540_16_274()
 {
    if (jj_scan_token(K_KEY)) return true;
    return false;
  }

  private boolean jj_3_262()
 {
    if (jj_scan_token(K_PRIMARY)) return true;
    if (jj_scan_token(K_KEY)) return true;
    return false;
  }

  private boolean jj_3_263()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_AlterExpression_5540_16_274()) {
    jj_scanpos = xsp;
    if (jj_scan_token(126)) return true;
    }
    if (jj_3R_RelObjectName_1689_5_173()) return true;
    return false;
  }

  private boolean jj_3R_LateralSubSelect_2475_5_712()
 {
    if (jj_scan_token(K_LATERAL)) return true;
    if (jj_scan_token(325)) return true;
    if (jj_3R_SubSelect_4738_5_134()) return true;
    if (jj_scan_token(326)) return true;
    return false;
  }

  private boolean jj_3R_ValuesList_2458_15_719()
 {
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_3R_RelObjectName_1689_5_173()) return true;
    return false;
  }

  private boolean jj_3R_ValuesList_2456_11_622()
 {
    if (jj_scan_token(325)) return true;
    if (jj_3R_RelObjectName_1689_5_173()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_ValuesList_2458_15_719()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(326)) return true;
    return false;
  }

  private boolean jj_3R_ValuesList_2447_18_718()
 {
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_3R_SimpleExpression_3535_5_132()) return true;
    return false;
  }

  private boolean jj_3R_FromItem_2406_57_716()
 {
    if (jj_3R_Pivot_2269_5_774()) return true;
    return false;
  }

  private boolean jj_3R_ValuesList_2454_7_411()
 {
    if (jj_3R_Alias_2114_5_175()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ValuesList_2456_11_622()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_ValuesList_2450_10_621()
 {
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_3R_SimpleExpression_3535_5_132()) return true;
    return false;
  }

  private boolean jj_3R_ValuesList_2444_14_620()
 {
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_scan_token(325)) return true;
    if (jj_3R_SimpleExpression_3535_5_132()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_ValuesList_2447_18_718()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(326)) return true;
    return false;
  }

  private boolean jj_3R_ValuesList_2442_14_184()
 {
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_3R_SimpleExpression_3535_5_132()) return true;
    return false;
  }

  private boolean jj_3_100()
 {
    if (jj_3R_SimpleExpression_3535_5_132()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_ValuesList_2450_10_621()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_99()
 {
    if (jj_scan_token(325)) return true;
    if (jj_3R_SimpleExpression_3535_5_132()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_ValuesList_2442_14_184()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(326)) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_ValuesList_2444_14_620()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_ValuesList_2439_5_183()
 {
    if (jj_scan_token(325)) return true;
    if (jj_scan_token(K_VALUES)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_99()) {
    jj_scanpos = xsp;
    if (jj_3_100()) return true;
    }
    if (jj_scan_token(326)) return true;
    xsp = jj_scanpos;
    if (jj_3R_ValuesList_2454_7_411()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_FromItem_2415_21_182()
 {
    if (jj_3R_SQLServerHints_2139_5_410()) return true;
    return false;
  }

  private boolean jj_3_96()
 {
    if (jj_3R_PivotXml_2297_5_180()) return true;
    return false;
  }

  private boolean jj_3_95()
 {
    if (jj_3R_UnPivot_2327_5_178()) return true;
    return false;
  }

  private boolean jj_3R_FromItem_2406_26_616()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_96()) {
    jj_scanpos = xsp;
    if (jj_3R_FromItem_2406_57_716()) return true;
    }
    return false;
  }

  private boolean jj_3R_FromItem_2410_21_181()
 {
    if (jj_3R_MySQLIndexHint_2153_9_409()) return true;
    return false;
  }

  private boolean jj_3_97()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_FromItem_2410_21_181()) {
    jj_scanpos = xsp;
    if (jj_3R_FromItem_2415_21_182()) return true;
    }
    return false;
  }

  private boolean jj_3_94()
 {
    if (jj_3R_TableFunction_4724_5_179()) return true;
    return false;
  }

  private boolean jj_3R_FromItem_2402_17_605()
 {
    if (jj_3R_LateralSubSelect_2475_5_712()) return true;
    return false;
  }

  private boolean jj_3R_FromItem_2404_15_615()
 {
    if (jj_3R_Alias_2114_5_175()) return true;
    return false;
  }

  private boolean jj_3_93()
 {
    if (jj_3R_UnPivot_2327_5_178()) return true;
    return false;
  }

  private boolean jj_3R_FromItem_2400_17_604()
 {
    if (jj_3R_Table_1750_5_176()) return true;
    return false;
  }

  private boolean jj_3R_FromItem_2397_17_603()
 {
    if (jj_3R_TableFunction_4724_5_179()) return true;
    return false;
  }

  private boolean jj_3R_FromItem_2386_27_715()
 {
    if (jj_3R_SetOperationListWithoutIntialSelect_1988_5_773()) return true;
    return false;
  }

  private boolean jj_3R_FromItem_2384_25_714()
 {
    if (jj_3R_SubSelect_4738_5_134()) return true;
    return false;
  }

  private boolean jj_3R_FromItem_2380_27_177()
 {
    if (jj_3R_SubJoin_2489_5_407()) return true;
    return false;
  }

  private boolean jj_3_91()
 {
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_3R_Table_1750_5_176()) return true;
    return false;
  }

  private boolean jj_3_92()
 {
    if (jj_3R_FromItem_2370_5_156()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_FromItem_2380_27_177()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_AlterExpressionColumnDropNotNull_5462_6_680()
 {
    if (jj_scan_token(K_NOT)) return true;
    return false;
  }

  private boolean jj_3R_AlterExpressionColumnDropNotNull_5460_5_550()
 {
    if (jj_3R_RelObjectName_1689_5_173()) return true;
    if (jj_scan_token(K_DROP)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_AlterExpressionColumnDropNotNull_5462_6_680()) jj_scanpos = xsp;
    if (jj_scan_token(K_NULL)) return true;
    return false;
  }

  private boolean jj_3R_FromItem_2375_17_602()
 {
    if (jj_scan_token(325)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_92()) {
    jj_scanpos = xsp;
    if (jj_3R_FromItem_2384_25_714()) return true;
    }
    xsp = jj_scanpos;
    if (jj_3R_FromItem_2386_27_715()) jj_scanpos = xsp;
    if (jj_scan_token(326)) return true;
    xsp = jj_scanpos;
    if (jj_3_93()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_98()
 {
    if (jj_3R_ValuesList_2439_5_183()) return true;
    return false;
  }

  private boolean jj_3R_FromItem_2373_9_394()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_FromItem_2375_17_602()) {
    jj_scanpos = xsp;
    if (jj_3R_FromItem_2397_17_603()) {
    jj_scanpos = xsp;
    if (jj_3R_FromItem_2400_17_604()) {
    jj_scanpos = xsp;
    if (jj_3R_FromItem_2402_17_605()) return true;
    }
    }
    }
    xsp = jj_scanpos;
    if (jj_3R_FromItem_2404_15_615()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_95()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_FromItem_2406_26_616()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_97()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_AlterExpressionColumnDataType_5445_7_679()
 {
    if (jj_3R_CreateParameter_5215_9_262()) return true;
    return false;
  }

  private boolean jj_3R_FromItem_2371_9_393()
 {
    if (jj_3R_ValuesList_2439_5_183()) return true;
    return false;
  }

  private boolean jj_3R_AlterExpressionColumnDataType_5443_6_548()
 {
    if (jj_scan_token(K_TYPE)) return true;
    return false;
  }

  private boolean jj_3R_AlterExpressionColumnDataType_5442_5_273()
 {
    if (jj_3R_RelObjectName_1689_5_173()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_AlterExpressionColumnDataType_5443_6_548()) jj_scanpos = xsp;
    if (jj_3R_ColDataType_5116_5_549()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_AlterExpressionColumnDataType_5445_7_679()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_FromItem_2370_5_156()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_FromItem_2371_9_393()) {
    jj_scanpos = xsp;
    if (jj_3R_FromItem_2373_9_394()) return true;
    }
    return false;
  }

  private boolean jj_3R_Truncate_5425_5_559()
 {
    if (jj_scan_token(K_TRUNCATE)) return true;
    return false;
  }

  private boolean jj_3R_IntoClause_2352_5_849()
 {
    if (jj_scan_token(K_INTO)) return true;
    if (jj_3R_Table_1750_5_176()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_91()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_90()
 {
    if (jj_3R_Alias_2114_5_175()) return true;
    return false;
  }

  private boolean jj_3_255()
 {
    if (jj_scan_token(K_IF)) return true;
    if (jj_scan_token(K_EXISTS)) return true;
    return false;
  }

  private boolean jj_3R_UnPivot_2328_9_618()
 {
    if (jj_scan_token(K_INCLUDE)) return true;
    if (jj_scan_token(K_NULLS)) return true;
    return false;
  }

  private boolean jj_3R_UnPivot_2329_7_619()
 {
    if (jj_scan_token(K_EXCLUDE)) return true;
    if (jj_scan_token(K_NULLS)) return true;
    return false;
  }

  private boolean jj_3R_UnPivot_2328_7_408()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_UnPivot_2328_9_618()) {
    jj_scanpos = xsp;
    if (jj_3R_UnPivot_2329_7_619()) return true;
    }
    return false;
  }

  private boolean jj_3R_UnPivot_2327_5_178()
 {
    if (jj_scan_token(K_UNPIVOT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_UnPivot_2328_7_408()) jj_scanpos = xsp;
    if (jj_scan_token(325)) return true;
    if (jj_3R_PivotForColumns_2192_5_887()) return true;
    if (jj_scan_token(K_FOR)) return true;
    if (jj_3R_PivotForColumns_2192_5_887()) return true;
    if (jj_scan_token(K_IN)) return true;
    if (jj_scan_token(325)) return true;
    if (jj_3R_PivotSingleInItems_2218_4_174()) return true;
    if (jj_scan_token(326)) return true;
    if (jj_scan_token(326)) return true;
    xsp = jj_scanpos;
    if (jj_3_90()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_Drop_5391_5_558()
 {
    if (jj_scan_token(K_DROP)) return true;
    return false;
  }

  private boolean jj_3R_ColumnsNamesList_5375_12_704()
 {
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_3R_ColumnsNamesListItem_5360_9_703()) return true;
    return false;
  }

  private boolean jj_3R_PivotXml_2304_9_892()
 {
    if (jj_3R_PivotMultiInItems_2254_4_902()) return true;
    return false;
  }

  private boolean jj_3R_AList_5345_38_843()
 {
    if (jj_scan_token(327)) return true;
    return false;
  }

  private boolean jj_3_89()
 {
    if (jj_3R_PivotSingleInItems_2218_4_174()) return true;
    return false;
  }

  private boolean jj_3R_PivotXml_2302_9_891()
 {
    if (jj_3R_SelectBody_1796_5_341()) return true;
    return false;
  }

  private boolean jj_3_88()
 {
    if (jj_scan_token(K_ANY)) return true;
    return false;
  }

  private boolean jj_3R_ColumnsNamesList_5373_5_589()
 {
    if (jj_scan_token(325)) return true;
    if (jj_3R_ColumnsNamesListItem_5360_9_703()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_ColumnsNamesList_5375_12_704()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(326)) return true;
    return false;
  }

  private boolean jj_3R_PivotXml_2297_5_180()
 {
    if (jj_scan_token(K_PIVOT)) return true;
    if (jj_scan_token(K_XML)) return true;
    if (jj_scan_token(325)) return true;
    if (jj_3R_PivotFunctionItems_2207_5_890()) return true;
    if (jj_scan_token(K_FOR)) return true;
    if (jj_3R_PivotForColumns_2192_5_887()) return true;
    if (jj_scan_token(K_IN)) return true;
    if (jj_scan_token(325)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_88()) {
    jj_scanpos = xsp;
    if (jj_3R_PivotXml_2302_9_891()) {
    jj_scanpos = xsp;
    if (jj_3_89()) {
    jj_scanpos = xsp;
    if (jj_3R_PivotXml_2304_9_892()) return true;
    }
    }
    }
    if (jj_scan_token(326)) return true;
    if (jj_scan_token(326)) return true;
    return false;
  }

  private boolean jj_3R_ColumnsNamesListItem_5361_11_764()
 {
    if (jj_scan_token(325)) return true;
    if (jj_scan_token(S_LONG)) return true;
    if (jj_scan_token(326)) return true;
    return false;
  }

  private boolean jj_3R_ColumnsNamesListItem_5360_9_703()
 {
    if (jj_3R_RelObjectName_1689_5_173()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ColumnsNamesListItem_5361_11_764()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_AList_5344_12_797()
 {
    if (jj_3R_RelObjectNameWithoutValue_1641_5_612()) return true;
    return false;
  }

  private boolean jj_3R_AList_5345_10_842()
 {
    if (jj_scan_token(K_COMMA)) return true;
    return false;
  }

  private boolean jj_3R_Pivot_2276_7_894()
 {
    if (jj_3R_Alias_2114_5_175()) return true;
    return false;
  }

  private boolean jj_3R_AList_5345_9_818()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_AList_5345_10_842()) {
    jj_scanpos = xsp;
    if (jj_3R_AList_5345_38_843()) return true;
    }
    return false;
  }

  private boolean jj_3R_AList_5343_10_796()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(313)) {
    jj_scanpos = xsp;
    if (jj_scan_token(312)) {
    jj_scanpos = xsp;
    if (jj_scan_token(322)) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_Pivot_2273_7_893()
 {
    if (jj_3R_PivotMultiInItems_2254_4_902()) return true;
    return false;
  }

  private boolean jj_3R_AList_5343_8_747()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_AList_5343_10_796()) {
    jj_scanpos = xsp;
    if (jj_3R_AList_5344_12_797()) return true;
    }
    xsp = jj_scanpos;
    if (jj_3R_AList_5345_9_818()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_87()
 {
    if (jj_3R_PivotSingleInItems_2218_4_174()) return true;
    return false;
  }

  private boolean jj_3R_AList_5340_6_673()
 {
    if (jj_scan_token(325)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_AList_5343_8_747()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(326)) return true;
    return false;
  }

  private boolean jj_3R_Pivot_2269_5_774()
 {
    if (jj_scan_token(K_PIVOT)) return true;
    if (jj_scan_token(325)) return true;
    if (jj_3R_PivotFunctionItems_2207_5_890()) return true;
    if (jj_scan_token(K_FOR)) return true;
    if (jj_3R_PivotForColumns_2192_5_887()) return true;
    if (jj_scan_token(K_IN)) return true;
    if (jj_scan_token(325)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_87()) {
    jj_scanpos = xsp;
    if (jj_3R_Pivot_2273_7_893()) return true;
    }
    if (jj_scan_token(326)) return true;
    if (jj_scan_token(326)) return true;
    xsp = jj_scanpos;
    if (jj_3R_Pivot_2276_7_894()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_RowMovement_5328_5_702()
 {
    if (jj_scan_token(K_DISABLE)) return true;
    if (jj_scan_token(K_ROW)) return true;
    if (jj_scan_token(K_MOVEMENT)) return true;
    return false;
  }

  private boolean jj_3R_PivotMultiInItems_2255_5_911()
 {
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_3R_ExpressionListItem_2241_5_910()) return true;
    return false;
  }

  private boolean jj_3R_RowMovement_5326_5_701()
 {
    if (jj_scan_token(K_ENABLE)) return true;
    if (jj_scan_token(K_ROW)) return true;
    if (jj_scan_token(K_MOVEMENT)) return true;
    return false;
  }

  private boolean jj_3R_PivotMultiInItems_2254_4_902()
 {
    if (jj_3R_ExpressionListItem_2241_5_910()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_PivotMultiInItems_2255_5_911()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_RowMovement_5325_3_582()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_RowMovement_5326_5_701()) {
    jj_scanpos = xsp;
    if (jj_3R_RowMovement_5328_5_702()) return true;
    }
    return false;
  }

  private boolean jj_3R_CreateParameter_5314_13_546()
 {
    if (jj_scan_token(363)) return true;
    if (jj_3R_ColDataType_5116_5_549()) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_5312_13_545()
 {
    if (jj_scan_token(K_ARRAY_LITERAL)) return true;
    if (jj_3R_ArrayConstructor_3944_5_238()) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_5310_13_544()
 {
    if (jj_scan_token(K_PARALLEL)) return true;
    return false;
  }

  private boolean jj_3R_ExpressionListItem_2244_6_915()
 {
    if (jj_3R_Alias_2114_5_175()) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_5308_13_543()
 {
    if (jj_scan_token(K_FALSE)) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_5306_13_542()
 {
    if (jj_scan_token(K_TRUE)) return true;
    return false;
  }

  private boolean jj_3R_ExpressionListItem_2241_5_910()
 {
    if (jj_scan_token(325)) return true;
    if (jj_3R_SimpleExpressionList_3358_5_169()) return true;
    if (jj_scan_token(326)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ExpressionListItem_2244_6_915()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_PivotSelectExprItem_2231_15_613()
 {
    if (jj_3R_Alias_2114_5_175()) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_5304_13_541()
 {
    if (jj_scan_token(K_DESC)) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_5302_13_540()
 {
    if (jj_scan_token(K_ASC)) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_5300_13_539()
 {
    if (jj_scan_token(K_COLLATE)) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_5298_13_538()
 {
    if (jj_scan_token(K_USING)) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_5296_13_537()
 {
    if (jj_scan_token(K_COMMENT)) return true;
    return false;
  }

  private boolean jj_3R_PivotSelectExprItem_2230_7_402()
 {
    if (jj_3R_SimpleExpression_3535_5_132()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_PivotSelectExprItem_2231_15_613()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_CreateParameter_5294_13_536()
 {
    if (jj_scan_token(K_TYPE)) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_5292_13_535()
 {
    if (jj_scan_token(K_IN)) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_5290_13_534()
 {
    if (jj_scan_token(K_BY)) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_5288_13_533()
 {
    if (jj_scan_token(K_PARTITION)) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_5286_13_532()
 {
    if (jj_scan_token(K_TEMPORARY)) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_5284_13_531()
 {
    if (jj_scan_token(K_TEMP)) return true;
    return false;
  }

  private boolean jj_3R_PivotSingleInItems_2219_5_403()
 {
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_3R_PivotSelectExprItem_2230_7_402()) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_5282_13_530()
 {
    if (jj_scan_token(K_UNSIGNED)) return true;
    return false;
  }

  private boolean jj_3R_PivotSingleInItems_2218_4_174()
 {
    if (jj_3R_PivotSelectExprItem_2230_7_402()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_PivotSingleInItems_2219_5_403()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_CreateParameter_5280_13_529()
 {
    if (jj_scan_token(K_WHERE)) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_5278_13_528()
 {
    if (jj_scan_token(K_EXCLUDE)) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_5276_13_527()
 {
    if (jj_scan_token(K_WITH)) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_5274_13_526()
 {
    if (jj_scan_token(K_CONSTRAINT)) return true;
    return false;
  }

  private boolean jj_3R_PivotFunctionItems_2208_7_901()
 {
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_3R_FunctionItem_2181_5_900()) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_5272_13_525()
 {
    if (jj_scan_token(K_CHECK)) return true;
    if (jj_scan_token(325)) return true;
    if (jj_3R_Expression_2983_5_136()) return true;
    if (jj_scan_token(326)) return true;
    return false;
  }

  private boolean jj_3R_PivotFunctionItems_2207_5_890()
 {
    if (jj_3R_FunctionItem_2181_5_900()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_PivotFunctionItems_2208_7_901()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_CreateParameter_5270_13_524()
 {
    if (jj_3R_AList_5340_6_673()) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_5268_13_523()
 {
    if (jj_scan_token(K_TABLESPACE)) return true;
    if (jj_3R_RelObjectName_1689_5_173()) return true;
    return false;
  }

  private boolean jj_3_254()
 {
    if (jj_scan_token(K_USING)) return true;
    if (jj_scan_token(K_INDEX)) return true;
    if (jj_scan_token(K_TABLESPACE)) return true;
    if (jj_3R_RelObjectName_1689_5_173()) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_5264_13_522()
 {
    if (jj_scan_token(327)) return true;
    return false;
  }

  private boolean jj_3R_PivotForColumns_2194_11_899()
 {
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_3R_Column_1626_5_133()) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_5262_13_521()
 {
    if (jj_scan_token(K_TIME_KEY_EXPR)) return true;
    return false;
  }

  private boolean jj_3R_PivotForColumns_2196_7_889()
 {
    if (jj_3R_Column_1626_5_133()) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_5236_38_746()
 {
    if (jj_scan_token(345)) return true;
    return false;
  }

  private boolean jj_3R_PivotForColumns_2193_9_888()
 {
    if (jj_scan_token(325)) return true;
    if (jj_3R_Column_1626_5_133()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_PivotForColumns_2194_11_899()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(326)) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_5260_13_520()
 {
    if (jj_scan_token(K_UPDATE)) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_5258_13_519()
 {
    if (jj_scan_token(K_DELETE)) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_5256_13_518()
 {
    if (jj_scan_token(K_CASCADE)) return true;
    return false;
  }

  private boolean jj_3R_FunctionItem_2182_15_909()
 {
    if (jj_3R_Alias_2114_5_175()) return true;
    return false;
  }

  private boolean jj_3R_PivotForColumns_2192_5_887()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_PivotForColumns_2193_9_888()) {
    jj_scanpos = xsp;
    if (jj_3R_PivotForColumns_2196_7_889()) return true;
    }
    return false;
  }

  private boolean jj_3R_CreateParameter_5254_13_517()
 {
    if (jj_scan_token(K_UNIQUE)) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_5252_13_516()
 {
    if (jj_scan_token(K_ROWS)) return true;
    return false;
  }

  private boolean jj_3R_Alias_2120_72_808()
 {
    if (jj_3R_ColDataType_5116_5_549()) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_5250_13_515()
 {
    if (jj_scan_token(K_DROP)) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_5248_13_514()
 {
    if (jj_scan_token(K_COMMIT)) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_5246_13_513()
 {
    if (jj_scan_token(K_ON)) return true;
    return false;
  }

  private boolean jj_3R_FunctionItem_2181_5_900()
 {
    if (jj_3R_Function_4573_5_210()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_FunctionItem_2182_15_909()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_CreateParameter_5244_13_512()
 {
    if (jj_scan_token(K_AS)) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_5240_16_672()
 {
    if (jj_scan_token(S_DOUBLE)) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_5238_16_671()
 {
    if (jj_scan_token(S_LONG)) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_5236_16_670()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_CreateParameter_5236_16_745()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_5236_38_746()) return true;
    }
    return false;
  }

  private boolean jj_3R_CreateParameter_5236_16_745()
 {
    if (jj_scan_token(333)) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_5236_15_511()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_CreateParameter_5236_16_670()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_CreateParameter_5238_16_671()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_5240_16_672()) return true;
    }
    return false;
  }

  private boolean jj_3R_MySQLIndexHint_2167_10_895()
 {
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_3R_RelObjectNameWithoutValue_1641_5_612()) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_5234_13_510()
 {
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_5232_13_509()
 {
    if (jj_scan_token(K_KEY)) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_5230_13_508()
 {
    if (jj_scan_token(K_REFERENCES)) return true;
    return false;
  }

  private boolean jj_3R_SQLServerHints_2140_31_897()
 {
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_3R_SQLServerHint_2130_9_896()) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_5228_13_507()
 {
    if (jj_scan_token(K_FOREIGN)) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_5226_13_506()
 {
    if (jj_scan_token(K_DEFAULT)) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_5224_13_505()
 {
    if (jj_scan_token(K_PRIMARY)) return true;
    return false;
  }

  private boolean jj_3R_Alias_2119_45_775()
 {
    if (jj_3R_ColDataType_5116_5_549()) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_5222_13_504()
 {
    if (jj_scan_token(K_NOT)) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_5217_18_669()
 {
    if (jj_scan_token(329)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(319)) {
    jj_scanpos = xsp;
    if (jj_scan_token(323)) return true;
    }
    return false;
  }

  private boolean jj_3R_MySQLIndexHint_2153_9_409()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(274)) {
    jj_scanpos = xsp;
    if (jj_scan_token(239)) {
    jj_scanpos = xsp;
    if (jj_scan_token(121)) {
    jj_scanpos = xsp;
    if (jj_scan_token(102)) return true;
    }
    }
    }
    xsp = jj_scanpos;
    if (jj_scan_token(126)) {
    jj_scanpos = xsp;
    if (jj_scan_token(142)) return true;
    }
    if (jj_scan_token(325)) return true;
    if (jj_3R_RelObjectNameWithoutValue_1641_5_612()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_MySQLIndexHint_2167_10_895()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(326)) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_5220_13_503()
 {
    if (jj_scan_token(K_NULL)) return true;
    return false;
  }

  private boolean jj_3R_Alias_2115_46_406()
 {
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_CreateParameter_5216_13_502()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(319)) {
    jj_scanpos = xsp;
    if (jj_scan_token(323)) return true;
    }
    xsp = jj_scanpos;
    if (jj_3R_CreateParameter_5217_18_669()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_CreateParameter_5215_9_262()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_CreateParameter_5216_13_502()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_5220_13_503()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_5222_13_504()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_5224_13_505()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_5226_13_506()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_5228_13_507()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_5230_13_508()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_5232_13_509()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_5234_13_510()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_5236_15_511()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_5244_13_512()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_5246_13_513()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_5248_13_514()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_5250_13_515()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_5252_13_516()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_5254_13_517()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_5256_13_518()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_5258_13_519()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_5260_13_520()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_5262_13_521()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_5264_13_522()) {
    jj_scanpos = xsp;
    if (jj_3_254()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_5268_13_523()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_5270_13_524()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_5272_13_525()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_5274_13_526()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_5276_13_527()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_5278_13_528()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_5280_13_529()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_5282_13_530()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_5284_13_531()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_5286_13_532()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_5288_13_533()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_5290_13_534()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_5292_13_535()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_5294_13_536()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_5296_13_537()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_5298_13_538()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_5300_13_539()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_5302_13_540()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_5304_13_541()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_5306_13_542()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_5308_13_543()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_5310_13_544()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_5312_13_545()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateParameter_5314_13_546()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_ColDataType_5130_90_812()
 {
    if (jj_scan_token(K_COMMA)) return true;
    return false;
  }

  private boolean jj_3R_AlterView_5196_22_339()
 {
    if (jj_scan_token(K_REPLACE)) return true;
    return false;
  }

  private boolean jj_3R_SQLServerHints_2139_5_410()
 {
    if (jj_scan_token(K_WITH)) return true;
    if (jj_scan_token(325)) return true;
    if (jj_3R_SQLServerHint_2130_9_896()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_SQLServerHints_2140_31_897()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(326)) return true;
    return false;
  }

  private boolean jj_3R_SQLServerHint_2132_9_904()
 {
    if (jj_scan_token(K_NOLOCK)) return true;
    return false;
  }

  private boolean jj_3R_SetOperationListWithoutIntialSelect_2003_137_611()
 {
    if (jj_scan_token(K_DISTINCT)) return true;
    return false;
  }

  private boolean jj_3R_SQLServerHint_2130_9_903()
 {
    if (jj_scan_token(K_INDEX)) return true;
    if (jj_scan_token(325)) return true;
    if (jj_3R_RelObjectName_1689_5_173()) return true;
    if (jj_scan_token(326)) return true;
    return false;
  }

  private boolean jj_3R_SQLServerHint_2130_9_896()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_SQLServerHint_2130_9_903()) {
    jj_scanpos = xsp;
    if (jj_3R_SQLServerHint_2132_9_904()) return true;
    }
    return false;
  }

  private boolean jj_3R_Alias_2120_18_776()
 {
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_3R_RelObjectName_1689_5_173()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_Alias_2120_72_808()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_AlterView_5198_7_340()
 {
    if (jj_3R_ColumnsNamesList_5373_5_589()) return true;
    return false;
  }

  private boolean jj_3R_AlterView_5196_5_125()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(11)) {
    jj_scanpos = xsp;
    if (jj_3R_AlterView_5196_22_339()) return true;
    }
    if (jj_scan_token(K_VIEW)) return true;
    if (jj_3R_Table_1750_5_176()) return true;
    xsp = jj_scanpos;
    if (jj_3R_AlterView_5198_7_340()) jj_scanpos = xsp;
    if (jj_scan_token(K_AS)) return true;
    if (jj_3R_SelectBody_1796_5_341()) return true;
    return false;
  }

  private boolean jj_3_86()
 {
    if (jj_scan_token(325)) return true;
    if (jj_3R_RelObjectName_1689_5_173()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_Alias_2119_45_775()) jj_scanpos = xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_Alias_2120_18_776()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(326)) return true;
    return false;
  }

  private boolean jj_3_83()
 {
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_3R_SelectItem_2082_5_170()) return true;
    return false;
  }

  private boolean jj_3R_Action_5180_19_866()
 {
    if (jj_scan_token(K_NULL)) return true;
    return false;
  }

  private boolean jj_3R_Action_5182_15_867()
 {
    if (jj_scan_token(K_DEFAULT)) return true;
    return false;
  }

  private boolean jj_3R_Alias_2115_11_405()
 {
    if (jj_3R_RelObjectNameWithoutStart_1702_5_614()) return true;
    return false;
  }

  private boolean jj_3R_Alias_2114_6_404()
 {
    if (jj_scan_token(K_AS)) return true;
    return false;
  }

  private boolean jj_3R_Alias_2114_5_175()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_Alias_2114_6_404()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_Alias_2115_11_405()) {
    jj_scanpos = xsp;
    if (jj_3R_Alias_2115_46_406()) return true;
    }
    xsp = jj_scanpos;
    if (jj_3_86()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_Action_5179_6_848()
 {
    if (jj_scan_token(K_SET)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_Action_5180_19_866()) {
    jj_scanpos = xsp;
    if (jj_3R_Action_5182_15_867()) return true;
    }
    return false;
  }

  private boolean jj_3_251()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(31)) {
    jj_scanpos = xsp;
    if (jj_scan_token(43)) return true;
    }
    return false;
  }

  private boolean jj_3R_Action_5177_6_847()
 {
    if (jj_scan_token(K_NO)) return true;
    if (jj_scan_token(K_ACTION)) return true;
    return false;
  }

  private boolean jj_3R_Action_5175_6_846()
 {
    if (jj_scan_token(K_RESTRICT)) return true;
    return false;
  }

  private boolean jj_3R_Action_5173_6_845()
 {
    if (jj_scan_token(K_CASCADE)) return true;
    return false;
  }

  private boolean jj_3R_Action_5173_5_820()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_Action_5173_6_845()) {
    jj_scanpos = xsp;
    if (jj_3R_Action_5175_6_846()) {
    jj_scanpos = xsp;
    if (jj_3R_Action_5177_6_847()) {
    jj_scanpos = xsp;
    if (jj_3R_Action_5179_6_848()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_SetOperationListWithoutIntialSelect_2003_103_398()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_SetOperationListWithoutIntialSelect_2003_103_610()) {
    jj_scanpos = xsp;
    if (jj_3R_SetOperationListWithoutIntialSelect_2003_137_611()) return true;
    }
    return false;
  }

  private boolean jj_3R_SetOperationListWithoutIntialSelect_2003_103_610()
 {
    if (jj_scan_token(K_ALL)) return true;
    return false;
  }

  private boolean jj_3R_AllTableColumns_2098_6_171()
 {
    if (jj_3R_Table_1750_5_176()) return true;
    if (jj_scan_token(329)) return true;
    if (jj_scan_token(328)) return true;
    return false;
  }

  private boolean jj_3R_CreateView_5164_7_338()
 {
    if (jj_scan_token(K_WITH)) return true;
    if (jj_scan_token(K_READ)) return true;
    if (jj_scan_token(K_ONLY)) return true;
    return false;
  }

  private boolean jj_3_84()
 {
    if (jj_3R_AllTableColumns_2098_6_171()) return true;
    return false;
  }

  private boolean jj_3R_ColDataType_5129_40_547()
 {
    if (jj_scan_token(S_LONG)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_251()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_CreateView_5161_7_337()
 {
    if (jj_3R_ColumnsNamesList_5373_5_589()) return true;
    return false;
  }

  private boolean jj_3R_CreateView_5157_11_588()
 {
    if (jj_scan_token(K_TEMPORARY)) return true;
    return false;
  }

  private boolean jj_3R_ColDataType_5129_38_272()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ColDataType_5129_40_547()) {
    jj_scanpos = xsp;
    if (jj_scan_token(322)) {
    jj_scanpos = xsp;
    if (jj_scan_token(319)) {
    jj_scanpos = xsp;
    if (jj_scan_token(43)) return true;
    }
    }
    }
    xsp = jj_scanpos;
    if (jj_3R_ColDataType_5130_90_812()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_CreateView_5159_7_336()
 {
    if (jj_scan_token(K_MATERIALIZED)) return true;
    return false;
  }

  private boolean jj_3R_CreateView_5156_9_335()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_CreateView_5156_9_587()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateView_5157_11_588()) return true;
    }
    return false;
  }

  private boolean jj_3R_CreateView_5156_9_587()
 {
    if (jj_scan_token(K_TEMP)) return true;
    return false;
  }

  private boolean jj_3R_CreateView_5153_11_586()
 {
    if (jj_scan_token(K_FORCE)) return true;
    return false;
  }

  private boolean jj_3_85()
 {
    if (jj_3R_SelectExpressionItem_2073_7_172()) return true;
    return false;
  }

  private boolean jj_3R_CreateView_5152_9_334()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_CreateView_5152_9_585()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateView_5153_11_586()) return true;
    }
    return false;
  }

  private boolean jj_3R_CreateView_5152_9_585()
 {
    if (jj_scan_token(K_NO)) return true;
    if (jj_scan_token(K_FORCE)) return true;
    return false;
  }

  private boolean jj_3_249()
 {
    if (jj_scan_token(S_IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_SelectItem_2083_5_400()
 {
    if (jj_3R_AllTableColumns_2098_6_171()) return true;
    return false;
  }

  private boolean jj_3R_SelectItem_2081_6_399()
 {
    if (jj_scan_token(328)) return true;
    return false;
  }

  private boolean jj_3R_SelectItem_2082_5_170()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_SelectItem_2081_6_399()) {
    jj_scanpos = xsp;
    if (jj_3R_SelectItem_2083_5_400()) {
    jj_scanpos = xsp;
    if (jj_3_85()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_CreateView_5150_7_333()
 {
    if (jj_scan_token(K_OR)) return true;
    if (jj_scan_token(K_REPLACE)) return true;
    return false;
  }

  private boolean jj_3R_WithList_2024_60_742()
 {
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_3R_WithItem_2039_6_711()) return true;
    return false;
  }

  private boolean jj_3R_CreateView_5149_5_124()
 {
    if (jj_scan_token(K_CREATE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_CreateView_5150_7_333()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_CreateView_5152_9_334()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_CreateView_5156_9_335()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_CreateView_5159_7_336()) jj_scanpos = xsp;
    if (jj_scan_token(K_VIEW)) return true;
    if (jj_3R_Table_1750_5_176()) return true;
    xsp = jj_scanpos;
    if (jj_3R_CreateView_5161_7_337()) jj_scanpos = xsp;
    if (jj_scan_token(K_AS)) return true;
    if (jj_3R_SelectWithWithItems_1775_5_140()) return true;
    xsp = jj_scanpos;
    if (jj_3R_CreateView_5164_7_338()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_SelectExpressionItem_2074_8_881()
 {
    if (jj_3R_Alias_2114_5_175()) return true;
    return false;
  }

  private boolean jj_3_248()
 {
    if (jj_scan_token(K_PRECISION)) return true;
    return false;
  }

  private boolean jj_3R_SelectExpressionItem_2073_7_172()
 {
    if (jj_3R_Expression_2983_5_136()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_SelectExpressionItem_2074_8_881()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_ColDataType_5121_27_781()
 {
    if (jj_scan_token(329)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(319)) {
    jj_scanpos = xsp;
    if (jj_scan_token(323)) return true;
    }
    return false;
  }

  private boolean jj_3R_ColDataType_5126_19_678()
 {
    if (jj_scan_token(K_SIGNED)) return true;
    return false;
  }

  private boolean jj_3_250()
 {
    if (jj_scan_token(K_SIGNED)) return true;
    if (jj_scan_token(S_IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_ColDataType_5123_19_677()
 {
    if (jj_scan_token(K_UNSIGNED)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_249()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_ColDataType_5131_8_782()
 {
    if (jj_scan_token(357)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(313)) jj_scanpos = xsp;
    if (jj_scan_token(358)) return true;
    return false;
  }

  private boolean jj_3_253()
 {
    if (jj_scan_token(K_CHARACTER)) return true;
    if (jj_scan_token(K_SET)) return true;
    if (jj_scan_token(S_IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_ColDataType_5119_19_676()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(319)) {
    jj_scanpos = xsp;
    if (jj_scan_token(323)) {
    jj_scanpos = xsp;
    if (jj_scan_token(61)) {
    jj_scanpos = xsp;
    if (jj_scan_token(62)) {
    jj_scanpos = xsp;
    if (jj_scan_token(298)) {
    jj_scanpos = xsp;
    if (jj_scan_token(131)) {
    jj_scanpos = xsp;
    if (jj_scan_token(311)) {
    jj_scanpos = xsp;
    if (jj_scan_token(43)) {
    jj_scanpos = xsp;
    if (jj_scan_token(235)) {
    jj_scanpos = xsp;
    if (jj_scan_token(25)) {
    jj_scanpos = xsp;
    if (jj_scan_token(136)) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    xsp = jj_scanpos;
    if (jj_3R_ColDataType_5121_27_781()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_SelectItemsList_2061_5_817()
 {
    if (jj_3R_SelectItem_2082_5_170()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_83()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_ColDataType_5118_19_675()
 {
    if (jj_scan_token(K_DOUBLE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_248()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_ColDataType_5131_6_727()
 {
    Token xsp;
    if (jj_3R_ColDataType_5131_8_782()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_ColDataType_5131_8_782()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_252()
 {
    if (jj_scan_token(325)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_ColDataType_5129_38_272()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(326)) return true;
    return false;
  }

  private boolean jj_3R_ColDataType_5117_17_674()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(38)) {
    jj_scanpos = xsp;
    if (jj_scan_token(26)) return true;
    }
    xsp = jj_scanpos;
    if (jj_scan_token(286)) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_82()
 {
    if (jj_scan_token(325)) return true;
    if (jj_scan_token(K_VALUES)) return true;
    if (jj_3R_SimpleExpressionList_3358_5_169()) return true;
    if (jj_scan_token(326)) return true;
    return false;
  }

  private boolean jj_3R_WithItem_2049_11_794()
 {
    if (jj_scan_token(325)) return true;
    if (jj_3R_SubSelect_4738_5_134()) return true;
    if (jj_scan_token(326)) return true;
    return false;
  }

  private boolean jj_3R_SetOperationList_1920_137_607()
 {
    if (jj_scan_token(K_DISTINCT)) return true;
    return false;
  }

  private boolean jj_3R_WithItem_2043_7_793()
 {
    if (jj_scan_token(325)) return true;
    if (jj_scan_token(K_VALUES)) return true;
    if (jj_3R_SimpleExpressionList_3358_5_169()) return true;
    if (jj_scan_token(326)) return true;
    return false;
  }

  private boolean jj_3R_ColDataType_5116_5_549()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ColDataType_5117_17_674()) {
    jj_scanpos = xsp;
    if (jj_3R_ColDataType_5118_19_675()) {
    jj_scanpos = xsp;
    if (jj_3R_ColDataType_5119_19_676()) {
    jj_scanpos = xsp;
    if (jj_3R_ColDataType_5123_19_677()) {
    jj_scanpos = xsp;
    if (jj_3_250()) {
    jj_scanpos = xsp;
    if (jj_3R_ColDataType_5126_19_678()) return true;
    }
    }
    }
    }
    }
    xsp = jj_scanpos;
    if (jj_3_252()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_ColDataType_5131_6_727()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_253()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_WithItem_2040_8_772()
 {
    if (jj_scan_token(325)) return true;
    if (jj_3R_SelectItemsList_2061_5_817()) return true;
    if (jj_scan_token(326)) return true;
    return false;
  }

  private boolean jj_3R_WithItem_2039_8_771()
 {
    if (jj_scan_token(K_RECURSIVE)) return true;
    return false;
  }

  private boolean jj_3R_WithItem_2039_6_711()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_WithItem_2039_8_771()) jj_scanpos = xsp;
    if (jj_3R_RelObjectName_1689_5_173()) return true;
    xsp = jj_scanpos;
    if (jj_3R_WithItem_2040_8_772()) jj_scanpos = xsp;
    if (jj_scan_token(K_AS)) return true;
    xsp = jj_scanpos;
    if (jj_3R_WithItem_2043_7_793()) {
    jj_scanpos = xsp;
    if (jj_3R_WithItem_2049_11_794()) return true;
    }
    return false;
  }

  private boolean jj_3_247()
 {
    if (jj_scan_token(325)) return true;
    if (jj_3R_Table_1750_5_176()) return true;
    if (jj_scan_token(326)) return true;
    return false;
  }

  private boolean jj_3R_CreateTable_5088_20_584()
 {
    if (jj_3R_Table_1750_5_176()) return true;
    return false;
  }

  private boolean jj_3R_CreateTable_5087_16_583()
 {
    if (jj_scan_token(325)) return true;
    if (jj_3R_Table_1750_5_176()) return true;
    if (jj_scan_token(326)) return true;
    return false;
  }

  private boolean jj_3R_WithList_2024_5_596()
 {
    if (jj_scan_token(K_WITH)) return true;
    if (jj_3R_WithItem_2039_6_711()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_WithList_2024_60_742()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_SetOperationList_1920_103_395()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_SetOperationList_1920_103_606()) {
    jj_scanpos = xsp;
    if (jj_3R_SetOperationList_1920_137_607()) return true;
    }
    return false;
  }

  private boolean jj_3R_SetOperationList_1920_103_606()
 {
    if (jj_scan_token(K_ALL)) return true;
    return false;
  }

  private boolean jj_3R_CreateTable_5087_5_332()
 {
    if (jj_scan_token(K_LIKE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_CreateTable_5087_16_583()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateTable_5088_20_584()) return true;
    }
    return false;
  }

  private boolean jj_3R_CreateTable_5085_7_331()
 {
    if (jj_scan_token(K_AS)) return true;
    if (jj_3R_SelectWithWithItems_1775_5_140()) return true;
    return false;
  }

  private boolean jj_3R_CreateTable_5084_7_330()
 {
    if (jj_3R_RowMovement_5325_3_582()) return true;
    return false;
  }

  private boolean jj_3R_SetOperationListWithoutIntialSelect_2006_11_168()
 {
    if (jj_scan_token(K_EXCEPT)) return true;
    return false;
  }

  private boolean jj_3R_SetOperationListWithoutIntialSelect_2005_11_167()
 {
    if (jj_scan_token(K_MINUS)) return true;
    return false;
  }

  private boolean jj_3_246()
 {
    if (jj_3R_CreateParameter_5215_9_262()) return true;
    return false;
  }

  private boolean jj_3R_SetOperationListWithoutIntialSelect_2004_11_166()
 {
    if (jj_scan_token(K_INTERSECT)) return true;
    return false;
  }

  private boolean jj_3R_SetOperationListWithoutIntialSelect_2003_10_165()
 {
    if (jj_scan_token(K_UNION)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_SetOperationListWithoutIntialSelect_2003_103_398()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_SetOperationList_1926_85_397()
 {
    if (jj_3R_Values_1109_5_609()) return true;
    return false;
  }

  private boolean jj_3_81()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_SetOperationListWithoutIntialSelect_2003_10_165()) {
    jj_scanpos = xsp;
    if (jj_3R_SetOperationListWithoutIntialSelect_2004_11_166()) {
    jj_scanpos = xsp;
    if (jj_3R_SetOperationListWithoutIntialSelect_2005_11_167()) {
    jj_scanpos = xsp;
    if (jj_3R_SetOperationListWithoutIntialSelect_2006_11_168()) return true;
    }
    }
    }
    if (jj_scan_token(325)) return true;
    if (jj_3R_SelectBody_1796_5_341()) return true;
    if (jj_scan_token(326)) return true;
    return false;
  }

  private boolean jj_3R_CreateTable_5044_30_800()
 {
    if (jj_scan_token(325)) return true;
    if (jj_3R_Expression_2983_5_136()) return true;
    if (jj_scan_token(326)) return true;
    return false;
  }

  private boolean jj_3R_CreateTable_5036_37_269()
 {
    if (jj_scan_token(325)) return true;
    if (jj_3R_Expression_2983_5_136()) return true;
    if (jj_scan_token(326)) return true;
    return false;
  }

  private boolean jj_3R_CreateTable_5049_21_763()
 {
    if (jj_3R_ColumnDefinition_4830_5_497()) return true;
    return false;
  }

  private boolean jj_3_243()
 {
    if (jj_scan_token(K_EXCLUDE)) return true;
    if (jj_scan_token(K_WHERE)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_CreateTable_5044_30_800()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_SetOperationListWithoutIntialSelect_1988_5_773()
 {
    Token xsp;
    if (jj_3_81()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_81()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_CreateTable_5034_26_268()
 {
    if (jj_scan_token(K_CONSTRAINT)) return true;
    if (jj_3R_RelObjectName_1689_5_173()) return true;
    return false;
  }

  private boolean jj_3R_SetOperationList_1926_62_396()
 {
    if (jj_3R_PlainSelect_1829_5_608()) return true;
    return false;
  }

  private boolean jj_3R_SetOperationList_1926_60_163()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_SetOperationList_1926_62_396()) {
    jj_scanpos = xsp;
    if (jj_3R_SetOperationList_1926_85_397()) return true;
    }
    return false;
  }

  private boolean jj_3_242()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_CreateTable_5034_26_268()) jj_scanpos = xsp;
    if (jj_scan_token(K_CHECK)) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_CreateTable_5036_37_269()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_237()
 {
    if (jj_scan_token(K_ON)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(67)) {
    jj_scanpos = xsp;
    if (jj_scan_token(271)) return true;
    }
    if (jj_3R_Action_5173_5_820()) return true;
    return false;
  }

  private boolean jj_3_236()
 {
    if (jj_scan_token(K_ON)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(67)) {
    jj_scanpos = xsp;
    if (jj_scan_token(271)) return true;
    }
    if (jj_3R_Action_5173_5_820()) return true;
    return false;
  }

  private boolean jj_3R_CreateTable_5012_26_267()
 {
    if (jj_scan_token(K_CONSTRAINT)) return true;
    if (jj_3R_RelObjectName_1689_5_173()) return true;
    return false;
  }

  private boolean jj_3R_SetOperationList_1918_48_766()
 {
    if (jj_3R_Values_1109_5_609()) return true;
    return false;
  }

  private boolean jj_3_241()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_CreateTable_5012_26_267()) jj_scanpos = xsp;
    if (jj_scan_token(K_FOREIGN)) return true;
    if (jj_scan_token(K_KEY)) return true;
    if (jj_3R_ColumnNamesWithParamsList_4753_6_263()) return true;
    if (jj_scan_token(K_REFERENCES)) return true;
    if (jj_3R_Table_1750_5_176()) return true;
    if (jj_3R_ColumnsNamesList_5373_5_589()) return true;
    xsp = jj_scanpos;
    if (jj_3_236()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_237()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_CreateTable_4997_31_799()
 {
    if (jj_3R_CreateParameter_5215_9_262()) return true;
    return false;
  }

  private boolean jj_3R_CreateTable_4948_77_270()
 {
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_3R_RelObjectName_1689_5_173()) return true;
    return false;
  }

  private boolean jj_3_80()
 {
    if (jj_scan_token(K_WITH)) return true;
    if (jj_scan_token(K_ISOLATION)) return true;
    return false;
  }

  private boolean jj_3_79()
 {
    if (jj_scan_token(K_FETCH)) return true;
    return false;
  }

  private boolean jj_3_78()
 {
    if (jj_scan_token(K_OFFSET)) return true;
    return false;
  }

  private boolean jj_3_77()
 {
    if (jj_scan_token(K_LIMIT)) return true;
    return false;
  }

  private boolean jj_3R_SetOperationList_1918_25_765()
 {
    if (jj_3R_PlainSelect_1829_5_608()) return true;
    return false;
  }

  private boolean jj_3_240()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(268)) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(107)) jj_scanpos = xsp;
    if (jj_scan_token(K_KEY)) return true;
    if (jj_3R_RelObjectName_1689_5_173()) return true;
    if (jj_3R_ColumnNamesWithParamsList_4753_6_263()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_CreateTable_4997_31_799()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_SetOperationList_1918_23_706()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_SetOperationList_1918_25_765()) {
    jj_scanpos = xsp;
    if (jj_3R_SetOperationList_1918_48_766()) return true;
    }
    return false;
  }

  private boolean jj_3R_CreateTable_4981_31_798()
 {
    if (jj_3R_CreateParameter_5215_9_262()) return true;
    return false;
  }

  private boolean jj_3R_SetOperationList_1934_6_710()
 {
    if (jj_3R_WithIsolation_2867_5_770()) return true;
    return false;
  }

  private boolean jj_3R_SetOperationList_1933_6_709()
 {
    if (jj_3R_Fetch_2845_5_769()) return true;
    return false;
  }

  private boolean jj_3R_SetOperationList_1932_6_708()
 {
    if (jj_3R_Offset_2824_5_768()) return true;
    return false;
  }

  private boolean jj_3_76()
 {
    if (jj_3R_OrderByElements_2726_5_164()) return true;
    return false;
  }

  private boolean jj_3R_SetOperationList_1931_6_707()
 {
    if (jj_3R_LimitWithOffset_2780_5_767()) return true;
    return false;
  }

  private boolean jj_3R_SetOperationList_1926_10_162()
 {
    if (jj_scan_token(325)) return true;
    if (jj_3R_SelectBody_1796_5_341()) return true;
    if (jj_scan_token(326)) return true;
    return false;
  }

  private boolean jj_3R_SetOperationList_1923_11_161()
 {
    if (jj_scan_token(K_EXCEPT)) return true;
    return false;
  }

  private boolean jj_3R_CreateTable_4977_28_266()
 {
    if (jj_scan_token(K_UNIQUE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(142)) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_SetOperationList_1922_11_160()
 {
    if (jj_scan_token(K_MINUS)) return true;
    return false;
  }

  private boolean jj_3R_SetOperationList_1921_11_159()
 {
    if (jj_scan_token(K_INTERSECT)) return true;
    return false;
  }

  private boolean jj_3R_CreateTable_4976_26_265()
 {
    if (jj_scan_token(K_PRIMARY)) return true;
    if (jj_scan_token(K_KEY)) return true;
    return false;
  }

  private boolean jj_3R_SetOperationList_1920_10_158()
 {
    if (jj_scan_token(K_UNION)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_SetOperationList_1920_103_395()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_CreateTable_4974_26_264()
 {
    if (jj_scan_token(K_CONSTRAINT)) return true;
    if (jj_3R_RelObjectName_1689_5_173()) return true;
    return false;
  }

  private boolean jj_3_75()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_SetOperationList_1920_10_158()) {
    jj_scanpos = xsp;
    if (jj_3R_SetOperationList_1921_11_159()) {
    jj_scanpos = xsp;
    if (jj_3R_SetOperationList_1922_11_160()) {
    jj_scanpos = xsp;
    if (jj_3R_SetOperationList_1923_11_161()) return true;
    }
    }
    }
    xsp = jj_scanpos;
    if (jj_3R_SetOperationList_1926_10_162()) {
    jj_scanpos = xsp;
    if (jj_3R_SetOperationList_1926_60_163()) return true;
    }
    return false;
  }

  private boolean jj_3R_SetOperationList_1917_6_705()
 {
    if (jj_scan_token(325)) return true;
    if (jj_3R_SelectBody_1796_5_341()) return true;
    if (jj_scan_token(326)) return true;
    return false;
  }

  private boolean jj_3R_SetOperationList_1917_5_590()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_SetOperationList_1917_6_705()) {
    jj_scanpos = xsp;
    if (jj_3R_SetOperationList_1918_23_706()) return true;
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_75()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3_76()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_SetOperationList_1931_6_707()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_SetOperationList_1932_6_708()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_SetOperationList_1933_6_709()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_SetOperationList_1934_6_710()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_239()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_CreateTable_4974_26_264()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_CreateTable_4976_26_265()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateTable_4977_28_266()) return true;
    }
    if (jj_3R_ColumnNamesWithParamsList_4753_6_263()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_CreateTable_4981_31_798()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_238()
 {
    if (jj_scan_token(K_INDEX)) return true;
    if (jj_3R_RelObjectName_1689_5_173()) return true;
    if (jj_3R_ColumnNamesWithParamsList_4753_6_263()) return true;
    return false;
  }

  private boolean jj_3_71()
 {
    if (jj_scan_token(K_WAIT)) return true;
    return false;
  }

  private boolean jj_3_73()
 {
    if (jj_scan_token(K_OPTIMIZE)) return true;
    return false;
  }

  private boolean jj_3R_CreateTable_4956_17_700()
 {
    if (jj_scan_token(K_COMMA)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_238()) {
    jj_scanpos = xsp;
    if (jj_3_239()) {
    jj_scanpos = xsp;
    if (jj_3_240()) {
    jj_scanpos = xsp;
    if (jj_3_241()) {
    jj_scanpos = xsp;
    if (jj_3_242()) {
    jj_scanpos = xsp;
    if (jj_3_243()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateTable_5049_21_763()) return true;
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3_68()
 {
    if (jj_scan_token(K_LIMIT)) return true;
    return false;
  }

  private boolean jj_3_70()
 {
    if (jj_scan_token(K_WITH)) return true;
    if (jj_scan_token(K_ISOLATION)) return true;
    return false;
  }

  private boolean jj_3R_PlainSelect_1887_11_856()
 {
    if (jj_scan_token(K_NOWAIT)) return true;
    return false;
  }

  private boolean jj_3_69()
 {
    if (jj_scan_token(K_FETCH)) return true;
    return false;
  }

  private boolean jj_3R_PlainSelect_1886_11_855()
 {
    if (jj_3R_Wait_5983_5_873()) return true;
    return false;
  }

  private boolean jj_3_74()
 {
    if (jj_scan_token(K_FOR)) return true;
    if (jj_scan_token(K_XML)) return true;
    if (jj_scan_token(K_PATH)) return true;
    if (jj_scan_token(325)) return true;
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    if (jj_scan_token(326)) return true;
    return false;
  }

  private boolean jj_3R_PlainSelect_1885_11_854()
 {
    if (jj_scan_token(K_OF)) return true;
    if (jj_3R_Table_1750_5_176()) return true;
    return false;
  }

  private boolean jj_3_67()
 {
    if (jj_scan_token(K_OFFSET)) return true;
    return false;
  }

  private boolean jj_3R_PlainSelect_1889_6_835()
 {
    if (jj_3R_OptimizeFor_2884_5_857()) return true;
    return false;
  }

  private boolean jj_3_66()
 {
    if (jj_scan_token(K_LIMIT)) return true;
    return false;
  }

  private boolean jj_3_65()
 {
    if (jj_scan_token(K_ORDER)) return true;
    if (jj_scan_token(K_BY)) return true;
    return false;
  }

  private boolean jj_3_64()
 {
    if (jj_scan_token(K_ORDER)) return true;
    if (jj_scan_token(K_SIBLINGS)) return true;
    if (jj_scan_token(K_BY)) return true;
    return false;
  }

  private boolean jj_3R_CreateTable_4950_13_271()
 {
    if (jj_scan_token(325)) return true;
    if (jj_3R_ColumnDefinition_4830_5_497()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_CreateTable_4956_17_700()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(326)) return true;
    return false;
  }

  private boolean jj_3R_PlainSelect_1881_10_832()
 {
    if (jj_3R_LimitWithOffset_2780_5_767()) return true;
    return false;
  }

  private boolean jj_3_72()
 {
    if (jj_scan_token(K_FOR)) return true;
    if (jj_scan_token(K_UPDATE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_PlainSelect_1885_11_854()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_PlainSelect_1886_11_855()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_PlainSelect_1887_11_856()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_PlainSelect_1883_6_834()
 {
    if (jj_3R_WithIsolation_2867_5_770()) return true;
    return false;
  }

  private boolean jj_3R_PlainSelect_1882_6_833()
 {
    if (jj_3R_Fetch_2845_5_769()) return true;
    return false;
  }

  private boolean jj_3R_PlainSelect_1880_6_831()
 {
    if (jj_3R_Offset_2824_5_768()) return true;
    return false;
  }

  private boolean jj_3R_PlainSelect_1879_6_830()
 {
    if (jj_3R_LimitWithOffset_2780_5_767()) return true;
    return false;
  }

  private boolean jj_3R_PlainSelect_1878_7_829()
 {
    if (jj_scan_token(K_EMIT)) return true;
    if (jj_scan_token(K_CHANGES)) return true;
    return false;
  }

  private boolean jj_3_244()
 {
    if (jj_scan_token(325)) return true;
    if (jj_3R_RelObjectName_1689_5_173()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_CreateTable_4948_77_270()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(326)) return true;
    return false;
  }

  private boolean jj_3R_PlainSelect_1877_6_828()
 {
    if (jj_3R_OrderByElements_2726_5_164()) return true;
    return false;
  }

  private boolean jj_3R_PlainSelect_1876_6_827()
 {
    if (jj_3R_OrderByElements_2726_5_164()) return true;
    return false;
  }

  private boolean jj_3R_PlainSelect_1875_7_826()
 {
    if (jj_3R_Having_2714_5_853()) return true;
    return false;
  }

  private boolean jj_3_245()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_244()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateTable_4950_13_271()) return true;
    }
    return false;
  }

  private boolean jj_3R_PlainSelect_1874_7_825()
 {
    if (jj_3R_GroupByColumnReferences_2683_5_852()) return true;
    return false;
  }

  private boolean jj_3R_PlainSelect_1873_7_824()
 {
    if (jj_3R_OracleHierarchicalQueryClause_2658_5_851()) return true;
    return false;
  }

  private boolean jj_3_235()
 {
    if (jj_scan_token(K_IF)) return true;
    if (jj_scan_token(K_NOT)) return true;
    if (jj_scan_token(K_EXISTS)) return true;
    return false;
  }

  private boolean jj_3_63()
 {
    if (jj_3R_WhereClause_2648_5_157()) return true;
    return false;
  }

  private boolean jj_3R_PlainSelect_1871_7_823()
 {
    if (jj_3R_KSQLWindowClause_2609_5_850()) return true;
    return false;
  }

  private boolean jj_3R_PlainSelect_1857_19_388()
 {
    if (jj_scan_token(K_SQL_CACHE)) return true;
    return false;
  }

  private boolean jj_3R_CreateTable_4941_6_329()
 {
    if (jj_3R_CreateParameter_5215_9_262()) return true;
    return false;
  }

  private boolean jj_3_62()
 {
    if (jj_scan_token(K_FROM)) return true;
    if (jj_3R_FromItem_2370_5_156()) return true;
    if (jj_3R_JoinsList_2504_5_145()) return true;
    return false;
  }

  private boolean jj_3R_PlainSelect_1856_17_387()
 {
    if (jj_scan_token(K_SQL_NO_CACHE)) return true;
    return false;
  }

  private boolean jj_3R_CreateTable_4937_7_328()
 {
    if (jj_scan_token(K_GLOBAL)) return true;
    return false;
  }

  private boolean jj_3R_PlainSelect_1866_6_822()
 {
    if (jj_3R_IntoClause_2352_5_849()) return true;
    return false;
  }

  private boolean jj_3R_CreateTable_4934_7_327()
 {
    if (jj_scan_token(K_UNLOGGED)) return true;
    return false;
  }

  private boolean jj_3_61()
 {
    if (jj_3R_Top_2899_5_155()) return true;
    return false;
  }

  private boolean jj_3R_CreateTable_4933_7_326()
 {
    if (jj_scan_token(K_OR)) return true;
    if (jj_scan_token(K_REPLACE)) return true;
    return false;
  }

  private boolean jj_3R_PlainSelect_1855_13_154()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_PlainSelect_1856_17_387()) {
    jj_scanpos = xsp;
    if (jj_3R_PlainSelect_1857_19_388()) return true;
    }
    return false;
  }

  private boolean jj_3_59()
 {
    if (jj_scan_token(K_ON)) return true;
    if (jj_scan_token(325)) return true;
    if (jj_3R_SelectItemsList_2061_5_817()) return true;
    if (jj_scan_token(326)) return true;
    return false;
  }

  private boolean jj_3R_CreateTable_4932_5_123()
 {
    if (jj_scan_token(K_CREATE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_CreateTable_4933_7_326()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_CreateTable_4934_7_327()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_CreateTable_4937_7_328()) jj_scanpos = xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_CreateTable_4941_6_329()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(K_TABLE)) return true;
    xsp = jj_scanpos;
    if (jj_3_235()) jj_scanpos = xsp;
    if (jj_3R_Table_1750_5_176()) return true;
    xsp = jj_scanpos;
    if (jj_3_245()) jj_scanpos = xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_246()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_CreateTable_5084_7_330()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_CreateTable_5085_7_331()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_CreateTable_5087_5_332()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_PlainSelect_1851_13_153()
 {
    if (jj_scan_token(K_SQL_CALC_FOUND_ROWS)) return true;
    return false;
  }

  private boolean jj_3R_PlainSelect_1847_13_152()
 {
    if (jj_scan_token(K_UNIQUE)) return true;
    return false;
  }

  private boolean jj_3R_PlainSelect_1842_13_151()
 {
    if (jj_scan_token(K_DISTINCT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_59()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_60()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(10)) {
    jj_scanpos = xsp;
    if (jj_3R_PlainSelect_1842_13_151()) {
    jj_scanpos = xsp;
    if (jj_3R_PlainSelect_1847_13_152()) {
    jj_scanpos = xsp;
    if (jj_3R_PlainSelect_1851_13_153()) {
    jj_scanpos = xsp;
    if (jj_3R_PlainSelect_1855_13_154()) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3_58()
 {
    if (jj_3R_First_2963_5_150()) return true;
    return false;
  }

  private boolean jj_3_57()
 {
    if (jj_3R_Skip_2927_5_149()) return true;
    return false;
  }

  private boolean jj_3R_PlainSelect_1831_7_821()
 {
    if (jj_scan_token(K_STRAIGHT)) return true;
    return false;
  }

  private boolean jj_3R_PlainSelect_1829_5_608()
 {
    if (jj_scan_token(K_SELECT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_PlainSelect_1831_7_821()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_57()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_58()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_60()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_61()) jj_scanpos = xsp;
    if (jj_3R_SelectItemsList_2061_5_817()) return true;
    xsp = jj_scanpos;
    if (jj_3R_PlainSelect_1866_6_822()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_62()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_PlainSelect_1871_7_823()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_63()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_PlainSelect_1873_7_824()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_PlainSelect_1874_7_825()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_PlainSelect_1875_7_826()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_PlainSelect_1876_6_827()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_PlainSelect_1877_6_828()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_PlainSelect_1878_7_829()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_PlainSelect_1879_6_830()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_PlainSelect_1880_6_831()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_PlainSelect_1881_10_832()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_PlainSelect_1882_6_833()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_PlainSelect_1883_6_834()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_72()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_PlainSelect_1889_6_835()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_74()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_PathSpecification_4892_10_689()
 {
    if (jj_scan_token(K_COMMA)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(319)) {
    jj_scanpos = xsp;
    if (jj_scan_token(323)) return true;
    }
    return false;
  }

  private boolean jj_3R_PathSpecification_4891_5_579()
 {
    if (jj_scan_token(K_PATH)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(319)) {
    jj_scanpos = xsp;
    if (jj_scan_token(323)) return true;
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_PathSpecification_4892_10_689()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_CreateSchema_4873_11_580()
 {
    if (jj_3R_CreateView_5149_5_124()) return true;
    return false;
  }

  private boolean jj_3R_CreateSchema_4867_9_319()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_234()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateSchema_4873_11_580()) return true;
    }
    return false;
  }

  private boolean jj_3_234()
 {
    if (jj_3R_CreateTable_4932_5_123()) return true;
    return false;
  }

  private boolean jj_3R_SelectBody_1796_5_341()
 {
    if (jj_3R_SetOperationList_1917_5_590()) return true;
    return false;
  }

  private boolean jj_3R_CreateSchema_4864_6_318()
 {
    if (jj_3R_PathSpecification_4891_5_579()) return true;
    return false;
  }

  private boolean jj_3R_CreateSchema_4860_7_317()
 {
    if (jj_scan_token(K_AUTHORIZATION)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(319)) {
    jj_scanpos = xsp;
    if (jj_scan_token(323)) return true;
    }
    return false;
  }

  private boolean jj_3R_CreateSchema_4859_7_316()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(319)) {
    jj_scanpos = xsp;
    if (jj_scan_token(323)) return true;
    }
    return false;
  }

  private boolean jj_3R_Select_1787_5_375()
 {
    if (jj_3R_SelectBody_1796_5_341()) return true;
    return false;
  }

  private boolean jj_3R_CreateSchema_4858_5_120()
 {
    if (jj_scan_token(K_CREATE)) return true;
    if (jj_scan_token(K_SCHEMA)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_CreateSchema_4859_7_316()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_CreateSchema_4860_7_317()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_CreateSchema_4864_6_318()) jj_scanpos = xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_CreateSchema_4867_9_319()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_TableWithAlias_1765_20_377()
 {
    if (jj_3R_Alias_2114_5_175()) return true;
    return false;
  }

  private boolean jj_3R_SelectWithWithItems_1775_7_374()
 {
    if (jj_3R_WithList_2024_5_596()) return true;
    return false;
  }

  private boolean jj_3R_SelectWithWithItems_1775_5_140()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_SelectWithWithItems_1775_7_374()) jj_scanpos = xsp;
    if (jj_3R_Select_1787_5_375()) return true;
    return false;
  }

  private boolean jj_3R_TableWithAlias_1765_5_144()
 {
    if (jj_3R_Table_1750_5_176()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_TableWithAlias_1765_20_377()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_233()
 {
    if (jj_3R_CreateParameter_5215_9_262()) return true;
    return false;
  }

  private boolean jj_3R_ColumnDefinition_4830_5_497()
 {
    if (jj_3R_RelObjectName_1689_5_173()) return true;
    if (jj_3R_ColDataType_5116_5_549()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_233()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_Table_1750_5_176()
 {
    if (jj_3R_RelObjectNameList_1613_5_325()) return true;
    return false;
  }

  private boolean jj_3R_CreateIndex_4812_7_315()
 {
    if (jj_3R_CreateParameter_5215_9_262()) return true;
    return false;
  }

  private boolean jj_3R_RelObjectNameExt2_1737_7_378()
 {
    if (jj_3R_RelObjectNameExt_1719_5_342()) return true;
    return false;
  }

  private boolean jj_3R_RelObjectNameExt2_1737_5_148()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_RelObjectNameExt2_1737_7_378()) {
    jj_scanpos = xsp;
    if (jj_scan_token(105)) {
    jj_scanpos = xsp;
    if (jj_scan_token(230)) {
    jj_scanpos = xsp;
    if (jj_scan_token(57)) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_CreateIndex_4806_7_314()
 {
    if (jj_scan_token(K_USING)) return true;
    if (jj_scan_token(S_IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_CreateIndex_4800_7_312()
 {
    if (jj_3R_CreateParameter_5215_9_262()) return true;
    return false;
  }

  private boolean jj_3R_CreateIndex_4799_5_119()
 {
    if (jj_scan_token(K_CREATE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_CreateIndex_4800_7_312()) jj_scanpos = xsp;
    if (jj_scan_token(K_INDEX)) return true;
    if (jj_3R_Index_4782_5_313()) return true;
    if (jj_scan_token(K_ON)) return true;
    if (jj_3R_Table_1750_5_176()) return true;
    xsp = jj_scanpos;
    if (jj_3R_CreateIndex_4806_7_314()) jj_scanpos = xsp;
    if (jj_3R_ColumnNamesWithParamsList_4753_6_263()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_CreateIndex_4812_7_315()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_RelObjectNameExt_1719_7_591()
 {
    if (jj_3R_RelObjectName_1689_5_173()) return true;
    return false;
  }

  private boolean jj_3R_RelObjectNameExt_1719_5_342()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_RelObjectNameExt_1719_7_591()) {
    jj_scanpos = xsp;
    if (jj_scan_token(10)) {
    jj_scanpos = xsp;
    if (jj_scan_token(15)) {
    jj_scanpos = xsp;
    if (jj_scan_token(245)) {
    jj_scanpos = xsp;
    if (jj_scan_token(148)) {
    jj_scanpos = xsp;
    if (jj_scan_token(224)) {
    jj_scanpos = xsp;
    if (jj_scan_token(235)) {
    jj_scanpos = xsp;
    if (jj_scan_token(77)) {
    jj_scanpos = xsp;
    if (jj_scan_token(119)) {
    jj_scanpos = xsp;
    if (jj_scan_token(120)) {
    jj_scanpos = xsp;
    if (jj_scan_token(192)) {
    jj_scanpos = xsp;
    if (jj_scan_token(150)) {
    jj_scanpos = xsp;
    if (jj_scan_token(183)) {
    jj_scanpos = xsp;
    if (jj_scan_token(203)) {
    jj_scanpos = xsp;
    if (jj_scan_token(204)) {
    jj_scanpos = xsp;
    if (jj_scan_token(35)) {
    jj_scanpos = xsp;
    if (jj_scan_token(123)) {
    jj_scanpos = xsp;
    if (jj_scan_token(112)) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_InternalFunction_4635_157_257()
 {
    if (jj_3R_OrderByElements_2726_5_164()) return true;
    return false;
  }

  private boolean jj_3R_Index_4782_5_313()
 {
    if (jj_3R_RelObjectNameList_1613_5_325()) return true;
    return false;
  }

  private boolean jj_3R_RelObjectNameWithoutStart_1702_6_713()
 {
    if (jj_3R_RelObjectNameWithoutValue_1641_5_612()) return true;
    return false;
  }

  private boolean jj_3R_RelObjectNameWithoutStart_1702_5_614()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_RelObjectNameWithoutStart_1702_6_713()) {
    jj_scanpos = xsp;
    if (jj_scan_token(260)) {
    jj_scanpos = xsp;
    if (jj_scan_token(284)) {
    jj_scanpos = xsp;
    if (jj_scan_token(285)) {
    jj_scanpos = xsp;
    if (jj_scan_token(131)) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_ColumnNamesWithParamsList_4767_11_688()
 {
    if (jj_3R_CreateParameter_5215_9_262()) return true;
    return false;
  }

  private boolean jj_3R_ColumnNamesWithParamsList_4763_9_578()
 {
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_3R_RelObjectName_1689_5_173()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ColumnNamesWithParamsList_4767_11_688()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_RelObjectName_1689_6_401()
 {
    if (jj_3R_RelObjectNameWithoutValue_1641_5_612()) return true;
    return false;
  }

  private boolean jj_3R_RelObjectName_1689_5_173()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_RelObjectName_1689_6_401()) {
    jj_scanpos = xsp;
    if (jj_scan_token(111)) {
    jj_scanpos = xsp;
    if (jj_scan_token(131)) {
    jj_scanpos = xsp;
    if (jj_scan_token(184)) {
    jj_scanpos = xsp;
    if (jj_scan_token(189)) {
    jj_scanpos = xsp;
    if (jj_scan_token(246)) {
    jj_scanpos = xsp;
    if (jj_scan_token(260)) {
    jj_scanpos = xsp;
    if (jj_scan_token(284)) {
    jj_scanpos = xsp;
    if (jj_scan_token(285)) {
    jj_scanpos = xsp;
    if (jj_scan_token(55)) {
    jj_scanpos = xsp;
    if (jj_scan_token(252)) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_ColumnNamesWithParamsList_4757_7_577()
 {
    if (jj_3R_CreateParameter_5215_9_262()) return true;
    return false;
  }

  private boolean jj_3R_ColumnNamesWithParamsList_4753_6_263()
 {
    if (jj_scan_token(325)) return true;
    if (jj_3R_RelObjectName_1689_5_173()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ColumnNamesWithParamsList_4757_7_577()) jj_scanpos = xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_ColumnNamesWithParamsList_4763_9_578()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(326)) return true;
    return false;
  }

  private boolean jj_3R_SubSelect_4738_7_350()
 {
    if (jj_3R_WithList_2024_5_596()) return true;
    return false;
  }

  private boolean jj_3R_SubSelect_4738_5_134()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_SubSelect_4738_7_350()) jj_scanpos = xsp;
    if (jj_3R_SelectBody_1796_5_341()) return true;
    return false;
  }

  private boolean jj_3R_InternalFunction_4629_113_256()
 {
    if (jj_scan_token(K_UNIQUE)) return true;
    return false;
  }

  private boolean jj_3_232()
 {
    if (jj_3R_Alias_2114_5_175()) return true;
    return false;
  }

  private boolean jj_3R_TableFunction_4724_5_179()
 {
    if (jj_3R_Function_4573_5_210()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_232()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_RelObjectNameList_1614_34_147()
 {
    if (jj_scan_token(329)) return true;
    return false;
  }

  private boolean jj_3R_RelObjectNameWithoutValue_1641_5_612()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(319)) {
    jj_scanpos = xsp;
    if (jj_scan_token(323)) {
    jj_scanpos = xsp;
    if (jj_scan_token(9)) {
    jj_scanpos = xsp;
    if (jj_scan_token(20)) {
    jj_scanpos = xsp;
    if (jj_scan_token(31)) {
    jj_scanpos = xsp;
    if (jj_scan_token(43)) {
    jj_scanpos = xsp;
    if (jj_scan_token(39)) {
    jj_scanpos = xsp;
    if (jj_scan_token(38)) {
    jj_scanpos = xsp;
    if (jj_scan_token(36)) {
    jj_scanpos = xsp;
    if (jj_scan_token(37)) {
    jj_scanpos = xsp;
    if (jj_scan_token(50)) {
    jj_scanpos = xsp;
    if (jj_scan_token(54)) {
    jj_scanpos = xsp;
    if (jj_scan_token(70)) {
    jj_scanpos = xsp;
    if (jj_scan_token(68)) {
    jj_scanpos = xsp;
    if (jj_scan_token(76)) {
    jj_scanpos = xsp;
    if (jj_scan_token(64)) {
    jj_scanpos = xsp;
    if (jj_scan_token(93)) {
    jj_scanpos = xsp;
    if (jj_scan_token(96)) {
    jj_scanpos = xsp;
    if (jj_scan_token(97)) {
    jj_scanpos = xsp;
    if (jj_scan_token(100)) {
    jj_scanpos = xsp;
    if (jj_scan_token(136)) {
    jj_scanpos = xsp;
    if (jj_scan_token(145)) {
    jj_scanpos = xsp;
    if (jj_scan_token(147)) {
    jj_scanpos = xsp;
    if (jj_scan_token(157)) {
    jj_scanpos = xsp;
    if (jj_scan_token(179)) {
    jj_scanpos = xsp;
    if (jj_scan_token(194)) {
    jj_scanpos = xsp;
    if (jj_scan_token(209)) {
    jj_scanpos = xsp;
    if (jj_scan_token(226)) {
    jj_scanpos = xsp;
    if (jj_scan_token(227)) {
    jj_scanpos = xsp;
    if (jj_scan_token(241)) {
    jj_scanpos = xsp;
    if (jj_scan_token(298)) {
    jj_scanpos = xsp;
    if (jj_scan_token(46)) {
    jj_scanpos = xsp;
    if (jj_scan_token(218)) {
    jj_scanpos = xsp;
    if (jj_scan_token(262)) {
    jj_scanpos = xsp;
    if (jj_scan_token(142)) {
    jj_scanpos = xsp;
    if (jj_scan_token(186)) {
    jj_scanpos = xsp;
    if (jj_scan_token(191)) {
    jj_scanpos = xsp;
    if (jj_scan_token(196)) {
    jj_scanpos = xsp;
    if (jj_scan_token(202)) {
    jj_scanpos = xsp;
    if (jj_scan_token(233)) {
    jj_scanpos = xsp;
    if (jj_scan_token(167)) {
    jj_scanpos = xsp;
    if (jj_scan_token(3)) {
    jj_scanpos = xsp;
    if (jj_scan_token(33)) {
    jj_scanpos = xsp;
    if (jj_scan_token(84)) {
    jj_scanpos = xsp;
    if (jj_scan_token(251)) {
    jj_scanpos = xsp;
    if (jj_scan_token(61)) {
    jj_scanpos = xsp;
    if (jj_scan_token(49)) {
    jj_scanpos = xsp;
    if (jj_scan_token(200)) {
    jj_scanpos = xsp;
    if (jj_scan_token(129)) {
    jj_scanpos = xsp;
    if (jj_scan_token(126)) {
    jj_scanpos = xsp;
    if (jj_scan_token(201)) {
    jj_scanpos = xsp;
    if (jj_scan_token(83)) {
    jj_scanpos = xsp;
    if (jj_scan_token(255)) {
    jj_scanpos = xsp;
    if (jj_scan_token(256)) {
    jj_scanpos = xsp;
    if (jj_scan_token(259)) {
    jj_scanpos = xsp;
    if (jj_scan_token(265)) {
    jj_scanpos = xsp;
    if (jj_scan_token(134)) {
    jj_scanpos = xsp;
    if (jj_scan_token(304)) {
    jj_scanpos = xsp;
    if (jj_scan_token(47)) {
    jj_scanpos = xsp;
    if (jj_scan_token(69)) {
    jj_scanpos = xsp;
    if (jj_scan_token(144)) {
    jj_scanpos = xsp;
    if (jj_scan_token(195)) {
    jj_scanpos = xsp;
    if (jj_scan_token(62)) {
    jj_scanpos = xsp;
    if (jj_scan_token(166)) {
    jj_scanpos = xsp;
    if (jj_scan_token(263)) {
    jj_scanpos = xsp;
    if (jj_scan_token(98)) {
    jj_scanpos = xsp;
    if (jj_scan_token(80)) {
    jj_scanpos = xsp;
    if (jj_scan_token(210)) {
    jj_scanpos = xsp;
    if (jj_scan_token(229)) {
    jj_scanpos = xsp;
    if (jj_scan_token(280)) {
    jj_scanpos = xsp;
    if (jj_scan_token(243)) {
    jj_scanpos = xsp;
    if (jj_scan_token(232)) {
    jj_scanpos = xsp;
    if (jj_scan_token(234)) {
    jj_scanpos = xsp;
    if (jj_scan_token(244)) {
    jj_scanpos = xsp;
    if (jj_scan_token(249)) {
    jj_scanpos = xsp;
    if (jj_scan_token(288)) {
    jj_scanpos = xsp;
    if (jj_scan_token(171)) {
    jj_scanpos = xsp;
    if (jj_scan_token(283)) {
    jj_scanpos = xsp;
    if (jj_scan_token(58)) {
    jj_scanpos = xsp;
    if (jj_scan_token(181)) {
    jj_scanpos = xsp;
    if (jj_scan_token(87)) {
    jj_scanpos = xsp;
    if (jj_scan_token(104)) {
    jj_scanpos = xsp;
    if (jj_scan_token(73)) {
    jj_scanpos = xsp;
    if (jj_scan_token(282)) {
    jj_scanpos = xsp;
    if (jj_scan_token(34)) {
    jj_scanpos = xsp;
    if (jj_scan_token(151)) {
    jj_scanpos = xsp;
    if (jj_scan_token(18)) {
    jj_scanpos = xsp;
    if (jj_scan_token(281)) {
    jj_scanpos = xsp;
    if (jj_scan_token(275)) {
    jj_scanpos = xsp;
    if (jj_scan_token(211)) {
    jj_scanpos = xsp;
    if (jj_scan_token(63)) {
    jj_scanpos = xsp;
    if (jj_scan_token(258)) {
    jj_scanpos = xsp;
    if (jj_scan_token(193)) {
    jj_scanpos = xsp;
    if (jj_scan_token(152)) {
    jj_scanpos = xsp;
    if (jj_scan_token(153)) {
    jj_scanpos = xsp;
    if (jj_scan_token(79)) {
    jj_scanpos = xsp;
    if (jj_scan_token(99)) {
    jj_scanpos = xsp;
    if (jj_scan_token(4)) {
    jj_scanpos = xsp;
    if (jj_scan_token(220)) {
    jj_scanpos = xsp;
    if (jj_scan_token(248)) {
    jj_scanpos = xsp;
    if (jj_scan_token(247)) {
    jj_scanpos = xsp;
    if (jj_scan_token(17)) {
    jj_scanpos = xsp;
    if (jj_scan_token(208)) {
    jj_scanpos = xsp;
    if (jj_scan_token(117)) {
    jj_scanpos = xsp;
    if (jj_scan_token(240)) {
    jj_scanpos = xsp;
    if (jj_scan_token(216)) {
    jj_scanpos = xsp;
    if (jj_scan_token(273)) {
    jj_scanpos = xsp;
    if (jj_scan_token(222)) {
    jj_scanpos = xsp;
    if (jj_scan_token(42)) {
    jj_scanpos = xsp;
    if (jj_scan_token(71)) {
    jj_scanpos = xsp;
    if (jj_scan_token(250)) {
    jj_scanpos = xsp;
    if (jj_scan_token(206)) {
    jj_scanpos = xsp;
    if (jj_scan_token(107)) {
    jj_scanpos = xsp;
    if (jj_scan_token(253)) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_ValueListExpression_4710_5_213()
 {
    if (jj_scan_token(325)) return true;
    if (jj_3R_SimpleExpressionListAtLeastTwoItems_3476_5_469()) return true;
    if (jj_scan_token(326)) return true;
    return false;
  }

  private boolean jj_3R_InternalFunction_4637_72_258()
 {
    if (jj_3R_OrderByElements_2726_5_164()) return true;
    return false;
  }

  private boolean jj_3R_MySQLGroupConcat_4696_10_883()
 {
    if (jj_scan_token(K_SEPARATOR)) return true;
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_MySQLGroupConcat_4695_10_882()
 {
    if (jj_3R_OrderByElements_2726_5_164()) return true;
    return false;
  }

  private boolean jj_3R_MySQLGroupConcat_4693_9_879()
 {
    if (jj_scan_token(K_DISTINCT)) return true;
    return false;
  }

  private boolean jj_3R_Column_1626_5_133()
 {
    if (jj_3R_RelObjectNameList_1613_5_325()) return true;
    return false;
  }

  private boolean jj_3R_InternalFunction_4629_71_255()
 {
    if (jj_scan_token(K_ALL)) return true;
    return false;
  }

  private boolean jj_3R_MySQLGroupConcat_4692_5_599()
 {
    if (jj_scan_token(K_GROUP_CONCAT)) return true;
    if (jj_scan_token(325)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_MySQLGroupConcat_4693_9_879()) jj_scanpos = xsp;
    if (jj_3R_SimpleExpressionList_3358_5_169()) return true;
    xsp = jj_scanpos;
    if (jj_3R_MySQLGroupConcat_4695_10_882()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_MySQLGroupConcat_4696_10_883()) jj_scanpos = xsp;
    if (jj_scan_token(326)) return true;
    return false;
  }

  private boolean jj_3_56()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(329)) {
    jj_scanpos = xsp;
    if (jj_scan_token(330)) return true;
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_RelObjectNameList_1614_34_147()) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_RelObjectNameExt2_1737_5_148()) return true;
    return false;
  }

  private boolean jj_3R_XMLSerializeExpr_4672_19_884()
 {
    if (jj_3R_OrderByElements_2726_5_164()) return true;
    return false;
  }

  private boolean jj_3R_RelObjectNameList_1613_5_325()
 {
    if (jj_3R_RelObjectNameExt_1719_5_342()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_56()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_XMLSerializeExpr_4668_5_600()
 {
    if (jj_scan_token(K_XMLSERIALIZE)) return true;
    if (jj_scan_token(325)) return true;
    if (jj_scan_token(K_XMLAGG)) return true;
    if (jj_scan_token(325)) return true;
    if (jj_scan_token(K_XMLTEXT)) return true;
    if (jj_scan_token(325)) return true;
    if (jj_3R_SimpleExpression_3535_5_132()) return true;
    if (jj_scan_token(326)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_XMLSerializeExpr_4672_19_884()) jj_scanpos = xsp;
    if (jj_scan_token(326)) return true;
    if (jj_scan_token(K_AS)) return true;
    if (jj_3R_ColDataType_5116_5_549()) return true;
    if (jj_scan_token(326)) return true;
    return false;
  }

  private boolean jj_3R_InternalFunction_4647_15_783()
 {
    if (jj_3R_RelObjectName_1689_5_173()) return true;
    return false;
  }

  private boolean jj_3_230()
 {
    if (jj_3R_Function_4573_5_210()) return true;
    return false;
  }

  private boolean jj_3_231()
 {
    if (jj_3R_KeepExpression_4234_5_261()) return true;
    return false;
  }

  private boolean jj_3_226()
 {
    if (jj_3R_AllTableColumns_2098_6_171()) return true;
    return false;
  }

  private boolean jj_3R_InternalFunction_4629_26_254()
 {
    if (jj_scan_token(K_DISTINCT)) return true;
    return false;
  }

  private boolean jj_3R_InternalFunction_4642_11_726()
 {
    if (jj_scan_token(K_IGNORE)) return true;
    if (jj_scan_token(K_NULLS)) return true;
    return false;
  }

  private boolean jj_3R_InternalFunction_4639_13_260()
 {
    if (jj_3R_SubSelect_4738_5_134()) return true;
    return false;
  }

  private boolean jj_3R_InternalFunction_4645_7_728()
 {
    if (jj_scan_token(329)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_230()) {
    jj_scanpos = xsp;
    if (jj_3R_InternalFunction_4647_15_783()) return true;
    }
    return false;
  }

  private boolean jj_3_228()
 {
    if (jj_3R_SimpleExpressionList_3358_5_169()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_InternalFunction_4637_72_258()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_MergeUpdateClause_1575_3_146()
 {
    if (jj_scan_token(K_WHEN)) return true;
    if (jj_scan_token(K_MATCHED)) return true;
    return false;
  }

  private boolean jj_3_227()
 {
    if (jj_3R_ComplexExpressionList_3373_5_135()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_InternalFunction_4635_157_257()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_InternalFunction_4633_13_259()
 {
    if (jj_3R_AllTableColumns_2098_6_171()) return true;
    return false;
  }

  private boolean jj_3_224()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_InternalFunction_4629_26_254()) {
    jj_scanpos = xsp;
    if (jj_3R_InternalFunction_4629_71_255()) {
    jj_scanpos = xsp;
    if (jj_3R_InternalFunction_4629_113_256()) return true;
    }
    }
    return false;
  }

  private boolean jj_3_225()
 {
    if (jj_scan_token(328)) return true;
    return false;
  }

  private boolean jj_3_229()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_224()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_225()) {
    jj_scanpos = xsp;
    if (jj_3R_InternalFunction_4633_13_259()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = getAsBoolean(Feature.allowComplexParsing);
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3_227()) {
    jj_scanpos = xsp;
    if (jj_3_228()) {
    jj_scanpos = xsp;
    if (jj_3R_InternalFunction_4639_13_260()) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3_55()
 {
    if (jj_3R_MergeUpdateClause_1575_3_146()) return true;
    return false;
  }

  private boolean jj_3R_InternalFunction_4627_5_639()
 {
    if (jj_3R_RelObjectNameList_1613_5_325()) return true;
    if (jj_scan_token(325)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_229()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_InternalFunction_4642_11_726()) jj_scanpos = xsp;
    if (jj_scan_token(326)) return true;
    xsp = jj_scanpos;
    if (jj_3R_InternalFunction_4645_7_728()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_231()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_221()
 {
    if (jj_3R_NamedExpressionListExprFirst_3442_9_253()) return true;
    return false;
  }

  private boolean jj_3R_Merge_1543_5_684()
 {
    if (jj_scan_token(K_MERGE)) return true;
    return false;
  }

  private boolean jj_3_220()
 {
    if (jj_3R_NamedExpressionList1_3406_5_252()) return true;
    return false;
  }

  private boolean jj_3_223()
 {
    if (jj_3R_SimpleExpressionList_3358_5_169()) return true;
    return false;
  }

  private boolean jj_3_222()
 {
    if (jj_3R_ComplexExpressionList_3373_5_135()) return true;
    return false;
  }

  private boolean jj_3R_SpecialStringFunctionWithNamedParameters_4598_13_500()
 {
    if (jj_3R_NamedExpressionListExprFirst_3442_9_253()) return true;
    return false;
  }

  private boolean jj_3R_SpecialStringFunctionWithNamedParameters_4596_13_499()
 {
    if (jj_3R_NamedExpressionList1_3406_5_252()) return true;
    return false;
  }

  private boolean jj_3R_SpecialStringFunctionWithNamedParameters_4592_9_251()
 {
    if (jj_scan_token(K_STRING_FUNCTION_NAME)) return true;
    if (jj_scan_token(325)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_SpecialStringFunctionWithNamedParameters_4596_13_499()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = getAsBoolean(Feature.allowComplexParsing);
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_SpecialStringFunctionWithNamedParameters_4598_13_500()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = getAsBoolean(Feature.allowComplexParsing);
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3_222()) {
    jj_scanpos = xsp;
    if (jj_3_223()) return true;
    }
    }
    }
    if (jj_scan_token(326)) return true;
    return false;
  }

  private boolean jj_3R_Delete_1508_20_143()
 {
    if (jj_3R_TableWithAlias_1765_5_144()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_Delete_1509_12_376()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(K_FROM)) return true;
    return false;
  }

  private boolean jj_3R_Delete_1509_12_376()
 {
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_3R_TableWithAlias_1765_5_144()) return true;
    return false;
  }

  private boolean jj_3_54()
 {
    if (jj_3R_TableWithAlias_1765_5_144()) return true;
    if (jj_3R_JoinsList_2504_5_145()) return true;
    return false;
  }

  private boolean jj_3R_Function_4576_11_463()
 {
    if (jj_3R_InternalFunction_4627_5_639()) return true;
    return false;
  }

  private boolean jj_3_219()
 {
    if (jj_3R_SpecialStringFunctionWithNamedParameters_4592_9_251()) return true;
    return false;
  }

  private boolean jj_3_53()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_Delete_1508_20_143()) {
    jj_scanpos = xsp;
    if (jj_scan_token(105)) return true;
    }
    return false;
  }

  private boolean jj_3R_Function_4574_9_462()
 {
    if (jj_scan_token(373)) return true;
    if (jj_scan_token(K_FN)) return true;
    if (jj_3R_InternalFunction_4627_5_639()) return true;
    if (jj_scan_token(360)) return true;
    return false;
  }

  private boolean jj_3R_FullTextSearch_4521_62_483()
 {
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_3R_Column_1626_5_133()) return true;
    return false;
  }

  private boolean jj_3R_Delete_1504_5_683()
 {
    if (jj_scan_token(K_DELETE)) return true;
    return false;
  }

  private boolean jj_3R_Function_4573_5_210()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_Function_4574_9_462()) {
    jj_scanpos = xsp;
    if (jj_3_219()) {
    jj_scanpos = xsp;
    if (jj_3R_Function_4576_11_463()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_WhenThenSearchCondition_4434_133_795()
 {
    if (jj_scan_token(326)) return true;
    return false;
  }

  private boolean jj_3R_CaseWhenExpression_4412_132_744()
 {
    if (jj_scan_token(326)) return true;
    return false;
  }

  private boolean jj_3R_FullTextSearch_4531_9_487()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(369)) {
    jj_scanpos = xsp;
    if (jj_scan_token(370)) {
    jj_scanpos = xsp;
    if (jj_scan_token(371)) {
    jj_scanpos = xsp;
    if (jj_scan_token(372)) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_FullTextSearch_4528_7_486()
 {
    if (jj_3R_SimpleJdbcNamedParameter_2767_5_665()) return true;
    return false;
  }

  private boolean jj_3_51()
 {
    if (jj_scan_token(325)) return true;
    if (jj_3R_SelectWithWithItems_1775_5_140()) return true;
    return false;
  }

  private boolean jj_3R_FullTextSearch_4526_7_485()
 {
    if (jj_3R_SimpleJdbcParameter_2756_5_245()) return true;
    return false;
  }

  private boolean jj_3R_FullTextSearch_4524_7_484()
 {
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_Upsert_1434_23_142()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(285)) {
    jj_scanpos = xsp;
    if (jj_scan_token(284)) return true;
    }
    return false;
  }

  private boolean jj_3R_FullTextSearch_4521_5_233()
 {
    if (jj_scan_token(K_MATCH)) return true;
    if (jj_scan_token(325)) return true;
    if (jj_3R_Column_1626_5_133()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_FullTextSearch_4521_62_483()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(326)) return true;
    if (jj_scan_token(K_AGAINST)) return true;
    if (jj_scan_token(325)) return true;
    xsp = jj_scanpos;
    if (jj_3R_FullTextSearch_4524_7_484()) {
    jj_scanpos = xsp;
    if (jj_3R_FullTextSearch_4526_7_485()) {
    jj_scanpos = xsp;
    if (jj_3R_FullTextSearch_4528_7_486()) return true;
    }
    }
    xsp = jj_scanpos;
    if (jj_3R_FullTextSearch_4531_9_487()) jj_scanpos = xsp;
    if (jj_scan_token(326)) return true;
    return false;
  }

  private boolean jj_3_52()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_Upsert_1434_23_142()) jj_scanpos = xsp;
    if (jj_scan_token(325)) return true;
    if (jj_3R_SimpleExpression_3535_5_132()) return true;
    return false;
  }

  private boolean jj_3_50()
 {
    if (jj_scan_token(325)) return true;
    if (jj_3R_Column_1626_5_133()) return true;
    return false;
  }

  private boolean jj_3R_Execute_4501_9_250()
 {
    if (jj_scan_token(325)) return true;
    return false;
  }

  private boolean jj_3_217()
 {
    if (jj_3R_SimpleExpressionList_3358_5_169()) return true;
    return false;
  }

  private boolean jj_3R_Upsert_1428_5_557()
 {
    if (jj_scan_token(K_UPSERT)) return true;
    return false;
  }

  private boolean jj_3_216()
 {
    if (jj_3R_VariableExpression_4471_5_249()) return true;
    return false;
  }

  private boolean jj_3_218()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_216()) {
    jj_scanpos = xsp;
    if (jj_3_217()) {
    jj_scanpos = xsp;
    if (jj_3R_Execute_4501_9_250()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_Execute_4490_11_687()
 {
    if (jj_scan_token(K_CALL)) return true;
    return false;
  }

  private boolean jj_3R_Execute_4489_11_686()
 {
    if (jj_scan_token(K_EXECUTE)) return true;
    return false;
  }

  private boolean jj_3R_Execute_4488_6_685()
 {
    if (jj_scan_token(K_EXEC)) return true;
    return false;
  }

  private boolean jj_3R_Execute_4488_5_560()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_Execute_4488_6_685()) {
    jj_scanpos = xsp;
    if (jj_3R_Execute_4489_11_686()) {
    jj_scanpos = xsp;
    if (jj_3R_Execute_4490_11_687()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_VariableExpression_4471_5_249()
 {
    if (jj_3R_UserVariable_3909_5_214()) return true;
    if (jj_scan_token(327)) return true;
    return false;
  }

  private boolean jj_3_49()
 {
    if (jj_3R_ListExpressionItem_1279_4_137()) return true;
    return false;
  }

  private boolean jj_3R_RowConstructor_4453_10_779()
 {
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_3R_ColumnDefinition_4830_5_497()) return true;
    return false;
  }

  private boolean jj_3_214()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(325)) jj_scanpos = xsp;
    if (jj_3R_CaseWhenExpression_4409_5_226()) return true;
    xsp = jj_scanpos;
    if (jj_scan_token(326)) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(290)) {
    jj_scanpos = xsp;
    if (jj_scan_token(81)) {
    jj_scanpos = xsp;
    if (jj_scan_token(84)) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_RowConstructor_4449_7_496()
 {
    if (jj_scan_token(K_ROW)) return true;
    return false;
  }

  private boolean jj_3R_RowConstructor_4449_5_248()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_RowConstructor_4449_7_496()) jj_scanpos = xsp;
    if (jj_scan_token(325)) return true;
    if (jj_3R_ColumnDefinition_4830_5_497()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_RowConstructor_4453_10_779()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(326)) return true;
    return false;
  }

  private boolean jj_3_215()
 {
    if (jj_3R_Expression_2983_5_136()) return true;
    return false;
  }

  private boolean jj_3R_WhenThenSearchCondition_4434_17_743()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(325)) jj_scanpos = xsp;
    if (jj_3R_CaseWhenExpression_4409_5_226()) return true;
    xsp = jj_scanpos;
    if (jj_3R_WhenThenSearchCondition_4434_133_795()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_212()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(325)) jj_scanpos = xsp;
    if (jj_3R_CaseWhenExpression_4409_5_226()) return true;
    xsp = jj_scanpos;
    if (jj_scan_token(326)) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(290)) {
    jj_scanpos = xsp;
    if (jj_scan_token(81)) {
    jj_scanpos = xsp;
    if (jj_scan_token(84)) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_WhenThenSearchCondition_4432_5_645()
 {
    if (jj_scan_token(K_WHEN)) return true;
    if (jj_3R_Expression_2983_5_136()) return true;
    if (jj_scan_token(K_THEN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_WhenThenSearchCondition_4434_17_743()) {
    jj_scanpos = xsp;
    if (jj_3_215()) return true;
    }
    return false;
  }

  private boolean jj_3R_IntervalExpression_4197_237_492()
 {
    if (jj_3R_Column_1626_5_133()) return true;
    return false;
  }

  private boolean jj_3_213()
 {
    if (jj_3R_Expression_2983_5_136()) return true;
    return false;
  }

  private boolean jj_3R_CaseWhenExpression_4412_16_667()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(325)) jj_scanpos = xsp;
    if (jj_3R_CaseWhenExpression_4409_5_226()) return true;
    xsp = jj_scanpos;
    if (jj_3R_CaseWhenExpression_4412_132_744()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_47()
 {
    if (jj_scan_token(325)) return true;
    if (jj_3R_SelectWithWithItems_1775_5_140()) return true;
    return false;
  }

  private boolean jj_3R_CaseWhenExpression_4411_7_476()
 {
    if (jj_3R_WhenThenSearchCondition_4432_5_645()) return true;
    return false;
  }

  private boolean jj_3R_CaseWhenExpression_4412_6_498()
 {
    if (jj_scan_token(K_ELSE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_CaseWhenExpression_4412_16_667()) {
    jj_scanpos = xsp;
    if (jj_3_213()) return true;
    }
    return false;
  }

  private boolean jj_3R_Insert_1323_23_141()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(285)) {
    jj_scanpos = xsp;
    if (jj_scan_token(284)) return true;
    }
    return false;
  }

  private boolean jj_3_211()
 {
    if (jj_3R_Expression_2983_5_136()) return true;
    return false;
  }

  private boolean jj_3R_WindowOffset_4323_91_865()
 {
    if (jj_scan_token(K_FOLLOWING)) return true;
    return false;
  }

  private boolean jj_3R_CaseWhenExpression_4409_5_226()
 {
    if (jj_scan_token(K_CASE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_211()) jj_scanpos = xsp;
    if (jj_3R_CaseWhenExpression_4411_7_476()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_CaseWhenExpression_4411_7_476()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_CaseWhenExpression_4412_6_498()) jj_scanpos = xsp;
    if (jj_scan_token(K_END)) return true;
    return false;
  }

  private boolean jj_3R_WindowOffset_4314_89_863()
 {
    if (jj_scan_token(K_FOLLOWING)) return true;
    return false;
  }

  private boolean jj_3_48()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_Insert_1323_23_141()) jj_scanpos = xsp;
    if (jj_scan_token(325)) return true;
    if (jj_3R_SimpleExpression_3535_5_132()) return true;
    return false;
  }

  private boolean jj_3_202()
 {
    if (jj_3R_Function_4573_5_210()) return true;
    return false;
  }

  private boolean jj_3R_TryCastExpression_4390_11_886()
 {
    if (jj_3R_ColDataType_5116_5_549()) return true;
    return false;
  }

  private boolean jj_3_46()
 {
    if (jj_scan_token(325)) return true;
    if (jj_3R_Column_1626_5_133()) return true;
    return false;
  }

  private boolean jj_3_210()
 {
    if (jj_3R_RowConstructor_4449_5_248()) return true;
    return false;
  }

  private boolean jj_3R_IntervalExpression_4197_195_491()
 {
    if (jj_3R_Function_4573_5_210()) return true;
    return false;
  }

  private boolean jj_3R_TryCastExpression_4384_5_236()
 {
    if (jj_scan_token(K_TRY_CAST)) return true;
    if (jj_scan_token(325)) return true;
    if (jj_3R_SimpleExpression_3535_5_132()) return true;
    if (jj_scan_token(K_AS)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_210()) {
    jj_scanpos = xsp;
    if (jj_3R_TryCastExpression_4390_11_886()) return true;
    }
    if (jj_scan_token(326)) return true;
    return false;
  }

  private boolean jj_3R_Insert_1311_5_681()
 {
    if (jj_scan_token(K_INSERT)) return true;
    return false;
  }

  private boolean jj_3_205()
 {
    if (jj_3R_windowFun_4251_5_246()) return true;
    return false;
  }

  private boolean jj_3R_CastExpression_4365_11_885()
 {
    if (jj_3R_ColDataType_5116_5_549()) return true;
    return false;
  }

  private boolean jj_3_209()
 {
    if (jj_3R_RowConstructor_4449_5_248()) return true;
    return false;
  }

  private boolean jj_3R_CastExpression_4359_5_235()
 {
    if (jj_scan_token(K_CAST)) return true;
    if (jj_scan_token(325)) return true;
    if (jj_3R_SimpleExpression_3535_5_132()) return true;
    if (jj_scan_token(K_AS)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_209()) {
    jj_scanpos = xsp;
    if (jj_3R_CastExpression_4365_11_885()) return true;
    }
    if (jj_scan_token(326)) return true;
    return false;
  }

  private boolean jj_3R_IntervalExpression_4197_165_490()
 {
    if (jj_3R_JdbcNamedParameter_3884_5_227()) return true;
    return false;
  }

  private boolean jj_3R_WindowElement_4290_71_791()
 {
    if (jj_scan_token(K_RANGE)) return true;
    return false;
  }

  private boolean jj_3R_ListExpressionItem_1279_4_137()
 {
    if (jj_3R_SelectExpressionItem_2073_7_172()) return true;
    return false;
  }

  private boolean jj_3R_WindowOffset_4313_40_862()
 {
    if (jj_scan_token(K_PRECEDING)) return true;
    return false;
  }

  private boolean jj_3R_WindowOffset_4323_26_864()
 {
    if (jj_scan_token(K_PRECEDING)) return true;
    return false;
  }

  private boolean jj_3R_Replace_1256_21_576()
 {
    if (jj_3R_SubSelect_4738_5_134()) return true;
    return false;
  }

  private boolean jj_3R_Replace_1244_31_138()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(285)) {
    jj_scanpos = xsp;
    if (jj_scan_token(284)) return true;
    }
    return false;
  }

  private boolean jj_3R_ExtractExpression_4339_5_229()
 {
    if (jj_scan_token(K_EXTRACT)) return true;
    if (jj_scan_token(325)) return true;
    if (jj_3R_RelObjectName_1689_5_173()) return true;
    if (jj_scan_token(K_FROM)) return true;
    if (jj_3R_SimpleExpression_3535_5_132()) return true;
    if (jj_scan_token(326)) return true;
    return false;
  }

  private boolean jj_3_208()
 {
    if (jj_3R_SimpleExpression_3535_5_132()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_WindowOffset_4323_26_864()) {
    jj_scanpos = xsp;
    if (jj_3R_WindowOffset_4323_91_865()) return true;
    }
    return false;
  }

  private boolean jj_3_207()
 {
    if (jj_scan_token(K_CURRENT)) return true;
    if (jj_scan_token(K_ROW)) return true;
    return false;
  }

  private boolean jj_3_45()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_Replace_1244_31_138()) jj_scanpos = xsp;
    if (jj_scan_token(325)) return true;
    if (jj_3R_PrimaryExpression_3715_5_139()) return true;
    return false;
  }

  private boolean jj_3R_WindowOffset_4312_17_495()
 {
    if (jj_scan_token(K_UNBOUNDED)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_WindowOffset_4313_40_862()) {
    jj_scanpos = xsp;
    if (jj_3R_WindowOffset_4314_89_863()) return true;
    }
    return false;
  }

  private boolean jj_3_44()
 {
    if (jj_scan_token(325)) return true;
    if (jj_3R_Column_1626_5_133()) return true;
    return false;
  }

  private boolean jj_3R_Replace_1241_9_308()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_44()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_45()) {
    jj_scanpos = xsp;
    if (jj_3R_Replace_1256_21_576()) return true;
    }
    return false;
  }

  private boolean jj_3_43()
 {
    if (jj_scan_token(K_INTO)) return true;
    return false;
  }

  private boolean jj_3R_WindowOffset_4311_5_247()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_WindowOffset_4312_17_495()) {
    jj_scanpos = xsp;
    if (jj_3_207()) {
    jj_scanpos = xsp;
    if (jj_3_208()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_KeepExpression_4234_79_814()
 {
    if (jj_scan_token(K_LAST)) return true;
    return false;
  }

  private boolean jj_3R_Replace_1232_9_307()
 {
    if (jj_scan_token(K_SET)) return true;
    return false;
  }

  private boolean jj_3_201()
 {
    if (jj_3R_SimpleJdbcParameter_2756_5_245()) return true;
    return false;
  }

  private boolean jj_3R_Replace_1229_5_115()
 {
    if (jj_scan_token(K_REPLACE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_43()) jj_scanpos = xsp;
    if (jj_3R_Table_1750_5_176()) return true;
    xsp = jj_scanpos;
    if (jj_3R_Replace_1232_9_307()) {
    jj_scanpos = xsp;
    if (jj_3R_Replace_1241_9_308()) return true;
    }
    return false;
  }

  private boolean jj_3_206()
 {
    if (jj_3R_WindowOffset_4311_5_247()) return true;
    return false;
  }

  private boolean jj_3R_IntervalExpression_4197_101_489()
 {
    if (jj_3R_SimpleJdbcParameter_2756_5_245()) return true;
    return false;
  }

  private boolean jj_3R_WindowElement_4291_7_792()
 {
    if (jj_scan_token(K_BETWEEN)) return true;
    if (jj_3R_WindowOffset_4311_5_247()) return true;
    if (jj_scan_token(K_AND)) return true;
    if (jj_3R_WindowOffset_4311_5_247()) return true;
    return false;
  }

  private boolean jj_3R_WindowElement_4290_6_790()
 {
    if (jj_scan_token(K_ROWS)) return true;
    return false;
  }

  private boolean jj_3R_WindowElement_4290_5_741()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_WindowElement_4290_6_790()) {
    jj_scanpos = xsp;
    if (jj_3R_WindowElement_4290_71_791()) return true;
    }
    xsp = jj_scanpos;
    if (jj_3R_WindowElement_4291_7_792()) {
    jj_scanpos = xsp;
    if (jj_3_206()) return true;
    }
    return false;
  }

  private boolean jj_3_42()
 {
    if (jj_3R_ListExpressionItem_1279_4_137()) return true;
    return false;
  }

  private boolean jj_3R_AnalyticExpression_4276_11_475()
 {
    if (jj_3R_windowFun_4251_5_246()) return true;
    return false;
  }

  private boolean jj_3R_AnalyticExpression_4275_6_474()
 {
    if (jj_scan_token(K_FILTER)) return true;
    if (jj_scan_token(325)) return true;
    if (jj_scan_token(K_WHERE)) return true;
    if (jj_3R_Expression_2983_5_136()) return true;
    if (jj_scan_token(326)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_205()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_AnalyticExpression_4275_5_224()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_AnalyticExpression_4275_6_474()) {
    jj_scanpos = xsp;
    if (jj_3R_AnalyticExpression_4276_11_475()) return true;
    }
    return false;
  }

  private boolean jj_3_204()
 {
    if (jj_3R_ComplexExpressionList_3373_5_135()) return true;
    return false;
  }

  private boolean jj_3R_KeepExpression_4234_42_813()
 {
    if (jj_scan_token(K_FIRST)) return true;
    return false;
  }

  private boolean jj_3_40()
 {
    if (jj_3R_Expression_2983_5_136()) return true;
    return false;
  }

  private boolean jj_3_39()
 {
    if (jj_scan_token(325)) return true;
    if (jj_3R_ComplexExpressionList_3373_5_135()) return true;
    if (jj_scan_token(326)) return true;
    return false;
  }

  private boolean jj_3R_windowFun_4257_15_914()
 {
    if (jj_scan_token(325)) return true;
    if (jj_3R_ComplexExpressionList_3373_5_135()) return true;
    if (jj_scan_token(326)) return true;
    return false;
  }

  private boolean jj_3_38()
 {
    if (jj_3R_SubSelect_4738_5_134()) return true;
    return false;
  }

  private boolean jj_3R_windowFun_4256_14_913()
 {
    if (jj_3R_ComplexExpressionList_3373_5_135()) return true;
    return false;
  }

  private boolean jj_3R_windowFun_4260_10_908()
 {
    if (jj_3R_WindowElement_4290_5_741()) return true;
    return false;
  }

  private boolean jj_3R_windowFun_4259_10_907()
 {
    if (jj_3R_OrderByElements_2726_5_164()) return true;
    return false;
  }

  private boolean jj_3R_windowFun_4255_10_906()
 {
    if (jj_scan_token(K_PARTITION)) return true;
    if (jj_scan_token(K_BY)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_windowFun_4256_14_913()) {
    jj_scanpos = xsp;
    if (jj_3R_windowFun_4257_15_914()) return true;
    }
    return false;
  }

  private boolean jj_3_37()
 {
    if (jj_scan_token(326)) return true;
    return false;
  }

  private boolean jj_3_36()
 {
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_3R_Column_1626_5_133()) return true;
    return false;
  }

  private boolean jj_3R_windowFun_4252_11_494()
 {
    if (jj_scan_token(K_WITHIN)) return true;
    if (jj_scan_token(K_GROUP)) return true;
    return false;
  }

  private boolean jj_3_35()
 {
    if (jj_scan_token(325)) return true;
    return false;
  }

  private boolean jj_3R_windowFun_4251_7_666()
 {
    if (jj_scan_token(K_IGNORE)) return true;
    if (jj_scan_token(K_NULLS)) return true;
    return false;
  }

  private boolean jj_3R_windowFun_4251_6_493()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_windowFun_4251_7_666()) jj_scanpos = xsp;
    if (jj_scan_token(K_OVER)) return true;
    return false;
  }

  private boolean jj_3R_windowFun_4251_5_246()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_windowFun_4251_6_493()) {
    jj_scanpos = xsp;
    if (jj_3R_windowFun_4252_11_494()) return true;
    }
    if (jj_scan_token(325)) return true;
    xsp = jj_scanpos;
    if (jj_3R_windowFun_4255_10_906()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_windowFun_4259_10_907()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_windowFun_4260_10_908()) jj_scanpos = xsp;
    if (jj_scan_token(326)) return true;
    return false;
  }

  private boolean jj_3_34()
 {
    if (jj_3R_Expression_2983_5_136()) return true;
    return false;
  }

  private boolean jj_3_33()
 {
    if (jj_scan_token(325)) return true;
    if (jj_3R_ComplexExpressionList_3373_5_135()) return true;
    if (jj_scan_token(326)) return true;
    return false;
  }

  private boolean jj_3_32()
 {
    if (jj_3R_SubSelect_4738_5_134()) return true;
    return false;
  }

  private boolean jj_3_31()
 {
    if (jj_scan_token(326)) return true;
    return false;
  }

  private boolean jj_3_30()
 {
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_3R_Column_1626_5_133()) return true;
    return false;
  }

  private boolean jj_3_29()
 {
    if (jj_scan_token(325)) return true;
    return false;
  }

  private boolean jj_3R_KeepExpression_4234_5_261()
 {
    if (jj_scan_token(K_KEEP)) return true;
    if (jj_scan_token(325)) return true;
    if (jj_scan_token(S_IDENTIFIER)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_KeepExpression_4234_42_813()) {
    jj_scanpos = xsp;
    if (jj_3R_KeepExpression_4234_79_814()) return true;
    }
    if (jj_3R_OrderByElements_2726_5_164()) return true;
    if (jj_scan_token(326)) return true;
    return false;
  }

  private boolean jj_3_41()
 {
    if (jj_3R_Column_1626_5_133()) return true;
    if (jj_scan_token(327)) return true;
    if (jj_3R_SimpleExpression_3535_5_132()) return true;
    return false;
  }

  private boolean jj_3R_IntervalExpressionWithoutInterval_4218_5_241()
 {
    if (jj_scan_token(K_DATE_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_Update_1141_4_682()
 {
    if (jj_scan_token(K_UPDATE)) return true;
    return false;
  }

  private boolean jj_3R_IntervalExpression_4197_19_488()
 {
    if (jj_scan_token(345)) return true;
    return false;
  }

  private boolean jj_3_203()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(319)) {
    jj_scanpos = xsp;
    if (jj_scan_token(62)) return true;
    }
    return false;
  }

  private boolean jj_3R_ShowTables_1084_53_595()
 {
    if (jj_scan_token(K_WHERE)) return true;
    if (jj_3R_Expression_2983_5_136()) return true;
    return false;
  }

  private boolean jj_3R_IntervalExpression_4196_1_234()
 {
    if (jj_scan_token(K_INTERVAL)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_IntervalExpression_4197_19_488()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(313)) {
    jj_scanpos = xsp;
    if (jj_scan_token(312)) {
    jj_scanpos = xsp;
    if (jj_scan_token(322)) {
    jj_scanpos = xsp;
    if (jj_3R_IntervalExpression_4197_101_489()) {
    jj_scanpos = xsp;
    if (jj_3R_IntervalExpression_4197_165_490()) {
    jj_scanpos = xsp;
    if (jj_3R_IntervalExpression_4197_195_491()) {
    jj_scanpos = xsp;
    if (jj_3R_IntervalExpression_4197_237_492()) return true;
    }
    }
    }
    }
    }
    }
    xsp = jj_scanpos;
    if (jj_3_203()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_199()
 {
    if (jj_3R_ComplexExpressionList_3373_5_135()) return true;
    return false;
  }

  private boolean jj_3R_JsonAggregateFunction_4170_19_740()
 {
    if (jj_scan_token(325)) return true;
    if (jj_3R_ComplexExpressionList_3373_5_135()) return true;
    if (jj_scan_token(326)) return true;
    return false;
  }

  private boolean jj_3R_JsonAggregateFunction_4173_14_664()
 {
    if (jj_3R_WindowElement_4290_5_741()) return true;
    return false;
  }

  private boolean jj_3R_JsonAggregateFunction_4169_18_739()
 {
    if (jj_3R_ComplexExpressionList_3373_5_135()) return true;
    return false;
  }

  private boolean jj_3R_JsonAggregateFunction_4172_14_663()
 {
    if (jj_3R_OrderByElements_2726_5_164()) return true;
    return false;
  }

  private boolean jj_3R_Values_1109_5_609()
 {
    if (jj_scan_token(K_VALUES)) return true;
    if (jj_3R_SimpleExpressionList_3358_5_169()) return true;
    return false;
  }

  private boolean jj_3R_JsonAggregateFunction_4168_14_662()
 {
    if (jj_scan_token(K_PARTITION)) return true;
    if (jj_scan_token(K_BY)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_JsonAggregateFunction_4169_18_739()) {
    jj_scanpos = xsp;
    if (jj_3R_JsonAggregateFunction_4170_19_740()) return true;
    }
    return false;
  }

  private boolean jj_3_200()
 {
    if (jj_scan_token(K_OVER)) return true;
    if (jj_scan_token(325)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_JsonAggregateFunction_4168_14_662()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_JsonAggregateFunction_4172_14_663()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_JsonAggregateFunction_4173_14_664()) jj_scanpos = xsp;
    if (jj_scan_token(326)) return true;
    return false;
  }

  private boolean jj_3R_Show_1100_5_564()
 {
    if (jj_scan_token(K_SHOW)) return true;
    return false;
  }

  private boolean jj_3_198()
 {
    if (jj_scan_token(K_FILTER)) return true;
    if (jj_scan_token(325)) return true;
    if (jj_scan_token(K_WHERE)) return true;
    if (jj_3R_Expression_2983_5_136()) return true;
    if (jj_scan_token(326)) return true;
    return false;
  }

  private boolean jj_3R_JsonAggregateFunction_4152_15_738()
 {
    if (jj_scan_token(K_ABSENT)) return true;
    if (jj_scan_token(K_ON)) return true;
    if (jj_scan_token(K_NULL)) return true;
    return false;
  }

  private boolean jj_3_197()
 {
    if (jj_scan_token(K_NULL)) return true;
    if (jj_scan_token(K_ON)) return true;
    if (jj_scan_token(K_NULL)) return true;
    return false;
  }

  private boolean jj_3R_JsonAggregateFunction_4148_15_661()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_197()) {
    jj_scanpos = xsp;
    if (jj_3R_JsonAggregateFunction_4152_15_738()) return true;
    }
    return false;
  }

  private boolean jj_3R_ShowTables_1084_6_594()
 {
    if (jj_scan_token(K_LIKE)) return true;
    if (jj_3R_SimpleExpression_3535_5_132()) return true;
    return false;
  }

  private boolean jj_3R_ShowTables_1084_5_346()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ShowTables_1084_6_594()) {
    jj_scanpos = xsp;
    if (jj_3R_ShowTables_1084_53_595()) return true;
    }
    return false;
  }

  private boolean jj_3R_JsonAggregateFunction_4145_15_660()
 {
    if (jj_3R_OrderByElements_2726_5_164()) return true;
    return false;
  }

  private boolean jj_3R_JsonAggregateFunction_4144_15_659()
 {
    if (jj_scan_token(K_FORMAT)) return true;
    if (jj_scan_token(K_JSON)) return true;
    return false;
  }

  private boolean jj_3R_ShowTables_1080_7_593()
 {
    if (jj_scan_token(K_IN)) return true;
    return false;
  }

  private boolean jj_3R_ShowTables_1079_7_592()
 {
    if (jj_scan_token(K_FROM)) return true;
    return false;
  }

  private boolean jj_3R_ShowTables_1078_5_345()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ShowTables_1079_7_592()) {
    jj_scanpos = xsp;
    if (jj_3R_ShowTables_1080_7_593()) return true;
    }
    if (jj_3R_RelObjectNameExt_1719_5_342()) return true;
    return false;
  }

  private boolean jj_3R_ShowTables_1075_5_344()
 {
    if (jj_scan_token(K_FULL)) return true;
    return false;
  }

  private boolean jj_3R_JsonAggregateFunction_4140_11_482()
 {
    if (jj_scan_token(K_JSON_ARRAYAGG)) return true;
    if (jj_scan_token(325)) return true;
    if (jj_3R_Expression_2983_5_136()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_JsonAggregateFunction_4144_15_659()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_JsonAggregateFunction_4145_15_660()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_JsonAggregateFunction_4148_15_661()) jj_scanpos = xsp;
    if (jj_scan_token(326)) return true;
    return false;
  }

  private boolean jj_3R_ShowTables_1074_5_343()
 {
    if (jj_scan_token(K_EXTENDED)) return true;
    return false;
  }

  private boolean jj_3R_JsonAggregateFunction_4133_15_737()
 {
    if (jj_scan_token(K_WITHOUT)) return true;
    if (jj_scan_token(K_UNIQUE)) return true;
    if (jj_scan_token(K_KEYS)) return true;
    return false;
  }

  private boolean jj_3R_ShowTables_1073_3_128()
 {
    if (jj_scan_token(K_SHOW)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_ShowTables_1074_5_343()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_ShowTables_1075_5_344()) jj_scanpos = xsp;
    if (jj_scan_token(K_TABLES)) return true;
    xsp = jj_scanpos;
    if (jj_3R_ShowTables_1078_5_345()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_ShowTables_1084_5_346()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_JsonAggregateFunction_4129_15_658()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_JsonAggregateFunction_4129_15_736()) {
    jj_scanpos = xsp;
    if (jj_3R_JsonAggregateFunction_4133_15_737()) return true;
    }
    return false;
  }

  private boolean jj_3R_JsonAggregateFunction_4129_15_736()
 {
    if (jj_scan_token(K_WITH)) return true;
    if (jj_scan_token(K_UNIQUE)) return true;
    if (jj_scan_token(K_KEYS)) return true;
    return false;
  }

  private boolean jj_3R_JsonAggregateFunction_4123_15_735()
 {
    if (jj_scan_token(K_ABSENT)) return true;
    if (jj_scan_token(K_ON)) return true;
    if (jj_scan_token(K_NULL)) return true;
    return false;
  }

  private boolean jj_3_196()
 {
    if (jj_scan_token(K_NULL)) return true;
    if (jj_scan_token(K_ON)) return true;
    if (jj_scan_token(K_NULL)) return true;
    return false;
  }

  private boolean jj_3R_JsonAggregateFunction_4113_21_655()
 {
    if (jj_scan_token(K_VALUE)) return true;
    return false;
  }

  private boolean jj_3R_JsonAggregateFunction_4119_15_657()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_196()) {
    jj_scanpos = xsp;
    if (jj_3R_JsonAggregateFunction_4123_15_735()) return true;
    }
    return false;
  }

  private boolean jj_3_28()
 {
    if (jj_scan_token(K_SCHEMA)) return true;
    return false;
  }

  private boolean jj_3R_ShowColumns_1057_5_127()
 {
    if (jj_scan_token(K_SHOW)) return true;
    if (jj_scan_token(K_COLUMNS)) return true;
    if (jj_scan_token(K_FROM)) return true;
    if (jj_3R_RelObjectNameExt_1719_5_342()) return true;
    return false;
  }

  private boolean jj_3R_JsonAggregateFunction_4116_15_656()
 {
    if (jj_scan_token(K_FORMAT)) return true;
    if (jj_scan_token(K_JSON)) return true;
    return false;
  }

  private boolean jj_3R_JsonFunction_4030_101_787()
 {
    if (jj_scan_token(K_VALUE)) return true;
    return false;
  }

  private boolean jj_3R_JsonAggregateFunction_4111_15_654()
 {
    if (jj_scan_token(K_KEY)) return true;
    return false;
  }

  private boolean jj_3R_Use_1047_5_565()
 {
    if (jj_scan_token(K_USE)) return true;
    return false;
  }

  private boolean jj_3R_JsonAggregateFunction_4109_11_481()
 {
    if (jj_scan_token(K_JSON_OBJECTAGG)) return true;
    if (jj_scan_token(325)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_JsonAggregateFunction_4111_15_654()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(311)) {
    jj_scanpos = xsp;
    if (jj_scan_token(312)) {
    jj_scanpos = xsp;
    if (jj_scan_token(313)) {
    jj_scanpos = xsp;
    if (jj_scan_token(315)) {
    jj_scanpos = xsp;
    if (jj_scan_token(322)) {
    jj_scanpos = xsp;
    if (jj_scan_token(319)) {
    jj_scanpos = xsp;
    if (jj_scan_token(323)) return true;
    }
    }
    }
    }
    }
    }
    xsp = jj_scanpos;
    if (jj_scan_token(330)) {
    jj_scanpos = xsp;
    if (jj_3R_JsonAggregateFunction_4113_21_655()) return true;
    }
    xsp = jj_scanpos;
    if (jj_scan_token(319)) {
    jj_scanpos = xsp;
    if (jj_scan_token(323)) return true;
    }
    xsp = jj_scanpos;
    if (jj_3R_JsonAggregateFunction_4116_15_656()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_JsonAggregateFunction_4119_15_657()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_JsonAggregateFunction_4129_15_658()) jj_scanpos = xsp;
    if (jj_scan_token(326)) return true;
    return false;
  }

  private boolean jj_3R_JsonFunction_4009_104_244()
 {
    if (jj_scan_token(K_VALUE)) return true;
    return false;
  }

  private boolean jj_3R_JsonAggregateFunction_4107_5_232()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_JsonAggregateFunction_4109_11_481()) {
    jj_scanpos = xsp;
    if (jj_3R_JsonAggregateFunction_4140_11_482()) return true;
    }
    xsp = jj_scanpos;
    if (jj_3_198()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_200()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_193()
 {
    if (jj_scan_token(K_FORMAT)) return true;
    if (jj_scan_token(K_JSON)) return true;
    return false;
  }

  private boolean jj_3R_JsonFunction_4081_19_653()
 {
    if (jj_scan_token(K_ABSENT)) return true;
    if (jj_scan_token(K_ON)) return true;
    if (jj_scan_token(K_NULL)) return true;
    return false;
  }

  private boolean jj_3R_JsonFunction_4074_25_789()
 {
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_3R_Expression_2983_5_136()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_193()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_192()
 {
    if (jj_scan_token(K_FORMAT)) return true;
    if (jj_scan_token(K_JSON)) return true;
    return false;
  }

  private boolean jj_3_195()
 {
    if (jj_3R_Expression_2983_5_136()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_192()) jj_scanpos = xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_JsonFunction_4074_25_789()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_191()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_194()) {
    jj_scanpos = xsp;
    if (jj_3_195()) return true;
    }
    return false;
  }

  private boolean jj_3_194()
 {
    if (jj_scan_token(K_NULL)) return true;
    if (jj_scan_token(K_ON)) return true;
    if (jj_scan_token(K_NULL)) return true;
    return false;
  }

  private boolean jj_3R_JsonFunction_4054_23_734()
 {
    if (jj_scan_token(K_WITHOUT)) return true;
    if (jj_scan_token(K_UNIQUE)) return true;
    if (jj_scan_token(K_KEYS)) return true;
    return false;
  }

  private boolean jj_3R_JsonFunction_4062_11_480()
 {
    if (jj_scan_token(K_JSON_ARRAY)) return true;
    if (jj_scan_token(325)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_191()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_JsonFunction_4081_19_653()) jj_scanpos = xsp;
    if (jj_scan_token(326)) return true;
    return false;
  }

  private boolean jj_3R_JsonFunction_4050_23_652()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_JsonFunction_4050_23_733()) {
    jj_scanpos = xsp;
    if (jj_3R_JsonFunction_4054_23_734()) return true;
    }
    return false;
  }

  private boolean jj_3R_JsonFunction_4050_23_733()
 {
    if (jj_scan_token(K_WITH)) return true;
    if (jj_scan_token(K_UNIQUE)) return true;
    if (jj_scan_token(K_KEYS)) return true;
    return false;
  }

  private boolean jj_3R_JsonFunction_4030_41_786()
 {
    if (jj_scan_token(K_COMMA)) return true;
    return false;
  }

  private boolean jj_3R_JsonFunction_4034_35_788()
 {
    if (jj_scan_token(K_FORMAT)) return true;
    if (jj_scan_token(K_JSON)) return true;
    return false;
  }

  private boolean jj_3R_JsonFunction_4044_23_732()
 {
    if (jj_scan_token(K_ABSENT)) return true;
    if (jj_scan_token(K_ON)) return true;
    if (jj_scan_token(K_NULL)) return true;
    return false;
  }

  private boolean jj_3R_JsonFunction_4028_37_785()
 {
    if (jj_scan_token(K_KEY)) return true;
    return false;
  }

  private boolean jj_3R_JsonFunction_4040_23_651()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_JsonFunction_4040_23_731()) {
    jj_scanpos = xsp;
    if (jj_3R_JsonFunction_4044_23_732()) return true;
    }
    return false;
  }

  private boolean jj_3R_JsonFunction_4040_23_731()
 {
    if (jj_scan_token(K_NULL)) return true;
    if (jj_scan_token(K_ON)) return true;
    if (jj_scan_token(K_NULL)) return true;
    return false;
  }

  private boolean jj_3R_JsonFunction_4027_33_730()
 {
    if (jj_scan_token(K_COMMA)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_JsonFunction_4028_37_785()) jj_scanpos = xsp;
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    xsp = jj_scanpos;
    if (jj_scan_token(330)) {
    jj_scanpos = xsp;
    if (jj_3R_JsonFunction_4030_41_786()) {
    jj_scanpos = xsp;
    if (jj_3R_JsonFunction_4030_101_787()) return true;
    }
    }
    if (jj_3R_Expression_2983_5_136()) return true;
    xsp = jj_scanpos;
    if (jj_3R_JsonFunction_4034_35_788()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_JsonFunction_4009_42_243()
 {
    if (jj_scan_token(K_COMMA)) return true;
    return false;
  }

  private boolean jj_3R_JsonFunction_4013_35_784()
 {
    if (jj_scan_token(K_FORMAT)) return true;
    if (jj_scan_token(K_JSON)) return true;
    return false;
  }

  private boolean jj_3_190()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(330)) {
    jj_scanpos = xsp;
    if (jj_3R_JsonFunction_4009_42_243()) {
    jj_scanpos = xsp;
    if (jj_3R_JsonFunction_4009_104_244()) return true;
    }
    }
    if (jj_3R_Expression_2983_5_136()) return true;
    xsp = jj_scanpos;
    if (jj_3R_JsonFunction_4013_35_784()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_JsonFunction_4005_33_729()
 {
    if (jj_scan_token(K_KEY)) return true;
    return false;
  }

  private boolean jj_3R_JsonFunction_4004_25_650()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_JsonFunction_4005_33_729()) jj_scanpos = xsp;
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    xsp = jj_scanpos;
    if (jj_3_190()) jj_scanpos = xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_JsonFunction_4027_33_730()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_Explain_941_5_571()
 {
    if (jj_scan_token(K_EXPLAIN)) return true;
    return false;
  }

  private boolean jj_3R_JsonFunction_3999_11_479()
 {
    if (jj_scan_token(K_JSON_OBJECT)) return true;
    if (jj_scan_token(325)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_JsonFunction_4004_25_650()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_JsonFunction_4040_23_651()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_JsonFunction_4050_23_652()) jj_scanpos = xsp;
    if (jj_scan_token(326)) return true;
    return false;
  }

  private boolean jj_3R_Describe_931_5_570()
 {
    if (jj_scan_token(K_DESCRIBE)) return true;
    return false;
  }

  private boolean jj_3R_JsonFunction_3997_5_231()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_JsonFunction_3999_11_479()) {
    jj_scanpos = xsp;
    if (jj_3R_JsonFunction_4062_11_480()) return true;
    }
    return false;
  }

  private boolean jj_3R_ArrayConstructor_3945_52_242()
 {
    if (jj_3R_ArrayConstructor_3944_5_238()) return true;
    return false;
  }

  private boolean jj_3R_ArrayConstructor_3947_42_844()
 {
    if (jj_3R_ArrayConstructor_3944_5_238()) return true;
    return false;
  }

  private boolean jj_3R_JsonExpression_3974_9_649()
 {
    if (jj_scan_token(368)) return true;
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_JsonExpression_3973_9_648()
 {
    if (jj_scan_token(367)) return true;
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_PurgeStatement_905_5_574()
 {
    if (jj_scan_token(K_PURGE)) return true;
    return false;
  }

  private boolean jj_3R_JsonExpression_3972_9_647()
 {
    if (jj_scan_token(366)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(322)) {
    jj_scanpos = xsp;
    if (jj_scan_token(313)) return true;
    }
    return false;
  }

  private boolean jj_3R_JsonExpression_3971_9_478()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_JsonExpression_3971_9_646()) {
    jj_scanpos = xsp;
    if (jj_3R_JsonExpression_3972_9_647()) {
    jj_scanpos = xsp;
    if (jj_3R_JsonExpression_3973_9_648()) {
    jj_scanpos = xsp;
    if (jj_3R_JsonExpression_3974_9_649()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_JsonExpression_3971_9_646()
 {
    if (jj_scan_token(365)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(322)) {
    jj_scanpos = xsp;
    if (jj_scan_token(313)) return true;
    }
    return false;
  }

  private boolean jj_3R_JsonExpression_3963_7_477()
 {
    if (jj_scan_token(363)) return true;
    if (jj_3R_ColDataType_5116_5_549()) return true;
    return false;
  }

  private boolean jj_3R_JsonExpression_3962_5_230()
 {
    if (jj_3R_Column_1626_5_133()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_JsonExpression_3963_7_477()) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_JsonExpression_3971_9_478()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_JsonExpression_3971_9_478()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_188()
 {
    if (jj_3R_SimpleExpression_3535_5_132()) return true;
    return false;
  }

  private boolean jj_3_187()
 {
    if (jj_3R_SimpleExpression_3535_5_132()) return true;
    return false;
  }

  private boolean jj_3R_ArrayConstructor_3947_10_819()
 {
    if (jj_scan_token(K_COMMA)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_188()) {
    jj_scanpos = xsp;
    if (jj_3R_ArrayConstructor_3947_42_844()) return true;
    }
    return false;
  }

  private boolean jj_3_189()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_187()) {
    jj_scanpos = xsp;
    if (jj_3R_ArrayConstructor_3945_52_242()) return true;
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_ArrayConstructor_3947_10_819()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_Set_833_47_347()
 {
    if (jj_scan_token(327)) return true;
    return false;
  }

  private boolean jj_3R_ArrayConstructor_3944_5_238()
 {
    if (jj_scan_token(357)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_189()) jj_scanpos = xsp;
    if (jj_scan_token(358)) return true;
    return false;
  }

  private boolean jj_3_27()
 {
    if (jj_scan_token(K_IF)) return true;
    if (jj_scan_token(K_EXISTS)) return true;
    return false;
  }

  private boolean jj_3_26()
 {
    if (jj_scan_token(K_TABLE)) return true;
    return false;
  }

  private boolean jj_3R_RenameTableStatement_866_5_562()
 {
    if (jj_scan_token(K_RENAME)) return true;
    return false;
  }

  private boolean jj_3_25()
 {
    if (jj_scan_token(K_DATETIMELITERAL)) return true;
    if (jj_scan_token(K_ZONE)) return true;
    return false;
  }

  private boolean jj_3R_DateTimeLiteralExpression_3934_5_237()
 {
    if (jj_scan_token(K_DATETIMELITERAL)) return true;
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_NumericBind_3923_5_228()
 {
    if (jj_scan_token(330)) return true;
    if (jj_scan_token(S_LONG)) return true;
    return false;
  }

  private boolean jj_3R_Reset_851_5_563()
 {
    if (jj_scan_token(K_RESET)) return true;
    return false;
  }

  private boolean jj_3_24()
 {
    if (jj_3R_SimpleExpression_3535_5_132()) return true;
    return false;
  }

  private boolean jj_3R_Set_833_19_131()
 {
    if (jj_3R_RelObjectNameExt_1719_5_342()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_Set_833_47_347()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_UserVariable_3909_12_470()
 {
    if (jj_scan_token(336)) return true;
    return false;
  }

  private boolean jj_3_22()
 {
    if (jj_scan_token(K_DATETIMELITERAL)) return true;
    if (jj_scan_token(K_ZONE)) return true;
    return false;
  }

  private boolean jj_3R_UserVariable_3911_7_471()
 {
    if (jj_scan_token(329)) return true;
    if (jj_3R_RelObjectNameExt2_1737_5_148()) return true;
    return false;
  }

  private boolean jj_3R_UserVariable_3909_5_214()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(364)) {
    jj_scanpos = xsp;
    if (jj_3R_UserVariable_3909_12_470()) return true;
    }
    if (jj_3R_RelObjectNameExt2_1737_5_148()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_UserVariable_3911_7_471()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_23()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_22()) {
    jj_scanpos = xsp;
    if (jj_3R_Set_833_19_131()) return true;
    }
    if (jj_3R_SimpleExpression_3535_5_132()) return true;
    return false;
  }

  private boolean jj_3R_OracleNamedFunctionParameter_3895_5_211()
 {
    if (jj_3R_RelObjectNameExt2_1737_5_148()) return true;
    if (jj_scan_token(K_ORACLE_NAMED_PARAMETER_ASSIGNMENT)) return true;
    if (jj_3R_Expression_2983_5_136()) return true;
    return false;
  }

  private boolean jj_3_21()
 {
    if (jj_scan_token(K_DATETIMELITERAL)) return true;
    if (jj_scan_token(K_ZONE)) return true;
    return false;
  }

  private boolean jj_3_20()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(151)) {
    jj_scanpos = xsp;
    if (jj_scan_token(234)) return true;
    }
    return false;
  }

  private boolean jj_3R_Set_813_5_561()
 {
    if (jj_scan_token(K_SET)) return true;
    return false;
  }

  private boolean jj_3R_JdbcNamedParameter_3884_5_227()
 {
    if (jj_scan_token(330)) return true;
    if (jj_3R_RelObjectNameExt2_1737_5_148()) return true;
    return false;
  }

  private boolean jj_3R_NextValExpression_3873_6_239()
 {
    if (jj_scan_token(K_NEXTVAL)) return true;
    if (jj_3R_RelObjectNameList_1613_5_325()) return true;
    return false;
  }

  private boolean jj_3R_ConnectByRootOperator_3862_5_601()
 {
    if (jj_scan_token(K_CONNECT_BY_ROOT)) return true;
    if (jj_3R_Column_1626_5_133()) return true;
    return false;
  }

  private boolean jj_3R_Declare_769_5_572()
 {
    if (jj_scan_token(K_DECLARE)) return true;
    return false;
  }

  private boolean jj_3_186()
 {
    if (jj_scan_token(K_AT)) return true;
    if (jj_scan_token(K_DATETIMELITERAL)) return true;
    if (jj_scan_token(K_ZONE)) return true;
    if (jj_3R_PrimaryExpression_3715_5_139()) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_3825_7_811()
 {
    if (jj_scan_token(363)) return true;
    if (jj_3R_ColDataType_5116_5_549()) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_3823_7_810()
 {
    if (jj_3R_ArrayExpression_3689_5_839()) return true;
    return false;
  }

  private boolean jj_3_185()
 {
    if (jj_3R_IntervalExpressionWithoutInterval_4218_5_241()) return true;
    return false;
  }

  private boolean jj_3_19()
 {
    if (jj_scan_token(ST_SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_3816_9_809()
 {
    if (jj_scan_token(K_COLLATE)) return true;
    if (jj_scan_token(S_IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_3811_13_878()
 {
    if (jj_scan_token(329)) return true;
    if (jj_3R_RelObjectNameExt_1719_5_342()) return true;
    return false;
  }

  private boolean jj_3R_Statements_722_27_130()
 {
    if (jj_scan_token(ST_SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_3801_19_240()
 {
    if (jj_scan_token(325)) return true;
    if (jj_3R_SimpleExpressionList_3358_5_169()) return true;
    if (jj_scan_token(326)) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_3791_28_225()
 {
    return false;
  }

  private boolean jj_3_18()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_Statements_722_27_130()) jj_scanpos = xsp;
    if (jj_scan_token(K_ELSE)) return true;
    if (jj_3R_SingleStatement_541_5_114()) return true;
    return false;
  }

  private boolean jj_3_165()
 {
    jj_lookingAhead = true;
    jj_semLA = getAsBoolean(Feature.allowComplexParsing);
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_PrimaryExpression_3791_28_225()) return true;
    if (jj_scan_token(325)) return true;
    if (jj_3R_ComplexExpressionList_3373_5_135()) return true;
    if (jj_scan_token(326)) return true;
    return false;
  }

  private boolean jj_3_183()
 {
    if (jj_scan_token(325)) return true;
    if (jj_3R_SubSelect_4738_5_134()) return true;
    if (jj_scan_token(326)) return true;
    return false;
  }

  private boolean jj_3_184()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_165()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_3801_19_240()) return true;
    }
    xsp = jj_scanpos;
    if (jj_3R_PrimaryExpression_3811_13_878()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_17()
 {
    if (jj_scan_token(ST_SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_3787_11_373()
 {
    if (jj_scan_token(325)) return true;
    if (jj_3R_SubSelect_4738_5_134()) return true;
    if (jj_scan_token(326)) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_3785_11_372()
 {
    if (jj_scan_token(362)) return true;
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    if (jj_scan_token(360)) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_3783_11_371()
 {
    if (jj_scan_token(361)) return true;
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    if (jj_scan_token(360)) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_3781_11_370()
 {
    if (jj_scan_token(359)) return true;
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    if (jj_scan_token(360)) return true;
    return false;
  }

  private boolean jj_3R_Statements_696_24_129()
 {
    if (jj_scan_token(ST_SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3_164()
 {
    if (jj_3R_AnalyticExpression_4275_5_224()) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_3779_11_369()
 {
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    return false;
  }

  private boolean jj_3_182()
 {
    if (jj_3R_Column_1626_5_133()) return true;
    return false;
  }

  private boolean jj_3_16()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_Statements_696_24_129()) jj_scanpos = xsp;
    if (jj_scan_token(K_ELSE)) return true;
    if (jj_3R_SingleStatement_541_5_114()) return true;
    return false;
  }

  private boolean jj_3_181()
 {
    if (jj_scan_token(K_ALL)) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_3773_11_368()
 {
    if (jj_3R_ConnectByRootOperator_3862_5_601()) return true;
    return false;
  }

  private boolean jj_3_180()
 {
    if (jj_3R_NextValExpression_3873_6_239()) return true;
    return false;
  }

  private boolean jj_3_179()
 {
    if (jj_scan_token(K_ARRAY_LITERAL)) return true;
    if (jj_3R_ArrayConstructor_3944_5_238()) return true;
    return false;
  }

  private boolean jj_3_178()
 {
    if (jj_3R_DateTimeLiteralExpression_3934_5_237()) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_3765_11_367()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(257)) {
    jj_scanpos = xsp;
    if (jj_scan_token(57)) return true;
    }
    return false;
  }

  private boolean jj_3_177()
 {
    if (jj_3R_TryCastExpression_4384_5_236()) return true;
    return false;
  }

  private boolean jj_3_176()
 {
    if (jj_3R_CastExpression_4359_5_235()) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_3756_11_366()
 {
    if (jj_scan_token(S_HEX)) return true;
    return false;
  }

  private boolean jj_3_174()
 {
    if (jj_3R_FullTextSearch_4521_5_233()) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_3754_11_365()
 {
    if (jj_scan_token(S_LONG)) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_3752_11_364()
 {
    if (jj_scan_token(S_DOUBLE)) return true;
    return false;
  }

  private boolean jj_3_173()
 {
    if (jj_3R_JsonAggregateFunction_4107_5_232()) return true;
    return false;
  }

  private boolean jj_3_172()
 {
    if (jj_3R_JsonFunction_3997_5_231()) return true;
    return false;
  }

  private boolean jj_3_175()
 {
    if (jj_3R_IntervalExpression_4196_1_234()) return true;
    return false;
  }

  private boolean jj_3_171()
 {
    if (jj_3R_Function_4573_5_210()) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_3746_11_363()
 {
    if (jj_3R_FullTextSearch_4521_5_233()) return true;
    return false;
  }

  private boolean jj_3_170()
 {
    if (jj_3R_JsonExpression_3962_5_230()) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_3742_11_362()
 {
    if (jj_3R_JsonAggregateFunction_4107_5_232()) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_3740_11_361()
 {
    if (jj_3R_JsonFunction_3997_5_231()) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_3738_11_360()
 {
    if (jj_3R_Function_4573_5_210()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_164()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_3736_11_359()
 {
    if (jj_3R_JsonExpression_3962_5_230()) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_3715_31_598()
 {
    if (jj_scan_token(332)) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_3734_11_358()
 {
    if (jj_3R_XMLSerializeExpr_4668_5_600()) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_3732_11_357()
 {
    if (jj_3R_MySQLGroupConcat_4692_5_599()) return true;
    return false;
  }

  private boolean jj_3_169()
 {
    if (jj_3R_ExtractExpression_4339_5_229()) return true;
    return false;
  }

  private boolean jj_3_168()
 {
    if (jj_3R_NumericBind_3923_5_228()) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_3726_11_356()
 {
    if (jj_3R_UserVariable_3909_5_214()) return true;
    return false;
  }

  private boolean jj_3_167()
 {
    if (jj_3R_JdbcNamedParameter_3884_5_227()) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_3722_11_355()
 {
    if (jj_3R_SimpleJdbcParameter_2756_5_245()) return true;
    return false;
  }

  private boolean jj_3_166()
 {
    if (jj_3R_CaseWhenExpression_4409_5_226()) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_3718_9_354()
 {
    if (jj_scan_token(K_NULL)) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_3716_6_353()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(333)) {
    jj_scanpos = xsp;
    if (jj_scan_token(345)) {
    jj_scanpos = xsp;
    if (jj_scan_token(337)) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_PrimaryExpression_3715_7_352()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_PrimaryExpression_3715_7_597()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_3715_31_598()) return true;
    }
    return false;
  }

  private boolean jj_3R_PrimaryExpression_3715_7_597()
 {
    if (jj_scan_token(K_NOT)) return true;
    return false;
  }

  private boolean jj_3R_PrimaryExpression_3715_5_139()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_PrimaryExpression_3715_7_352()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_PrimaryExpression_3716_6_353()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_PrimaryExpression_3718_9_354()) {
    jj_scanpos = xsp;
    if (jj_3_166()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_3722_11_355()) {
    jj_scanpos = xsp;
    if (jj_3_167()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_3726_11_356()) {
    jj_scanpos = xsp;
    if (jj_3_168()) {
    jj_scanpos = xsp;
    if (jj_3_169()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_3732_11_357()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_3734_11_358()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_3736_11_359()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_3738_11_360()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_3740_11_361()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_3742_11_362()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_3746_11_363()) {
    jj_scanpos = xsp;
    if (jj_3_175()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_3752_11_364()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_3754_11_365()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_3756_11_366()) {
    jj_scanpos = xsp;
    if (jj_3_176()) {
    jj_scanpos = xsp;
    if (jj_3_177()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_3765_11_367()) {
    jj_scanpos = xsp;
    if (jj_3_178()) {
    jj_scanpos = xsp;
    if (jj_3_179()) {
    jj_scanpos = xsp;
    if (jj_3_180()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_3773_11_368()) {
    jj_scanpos = xsp;
    if (jj_3_181()) {
    jj_scanpos = xsp;
    if (jj_3_182()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_3779_11_369()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_3781_11_370()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_3783_11_371()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_3785_11_372()) {
    jj_scanpos = xsp;
    if (jj_3R_PrimaryExpression_3787_11_373()) {
    jj_scanpos = xsp;
    if (jj_3_184()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    xsp = jj_scanpos;
    if (jj_3R_PrimaryExpression_3816_9_809()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_185()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_PrimaryExpression_3823_7_810()) jj_scanpos = xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_PrimaryExpression_3825_7_811()) { jj_scanpos = xsp; break; }
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_186()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_SingleStatement_636_9_306()
 {
    if (jj_3R_AlterSystemStatement_5889_5_575()) return true;
    return false;
  }

  private boolean jj_3R_SingleStatement_634_9_305()
 {
    if (jj_3R_PurgeStatement_905_5_574()) return true;
    return false;
  }

  private boolean jj_3R_SingleStatement_632_9_304()
 {
    if (jj_3R_Grant_6075_9_573()) return true;
    return false;
  }

  private boolean jj_3R_SingleStatement_630_9_303()
 {
    if (jj_3R_Declare_769_5_572()) return true;
    return false;
  }

  private boolean jj_3R_SingleStatement_628_9_302()
 {
    if (jj_3R_Explain_941_5_571()) return true;
    return false;
  }

  private boolean jj_3R_SingleStatement_626_9_301()
 {
    if (jj_3R_Describe_931_5_570()) return true;
    return false;
  }

  private boolean jj_3_163()
 {
    if (jj_3R_SimpleExpression_3535_5_132()) return true;
    return false;
  }

  private boolean jj_3R_SingleStatement_624_9_300()
 {
    if (jj_3R_Comment_6046_5_569()) return true;
    return false;
  }

  private boolean jj_3R_ArrayExpression_3692_11_880()
 {
    if (jj_scan_token(330)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_163()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_SingleStatement_622_9_299()
 {
    if (jj_3R_Commit_6031_3_568()) return true;
    return false;
  }

  private boolean jj_3_15()
 {
    if (jj_3R_ShowTables_1073_3_128()) return true;
    return false;
  }

  private boolean jj_3R_SingleStatement_620_9_298()
 {
    if (jj_3R_RollbackStatement_6010_5_567()) return true;
    return false;
  }

  private boolean jj_3_162()
 {
    if (jj_3R_SimpleExpression_3535_5_132()) return true;
    return false;
  }

  private boolean jj_3R_SingleStatement_618_9_297()
 {
    if (jj_3R_SavepointStatement_5995_3_566()) return true;
    return false;
  }

  private boolean jj_3_14()
 {
    if (jj_3R_ShowColumns_1057_5_127()) return true;
    return false;
  }

  private boolean jj_3R_SingleStatement_616_9_296()
 {
    if (jj_3R_Use_1047_5_565()) return true;
    return false;
  }

  private boolean jj_3R_ArrayExpression_3689_5_839()
 {
    if (jj_scan_token(357)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_162()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_ArrayExpression_3692_11_880()) jj_scanpos = xsp;
    if (jj_scan_token(358)) return true;
    return false;
  }

  private boolean jj_3R_SingleStatement_614_9_295()
 {
    if (jj_3R_Show_1100_5_564()) return true;
    return false;
  }

  private boolean jj_3R_SingleStatement_611_9_294()
 {
    if (jj_3R_ShowTables_1073_3_128()) return true;
    return false;
  }

  private boolean jj_3R_SingleStatement_608_9_293()
 {
    if (jj_3R_ShowColumns_1057_5_127()) return true;
    return false;
  }

  private boolean jj_3R_SingleStatement_606_9_292()
 {
    if (jj_3R_Reset_851_5_563()) return true;
    return false;
  }

  private boolean jj_3R_MultiplicativeExpression_3646_39_222()
 {
    if (jj_scan_token(355)) return true;
    return false;
  }

  private boolean jj_3R_SingleStatement_604_9_291()
 {
    if (jj_3R_RenameTableStatement_866_5_562()) return true;
    return false;
  }

  private boolean jj_3R_MultiplicativeExpression_3645_39_221()
 {
    if (jj_scan_token(K_DIV)) return true;
    return false;
  }

  private boolean jj_3_13()
 {
    if (jj_3R_AlterSequence_6254_3_126()) return true;
    return false;
  }

  private boolean jj_3R_MultiplicativeExpression_3644_39_220()
 {
    if (jj_scan_token(354)) return true;
    return false;
  }

  private boolean jj_3R_SingleStatement_602_9_290()
 {
    if (jj_3R_Set_813_5_561()) return true;
    return false;
  }

  private boolean jj_3R_SingleStatement_600_9_289()
 {
    if (jj_3R_Execute_4488_5_560()) return true;
    return false;
  }

  private boolean jj_3_12()
 {
    if (jj_3R_AlterView_5196_5_125()) return true;
    return false;
  }

  private boolean jj_3R_BitwiseXor_3670_9_780()
 {
    if (jj_scan_token(356)) return true;
    if (jj_3R_PrimaryExpression_3715_5_139()) return true;
    return false;
  }

  private boolean jj_3R_SingleStatement_598_9_288()
 {
    if (jj_3R_Truncate_5425_5_559()) return true;
    return false;
  }

  private boolean jj_3_11()
 {
    if (jj_3R_CreateView_5149_5_124()) return true;
    return false;
  }

  private boolean jj_3R_SingleStatement_596_9_287()
 {
    if (jj_3R_Drop_5391_5_558()) return true;
    return false;
  }

  private boolean jj_3_10()
 {
    if (jj_3R_CreateTable_4932_5_123()) return true;
    return false;
  }

  private boolean jj_3R_SingleStatement_593_9_286()
 {
    if (jj_3R_AlterSequence_6254_3_126()) return true;
    return false;
  }

  private boolean jj_3R_BitwiseXor_3668_5_223()
 {
    if (jj_3R_PrimaryExpression_3715_5_139()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_BitwiseXor_3670_9_780()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_9()
 {
    if (jj_3R_CreateSynonym_6298_3_122()) return true;
    return false;
  }

  private boolean jj_3R_SingleStatement_590_9_285()
 {
    if (jj_3R_AlterView_5196_5_125()) return true;
    return false;
  }

  private boolean jj_3_8()
 {
    if (jj_3R_CreateSequence_6239_3_121()) return true;
    return false;
  }

  private boolean jj_3R_SingleStatement_587_9_284()
 {
    if (jj_3R_CreateView_5149_5_124()) return true;
    return false;
  }

  private boolean jj_3R_MultiplicativeExpression_3643_23_219()
 {
    if (jj_scan_token(328)) return true;
    return false;
  }

  private boolean jj_3_7()
 {
    if (jj_3R_CreateSchema_4858_5_120()) return true;
    return false;
  }

  private boolean jj_3R_SingleStatement_584_9_283()
 {
    if (jj_3R_CreateTable_4932_5_123()) return true;
    return false;
  }

  private boolean jj_3_6()
 {
    if (jj_3R_CreateIndex_4799_5_119()) return true;
    return false;
  }

  private boolean jj_3R_SingleStatement_581_9_282()
 {
    if (jj_3R_CreateSynonym_6298_3_122()) return true;
    return false;
  }

  private boolean jj_3_5()
 {
    if (jj_3R_CreateFunctionStatement_6270_3_118()) return true;
    return false;
  }

  private boolean jj_3R_SingleStatement_578_9_281()
 {
    if (jj_3R_CreateSequence_6239_3_121()) return true;
    return false;
  }

  private boolean jj_3R_AdditiveExpression_3617_39_217()
 {
    if (jj_scan_token(345)) return true;
    return false;
  }

  private boolean jj_3R_SingleStatement_575_9_280()
 {
    if (jj_3R_CreateSchema_4858_5_120()) return true;
    return false;
  }

  private boolean jj_3R_SingleStatement_572_9_279()
 {
    if (jj_3R_CreateIndex_4799_5_119()) return true;
    return false;
  }

  private boolean jj_3_161()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_MultiplicativeExpression_3643_23_219()) {
    jj_scanpos = xsp;
    if (jj_3R_MultiplicativeExpression_3644_39_220()) {
    jj_scanpos = xsp;
    if (jj_3R_MultiplicativeExpression_3645_39_221()) {
    jj_scanpos = xsp;
    if (jj_3R_MultiplicativeExpression_3646_39_222()) return true;
    }
    }
    }
    if (jj_3R_BitwiseXor_3668_5_223()) return true;
    return false;
  }

  private boolean jj_3R_SingleStatement_569_9_278()
 {
    if (jj_3R_CreateFunctionStatement_6270_3_118()) return true;
    return false;
  }

  private boolean jj_3_4()
 {
    if (jj_3R_AlterSession_5823_5_117()) return true;
    return false;
  }

  private boolean jj_3R_SingleStatement_554_21_556()
 {
    if (jj_3R_Merge_1543_5_684()) return true;
    return false;
  }

  private boolean jj_3R_SingleStatement_552_21_555()
 {
    if (jj_3R_Delete_1504_5_683()) return true;
    return false;
  }

  private boolean jj_3_3()
 {
    if (jj_3R_AlterTable_5798_5_116()) return true;
    return false;
  }

  private boolean jj_3R_MultiplicativeExpression_3638_5_218()
 {
    if (jj_3R_BitwiseXor_3668_5_223()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_161()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_SingleStatement_550_21_554()
 {
    if (jj_3R_Update_1141_4_682()) return true;
    return false;
  }

  private boolean jj_3_2()
 {
    if (jj_3R_Replace_1229_5_115()) return true;
    return false;
  }

  private boolean jj_3R_SingleStatement_548_21_553()
 {
    if (jj_3R_Insert_1311_5_681()) return true;
    return false;
  }

  private boolean jj_3R_SingleStatement_558_9_277()
 {
    if (jj_3R_Upsert_1428_5_557()) return true;
    return false;
  }

  private boolean jj_3R_SingleStatement_546_21_552()
 {
    if (jj_3R_Select_1787_5_375()) return true;
    return false;
  }

  private boolean jj_3R_SingleStatement_544_19_551()
 {
    if (jj_3R_WithList_2024_5_596()) return true;
    return false;
  }

  private boolean jj_3R_SingleStatement_543_13_276()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_SingleStatement_544_19_551()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_SingleStatement_546_21_552()) {
    jj_scanpos = xsp;
    if (jj_3R_SingleStatement_548_21_553()) {
    jj_scanpos = xsp;
    if (jj_3R_SingleStatement_550_21_554()) {
    jj_scanpos = xsp;
    if (jj_3R_SingleStatement_552_21_555()) {
    jj_scanpos = xsp;
    if (jj_3R_SingleStatement_554_21_556()) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_AdditiveExpression_3616_10_216()
 {
    if (jj_scan_token(333)) return true;
    return false;
  }

  private boolean jj_3_160()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_AdditiveExpression_3616_10_216()) {
    jj_scanpos = xsp;
    if (jj_3R_AdditiveExpression_3617_39_217()) return true;
    }
    if (jj_3R_MultiplicativeExpression_3638_5_218()) return true;
    return false;
  }

  private boolean jj_3R_AdditiveExpression_3614_5_472()
 {
    if (jj_3R_MultiplicativeExpression_3638_5_218()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_160()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_SingleStatement_541_5_114()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_SingleStatement_543_13_276()) {
    jj_scanpos = xsp;
    if (jj_3R_SingleStatement_558_9_277()) {
    jj_scanpos = xsp;
    if (jj_3_2()) {
    jj_scanpos = xsp;
    if (jj_3_3()) {
    jj_scanpos = xsp;
    if (jj_3_4()) {
    jj_scanpos = xsp;
    if (jj_3R_SingleStatement_569_9_278()) {
    jj_scanpos = xsp;
    if (jj_3R_SingleStatement_572_9_279()) {
    jj_scanpos = xsp;
    if (jj_3R_SingleStatement_575_9_280()) {
    jj_scanpos = xsp;
    if (jj_3R_SingleStatement_578_9_281()) {
    jj_scanpos = xsp;
    if (jj_3R_SingleStatement_581_9_282()) {
    jj_scanpos = xsp;
    if (jj_3R_SingleStatement_584_9_283()) {
    jj_scanpos = xsp;
    if (jj_3R_SingleStatement_587_9_284()) {
    jj_scanpos = xsp;
    if (jj_3R_SingleStatement_590_9_285()) {
    jj_scanpos = xsp;
    if (jj_3R_SingleStatement_593_9_286()) {
    jj_scanpos = xsp;
    if (jj_3R_SingleStatement_596_9_287()) {
    jj_scanpos = xsp;
    if (jj_3R_SingleStatement_598_9_288()) {
    jj_scanpos = xsp;
    if (jj_3R_SingleStatement_600_9_289()) {
    jj_scanpos = xsp;
    if (jj_3R_SingleStatement_602_9_290()) {
    jj_scanpos = xsp;
    if (jj_3R_SingleStatement_604_9_291()) {
    jj_scanpos = xsp;
    if (jj_3R_SingleStatement_606_9_292()) {
    jj_scanpos = xsp;
    if (jj_3R_SingleStatement_608_9_293()) {
    jj_scanpos = xsp;
    if (jj_3R_SingleStatement_611_9_294()) {
    jj_scanpos = xsp;
    if (jj_3R_SingleStatement_614_9_295()) {
    jj_scanpos = xsp;
    if (jj_3R_SingleStatement_616_9_296()) {
    jj_scanpos = xsp;
    if (jj_3R_SingleStatement_618_9_297()) {
    jj_scanpos = xsp;
    if (jj_3R_SingleStatement_620_9_298()) {
    jj_scanpos = xsp;
    if (jj_3R_SingleStatement_622_9_299()) {
    jj_scanpos = xsp;
    if (jj_3R_SingleStatement_624_9_300()) {
    jj_scanpos = xsp;
    if (jj_3R_SingleStatement_626_9_301()) {
    jj_scanpos = xsp;
    if (jj_3R_SingleStatement_628_9_302()) {
    jj_scanpos = xsp;
    if (jj_3R_SingleStatement_630_9_303()) {
    jj_scanpos = xsp;
    if (jj_3R_SingleStatement_632_9_304()) {
    jj_scanpos = xsp;
    if (jj_3R_SingleStatement_634_9_305()) {
    jj_scanpos = xsp;
    if (jj_3R_SingleStatement_636_9_306()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_BitwiseAndOr_3591_25_644()
 {
    if (jj_scan_token(353)) return true;
    return false;
  }

  private boolean jj_3R_BitwiseAndOr_3589_25_643()
 {
    if (jj_scan_token(352)) return true;
    return false;
  }

  private boolean jj_3R_BitwiseAndOr_3587_13_642()
 {
    if (jj_scan_token(351)) return true;
    return false;
  }

  private boolean jj_3R_BitwiseAndOr_3585_13_641()
 {
    if (jj_scan_token(350)) return true;
    return false;
  }

  private boolean jj_3_1()
 {
    if (jj_scan_token(K_ELSE)) return true;
    if (jj_3R_SingleStatement_541_5_114()) return true;
    return false;
  }

  private boolean jj_3R_BitwiseAndOr_3584_9_473()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_BitwiseAndOr_3585_13_641()) {
    jj_scanpos = xsp;
    if (jj_3R_BitwiseAndOr_3587_13_642()) {
    jj_scanpos = xsp;
    if (jj_3R_BitwiseAndOr_3589_25_643()) {
    jj_scanpos = xsp;
    if (jj_3R_BitwiseAndOr_3591_25_644()) return true;
    }
    }
    }
    if (jj_3R_AdditiveExpression_3614_5_472()) return true;
    return false;
  }

  private boolean jj_3R_BitwiseAndOr_3582_5_215()
 {
    if (jj_3R_AdditiveExpression_3614_5_472()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_BitwiseAndOr_3584_9_473()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_AnyComparisonExpression_3508_79_466()
 {
    if (jj_scan_token(K_ALL)) return true;
    return false;
  }

  private boolean jj_3_159()
 {
    if (jj_scan_token(OP_CONCAT)) return true;
    if (jj_3R_BitwiseAndOr_3582_5_215()) return true;
    return false;
  }

  private boolean jj_3R_ConcatExpression_3559_5_349()
 {
    if (jj_3R_BitwiseAndOr_3582_5_215()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_159()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_158()
 {
    if (jj_3R_UserVariable_3909_5_214()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(327)) {
    jj_scanpos = xsp;
    if (jj_scan_token(349)) return true;
    }
    return false;
  }

  private boolean jj_3R_AnyComparisonExpression_3508_40_465()
 {
    if (jj_scan_token(K_SOME)) return true;
    return false;
  }

  private boolean jj_3R_SimpleExpression_3535_7_348()
 {
    if (jj_3R_UserVariable_3909_5_214()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(327)) {
    jj_scanpos = xsp;
    if (jj_scan_token(349)) return true;
    }
    return false;
  }

  private boolean jj_3R_SimpleExpression_3535_5_132()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_SimpleExpression_3535_7_348()) jj_scanpos = xsp;
    if (jj_3R_ConcatExpression_3559_5_349()) return true;
    return false;
  }

  private boolean jj_3_157()
 {
    if (jj_scan_token(K_VALUES)) return true;
    if (jj_3R_SimpleExpressionList_3358_5_169()) return true;
    return false;
  }

  private boolean jj_3R_SimpleExpressionListAtLeastTwoItems_3476_57_640()
 {
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_3R_SimpleExpression_3535_5_132()) return true;
    return false;
  }

  private boolean jj_3R_AnyComparisonExpression_3519_11_468()
 {
    if (jj_3R_SubSelect_4738_5_134()) return true;
    return false;
  }

  private boolean jj_3R_AnyComparisonExpression_3513_9_467()
 {
    if (jj_scan_token(K_VALUES)) return true;
    if (jj_3R_SimpleExpressionList_3358_5_169()) return true;
    return false;
  }

  private boolean jj_3R_AnyComparisonExpression_3508_3_464()
 {
    if (jj_scan_token(K_ANY)) return true;
    return false;
  }

  private boolean jj_3R_AnyComparisonExpression_3508_2_212()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_AnyComparisonExpression_3508_3_464()) {
    jj_scanpos = xsp;
    if (jj_3R_AnyComparisonExpression_3508_40_465()) {
    jj_scanpos = xsp;
    if (jj_3R_AnyComparisonExpression_3508_79_466()) return true;
    }
    }
    if (jj_scan_token(325)) return true;
    xsp = jj_scanpos;
    if (jj_3R_AnyComparisonExpression_3513_9_467()) {
    jj_scanpos = xsp;
    if (jj_3R_AnyComparisonExpression_3519_11_468()) return true;
    }
    if (jj_scan_token(326)) return true;
    return false;
  }

  private boolean jj_3_155()
 {
    if (jj_3R_ValueListExpression_4710_5_213()) return true;
    return false;
  }

  private boolean jj_3R_ComparisonItem_3492_7_448()
 {
    if (jj_3R_RowConstructor_4449_5_248()) return true;
    return false;
  }

  private boolean jj_3_156()
 {
    if (jj_3R_SimpleExpression_3535_5_132()) return true;
    return false;
  }

  private boolean jj_3R_ComparisonItem_3490_7_447()
 {
    if (jj_3R_ValueListExpression_4710_5_213()) return true;
    return false;
  }

  private boolean jj_3_154()
 {
    if (jj_3R_AnyComparisonExpression_3508_2_212()) return true;
    return false;
  }

  private boolean jj_3R_ComparisonItem_3488_3_199()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_154()) {
    jj_scanpos = xsp;
    if (jj_3R_ComparisonItem_3490_7_447()) {
    jj_scanpos = xsp;
    if (jj_3_156()) {
    jj_scanpos = xsp;
    if (jj_3R_ComparisonItem_3492_7_448()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_NamedExpressionListExprFirst_3455_33_668()
 {
    if (jj_scan_token(K_FOR)) return true;
    if (jj_3R_SimpleExpression_3535_5_132()) return true;
    return false;
  }

  private boolean jj_3R_SimpleExpressionListAtLeastTwoItems_3476_5_469()
 {
    if (jj_3R_SimpleExpression_3535_5_132()) return true;
    Token xsp;
    if (jj_3R_SimpleExpressionListAtLeastTwoItems_3476_57_640()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_SimpleExpressionListAtLeastTwoItems_3476_57_640()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_NamedExpressionListExprFirst_3452_25_501()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(101)) {
    jj_scanpos = xsp;
    if (jj_scan_token(105)) return true;
    }
    if (jj_3R_SimpleExpression_3535_5_132()) return true;
    xsp = jj_scanpos;
    if (jj_3R_NamedExpressionListExprFirst_3455_33_668()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_NamedExpressionListExprFirst_3442_9_253()
 {
    if (jj_3R_SimpleExpression_3535_5_132()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(105)) {
    jj_scanpos = xsp;
    if (jj_scan_token(123)) {
    jj_scanpos = xsp;
    if (jj_scan_token(198)) return true;
    }
    }
    if (jj_3R_SimpleExpression_3535_5_132()) return true;
    xsp = jj_scanpos;
    if (jj_3R_NamedExpressionListExprFirst_3452_25_501()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_NamedExpressionList1_3406_5_252()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(27)) {
    jj_scanpos = xsp;
    if (jj_scan_token(147)) {
    jj_scanpos = xsp;
    if (jj_scan_token(261)) return true;
    }
    }
    if (jj_3R_SimpleExpression_3535_5_132()) return true;
    xsp = jj_scanpos;
    if (jj_scan_token(105)) {
    jj_scanpos = xsp;
    if (jj_scan_token(123)) {
    jj_scanpos = xsp;
    if (jj_scan_token(198)) return true;
    }
    }
    if (jj_3R_SimpleExpression_3535_5_132()) return true;
    return false;
  }

  private boolean jj_3R_IsBooleanExpression_3315_94_454()
 {
    if (jj_scan_token(K_FALSE)) return true;
    return false;
  }

  private boolean jj_3_153()
 {
    if (jj_3R_Expression_2983_5_136()) return true;
    return false;
  }

  private boolean jj_3_152()
 {
    if (jj_3R_OracleNamedFunctionParameter_3895_5_211()) return true;
    return false;
  }

  private boolean jj_3_151()
 {
    if (jj_scan_token(K_COMMA)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_152()) {
    jj_scanpos = xsp;
    if (jj_3_153()) return true;
    }
    return false;
  }

  private boolean jj_3_150()
 {
    if (jj_3R_Expression_2983_5_136()) return true;
    return false;
  }

  private boolean jj_3_149()
 {
    if (jj_3R_OracleNamedFunctionParameter_3895_5_211()) return true;
    return false;
  }

  private boolean jj_3R_ComplexExpressionList_3373_5_135()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_149()) {
    jj_scanpos = xsp;
    if (jj_3_150()) return true;
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_151()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_IsBooleanExpression_3315_55_453()
 {
    if (jj_scan_token(K_TRUE)) return true;
    return false;
  }

  private boolean jj_3_148()
 {
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_3R_SimpleExpression_3535_5_132()) return true;
    return false;
  }

  private boolean jj_3R_SimpleExpressionList_3358_5_169()
 {
    if (jj_3R_SimpleExpression_3535_5_132()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_148()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_IsNullExpression_3301_62_637()
 {
    if (jj_scan_token(K_NOT)) return true;
    return false;
  }

  private boolean jj_3R_IsNullExpression_3301_54_451()
 {
    if (jj_scan_token(K_IS)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_IsNullExpression_3301_62_637()) jj_scanpos = xsp;
    if (jj_scan_token(K_NULL)) return true;
    return false;
  }

  private boolean jj_3R_ExistsExpression_3330_5_636()
 {
    if (jj_scan_token(K_EXISTS)) return true;
    if (jj_3R_SimpleExpression_3535_5_132()) return true;
    return false;
  }

  private boolean jj_3R_IsBooleanExpression_3315_19_452()
 {
    if (jj_scan_token(K_NOT)) return true;
    return false;
  }

  private boolean jj_3R_IsBooleanExpression_3314_9_202()
 {
    if (jj_scan_token(K_IS)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_IsBooleanExpression_3315_19_452()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_IsBooleanExpression_3315_55_453()) {
    jj_scanpos = xsp;
    if (jj_3R_IsBooleanExpression_3315_94_454()) return true;
    }
    return false;
  }

  private boolean jj_3R_IsNullExpression_3301_10_450()
 {
    if (jj_scan_token(K_ISNULL)) return true;
    return false;
  }

  private boolean jj_3R_IsNullExpression_3301_9_201()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_IsNullExpression_3301_10_450()) {
    jj_scanpos = xsp;
    if (jj_3R_IsNullExpression_3301_54_451()) return true;
    }
    return false;
  }

  private boolean jj_3R_LikeExpression_3252_54_456()
 {
    if (jj_scan_token(K_ILIKE)) return true;
    return false;
  }

  private boolean jj_3R_IsDistinctExpression_3286_13_457()
 {
    if (jj_scan_token(K_NOT)) return true;
    return false;
  }

  private boolean jj_3R_IsDistinctExpression_3286_5_204()
 {
    if (jj_scan_token(K_IS)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_IsDistinctExpression_3286_13_457()) jj_scanpos = xsp;
    if (jj_scan_token(K_DISTINCT)) return true;
    if (jj_scan_token(K_FROM)) return true;
    if (jj_3R_SimpleExpression_3535_5_132()) return true;
    return false;
  }

  private boolean jj_3R_SimilarToExpression_3271_6_859()
 {
    if (jj_scan_token(K_ESCAPE)) return true;
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_SimilarToExpression_3268_6_638()
 {
    if (jj_scan_token(K_NOT)) return true;
    return false;
  }

  private boolean jj_3R_SimilarToExpression_3268_5_458()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_SimilarToExpression_3268_6_638()) jj_scanpos = xsp;
    if (jj_scan_token(K_SIMILAR)) return true;
    if (jj_scan_token(K_TO)) return true;
    if (jj_3R_SimpleExpression_3535_5_132()) return true;
    xsp = jj_scanpos;
    if (jj_3R_SimilarToExpression_3271_6_859()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_LikeExpression_3253_6_858()
 {
    if (jj_scan_token(K_ESCAPE)) return true;
    if (jj_3R_Expression_2983_5_136()) return true;
    return false;
  }

  private boolean jj_3R_LikeExpression_3252_6_455()
 {
    if (jj_scan_token(K_NOT)) return true;
    return false;
  }

  private boolean jj_3R_LikeExpression_3252_5_203()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_LikeExpression_3252_6_455()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(149)) {
    jj_scanpos = xsp;
    if (jj_3R_LikeExpression_3252_54_456()) return true;
    }
    if (jj_3R_SimpleExpression_3535_5_132()) return true;
    xsp = jj_scanpos;
    if (jj_3R_LikeExpression_3253_6_858()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_Synonym_6317_5_324()
 {
    if (jj_3R_RelObjectNameList_1613_5_325()) return true;
    return false;
  }

  private boolean jj_3R_Between_3234_10_449()
 {
    if (jj_scan_token(K_NOT)) return true;
    return false;
  }

  private boolean jj_3R_Between_3234_9_200()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_Between_3234_10_449()) jj_scanpos = xsp;
    if (jj_scan_token(K_BETWEEN)) return true;
    if (jj_3R_SimpleExpression_3535_5_132()) return true;
    if (jj_scan_token(K_AND)) return true;
    if (jj_3R_SimpleExpression_3535_5_132()) return true;
    return false;
  }

  private boolean jj_3R_CreateSynonym_6300_4_323()
 {
    if (jj_scan_token(K_PUBLIC)) return true;
    return false;
  }

  private boolean jj_3R_CreateSynonym_6299_4_322()
 {
    if (jj_scan_token(K_OR)) return true;
    if (jj_scan_token(K_REPLACE)) return true;
    return false;
  }

  private boolean jj_3R_CreateSynonym_6298_3_122()
 {
    if (jj_scan_token(K_CREATE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_CreateSynonym_6299_4_322()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_CreateSynonym_6300_4_323()) jj_scanpos = xsp;
    if (jj_scan_token(K_SYNONYM)) return true;
    if (jj_3R_Synonym_6317_5_324()) return true;
    if (jj_scan_token(K_FOR)) return true;
    if (jj_3R_RelObjectNameList_1613_5_325()) return true;
    return false;
  }

  private boolean jj_3_147()
 {
    if (jj_scan_token(326)) return true;
    if (jj_scan_token(K_COMMA)) return true;
    if (jj_scan_token(325)) return true;
    return false;
  }

  private boolean jj_3R_CreateFunctionStatement_6270_15_309()
 {
    if (jj_scan_token(K_OR)) return true;
    if (jj_scan_token(K_REPLACE)) return true;
    return false;
  }

  private boolean jj_3_144()
 {
    if (jj_scan_token(325)) return true;
    if (jj_3R_ComplexExpressionList_3373_5_135()) return true;
    if (jj_scan_token(326)) return true;
    return false;
  }

  private boolean jj_3R_CreateFunctionStatement_6274_4_311()
 {
    if (jj_scan_token(K_PROCEDURE)) return true;
    return false;
  }

  private boolean jj_3R_CreateFunctionStatement_6272_4_310()
 {
    if (jj_scan_token(K_FUNCTION)) return true;
    return false;
  }

  private boolean jj_3R_CreateFunctionStatement_6270_3_118()
 {
    if (jj_scan_token(K_CREATE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_CreateFunctionStatement_6270_15_309()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_CreateFunctionStatement_6272_4_310()) {
    jj_scanpos = xsp;
    if (jj_3R_CreateFunctionStatement_6274_4_311()) return true;
    }
    if (true) { jj_la = 0; jj_scanpos = jj_lastpos; return false;}
    return false;
  }

  private boolean jj_3_146()
 {
    if (jj_3R_SimpleExpression_3535_5_132()) return true;
    return false;
  }

  private boolean jj_3_145()
 {
    if (jj_scan_token(325)) return true;
    if (jj_3R_SubSelect_4738_5_134()) return true;
    if (jj_scan_token(326)) return true;
    return false;
  }

  private boolean jj_3R_InExpression_3188_9_461()
 {
    if (jj_scan_token(325)) return true;
    if (jj_3R_ComplexExpressionList_3373_5_135()) return true;
    if (jj_scan_token(326)) return true;
    return false;
  }

  private boolean jj_3_143()
 {
    if (jj_3R_Function_4573_5_210()) return true;
    return false;
  }

  private boolean jj_3_142()
 {
    if (jj_scan_token(S_CHAR_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_InExpression_3182_11_459()
 {
    if (jj_scan_token(325)) return true;
    if (jj_scan_token(333)) return true;
    if (jj_scan_token(326)) return true;
    return false;
  }

  private boolean jj_3R_InExpression_3181_9_209()
 {
    if (jj_3R_SimpleExpression_3535_5_132()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_InExpression_3182_11_459()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_InExpression_3184_6_460()) jj_scanpos = xsp;
    if (jj_scan_token(K_IN)) return true;
    xsp = jj_scanpos;
    if (jj_3_142()) {
    jj_scanpos = xsp;
    if (jj_3_143()) {
    jj_scanpos = xsp;
    if (jj_3R_InExpression_3188_9_461()) {
    jj_scanpos = xsp;
    if (jj_3_145()) {
    jj_scanpos = xsp;
    if (jj_3_146()) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_InExpression_3184_6_460()
 {
    if (jj_scan_token(K_NOT)) return true;
    return false;
  }

  private boolean jj_3R_AlterSequence_6254_3_126()
 {
    if (jj_scan_token(K_ALTER)) return true;
    if (jj_scan_token(K_SEQUENCE)) return true;
    if (jj_3R_Sequence_6130_5_320()) return true;
    if (jj_3R_SequenceParameters_6145_1_321()) return true;
    return false;
  }

  private boolean jj_3_138()
 {
    if (jj_3R_IsDistinctExpression_3286_5_204()) return true;
    return false;
  }

  private boolean jj_3_134()
 {
    if (jj_3R_Between_3234_9_200()) return true;
    return false;
  }

  private boolean jj_3_136()
 {
    if (jj_3R_IsBooleanExpression_3314_9_202()) return true;
    return false;
  }

  private boolean jj_3_135()
 {
    if (jj_3R_IsNullExpression_3301_9_201()) return true;
    return false;
  }

  private boolean jj_3R_SQLCondition_3163_12_208()
 {
    if (jj_3R_SimilarToExpression_3268_5_458()) return true;
    return false;
  }

  private boolean jj_3R_SQLCondition_3162_12_207()
 {
    if (jj_3R_IsDistinctExpression_3286_5_204()) return true;
    return false;
  }

  private boolean jj_3_140()
 {
    if (jj_3R_InExpression_3181_9_209()) return true;
    return false;
  }

  private boolean jj_3_137()
 {
    if (jj_3R_LikeExpression_3252_5_203()) return true;
    return false;
  }

  private boolean jj_3R_SQLCondition_3160_12_206()
 {
    if (jj_3R_IsBooleanExpression_3314_9_202()) return true;
    return false;
  }

  private boolean jj_3R_SQLCondition_3159_12_205()
 {
    if (jj_3R_IsNullExpression_3301_9_201()) return true;
    return false;
  }

  private boolean jj_3R_CreateSequence_6239_3_121()
 {
    if (jj_scan_token(K_CREATE)) return true;
    if (jj_scan_token(K_SEQUENCE)) return true;
    if (jj_3R_Sequence_6130_5_320()) return true;
    if (jj_3R_SequenceParameters_6145_1_321()) return true;
    return false;
  }

  private boolean jj_3_139()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_134()) {
    jj_scanpos = xsp;
    if (jj_3R_SQLCondition_3159_12_205()) {
    jj_scanpos = xsp;
    if (jj_3R_SQLCondition_3160_12_206()) {
    jj_scanpos = xsp;
    if (jj_3_137()) {
    jj_scanpos = xsp;
    if (jj_3R_SQLCondition_3162_12_207()) {
    jj_scanpos = xsp;
    if (jj_3R_SQLCondition_3163_12_208()) return true;
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3_141()
 {
    if (jj_3R_SimpleExpression_3535_5_132()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_139()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_SQLCondition_3156_7_446()
 {
    if (jj_3R_InExpression_3181_9_209()) return true;
    return false;
  }

  private boolean jj_3R_SQLCondition_3155_5_445()
 {
    if (jj_3R_ExistsExpression_3330_5_636()) return true;
    return false;
  }

  private boolean jj_3R_SQLCondition_3154_5_198()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_SQLCondition_3155_5_445()) {
    jj_scanpos = xsp;
    if (jj_3R_SQLCondition_3156_7_446()) {
    jj_scanpos = xsp;
    if (jj_3_141()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_SequenceParameters_6224_6_762()
 {
    if (jj_scan_token(K_GLOBAL)) return true;
    return false;
  }

  private boolean jj_3R_SequenceParameters_6223_5_761()
 {
    if (jj_scan_token(K_SESSION)) return true;
    return false;
  }

  private boolean jj_3R_SequenceParameters_6223_4_699()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_SequenceParameters_6223_5_761()) {
    jj_scanpos = xsp;
    if (jj_3R_SequenceParameters_6224_6_762()) return true;
    }
    return false;
  }

  private boolean jj_3R_SequenceParameters_6220_6_760()
 {
    if (jj_scan_token(K_NOKEEP)) return true;
    return false;
  }

  private boolean jj_3R_SequenceParameters_6219_5_759()
 {
    if (jj_scan_token(K_KEEP)) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_3107_45_634()
 {
    if (jj_scan_token(K_BINARY)) return true;
    return false;
  }

  private boolean jj_3R_SequenceParameters_6219_4_698()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_SequenceParameters_6219_5_759()) {
    jj_scanpos = xsp;
    if (jj_3R_SequenceParameters_6220_6_760()) return true;
    }
    return false;
  }

  private boolean jj_3R_SequenceParameters_6216_6_758()
 {
    if (jj_scan_token(K_NOORDER)) return true;
    return false;
  }

  private boolean jj_3R_SequenceParameters_6215_5_757()
 {
    if (jj_scan_token(K_ORDER)) return true;
    return false;
  }

  private boolean jj_3R_SequenceParameters_6215_4_697()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_SequenceParameters_6215_5_757()) {
    jj_scanpos = xsp;
    if (jj_3R_SequenceParameters_6216_6_758()) return true;
    }
    return false;
  }

  private boolean jj_3R_SequenceParameters_6207_5_756()
 {
    if (jj_scan_token(K_CACHE)) return true;
    if (jj_scan_token(S_LONG)) return true;
    return false;
  }

  private boolean jj_3R_SequenceParameters_6202_5_755()
 {
    if (jj_scan_token(K_NOCACHE)) return true;
    return false;
  }

  private boolean jj_3_133()
 {
    if (jj_scan_token(325)) return true;
    if (jj_scan_token(333)) return true;
    if (jj_scan_token(326)) return true;
    return false;
  }

  private boolean jj_3_132()
 {
    if (jj_3R_ComparisonItem_3488_3_199()) return true;
    return false;
  }

  private boolean jj_3R_SequenceParameters_6202_4_696()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_SequenceParameters_6202_5_755()) {
    jj_scanpos = xsp;
    if (jj_3R_SequenceParameters_6207_5_756()) return true;
    }
    return false;
  }

  private boolean jj_3R_SequenceParameters_6199_6_754()
 {
    if (jj_scan_token(K_CYCLE)) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_3122_11_444()
 {
    if (jj_scan_token(348)) return true;
    return false;
  }

  private boolean jj_3_131()
 {
    if (jj_scan_token(K_PRIOR)) return true;
    if (jj_3R_ComparisonItem_3488_3_199()) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_3121_11_443()
 {
    if (jj_scan_token(347)) return true;
    return false;
  }

  private boolean jj_3R_SequenceParameters_6198_5_753()
 {
    if (jj_scan_token(K_NOCYCLE)) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_3120_11_442()
 {
    if (jj_scan_token(346)) return true;
    return false;
  }

  private boolean jj_3R_SequenceParameters_6198_4_695()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_SequenceParameters_6198_5_753()) {
    jj_scanpos = xsp;
    if (jj_3R_SequenceParameters_6199_6_754()) return true;
    }
    return false;
  }

  private boolean jj_3R_RegularCondition_3119_11_441()
 {
    if (jj_scan_token(345)) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_3118_11_440()
 {
    if (jj_scan_token(OP_CONCAT)) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_3117_11_439()
 {
    if (jj_scan_token(344)) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_3116_11_438()
 {
    if (jj_scan_token(343)) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_3108_19_635()
 {
    if (jj_scan_token(K_BINARY)) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_3115_11_437()
 {
    if (jj_scan_token(331)) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_3114_11_436()
 {
    if (jj_scan_token(342)) return true;
    return false;
  }

  private boolean jj_3R_SequenceParameters_6190_6_752()
 {
    if (jj_scan_token(K_MINVALUE)) return true;
    if (jj_scan_token(S_LONG)) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_3113_11_435()
 {
    if (jj_scan_token(341)) return true;
    return false;
  }

  private boolean jj_3R_SequenceParameters_6185_5_751()
 {
    if (jj_scan_token(K_NOMINVALUE)) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_3111_7_434()
 {
    if (jj_scan_token(340)) return true;
    return false;
  }

  private boolean jj_3R_SequenceParameters_6185_4_694()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_SequenceParameters_6185_5_751()) {
    jj_scanpos = xsp;
    if (jj_3R_SequenceParameters_6190_6_752()) return true;
    }
    return false;
  }

  private boolean jj_3R_Condition_3072_45_196()
 {
    if (jj_scan_token(332)) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_3110_7_433()
 {
    if (jj_scan_token(339)) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_3109_7_432()
 {
    if (jj_scan_token(338)) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_3108_7_431()
 {
    if (jj_scan_token(K_RLIKE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_RegularCondition_3108_19_635()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_RegularCondition_3107_8_633()
 {
    if (jj_scan_token(K_NOT)) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_3107_7_430()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_RegularCondition_3107_8_633()) jj_scanpos = xsp;
    if (jj_scan_token(K_REGEXP)) return true;
    xsp = jj_scanpos;
    if (jj_3R_RegularCondition_3107_45_634()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_RegularCondition_3106_7_429()
 {
    if (jj_scan_token(337)) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_3105_7_428()
 {
    if (jj_scan_token(336)) return true;
    return false;
  }

  private boolean jj_3R_SequenceParameters_6177_6_750()
 {
    if (jj_scan_token(K_MAXVALUE)) return true;
    if (jj_scan_token(S_LONG)) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_3104_7_427()
 {
    if (jj_scan_token(OP_NOTEQUALSBANG)) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_3103_7_426()
 {
    if (jj_scan_token(OP_NOTEQUALSSTANDARD)) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_3102_7_425()
 {
    if (jj_scan_token(OP_MINORTHANEQUALS)) return true;
    return false;
  }

  private boolean jj_3R_SequenceParameters_6162_18_748()
 {
    if (jj_scan_token(K_WITH)) return true;
    if (jj_scan_token(S_LONG)) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_3101_7_424()
 {
    if (jj_scan_token(OP_GREATERTHANEQUALS)) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_3100_7_423()
 {
    if (jj_scan_token(327)) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_3099_7_422()
 {
    if (jj_scan_token(335)) return true;
    return false;
  }

  private boolean jj_3R_SequenceParameters_6172_5_749()
 {
    if (jj_scan_token(K_NOMAXVALUE)) return true;
    return false;
  }

  private boolean jj_3R_SequenceParameters_6172_4_693()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_SequenceParameters_6172_5_749()) {
    jj_scanpos = xsp;
    if (jj_3R_SequenceParameters_6177_6_750()) return true;
    }
    return false;
  }

  private boolean jj_3_130()
 {
    if (jj_scan_token(334)) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_3095_7_421()
 {
    if (jj_scan_token(325)) return true;
    if (jj_scan_token(333)) return true;
    if (jj_scan_token(326)) return true;
    return false;
  }

  private boolean jj_3_129()
 {
    if (jj_scan_token(K_PRIOR)) return true;
    return false;
  }

  private boolean jj_3R_RegularCondition_3092_5_197()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_129()) jj_scanpos = xsp;
    if (jj_3R_ComparisonItem_3488_3_199()) return true;
    xsp = jj_scanpos;
    if (jj_3R_RegularCondition_3095_7_421()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_130()) {
    jj_scanpos = xsp;
    if (jj_3R_RegularCondition_3099_7_422()) {
    jj_scanpos = xsp;
    if (jj_3R_RegularCondition_3100_7_423()) {
    jj_scanpos = xsp;
    if (jj_3R_RegularCondition_3101_7_424()) {
    jj_scanpos = xsp;
    if (jj_3R_RegularCondition_3102_7_425()) {
    jj_scanpos = xsp;
    if (jj_3R_RegularCondition_3103_7_426()) {
    jj_scanpos = xsp;
    if (jj_3R_RegularCondition_3104_7_427()) {
    jj_scanpos = xsp;
    if (jj_3R_RegularCondition_3105_7_428()) {
    jj_scanpos = xsp;
    if (jj_3R_RegularCondition_3106_7_429()) {
    jj_scanpos = xsp;
    if (jj_3R_RegularCondition_3107_7_430()) {
    jj_scanpos = xsp;
    if (jj_3R_RegularCondition_3108_7_431()) {
    jj_scanpos = xsp;
    if (jj_3R_RegularCondition_3109_7_432()) {
    jj_scanpos = xsp;
    if (jj_3R_RegularCondition_3110_7_433()) {
    jj_scanpos = xsp;
    if (jj_3R_RegularCondition_3111_7_434()) {
    jj_scanpos = xsp;
    if (jj_3R_RegularCondition_3113_11_435()) {
    jj_scanpos = xsp;
    if (jj_3R_RegularCondition_3114_11_436()) {
    jj_scanpos = xsp;
    if (jj_3R_RegularCondition_3115_11_437()) {
    jj_scanpos = xsp;
    if (jj_3R_RegularCondition_3116_11_438()) {
    jj_scanpos = xsp;
    if (jj_3R_RegularCondition_3117_11_439()) {
    jj_scanpos = xsp;
    if (jj_3R_RegularCondition_3118_11_440()) {
    jj_scanpos = xsp;
    if (jj_3R_RegularCondition_3119_11_441()) {
    jj_scanpos = xsp;
    if (jj_3R_RegularCondition_3120_11_442()) {
    jj_scanpos = xsp;
    if (jj_3R_RegularCondition_3121_11_443()) {
    jj_scanpos = xsp;
    if (jj_3R_RegularCondition_3122_11_444()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    xsp = jj_scanpos;
    if (jj_3_131()) {
    jj_scanpos = xsp;
    if (jj_3_132()) return true;
    }
    xsp = jj_scanpos;
    if (jj_3_133()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_SequenceParameters_6162_4_692()
 {
    if (jj_scan_token(K_RESTART)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_SequenceParameters_6162_18_748()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_Condition_3072_21_195()
 {
    if (jj_scan_token(K_NOT)) return true;
    return false;
  }

  private boolean jj_3_127()
 {
    if (jj_3R_RegularCondition_3092_5_197()) return true;
    return false;
  }

  private boolean jj_3R_AndExpression_3050_39_632()
 {
    if (jj_scan_token(332)) return true;
    return false;
  }

  private boolean jj_3R_SequenceParameters_6154_4_691()
 {
    if (jj_scan_token(K_START)) return true;
    if (jj_scan_token(K_WITH)) return true;
    if (jj_scan_token(S_LONG)) return true;
    return false;
  }

  private boolean jj_3_128()
 {
    if (jj_3R_SQLCondition_3154_5_198()) return true;
    return false;
  }

  private boolean jj_3R_Condition_3074_9_419()
 {
    if (jj_3R_RegularCondition_3092_5_197()) return true;
    return false;
  }

  private boolean jj_3_126()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_Condition_3072_21_195()) {
    jj_scanpos = xsp;
    if (jj_3R_Condition_3072_45_196()) return true;
    }
    return false;
  }

  private boolean jj_3R_SequenceParameters_6146_4_581()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_SequenceParameters_6146_4_690()) {
    jj_scanpos = xsp;
    if (jj_3R_SequenceParameters_6154_4_691()) {
    jj_scanpos = xsp;
    if (jj_3R_SequenceParameters_6162_4_692()) {
    jj_scanpos = xsp;
    if (jj_3R_SequenceParameters_6172_4_693()) {
    jj_scanpos = xsp;
    if (jj_3R_SequenceParameters_6185_4_694()) {
    jj_scanpos = xsp;
    if (jj_3R_SequenceParameters_6198_4_695()) {
    jj_scanpos = xsp;
    if (jj_3R_SequenceParameters_6202_4_696()) {
    jj_scanpos = xsp;
    if (jj_3R_SequenceParameters_6215_4_697()) {
    jj_scanpos = xsp;
    if (jj_3R_SequenceParameters_6219_4_698()) {
    jj_scanpos = xsp;
    if (jj_3R_SequenceParameters_6223_4_699()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_SequenceParameters_6146_4_690()
 {
    if (jj_scan_token(K_INCREMENT)) return true;
    if (jj_scan_token(K_BY)) return true;
    if (jj_scan_token(S_LONG)) return true;
    return false;
  }

  private boolean jj_3R_Condition_3072_5_191()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_126()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_Condition_3074_9_419()) {
    jj_scanpos = xsp;
    if (jj_3_128()) return true;
    }
    return false;
  }

  private boolean jj_3R_SequenceParameters_6145_1_321()
 {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_SequenceParameters_6146_4_581()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_AndExpression_3038_35_725()
 {
    if (jj_scan_token(332)) return true;
    return false;
  }

  /** Generated Token Manager. */
  public CCJSqlParserTokenManager token_source;
  SimpleCharStream jj_input_stream;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  /** Whether we are looking ahead. */
  private boolean jj_lookingAhead = false;
  private boolean jj_semLA;
  private int jj_gen;
  final private int[] jj_la1 = new int[576];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static private int[] jj_la1_2;
  static private int[] jj_la1_3;
  static private int[] jj_la1_4;
  static private int[] jj_la1_5;
  static private int[] jj_la1_6;
  static private int[] jj_la1_7;
  static private int[] jj_la1_8;
  static private int[] jj_la1_9;
  static private int[] jj_la1_10;
  static private int[] jj_la1_11;
  static {
	   jj_la1_init_0();
	   jj_la1_init_1();
	   jj_la1_init_2();
	   jj_la1_init_3();
	   jj_la1_init_4();
	   jj_la1_init_5();
	   jj_la1_init_6();
	   jj_la1_init_7();
	   jj_la1_init_8();
	   jj_la1_init_9();
	   jj_la1_init_10();
	   jj_la1_init_11();
	}
	private static void jj_la1_init_0() {
	   jj_la1_0 = new int[] {0x0,0x0,0x0,0x800,0x0,0x0,0x0,0x0,0x800,0x0,0x800800,0x800800,0x800800,0x0,0x0,0x800800,0x800800,0x0,0x0,0x800800,0x800800,0x800800,0x0,0x0,0x0,0x0,0x6080000,0x0,0x0,0x80168618,0x0,0x0,0x80168618,0x80160618,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40001000,0x40001000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80168618,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000,0x801e0218,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80168618,0x0,0x0,0x0,0x0,0x0,0x80168618,0x801e0218,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80160218,0x80160218,0x80160218,0x80168618,0x80168618,0x801e0218,0x0,0x0,0x0,0x400,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x400,0x400,0x0,0x0,0x0,0x400,0x400,0x0,0x0,0x0,0x0,0x0,0x801e0218,0x0,0x80000,0x80160218,0x6000000,0x0,0x6000000,0x0,0x0,0x0,0x0,0x0,0x801e0218,0x0,0x80168618,0x0,0x0,0x801e0218,0x801e0218,0x0,0x0,0x801e0218,0x0,0x0,0x0,0x0,0x10000,0x0,0x0,0x0,0x80168618,0x801e0218,0x0,0x0,0x0,0x80168618,0x0,0x0,0x0,0x0,0x0,0x0,0x801e0218,0x10000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200000,0x200000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x6000,0x0,0x0,0x0,0x0,0x0,0x0,0x2000000,0x2000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8400,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4,0x4,0x0,0x0,0x0,0x4,0x0,0x0,0x0,0x0,0x0,0x0,0x4,0x4,0x0,0x0,0x0,0x0,0x4,0x4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80168618,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000000,0x0,0x0,0x0,0x6000000,0x6000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80168618,0x400,0x0,0x0,0x0,0x0,0x80160218,0x0,0x0,0x0,0x0,0x0,0x0,0x102c0000,0x0,0x102c0000,0x102c0000,0x0,0x102c0000,0x0,0x0,0x0,0x400000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x102c0000,0x0,0x0,0x0,0x0,0x0,0x102c0000,0x0,0x0,0x102c0000,0x0,0x0,0x0,0x0,0x0,0x0,0x80160218,0x0,0x0,0x80000,0x80168618,0x0,0x4000000,0x0,0x2000000,0x0,0x0,0x6000000,0x0,0x0,0x80000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x800,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000,0x10240000,0x0,0x80160218,0x0,0x80160218,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x102c0000,0x0,0x0,0x0,0x820,0x0,0x0,0x0,0x80160218,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80160218,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xa20,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x0,0x0,0x0,0x0,0x20000,0x0,0x0,0x0,0x0,0x0,0x0,0x800,0x800,0x0,0x800,0x20000000,0x0,0x0,0x0,0x0,0x20000000,0x0,0x0,0x0,0x20000000,0x0,0x0,0x0,0x0,};
	}
	private static void jj_la1_init_1() {
	   jj_la1_1 = new int[] {0x0,0x0,0x0,0x10860001,0x0,0x0,0x0,0x1,0x10060000,0x0,0x10860001,0x10860001,0x10860001,0x0,0x0,0x10860001,0x10860001,0x0,0x0,0x10860001,0x10860001,0x10860001,0x10000,0x0,0x10000,0x0,0x60000840,0x0,0x0,0xe4c6ccfe,0x10000,0x0,0xe4c6ccfe,0xe4c6ccf6,0x0,0x0,0x10000,0x0,0x80000000,0x0,0x0,0x0,0x0,0x400000,0x400000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10000,0x10000,0xe4c6ccfe,0x0,0x0,0x0,0x0,0x0,0x0,0x10000,0x10000,0x0,0x0,0x10000,0x10000,0x10000,0x0,0x0,0x10000,0x0,0x0,0x0,0x0,0x0,0xe446ccf6,0x10000,0x0,0x0,0x10000,0x10000,0x10000,0x0,0x10000,0x0,0x10000,0x0,0x0,0x0,0x0,0x10000,0x0,0x0,0x10000,0x10000,0x10000,0x0,0x0,0x10000,0x0,0x0,0x0,0x0,0x10000,0xe4c6ccfe,0x10000,0x0,0x0,0x0,0x0,0xe4c6ccfe,0xe446ccf6,0x0,0x0,0x0,0x0,0x10000,0x0,0x0,0x10000,0x0,0x10000,0x0,0x0,0x0,0xe446ccf6,0xe4c6ccf6,0xe446ccf6,0xe4c6ccfe,0xe6c6ccfe,0xe446ccf6,0x0,0x0,0x0,0x0,0x0,0x0,0x80000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10000,0x0,0x0,0x0,0xe446ccf6,0x0,0x0,0xe446ccf6,0x60000840,0x10000,0x60000840,0x0,0x10000,0x0,0x0,0x10000,0xe446ccf6,0x10000,0xe4c6ccfe,0x10000,0x10000,0xe446ccf6,0xe446ccf6,0x10000,0x0,0xe446ccf6,0x0,0x0,0x0,0x0,0x1010000,0x0,0x0,0x0,0xe4c6ccfe,0xe446ccf6,0x0,0x0,0x0,0xe4c6ccfe,0x10000,0x10000,0x10000,0x10000,0x10000,0x0,0xe446ccf6,0x1010000,0x0,0x0,0x0,0x0,0x1000000,0x1000000,0x0,0x10000,0x0,0x10000,0x0,0x40000000,0x40000000,0x10000,0x0,0x0,0x0,0x0,0x80000,0x10000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10000,0x0,0x0,0x0,0x0,0x0,0x0,0x10000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2000000,0x100000,0x0,0x2000,0x0,0x0,0x0,0x0,0x0,0x10000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10000,0x0,0x10000,0x0,0x10000,0x0,0x0,0x0,0x0,0x0,0x0,0x10000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xe4c6ccfe,0x40000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x60000840,0x60000840,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10000,0x1,0x10000,0x0,0x10000,0x0,0x0,0x0,0x0,0xe4c6ccfe,0x0,0x0,0x0,0x0,0x0,0xe4c6ccf6,0x0,0x0,0x0,0x0,0x0,0x0,0x262202,0x10000,0x262202,0x262202,0x0,0x262202,0x0,0x0,0x0,0x0,0x0,0x800000,0x800000,0x0,0x10000,0x0,0x0,0x0,0x0,0x262202,0x10000,0x10000,0x200000,0x0,0x0,0x262202,0x0,0x0,0x262202,0x200000,0x0,0x0,0x200000,0x0,0x0,0xe4c6ccf6,0x0,0x0,0x0,0xe4c6ccfe,0x0,0x40,0x0,0x60000800,0x0,0x0,0x60000840,0x0,0x800,0x800,0x800,0x10000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20002,0x242200,0x0,0xe446ccf6,0x0,0xe446ccf6,0x10000,0x10000,0x0,0x10000,0x0,0x2,0x2,0x2,0x0,0x262202,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xe4c6ccf6,0x10000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200,0xe4e6ccf6,0x4000,0x0,0x0,0x0,0x2,0x0,0x0,0x0,0x2,0x4000,0x0,0x2,0x2,0x2,0x2,0x2,0x2,0x0,0x0,0x2,0x2,0x204000,0x0,0x0,0x0,0x0,0x80,0x40000,0x0,0x10000,0x20000,0x0,0x20000,0x0,0x20000,0x0,0x1000,0x0,0x0,0x0,0x0,0x400,0x0,0x0,0x0,0x0,0x4000,0x10000,0x0,0x0,0x10000,0x0,0x4000000,0x0,0x0,0x0,0x4000000,0x0,0x0,0x0,0x0,0x4000000,0x0,0x0,0x0,0x0,};
	}
	private static void jj_la1_init_2() {
	   jj_la1_2 = new int[] {0x0,0x0,0x0,0xb004028,0x0,0x8,0x8,0x3004000,0x8000020,0x0,0xb004028,0xb004028,0xb004028,0x0,0x0,0xb004028,0xb004028,0x0,0x0,0xb004028,0xb004028,0xb004028,0x0,0x0,0x0,0x0,0x2000,0x0,0x0,0x2099b2f1,0x0,0x0,0x2099b2f1,0x209992f1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2099b2f1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4,0x4,0x0,0x0,0x0,0x209992f1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2099b2f1,0x0,0x0,0x0,0x0,0x0,0x2099b2f1,0x209992f1,0x0,0x0,0x0,0x0,0x0,0x0,0x8,0x0,0x0,0x0,0x0,0x0,0x0,0x209992f1,0x209992f1,0x209992f1,0x2099b2f1,0x2099b2f1,0x209992f1,0x0,0x0,0x0,0x100,0x0,0x0,0x0,0x0,0x0,0x40000,0x0,0x0,0x0,0x0,0x100,0x100,0x400000,0x0,0x0,0x100,0x100,0x400000,0x0,0x0,0x0,0x0,0x209992f1,0x0,0x0,0x209992f1,0x2000,0x0,0x2000,0x0,0x0,0x0,0x0,0x0,0x209992f1,0x0,0x2099b2f1,0x0,0x0,0x209992f1,0x209992f1,0x0,0x0,0x209992f1,0x0,0x0,0x800000,0x800000,0x0,0x0,0x400000,0x0,0x2099b2f1,0x209992f1,0x0,0x0,0x0,0x2099b2f1,0x0,0x0,0x0,0x0,0x0,0x0,0x209992f1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10,0x10,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4000000,0x0,0x0,0x0,0x0,0x0,0x200000,0x0,0x200000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2099b2f1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2000,0x2000,0x0,0x0,0x0,0x20000,0x0,0x0,0x0,0x0,0x3000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2099b2f1,0x100,0x0,0x0,0x0,0x0,0x209992f1,0x0,0x0,0x100,0x0,0x0,0x0,0x804019,0x0,0x804019,0x804019,0x0,0x804019,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x804019,0x0,0x0,0x0,0x0,0x0,0x804019,0x0,0x0,0x804019,0x0,0x8,0x8,0x0,0x0,0x0,0x209992f1,0x0,0x80040,0x0,0x2099b2f1,0x0,0x0,0x0,0x0,0x0,0x0,0x2000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4009,0x800010,0x80040,0x209992f1,0x0,0x209992f1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x804019,0x0,0x80042,0x80042,0x0,0x0,0x0,0x0,0x209992f1,0x0,0x0,0x0,0x0,0x0,0x0,0x8,0x8,0x0,0x8,0x8,0x0,0x0,0x0,0x0,0x0,0x0,0x209992f1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4000,0x0,0x0,0x0,0x0,0xc00,0x0,0xc00,0x0,0xc00,0x80040,0x0,0x0,0x0,0x0,0x880c0,0x0,0x0,0x0,0x0,0x0,0x0,0x2004008,0x2004008,0x0,0x2004008,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
	}
	private static void jj_la1_init_3() {
	   jj_la1_3 = new int[] {0x0,0x0,0x0,0x804000,0x0,0x0,0x0,0x0,0x4000,0x0,0x4000,0x4000,0x4000,0x0,0x0,0x4000,0x804000,0x0,0x0,0x4000,0x804000,0x804000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x49a1891f,0x0,0x0,0x49a1891f,0x4020891f,0x0,0x0,0x0,0x0,0x40000000,0x4,0x4,0x0,0x0,0x100,0x100,0x0,0x400,0x8000200,0x8000200,0x0,0x0,0x0,0x2000000,0x0,0x0,0x49a1891f,0x200,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x100000,0x100000,0x2000000,0x0,0x0,0x4020091f,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2000000,0x0,0x49a18b1f,0x0,0x0,0x0,0x0,0x0,0x49a1891f,0x4020091f,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4020091f,0x4020891f,0x4020091f,0x49a1891f,0x49a18b1f,0x4020091f,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8000,0x80000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4020091f,0x0,0x0,0x4020091f,0x0,0x0,0x0,0x40000000,0x0,0x2000040,0x40000000,0x0,0x4020091f,0x0,0x49a1891f,0x0,0x0,0x4020091f,0x4020091f,0x0,0x0,0x4020091f,0x0,0x0,0x10000000,0x10000000,0x80000400,0x0,0x0,0x0,0x49a1891f,0x4020091f,0x0,0x0,0x2000040,0x49a1891f,0x0,0x0,0x0,0x0,0x0,0x0,0x4020091f,0x80000400,0x0,0x0,0x400,0x0,0x80000400,0x80000400,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x400000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2,0x2,0x0,0x0,0x0,0x0,0x2,0x0,0x0,0x0,0x0,0x2,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4,0x0,0x0,0x8000200,0x8000200,0x220,0x20,0x220,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x100,0x0,0x0,0x0,0x100,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x100,0x0,0x0,0x0,0x0,0x100,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x49a1891f,0x0,0x2,0x2000000,0x2000000,0x0,0x0,0x0,0x0,0x2000001,0x0,0x0,0x10,0x10,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x49a1891f,0x0,0x0,0x0,0x0,0x2000000,0x4020891f,0x0,0x0,0x0,0x0,0x0,0x0,0x8000084,0x0,0x8000084,0x8000084,0x0,0x8000084,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2000,0x8000084,0x0,0x0,0x0,0x0,0x0,0x8000084,0x0,0x800,0x8000084,0x0,0x0,0x0,0x0,0x0,0x0,0x4020891f,0x0,0x0,0x0,0x49a1891f,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40,0x40,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x8000004,0x0,0x4020091f,0x0,0x4020091f,0x0,0x0,0x0,0x0,0x40000000,0x0,0x0,0x0,0x0,0x8000084,0x0,0x0,0x0,0x0,0x0,0x40000000,0x0,0x4020891f,0x0,0x40000000,0x0,0x40000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40000000,0x40000000,0x0,0x80,0x4020899f,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x800000,0x0,0x0,0x0,0x40000080,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40000,0x0,0x40000,0x0,0x40,0x0,0x0,0x0,0x0,0x8,0x0,0x0,0x40,0x40,0x0,0x0,0x0,0x0,0x0,0x0,0x20002000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2000,0x20002000,0x0,0x1000,0x0,0x0,};
	}
	private static void jj_la1_init_4() {
	   jj_la1_4 = new int[] {0x0,0x0,0x0,0x80000002,0x0,0x80000002,0x80000002,0x0,0x0,0x0,0x80000002,0x80000002,0x80000002,0x0,0x0,0x80000002,0x80000002,0x0,0x0,0x80000002,0x80000002,0x80000002,0x0,0x0,0x0,0x0,0x108,0x800000,0x0,0x23db414a,0x0,0x0,0x23db414a,0x238b414a,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x100,0x100,0x0,0x0,0x0,0x0,0x0,0x0,0x200000,0x200000,0x4000000,0x0,0x0,0x0,0x23db414a,0x0,0x0,0x0,0x400000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4000000,0x4000000,0x0,0x10,0x0,0x238b4142,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4000000,0x0,0x0,0x0,0x23db414a,0x0,0x0,0x0,0x0,0x400000,0x23db414a,0x238b414a,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x238b4142,0x238b414a,0x238b414a,0x23db414a,0x23db414a,0x238b414a,0x0,0x1,0x0,0x0,0x10,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4,0x0,0x0,0x0,0x0,0x4,0x0,0x0,0x0,0x0,0x238b414a,0x0,0x0,0x238b414a,0x108,0x0,0x108,0x0,0x0,0x0,0x4000,0x0,0x238b414a,0x0,0x23db414a,0x0,0x0,0x238b414a,0x238b414a,0x0,0x0,0x238b414a,0x0,0x0,0x0,0x0,0x100081,0x0,0x4,0x0,0x23df414a,0x238b414a,0x0,0x0,0x0,0x23df414a,0x0,0x0,0x0,0x0,0x0,0x0,0x238b414a,0x100081,0x0,0x0,0x0,0x0,0x100000,0x100000,0x0,0x81,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000,0x20000,0x0,0x400000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x400000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200000,0x0,0x0,0x0,0x0,0x0,0x60,0x0,0x0,0x0,0x80000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4000,0x0,0x0,0x0,0x4000,0x0,0x0,0x4000,0x0,0x0,0x0,0x0,0x0,0x0,0xa00,0x4000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1400,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x23db414a,0x0,0x20000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x108,0x108,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x23db414a,0x0,0x0,0x0,0x0,0x0,0x238b414a,0x0,0x0,0x0,0x0,0x0,0x0,0x4000,0x0,0x4000,0x4000,0x0,0x4000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4000,0x0,0x0,0x0,0x4000,0x0,0x4000,0x0,0x0,0x4000,0x0,0x0,0x0,0x0,0x0,0x0,0x238b414a,0x0,0x0,0x0,0x23db414a,0x200000,0x0,0x0,0x108,0x0,0x0,0x108,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4000,0x0,0x0,0x238b4142,0x0,0x238b4142,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4000,0x0,0x0,0x0,0x0,0x0,0x4000,0x0,0x238b414a,0x0,0x4000,0x0,0x4000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4000,0x4000,0x0,0x4000,0x238b414a,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2,0x2,0x0,0x2,0x40002000,0x0,0x40000000,0x0,0x0,0x0,0x0,0x2000,0x0,0x40002000,0x0,0x0,0x0,0x0,};
	}
	private static void jj_la1_init_5() {
	   jj_la1_5 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xa5a808c0,0x0,0x0,0xa5a808c0,0xa52808c0,0x100000,0x100000,0x0,0x0,0x0,0x1400000,0x1400000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xa5a808c0,0x0,0x0,0x20000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x842808c0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000000,0x0,0x0,0x0,0x0,0xa5a808c0,0x0,0x0,0x0,0x20000000,0x0,0xa5a808c0,0x842808c0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x842808c0,0xa52808c0,0x842808c0,0xa5a808c0,0xa5a808c0,0x842808c0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200000,0x100000,0x0,0x0,0x0,0x0,0x1,0x0,0x0,0x0,0x0,0x1,0x0,0x0,0x0,0x0,0x842808c0,0x0,0x0,0x842808c0,0x0,0x0,0x0,0x800,0x0,0x0,0x0,0x0,0x842808c0,0x0,0xa5a808c0,0x0,0x0,0x842808c0,0x842808c0,0x0,0x0,0x842808c0,0x0,0x0,0x0,0x0,0x40000010,0x0,0x1,0x0,0xa5a808c0,0x842808c0,0x0,0x0,0x0,0xa5a808c0,0x0,0x0,0x0,0x0,0x0,0x0,0x842808c0,0x40000010,0x40000000,0x40000000,0x0,0x40000000,0x40000010,0x40000010,0x40000000,0x0,0x0,0x0,0x1000000,0x0,0x0,0x0,0x0,0x200,0x200,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000,0x0,0x0,0x0,0x20,0x0,0x0,0x0,0x0,0x0,0x0,0x8000,0x8000,0x8000,0x0,0x8000,0x8000,0x8000,0x8000,0x0,0x8000,0x0,0x0,0x8000,0x8000,0x0,0x0,0x8000,0x8000,0x8000,0x0,0x0,0x8000,0x0,0x8000,0x8000,0x0,0x8000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8000,0x8000,0x0,0x0,0x0,0x0,0x0,0x40000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40000,0x40000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40000,0x0,0x0,0x0,0x20000000,0x0,0x40000,0x0,0x0,0x0,0x20000000,0x0,0x0,0x0,0x0,0xa5a808c0,0x0,0x0,0x0,0x80000000,0x0,0x0,0x20000000,0x0,0x80000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xa5a808c0,0x0,0x20000000,0x20000000,0x0,0x0,0xa52808c0,0x0,0x20000000,0x0,0x20000000,0x0,0x0,0x1048000,0x0,0x1048000,0x1048000,0x0,0x1048000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8000000,0x0,0x0,0x1048000,0x0,0x0,0x0,0x0,0x0,0x1048000,0x0,0x0,0x1048000,0x0,0x0,0x0,0x0,0x0,0x0,0xa52808c0,0x0,0x0,0x0,0xa5a808c0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8000000,0x80,0x80,0x0,0x0,0x0,0x0,0x0,0x40000,0x80,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1048000,0x0,0x0,0x842808c0,0x0,0x842808c0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1048000,0x8000,0x28000,0x28000,0x4,0x0,0x0,0x0,0xa52808c0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xa52808c0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4,0x0,0x2000000,0x0,0x10000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000000,0x0,0x0,0x20007702,0x0,0x1000,0x2002,0x200,0x100,0x20004000,0x400,0x0,0x20007702,0x8000000,0x0,0x8000000,0x0,};
	}
	private static void jj_la1_init_6() {
	   jj_la1_6 = new int[] {0x0,0x0,0x0,0x6002000,0x0,0x0,0x0,0x2000000,0x2000,0x0,0x6002000,0x6002000,0x6002000,0x0,0x0,0x6002000,0x6002000,0x0,0x0,0x6002000,0x6002000,0x6002000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x550f5f1f,0x0,0x0,0x550f5f1f,0x550f471e,0x0,0x0,0x0,0x0,0x80000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x550f5f1f,0x0,0x0,0x0,0x0,0x0,0x80000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x550f471e,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8000,0x0,0x0,0x550f5f1f,0x0,0x0,0x0,0x0,0x0,0x550f5f1f,0x550f471e,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x550f471e,0x550f471e,0x550f471e,0x550f5f1f,0x550f5f1f,0x550f471e,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x100000,0x0,0x0,0x550f471e,0x0,0x0,0x550f471e,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x550f471e,0x0,0x550f5f1f,0x0,0x0,0x550f471e,0x550f471e,0x0,0x0,0x550f471e,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x550f5f1f,0x550f471e,0x20,0x20,0x0,0x550f5f1f,0x0,0x0,0x0,0x0,0x0,0x0,0x550f471e,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xc00000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40,0x40,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4,0x0,0x20000,0x0,0x0,0x0,0x550f5f1f,0x0,0x0,0x0,0x0,0x0,0x4,0x0,0x20000,0x0,0x20000,0x0,0x80,0x80,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x550f5f1f,0x0,0x0,0x0,0x0,0x0,0x550f471e,0x0,0x0,0x0,0x0,0x0,0x0,0x200206,0x0,0x200206,0x200206,0x0,0x200206,0x0,0x0,0x0,0x0,0x8,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200206,0x0,0x0,0x0,0x0,0x200,0x200206,0x0,0x0,0x200206,0x0,0x0,0x0,0x0,0x0,0x0,0x550f471e,0x0,0x0,0x0,0x550f5f1f,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000000,0x4000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200200,0x6,0x0,0x550f471e,0x0,0x550f471e,0x0,0x0,0x0,0x0,0x0,0x20000000,0x20000000,0x0,0x0,0x200206,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x550f471e,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200,0x550f471e,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000000,0x20000000,0x20000000,0x20000000,0x20000000,0x20000000,0x0,0x0,0x20000000,0x20000000,0x200,0x0,0x0,0x0,0x0,0x0,0x2000000,0x0,0x0,0x0,0x4000,0x8000002,0x4000,0x8000002,0x4000,0x0,0x2,0x2,0x0,0x0,0x11010000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x800,0x0,0x1000,};
	}
	private static void jj_la1_init_7() {
	   jj_la1_7 = new int[] {0x0,0x0,0x0,0x9852,0x0,0x40,0x40,0x1800,0x8012,0x0,0x9852,0x9852,0x9852,0x0,0x0,0x9852,0x9852,0x0,0x0,0x9852,0x9852,0x9852,0x0,0x0,0x0,0x0,0x8000800,0x400,0x0,0xbffb0f2d,0x0,0x0,0xbffb0f2d,0xbfdb072c,0x0,0x0,0x0,0x0,0x28000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xbffb0f2d,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40,0x840,0x0,0x0,0x0,0x0,0x0,0x0,0xaf9b072c,0x0,0x0,0x0,0x0,0x0,0x0,0x40,0x0,0x840,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40,0x40,0x0,0x0,0x0,0x0,0x0,0x0,0xbffb0f2d,0x0,0x0,0x0,0x0,0x0,0xbffb0f2d,0xaf9b072c,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xaf9b072c,0xbfdb072c,0xaf9b072c,0xbffb0f2d,0xbffb0f6d,0xaf9b072c,0x0,0x0,0x0,0x0,0x0,0x0,0x400000,0x0,0x0,0x0,0x0,0x0,0x40,0x40,0x0,0x0,0x0,0x40,0x40,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xaf9b072c,0x0,0x0,0xaf9b072c,0x800,0x0,0x800,0x0,0x0,0x8000,0x0,0x0,0xaf9b072c,0x0,0xbffb0f2d,0x0,0x0,0xaf9b072c,0xaf9b072c,0x0,0x0,0xaf9b072c,0x40,0x0,0x0,0x0,0x1,0x40,0x0,0x0,0xbffb0f2d,0xaf9b072c,0x0,0x0,0x8000,0xbffb0f2d,0x0,0x0,0x0,0x0,0x0,0x0,0xaf9b072c,0x1,0x80,0x80,0x1,0x0,0x1,0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x400,0x0,0x0,0x400000,0x400000,0x0,0x20000,0x0,0x0,0x0,0x0,0x0,0x0,0xc,0xc,0x0,0x0,0xc,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4,0x200000,0x40,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8,0x0,0x0,0x0,0xbffb0f2d,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8,0x0,0x8,0x0,0x0,0x0,0x0,0x800,0x800,0x0,0x0,0x0,0x0,0x0,0x0,0x4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xbffb0f2d,0x0,0x0,0x0,0x40,0x0,0xbfdb072c,0x0,0x0,0x0,0x0,0x200,0x0,0xa0000008,0x0,0xa0000008,0xa0000008,0x0,0xa0000008,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xa0000008,0x0,0x0,0x0,0x0,0x0,0xa0000008,0x0,0x0,0xa0000008,0x0,0x0,0x0,0x0,0x0,0x0,0xbfdb072c,0x0,0x0,0x0,0xbffb0f2d,0x0,0x0,0x0,0x800,0x0,0x0,0x800,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000000,0x80000000,0x0,0x0,0x0,0x0,0x800,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8,0xa0000000,0x0,0xaf9b072c,0x0,0xaf9b072c,0x0,0x0,0x0,0x0,0x8000120,0x0,0x0,0x0,0x0,0xa0000008,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xbfdb072c,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xbfdb072c,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2,0x0,0x0,0x0,0x0,0x0,0x800,0x0,0x0,0x0,0x0,0x1811800,0x0,0x10,0x0,0x0,0x8000000,0x0,0x40,0x40,0x0,0x40,0x402400,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x400,0x402400,0x0,0x0,0x0,0x0,};
	}
	private static void jj_la1_init_8() {
	   jj_la1_8 = new int[] {0x0,0x0,0x0,0x20058040,0x0,0x20008000,0x20018000,0x40,0x40000,0x0,0x20058040,0x20058040,0x20058040,0x0,0x0,0x20058040,0x20058040,0x0,0x0,0x20058040,0x20058040,0x20058040,0x0,0x0,0x0,0x0,0x5000000,0x0,0x0,0x3f0a02dd,0x0,0x0,0x3f0a02dd,0x3f0a02dd,0x0,0x0,0x0,0x80000,0x0,0x80,0x80,0x0,0x0,0x80000000,0x80000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3f0a02dd,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x30000000,0x30000000,0x0,0x0,0x0,0x20000000,0x30000000,0x0,0x0,0x0,0x0,0x0,0x0,0xf0a02cd,0x0,0x30000000,0x30000000,0x0,0x0,0x0,0x20000000,0x0,0x20000000,0x0,0x0,0x0,0x0,0x0,0x0,0x30000000,0x30000000,0x0,0x0,0x0,0x20000000,0x20000000,0x0,0x0,0x0,0x0,0x0,0x0,0x3f0a02dd,0x0,0x800000,0x0,0x0,0x0,0x3f0a02dd,0x3f0a02dd,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf0a02cd,0x3f0a02dd,0x3f0a02dd,0x3f0a02dd,0x3f0a02dd,0x3f0a02dd,0x0,0x0,0x600000,0x701000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000000,0x20000000,0x0,0x0,0x800,0x20000000,0x20000000,0x0,0x0,0x800,0x0,0x0,0x0,0x0,0x3f0a02dd,0x0,0x0,0x3f0a02dd,0x5000000,0x0,0x5000000,0x0,0x0,0x40000,0x0,0x0,0x3f0a02dd,0x0,0x3f0a02dd,0x0,0x0,0x3f0a02dd,0x3f0a02dd,0x0,0x0,0x3f0a02dd,0x20000000,0x0,0x0,0x0,0x0,0x20000000,0x800,0x0,0x3f0a02dd,0x3f0a02dd,0x0,0x0,0x40000,0x3f0a02dd,0x0,0x0,0x0,0x0,0x0,0x0,0x3f0a02dd,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x800000,0x0,0x0,0x0,0x100,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x0,0x20,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10000000,0x0,0x0,0x0,0x10000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3f0a02dd,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x400,0x5000000,0x5000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3f0a02dd,0x1000,0x0,0x0,0x20000000,0x0,0x3f0a02dd,0x0,0x0,0x0,0x0,0x0,0x0,0x4809283,0x0,0x4809283,0x4809283,0x800000,0x4809283,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2000,0x0,0x4809283,0x0,0x0,0x0,0x0,0x1000,0x4809283,0x1000,0x0,0x4809283,0x0,0x8000,0x8000,0x0,0x0,0x0,0x3f0a02dd,0x0,0x0,0x0,0x3f0a02dd,0x0,0x0,0x40000000,0x0,0x0,0x0,0x4000000,0x1000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1,0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x9002,0x4800281,0x0,0xf0a02cd,0x0,0xf0a02cd,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200,0x4809283,0x0,0x8000000,0x8000000,0x0,0x800000,0x0,0x800000,0x3f0a02dd,0x0,0x0,0x0,0x0,0x800000,0x0,0x8000,0x8000,0x0,0x8000,0x8000,0x800000,0x0,0x0,0x0,0x800000,0x1000,0x3f0a12dd,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8,0x8,0x0,0x0,0x8000,0x8000,0x0,0x8000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
	}
	private static void jj_la1_init_9() {
	   jj_la1_9 = new int[] {0x20000,0x20000,0x20000,0x20,0x20,0x0,0x20,0x0,0x0,0x20000,0x20,0x20,0x20,0x20000,0x20000,0x20,0x20,0x20000,0x20000,0x20,0x20,0x20,0x0,0x0,0x0,0x0,0x80800400,0x0,0x0,0x80010401,0x0,0x0,0x80010401,0x80010401,0x2,0x2,0x0,0x0,0x0,0x0,0x0,0x8400,0x8400,0x0,0x0,0x0,0x0,0x0,0x0,0x8,0x8,0x0,0x0,0x0,0x0,0x80010401,0x0,0x8,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20,0x20,0x0,0x0,0x0,0x0,0x0,0x0,0x80010401,0x0,0x0,0x0,0x0,0x0,0x0,0x20,0x0,0x20,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20,0x20,0x0,0x0,0x0,0x0,0x0,0x0,0x80010401,0x0,0x0,0x8,0x0,0x0,0x80010401,0x80010401,0x4,0x4,0x4,0x4,0x0,0x8,0x0,0x0,0x0,0x0,0x8,0x0,0x0,0x80010401,0x80010401,0x80010401,0x80010401,0x80010401,0x80010401,0x20,0x0,0x0,0x0,0x0,0x10,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80010401,0x0,0x0,0x80010401,0x80800400,0x0,0x80800400,0x0,0x0,0x0,0x0,0x0,0x80010401,0x0,0x80010401,0x0,0x0,0x80010401,0x80010401,0x0,0x0,0x80010401,0x0,0x0,0x0,0x0,0x0,0x20,0x0,0x0,0x80010401,0x80010401,0x0,0x0,0x20,0x80010401,0x0,0x0,0x0,0x0,0x0,0x0,0x80010401,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x0,0x80,0x80000000,0x80000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2000000,0x0,0x2000000,0x82000000,0x0,0x82000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7c0000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000,0xb000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2000000,0x2000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x120,0x120,0x0,0x0,0x0,0x0,0x8b800000,0x0,0x80000000,0x0,0x0,0x0,0x120,0x120,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3000000,0x0,0x80010401,0x80000000,0x0,0x0,0x80,0x0,0x0,0x0,0x0,0x80,0x0,0x0,0x0,0x0,0x0,0x80800400,0x80800400,0x4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80010401,0x0,0x0,0x0,0x20,0x0,0x80010401,0x0,0x0,0x0,0x0,0x0,0x20,0x83000028,0x0,0x83000028,0x83000028,0x0,0x83000028,0x80000000,0x80000000,0x80000000,0x0,0x0,0x0,0x0,0x80000000,0x0,0x80000000,0x0,0x0,0x0,0x83000028,0x0,0x0,0x0,0x0,0x0,0x83000028,0x0,0x0,0x83000028,0x0,0x0,0x0,0x0,0x0,0x0,0x80010401,0x0,0x0,0x0,0x80010401,0x0,0x0,0x0,0x80800400,0x80000000,0x0,0x80800400,0x0,0x82000000,0x0,0x82000000,0x0,0x2000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20,0x0,0x0,0x0,0x0,0x80000000,0x80000000,0x0,0x0,0x0,0x3000000,0x83000000,0x28,0x0,0x83010401,0x3000000,0x83010401,0x0,0x0,0x0,0x0,0x80000001,0x80000000,0x80000000,0x0,0x0,0x83000028,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80010401,0x0,0x0,0x80000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80010401,0x0,0x80000000,0x0,0x0,0x0,0x80000000,0x0,0x0,0x0,0x80000000,0x80000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000000,0x0,0x0,0x80000000,0x0,0x80000000,0x80000000,0x80000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x82000000,0x82000000,0x0,0x0,0x0,0x200,0x0,0x0,0x0,0x1,0x0,0x0,0x80000000,0x0,0x0,0x0,0x20,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
	}
	private static void jj_la1_init_10() {
	   jj_la1_10 = new int[] {0x0,0x0,0x0,0x20,0x0,0x20,0x20,0x0,0x0,0x0,0x20,0x20,0x20,0x0,0x0,0x20,0x20,0x0,0x0,0x20,0x20,0x20,0x0,0x80,0x0,0x80,0x8,0x0,0x80,0x8,0x0,0x80,0x8,0x8,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x28,0x0,0x0,0x0,0x0,0x100,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20,0x20,0x0,0x0,0x0,0x0,0x0,0x0,0x8,0x0,0x0,0x0,0x0,0x0,0x0,0x20,0x0,0x20,0x0,0x0,0x100,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20,0x20,0x0,0x0,0x0,0x0,0x0,0x0,0x8,0x0,0x0,0x0,0x0,0x0,0x28,0xc,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20,0x0,0x0,0x600,0x200,0x8,0x8,0x8,0x8,0x8,0xc,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20,0x0,0x0,0x0,0x0,0x20,0x0,0x0,0x0,0x0,0x0,0x20,0x20,0xc,0x100,0x0,0xc,0x8,0x0,0x8,0x0,0x0,0x0,0x0,0x0,0xc,0x0,0x28,0x0,0x0,0xc,0xc,0x0,0x20,0xc,0x20,0x20,0x0,0x0,0x0,0x20,0x0,0x20,0x8,0xc,0x0,0x0,0x0,0x28,0x0,0x0,0x0,0x0,0x0,0x20,0xc,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x800,0x0,0xc20,0x800,0x0,0x800,0x1000,0x1000,0x1020,0x0,0x1000,0x1000,0x1020,0x1000,0x20,0x0,0x0,0x0,0x1fff8880,0x0,0x0,0x20,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20,0x0,0x20,0x20000080,0xc0000000,0xc0000000,0x2002000,0x100,0x0,0x400,0x1000,0x1000,0x2022000,0x2022000,0x0,0x20,0x200,0x0,0x800,0x10000,0x0,0x0,0x0,0x0,0x4,0x0,0x0,0x0,0x10000,0x200,0x0,0x0,0x0,0x0,0x4,0x4,0x0,0x0,0x0,0x400,0x0,0x0,0x0,0x400,0x0,0x4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xc,0x400,0x8,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20,0x0,0x0,0x0,0x2000000,0x4,0x400,0x8,0x0,0x0,0x0,0x0,0x20,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8,0x8,0x0,0x20,0x40,0x0,0x20,0x40,0x0,0x0,0x0,0x0,0x20,0x0,0xc04,0x0,0x0,0x0,0x8,0x0,0x0,0x0,0x20,0x0,0x8,0x200,0x0,0x0,0x0,0x0,0x0,0x20020ac,0x0,0x20020ac,0x20020ac,0x0,0x20020ac,0x8,0x8,0x8,0x0,0x0,0x0,0x0,0x8,0x0,0x8,0x0,0x0,0x0,0x20020ac,0x0,0x0,0x0,0x0,0x0,0x20020ac,0x0,0x0,0x20020ac,0x0,0x0,0x0,0x0,0x20,0x20,0x8,0x20,0x0,0x0,0x8,0x0,0x0,0x0,0x8,0x8,0x200,0x8,0x0,0x4,0x0,0x4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20,0x0,0x0,0x0,0x0,0x20,0x8,0x8,0x200,0x2002000,0x2002000,0x0,0x200208c,0x20,0x0,0xc,0x4,0xc,0x80,0x80,0x20,0x0,0x0,0x0,0x0,0x0,0x0,0x20020ac,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8,0x0,0x0,0x8,0x0,0x0,0x20,0x0,0x0,0x20,0x0,0x0,0x0,0x20,0x0,0x0,0x0,0x0,0x28,0x0,0x8,0x0,0x0,0x0,0x8,0x0,0x0,0x0,0x28,0x8,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8,0x0,0x0,0x28,0x80,0x8,0x8,0x8,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x84,0x84,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
	}
	private static void jj_la1_init_11() {
	   jj_la1_11 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3,0x3,0x0,0xc,0x10,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000,0x0,0x0,0x0,0x0,0x680,0x0,0x20,0x800,0x1000,0x0,0x20,0x0,0x20,0x800,0x0,0x0,0x1e000,0x1e000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1e0000,0x1e0000,0x200000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x800,0x0,0x800,0x800,0x0,0x800,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x800,0x0,0x0,0x0,0x0,0x0,0x800,0x0,0x0,0x800,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20,0x20,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x800,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x800,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x400000,0x800000,0x0,0x0,0x400000,0x800000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3000000,0x3000000,0x1c000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
	}
  final private JJCalls[] jj_2_rtns = new JJCalls[267];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  /** Constructor. */
  public CCJSqlParser(Provider stream) {
	 jj_input_stream = new SimpleCharStream(stream, 1, 1);
	 token_source = new CCJSqlParserTokenManager(jj_input_stream);
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 576; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor. */
  public CCJSqlParser(String dsl) throws ParseException, TokenMgrException {
	   this(new StringProvider(dsl));
  }

  public void ReInit(String s) {
	  ReInit(new StringProvider(s));
  }
  /** Reinitialise. */
  public void ReInit(Provider stream) {
	if (jj_input_stream == null) {
	   jj_input_stream = new SimpleCharStream(stream, 1, 1);
	} else {
	   jj_input_stream.ReInit(stream, 1, 1);
	}
	if (token_source == null) {
 token_source = new CCJSqlParserTokenManager(jj_input_stream);
	}

	 token_source.ReInit(jj_input_stream);
	 token = new Token();
	 jj_ntk = -1;
	 jjtree.reset();
	 jj_gen = 0;
	 for (int i = 0; i < 576; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor with generated Token Manager. */
  public CCJSqlParser(CCJSqlParserTokenManager tm) {
	 token_source = tm;
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 576; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(CCJSqlParserTokenManager tm) {
	 token_source = tm;
	 token = new Token();
	 jj_ntk = -1;
	 jjtree.reset();
	 jj_gen = 0;
	 for (int i = 0; i < 576; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  private Token jj_consume_token(int kind) throws ParseException {
	 Token oldToken;
	 if ((oldToken = token).next != null) token = token.next;
	 else token = token.next = token_source.getNextToken();
	 jj_ntk = -1;
	 if (token.kind == kind) {
	   jj_gen++;
	   if (++jj_gc > 100) {
		 jj_gc = 0;
		 for (int i = 0; i < jj_2_rtns.length; i++) {
		   JJCalls c = jj_2_rtns[i];
		   while (c != null) {
			 if (c.gen < jj_gen) c.first = null;
			 c = c.next;
		   }
		 }
	   }
	   return token;
	 }
	 token = oldToken;
	 jj_kind = kind;
	 throw generateParseException();
  }

  @SuppressWarnings("serial")
  static private final class LookaheadSuccess extends RuntimeException {
    @Override
    public Throwable fillInStackTrace() {
      return this;
    }
  }
  static private final LookaheadSuccess jj_ls = new LookaheadSuccess();
  private boolean jj_scan_token(int kind) {
	 if (jj_scanpos == jj_lastpos) {
	   jj_la--;
	   if (jj_scanpos.next == null) {
		 jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
	   } else {
		 jj_lastpos = jj_scanpos = jj_scanpos.next;
	   }
	 } else {
	   jj_scanpos = jj_scanpos.next;
	 }
	 if (jj_rescan) {
	   int i = 0; Token tok = token;
	   while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
	   if (tok != null) jj_add_error_token(kind, i);
	 }
	 if (jj_scanpos.kind != kind) return true;
	 if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
	 return false;
  }


/** Get the next Token. */
  final public Token getNextToken() {
	 if (token.next != null) token = token.next;
	 else token = token.next = token_source.getNextToken();
	 jj_ntk = -1;
	 jj_gen++;
	 return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
	 Token t = jj_lookingAhead ? jj_scanpos : token;
	 for (int i = 0; i < index; i++) {
	   if (t.next != null) t = t.next;
	   else t = t.next = token_source.getNextToken();
	 }
	 return t;
  }

  private int jj_ntk_f() {
	 if ((jj_nt=token.next) == null)
	   return (jj_ntk = (token.next=token_source.getNextToken()).kind);
	 else
	   return (jj_ntk = jj_nt.kind);
  }

  private List<int[]> jj_expentries = new ArrayList<int[]>();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
	 if (pos >= 100) {
		return;
	 }

	 if (pos == jj_endpos + 1) {
	   jj_lasttokens[jj_endpos++] = kind;
	 } else if (jj_endpos != 0) {
	   jj_expentry = new int[jj_endpos];

	   for (int i = 0; i < jj_endpos; i++) {
		 jj_expentry[i] = jj_lasttokens[i];
	   }

	   for (int[] oldentry : jj_expentries) {
		 if (oldentry.length == jj_expentry.length) {
		   boolean isMatched = true;

		   for (int i = 0; i < jj_expentry.length; i++) {
			 if (oldentry[i] != jj_expentry[i]) {
			   isMatched = false;
			   break;
			 }

		   }
		   if (isMatched) {
			 jj_expentries.add(jj_expentry);
			 break;
		   }
		 }
	   }

	   if (pos != 0) {
		 jj_lasttokens[(jj_endpos = pos) - 1] = kind;
	   }
	 }
  }

  /** Generate ParseException. */
  public ParseException generateParseException() {
	 jj_expentries.clear();
	 boolean[] la1tokens = new boolean[381];
	 if (jj_kind >= 0) {
	   la1tokens[jj_kind] = true;
	   jj_kind = -1;
	 }
	 for (int i = 0; i < 576; i++) {
	   if (jj_la1[i] == jj_gen) {
		 for (int j = 0; j < 32; j++) {
		   if ((jj_la1_0[i] & (1<<j)) != 0) {
			 la1tokens[j] = true;
		   }
		   if ((jj_la1_1[i] & (1<<j)) != 0) {
			 la1tokens[32+j] = true;
		   }
		   if ((jj_la1_2[i] & (1<<j)) != 0) {
			 la1tokens[64+j] = true;
		   }
		   if ((jj_la1_3[i] & (1<<j)) != 0) {
			 la1tokens[96+j] = true;
		   }
		   if ((jj_la1_4[i] & (1<<j)) != 0) {
			 la1tokens[128+j] = true;
		   }
		   if ((jj_la1_5[i] & (1<<j)) != 0) {
			 la1tokens[160+j] = true;
		   }
		   if ((jj_la1_6[i] & (1<<j)) != 0) {
			 la1tokens[192+j] = true;
		   }
		   if ((jj_la1_7[i] & (1<<j)) != 0) {
			 la1tokens[224+j] = true;
		   }
		   if ((jj_la1_8[i] & (1<<j)) != 0) {
			 la1tokens[256+j] = true;
		   }
		   if ((jj_la1_9[i] & (1<<j)) != 0) {
			 la1tokens[288+j] = true;
		   }
		   if ((jj_la1_10[i] & (1<<j)) != 0) {
			 la1tokens[320+j] = true;
		   }
		   if ((jj_la1_11[i] & (1<<j)) != 0) {
			 la1tokens[352+j] = true;
		   }
		 }
	   }
	 }
	 for (int i = 0; i < 381; i++) {
	   if (la1tokens[i]) {
		 jj_expentry = new int[1];
		 jj_expentry[0] = i;
		 jj_expentries.add(jj_expentry);
	   }
	 }
	 jj_endpos = 0;
	 jj_rescan_token();
	 jj_add_error_token(0, 0);
	 int[][] exptokseq = new int[jj_expentries.size()][];
	 for (int i = 0; i < jj_expentries.size(); i++) {
	   exptokseq[i] = jj_expentries.get(i);
	 }
	 return new ParseException(token, exptokseq, tokenImage, token_source == null ? null : CCJSqlParserTokenManager.lexStateNames[token_source.curLexState]);
  }

  private boolean trace_enabled;

/** Trace enabled. */
  final public boolean trace_enabled() {
	 return trace_enabled;
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

  private void jj_rescan_token() {
	 jj_rescan = true;
	 for (int i = 0; i < 267; i++) {
	   try {
		 JJCalls p = jj_2_rtns[i];

		 do {
		   if (p.gen > jj_gen) {
			 jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
			 switch (i) {
			   case 0: jj_3_1(); break;
			   case 1: jj_3_2(); break;
			   case 2: jj_3_3(); break;
			   case 3: jj_3_4(); break;
			   case 4: jj_3_5(); break;
			   case 5: jj_3_6(); break;
			   case 6: jj_3_7(); break;
			   case 7: jj_3_8(); break;
			   case 8: jj_3_9(); break;
			   case 9: jj_3_10(); break;
			   case 10: jj_3_11(); break;
			   case 11: jj_3_12(); break;
			   case 12: jj_3_13(); break;
			   case 13: jj_3_14(); break;
			   case 14: jj_3_15(); break;
			   case 15: jj_3_16(); break;
			   case 16: jj_3_17(); break;
			   case 17: jj_3_18(); break;
			   case 18: jj_3_19(); break;
			   case 19: jj_3_20(); break;
			   case 20: jj_3_21(); break;
			   case 21: jj_3_22(); break;
			   case 22: jj_3_23(); break;
			   case 23: jj_3_24(); break;
			   case 24: jj_3_25(); break;
			   case 25: jj_3_26(); break;
			   case 26: jj_3_27(); break;
			   case 27: jj_3_28(); break;
			   case 28: jj_3_29(); break;
			   case 29: jj_3_30(); break;
			   case 30: jj_3_31(); break;
			   case 31: jj_3_32(); break;
			   case 32: jj_3_33(); break;
			   case 33: jj_3_34(); break;
			   case 34: jj_3_35(); break;
			   case 35: jj_3_36(); break;
			   case 36: jj_3_37(); break;
			   case 37: jj_3_38(); break;
			   case 38: jj_3_39(); break;
			   case 39: jj_3_40(); break;
			   case 40: jj_3_41(); break;
			   case 41: jj_3_42(); break;
			   case 42: jj_3_43(); break;
			   case 43: jj_3_44(); break;
			   case 44: jj_3_45(); break;
			   case 45: jj_3_46(); break;
			   case 46: jj_3_47(); break;
			   case 47: jj_3_48(); break;
			   case 48: jj_3_49(); break;
			   case 49: jj_3_50(); break;
			   case 50: jj_3_51(); break;
			   case 51: jj_3_52(); break;
			   case 52: jj_3_53(); break;
			   case 53: jj_3_54(); break;
			   case 54: jj_3_55(); break;
			   case 55: jj_3_56(); break;
			   case 56: jj_3_57(); break;
			   case 57: jj_3_58(); break;
			   case 58: jj_3_59(); break;
			   case 59: jj_3_60(); break;
			   case 60: jj_3_61(); break;
			   case 61: jj_3_62(); break;
			   case 62: jj_3_63(); break;
			   case 63: jj_3_64(); break;
			   case 64: jj_3_65(); break;
			   case 65: jj_3_66(); break;
			   case 66: jj_3_67(); break;
			   case 67: jj_3_68(); break;
			   case 68: jj_3_69(); break;
			   case 69: jj_3_70(); break;
			   case 70: jj_3_71(); break;
			   case 71: jj_3_72(); break;
			   case 72: jj_3_73(); break;
			   case 73: jj_3_74(); break;
			   case 74: jj_3_75(); break;
			   case 75: jj_3_76(); break;
			   case 76: jj_3_77(); break;
			   case 77: jj_3_78(); break;
			   case 78: jj_3_79(); break;
			   case 79: jj_3_80(); break;
			   case 80: jj_3_81(); break;
			   case 81: jj_3_82(); break;
			   case 82: jj_3_83(); break;
			   case 83: jj_3_84(); break;
			   case 84: jj_3_85(); break;
			   case 85: jj_3_86(); break;
			   case 86: jj_3_87(); break;
			   case 87: jj_3_88(); break;
			   case 88: jj_3_89(); break;
			   case 89: jj_3_90(); break;
			   case 90: jj_3_91(); break;
			   case 91: jj_3_92(); break;
			   case 92: jj_3_93(); break;
			   case 93: jj_3_94(); break;
			   case 94: jj_3_95(); break;
			   case 95: jj_3_96(); break;
			   case 96: jj_3_97(); break;
			   case 97: jj_3_98(); break;
			   case 98: jj_3_99(); break;
			   case 99: jj_3_100(); break;
			   case 100: jj_3_101(); break;
			   case 101: jj_3_102(); break;
			   case 102: jj_3_103(); break;
			   case 103: jj_3_104(); break;
			   case 104: jj_3_105(); break;
			   case 105: jj_3_106(); break;
			   case 106: jj_3_107(); break;
			   case 107: jj_3_108(); break;
			   case 108: jj_3_109(); break;
			   case 109: jj_3_110(); break;
			   case 110: jj_3_111(); break;
			   case 111: jj_3_112(); break;
			   case 112: jj_3_113(); break;
			   case 113: jj_3_114(); break;
			   case 114: jj_3_115(); break;
			   case 115: jj_3_116(); break;
			   case 116: jj_3_117(); break;
			   case 117: jj_3_118(); break;
			   case 118: jj_3_119(); break;
			   case 119: jj_3_120(); break;
			   case 120: jj_3_121(); break;
			   case 121: jj_3_122(); break;
			   case 122: jj_3_123(); break;
			   case 123: jj_3_124(); break;
			   case 124: jj_3_125(); break;
			   case 125: jj_3_126(); break;
			   case 126: jj_3_127(); break;
			   case 127: jj_3_128(); break;
			   case 128: jj_3_129(); break;
			   case 129: jj_3_130(); break;
			   case 130: jj_3_131(); break;
			   case 131: jj_3_132(); break;
			   case 132: jj_3_133(); break;
			   case 133: jj_3_134(); break;
			   case 134: jj_3_135(); break;
			   case 135: jj_3_136(); break;
			   case 136: jj_3_137(); break;
			   case 137: jj_3_138(); break;
			   case 138: jj_3_139(); break;
			   case 139: jj_3_140(); break;
			   case 140: jj_3_141(); break;
			   case 141: jj_3_142(); break;
			   case 142: jj_3_143(); break;
			   case 143: jj_3_144(); break;
			   case 144: jj_3_145(); break;
			   case 145: jj_3_146(); break;
			   case 146: jj_3_147(); break;
			   case 147: jj_3_148(); break;
			   case 148: jj_3_149(); break;
			   case 149: jj_3_150(); break;
			   case 150: jj_3_151(); break;
			   case 151: jj_3_152(); break;
			   case 152: jj_3_153(); break;
			   case 153: jj_3_154(); break;
			   case 154: jj_3_155(); break;
			   case 155: jj_3_156(); break;
			   case 156: jj_3_157(); break;
			   case 157: jj_3_158(); break;
			   case 158: jj_3_159(); break;
			   case 159: jj_3_160(); break;
			   case 160: jj_3_161(); break;
			   case 161: jj_3_162(); break;
			   case 162: jj_3_163(); break;
			   case 163: jj_3_164(); break;
			   case 164: jj_3_165(); break;
			   case 165: jj_3_166(); break;
			   case 166: jj_3_167(); break;
			   case 167: jj_3_168(); break;
			   case 168: jj_3_169(); break;
			   case 169: jj_3_170(); break;
			   case 170: jj_3_171(); break;
			   case 171: jj_3_172(); break;
			   case 172: jj_3_173(); break;
			   case 173: jj_3_174(); break;
			   case 174: jj_3_175(); break;
			   case 175: jj_3_176(); break;
			   case 176: jj_3_177(); break;
			   case 177: jj_3_178(); break;
			   case 178: jj_3_179(); break;
			   case 179: jj_3_180(); break;
			   case 180: jj_3_181(); break;
			   case 181: jj_3_182(); break;
			   case 182: jj_3_183(); break;
			   case 183: jj_3_184(); break;
			   case 184: jj_3_185(); break;
			   case 185: jj_3_186(); break;
			   case 186: jj_3_187(); break;
			   case 187: jj_3_188(); break;
			   case 188: jj_3_189(); break;
			   case 189: jj_3_190(); break;
			   case 190: jj_3_191(); break;
			   case 191: jj_3_192(); break;
			   case 192: jj_3_193(); break;
			   case 193: jj_3_194(); break;
			   case 194: jj_3_195(); break;
			   case 195: jj_3_196(); break;
			   case 196: jj_3_197(); break;
			   case 197: jj_3_198(); break;
			   case 198: jj_3_199(); break;
			   case 199: jj_3_200(); break;
			   case 200: jj_3_201(); break;
			   case 201: jj_3_202(); break;
			   case 202: jj_3_203(); break;
			   case 203: jj_3_204(); break;
			   case 204: jj_3_205(); break;
			   case 205: jj_3_206(); break;
			   case 206: jj_3_207(); break;
			   case 207: jj_3_208(); break;
			   case 208: jj_3_209(); break;
			   case 209: jj_3_210(); break;
			   case 210: jj_3_211(); break;
			   case 211: jj_3_212(); break;
			   case 212: jj_3_213(); break;
			   case 213: jj_3_214(); break;
			   case 214: jj_3_215(); break;
			   case 215: jj_3_216(); break;
			   case 216: jj_3_217(); break;
			   case 217: jj_3_218(); break;
			   case 218: jj_3_219(); break;
			   case 219: jj_3_220(); break;
			   case 220: jj_3_221(); break;
			   case 221: jj_3_222(); break;
			   case 222: jj_3_223(); break;
			   case 223: jj_3_224(); break;
			   case 224: jj_3_225(); break;
			   case 225: jj_3_226(); break;
			   case 226: jj_3_227(); break;
			   case 227: jj_3_228(); break;
			   case 228: jj_3_229(); break;
			   case 229: jj_3_230(); break;
			   case 230: jj_3_231(); break;
			   case 231: jj_3_232(); break;
			   case 232: jj_3_233(); break;
			   case 233: jj_3_234(); break;
			   case 234: jj_3_235(); break;
			   case 235: jj_3_236(); break;
			   case 236: jj_3_237(); break;
			   case 237: jj_3_238(); break;
			   case 238: jj_3_239(); break;
			   case 239: jj_3_240(); break;
			   case 240: jj_3_241(); break;
			   case 241: jj_3_242(); break;
			   case 242: jj_3_243(); break;
			   case 243: jj_3_244(); break;
			   case 244: jj_3_245(); break;
			   case 245: jj_3_246(); break;
			   case 246: jj_3_247(); break;
			   case 247: jj_3_248(); break;
			   case 248: jj_3_249(); break;
			   case 249: jj_3_250(); break;
			   case 250: jj_3_251(); break;
			   case 251: jj_3_252(); break;
			   case 252: jj_3_253(); break;
			   case 253: jj_3_254(); break;
			   case 254: jj_3_255(); break;
			   case 255: jj_3_256(); break;
			   case 256: jj_3_257(); break;
			   case 257: jj_3_258(); break;
			   case 258: jj_3_259(); break;
			   case 259: jj_3_260(); break;
			   case 260: jj_3_261(); break;
			   case 261: jj_3_262(); break;
			   case 262: jj_3_263(); break;
			   case 263: jj_3_264(); break;
			   case 264: jj_3_265(); break;
			   case 265: jj_3_266(); break;
			   case 266: jj_3_267(); break;
			 }
		   }
		   p = p.next;
		 } while (p != null);

		 } catch(LookaheadSuccess ls) { }
	 }
	 jj_rescan = false;
  }

  private void jj_save(int index, int xla) {
	 JJCalls p = jj_2_rtns[index];
	 while (p.gen > jj_gen) {
	   if (p.next == null) { p = p.next = new JJCalls(); break; }
	   p = p.next;
	 }

	 p.gen = jj_gen + xla - jj_la; 
	 p.first = token;
	 p.arg = xla;
  }

  static final class JJCalls {
	 int gen;
	 Token first;
	 int arg;
	 JJCalls next;
  }

}
