/*
 * Decompiled with CFR 0.152.
 */
package com.jdroid.java.firebase;

import com.firebase.client.DataSnapshot;
import com.firebase.client.FirebaseError;
import com.firebase.client.ValueEventListener;
import com.jdroid.java.exception.UnexpectedException;
import com.jdroid.java.firebase.FirebaseCountDownLatch;
import com.jdroid.java.firebase.FirebaseException;

public class FirebaseValueEventListener
implements ValueEventListener {
    private FirebaseCountDownLatch done = new FirebaseCountDownLatch();

    public void onDataChange(DataSnapshot snapshot) {
        this.done.setDataSnapshot(snapshot);
        this.done.countDown();
    }

    public void onCancelled(FirebaseError firebaseError) {
        this.done.setFirebaseException(new FirebaseException(firebaseError));
        this.done.countDown();
    }

    public void waitOperation() {
        try {
            this.done.await();
            if (this.done.getFirebaseException() != null) {
                throw this.done.getFirebaseException();
            }
        }
        catch (InterruptedException e) {
            throw new UnexpectedException((Throwable)e);
        }
    }

    public DataSnapshot getDataSnapshot() {
        return this.done.getDataSnapshot();
    }
}

