/*
 * Decompiled with CFR 0.152.
 */
package com.jdroid.java.firebase.database.auth;

import com.firebase.client.AuthData;
import com.firebase.client.Firebase;
import com.firebase.client.FirebaseError;
import com.jdroid.java.exception.UnexpectedException;
import com.jdroid.java.firebase.database.FirebaseDatabaseRepository;
import com.jdroid.java.utils.LoggerUtils;
import java.util.concurrent.CountDownLatch;
import org.slf4j.Logger;

public abstract class FirebaseAuthenticationStrategy
implements Firebase.AuthResultHandler {
    private static final Logger LOGGER = LoggerUtils.getLogger(FirebaseDatabaseRepository.class);
    private CountDownLatch countDownLatch;

    public final void authenticate(Firebase firebase) {
        this.countDownLatch = new CountDownLatch(1);
        this.doAuthenticate(firebase);
        try {
            this.countDownLatch.await();
        }
        catch (InterruptedException e) {
            throw new UnexpectedException((Throwable)e);
        }
    }

    protected abstract void doAuthenticate(Firebase var1);

    protected void doOnAuthenticationError(FirebaseError error) {
        throw error.toException();
    }

    protected void doOnAuthenticated(AuthData authData) {
    }

    public final void onAuthenticationError(FirebaseError error) {
        this.getCountDownLatch().countDown();
        this.doOnAuthenticationError(error);
    }

    public final void onAuthenticated(AuthData authData) {
        this.getCountDownLatch().countDown();
        LOGGER.info("Firebase authenticated. " + authData.toString());
        this.doOnAuthenticated(authData);
    }

    public CountDownLatch getCountDownLatch() {
        return this.countDownLatch;
    }
}

