/*
 * Decompiled with CFR 0.152.
 */
package com.jdroid.github.service;

import com.google.gson.reflect.TypeToken;
import com.jdroid.github.IRepositoryIdProvider;
import com.jdroid.github.Label;
import com.jdroid.github.client.GitHubClient;
import com.jdroid.github.client.GitHubRequest;
import com.jdroid.github.client.PagedRequest;
import com.jdroid.github.service.GitHubService;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.List;

public class LabelService
extends GitHubService {
    public LabelService() {
    }

    public LabelService(GitHubClient client) {
        super(client);
    }

    public List<Label> getLabels(IRepositoryIdProvider repository) throws IOException {
        String repoId = this.getId(repository);
        return this.getLabels(repoId);
    }

    public List<Label> getLabels(String user, String repository) throws IOException {
        this.verifyRepository(user, repository);
        String repoId = user + '/' + repository;
        return this.getLabels(repoId);
    }

    private List<Label> getLabels(String id) throws IOException {
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(id);
        uri.append("/labels");
        PagedRequest request = this.createPagedRequest();
        request.setUri(uri);
        request.setType(new TypeToken<List<Label>>(){}.getType());
        return this.getAll(request);
    }

    public List<Label> setLabels(IRepositoryIdProvider repository, String issueId, List<Label> labels) throws IOException {
        String repoId = this.getId(repository);
        return this.setLabels(repoId, issueId, labels);
    }

    public List<Label> setLabels(String user, String repository, String issueId, List<Label> labels) throws IOException {
        this.verifyRepository(user, repository);
        String repoId = user + '/' + repository;
        return this.setLabels(repoId, issueId, labels);
    }

    private List<Label> setLabels(String id, String issueId, List<Label> labels) throws IOException {
        if (issueId == null) {
            throw new IllegalArgumentException("Issue id cannot be null");
        }
        if (issueId.length() == 0) {
            throw new IllegalArgumentException("Issue id cannot be empty");
        }
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(id);
        uri.append("/issues");
        uri.append('/').append(issueId);
        uri.append("/labels");
        return (List)this.client.put(uri.toString(), labels, new TypeToken<List<Label>>(){}.getType());
    }

    public Label createLabel(IRepositoryIdProvider repository, Label label) throws IOException {
        String repoId = this.getId(repository);
        return this.createLabel(repoId, label);
    }

    public Label createLabel(String user, String repository, Label label) throws IOException {
        this.verifyRepository(user, repository);
        String repoId = user + '/' + repository;
        return this.createLabel(repoId, label);
    }

    private Label createLabel(String id, Label label) throws IOException {
        if (label == null) {
            throw new IllegalArgumentException("Label cannot be null");
        }
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(id);
        uri.append("/labels");
        return (Label)this.client.post(uri.toString(), label, (Type)((Object)Label.class));
    }

    public Label getLabel(IRepositoryIdProvider repository, String label) throws IOException {
        String repoId = this.getId(repository);
        return this.getLabel(repoId, label);
    }

    public Label getLabel(String user, String repository, String label) throws IOException {
        this.verifyRepository(user, repository);
        String repoId = user + '/' + repository;
        return this.getLabel(repoId, label);
    }

    private Label getLabel(String id, String label) throws IOException {
        if (label == null) {
            throw new IllegalArgumentException("Label cannot be null");
        }
        if (label.length() == 0) {
            throw new IllegalArgumentException("Label cannot be empty");
        }
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(id);
        uri.append("/labels");
        uri.append('/').append(label);
        GitHubRequest request = this.createRequest();
        request.setUri(uri);
        request.setType((Type)((Object)Label.class));
        return (Label)this.client.get(request).getBody();
    }

    public void deleteLabel(IRepositoryIdProvider repository, String label) throws IOException {
        String repoId = this.getId(repository);
        this.deleteLabel(repoId, label);
    }

    public void deleteLabel(String user, String repository, String label) throws IOException {
        this.verifyRepository(user, repository);
        String repoId = user + '/' + repository;
        this.deleteLabel(repoId, label);
    }

    private void deleteLabel(String id, String label) throws IOException {
        if (label == null) {
            throw new IllegalArgumentException("Label cannot be null");
        }
        if (label.length() == 0) {
            throw new IllegalArgumentException("Label cannot be empty");
        }
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(id);
        uri.append("/labels");
        uri.append('/').append(label);
        this.client.delete(uri.toString());
    }

    public Label editLabel(IRepositoryIdProvider repository, Label label) throws IOException {
        String repoId = this.getId(repository);
        if (label == null) {
            throw new IllegalArgumentException("Label cannot be null");
        }
        String name = label.getName();
        if (name == null) {
            throw new IllegalArgumentException("Label name cannot be null");
        }
        if (name.length() == 0) {
            throw new IllegalArgumentException("Label name cannot be empty");
        }
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(repoId);
        uri.append("/labels");
        uri.append('/').append(name);
        return (Label)this.client.post(uri.toString(), label, (Type)((Object)Label.class));
    }
}

