package com.jpattern.orm;

import java.sql.ResultSet;

/**
 * @author Francesco Cina
 *
 * 22/mag/2011
 * 
 * The bytecode of classes implementing this interface is generated at runtime using asm
 *  
 */
public interface IOrmPersistor<T> {
	
	T mapRow(String rowNamePrefix, ResultSet rs, int rowNum);
	
	Object[] allValues(T entity);
	
	Object[] allNotGeneratedValues(T entity);
	
	Object[] primaryKeyValues(T entity);
	
	Object[] notPrimaryKeyValues(T entity);
	
	void updatePrimaryKey(ResultSet rs, T entity);
	
}
