package com.jpattern.orm;

import java.util.HashMap;
import java.util.Map;

import com.jpattern.orm.exception.OrmException;


/**
 * 
 * @author Francesco Cina
 *
 * 22/mag/2011
 */
public class OrmClassToolMap implements IOrmClassToolMap {

	private Map<Class<?>, IOrmClassTool<?>> classToolMap = new HashMap<Class<?>, IOrmClassTool<?>>();

	@Override
	public <T> void put(Class<T> clazz, IOrmClassTool<T> ormClassTool) {
		classToolMap.put(clazz, ormClassTool);
	}

	@Override
	public boolean containsTool(Class<?> clazz) {
		return classToolMap.containsKey(clazz);
	}

	@SuppressWarnings("unchecked")
	@Override
	public <T> IOrmClassTool<T> getOrmClassTool(Class<T> clazz) throws OrmException {
		IOrmClassTool<?> ormClazzTool = classToolMap.get(clazz);
		if (ormClazzTool==null) {
			throw new OrmException("Class " + clazz.getName() + " is not registered as an ORM entity!");
		}
		return (IOrmClassTool<T>) classToolMap.get(clazz);
	}

}
