package com.jpattern.orm.crud;

import com.jpattern.orm.dialect.IDialect;

/**
 * 
 * @author Francesco Cina
 *
 * 05/giu/2011
 */
public abstract class AColumnValueGenerator {
	
	private final String name;
	private int cacheSize = 0;
	private String generatedColumnName;

	public AColumnValueGenerator(String name) {
		this.name = name;
	}

	public String getName() {
		return name;
	}
	
	public void setCacheSize(int cacheSize) {
		this.cacheSize = cacheSize;
	}

	public int getCacheSize() {
		return cacheSize;
	}
	
	public void setGeneratedColumnName(String generatedColumnName) {
		this.generatedColumnName = generatedColumnName;
	}

	public String getGeneratedColumnName() {
		return generatedColumnName;
	}
	
	public abstract String insertQueryParameter(IDialect dialect, String currentValue);
	
	public abstract boolean returnGeneratedKeys();
	
	public abstract boolean isAutoGenerated();
	
}
