package com.jpattern.orm.crud;

/**
 * 
 * @author Francesco Cina
 *
 * 22/mag/2011
 */
public interface IOrmCRUDQuery {

	/**
	 * The pregenerated query to load an entity
	 * @return
	 */
	String getLoadQuery();

	/**
	 * The pregenerated query to save an entity
	 * @return
	 */
	String getSaveQuery();
	
	/**
	 * The pregenerated query to delete an entity
	 * @return
	 */
	String getDeleteQuery();
	
	/**
	 * The pregenerated query to update an entity
	 * @return
	 */
	String getUpdateQuery();
	
	/**
	 * Return the ordered names of the columns using as alias
	 * for the table the complete table name (with the schema name
	 * if exists). This is used to create custom select query   
	 * @return
	 */
	String getBaseSelectClause();
	
	/**
	 * It wokrs like getBaseSelectClause() but instead of using the
	 * complete table name as alias it uses a custom prefix to prepend 
	 * to the column names 
	 * @param rowNamePrefix
	 * @return
	 */
	String getBaseSelectClause(String rowNamePrefix);
	
	/**
	 * Return the name of the table (with the schema name
	 * if exists)
	 * @return
	 */
	String getBaseFromClause();
	
	/**
	 * Return whether in the save query there are automatically 
	 * generated key (for example using a call to a Sequence in the 
	 * insert query) 
	 * @return
	 */
	boolean generatedKey();
	
}
