package com.jpattern.orm.generator;

import com.jpattern.org.cojen.classfile.ClassFile;
import com.jpattern.org.cojen.classfile.CodeBuilder;
import com.jpattern.org.cojen.classfile.Label;
import com.jpattern.org.cojen.classfile.LocalVariable;
import com.jpattern.org.cojen.classfile.MethodInfo;
import com.jpattern.org.cojen.classfile.Modifiers;
import com.jpattern.org.cojen.classfile.TypeDesc;
import com.jpattern.orm.exception.OrmConfigurationException;
import com.jpattern.orm.mapper.IClassMapper;

/**
 * 
 * @author Francesco Cina
 *
 * 04/giu/2011
 */
public class CojenPersistorDump<T> {
	
	private static final String MAP_ROW_METHOD_NAME = "mapRow";
	private static final String PRIMARY_KEY_VALUES_METHOD_NAME = "primaryKeyValues";
	private static final String NOT_PRIMARY_KEY_VALUES_METHOD_NAME = "notPrimaryKeyValues";
	private static final String ALL_VALUES_METHOD_NAME = "allValues";
	private static final String ALL_NOT_GENERATED_VALUES_METHOD_NAME = "allNotGeneratedValues";
	private static final String UPDATE_PRIMARY_KEY_METHOD_NAME = "updatePrimaryKey";
	
    private final String className;
	private final IClassMapper<T> classMapper;

	public CojenPersistorDump(String className, IClassMapper<T> classMapper) {
		this.className = className;
		this.classMapper = classMapper;
	}

	public ClassFile createClassFile() throws SecurityException, NoSuchMethodException, OrmConfigurationException {
        ClassFile cf = new ClassFile(className, java.lang.Object.class.getName());
        cf.setTarget("1.6");
        cf.addInterface(com.jpattern.orm.IOrmPersistor.class.getName());

        //
        // Create constructors
        //

        // public void <init>()
        createConstructor_1(cf);

        //
        // Create methods
        //

        // public java.lang.Object mapRow(java.lang.String, java.sql.ResultSet, int)
        createMethod_1(cf);

        // public java.lang.Object[] allValues(java.lang.Object)
        createMethod_2(cf);

        // public java.lang.Object[] primaryKeyValues(java.lang.Object)
        createMethod_3(cf);

        // public java.lang.Object[] notPrimaryKeyValues(java.lang.Object)
        createMethod_4(cf);

        // public void updatePrimaryKey(java.sql.ResultSet, java.lang.Object)
        createMethod_5(cf);
        
        // public volatile java.lang.Object[] notPrimaryKeyValues(java.lang.Object)
        createMethod_6(cf);

        // public volatile java.lang.Object[] allValues(java.lang.Object)
        createMethod_7(cf);

        // public volatile java.lang.Object[] primaryKeyValues(java.lang.Object)
        createMethod_8(cf);

        // public volatile java.lang.Object mapRow(java.lang.String, java.sql.ResultSet, int)
        createMethod_9(cf);
        
        // public volatile void updatePrimaryKey(java.sql.ResultSet, java.lang.Object)
        createMethod_10(cf);
        
        // public java.lang.Object[] allNotGeneratedValues(java.lang.Object)
        createMethod_11(cf);
        
        // public volatile java.lang.Object[] allNotGeneratedValues(java.lang.Object)
        createMethod_12(cf);

        return cf;
    }

    // public void <init>()
    private void createConstructor_1(ClassFile cf) {
        MethodInfo mi = cf.addConstructor(Modifiers.PUBLIC, null);
        CodeBuilder b = new CodeBuilder(mi);
        b.loadThis();
        b.invokeSuperConstructor(null);
        b.returnVoid();
    }

    // public java.lang.Object mapRow(java.sql.ResultSet, int)
    private void createMethod_1(ClassFile cf) throws SecurityException, NoSuchMethodException, OrmConfigurationException {
        MethodInfo mi = cf.addMethod(Modifiers.PUBLIC, MAP_ROW_METHOD_NAME, TypeDesc.forClass(classMapper.getMappedClass().getName()), new TypeDesc[] {TypeDesc.STRING, TypeDesc.forClass(java.sql.ResultSet.class.getName()), TypeDesc.INT});
        CodeBuilder b = new CodeBuilder(mi);

        LocalVariable var_1 = b.getParameter(0);
        LocalVariable var_2 = b.getParameter(1);
//        LocalVariable var_3 = b.getParameter(2);

        TypeDesc type_1 = TypeDesc.forClass(classMapper.getMappedClass().getName());
        b.newObject(type_1);
        b.dup();
        b.invokeConstructor(classMapper.getMappedClass().getName(), null);
        LocalVariable var_4 = b.createLocalVariable(null, TypeDesc.OBJECT);
        b.storeLocal(var_4);
        
        Label label_1 = b.createLabel();
        label_1.setLocation();
        
        String[] allColumnNames = classMapper.getAllColumnJavaNames();
        for (String columnName : allColumnNames) {
            b.loadLocal(var_4);
            b.loadLocal(var_2);
        	new SetterDumpFactory().visit(b, var_1, classMapper, columnName); 
        }
        
        Label label_2 = b.createLabel();
        label_2.setLocation();
        Label label_3 = b.createLabel();
        b.branch(label_3);

        b.exceptionHandler(label_1, label_2, java.lang.Exception.class.getName());
        LocalVariable var_5 = b.createLocalVariable(null, TypeDesc.OBJECT);
        b.storeLocal(var_5);

        TypeDesc type_2 = TypeDesc.forClass(com.jpattern.orm.exception.OrmException.class.getName());
        b.newObject(type_2);
        b.dup();
        b.loadLocal(var_5);
        TypeDesc type_3 = TypeDesc.forClass(java.lang.Exception.class.getName());
        TypeDesc[] params_4 = new TypeDesc[] {type_3};
        b.invokeConstructor(com.jpattern.orm.exception.OrmException.class.getName(), params_4);
        b.throwObject();

        label_3.setLocation();
        b.loadLocal(var_4);
        b.returnValue(TypeDesc.OBJECT);
    }

    // public java.lang.Object[] allValues(java.lang.Object)
    private void createMethod_2(ClassFile cf) {
        MethodInfo mi = cf.addMethod(Modifiers.PUBLIC, ALL_VALUES_METHOD_NAME, TypeDesc.OBJECT.toArrayType(), new TypeDesc[] {TypeDesc.forClass(classMapper.getMappedClass().getName())});
        CodeBuilder b = new CodeBuilder(mi);
        LocalVariable var_1 = b.getParameter(0);
        
        String[] allColumnNames = classMapper.getAllColumnJavaNames();
        b.loadConstant(allColumnNames.length);
        TypeDesc type_1 = TypeDesc.OBJECT.toArrayType();
        b.newObject(type_1);
        
        int count = 0;
        for (String columnName : allColumnNames) {
        	new GetterDumpFactory().visit(b, count++, var_1, classMapper, columnName); 
        }
        
        LocalVariable var_2 = b.createLocalVariable(null, TypeDesc.OBJECT);
        b.storeLocal(var_2);
        b.loadLocal(var_2);
        b.returnValue(TypeDesc.OBJECT);
    }

    // public java.lang.Object[] primaryKeyValues(java.lang.Object)
    private void createMethod_3(ClassFile cf) {
        MethodInfo mi = cf.addMethod(Modifiers.PUBLIC, PRIMARY_KEY_VALUES_METHOD_NAME, TypeDesc.OBJECT.toArrayType(), new TypeDesc[] {TypeDesc.forClass(classMapper.getMappedClass().getName())});
        CodeBuilder b = new CodeBuilder(mi);
        LocalVariable var_1 = b.getParameter(0);

        String[] primaryKeyColumnNames = classMapper.getPrimaryKeyColumnJavaNames();
        b.loadConstant(primaryKeyColumnNames.length);
        TypeDesc type_1 = TypeDesc.OBJECT.toArrayType();
        b.newObject(type_1);
        
        int count = 0;
        for (String columnName : primaryKeyColumnNames) {
        	new GetterDumpFactory().visit(b, count++, var_1, classMapper, columnName); 
        }
        
        LocalVariable var_2 = b.createLocalVariable(null, TypeDesc.OBJECT);
        b.storeLocal(var_2);
        b.loadLocal(var_2);
        b.returnValue(TypeDesc.OBJECT);
    }

    // public java.lang.Object[] notPrimaryKeyValues(java.lang.Object)
    private void createMethod_4(ClassFile cf) {
        MethodInfo mi = cf.addMethod(Modifiers.PUBLIC, NOT_PRIMARY_KEY_VALUES_METHOD_NAME, TypeDesc.OBJECT.toArrayType(), new TypeDesc[] {TypeDesc.forClass(classMapper.getMappedClass().getName())});
        CodeBuilder b = new CodeBuilder(mi);
        LocalVariable var_1 = b.getParameter(0);

        String[] notPrimaryKeyColumnNames = classMapper.getNotPrimaryKeyColumnJavaNames();
        b.loadConstant(notPrimaryKeyColumnNames.length);
        TypeDesc type_1 = TypeDesc.OBJECT.toArrayType();
        b.newObject(type_1);
        
        int count = 0;
        for (String columnName : notPrimaryKeyColumnNames) {
        	new GetterDumpFactory().visit(b, count++, var_1, classMapper, columnName); 
        }
        
        LocalVariable var_2 = b.createLocalVariable(null, TypeDesc.OBJECT);
        b.storeLocal(var_2);
        b.loadLocal(var_2);
        b.returnValue(TypeDesc.OBJECT);
    }

    // public void updatePrimaryKey(java.sql.ResultSet, java.lang.Object)
    private void createMethod_5(ClassFile cf) throws SecurityException, NoSuchMethodException, OrmConfigurationException {
        MethodInfo mi = cf.addMethod(Modifiers.PUBLIC, UPDATE_PRIMARY_KEY_METHOD_NAME, null, new TypeDesc[] {TypeDesc.forClass(java.sql.ResultSet.class.getName()), TypeDesc.forClass(classMapper.getMappedClass().getName())});
        CodeBuilder b = new CodeBuilder(mi);

        LocalVariable var_1 = b.getParameter(0);
        LocalVariable var_2 = b.getParameter(1);

        String[] allColumnNames = classMapper.getAllGeneratedColumnJavaNames();
        
        if (allColumnNames.length > 0) {
	        Label label_1 = b.createLabel();
	        label_1.setLocation();
	        
	        
	        int count = 1;
	        for (String columnName : allColumnNames) {
	       		b.loadLocal(var_2);
	           	b.loadLocal(var_1);
	       		new SetterDumpFactory().visit(b, classMapper, columnName, count++);
	        }
	        
	        Label label_2 = b.createLabel();
	        label_2.setLocation();
	        Label label_3 = b.createLabel();
	        b.branch(label_3);
	
	        b.exceptionHandler(label_1, label_2, java.lang.Exception.class.getName());
	        LocalVariable var_3 = b.createLocalVariable(null, TypeDesc.OBJECT);
	        b.storeLocal(var_3);
	
	        TypeDesc type_1 = TypeDesc.forClass(com.jpattern.orm.exception.OrmException.class.getName());
	        b.newObject(type_1);
	        b.dup();
	        b.loadLocal(var_3);
	        TypeDesc type_2 = TypeDesc.forClass(java.lang.Exception.class.getName());
	        TypeDesc[] params_3 = new TypeDesc[] {type_2};
	        b.invokeConstructor(com.jpattern.orm.exception.OrmException.class.getName(), params_3);
	        b.throwObject();
	
	        label_3.setLocation();
        }
        b.returnVoid();
        
    }
    
    // public volatile java.lang.Object[] notPrimaryKeyValues(java.lang.Object)
    private void createMethod_6(ClassFile cf) {
        MethodInfo mi = cf.addMethod(Modifiers.PUBLIC.toVolatile(true), NOT_PRIMARY_KEY_VALUES_METHOD_NAME, TypeDesc.OBJECT.toArrayType(), new TypeDesc[] {TypeDesc.OBJECT});
        CodeBuilder b = new CodeBuilder(mi);

        LocalVariable var_1 = b.getParameter(0);

        b.loadThis();
        b.loadLocal(var_1);
        TypeDesc type_1 = TypeDesc.forClass(classMapper.getMappedClass().getName());
        b.checkCast(type_1);
        TypeDesc type_2 = TypeDesc.OBJECT.toArrayType();
        TypeDesc[] params_1 = new TypeDesc[] {type_1};
        b.invokeVirtual(NOT_PRIMARY_KEY_VALUES_METHOD_NAME, type_2, params_1);
        b.returnValue(TypeDesc.OBJECT);
    }

    // public volatile java.lang.Object[] allValues(java.lang.Object)
    private void createMethod_7(ClassFile cf) {
        MethodInfo mi = cf.addMethod(Modifiers.PUBLIC.toVolatile(true), ALL_VALUES_METHOD_NAME, TypeDesc.OBJECT.toArrayType(), new TypeDesc[] {TypeDesc.OBJECT});
        CodeBuilder b = new CodeBuilder(mi);

        LocalVariable var_1 = b.getParameter(0);

        b.loadThis();
        b.loadLocal(var_1);
        TypeDesc type_1 = TypeDesc.forClass(classMapper.getMappedClass().getName());
        b.checkCast(type_1);
        TypeDesc type_2 = TypeDesc.OBJECT.toArrayType();
        TypeDesc[] params_1 = new TypeDesc[] {type_1};
        b.invokeVirtual(ALL_VALUES_METHOD_NAME, type_2, params_1);
        b.returnValue(TypeDesc.OBJECT);
    }

    // public volatile java.lang.Object[] primaryKeyValues(java.lang.Object)
    private void createMethod_8(ClassFile cf) {
        MethodInfo mi = cf.addMethod(Modifiers.PUBLIC.toVolatile(true), PRIMARY_KEY_VALUES_METHOD_NAME, TypeDesc.OBJECT.toArrayType(), new TypeDesc[] {TypeDesc.OBJECT});
        CodeBuilder b = new CodeBuilder(mi);

        LocalVariable var_1 = b.getParameter(0);

        b.loadThis();
        b.loadLocal(var_1);
        TypeDesc type_1 = TypeDesc.forClass(classMapper.getMappedClass().getName());
        b.checkCast(type_1);
        TypeDesc type_2 = TypeDesc.OBJECT.toArrayType();
        TypeDesc[] params_1 = new TypeDesc[] {type_1};
        b.invokeVirtual(PRIMARY_KEY_VALUES_METHOD_NAME, type_2, params_1);
        b.returnValue(TypeDesc.OBJECT);
    }

    //public volatile java.lang.Object mapRow(java.lang.String, java.sql.ResultSet, int)
    private void createMethod_9(ClassFile cf) {
//        MethodInfo mi = cf.addMethod(Modifiers.PUBLIC.toVolatile(true), MAP_ROW_METHOD_NAME, TypeDesc.OBJECT, new TypeDesc[] {TypeDesc.forClass(java.sql.ResultSet.class.getName()), TypeDesc.INT});
//        CodeBuilder b = new CodeBuilder(mi);
//
//        LocalVariable var_1 = b.getParameter(0);
//        LocalVariable var_2 = b.getParameter(1);
//
//        b.loadThis();
//        b.loadLocal(var_1);
//        b.loadLocal(var_2);
//        TypeDesc type_1 = TypeDesc.forClass(classMapper.getMappedClass().getName());
//        TypeDesc type_2 = TypeDesc.forClass(java.sql.ResultSet.class.getName());
//        TypeDesc[] params_1 = new TypeDesc[] {type_2, TypeDesc.INT};
//        b.invokeVirtual(MAP_ROW_METHOD_NAME, type_1, params_1);
//        b.returnValue(TypeDesc.OBJECT);
    	
        MethodInfo mi = cf.addMethod(Modifiers.PUBLIC.toVolatile(true), MAP_ROW_METHOD_NAME, TypeDesc.OBJECT, new TypeDesc[] {TypeDesc.STRING, TypeDesc.forClass(java.sql.ResultSet.class.getName()), TypeDesc.INT});
        CodeBuilder b = new CodeBuilder(mi);

        LocalVariable var_1 = b.getParameter(0);
        LocalVariable var_2 = b.getParameter(1);
        LocalVariable var_3 = b.getParameter(2);

        b.loadThis();
        b.loadLocal(var_1);
        b.loadLocal(var_2);
        b.loadLocal(var_3);
        TypeDesc type_1 = TypeDesc.forClass(classMapper.getMappedClass().getName());
        TypeDesc type_2 = TypeDesc.forClass(java.sql.ResultSet.class.getName());
        TypeDesc[] params_1 = new TypeDesc[] {TypeDesc.STRING, type_2, TypeDesc.INT};
        b.invokeVirtual(MAP_ROW_METHOD_NAME, type_1, params_1);
        b.returnValue(TypeDesc.OBJECT);
    	
    }
    
    // public volatile void updatePrimaryKey(java.sql.ResultSet, java.lang.Object)
    private void createMethod_10(ClassFile cf) {
        MethodInfo mi = cf.addMethod(Modifiers.PUBLIC.toVolatile(true), UPDATE_PRIMARY_KEY_METHOD_NAME, null, new TypeDesc[] {TypeDesc.forClass(java.sql.ResultSet.class.getName()), TypeDesc.OBJECT});
        CodeBuilder b = new CodeBuilder(mi);

        LocalVariable var_1 = b.getParameter(0);
        LocalVariable var_2 = b.getParameter(1);

        b.loadThis();
        b.loadLocal(var_1);
        b.loadLocal(var_2);
        TypeDesc type_1 = TypeDesc.forClass(classMapper.getMappedClass().getName());
        b.checkCast(type_1);
        TypeDesc type_2 = TypeDesc.forClass(java.sql.ResultSet.class.getName());
        TypeDesc[] params_1 = new TypeDesc[] {type_2, type_1};
        b.invokeVirtual(UPDATE_PRIMARY_KEY_METHOD_NAME, null, params_1);
        b.returnVoid();
    }
    
    // public java.lang.Object[] allNotGeneratedValues(java.lang.Object)
    private void createMethod_11(ClassFile cf) {
        
        MethodInfo mi = cf.addMethod(Modifiers.PUBLIC, ALL_NOT_GENERATED_VALUES_METHOD_NAME, TypeDesc.OBJECT.toArrayType(), new TypeDesc[] {TypeDesc.forClass(classMapper.getMappedClass().getName())});
        CodeBuilder b = new CodeBuilder(mi);
        LocalVariable var_1 = b.getParameter(0);
        
        String[] allNotGeneratedColumnNames = classMapper.getAllNotGeneratedColumnJavaNames();
        b.loadConstant(allNotGeneratedColumnNames.length);
        TypeDesc type_1 = TypeDesc.OBJECT.toArrayType();
        b.newObject(type_1);
        
        int count = 0;
        for (String columnName : allNotGeneratedColumnNames) {
        	new GetterDumpFactory().visit(b, count++, var_1, classMapper, columnName); 
        }
        
        LocalVariable var_2 = b.createLocalVariable(null, TypeDesc.OBJECT);
        b.storeLocal(var_2);
        b.loadLocal(var_2);
        b.returnValue(TypeDesc.OBJECT);
    }
    
    // public volatile java.lang.Object[] allNotGeneratedValues(java.lang.Object)
    private void createMethod_12(ClassFile cf) {
        MethodInfo mi = cf.addMethod(Modifiers.PUBLIC.toVolatile(true), ALL_NOT_GENERATED_VALUES_METHOD_NAME, TypeDesc.OBJECT.toArrayType(), new TypeDesc[] {TypeDesc.OBJECT});
        CodeBuilder b = new CodeBuilder(mi);

        LocalVariable var_1 = b.getParameter(0);

        b.mapLineNumber(1);
        b.loadThis();
        b.loadLocal(var_1);
        TypeDesc type_1 = TypeDesc.forClass(classMapper.getMappedClass().getName());
        b.checkCast(type_1);
        TypeDesc type_2 = TypeDesc.OBJECT.toArrayType();
        TypeDesc[] params_1 = new TypeDesc[] {type_1};
        b.invokeVirtual(ALL_NOT_GENERATED_VALUES_METHOD_NAME, type_2, params_1);
        b.returnValue(TypeDesc.OBJECT);
    }
}
