package com.jpattern.orm.generator;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Date;


import com.jpattern.org.cojen.classfile.ClassFile;
import com.jpattern.orm.IOrmPersistor;
import com.jpattern.orm.exception.OrmConfigurationException;
import com.jpattern.orm.mapper.IClassMapper;

/**
 * 
 * @author Francesco Cina
 *
 * 31/mag/2011
 */
public class CojenPersistorGenerator<T> implements IPersistorGenerator<T> {

	private static String generatedPackage = CojenPersistorGenerator.class.getPackage() + "/generated_" + new Date().getTime() + "/";
	
	private final IClassMapper<T> classMapper;

	public CojenPersistorGenerator(IClassMapper<T> classMapper) {
		this.classMapper = classMapper;
	}
	
	@SuppressWarnings("unchecked")
	@Override
	public IOrmPersistor<T> generate() throws SecurityException, NoSuchMethodException, OrmConfigurationException, IOException, InstantiationException, IllegalAccessException {
		String className = generatedPackage + classMapper.getClass().getSimpleName() + "_" +  this.getClass().getSimpleName() + "_" + new Date().getTime();
		
		ClassFile cf = new CojenPersistorDump<T>(className, classMapper).createClassFile();
		ByteArrayOutputStream out = new ByteArrayOutputStream();
		cf.writeTo(out);
		
		IClassLoader classLoader = new ThreadClassLoader();
		Class<?> result = classLoader.define(className.replace('/', '.'), out.toByteArray());
		return (IOrmPersistor<T>) result.newInstance();
	}

}
