package com.jpattern.orm.generator;

import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.RowId;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Map;
import java.util.HashMap;

import com.jpattern.orm.exception.OrmConfigurationException;

/**
 * 
 * @author Francesco Cina
 * 
 *         06/giu/2011
 */
public final class MethodHelper {

	private static boolean initialized = false;
	private static Map<Class<?>, Method> resultSetGetterForInt = new HashMap<Class<?>, Method>();
	private static Map<Class<?>, Method> resultSetGetterForString = new HashMap<Class<?>, Method>();

	private static void init() throws SecurityException, NoSuchMethodException {
		if (!initialized) {
			addGetter(Array.class, "getArray");
			addGetter(BigDecimal.class, "getBigDecimal");
			addGetter(InputStream.class, "getBinaryStream");
			addGetter(Blob.class, "getBlob");
			addGetter(Boolean.TYPE, "getBoolean");
			addGetter(Boolean.class, "getBoolean");
			addGetter(Byte.TYPE, "getByte");
			addGetter(Byte.class, "getByte");
			addGetter(byte[].class, "getBytes");
			addGetter(Reader.class, "getCharacterStream");
			addGetter(Clob.class, "getClob");
			addGetter(Date.class, "getDate");
			addGetter(Double.TYPE, "getDouble");
			addGetter(Double.class, "getDouble");
			addGetter(Float.TYPE, "getFloat");
			addGetter(Float.class, "getFloat");
			addGetter(Integer.TYPE, "getInt");
			addGetter(Integer.class, "getInt");
			addGetter(Long.TYPE, "getLong");
			addGetter(Long.class, "getLong");
			addGetter(NClob.class, "getNClob");
			addGetter(Object.class, "getObject");
			addGetter(Ref.class, "getRef");
			addGetter(RowId.class, "getRowId");
			addGetter(Short.TYPE, "getShort");
			addGetter(Short.class, "getShort");
			addGetter(SQLXML.class, "getSQLXML");
			addGetter(String.class, "getString");
			addGetter(Time.class, "getTime");
			addGetter(Timestamp.class, "getTimestamp");
			addGetter(URL.class, "getURL");
		}
	}

	public static final Method findResultSetGetterForString(final Class<?> type) throws SecurityException, NoSuchMethodException, OrmConfigurationException {
		init();
		if (resultSetGetterForString.containsKey(type)) {
			return resultSetGetterForString.get(type);
		} else {
			throw new OrmConfigurationException("Type [" + type + "] is not supported at this time");
		}
	}

	public static final Method findResultSetGetterForInt(final Class<?> type) throws SecurityException, NoSuchMethodException, OrmConfigurationException {
		init();
		if (resultSetGetterForInt.containsKey(type)) {
			return resultSetGetterForInt.get(type);
		} else {
			throw new OrmConfigurationException("Type [" + type + "] is not supported at this time");
		}
	}

	private static void addGetter(Class<?> key, String resultSetMethodName) throws SecurityException, NoSuchMethodException {
		resultSetGetterForInt.put(key, ResultSet.class.getMethod(resultSetMethodName, new Class[] { int.class }));
		resultSetGetterForString.put(key, ResultSet.class.getMethod(resultSetMethodName, new Class[] { String.class }));
	}
}
