package com.jpattern.orm.logger;

import com.jpattern.logger.ILogger;
import com.jpattern.logger.ILoggerFactory;
import com.jpattern.logger.NullLoggerFactory;

/**
 * 
 * @author Francesco Cina
 *
 * 04/giu/2011
 */
public abstract class OrmLogger {

	private static ILoggerFactory ormLoggerFactory;

	public static void setOrmLoggerFactory(ILoggerFactory ormLoggerFactory) {
		OrmLogger.ormLoggerFactory = ormLoggerFactory;
	}

	public static ILogger getOrmLogger(Class<?> clazz) {
		if ( ormLoggerFactory == null ) {
			ormLoggerFactory = new NullLoggerFactory();
		}
		return ormLoggerFactory.logger(clazz);
	}
	
}
