package com.jpattern.orm.mapper;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

import com.jpattern.orm.annotation.Column;
import com.jpattern.orm.annotation.Generator;
import com.jpattern.orm.annotation.Id;
import com.jpattern.orm.annotation.Schema;
import com.jpattern.orm.annotation.Table;
import com.jpattern.orm.crud.AColumnValueGenerator;
import com.jpattern.orm.crud.NullColumnValueGenerator;
import com.jpattern.orm.crud.ColumnValueGeneratorFactory;
import com.jpattern.orm.util.FieldDefaultNaming;

/**
 * 
 * @author Francesco Cina
 *
 * 08/giu/2011
 */
public class ClassTableMapBuilder implements ITableMapBuilder {

	private final Class<?> clazz;
	private final TableMap tableMap;

	public ClassTableMapBuilder(Class<?> clazz, TableMap tableMap) {
		this.clazz = clazz;
		this.tableMap = tableMap;
	}
	
	@Override
	public void updateTableMap() {
		generateTableName(tableMap);
		generateSchemaName(tableMap);
		generateColumnNames(tableMap);
	}

	private void generateColumnNames(TableMap tableMap) {
		Field[] fields = clazz.getDeclaredFields();
		for (Field field : fields) {
			if (!Modifier.isStatic( field.getModifiers() ) ) {
				AColumnValueGenerator columnValueGenerator = new NullColumnValueGenerator("");
				String columnName = FieldDefaultNaming.getJavanameToDBnameDefaultMapping(field.getName());
				Id id = field.getAnnotation(Id.class);
				Column column = field.getAnnotation(Column.class);
				Generator generator = field.getAnnotation(Generator.class);
				if (id!=null) {
					tableMap.addPrimaryKey(field.getName());
				}
				if (column!=null) {
					columnName = column.name();
				}
				if (generator!=null) {
					columnValueGenerator = ColumnValueGeneratorFactory.generator(generator.generatorType(), generator.name());
					columnValueGenerator.setCacheSize(generator.getCacheSize());
					columnValueGenerator.setGeneratedColumnName(columnName);
				}
				tableMap.addColumnMapping(field.getName(), columnName, columnValueGenerator);
			}
		}
		
	}

	private void generateTableName(TableMap tableMap) {
		String tableName =  FieldDefaultNaming.getJavanameToDBnameDefaultMapping(clazz.getSimpleName());
		Table annotation = clazz.getAnnotation(Table.class);
		if ( annotation != null) {
			tableName = annotation.name();
		}
		tableMap.setTableName( tableName );
	}
	
	private void generateSchemaName(TableMap tableMap) {
		Schema annotation = clazz.getAnnotation(Schema.class);
		if ( annotation != null) {
			tableMap.setSchemaName(annotation.name());
		}
	}
	
}
