package com.jpattern.orm.mapper;

import java.lang.reflect.Field;
import java.lang.reflect.Method;


/**
 * la rappresentazione della colonna
 * 
 * @author Claudio Quaresima - claudio.quaresima@gmail.com - 11/ago/08 17:16:34
 * @version $Id: $
 */
public final class Column implements IColumn {

    private static final long serialVersionUID = 1L;

    private Method getter;
    private Method setter;
    private String name;

	private boolean identifying = false;

	private Field field;
    
    public Column(String columnName) {
        this.name = columnName;
    }

    @Override
	public String getName() {
        return name;
    }
    
    @Override
	public boolean isIdentifying()
    {
        return identifying ;
    }
    
    @Override
	public Method getGetter() {
        return getter;
    }

	public void setGetter(Method getter) {
        this.getter = getter;
    }

    @Override
	public Method getSetter() {
        return setter;
    }

	public void setSetter(Method setter) {
        this.setter = setter;
    }

	public void setIdentifying(boolean identifying) {
		this.identifying = identifying;
	}

	public void setField(Field field) {
		this.field = field;
	}

	@Override
	public Field getField() {
		return field;
	}
}
