package com.jpattern.orm.query;

import java.util.List;

import com.jpattern.orm.NullOrmClassToolMap;
import com.jpattern.orm.exception.OrmException;

/**
 * 
 * @author Francesco Cina
 *
 * 08/lug/2011
 */
public abstract class ABaseOrmQuery extends AQuery implements IBaseOrmQuery {

	private IExpression whereExpression = new Expression();
	private OrderBy orderBy = new OrderBy();
	private IJoin join = new Join(new NullOrmClassToolMap());

	@Override
	public final IJoin join() throws OrmException {
		return join;
	}

	@Override
	public final IExpression where() throws OrmException {
		return whereExpression;
	}

	@Override
	public final IOrderBy orderBy() throws OrmException {
		return orderBy;
	}

	protected final void setWhere(IExpression whereExpression) {
		this.whereExpression = whereExpression;
	}

	protected final void setOrderBy(OrderBy orderBy) {
		this.orderBy = orderBy;
	}

	protected final void setJoin(IJoin join) {
		this.join = join;
	}
	
	@Override
	public final String renderSql() {
		StringBuilder StringBuilder = new StringBuilder();
		renderSql(StringBuilder);
		return StringBuilder.toString();
	}
	
	@Override
	public final void renderSql(StringBuilder StringBuilder) {
		renderSelect(StringBuilder);
		renderFrom(StringBuilder);
		renderWhere(StringBuilder);
		renderOrderBy(StringBuilder);
	}

	protected abstract void renderOrderBy(StringBuilder StringBuilder);

	protected abstract void renderWhere(StringBuilder StringBuilder);

	protected abstract void renderFrom(StringBuilder StringBuilder);

	protected abstract void renderSelect(StringBuilder StringBuilder);

	@Override
	public final void appendValues(List<Object> values) {
		where().appendValues(values);
	}
}
