package com.jpattern.orm.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import com.jpattern.orm.query.expression.AndExpressionElement;
import com.jpattern.orm.query.expression.EqExpressionElement;
import com.jpattern.orm.query.expression.EqPropertiesExpressionElement;
import com.jpattern.orm.query.expression.GeExpressionElement;
import com.jpattern.orm.query.expression.GePropertiesExpressionElement;
import com.jpattern.orm.query.expression.GtExpressionElement;
import com.jpattern.orm.query.expression.GtPropertiesExpressionElement;
import com.jpattern.orm.query.expression.IEqExpressionElement;
import com.jpattern.orm.query.expression.IEqPropertiesExpressionElement;
import com.jpattern.orm.query.expression.ILikeExpressionElement;
import com.jpattern.orm.query.expression.InExpressionElement;
import com.jpattern.orm.query.expression.InSubQueryExpressionElement;
import com.jpattern.orm.query.expression.IsNotNullExpressionElement;
import com.jpattern.orm.query.expression.IsNullExpressionElement;
import com.jpattern.orm.query.expression.LeExpressionElement;
import com.jpattern.orm.query.expression.LePropertiesExpressionElement;
import com.jpattern.orm.query.expression.LikeExpressionElement;
import com.jpattern.orm.query.expression.LtExpressionElement;
import com.jpattern.orm.query.expression.LtPropertiesExpressionElement;
import com.jpattern.orm.query.expression.NInExpressionElement;
import com.jpattern.orm.query.expression.NLikeExpressionElement;
import com.jpattern.orm.query.expression.NeExpressionElement;
import com.jpattern.orm.query.expression.NePropertiesExpressionElement;
import com.jpattern.orm.query.expression.NotExpressionElement;
import com.jpattern.orm.query.expression.OrExpressionElement;

/**
 * 
 * @author Francesco Cina
 *
 * 19/giu/2011
 */
public class Expression implements IExpression {

	List<IExpressionElement> elementList = new ArrayList<IExpressionElement>();
	private INameSolver nameSolver = new NullNameSolver();
	
	@Override
	public IExpression allEq(Map<String, Object> propertyMap) {
		for (Entry<String, Object> entry : propertyMap.entrySet()) {
			eq(entry.getKey(), entry.getValue());
		}
		return this;
	}

	@Override
	public IExpression eq(String property, Object value) {
		IExpressionElement expressionElement = new EqExpressionElement(property, value);
		expressionElement.setNameSolver(nameSolver);
		elementList.add(expressionElement);
		return this;
	}

	@Override
	public IExpression eqProperties(String firstProperty, String secondProperty) {
		IExpressionElement expressionElement = new EqPropertiesExpressionElement(firstProperty, secondProperty);
		expressionElement.setNameSolver(nameSolver);
		elementList.add(expressionElement);
		return this;
	}

	@Override
	public IExpression le(String property, Object value) {
		IExpressionElement expressionElement = new LeExpressionElement(property, value);
		expressionElement.setNameSolver(nameSolver);
		elementList.add(expressionElement);
		return this;
	}
	
	@Override
	public IExpression leProperties(String firstProperty, String secondProperty) {
		IExpressionElement expressionElement = new LePropertiesExpressionElement(firstProperty, secondProperty);
		expressionElement.setNameSolver(nameSolver);
		elementList.add(expressionElement);
		return this;
	}

	@Override
	public IExpression ge(String property, Object value) {
		IExpressionElement expressionElement = new GeExpressionElement(property, value);
		expressionElement.setNameSolver(nameSolver);
		elementList.add(expressionElement);
		return this;
	}
	
	@Override
	public IExpression geProperties(String firstProperty, String secondProperty) {
		IExpressionElement expressionElement = new GePropertiesExpressionElement(firstProperty, secondProperty);
		expressionElement.setNameSolver(nameSolver);
		elementList.add(expressionElement);
		return this;
	}

	@Override
	public IExpression lt(String property, Object value) {
		IExpressionElement expressionElement = new LtExpressionElement(property, value);
		expressionElement.setNameSolver(nameSolver);
		elementList.add(expressionElement);
		return this;
	}

	@Override
	public IExpression ltProperties(String firstProperty, String secondProperty) {
		IExpressionElement expressionElement = new LtPropertiesExpressionElement(firstProperty, secondProperty);
		expressionElement.setNameSolver(nameSolver);
		elementList.add(expressionElement);
		return this;
	}

	@Override
	public IExpression gt(String property, Object value) {
		IExpressionElement expressionElement = new GtExpressionElement(property, value);
		expressionElement.setNameSolver(nameSolver);
		elementList.add(expressionElement);
		return this;
	}
	
	@Override
	public IExpression gtProperties(String firstProperty, String secondProperty) {
		IExpressionElement expressionElement = new GtPropertiesExpressionElement(firstProperty, secondProperty);
		expressionElement.setNameSolver(nameSolver);
		elementList.add(expressionElement);
		return this;
	}

	@Override
	public IExpression ieq(String property, String value) {
		IExpressionElement expressionElement = new IEqExpressionElement(property, value);
		expressionElement.setNameSolver(nameSolver);
		elementList.add(expressionElement);
		return this;
	}

	@Override
	public IExpression ieqProperties(String firstProperty, String secondProperty) {
		IExpressionElement expressionElement = new IEqPropertiesExpressionElement(firstProperty, secondProperty);
		expressionElement.setNameSolver(nameSolver);
		elementList.add(expressionElement);
		return this;
	}
	
	@Override
	public IExpression ilike(String property, String value) {
		IExpressionElement expressionElement = new ILikeExpressionElement(property, value);
		expressionElement.setNameSolver(nameSolver);
		elementList.add(expressionElement);
		return this;
	}

	@Override
	public IExpression in(String property, Collection<?> values) {
		IExpressionElement expressionElement = new InExpressionElement(property, values);
		expressionElement.setNameSolver(nameSolver);
		elementList.add(expressionElement);
		return this;
	}

	@Override
	public IExpression in(String property, Object[] values) {
		return in(property, Arrays.asList( values ));
	}

	@Override
	public IExpression in(String property, IQuery subQuery) {
		IExpressionElement expressionElement = new InSubQueryExpressionElement(property, subQuery, true);
		expressionElement.setNameSolver(nameSolver);
		elementList.add(expressionElement);
		return this;
	}
	
	@Override
	public IExpression nin(String property, Collection<?> values) {
		IExpressionElement expressionElement = new NInExpressionElement(property, values);
		expressionElement.setNameSolver(nameSolver);
		elementList.add(expressionElement);
		return this;
	}

	@Override
	public IExpression nin(String property, Object[] values) {
		return nin(property, Arrays.asList( values ));
	}

	@Override
	public IExpression nin(String property, IQuery subQuery) {
		IExpressionElement expressionElement = new InSubQueryExpressionElement(property, subQuery, false);
		expressionElement.setNameSolver(nameSolver);
		elementList.add(expressionElement);
		return this;
	}

	@Override
	public IExpression isNotNull(String property) {
		IExpressionElement expressionElement = new IsNotNullExpressionElement(property);
		expressionElement.setNameSolver(nameSolver);
		elementList.add(expressionElement);
		return this;
	}

	@Override
	public IExpression isNull(String property) {
		IExpressionElement expressionElement = new IsNullExpressionElement(property);
		expressionElement.setNameSolver(nameSolver);
		elementList.add(expressionElement);
		return this;
	}

	@Override
	public IExpression like(String property, String value) {
		IExpressionElement expressionElement = new LikeExpressionElement(property, value);
		expressionElement.setNameSolver(nameSolver);
		elementList.add(expressionElement);
		return this;
	}

	@Override
	public IExpression nlike(String property, String value) {
		IExpressionElement expressionElement = new NLikeExpressionElement(property, value);
		expressionElement.setNameSolver(nameSolver);
		elementList.add(expressionElement);
		return this;
	}
	
	@Override
	public IExpression ne(String property, Object value) {
		IExpressionElement expressionElement = new NeExpressionElement(property, value);
		expressionElement.setNameSolver(nameSolver);
		elementList.add(expressionElement);
		return this;
	}
	
	@Override
	public IExpression neProperties(String firstProperty, String secondProperty) {
		IExpressionElement expressionElement = new NePropertiesExpressionElement(firstProperty, secondProperty);
		expressionElement.setNameSolver(nameSolver);
		elementList.add(expressionElement);
		return this;
	}

	@Override
	public IExpression not(IExpressionElement expression) {
		IExpressionElement expressionElement = new NotExpressionElement(expression);
		expressionElement.setNameSolver(nameSolver);
		elementList.add(expressionElement);
		return this;
	}

	@Override
	public IExpression or(IExpressionElement expressionOne, IExpressionElement expressionTwo) {
		IExpressionElement expressionElement = new OrExpressionElement(expressionOne, expressionTwo);
		expressionElement.setNameSolver(nameSolver);
		elementList.add(expressionElement);
		return this;
	}

	@Override
	public IExpression and(IExpressionElement expressionOne, IExpressionElement expressionTwo) {
		IExpressionElement expressionElement = new AndExpressionElement(expressionOne, expressionTwo);
		expressionElement.setNameSolver(nameSolver);
		elementList.add(expressionElement);
		return this;
	}
	
	@Override
	public void setNameSolver(INameSolver nameSolver) {
		this.nameSolver = nameSolver;
	}

	@Override
	public String renderSql() {
		StringBuilder StringBuilder = new StringBuilder();
		renderSql(StringBuilder);
		return StringBuilder.toString();
	}

	@Override
	public void renderSql(StringBuilder StringBuilder) {
		boolean first = true;
		if (!elementList.isEmpty()) {
			StringBuilder.append("WHERE ");
			for (IExpressionElement expressionElement : elementList) {
				if (!first) {
					StringBuilder.append("AND ");
				}
				expressionElement.renderSql(StringBuilder);
				first = false;
			}
		}
	}

	@Override
	public void appendValues(List<Object> values) {
		if (!elementList.isEmpty()) {
			for (IExpressionElement expressionElement : elementList) {
				expressionElement.appendValues(values);
			}
		}
	}

}
