package com.jpattern.orm.query;

import com.jpattern.orm.exception.OrmException;

/**
 * 
 * @author Francesco Cina
 *
 * 08/lug/2011
 */
public interface IBaseOrmQuery extends IQuery {

	/**
	 * Add join tables to the from clause. 
	 * @return
	 */
	public abstract IJoin join() throws OrmException;

	/**
	 * Set the where clause.
	 * @return
	 */
	public abstract IExpression where() throws OrmException;

	/**
	 * Set the order by clause.
	 * @return
	 */
	public abstract IOrderBy orderBy() throws OrmException;
	
}
