package com.jpattern.orm.query;

import java.math.BigDecimal;
import java.util.List;

import com.jpattern.orm.exception.OrmException;
import com.jpattern.orm.exception.OrmNotUniqueResultException;
import com.jpattern.orm.session.IResultSetReader;

/**
 * 
 * @author Francesco Cina
 *
 * 09/lug/2011
 */
public interface ICustomQuery {
	
	/**
	 * Execute the query reading the ResultSet with a
	 * IResultSetReader.
	 * @param rse object that will extract all rows of results
	 * @return an arbitrary result object, as returned by the IResultSetExtractor
	 */
	<T> T find(IResultSetReader<T> rse) throws OrmException;
	
	/**
	 * Execute the query and read the result creating a List of all the ordered arrays with the extracted column values for every row.
	 * @return
	 */
	List<Object[]> findList() throws OrmException;
	
	/**
	 * Execute the query and read the result creating an ordered array with the extracted column values or null (if no matching bean is found).
	 * @return
	 * @throws OrmNotUniqueResultException if more than one row is returned from the query
	 */
	Object[] findUnique() throws OrmNotUniqueResultException;
	
	/**
	 * Execute the query and read the result as an int value
	 * @param sql SQL query to execute
	 * @param args arguments to bind to the query
	 * @return 
	 */
	int findInt() throws OrmException;
	
	/**
	 * Execute the query and read the result as an long value
	 * @param sql SQL query to execute
	 * @param args arguments to bind to the query
	 * @return 
	 */
	long findLong() throws OrmException;

	/**
	 * Execute the query and read the result as a double value
	 * @param sql SQL query to execute
	 * @param args arguments to bind to the query
	 * @return 
	 */
	double findDouble() throws OrmException;
	
	/**
	 * Execute the query and read the result as a float value
	 * @param sql SQL query to execute
	 * @param args arguments to bind to the query
	 * @return 
	 */
	float findFloat() throws OrmException;
	
	/**
	 * Execute the wuery and read the result as a String value
	 * @param sql SQL query to execute
	 * @param args arguments to bind to the query
	 * @return 
	 */
	String findString() throws OrmException;

	/**
	 * Execute the query and read the result as a boolean value
	 * @param sql SQL query to execute
	 * @param args arguments to bind to the query
	 * @return 
	 */
	boolean findBoolean() throws OrmException;

	/**
	 * Execute the query and read the result as a BigDecimal value
	 * @param sql SQL query to execute
	 * @param args arguments to bind to the query
	 * @return 
	 */
	BigDecimal findBigDecimal() throws OrmException;
	
}
