package com.jpattern.orm.query;

import java.util.List;

import com.jpattern.orm.exception.OrmException;
import com.jpattern.orm.exception.OrmNotUniqueResultException;

/**
 * 
 * @author Francesco Cina
 *
 * 18/giu/2011
 */
public interface IOrmQuery<T> extends IBaseOrmQuery {

	/**
	 * Execute the query returning the list of objects.
	 * @return
	 */
	List<T> findList() throws OrmException;
	
	/**
	 * Return the count of entities this query should return.
	 * @return
	 */
	long findRowCount() throws OrmException;
    
	/**
	 * Execute the query returning either a single bean or null (if no matching bean is found).
	 * @return 
	 * @throws OrmNotUniqueResultException if more than one row is returned from the query
	 */
	T findUnique() throws OrmException, OrmNotUniqueResultException;
    
	/**
	 * Execute the query and for every object created call the IOrmSerialResultReader.
	 * The objects are created one after the other to avoid the use of too much memory.
	 * @param srr
	 * @throws OrmException
	 */
	void find(IOrmSerialResultReader<T> srr) throws OrmException; 
	
	
	/**
	 * Return the sql that was generated for to return the row count of the execution of this query.
	 * @return
	 */
	String getGeneratedRowCountSql() throws OrmException;
	
	/**
	 * use Distinct in the select clause
	 * @return
	 */
	IOrmQuery<T> setDistinct() throws OrmException;    
	
	/**
	 * return if use Distinct in the select clause
	 * @return
	 */
	boolean isDistinct() throws OrmException;  
	
	/**
	 * Set the maximum number of rows to return in the query.
	 * @param maxRows
	 * @return
	 */
	IOrmQuery<T> setMaxRows(int maxRows) throws OrmException;
	
	/**
	 * Set the query timeout for the query.
	 */
	IOrmQuery<T> setQueryTimeout(int queryTimeout);

}
