package com.jpattern.orm.query;

import java.util.List;

import com.jpattern.orm.exception.OrmException;

/**
 * 
 * @author Francesco Cina
 *
 * 07/lug/2011
 */
public interface IQuery extends IRenderableSqlObject {

	/**
	 * Return the max rows for this query.
	 * @return
	 */
	int getMaxRows() throws OrmException;

	/**
	 * Set the maximum number of rows to return in the query.
	 * @param maxRows
	 * @return
	 */
	IQuery setMaxRows(int maxRows) throws OrmException;
	
	/**
	 * Set the query timeout for the query.
	 */
	IQuery setQueryTimeout(int queryTimeout);

	/**
	 * Return the query timeout for the query.
	 */
	int getQueryTimeout();

	/**
	 * Append to the list all the values of the expression's elements
	 * @return
	 */
	void appendValues(List<Object> values);

}