package com.jpattern.orm.query;

import java.util.ArrayList;
import java.util.List;

import com.jpattern.orm.IOrmClassToolMap;
import com.jpattern.orm.query.join.CrossJoinElement;
import com.jpattern.orm.query.join.FullOuterJoinElement;
import com.jpattern.orm.query.join.IJoinElement;
import com.jpattern.orm.query.join.InnerJoinElement;
import com.jpattern.orm.query.join.LeftOuterJoinElement;
import com.jpattern.orm.query.join.NaturalJoinElement;
import com.jpattern.orm.query.join.RightOuterJoinElement;

/**
 * 
 * @author Francesco Cina
 *
 * 27/giu/2011
 */
public class Join implements IJoin {
	
	private INameSolver nameSolver = new NullNameSolver();
	private List<IJoinElement> joinElements = new ArrayList<IJoinElement>();
	private final IOrmClassToolMap ormClassToolMap;

	public Join (IOrmClassToolMap ormClassToolMap) {
		this.ormClassToolMap = ormClassToolMap;
	}
	
	@Override
	public IJoin cross(Class<?> joinClass) {
		return cross(joinClass, joinClass.getSimpleName());
	}

	@Override
	public IJoin cross(Class<?> joinClass, String joinClassAlias) {
		IJoinElement joinElement = new CrossJoinElement(ormClassToolMap, joinClass);
		nameSolver.register(joinClass, joinClassAlias);
		joinElement.setNameSolver(nameSolver);
		joinElements.add(joinElement);
		return this;
	}
	
	@Override
	public IJoin natural(Class<?> joinClass) {
		return natural(joinClass, joinClass.getSimpleName());
	}

	@Override
	public IJoin natural(Class<?> joinClass, String joinClassAlias) {
		IJoinElement joinElement = new NaturalJoinElement(ormClassToolMap, joinClass);
		nameSolver.register(joinClass, joinClassAlias);
		joinElement.setNameSolver(nameSolver);
		joinElements.add(joinElement);
		return this;
	}

	@Override
	public IJoin inner(Class<?> joinClass) {
		return inner(joinClass, joinClass.getSimpleName());
	}

	@Override
	public IJoin inner(Class<?> joinClass, String joinClassAlias) {
		IJoinElement joinElement = new InnerJoinElement(ormClassToolMap, joinClass);
		nameSolver.register(joinClass, joinClassAlias);
		joinElement.setNameSolver(nameSolver);
		joinElements.add(joinElement);
		return this;
	}
	
	@Override
	public IJoin inner(Class<?> joinClass, String onLeftProperty, String onRigthProperty) {
		return inner(joinClass, joinClass.getSimpleName(), onLeftProperty, onRigthProperty);
	}

	@Override
	public IJoin inner(Class<?> joinClass, String joinClassAlias, String onLeftProperty, String onRigthProperty) {
		IJoinElement joinElement = new InnerJoinElement(ormClassToolMap, joinClass, onLeftProperty, onRigthProperty);
		nameSolver.register(joinClass, joinClassAlias);
		joinElement.setNameSolver(nameSolver);
		joinElements.add(joinElement);
		return this;
	}

	@Override
	public IJoin leftOuter(Class<?> joinClass) {
		return leftOuter(joinClass, joinClass.getSimpleName());
	}

	@Override
	public IJoin leftOuter(Class<?> joinClass, String joinClassAlias) {
		IJoinElement joinElement = new LeftOuterJoinElement(ormClassToolMap, joinClass);
		nameSolver.register(joinClass, joinClassAlias);
		joinElement.setNameSolver(nameSolver);
		joinElements.add(joinElement);
		return this;
	}

	@Override
	public IJoin leftOuter(Class<?> joinClass, String onLeftProperty, String onRigthProperty) {
		return leftOuter(joinClass, joinClass.getSimpleName(), onLeftProperty, onRigthProperty);
	}

	@Override
	public IJoin leftOuter(Class<?> joinClass, String joinClassAlias, String onLeftProperty, String onRigthProperty) {
		IJoinElement joinElement = new LeftOuterJoinElement(ormClassToolMap, joinClass, onLeftProperty, onRigthProperty);
		nameSolver.register(joinClass, joinClassAlias);
		joinElement.setNameSolver(nameSolver);
		joinElements.add(joinElement);
		return this;
	}

	@Override
	public IJoin rightOuter(Class<?> joinClass) {
		return rightOuter(joinClass, joinClass.getSimpleName());
	}

	@Override
	public IJoin rightOuter(Class<?> joinClass, String joinClassAlias) {
		IJoinElement joinElement = new RightOuterJoinElement(ormClassToolMap, joinClass);
		nameSolver.register(joinClass, joinClassAlias);
		joinElement.setNameSolver(nameSolver);
		joinElements.add(joinElement);
		return this;
	}

	@Override
	public IJoin rightOuter(Class<?> joinClass, String onLeftProperty, String onRigthProperty) {
		return rightOuter(joinClass, joinClass.getSimpleName(), onLeftProperty, onRigthProperty);
	}

	@Override
	public IJoin rightOuter(Class<?> joinClass, String joinClassAlias, String onLeftProperty, String onRigthProperty) {
		IJoinElement joinElement = new RightOuterJoinElement(ormClassToolMap, joinClass, onLeftProperty, onRigthProperty);
		nameSolver.register(joinClass, joinClassAlias);
		joinElement.setNameSolver(nameSolver);
		joinElements.add(joinElement);
		return this;
	}

	@Override
	public IJoin fullOuter(Class<?> joinClass) {
		return fullOuter(joinClass, joinClass.getSimpleName());
	}

	@Override
	public IJoin fullOuter(Class<?> joinClass, String joinClassAlias) {
		IJoinElement joinElement = new FullOuterJoinElement(ormClassToolMap, joinClass);
		nameSolver.register(joinClass, joinClassAlias);
		joinElement.setNameSolver(nameSolver);
		joinElements.add(joinElement);
		return this;
	}

	@Override
	public IJoin fullOuter(Class<?> joinClass, String onLeftProperty, String onRigthProperty) {
		return fullOuter(joinClass, joinClass.getSimpleName(), onLeftProperty, onRigthProperty);
	}

	@Override
	public IJoin fullOuter(Class<?> joinClass, String joinClassAlias, String onLeftProperty, String onRigthProperty) {
		IJoinElement joinElement = new FullOuterJoinElement(ormClassToolMap, joinClass, onLeftProperty, onRigthProperty);
		nameSolver.register(joinClass, joinClassAlias);
		joinElement.setNameSolver(nameSolver);
		joinElements.add(joinElement);
		return this;
	}

	@Override
	public void setNameSolver(INameSolver nameSolver) {
		this.nameSolver = nameSolver;
	}

	@Override
	public String renderSql() {
		StringBuilder query = new StringBuilder();
		renderSql(query);
		return query.toString();
	}

	@Override
	public void renderSql(StringBuilder StringBuilder) {
		for (IJoinElement joinElement : joinElements) {
			joinElement.renderSql(StringBuilder);
		}
	}

}
