package com.jpattern.orm.query;

import java.util.ArrayList;
import java.util.List;

import com.jpattern.orm.query.order.OrderByType;
import com.jpattern.orm.query.order.OrderElement;

/**
 * 
 * @author Francesco Cina
 *
 * 24/giu/2011
 */
public class OrderBy implements IOrderBy {

	private INameSolver nameSolver = new NullNameSolver();
	private List<IOrderElement> elementList = new ArrayList<IOrderElement>();

	@Override
	public IOrderBy asc(String property) {
		elementList.add(new OrderElement(nameSolver, property, elementList.isEmpty(), OrderByType.ASC));
		return this;
	}

	@Override
	public IOrderBy desc(String property) {
		elementList.add(new OrderElement(nameSolver, property, elementList.isEmpty(), OrderByType.DESC));
		return this;
	}

	@Override
	public String renderSql() {
		StringBuilder query = new StringBuilder();
		renderSql(query);
		return query.toString();
	}

	@Override
	public void renderSql(StringBuilder StringBuilder) {
		if (!elementList.isEmpty()) {
			StringBuilder.append("ORDER BY ");
			for (IOrderElement expressionElement : elementList) {
				expressionElement.renderSql(StringBuilder);
			}
		}
	}

	@Override
	public void setNameSolver(INameSolver nameSolver) {
		this.nameSolver  = nameSolver;
	}

}
