package com.jpattern.orm.query;

import java.util.ArrayList;
import java.util.List;

import com.jpattern.orm.IOrmClassToolMap;
import com.jpattern.orm.session.ISessionSqlPerformer;
import com.jpattern.orm.session.ISqlPerformer;

/**
 * 
 * @author Francesco Cina
 *
 * 10/lug/2011
 */
public class OrmDelete implements IDelete, INameSolverConsumer {

	private IExpression whereExpression = new Expression();
	private final IOrmClassToolMap ormClassToolMap;
	private final ISessionSqlPerformer session;
//	private INameSolver nameSolver = new NullNameSolver();
	private int queryTimeout = 0;
	private final Class<?> clazz;

	public OrmDelete(Class<?> clazz, IOrmClassToolMap ormClassToolMap, ISessionSqlPerformer session) {
		this.clazz = clazz;
		this.ormClassToolMap = ormClassToolMap;
		this.session = session;
	}

	@Override
	public IExpression where() {
		return whereExpression;
	}

	@Override
	public int perform() {
		List<Object> values = new ArrayList<Object>();
		appendValues(values);
		ISqlPerformer sqlExec = session.sqlPerformer();
		sqlExec.setQueryTimeout(getQueryTimeout());
		return sqlExec.update(renderSql(), values.toArray());
	}

	@Override
	public void appendValues(List<Object> values) {
		whereExpression.appendValues(values);		
	}

	@Override
	public IDelete setQueryTimeout(int queryTimeout) {
		this.queryTimeout = queryTimeout;
		return this;
	}

	@Override
	public int getQueryTimeout() {
		return queryTimeout;
	}

	@Override
	public void setNameSolver(INameSolver nameSolver) {
//		this.nameSolver = nameSolver;
		whereExpression.setNameSolver(nameSolver);
	}

	@Override
	public String renderSql() {
		StringBuilder StringBuilder = new StringBuilder();
		renderSql(StringBuilder);
		return StringBuilder.toString();
	}

	@Override
	public void renderSql(StringBuilder StringBuilder) {
		StringBuilder.append("DELETE FROM ");
		StringBuilder.append(ormClassToolMap.getOrmClassTool(clazz).getClassMapper().getTableMap().getTableNameWithSchema() );
		StringBuilder.append(" ");
		where().renderSql(StringBuilder);
	}

}
