package com.jpattern.orm.query;

import java.util.ArrayList;
import java.util.List;

import com.jpattern.orm.IOrmClassToolMap;
import com.jpattern.orm.session.ISessionSqlPerformer;
import com.jpattern.orm.session.ISqlPerformer;

/**
 * 
 * @author Francesco Cina
 *
 * 10/lug/2011
 */
public class OrmUpdate implements IUpdate, INameSolverConsumer {

	private ISetClause set = new SetClause();
	private IExpression whereExpression = new Expression();
//	private INameSolver nameSolver = new NullNameSolver();
	private int queryTimeout = 0;
	private final Class<?> clazz;
	private final IOrmClassToolMap ormClassToolMap;
	private final ISessionSqlPerformer session;

	public OrmUpdate(Class<?> clazz, IOrmClassToolMap ormClassToolMap, ISessionSqlPerformer session) {
		this.clazz = clazz;
		this.ormClassToolMap = ormClassToolMap;
		this.session = session;
	}
	
	@Override
	public IExpression where() {
		return whereExpression;
	}

	@Override
	public int perform() {
		List<Object> values = new ArrayList<Object>();
		appendValues(values);
		ISqlPerformer sqlExec = session.sqlPerformer();
		sqlExec.setQueryTimeout(getQueryTimeout());
		return sqlExec.update(renderSql(), values.toArray());
	}

	@Override
	public void appendValues(List<Object> values) {
		set.appendValues(values);
		whereExpression.appendValues(values);		
	}

	@Override
	public IUpdate setQueryTimeout(int queryTimeout) {
		this.queryTimeout = queryTimeout;
		return this;
	}

	@Override
	public int getQueryTimeout() {
		return queryTimeout;
	}

	@Override
	public void setNameSolver(INameSolver nameSolver) {
//		this.nameSolver = nameSolver;
		whereExpression.setNameSolver(nameSolver);
		set.setNameSolver(nameSolver);
	}

	@Override
	public String renderSql() {
		StringBuilder StringBuilder = new StringBuilder();
		renderSql(StringBuilder);
		return StringBuilder.toString();
	}

	@Override
	public void renderSql(StringBuilder StringBuilder) {
		StringBuilder.append("UPDATE ");
		StringBuilder.append(ormClassToolMap.getOrmClassTool(clazz).getClassMapper().getTableMap().getTableNameWithSchema() );
		StringBuilder.append(" ");
		set().renderSql(StringBuilder);
		where().renderSql(StringBuilder);
	}

	@Override
	public ISetClause set() {
		return set;
	}

}
