package com.jpattern.orm.query;

import java.util.ArrayList;
import java.util.List;

import com.jpattern.orm.query.expression.EqExpressionElement;

/**
 * 
 * @author Francesco Cina
 *
 * 10/lug/2011
 */
public class SetClause implements ISetClause {

	List<IExpressionElement> elementList = new ArrayList<IExpressionElement>();
	private INameSolver nameSolver = new NullNameSolver();
	
	@Override
	public ISetClause eq(String property, Object value) {
		IExpressionElement expressionElement = new EqExpressionElement(property, value);
		expressionElement.setNameSolver(nameSolver);
		elementList.add(expressionElement);
		return this;
	}

	@Override
	public String renderSql() {
		StringBuilder StringBuilder = new StringBuilder();
		renderSql(StringBuilder);
		return StringBuilder.toString();
	}

	@Override
	public void renderSql(StringBuilder StringBuilder) {
		boolean first = true;
		if (!elementList.isEmpty()) {
			StringBuilder.append("SET ");
			for (IExpressionElement expressionElement : elementList) {
				if (!first) {
					StringBuilder.append(", ");
				}
				expressionElement.renderSql(StringBuilder);
				first = false;
			}
		}
	}

	@Override
	public void appendValues(List<Object> values) {
		if (!elementList.isEmpty()) {
			for (IExpressionElement expressionElement : elementList) {
				expressionElement.appendValues(values);
			}
		}
	}
	
	@Override
	public void setNameSolver(INameSolver nameSolver) {
		this.nameSolver = nameSolver;
	}
}
