package com.jpattern.orm.query.expression;

import java.util.Collection;
import java.util.List;

import com.jpattern.orm.exception.OrmQueryFormatException;
import com.jpattern.orm.query.IExpressionElement;
import com.jpattern.orm.query.INameSolver;
import com.jpattern.orm.query.NullNameSolver;

/**
 * 
 * @author Francesco Cina
 *
 * 19/giu/2011
 */
public abstract class AExpressionElement implements IExpressionElement {

	private String property;
	private Object value;
	private Collection<?> values;
	private INameSolver nameSolver = new NullNameSolver();
	
	
	public void setNameSolver(INameSolver nameSolver) {
		this.nameSolver = nameSolver;
	}

	private IPropertyDecorator propertyDecorator = new NullPropertyDecorator();
	private IPropertyDecorator valueDecorator = new NullPropertyDecorator();
	
	public final boolean hasValue() {
		return (value!=null);
	}

	public final boolean hasValues() {
		return (values!=null && values.size()>0);
	}

	public Object getValue() {
		return value;
	}

	public void setValue(Object value) {
		this.value = value;
	}

	public Collection<?> getValues() {
		return values;
	}

	public void setValues(Collection<?> values) {
		this.values = values;
	}

	public final String getProperty() {
		return property;
	}

	public void setProperty(String property) {
		this.property = property;
	}
	
	protected INameSolver nameSolver() {
		return nameSolver;
	}

	protected IPropertyDecorator getPropertyDecorator() {
		return propertyDecorator;
	}

	protected void setPropertyDecorator(IPropertyDecorator propertyDecorator) {
		this.propertyDecorator = propertyDecorator;
	}

	protected IPropertyDecorator getValueDecorator() {
		return valueDecorator;
	}

	protected void setValueDecorator(IPropertyDecorator valueDecorator) {
		this.valueDecorator = valueDecorator;
	}
	
	@Override
	public void renderSql(StringBuilder query) throws OrmQueryFormatException {
		query.append( getPropertyDecorator().decore( nameSolver().solvePropertyName(getProperty()) ) );
		query.append( " " );
		query.append( getExpressionElementKey() );
		query.append( " " );
		appendQuestionMarks(query);
	}

	private void appendQuestionMarks(StringBuilder query) {
		if (hasValue()) {
			query.append( getValueDecorator().decore("?") + " " );
			return;
		}
		if (hasValues()) {
			query.append( "( ");
			for (int i=0; i<getValues().size()-1; i++) {
				query.append( getValueDecorator().decore("?") + ", " );
			}
			query.append( getValueDecorator().decore("?") + " ) ");
		}
	}

	@Override
	public String renderSql() throws OrmQueryFormatException {
		StringBuilder query = new StringBuilder();
		renderSql(query);
		return query.toString();		
	}

	public abstract String getExpressionElementKey();
	
	
	public void appendValues(List<Object> values) {
		if (hasValue()) {
			values.add(value);
		}
		if (hasValues()) {
			values.addAll( this.values );
		}
	}
}
