package com.jpattern.orm.query.expression;

import java.util.List;

import com.jpattern.orm.query.IExpressionElement;
import com.jpattern.orm.query.INameSolver;
import com.jpattern.orm.query.IQuery;

/**
 * 
 * @author Francesco Cina
 *
 * 26/giu/2011
 */
public class InSubQueryExpressionElement implements IExpressionElement {

	private final IQuery query;
	private INameSolver nameSolver;
	private final String property;
	private final boolean in;

	public InSubQueryExpressionElement(String property, IQuery query, boolean in) {
		this.property = property;
		this.query = query;
		this.in = in;
	}

	@Override
	public String renderSql() {
		StringBuilder StringBuilder = new StringBuilder();
		renderSql(StringBuilder);
		return StringBuilder.toString();
	}

	@Override
	public void renderSql(StringBuilder StringBuilder) {
		StringBuilder.append(  nameSolver.solvePropertyName( property ) );
		if (in) {
			StringBuilder.append( " IN ( ");
		} else {
			StringBuilder.append( " NOT IN ( ");
		}
		query.renderSql(StringBuilder);
		StringBuilder.append(") ");
	}

	@Override
	public void setNameSolver(INameSolver nameSolver) {
		this.nameSolver = nameSolver;
	}

	@Override
	public void appendValues(List<Object> values) {
		query.appendValues(values);
	}

}