package com.jpattern.orm.query.expression;

import java.util.List;

import com.jpattern.orm.query.IExpressionElement;
import com.jpattern.orm.query.INameSolver;

/**
 * 
 * @author Francesco Cina
 *
 * 26/giu/2011
 */
public class NotExpressionElement implements IExpressionElement {

	
	
	protected final IExpressionElement expression;

	public NotExpressionElement(IExpressionElement expression) {
		this.expression = expression;
	}

	@Override
	public String renderSql() {
		StringBuilder StringBuilder = new StringBuilder();
		renderSql(StringBuilder);
		return StringBuilder.toString();
	}

	@Override
	public void renderSql(StringBuilder StringBuilder) {
		StringBuilder.append("NOT ( ");
		expression.renderSql(StringBuilder);
		StringBuilder.append(") ");
	}

	@Override
	public void setNameSolver(INameSolver nameSolver) {
		expression.setNameSolver(nameSolver);
	}

	@Override
	public void appendValues(List<Object> values) {
		expression.appendValues(values);
	}

}