package com.jpattern.orm.query.join;

import com.jpattern.orm.IOrmClassToolMap;
import com.jpattern.orm.query.INameSolver;

/**
 * 
 * @author Francesco Cina
 *
 * 27/giu/2011
 */
public abstract class AJoinElement implements IJoinElement {

	protected final Class<?> joinClass;
	private INameSolver nameSolver;
	protected final IOrmClassToolMap ormClassToolMap;

	public AJoinElement(IOrmClassToolMap ormClassToolMap, Class<?> joinClass) {
		this.ormClassToolMap = ormClassToolMap;
		this.joinClass = joinClass;
	}

	@Override
	public void setNameSolver(INameSolver nameSolver) {
		this.nameSolver = nameSolver;
	}

	@Override
	public String renderSql() {
		StringBuilder query = new StringBuilder();
		renderSql(query);
		return query.toString();
	}

	@Override
	public void renderSql(StringBuilder StringBuilder) {
		String alias = nameSolver.alias(joinClass); 
		StringBuilder.append( getJoinName() );
		StringBuilder.append(ormClassToolMap.getOrmClassTool(joinClass).getClassMapper().getTableMap().getTableNameWithSchema() );
		StringBuilder.append( " " );
		StringBuilder.append(alias);
		
		if (hasOnClause()) {
			StringBuilder.append( " ON " );
			StringBuilder.append( nameSolver.solvePropertyName(onLeftProperty()) );
			StringBuilder.append( " = " );
			StringBuilder.append( nameSolver.solvePropertyName(onRightProperty()) );
		}
		
		StringBuilder.append( " " );
	}
	
	protected abstract String getJoinName();
	
	protected abstract boolean hasOnClause();
	
	protected abstract String onLeftProperty();
	
	protected abstract String onRightProperty();

}