package com.jpattern.orm.query.join;

import com.jpattern.orm.IOrmClassToolMap;

/**
 * 
 * @author Francesco Cina
 *
 * 27/giu/2011
 */
public class RightOuterJoinElement extends AJoinElement {

	private final String onLeftProperty;
	private final String onRigthProperty;
	private boolean onClause = true;

	public RightOuterJoinElement(IOrmClassToolMap ormClassToolMap, Class<?> joinClass) {
		this(ormClassToolMap, joinClass, "", "");
		onClause = false;
	}
	
	public RightOuterJoinElement(IOrmClassToolMap ormClassToolMap, Class<?> joinClass, String onLeftProperty, String onRigthProperty) {
		super(ormClassToolMap, joinClass);
		this.onLeftProperty = onLeftProperty;
		this.onRigthProperty = onRigthProperty;
	}

	@Override
	protected String getJoinName() {
		return "RIGHT OUTER JOIN ";
	}

	@Override
	protected boolean hasOnClause() {
		return onClause ;
	}

	@Override
	protected String onLeftProperty() {
		return onLeftProperty;
	}

	@Override
	protected String onRightProperty() {
		return onRigthProperty;
	}
	
}
