package com.jpattern.orm.query.order;

import com.jpattern.orm.query.INameSolver;
import com.jpattern.orm.query.IOrderElement;

/**
 * 
 * @author Francesco Cina
 *
 * 24/giu/2011
 */
public class OrderElement implements IOrderElement {

	private final INameSolver nameSolver;
	private final boolean isFirstElement;
	private final OrderByType type;
	private final String property;

	public OrderElement(INameSolver nameSolver, String property, boolean isFirstElement, OrderByType type) {
		this.nameSolver = nameSolver;
		this.property = property;
		this.isFirstElement = isFirstElement;
		this.type = type;
	}
	
	@Override
	public String renderSql() {
		StringBuilder query = new StringBuilder();
		renderSql(query);
		return query.toString();
	}

	@Override
	public void renderSql(StringBuilder StringBuilder) {
		if (!isFirstElement) {
			StringBuilder.append( ", " );
		}
		StringBuilder.append( nameSolver.solvePropertyName(property) );
		StringBuilder.append( " " );
		StringBuilder.append( type.getType() );
		StringBuilder.append( " " );
	}

}
