package com.jpattern.orm.query.sql;

import com.jpattern.orm.query.ISqlUpdate;
import com.jpattern.orm.session.IGeneratedKeyReader;
import com.jpattern.orm.session.ISessionSqlPerformer;
import com.jpattern.orm.session.ISqlPerformer;

/**
 * 
 * @author Francesco Cina
 *
 * 09/lug/2011
 */
public class SqlUpdateGKReader implements ISqlUpdate {

	private int queryTimeout = 0;
	private final ISessionSqlPerformer session;
	private final String sql;
	private final IGeneratedKeyReader generatedKeyReader;
	private final Object[] args;

	public SqlUpdateGKReader(ISessionSqlPerformer session, String sql, IGeneratedKeyReader generatedKeyReader, Object[] args) {
		this.session = session;
		this.sql = sql;
		this.generatedKeyReader = generatedKeyReader;
		this.args = args;
	}

	@Override
	public void execute() {
		perform();
	}

	@Override
	public void setQueryTimeout(int queryTimeout) {
		this.queryTimeout  = queryTimeout;
	}

	@Override
	public int getQueryTimeout() {
		return queryTimeout;
	}

	@Override
	public int perform() {
		ISqlPerformer sqlExec = session.sqlPerformer();
		sqlExec.setQueryTimeout(getQueryTimeout());
		return sqlExec.update(sql , generatedKeyReader, args);
	}

}
