package com.jpattern.orm.script;

import java.io.IOException;

/**
 * 
 * @author Francesco Cina
 *
 * 01/lug/2011
 */
public interface IParser {

	/**
	 * Parse the script using the default symbol ";" to identify the sql statements
	 * @param parserCallback
	 * @throws IOException
	 */
	void parse( IParserCallback parserCallback ) throws IOException;

	/**
	 * Parse the script using a custom symbol to identify the sql statements
	 * @param parserCallback
	 * @param spearatorSymbol a custom separator symbol
	 * @throws IOException
	 */
	void parse(IParserCallback parserCallback, String spearatorSymbol) throws IOException;
	
}
