package com.jpattern.orm.script;

import com.jpattern.logger.ILogger;
import com.jpattern.orm.logger.OrmLogger;
import com.jpattern.orm.session.ISession;
import com.jpattern.orm.session.ISessionSqlPerformer;
import com.jpattern.orm.session.ISqlPerformer;
import com.jpattern.orm.session.ITransaction;

/**
 * 
 * @author Francesco Cina
 *
 * 02/lug/2011
 */
public class SessionParserCallback implements IParserCallback {

	private final ISession session;
	private int parseCount = 0;
	private ITransaction tx;
	private boolean committed = false;
	private final ISqlPerformer sqlExec;
	private final int commitEveryStatements;
	private final ILogger logger;

	public SessionParserCallback(ISessionSqlPerformer session, int commitEveryStatements) {
		this.session = session;
		this.commitEveryStatements = commitEveryStatements;
		logger = OrmLogger.getOrmLogger(getClass());
		sqlExec = session.sqlPerformer();
		open();
	}

	void open() {
		commit();
		logger.debug("open", "Start new Transaction");
		tx = session.beginTransaction();
		committed = false;
	}
	
	@Override
	public void parseAction(String sqlStatement) {
		logger.trace("parseAction", "Execute statement " + parseCount + ": " + sqlStatement);
		sqlExec.update(sqlStatement);
		parseCount++;
		
		if (parseCount >= commitEveryStatements) {
			commit();
			open();
		}
		
	}
	
	void commit() {
		if (tx != null && !committed) {
			logger.debug("open", "Commit Transaction");
			tx.commit();
			committed = true;
		}
	}
	
}
